/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.gradle.javacpp;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.bytedeco.gradle.javacpp.BuildExtension;
import org.bytedeco.gradle.javacpp.BuildTask;
import org.bytedeco.javacpp.Loader;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.WriteProperties;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;

public class BuildPlugin
implements Plugin<Project> {
    Project project;

    String getPlatform() {
        return (String)this.project.findProperty("javacppPlatform");
    }

    String getPlatformExtension() {
        return (String)this.project.findProperty("javacppPlatformExtension");
    }

    boolean isLibraryPath(String path) {
        String p = (String)this.project.findProperty("javacpp.platform.library.path");
        return p != null && p.length() > 0 ? path.startsWith(p) : path.contains("/" + this.getPlatform() + this.getPlatformExtension() + "/");
    }

    public void apply(Project project) {
        this.project = project;
        if (!project.hasProperty("javacppPlatform")) {
            project.getExtensions().getExtraProperties().set("javacppPlatform", (Object)Loader.Detector.getPlatform());
        }
        if (!project.hasProperty("javacppPlatformExtension")) {
            project.getExtensions().getExtraProperties().set("javacppPlatformExtension", (Object)"");
        }
        if (project.getExtensions().findByName("javacppBuild") == null) {
            project.getExtensions().create("javacppBuild", BuildExtension.class, new Object[]{this});
        }
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            JavaPluginConvention jc = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSet main = (SourceSet)jc.getSourceSets().getByName("main");
            Set files = main.getOutput().getClassesDirs().getFiles();
            String[] paths = new String[files.size()];
            int n = 0;
            for (File file2 : files) {
                try {
                    paths[n++] = file2.getCanonicalPath();
                }
                catch (IOException ex) {
                    paths[n++] = file2.getAbsolutePath();
                }
            }
            project.getTasks().register("javacppBuildCommand", BuildTask.class, task -> {
                task.classPath = paths;
                task.properties = this.getPlatform();
                if (this.getPlatformExtension() != null && this.getPlatformExtension().length() > 0) {
                    task.propertyKeysAndValues = new Properties();
                    task.propertyKeysAndValues.setProperty("platform.extension", this.getPlatformExtension());
                }
                task.classOrPackageNames = new String[0];
                task.workingDirectory = project.getProjectDir();
            });
            project.getTasks().register("javacppCompileJava", JavaCompile.class, task -> {
                task.setSource((FileTree)main.getJava());
                task.setClasspath(main.getCompileClasspath());
                task.setDestinationDir(main.getJava().getOutputDir());
                task.dependsOn(new Object[]{"javacppBuildCommand"});
            });
            project.getTasks().register("javacppBuildParser", BuildTask.class, task -> {
                task.classPath = paths;
                task.properties = this.getPlatform();
                if (this.getPlatformExtension() != null && this.getPlatformExtension().length() > 0) {
                    task.propertyKeysAndValues = new Properties();
                    task.propertyKeysAndValues.setProperty("platform.extension", this.getPlatformExtension());
                }
                task.outputDirectory = (File)main.getJava().getSrcDirs().iterator().next();
                task.dependsOn(new Object[]{"javacppCompileJava"});
                task.doFirst(t -> main.getJava().srcDir((Object)task.outputDirectory));
            });
            project.getTasks().getByName("compileJava").dependsOn(new Object[]{"javacppBuildParser"});
            project.getTasks().register("javacppBuildCompiler", BuildTask.class, task -> {
                task.classPath = paths;
                task.properties = this.getPlatform();
                if (this.getPlatformExtension() != null && this.getPlatformExtension().length() > 0) {
                    task.propertyKeysAndValues = new Properties();
                    task.propertyKeysAndValues.setProperty("platform.extension", this.getPlatformExtension());
                }
                task.dependsOn(new Object[]{"compileJava"});
            });
            project.getTasks().getByName("classes").dependsOn(new Object[]{"javacppBuildCompiler"});
            project.getTasks().register("javacppPomProperties", WriteProperties.class, task -> {
                Object group = project.findProperty("group");
                Object name = project.findProperty("name");
                Object version = project.findProperty("version");
                task.property("groupId", group);
                task.property("artifactId", name);
                task.property("version", version);
                task.setOutputFile(new File(main.getOutput().getResourcesDir(), "META-INF/maven/" + group + "/" + name + "/pom.properties"));
            });
            Jar jarTask = (Jar)project.getTasks().getByName("jar");
            jarTask.dependsOn(new Object[]{"javacppPomProperties"});
            jarTask.exclude(file -> this.isLibraryPath(file.getPath()));
            TaskProvider javacppJarTask = project.getTasks().register("javacppJar", Jar.class, task -> {
                task.from(new Object[]{main.getOutput()});
                task.setClassifier(this.getPlatform() + this.getPlatformExtension());
                task.include(file -> file.isDirectory() || this.isLibraryPath(file.getPath()));
                task.dependsOn(new Object[]{"jar"});
            });
            project.getArtifacts().add("archives", (Object)javacppJarTask);
            TaskProvider javacppPlatformJarTask = project.getTasks().register("javacppPlatformJar", Jar.class, task -> {
                task.setBaseName(project.getName() + "-platform");
                task.dependsOn(new Object[]{"javacppJar"});
            });
            TaskProvider javacppPlatformJavadocJarTask = project.getTasks().register("javacppPlatformJavadocJar", Jar.class, task -> {
                task.setBaseName(project.getName() + "-platform");
                task.setClassifier("javadoc");
                task.dependsOn(new Object[]{"javacppPlatformJar"});
            });
            TaskProvider javacppPlatformSourcesTask = project.getTasks().register("javacppPlatformSourcesJar", Jar.class, task -> {
                task.setBaseName(project.getName() + "-platform");
                task.setClassifier("sources");
                task.dependsOn(new Object[]{"javacppPlatformJar"});
            });
            project.getConfigurations().maybeCreate("javacppPlatform");
            project.getArtifacts().add("javacppPlatform", (Object)javacppPlatformJarTask);
            project.getArtifacts().add("javacppPlatform", (Object)javacppPlatformJavadocJarTask);
            project.getArtifacts().add("javacppPlatform", (Object)javacppPlatformSourcesTask);
        });
    }
}

