/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.gradle.javacpp;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.bytedeco.gradle.javacpp.BuildExecutor;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.tools.Builder;
import org.bytedeco.javacpp.tools.CommandExecutor;
import org.bytedeco.javacpp.tools.Logger;
import org.bytedeco.javacpp.tools.ParserException;
import org.bytedeco.javacpp.tools.Slf4jLogger;
import org.gradle.api.DefaultTask;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class BuildTask
extends DefaultTask {
    String[] classPath = null;
    String[] includePath = null;
    String[] includeResource = null;
    String[] buildPath = null;
    String[] buildResource = null;
    String[] linkPath = null;
    String[] linkResource = null;
    String[] preloadPath = null;
    String[] preloadResource = null;
    String[] resourcePath = null;
    String[] executablePath = null;
    String encoding = null;
    File outputDirectory = null;
    String outputName = null;
    boolean clean = false;
    boolean generate = true;
    boolean compile = true;
    boolean deleteJniFiles = true;
    boolean header = false;
    boolean copyLibs = false;
    boolean copyResources = false;
    File configDirectory = null;
    String jarPrefix = null;
    String properties = null;
    File propertyFile = null;
    Properties propertyKeysAndValues = null;
    String[] classOrPackageNames = null;
    String[] buildCommand = null;
    String[] targetDirectory = null;
    File workingDirectory = null;
    Map<String, String> environmentVariables = null;
    String[] compilerOptions = null;
    boolean skip = false;

    public BuildTask() {
        this.getOutputs().upToDateWhen(t -> false);
    }

    @Optional
    @Classpath
    @InputFiles
    String[] getClassPath() {
        return this.classPath;
    }

    void setClassPath(String[] s) {
        this.classPath = s;
    }

    @Optional
    @Input
    String[] getIncludePath() {
        return this.includePath;
    }

    void setIncludePath(String[] s) {
        this.includePath = s;
    }

    @Optional
    @Input
    String[] getIncludeResource() {
        return this.includeResource;
    }

    void setIncludeResource(String[] s) {
        this.includeResource = s;
    }

    @Optional
    @Input
    String[] getBuildPath() {
        return this.buildPath;
    }

    void setBuildPath(String[] s) {
        this.buildPath = s;
    }

    @Optional
    @Input
    String[] getBuildResource() {
        return this.buildResource;
    }

    void setBuildResource(String[] s) {
        this.buildResource = s;
    }

    @Optional
    @Input
    String[] getLinkPath() {
        return this.linkPath;
    }

    void setLinkPath(String[] s) {
        this.linkPath = s;
    }

    @Optional
    @Input
    String[] getLinkResource() {
        return this.linkResource;
    }

    void setLinkResource(String[] s) {
        this.linkResource = s;
    }

    @Optional
    @Input
    String[] getPreloadPath() {
        return this.preloadPath;
    }

    void setPreloadPath(String[] s) {
        this.preloadPath = s;
    }

    @Optional
    @Input
    String[] getPreloadResource() {
        return this.preloadResource;
    }

    void setPreloadResource(String[] s) {
        this.preloadResource = s;
    }

    @Optional
    @Input
    String[] getResourcePath() {
        return this.resourcePath;
    }

    void setResourcePath(String[] s) {
        this.resourcePath = s;
    }

    @Optional
    @Input
    String[] getExecutablePath() {
        return this.executablePath;
    }

    void setExecutablePath(String[] s) {
        this.executablePath = s;
    }

    @Optional
    @Input
    String getEncoding() {
        return this.encoding;
    }

    void setEncoding(String s) {
        this.encoding = s;
    }

    @Optional
    @OutputDirectory
    File getOutputDirectory() {
        return this.outputDirectory;
    }

    void setOutputDirectory(File f) {
        this.outputDirectory = f;
    }

    @Optional
    @Input
    String getOutputName() {
        return this.outputName;
    }

    void setOutputName(String s) {
        this.outputName = s;
    }

    @Input
    boolean getClean() {
        return this.clean;
    }

    void setClean(boolean b) {
        this.clean = b;
    }

    @Input
    boolean getGenerate() {
        return this.generate;
    }

    void setGenerate(boolean b) {
        this.generate = b;
    }

    @Input
    boolean getCompile() {
        return this.compile;
    }

    void setCompile(boolean b) {
        this.compile = b;
    }

    @Input
    boolean getDeleteJniFiles() {
        return this.deleteJniFiles;
    }

    void setDeleteJniFiles(boolean b) {
        this.deleteJniFiles = b;
    }

    @Input
    boolean getHeader() {
        return this.header;
    }

    void setHeader(boolean b) {
        this.header = b;
    }

    @Input
    boolean getCopyLibs() {
        return this.copyLibs;
    }

    void setCopyLibs(boolean b) {
        this.copyLibs = b;
    }

    @Input
    boolean getCopyResources() {
        return this.copyResources;
    }

    void setCopyResources(boolean b) {
        this.copyResources = b;
    }

    @Optional
    @OutputDirectory
    File getConfigDirectory() {
        return this.configDirectory;
    }

    void setConfigDirectory(File f) {
        this.configDirectory = f;
    }

    @Optional
    @Input
    String getJarPrefix() {
        return this.jarPrefix;
    }

    void setJarPrefix(String s) {
        this.jarPrefix = s;
    }

    @Optional
    @Input
    String getProperties() {
        return this.properties;
    }

    void setProperties(String s) {
        this.properties = s;
    }

    @Optional
    @InputFile
    File getPropertyFile() {
        return this.propertyFile;
    }

    void setPropertyFile(File f) {
        this.propertyFile = f;
    }

    @Optional
    @Input
    Properties getPropertyKeysAndValues() {
        return this.propertyKeysAndValues;
    }

    void setPropertyKeysAndValues(Properties p) {
        this.propertyKeysAndValues = p;
    }

    @Optional
    @Input
    String[] getClassOrPackageNames() {
        return this.classOrPackageNames;
    }

    void setClassOrPackageNames(String[] s) {
        this.classOrPackageNames = s;
    }

    @Optional
    @Input
    String[] getBuildCommand() {
        return this.buildCommand;
    }

    void setBuildCommand(String[] s) {
        this.buildCommand = s;
    }

    @Optional
    @Input
    String[] getTargetDirectory() {
        return this.targetDirectory;
    }

    void setTargetDirectory(String[] s) {
        this.targetDirectory = s;
    }

    @Optional
    @InputDirectory
    File getWorkingDirectory() {
        return this.workingDirectory;
    }

    void setWorkingDirectory(File f) {
        this.workingDirectory = f;
    }

    @Optional
    @Input
    Map getEnvironmentVariables() {
        return this.environmentVariables;
    }

    void setEnvironmentVariables(Map m) {
        this.environmentVariables = m;
    }

    @Optional
    @Input
    String[] getCompilerOptions() {
        return this.compilerOptions;
    }

    void setCompilerOptions(String[] s) {
        this.compilerOptions = s;
    }

    @Input
    boolean getSkip() {
        return this.skip;
    }

    void setSkip(boolean b) {
        this.skip = b;
    }

    @TaskAction
    public void build() throws IOException, ClassNotFoundException, NoClassDefFoundError, InterruptedException, ParserException {
        Slf4jLogger logger = new Slf4jLogger(Builder.class);
        if (this.getSkip()) {
            logger.info("Skipping execution of JavaCPP Builder");
            return;
        }
        Builder builder = new Builder((Logger)logger).classPaths(this.getClassPath()).encoding(this.getEncoding()).outputDirectory(this.getOutputDirectory()).outputName(this.getOutputName()).clean(this.getClean()).generate(this.getGenerate()).compile(this.getCompile()).deleteJniFiles(this.getDeleteJniFiles()).header(this.getHeader()).copyLibs(this.getCopyLibs()).copyResources(this.getCopyResources()).configDirectory(this.getConfigDirectory()).jarPrefix(this.getJarPrefix()).properties(this.getProperties()).propertyFile(this.getPropertyFile()).properties(this.getPropertyKeysAndValues()).classesOrPackages(this.getClassOrPackageNames()).buildCommand(this.getBuildCommand()).workingDirectory(this.getWorkingDirectory()).environmentVariables(this.getEnvironmentVariables()).compilerOptions(this.getCompilerOptions()).commandExecutor((CommandExecutor)new BuildExecutor((Logger)logger)).addProperty("platform.buildpath", this.getBuildPath()).addProperty("platform.buildresource", this.getBuildResource()).addProperty("platform.includepath", this.getIncludePath()).addProperty("platform.includeresource", this.getIncludeResource()).addProperty("platform.linkpath", this.getLinkPath()).addProperty("platform.linkresource", this.getLinkResource()).addProperty("platform.preloadpath", this.getPreloadPath()).addProperty("platform.preloadresource", this.getPreloadResource()).addProperty("platform.resourcepath", this.getResourcePath()).addProperty("platform.executablepath", this.getExecutablePath());
        String extension = builder.getProperty("platform.extension");
        this.getLogger().info("Detected platform \"" + Loader.Detector.getPlatform() + "\"");
        this.getLogger().info("Building platform \"" + builder.getProperty("platform") + "\"" + (extension != null && extension.length() > 0 ? " with extension \"" + extension + "\"" : ""));
        ExtraPropertiesExtension projectProperties = this.getProject().getExtensions().getExtraProperties();
        for (String key : builder.getProperties().stringPropertyNames()) {
            projectProperties.set("javacpp." + key, (Object)builder.getProperties().getProperty(key));
        }
        Object[] outputFiles = builder.build();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("outputFiles: " + Arrays.deepToString(outputFiles));
        }
    }
}

