// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.hdf5.global.hdf5.*;


/** \class StrType
    \brief StrType is a derivative of a DataType and operates on HDF5
    string datatype.
*/
//  Inheritance: AtomType -> DataType -> H5Object -> H5Location -> IdComponent
@Namespace("H5") @Properties(inherit = org.bytedeco.hdf5.presets.hdf5.class)
public class StrType extends AtomType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StrType(Pointer p) { super(p); }

        // Creates a string type using a predefined type
        public StrType(@Const @ByRef PredType pred_type) { super((Pointer)null); allocate(pred_type); }
        private native void allocate(@Const @ByRef PredType pred_type);

        // Creates a string type with specified length - may be obsolete
        public StrType(@Const @ByRef PredType pred_type, @Cast("const size_t") long size) { super((Pointer)null); allocate(pred_type, size); }
        private native void allocate(@Const @ByRef PredType pred_type, @Cast("const size_t") long size);

        // Creates a string type with specified length
        public StrType(int dummy, @Cast("const size_t") long size) { super((Pointer)null); allocate(dummy, size); }
        private native void allocate(int dummy, @Cast("const size_t") long size);

        // Gets the string datatype of the specified dataset
        public StrType(@Const @ByRef DataSet dataset) { super((Pointer)null); allocate(dataset); }
        private native void allocate(@Const @ByRef DataSet dataset);

        // Constructors that open an HDF5 string datatype, given a location.
        public StrType(@Const @ByRef H5Location loc, @Cast("const char*") BytePointer name) { super((Pointer)null); allocate(loc, name); }
        private native void allocate(@Const @ByRef H5Location loc, @Cast("const char*") BytePointer name);
        public StrType(@Const @ByRef H5Location loc, String name) { super((Pointer)null); allocate(loc, name); }
        private native void allocate(@Const @ByRef H5Location loc, String name);

        // Returns an StrType object via DataType* by decoding the
        // binary object description of this type.
        public native DataType decode();

        // Retrieves the character set type of this string datatype.
        public native @Cast("H5T_cset_t") int getCset();

        // Sets character set to be used.
        public native void setCset(@Cast("H5T_cset_t") int cset);

        // Retrieves the string padding method for this string datatype.
        public native @Cast("H5T_str_t") int getStrpad();

        // Defines the storage mechanism for character strings.
        public native void setStrpad(@Cast("H5T_str_t") int strpad);

        /**\brief Returns this class name. */
        public native @StdString BytePointer fromClass();

        // default constructor
        public StrType() { super((Pointer)null); allocate(); }
        private native void allocate();

        // Creates a string datatype using an existing id
        public StrType(@Cast("const hid_t") long existing_id) { super((Pointer)null); allocate(existing_id); }
        private native void allocate(@Cast("const hid_t") long existing_id);

        // Copy constructor: same as the original StrType.
        public StrType(@Const @ByRef StrType original) { super((Pointer)null); allocate(original); }
        private native void allocate(@Const @ByRef StrType original);

        // Noop destructor.

}
