// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5.global;

import org.bytedeco.hdf5.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class hdf5 extends org.bytedeco.hdf5.presets.hdf5 {
    static { Loader.load(); }

// Parsed from H5pubconf.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* H5pubconf.h  Generated By CMake during the configuration */

// #ifndef H5_CONFIG_H_
// #define H5_CONFIG_H_

/* Define if the Windows virtual file driver should be compiled */
public static final int H5_HAVE_WINDOWS = 1;

/* Define if using MinGW */
/* #undef H5_HAVE_MINGW */

/* Define if on the Windows platform and default WIN32 API */
public static final int H5_HAVE_WIN32_API = 1;

/* Define if using a Windows compiler (i.e. Visual Studio) */
public static final int H5_HAVE_VISUAL_STUDIO = 1;

/* Define if building universal (internal helper macro) */
/* #undef H5_AC_APPLE_UNIVERSAL_BUILD */

/* Define if C++ compiler recognizes offsetof */
/* #undef H5_CXX_HAVE_OFFSETOF */

/* Define the default plugins path to compile */
public static final String H5_DEFAULT_PLUGINDIR = "%ALLUSERSPROFILE%\\hdf5\\lib\\plugin";

/* Define if `dev_t' is a scalar */
/* #undef H5_DEV_T_IS_SCALAR */

/* Define to dummy `main' function (if any) required to link to the Fortran
   libraries. */
/* #undef H5_FC_DUMMY_MAIN */

/* Define if F77 and FC dummy `main' functions are identical. */
/* #undef H5_FC_DUMMY_MAIN_EQ_F77 */

/* Define to a macro mangling the given C identifier (in lower and upper
   case), which must not contain underscores, for linking with Fortran. */
// #define H5_FC_FUNC(name,NAME) name ## _

/* As FC_FUNC, but for C identifiers containing underscores. */
// #define H5_FC_FUNC_(name,NAME) name ## _

/* Define if Fortran C_LONG_DOUBLE is different from C_DOUBLE */
// #define H5_FORTRAN_C_LONG_DOUBLE_IS_UNIQUE 

/* Define if we have Fortran C_LONG_DOUBLE */
// #define H5_FORTRAN_HAVE_C_LONG_DOUBLE 

/* Define if we have Fortran intrinsic C_SIZEOF */
/* #undef H5_FORTRAN_HAVE_C_SIZEOF */

/* Define if we have Fortran intrinsic SIZEOF */
/* #undef H5_FORTRAN_HAVE_SIZEOF */

/* Define if we have Fortran intrinsic STORAGE_SIZE */
/* #undef H5_FORTRAN_HAVE_STORAGE_SIZE */

/* Determine the size of C long double */
/* #undef H5_FORTRAN_SIZEOF_LONG_DOUBLE */

/* Define Fortran compiler ID */
// #define H5_Fortran_COMPILER_ID 

/* Define valid Fortran INTEGER KINDs */
/* #undef H5_H5CONFIG_F_IKIND */

/* Define number of valid Fortran INTEGER KINDs */
/* #undef H5_H5CONFIG_F_NUM_IKIND */

/* Define number of valid Fortran REAL KINDs */
/* #undef H5_H5CONFIG_F_NUM_RKIND */

/* Define valid Fortran REAL KINDs */
/* #undef H5_H5CONFIG_F_RKIND */

/* Define valid Fortran REAL KINDs Sizeof */
/* #undef H5_H5CONFIG_F_RKIND_SIZEOF */

/* Define to 1 if you have the `alarm' function. */
/* #undef H5_HAVE_ALARM */

/* Define to 1 if you have the `asprintf' function. */
/* #undef H5_HAVE_ASPRINTF */

/* Define if the __attribute__(()) extension is present */
/* #undef H5_HAVE_ATTRIBUTE */

/* Define if the compiler understands C99 designated initialization of structs
   and unions */
/* #undef H5_HAVE_C99_DESIGNATED_INITIALIZER */

/* Define if the compiler understands the __func__ keyword */
/* #undef H5_HAVE_C99_FUNC */

/* Define to 1 if you have the `clock_gettime' function. */
/* #undef H5_HAVE_CLOCK_GETTIME */

/* Define if the function stack tracing code is to be compiled in */
/* #undef H5_HAVE_CODESTACK */

/* Define to 1 if you have the <curl/curl.h> header file. */
/* #undef H5_HAVE_CURL_H */

/* Define if Darwin or Mac OS X */
/* #undef H5_HAVE_DARWIN */

/* Define to 1 if you have the `difftime' function. */
public static final int H5_HAVE_DIFFTIME = 1;

/* Define if the direct I/O virtual file driver (VFD) should be compiled */
/* #undef H5_HAVE_DIRECT */

/* Define to 1 if you have the <dirent.h> header file. */
/* #undef H5_HAVE_DIRENT_H */

/* Define to 1 if you have the <dlfcn.h> header file. */
/* #undef H5_HAVE_DLFCN_H */

/* Define to 1 if you have the <dmalloc.h> header file. */
/* #undef H5_HAVE_DMALLOC_H */

/* Define if library information should be embedded in the executables */
public static final int H5_HAVE_EMBEDDED_LIBINFO = 1;

/* Define to 1 if you have the `fcntl' function. */
/* #undef H5_HAVE_FCNTL */

/* Define to 1 if you have the <features.h> header file. */
/* #undef H5_HAVE_FEATURES_H */

/* Define if support for deflate (zlib) filter is enabled */
public static final int H5_HAVE_FILTER_DEFLATE = 1;

/* Define if support for szip filter is enabled */
/* #undef H5_HAVE_FILTER_SZIP */

/* Determine if __float128 is available */
/* #undef H5_HAVE_FLOAT128 */

/* Define to 1 if you have the `flock' function. */
/* #undef H5_HAVE_FLOCK */

/* Define to 1 if you have the `fork' function. */
/* #undef H5_HAVE_FORK */

/* Define to 1 if you have the `frexpf' function. */
/* #undef H5_HAVE_FREXPF */

/* Define to 1 if you have the `frexpl' function. */
/* #undef H5_HAVE_FREXPL */

/* Define to 1 if you have the `fseeko' function. */
/* #undef H5_HAVE_FSEEKO */

/* Define if the compiler understands the __FUNCTION__ keyword */
public static final int H5_HAVE_FUNCTION = 1;

/* Determine if INTEGER*16 is available */
/* #undef H5_HAVE_Fortran_INTEGER_SIZEOF_16 */

/* Define to 1 if you have the `GetConsoleScreenBufferInfo' function. */
public static final int H5_HAVE_GETCONSOLESCREENBUFFERINFO = 1;

/* Define to 1 if you have the `gethostname' function. */
public static final int H5_HAVE_GETHOSTNAME = 1;

/* Define to 1 if you have the `getpwuid' function. */
/* #undef H5_HAVE_GETPWUID */

/* Define to 1 if you have the `getrusage' function. */
/* #undef H5_HAVE_GETRUSAGE */

/* Define to 1 if you have the `gettextinfo' function. */
/* #undef H5_HAVE_GETTEXTINFO */

/* Define to 1 if you have the `gettimeofday' function. */
public static final int H5_HAVE_GETTIMEOFDAY = 1;

/* Define to 1 if you have the <hdfs.h> header file. */
/* #undef H5_HAVE_HDFS_H */

/* Define if the compiler understands inline */
public static final int H5_HAVE_INLINE = 1;

/* Define if parallel library will contain instrumentation to detect correct
   optimization operation */
/* #undef H5_HAVE_INSTRUMENTED_LIBRARY */

/* Define to 1 if you have the <inttypes.h> header file. */
public static final int H5_HAVE_INTTYPES_H = 1;

/* Define to 1 if you have the `ioctl' function. */
/* #undef H5_HAVE_IOCTL */

/* Define to 1 if you have the <io.h> header file. */
public static final int H5_HAVE_IO_H = 1;

/* Define to 1 if you have the `crypto' library (-lcrypto). */
/* #undef H5_HAVE_LIBCRYPTO */

/* Define to 1 if you have the `curl' library (-lcurl). */
/* #undef H5_HAVE_LIBCURL */

/* Define to 1 if you have the `dl' library (-ldl). */
/* #undef H5_HAVE_LIBDL */

/* Define to 1 if you have the `dmalloc' library (-ldmalloc). */
/* #undef H5_HAVE_LIBDMALLOC */

/* Proceed to build with libhdfs */
/* #undef H5_HAVE_LIBHDFS */

/* Define to 1 if you have the `jvm' library (-ljvm). */
/* #undef H5_HAVE_LIBJVM */

/* Define to 1 if you have the `m' library (-lm). */
public static final int H5_HAVE_LIBM = 1;

/* Define to 1 if you have the `mpe' library (-lmpe). */
/* #undef H5_HAVE_LIBMPE */

/* Define to 1 if you have the `pthread' library (-lpthread). */
/* #undef H5_HAVE_LIBPTHREAD */

/* Define to 1 if you have the `sz' library (-lsz). */
/* #undef H5_HAVE_LIBSZ */

/* Define to 1 if you have the `ws2_32' library (-lws2_32). */
public static final int H5_HAVE_LIBWS2_32 = 1;

/* Define to 1 if you have the `z' library (-lz). */
public static final int H5_HAVE_LIBZ = 1;

/* Define to 1 if you have the `llround' function. */
public static final int H5_HAVE_LLROUND = 1;

/* Define to 1 if you have the `llroundf' function. */
public static final int H5_HAVE_LLROUNDF = 1;

/* Define to 1 if you have the `longjmp' function. */
public static final int H5_HAVE_LONGJMP = 1;

/* Define to 1 if you have the `lround' function. */
public static final int H5_HAVE_LROUND = 1;

/* Define to 1 if you have the `lroundf' function. */
public static final int H5_HAVE_LROUNDF = 1;

/* Define to 1 if you have the `lseek64' function. */
/* #undef H5_HAVE_LSEEK64 */

/* Define to 1 if you have the `lstat' function. */
/* #undef H5_HAVE_LSTAT */

/* Define to 1 if you have the <mach/mach_time.h> header file. */
/* #undef H5_HAVE_MACH_MACH_TIME_H */

/* Define if the map API (H5M) should be compiled */
/* #undef H5_HAVE_MAP_API */

/* Define to 1 if you have the <memory.h> header file. */
public static final int H5_HAVE_MEMORY_H = 1;

/* Define if we have MPE support */
/* #undef H5_HAVE_MPE */

/* Define to 1 if you have the <mpe.h> header file. */
/* #undef H5_HAVE_MPE_H */

/* Define if MPI_Comm_c2f and MPI_Comm_f2c exists */
/* #undef H5_HAVE_MPI_MULTI_LANG_Comm */

/* Define if MPI_Info_c2f and MPI_Info_f2c exists */
/* #undef H5_HAVE_MPI_MULTI_LANG_Info */

/* Define to 1 if you have the <openssl/evp.h> header file. */
/* #undef H5_HAVE_OPENSSL_EVP_H */

/* Define to 1 if you have the <openssl/hmac.h> header file. */
/* #undef H5_HAVE_OPENSSL_HMAC_H */

/* Define to 1 if you have the <openssl/sha.h> header file. */
/* #undef H5_HAVE_OPENSSL_SHA_H */

/* Define if we have parallel support */
/* #undef H5_HAVE_PARALLEL */

/* Define if both pread and pwrite exist. */
/* #undef H5_HAVE_PREADWRITE */

/* Define to 1 if you have the <pthread.h> header file. */
/* #undef H5_HAVE_PTHREAD_H */

/* Define to 1 if you have the <quadmath.h> header file. */
/* #undef H5_HAVE_QUADMATH_H */

/* Define to 1 if you have the `random' function. */
/* #undef H5_HAVE_RANDOM */

/* Define to 1 if you have the `rand_r' function. */
/* #undef H5_HAVE_RAND_R */

/* Define whether the Read-Only S3 virtual file driver (VFD) should be
   compiled */
/* #undef H5_HAVE_ROS3_VFD */

/* Define to 1 if you have the `round' function. */
public static final int H5_HAVE_ROUND = 1;

/* Define to 1 if you have the `roundf' function. */
public static final int H5_HAVE_ROUNDF = 1;

/* Define to 1 if you have the `setjmp' function. */
public static final int H5_HAVE_SETJMP = 1;

/* Define to 1 if you have the <setjmp.h> header file. */
public static final int H5_HAVE_SETJMP_H = 1;

/* Define to 1 if you have the `setsysinfo' function. */
/* #undef H5_HAVE_SETSYSINFO */

/* Define to 1 if you have the `siglongjmp' function. */
/* #undef H5_HAVE_SIGLONGJMP */

/* Define to 1 if you have the `signal' function. */
public static final int H5_HAVE_SIGNAL = 1;

/* Define to 1 if you have the `sigprocmask' function. */
/* #undef H5_HAVE_SIGPROCMASK */

/* Define to 1 if you have the `sigsetjmp' function. */
/* #undef H5_HAVE_SIGSETJMP */

/* Define to 1 if you have the `snprintf' function. */
/* #undef H5_HAVE_SNPRINTF */

/* Define to 1 if you have the `srandom' function. */
/* #undef H5_HAVE_SRANDOM */

/* Define to 1 if you have the `stat64' function. */
/* #undef H5_HAVE_STAT64 */

/* Define if `struct stat' has the `st_blocks' field */
/* #undef H5_HAVE_STAT_ST_BLOCKS */

/* Define to 1 if you have the <stdbool.h> header file. */
public static native @MemberGetter int H5_HAVE_STDBOOL_H();
public static final int H5_HAVE_STDBOOL_H = H5_HAVE_STDBOOL_H();

/* Define to 1 if you have the <stddef.h> header file. */
public static final int H5_HAVE_STDDEF_H = 1;

/* Define to 1 if you have the <stdint.h> header file. */
public static final int H5_HAVE_STDINT_H = 1;

/* Define to 1 if you have the <stdint.h> header file for Cplusplus. */
public static final int H5_HAVE_STDINT_H_CXX = 1;

/* Define to 1 if you have the <stdlib.h> header file. */
public static final int H5_HAVE_STDLIB_H = 1;

/* Define to 1 if you have the `strdup' function. */
public static final int H5_HAVE_STRDUP = 1;

/* Define to 1 if you have the <strings.h> header file. */
/* #undef H5_HAVE_STRINGS_H */

/* Define to 1 if you have the <string.h> header file. */
public static final int H5_HAVE_STRING_H = 1;

/* Define to 1 if you have the `strtoll' function. */
public static final int H5_HAVE_STRTOLL = 1;

/* Define to 1 if you have the `strtoull' function. */
public static final int H5_HAVE_STRTOULL = 1;

/* Define if struct text_info is defined */
/* #undef H5_HAVE_STRUCT_TEXT_INFO */

/* Define if struct videoconfig is defined */
/* #undef H5_HAVE_STRUCT_VIDEOCONFIG */

/* Define to 1 if you have the `symlink' function. */
/* #undef H5_HAVE_SYMLINK */

/* Define to 1 if you have the `system' function. */
public static final int H5_HAVE_SYSTEM = 1;

/* Define to 1 if you have the <sys/file.h> header file. */
/* #undef H5_HAVE_SYS_FILE_H */

/* Define to 1 if you have the <sys/ioctl.h> header file. */
/* #undef H5_HAVE_SYS_IOCTL_H */

/* Define to 1 if you have the <sys/resource.h> header file. */
/* #undef H5_HAVE_SYS_RESOURCE_H */

/* Define to 1 if you have the <sys/socket.h> header file. */
/* #undef H5_HAVE_SYS_SOCKET_H */

/* Define to 1 if you have the <sys/stat.h> header file. */
public static final int H5_HAVE_SYS_STAT_H = 1;

/* Define to 1 if you have the <sys/timeb.h> header file. */
public static final int H5_HAVE_SYS_TIMEB_H = 1;

/* Define to 1 if you have the <sys/time.h> header file. */
/* #undef H5_HAVE_SYS_TIME_H */

/* Define to 1 if you have the <sys/types.h> header file. */
public static final int H5_HAVE_SYS_TYPES_H = 1;

/* Define to 1 if you have the <szlib.h> header file. */
/* #undef H5_HAVE_SZLIB_H */

// #if defined(_WIN32) && !defined(H5_BUILT_AS_DYNAMIC_LIB)
/* Not supported on WIN32 platforms with static linking */
/* #undef H5_HAVE_THREADSAFE */
// #else
/* Define if we have thread safe support */
/* #undef H5_HAVE_THREADSAFE */
// #endif

/* Define if timezone is a global variable */
public static final int H5_HAVE_TIMEZONE = 1;

/* Define if the ioctl TIOCGETD is defined */
/* #undef H5_HAVE_TIOCGETD */

/* Define if the ioctl TIOGWINSZ is defined */
/* #undef H5_HAVE_TIOCGWINSZ */

/* Define to 1 if you have the `tmpfile' function. */
public static final int H5_HAVE_TMPFILE = 1;

/* Define if tm_gmtoff is a member of struct tm */
/* #undef H5_HAVE_TM_GMTOFF */

/* Define to 1 if you have the <unistd.h> header file. */
/* #undef H5_HAVE_UNISTD_H */

/* Define to 1 if you have the `vasprintf' function. */
/* #undef H5_HAVE_VASPRINTF */

/* Define to 1 if you have the `vsnprintf' function. */
/* #undef H5_HAVE_VSNPRINTF */

/* Define to 1 if you have the `waitpid' function. */
/* #undef H5_HAVE_WAITPID */

/* Define to 1 if you have the 'InitOnceExecuteOnce' function. */
/* #undef H5_HAVE_WIN_THREADS */

/* Define if your system has window style path name. */
public static final int H5_HAVE_WINDOW_PATH = 1;

/* Define to 1 if you have the <winsock2.h> header file. */
public static final int H5_HAVE_WINSOCK2_H = 1;

/* Define to 1 if you have the <zlib.h> header file. */
public static final int H5_HAVE_ZLIB_H = 1;

/* Define to 1 if you have the `_getvideoconfig' function. */
/* #undef H5_HAVE__GETVIDEOCONFIG */

/* Define to 1 if you have the `_scrsize' function. */
/* #undef H5_HAVE__SCRSIZE */

/* Define if the compiler understands __inline */
public static final int H5_HAVE___INLINE = 1;

/* Define if the compiler understands __inline__ */
/* #undef H5_HAVE___INLINE__ */

/* Define if the high-level library headers should be included in hdf5.h */
public static final int H5_INCLUDE_HL = 1;

/* Define if your system can convert long double to (unsigned) long long
   values correctly. */
public static final int H5_LDOUBLE_TO_LLONG_ACCURATE = 1;

/* Define if your system converts long double to (unsigned) long values with
   special algorithm. */
/* #undef H5_LDOUBLE_TO_LONG_SPECIAL */

/* Define if your system can convert (unsigned) long long to long double
   values correctly. */
public static final int H5_LLONG_TO_LDOUBLE_CORRECT = 1;

/* Define if your system can convert (unsigned) long to long double values
   with special algorithm. */
/* #undef H5_LONG_TO_LDOUBLE_SPECIAL */

/* Define if your system is power6 and cannot convert some long double values. */
/* #undef H5_DISABLE_SOME_LDOUBLE_CONV */

/* Define to the sub-directory where libtool stores uninstalled libraries. */
/* #undef H5_LT_OBJDIR */

/* Define to enable internal memory allocation sanity checking. */
/* #undef H5_MEMORY_ALLOC_SANITY_CHECK */

/* Define if we can violate pointer alignment restrictions */
public static final int H5_NO_ALIGNMENT_RESTRICTIONS = 1;

/* Define if deprecated public API symbols are disabled */
/* #undef H5_NO_DEPRECATED_SYMBOLS */

/* Name of package */
public static final String H5_PACKAGE = "hdf5";

/* Define to the address where bug reports for this package should be sent. */
public static final String H5_PACKAGE_BUGREPORT = "help@hdfgroup.org";

/* Define to the full name of this package. */
public static final String H5_PACKAGE_NAME = "HDF5";

/* Define to the full name and version of this package. */
public static final String H5_PACKAGE_STRING = "HDF5 1.12.0";

/* Define to the one symbol short name of this package. */
public static final String H5_PACKAGE_TARNAME = "hdf5";

/* Define to the home page for this package. */
public static final String H5_PACKAGE_URL = "http://www.hdfgroup.org";

/* Define to the version of this package. */
public static final String H5_PACKAGE_VERSION = "1.12.0";

/* Determine the maximum decimal precision in C */
/* #undef H5_PAC_C_MAX_REAL_PRECISION */

/* Define Fortran Maximum Real Decimal Precision */
/* #undef H5_PAC_FC_MAX_REAL_PRECISION */

/* Width for printf() for type `long long' or `__int64', use `ll' */
public static final String H5_PRINTF_LL_WIDTH = "I64";

/* The size of `bool', as computed by sizeof. */
public static final int H5_SIZEOF_BOOL = 1;

/* The size of `char', as computed by sizeof. */
public static final int H5_SIZEOF_CHAR = 1;

/* The size of `double', as computed by sizeof. */
public static final int H5_SIZEOF_DOUBLE = 8;

/* The size of `float', as computed by sizeof. */
public static final int H5_SIZEOF_FLOAT = 4;

/* The size of `int', as computed by sizeof. */
public static final int H5_SIZEOF_INT = 4;

/* The size of `int16_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT16_T = 2;

/* The size of `int32_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT32_T = 4;

/* The size of `int64_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT64_T = 8;

/* The size of `int8_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT8_T = 1;

/* The size of `int_fast16_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_FAST16_T = 4;

/* The size of `int_fast32_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_FAST32_T = 4;

/* The size of `int_fast64_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_FAST64_T = 8;

/* The size of `int_fast8_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_FAST8_T = 1;

/* The size of `int_least16_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_LEAST16_T = 2;

/* The size of `int_least32_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_LEAST32_T = 4;

/* The size of `int_least64_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_LEAST64_T = 8;

/* The size of `int_least8_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_LEAST8_T = 1;

// #if !defined(__APPLE__)
/* The size of `size_t', as computed by sizeof. */
public static final int H5_SIZEOF_SIZE_T = 8;

/* The size of `ssize_t', as computed by sizeof. */
/* #undef H5_SIZEOF_SSIZE_T */

/* The size of `long', as computed by sizeof. */
public static final int H5_SIZEOF_LONG = 4;

// #else
//    # if defined(__LP64__) && __LP64__
  public static final int H5_SIZEOF_SSIZE_T = 8;
//   # else
//   # endif

// #endif

/* The size of `long double', as computed by sizeof. */
public static final int H5_SIZEOF_LONG_DOUBLE = 8;

/* Define size of long long and/or __int64 bit integer type only if the type
   exists.  */
// #if !defined(__APPLE__)
 public static final int H5_SIZEOF_LONG_LONG = 8;
// #else
// #endif

/* The size of `off64_t', as computed by sizeof. */
/* #undef H5_SIZEOF_OFF64_T */

/* The size of `off_t', as computed by sizeof. */
public static final int H5_SIZEOF_OFF_T = 4;

/* The size of `ptrdiff_t', as computed by sizeof. */
/* #undef H5_SIZEOF_PTRDIFF_T */

/* The size of `short', as computed by sizeof. */
public static final int H5_SIZEOF_SHORT = 2;

/* The size of `time_t', as computed by sizeof. */
public static final int H5_SIZEOF_TIME_T = 8;

/* The size of `uint16_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT16_T = 2;

/* The size of `uint32_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT32_T = 4;

/* The size of `uint64_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT64_T = 8;

/* The size of `uint8_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT8_T = 1;

/* The size of `uint_fast16_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_FAST16_T = 4;

/* The size of `uint_fast32_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_FAST32_T = 4;

/* The size of `uint_fast64_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_FAST64_T = 8;

/* The size of `uint_fast8_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_FAST8_T = 1;

/* The size of `uint_least16_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_LEAST16_T = 2;

/* The size of `uint_least32_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_LEAST32_T = 4;

/* The size of `uint_least64_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_LEAST64_T = 8;

/* The size of `uint_least8_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_LEAST8_T = 1;

/* The size of `unsigned', as computed by sizeof. */
public static final int H5_SIZEOF_UNSIGNED = 4;

/* The size of `_Quad', as computed by sizeof. */
// #define H5_SIZEOF__QUAD 

/* The size of `__float128', as computed by sizeof. */
public static final int H5_SIZEOF___FLOAT128 = 0;

/* The size of `__int64', as computed by sizeof. */
public static final int H5_SIZEOF___INT64 = 8;

/* Define to 1 if you have the ANSI C header files. */
public static final int H5_STDC_HEADERS = 1;

/* Define if strict file format checks are enabled */
/* #undef H5_STRICT_FORMAT_CHECKS */

/* Define if your system supports pthread_attr_setscope(&attribute,
   PTHREAD_SCOPE_SYSTEM) call. */
/* #undef H5_SYSTEM_SCOPE_THREADS */

/* Define to 1 if you can safely include both <sys/time.h> and <time.h>. */
/* #undef H5_TIME_WITH_SYS_TIME */

/* Define using v1.6 public API symbols by default */
/* #undef H5_USE_16_API_DEFAULT */

/* Define using v1.8 public API symbols by default */
/* #undef H5_USE_18_API_DEFAULT */

/* Define using v1.10 public API symbols by default */
/* #undef H5_USE_110_API_DEFAULT */

/* Define using v1.12 public API symbols by default */
public static final int H5_USE_112_API_DEFAULT = 1;

/* Define if a memory checking tool will be used on the library, to cause
   library to be very picky about memory operations and also disable the
   internal free list manager code. */
/* #undef H5_USING_MEMCHECKER */

/* Version number of package */
public static final String H5_VERSION = "1.12.0";

/* Data accuracy is prefered to speed during data conversions */
public static final int H5_WANT_DATA_ACCURACY = 1;

/* Check exception handling functions during data conversions */
public static final int H5_WANT_DCONV_EXCEPTION = 1;

/* Define WORDS_BIGENDIAN to 1 if your processor stores words with the most
   significant byte first (like Motorola and SPARC, unlike Intel). */
// #if !defined(__APPLE__)
// # ifndef WORDS_BIGENDIAN
// #  undef WORDS_BIGENDIAN
// # endif
// #else
// # if defined __BIG_ENDIAN__
public static final int WORDS_BIGENDIAN = 1;
// # endif
// #endif

/* #undef WORDS_BIGENDIAN */

/* Number of bits in a file offset, on hosts where this is settable. */
/* #undef H5__FILE_OFFSET_BITS */

/* Define for large files, on AIX-style hosts. */
/* #undef H5__LARGE_FILES */

/* Define to empty if `const' does not conform to ANSI C. */
/* #undef H5_const */

/* Define to `long int' if <sys/types.h> does not define. */
/* #undef H5_off_t */

/* Define to `long' if <sys/types.h> does not define. */
/* #undef H5_ptrdiff_t */

/* Define to `unsigned long' if <sys/types.h> does not define. */
/* #undef H5_size_t */

/* Define to `long' if <sys/types.h> does not define. */
/* #undef H5_ssize_t */

// #endif


// Parsed from H5public.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the HDF5 module.
 */
// #ifndef _H5public_H
// #define _H5public_H

/* Include files for public use... */
/*
 * Since H5pubconf.h is a generated header file, it is messy to try
 * to put a #ifndef _H5pubconf_H ... #endif guard in it.
 * HDF5 has set an internal rule that it is being included here.
 * Source files should NOT include H5pubconf.h directly but include
 * it via H5public.h.  The #ifndef _H5public_H guard above would
 * prevent repeated include.
 */
// #include "H5pubconf.h"		/*from configure                             */

/* API Version macro wrapper definitions */
// #include "H5version.h"

// #ifdef H5_HAVE_FEATURES_H
// #include <features.h>           /*for setting POSIX, BSD, etc. compatibility */
// #endif
// #ifdef H5_HAVE_SYS_TYPES_H
// #include <sys/types.h>
// #endif
// #ifdef H5_STDC_HEADERS
// #   include <limits.h>		/*for H5T_NATIVE_CHAR defn in H5Tpublic.h    */
// #   include <stdarg.h>      /*for variadic functions in H5VLpublic.h     */
// #endif
// #ifndef __cplusplus
// # ifdef H5_HAVE_STDINT_H
// #   include <stdint.h>		/*for C9x types				     */
// # endif
// #else
// # ifdef H5_HAVE_STDINT_H_CXX
// #   include <stdint.h>		/*for C9x types	when include from C++	     */
// # endif
// #endif
// #ifdef H5_HAVE_INTTYPES_H
// #   include <inttypes.h>        /* For uint64_t on some platforms            */
// #endif
// #ifdef H5_HAVE_STDDEF_H
// #   include <stddef.h>
// #endif
// #ifdef H5_HAVE_PARALLEL
// #endif


/* Include the Windows API adapter header early */
// #include "H5api_adpt.h"

// #ifdef __cplusplus
// #endif

/* Macros for enabling/disabling particular GCC warnings */
/* (see the following web-sites for more info:
 *      http://www.dbp-consulting.com/tutorials/SuppressingGCCWarnings.html
 *      http://gcc.gnu.org/onlinedocs/gcc/Diagnostic-Pragmas.html#Diagnostic-Pragmas
 */
/* These pragmas are only implemented usefully in gcc 4.6+ */
// #if ((__GNUC__ * 100) + __GNUC_MINOR__) >= 406
// #else
//     #define H5_GCC_DIAG_OFF(x)
//     #define H5_GCC_DIAG_ON(x)
// #endif

/* Version numbers */
public static final int H5_VERS_MAJOR =	1;	/* For major interface/format changes  	     */
public static final int H5_VERS_MINOR =	12;	/* For minor interface/format changes  	     */
public static final int H5_VERS_RELEASE =	0;	/* For tweaks, bug-fixes, or development     */
public static final String H5_VERS_SUBRELEASE = "";	/* For pre-releases like snap0       */
				/* Empty string for real releases.           */
public static final String H5_VERS_INFO =    "HDF5 library version: 1.12.0";      /* Full version string */

// #define H5check()	H5check_version(H5_VERS_MAJOR,H5_VERS_MINOR,
// 				        H5_VERS_RELEASE)

/* macros for comparing the version */
// #define H5_VERSION_GE(Maj,Min,Rel)
//        (((H5_VERS_MAJOR==Maj) && (H5_VERS_MINOR==Min) && (H5_VERS_RELEASE>=Rel)) ||
//         ((H5_VERS_MAJOR==Maj) && (H5_VERS_MINOR>Min)) ||
//         (H5_VERS_MAJOR>Maj))

// #define H5_VERSION_LE(Maj,Min,Rel)
//        (((H5_VERS_MAJOR==Maj) && (H5_VERS_MINOR==Min) && (H5_VERS_RELEASE<=Rel)) ||
//         ((H5_VERS_MAJOR==Maj) && (H5_VERS_MINOR<Min)) ||
//         (H5_VERS_MAJOR<Maj))

/*
 * Status return values.  Failed integer functions in HDF5 result almost
 * always in a negative value (unsigned failing functions sometimes return
 * zero for failure) while successful return is non-negative (often zero).
 * The negative failure value is most commonly -1, but don't bet on it.  The
 * proper way to detect failure is something like:
 *
 * 	if((dset = H5Dopen2(file, name)) < 0)
 *	    fprintf(stderr, "unable to open the requested dataset\n");
 */


/*
 * Boolean type.  Successful return values are zero (false) or positive
 * (true). The typical true value is 1 but don't bet on it.  Boolean
 * functions cannot fail.  Functions that return `htri_t' however return zero
 * (false), positive (true), or negative (failure). The proper way to test
 * for truth from a htri_t function is:
 *
 * 	if ((retval = H5Tcommitted(type))>0) {
 *	    printf("data type is committed\n");
 *	} else if (!retval) {
 * 	    printf("data type is not committed\n");
 *	} else {
 * 	    printf("error determining whether data type is committed\n");
 *	}
 */
// #ifdef H5_HAVE_STDBOOL_H
//   #include <stdbool.h>
// #else /* H5_HAVE_STDBOOL_H */
// #endif /* H5_HAVE_STDBOOL_H */

/* Define the ssize_t type if it not is defined */
// #if H5_SIZEOF_SSIZE_T==0
/* Undefine this size, we will re-define it in one of the sections below */
// #undef H5_SIZEOF_SSIZE_T
// #if H5_SIZEOF_SIZE_T==H5_SIZEOF_INT
// #elif H5_SIZEOF_SIZE_T==H5_SIZEOF_LONG
// #elif H5_SIZEOF_SIZE_T==H5_SIZEOF_LONG_LONG
// #else /* Can't find matching type for ssize_t */
// #   error "nothing appropriate for ssize_t"
// #endif
// #endif

/*
 * The sizes of file objects have their own types defined here, use a 64-bit
 * type.
 */
// #if H5_SIZEOF_LONG_LONG >= 8
public static final int H5_SIZEOF_HSIZE_T = H5_SIZEOF_LONG_LONG;
public static final int H5_SIZEOF_HSSIZE_T = H5_SIZEOF_LONG_LONG;
// #else
// #   error "nothing appropriate for hsize_t"
// #endif
public static native @MemberGetter int HSIZE_UNDEF();
public static final int HSIZE_UNDEF = HSIZE_UNDEF();

/*
 * File addresses have their own types.
 */
// #if H5_SIZEOF_INT >= 8
public static native @MemberGetter int HADDR_UNDEF();
public static final int HADDR_UNDEF = HADDR_UNDEF();
public static final int H5_SIZEOF_HADDR_T =        H5_SIZEOF_INT;
// #   ifdef H5_HAVE_PARALLEL
// #   endif  /* H5_HAVE_PARALLEL */
// #elif H5_SIZEOF_LONG >= 8
// #   ifdef H5_HAVE_PARALLEL
// #   endif  /* H5_HAVE_PARALLEL */
// #elif H5_SIZEOF_LONG_LONG >= 8
// #   ifdef H5_HAVE_PARALLEL
// #   endif  /* H5_HAVE_PARALLEL */
// #else
// #   error "nothing appropriate for haddr_t"
// #endif
// #if H5_SIZEOF_HADDR_T == H5_SIZEOF_INT
public static final String H5_PRINTF_HADDR_FMT =  "%u";
// #elif H5_SIZEOF_HADDR_T == H5_SIZEOF_LONG
// #elif H5_SIZEOF_HADDR_T == H5_SIZEOF_LONG_LONG
// #else
// #   error "nothing appropriate for H5_PRINTF_HADDR_FMT"
// #endif
public static final int HADDR_MAX =		(HADDR_UNDEF-1);

/* uint32_t type is used for creation order field for messages.  It may be
 * defined in Posix.1g, otherwise it is defined here.
 */
// #if H5_SIZEOF_UINT32_T>=4
// #elif H5_SIZEOF_SHORT>=4
// #elif H5_SIZEOF_INT>=4
// #   undef H5_SIZEOF_UINT32_T
// #elif H5_SIZEOF_LONG>=4
// #   undef H5_SIZEOF_UINT32_T
// #else
// #   error "nothing appropriate for uint32_t"
// #endif

/* int64_t type is used for creation order field for links.  It may be
 * defined in Posix.1g, otherwise it is defined here.
 */
// #if H5_SIZEOF_INT64_T>=8
// #elif H5_SIZEOF_INT>=8
// #elif H5_SIZEOF_LONG>=8
// #   undef H5_SIZEOF_INT64_T
// #elif H5_SIZEOF_LONG_LONG>=8
// #   undef H5_SIZEOF_INT64_T
// #else
// #   error "nothing appropriate for int64_t"
// #endif

/* uint64_t type is used for fields for H5O_info_t.  It may be
 * defined in Posix.1g, otherwise it is defined here.
 */
// #if H5_SIZEOF_UINT64_T>=8
// #elif H5_SIZEOF_INT>=8
// #elif H5_SIZEOF_LONG>=8
// #   undef H5_SIZEOF_UINT64_T
// #elif H5_SIZEOF_LONG_LONG>=8
// #   undef H5_SIZEOF_UINT64_T
// #else
// #   error "nothing appropriate for uint64_t"
// #endif

/* Common iteration orders */
/** enum H5_iter_order_t */
public static final int
    H5_ITER_UNKNOWN = -1,       /* Unknown order */
    H5_ITER_INC = 0,                /* Increasing order */
    H5_ITER_DEC = 1,                /* Decreasing order */
    H5_ITER_NATIVE = 2,             /* No particular order, whatever is fastest */
    H5_ITER_N = 3;		        /* Number of iteration orders */

/* Iteration callback values */
/* (Actually, any positive value will cause the iterator to stop and pass back
 *      that positive value to the function that called the iterator)
 */
public static final int H5_ITER_ERROR =   (-1);
public static final int H5_ITER_CONT =    (0);
public static final int H5_ITER_STOP =    (1);

/*
 * The types of indices on links in groups/attributes on objects.
 * Primarily used for "<do> <foo> by index" routines and for iterating over
 * links in groups/attributes on objects.
 */
/** enum H5_index_t */
public static final int
    H5_INDEX_UNKNOWN = -1,	/* Unknown index type			*/
    H5_INDEX_NAME = 0,		/* Index on names 			*/
    H5_INDEX_CRT_ORDER = 1,		/* Index on creation order 		*/
    H5_INDEX_N = 2;			/* Number of indices defined 		*/
// Targeting ..\H5_ih_info_t.java



/* Tokens are unique and permanent identifiers that are
 * used to reference HDF5 objects in a container. */

/* The maximum size allowed for tokens */
public static final int H5O_MAX_TOKEN_SIZE =      (16);
// Targeting ..\H5O_token_t.java



/* Functions in H5.c */
public static native @Cast("herr_t") int H5open();
public static native @Cast("herr_t") int H5close();
public static native @Cast("herr_t") int H5dont_atexit();
public static native @Cast("herr_t") int H5garbage_collect();
public static native @Cast("herr_t") int H5set_free_list_limits(int reg_global_lim, int reg_list_lim,
                int arr_global_lim, int arr_list_lim, int blk_global_lim,
                int blk_list_lim);
public static native @Cast("herr_t") int H5get_libversion(@Cast("unsigned*") IntPointer majnum, @Cast("unsigned*") IntPointer minnum,
				@Cast("unsigned*") IntPointer relnum);
public static native @Cast("herr_t") int H5get_libversion(@Cast("unsigned*") IntBuffer majnum, @Cast("unsigned*") IntBuffer minnum,
				@Cast("unsigned*") IntBuffer relnum);
public static native @Cast("herr_t") int H5get_libversion(@Cast("unsigned*") int[] majnum, @Cast("unsigned*") int[] minnum,
				@Cast("unsigned*") int[] relnum);
public static native @Cast("herr_t") int H5check_version(@Cast("unsigned") int majnum, @Cast("unsigned") int minnum,
			       @Cast("unsigned") int relnum);
public static native @Cast("herr_t") int H5is_library_threadsafe(@Cast("hbool_t*") BoolPointer is_ts);
public static native @Cast("herr_t") int H5is_library_threadsafe(@Cast("hbool_t*") boolean[] is_ts);
public static native @Cast("herr_t") int H5free_memory(Pointer mem);
public static native Pointer H5allocate_memory(@Cast("size_t") long size, @Cast("hbool_t") boolean clear);
public static native Pointer H5resize_memory(Pointer mem, @Cast("size_t") long size);

// #ifdef __cplusplus
// #endif
// #endif /* _H5public_H */
 



// Parsed from H5Cpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:	H5Cpublic.h
 *              June 4, 2005
 *              John Mainzer
 *
 * Purpose:     Public include file for cache functions.
 *
 * Modifications:
 *
 *-------------------------------------------------------------------------
 */
// #ifndef _H5Cpublic_H
// #define _H5Cpublic_H

/* Public headers needed by this file */
// #include "H5public.h"

// #ifdef __cplusplus
// #endif

/** enum H5C_cache_incr_mode */
public static final int
    H5C_incr__off = 0,
    H5C_incr__threshold = 1;

/** enum H5C_cache_flash_incr_mode */
public static final int
     H5C_flash_incr__off = 0,
     H5C_flash_incr__add_space = 1;

/** enum H5C_cache_decr_mode */
public static final int
    H5C_decr__off = 0,
    H5C_decr__threshold = 1,
    H5C_decr__age_out = 2,
    H5C_decr__age_out_with_threshold = 3;

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from H5Ipublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains function prototypes for each exported function in
 * the H5I module.
 */
// #ifndef _H5Ipublic_H
// #define _H5Ipublic_H

/* Public headers needed by this file */
// #include "H5public.h"

/*
 * Library type values.  Start with `1' instead of `0' because it makes the
 * tracing output look better when hid_t values are large numbers.  Change the
 * TYPE_BITS in H5I.c if the MAXID gets larger than 32 (an assertion will
 * fail otherwise).
 *
 * When adding types here, add a section to the 'misc19' test in test/tmisc.c
 * to verify that the H5I{inc|dec|get}_ref() routines work correctly with it.
 */
/** enum H5I_type_t */
public static final int
    H5I_UNINIT      = (-2),     /* uninitialized type                           */
    H5I_BADID       = (-1),     /* invalid Type                                 */
    H5I_FILE        = 1,        /* type ID for File objects                     */
    H5I_GROUP = 2,                  /* type ID for Group objects                    */
    H5I_DATATYPE = 3,               /* type ID for Datatype objects                 */
    H5I_DATASPACE = 4,              /* type ID for Dataspace objects                */
    H5I_DATASET = 5,                /* type ID for Dataset objects                  */
    H5I_MAP = 6,                    /* type ID for Map objects                      */
    H5I_ATTR = 7,                   /* type ID for Attribute objects                */
    H5I_VFL = 8,                    /* type ID for virtual file layer               */
    H5I_VOL = 9,                    /* type ID for virtual object layer             */
    H5I_GENPROP_CLS = 10,            /* type ID for generic property list classes    */
    H5I_GENPROP_LST = 11,            /* type ID for generic property lists           */
    H5I_ERROR_CLASS = 12,            /* type ID for error classes                    */
    H5I_ERROR_MSG = 13,              /* type ID for error messages                   */
    H5I_ERROR_STACK = 14,            /* type ID for error stacks                     */
    H5I_SPACE_SEL_ITER = 15,         /* type ID for dataspace selection iterator     */
    H5I_NTYPES = 16;                  /* number of library types, MUST BE LAST!       */

/* Type of atoms to return to users */
public static final int H5_SIZEOF_HID_T =         H5_SIZEOF_INT64_T;

/* An invalid object ID. This is also negative for error return. */
public static final int H5I_INVALID_HID =         (-1);
// Targeting ..\H5I_free_t.java


// Targeting ..\H5I_search_func_t.java


// Targeting ..\H5I_iterate_func_t.java



// #ifdef __cplusplus
// #endif

/* Public API functions */

public static native @Cast("hid_t") long H5Iregister(@Cast("H5I_type_t") int type, @Const Pointer object);
public static native Pointer H5Iobject_verify(@Cast("hid_t") long id, @Cast("H5I_type_t") int id_type);
public static native Pointer H5Iremove_verify(@Cast("hid_t") long id, @Cast("H5I_type_t") int id_type);
public static native @Cast("H5I_type_t") int H5Iget_type(@Cast("hid_t") long id);
public static native @Cast("hid_t") long H5Iget_file_id(@Cast("hid_t") long id);
public static native @Cast("ssize_t") long H5Iget_name(@Cast("hid_t") long id, @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Iget_name(@Cast("hid_t") long id, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Iget_name(@Cast("hid_t") long id, @Cast("char*") byte[] name, @Cast("size_t") long size);
public static native int H5Iinc_ref(@Cast("hid_t") long id);
public static native int H5Idec_ref(@Cast("hid_t") long id);
public static native int H5Iget_ref(@Cast("hid_t") long id);
public static native @Cast("H5I_type_t") int H5Iregister_type(@Cast("size_t") long hash_size, @Cast("unsigned") int reserved, H5I_free_t free_func);
public static native @Cast("herr_t") int H5Iclear_type(@Cast("H5I_type_t") int type, @Cast("hbool_t") boolean force);
public static native @Cast("herr_t") int H5Idestroy_type(@Cast("H5I_type_t") int type);
public static native int H5Iinc_type_ref(@Cast("H5I_type_t") int type);
public static native int H5Idec_type_ref(@Cast("H5I_type_t") int type);
public static native int H5Iget_type_ref(@Cast("H5I_type_t") int type);
public static native Pointer H5Isearch(@Cast("H5I_type_t") int type, H5I_search_func_t func, Pointer key);
public static native @Cast("herr_t") int H5Iiterate(@Cast("H5I_type_t") int type, H5I_iterate_func_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Inmembers(@Cast("H5I_type_t") int type, @Cast("hsize_t*") LongPointer num_members);
public static native @Cast("herr_t") int H5Inmembers(@Cast("H5I_type_t") int type, @Cast("hsize_t*") LongBuffer num_members);
public static native @Cast("herr_t") int H5Inmembers(@Cast("H5I_type_t") int type, @Cast("hsize_t*") long[] num_members);
public static native @Cast("htri_t") int H5Itype_exists(@Cast("H5I_type_t") int type);
public static native @Cast("htri_t") int H5Iis_valid(@Cast("hid_t") long id);

// #ifdef __cplusplus
// #endif
// #endif /* _H5Ipublic_H */



// Parsed from H5Tpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5T module.
 */
// #ifndef _H5Tpublic_H
// #define _H5Tpublic_H

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Ipublic.h"

// #define HOFFSET(S,M)    (offsetof(S,M))

/* These are the various classes of datatypes */
/* If this goes over 16 types (0-15), the file format will need to change) */
/** enum H5T_class_t */
public static final int
    H5T_NO_CLASS         = -1,  /*error                                      */
    H5T_INTEGER          = 0,   /*integer types                              */
    H5T_FLOAT            = 1,   /*floating-point types                       */
    H5T_TIME             = 2,   /*date and time types                        */
    H5T_STRING           = 3,   /*character string types                     */
    H5T_BITFIELD         = 4,   /*bit field types                            */
    H5T_OPAQUE           = 5,   /*opaque types                               */
    H5T_COMPOUND         = 6,   /*compound types                             */
    H5T_REFERENCE        = 7,   /*reference types                            */
    H5T_ENUM		  = 8,	/*enumeration types                          */
    H5T_VLEN		  = 9,	/*Variable-Length types                      */
    H5T_ARRAY	          = 10,	/*Array types                                */

    H5T_NCLASSES = 11;                /*this must be last                          */

/* Byte orders */
/** enum H5T_order_t */
public static final int
    H5T_ORDER_ERROR      = -1,  /*error                                      */
    H5T_ORDER_LE         = 0,   /*little endian                              */
    H5T_ORDER_BE         = 1,   /*bit endian                                 */
    H5T_ORDER_VAX        = 2,   /*VAX mixed endian                           */
    H5T_ORDER_MIXED      = 3,   /*Compound type with mixed member orders     */
    H5T_ORDER_NONE       = 4;    /*no particular order (strings, bits,..)     */
    /*H5T_ORDER_NONE must be last */

/* Types of integer sign schemes */
/** enum H5T_sign_t */
public static final int
    H5T_SGN_ERROR        = -1,  /*error                                      */
    H5T_SGN_NONE         = 0,   /*this is an unsigned type                   */
    H5T_SGN_2            = 1,   /*two's complement                           */

    H5T_NSGN             = 2;    /*this must be last!                         */

/* Floating-point normalization schemes */
/** enum H5T_norm_t */
public static final int
    H5T_NORM_ERROR       = -1,  /*error                                      */
    H5T_NORM_IMPLIED     = 0,   /*msb of mantissa isn't stored, always 1     */
    H5T_NORM_MSBSET      = 1,   /*msb of mantissa is always 1                */
    H5T_NORM_NONE        = 2;    /*not normalized                             */
    /*H5T_NORM_NONE must be last */

/*
 * Character set to use for text strings.  Do not change these values since
 * they appear in HDF5 files!
 */
/** enum H5T_cset_t */
public static final int
    H5T_CSET_ERROR       = -1,  /*error                                      */
    H5T_CSET_ASCII       = 0,   /*US ASCII                                   */
    H5T_CSET_UTF8        = 1,   /*UTF-8 Unicode encoding		     */
    H5T_CSET_RESERVED_2  = 2,   /*reserved for later use		     */
    H5T_CSET_RESERVED_3  = 3,   /*reserved for later use		     */
    H5T_CSET_RESERVED_4  = 4,   /*reserved for later use		     */
    H5T_CSET_RESERVED_5  = 5,   /*reserved for later use		     */
    H5T_CSET_RESERVED_6  = 6,   /*reserved for later use		     */
    H5T_CSET_RESERVED_7  = 7,   /*reserved for later use		     */
    H5T_CSET_RESERVED_8  = 8,   /*reserved for later use		     */
    H5T_CSET_RESERVED_9  = 9,   /*reserved for later use		     */
    H5T_CSET_RESERVED_10 = 10,  /*reserved for later use		     */
    H5T_CSET_RESERVED_11 = 11,  /*reserved for later use		     */
    H5T_CSET_RESERVED_12 = 12,  /*reserved for later use		     */
    H5T_CSET_RESERVED_13 = 13,  /*reserved for later use		     */
    H5T_CSET_RESERVED_14 = 14,  /*reserved for later use		     */
    H5T_CSET_RESERVED_15 = 15;   /*reserved for later use		     */
public static final int H5T_NCSET = H5T_CSET_RESERVED_2;    		/*Number of character sets actually defined  */

/*
 * Type of padding to use in character strings.  Do not change these values
 * since they appear in HDF5 files!
 */
/** enum H5T_str_t */
public static final int
    H5T_STR_ERROR        = -1,  /*error                                      */
    H5T_STR_NULLTERM     = 0,   /*null terminate like in C                   */
    H5T_STR_NULLPAD      = 1,   /*pad with nulls                             */
    H5T_STR_SPACEPAD     = 2,   /*pad with spaces like in Fortran            */
    H5T_STR_RESERVED_3   = 3,   /*reserved for later use		     */
    H5T_STR_RESERVED_4   = 4,   /*reserved for later use		     */
    H5T_STR_RESERVED_5   = 5,   /*reserved for later use		     */
    H5T_STR_RESERVED_6   = 6,   /*reserved for later use		     */
    H5T_STR_RESERVED_7   = 7,   /*reserved for later use		     */
    H5T_STR_RESERVED_8   = 8,   /*reserved for later use		     */
    H5T_STR_RESERVED_9   = 9,   /*reserved for later use		     */
    H5T_STR_RESERVED_10  = 10,  /*reserved for later use		     */
    H5T_STR_RESERVED_11  = 11,  /*reserved for later use		     */
    H5T_STR_RESERVED_12  = 12,  /*reserved for later use		     */
    H5T_STR_RESERVED_13  = 13,  /*reserved for later use		     */
    H5T_STR_RESERVED_14  = 14,  /*reserved for later use		     */
    H5T_STR_RESERVED_15  = 15;   /*reserved for later use		     */
public static final int H5T_NSTR = H5T_STR_RESERVED_3;		/*num H5T_str_t types actually defined	     */

/* Type of padding to use in other atomic types */
/** enum H5T_pad_t */
public static final int
    H5T_PAD_ERROR        = -1,  /*error                                      */
    H5T_PAD_ZERO         = 0,   /*always set to zero                         */
    H5T_PAD_ONE          = 1,   /*always set to one                          */
    H5T_PAD_BACKGROUND   = 2,   /*set to background value                    */

    H5T_NPAD             = 3;    /*THIS MUST BE LAST                          */

/* Commands sent to conversion functions */
/** enum H5T_cmd_t */
public static final int
    H5T_CONV_INIT	 = 0,	/*query and/or initialize private data	     */
    H5T_CONV_CONV	 = 1, 	/*convert data from source to dest datatype */
    H5T_CONV_FREE	 = 2;	/*function is being removed from path	     */

/* How is the `bkg' buffer used by the conversion function? */
/** enum H5T_bkg_t */
public static final int
    H5T_BKG_NO		 = 0, 	/*background buffer is not needed, send NULL */
    H5T_BKG_TEMP	 = 1,	/*bkg buffer used as temp storage only       */
    H5T_BKG_YES		 = 2;	/*init bkg buf with data before conversion   */
// Targeting ..\H5T_cdata_t.java



/* Conversion function persistence */
/** enum H5T_pers_t */
public static final int
    H5T_PERS_DONTCARE	 = -1, 	/*wild card				     */
    H5T_PERS_HARD	 = 0,	/*hard conversion function		     */
    H5T_PERS_SOFT	 = 1; 	/*soft conversion function		     */

/* The order to retrieve atomic native datatype */
/** enum H5T_direction_t */
public static final int
    H5T_DIR_DEFAULT     = 0,    /*default direction is inscendent            */
    H5T_DIR_ASCEND      = 1,    /*in inscendent order                        */
    H5T_DIR_DESCEND     = 2;     /*in descendent order                        */

/* The exception type passed into the conversion callback function */
/** enum H5T_conv_except_t */
public static final int
    H5T_CONV_EXCEPT_RANGE_HI       = 0,   /*source value is greater than destination's range */
    H5T_CONV_EXCEPT_RANGE_LOW      = 1,   /*source value is less than destination's range    */
    H5T_CONV_EXCEPT_PRECISION      = 2,   /*source value loses precision in destination      */
    H5T_CONV_EXCEPT_TRUNCATE       = 3,   /*source value is truncated in destination         */
    H5T_CONV_EXCEPT_PINF           = 4,   /*source value is positive infinity(floating number) */
    H5T_CONV_EXCEPT_NINF           = 5,   /*source value is negative infinity(floating number) */
    H5T_CONV_EXCEPT_NAN            = 6;    /*source value is NaN(floating number)             */

/* The return value from conversion callback function H5T_conv_except_func_t */
/** enum H5T_conv_ret_t */
public static final int
    H5T_CONV_ABORT      = -1,   /*abort conversion                           */
    H5T_CONV_UNHANDLED  = 0,    /*callback function failed to handle the exception      */
    H5T_CONV_HANDLED    = 1;     /*callback function handled the exception successfully  */
// Targeting ..\hvl_t.java



/* Variable Length String information */
public static native @MemberGetter int H5T_VARIABLE();
public static final int H5T_VARIABLE = H5T_VARIABLE();  /* Indicate that a string is variable length (null-terminated in C, instead of fixed length) */

/* Opaque information */
public static final int H5T_OPAQUE_TAG_MAX =      256;     /* Maximum length of an opaque tag */
                                        /* This could be raised without too much difficulty */

// #ifdef __cplusplus
// Targeting ..\H5T_conv_t.java


// Targeting ..\H5T_conv_except_func_t.java



/* When this header is included from a private header, don't make calls to H5open() */
// #undef H5OPEN
// #ifndef _H5private_H
// #define H5OPEN          H5open(),
// #else   /* _H5private_H */
// #define H5OPEN
// #endif  /* _H5private_H */

/*
 * The IEEE floating point types in various byte orders.
 */
public static native @MemberGetter int H5T_IEEE_F32BE();
public static final int H5T_IEEE_F32BE = H5T_IEEE_F32BE();
public static native @MemberGetter int H5T_IEEE_F32LE();
public static final int H5T_IEEE_F32LE = H5T_IEEE_F32LE();
public static native @MemberGetter int H5T_IEEE_F64BE();
public static final int H5T_IEEE_F64BE = H5T_IEEE_F64BE();
public static native @MemberGetter int H5T_IEEE_F64LE();
public static final int H5T_IEEE_F64LE = H5T_IEEE_F64LE();
public static native @Cast("hid_t") long H5T_IEEE_F32BE_g(); public static native void H5T_IEEE_F32BE_g(long setter);
public static native @Cast("hid_t") long H5T_IEEE_F32LE_g(); public static native void H5T_IEEE_F32LE_g(long setter);
public static native @Cast("hid_t") long H5T_IEEE_F64BE_g(); public static native void H5T_IEEE_F64BE_g(long setter);
public static native @Cast("hid_t") long H5T_IEEE_F64LE_g(); public static native void H5T_IEEE_F64LE_g(long setter);

/*
 * These are "standard" types.  For instance, signed (2's complement) and
 * unsigned integers of various sizes and byte orders.
 */
public static native @MemberGetter int H5T_STD_I8BE();
public static final int H5T_STD_I8BE = H5T_STD_I8BE();
public static native @MemberGetter int H5T_STD_I8LE();
public static final int H5T_STD_I8LE = H5T_STD_I8LE();
public static native @MemberGetter int H5T_STD_I16BE();
public static final int H5T_STD_I16BE = H5T_STD_I16BE();
public static native @MemberGetter int H5T_STD_I16LE();
public static final int H5T_STD_I16LE = H5T_STD_I16LE();
public static native @MemberGetter int H5T_STD_I32BE();
public static final int H5T_STD_I32BE = H5T_STD_I32BE();
public static native @MemberGetter int H5T_STD_I32LE();
public static final int H5T_STD_I32LE = H5T_STD_I32LE();
public static native @MemberGetter int H5T_STD_I64BE();
public static final int H5T_STD_I64BE = H5T_STD_I64BE();
public static native @MemberGetter int H5T_STD_I64LE();
public static final int H5T_STD_I64LE = H5T_STD_I64LE();
public static native @MemberGetter int H5T_STD_U8BE();
public static final int H5T_STD_U8BE = H5T_STD_U8BE();
public static native @MemberGetter int H5T_STD_U8LE();
public static final int H5T_STD_U8LE = H5T_STD_U8LE();
public static native @MemberGetter int H5T_STD_U16BE();
public static final int H5T_STD_U16BE = H5T_STD_U16BE();
public static native @MemberGetter int H5T_STD_U16LE();
public static final int H5T_STD_U16LE = H5T_STD_U16LE();
public static native @MemberGetter int H5T_STD_U32BE();
public static final int H5T_STD_U32BE = H5T_STD_U32BE();
public static native @MemberGetter int H5T_STD_U32LE();
public static final int H5T_STD_U32LE = H5T_STD_U32LE();
public static native @MemberGetter int H5T_STD_U64BE();
public static final int H5T_STD_U64BE = H5T_STD_U64BE();
public static native @MemberGetter int H5T_STD_U64LE();
public static final int H5T_STD_U64LE = H5T_STD_U64LE();
public static native @MemberGetter int H5T_STD_B8BE();
public static final int H5T_STD_B8BE = H5T_STD_B8BE();
public static native @MemberGetter int H5T_STD_B8LE();
public static final int H5T_STD_B8LE = H5T_STD_B8LE();
public static native @MemberGetter int H5T_STD_B16BE();
public static final int H5T_STD_B16BE = H5T_STD_B16BE();
public static native @MemberGetter int H5T_STD_B16LE();
public static final int H5T_STD_B16LE = H5T_STD_B16LE();
public static native @MemberGetter int H5T_STD_B32BE();
public static final int H5T_STD_B32BE = H5T_STD_B32BE();
public static native @MemberGetter int H5T_STD_B32LE();
public static final int H5T_STD_B32LE = H5T_STD_B32LE();
public static native @MemberGetter int H5T_STD_B64BE();
public static final int H5T_STD_B64BE = H5T_STD_B64BE();
public static native @MemberGetter int H5T_STD_B64LE();
public static final int H5T_STD_B64LE = H5T_STD_B64LE();
public static native @MemberGetter int H5T_STD_REF_OBJ();
public static final int H5T_STD_REF_OBJ = H5T_STD_REF_OBJ();
public static native @MemberGetter int H5T_STD_REF_DSETREG();
public static final int H5T_STD_REF_DSETREG = H5T_STD_REF_DSETREG();
public static native @MemberGetter int H5T_STD_REF();
public static final int H5T_STD_REF = H5T_STD_REF();
public static native @Cast("hid_t") long H5T_STD_I8BE_g(); public static native void H5T_STD_I8BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I8LE_g(); public static native void H5T_STD_I8LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I16BE_g(); public static native void H5T_STD_I16BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I16LE_g(); public static native void H5T_STD_I16LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I32BE_g(); public static native void H5T_STD_I32BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I32LE_g(); public static native void H5T_STD_I32LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I64BE_g(); public static native void H5T_STD_I64BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I64LE_g(); public static native void H5T_STD_I64LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U8BE_g(); public static native void H5T_STD_U8BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U8LE_g(); public static native void H5T_STD_U8LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U16BE_g(); public static native void H5T_STD_U16BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U16LE_g(); public static native void H5T_STD_U16LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U32BE_g(); public static native void H5T_STD_U32BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U32LE_g(); public static native void H5T_STD_U32LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U64BE_g(); public static native void H5T_STD_U64BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U64LE_g(); public static native void H5T_STD_U64LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B8BE_g(); public static native void H5T_STD_B8BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B8LE_g(); public static native void H5T_STD_B8LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B16BE_g(); public static native void H5T_STD_B16BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B16LE_g(); public static native void H5T_STD_B16LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B32BE_g(); public static native void H5T_STD_B32BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B32LE_g(); public static native void H5T_STD_B32LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B64BE_g(); public static native void H5T_STD_B64BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B64LE_g(); public static native void H5T_STD_B64LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_REF_OBJ_g(); public static native void H5T_STD_REF_OBJ_g(long setter);
public static native @Cast("hid_t") long H5T_STD_REF_DSETREG_g(); public static native void H5T_STD_REF_DSETREG_g(long setter);
public static native @Cast("hid_t") long H5T_STD_REF_g(); public static native void H5T_STD_REF_g(long setter);

/*
 * Types which are particular to Unix.
 */
public static native @MemberGetter int H5T_UNIX_D32BE();
public static final int H5T_UNIX_D32BE = H5T_UNIX_D32BE();
public static native @MemberGetter int H5T_UNIX_D32LE();
public static final int H5T_UNIX_D32LE = H5T_UNIX_D32LE();
public static native @MemberGetter int H5T_UNIX_D64BE();
public static final int H5T_UNIX_D64BE = H5T_UNIX_D64BE();
public static native @MemberGetter int H5T_UNIX_D64LE();
public static final int H5T_UNIX_D64LE = H5T_UNIX_D64LE();
public static native @Cast("hid_t") long H5T_UNIX_D32BE_g(); public static native void H5T_UNIX_D32BE_g(long setter);
public static native @Cast("hid_t") long H5T_UNIX_D32LE_g(); public static native void H5T_UNIX_D32LE_g(long setter);
public static native @Cast("hid_t") long H5T_UNIX_D64BE_g(); public static native void H5T_UNIX_D64BE_g(long setter);
public static native @Cast("hid_t") long H5T_UNIX_D64LE_g(); public static native void H5T_UNIX_D64LE_g(long setter);

/*
 * Types particular to the C language.  String types use `bytes' instead
 * of `bits' as their size.
 */
public static native @MemberGetter int H5T_C_S1();
public static final int H5T_C_S1 = H5T_C_S1();
public static native @Cast("hid_t") long H5T_C_S1_g(); public static native void H5T_C_S1_g(long setter);

/*
 * Types particular to Fortran.
 */
public static native @MemberGetter int H5T_FORTRAN_S1();
public static final int H5T_FORTRAN_S1 = H5T_FORTRAN_S1();
public static native @Cast("hid_t") long H5T_FORTRAN_S1_g(); public static native void H5T_FORTRAN_S1_g(long setter);

/*
 * These types are for Intel CPU's.  They are little endian with IEEE
 * floating point.
 */
public static native @MemberGetter int H5T_INTEL_I8();
public static final int H5T_INTEL_I8 = H5T_INTEL_I8();
public static native @MemberGetter int H5T_INTEL_I16();
public static final int H5T_INTEL_I16 = H5T_INTEL_I16();
public static native @MemberGetter int H5T_INTEL_I32();
public static final int H5T_INTEL_I32 = H5T_INTEL_I32();
public static native @MemberGetter int H5T_INTEL_I64();
public static final int H5T_INTEL_I64 = H5T_INTEL_I64();
public static native @MemberGetter int H5T_INTEL_U8();
public static final int H5T_INTEL_U8 = H5T_INTEL_U8();
public static native @MemberGetter int H5T_INTEL_U16();
public static final int H5T_INTEL_U16 = H5T_INTEL_U16();
public static native @MemberGetter int H5T_INTEL_U32();
public static final int H5T_INTEL_U32 = H5T_INTEL_U32();
public static native @MemberGetter int H5T_INTEL_U64();
public static final int H5T_INTEL_U64 = H5T_INTEL_U64();
public static native @MemberGetter int H5T_INTEL_B8();
public static final int H5T_INTEL_B8 = H5T_INTEL_B8();
public static native @MemberGetter int H5T_INTEL_B16();
public static final int H5T_INTEL_B16 = H5T_INTEL_B16();
public static native @MemberGetter int H5T_INTEL_B32();
public static final int H5T_INTEL_B32 = H5T_INTEL_B32();
public static native @MemberGetter int H5T_INTEL_B64();
public static final int H5T_INTEL_B64 = H5T_INTEL_B64();
public static native @MemberGetter int H5T_INTEL_F32();
public static final int H5T_INTEL_F32 = H5T_INTEL_F32();
public static native @MemberGetter int H5T_INTEL_F64();
public static final int H5T_INTEL_F64 = H5T_INTEL_F64();

/*
 * These types are for DEC Alpha CPU's.  They are little endian with IEEE
 * floating point.
 */
public static native @MemberGetter int H5T_ALPHA_I8();
public static final int H5T_ALPHA_I8 = H5T_ALPHA_I8();
public static native @MemberGetter int H5T_ALPHA_I16();
public static final int H5T_ALPHA_I16 = H5T_ALPHA_I16();
public static native @MemberGetter int H5T_ALPHA_I32();
public static final int H5T_ALPHA_I32 = H5T_ALPHA_I32();
public static native @MemberGetter int H5T_ALPHA_I64();
public static final int H5T_ALPHA_I64 = H5T_ALPHA_I64();
public static native @MemberGetter int H5T_ALPHA_U8();
public static final int H5T_ALPHA_U8 = H5T_ALPHA_U8();
public static native @MemberGetter int H5T_ALPHA_U16();
public static final int H5T_ALPHA_U16 = H5T_ALPHA_U16();
public static native @MemberGetter int H5T_ALPHA_U32();
public static final int H5T_ALPHA_U32 = H5T_ALPHA_U32();
public static native @MemberGetter int H5T_ALPHA_U64();
public static final int H5T_ALPHA_U64 = H5T_ALPHA_U64();
public static native @MemberGetter int H5T_ALPHA_B8();
public static final int H5T_ALPHA_B8 = H5T_ALPHA_B8();
public static native @MemberGetter int H5T_ALPHA_B16();
public static final int H5T_ALPHA_B16 = H5T_ALPHA_B16();
public static native @MemberGetter int H5T_ALPHA_B32();
public static final int H5T_ALPHA_B32 = H5T_ALPHA_B32();
public static native @MemberGetter int H5T_ALPHA_B64();
public static final int H5T_ALPHA_B64 = H5T_ALPHA_B64();
public static native @MemberGetter int H5T_ALPHA_F32();
public static final int H5T_ALPHA_F32 = H5T_ALPHA_F32();
public static native @MemberGetter int H5T_ALPHA_F64();
public static final int H5T_ALPHA_F64 = H5T_ALPHA_F64();

/*
 * These types are for MIPS cpu's commonly used in SGI systems. They are big
 * endian with IEEE floating point.
 */
public static native @MemberGetter int H5T_MIPS_I8();
public static final int H5T_MIPS_I8 = H5T_MIPS_I8();
public static native @MemberGetter int H5T_MIPS_I16();
public static final int H5T_MIPS_I16 = H5T_MIPS_I16();
public static native @MemberGetter int H5T_MIPS_I32();
public static final int H5T_MIPS_I32 = H5T_MIPS_I32();
public static native @MemberGetter int H5T_MIPS_I64();
public static final int H5T_MIPS_I64 = H5T_MIPS_I64();
public static native @MemberGetter int H5T_MIPS_U8();
public static final int H5T_MIPS_U8 = H5T_MIPS_U8();
public static native @MemberGetter int H5T_MIPS_U16();
public static final int H5T_MIPS_U16 = H5T_MIPS_U16();
public static native @MemberGetter int H5T_MIPS_U32();
public static final int H5T_MIPS_U32 = H5T_MIPS_U32();
public static native @MemberGetter int H5T_MIPS_U64();
public static final int H5T_MIPS_U64 = H5T_MIPS_U64();
public static native @MemberGetter int H5T_MIPS_B8();
public static final int H5T_MIPS_B8 = H5T_MIPS_B8();
public static native @MemberGetter int H5T_MIPS_B16();
public static final int H5T_MIPS_B16 = H5T_MIPS_B16();
public static native @MemberGetter int H5T_MIPS_B32();
public static final int H5T_MIPS_B32 = H5T_MIPS_B32();
public static native @MemberGetter int H5T_MIPS_B64();
public static final int H5T_MIPS_B64 = H5T_MIPS_B64();
public static native @MemberGetter int H5T_MIPS_F32();
public static final int H5T_MIPS_F32 = H5T_MIPS_F32();
public static native @MemberGetter int H5T_MIPS_F64();
public static final int H5T_MIPS_F64 = H5T_MIPS_F64();

/*
 * The VAX floating point types (i.e. in VAX byte order)
 */
public static native @MemberGetter int H5T_VAX_F32();
public static final int H5T_VAX_F32 = H5T_VAX_F32();
public static native @MemberGetter int H5T_VAX_F64();
public static final int H5T_VAX_F64 = H5T_VAX_F64();
public static native @Cast("hid_t") long H5T_VAX_F32_g(); public static native void H5T_VAX_F32_g(long setter);
public static native @Cast("hid_t") long H5T_VAX_F64_g(); public static native void H5T_VAX_F64_g(long setter);

/*
 * The predefined native types. These are the types detected by H5detect and
 * they violate the naming scheme a little.  Instead of a class name,
 * precision and byte order as the last component, they have a C-like type
 * name.  If the type begins with `U' then it is the unsigned version of the
 * integer type; other integer types are signed.  The type LLONG corresponds
 * to C's `long long' and LDOUBLE is `long double' (these types might be the
 * same as `LONG' and `DOUBLE' respectively).
 */
public static native @MemberGetter int H5T_NATIVE_CHAR();
public static final int H5T_NATIVE_CHAR = H5T_NATIVE_CHAR();
public static native @MemberGetter int H5T_NATIVE_SCHAR();
public static final int H5T_NATIVE_SCHAR = H5T_NATIVE_SCHAR();
public static native @MemberGetter int H5T_NATIVE_UCHAR();
public static final int H5T_NATIVE_UCHAR = H5T_NATIVE_UCHAR();
public static native @MemberGetter int H5T_NATIVE_SHORT();
public static final int H5T_NATIVE_SHORT = H5T_NATIVE_SHORT();
public static native @MemberGetter int H5T_NATIVE_USHORT();
public static final int H5T_NATIVE_USHORT = H5T_NATIVE_USHORT();
public static native @MemberGetter int H5T_NATIVE_INT();
public static final int H5T_NATIVE_INT = H5T_NATIVE_INT();
public static native @MemberGetter int H5T_NATIVE_UINT();
public static final int H5T_NATIVE_UINT = H5T_NATIVE_UINT();
public static native @MemberGetter int H5T_NATIVE_LONG();
public static final int H5T_NATIVE_LONG = H5T_NATIVE_LONG();
public static native @MemberGetter int H5T_NATIVE_ULONG();
public static final int H5T_NATIVE_ULONG = H5T_NATIVE_ULONG();
public static native @MemberGetter int H5T_NATIVE_LLONG();
public static final int H5T_NATIVE_LLONG = H5T_NATIVE_LLONG();
public static native @MemberGetter int H5T_NATIVE_ULLONG();
public static final int H5T_NATIVE_ULLONG = H5T_NATIVE_ULLONG();
public static native @MemberGetter int H5T_NATIVE_FLOAT();
public static final int H5T_NATIVE_FLOAT = H5T_NATIVE_FLOAT();
public static native @MemberGetter int H5T_NATIVE_DOUBLE();
public static final int H5T_NATIVE_DOUBLE = H5T_NATIVE_DOUBLE();
// #if H5_SIZEOF_LONG_DOUBLE !=0
public static native @MemberGetter int H5T_NATIVE_LDOUBLE();
public static final int H5T_NATIVE_LDOUBLE = H5T_NATIVE_LDOUBLE();
// #endif
public static native @MemberGetter int H5T_NATIVE_B8();
public static final int H5T_NATIVE_B8 = H5T_NATIVE_B8();
public static native @MemberGetter int H5T_NATIVE_B16();
public static final int H5T_NATIVE_B16 = H5T_NATIVE_B16();
public static native @MemberGetter int H5T_NATIVE_B32();
public static final int H5T_NATIVE_B32 = H5T_NATIVE_B32();
public static native @MemberGetter int H5T_NATIVE_B64();
public static final int H5T_NATIVE_B64 = H5T_NATIVE_B64();
public static native @MemberGetter int H5T_NATIVE_OPAQUE();
public static final int H5T_NATIVE_OPAQUE = H5T_NATIVE_OPAQUE();
public static native @MemberGetter int H5T_NATIVE_HADDR();
public static final int H5T_NATIVE_HADDR = H5T_NATIVE_HADDR();
public static native @MemberGetter int H5T_NATIVE_HSIZE();
public static final int H5T_NATIVE_HSIZE = H5T_NATIVE_HSIZE();
public static native @MemberGetter int H5T_NATIVE_HSSIZE();
public static final int H5T_NATIVE_HSSIZE = H5T_NATIVE_HSSIZE();
public static native @MemberGetter int H5T_NATIVE_HERR();
public static final int H5T_NATIVE_HERR = H5T_NATIVE_HERR();
public static native @MemberGetter int H5T_NATIVE_HBOOL();
public static final int H5T_NATIVE_HBOOL = H5T_NATIVE_HBOOL();
public static native @Cast("hid_t") long H5T_NATIVE_SCHAR_g(); public static native void H5T_NATIVE_SCHAR_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UCHAR_g(); public static native void H5T_NATIVE_UCHAR_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_SHORT_g(); public static native void H5T_NATIVE_SHORT_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_USHORT_g(); public static native void H5T_NATIVE_USHORT_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_g(); public static native void H5T_NATIVE_INT_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_g(); public static native void H5T_NATIVE_UINT_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_LONG_g(); public static native void H5T_NATIVE_LONG_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_ULONG_g(); public static native void H5T_NATIVE_ULONG_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_LLONG_g(); public static native void H5T_NATIVE_LLONG_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_ULLONG_g(); public static native void H5T_NATIVE_ULLONG_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_FLOAT_g(); public static native void H5T_NATIVE_FLOAT_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_DOUBLE_g(); public static native void H5T_NATIVE_DOUBLE_g(long setter);
// #if H5_SIZEOF_LONG_DOUBLE !=0
public static native @Cast("hid_t") long H5T_NATIVE_LDOUBLE_g(); public static native void H5T_NATIVE_LDOUBLE_g(long setter);
// #endif
public static native @Cast("hid_t") long H5T_NATIVE_B8_g(); public static native void H5T_NATIVE_B8_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_B16_g(); public static native void H5T_NATIVE_B16_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_B32_g(); public static native void H5T_NATIVE_B32_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_B64_g(); public static native void H5T_NATIVE_B64_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_OPAQUE_g(); public static native void H5T_NATIVE_OPAQUE_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_HADDR_g(); public static native void H5T_NATIVE_HADDR_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_HSIZE_g(); public static native void H5T_NATIVE_HSIZE_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_HSSIZE_g(); public static native void H5T_NATIVE_HSSIZE_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_HERR_g(); public static native void H5T_NATIVE_HERR_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_HBOOL_g(); public static native void H5T_NATIVE_HBOOL_g(long setter);

/* C9x integer types */
public static native @MemberGetter int H5T_NATIVE_INT8();
public static final int H5T_NATIVE_INT8 = H5T_NATIVE_INT8();
public static native @MemberGetter int H5T_NATIVE_UINT8();
public static final int H5T_NATIVE_UINT8 = H5T_NATIVE_UINT8();
public static native @MemberGetter int H5T_NATIVE_INT_LEAST8();
public static final int H5T_NATIVE_INT_LEAST8 = H5T_NATIVE_INT_LEAST8();
public static native @MemberGetter int H5T_NATIVE_UINT_LEAST8();
public static final int H5T_NATIVE_UINT_LEAST8 = H5T_NATIVE_UINT_LEAST8();
public static native @MemberGetter int H5T_NATIVE_INT_FAST8();
public static final int H5T_NATIVE_INT_FAST8 = H5T_NATIVE_INT_FAST8();
public static native @MemberGetter int H5T_NATIVE_UINT_FAST8();
public static final int H5T_NATIVE_UINT_FAST8 = H5T_NATIVE_UINT_FAST8();
public static native @Cast("hid_t") long H5T_NATIVE_INT8_g(); public static native void H5T_NATIVE_INT8_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT8_g(); public static native void H5T_NATIVE_UINT8_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_LEAST8_g(); public static native void H5T_NATIVE_INT_LEAST8_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_LEAST8_g(); public static native void H5T_NATIVE_UINT_LEAST8_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_FAST8_g(); public static native void H5T_NATIVE_INT_FAST8_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_FAST8_g(); public static native void H5T_NATIVE_UINT_FAST8_g(long setter);

public static native @MemberGetter int H5T_NATIVE_INT16();
public static final int H5T_NATIVE_INT16 = H5T_NATIVE_INT16();
public static native @MemberGetter int H5T_NATIVE_UINT16();
public static final int H5T_NATIVE_UINT16 = H5T_NATIVE_UINT16();
public static native @MemberGetter int H5T_NATIVE_INT_LEAST16();
public static final int H5T_NATIVE_INT_LEAST16 = H5T_NATIVE_INT_LEAST16();
public static native @MemberGetter int H5T_NATIVE_UINT_LEAST16();
public static final int H5T_NATIVE_UINT_LEAST16 = H5T_NATIVE_UINT_LEAST16();
public static native @MemberGetter int H5T_NATIVE_INT_FAST16();
public static final int H5T_NATIVE_INT_FAST16 = H5T_NATIVE_INT_FAST16();
public static native @MemberGetter int H5T_NATIVE_UINT_FAST16();
public static final int H5T_NATIVE_UINT_FAST16 = H5T_NATIVE_UINT_FAST16();
public static native @Cast("hid_t") long H5T_NATIVE_INT16_g(); public static native void H5T_NATIVE_INT16_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT16_g(); public static native void H5T_NATIVE_UINT16_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_LEAST16_g(); public static native void H5T_NATIVE_INT_LEAST16_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_LEAST16_g(); public static native void H5T_NATIVE_UINT_LEAST16_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_FAST16_g(); public static native void H5T_NATIVE_INT_FAST16_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_FAST16_g(); public static native void H5T_NATIVE_UINT_FAST16_g(long setter);

public static native @MemberGetter int H5T_NATIVE_INT32();
public static final int H5T_NATIVE_INT32 = H5T_NATIVE_INT32();
public static native @MemberGetter int H5T_NATIVE_UINT32();
public static final int H5T_NATIVE_UINT32 = H5T_NATIVE_UINT32();
public static native @MemberGetter int H5T_NATIVE_INT_LEAST32();
public static final int H5T_NATIVE_INT_LEAST32 = H5T_NATIVE_INT_LEAST32();
public static native @MemberGetter int H5T_NATIVE_UINT_LEAST32();
public static final int H5T_NATIVE_UINT_LEAST32 = H5T_NATIVE_UINT_LEAST32();
public static native @MemberGetter int H5T_NATIVE_INT_FAST32();
public static final int H5T_NATIVE_INT_FAST32 = H5T_NATIVE_INT_FAST32();
public static native @MemberGetter int H5T_NATIVE_UINT_FAST32();
public static final int H5T_NATIVE_UINT_FAST32 = H5T_NATIVE_UINT_FAST32();
public static native @Cast("hid_t") long H5T_NATIVE_INT32_g(); public static native void H5T_NATIVE_INT32_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT32_g(); public static native void H5T_NATIVE_UINT32_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_LEAST32_g(); public static native void H5T_NATIVE_INT_LEAST32_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_LEAST32_g(); public static native void H5T_NATIVE_UINT_LEAST32_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_FAST32_g(); public static native void H5T_NATIVE_INT_FAST32_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_FAST32_g(); public static native void H5T_NATIVE_UINT_FAST32_g(long setter);

public static native @MemberGetter int H5T_NATIVE_INT64();
public static final int H5T_NATIVE_INT64 = H5T_NATIVE_INT64();
public static native @MemberGetter int H5T_NATIVE_UINT64();
public static final int H5T_NATIVE_UINT64 = H5T_NATIVE_UINT64();
public static native @MemberGetter int H5T_NATIVE_INT_LEAST64();
public static final int H5T_NATIVE_INT_LEAST64 = H5T_NATIVE_INT_LEAST64();
public static native @MemberGetter int H5T_NATIVE_UINT_LEAST64();
public static final int H5T_NATIVE_UINT_LEAST64 = H5T_NATIVE_UINT_LEAST64();
public static native @MemberGetter int H5T_NATIVE_INT_FAST64();
public static final int H5T_NATIVE_INT_FAST64 = H5T_NATIVE_INT_FAST64();
public static native @MemberGetter int H5T_NATIVE_UINT_FAST64();
public static final int H5T_NATIVE_UINT_FAST64 = H5T_NATIVE_UINT_FAST64();
public static native @Cast("hid_t") long H5T_NATIVE_INT64_g(); public static native void H5T_NATIVE_INT64_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT64_g(); public static native void H5T_NATIVE_UINT64_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_LEAST64_g(); public static native void H5T_NATIVE_INT_LEAST64_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_LEAST64_g(); public static native void H5T_NATIVE_UINT_LEAST64_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_FAST64_g(); public static native void H5T_NATIVE_INT_FAST64_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_FAST64_g(); public static native void H5T_NATIVE_UINT_FAST64_g(long setter);

/* Operations defined on all datatypes */
public static native @Cast("hid_t") long H5Tcreate(@Cast("H5T_class_t") int type, @Cast("size_t") long size);
public static native @Cast("hid_t") long H5Tcopy(@Cast("hid_t") long type_id);
public static native @Cast("herr_t") int H5Tclose(@Cast("hid_t") long type_id);
public static native @Cast("htri_t") int H5Tequal(@Cast("hid_t") long type1_id, @Cast("hid_t") long type2_id);
public static native @Cast("herr_t") int H5Tlock(@Cast("hid_t") long type_id);
public static native @Cast("herr_t") int H5Tcommit2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long type_id,
    @Cast("hid_t") long lcpl_id, @Cast("hid_t") long tcpl_id, @Cast("hid_t") long tapl_id);
public static native @Cast("herr_t") int H5Tcommit2(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long type_id,
    @Cast("hid_t") long lcpl_id, @Cast("hid_t") long tcpl_id, @Cast("hid_t") long tapl_id);
public static native @Cast("hid_t") long H5Topen2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long tapl_id);
public static native @Cast("hid_t") long H5Topen2(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long tapl_id);
public static native @Cast("herr_t") int H5Tcommit_anon(@Cast("hid_t") long loc_id, @Cast("hid_t") long type_id, @Cast("hid_t") long tcpl_id, @Cast("hid_t") long tapl_id);
public static native @Cast("hid_t") long H5Tget_create_plist(@Cast("hid_t") long type_id);
public static native @Cast("htri_t") int H5Tcommitted(@Cast("hid_t") long type_id);
public static native @Cast("herr_t") int H5Tencode(@Cast("hid_t") long obj_id, Pointer buf, @Cast("size_t*") SizeTPointer nalloc);
public static native @Cast("hid_t") long H5Tdecode(@Const Pointer buf);
public static native @Cast("herr_t") int H5Tflush(@Cast("hid_t") long type_id);
public static native @Cast("herr_t") int H5Trefresh(@Cast("hid_t") long type_id);

/* Operations defined on compound datatypes */
public static native @Cast("herr_t") int H5Tinsert(@Cast("hid_t") long parent_id, @Cast("const char*") BytePointer name, @Cast("size_t") long offset,
			 @Cast("hid_t") long member_id);
public static native @Cast("herr_t") int H5Tinsert(@Cast("hid_t") long parent_id, String name, @Cast("size_t") long offset,
			 @Cast("hid_t") long member_id);
public static native @Cast("herr_t") int H5Tpack(@Cast("hid_t") long type_id);

/* Operations defined on enumeration datatypes */
public static native @Cast("hid_t") long H5Tenum_create(@Cast("hid_t") long base_id);
public static native @Cast("herr_t") int H5Tenum_insert(@Cast("hid_t") long type, @Cast("const char*") BytePointer name, @Const Pointer value);
public static native @Cast("herr_t") int H5Tenum_insert(@Cast("hid_t") long type, String name, @Const Pointer value);
public static native @Cast("herr_t") int H5Tenum_nameof(@Cast("hid_t") long type, @Const Pointer value, @Cast("char*") BytePointer name,
			     @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Tenum_nameof(@Cast("hid_t") long type, @Const Pointer value, @Cast("char*") ByteBuffer name,
			     @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Tenum_nameof(@Cast("hid_t") long type, @Const Pointer value, @Cast("char*") byte[] name,
			     @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Tenum_valueof(@Cast("hid_t") long type, @Cast("const char*") BytePointer name,
			      Pointer value);
public static native @Cast("herr_t") int H5Tenum_valueof(@Cast("hid_t") long type, String name,
			      Pointer value);

/* Operations defined on variable-length datatypes */
public static native @Cast("hid_t") long H5Tvlen_create(@Cast("hid_t") long base_id);

/* Operations defined on array datatypes */
public static native @Cast("hid_t") long H5Tarray_create2(@Cast("hid_t") long base_id, @Cast("unsigned") int ndims,
            @Cast("const hsize_t*") LongPointer dim);
public static native @Cast("hid_t") long H5Tarray_create2(@Cast("hid_t") long base_id, @Cast("unsigned") int ndims,
            @Cast("const hsize_t*") LongBuffer dim);
public static native @Cast("hid_t") long H5Tarray_create2(@Cast("hid_t") long base_id, @Cast("unsigned") int ndims,
            @Cast("const hsize_t*") long[] dim);
public static native int H5Tget_array_ndims(@Cast("hid_t") long type_id);
public static native int H5Tget_array_dims2(@Cast("hid_t") long type_id, @Cast("hsize_t*") LongPointer dims);
public static native int H5Tget_array_dims2(@Cast("hid_t") long type_id, @Cast("hsize_t*") LongBuffer dims);
public static native int H5Tget_array_dims2(@Cast("hid_t") long type_id, @Cast("hsize_t*") long[] dims);

/* Operations defined on opaque datatypes */
public static native @Cast("herr_t") int H5Tset_tag(@Cast("hid_t") long type, @Cast("const char*") BytePointer tag);
public static native @Cast("herr_t") int H5Tset_tag(@Cast("hid_t") long type, String tag);
public static native @Cast("char*") BytePointer H5Tget_tag(@Cast("hid_t") long type);

/* Querying property values */
public static native @Cast("hid_t") long H5Tget_super(@Cast("hid_t") long type);
public static native @Cast("H5T_class_t") int H5Tget_class(@Cast("hid_t") long type_id);
public static native @Cast("htri_t") int H5Tdetect_class(@Cast("hid_t") long type_id, @Cast("H5T_class_t") int cls);
public static native @Cast("size_t") long H5Tget_size(@Cast("hid_t") long type_id);
public static native @Cast("H5T_order_t") int H5Tget_order(@Cast("hid_t") long type_id);
public static native @Cast("size_t") long H5Tget_precision(@Cast("hid_t") long type_id);
public static native int H5Tget_offset(@Cast("hid_t") long type_id);
public static native @Cast("herr_t") int H5Tget_pad(@Cast("hid_t") long type_id, @Cast("H5T_pad_t*") IntPointer lsb,
			  @Cast("H5T_pad_t*") IntPointer msb);
public static native @Cast("herr_t") int H5Tget_pad(@Cast("hid_t") long type_id, @Cast("H5T_pad_t*") IntBuffer lsb,
			  @Cast("H5T_pad_t*") IntBuffer msb);
public static native @Cast("herr_t") int H5Tget_pad(@Cast("hid_t") long type_id, @Cast("H5T_pad_t*") int[] lsb,
			  @Cast("H5T_pad_t*") int[] msb);
public static native @Cast("H5T_sign_t") int H5Tget_sign(@Cast("hid_t") long type_id);
public static native @Cast("herr_t") int H5Tget_fields(@Cast("hid_t") long type_id, @Cast("size_t*") SizeTPointer spos,
			     @Cast("size_t*") SizeTPointer epos, @Cast("size_t*") SizeTPointer esize,
			     @Cast("size_t*") SizeTPointer mpos, @Cast("size_t*") SizeTPointer msize);
public static native @Cast("size_t") long H5Tget_ebias(@Cast("hid_t") long type_id);
public static native @Cast("H5T_norm_t") int H5Tget_norm(@Cast("hid_t") long type_id);
public static native @Cast("H5T_pad_t") int H5Tget_inpad(@Cast("hid_t") long type_id);
public static native @Cast("H5T_str_t") int H5Tget_strpad(@Cast("hid_t") long type_id);
public static native int H5Tget_nmembers(@Cast("hid_t") long type_id);
public static native @Cast("char*") BytePointer H5Tget_member_name(@Cast("hid_t") long type_id, @Cast("unsigned") int membno);
public static native int H5Tget_member_index(@Cast("hid_t") long type_id, @Cast("const char*") BytePointer name);
public static native int H5Tget_member_index(@Cast("hid_t") long type_id, String name);
public static native @Cast("size_t") long H5Tget_member_offset(@Cast("hid_t") long type_id, @Cast("unsigned") int membno);
public static native @Cast("H5T_class_t") int H5Tget_member_class(@Cast("hid_t") long type_id, @Cast("unsigned") int membno);
public static native @Cast("hid_t") long H5Tget_member_type(@Cast("hid_t") long type_id, @Cast("unsigned") int membno);
public static native @Cast("herr_t") int H5Tget_member_value(@Cast("hid_t") long type_id, @Cast("unsigned") int membno, Pointer value);
public static native @Cast("H5T_cset_t") int H5Tget_cset(@Cast("hid_t") long type_id);
public static native @Cast("htri_t") int H5Tis_variable_str(@Cast("hid_t") long type_id);
public static native @Cast("hid_t") long H5Tget_native_type(@Cast("hid_t") long type_id, @Cast("H5T_direction_t") int direction);

/* Setting property values */
public static native @Cast("herr_t") int H5Tset_size(@Cast("hid_t") long type_id, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Tset_order(@Cast("hid_t") long type_id, @Cast("H5T_order_t") int order);
public static native @Cast("herr_t") int H5Tset_precision(@Cast("hid_t") long type_id, @Cast("size_t") long prec);
public static native @Cast("herr_t") int H5Tset_offset(@Cast("hid_t") long type_id, @Cast("size_t") long offset);
public static native @Cast("herr_t") int H5Tset_pad(@Cast("hid_t") long type_id, @Cast("H5T_pad_t") int lsb, @Cast("H5T_pad_t") int msb);
public static native @Cast("herr_t") int H5Tset_sign(@Cast("hid_t") long type_id, @Cast("H5T_sign_t") int sign);
public static native @Cast("herr_t") int H5Tset_fields(@Cast("hid_t") long type_id, @Cast("size_t") long spos, @Cast("size_t") long epos,
			     @Cast("size_t") long esize, @Cast("size_t") long mpos, @Cast("size_t") long msize);
public static native @Cast("herr_t") int H5Tset_ebias(@Cast("hid_t") long type_id, @Cast("size_t") long ebias);
public static native @Cast("herr_t") int H5Tset_norm(@Cast("hid_t") long type_id, @Cast("H5T_norm_t") int norm);
public static native @Cast("herr_t") int H5Tset_inpad(@Cast("hid_t") long type_id, @Cast("H5T_pad_t") int pad);
public static native @Cast("herr_t") int H5Tset_cset(@Cast("hid_t") long type_id, @Cast("H5T_cset_t") int cset);
public static native @Cast("herr_t") int H5Tset_strpad(@Cast("hid_t") long type_id, @Cast("H5T_str_t") int strpad);

/* Type conversion database */
public static native @Cast("herr_t") int H5Tregister(@Cast("H5T_pers_t") int pers, @Cast("const char*") BytePointer name, @Cast("hid_t") long src_id,
			   @Cast("hid_t") long dst_id, H5T_conv_t func);
public static native @Cast("herr_t") int H5Tregister(@Cast("H5T_pers_t") int pers, String name, @Cast("hid_t") long src_id,
			   @Cast("hid_t") long dst_id, H5T_conv_t func);
public static native @Cast("herr_t") int H5Tunregister(@Cast("H5T_pers_t") int pers, @Cast("const char*") BytePointer name, @Cast("hid_t") long src_id,
			     @Cast("hid_t") long dst_id, H5T_conv_t func);
public static native @Cast("herr_t") int H5Tunregister(@Cast("H5T_pers_t") int pers, String name, @Cast("hid_t") long src_id,
			     @Cast("hid_t") long dst_id, H5T_conv_t func);
public static native H5T_conv_t H5Tfind(@Cast("hid_t") long src_id, @Cast("hid_t") long dst_id, @Cast("H5T_cdata_t**") PointerPointer pcdata);
public static native H5T_conv_t H5Tfind(@Cast("hid_t") long src_id, @Cast("hid_t") long dst_id, @ByPtrPtr H5T_cdata_t pcdata);
public static native @Cast("htri_t") int H5Tcompiler_conv(@Cast("hid_t") long src_id, @Cast("hid_t") long dst_id);
public static native @Cast("herr_t") int H5Tconvert(@Cast("hid_t") long src_id, @Cast("hid_t") long dst_id, @Cast("size_t") long nelmts,
			  Pointer buf, Pointer background, @Cast("hid_t") long plist_id);
public static native @Cast("herr_t") int H5Treclaim(@Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hid_t") long plist_id, Pointer buf);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Tpublic_H */



// Parsed from H5Lpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5Lpublic.h
 *                      Dec 1 2005
 *                      James Laird
 *
 * Purpose:             Public declarations for the H5L package (links)
 *
 *-------------------------------------------------------------------------
 */
// #ifndef _H5Lpublic_H
// #define _H5Lpublic_H

/* Public headers needed by this file */
// #include "H5public.h"		/* Generic Functions			*/
// #include "H5Ipublic.h"		/* IDs			  		*/
// #include "H5Opublic.h"		/* Object Headers			*/
// #include "H5Tpublic.h"		/* Datatypes				*/

/*****************/
/* Public Macros */
/*****************/

/* Maximum length of a link's name */
/* (encoded in a 32-bit unsigned integer) */
public static native @MemberGetter int H5L_MAX_LINK_NAME_LEN();
public static final int H5L_MAX_LINK_NAME_LEN = H5L_MAX_LINK_NAME_LEN();  /* (4GB - 1) */

/* Macro to indicate operation occurs on same location */
public static native @MemberGetter int H5L_SAME_LOC();
public static final int H5L_SAME_LOC = H5L_SAME_LOC();

/* Current version of the H5L_class_t struct */
public static final int H5L_LINK_CLASS_T_VERS =       1;

// #ifdef __cplusplus
// #endif

/*******************/
/* Public Typedefs */
/*******************/

/* Link class types.
 * Values less than 64 are reserved for the HDF5 library's internal use.
 * Values 64 to 255 are for "user-defined" link class types; these types are
 * defined by HDF5 but their behavior can be overridden by users.
 * Users who want to create new classes of links should contact the HDF5
 * development team at hdfhelp@ncsa.uiuc.edu .
 * These values can never change because they appear in HDF5 files.
 */
/** enum H5L_type_t */
public static final int
    H5L_TYPE_ERROR = (-1),      /* Invalid link type id         */
    H5L_TYPE_HARD = 0,          /* Hard link id                 */
    H5L_TYPE_SOFT = 1,          /* Soft link id                 */
    H5L_TYPE_EXTERNAL = 64,     /* External link id             */
    H5L_TYPE_MAX = 255;	        /* Maximum link type id         */
public static final int H5L_TYPE_BUILTIN_MAX = H5L_TYPE_SOFT;      /* Maximum value link value for "built-in" link types */
public static final int H5L_TYPE_UD_MIN =      H5L_TYPE_EXTERNAL;
// Targeting ..\H5L_info2_t.java


// Targeting ..\H5L_create_func_t.java


// Targeting ..\H5L_move_func_t.java


// Targeting ..\H5L_copy_func_t.java


// Targeting ..\H5L_traverse_func_t.java


// Targeting ..\H5L_delete_func_t.java


// Targeting ..\H5L_query_func_t.java


// Targeting ..\H5L_class_t.java


// Targeting ..\H5L_iterate2_t.java


// Targeting ..\H5L_elink_traverse_t.java




/********************/
/* Public Variables */
/********************/


/*********************/
/* Public Prototypes */
/*********************/
public static native @Cast("herr_t") int H5Lmove(@Cast("hid_t") long src_loc, @Cast("const char*") BytePointer src_name, @Cast("hid_t") long dst_loc,
    @Cast("const char*") BytePointer dst_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lmove(@Cast("hid_t") long src_loc, String src_name, @Cast("hid_t") long dst_loc,
    String dst_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lcopy(@Cast("hid_t") long src_loc, @Cast("const char*") BytePointer src_name, @Cast("hid_t") long dst_loc,
    @Cast("const char*") BytePointer dst_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lcopy(@Cast("hid_t") long src_loc, String src_name, @Cast("hid_t") long dst_loc,
    String dst_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lcreate_hard(@Cast("hid_t") long cur_loc, @Cast("const char*") BytePointer cur_name,
    @Cast("hid_t") long dst_loc, @Cast("const char*") BytePointer dst_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lcreate_hard(@Cast("hid_t") long cur_loc, String cur_name,
    @Cast("hid_t") long dst_loc, String dst_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lcreate_soft(@Cast("const char*") BytePointer link_target, @Cast("hid_t") long link_loc_id,
    @Cast("const char*") BytePointer link_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lcreate_soft(String link_target, @Cast("hid_t") long link_loc_id,
    String link_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Ldelete(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Ldelete(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Ldelete_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Ldelete_by_idx(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lget_val(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, Pointer buf,
    @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lget_val(@Cast("hid_t") long loc_id, String name, Pointer buf,
    @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lget_val_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    Pointer buf, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lget_val_by_idx(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    Pointer buf, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("htri_t") int H5Lexists(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long lapl_id);
public static native @Cast("htri_t") int H5Lexists(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lget_info2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name,
    H5L_info2_t linfo, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lget_info2(@Cast("hid_t") long loc_id, String name,
    H5L_info2_t linfo, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lget_info_by_idx2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    H5L_info2_t linfo, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lget_info_by_idx2(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    H5L_info2_t linfo, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Lget_name_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") BytePointer name, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Lget_name_by_idx(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") ByteBuffer name, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Lget_name_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") byte[] name, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Lget_name_by_idx(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") BytePointer name, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Lget_name_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") ByteBuffer name, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Lget_name_by_idx(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") byte[] name, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Literate2(@Cast("hid_t") long grp_id, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx, H5L_iterate2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Literate2(@Cast("hid_t") long grp_id, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx, H5L_iterate2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Literate2(@Cast("hid_t") long grp_id, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx, H5L_iterate2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Literate_by_name2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx,
    H5L_iterate2_t op, Pointer op_data, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name2(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx,
    H5L_iterate2_t op, Pointer op_data, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx,
    H5L_iterate2_t op, Pointer op_data, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name2(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx,
    H5L_iterate2_t op, Pointer op_data, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx,
    H5L_iterate2_t op, Pointer op_data, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name2(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx,
    H5L_iterate2_t op, Pointer op_data, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lvisit2(@Cast("hid_t") long grp_id, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order,
    H5L_iterate2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Lvisit_by_name2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, H5L_iterate2_t op,
    Pointer op_data, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lvisit_by_name2(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, H5L_iterate2_t op,
    Pointer op_data, @Cast("hid_t") long lapl_id);

/* UD link functions */
public static native @Cast("herr_t") int H5Lcreate_ud(@Cast("hid_t") long link_loc_id, @Cast("const char*") BytePointer link_name,
    @Cast("H5L_type_t") int link_type, @Const Pointer udata, @Cast("size_t") long udata_size, @Cast("hid_t") long lcpl_id,
    @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lcreate_ud(@Cast("hid_t") long link_loc_id, String link_name,
    @Cast("H5L_type_t") int link_type, @Const Pointer udata, @Cast("size_t") long udata_size, @Cast("hid_t") long lcpl_id,
    @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lregister(@Const H5L_class_t cls);
public static native @Cast("herr_t") int H5Lunregister(@Cast("H5L_type_t") int id);
public static native @Cast("htri_t") int H5Lis_registered(@Cast("H5L_type_t") int id);

/* External link functions */
public static native @Cast("herr_t") int H5Lunpack_elink_val(@Const Pointer ext_linkval, @Cast("size_t") long link_size,
   @Cast("unsigned*") IntPointer flags, @Cast("const char**") PointerPointer filename, @Cast("const char**") PointerPointer obj_path);
public static native @Cast("herr_t") int H5Lunpack_elink_val(@Const Pointer ext_linkval, @Cast("size_t") long link_size,
   @Cast("unsigned*") IntPointer flags, @Cast("const char**") @ByPtrPtr BytePointer filename, @Cast("const char**") @ByPtrPtr BytePointer obj_path);
public static native @Cast("herr_t") int H5Lunpack_elink_val(@Const Pointer ext_linkval, @Cast("size_t") long link_size,
   @Cast("unsigned*") IntBuffer flags, @Cast("const char**") @ByPtrPtr ByteBuffer filename, @Cast("const char**") @ByPtrPtr ByteBuffer obj_path);
public static native @Cast("herr_t") int H5Lunpack_elink_val(@Const Pointer ext_linkval, @Cast("size_t") long link_size,
   @Cast("unsigned*") int[] flags, @Cast("const char**") @ByPtrPtr byte[] filename, @Cast("const char**") @ByPtrPtr byte[] obj_path);
public static native @Cast("herr_t") int H5Lcreate_external(@Cast("const char*") BytePointer file_name, @Cast("const char*") BytePointer obj_name,
    @Cast("hid_t") long link_loc_id, @Cast("const char*") BytePointer link_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lcreate_external(String file_name, String obj_name,
    @Cast("hid_t") long link_loc_id, String link_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Lpublic_H */



// Parsed from H5Opublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5Opublic.h
 *                      Aug  5 1997
 *                      Robb Matzke <matzke@llnl.gov>
 *
 * Purpose:             Public declarations for the H5O (object header)
 *                      package.
 *
 *-------------------------------------------------------------------------
 */
// #ifndef _H5Opublic_H
// #define _H5Opublic_H

/* Public headers needed by this file */
// #include "H5public.h"		/* Generic Functions			*/
// #include "H5Ipublic.h"		/* IDs			  		*/
// #include "H5Lpublic.h"		/* Links		  		*/

/*****************/
/* Public Macros */
/*****************/

/* Flags for object copy (H5Ocopy) */
public static final int H5O_COPY_SHALLOW_HIERARCHY_FLAG = (0x0001);   /* Copy only immediate members */
public static final int H5O_COPY_EXPAND_SOFT_LINK_FLAG =  (0x0002);   /* Expand soft links into new objects */
public static final int H5O_COPY_EXPAND_EXT_LINK_FLAG =   (0x0004);   /* Expand external links into new objects */
public static final int H5O_COPY_EXPAND_REFERENCE_FLAG =  (0x0008);   /* Copy objects that are pointed by references */
public static final int H5O_COPY_WITHOUT_ATTR_FLAG =      (0x0010);   /* Copy object without copying attributes */
public static final int H5O_COPY_PRESERVE_NULL_FLAG =     (0x0020);   /* Copy NULL messages (empty space) */
public static final int H5O_COPY_MERGE_COMMITTED_DTYPE_FLAG = (0x0040);   /* Merge committed datatypes in dest file */
public static final int H5O_COPY_ALL =                    (0x007F);   /* All object copying flags (for internal checking) */

/* Flags for shared message indexes.
 * Pass these flags in using the mesg_type_flags parameter in
 * H5P_set_shared_mesg_index.
 * (Developers: These flags correspond to object header message type IDs,
 * but we need to assign each kind of message to a different bit so that
 * one index can hold multiple types.)
 */
public static final int H5O_SHMESG_NONE_FLAG =    0x0000;          /* No shared messages */
public static native @MemberGetter int H5O_SHMESG_SDSPACE_FLAG();
public static final int H5O_SHMESG_SDSPACE_FLAG = H5O_SHMESG_SDSPACE_FLAG(); /* Simple Dataspace Message.  */
public static native @MemberGetter int H5O_SHMESG_DTYPE_FLAG();
public static final int H5O_SHMESG_DTYPE_FLAG = H5O_SHMESG_DTYPE_FLAG(); /* Datatype Message.  */
public static native @MemberGetter int H5O_SHMESG_FILL_FLAG();
public static final int H5O_SHMESG_FILL_FLAG = H5O_SHMESG_FILL_FLAG(); /* Fill Value Message. */
public static native @MemberGetter int H5O_SHMESG_PLINE_FLAG();
public static final int H5O_SHMESG_PLINE_FLAG = H5O_SHMESG_PLINE_FLAG(); /* Filter pipeline message.  */
public static native @MemberGetter int H5O_SHMESG_ATTR_FLAG();
public static final int H5O_SHMESG_ATTR_FLAG = H5O_SHMESG_ATTR_FLAG(); /* Attribute Message.  */
public static final int H5O_SHMESG_ALL_FLAG =     (H5O_SHMESG_SDSPACE_FLAG | H5O_SHMESG_DTYPE_FLAG | H5O_SHMESG_FILL_FLAG | H5O_SHMESG_PLINE_FLAG | H5O_SHMESG_ATTR_FLAG);

/* Object header status flag definitions */
public static final int H5O_HDR_CHUNK0_SIZE =             0x03;    /* 2-bit field indicating # of bytes to store the size of chunk 0's data */
public static final int H5O_HDR_ATTR_CRT_ORDER_TRACKED =  0x04;    /* Attribute creation order is tracked */
public static final int H5O_HDR_ATTR_CRT_ORDER_INDEXED =  0x08;    /* Attribute creation order has index */
public static final int H5O_HDR_ATTR_STORE_PHASE_CHANGE = 0x10;    /* Non-default attribute storage phase change values stored */
public static final int H5O_HDR_STORE_TIMES =             0x20;    /* Store access, modification, change & birth times for object */
public static final int H5O_HDR_ALL_FLAGS =       (H5O_HDR_CHUNK0_SIZE | H5O_HDR_ATTR_CRT_ORDER_TRACKED | H5O_HDR_ATTR_CRT_ORDER_INDEXED | H5O_HDR_ATTR_STORE_PHASE_CHANGE | H5O_HDR_STORE_TIMES);

/* Maximum shared message values.  Number of indexes is 8 to allow room to add
 * new types of messages.
 */
public static final int H5O_SHMESG_MAX_NINDEXES = 8;
public static final int H5O_SHMESG_MAX_LIST_SIZE = 5000;

/* Flags for H5Oget_info.
 * Theses flags determine which fields will be filled in in the H5O_info_t
 * struct.
 */
public static final int H5O_INFO_BASIC =          0x0001;         /* Fill in the fileno, addr, type, and rc fields */
public static final int H5O_INFO_TIME =           0x0002;         /* Fill in the atime, mtime, ctime, and btime fields */
public static final int H5O_INFO_NUM_ATTRS =      0x0004;         /* Fill in the num_attrs field */
public static final int H5O_INFO_ALL =            (H5O_INFO_BASIC | H5O_INFO_TIME | H5O_INFO_NUM_ATTRS);

/* Flags for H5Oget_native_info.
 * Theses flags determine which fields will be filled in in the H5O_native_info_t
 * struct.
 */
public static final int H5O_NATIVE_INFO_HDR =            0x0008;         /* Fill in the hdr field */
public static final int H5O_NATIVE_INFO_META_SIZE =      0x0010;         /* Fill in the meta_size field */
public static final int H5O_NATIVE_INFO_ALL =            (H5O_NATIVE_INFO_HDR | H5O_NATIVE_INFO_META_SIZE);

/* Convenience macro to check if the token is the 'undefined' token value */
// #define H5O_IS_TOKEN_UNDEF(token)    (!HDmemcmp(&(token), &(H5O_TOKEN_UNDEF), sizeof(H5O_token_t)))


/*******************/
/* Public Typedefs */
/*******************/

/* Types of objects in file */
/** enum H5O_type_t */
public static final int
    H5O_TYPE_UNKNOWN = -1,    /* Unknown object type        */
    H5O_TYPE_GROUP = 0,            /* Object is a group        */
    H5O_TYPE_DATASET = 1,        /* Object is a dataset        */
    H5O_TYPE_NAMED_DATATYPE = 2,     /* Object is a named data type */
    H5O_TYPE_MAP = 3,               /* Object is a map */
    H5O_TYPE_NTYPES = 4;             /* Number of different object types (must be last!) */
// Targeting ..\H5O_hdr_info_t.java


// Targeting ..\H5O_info2_t.java


// Targeting ..\H5O_native_info_t.java



/* Typedef for message creation indexes */
// Targeting ..\H5O_iterate2_t.java



/** enum H5O_mcdt_search_ret_t */
public static final int
    H5O_MCDT_SEARCH_ERROR = -1,    /* Abort H5Ocopy */
    H5O_MCDT_SEARCH_CONT = 0,    /* Continue the global search of all committed datatypes in the destination file */
    H5O_MCDT_SEARCH_STOP = 1;    /* Stop the search, but continue copying.  The committed datatype will be copied but not merged. */
// Targeting ..\H5O_mcdt_search_cb_t.java



/********************/
/* Public Variables */
/********************/


/*********************/
/* Public Prototypes */
/*********************/
// #ifdef __cplusplus
// #endif

public static native @Cast("hid_t") long H5Oopen(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long lapl_id);
public static native @Cast("hid_t") long H5Oopen(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long lapl_id);
public static native @Cast("hid_t") long H5Oopen_by_token(@Cast("hid_t") long loc_id, @ByVal H5O_token_t token);
public static native @Cast("hid_t") long H5Oopen_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") long lapl_id);
public static native @Cast("hid_t") long H5Oopen_by_idx(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") long lapl_id);
public static native @Cast("htri_t") int H5Oexists_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long lapl_id);
public static native @Cast("htri_t") int H5Oexists_by_name(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oget_info3(@Cast("hid_t") long loc_id, H5O_info2_t oinfo, @Cast("unsigned") int fields);
public static native @Cast("herr_t") int H5Oget_info_by_name3(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, H5O_info2_t oinfo,
    @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oget_info_by_name3(@Cast("hid_t") long loc_id, String name, H5O_info2_t oinfo,
    @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oget_info_by_idx3(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5O_info2_t oinfo,
    @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oget_info_by_idx3(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5O_info2_t oinfo,
    @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oget_native_info(@Cast("hid_t") long loc_id, H5O_native_info_t oinfo, @Cast("unsigned") int fields);
public static native @Cast("herr_t") int H5Oget_native_info_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, H5O_native_info_t oinfo,
    @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oget_native_info_by_name(@Cast("hid_t") long loc_id, String name, H5O_native_info_t oinfo,
    @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oget_native_info_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5O_native_info_t oinfo,
    @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oget_native_info_by_idx(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5O_native_info_t oinfo,
    @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Olink(@Cast("hid_t") long obj_id, @Cast("hid_t") long new_loc_id, @Cast("const char*") BytePointer new_name,
    @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Olink(@Cast("hid_t") long obj_id, @Cast("hid_t") long new_loc_id, String new_name,
    @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oincr_refcount(@Cast("hid_t") long object_id);
public static native @Cast("herr_t") int H5Odecr_refcount(@Cast("hid_t") long object_id);
public static native @Cast("herr_t") int H5Ocopy(@Cast("hid_t") long src_loc_id, @Cast("const char*") BytePointer src_name, @Cast("hid_t") long dst_loc_id,
    @Cast("const char*") BytePointer dst_name, @Cast("hid_t") long ocpypl_id, @Cast("hid_t") long lcpl_id);
public static native @Cast("herr_t") int H5Ocopy(@Cast("hid_t") long src_loc_id, String src_name, @Cast("hid_t") long dst_loc_id,
    String dst_name, @Cast("hid_t") long ocpypl_id, @Cast("hid_t") long lcpl_id);
public static native @Cast("herr_t") int H5Oset_comment(@Cast("hid_t") long obj_id, @Cast("const char*") BytePointer comment);
public static native @Cast("herr_t") int H5Oset_comment(@Cast("hid_t") long obj_id, String comment);
public static native @Cast("herr_t") int H5Oset_comment_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name,
    @Cast("const char*") BytePointer comment, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oset_comment_by_name(@Cast("hid_t") long loc_id, String name,
    String comment, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Oget_comment(@Cast("hid_t") long obj_id, @Cast("char*") BytePointer comment, @Cast("size_t") long bufsize);
public static native @Cast("ssize_t") long H5Oget_comment(@Cast("hid_t") long obj_id, @Cast("char*") ByteBuffer comment, @Cast("size_t") long bufsize);
public static native @Cast("ssize_t") long H5Oget_comment(@Cast("hid_t") long obj_id, @Cast("char*") byte[] comment, @Cast("size_t") long bufsize);
public static native @Cast("ssize_t") long H5Oget_comment_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name,
    @Cast("char*") BytePointer comment, @Cast("size_t") long bufsize, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Oget_comment_by_name(@Cast("hid_t") long loc_id, String name,
    @Cast("char*") ByteBuffer comment, @Cast("size_t") long bufsize, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Oget_comment_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name,
    @Cast("char*") byte[] comment, @Cast("size_t") long bufsize, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Oget_comment_by_name(@Cast("hid_t") long loc_id, String name,
    @Cast("char*") BytePointer comment, @Cast("size_t") long bufsize, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Oget_comment_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name,
    @Cast("char*") ByteBuffer comment, @Cast("size_t") long bufsize, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Oget_comment_by_name(@Cast("hid_t") long loc_id, String name,
    @Cast("char*") byte[] comment, @Cast("size_t") long bufsize, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Ovisit3(@Cast("hid_t") long obj_id, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order,
    H5O_iterate2_t op, Pointer op_data, @Cast("unsigned") int fields);
public static native @Cast("herr_t") int H5Ovisit_by_name3(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, H5O_iterate2_t op,
    Pointer op_data, @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Ovisit_by_name3(@Cast("hid_t") long loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, H5O_iterate2_t op,
    Pointer op_data, @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oclose(@Cast("hid_t") long object_id);
public static native @Cast("herr_t") int H5Oflush(@Cast("hid_t") long obj_id);
public static native @Cast("herr_t") int H5Orefresh(@Cast("hid_t") long oid);
public static native @Cast("herr_t") int H5Odisable_mdc_flushes(@Cast("hid_t") long object_id);
public static native @Cast("herr_t") int H5Oenable_mdc_flushes(@Cast("hid_t") long object_id);
public static native @Cast("herr_t") int H5Oare_mdc_flushes_disabled(@Cast("hid_t") long object_id, @Cast("hbool_t*") BoolPointer are_disabled);
public static native @Cast("herr_t") int H5Oare_mdc_flushes_disabled(@Cast("hid_t") long object_id, @Cast("hbool_t*") boolean[] are_disabled);
public static native @Cast("herr_t") int H5Otoken_cmp(@Cast("hid_t") long loc_id, @Const H5O_token_t token1, @Const H5O_token_t token2,
    IntPointer cmp_value);
public static native @Cast("herr_t") int H5Otoken_cmp(@Cast("hid_t") long loc_id, @Const H5O_token_t token1, @Const H5O_token_t token2,
    IntBuffer cmp_value);
public static native @Cast("herr_t") int H5Otoken_cmp(@Cast("hid_t") long loc_id, @Const H5O_token_t token1, @Const H5O_token_t token2,
    int[] cmp_value);
public static native @Cast("herr_t") int H5Otoken_to_str(@Cast("hid_t") long loc_id, @Const H5O_token_t token, @Cast("char**") PointerPointer token_str);
public static native @Cast("herr_t") int H5Otoken_to_str(@Cast("hid_t") long loc_id, @Const H5O_token_t token, @Cast("char**") @ByPtrPtr BytePointer token_str);
public static native @Cast("herr_t") int H5Otoken_to_str(@Cast("hid_t") long loc_id, @Const H5O_token_t token, @Cast("char**") @ByPtrPtr ByteBuffer token_str);
public static native @Cast("herr_t") int H5Otoken_to_str(@Cast("hid_t") long loc_id, @Const H5O_token_t token, @Cast("char**") @ByPtrPtr byte[] token_str);
public static native @Cast("herr_t") int H5Otoken_from_str(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer token_str, H5O_token_t token);
public static native @Cast("herr_t") int H5Otoken_from_str(@Cast("hid_t") long loc_id, String token_str, H5O_token_t token);

/* The canonical 'undefined' token value */
// #define H5O_TOKEN_UNDEF (H5OPEN H5O_TOKEN_UNDEF_g)
@MemberGetter public static native @Const @ByRef H5O_token_t H5O_TOKEN_UNDEF_g();

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Opublic_H */



// Parsed from H5Zpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Thursday, April 16, 1998
 */

// #ifndef _H5Zpublic_H
// #define _H5Zpublic_H

/* Public headers needed by this file */
// #include "H5public.h"

/*
 * Filter identifiers.  Values 0 through 255 are for filters defined by the
 * HDF5 library.  Values 256 through 511 are available for testing new
 * filters. Subsequent values should be obtained from the HDF5 development
 * team at help@hdfgroup.org.  These values will never change because they
 * appear in the HDF5 files.
 */

/* Filter IDs */
public static final int H5Z_FILTER_ERROR =	(-1);	/*no filter			*/
public static final int H5Z_FILTER_NONE =		0;	/*reserved indefinitely		*/
public static final int H5Z_FILTER_DEFLATE =	1; 	/*deflation like gzip	     	*/
public static final int H5Z_FILTER_SHUFFLE =      2;       /*shuffle the data              */
public static final int H5Z_FILTER_FLETCHER32 =   3;       /*fletcher32 checksum of EDC    */
public static final int H5Z_FILTER_SZIP =         4;       /*szip compression              */
public static final int H5Z_FILTER_NBIT =         5;       /*nbit compression              */
public static final int H5Z_FILTER_SCALEOFFSET =  6;       /*scale+offset compression      */
public static final int H5Z_FILTER_RESERVED =     256;	/*filter ids below this value are reserved for library use */

public static final int H5Z_FILTER_MAX =		65535;	/*maximum filter id		*/

/* General macros */
public static final int H5Z_FILTER_ALL =	 	0;	/* Symbol to remove all filters in H5Premove_filter */
public static final int H5Z_MAX_NFILTERS =        32;      /* Maximum number of filters allowed in a pipeline */
                                        /* (should probably be allowed to be an
                                         * unlimited amount, but currently each
                                         * filter uses a bit in a 32-bit field,
                                         * so the format would have to be
                                         * changed to accommodate that)
                                         */

/* Flags for filter definition (stored) */
public static final int H5Z_FLAG_DEFMASK =	0x00ff;	/*definition flag mask		*/
public static final int H5Z_FLAG_MANDATORY =      0x0000;  /*filter is mandatory		*/
public static final int H5Z_FLAG_OPTIONAL =	0x0001;	/*filter is optional		*/

/* Additional flags for filter invocation (not stored) */
public static final int H5Z_FLAG_INVMASK =	0xff00;	/*invocation flag mask		*/
public static final int H5Z_FLAG_REVERSE =	0x0100;	/*reverse direction; read	*/
public static final int H5Z_FLAG_SKIP_EDC =	0x0200;	/*skip EDC filters for read	*/

/* Special parameters for szip compression */
/* [These are aliases for the similar definitions in szlib.h, which we can't
 * include directly due to the duplication of various symbols with the zlib.h
 * header file] */
public static final int H5_SZIP_ALLOW_K13_OPTION_MASK =   1;
public static final int H5_SZIP_CHIP_OPTION_MASK =        2;
public static final int H5_SZIP_EC_OPTION_MASK =          4;
public static final int H5_SZIP_NN_OPTION_MASK =          32;
public static final int H5_SZIP_MAX_PIXELS_PER_BLOCK =    32;

/* Macros for the shuffle filter */
public static final int H5Z_SHUFFLE_USER_NPARMS =    0;    /* Number of parameters that users can set */
public static final int H5Z_SHUFFLE_TOTAL_NPARMS =   1;    /* Total number of parameters for filter */

/* Macros for the szip filter */
public static final int H5Z_SZIP_USER_NPARMS =    2;       /* Number of parameters that users can set */
public static final int H5Z_SZIP_TOTAL_NPARMS =   4;       /* Total number of parameters for filter */
public static final int H5Z_SZIP_PARM_MASK =      0;       /* "User" parameter for option mask */
public static final int H5Z_SZIP_PARM_PPB =       1;       /* "User" parameter for pixels-per-block */
public static final int H5Z_SZIP_PARM_BPP =       2;       /* "Local" parameter for bits-per-pixel */
public static final int H5Z_SZIP_PARM_PPS =       3;       /* "Local" parameter for pixels-per-scanline */

/* Macros for the nbit filter */
public static final int H5Z_NBIT_USER_NPARMS =     0;     /* Number of parameters that users can set */

/* Macros for the scale offset filter */
public static final int H5Z_SCALEOFFSET_USER_NPARMS =      2;    /* Number of parameters that users can set */


/* Special parameters for ScaleOffset filter*/
public static final int H5Z_SO_INT_MINBITS_DEFAULT = 0;
/** enum H5Z_SO_scale_type_t */
public static final int
    H5Z_SO_FLOAT_DSCALE = 0,
    H5Z_SO_FLOAT_ESCALE = 1,
    H5Z_SO_INT          = 2;

/* Current version of the H5Z_class_t struct */
public static final int H5Z_CLASS_T_VERS = (1);

/* Values to decide if EDC is enabled for reading data */
/** enum H5Z_EDC_t */
public static final int
    H5Z_ERROR_EDC       = -1,   /* error value */
    H5Z_DISABLE_EDC     = 0,
    H5Z_ENABLE_EDC      = 1,
    H5Z_NO_EDC          = 2;     /* must be the last */

/* Bit flags for H5Zget_filter_info */
public static final int H5Z_FILTER_CONFIG_ENCODE_ENABLED = (0x0001);
public static final int H5Z_FILTER_CONFIG_DECODE_ENABLED = (0x0002);

/* Return values for filter callback function */
/** enum H5Z_cb_return_t */
public static final int
    H5Z_CB_ERROR  = -1,
    H5Z_CB_FAIL   = 0,    /* I/O should fail if filter fails. */
    H5Z_CB_CONT   = 1,    /* I/O continues if filter fails.   */
    H5Z_CB_NO     = 2;
// Targeting ..\H5Z_filter_func_t.java


// Targeting ..\H5Z_cb_t.java



// #ifdef __cplusplus
// Targeting ..\H5Z_can_apply_func_t.java


// Targeting ..\H5Z_set_local_func_t.java


// Targeting ..\H5Z_func_t.java


// Targeting ..\H5Z_class2_t.java



public static native @Cast("herr_t") int H5Zregister(@Const Pointer cls);
public static native @Cast("herr_t") int H5Zunregister(@Cast("H5Z_filter_t") int id);
public static native @Cast("htri_t") int H5Zfilter_avail(@Cast("H5Z_filter_t") int id);
public static native @Cast("herr_t") int H5Zget_filter_info(@Cast("H5Z_filter_t") int filter, @Cast("unsigned int*") IntPointer filter_config_flags);
public static native @Cast("herr_t") int H5Zget_filter_info(@Cast("H5Z_filter_t") int filter, @Cast("unsigned int*") IntBuffer filter_config_flags);
public static native @Cast("herr_t") int H5Zget_filter_info(@Cast("H5Z_filter_t") int filter, @Cast("unsigned int*") int[] filter_config_flags);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif



// Parsed from H5Apublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5A module.
 */
// #ifndef _H5Apublic_H
// #define _H5Apublic_H

/* Public headers needed by this file */
// #include "H5Ipublic.h"		/* IDs			  		*/
// #include "H5Opublic.h"		/* Object Headers			*/
// #include "H5Tpublic.h"
// Targeting ..\H5A_info_t.java


// Targeting ..\H5A_operator2_t.java




/********************/
/* Public Variables */
/********************/


/*********************/
/* Public Prototypes */
/*********************/
// #ifdef __cplusplus
// #endif

public static native @Cast("hid_t") long H5Acreate2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer attr_name, @Cast("hid_t") long type_id,
    @Cast("hid_t") long space_id, @Cast("hid_t") long acpl_id, @Cast("hid_t") long aapl_id);
public static native @Cast("hid_t") long H5Acreate2(@Cast("hid_t") long loc_id, String attr_name, @Cast("hid_t") long type_id,
    @Cast("hid_t") long space_id, @Cast("hid_t") long acpl_id, @Cast("hid_t") long aapl_id);
public static native @Cast("hid_t") long H5Acreate_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("const char*") BytePointer attr_name,
    @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hid_t") long acpl_id, @Cast("hid_t") long aapl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("hid_t") long H5Acreate_by_name(@Cast("hid_t") long loc_id, String obj_name, String attr_name,
    @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hid_t") long acpl_id, @Cast("hid_t") long aapl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("hid_t") long H5Aopen(@Cast("hid_t") long obj_id, @Cast("const char*") BytePointer attr_name, @Cast("hid_t") long aapl_id);
public static native @Cast("hid_t") long H5Aopen(@Cast("hid_t") long obj_id, String attr_name, @Cast("hid_t") long aapl_id);
public static native @Cast("hid_t") long H5Aopen_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("const char*") BytePointer attr_name, @Cast("hid_t") long aapl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("hid_t") long H5Aopen_by_name(@Cast("hid_t") long loc_id, String obj_name,
    String attr_name, @Cast("hid_t") long aapl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("hid_t") long H5Aopen_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") long aapl_id,
    @Cast("hid_t") long lapl_id);
public static native @Cast("hid_t") long H5Aopen_by_idx(@Cast("hid_t") long loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") long aapl_id,
    @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Awrite(@Cast("hid_t") long attr_id, @Cast("hid_t") long type_id, @Const Pointer buf);
public static native @Cast("herr_t") int H5Aread(@Cast("hid_t") long attr_id, @Cast("hid_t") long type_id, Pointer buf);
public static native @Cast("herr_t") int H5Aclose(@Cast("hid_t") long attr_id);
public static native @Cast("hid_t") long H5Aget_space(@Cast("hid_t") long attr_id);
public static native @Cast("hid_t") long H5Aget_type(@Cast("hid_t") long attr_id);
public static native @Cast("hid_t") long H5Aget_create_plist(@Cast("hid_t") long attr_id);
public static native @Cast("ssize_t") long H5Aget_name(@Cast("hid_t") long attr_id, @Cast("size_t") long buf_size, @Cast("char*") BytePointer buf);
public static native @Cast("ssize_t") long H5Aget_name(@Cast("hid_t") long attr_id, @Cast("size_t") long buf_size, @Cast("char*") ByteBuffer buf);
public static native @Cast("ssize_t") long H5Aget_name(@Cast("hid_t") long attr_id, @Cast("size_t") long buf_size, @Cast("char*") byte[] buf);
public static native @Cast("ssize_t") long H5Aget_name_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") BytePointer name, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Aget_name_by_idx(@Cast("hid_t") long loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") ByteBuffer name, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Aget_name_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") byte[] name, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Aget_name_by_idx(@Cast("hid_t") long loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") BytePointer name, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Aget_name_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") ByteBuffer name, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Aget_name_by_idx(@Cast("hid_t") long loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") byte[] name, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("hsize_t") long H5Aget_storage_size(@Cast("hid_t") long attr_id);
public static native @Cast("herr_t") int H5Aget_info(@Cast("hid_t") long attr_id, H5A_info_t ainfo);
public static native @Cast("herr_t") int H5Aget_info_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("const char*") BytePointer attr_name, H5A_info_t ainfo, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Aget_info_by_name(@Cast("hid_t") long loc_id, String obj_name,
    String attr_name, H5A_info_t ainfo, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Aget_info_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    H5A_info_t ainfo, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Aget_info_by_idx(@Cast("hid_t") long loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    H5A_info_t ainfo, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Arename(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer old_name, @Cast("const char*") BytePointer new_name);
public static native @Cast("herr_t") int H5Arename(@Cast("hid_t") long loc_id, String old_name, String new_name);
public static native @Cast("herr_t") int H5Arename_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("const char*") BytePointer old_attr_name, @Cast("const char*") BytePointer new_attr_name, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Arename_by_name(@Cast("hid_t") long loc_id, String obj_name,
    String old_attr_name, String new_attr_name, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Aiterate2(@Cast("hid_t") long loc_id, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx, H5A_operator2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Aiterate2(@Cast("hid_t") long loc_id, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx, H5A_operator2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Aiterate2(@Cast("hid_t") long loc_id, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx, H5A_operator2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx, H5A_operator2_t op, Pointer op_data,
    @Cast("hid_t") long lapd_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") long loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx, H5A_operator2_t op, Pointer op_data,
    @Cast("hid_t") long lapd_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx, H5A_operator2_t op, Pointer op_data,
    @Cast("hid_t") long lapd_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") long loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx, H5A_operator2_t op, Pointer op_data,
    @Cast("hid_t") long lapd_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx, H5A_operator2_t op, Pointer op_data,
    @Cast("hid_t") long lapd_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") long loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx, H5A_operator2_t op, Pointer op_data,
    @Cast("hid_t") long lapd_id);
public static native @Cast("herr_t") int H5Adelete(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Adelete(@Cast("hid_t") long loc_id, String name);
public static native @Cast("herr_t") int H5Adelete_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("const char*") BytePointer attr_name, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Adelete_by_name(@Cast("hid_t") long loc_id, String obj_name,
    String attr_name, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Adelete_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Adelete_by_idx(@Cast("hid_t") long loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") long lapl_id);
public static native @Cast("htri_t") int H5Aexists(@Cast("hid_t") long obj_id, @Cast("const char*") BytePointer attr_name);
public static native @Cast("htri_t") int H5Aexists(@Cast("hid_t") long obj_id, String attr_name);
public static native @Cast("htri_t") int H5Aexists_by_name(@Cast("hid_t") long obj_id, @Cast("const char*") BytePointer obj_name,
    @Cast("const char*") BytePointer attr_name, @Cast("hid_t") long lapl_id);
public static native @Cast("htri_t") int H5Aexists_by_name(@Cast("hid_t") long obj_id, String obj_name,
    String attr_name, @Cast("hid_t") long lapl_id);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif

// #endif /* _H5Apublic_H */



// Parsed from H5ACpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5ACpublic.h
 *                      Jul 10 1997
 *                      Robb Matzke <matzke@llnl.gov>
 *
 * Purpose:             Public include file for cache functions.
 *
 * Modifications:
 *
 *-------------------------------------------------------------------------
 */
// #ifndef _H5ACpublic_H
// #define _H5ACpublic_H

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Cpublic.h"

// #ifdef __cplusplus
// #endif

/****************************************************************************
 *
 * structure H5AC_cache_config_t
 *
 * H5AC_cache_config_t is a public structure intended for use in public APIs.
 * At least in its initial incarnation, it is basically a copy of struct
 * H5C_auto_size_ctl_t, minus the report_fcn field, and plus the
 * dirty_bytes_threshold field.
 *
 * The report_fcn field is omitted, as including it would require us to
 * make H5C_t structure public.
 *
 * The dirty_bytes_threshold field does not appear in H5C_auto_size_ctl_t,
 * as synchronization between caches on different processes is handled at
 * the H5AC level, not at the level of H5C.  Note however that there is
 * considerable interaction between this value and the other fields in this
 * structure.
 *
 * Similarly, the open_trace_file, close_trace_file, and trace_file_name
 * fields do not appear in H5C_auto_size_ctl_t, as most trace file
 * issues are handled at the H5AC level.  The one exception is storage of
 * the pointer to the trace file, which is handled by H5C.
 *
 * The structure is in H5ACpublic.h as we may wish to allow different
 * configuration options for metadata and raw data caches.
 *
 * The fields of the structure are discussed individually below:
 *
 * version: Integer field containing the version number of this version
 *      of the H5AC_cache_config_t structure.  Any instance of
 *      H5AC_cache_config_t passed to the cache must have a known
 *      version number, or an error will be flagged.
 *
 * rpt_fcn_enabled: Boolean field used to enable and disable the default
 *    reporting function.  This function is invoked every time the
 *    automatic cache resize code is run, and reports on its activities.
 *
 *    This is a debugging function, and should normally be turned off.
 *
 * open_trace_file: Boolean field indicating whether the trace_file_name
 *     field should be used to open a trace file for the cache.
 *
 *      *** DEPRECATED *** Use H5Fstart/stop logging functions instead
 *
 *     The trace file is a debuging feature that allow the capture of
 *     top level metadata cache requests for purposes of debugging and/or
 *     optimization.  This field should normally be set to FALSE, as
 *     trace file collection imposes considerable overhead.
 *
 *     This field should only be set to TRUE when the trace_file_name
 *     contains the full path of the desired trace file, and either
 *     there is no open trace file on the cache, or the close_trace_file
 *     field is also TRUE.
 *
 * close_trace_file: Boolean field indicating whether the current trace
 *     file (if any) should be closed.
 *
 *      *** DEPRECATED *** Use H5Fstart/stop logging functions instead
 *
 *     See the above comments on the open_trace_file field.  This field
 *     should be set to FALSE unless there is an open trace file on the
 *     cache that you wish to close.
 *
 * trace_file_name: Full path of the trace file to be opened if the
 *     open_trace_file field is TRUE.
 *
 *      *** DEPRECATED *** Use H5Fstart/stop logging functions instead
 *
 *     In the parallel case, an ascii representation of the mpi rank of
 *     the process will be appended to the file name to yield a unique
 *     trace file name for each process.
 *
 *     The length of the path must not exceed H5AC__MAX_TRACE_FILE_NAME_LEN
 *     characters.
 *
 * evictions_enabled:  Boolean field used to either report the current
 *     evictions enabled status of the cache, or to set the cache's
 *    evictions enabled status.
 *
 *     In general, the metadata cache should always be allowed to
 *     evict entries.  However, in some cases it is advantageous to
 *     disable evictions briefly, and thereby postpone metadata
 *     writes.  However, this must be done with care, as the cache
 *     can grow quickly.  If you do this, re-enable evictions as
 *     soon as possible and monitor cache size.
 *
 *     At present, evictions can only be disabled if automatic
 *     cache resizing is also disabled (that is, ( incr_mode ==
 *    H5C_incr__off ) && ( decr_mode == H5C_decr__off )).  There
 *    is no logical reason why this should be so, but it simplifies
 *    implementation and testing, and I can't think of any reason
 *    why it would be desireable.  If you can think of one, I'll
 *    revisit the issue.
 *
 * set_initial_size: Boolean flag indicating whether the size of the
 *      initial size of the cache is to be set to the value given in
 *      the initial_size field.  If set_initial_size is FALSE, the
 *      initial_size field is ignored.
 *
 * initial_size: If enabled, this field contain the size the cache is
 *      to be set to upon receipt of this structure.  Needless to say,
 *      initial_size must lie in the closed interval [min_size, max_size].
 *
 * min_clean_fraction: double in the range 0 to 1 indicating the fraction
 *      of the cache that is to be kept clean.  This field is only used
 *      in parallel mode.  Typical values are 0.1 to 0.5.
 *
 * max_size: Maximum size to which the cache can be adjusted.  The
 *      supplied value must fall in the closed interval
 *      [MIN_MAX_CACHE_SIZE, MAX_MAX_CACHE_SIZE].  Also, max_size must
 *      be greater than or equal to min_size.
 *
 * min_size: Minimum size to which the cache can be adjusted.  The
 *      supplied value must fall in the closed interval
 *      [H5C__MIN_MAX_CACHE_SIZE, H5C__MAX_MAX_CACHE_SIZE].  Also, min_size
 *      must be less than or equal to max_size.
 *
 * epoch_length: Number of accesses on the cache over which to collect
 *      hit rate stats before running the automatic cache resize code,
 *      if it is enabled.
 *
 *      At the end of an epoch, we discard prior hit rate data and start
 *      collecting afresh.  The epoch_length must lie in the closed
 *      interval [H5C__MIN_AR_EPOCH_LENGTH, H5C__MAX_AR_EPOCH_LENGTH].
 *
 *
 * Cache size increase control fields:
 *
 * incr_mode: Instance of the H5C_cache_incr_mode enumerated type whose
 *      value indicates how we determine whether the cache size should be
 *      increased.  At present there are two possible values:
 *
 *      H5C_incr__off:  Don't attempt to increase the size of the cache
 *              automatically.
 *
 *              When this increment mode is selected, the remaining fields
 *              in the cache size increase section ar ignored.
 *
 *      H5C_incr__threshold: Attempt to increase the size of the cache
 *              whenever the average hit rate over the last epoch drops
 *              below the value supplied in the lower_hr_threshold
 *              field.
 *
 *              Note that this attempt will fail if the cache is already
 *              at its maximum size, or if the cache is not already using
 *              all available space.
 *
 *      Note that you must set decr_mode to H5C_incr__off if you
 *      disable metadata cache entry evictions.
 *
 * lower_hr_threshold: Lower hit rate threshold.  If the increment mode
 *      (incr_mode) is H5C_incr__threshold and the hit rate drops below the
 *      value supplied in this field in an epoch, increment the cache size by
 *      size_increment.  Note that cache size may not be incremented above
 *      max_size, and that the increment may be further restricted by the
 *      max_increment field if it is enabled.
 *
 *      When enabled, this field must contain a value in the range [0.0, 1.0].
 *      Depending on the incr_mode selected, it may also have to be less than
 *      upper_hr_threshold.
 *
 * increment:  Double containing the multiplier used to derive the new
 *      cache size from the old if a cache size increment is triggered.
 *      The increment must be greater than 1.0, and should not exceed 2.0.
 *
 *      The new cache size is obtained my multiplying the current max cache
 *      size by the increment, and then clamping to max_size and to stay
 *      within the max_increment as necessary.
 *
 * apply_max_increment:  Boolean flag indicating whether the max_increment
 *      field should be used to limit the maximum cache size increment.
 *
 * max_increment: If enabled by the apply_max_increment field described
 *      above, this field contains the maximum number of bytes by which the
 *      cache size can be increased in a single re-size.
 *
 * flash_incr_mode:  Instance of the H5C_cache_flash_incr_mode enumerated
 *      type whose value indicates whether and by which algorithm we should
 *      make flash increases in the size of the cache to accommodate insertion
 *      of large entries and large increases in the size of a single entry.
 *
 *      The addition of the flash increment mode was occasioned by performance
 *      problems that appear when a local heap is increased to a size in excess
 *      of the current cache size.  While the existing re-size code dealt with
 *      this eventually, performance was very bad for the remainder of the
 *      epoch.
 *
 *      At present, there are two possible values for the flash_incr_mode:
 *
 *      H5C_flash_incr__off:  Don't perform flash increases in the size of
 *              the cache.
 *
 *      H5C_flash_incr__add_space:  Let x be either the size of a newly
 *              newly inserted entry, or the number of bytes by which the
 *              size of an existing entry has been increased.
 *
 *              If
 *                      x > flash_threshold * current max cache size,
 *
 *              increase the current maximum cache size by x * flash_multiple
 *              less any free space in the cache, and star a new epoch.  For
 *              now at least, pay no attention to the maximum increment.
 *
 *      In both of the above cases, the flash increment pays no attention to
 *      the maximum increment (at least in this first incarnation), but DOES
 *      stay within max_size.
 *
 *      With a little thought, it should be obvious that the above flash
 *      cache size increase algorithm is not sufficient for all circumstances
 *      -- for example, suppose the user round robins through
 *      (1/flash_threshold) +1 groups, adding one data set to each on each
 *      pass.  Then all will increase in size at about the same time, requiring
 *      the max cache size to at least double to maintain acceptable
 *      performance, however the above flash increment algorithm will not be
 *      triggered.
 *
 *      Hopefully, the add space algorithms detailed above will be sufficient
 *      for the performance problems encountered to date.  However, we should
 *      expect to revisit the issue.
 *
 * flash_multiple: Double containing the multiple described above in the
 *      H5C_flash_incr__add_space section of the discussion of the
 *      flash_incr_mode section.  This field is ignored unless flash_incr_mode
 *      is H5C_flash_incr__add_space.
 *
 * flash_threshold: Double containing the factor by which current max cache
 *      size is multiplied to obtain the size threshold for the add_space flash
 *      increment algorithm.  The field is ignored unless flash_incr_mode is
 *      H5C_flash_incr__add_space.
 *
 *
 * Cache size decrease control fields:
 *
 * decr_mode: Instance of the H5C_cache_decr_mode enumerated type whose
 *      value indicates how we determine whether the cache size should be
 *      decreased.  At present there are four possibilities.
 *
 *      H5C_decr__off:  Don't attempt to decrease the size of the cache
 *              automatically.
 *
 *              When this increment mode is selected, the remaining fields
 *              in the cache size decrease section are ignored.
 *
 *      H5C_decr__threshold: Attempt to decrease the size of the cache
 *              whenever the average hit rate over the last epoch rises
 *              above the value supplied in the upper_hr_threshold
 *              field.
 *
 *      H5C_decr__age_out:  At the end of each epoch, search the cache for
 *              entries that have not been accessed for at least the number
 *              of epochs specified in the epochs_before_eviction field, and
 *              evict these entries.  Conceptually, the maximum cache size
 *              is then decreased to match the new actual cache size.  However,
 *              this reduction may be modified by the min_size, the
 *              max_decrement, and/or the empty_reserve.
 *
 *      H5C_decr__age_out_with_threshold:  Same as age_out, but we only
 *              attempt to reduce the cache size when the hit rate observed
 *              over the last epoch exceeds the value provided in the
 *              upper_hr_threshold field.
 *
 *      Note that you must set decr_mode to H5C_decr__off if you
 *      disable metadata cache entry evictions.
 *
 * upper_hr_threshold: Upper hit rate threshold.  The use of this field
 *      varies according to the current decr_mode:
 *
 *      H5C_decr__off or H5C_decr__age_out:  The value of this field is
 *              ignored.
 *
 *      H5C_decr__threshold:  If the hit rate exceeds this threshold in any
 *              epoch, attempt to decrement the cache size by size_decrement.
 *
 *              Note that cache size may not be decremented below min_size.
 *
 *              Note also that if the upper_threshold is 1.0, the cache size
 *              will never be reduced.
 *
 *      H5C_decr__age_out_with_threshold:  If the hit rate exceeds this
 *              threshold in any epoch, attempt to reduce the cache size
 *              by evicting entries that have not been accessed for more
 *              than the specified number of epochs.
 *
 * decrement: This field is only used when the decr_mode is
 *      H5C_decr__threshold.
 *
 *      The field is a double containing the multiplier used to derive the
 *      new cache size from the old if a cache size decrement is triggered.
 *      The decrement must be in the range 0.0 (in which case the cache will
 *      try to contract to its minimum size) to 1.0 (in which case the
 *      cache will never shrink).
 *
 * apply_max_decrement:  Boolean flag used to determine whether decrements
 *      in cache size are to be limited by the max_decrement field.
 *
 * max_decrement: Maximum number of bytes by which the cache size can be
 *      decreased in a single re-size.  Note that decrements may also be
 *      restricted by the min_size of the cache, and (in age out modes) by
 *      the empty_reserve field.
 *
 * epochs_before_eviction:  Integer field used in H5C_decr__age_out and
 *      H5C_decr__age_out_with_threshold decrement modes.
 *
 *      This field contains the number of epochs an entry must remain
 *      unaccessed before it is evicted in an attempt to reduce the
 *      cache size.  If applicable, this field must lie in the range
 *      [1, H5C__MAX_EPOCH_MARKERS].
 *
 * apply_empty_reserve:  Boolean field controlling whether the empty_reserve
 *      field is to be used in computing the new cache size when the
 *      decr_mode is H5C_decr__age_out or H5C_decr__age_out_with_threshold.
 *
 * empty_reserve:  To avoid a constant racheting down of cache size by small
 *      amounts in the H5C_decr__age_out and H5C_decr__age_out_with_threshold
 *      modes, this field allows one to require that any cache size
 *      reductions leave the specified fraction of unused space in the cache.
 *
 *      The value of this field must be in the range [0.0, 1.0].  I would
 *      expect typical values to be in the range of 0.01 to 0.1.
 *
 *
 * Parallel Configuration Fields:
 *
 * In PHDF5, all operations that modify metadata must be executed collectively.
 *
 * We used to think that this was enough to ensure consistency across the
 * metadata caches, but since we allow processes to read metadata individually,
 * the order of dirty entries in the LRU list can vary across processes,
 * which can result in inconsistencies between the caches.
 *
 * PHDF5 uses several strategies to prevent such inconsistencies in metadata,
 * all of which use the fact that the same stream of dirty metadata is seen
 * by all processes for purposes of synchronization.  This is done by
 * having each process count the number of bytes of dirty metadata generated,
 * and then running a "sync point" whenever this count exceeds a user
 * specified threshold (see dirty_bytes_threshold below).
 *
 * The current metadata write strategy is indicated by the
 * metadata_write_strategy field.  The possible values of this field, along
 * with the associated metadata write strategies are discussed below.
 *
 * dirty_bytes_threshold:  Threshold of dirty byte creation used to
 *     synchronize updates between caches. (See above for outline and
 *    motivation.)
 *
 *    This value MUST be consistent across all processes accessing the
 *    file.  This field is ignored unless HDF5 has been compiled for
 *    parallel.
 *
 * metadata_write_strategy: Integer field containing a code indicating the
 *    desired metadata write strategy.  The valid values of this field
 *    are enumerated and discussed below:
 *
 *
 *    H5AC_METADATA_WRITE_STRATEGY__PROCESS_0_ONLY:
 *
 *    When metadata_write_strategy is set to this value, only process
 *    zero is allowed to write dirty metadata to disk.  All other
 *    processes must retain dirty metadata until they are informed at
 *    a sync point that the dirty metadata in question has been written
 *    to disk.
 *
 *    When the sync point is reached (or when there is a user generated
 *    flush), process zero flushes sufficient entries to bring it into
 *    complience with its min clean size (or flushes all dirty entries in
 *    the case of a user generated flush), broad casts the list of
 *    entries just cleaned to all the other processes, and then exits
 *    the sync point.
 *
 *    Upon receipt of the broadcast, the other processes mark the indicated
 *    entries as clean, and leave the sync point as well.
 *
 *
 *    H5AC_METADATA_WRITE_STRATEGY__DISTRIBUTED:
 *
 *    In the distributed metadata write strategy, process zero still makes
 *    the decisions as to what entries should be flushed, but the actual
 *    flushes are distributed across the processes in the computation to
 *    the extent possible.
 *
 *    In this strategy, when a sync point is triggered (either by dirty
 *    metadata creation or manual flush), all processes enter a barrier.
 *
 *    On the other side of the barrier, process 0 constructs an ordered
 *    list of the entries to be flushed, and then broadcasts this list
 *    to the caches in all the processes.
 *
 *    All processes then scan the list of entries to be flushed, flushing
 *    some, and marking the rest as clean.  The algorithm for this purpose
 *    ensures that each entry in the list is flushed exactly once, and
 *    all are marked clean in each cache.
 *
 *    Note that in the case of a flush of the cache, no message passing
 *    is necessary, as all processes have the same list of dirty entries,
 *    and all of these entries must be flushed.  Thus in this case it is
 *    sufficient for each process to sort its list of dirty entries after
 *    leaving the initial barrier, and use this list as if it had been
 *    received from process zero.
 *
 *    To avoid possible messages from the past/future, all caches must
 *    wait until all caches are done before leaving the sync point.
 *
 ****************************************************************************/

public static final int H5AC__CURR_CACHE_CONFIG_VERSION =     1;
public static final int H5AC__MAX_TRACE_FILE_NAME_LEN =        1024;

public static final int H5AC_METADATA_WRITE_STRATEGY__PROCESS_0_ONLY =    0;
public static final int H5AC_METADATA_WRITE_STRATEGY__DISTRIBUTED =       1;
// Targeting ..\H5AC_cache_config_t.java




/****************************************************************************
 *
 * structure H5AC_cache_image_config_t
 *
 * H5AC_cache_image_ctl_t is a public structure intended for use in public
 * APIs.  At least in its initial incarnation, it is a copy of struct
 * H5C_cache_image_ctl_t.
 *
 * The fields of the structure are discussed individually below:
 *
 * version: Integer field containing the version number of this version
 *      of the H5C_image_ctl_t structure.  Any instance of
 *      H5C_image_ctl_t passed to the cache must have a known
 *      version number, or an error will be flagged.
 *
 * generate_image:  Boolean flag indicating whether a cache image should
 *      be created on file close.
 *
 * save_resize_status:    Boolean flag indicating whether the cache image
 *    should include the adaptive cache resize configuration and status.
 *    Note that this field is ignored at present.
 *
 * entry_ageout:    Integer field indicating the maximum number of
 *    times a prefetched entry can appear in subsequent cache images.
 *    This field exists to allow the user to avoid the buildup of
 *    infrequently used entries in long sequences of cache images.
 *
 *    The value of this field must lie in the range
 *    H5AC__CACHE_IMAGE__ENTRY_AGEOUT__NONE (-1) to
 *    H5AC__CACHE_IMAGE__ENTRY_AGEOUT__MAX (100).
 *
 *    H5AC__CACHE_IMAGE__ENTRY_AGEOUT__NONE means that no limit
 *    is imposed on number of times a prefeteched entry can appear
 *    in subsequent cache images.
 *
 *    A value of 0 prevents prefetched entries from being included
 *    in cache images.
 *
 *    Positive integers restrict prefetched entries to the specified
 *    number of appearances.
 *
 *    Note that the number of subsequent cache images that a prefetched
 *    entry has appeared in is tracked in an 8 bit field.  Thus, while
 *    H5AC__CACHE_IMAGE__ENTRY_AGEOUT__MAX can be increased from its
 *    current value, any value in excess of 255 will be the functional
 *    equivalent of H5AC__CACHE_IMAGE__ENTRY_AGEOUT__NONE.
 *
 ****************************************************************************/

public static final int H5AC__CURR_CACHE_IMAGE_CONFIG_VERSION =     1;

public static final int H5AC__CACHE_IMAGE__ENTRY_AGEOUT__NONE =    -1;
public static final int H5AC__CACHE_IMAGE__ENTRY_AGEOUT__MAX =    100;
// Targeting ..\H5AC_cache_image_config_t.java



// #ifdef __cplusplus
// #endif
// #endif



// Parsed from H5Dpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5D module.
 */
// #ifndef _H5Dpublic_H
// #define _H5Dpublic_H

/* System headers needed by this file */

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Ipublic.h"

/*****************/
/* Public Macros */
/*****************/

/* Macros used to "unset" chunk cache configuration parameters */
public static native @MemberGetter int H5D_CHUNK_CACHE_NSLOTS_DEFAULT();
public static final int H5D_CHUNK_CACHE_NSLOTS_DEFAULT = H5D_CHUNK_CACHE_NSLOTS_DEFAULT();
public static native @MemberGetter int H5D_CHUNK_CACHE_NBYTES_DEFAULT();
public static final int H5D_CHUNK_CACHE_NBYTES_DEFAULT = H5D_CHUNK_CACHE_NBYTES_DEFAULT();
public static final double H5D_CHUNK_CACHE_W0_DEFAULT =          (-1.0f);

/* Bit flags for the H5Pset_chunk_opts() and H5Pget_chunk_opts() */
public static final int H5D_CHUNK_DONT_FILTER_PARTIAL_CHUNKS =      (0x0002);

/*******************/
/* Public Typedefs */
/*******************/

/* Values for the H5D_LAYOUT property */
/** enum H5D_layout_t */
public static final int
    H5D_LAYOUT_ERROR	 = -1,

    H5D_COMPACT		 = 0,	/*raw data is very small		     */
    H5D_CONTIGUOUS	 = 1,	/*the default				     */
    H5D_CHUNKED		 = 2,	/*slow and fancy			     */
    H5D_VIRTUAL         = 3,    /*actual data is stored in other datasets     */
    H5D_NLAYOUTS	 = 4;	/*this one must be last!		     */

/* Types of chunk index data structures */
/** enum H5D_chunk_index_t */
public static final int
    H5D_CHUNK_IDX_BTREE	 = 0,    /* v1 B-tree index (default)                */
    H5D_CHUNK_IDX_SINGLE = 1,   /* Single Chunk index (cur dims[]=max dims[]=chunk dims[]; filtered & non-filtered) */
    H5D_CHUNK_IDX_NONE = 2,     /* Implicit: No Index (H5D_ALLOC_TIME_EARLY, non-filtered, fixed dims) */
    H5D_CHUNK_IDX_FARRAY = 3,   /* Fixed array (for 0 unlimited dims)       */
    H5D_CHUNK_IDX_EARRAY = 4,   /* Extensible array (for 1 unlimited dim)   */
    H5D_CHUNK_IDX_BT2 = 5,      /* v2 B-tree index (for >1 unlimited dims)  */
    H5D_CHUNK_IDX_NTYPES = 6;        /* This one must be last!                   */

/* Values for the space allocation time property */
/** enum H5D_alloc_time_t */
public static final int
    H5D_ALLOC_TIME_ERROR	 = -1,
    H5D_ALLOC_TIME_DEFAULT 	 = 0,
    H5D_ALLOC_TIME_EARLY	 = 1,
    H5D_ALLOC_TIME_LATE		 = 2,
    H5D_ALLOC_TIME_INCR		 = 3;

/* Values for the status of space allocation */
/** enum H5D_space_status_t */
public static final int
    H5D_SPACE_STATUS_ERROR		 = -1,
    H5D_SPACE_STATUS_NOT_ALLOCATED	 = 0,
    H5D_SPACE_STATUS_PART_ALLOCATED	 = 1,
    H5D_SPACE_STATUS_ALLOCATED		 = 2;

/* Values for time of writing fill value property */
/** enum H5D_fill_time_t */
public static final int
    H5D_FILL_TIME_ERROR	 = -1,
    H5D_FILL_TIME_ALLOC = 0,
    H5D_FILL_TIME_NEVER	 = 1,
    H5D_FILL_TIME_IFSET	 = 2;

/* Values for fill value status */
/** enum H5D_fill_value_t */
public static final int
    H5D_FILL_VALUE_ERROR        = -1,
    H5D_FILL_VALUE_UNDEFINED    = 0,
    H5D_FILL_VALUE_DEFAULT      = 1,
    H5D_FILL_VALUE_USER_DEFINED = 2;

/* Values for VDS bounds option */
/** enum H5D_vds_view_t */
public static final int
    H5D_VDS_ERROR               = -1,
    H5D_VDS_FIRST_MISSING       = 0,
    H5D_VDS_LAST_AVAILABLE      = 1;
// Targeting ..\H5D_append_cb_t.java


// Targeting ..\H5D_operator_t.java


// Targeting ..\H5D_scatter_func_t.java


// Targeting ..\H5D_gather_func_t.java




/********************/
/* Public Variables */
/********************/

/*********************/
/* Public Prototypes */
/*********************/
// #ifdef __cplusplus
// #endif

public static native @Cast("hid_t") long H5Dcreate2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long type_id,
    @Cast("hid_t") long space_id, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long dcpl_id, @Cast("hid_t") long dapl_id);
public static native @Cast("hid_t") long H5Dcreate2(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long type_id,
    @Cast("hid_t") long space_id, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long dcpl_id, @Cast("hid_t") long dapl_id);
public static native @Cast("hid_t") long H5Dcreate_anon(@Cast("hid_t") long file_id, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id,
    @Cast("hid_t") long plist_id, @Cast("hid_t") long dapl_id);
public static native @Cast("hid_t") long H5Dopen2(@Cast("hid_t") long file_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long dapl_id);
public static native @Cast("hid_t") long H5Dopen2(@Cast("hid_t") long file_id, String name, @Cast("hid_t") long dapl_id);
public static native @Cast("herr_t") int H5Dclose(@Cast("hid_t") long dset_id);
public static native @Cast("hid_t") long H5Dget_space(@Cast("hid_t") long dset_id);
public static native @Cast("herr_t") int H5Dget_space_status(@Cast("hid_t") long dset_id, @Cast("H5D_space_status_t*") IntPointer allocation);
public static native @Cast("herr_t") int H5Dget_space_status(@Cast("hid_t") long dset_id, @Cast("H5D_space_status_t*") IntBuffer allocation);
public static native @Cast("herr_t") int H5Dget_space_status(@Cast("hid_t") long dset_id, @Cast("H5D_space_status_t*") int[] allocation);
public static native @Cast("hid_t") long H5Dget_type(@Cast("hid_t") long dset_id);
public static native @Cast("hid_t") long H5Dget_create_plist(@Cast("hid_t") long dset_id);
public static native @Cast("hid_t") long H5Dget_access_plist(@Cast("hid_t") long dset_id);
public static native @Cast("hsize_t") long H5Dget_storage_size(@Cast("hid_t") long dset_id);
public static native @Cast("herr_t") int H5Dget_chunk_storage_size(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") LongPointer offset, @Cast("hsize_t*") LongPointer chunk_bytes);
public static native @Cast("herr_t") int H5Dget_chunk_storage_size(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") LongBuffer offset, @Cast("hsize_t*") LongBuffer chunk_bytes);
public static native @Cast("herr_t") int H5Dget_chunk_storage_size(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") long[] offset, @Cast("hsize_t*") long[] chunk_bytes);
public static native @Cast("herr_t") int H5Dget_num_chunks(@Cast("hid_t") long dset_id, @Cast("hid_t") long fspace_id, @Cast("hsize_t*") LongPointer nchunks);
public static native @Cast("herr_t") int H5Dget_num_chunks(@Cast("hid_t") long dset_id, @Cast("hid_t") long fspace_id, @Cast("hsize_t*") LongBuffer nchunks);
public static native @Cast("herr_t") int H5Dget_num_chunks(@Cast("hid_t") long dset_id, @Cast("hid_t") long fspace_id, @Cast("hsize_t*") long[] nchunks);
public static native @Cast("herr_t") int H5Dget_chunk_info_by_coord(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") LongPointer coord, @Cast("unsigned*") IntPointer filter_mask, @Cast("haddr_t*") LongPointer addr, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Dget_chunk_info_by_coord(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") LongBuffer coord, @Cast("unsigned*") IntBuffer filter_mask, @Cast("haddr_t*") LongBuffer addr, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Dget_chunk_info_by_coord(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") long[] coord, @Cast("unsigned*") int[] filter_mask, @Cast("haddr_t*") long[] addr, @Cast("hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Dget_chunk_info(@Cast("hid_t") long dset_id, @Cast("hid_t") long fspace_id, @Cast("hsize_t") long chk_idx, @Cast("hsize_t*") LongPointer coord, @Cast("unsigned*") IntPointer filter_mask, @Cast("haddr_t*") LongPointer addr, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Dget_chunk_info(@Cast("hid_t") long dset_id, @Cast("hid_t") long fspace_id, @Cast("hsize_t") long chk_idx, @Cast("hsize_t*") LongBuffer coord, @Cast("unsigned*") IntBuffer filter_mask, @Cast("haddr_t*") LongBuffer addr, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Dget_chunk_info(@Cast("hid_t") long dset_id, @Cast("hid_t") long fspace_id, @Cast("hsize_t") long chk_idx, @Cast("hsize_t*") long[] coord, @Cast("unsigned*") int[] filter_mask, @Cast("haddr_t*") long[] addr, @Cast("hsize_t*") long[] size);
public static native @Cast("haddr_t") long H5Dget_offset(@Cast("hid_t") long dset_id);
public static native @Cast("herr_t") int H5Dread(@Cast("hid_t") long dset_id, @Cast("hid_t") long mem_type_id, @Cast("hid_t") long mem_space_id,
			@Cast("hid_t") long file_space_id, @Cast("hid_t") long plist_id, Pointer buf);
public static native @Cast("herr_t") int H5Dwrite(@Cast("hid_t") long dset_id, @Cast("hid_t") long mem_type_id, @Cast("hid_t") long mem_space_id,
			 @Cast("hid_t") long file_space_id, @Cast("hid_t") long plist_id, @Const Pointer buf);
public static native @Cast("herr_t") int H5Dwrite_chunk(@Cast("hid_t") long dset_id, @Cast("hid_t") long dxpl_id, @Cast("uint32_t") int filters, 
            @Cast("const hsize_t*") LongPointer offset, @Cast("size_t") long data_size, @Const Pointer buf);
public static native @Cast("herr_t") int H5Dwrite_chunk(@Cast("hid_t") long dset_id, @Cast("hid_t") long dxpl_id, @Cast("uint32_t") int filters, 
            @Cast("const hsize_t*") LongBuffer offset, @Cast("size_t") long data_size, @Const Pointer buf);
public static native @Cast("herr_t") int H5Dwrite_chunk(@Cast("hid_t") long dset_id, @Cast("hid_t") long dxpl_id, @Cast("uint32_t") int filters, 
            @Cast("const hsize_t*") long[] offset, @Cast("size_t") long data_size, @Const Pointer buf);
public static native @Cast("herr_t") int H5Dread_chunk(@Cast("hid_t") long dset_id, @Cast("hid_t") long dxpl_id,
            @Cast("const hsize_t*") LongPointer offset, @Cast("uint32_t*") IntPointer filters, Pointer buf);
public static native @Cast("herr_t") int H5Dread_chunk(@Cast("hid_t") long dset_id, @Cast("hid_t") long dxpl_id,
            @Cast("const hsize_t*") LongBuffer offset, @Cast("uint32_t*") IntBuffer filters, Pointer buf);
public static native @Cast("herr_t") int H5Dread_chunk(@Cast("hid_t") long dset_id, @Cast("hid_t") long dxpl_id,
            @Cast("const hsize_t*") long[] offset, @Cast("uint32_t*") int[] filters, Pointer buf);
public static native @Cast("herr_t") int H5Diterate(Pointer buf, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id,
            H5D_operator_t op, Pointer operator_data);
public static native @Cast("herr_t") int H5Dvlen_get_buf_size(@Cast("hid_t") long dataset_id, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Dvlen_get_buf_size(@Cast("hid_t") long dataset_id, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Dvlen_get_buf_size(@Cast("hid_t") long dataset_id, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Dfill(@Const Pointer _fill, @Cast("hid_t") long fill_type, Pointer buf,
        @Cast("hid_t") long buf_type, @Cast("hid_t") long space);
public static native @Cast("herr_t") int H5Dset_extent(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Dset_extent(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Dset_extent(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Dflush(@Cast("hid_t") long dset_id);
public static native @Cast("herr_t") int H5Drefresh(@Cast("hid_t") long dset_id);
public static native @Cast("herr_t") int H5Dscatter(H5D_scatter_func_t op, Pointer op_data, @Cast("hid_t") long type_id,
    @Cast("hid_t") long dst_space_id, Pointer dst_buf);
public static native @Cast("herr_t") int H5Dgather(@Cast("hid_t") long src_space_id, @Const Pointer src_buf, @Cast("hid_t") long type_id,
    @Cast("size_t") long dst_buf_size, Pointer dst_buf, H5D_gather_func_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Ddebug(@Cast("hid_t") long dset_id);

/* Internal API routines */
public static native @Cast("herr_t") int H5Dformat_convert(@Cast("hid_t") long dset_id);
public static native @Cast("herr_t") int H5Dget_chunk_index_type(@Cast("hid_t") long did, @Cast("H5D_chunk_index_t*") IntPointer idx_type);
public static native @Cast("herr_t") int H5Dget_chunk_index_type(@Cast("hid_t") long did, @Cast("H5D_chunk_index_t*") IntBuffer idx_type);
public static native @Cast("herr_t") int H5Dget_chunk_index_type(@Cast("hid_t") long did, @Cast("H5D_chunk_index_t*") int[] idx_type);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Dpublic_H */



// Parsed from H5Epublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5E module.
 */
// #ifndef _H5Epublic_H
// #define _H5Epublic_H

// #include <stdio.h>              /*FILE arg of H5Eprint()                     */

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Ipublic.h"

/* Value for the default error stack */
public static native @MemberGetter int H5E_DEFAULT();
public static final int H5E_DEFAULT = H5E_DEFAULT();

/* Different kinds of error information */
/** enum H5E_type_t */
public static final int
    H5E_MAJOR = 0,
    H5E_MINOR = 1;
// Targeting ..\H5E_error2_t.java



/* When this header is included from a private header, don't make calls to H5open() */
// #undef H5OPEN
// #ifndef _H5private_H
// #define H5OPEN          H5open(),
// #else   /* _H5private_H */
// #define H5OPEN
// #endif  /* _H5private_H */

/* HDF5 error class */
// #define H5E_ERR_CLS		(H5OPEN H5E_ERR_CLS_g)


/* Include the automatically generated public header information */
/* (This includes the list of major and minor error codes for the library) */
// #include "H5Epubgen.h"

/*
 * One often needs to temporarily disable automatic error reporting when
 * trying something that's likely or expected to fail.  The code to try can
 * be nested between calls to H5Eget_auto() and H5Eset_auto(), but it's
 * easier just to use this macro like:
 * 	H5E_BEGIN_TRY {
 *	    ...stuff here that's likely to fail...
 *      } H5E_END_TRY;
 *
 * Warning: don't break, return, or longjmp() from the body of the loop or
 *	    the error reporting won't be properly restored!
 *
 * These two macros still use the old API functions for backward compatibility
 * purpose.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS
// #else /* H5_NO_DEPRECATED_SYMBOLS */
// #define H5E_BEGIN_TRY {
//     H5E_auto2_t saved_efunc;
//     void *H5E_saved_edata;
// 
//     (void)H5Eget_auto2(H5E_DEFAULT, &saved_efunc, &H5E_saved_edata);
//     (void)H5Eset_auto2(H5E_DEFAULT, NULL, NULL);

// #define H5E_END_TRY
//     (void)H5Eset_auto2(H5E_DEFAULT, saved_efunc, H5E_saved_edata);
// }
// #endif /* H5_NO_DEPRECATED_SYMBOLS */

/*
 * Public API Convenience Macros for Error reporting - Documented
 */
/* Use the Standard C __FILE__ & __LINE__ macros instead of typing them in */
// #define H5Epush_sim(func, cls, maj, min, str) H5Epush2(H5E_DEFAULT, __FILE__, func, __LINE__, cls, maj, min, str)

/*
 * Public API Convenience Macros for Error reporting - Undocumented
 */
/* Use the Standard C __FILE__ & __LINE__ macros instead of typing them in */
/*  And return after pushing error onto stack */
// #define H5Epush_ret(func, cls, maj, min, str, ret) {
//     H5Epush2(H5E_DEFAULT, __FILE__, func, __LINE__, cls, maj, min, str);
//     return(ret);
// }

/* Use the Standard C __FILE__ & __LINE__ macros instead of typing them in
 * And goto a label after pushing error onto stack.
 */
// #define H5Epush_goto(func, cls, maj, min, str, label) {
//     H5Epush2(H5E_DEFAULT, __FILE__, func, __LINE__, cls, maj, min, str);
//     goto label;
// }

/* Error stack traversal direction */
/** enum H5E_direction_t */
public static final int
    H5E_WALK_UPWARD	 = 0,		/*begin deep, end at API function    */
    H5E_WALK_DOWNWARD	 = 1;		/*begin at API function, end deep    */


// #ifdef __cplusplus
// Targeting ..\H5E_walk2_t.java


// Targeting ..\H5E_auto2_t.java



/* Public API functions */
public static native @Cast("hid_t") long H5Eregister_class(@Cast("const char*") BytePointer cls_name, @Cast("const char*") BytePointer lib_name,
    @Cast("const char*") BytePointer version);
public static native @Cast("hid_t") long H5Eregister_class(String cls_name, String lib_name,
    String version);
public static native @Cast("herr_t") int H5Eunregister_class(@Cast("hid_t") long class_id);
public static native @Cast("herr_t") int H5Eclose_msg(@Cast("hid_t") long err_id);
public static native @Cast("hid_t") long H5Ecreate_msg(@Cast("hid_t") long cls, @Cast("H5E_type_t") int msg_type, @Cast("const char*") BytePointer msg);
public static native @Cast("hid_t") long H5Ecreate_msg(@Cast("hid_t") long cls, @Cast("H5E_type_t") int msg_type, String msg);
public static native @Cast("hid_t") long H5Ecreate_stack();
public static native @Cast("hid_t") long H5Eget_current_stack();
public static native @Cast("herr_t") int H5Eclose_stack(@Cast("hid_t") long stack_id);
public static native @Cast("ssize_t") long H5Eget_class_name(@Cast("hid_t") long class_id, @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Eget_class_name(@Cast("hid_t") long class_id, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Eget_class_name(@Cast("hid_t") long class_id, @Cast("char*") byte[] name, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Eset_current_stack(@Cast("hid_t") long err_stack_id);
public static native @Cast("herr_t") int H5Epush2(@Cast("hid_t") long err_stack, @Cast("const char*") BytePointer file, @Cast("const char*") BytePointer func, @Cast("unsigned") int line,
    @Cast("hid_t") long cls_id, @Cast("hid_t") long maj_id, @Cast("hid_t") long min_id, @Cast("const char*") BytePointer msg);
public static native @Cast("herr_t") int H5Epush2(@Cast("hid_t") long err_stack, String file, String func, @Cast("unsigned") int line,
    @Cast("hid_t") long cls_id, @Cast("hid_t") long maj_id, @Cast("hid_t") long min_id, String msg);
public static native @Cast("herr_t") int H5Epop(@Cast("hid_t") long err_stack, @Cast("size_t") long count);
public static native @Cast("herr_t") int H5Eprint2(@Cast("hid_t") long err_stack, @Cast("FILE*") Pointer stream);
public static native @Cast("herr_t") int H5Ewalk2(@Cast("hid_t") long err_stack, @Cast("H5E_direction_t") int direction, H5E_walk2_t func,
    Pointer client_data);
public static native @Cast("herr_t") int H5Eget_auto2(@Cast("hid_t") long estack_id, @ByPtrPtr H5E_auto2_t func, @Cast("void**") PointerPointer client_data);
public static native @Cast("herr_t") int H5Eget_auto2(@Cast("hid_t") long estack_id, @ByPtrPtr H5E_auto2_t func, @Cast("void**") @ByPtrPtr Pointer client_data);
public static native @Cast("herr_t") int H5Eset_auto2(@Cast("hid_t") long estack_id, H5E_auto2_t func, Pointer client_data);
public static native @Cast("herr_t") int H5Eclear2(@Cast("hid_t") long err_stack);
public static native @Cast("herr_t") int H5Eauto_is_v2(@Cast("hid_t") long err_stack, @Cast("unsigned*") IntPointer is_stack);
public static native @Cast("herr_t") int H5Eauto_is_v2(@Cast("hid_t") long err_stack, @Cast("unsigned*") IntBuffer is_stack);
public static native @Cast("herr_t") int H5Eauto_is_v2(@Cast("hid_t") long err_stack, @Cast("unsigned*") int[] is_stack);
public static native @Cast("ssize_t") long H5Eget_msg(@Cast("hid_t") long msg_id, @Cast("H5E_type_t*") IntPointer type, @Cast("char*") BytePointer msg,
    @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Eget_msg(@Cast("hid_t") long msg_id, @Cast("H5E_type_t*") IntBuffer type, @Cast("char*") ByteBuffer msg,
    @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Eget_msg(@Cast("hid_t") long msg_id, @Cast("H5E_type_t*") int[] type, @Cast("char*") byte[] msg,
    @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Eget_num(@Cast("hid_t") long error_stack_id);


/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS
// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif

// #endif /* end _H5Epublic_H */



// Parsed from H5Fpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5F module.
 */
// #ifndef _H5Fpublic_H
// #define _H5Fpublic_H

/* Public header files needed by this file */
// #include "H5public.h"
// #include "H5ACpublic.h"
// #include "H5Ipublic.h"

/* When this header is included from a private header, don't make calls to H5check() */
// #undef H5CHECK
// #ifndef _H5private_H
// #define H5CHECK          H5check(),
// #else   /* _H5private_H */
// #define H5CHECK
// #endif  /* _H5private_H */

/* When this header is included from a private HDF5 header, don't make calls to H5open() */
// #undef H5OPEN
// #ifndef _H5private_H
// #define H5OPEN        H5open(),
// #else   /* _H5private_H */
// #define H5OPEN
// #endif  /* _H5private_H */

/*
 * These are the bits that can be passed to the `flags' argument of
 * H5Fcreate() and H5Fopen(). Use the bit-wise OR operator (|) to combine
 * them as needed.  As a side effect, they call H5check_version() to make sure
 * that the application is compiled with a version of the hdf5 header files
 * which are compatible with the library to which the application is linked.
 * We're assuming that these constants are used rather early in the hdf5
 * session.
 */
public static native @MemberGetter int H5F_ACC_RDONLY();
public static final int H5F_ACC_RDONLY = H5F_ACC_RDONLY();    /*absence of rdwr => rd-only */
public static native @MemberGetter int H5F_ACC_RDWR();
public static final int H5F_ACC_RDWR = H5F_ACC_RDWR();    /*open for read and write    */
public static native @MemberGetter int H5F_ACC_TRUNC();
public static final int H5F_ACC_TRUNC = H5F_ACC_TRUNC();    /*overwrite existing files   */
public static native @MemberGetter int H5F_ACC_EXCL();
public static final int H5F_ACC_EXCL = H5F_ACC_EXCL();    /*fail if file already exists*/
/* NOTE: 0x0008u was H5F_ACC_DEBUG, now deprecated */
public static native @MemberGetter int H5F_ACC_CREAT();
public static final int H5F_ACC_CREAT = H5F_ACC_CREAT();    /*create non-existing files  */
public static native @MemberGetter int H5F_ACC_SWMR_WRITE();
public static final int H5F_ACC_SWMR_WRITE = H5F_ACC_SWMR_WRITE(); /*indicate that this file is
                                                 * open for writing in a
                                                 * single-writer/multi-reader (SWMR)
                                                 * scenario.  Note that the
                                                 * process(es) opening the file
                                                 * for reading must open the file
                                                 * with RDONLY access, and use
                                                 * the special "SWMR_READ" access
                                                 * flag. */
public static native @MemberGetter int H5F_ACC_SWMR_READ();
public static final int H5F_ACC_SWMR_READ = H5F_ACC_SWMR_READ(); /*indicate that this file is
                                                 * open for reading in a
                                                 * single-writer/multi-reader (SWMR)
                                                 * scenario.  Note that the
                                                 * process(es) opening the file
                                                 * for SWMR reading must also
                                                 * open the file with the RDONLY
                                                 * flag.  */

/* Value passed to H5Pset_elink_acc_flags to cause flags to be taken from the
 * parent file. */
public static native @MemberGetter int H5F_ACC_DEFAULT();
public static final int H5F_ACC_DEFAULT = H5F_ACC_DEFAULT();    /*ignore setting on lapl     */

/* Flags for H5Fget_obj_count() & H5Fget_obj_ids() calls */
public static final int H5F_OBJ_FILE =    (0x0001);       /* File objects */
public static final int H5F_OBJ_DATASET =    (0x0002);       /* Dataset objects */
public static final int H5F_OBJ_GROUP =    (0x0004);       /* Group objects */
public static final int H5F_OBJ_DATATYPE = (0x0008);      /* Named datatype objects */
public static final int H5F_OBJ_ATTR =    (0x0010);       /* Attribute objects */
public static final int H5F_OBJ_ALL =     (H5F_OBJ_FILE|H5F_OBJ_DATASET|H5F_OBJ_GROUP|H5F_OBJ_DATATYPE|H5F_OBJ_ATTR);
public static final int H5F_OBJ_LOCAL =   (0x0020);       /* Restrict search to objects opened through current file ID */
                                        /* (as opposed to objects opened through any file ID accessing this file) */

public static native @MemberGetter int H5F_FAMILY_DEFAULT();
public static final int H5F_FAMILY_DEFAULT = H5F_FAMILY_DEFAULT();

// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */

/* The difference between a single file and a set of mounted files */
/** enum H5F_scope_t */
public static final int
    H5F_SCOPE_LOCAL    = 0,    /*specified file handle only        */
    H5F_SCOPE_GLOBAL    = 1;     /*entire virtual file            */

/* Unlimited file size for H5Pset_external() */
public static native @MemberGetter long H5F_UNLIMITED();
public static final long H5F_UNLIMITED = H5F_UNLIMITED();

/* How does file close behave?
 * H5F_CLOSE_DEFAULT - Use the degree pre-defined by underlining VFL
 * H5F_CLOSE_WEAK    - file closes only after all opened objects are closed
 * H5F_CLOSE_SEMI    - if no opened objects, file is close; otherwise, file
            close fails
 * H5F_CLOSE_STRONG  - if there are opened objects, close them first, then
            close file
 */
/** enum H5F_close_degree_t */
public static final int
    H5F_CLOSE_DEFAULT   = 0,
    H5F_CLOSE_WEAK      = 1,
    H5F_CLOSE_SEMI      = 2,
    H5F_CLOSE_STRONG    = 3;
// Targeting ..\H5F_info2_t.java



/*
 * Types of allocation requests. The values larger than H5FD_MEM_DEFAULT
 * should not change other than adding new types to the end. These numbers
 * might appear in files.
 *
 * Note: please change the log VFD flavors array if you change this
 * enumeration.
 */
/** enum H5F_mem_t */
public static final int
    H5FD_MEM_NOLIST     = -1,   /* Data should not appear in the free list.
                                 * Must be negative.
                                 */
    H5FD_MEM_DEFAULT    = 0,    /* Value not yet set.  Can also be the
                                 * datatype set in a larger allocation
                                 * that will be suballocated by the library.
                                 * Must be zero.
                                 */
    H5FD_MEM_SUPER      = 1,    /* Superblock data */
    H5FD_MEM_BTREE      = 2,    /* B-tree data */
    H5FD_MEM_DRAW       = 3,    /* Raw data (content of datasets, etc.) */
    H5FD_MEM_GHEAP      = 4,    /* Global heap data */
    H5FD_MEM_LHEAP      = 5,    /* Local heap data */
    H5FD_MEM_OHDR       = 6,    /* Object header data */

    H5FD_MEM_NTYPES = 7;             /* Sentinel value - must be last */
// Targeting ..\H5F_sect_info_t.java



/* Library's format versions */
/** enum H5F_libver_t */
public static final int
    H5F_LIBVER_ERROR = -1,
    H5F_LIBVER_EARLIEST = 0,    /* Use the earliest possible format for storing objects */
    H5F_LIBVER_V18 = 1,         /* Use the latest v18 format for storing objects */
    H5F_LIBVER_V110 = 2,        /* Use the latest v110 format for storing objects */
    H5F_LIBVER_V112 = 3,        /* Use the latest v112 format for storing objects */
    H5F_LIBVER_NBOUNDS = 4;

public static final int H5F_LIBVER_LATEST =   H5F_LIBVER_V112;

/* File space handling strategy */
/** enum H5F_fspace_strategy_t */
public static final int
    H5F_FSPACE_STRATEGY_FSM_AGGR = 0,   /* Mechanisms: free-space managers, aggregators, and virtual file drivers */
                                        /* This is the library default when not set */
    H5F_FSPACE_STRATEGY_PAGE = 1,   /* Mechanisms: free-space managers with embedded paged aggregation and virtual file drivers */
    H5F_FSPACE_STRATEGY_AGGR = 2,   /* Mechanisms: aggregators and virtual file drivers */
    H5F_FSPACE_STRATEGY_NONE = 3,   /* Mechanisms: virtual file drivers */
    H5F_FSPACE_STRATEGY_NTYPES = 4;      /* must be last */

/* Deprecated: File space handling strategy for release 1.10.0 */
/* They are mapped to H5F_fspace_strategy_t as defined above from release 1.10.1 onwards */
/** enum H5F_file_space_type_t */
public static final int
    H5F_FILE_SPACE_DEFAULT = 0,     /* Default (or current) free space strategy setting */
    H5F_FILE_SPACE_ALL_PERSIST = 1, /* Persistent free space managers, aggregators, virtual file driver */
    H5F_FILE_SPACE_ALL = 2,        /* Non-persistent free space managers, aggregators, virtual file driver */
                    /* This is the library default */
    H5F_FILE_SPACE_AGGR_VFD = 3,    /* Aggregators, Virtual file driver */
    H5F_FILE_SPACE_VFD = 4,        /* Virtual file driver */
    H5F_FILE_SPACE_NTYPES = 5;        /* must be last */

/* Data structure to report the collection of read retries for metadata items with checksum */
/* Used by public routine H5Fget_metadata_read_retry_info() */
public static final int H5F_NUM_METADATA_READ_RETRY_TYPES =    21;
// Targeting ..\H5F_retry_info_t.java


// Targeting ..\H5F_flush_cb_t.java



/*********************/
/* Public Prototypes */
/*********************/
// #ifdef __cplusplus
// #endif

public static native @Cast("htri_t") int H5Fis_accessible(@Cast("const char*") BytePointer container_name, @Cast("hid_t") long fapl_id);
public static native @Cast("htri_t") int H5Fis_accessible(String container_name, @Cast("hid_t") long fapl_id);
public static native @Cast("hid_t") long H5Fcreate(@Cast("const char*") BytePointer filename, @Cast("unsigned") int flags,
                @Cast("hid_t") long create_plist, @Cast("hid_t") long access_plist);
public static native @Cast("hid_t") long H5Fcreate(String filename, @Cast("unsigned") int flags,
                @Cast("hid_t") long create_plist, @Cast("hid_t") long access_plist);
public static native @Cast("hid_t") long H5Fopen(@Cast("const char*") BytePointer filename, @Cast("unsigned") int flags,
                @Cast("hid_t") long access_plist);
public static native @Cast("hid_t") long H5Fopen(String filename, @Cast("unsigned") int flags,
                @Cast("hid_t") long access_plist);
public static native @Cast("hid_t") long H5Freopen(@Cast("hid_t") long file_id);
public static native @Cast("herr_t") int H5Fflush(@Cast("hid_t") long object_id, @Cast("H5F_scope_t") int scope);
public static native @Cast("herr_t") int H5Fclose(@Cast("hid_t") long file_id);
public static native @Cast("herr_t") int H5Fdelete(@Cast("const char*") BytePointer filename, @Cast("hid_t") long fapl_id);
public static native @Cast("herr_t") int H5Fdelete(String filename, @Cast("hid_t") long fapl_id);
public static native @Cast("hid_t") long H5Fget_create_plist(@Cast("hid_t") long file_id);
public static native @Cast("hid_t") long H5Fget_access_plist(@Cast("hid_t") long file_id);
public static native @Cast("herr_t") int H5Fget_intent(@Cast("hid_t") long file_id, @Cast("unsigned*") IntPointer intent);
public static native @Cast("herr_t") int H5Fget_intent(@Cast("hid_t") long file_id, @Cast("unsigned*") IntBuffer intent);
public static native @Cast("herr_t") int H5Fget_intent(@Cast("hid_t") long file_id, @Cast("unsigned*") int[] intent);
public static native @Cast("herr_t") int H5Fget_fileno(@Cast("hid_t") long file_id, @Cast("unsigned long*") CLongPointer fileno);
public static native @Cast("ssize_t") long H5Fget_obj_count(@Cast("hid_t") long file_id, @Cast("unsigned") int types);
public static native @Cast("ssize_t") long H5Fget_obj_ids(@Cast("hid_t") long file_id, @Cast("unsigned") int types, @Cast("size_t") long max_objs, @Cast("hid_t*") LongPointer obj_id_list);
public static native @Cast("ssize_t") long H5Fget_obj_ids(@Cast("hid_t") long file_id, @Cast("unsigned") int types, @Cast("size_t") long max_objs, @Cast("hid_t*") LongBuffer obj_id_list);
public static native @Cast("ssize_t") long H5Fget_obj_ids(@Cast("hid_t") long file_id, @Cast("unsigned") int types, @Cast("size_t") long max_objs, @Cast("hid_t*") long[] obj_id_list);
public static native @Cast("herr_t") int H5Fget_vfd_handle(@Cast("hid_t") long file_id, @Cast("hid_t") long fapl, @Cast("void**") PointerPointer file_handle);
public static native @Cast("herr_t") int H5Fget_vfd_handle(@Cast("hid_t") long file_id, @Cast("hid_t") long fapl, @Cast("void**") @ByPtrPtr Pointer file_handle);
public static native @Cast("herr_t") int H5Fmount(@Cast("hid_t") long loc, @Cast("const char*") BytePointer name, @Cast("hid_t") long child, @Cast("hid_t") long plist);
public static native @Cast("herr_t") int H5Fmount(@Cast("hid_t") long loc, String name, @Cast("hid_t") long child, @Cast("hid_t") long plist);
public static native @Cast("herr_t") int H5Funmount(@Cast("hid_t") long loc, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Funmount(@Cast("hid_t") long loc, String name);
public static native @Cast("hssize_t") long H5Fget_freespace(@Cast("hid_t") long file_id);
public static native @Cast("herr_t") int H5Fget_filesize(@Cast("hid_t") long file_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Fget_filesize(@Cast("hid_t") long file_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Fget_filesize(@Cast("hid_t") long file_id, @Cast("hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Fget_eoa(@Cast("hid_t") long file_id, @Cast("haddr_t*") LongPointer eoa);
public static native @Cast("herr_t") int H5Fget_eoa(@Cast("hid_t") long file_id, @Cast("haddr_t*") LongBuffer eoa);
public static native @Cast("herr_t") int H5Fget_eoa(@Cast("hid_t") long file_id, @Cast("haddr_t*") long[] eoa);
public static native @Cast("herr_t") int H5Fincrement_filesize(@Cast("hid_t") long file_id, @Cast("hsize_t") long increment);
public static native @Cast("ssize_t") long H5Fget_file_image(@Cast("hid_t") long file_id, Pointer buf_ptr, @Cast("size_t") long buf_len);
public static native @Cast("herr_t") int H5Fget_mdc_config(@Cast("hid_t") long file_id,
                H5AC_cache_config_t config_ptr);
public static native @Cast("herr_t") int H5Fset_mdc_config(@Cast("hid_t") long file_id,
                H5AC_cache_config_t config_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_hit_rate(@Cast("hid_t") long file_id, DoublePointer hit_rate_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_hit_rate(@Cast("hid_t") long file_id, DoubleBuffer hit_rate_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_hit_rate(@Cast("hid_t") long file_id, double[] hit_rate_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_size(@Cast("hid_t") long file_id,
                              @Cast("size_t*") SizeTPointer max_size_ptr,
                              @Cast("size_t*") SizeTPointer min_clean_size_ptr,
                              @Cast("size_t*") SizeTPointer cur_size_ptr,
                              IntPointer cur_num_entries_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_size(@Cast("hid_t") long file_id,
                              @Cast("size_t*") SizeTPointer max_size_ptr,
                              @Cast("size_t*") SizeTPointer min_clean_size_ptr,
                              @Cast("size_t*") SizeTPointer cur_size_ptr,
                              IntBuffer cur_num_entries_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_size(@Cast("hid_t") long file_id,
                              @Cast("size_t*") SizeTPointer max_size_ptr,
                              @Cast("size_t*") SizeTPointer min_clean_size_ptr,
                              @Cast("size_t*") SizeTPointer cur_size_ptr,
                              int[] cur_num_entries_ptr);
public static native @Cast("herr_t") int H5Freset_mdc_hit_rate_stats(@Cast("hid_t") long file_id);
public static native @Cast("ssize_t") long H5Fget_name(@Cast("hid_t") long obj_id, @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Fget_name(@Cast("hid_t") long obj_id, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Fget_name(@Cast("hid_t") long obj_id, @Cast("char*") byte[] name, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Fget_info2(@Cast("hid_t") long obj_id, H5F_info2_t finfo);
public static native @Cast("herr_t") int H5Fget_metadata_read_retry_info(@Cast("hid_t") long file_id, H5F_retry_info_t info);
public static native @Cast("herr_t") int H5Fstart_swmr_write(@Cast("hid_t") long file_id);
public static native @Cast("ssize_t") long H5Fget_free_sections(@Cast("hid_t") long file_id, @Cast("H5F_mem_t") int type,
    @Cast("size_t") long nsects, H5F_sect_info_t sect_info);
public static native @Cast("herr_t") int H5Fclear_elink_file_cache(@Cast("hid_t") long file_id);
public static native @Cast("herr_t") int H5Fset_libver_bounds(@Cast("hid_t") long file_id, @Cast("H5F_libver_t") int low, @Cast("H5F_libver_t") int high);
public static native @Cast("herr_t") int H5Fstart_mdc_logging(@Cast("hid_t") long file_id);
public static native @Cast("herr_t") int H5Fstop_mdc_logging(@Cast("hid_t") long file_id);
public static native @Cast("herr_t") int H5Fget_mdc_logging_status(@Cast("hid_t") long file_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("hbool_t*") BoolPointer is_currently_logging);
public static native @Cast("herr_t") int H5Fget_mdc_logging_status(@Cast("hid_t") long file_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("hbool_t*") boolean[] is_currently_logging);
public static native @Cast("herr_t") int H5Fformat_convert(@Cast("hid_t") long fid);
public static native @Cast("herr_t") int H5Freset_page_buffering_stats(@Cast("hid_t") long file_id);
public static native @Cast("herr_t") int H5Fget_page_buffering_stats(@Cast("hid_t") long file_id, @Cast("unsigned*") IntPointer accesses,
    @Cast("unsigned*") IntPointer hits, @Cast("unsigned*") IntPointer misses, @Cast("unsigned*") IntPointer evictions, @Cast("unsigned*") IntPointer bypasses);
public static native @Cast("herr_t") int H5Fget_page_buffering_stats(@Cast("hid_t") long file_id, @Cast("unsigned*") IntBuffer accesses,
    @Cast("unsigned*") IntBuffer hits, @Cast("unsigned*") IntBuffer misses, @Cast("unsigned*") IntBuffer evictions, @Cast("unsigned*") IntBuffer bypasses);
public static native @Cast("herr_t") int H5Fget_page_buffering_stats(@Cast("hid_t") long file_id, @Cast("unsigned*") int[] accesses,
    @Cast("unsigned*") int[] hits, @Cast("unsigned*") int[] misses, @Cast("unsigned*") int[] evictions, @Cast("unsigned*") int[] bypasses);
public static native @Cast("herr_t") int H5Fget_mdc_image_info(@Cast("hid_t") long file_id, @Cast("haddr_t*") LongPointer image_addr, @Cast("hsize_t*") LongPointer image_size);
public static native @Cast("herr_t") int H5Fget_mdc_image_info(@Cast("hid_t") long file_id, @Cast("haddr_t*") LongBuffer image_addr, @Cast("hsize_t*") LongBuffer image_size);
public static native @Cast("herr_t") int H5Fget_mdc_image_info(@Cast("hid_t") long file_id, @Cast("haddr_t*") long[] image_addr, @Cast("hsize_t*") long[] image_size);
public static native @Cast("herr_t") int H5Fget_dset_no_attrs_hint(@Cast("hid_t") long file_id, @Cast("hbool_t*") BoolPointer minimize);
public static native @Cast("herr_t") int H5Fget_dset_no_attrs_hint(@Cast("hid_t") long file_id, @Cast("hbool_t*") boolean[] minimize);
public static native @Cast("herr_t") int H5Fset_dset_no_attrs_hint(@Cast("hid_t") long file_id, @Cast("hbool_t") boolean minimize);

// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Fpublic_H */



// Parsed from H5FDpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Monday, July 26, 1999
 */
// #ifndef _H5FDpublic_H
// #define _H5FDpublic_H

// #include "H5public.h"
// #include "H5Fpublic.h"		/*for H5F_close_degree_t */

public static final int H5_HAVE_VFL = 1; /*define a convenient app feature test*/
public static final int H5FD_VFD_DEFAULT = 0;   /* Default VFL driver value */

/* Types of allocation requests: see H5Fpublic.h  */

/* Map "fractal heap" header blocks to 'ohdr' type file memory, since its
 * a fair amount of work to add a new kind of file memory and they are similar
 * enough to object headers and probably too minor to deserve their own type.
 *
 * Map "fractal heap" indirect blocks to 'ohdr' type file memory, since they
 * are similar to fractal heap header blocks.
 *
 * Map "fractal heap" direct blocks to 'lheap' type file memory, since they
 * will be replacing local heaps.
 *
 * Map "fractal heap" 'huge' objects to 'draw' type file memory, since they
 * represent large objects that are directly stored in the file.
 *
 *      -QAK
 */
public static final int H5FD_MEM_FHEAP_HDR =      H5FD_MEM_OHDR;
public static final int H5FD_MEM_FHEAP_IBLOCK =   H5FD_MEM_OHDR;
public static final int H5FD_MEM_FHEAP_DBLOCK =   H5FD_MEM_LHEAP;
public static final int H5FD_MEM_FHEAP_HUGE_OBJ = H5FD_MEM_DRAW;

/* Map "free space" header blocks to 'ohdr' type file memory, since its
 * a fair amount of work to add a new kind of file memory and they are similar
 * enough to object headers and probably too minor to deserve their own type.
 *
 * Map "free space" serialized sections to 'lheap' type file memory, since they
 * are similar enough to local heap info.
 *
 *      -QAK
 */
public static final int H5FD_MEM_FSPACE_HDR =     H5FD_MEM_OHDR;
public static final int H5FD_MEM_FSPACE_SINFO =   H5FD_MEM_LHEAP;

/* Map "shared object header message" master table to 'ohdr' type file memory,
 * since its a fair amount of work to add a new kind of file memory and they are
 * similar enough to object headers and probably too minor to deserve their own
 * type.
 *
 * Map "shared object header message" indices to 'btree' type file memory,
 * since they are similar enough to B-tree nodes.
 *
 *      -QAK
 */
public static final int H5FD_MEM_SOHM_TABLE =     H5FD_MEM_OHDR;
public static final int H5FD_MEM_SOHM_INDEX =     H5FD_MEM_BTREE;

/* Map "extensible array" header blocks to 'ohdr' type file memory, since its
 * a fair amount of work to add a new kind of file memory and they are similar
 * enough to object headers and probably too minor to deserve their own type.
 *
 * Map "extensible array" index blocks to 'ohdr' type file memory, since they
 * are similar to extensible array header blocks.
 *
 * Map "extensible array" super blocks to 'btree' type file memory, since they
 * are similar enough to B-tree nodes.
 *
 * Map "extensible array" data blocks & pages to 'lheap' type file memory, since
 * they are similar enough to local heap info.
 *
 *      -QAK
 */
public static final int H5FD_MEM_EARRAY_HDR =     H5FD_MEM_OHDR;
public static final int H5FD_MEM_EARRAY_IBLOCK =  H5FD_MEM_OHDR;
public static final int H5FD_MEM_EARRAY_SBLOCK =  H5FD_MEM_BTREE;
public static final int H5FD_MEM_EARRAY_DBLOCK =  H5FD_MEM_LHEAP;
public static final int H5FD_MEM_EARRAY_DBLK_PAGE =  H5FD_MEM_LHEAP;

/* Map "fixed array" header blocks to 'ohdr' type file memory, since its
 * a fair amount of work to add a new kind of file memory and they are similar
 * enough to object headers and probably too minor to deserve their own type.
 *
 * Map "fixed array" data blocks & pages to 'lheap' type file memory, since
 * they are similar enough to local heap info.
 *
 */
public static final int H5FD_MEM_FARRAY_HDR =     H5FD_MEM_OHDR;
public static final int H5FD_MEM_FARRAY_DBLOCK =  H5FD_MEM_LHEAP;
public static final int H5FD_MEM_FARRAY_DBLK_PAGE =  H5FD_MEM_LHEAP;

/*
 * A free-list map which maps all types of allocation requests to a single
 * free list.  This is useful for drivers that don't really care about
 * keeping different requests segregated in the underlying file and which
 * want to make most efficient reuse of freed memory.  The use of the
 * H5FD_MEM_SUPER free list is arbitrary.
 */
// #define H5FD_FLMAP_SINGLE {
//     H5FD_MEM_SUPER,			/*default*/
//     H5FD_MEM_SUPER,			/*super*/
//     H5FD_MEM_SUPER,			/*btree*/
//     H5FD_MEM_SUPER,			/*draw*/
//     H5FD_MEM_SUPER,			/*gheap*/
//     H5FD_MEM_SUPER,			/*lheap*/
//     H5FD_MEM_SUPER			/*ohdr*/
// }

/*
 * A free-list map which segregates requests into `raw' or `meta' data
 * pools.
 */
// #define H5FD_FLMAP_DICHOTOMY {
//     H5FD_MEM_SUPER,			/*default*/
//     H5FD_MEM_SUPER,			/*super*/
//     H5FD_MEM_SUPER,			/*btree*/
//     H5FD_MEM_DRAW,			/*draw*/
//     H5FD_MEM_DRAW,			/*gheap*/
//     H5FD_MEM_SUPER,			/*lheap*/
//     H5FD_MEM_SUPER			/*ohdr*/
// }

/*
 * The default free list map which causes each request type to use it's own
 * free-list.
 */
// #define H5FD_FLMAP_DEFAULT {
//     H5FD_MEM_DEFAULT,			/*default*/
//     H5FD_MEM_DEFAULT,			/*super*/
//     H5FD_MEM_DEFAULT,			/*btree*/
//     H5FD_MEM_DEFAULT,			/*draw*/
//     H5FD_MEM_DEFAULT,			/*gheap*/
//     H5FD_MEM_DEFAULT,			/*lheap*/
//     H5FD_MEM_DEFAULT			/*ohdr*/
// }


/* Define VFL driver features that can be enabled on a per-driver basis */
/* These are returned with the 'query' function pointer in H5FD_class_t */
    /*
     * Defining H5FD_FEAT_AGGREGATE_METADATA for a VFL driver means that
     * the library will attempt to allocate a larger block for metadata and
     * then sub-allocate each metadata request from that larger block.
     */
public static final int H5FD_FEAT_AGGREGATE_METADATA =    0x00000001;
    /*
     * Defining H5FD_FEAT_ACCUMULATE_METADATA for a VFL driver means that
     * the library will attempt to cache metadata as it is written to the file
     * and build up a larger block of metadata to eventually pass to the VFL
     * 'write' routine.
     *
     * Distinguish between updating the metadata accumulator on writes and
     * reads.  This is particularly (perhaps only, even) important for MPI-I/O
     * where we guarantee that writes are collective, but reads may not be.
     * If we were to allow the metadata accumulator to be written during a
     * read operation, the application would hang.
     */
public static final int H5FD_FEAT_ACCUMULATE_METADATA_WRITE =     0x00000002;
public static final int H5FD_FEAT_ACCUMULATE_METADATA_READ =      0x00000004;
public static final int H5FD_FEAT_ACCUMULATE_METADATA =   (H5FD_FEAT_ACCUMULATE_METADATA_WRITE|H5FD_FEAT_ACCUMULATE_METADATA_READ);
    /*
     * Defining H5FD_FEAT_DATA_SIEVE for a VFL driver means that
     * the library will attempt to cache raw data as it is read from/written to
     * a file in a "data seive" buffer.  See Rajeev Thakur's papers:
     *  http://www.mcs.anl.gov/~thakur/papers/romio-coll.ps.gz
     *  http://www.mcs.anl.gov/~thakur/papers/mpio-high-perf.ps.gz
     */
public static final int H5FD_FEAT_DATA_SIEVE =            0x00000008;
    /*
     * Defining H5FD_FEAT_AGGREGATE_SMALLDATA for a VFL driver means that
     * the library will attempt to allocate a larger block for "small" raw data
     * and then sub-allocate "small" raw data requests from that larger block.
     */
public static final int H5FD_FEAT_AGGREGATE_SMALLDATA =   0x00000010;
    /*
     * Defining H5FD_FEAT_IGNORE_DRVRINFO for a VFL driver means that
     * the library will ignore the driver info that is encoded in the file
     * for the VFL driver.  (This will cause the driver info to be eliminated
     * from the file when it is flushed/closed, if the file is opened R/W).
     */
public static final int H5FD_FEAT_IGNORE_DRVRINFO =       0x00000020;
    /*
     * Defining the H5FD_FEAT_DIRTY_DRVRINFO_LOAD for a VFL driver means that
     * the library will mark the driver info dirty when the file is opened
     * R/W.  This will cause the driver info to be re-encoded when the file
     * is flushed/closed.
     */
public static final int H5FD_FEAT_DIRTY_DRVRINFO_LOAD =   0x00000040;
    /*
     * Defining H5FD_FEAT_POSIX_COMPAT_HANDLE for a VFL driver means that
     * the handle for the VFD (returned with the 'get_handle' callback) is
     * of type 'int' and is compatible with POSIX I/O calls.
     */
public static final int H5FD_FEAT_POSIX_COMPAT_HANDLE =   0x00000080;    
    /*
     * Defining H5FD_FEAT_HAS_MPI for a VFL driver means that
     * the driver makes use of MPI communication and code may retrieve
     * communicator/rank information from it
     */
public static final int H5FD_FEAT_HAS_MPI =               0x00000100;
    /*
     * Defining the H5FD_FEAT_ALLOCATE_EARLY for a VFL driver will force
     * the library to use the H5D_ALLOC_TIME_EARLY on dataset create
     * instead of the default H5D_ALLOC_TIME_LATE
     */
public static final int H5FD_FEAT_ALLOCATE_EARLY =        0x00000200;
    /* 
     * Defining H5FD_FEAT_ALLOW_FILE_IMAGE for a VFL driver means that
     * the driver is able to use a file image in the fapl as the initial
     * contents of a file.
     */
public static final int H5FD_FEAT_ALLOW_FILE_IMAGE =      0x00000400;
    /*
     * Defining H5FD_FEAT_CAN_USE_FILE_IMAGE_CALLBACKS for a VFL driver
     * means that the driver is able to use callbacks to make a copy of the
     * image to store in memory.
     */
public static final int H5FD_FEAT_CAN_USE_FILE_IMAGE_CALLBACKS = 0x00000800;
    /*
     * Defining H5FD_FEAT_SUPPORTS_SWMR_IO for a VFL driver means that the
     * driver supports the single-writer/multiple-readers I/O pattern.
     */
public static final int H5FD_FEAT_SUPPORTS_SWMR_IO =      0x00001000;
    /*
     * Defining H5FD_FEAT_USE_ALLOC_SIZE for a VFL driver
     * means that the library will just pass the allocation size to the
     * the driver's allocation callback which will eventually handle alignment.
     * This is specifically used for the multi/split driver.
     */
public static final int H5FD_FEAT_USE_ALLOC_SIZE =	0x00002000;
    /*
     * Defining H5FD_FEAT_PAGED_AGGR for a VFL driver
     * means that the driver needs special file space mapping for paged aggregation.
     * This is specifically used for the multi/split driver.
     */
public static final int H5FD_FEAT_PAGED_AGGR =		0x00004000;
    /*
     * Defining H5FD_FEAT_DEFAULT_VFD_COMPATIBLE for a VFL driver
     * that creates a file which is compatible with the default VFD.
     * Generally, this means that the VFD creates a single file that follows
     * the canonical HDF5 file format.
     */
public static final int H5FD_FEAT_DEFAULT_VFD_COMPATIBLE =        0x00008000;


/* Forward declaration */
// Targeting ..\H5FD_class_t.java


// Targeting ..\H5FD_free_t.java


// Targeting ..\H5FD_t.java



/* Define enum for the source of file image callbacks */
/** enum H5FD_file_image_op_t */
public static final int
    H5FD_FILE_IMAGE_OP_NO_OP = 0,
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_SET = 1,     
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_COPY = 2,
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_GET = 3,
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_CLOSE = 4,
    H5FD_FILE_IMAGE_OP_FILE_OPEN = 5,
    H5FD_FILE_IMAGE_OP_FILE_RESIZE = 6,
    H5FD_FILE_IMAGE_OP_FILE_CLOSE = 7;
// Targeting ..\H5FD_file_image_callbacks_t.java



// #ifdef __cplusplus
// #endif

/* Function prototypes */
public static native @Cast("hid_t") long H5FDregister(@Const H5FD_class_t cls);
public static native @Cast("herr_t") int H5FDunregister(@Cast("hid_t") long driver_id);
public static native H5FD_t H5FDopen(@Cast("const char*") BytePointer name, @Cast("unsigned") int flags, @Cast("hid_t") long fapl_id,
                        @Cast("haddr_t") long maxaddr);
public static native H5FD_t H5FDopen(String name, @Cast("unsigned") int flags, @Cast("hid_t") long fapl_id,
                        @Cast("haddr_t") long maxaddr);
public static native @Cast("herr_t") int H5FDclose(H5FD_t file);
public static native int H5FDcmp(@Const H5FD_t f1, @Const H5FD_t f2);
public static native int H5FDquery(@Const H5FD_t f, @Cast("unsigned long*") CLongPointer flags);
public static native @Cast("haddr_t") long H5FDalloc(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") long dxpl_id, @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5FDfree(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") long dxpl_id,
                       @Cast("haddr_t") long addr, @Cast("hsize_t") long size);
public static native @Cast("haddr_t") long H5FDget_eoa(H5FD_t file, @Cast("H5FD_mem_t") int type);
public static native @Cast("herr_t") int H5FDset_eoa(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("haddr_t") long eoa);
public static native @Cast("haddr_t") long H5FDget_eof(H5FD_t file, @Cast("H5FD_mem_t") int type);
public static native @Cast("herr_t") int H5FDget_vfd_handle(H5FD_t file, @Cast("hid_t") long fapl, @Cast("void**") PointerPointer file_handle);
public static native @Cast("herr_t") int H5FDget_vfd_handle(H5FD_t file, @Cast("hid_t") long fapl, @Cast("void**") @ByPtrPtr Pointer file_handle);
public static native @Cast("herr_t") int H5FDread(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") long dxpl_id,
                       @Cast("haddr_t") long addr, @Cast("size_t") long size, Pointer buf);
public static native @Cast("herr_t") int H5FDwrite(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") long dxpl_id,
                        @Cast("haddr_t") long addr, @Cast("size_t") long size, @Const Pointer buf);
public static native @Cast("herr_t") int H5FDflush(H5FD_t file, @Cast("hid_t") long dxpl_id, @Cast("hbool_t") boolean closing);
public static native @Cast("herr_t") int H5FDtruncate(H5FD_t file, @Cast("hid_t") long dxpl_id, @Cast("hbool_t") boolean closing);
public static native @Cast("herr_t") int H5FDlock(H5FD_t file, @Cast("hbool_t") boolean rw);
public static native @Cast("herr_t") int H5FDunlock(H5FD_t file);

/* Allows querying a VFD ID for features before the file is opened */
public static native @Cast("herr_t") int H5FDdriver_query(@Cast("hid_t") long driver_id, @Cast("unsigned long*") CLongPointer flags);

// #ifdef __cplusplus
// #endif
// #endif



// Parsed from H5Gpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5Gpublic.h
 *                      Jul 11 1997
 *                      Robb Matzke <matzke@llnl.gov>
 *
 * Purpose:             Public declarations for the H5G package
 *
 *-------------------------------------------------------------------------
 */
// #ifndef _H5Gpublic_H
// #define _H5Gpublic_H

/* System headers needed by this file */
// #include <sys/types.h>

/* Public headers needed by this file */
// #include "H5public.h"		/* Generic Functions			*/
// #include "H5Lpublic.h"		/* Links                                */
// #include "H5Opublic.h"		/* Object headers			*/
// #include "H5Tpublic.h"		/* Datatypes				*/

/*****************/
/* Public Macros */
/*****************/

/*******************/
/* Public Typedefs */
/*******************/

/* Types of link storage for groups */
/** enum H5G_storage_type_t */
public static final int
    H5G_STORAGE_TYPE_UNKNOWN = -1,	/* Unknown link storage type	*/
    H5G_STORAGE_TYPE_SYMBOL_TABLE = 0,      /* Links in group are stored with a "symbol table" */
                                        /* (this is sometimes called "old-style" groups) */
    H5G_STORAGE_TYPE_COMPACT = 1,		/* Links are stored in object header */
    H5G_STORAGE_TYPE_DENSE = 2; 		/* Links are stored in fractal heap & indexed with v2 B-tree */
// Targeting ..\H5G_info_t.java




/********************/
/* Public Variables */
/********************/


/*********************/
/* Public Prototypes */
/*********************/
// #ifdef __cplusplus
// #endif

public static native @Cast("hid_t") long H5Gcreate2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long lcpl_id,
    @Cast("hid_t") long gcpl_id, @Cast("hid_t") long gapl_id);
public static native @Cast("hid_t") long H5Gcreate2(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long lcpl_id,
    @Cast("hid_t") long gcpl_id, @Cast("hid_t") long gapl_id);
public static native @Cast("hid_t") long H5Gcreate_anon(@Cast("hid_t") long loc_id, @Cast("hid_t") long gcpl_id, @Cast("hid_t") long gapl_id);
public static native @Cast("hid_t") long H5Gopen2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long gapl_id);
public static native @Cast("hid_t") long H5Gopen2(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long gapl_id);
public static native @Cast("hid_t") long H5Gget_create_plist(@Cast("hid_t") long group_id);
public static native @Cast("herr_t") int H5Gget_info(@Cast("hid_t") long loc_id, H5G_info_t ginfo);
public static native @Cast("herr_t") int H5Gget_info_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, H5G_info_t ginfo,
    @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Gget_info_by_name(@Cast("hid_t") long loc_id, String name, H5G_info_t ginfo,
    @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Gget_info_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5G_info_t ginfo,
    @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Gget_info_by_idx(@Cast("hid_t") long loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5G_info_t ginfo,
    @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Gclose(@Cast("hid_t") long group_id);
public static native @Cast("herr_t") int H5Gflush(@Cast("hid_t") long group_id);
public static native @Cast("herr_t") int H5Grefresh(@Cast("hid_t") long group_id);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Gpublic_H */



// Parsed from H5MMpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5MMproto.h
 *                      Jul 10 1997
 *                      Robb Matzke <matzke@llnl.gov>
 *
 * Purpose:             Public declarations for the H5MM (memory management)
 *                      package.
 *
 * Modifications:
 *
 *-------------------------------------------------------------------------
 */
// #ifndef _H5MMpublic_H
// #define _H5MMpublic_H

/* Public headers needed by this file */
// #include "H5public.h"
// Targeting ..\H5MM_allocate_t.java


// Targeting ..\H5MM_free_t.java



// #ifdef __cplusplus
// #endif

// #ifdef __cplusplus
// #endif
// #endif /* _H5MMpublic_H */



// Parsed from H5Ppublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains function prototypes for each exported function in the
 * H5P module.
 */
// #ifndef _H5Ppublic_H
// #define _H5Ppublic_H

/* System headers needed by this file */

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5ACpublic.h"
// #include "H5Dpublic.h"
// #include "H5Fpublic.h"
// #include "H5FDpublic.h"
// #include "H5Ipublic.h"
// #include "H5Lpublic.h"
// #include "H5Opublic.h"
// #include "H5MMpublic.h"
// #include "H5Tpublic.h"
// #include "H5Zpublic.h"


/*****************/
/* Public Macros */
/*****************/

/* When this header is included from a private HDF5 header, don't make calls to H5open() */
// #undef H5OPEN
// #ifndef _H5private_H
// #define H5OPEN        H5open(),
// #else   /* _H5private_H */
// #define H5OPEN
// #endif  /* _H5private_H */

/*
 * The library's property list classes
 */

public static native @MemberGetter int H5P_ROOT();
public static final int H5P_ROOT = H5P_ROOT();
public static native @MemberGetter int H5P_OBJECT_CREATE();
public static final int H5P_OBJECT_CREATE = H5P_OBJECT_CREATE();
public static native @MemberGetter int H5P_FILE_CREATE();
public static final int H5P_FILE_CREATE = H5P_FILE_CREATE();
public static native @MemberGetter int H5P_FILE_ACCESS();
public static final int H5P_FILE_ACCESS = H5P_FILE_ACCESS();
public static native @MemberGetter int H5P_DATASET_CREATE();
public static final int H5P_DATASET_CREATE = H5P_DATASET_CREATE();
public static native @MemberGetter int H5P_DATASET_ACCESS();
public static final int H5P_DATASET_ACCESS = H5P_DATASET_ACCESS();
public static native @MemberGetter int H5P_DATASET_XFER();
public static final int H5P_DATASET_XFER = H5P_DATASET_XFER();
public static native @MemberGetter int H5P_FILE_MOUNT();
public static final int H5P_FILE_MOUNT = H5P_FILE_MOUNT();
public static native @MemberGetter int H5P_GROUP_CREATE();
public static final int H5P_GROUP_CREATE = H5P_GROUP_CREATE();
public static native @MemberGetter int H5P_GROUP_ACCESS();
public static final int H5P_GROUP_ACCESS = H5P_GROUP_ACCESS();
public static native @MemberGetter int H5P_DATATYPE_CREATE();
public static final int H5P_DATATYPE_CREATE = H5P_DATATYPE_CREATE();
public static native @MemberGetter int H5P_DATATYPE_ACCESS();
public static final int H5P_DATATYPE_ACCESS = H5P_DATATYPE_ACCESS();
public static native @MemberGetter int H5P_MAP_CREATE();
public static final int H5P_MAP_CREATE = H5P_MAP_CREATE();
public static native @MemberGetter int H5P_MAP_ACCESS();
public static final int H5P_MAP_ACCESS = H5P_MAP_ACCESS();
public static native @MemberGetter int H5P_STRING_CREATE();
public static final int H5P_STRING_CREATE = H5P_STRING_CREATE();
public static native @MemberGetter int H5P_ATTRIBUTE_CREATE();
public static final int H5P_ATTRIBUTE_CREATE = H5P_ATTRIBUTE_CREATE();
public static native @MemberGetter int H5P_ATTRIBUTE_ACCESS();
public static final int H5P_ATTRIBUTE_ACCESS = H5P_ATTRIBUTE_ACCESS();
public static native @MemberGetter int H5P_OBJECT_COPY();
public static final int H5P_OBJECT_COPY = H5P_OBJECT_COPY();
public static native @MemberGetter int H5P_LINK_CREATE();
public static final int H5P_LINK_CREATE = H5P_LINK_CREATE();
public static native @MemberGetter int H5P_LINK_ACCESS();
public static final int H5P_LINK_ACCESS = H5P_LINK_ACCESS();
public static native @MemberGetter int H5P_VOL_INITIALIZE();
public static final int H5P_VOL_INITIALIZE = H5P_VOL_INITIALIZE();
public static native @MemberGetter int H5P_REFERENCE_ACCESS();
public static final int H5P_REFERENCE_ACCESS = H5P_REFERENCE_ACCESS();

/*
 * The library's default property lists
 */
public static native @MemberGetter int H5P_FILE_CREATE_DEFAULT();
public static final int H5P_FILE_CREATE_DEFAULT = H5P_FILE_CREATE_DEFAULT();
public static native @MemberGetter int H5P_FILE_ACCESS_DEFAULT();
public static final int H5P_FILE_ACCESS_DEFAULT = H5P_FILE_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_DATASET_CREATE_DEFAULT();
public static final int H5P_DATASET_CREATE_DEFAULT = H5P_DATASET_CREATE_DEFAULT();
public static native @MemberGetter int H5P_DATASET_ACCESS_DEFAULT();
public static final int H5P_DATASET_ACCESS_DEFAULT = H5P_DATASET_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_DATASET_XFER_DEFAULT();
public static final int H5P_DATASET_XFER_DEFAULT = H5P_DATASET_XFER_DEFAULT();
public static native @MemberGetter int H5P_FILE_MOUNT_DEFAULT();
public static final int H5P_FILE_MOUNT_DEFAULT = H5P_FILE_MOUNT_DEFAULT();
public static native @MemberGetter int H5P_GROUP_CREATE_DEFAULT();
public static final int H5P_GROUP_CREATE_DEFAULT = H5P_GROUP_CREATE_DEFAULT();
public static native @MemberGetter int H5P_GROUP_ACCESS_DEFAULT();
public static final int H5P_GROUP_ACCESS_DEFAULT = H5P_GROUP_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_DATATYPE_CREATE_DEFAULT();
public static final int H5P_DATATYPE_CREATE_DEFAULT = H5P_DATATYPE_CREATE_DEFAULT();
public static native @MemberGetter int H5P_DATATYPE_ACCESS_DEFAULT();
public static final int H5P_DATATYPE_ACCESS_DEFAULT = H5P_DATATYPE_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_MAP_CREATE_DEFAULT();
public static final int H5P_MAP_CREATE_DEFAULT = H5P_MAP_CREATE_DEFAULT();
public static native @MemberGetter int H5P_MAP_ACCESS_DEFAULT();
public static final int H5P_MAP_ACCESS_DEFAULT = H5P_MAP_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_ATTRIBUTE_CREATE_DEFAULT();
public static final int H5P_ATTRIBUTE_CREATE_DEFAULT = H5P_ATTRIBUTE_CREATE_DEFAULT();
public static native @MemberGetter int H5P_ATTRIBUTE_ACCESS_DEFAULT();
public static final int H5P_ATTRIBUTE_ACCESS_DEFAULT = H5P_ATTRIBUTE_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_OBJECT_COPY_DEFAULT();
public static final int H5P_OBJECT_COPY_DEFAULT = H5P_OBJECT_COPY_DEFAULT();
public static native @MemberGetter int H5P_LINK_CREATE_DEFAULT();
public static final int H5P_LINK_CREATE_DEFAULT = H5P_LINK_CREATE_DEFAULT();
public static native @MemberGetter int H5P_LINK_ACCESS_DEFAULT();
public static final int H5P_LINK_ACCESS_DEFAULT = H5P_LINK_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_VOL_INITIALIZE_DEFAULT();
public static final int H5P_VOL_INITIALIZE_DEFAULT = H5P_VOL_INITIALIZE_DEFAULT();
public static native @MemberGetter int H5P_REFERENCE_ACCESS_DEFAULT();
public static final int H5P_REFERENCE_ACCESS_DEFAULT = H5P_REFERENCE_ACCESS_DEFAULT();

/* Common creation order flags (for links in groups and attributes on objects) */
public static final int H5P_CRT_ORDER_TRACKED =           0x0001;
public static final int H5P_CRT_ORDER_INDEXED =           0x0002;

/* Default value for all property list classes */
public static native @MemberGetter int H5P_DEFAULT();
public static final int H5P_DEFAULT = H5P_DEFAULT();

// #ifdef __cplusplus
// Targeting ..\H5P_cls_create_func_t.java


// Targeting ..\H5P_cls_copy_func_t.java


// Targeting ..\H5P_cls_close_func_t.java


// Targeting ..\H5P_prp_cb1_t.java


// Targeting ..\H5P_prp_cb2_t.java


// Targeting ..\H5P_prp_encode_func_t.java


// Targeting ..\H5P_prp_decode_func_t.java


// Targeting ..\H5P_prp_compare_func_t.java


// Targeting ..\H5P_iterate_t.java



/* Actual IO mode property */
/** enum H5D_mpio_actual_chunk_opt_mode_t */
public static final int
    /* The default value, H5D_MPIO_NO_CHUNK_OPTIMIZATION, is used for all I/O
     * operations that do not use chunk optimizations, including non-collective
     * I/O and contiguous collective I/O.
     */
    H5D_MPIO_NO_CHUNK_OPTIMIZATION = 0,
    H5D_MPIO_LINK_CHUNK = 1,
    H5D_MPIO_MULTI_CHUNK = 2;

/** enum H5D_mpio_actual_io_mode_t */
public static final int
    /* The following four values are conveniently defined as a bit field so that
     * we can switch from the default to independent or collective and then to
     * mixed without having to check the original value.
     *
     * NO_COLLECTIVE means that either collective I/O wasn't requested or that
     * no I/O took place.
     *
     * CHUNK_INDEPENDENT means that collective I/O was requested, but the
     * chunk optimization scheme chose independent I/O for each chunk.
     */
    H5D_MPIO_NO_COLLECTIVE = 0x0,
    H5D_MPIO_CHUNK_INDEPENDENT = 0x1,
    H5D_MPIO_CHUNK_COLLECTIVE = 0x2,
    H5D_MPIO_CHUNK_MIXED = 0x1 | 0x2,

    /* The contiguous case is separate from the bit field. */
    H5D_MPIO_CONTIGUOUS_COLLECTIVE = 0x4;

/* Broken collective IO property */
/** enum H5D_mpio_no_collective_cause_t */
public static final int
    H5D_MPIO_COLLECTIVE = 0x00,
    H5D_MPIO_SET_INDEPENDENT = 0x01,
    H5D_MPIO_DATATYPE_CONVERSION = 0x02,
    H5D_MPIO_DATA_TRANSFORMS = 0x04,
    H5D_MPIO_MPI_OPT_TYPES_ENV_VAR_DISABLED = 0x08,
    H5D_MPIO_NOT_SIMPLE_OR_SCALAR_DATASPACES = 0x10,
    H5D_MPIO_NOT_CONTIGUOUS_OR_CHUNKED_DATASET = 0x20,
    H5D_MPIO_PARALLEL_FILTERED_WRITES_DISABLED = 0x40,
    H5D_MPIO_ERROR_WHILE_CHECKING_COLLECTIVE_POSSIBLE = 0x80,
    H5D_MPIO_NO_COLLECTIVE_MAX_CAUSE = 0x100;

/********************/
/* Public Variables */
/********************/

/* Property list class IDs */
/* (Internal to library, do not use!  Use macros above) */
public static native @Cast("hid_t") long H5P_CLS_ROOT_ID_g(); public static native void H5P_CLS_ROOT_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_OBJECT_CREATE_ID_g(); public static native void H5P_CLS_OBJECT_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_FILE_CREATE_ID_g(); public static native void H5P_CLS_FILE_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_FILE_ACCESS_ID_g(); public static native void H5P_CLS_FILE_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_DATASET_CREATE_ID_g(); public static native void H5P_CLS_DATASET_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_DATASET_ACCESS_ID_g(); public static native void H5P_CLS_DATASET_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_DATASET_XFER_ID_g(); public static native void H5P_CLS_DATASET_XFER_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_FILE_MOUNT_ID_g(); public static native void H5P_CLS_FILE_MOUNT_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_GROUP_CREATE_ID_g(); public static native void H5P_CLS_GROUP_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_GROUP_ACCESS_ID_g(); public static native void H5P_CLS_GROUP_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_DATATYPE_CREATE_ID_g(); public static native void H5P_CLS_DATATYPE_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_DATATYPE_ACCESS_ID_g(); public static native void H5P_CLS_DATATYPE_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_MAP_CREATE_ID_g(); public static native void H5P_CLS_MAP_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_MAP_ACCESS_ID_g(); public static native void H5P_CLS_MAP_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_STRING_CREATE_ID_g(); public static native void H5P_CLS_STRING_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_ATTRIBUTE_CREATE_ID_g(); public static native void H5P_CLS_ATTRIBUTE_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_ATTRIBUTE_ACCESS_ID_g(); public static native void H5P_CLS_ATTRIBUTE_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_OBJECT_COPY_ID_g(); public static native void H5P_CLS_OBJECT_COPY_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_LINK_CREATE_ID_g(); public static native void H5P_CLS_LINK_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_LINK_ACCESS_ID_g(); public static native void H5P_CLS_LINK_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_VOL_INITIALIZE_ID_g(); public static native void H5P_CLS_VOL_INITIALIZE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_REFERENCE_ACCESS_ID_g(); public static native void H5P_CLS_REFERENCE_ACCESS_ID_g(long setter);

/* Default roperty list IDs */
/* (Internal to library, do not use!  Use macros above) */
public static native @Cast("hid_t") long H5P_LST_FILE_CREATE_ID_g(); public static native void H5P_LST_FILE_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_FILE_ACCESS_ID_g(); public static native void H5P_LST_FILE_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_DATASET_CREATE_ID_g(); public static native void H5P_LST_DATASET_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_DATASET_ACCESS_ID_g(); public static native void H5P_LST_DATASET_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_DATASET_XFER_ID_g(); public static native void H5P_LST_DATASET_XFER_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_FILE_MOUNT_ID_g(); public static native void H5P_LST_FILE_MOUNT_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_GROUP_CREATE_ID_g(); public static native void H5P_LST_GROUP_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_GROUP_ACCESS_ID_g(); public static native void H5P_LST_GROUP_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_DATATYPE_CREATE_ID_g(); public static native void H5P_LST_DATATYPE_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_DATATYPE_ACCESS_ID_g(); public static native void H5P_LST_DATATYPE_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_MAP_CREATE_ID_g(); public static native void H5P_LST_MAP_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_MAP_ACCESS_ID_g(); public static native void H5P_LST_MAP_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_ATTRIBUTE_CREATE_ID_g(); public static native void H5P_LST_ATTRIBUTE_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_ATTRIBUTE_ACCESS_ID_g(); public static native void H5P_LST_ATTRIBUTE_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_OBJECT_COPY_ID_g(); public static native void H5P_LST_OBJECT_COPY_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_LINK_CREATE_ID_g(); public static native void H5P_LST_LINK_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_LINK_ACCESS_ID_g(); public static native void H5P_LST_LINK_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_VOL_INITIALIZE_ID_g(); public static native void H5P_LST_VOL_INITIALIZE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_REFERENCE_ACCESS_ID_g(); public static native void H5P_LST_REFERENCE_ACCESS_ID_g(long setter);

/*********************/
/* Public Prototypes */
/*********************/

/* Generic property list routines */
public static native @Cast("hid_t") long H5Pcreate_class(@Cast("hid_t") long parent, @Cast("const char*") BytePointer name,
    H5P_cls_create_func_t cls_create, Pointer create_data,
    H5P_cls_copy_func_t cls_copy, Pointer copy_data,
    H5P_cls_close_func_t cls_close, Pointer close_data);
public static native @Cast("hid_t") long H5Pcreate_class(@Cast("hid_t") long parent, String name,
    H5P_cls_create_func_t cls_create, Pointer create_data,
    H5P_cls_copy_func_t cls_copy, Pointer copy_data,
    H5P_cls_close_func_t cls_close, Pointer close_data);
public static native @Cast("char*") BytePointer H5Pget_class_name(@Cast("hid_t") long pclass_id);
public static native @Cast("hid_t") long H5Pcreate(@Cast("hid_t") long cls_id);
public static native @Cast("herr_t") int H5Pregister2(@Cast("hid_t") long cls_id, @Cast("const char*") BytePointer name, @Cast("size_t") long size,
    Pointer def_value, @Cast("H5P_prp_create_func_t") H5P_prp_cb1_t prp_create,
    @Cast("H5P_prp_set_func_t") H5P_prp_cb2_t prp_set, @Cast("H5P_prp_get_func_t") H5P_prp_cb2_t prp_get,
    @Cast("H5P_prp_delete_func_t") H5P_prp_cb2_t prp_del, @Cast("H5P_prp_copy_func_t") H5P_prp_cb1_t prp_copy,
    H5P_prp_compare_func_t prp_cmp, @Cast("H5P_prp_close_func_t") H5P_prp_cb1_t prp_close);
public static native @Cast("herr_t") int H5Pregister2(@Cast("hid_t") long cls_id, String name, @Cast("size_t") long size,
    Pointer def_value, @Cast("H5P_prp_create_func_t") H5P_prp_cb1_t prp_create,
    @Cast("H5P_prp_set_func_t") H5P_prp_cb2_t prp_set, @Cast("H5P_prp_get_func_t") H5P_prp_cb2_t prp_get,
    @Cast("H5P_prp_delete_func_t") H5P_prp_cb2_t prp_del, @Cast("H5P_prp_copy_func_t") H5P_prp_cb1_t prp_copy,
    H5P_prp_compare_func_t prp_cmp, @Cast("H5P_prp_close_func_t") H5P_prp_cb1_t prp_close);
public static native @Cast("herr_t") int H5Pinsert2(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer name, @Cast("size_t") long size,
    Pointer value, @Cast("H5P_prp_set_func_t") H5P_prp_cb2_t prp_set, @Cast("H5P_prp_get_func_t") H5P_prp_cb2_t prp_get,
    @Cast("H5P_prp_delete_func_t") H5P_prp_cb2_t prp_delete, @Cast("H5P_prp_copy_func_t") H5P_prp_cb1_t prp_copy,
    H5P_prp_compare_func_t prp_cmp, @Cast("H5P_prp_close_func_t") H5P_prp_cb1_t prp_close);
public static native @Cast("herr_t") int H5Pinsert2(@Cast("hid_t") long plist_id, String name, @Cast("size_t") long size,
    Pointer value, @Cast("H5P_prp_set_func_t") H5P_prp_cb2_t prp_set, @Cast("H5P_prp_get_func_t") H5P_prp_cb2_t prp_get,
    @Cast("H5P_prp_delete_func_t") H5P_prp_cb2_t prp_delete, @Cast("H5P_prp_copy_func_t") H5P_prp_cb1_t prp_copy,
    H5P_prp_compare_func_t prp_cmp, @Cast("H5P_prp_close_func_t") H5P_prp_cb1_t prp_close);
public static native @Cast("herr_t") int H5Pset(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer name, @Const Pointer value);
public static native @Cast("herr_t") int H5Pset(@Cast("hid_t") long plist_id, String name, @Const Pointer value);
public static native @Cast("htri_t") int H5Pexist(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer name);
public static native @Cast("htri_t") int H5Pexist(@Cast("hid_t") long plist_id, String name);
public static native @Cast("herr_t") int H5Pencode2(@Cast("hid_t") long plist_id, Pointer buf, @Cast("size_t*") SizeTPointer nalloc, @Cast("hid_t") long fapl_id);
public static native @Cast("hid_t") long H5Pdecode(@Const Pointer buf);
public static native @Cast("herr_t") int H5Pget_size(@Cast("hid_t") long id, @Cast("const char*") BytePointer name, @Cast("size_t*") SizeTPointer size);
public static native @Cast("herr_t") int H5Pget_size(@Cast("hid_t") long id, String name, @Cast("size_t*") SizeTPointer size);
public static native @Cast("herr_t") int H5Pget_nprops(@Cast("hid_t") long id, @Cast("size_t*") SizeTPointer nprops);
public static native @Cast("hid_t") long H5Pget_class(@Cast("hid_t") long plist_id);
public static native @Cast("hid_t") long H5Pget_class_parent(@Cast("hid_t") long pclass_id);
public static native @Cast("herr_t") int H5Pget(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer name, Pointer value);
public static native @Cast("herr_t") int H5Pget(@Cast("hid_t") long plist_id, String name, Pointer value);
public static native @Cast("htri_t") int H5Pequal(@Cast("hid_t") long id1, @Cast("hid_t") long id2);
public static native @Cast("htri_t") int H5Pisa_class(@Cast("hid_t") long plist_id, @Cast("hid_t") long pclass_id);
public static native int H5Piterate(@Cast("hid_t") long id, IntPointer idx, H5P_iterate_t iter_func,
            Pointer iter_data);
public static native int H5Piterate(@Cast("hid_t") long id, IntBuffer idx, H5P_iterate_t iter_func,
            Pointer iter_data);
public static native int H5Piterate(@Cast("hid_t") long id, int[] idx, H5P_iterate_t iter_func,
            Pointer iter_data);
public static native @Cast("herr_t") int H5Pcopy_prop(@Cast("hid_t") long dst_id, @Cast("hid_t") long src_id, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Pcopy_prop(@Cast("hid_t") long dst_id, @Cast("hid_t") long src_id, String name);
public static native @Cast("herr_t") int H5Premove(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Premove(@Cast("hid_t") long plist_id, String name);
public static native @Cast("herr_t") int H5Punregister(@Cast("hid_t") long pclass_id, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Punregister(@Cast("hid_t") long pclass_id, String name);
public static native @Cast("herr_t") int H5Pclose_class(@Cast("hid_t") long plist_id);
public static native @Cast("herr_t") int H5Pclose(@Cast("hid_t") long plist_id);
public static native @Cast("hid_t") long H5Pcopy(@Cast("hid_t") long plist_id);

/* Object creation property list (OCPL) routines */
public static native @Cast("herr_t") int H5Pset_attr_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned") int max_compact, @Cast("unsigned") int min_dense);
public static native @Cast("herr_t") int H5Pget_attr_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer max_compact, @Cast("unsigned*") IntPointer min_dense);
public static native @Cast("herr_t") int H5Pget_attr_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer max_compact, @Cast("unsigned*") IntBuffer min_dense);
public static native @Cast("herr_t") int H5Pget_attr_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] max_compact, @Cast("unsigned*") int[] min_dense);
public static native @Cast("herr_t") int H5Pset_attr_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned") int crt_order_flags);
public static native @Cast("herr_t") int H5Pget_attr_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer crt_order_flags);
public static native @Cast("herr_t") int H5Pget_attr_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer crt_order_flags);
public static native @Cast("herr_t") int H5Pget_attr_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] crt_order_flags);
public static native @Cast("herr_t") int H5Pset_obj_track_times(@Cast("hid_t") long plist_id, @Cast("hbool_t") boolean track_times);
public static native @Cast("herr_t") int H5Pget_obj_track_times(@Cast("hid_t") long plist_id, @Cast("hbool_t*") BoolPointer track_times);
public static native @Cast("herr_t") int H5Pget_obj_track_times(@Cast("hid_t") long plist_id, @Cast("hbool_t*") boolean[] track_times);
public static native @Cast("herr_t") int H5Pmodify_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter,
        @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
        @Cast("const unsigned int*") IntPointer cd_values);
public static native @Cast("herr_t") int H5Pmodify_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter,
        @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
        @Cast("const unsigned int*") IntBuffer cd_values);
public static native @Cast("herr_t") int H5Pmodify_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter,
        @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
        @Cast("const unsigned int*") int[] cd_values);
public static native @Cast("herr_t") int H5Pset_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter,
        @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
        @Cast("const unsigned int*") IntPointer c_values);
public static native @Cast("herr_t") int H5Pset_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter,
        @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
        @Cast("const unsigned int*") IntBuffer c_values);
public static native @Cast("herr_t") int H5Pset_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter,
        @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
        @Cast("const unsigned int*") int[] c_values);
public static native int H5Pget_nfilters(@Cast("hid_t") long plist_id);
public static native @Cast("H5Z_filter_t") int H5Pget_filter2(@Cast("hid_t") long plist_id, @Cast("unsigned") int filter,
       @Cast("unsigned int*") IntPointer flags,
       @Cast("size_t*") SizeTPointer cd_nelmts,
       @Cast("unsigned*") IntPointer cd_values,
       @Cast("size_t") long namelen, @Cast("char*") BytePointer name,
       @Cast("unsigned*") IntPointer filter_config);
public static native @Cast("H5Z_filter_t") int H5Pget_filter2(@Cast("hid_t") long plist_id, @Cast("unsigned") int filter,
       @Cast("unsigned int*") IntBuffer flags,
       @Cast("size_t*") SizeTPointer cd_nelmts,
       @Cast("unsigned*") IntBuffer cd_values,
       @Cast("size_t") long namelen, @Cast("char*") ByteBuffer name,
       @Cast("unsigned*") IntBuffer filter_config);
public static native @Cast("H5Z_filter_t") int H5Pget_filter2(@Cast("hid_t") long plist_id, @Cast("unsigned") int filter,
       @Cast("unsigned int*") int[] flags,
       @Cast("size_t*") SizeTPointer cd_nelmts,
       @Cast("unsigned*") int[] cd_values,
       @Cast("size_t") long namelen, @Cast("char*") byte[] name,
       @Cast("unsigned*") int[] filter_config);
public static native @Cast("herr_t") int H5Pget_filter_by_id2(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int id,
       @Cast("unsigned int*") IntPointer flags, @Cast("size_t*") SizeTPointer cd_nelmts,
       @Cast("unsigned*") IntPointer cd_values, @Cast("size_t") long namelen, @Cast("char*") BytePointer name,
       @Cast("unsigned*") IntPointer filter_config);
public static native @Cast("herr_t") int H5Pget_filter_by_id2(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int id,
       @Cast("unsigned int*") IntBuffer flags, @Cast("size_t*") SizeTPointer cd_nelmts,
       @Cast("unsigned*") IntBuffer cd_values, @Cast("size_t") long namelen, @Cast("char*") ByteBuffer name,
       @Cast("unsigned*") IntBuffer filter_config);
public static native @Cast("herr_t") int H5Pget_filter_by_id2(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int id,
       @Cast("unsigned int*") int[] flags, @Cast("size_t*") SizeTPointer cd_nelmts,
       @Cast("unsigned*") int[] cd_values, @Cast("size_t") long namelen, @Cast("char*") byte[] name,
       @Cast("unsigned*") int[] filter_config);
public static native @Cast("htri_t") int H5Pall_filters_avail(@Cast("hid_t") long plist_id);
public static native @Cast("herr_t") int H5Premove_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter);
public static native @Cast("herr_t") int H5Pset_deflate(@Cast("hid_t") long plist_id, @Cast("unsigned") int aggression);
public static native @Cast("herr_t") int H5Pset_fletcher32(@Cast("hid_t") long plist_id);

/* File creation property list (FCPL) routines */
public static native @Cast("herr_t") int H5Pset_userblock(@Cast("hid_t") long plist_id, @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5Pget_userblock(@Cast("hid_t") long plist_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Pget_userblock(@Cast("hid_t") long plist_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Pget_userblock(@Cast("hid_t") long plist_id, @Cast("hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Pset_sizes(@Cast("hid_t") long plist_id, @Cast("size_t") long sizeof_addr,
       @Cast("size_t") long sizeof_size);
public static native @Cast("herr_t") int H5Pget_sizes(@Cast("hid_t") long plist_id, @Cast("size_t*") SizeTPointer sizeof_addr,
       @Cast("size_t*") SizeTPointer sizeof_size);
public static native @Cast("herr_t") int H5Pset_sym_k(@Cast("hid_t") long plist_id, @Cast("unsigned") int ik, @Cast("unsigned") int lk);
public static native @Cast("herr_t") int H5Pget_sym_k(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer ik, @Cast("unsigned*") IntPointer lk);
public static native @Cast("herr_t") int H5Pget_sym_k(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer ik, @Cast("unsigned*") IntBuffer lk);
public static native @Cast("herr_t") int H5Pget_sym_k(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] ik, @Cast("unsigned*") int[] lk);
public static native @Cast("herr_t") int H5Pset_istore_k(@Cast("hid_t") long plist_id, @Cast("unsigned") int ik);
public static native @Cast("herr_t") int H5Pget_istore_k(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer ik);
public static native @Cast("herr_t") int H5Pget_istore_k(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer ik);
public static native @Cast("herr_t") int H5Pget_istore_k(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] ik);
public static native @Cast("herr_t") int H5Pset_shared_mesg_nindexes(@Cast("hid_t") long plist_id, @Cast("unsigned") int nindexes);
public static native @Cast("herr_t") int H5Pget_shared_mesg_nindexes(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer nindexes);
public static native @Cast("herr_t") int H5Pget_shared_mesg_nindexes(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer nindexes);
public static native @Cast("herr_t") int H5Pget_shared_mesg_nindexes(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] nindexes);
public static native @Cast("herr_t") int H5Pset_shared_mesg_index(@Cast("hid_t") long plist_id, @Cast("unsigned") int index_num, @Cast("unsigned") int mesg_type_flags, @Cast("unsigned") int min_mesg_size);
public static native @Cast("herr_t") int H5Pget_shared_mesg_index(@Cast("hid_t") long plist_id, @Cast("unsigned") int index_num, @Cast("unsigned*") IntPointer mesg_type_flags, @Cast("unsigned*") IntPointer min_mesg_size);
public static native @Cast("herr_t") int H5Pget_shared_mesg_index(@Cast("hid_t") long plist_id, @Cast("unsigned") int index_num, @Cast("unsigned*") IntBuffer mesg_type_flags, @Cast("unsigned*") IntBuffer min_mesg_size);
public static native @Cast("herr_t") int H5Pget_shared_mesg_index(@Cast("hid_t") long plist_id, @Cast("unsigned") int index_num, @Cast("unsigned*") int[] mesg_type_flags, @Cast("unsigned*") int[] min_mesg_size);
public static native @Cast("herr_t") int H5Pset_shared_mesg_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned") int max_list, @Cast("unsigned") int min_btree);
public static native @Cast("herr_t") int H5Pget_shared_mesg_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer max_list, @Cast("unsigned*") IntPointer min_btree);
public static native @Cast("herr_t") int H5Pget_shared_mesg_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer max_list, @Cast("unsigned*") IntBuffer min_btree);
public static native @Cast("herr_t") int H5Pget_shared_mesg_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] max_list, @Cast("unsigned*") int[] min_btree);
public static native @Cast("herr_t") int H5Pset_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t") int strategy, @Cast("hbool_t") boolean persist, @Cast("hsize_t") long threshold);
public static native @Cast("herr_t") int H5Pget_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t*") IntPointer strategy, @Cast("hbool_t*") BoolPointer persist, @Cast("hsize_t*") LongPointer threshold);
public static native @Cast("herr_t") int H5Pget_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t*") IntBuffer strategy, @Cast("hbool_t*") boolean[] persist, @Cast("hsize_t*") LongBuffer threshold);
public static native @Cast("herr_t") int H5Pget_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t*") int[] strategy, @Cast("hbool_t*") BoolPointer persist, @Cast("hsize_t*") long[] threshold);
public static native @Cast("herr_t") int H5Pget_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t*") IntPointer strategy, @Cast("hbool_t*") boolean[] persist, @Cast("hsize_t*") LongPointer threshold);
public static native @Cast("herr_t") int H5Pget_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t*") IntBuffer strategy, @Cast("hbool_t*") BoolPointer persist, @Cast("hsize_t*") LongBuffer threshold);
public static native @Cast("herr_t") int H5Pget_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t*") int[] strategy, @Cast("hbool_t*") boolean[] persist, @Cast("hsize_t*") long[] threshold);
public static native @Cast("herr_t") int H5Pset_file_space_page_size(@Cast("hid_t") long plist_id, @Cast("hsize_t") long fsp_size);
public static native @Cast("herr_t") int H5Pget_file_space_page_size(@Cast("hid_t") long plist_id, @Cast("hsize_t*") LongPointer fsp_size);
public static native @Cast("herr_t") int H5Pget_file_space_page_size(@Cast("hid_t") long plist_id, @Cast("hsize_t*") LongBuffer fsp_size);
public static native @Cast("herr_t") int H5Pget_file_space_page_size(@Cast("hid_t") long plist_id, @Cast("hsize_t*") long[] fsp_size);

/* File access property list (FAPL) routines */
public static native @Cast("herr_t") int H5Pset_alignment(@Cast("hid_t") long fapl_id, @Cast("hsize_t") long threshold,
    @Cast("hsize_t") long alignment);
public static native @Cast("herr_t") int H5Pget_alignment(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongPointer threshold,
    @Cast("hsize_t*") LongPointer alignment);
public static native @Cast("herr_t") int H5Pget_alignment(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongBuffer threshold,
    @Cast("hsize_t*") LongBuffer alignment);
public static native @Cast("herr_t") int H5Pget_alignment(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") long[] threshold,
    @Cast("hsize_t*") long[] alignment);
public static native @Cast("herr_t") int H5Pset_driver(@Cast("hid_t") long plist_id, @Cast("hid_t") long driver_id,
        @Const Pointer driver_info);
public static native @Cast("hid_t") long H5Pget_driver(@Cast("hid_t") long plist_id);
public static native @Const Pointer H5Pget_driver_info(@Cast("hid_t") long plist_id);
public static native @Cast("herr_t") int H5Pset_vol(@Cast("hid_t") long plist_id, @Cast("hid_t") long new_vol_id, @Const Pointer new_vol_info);
public static native @Cast("herr_t") int H5Pget_vol_id(@Cast("hid_t") long plist_id, @Cast("hid_t*") LongPointer vol_id);
public static native @Cast("herr_t") int H5Pget_vol_id(@Cast("hid_t") long plist_id, @Cast("hid_t*") LongBuffer vol_id);
public static native @Cast("herr_t") int H5Pget_vol_id(@Cast("hid_t") long plist_id, @Cast("hid_t*") long[] vol_id);
public static native @Cast("herr_t") int H5Pget_vol_info(@Cast("hid_t") long plist_id, @Cast("void**") PointerPointer vol_info);
public static native @Cast("herr_t") int H5Pget_vol_info(@Cast("hid_t") long plist_id, @Cast("void**") @ByPtrPtr Pointer vol_info);
public static native @Cast("herr_t") int H5Pset_family_offset(@Cast("hid_t") long fapl_id, @Cast("hsize_t") long offset);
public static native @Cast("herr_t") int H5Pget_family_offset(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongPointer offset);
public static native @Cast("herr_t") int H5Pget_family_offset(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongBuffer offset);
public static native @Cast("herr_t") int H5Pget_family_offset(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") long[] offset);
public static native @Cast("herr_t") int H5Pset_multi_type(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t") int type);
public static native @Cast("herr_t") int H5Pget_multi_type(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t*") IntPointer type);
public static native @Cast("herr_t") int H5Pget_multi_type(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t*") IntBuffer type);
public static native @Cast("herr_t") int H5Pget_multi_type(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t*") int[] type);
public static native @Cast("herr_t") int H5Pset_cache(@Cast("hid_t") long plist_id, int mdc_nelmts,
       @Cast("size_t") long rdcc_nslots, @Cast("size_t") long rdcc_nbytes,
       double rdcc_w0);
public static native @Cast("herr_t") int H5Pget_cache(@Cast("hid_t") long plist_id,
       IntPointer mdc_nelmts,
       @Cast("size_t*") SizeTPointer rdcc_nslots,
       @Cast("size_t*") SizeTPointer rdcc_nbytes, DoublePointer rdcc_w0);
public static native @Cast("herr_t") int H5Pget_cache(@Cast("hid_t") long plist_id,
       IntBuffer mdc_nelmts,
       @Cast("size_t*") SizeTPointer rdcc_nslots,
       @Cast("size_t*") SizeTPointer rdcc_nbytes, DoubleBuffer rdcc_w0);
public static native @Cast("herr_t") int H5Pget_cache(@Cast("hid_t") long plist_id,
       int[] mdc_nelmts,
       @Cast("size_t*") SizeTPointer rdcc_nslots,
       @Cast("size_t*") SizeTPointer rdcc_nbytes, double[] rdcc_w0);
public static native @Cast("herr_t") int H5Pset_mdc_config(@Cast("hid_t") long plist_id,
       H5AC_cache_config_t config_ptr);
public static native @Cast("herr_t") int H5Pget_mdc_config(@Cast("hid_t") long plist_id,
       H5AC_cache_config_t config_ptr);    /* out */
public static native @Cast("herr_t") int H5Pset_gc_references(@Cast("hid_t") long fapl_id, @Cast("unsigned") int gc_ref);
public static native @Cast("herr_t") int H5Pget_gc_references(@Cast("hid_t") long fapl_id, @Cast("unsigned*") IntPointer gc_ref);
public static native @Cast("herr_t") int H5Pget_gc_references(@Cast("hid_t") long fapl_id, @Cast("unsigned*") IntBuffer gc_ref);
public static native @Cast("herr_t") int H5Pget_gc_references(@Cast("hid_t") long fapl_id, @Cast("unsigned*") int[] gc_ref);
public static native @Cast("herr_t") int H5Pset_fclose_degree(@Cast("hid_t") long fapl_id, @Cast("H5F_close_degree_t") int degree);
public static native @Cast("herr_t") int H5Pget_fclose_degree(@Cast("hid_t") long fapl_id, @Cast("H5F_close_degree_t*") IntPointer degree);
public static native @Cast("herr_t") int H5Pget_fclose_degree(@Cast("hid_t") long fapl_id, @Cast("H5F_close_degree_t*") IntBuffer degree);
public static native @Cast("herr_t") int H5Pget_fclose_degree(@Cast("hid_t") long fapl_id, @Cast("H5F_close_degree_t*") int[] degree);
public static native @Cast("herr_t") int H5Pset_meta_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5Pget_meta_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Pget_meta_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Pget_meta_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Pset_sieve_buf_size(@Cast("hid_t") long fapl_id, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Pget_sieve_buf_size(@Cast("hid_t") long fapl_id, @Cast("size_t*") SizeTPointer size);
public static native @Cast("herr_t") int H5Pset_small_data_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5Pget_small_data_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Pget_small_data_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Pget_small_data_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Pset_libver_bounds(@Cast("hid_t") long plist_id, @Cast("H5F_libver_t") int low,
    @Cast("H5F_libver_t") int high);
public static native @Cast("herr_t") int H5Pget_libver_bounds(@Cast("hid_t") long plist_id, @Cast("H5F_libver_t*") IntPointer low,
    @Cast("H5F_libver_t*") IntPointer high);
public static native @Cast("herr_t") int H5Pget_libver_bounds(@Cast("hid_t") long plist_id, @Cast("H5F_libver_t*") IntBuffer low,
    @Cast("H5F_libver_t*") IntBuffer high);
public static native @Cast("herr_t") int H5Pget_libver_bounds(@Cast("hid_t") long plist_id, @Cast("H5F_libver_t*") int[] low,
    @Cast("H5F_libver_t*") int[] high);
public static native @Cast("herr_t") int H5Pset_elink_file_cache_size(@Cast("hid_t") long plist_id, @Cast("unsigned") int efc_size);
public static native @Cast("herr_t") int H5Pget_elink_file_cache_size(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer efc_size);
public static native @Cast("herr_t") int H5Pget_elink_file_cache_size(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer efc_size);
public static native @Cast("herr_t") int H5Pget_elink_file_cache_size(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] efc_size);
public static native @Cast("herr_t") int H5Pset_file_image(@Cast("hid_t") long fapl_id, Pointer buf_ptr, @Cast("size_t") long buf_len);
public static native @Cast("herr_t") int H5Pget_file_image(@Cast("hid_t") long fapl_id, @Cast("void**") PointerPointer buf_ptr_ptr, @Cast("size_t*") SizeTPointer buf_len_ptr);
public static native @Cast("herr_t") int H5Pget_file_image(@Cast("hid_t") long fapl_id, @Cast("void**") @ByPtrPtr Pointer buf_ptr_ptr, @Cast("size_t*") SizeTPointer buf_len_ptr);
public static native @Cast("herr_t") int H5Pset_file_image_callbacks(@Cast("hid_t") long fapl_id,
       H5FD_file_image_callbacks_t callbacks_ptr);
public static native @Cast("herr_t") int H5Pget_file_image_callbacks(@Cast("hid_t") long fapl_id,
       H5FD_file_image_callbacks_t callbacks_ptr);
public static native @Cast("herr_t") int H5Pset_core_write_tracking(@Cast("hid_t") long fapl_id, @Cast("hbool_t") boolean is_enabled, @Cast("size_t") long page_size);
public static native @Cast("herr_t") int H5Pget_core_write_tracking(@Cast("hid_t") long fapl_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("size_t*") SizeTPointer page_size);
public static native @Cast("herr_t") int H5Pget_core_write_tracking(@Cast("hid_t") long fapl_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("size_t*") SizeTPointer page_size);
public static native @Cast("herr_t") int H5Pset_metadata_read_attempts(@Cast("hid_t") long plist_id, @Cast("unsigned") int attempts);
public static native @Cast("herr_t") int H5Pget_metadata_read_attempts(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer attempts);
public static native @Cast("herr_t") int H5Pget_metadata_read_attempts(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer attempts);
public static native @Cast("herr_t") int H5Pget_metadata_read_attempts(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] attempts);
public static native @Cast("herr_t") int H5Pset_object_flush_cb(@Cast("hid_t") long plist_id, H5F_flush_cb_t func, Pointer udata);
public static native @Cast("herr_t") int H5Pget_object_flush_cb(@Cast("hid_t") long plist_id, @ByPtrPtr H5F_flush_cb_t func, @Cast("void**") PointerPointer udata);
public static native @Cast("herr_t") int H5Pget_object_flush_cb(@Cast("hid_t") long plist_id, @ByPtrPtr H5F_flush_cb_t func, @Cast("void**") @ByPtrPtr Pointer udata);
public static native @Cast("herr_t") int H5Pset_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t") boolean is_enabled, @Cast("const char*") BytePointer location, @Cast("hbool_t") boolean start_on_access);
public static native @Cast("herr_t") int H5Pset_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t") boolean is_enabled, String location, @Cast("hbool_t") boolean start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("char*") BytePointer location, @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") BoolPointer start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("char*") ByteBuffer location, @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") boolean[] start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("char*") byte[] location, @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") BoolPointer start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("char*") BytePointer location, @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") boolean[] start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("char*") ByteBuffer location, @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") BoolPointer start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("char*") byte[] location, @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") boolean[] start_on_access);
public static native @Cast("herr_t") int H5Pset_evict_on_close(@Cast("hid_t") long fapl_id, @Cast("hbool_t") boolean evict_on_close);
public static native @Cast("herr_t") int H5Pget_evict_on_close(@Cast("hid_t") long fapl_id, @Cast("hbool_t*") BoolPointer evict_on_close);
public static native @Cast("herr_t") int H5Pget_evict_on_close(@Cast("hid_t") long fapl_id, @Cast("hbool_t*") boolean[] evict_on_close);
// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */
public static native @Cast("herr_t") int H5Pset_mdc_image_config(@Cast("hid_t") long plist_id, H5AC_cache_image_config_t config_ptr);
public static native @Cast("herr_t") int H5Pget_mdc_image_config(@Cast("hid_t") long plist_id, H5AC_cache_image_config_t config_ptr);
public static native @Cast("herr_t") int H5Pset_page_buffer_size(@Cast("hid_t") long plist_id, @Cast("size_t") long buf_size, @Cast("unsigned") int min_meta_per, @Cast("unsigned") int min_raw_per);
public static native @Cast("herr_t") int H5Pget_page_buffer_size(@Cast("hid_t") long plist_id, @Cast("size_t*") SizeTPointer buf_size, @Cast("unsigned*") IntPointer min_meta_per, @Cast("unsigned*") IntPointer min_raw_per);
public static native @Cast("herr_t") int H5Pget_page_buffer_size(@Cast("hid_t") long plist_id, @Cast("size_t*") SizeTPointer buf_size, @Cast("unsigned*") IntBuffer min_meta_per, @Cast("unsigned*") IntBuffer min_raw_per);
public static native @Cast("herr_t") int H5Pget_page_buffer_size(@Cast("hid_t") long plist_id, @Cast("size_t*") SizeTPointer buf_size, @Cast("unsigned*") int[] min_meta_per, @Cast("unsigned*") int[] min_raw_per);

/* Dataset creation property list (DCPL) routines */
public static native @Cast("herr_t") int H5Pset_layout(@Cast("hid_t") long plist_id, @Cast("H5D_layout_t") int layout);
public static native @Cast("H5D_layout_t") int H5Pget_layout(@Cast("hid_t") long plist_id);
public static native @Cast("herr_t") int H5Pset_chunk(@Cast("hid_t") long plist_id, int ndims, @Cast("const hsize_t*") LongPointer dim);
public static native @Cast("herr_t") int H5Pset_chunk(@Cast("hid_t") long plist_id, int ndims, @Cast("const hsize_t*") LongBuffer dim);
public static native @Cast("herr_t") int H5Pset_chunk(@Cast("hid_t") long plist_id, int ndims, @Cast("const hsize_t*") long[] dim);
public static native int H5Pget_chunk(@Cast("hid_t") long plist_id, int max_ndims, @Cast("hsize_t*") LongPointer dim);
public static native int H5Pget_chunk(@Cast("hid_t") long plist_id, int max_ndims, @Cast("hsize_t*") LongBuffer dim);
public static native int H5Pget_chunk(@Cast("hid_t") long plist_id, int max_ndims, @Cast("hsize_t*") long[] dim);
public static native @Cast("herr_t") int H5Pset_virtual(@Cast("hid_t") long dcpl_id, @Cast("hid_t") long vspace_id,
    @Cast("const char*") BytePointer src_file_name, @Cast("const char*") BytePointer src_dset_name, @Cast("hid_t") long src_space_id);
public static native @Cast("herr_t") int H5Pset_virtual(@Cast("hid_t") long dcpl_id, @Cast("hid_t") long vspace_id,
    String src_file_name, String src_dset_name, @Cast("hid_t") long src_space_id);
public static native @Cast("herr_t") int H5Pget_virtual_count(@Cast("hid_t") long dcpl_id, @Cast("size_t*") SizeTPointer count);
public static native @Cast("hid_t") long H5Pget_virtual_vspace(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index);
public static native @Cast("hid_t") long H5Pget_virtual_srcspace(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index);
public static native @Cast("ssize_t") long H5Pget_virtual_filename(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index,
    @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_virtual_filename(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index,
    @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_virtual_filename(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index,
    @Cast("char*") byte[] name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_virtual_dsetname(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index,
    @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_virtual_dsetname(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index,
    @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_virtual_dsetname(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index,
    @Cast("char*") byte[] name, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Pset_external(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer name, @Cast("off_t") long offset,
          @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5Pset_external(@Cast("hid_t") long plist_id, String name, @Cast("off_t") long offset,
          @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5Pset_chunk_opts(@Cast("hid_t") long plist_id, @Cast("unsigned") int opts);
public static native @Cast("herr_t") int H5Pget_chunk_opts(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer opts);
public static native @Cast("herr_t") int H5Pget_chunk_opts(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer opts);
public static native @Cast("herr_t") int H5Pget_chunk_opts(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] opts);
public static native int H5Pget_external_count(@Cast("hid_t") long plist_id);
public static native @Cast("herr_t") int H5Pget_external(@Cast("hid_t") long plist_id, @Cast("unsigned") int idx, @Cast("size_t") long name_size,
          @Cast("char*") BytePointer name, @Cast("off_t*") SizeTPointer offset,
          @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Pget_external(@Cast("hid_t") long plist_id, @Cast("unsigned") int idx, @Cast("size_t") long name_size,
          @Cast("char*") ByteBuffer name, @Cast("off_t*") SizeTPointer offset,
          @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Pget_external(@Cast("hid_t") long plist_id, @Cast("unsigned") int idx, @Cast("size_t") long name_size,
          @Cast("char*") byte[] name, @Cast("off_t*") SizeTPointer offset,
          @Cast("hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Pset_szip(@Cast("hid_t") long plist_id, @Cast("unsigned") int options_mask, @Cast("unsigned") int pixels_per_block);
public static native @Cast("herr_t") int H5Pset_shuffle(@Cast("hid_t") long plist_id);
public static native @Cast("herr_t") int H5Pset_nbit(@Cast("hid_t") long plist_id);
public static native @Cast("herr_t") int H5Pset_scaleoffset(@Cast("hid_t") long plist_id, @Cast("H5Z_SO_scale_type_t") int scale_type, int scale_factor);
public static native @Cast("herr_t") int H5Pset_fill_value(@Cast("hid_t") long plist_id, @Cast("hid_t") long type_id,
     @Const Pointer value);
public static native @Cast("herr_t") int H5Pget_fill_value(@Cast("hid_t") long plist_id, @Cast("hid_t") long type_id,
     Pointer value);
public static native @Cast("herr_t") int H5Pfill_value_defined(@Cast("hid_t") long plist, @Cast("H5D_fill_value_t*") IntPointer status);
public static native @Cast("herr_t") int H5Pfill_value_defined(@Cast("hid_t") long plist, @Cast("H5D_fill_value_t*") IntBuffer status);
public static native @Cast("herr_t") int H5Pfill_value_defined(@Cast("hid_t") long plist, @Cast("H5D_fill_value_t*") int[] status);
public static native @Cast("herr_t") int H5Pset_alloc_time(@Cast("hid_t") long plist_id, @Cast("H5D_alloc_time_t") int alloc_time);
public static native @Cast("herr_t") int H5Pget_alloc_time(@Cast("hid_t") long plist_id, @Cast("H5D_alloc_time_t*") IntPointer alloc_time);
public static native @Cast("herr_t") int H5Pget_alloc_time(@Cast("hid_t") long plist_id, @Cast("H5D_alloc_time_t*") IntBuffer alloc_time);
public static native @Cast("herr_t") int H5Pget_alloc_time(@Cast("hid_t") long plist_id, @Cast("H5D_alloc_time_t*") int[] alloc_time);
public static native @Cast("herr_t") int H5Pset_fill_time(@Cast("hid_t") long plist_id, @Cast("H5D_fill_time_t") int fill_time);
public static native @Cast("herr_t") int H5Pget_fill_time(@Cast("hid_t") long plist_id, @Cast("H5D_fill_time_t*") IntPointer fill_time);
public static native @Cast("herr_t") int H5Pget_fill_time(@Cast("hid_t") long plist_id, @Cast("H5D_fill_time_t*") IntBuffer fill_time);
public static native @Cast("herr_t") int H5Pget_fill_time(@Cast("hid_t") long plist_id, @Cast("H5D_fill_time_t*") int[] fill_time);
public static native @Cast("herr_t") int H5Pget_dset_no_attrs_hint(@Cast("hid_t") long dcpl_id, @Cast("hbool_t*") BoolPointer minimize);
public static native @Cast("herr_t") int H5Pget_dset_no_attrs_hint(@Cast("hid_t") long dcpl_id, @Cast("hbool_t*") boolean[] minimize);
public static native @Cast("herr_t") int H5Pset_dset_no_attrs_hint(@Cast("hid_t") long dcpl_id, @Cast("hbool_t") boolean minimize);

/* Dataset access property list (DAPL) routines */
public static native @Cast("herr_t") int H5Pset_chunk_cache(@Cast("hid_t") long dapl_id, @Cast("size_t") long rdcc_nslots,
       @Cast("size_t") long rdcc_nbytes, double rdcc_w0);
public static native @Cast("herr_t") int H5Pget_chunk_cache(@Cast("hid_t") long dapl_id,
       @Cast("size_t*") SizeTPointer rdcc_nslots,
       @Cast("size_t*") SizeTPointer rdcc_nbytes,
       DoublePointer rdcc_w0);
public static native @Cast("herr_t") int H5Pget_chunk_cache(@Cast("hid_t") long dapl_id,
       @Cast("size_t*") SizeTPointer rdcc_nslots,
       @Cast("size_t*") SizeTPointer rdcc_nbytes,
       DoubleBuffer rdcc_w0);
public static native @Cast("herr_t") int H5Pget_chunk_cache(@Cast("hid_t") long dapl_id,
       @Cast("size_t*") SizeTPointer rdcc_nslots,
       @Cast("size_t*") SizeTPointer rdcc_nbytes,
       double[] rdcc_w0);
public static native @Cast("herr_t") int H5Pset_virtual_view(@Cast("hid_t") long plist_id, @Cast("H5D_vds_view_t") int view);
public static native @Cast("herr_t") int H5Pget_virtual_view(@Cast("hid_t") long plist_id, @Cast("H5D_vds_view_t*") IntPointer view);
public static native @Cast("herr_t") int H5Pget_virtual_view(@Cast("hid_t") long plist_id, @Cast("H5D_vds_view_t*") IntBuffer view);
public static native @Cast("herr_t") int H5Pget_virtual_view(@Cast("hid_t") long plist_id, @Cast("H5D_vds_view_t*") int[] view);
public static native @Cast("herr_t") int H5Pset_virtual_printf_gap(@Cast("hid_t") long plist_id, @Cast("hsize_t") long gap_size);
public static native @Cast("herr_t") int H5Pget_virtual_printf_gap(@Cast("hid_t") long plist_id, @Cast("hsize_t*") LongPointer gap_size);
public static native @Cast("herr_t") int H5Pget_virtual_printf_gap(@Cast("hid_t") long plist_id, @Cast("hsize_t*") LongBuffer gap_size);
public static native @Cast("herr_t") int H5Pget_virtual_printf_gap(@Cast("hid_t") long plist_id, @Cast("hsize_t*") long[] gap_size);
public static native @Cast("herr_t") int H5Pset_virtual_prefix(@Cast("hid_t") long dapl_id, @Cast("const char*") BytePointer prefix);
public static native @Cast("herr_t") int H5Pset_virtual_prefix(@Cast("hid_t") long dapl_id, String prefix);
public static native @Cast("ssize_t") long H5Pget_virtual_prefix(@Cast("hid_t") long dapl_id, @Cast("char*") BytePointer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_virtual_prefix(@Cast("hid_t") long dapl_id, @Cast("char*") ByteBuffer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_virtual_prefix(@Cast("hid_t") long dapl_id, @Cast("char*") byte[] prefix, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Pset_append_flush(@Cast("hid_t") long plist_id, @Cast("unsigned") int ndims,
    @Cast("const hsize_t*") LongPointer boundary, H5D_append_cb_t func, Pointer udata);
public static native @Cast("herr_t") int H5Pset_append_flush(@Cast("hid_t") long plist_id, @Cast("unsigned") int ndims,
    @Cast("const hsize_t*") LongBuffer boundary, H5D_append_cb_t func, Pointer udata);
public static native @Cast("herr_t") int H5Pset_append_flush(@Cast("hid_t") long plist_id, @Cast("unsigned") int ndims,
    @Cast("const hsize_t*") long[] boundary, H5D_append_cb_t func, Pointer udata);
public static native @Cast("herr_t") int H5Pget_append_flush(@Cast("hid_t") long plist_id, @Cast("unsigned") int dims,
    @Cast("hsize_t*") LongPointer boundary, @ByPtrPtr H5D_append_cb_t func, @Cast("void**") PointerPointer udata);
public static native @Cast("herr_t") int H5Pget_append_flush(@Cast("hid_t") long plist_id, @Cast("unsigned") int dims,
    @Cast("hsize_t*") LongPointer boundary, @ByPtrPtr H5D_append_cb_t func, @Cast("void**") @ByPtrPtr Pointer udata);
public static native @Cast("herr_t") int H5Pget_append_flush(@Cast("hid_t") long plist_id, @Cast("unsigned") int dims,
    @Cast("hsize_t*") LongBuffer boundary, @ByPtrPtr H5D_append_cb_t func, @Cast("void**") @ByPtrPtr Pointer udata);
public static native @Cast("herr_t") int H5Pget_append_flush(@Cast("hid_t") long plist_id, @Cast("unsigned") int dims,
    @Cast("hsize_t*") long[] boundary, @ByPtrPtr H5D_append_cb_t func, @Cast("void**") @ByPtrPtr Pointer udata);
public static native @Cast("herr_t") int H5Pset_efile_prefix(@Cast("hid_t") long dapl_id, @Cast("const char*") BytePointer prefix);
public static native @Cast("herr_t") int H5Pset_efile_prefix(@Cast("hid_t") long dapl_id, String prefix);
public static native @Cast("ssize_t") long H5Pget_efile_prefix(@Cast("hid_t") long dapl_id, @Cast("char*") BytePointer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_efile_prefix(@Cast("hid_t") long dapl_id, @Cast("char*") ByteBuffer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_efile_prefix(@Cast("hid_t") long dapl_id, @Cast("char*") byte[] prefix, @Cast("size_t") long size);

/* Dataset xfer property list (DXPL) routines */
public static native @Cast("herr_t") int H5Pset_data_transform(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer expression);
public static native @Cast("herr_t") int H5Pset_data_transform(@Cast("hid_t") long plist_id, String expression);
public static native @Cast("ssize_t") long H5Pget_data_transform(@Cast("hid_t") long plist_id, @Cast("char*") BytePointer expression, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_data_transform(@Cast("hid_t") long plist_id, @Cast("char*") ByteBuffer expression, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_data_transform(@Cast("hid_t") long plist_id, @Cast("char*") byte[] expression, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Pset_buffer(@Cast("hid_t") long plist_id, @Cast("size_t") long size, Pointer tconv,
        Pointer bkg);
public static native @Cast("size_t") long H5Pget_buffer(@Cast("hid_t") long plist_id, @Cast("void**") PointerPointer tconv,
        @Cast("void**") PointerPointer bkg);
public static native @Cast("size_t") long H5Pget_buffer(@Cast("hid_t") long plist_id, @Cast("void**") @ByPtrPtr Pointer tconv,
        @Cast("void**") @ByPtrPtr Pointer bkg);
public static native @Cast("herr_t") int H5Pset_preserve(@Cast("hid_t") long plist_id, @Cast("hbool_t") boolean status);
public static native int H5Pget_preserve(@Cast("hid_t") long plist_id);
public static native @Cast("herr_t") int H5Pset_edc_check(@Cast("hid_t") long plist_id, @Cast("H5Z_EDC_t") int check);
public static native @Cast("H5Z_EDC_t") int H5Pget_edc_check(@Cast("hid_t") long plist_id);
public static native @Cast("herr_t") int H5Pset_filter_callback(@Cast("hid_t") long plist_id, H5Z_filter_func_t func,
                                     Pointer op_data);
public static native @Cast("herr_t") int H5Pset_btree_ratios(@Cast("hid_t") long plist_id, double left, double middle,
       double right);
public static native @Cast("herr_t") int H5Pget_btree_ratios(@Cast("hid_t") long plist_id, DoublePointer left,
       DoublePointer middle,
       DoublePointer right);
public static native @Cast("herr_t") int H5Pget_btree_ratios(@Cast("hid_t") long plist_id, DoubleBuffer left,
       DoubleBuffer middle,
       DoubleBuffer right);
public static native @Cast("herr_t") int H5Pget_btree_ratios(@Cast("hid_t") long plist_id, double[] left,
       double[] middle,
       double[] right);
public static native @Cast("herr_t") int H5Pset_vlen_mem_manager(@Cast("hid_t") long plist_id,
                                       H5MM_allocate_t alloc_func,
                                       Pointer alloc_info, H5MM_free_t free_func,
                                       Pointer free_info);
public static native @Cast("herr_t") int H5Pget_vlen_mem_manager(@Cast("hid_t") long plist_id,
                                       @ByPtrPtr H5MM_allocate_t alloc_func,
                                       @Cast("void**") PointerPointer alloc_info,
                                       @ByPtrPtr H5MM_free_t free_func,
                                       @Cast("void**") PointerPointer free_info);
public static native @Cast("herr_t") int H5Pget_vlen_mem_manager(@Cast("hid_t") long plist_id,
                                       @ByPtrPtr H5MM_allocate_t alloc_func,
                                       @Cast("void**") @ByPtrPtr Pointer alloc_info,
                                       @ByPtrPtr H5MM_free_t free_func,
                                       @Cast("void**") @ByPtrPtr Pointer free_info);
public static native @Cast("herr_t") int H5Pset_hyper_vector_size(@Cast("hid_t") long fapl_id, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Pget_hyper_vector_size(@Cast("hid_t") long fapl_id, @Cast("size_t*") SizeTPointer size);
public static native @Cast("herr_t") int H5Pset_type_conv_cb(@Cast("hid_t") long dxpl_id, H5T_conv_except_func_t op, Pointer operate_data);
public static native @Cast("herr_t") int H5Pget_type_conv_cb(@Cast("hid_t") long dxpl_id, @ByPtrPtr H5T_conv_except_func_t op, @Cast("void**") PointerPointer operate_data);
public static native @Cast("herr_t") int H5Pget_type_conv_cb(@Cast("hid_t") long dxpl_id, @ByPtrPtr H5T_conv_except_func_t op, @Cast("void**") @ByPtrPtr Pointer operate_data);
// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */

/* Link creation property list (LCPL) routines */
public static native @Cast("herr_t") int H5Pset_create_intermediate_group(@Cast("hid_t") long plist_id, @Cast("unsigned") int crt_intmd);
public static native @Cast("herr_t") int H5Pget_create_intermediate_group(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer crt_intmd);
public static native @Cast("herr_t") int H5Pget_create_intermediate_group(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer crt_intmd);
public static native @Cast("herr_t") int H5Pget_create_intermediate_group(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] crt_intmd);

/* Group creation property list (GCPL) routines */
public static native @Cast("herr_t") int H5Pset_local_heap_size_hint(@Cast("hid_t") long plist_id, @Cast("size_t") long size_hint);
public static native @Cast("herr_t") int H5Pget_local_heap_size_hint(@Cast("hid_t") long plist_id, @Cast("size_t*") SizeTPointer size_hint);
public static native @Cast("herr_t") int H5Pset_link_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned") int max_compact, @Cast("unsigned") int min_dense);
public static native @Cast("herr_t") int H5Pget_link_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer max_compact, @Cast("unsigned*") IntPointer min_dense);
public static native @Cast("herr_t") int H5Pget_link_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer max_compact, @Cast("unsigned*") IntBuffer min_dense);
public static native @Cast("herr_t") int H5Pget_link_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] max_compact, @Cast("unsigned*") int[] min_dense);
public static native @Cast("herr_t") int H5Pset_est_link_info(@Cast("hid_t") long plist_id, @Cast("unsigned") int est_num_entries, @Cast("unsigned") int est_name_len);
public static native @Cast("herr_t") int H5Pget_est_link_info(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer est_num_entries, @Cast("unsigned*") IntPointer est_name_len);
public static native @Cast("herr_t") int H5Pget_est_link_info(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer est_num_entries, @Cast("unsigned*") IntBuffer est_name_len);
public static native @Cast("herr_t") int H5Pget_est_link_info(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] est_num_entries, @Cast("unsigned*") int[] est_name_len);
public static native @Cast("herr_t") int H5Pset_link_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned") int crt_order_flags);
public static native @Cast("herr_t") int H5Pget_link_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer crt_order_flags);
public static native @Cast("herr_t") int H5Pget_link_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer crt_order_flags);
public static native @Cast("herr_t") int H5Pget_link_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] crt_order_flags);

/* Map access property list (MAPL) routines */
// #ifdef H5_HAVE_MAP_API
// #endif /*  H5_HAVE_MAP_API */

/* String creation property list (STRCPL) routines */
public static native @Cast("herr_t") int H5Pset_char_encoding(@Cast("hid_t") long plist_id, @Cast("H5T_cset_t") int encoding);
public static native @Cast("herr_t") int H5Pget_char_encoding(@Cast("hid_t") long plist_id, @Cast("H5T_cset_t*") IntPointer encoding);
public static native @Cast("herr_t") int H5Pget_char_encoding(@Cast("hid_t") long plist_id, @Cast("H5T_cset_t*") IntBuffer encoding);
public static native @Cast("herr_t") int H5Pget_char_encoding(@Cast("hid_t") long plist_id, @Cast("H5T_cset_t*") int[] encoding);

/* Link access property list (LAPL) routines */
public static native @Cast("herr_t") int H5Pset_nlinks(@Cast("hid_t") long plist_id, @Cast("size_t") long nlinks);
public static native @Cast("herr_t") int H5Pget_nlinks(@Cast("hid_t") long plist_id, @Cast("size_t*") SizeTPointer nlinks);
public static native @Cast("herr_t") int H5Pset_elink_prefix(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer prefix);
public static native @Cast("herr_t") int H5Pset_elink_prefix(@Cast("hid_t") long plist_id, String prefix);
public static native @Cast("ssize_t") long H5Pget_elink_prefix(@Cast("hid_t") long plist_id, @Cast("char*") BytePointer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_elink_prefix(@Cast("hid_t") long plist_id, @Cast("char*") ByteBuffer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_elink_prefix(@Cast("hid_t") long plist_id, @Cast("char*") byte[] prefix, @Cast("size_t") long size);
public static native @Cast("hid_t") long H5Pget_elink_fapl(@Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Pset_elink_fapl(@Cast("hid_t") long lapl_id, @Cast("hid_t") long fapl_id);
public static native @Cast("herr_t") int H5Pset_elink_acc_flags(@Cast("hid_t") long lapl_id, @Cast("unsigned") int flags);
public static native @Cast("herr_t") int H5Pget_elink_acc_flags(@Cast("hid_t") long lapl_id, @Cast("unsigned*") IntPointer flags);
public static native @Cast("herr_t") int H5Pget_elink_acc_flags(@Cast("hid_t") long lapl_id, @Cast("unsigned*") IntBuffer flags);
public static native @Cast("herr_t") int H5Pget_elink_acc_flags(@Cast("hid_t") long lapl_id, @Cast("unsigned*") int[] flags);
public static native @Cast("herr_t") int H5Pset_elink_cb(@Cast("hid_t") long lapl_id, H5L_elink_traverse_t func, Pointer op_data);
public static native @Cast("herr_t") int H5Pget_elink_cb(@Cast("hid_t") long lapl_id, @ByPtrPtr H5L_elink_traverse_t func, @Cast("void**") PointerPointer op_data);
public static native @Cast("herr_t") int H5Pget_elink_cb(@Cast("hid_t") long lapl_id, @ByPtrPtr H5L_elink_traverse_t func, @Cast("void**") @ByPtrPtr Pointer op_data);

/* Object copy property list (OCPYPL) routines */
public static native @Cast("herr_t") int H5Pset_copy_object(@Cast("hid_t") long plist_id, @Cast("unsigned") int crt_intmd);
public static native @Cast("herr_t") int H5Pget_copy_object(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer crt_intmd);
public static native @Cast("herr_t") int H5Pget_copy_object(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer crt_intmd);
public static native @Cast("herr_t") int H5Pget_copy_object(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] crt_intmd);
public static native @Cast("herr_t") int H5Padd_merge_committed_dtype_path(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer path);
public static native @Cast("herr_t") int H5Padd_merge_committed_dtype_path(@Cast("hid_t") long plist_id, String path);
public static native @Cast("herr_t") int H5Pfree_merge_committed_dtype_paths(@Cast("hid_t") long plist_id);
public static native @Cast("herr_t") int H5Pset_mcdt_search_cb(@Cast("hid_t") long plist_id, H5O_mcdt_search_cb_t func, Pointer op_data);
public static native @Cast("herr_t") int H5Pget_mcdt_search_cb(@Cast("hid_t") long plist_id, @ByPtrPtr H5O_mcdt_search_cb_t func, @Cast("void**") PointerPointer op_data);
public static native @Cast("herr_t") int H5Pget_mcdt_search_cb(@Cast("hid_t") long plist_id, @ByPtrPtr H5O_mcdt_search_cb_t func, @Cast("void**") @ByPtrPtr Pointer op_data);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS
// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Ppublic_H */



// Parsed from H5PLpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5. The full HDF5 copyright notice, including      *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5PL module.
 */

// #ifndef _H5PLpublic_H
// #define _H5PLpublic_H

/* Public headers needed by this file */
// #include "H5public.h"          /* Generic Functions                    */

/*******************/
/* Public Typedefs */
/*******************/

/* Special string to indicate no plugin loading.
 */
public static final String H5PL_NO_PLUGIN =          "::";

/* Plugin type used by the plugin library */
/** enum H5PL_type_t */
public static final int
    H5PL_TYPE_ERROR         = -1,   /* Error                */
    H5PL_TYPE_FILTER        = 0,   /* Filter               */
    H5PL_TYPE_VOL           = 1,   /* VOL driver           */
    H5PL_TYPE_NONE          = 2;    /* This must be last!   */

/* Common dynamic plugin type flags used by the set/get_loading_state functions */
public static final int H5PL_FILTER_PLUGIN =      0x0001;
public static final int H5PL_VOL_PLUGIN =         0x0002;
public static final int H5PL_ALL_PLUGIN =         0xFFFF;

// #ifdef __cplusplus
// #endif

/* plugin state */
public static native @Cast("herr_t") int H5PLset_loading_state(@Cast("unsigned int") int plugin_control_mask);
public static native @Cast("herr_t") int H5PLget_loading_state(@Cast("unsigned int*") IntPointer plugin_control_mask);
public static native @Cast("herr_t") int H5PLget_loading_state(@Cast("unsigned int*") IntBuffer plugin_control_mask);
public static native @Cast("herr_t") int H5PLget_loading_state(@Cast("unsigned int*") int[] plugin_control_mask);
public static native @Cast("herr_t") int H5PLappend(@Cast("const char*") BytePointer search_path);
public static native @Cast("herr_t") int H5PLappend(String search_path);
public static native @Cast("herr_t") int H5PLprepend(@Cast("const char*") BytePointer search_path);
public static native @Cast("herr_t") int H5PLprepend(String search_path);
public static native @Cast("herr_t") int H5PLreplace(@Cast("const char*") BytePointer search_path, @Cast("unsigned int") int index);
public static native @Cast("herr_t") int H5PLreplace(String search_path, @Cast("unsigned int") int index);
public static native @Cast("herr_t") int H5PLinsert(@Cast("const char*") BytePointer search_path, @Cast("unsigned int") int index);
public static native @Cast("herr_t") int H5PLinsert(String search_path, @Cast("unsigned int") int index);
public static native @Cast("herr_t") int H5PLremove(@Cast("unsigned int") int index);
public static native @Cast("ssize_t") long H5PLget(@Cast("unsigned int") int index, @Cast("char*") BytePointer path_buf, @Cast("size_t") long buf_size);
public static native @Cast("ssize_t") long H5PLget(@Cast("unsigned int") int index, @Cast("char*") ByteBuffer path_buf, @Cast("size_t") long buf_size);
public static native @Cast("ssize_t") long H5PLget(@Cast("unsigned int") int index, @Cast("char*") byte[] path_buf, @Cast("size_t") long buf_size);
public static native @Cast("herr_t") int H5PLsize(@Cast("unsigned int*") IntPointer num_paths);
public static native @Cast("herr_t") int H5PLsize(@Cast("unsigned int*") IntBuffer num_paths);
public static native @Cast("herr_t") int H5PLsize(@Cast("unsigned int*") int[] num_paths);

// #ifdef __cplusplus
// #endif

// #endif /* _H5PLpublic_H */



// Parsed from H5Rpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5R module.
 */
// #ifndef _H5Rpublic_H
// #define _H5Rpublic_H

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Gpublic.h"
// #include "H5Ipublic.h"

/*****************/
/* Public Macros */
/*****************/

/* Deprecated reference buffer sizes that are kept for backward compatibility */
public static native @MemberGetter int H5R_OBJ_REF_BUF_SIZE();
public static final int H5R_OBJ_REF_BUF_SIZE = H5R_OBJ_REF_BUF_SIZE();
public static native @MemberGetter int H5R_DSET_REG_REF_BUF_SIZE();
public static final int H5R_DSET_REG_REF_BUF_SIZE = H5R_DSET_REG_REF_BUF_SIZE();

/* Default reference buffer size.
 * Note! Be careful with the sizes of the references because they should really
 * depend on the run-time values in the file.
 */
public static final int H5R_REF_BUF_SIZE =            (64);

/*******************/
/* Public Typedefs */
/*******************/

/*
 * Reference types allowed.
 * DO NOT CHANGE THE ORDER or VALUES as reference type values are encoded into
 * the datatype message header.
 */
/** enum H5R_type_t */
public static final int
    H5R_BADTYPE     =   (-1),   /* Invalid reference type           */
    H5R_OBJECT1     = 0,    /* Backward compatibility (object)  */
    H5R_DATASET_REGION1 = 1,    /* Backward compatibility (region)  */
    H5R_OBJECT2         = 2,    /* Object reference                 */
    H5R_DATASET_REGION2 = 3,    /* Region reference                 */
    H5R_ATTR            = 4,    /* Attribute Reference              */
    H5R_MAXTYPE         = 5;     /* Highest type (invalid)           */

/* Deprecated types are kept for backward compatibility with previous versions */

/**
 * Deprecated object reference type that is used with deprecated reference APIs.
 * Note! This type can only be used with the "native" HDF5 VOL connector.
 */
// Targeting ..\hdset_reg_ref_t.java


// Targeting ..\H5R_ref_t.java



/********************/
/* Public Variables */
/********************/


/*********************/
/* Public Prototypes */
/*********************/

// #ifdef __cplusplus
// #endif

/* Constructors */
public static native @Cast("herr_t") int H5Rcreate_object(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long oapl_id, H5R_ref_t ref_ptr);
public static native @Cast("herr_t") int H5Rcreate_object(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long oapl_id, H5R_ref_t ref_ptr);
public static native @Cast("herr_t") int H5Rcreate_region(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long space_id, @Cast("hid_t") long oapl_id, H5R_ref_t ref_ptr);
public static native @Cast("herr_t") int H5Rcreate_region(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long space_id, @Cast("hid_t") long oapl_id, H5R_ref_t ref_ptr);
public static native @Cast("herr_t") int H5Rcreate_attr(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("const char*") BytePointer attr_name, @Cast("hid_t") long oapl_id, H5R_ref_t ref_ptr);
public static native @Cast("herr_t") int H5Rcreate_attr(@Cast("hid_t") long loc_id, String name, String attr_name, @Cast("hid_t") long oapl_id, H5R_ref_t ref_ptr);
public static native @Cast("herr_t") int H5Rdestroy(H5R_ref_t ref_ptr);

/* Info */
public static native @Cast("H5R_type_t") int H5Rget_type(@Const H5R_ref_t ref_ptr);
public static native @Cast("htri_t") int H5Requal(@Const H5R_ref_t ref1_ptr, @Const H5R_ref_t ref2_ptr);
public static native @Cast("herr_t") int H5Rcopy(@Const H5R_ref_t src_ref_ptr, H5R_ref_t dst_ref_ptr);

/* Dereference */
public static native @Cast("hid_t") long H5Ropen_object(H5R_ref_t ref_ptr, @Cast("hid_t") long rapl_id, @Cast("hid_t") long oapl_id);
public static native @Cast("hid_t") long H5Ropen_region(H5R_ref_t ref_ptr, @Cast("hid_t") long rapl_id, @Cast("hid_t") long oapl_id);
public static native @Cast("hid_t") long H5Ropen_attr(H5R_ref_t ref_ptr, @Cast("hid_t") long rapl_id, @Cast("hid_t") long aapl_id);

/* Get type */
public static native @Cast("herr_t") int H5Rget_obj_type3(H5R_ref_t ref_ptr, @Cast("hid_t") long rapl_id, @Cast("H5O_type_t*") IntPointer obj_type);
public static native @Cast("herr_t") int H5Rget_obj_type3(H5R_ref_t ref_ptr, @Cast("hid_t") long rapl_id, @Cast("H5O_type_t*") IntBuffer obj_type);
public static native @Cast("herr_t") int H5Rget_obj_type3(H5R_ref_t ref_ptr, @Cast("hid_t") long rapl_id, @Cast("H5O_type_t*") int[] obj_type);

/* Get name */
public static native @Cast("ssize_t") long H5Rget_file_name(@Const H5R_ref_t ref_ptr, @Cast("char*") BytePointer buf, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Rget_file_name(@Const H5R_ref_t ref_ptr, @Cast("char*") ByteBuffer buf, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Rget_file_name(@Const H5R_ref_t ref_ptr, @Cast("char*") byte[] buf, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Rget_obj_name(H5R_ref_t ref_ptr, @Cast("hid_t") long rapl_id, @Cast("char*") BytePointer buf, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Rget_obj_name(H5R_ref_t ref_ptr, @Cast("hid_t") long rapl_id, @Cast("char*") ByteBuffer buf, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Rget_obj_name(H5R_ref_t ref_ptr, @Cast("hid_t") long rapl_id, @Cast("char*") byte[] buf, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Rget_attr_name(@Const H5R_ref_t ref_ptr, @Cast("char*") BytePointer buf, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Rget_attr_name(@Const H5R_ref_t ref_ptr, @Cast("char*") ByteBuffer buf, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Rget_attr_name(@Const H5R_ref_t ref_ptr, @Cast("char*") byte[] buf, @Cast("size_t") long size);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is or will be deprecated.
 */

/* Macros */

/* Versions for compatibility */
public static final int H5R_OBJECT =          H5R_OBJECT1;
public static final int H5R_DATASET_REGION =  H5R_DATASET_REGION1;

/* Function prototypes */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

public static native @Cast("herr_t") int H5Rcreate(Pointer ref, @Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("H5R_type_t") int ref_type, @Cast("hid_t") long space_id);
public static native @Cast("herr_t") int H5Rcreate(Pointer ref, @Cast("hid_t") long loc_id, String name, @Cast("H5R_type_t") int ref_type, @Cast("hid_t") long space_id);
public static native @Cast("herr_t") int H5Rget_obj_type2(@Cast("hid_t") long id, @Cast("H5R_type_t") int ref_type, @Const Pointer ref, @Cast("H5O_type_t*") IntPointer obj_type);
public static native @Cast("herr_t") int H5Rget_obj_type2(@Cast("hid_t") long id, @Cast("H5R_type_t") int ref_type, @Const Pointer ref, @Cast("H5O_type_t*") IntBuffer obj_type);
public static native @Cast("herr_t") int H5Rget_obj_type2(@Cast("hid_t") long id, @Cast("H5R_type_t") int ref_type, @Const Pointer ref, @Cast("H5O_type_t*") int[] obj_type);
public static native @Cast("hid_t") long H5Rdereference2(@Cast("hid_t") long obj_id, @Cast("hid_t") long oapl_id, @Cast("H5R_type_t") int ref_type, @Const Pointer ref);
public static native @Cast("hid_t") long H5Rget_region(@Cast("hid_t") long dataset, @Cast("H5R_type_t") int ref_type, @Const Pointer ref);
public static native @Cast("ssize_t") long H5Rget_name(@Cast("hid_t") long loc_id, @Cast("H5R_type_t") int ref_type, @Const Pointer ref, @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Rget_name(@Cast("hid_t") long loc_id, @Cast("H5R_type_t") int ref_type, @Const Pointer ref, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Rget_name(@Cast("hid_t") long loc_id, @Cast("H5R_type_t") int ref_type, @Const Pointer ref, @Cast("char*") byte[] name, @Cast("size_t") long size);

// #ifdef __cplusplus
// #endif

// #endif  /* _H5Rpublic_H */


// Parsed from H5Spublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5S module.
 */
// #ifndef _H5Spublic_H
// #define _H5Spublic_H

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Ipublic.h"

/* Define atomic datatypes */
public static native @MemberGetter int H5S_ALL();
public static final int H5S_ALL = H5S_ALL();
public static final int H5S_UNLIMITED =   HSIZE_UNDEF;

/* Define user-level maximum number of dimensions */
public static final int H5S_MAX_RANK =    32;

/* Flags for selection iterators */
public static final int H5S_SEL_ITER_GET_SEQ_LIST_SORTED = 0x0001; /* Retrieve elements from iterator
                                                 * in increasing offset order, for
                                                 * each call to retrieve sequences.
                                                 * Currently, this only applies to
                                                 * point selections, as hyperslab
                                                 * selections are always returned
                                                 * in increasing offset order.
                                                 *
                                                 * Note that the order is only
                                                 * increasing for each call to
                                                 * get_seq_list, the next set of
                                                 * sequences could start with an
                                                 * earlier offset than the previous
                                                 * one.
                                                 */
public static final int H5S_SEL_ITER_SHARE_WITH_DATASPACE = 0x0002; /* Don't copy the dataspace
                                                 * selection when creating the
                                                 * selection iterator.
                                                 * 
                                                 * This can improve performance
                                                 * of creating the iterator, but
                                                 * the dataspace _MUST_NOT_ be
                                                 * modified or closed until the
                                                 * selection iterator is closed
                                                 * or the iterator's behavior
                                                 * will be undefined.
                                                 */

/* Different types of dataspaces */
/** enum H5S_class_t */
public static final int
    H5S_NO_CLASS         = -1,  /*error                                      */
    H5S_SCALAR           = 0,   /*scalar variable                            */
    H5S_SIMPLE           = 1,   /*simple dataspace                           */
    H5S_NULL             = 2;    /*null dataspace                             */

/* Different ways of combining selections */
/** enum H5S_seloper_t */
public static final int
    H5S_SELECT_NOOP      = -1,  /* error                                     */
    H5S_SELECT_SET       = 0,   /* Select "set" operation 		     */
    H5S_SELECT_OR = 1,              /* Binary "or" operation for hyperslabs
                                 * (add new selection to existing selection)
                                 * Original region:  AAAAAAAAAA
                                 * New region:             BBBBBBBBBB
                                 * A or B:           CCCCCCCCCCCCCCCC
                                 */
    H5S_SELECT_AND = 2,             /* Binary "and" operation for hyperslabs
                                 * (only leave overlapped regions in selection)
                                 * Original region:  AAAAAAAAAA
                                 * New region:             BBBBBBBBBB
                                 * A and B:                CCCC
                                 */
    H5S_SELECT_XOR = 3,             /* Binary "xor" operation for hyperslabs
                                 * (only leave non-overlapped regions in selection)
                                 * Original region:  AAAAAAAAAA
                                 * New region:             BBBBBBBBBB
                                 * A xor B:          CCCCCC    CCCCCC
                                 */
    H5S_SELECT_NOTB = 4,            /* Binary "not" operation for hyperslabs
                                 * (only leave non-overlapped regions in original selection)
                                 * Original region:  AAAAAAAAAA
                                 * New region:             BBBBBBBBBB
                                 * A not B:          CCCCCC
                                 */
    H5S_SELECT_NOTA = 5,            /* Binary "not" operation for hyperslabs
                                 * (only leave non-overlapped regions in new selection)
                                 * Original region:  AAAAAAAAAA
                                 * New region:             BBBBBBBBBB
                                 * B not A:                    CCCCCC
                                 */
    H5S_SELECT_APPEND = 6,          /* Append elements to end of point selection */
    H5S_SELECT_PREPEND = 7,         /* Prepend elements to beginning of point selection */
    H5S_SELECT_INVALID = 8;          /* Invalid upper bound on selection operations */

/* Enumerated type for the type of selection */
/** enum H5S_sel_type */
public static final int
    H5S_SEL_ERROR	 = -1, 	/* Error			*/
    H5S_SEL_NONE	 = 0,    /* Nothing selected 		*/
    H5S_SEL_POINTS	 = 1,    /* Points / elements selected	*/
    H5S_SEL_HYPERSLABS  = 2,    /* Hyperslab selected           */
    H5S_SEL_ALL		 = 3,    /* Entire extent selected	*/
    H5S_SEL_N = 4;			/*THIS MUST BE LAST		*/

// #ifdef __cplusplus
// #endif

/* Operations on dataspaces */
public static native @Cast("hid_t") long H5Screate(@Cast("H5S_class_t") int type);
public static native @Cast("hid_t") long H5Screate_simple(int rank, @Cast("const hsize_t*") LongPointer dims,
    @Cast("const hsize_t*") LongPointer maxdims);
public static native @Cast("hid_t") long H5Screate_simple(int rank, @Cast("const hsize_t*") LongBuffer dims,
    @Cast("const hsize_t*") LongBuffer maxdims);
public static native @Cast("hid_t") long H5Screate_simple(int rank, @Cast("const hsize_t*") long[] dims,
    @Cast("const hsize_t*") long[] maxdims);
public static native @Cast("herr_t") int H5Sset_extent_simple(@Cast("hid_t") long space_id, int rank,
    @Cast("const hsize_t*") LongPointer dims, @Cast("const hsize_t*") LongPointer max);
public static native @Cast("herr_t") int H5Sset_extent_simple(@Cast("hid_t") long space_id, int rank,
    @Cast("const hsize_t*") LongBuffer dims, @Cast("const hsize_t*") LongBuffer max);
public static native @Cast("herr_t") int H5Sset_extent_simple(@Cast("hid_t") long space_id, int rank,
    @Cast("const hsize_t*") long[] dims, @Cast("const hsize_t*") long[] max);
public static native @Cast("hid_t") long H5Scopy(@Cast("hid_t") long space_id);
public static native @Cast("herr_t") int H5Sclose(@Cast("hid_t") long space_id);
public static native @Cast("herr_t") int H5Sencode2(@Cast("hid_t") long obj_id, Pointer buf, @Cast("size_t*") SizeTPointer nalloc, @Cast("hid_t") long fapl);
public static native @Cast("hid_t") long H5Sdecode(@Const Pointer buf);
public static native @Cast("hssize_t") long H5Sget_simple_extent_npoints(@Cast("hid_t") long space_id);
public static native int H5Sget_simple_extent_ndims(@Cast("hid_t") long space_id);
public static native int H5Sget_simple_extent_dims(@Cast("hid_t") long space_id, @Cast("hsize_t*") LongPointer dims,
    @Cast("hsize_t*") LongPointer maxdims);
public static native int H5Sget_simple_extent_dims(@Cast("hid_t") long space_id, @Cast("hsize_t*") LongBuffer dims,
    @Cast("hsize_t*") LongBuffer maxdims);
public static native int H5Sget_simple_extent_dims(@Cast("hid_t") long space_id, @Cast("hsize_t*") long[] dims,
    @Cast("hsize_t*") long[] maxdims);
public static native @Cast("htri_t") int H5Sis_simple(@Cast("hid_t") long space_id);
public static native @Cast("H5S_class_t") int H5Sget_simple_extent_type(@Cast("hid_t") long space_id);
public static native @Cast("herr_t") int H5Sset_extent_none(@Cast("hid_t") long space_id);
public static native @Cast("herr_t") int H5Sextent_copy(@Cast("hid_t") long dst_id,@Cast("hid_t") long src_id);
public static native @Cast("htri_t") int H5Sextent_equal(@Cast("hid_t") long sid1, @Cast("hid_t") long sid2);

/* Operations on dataspace selections */
public static native @Cast("H5S_sel_type") int H5Sget_select_type(@Cast("hid_t") long spaceid);
public static native @Cast("hssize_t") long H5Sget_select_npoints(@Cast("hid_t") long spaceid);
public static native @Cast("herr_t") int H5Sselect_copy(@Cast("hid_t") long dst_id, @Cast("hid_t") long src_id);
public static native @Cast("htri_t") int H5Sselect_valid(@Cast("hid_t") long spaceid);
public static native @Cast("herr_t") int H5Sselect_adjust(@Cast("hid_t") long spaceid, @Cast("const hssize_t*") LongPointer offset);
public static native @Cast("herr_t") int H5Sselect_adjust(@Cast("hid_t") long spaceid, @Cast("const hssize_t*") LongBuffer offset);
public static native @Cast("herr_t") int H5Sselect_adjust(@Cast("hid_t") long spaceid, @Cast("const hssize_t*") long[] offset);
public static native @Cast("herr_t") int H5Sget_select_bounds(@Cast("hid_t") long spaceid, @Cast("hsize_t*") LongPointer start,
    @Cast("hsize_t*") LongPointer end);
public static native @Cast("herr_t") int H5Sget_select_bounds(@Cast("hid_t") long spaceid, @Cast("hsize_t*") LongBuffer start,
    @Cast("hsize_t*") LongBuffer end);
public static native @Cast("herr_t") int H5Sget_select_bounds(@Cast("hid_t") long spaceid, @Cast("hsize_t*") long[] start,
    @Cast("hsize_t*") long[] end);
public static native @Cast("htri_t") int H5Sselect_shape_same(@Cast("hid_t") long space1_id, @Cast("hid_t") long space2_id);
public static native @Cast("htri_t") int H5Sselect_intersect_block(@Cast("hid_t") long space_id, @Cast("const hsize_t*") LongPointer start,
    @Cast("const hsize_t*") LongPointer end);
public static native @Cast("htri_t") int H5Sselect_intersect_block(@Cast("hid_t") long space_id, @Cast("const hsize_t*") LongBuffer start,
    @Cast("const hsize_t*") LongBuffer end);
public static native @Cast("htri_t") int H5Sselect_intersect_block(@Cast("hid_t") long space_id, @Cast("const hsize_t*") long[] start,
    @Cast("const hsize_t*") long[] end);
public static native @Cast("herr_t") int H5Soffset_simple(@Cast("hid_t") long space_id, @Cast("const hssize_t*") LongPointer offset);
public static native @Cast("herr_t") int H5Soffset_simple(@Cast("hid_t") long space_id, @Cast("const hssize_t*") LongBuffer offset);
public static native @Cast("herr_t") int H5Soffset_simple(@Cast("hid_t") long space_id, @Cast("const hssize_t*") long[] offset);
public static native @Cast("herr_t") int H5Sselect_all(@Cast("hid_t") long spaceid);
public static native @Cast("herr_t") int H5Sselect_none(@Cast("hid_t") long spaceid);
public static native @Cast("herr_t") int H5Sselect_elements(@Cast("hid_t") long space_id, @Cast("H5S_seloper_t") int op,
    @Cast("size_t") long num_elem, @Cast("const hsize_t*") LongPointer coord);
public static native @Cast("herr_t") int H5Sselect_elements(@Cast("hid_t") long space_id, @Cast("H5S_seloper_t") int op,
    @Cast("size_t") long num_elem, @Cast("const hsize_t*") LongBuffer coord);
public static native @Cast("herr_t") int H5Sselect_elements(@Cast("hid_t") long space_id, @Cast("H5S_seloper_t") int op,
    @Cast("size_t") long num_elem, @Cast("const hsize_t*") long[] coord);
public static native @Cast("hssize_t") long H5Sget_select_elem_npoints(@Cast("hid_t") long spaceid);
public static native @Cast("herr_t") int H5Sget_select_elem_pointlist(@Cast("hid_t") long spaceid, @Cast("hsize_t") long startpoint,
    @Cast("hsize_t") long numpoints, @Cast("hsize_t*") LongPointer buf);
public static native @Cast("herr_t") int H5Sget_select_elem_pointlist(@Cast("hid_t") long spaceid, @Cast("hsize_t") long startpoint,
    @Cast("hsize_t") long numpoints, @Cast("hsize_t*") LongBuffer buf);
public static native @Cast("herr_t") int H5Sget_select_elem_pointlist(@Cast("hid_t") long spaceid, @Cast("hsize_t") long startpoint,
    @Cast("hsize_t") long numpoints, @Cast("hsize_t*") long[] buf);
public static native @Cast("herr_t") int H5Sselect_hyperslab(@Cast("hid_t") long space_id, @Cast("H5S_seloper_t") int op,
    @Cast("const hsize_t*") LongPointer start, @Cast("const hsize_t*") LongPointer _stride, @Cast("const hsize_t*") LongPointer count,
    @Cast("const hsize_t*") LongPointer _block);
public static native @Cast("herr_t") int H5Sselect_hyperslab(@Cast("hid_t") long space_id, @Cast("H5S_seloper_t") int op,
    @Cast("const hsize_t*") LongBuffer start, @Cast("const hsize_t*") LongBuffer _stride, @Cast("const hsize_t*") LongBuffer count,
    @Cast("const hsize_t*") LongBuffer _block);
public static native @Cast("herr_t") int H5Sselect_hyperslab(@Cast("hid_t") long space_id, @Cast("H5S_seloper_t") int op,
    @Cast("const hsize_t*") long[] start, @Cast("const hsize_t*") long[] _stride, @Cast("const hsize_t*") long[] count,
    @Cast("const hsize_t*") long[] _block);
public static native @Cast("hid_t") long H5Scombine_hyperslab(@Cast("hid_t") long space_id, @Cast("H5S_seloper_t") int op,
    @Cast("const hsize_t*") LongPointer start, @Cast("const hsize_t*") LongPointer _stride, @Cast("const hsize_t*") LongPointer count,
    @Cast("const hsize_t*") LongPointer _block);
public static native @Cast("hid_t") long H5Scombine_hyperslab(@Cast("hid_t") long space_id, @Cast("H5S_seloper_t") int op,
    @Cast("const hsize_t*") LongBuffer start, @Cast("const hsize_t*") LongBuffer _stride, @Cast("const hsize_t*") LongBuffer count,
    @Cast("const hsize_t*") LongBuffer _block);
public static native @Cast("hid_t") long H5Scombine_hyperslab(@Cast("hid_t") long space_id, @Cast("H5S_seloper_t") int op,
    @Cast("const hsize_t*") long[] start, @Cast("const hsize_t*") long[] _stride, @Cast("const hsize_t*") long[] count,
    @Cast("const hsize_t*") long[] _block);
public static native @Cast("herr_t") int H5Smodify_select(@Cast("hid_t") long space1_id, @Cast("H5S_seloper_t") int op, @Cast("hid_t") long space2_id);
public static native @Cast("hid_t") long H5Scombine_select(@Cast("hid_t") long space1_id, @Cast("H5S_seloper_t") int op, @Cast("hid_t") long space2_id);
public static native @Cast("htri_t") int H5Sis_regular_hyperslab(@Cast("hid_t") long spaceid);
public static native @Cast("htri_t") int H5Sget_regular_hyperslab(@Cast("hid_t") long spaceid, @Cast("hsize_t*") LongPointer start,
    @Cast("hsize_t*") LongPointer stride, @Cast("hsize_t*") LongPointer count, @Cast("hsize_t*") LongPointer block);
public static native @Cast("htri_t") int H5Sget_regular_hyperslab(@Cast("hid_t") long spaceid, @Cast("hsize_t*") LongBuffer start,
    @Cast("hsize_t*") LongBuffer stride, @Cast("hsize_t*") LongBuffer count, @Cast("hsize_t*") LongBuffer block);
public static native @Cast("htri_t") int H5Sget_regular_hyperslab(@Cast("hid_t") long spaceid, @Cast("hsize_t*") long[] start,
    @Cast("hsize_t*") long[] stride, @Cast("hsize_t*") long[] count, @Cast("hsize_t*") long[] block);
public static native @Cast("hssize_t") long H5Sget_select_hyper_nblocks(@Cast("hid_t") long spaceid);
public static native @Cast("herr_t") int H5Sget_select_hyper_blocklist(@Cast("hid_t") long spaceid, @Cast("hsize_t") long startblock,
    @Cast("hsize_t") long numblocks, @Cast("hsize_t*") LongPointer buf);
public static native @Cast("herr_t") int H5Sget_select_hyper_blocklist(@Cast("hid_t") long spaceid, @Cast("hsize_t") long startblock,
    @Cast("hsize_t") long numblocks, @Cast("hsize_t*") LongBuffer buf);
public static native @Cast("herr_t") int H5Sget_select_hyper_blocklist(@Cast("hid_t") long spaceid, @Cast("hsize_t") long startblock,
    @Cast("hsize_t") long numblocks, @Cast("hsize_t*") long[] buf);
public static native @Cast("hid_t") long H5Sselect_project_intersection(@Cast("hid_t") long src_space_id,
    @Cast("hid_t") long dst_space_id, @Cast("hid_t") long src_intersect_space_id);

/* Operations on dataspace selection iterators */
public static native @Cast("hid_t") long H5Ssel_iter_create(@Cast("hid_t") long spaceid, @Cast("size_t") long elmt_size, @Cast("unsigned") int flags);
public static native @Cast("herr_t") int H5Ssel_iter_get_seq_list(@Cast("hid_t") long sel_iter_id, @Cast("size_t") long maxseq,
    @Cast("size_t") long maxbytes, @Cast("size_t*") SizeTPointer nseq, @Cast("size_t*") SizeTPointer nbytes, @Cast("hsize_t*") LongPointer off, @Cast("size_t*") SizeTPointer len);
public static native @Cast("herr_t") int H5Ssel_iter_get_seq_list(@Cast("hid_t") long sel_iter_id, @Cast("size_t") long maxseq,
    @Cast("size_t") long maxbytes, @Cast("size_t*") SizeTPointer nseq, @Cast("size_t*") SizeTPointer nbytes, @Cast("hsize_t*") LongBuffer off, @Cast("size_t*") SizeTPointer len);
public static native @Cast("herr_t") int H5Ssel_iter_get_seq_list(@Cast("hid_t") long sel_iter_id, @Cast("size_t") long maxseq,
    @Cast("size_t") long maxbytes, @Cast("size_t*") SizeTPointer nseq, @Cast("size_t*") SizeTPointer nbytes, @Cast("hsize_t*") long[] off, @Cast("size_t*") SizeTPointer len);
public static native @Cast("herr_t") int H5Ssel_iter_close(@Cast("hid_t") long sel_iter_id);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Spublic_H */



// Parsed from H5FDcore.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Monday, August  2, 1999
 *
 * Purpose:	The public header file for the core driver.
 */
// #ifndef H5FDcore_H
// #define H5FDcore_H

public static native @MemberGetter int H5FD_CORE();
public static final int H5FD_CORE = H5FD_CORE();

// #ifdef __cplusplus
// #endif
public static native @Cast("hid_t") long H5FD_core_init();
public static native @Cast("herr_t") int H5Pset_fapl_core(@Cast("hid_t") long fapl_id, @Cast("size_t") long increment,
				@Cast("hbool_t") boolean backing_store);
public static native @Cast("herr_t") int H5Pget_fapl_core(@Cast("hid_t") long fapl_id, @Cast("size_t*") SizeTPointer increment,
				@Cast("hbool_t*") BoolPointer backing_store);
public static native @Cast("herr_t") int H5Pget_fapl_core(@Cast("hid_t") long fapl_id, @Cast("size_t*") SizeTPointer increment,
				@Cast("hbool_t*") boolean[] backing_store);
// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5FDdirect.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Raymond Lu <slu@hdfgroup.uiuc.edu>
 *              Wednesday, 20 September 2006
 *
 * Purpose:	The public header file for the direct driver.
 */
// #ifndef H5FDdirect_H
// #define H5FDdirect_H

// #ifdef H5_HAVE_DIRECT
// #else
public static final int H5FD_DIRECT =      (-1);
// #endif /* H5_HAVE_DIRECT */

// #ifdef H5_HAVE_DIRECT

// #endif /* H5_HAVE_DIRECT */

// #endif



// Parsed from H5FDfamily.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Monday, August  4, 1999
 *
 * Purpose:	The public header file for the family driver.
 */
// #ifndef H5FDfamily_H
// #define H5FDfamily_H

public static native @MemberGetter int H5FD_FAMILY();
public static final int H5FD_FAMILY = H5FD_FAMILY();

// #ifdef __cplusplus
// #endif

public static native @Cast("hid_t") long H5FD_family_init();
public static native @Cast("herr_t") int H5Pset_fapl_family(@Cast("hid_t") long fapl_id, @Cast("hsize_t") long memb_size,
			  @Cast("hid_t") long memb_fapl_id);
public static native @Cast("herr_t") int H5Pget_fapl_family(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongPointer memb_size,
			  @Cast("hid_t*") LongPointer memb_fapl_id);
public static native @Cast("herr_t") int H5Pget_fapl_family(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongBuffer memb_size,
			  @Cast("hid_t*") LongBuffer memb_fapl_id);
public static native @Cast("herr_t") int H5Pget_fapl_family(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") long[] memb_size,
			  @Cast("hid_t*") long[] memb_fapl_id);

// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5FDlog.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Quincey Koziol <koziol@ncsa.uiuc.edu>
 *              Monday, April 17, 2000
 *
 * Purpose:	The public header file for the log driver.
 */
// #ifndef H5FDlog_H
// #define H5FDlog_H

public static native @MemberGetter int H5FD_LOG();
public static final int H5FD_LOG = H5FD_LOG();

/* Flags for H5Pset_fapl_log() */
/* Flags for tracking 'meta' operations (truncate) */
public static final int H5FD_LOG_TRUNCATE =   0x00000001;
public static final int H5FD_LOG_META_IO =    (H5FD_LOG_TRUNCATE);
/* Flags for tracking where reads/writes/seeks occur */
public static final int H5FD_LOG_LOC_READ =   0x00000002;
public static final int H5FD_LOG_LOC_WRITE =  0x00000004;
public static final int H5FD_LOG_LOC_SEEK =   0x00000008;
public static final int H5FD_LOG_LOC_IO =     (H5FD_LOG_LOC_READ|H5FD_LOG_LOC_WRITE|H5FD_LOG_LOC_SEEK);
/* Flags for tracking number of times each byte is read/written */
public static final int H5FD_LOG_FILE_READ =  0x00000010;
public static final int H5FD_LOG_FILE_WRITE = 0x00000020;
public static final int H5FD_LOG_FILE_IO =    (H5FD_LOG_FILE_READ|H5FD_LOG_FILE_WRITE);
/* Flag for tracking "flavor" (type) of information stored at each byte */
public static final int H5FD_LOG_FLAVOR =     0x00000040;
/* Flags for tracking total number of reads/writes/seeks/truncates */
public static final int H5FD_LOG_NUM_READ =   0x00000080;
public static final int H5FD_LOG_NUM_WRITE =  0x00000100;
public static final int H5FD_LOG_NUM_SEEK =   0x00000200;
public static final int H5FD_LOG_NUM_TRUNCATE = 0x00000400;
public static final int H5FD_LOG_NUM_IO =     (H5FD_LOG_NUM_READ|H5FD_LOG_NUM_WRITE|H5FD_LOG_NUM_SEEK|H5FD_LOG_NUM_TRUNCATE);
/* Flags for tracking time spent in open/stat/read/write/seek/truncate/close */
public static final int H5FD_LOG_TIME_OPEN =  0x00000800;
public static final int H5FD_LOG_TIME_STAT =  0x00001000;
public static final int H5FD_LOG_TIME_READ =  0x00002000;
public static final int H5FD_LOG_TIME_WRITE = 0x00004000;
public static final int H5FD_LOG_TIME_SEEK =  0x00008000;
public static final int H5FD_LOG_TIME_TRUNCATE = 0x00010000;
public static final int H5FD_LOG_TIME_CLOSE = 0x00020000;
public static final int H5FD_LOG_TIME_IO =    (H5FD_LOG_TIME_OPEN|H5FD_LOG_TIME_STAT|H5FD_LOG_TIME_READ|H5FD_LOG_TIME_WRITE|H5FD_LOG_TIME_SEEK|H5FD_LOG_TIME_TRUNCATE|H5FD_LOG_TIME_CLOSE);
/* Flags for tracking allocation/release of space in file */
public static final int H5FD_LOG_ALLOC =      0x00040000;
public static final int H5FD_LOG_FREE =       0x00080000;
public static final int H5FD_LOG_ALL =        (H5FD_LOG_FREE|H5FD_LOG_ALLOC|H5FD_LOG_TIME_IO|H5FD_LOG_NUM_IO|H5FD_LOG_FLAVOR|H5FD_LOG_FILE_IO|H5FD_LOG_LOC_IO|H5FD_LOG_META_IO);

// #ifdef __cplusplus
// #endif

public static native @Cast("hid_t") long H5FD_log_init();
public static native @Cast("herr_t") int H5Pset_fapl_log(@Cast("hid_t") long fapl_id, @Cast("const char*") BytePointer logfile, @Cast("unsigned long long") long flags, @Cast("size_t") long buf_size);
public static native @Cast("herr_t") int H5Pset_fapl_log(@Cast("hid_t") long fapl_id, String logfile, @Cast("unsigned long long") long flags, @Cast("size_t") long buf_size);

// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5FDmpi.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Quincey Koziol <koziol@ncsa.uiuc.edu>
 *              Friday, January 30, 2004
 *
 * Purpose:	The public header file for common items for all MPI VFL drivers
 */
// #ifndef H5FDmpi_H
// #define H5FDmpi_H

/***** Macros for One linked collective IO case. *****/
/* The default value to do one linked collective IO for all chunks.
   If the average number of chunks per process is greater than this value,
      the library will create an MPI derived datatype to link all chunks to do collective IO.
      The user can set this value through an API. */

public static final int H5D_ONE_LINK_CHUNK_IO_THRESHOLD = 0;
/***** Macros for multi-chunk collective IO case. *****/
/* The default value of the threshold to do collective IO for this chunk.
   If the average percentage of processes per chunk is greater than the default value,
   collective IO is done for this chunk.
*/

public static final int H5D_MULTI_CHUNK_IO_COL_THRESHOLD = 60;
/* Type of I/O for data transfer properties */
/** enum H5FD_mpio_xfer_t */
public static final int
    H5FD_MPIO_INDEPENDENT = 0, 		/*zero is the default*/
    H5FD_MPIO_COLLECTIVE = 1;

/* Type of chunked dataset I/O */
/** enum H5FD_mpio_chunk_opt_t */
public static final int
    H5FD_MPIO_CHUNK_DEFAULT = 0,
    H5FD_MPIO_CHUNK_ONE_IO = 1,  		/*zero is the default*/
    H5FD_MPIO_CHUNK_MULTI_IO = 2;

/* Type of collective I/O */
/** enum H5FD_mpio_collective_opt_t */
public static final int
    H5FD_MPIO_COLLECTIVE_IO = 0,
    H5FD_MPIO_INDIVIDUAL_IO = 1;  		/*zero is the default*/

/* Include all the MPI VFL headers */
// #include "H5FDmpio.h"           /* MPI I/O file driver			*/

// #endif /* H5FDmpi_H */



// Parsed from H5FDmulti.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Monday, August  2, 1999
 *
 * Purpose:	The public header file for the "multi" driver.
 */
// #ifndef H5FDmulti_H
// #define H5FDmulti_H

public static native @MemberGetter int H5FD_MULTI();
public static final int H5FD_MULTI = H5FD_MULTI();

// #ifdef __cplusplus
// #endif
public static native @Cast("hid_t") long H5FD_multi_init();
public static native @Cast("herr_t") int H5Pset_fapl_multi(@Cast("hid_t") long fapl_id, @Cast("const H5FD_mem_t*") IntPointer memb_map,
			 @Cast("const hid_t*") LongPointer memb_fapl, @Cast("const char*const*") PointerPointer memb_name,
			 @Cast("const haddr_t*") LongPointer memb_addr, @Cast("hbool_t") boolean relax);
public static native @Cast("herr_t") int H5Pset_fapl_multi(@Cast("hid_t") long fapl_id, @Cast("const H5FD_mem_t*") IntPointer memb_map,
			 @Cast("const hid_t*") LongPointer memb_fapl, @Cast("const char*const*") @ByPtrPtr BytePointer memb_name,
			 @Cast("const haddr_t*") LongPointer memb_addr, @Cast("hbool_t") boolean relax);
public static native @Cast("herr_t") int H5Pset_fapl_multi(@Cast("hid_t") long fapl_id, @Cast("const H5FD_mem_t*") IntBuffer memb_map,
			 @Cast("const hid_t*") LongBuffer memb_fapl, @Cast("const char*const*") @ByPtrPtr ByteBuffer memb_name,
			 @Cast("const haddr_t*") LongBuffer memb_addr, @Cast("hbool_t") boolean relax);
public static native @Cast("herr_t") int H5Pset_fapl_multi(@Cast("hid_t") long fapl_id, @Cast("const H5FD_mem_t*") int[] memb_map,
			 @Cast("const hid_t*") long[] memb_fapl, @Cast("const char*const*") @ByPtrPtr byte[] memb_name,
			 @Cast("const haddr_t*") long[] memb_addr, @Cast("hbool_t") boolean relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t*") IntPointer memb_map,
			 @Cast("hid_t*") LongPointer memb_fapl, @Cast("char**") PointerPointer memb_name,
			 @Cast("haddr_t*") LongPointer memb_addr, @Cast("hbool_t*") BoolPointer relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t*") IntPointer memb_map,
			 @Cast("hid_t*") LongPointer memb_fapl, @Cast("char**") @ByPtrPtr BytePointer memb_name,
			 @Cast("haddr_t*") LongPointer memb_addr, @Cast("hbool_t*") BoolPointer relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t*") IntBuffer memb_map,
			 @Cast("hid_t*") LongBuffer memb_fapl, @Cast("char**") @ByPtrPtr ByteBuffer memb_name,
			 @Cast("haddr_t*") LongBuffer memb_addr, @Cast("hbool_t*") boolean[] relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t*") int[] memb_map,
			 @Cast("hid_t*") long[] memb_fapl, @Cast("char**") @ByPtrPtr byte[] memb_name,
			 @Cast("haddr_t*") long[] memb_addr, @Cast("hbool_t*") BoolPointer relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t*") IntPointer memb_map,
			 @Cast("hid_t*") LongPointer memb_fapl, @Cast("char**") @ByPtrPtr BytePointer memb_name,
			 @Cast("haddr_t*") LongPointer memb_addr, @Cast("hbool_t*") boolean[] relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t*") IntBuffer memb_map,
			 @Cast("hid_t*") LongBuffer memb_fapl, @Cast("char**") @ByPtrPtr ByteBuffer memb_name,
			 @Cast("haddr_t*") LongBuffer memb_addr, @Cast("hbool_t*") BoolPointer relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t*") int[] memb_map,
			 @Cast("hid_t*") long[] memb_fapl, @Cast("char**") @ByPtrPtr byte[] memb_name,
			 @Cast("haddr_t*") long[] memb_addr, @Cast("hbool_t*") boolean[] relax);
public static native @Cast("herr_t") int H5Pset_fapl_split(@Cast("hid_t") long fapl, @Cast("const char*") BytePointer meta_ext,
			 @Cast("hid_t") long meta_plist_id, @Cast("const char*") BytePointer raw_ext,
			 @Cast("hid_t") long raw_plist_id);
public static native @Cast("herr_t") int H5Pset_fapl_split(@Cast("hid_t") long fapl, String meta_ext,
			 @Cast("hid_t") long meta_plist_id, String raw_ext,
			 @Cast("hid_t") long raw_plist_id);
// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5FDsec2.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Monday, August  2, 1999
 *
 * Purpose:	The public header file for the sec2 driver.
 */
// #ifndef H5FDsec2_H
// #define H5FDsec2_H

public static native @MemberGetter int H5FD_SEC2();
public static final int H5FD_SEC2 = H5FD_SEC2();

// #ifdef __cplusplus
// #endif

public static native @Cast("hid_t") long H5FD_sec2_init();
public static native @Cast("herr_t") int H5Pset_fapl_sec2(@Cast("hid_t") long fapl_id);

// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5FDstdio.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Monday, August  2, 1999
 *
 * Purpose:	The public header file for the sec2 driver.
 */
// #ifndef H5FDstdio_H
// #define H5FDstdio_H

// #include "H5Ipublic.h"

public static native @MemberGetter int H5FD_STDIO();
public static final int H5FD_STDIO = H5FD_STDIO();

// #ifdef __cplusplus
// #endif

public static native @Cast("hid_t") long H5FD_stdio_init();
public static native @Cast("herr_t") int H5Pset_fapl_stdio(@Cast("hid_t") long fapl_id);

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from H5DOpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5DOpublic_H
// #define _H5DOpublic_H

// #ifdef __cplusplus
// #endif

/*-------------------------------------------------------------------------
 *
 * "Optimized dataset" routines.
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5DOappend(@Cast("hid_t") long dset_id, @Cast("hid_t") long dxpl_id, @Cast("unsigned") int axis,
    @Cast("size_t") long extension, @Cast("hid_t") long memtype, @Const Pointer buf);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5DSpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5DSpublic_H
// #define _H5DSpublic_H



public static final String DIMENSION_SCALE_CLASS = "DIMENSION_SCALE";
public static final String DIMENSION_LIST =        "DIMENSION_LIST";
public static final String REFERENCE_LIST =        "REFERENCE_LIST";
public static final String DIMENSION_LABELS =      "DIMENSION_LABELS";
// Targeting ..\H5DS_iterate_t.java




// #ifdef __cplusplus
// #endif

public static native @Cast("herr_t") int H5DSattach_scale( @Cast("hid_t") long did,
                        @Cast("hid_t") long dsid,
                        @Cast("unsigned int") int idx);

public static native @Cast("herr_t") int H5DSdetach_scale( @Cast("hid_t") long did,
                        @Cast("hid_t") long dsid,
                        @Cast("unsigned int") int idx);

public static native @Cast("herr_t") int H5DSset_scale( @Cast("hid_t") long dsid,
                     @Cast("const char*") BytePointer dimname);
public static native @Cast("herr_t") int H5DSset_scale( @Cast("hid_t") long dsid,
                     String dimname);

public static native int H5DSget_num_scales( @Cast("hid_t") long did,
                       @Cast("unsigned int") int dim);

public static native @Cast("herr_t") int H5DSset_label( @Cast("hid_t") long did,
                     @Cast("unsigned int") int idx,
                     @Cast("const char*") BytePointer label);
public static native @Cast("herr_t") int H5DSset_label( @Cast("hid_t") long did,
                     @Cast("unsigned int") int idx,
                     String label);

public static native @Cast("ssize_t") long H5DSget_label( @Cast("hid_t") long did,
                      @Cast("unsigned int") int idx,
                      @Cast("char*") BytePointer label,
                      @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5DSget_label( @Cast("hid_t") long did,
                      @Cast("unsigned int") int idx,
                      @Cast("char*") ByteBuffer label,
                      @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5DSget_label( @Cast("hid_t") long did,
                      @Cast("unsigned int") int idx,
                      @Cast("char*") byte[] label,
                      @Cast("size_t") long size);

public static native @Cast("ssize_t") long H5DSget_scale_name( @Cast("hid_t") long did,
                           @Cast("char*") BytePointer name,
                           @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5DSget_scale_name( @Cast("hid_t") long did,
                           @Cast("char*") ByteBuffer name,
                           @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5DSget_scale_name( @Cast("hid_t") long did,
                           @Cast("char*") byte[] name,
                           @Cast("size_t") long size);

public static native @Cast("htri_t") int H5DSis_scale( @Cast("hid_t") long did);

public static native @Cast("herr_t") int H5DSiterate_scales( @Cast("hid_t") long did,
                          @Cast("unsigned int") int dim,
                          IntPointer idx,
                          H5DS_iterate_t visitor,
                          Pointer visitor_data);
public static native @Cast("herr_t") int H5DSiterate_scales( @Cast("hid_t") long did,
                          @Cast("unsigned int") int dim,
                          IntBuffer idx,
                          H5DS_iterate_t visitor,
                          Pointer visitor_data);
public static native @Cast("herr_t") int H5DSiterate_scales( @Cast("hid_t") long did,
                          @Cast("unsigned int") int dim,
                          int[] idx,
                          H5DS_iterate_t visitor,
                          Pointer visitor_data);

public static native @Cast("htri_t") int H5DSis_attached( @Cast("hid_t") long did,
                       @Cast("hid_t") long dsid,
                       @Cast("unsigned int") int idx);



// #ifdef __cplusplus
// #endif

// #endif


// Parsed from H5LTpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5LTpublic_H
// #define _H5LTpublic_H

/* Flag definitions for H5LTopen_file_image() */
public static final int H5LT_FILE_IMAGE_OPEN_RW =      0x0001; /* Open image for read-write */
public static final int H5LT_FILE_IMAGE_DONT_COPY =    0x0002; /* The HDF5 lib won't copy   */
/* user supplied image buffer. The same image is open with the core driver.  */
public static final int H5LT_FILE_IMAGE_DONT_RELEASE = 0x0004; /* The HDF5 lib won't        */
/* deallocate user supplied image buffer. The user application is reponsible */
/* for doing so.                                                             */ 
public static final int H5LT_FILE_IMAGE_ALL =          0x0007;

/** enum H5LT_lang_t */
public static final int
    H5LT_LANG_ERR = -1, /*this is the first*/
    H5LT_DDL      = 0,  /*for DDL*/
    H5LT_C        = 1,  /*for C*/
    H5LT_FORTRAN  = 2,  /*for Fortran*/
    H5LT_NO_LANG  = 3;   /*this is the last*/

// #ifdef __cplusplus
// #endif

/*-------------------------------------------------------------------------
 *
 * Make dataset functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5LTmake_dataset( @Cast("hid_t") long loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         int rank,
                         @Cast("const hsize_t*") LongPointer dims,
                         @Cast("hid_t") long type_id,
                         @Const Pointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset( @Cast("hid_t") long loc_id,
                         String dset_name,
                         int rank,
                         @Cast("const hsize_t*") LongBuffer dims,
                         @Cast("hid_t") long type_id,
                         @Const Pointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset( @Cast("hid_t") long loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         int rank,
                         @Cast("const hsize_t*") long[] dims,
                         @Cast("hid_t") long type_id,
                         @Const Pointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset( @Cast("hid_t") long loc_id,
                         String dset_name,
                         int rank,
                         @Cast("const hsize_t*") LongPointer dims,
                         @Cast("hid_t") long type_id,
                         @Const Pointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset( @Cast("hid_t") long loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         int rank,
                         @Cast("const hsize_t*") LongBuffer dims,
                         @Cast("hid_t") long type_id,
                         @Const Pointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset( @Cast("hid_t") long loc_id,
                         String dset_name,
                         int rank,
                         @Cast("const hsize_t*") long[] dims,
                         @Cast("hid_t") long type_id,
                         @Const Pointer buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_char( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongPointer dims,
                              @Cast("const char*") BytePointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_char( @Cast("hid_t") long loc_id,
                              String dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongBuffer dims,
                              String buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_char( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              int rank,
                              @Cast("const hsize_t*") long[] dims,
                              @Cast("const char*") BytePointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_char( @Cast("hid_t") long loc_id,
                              String dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongPointer dims,
                              String buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_char( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongBuffer dims,
                              @Cast("const char*") BytePointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_char( @Cast("hid_t") long loc_id,
                              String dset_name,
                              int rank,
                              @Cast("const hsize_t*") long[] dims,
                              String buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_short( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongPointer dims,
                               @Const ShortPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_short( @Cast("hid_t") long loc_id,
                               String dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongBuffer dims,
                               @Const ShortBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_short( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               int rank,
                               @Cast("const hsize_t*") long[] dims,
                               @Const short[] buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_short( @Cast("hid_t") long loc_id,
                               String dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongPointer dims,
                               @Const ShortPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_short( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongBuffer dims,
                               @Const ShortBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_short( @Cast("hid_t") long loc_id,
                               String dset_name,
                               int rank,
                               @Cast("const hsize_t*") long[] dims,
                               @Const short[] buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_int( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             int rank,
                             @Cast("const hsize_t*") LongPointer dims,
                             @Const IntPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_int( @Cast("hid_t") long loc_id,
                             String dset_name,
                             int rank,
                             @Cast("const hsize_t*") LongBuffer dims,
                             @Const IntBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_int( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             int rank,
                             @Cast("const hsize_t*") long[] dims,
                             @Const int[] buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_int( @Cast("hid_t") long loc_id,
                             String dset_name,
                             int rank,
                             @Cast("const hsize_t*") LongPointer dims,
                             @Const IntPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_int( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             int rank,
                             @Cast("const hsize_t*") LongBuffer dims,
                             @Const IntBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_int( @Cast("hid_t") long loc_id,
                             String dset_name,
                             int rank,
                             @Cast("const hsize_t*") long[] dims,
                             @Const int[] buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_long( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongPointer dims,
                              @Const CLongPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_long( @Cast("hid_t") long loc_id,
                              String dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongBuffer dims,
                              @Const CLongPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_long( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              int rank,
                              @Cast("const hsize_t*") long[] dims,
                              @Const CLongPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_long( @Cast("hid_t") long loc_id,
                              String dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongPointer dims,
                              @Const CLongPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_long( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongBuffer dims,
                              @Const CLongPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_long( @Cast("hid_t") long loc_id,
                              String dset_name,
                              int rank,
                              @Cast("const hsize_t*") long[] dims,
                              @Const CLongPointer buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_float( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongPointer dims,
                               @Const FloatPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_float( @Cast("hid_t") long loc_id,
                               String dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongBuffer dims,
                               @Const FloatBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_float( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               int rank,
                               @Cast("const hsize_t*") long[] dims,
                               @Const float[] buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_float( @Cast("hid_t") long loc_id,
                               String dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongPointer dims,
                               @Const FloatPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_float( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongBuffer dims,
                               @Const FloatBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_float( @Cast("hid_t") long loc_id,
                               String dset_name,
                               int rank,
                               @Cast("const hsize_t*") long[] dims,
                               @Const float[] buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_double( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                int rank,
                                @Cast("const hsize_t*") LongPointer dims,
                                @Const DoublePointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_double( @Cast("hid_t") long loc_id,
                                String dset_name,
                                int rank,
                                @Cast("const hsize_t*") LongBuffer dims,
                                @Const DoubleBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_double( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                int rank,
                                @Cast("const hsize_t*") long[] dims,
                                @Const double[] buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_double( @Cast("hid_t") long loc_id,
                                String dset_name,
                                int rank,
                                @Cast("const hsize_t*") LongPointer dims,
                                @Const DoublePointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_double( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                int rank,
                                @Cast("const hsize_t*") LongBuffer dims,
                                @Const DoubleBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_double( @Cast("hid_t") long loc_id,
                                String dset_name,
                                int rank,
                                @Cast("const hsize_t*") long[] dims,
                                @Const double[] buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_string( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               @Cast("const char*") BytePointer buf );
public static native @Cast("herr_t") int H5LTmake_dataset_string( @Cast("hid_t") long loc_id,
                               String dset_name,
                               String buf );


/*-------------------------------------------------------------------------
 *
 * Read dataset functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5LTread_dataset( @Cast("hid_t") long loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         @Cast("hid_t") long type_id,
                         Pointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset( @Cast("hid_t") long loc_id,
                         String dset_name,
                         @Cast("hid_t") long type_id,
                         Pointer buffer );

public static native @Cast("herr_t") int H5LTread_dataset_char( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("char*") BytePointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_char( @Cast("hid_t") long loc_id,
                              String dset_name,
                              @Cast("char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_char( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("char*") byte[] buffer );
public static native @Cast("herr_t") int H5LTread_dataset_char( @Cast("hid_t") long loc_id,
                              String dset_name,
                              @Cast("char*") BytePointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_char( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_char( @Cast("hid_t") long loc_id,
                              String dset_name,
                              @Cast("char*") byte[] buffer );

public static native @Cast("herr_t") int H5LTread_dataset_short( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               ShortPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_short( @Cast("hid_t") long loc_id,
                               String dset_name,
                               ShortBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_short( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               short[] buffer );
public static native @Cast("herr_t") int H5LTread_dataset_short( @Cast("hid_t") long loc_id,
                               String dset_name,
                               ShortPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_short( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               ShortBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_short( @Cast("hid_t") long loc_id,
                               String dset_name,
                               short[] buffer );

public static native @Cast("herr_t") int H5LTread_dataset_int( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             IntPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_int( @Cast("hid_t") long loc_id,
                             String dset_name,
                             IntBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_int( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             int[] buffer );
public static native @Cast("herr_t") int H5LTread_dataset_int( @Cast("hid_t") long loc_id,
                             String dset_name,
                             IntPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_int( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             IntBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_int( @Cast("hid_t") long loc_id,
                             String dset_name,
                             int[] buffer );

public static native @Cast("herr_t") int H5LTread_dataset_long( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              CLongPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_long( @Cast("hid_t") long loc_id,
                              String dset_name,
                              CLongPointer buffer );

public static native @Cast("herr_t") int H5LTread_dataset_float( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               FloatPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_float( @Cast("hid_t") long loc_id,
                               String dset_name,
                               FloatBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_float( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               float[] buffer );
public static native @Cast("herr_t") int H5LTread_dataset_float( @Cast("hid_t") long loc_id,
                               String dset_name,
                               FloatPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_float( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               FloatBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_float( @Cast("hid_t") long loc_id,
                               String dset_name,
                               float[] buffer );

public static native @Cast("herr_t") int H5LTread_dataset_double( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                DoublePointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_double( @Cast("hid_t") long loc_id,
                                String dset_name,
                                DoubleBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_double( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                double[] buffer );
public static native @Cast("herr_t") int H5LTread_dataset_double( @Cast("hid_t") long loc_id,
                                String dset_name,
                                DoublePointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_double( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                DoubleBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_double( @Cast("hid_t") long loc_id,
                                String dset_name,
                                double[] buffer );

public static native @Cast("herr_t") int H5LTread_dataset_string( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                @Cast("char*") BytePointer buf );
public static native @Cast("herr_t") int H5LTread_dataset_string( @Cast("hid_t") long loc_id,
                                String dset_name,
                                @Cast("char*") ByteBuffer buf );
public static native @Cast("herr_t") int H5LTread_dataset_string( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                @Cast("char*") byte[] buf );
public static native @Cast("herr_t") int H5LTread_dataset_string( @Cast("hid_t") long loc_id,
                                String dset_name,
                                @Cast("char*") BytePointer buf );
public static native @Cast("herr_t") int H5LTread_dataset_string( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                @Cast("char*") ByteBuffer buf );
public static native @Cast("herr_t") int H5LTread_dataset_string( @Cast("hid_t") long loc_id,
                                String dset_name,
                                @Cast("char*") byte[] buf );

/*-------------------------------------------------------------------------
 *
 * Query dataset functions
 *
 *-------------------------------------------------------------------------
 */


public static native @Cast("herr_t") int H5LTget_dataset_ndims( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             IntPointer rank );
public static native @Cast("herr_t") int H5LTget_dataset_ndims( @Cast("hid_t") long loc_id,
                             String dset_name,
                             IntBuffer rank );
public static native @Cast("herr_t") int H5LTget_dataset_ndims( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             int[] rank );
public static native @Cast("herr_t") int H5LTget_dataset_ndims( @Cast("hid_t") long loc_id,
                             String dset_name,
                             IntPointer rank );
public static native @Cast("herr_t") int H5LTget_dataset_ndims( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             IntBuffer rank );
public static native @Cast("herr_t") int H5LTget_dataset_ndims( @Cast("hid_t") long loc_id,
                             String dset_name,
                             int[] rank );

public static native @Cast("herr_t") int H5LTget_dataset_info( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("hsize_t*") LongPointer dims,
                             @Cast("H5T_class_t*") IntPointer type_class,
                             @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_dataset_info( @Cast("hid_t") long loc_id,
                             String dset_name,
                             @Cast("hsize_t*") LongBuffer dims,
                             @Cast("H5T_class_t*") IntBuffer type_class,
                             @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_dataset_info( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("hsize_t*") long[] dims,
                             @Cast("H5T_class_t*") int[] type_class,
                             @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_dataset_info( @Cast("hid_t") long loc_id,
                             String dset_name,
                             @Cast("hsize_t*") LongPointer dims,
                             @Cast("H5T_class_t*") IntPointer type_class,
                             @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_dataset_info( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("hsize_t*") LongBuffer dims,
                             @Cast("H5T_class_t*") IntBuffer type_class,
                             @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_dataset_info( @Cast("hid_t") long loc_id,
                             String dset_name,
                             @Cast("hsize_t*") long[] dims,
                             @Cast("H5T_class_t*") int[] type_class,
                             @Cast("size_t*") SizeTPointer type_size );

public static native @Cast("herr_t") int H5LTfind_dataset( @Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name );
public static native @Cast("herr_t") int H5LTfind_dataset( @Cast("hid_t") long loc_id, String name );



/*-------------------------------------------------------------------------
 *
 * Set attribute functions
 *
 *-------------------------------------------------------------------------
 */


public static native @Cast("herr_t") int H5LTset_attribute_string( @Cast("hid_t") long loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Cast("const char*") BytePointer attr_data );
public static native @Cast("herr_t") int H5LTset_attribute_string( @Cast("hid_t") long loc_id,
                                 String obj_name,
                                 String attr_name,
                                 String attr_data );

public static native @Cast("herr_t") int H5LTset_attribute_char( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("const char*") BytePointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_char( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               String buffer,
                               @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_uchar( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("const unsigned char*") BytePointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uchar( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("const unsigned char*") ByteBuffer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uchar( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("const unsigned char*") byte[] buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uchar( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("const unsigned char*") BytePointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uchar( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("const unsigned char*") ByteBuffer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uchar( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("const unsigned char*") byte[] buffer,
                               @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_short( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Const ShortPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_short( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Const ShortBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_short( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Const short[] buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_short( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Const ShortPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_short( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Const ShortBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_short( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Const short[] buffer,
                              @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_ushort( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("const unsigned short*") ShortPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_ushort( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("const unsigned short*") ShortBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_ushort( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("const unsigned short*") short[] buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_ushort( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("const unsigned short*") ShortPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_ushort( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("const unsigned short*") ShortBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_ushort( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("const unsigned short*") short[] buffer,
                              @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_int( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Const IntPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_int( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Const IntBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_int( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Const int[] buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_int( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Const IntPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_int( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Const IntBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_int( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Const int[] buffer,
                              @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_uint( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("const unsigned int*") IntPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uint( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("const unsigned int*") IntBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uint( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("const unsigned int*") int[] buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uint( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("const unsigned int*") IntPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uint( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("const unsigned int*") IntBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uint( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("const unsigned int*") int[] buffer,
                              @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_long( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Const CLongPointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_long( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Const CLongPointer buffer,
                               @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_long_long( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Const LongPointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_long_long( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Const LongBuffer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_long_long( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Const long[] buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_long_long( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Const LongPointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_long_long( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Const LongBuffer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_long_long( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Const long[] buffer,
                               @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_ulong( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("const unsigned long*") CLongPointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_ulong( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("const unsigned long*") CLongPointer buffer,
                               @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_float( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                @Const FloatPointer buffer,
                                @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_float( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                @Const FloatBuffer buffer,
                                @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_float( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                @Const float[] buffer,
                                @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_float( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                @Const FloatPointer buffer,
                                @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_float( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                @Const FloatBuffer buffer,
                                @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_float( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                @Const float[] buffer,
                                @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_double( @Cast("hid_t") long loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Const DoublePointer buffer,
                                 @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_double( @Cast("hid_t") long loc_id,
                                 String obj_name,
                                 String attr_name,
                                 @Const DoubleBuffer buffer,
                                 @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_double( @Cast("hid_t") long loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Const double[] buffer,
                                 @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_double( @Cast("hid_t") long loc_id,
                                 String obj_name,
                                 String attr_name,
                                 @Const DoublePointer buffer,
                                 @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_double( @Cast("hid_t") long loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Const DoubleBuffer buffer,
                                 @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_double( @Cast("hid_t") long loc_id,
                                 String obj_name,
                                 String attr_name,
                                 @Const double[] buffer,
                                 @Cast("size_t") long size );

/*-------------------------------------------------------------------------
 *
 * Get attribute functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5LTget_attribute( @Cast("hid_t") long loc_id,
                          @Cast("const char*") BytePointer obj_name,
                          @Cast("const char*") BytePointer attr_name,
                          @Cast("hid_t") long mem_type_id,
                          Pointer data );
public static native @Cast("herr_t") int H5LTget_attribute( @Cast("hid_t") long loc_id,
                          String obj_name,
                          String attr_name,
                          @Cast("hid_t") long mem_type_id,
                          Pointer data );

public static native @Cast("herr_t") int H5LTget_attribute_string( @Cast("hid_t") long loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Cast("char*") BytePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_string( @Cast("hid_t") long loc_id,
                                 String obj_name,
                                 String attr_name,
                                 @Cast("char*") ByteBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_string( @Cast("hid_t") long loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Cast("char*") byte[] data );
public static native @Cast("herr_t") int H5LTget_attribute_string( @Cast("hid_t") long loc_id,
                                 String obj_name,
                                 String attr_name,
                                 @Cast("char*") BytePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_string( @Cast("hid_t") long loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Cast("char*") ByteBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_string( @Cast("hid_t") long loc_id,
                                 String obj_name,
                                 String attr_name,
                                 @Cast("char*") byte[] data );

public static native @Cast("herr_t") int H5LTget_attribute_char( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("char*") BytePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_char( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("char*") ByteBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_char( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("char*") byte[] data );
public static native @Cast("herr_t") int H5LTget_attribute_char( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("char*") BytePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_char( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("char*") ByteBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_char( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("char*") byte[] data );

public static native @Cast("herr_t") int H5LTget_attribute_uchar( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("unsigned char*") BytePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_uchar( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("unsigned char*") ByteBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_uchar( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("unsigned char*") byte[] data );
public static native @Cast("herr_t") int H5LTget_attribute_uchar( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("unsigned char*") BytePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_uchar( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("unsigned char*") ByteBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_uchar( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("unsigned char*") byte[] data );

public static native @Cast("herr_t") int H5LTget_attribute_short( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                ShortPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_short( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                ShortBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_short( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                short[] data );
public static native @Cast("herr_t") int H5LTget_attribute_short( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                ShortPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_short( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                ShortBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_short( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                short[] data );

public static native @Cast("herr_t") int H5LTget_attribute_ushort( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                @Cast("unsigned short*") ShortPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_ushort( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                @Cast("unsigned short*") ShortBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_ushort( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                @Cast("unsigned short*") short[] data );
public static native @Cast("herr_t") int H5LTget_attribute_ushort( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                @Cast("unsigned short*") ShortPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_ushort( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                @Cast("unsigned short*") ShortBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_ushort( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                @Cast("unsigned short*") short[] data );

public static native @Cast("herr_t") int H5LTget_attribute_int( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              IntPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_int( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              IntBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_int( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              int[] data );
public static native @Cast("herr_t") int H5LTget_attribute_int( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              IntPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_int( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              IntBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_int( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              int[] data );

public static native @Cast("herr_t") int H5LTget_attribute_uint( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("unsigned int*") IntPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_uint( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("unsigned int*") IntBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_uint( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("unsigned int*") int[] data );
public static native @Cast("herr_t") int H5LTget_attribute_uint( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("unsigned int*") IntPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_uint( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("unsigned int*") IntBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_uint( @Cast("hid_t") long loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("unsigned int*") int[] data );

public static native @Cast("herr_t") int H5LTget_attribute_long( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               CLongPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_long( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               CLongPointer data );

public static native @Cast("herr_t") int H5LTget_attribute_long_long( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               LongPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_long_long( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               LongBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_long_long( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               long[] data );
public static native @Cast("herr_t") int H5LTget_attribute_long_long( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               LongPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_long_long( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               LongBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_long_long( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               long[] data );

public static native @Cast("herr_t") int H5LTget_attribute_ulong( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("unsigned long*") CLongPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_ulong( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("unsigned long*") CLongPointer data );

public static native @Cast("herr_t") int H5LTget_attribute_float( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                FloatPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_float( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                FloatBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_float( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                float[] data );
public static native @Cast("herr_t") int H5LTget_attribute_float( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                FloatPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_float( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                FloatBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_float( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                float[] data );

public static native @Cast("herr_t") int H5LTget_attribute_double( @Cast("hid_t") long loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 DoublePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_double( @Cast("hid_t") long loc_id,
                                 String obj_name,
                                 String attr_name,
                                 DoubleBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_double( @Cast("hid_t") long loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 double[] data );
public static native @Cast("herr_t") int H5LTget_attribute_double( @Cast("hid_t") long loc_id,
                                 String obj_name,
                                 String attr_name,
                                 DoublePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_double( @Cast("hid_t") long loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 DoubleBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_double( @Cast("hid_t") long loc_id,
                                 String obj_name,
                                 String attr_name,
                                 double[] data );


/*-------------------------------------------------------------------------
 *
 * Query attribute functions
 *
 *-------------------------------------------------------------------------
 */


public static native @Cast("herr_t") int H5LTget_attribute_ndims( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                IntPointer rank );
public static native @Cast("herr_t") int H5LTget_attribute_ndims( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                IntBuffer rank );
public static native @Cast("herr_t") int H5LTget_attribute_ndims( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                int[] rank );
public static native @Cast("herr_t") int H5LTget_attribute_ndims( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                IntPointer rank );
public static native @Cast("herr_t") int H5LTget_attribute_ndims( @Cast("hid_t") long loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                IntBuffer rank );
public static native @Cast("herr_t") int H5LTget_attribute_ndims( @Cast("hid_t") long loc_id,
                                String obj_name,
                                String attr_name,
                                int[] rank );

public static native @Cast("herr_t") int H5LTget_attribute_info( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("hsize_t*") LongPointer dims,
                               @Cast("H5T_class_t*") IntPointer type_class,
                               @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_attribute_info( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("hsize_t*") LongBuffer dims,
                               @Cast("H5T_class_t*") IntBuffer type_class,
                               @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_attribute_info( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("hsize_t*") long[] dims,
                               @Cast("H5T_class_t*") int[] type_class,
                               @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_attribute_info( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("hsize_t*") LongPointer dims,
                               @Cast("H5T_class_t*") IntPointer type_class,
                               @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_attribute_info( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("hsize_t*") LongBuffer dims,
                               @Cast("H5T_class_t*") IntBuffer type_class,
                               @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_attribute_info( @Cast("hid_t") long loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("hsize_t*") long[] dims,
                               @Cast("H5T_class_t*") int[] type_class,
                               @Cast("size_t*") SizeTPointer type_size );





/*-------------------------------------------------------------------------
 *
 * General functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("hid_t") long H5LTtext_to_dtype(@Cast("const char*") BytePointer text, @Cast("H5LT_lang_t") int lang_type);
public static native @Cast("hid_t") long H5LTtext_to_dtype(String text, @Cast("H5LT_lang_t") int lang_type);
public static native @Cast("herr_t") int H5LTdtype_to_text(@Cast("hid_t") long dtype, @Cast("char*") BytePointer str, @Cast("H5LT_lang_t") int lang_type, @Cast("size_t*") SizeTPointer len);
public static native @Cast("herr_t") int H5LTdtype_to_text(@Cast("hid_t") long dtype, @Cast("char*") ByteBuffer str, @Cast("H5LT_lang_t") int lang_type, @Cast("size_t*") SizeTPointer len);
public static native @Cast("herr_t") int H5LTdtype_to_text(@Cast("hid_t") long dtype, @Cast("char*") byte[] str, @Cast("H5LT_lang_t") int lang_type, @Cast("size_t*") SizeTPointer len);


/*-------------------------------------------------------------------------
 *
 * Utility functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5LTfind_attribute( @Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name );
public static native @Cast("herr_t") int H5LTfind_attribute( @Cast("hid_t") long loc_id, String name );

public static native @Cast("htri_t") int H5LTpath_valid(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer path, @Cast("hbool_t") boolean check_object_valid);
public static native @Cast("htri_t") int H5LTpath_valid(@Cast("hid_t") long loc_id, String path, @Cast("hbool_t") boolean check_object_valid);

/*-------------------------------------------------------------------------
 *
 * File image operations functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("hid_t") long H5LTopen_file_image(Pointer buf_ptr, @Cast("size_t") long buf_size, @Cast("unsigned") int flags);

// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5IMpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5IMpublic_H
// #define _H5IMpublic_H


// #ifdef __cplusplus
// #endif


public static native @Cast("herr_t") int H5IMmake_image_8bit( @Cast("hid_t") long loc_id,
                            @Cast("const char*") BytePointer dset_name,
                            @Cast("hsize_t") long width,
                            @Cast("hsize_t") long height,
                            @Cast("const unsigned char*") BytePointer buffer );
public static native @Cast("herr_t") int H5IMmake_image_8bit( @Cast("hid_t") long loc_id,
                            String dset_name,
                            @Cast("hsize_t") long width,
                            @Cast("hsize_t") long height,
                            @Cast("const unsigned char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5IMmake_image_8bit( @Cast("hid_t") long loc_id,
                            @Cast("const char*") BytePointer dset_name,
                            @Cast("hsize_t") long width,
                            @Cast("hsize_t") long height,
                            @Cast("const unsigned char*") byte[] buffer );
public static native @Cast("herr_t") int H5IMmake_image_8bit( @Cast("hid_t") long loc_id,
                            String dset_name,
                            @Cast("hsize_t") long width,
                            @Cast("hsize_t") long height,
                            @Cast("const unsigned char*") BytePointer buffer );
public static native @Cast("herr_t") int H5IMmake_image_8bit( @Cast("hid_t") long loc_id,
                            @Cast("const char*") BytePointer dset_name,
                            @Cast("hsize_t") long width,
                            @Cast("hsize_t") long height,
                            @Cast("const unsigned char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5IMmake_image_8bit( @Cast("hid_t") long loc_id,
                            String dset_name,
                            @Cast("hsize_t") long width,
                            @Cast("hsize_t") long height,
                            @Cast("const unsigned char*") byte[] buffer );

public static native @Cast("herr_t") int H5IMmake_image_24bit( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("hsize_t") long width,
                             @Cast("hsize_t") long height,
                             @Cast("const char*") BytePointer interlace,
                             @Cast("const unsigned char*") BytePointer buffer );
public static native @Cast("herr_t") int H5IMmake_image_24bit( @Cast("hid_t") long loc_id,
                             String dset_name,
                             @Cast("hsize_t") long width,
                             @Cast("hsize_t") long height,
                             String interlace,
                             @Cast("const unsigned char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5IMmake_image_24bit( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("hsize_t") long width,
                             @Cast("hsize_t") long height,
                             @Cast("const char*") BytePointer interlace,
                             @Cast("const unsigned char*") byte[] buffer );
public static native @Cast("herr_t") int H5IMmake_image_24bit( @Cast("hid_t") long loc_id,
                             String dset_name,
                             @Cast("hsize_t") long width,
                             @Cast("hsize_t") long height,
                             String interlace,
                             @Cast("const unsigned char*") BytePointer buffer );
public static native @Cast("herr_t") int H5IMmake_image_24bit( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("hsize_t") long width,
                             @Cast("hsize_t") long height,
                             @Cast("const char*") BytePointer interlace,
                             @Cast("const unsigned char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5IMmake_image_24bit( @Cast("hid_t") long loc_id,
                             String dset_name,
                             @Cast("hsize_t") long width,
                             @Cast("hsize_t") long height,
                             String interlace,
                             @Cast("const unsigned char*") byte[] buffer );

public static native @Cast("herr_t") int H5IMget_image_info( @Cast("hid_t") long loc_id,
                     @Cast("const char*") BytePointer dset_name,
                     @Cast("hsize_t*") LongPointer width,
                     @Cast("hsize_t*") LongPointer height,
                     @Cast("hsize_t*") LongPointer planes,
                     @Cast("char*") BytePointer interlace,
                     @Cast("hssize_t*") LongPointer npals );
public static native @Cast("herr_t") int H5IMget_image_info( @Cast("hid_t") long loc_id,
                     String dset_name,
                     @Cast("hsize_t*") LongBuffer width,
                     @Cast("hsize_t*") LongBuffer height,
                     @Cast("hsize_t*") LongBuffer planes,
                     @Cast("char*") ByteBuffer interlace,
                     @Cast("hssize_t*") LongBuffer npals );
public static native @Cast("herr_t") int H5IMget_image_info( @Cast("hid_t") long loc_id,
                     @Cast("const char*") BytePointer dset_name,
                     @Cast("hsize_t*") long[] width,
                     @Cast("hsize_t*") long[] height,
                     @Cast("hsize_t*") long[] planes,
                     @Cast("char*") byte[] interlace,
                     @Cast("hssize_t*") long[] npals );
public static native @Cast("herr_t") int H5IMget_image_info( @Cast("hid_t") long loc_id,
                     String dset_name,
                     @Cast("hsize_t*") LongPointer width,
                     @Cast("hsize_t*") LongPointer height,
                     @Cast("hsize_t*") LongPointer planes,
                     @Cast("char*") BytePointer interlace,
                     @Cast("hssize_t*") LongPointer npals );
public static native @Cast("herr_t") int H5IMget_image_info( @Cast("hid_t") long loc_id,
                     @Cast("const char*") BytePointer dset_name,
                     @Cast("hsize_t*") LongBuffer width,
                     @Cast("hsize_t*") LongBuffer height,
                     @Cast("hsize_t*") LongBuffer planes,
                     @Cast("char*") ByteBuffer interlace,
                     @Cast("hssize_t*") LongBuffer npals );
public static native @Cast("herr_t") int H5IMget_image_info( @Cast("hid_t") long loc_id,
                     String dset_name,
                     @Cast("hsize_t*") long[] width,
                     @Cast("hsize_t*") long[] height,
                     @Cast("hsize_t*") long[] planes,
                     @Cast("char*") byte[] interlace,
                     @Cast("hssize_t*") long[] npals );

public static native @Cast("herr_t") int H5IMread_image( @Cast("hid_t") long loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("unsigned char*") BytePointer buffer );
public static native @Cast("herr_t") int H5IMread_image( @Cast("hid_t") long loc_id,
                       String dset_name,
                       @Cast("unsigned char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5IMread_image( @Cast("hid_t") long loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("unsigned char*") byte[] buffer );
public static native @Cast("herr_t") int H5IMread_image( @Cast("hid_t") long loc_id,
                       String dset_name,
                       @Cast("unsigned char*") BytePointer buffer );
public static native @Cast("herr_t") int H5IMread_image( @Cast("hid_t") long loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("unsigned char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5IMread_image( @Cast("hid_t") long loc_id,
                       String dset_name,
                       @Cast("unsigned char*") byte[] buffer );

public static native @Cast("herr_t") int H5IMmake_palette( @Cast("hid_t") long loc_id,
                         @Cast("const char*") BytePointer pal_name,
                         @Cast("const hsize_t*") LongPointer pal_dims,
                         @Cast("const unsigned char*") BytePointer pal_data );
public static native @Cast("herr_t") int H5IMmake_palette( @Cast("hid_t") long loc_id,
                         String pal_name,
                         @Cast("const hsize_t*") LongBuffer pal_dims,
                         @Cast("const unsigned char*") ByteBuffer pal_data );
public static native @Cast("herr_t") int H5IMmake_palette( @Cast("hid_t") long loc_id,
                         @Cast("const char*") BytePointer pal_name,
                         @Cast("const hsize_t*") long[] pal_dims,
                         @Cast("const unsigned char*") byte[] pal_data );
public static native @Cast("herr_t") int H5IMmake_palette( @Cast("hid_t") long loc_id,
                         String pal_name,
                         @Cast("const hsize_t*") LongPointer pal_dims,
                         @Cast("const unsigned char*") BytePointer pal_data );
public static native @Cast("herr_t") int H5IMmake_palette( @Cast("hid_t") long loc_id,
                         @Cast("const char*") BytePointer pal_name,
                         @Cast("const hsize_t*") LongBuffer pal_dims,
                         @Cast("const unsigned char*") ByteBuffer pal_data );
public static native @Cast("herr_t") int H5IMmake_palette( @Cast("hid_t") long loc_id,
                         String pal_name,
                         @Cast("const hsize_t*") long[] pal_dims,
                         @Cast("const unsigned char*") byte[] pal_data );

public static native @Cast("herr_t") int H5IMlink_palette( @Cast("hid_t") long loc_id,
                        @Cast("const char*") BytePointer image_name,
                        @Cast("const char*") BytePointer pal_name );
public static native @Cast("herr_t") int H5IMlink_palette( @Cast("hid_t") long loc_id,
                        String image_name,
                        String pal_name );

public static native @Cast("herr_t") int H5IMunlink_palette( @Cast("hid_t") long loc_id,
                           @Cast("const char*") BytePointer image_name,
                           @Cast("const char*") BytePointer pal_name );
public static native @Cast("herr_t") int H5IMunlink_palette( @Cast("hid_t") long loc_id,
                           String image_name,
                           String pal_name );

public static native @Cast("herr_t") int H5IMget_npalettes( @Cast("hid_t") long loc_id,
                          @Cast("const char*") BytePointer image_name,
                          @Cast("hssize_t*") LongPointer npals );
public static native @Cast("herr_t") int H5IMget_npalettes( @Cast("hid_t") long loc_id,
                          String image_name,
                          @Cast("hssize_t*") LongBuffer npals );
public static native @Cast("herr_t") int H5IMget_npalettes( @Cast("hid_t") long loc_id,
                          @Cast("const char*") BytePointer image_name,
                          @Cast("hssize_t*") long[] npals );
public static native @Cast("herr_t") int H5IMget_npalettes( @Cast("hid_t") long loc_id,
                          String image_name,
                          @Cast("hssize_t*") LongPointer npals );
public static native @Cast("herr_t") int H5IMget_npalettes( @Cast("hid_t") long loc_id,
                          @Cast("const char*") BytePointer image_name,
                          @Cast("hssize_t*") LongBuffer npals );
public static native @Cast("herr_t") int H5IMget_npalettes( @Cast("hid_t") long loc_id,
                          String image_name,
                          @Cast("hssize_t*") long[] npals );

public static native @Cast("herr_t") int H5IMget_palette_info( @Cast("hid_t") long loc_id,
                        @Cast("const char*") BytePointer image_name,
                        int pal_number,
                        @Cast("hsize_t*") LongPointer pal_dims );
public static native @Cast("herr_t") int H5IMget_palette_info( @Cast("hid_t") long loc_id,
                        String image_name,
                        int pal_number,
                        @Cast("hsize_t*") LongBuffer pal_dims );
public static native @Cast("herr_t") int H5IMget_palette_info( @Cast("hid_t") long loc_id,
                        @Cast("const char*") BytePointer image_name,
                        int pal_number,
                        @Cast("hsize_t*") long[] pal_dims );
public static native @Cast("herr_t") int H5IMget_palette_info( @Cast("hid_t") long loc_id,
                        String image_name,
                        int pal_number,
                        @Cast("hsize_t*") LongPointer pal_dims );
public static native @Cast("herr_t") int H5IMget_palette_info( @Cast("hid_t") long loc_id,
                        @Cast("const char*") BytePointer image_name,
                        int pal_number,
                        @Cast("hsize_t*") LongBuffer pal_dims );
public static native @Cast("herr_t") int H5IMget_palette_info( @Cast("hid_t") long loc_id,
                        String image_name,
                        int pal_number,
                        @Cast("hsize_t*") long[] pal_dims );

public static native @Cast("herr_t") int H5IMget_palette( @Cast("hid_t") long loc_id,
                        @Cast("const char*") BytePointer image_name,
                        int pal_number,
                        @Cast("unsigned char*") BytePointer pal_data );
public static native @Cast("herr_t") int H5IMget_palette( @Cast("hid_t") long loc_id,
                        String image_name,
                        int pal_number,
                        @Cast("unsigned char*") ByteBuffer pal_data );
public static native @Cast("herr_t") int H5IMget_palette( @Cast("hid_t") long loc_id,
                        @Cast("const char*") BytePointer image_name,
                        int pal_number,
                        @Cast("unsigned char*") byte[] pal_data );
public static native @Cast("herr_t") int H5IMget_palette( @Cast("hid_t") long loc_id,
                        String image_name,
                        int pal_number,
                        @Cast("unsigned char*") BytePointer pal_data );
public static native @Cast("herr_t") int H5IMget_palette( @Cast("hid_t") long loc_id,
                        @Cast("const char*") BytePointer image_name,
                        int pal_number,
                        @Cast("unsigned char*") ByteBuffer pal_data );
public static native @Cast("herr_t") int H5IMget_palette( @Cast("hid_t") long loc_id,
                        String image_name,
                        int pal_number,
                        @Cast("unsigned char*") byte[] pal_data );

public static native @Cast("herr_t") int H5IMis_image( @Cast("hid_t") long loc_id,
                     @Cast("const char*") BytePointer dset_name );
public static native @Cast("herr_t") int H5IMis_image( @Cast("hid_t") long loc_id,
                     String dset_name );

public static native @Cast("herr_t") int H5IMis_palette( @Cast("hid_t") long loc_id,
                     @Cast("const char*") BytePointer dset_name );
public static native @Cast("herr_t") int H5IMis_palette( @Cast("hid_t") long loc_id,
                     String dset_name );

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from H5TBpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5TBpublic_H
// #define _H5TBpublic_H


// #ifdef __cplusplus
// #endif


/*-------------------------------------------------------------------------
 *
 * Create functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5TBmake_table( @Cast("const char*") BytePointer table_title,
                       @Cast("hid_t") long loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") PointerPointer field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") LongPointer field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );
public static native @Cast("herr_t") int H5TBmake_table( @Cast("const char*") BytePointer table_title,
                       @Cast("hid_t") long loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") @ByPtrPtr BytePointer field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") LongPointer field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );
public static native @Cast("herr_t") int H5TBmake_table( String table_title,
                       @Cast("hid_t") long loc_id,
                       String dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") @ByPtrPtr ByteBuffer field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") LongBuffer field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );
public static native @Cast("herr_t") int H5TBmake_table( @Cast("const char*") BytePointer table_title,
                       @Cast("hid_t") long loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") @ByPtrPtr byte[] field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") long[] field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );
public static native @Cast("herr_t") int H5TBmake_table( String table_title,
                       @Cast("hid_t") long loc_id,
                       String dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") @ByPtrPtr BytePointer field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") LongPointer field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );
public static native @Cast("herr_t") int H5TBmake_table( @Cast("const char*") BytePointer table_title,
                       @Cast("hid_t") long loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") @ByPtrPtr ByteBuffer field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") LongBuffer field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );
public static native @Cast("herr_t") int H5TBmake_table( String table_title,
                       @Cast("hid_t") long loc_id,
                       String dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") @ByPtrPtr byte[] field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") long[] field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );


/*-------------------------------------------------------------------------
 *
 * Write functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5TBappend_records( @Cast("hid_t") long loc_id,
                           @Cast("const char*") BytePointer dset_name,
                           @Cast("hsize_t") long nrecords,
                           @Cast("size_t") long type_size,
                           @Cast("const size_t*") SizeTPointer field_offset,
                           @Cast("const size_t*") SizeTPointer dst_sizes,
                           @Const Pointer buf );
public static native @Cast("herr_t") int H5TBappend_records( @Cast("hid_t") long loc_id,
                           String dset_name,
                           @Cast("hsize_t") long nrecords,
                           @Cast("size_t") long type_size,
                           @Cast("const size_t*") SizeTPointer field_offset,
                           @Cast("const size_t*") SizeTPointer dst_sizes,
                           @Const Pointer buf );

public static native @Cast("herr_t") int H5TBwrite_records( @Cast("hid_t") long loc_id,
                          @Cast("const char*") BytePointer dset_name,
                          @Cast("hsize_t") long start,
                          @Cast("hsize_t") long nrecords,
                          @Cast("size_t") long type_size,
                          @Cast("const size_t*") SizeTPointer field_offset,
                          @Cast("const size_t*") SizeTPointer dst_sizes,
                          @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_records( @Cast("hid_t") long loc_id,
                          String dset_name,
                          @Cast("hsize_t") long start,
                          @Cast("hsize_t") long nrecords,
                          @Cast("size_t") long type_size,
                          @Cast("const size_t*") SizeTPointer field_offset,
                          @Cast("const size_t*") SizeTPointer dst_sizes,
                          @Const Pointer buf );


public static native @Cast("herr_t") int H5TBwrite_fields_name( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("const char*") BytePointer field_names,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_fields_name( @Cast("hid_t") long loc_id,
                              String dset_name,
                              String field_names,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              @Const Pointer buf );

public static native @Cast("herr_t") int H5TBwrite_fields_index( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               @Cast("hsize_t") long nfields,
                               @Const IntPointer field_index,
                               @Cast("hsize_t") long start,
                               @Cast("hsize_t") long nrecords,
                               @Cast("size_t") long type_size,
                               @Cast("const size_t*") SizeTPointer field_offset,
                               @Cast("const size_t*") SizeTPointer dst_sizes,
                               @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_fields_index( @Cast("hid_t") long loc_id,
                               String dset_name,
                               @Cast("hsize_t") long nfields,
                               @Const IntBuffer field_index,
                               @Cast("hsize_t") long start,
                               @Cast("hsize_t") long nrecords,
                               @Cast("size_t") long type_size,
                               @Cast("const size_t*") SizeTPointer field_offset,
                               @Cast("const size_t*") SizeTPointer dst_sizes,
                               @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_fields_index( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               @Cast("hsize_t") long nfields,
                               @Const int[] field_index,
                               @Cast("hsize_t") long start,
                               @Cast("hsize_t") long nrecords,
                               @Cast("size_t") long type_size,
                               @Cast("const size_t*") SizeTPointer field_offset,
                               @Cast("const size_t*") SizeTPointer dst_sizes,
                               @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_fields_index( @Cast("hid_t") long loc_id,
                               String dset_name,
                               @Cast("hsize_t") long nfields,
                               @Const IntPointer field_index,
                               @Cast("hsize_t") long start,
                               @Cast("hsize_t") long nrecords,
                               @Cast("size_t") long type_size,
                               @Cast("const size_t*") SizeTPointer field_offset,
                               @Cast("const size_t*") SizeTPointer dst_sizes,
                               @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_fields_index( @Cast("hid_t") long loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               @Cast("hsize_t") long nfields,
                               @Const IntBuffer field_index,
                               @Cast("hsize_t") long start,
                               @Cast("hsize_t") long nrecords,
                               @Cast("size_t") long type_size,
                               @Cast("const size_t*") SizeTPointer field_offset,
                               @Cast("const size_t*") SizeTPointer dst_sizes,
                               @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_fields_index( @Cast("hid_t") long loc_id,
                               String dset_name,
                               @Cast("hsize_t") long nfields,
                               @Const int[] field_index,
                               @Cast("hsize_t") long start,
                               @Cast("hsize_t") long nrecords,
                               @Cast("size_t") long type_size,
                               @Cast("const size_t*") SizeTPointer field_offset,
                               @Cast("const size_t*") SizeTPointer dst_sizes,
                               @Const Pointer buf );


/*-------------------------------------------------------------------------
 *
 * Read functions
 *
 *-------------------------------------------------------------------------
 */



public static native @Cast("herr_t") int H5TBread_table( @Cast("hid_t") long loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("size_t") long dst_size,
                       @Cast("const size_t*") SizeTPointer dst_offset,
                       @Cast("const size_t*") SizeTPointer dst_sizes,
                       Pointer dst_buf );
public static native @Cast("herr_t") int H5TBread_table( @Cast("hid_t") long loc_id,
                       String dset_name,
                       @Cast("size_t") long dst_size,
                       @Cast("const size_t*") SizeTPointer dst_offset,
                       @Cast("const size_t*") SizeTPointer dst_sizes,
                       Pointer dst_buf );


public static native @Cast("herr_t") int H5TBread_fields_name( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("const char*") BytePointer field_names,
                             @Cast("hsize_t") long start,
                             @Cast("hsize_t") long nrecords,
                             @Cast("size_t") long type_size,
                             @Cast("const size_t*") SizeTPointer field_offset,
                             @Cast("const size_t*") SizeTPointer dst_sizes,
                             Pointer buf );
public static native @Cast("herr_t") int H5TBread_fields_name( @Cast("hid_t") long loc_id,
                             String dset_name,
                             String field_names,
                             @Cast("hsize_t") long start,
                             @Cast("hsize_t") long nrecords,
                             @Cast("size_t") long type_size,
                             @Cast("const size_t*") SizeTPointer field_offset,
                             @Cast("const size_t*") SizeTPointer dst_sizes,
                             Pointer buf );

public static native @Cast("herr_t") int H5TBread_fields_index( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("hsize_t") long nfields,
                              @Const IntPointer field_index,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              Pointer buf );
public static native @Cast("herr_t") int H5TBread_fields_index( @Cast("hid_t") long loc_id,
                              String dset_name,
                              @Cast("hsize_t") long nfields,
                              @Const IntBuffer field_index,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              Pointer buf );
public static native @Cast("herr_t") int H5TBread_fields_index( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("hsize_t") long nfields,
                              @Const int[] field_index,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              Pointer buf );
public static native @Cast("herr_t") int H5TBread_fields_index( @Cast("hid_t") long loc_id,
                              String dset_name,
                              @Cast("hsize_t") long nfields,
                              @Const IntPointer field_index,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              Pointer buf );
public static native @Cast("herr_t") int H5TBread_fields_index( @Cast("hid_t") long loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("hsize_t") long nfields,
                              @Const IntBuffer field_index,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              Pointer buf );
public static native @Cast("herr_t") int H5TBread_fields_index( @Cast("hid_t") long loc_id,
                              String dset_name,
                              @Cast("hsize_t") long nfields,
                              @Const int[] field_index,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              Pointer buf );


public static native @Cast("herr_t") int H5TBread_records( @Cast("hid_t") long loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         @Cast("hsize_t") long start,
                         @Cast("hsize_t") long nrecords,
                         @Cast("size_t") long type_size,
                         @Cast("const size_t*") SizeTPointer dst_offset,
                         @Cast("const size_t*") SizeTPointer dst_sizes,
                         Pointer buf );
public static native @Cast("herr_t") int H5TBread_records( @Cast("hid_t") long loc_id,
                         String dset_name,
                         @Cast("hsize_t") long start,
                         @Cast("hsize_t") long nrecords,
                         @Cast("size_t") long type_size,
                         @Cast("const size_t*") SizeTPointer dst_offset,
                         @Cast("const size_t*") SizeTPointer dst_sizes,
                         Pointer buf );

/*-------------------------------------------------------------------------
 *
 * Inquiry functions
 *
 *-------------------------------------------------------------------------
 */


public static native @Cast("herr_t") int H5TBget_table_info( @Cast("hid_t") long loc_id,
                            @Cast("const char*") BytePointer dset_name,
                            @Cast("hsize_t*") LongPointer nfields,
                            @Cast("hsize_t*") LongPointer nrecords );
public static native @Cast("herr_t") int H5TBget_table_info( @Cast("hid_t") long loc_id,
                            String dset_name,
                            @Cast("hsize_t*") LongBuffer nfields,
                            @Cast("hsize_t*") LongBuffer nrecords );
public static native @Cast("herr_t") int H5TBget_table_info( @Cast("hid_t") long loc_id,
                            @Cast("const char*") BytePointer dset_name,
                            @Cast("hsize_t*") long[] nfields,
                            @Cast("hsize_t*") long[] nrecords );
public static native @Cast("herr_t") int H5TBget_table_info( @Cast("hid_t") long loc_id,
                            String dset_name,
                            @Cast("hsize_t*") LongPointer nfields,
                            @Cast("hsize_t*") LongPointer nrecords );
public static native @Cast("herr_t") int H5TBget_table_info( @Cast("hid_t") long loc_id,
                            @Cast("const char*") BytePointer dset_name,
                            @Cast("hsize_t*") LongBuffer nfields,
                            @Cast("hsize_t*") LongBuffer nrecords );
public static native @Cast("herr_t") int H5TBget_table_info( @Cast("hid_t") long loc_id,
                            String dset_name,
                            @Cast("hsize_t*") long[] nfields,
                            @Cast("hsize_t*") long[] nrecords );

public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") long loc_id,
                           @Cast("const char*") BytePointer dset_name,
                           @Cast("char**") PointerPointer field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") long loc_id,
                           @Cast("const char*") BytePointer dset_name,
                           @Cast("char**") @ByPtrPtr BytePointer field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") long loc_id,
                           String dset_name,
                           @Cast("char**") @ByPtrPtr ByteBuffer field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") long loc_id,
                           @Cast("const char*") BytePointer dset_name,
                           @Cast("char**") @ByPtrPtr byte[] field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") long loc_id,
                           String dset_name,
                           @Cast("char**") @ByPtrPtr BytePointer field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") long loc_id,
                           @Cast("const char*") BytePointer dset_name,
                           @Cast("char**") @ByPtrPtr ByteBuffer field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") long loc_id,
                           String dset_name,
                           @Cast("char**") @ByPtrPtr byte[] field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );


/*-------------------------------------------------------------------------
 *
 * Manipulation functions
 *
 *-------------------------------------------------------------------------
 */


public static native @Cast("herr_t") int H5TBdelete_record( @Cast("hid_t") long loc_id,
                          @Cast("const char*") BytePointer dset_name,
                          @Cast("hsize_t") long start,
                          @Cast("hsize_t") long nrecords );
public static native @Cast("herr_t") int H5TBdelete_record( @Cast("hid_t") long loc_id,
                          String dset_name,
                          @Cast("hsize_t") long start,
                          @Cast("hsize_t") long nrecords );


public static native @Cast("herr_t") int H5TBinsert_record( @Cast("hid_t") long loc_id,
                          @Cast("const char*") BytePointer dset_name,
                          @Cast("hsize_t") long start,
                          @Cast("hsize_t") long nrecords,
                          @Cast("size_t") long dst_size,
                          @Cast("const size_t*") SizeTPointer dst_offset,
                          @Cast("const size_t*") SizeTPointer dst_sizes,
                          Pointer buf );
public static native @Cast("herr_t") int H5TBinsert_record( @Cast("hid_t") long loc_id,
                          String dset_name,
                          @Cast("hsize_t") long start,
                          @Cast("hsize_t") long nrecords,
                          @Cast("size_t") long dst_size,
                          @Cast("const size_t*") SizeTPointer dst_offset,
                          @Cast("const size_t*") SizeTPointer dst_sizes,
                          Pointer buf );

public static native @Cast("herr_t") int H5TBadd_records_from( @Cast("hid_t") long loc_id,
                             @Cast("const char*") BytePointer dset_name1,
                             @Cast("hsize_t") long start1,
                             @Cast("hsize_t") long nrecords,
                             @Cast("const char*") BytePointer dset_name2,
                             @Cast("hsize_t") long start2 );
public static native @Cast("herr_t") int H5TBadd_records_from( @Cast("hid_t") long loc_id,
                             String dset_name1,
                             @Cast("hsize_t") long start1,
                             @Cast("hsize_t") long nrecords,
                             String dset_name2,
                             @Cast("hsize_t") long start2 );

public static native @Cast("herr_t") int H5TBcombine_tables( @Cast("hid_t") long loc_id1,
                           @Cast("const char*") BytePointer dset_name1,
                           @Cast("hid_t") long loc_id2,
                           @Cast("const char*") BytePointer dset_name2,
                           @Cast("const char*") BytePointer dset_name3 );
public static native @Cast("herr_t") int H5TBcombine_tables( @Cast("hid_t") long loc_id1,
                           String dset_name1,
                           @Cast("hid_t") long loc_id2,
                           String dset_name2,
                           String dset_name3 );

public static native @Cast("herr_t") int H5TBinsert_field( @Cast("hid_t") long loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         @Cast("const char*") BytePointer field_name,
                         @Cast("hid_t") long field_type,
                         @Cast("hsize_t") long _position,
                         @Const Pointer fill_data,
                         @Const Pointer buf );
public static native @Cast("herr_t") int H5TBinsert_field( @Cast("hid_t") long loc_id,
                         String dset_name,
                         String field_name,
                         @Cast("hid_t") long field_type,
                         @Cast("hsize_t") long _position,
                         @Const Pointer fill_data,
                         @Const Pointer buf );

public static native @Cast("herr_t") int H5TBdelete_field( @Cast("hid_t") long loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         @Cast("const char*") BytePointer field_name );
public static native @Cast("herr_t") int H5TBdelete_field( @Cast("hid_t") long loc_id,
                         String dset_name,
                         String field_name );


/*-------------------------------------------------------------------------
 *
 * Table attribute functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5TBAget_title( @Cast("hid_t") long loc_id,
                       @Cast("char*") BytePointer table_title );
public static native @Cast("herr_t") int H5TBAget_title( @Cast("hid_t") long loc_id,
                       @Cast("char*") ByteBuffer table_title );
public static native @Cast("herr_t") int H5TBAget_title( @Cast("hid_t") long loc_id,
                       @Cast("char*") byte[] table_title );

public static native @Cast("htri_t") int H5TBAget_fill(@Cast("hid_t") long loc_id,
                      @Cast("const char*") BytePointer dset_name,
                      @Cast("hid_t") long dset_id,
                      @Cast("unsigned char*") BytePointer dst_buf);
public static native @Cast("htri_t") int H5TBAget_fill(@Cast("hid_t") long loc_id,
                      String dset_name,
                      @Cast("hid_t") long dset_id,
                      @Cast("unsigned char*") ByteBuffer dst_buf);
public static native @Cast("htri_t") int H5TBAget_fill(@Cast("hid_t") long loc_id,
                      @Cast("const char*") BytePointer dset_name,
                      @Cast("hid_t") long dset_id,
                      @Cast("unsigned char*") byte[] dst_buf);
public static native @Cast("htri_t") int H5TBAget_fill(@Cast("hid_t") long loc_id,
                      String dset_name,
                      @Cast("hid_t") long dset_id,
                      @Cast("unsigned char*") BytePointer dst_buf);
public static native @Cast("htri_t") int H5TBAget_fill(@Cast("hid_t") long loc_id,
                      @Cast("const char*") BytePointer dset_name,
                      @Cast("hid_t") long dset_id,
                      @Cast("unsigned char*") ByteBuffer dst_buf);
public static native @Cast("htri_t") int H5TBAget_fill(@Cast("hid_t") long loc_id,
                      String dset_name,
                      @Cast("hid_t") long dset_id,
                      @Cast("unsigned char*") byte[] dst_buf);

// #ifdef __cplusplus
// #endif


// #endif



// Parsed from H5PTpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5PTpublic_H
// #define _H5PTpublic_H


// #ifdef __cplusplus
// #endif

/*-------------------------------------------------------------------------
 * Create/Open/Close functions
 *-------------------------------------------------------------------------
 */
/* NOTE: H5PTcreate is replacing H5PTcreate_fl for better name due to the
   removal of H5PTcreate_vl.  H5PTcreate_fl may be retired in 1.8.19. */
public static native @Cast("hid_t") long H5PTcreate(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer dset_name,
			@Cast("hid_t") long dtype_id, @Cast("hsize_t") long chunk_size, @Cast("hid_t") long plist_id);
public static native @Cast("hid_t") long H5PTcreate(@Cast("hid_t") long loc_id, String dset_name,
			@Cast("hid_t") long dtype_id, @Cast("hsize_t") long chunk_size, @Cast("hid_t") long plist_id);

public static native @Cast("hid_t") long H5PTopen(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer dset_name);
public static native @Cast("hid_t") long H5PTopen(@Cast("hid_t") long loc_id, String dset_name);

public static native @Cast("herr_t") int H5PTclose(@Cast("hid_t") long table_id);

/* This function may be removed from the packet table in release 1.8.19. */
public static native @Cast("hid_t") long H5PTcreate_fl(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer dset_name,
			@Cast("hid_t") long dtype_id, @Cast("hsize_t") long chunk_size, int compression);
public static native @Cast("hid_t") long H5PTcreate_fl(@Cast("hid_t") long loc_id, String dset_name,
			@Cast("hid_t") long dtype_id, @Cast("hsize_t") long chunk_size, int compression);


/*-------------------------------------------------------------------------
 * Write functions
 *-------------------------------------------------------------------------
 */
public static native @Cast("herr_t") int H5PTappend(@Cast("hid_t") long table_id, @Cast("size_t") long nrecords, @Const Pointer data);

/*-------------------------------------------------------------------------
 * Read functions
 *-------------------------------------------------------------------------
 */
public static native @Cast("herr_t") int H5PTget_next(@Cast("hid_t") long table_id, @Cast("size_t") long nrecords, Pointer data);

public static native @Cast("herr_t") int H5PTread_packets(@Cast("hid_t") long table_id, @Cast("hsize_t") long start,
			@Cast("size_t") long nrecords, Pointer data);

/*-------------------------------------------------------------------------
 * Inquiry functions
 *-------------------------------------------------------------------------
 */
public static native @Cast("herr_t") int H5PTget_num_packets(@Cast("hid_t") long table_id, @Cast("hsize_t*") LongPointer nrecords);
public static native @Cast("herr_t") int H5PTget_num_packets(@Cast("hid_t") long table_id, @Cast("hsize_t*") LongBuffer nrecords);
public static native @Cast("herr_t") int H5PTget_num_packets(@Cast("hid_t") long table_id, @Cast("hsize_t*") long[] nrecords);

public static native @Cast("herr_t") int H5PTis_valid(@Cast("hid_t") long table_id);

public static native @Cast("herr_t") int H5PTis_varlen(@Cast("hid_t") long table_id);

/*-------------------------------------------------------------------------
 *
 * Accessor functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("hid_t") long H5PTget_dataset(@Cast("hid_t") long table_id);

public static native @Cast("hid_t") long H5PTget_type(@Cast("hid_t") long table_id);

/*-------------------------------------------------------------------------
 *
 * Packet Table "current index" functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5PTcreate_index( @Cast("hid_t") long table_id );

public static native @Cast("herr_t") int H5PTset_index( @Cast("hid_t") long table_id,
                             @Cast("hsize_t") long pt_index );

public static native @Cast("herr_t") int H5PTget_index( @Cast("hid_t") long table_id,
                             @Cast("hsize_t*") LongPointer pt_index );
public static native @Cast("herr_t") int H5PTget_index( @Cast("hid_t") long table_id,
                             @Cast("hsize_t*") LongBuffer pt_index );
public static native @Cast("herr_t") int H5PTget_index( @Cast("hid_t") long table_id,
                             @Cast("hsize_t*") long[] pt_index );

/*-------------------------------------------------------------------------
 *
 * Memory Management functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5PTfree_vlen_buff( @Cast("hid_t") long table_id,
                               @Cast("size_t") long bufflen,
                               Pointer buff );

// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5LDpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5LDpublic_H
// #define _H5LDpublic_H

// #ifdef __cplusplus
// #endif

public static native @Cast("herr_t") int H5LDget_dset_dims(@Cast("hid_t") long did, @Cast("hsize_t*") LongPointer cur_dims);
public static native @Cast("herr_t") int H5LDget_dset_dims(@Cast("hid_t") long did, @Cast("hsize_t*") LongBuffer cur_dims);
public static native @Cast("herr_t") int H5LDget_dset_dims(@Cast("hid_t") long did, @Cast("hsize_t*") long[] cur_dims);
public static native @Cast("size_t") long H5LDget_dset_type_size(@Cast("hid_t") long did, @Cast("const char*") BytePointer fields);
public static native @Cast("size_t") long H5LDget_dset_type_size(@Cast("hid_t") long did, String fields);
public static native @Cast("herr_t") int H5LDget_dset_elmts(@Cast("hid_t") long did, @Cast("const hsize_t*") LongPointer prev_dims,
    @Cast("const hsize_t*") LongPointer cur_dims, @Cast("const char*") BytePointer fields, Pointer buf);
public static native @Cast("herr_t") int H5LDget_dset_elmts(@Cast("hid_t") long did, @Cast("const hsize_t*") LongBuffer prev_dims,
    @Cast("const hsize_t*") LongBuffer cur_dims, String fields, Pointer buf);
public static native @Cast("herr_t") int H5LDget_dset_elmts(@Cast("hid_t") long did, @Cast("const hsize_t*") long[] prev_dims,
    @Cast("const hsize_t*") long[] cur_dims, @Cast("const char*") BytePointer fields, Pointer buf);
public static native @Cast("herr_t") int H5LDget_dset_elmts(@Cast("hid_t") long did, @Cast("const hsize_t*") LongPointer prev_dims,
    @Cast("const hsize_t*") LongPointer cur_dims, String fields, Pointer buf);
public static native @Cast("herr_t") int H5LDget_dset_elmts(@Cast("hid_t") long did, @Cast("const hsize_t*") LongBuffer prev_dims,
    @Cast("const hsize_t*") LongBuffer cur_dims, @Cast("const char*") BytePointer fields, Pointer buf);
public static native @Cast("herr_t") int H5LDget_dset_elmts(@Cast("hid_t") long did, @Cast("const hsize_t*") long[] prev_dims,
    @Cast("const hsize_t*") long[] cur_dims, String fields, Pointer buf);

// #ifdef __cplusplus
// #endif

// #endif /* _H5LDpublic_H */



// Parsed from H5PacketTable.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Packet Table wrapper classes
 *
 * Wraps the H5PT Packet Table C functions in C++ objects
 *
 * Nat Furrer and James Laird
 * February 2004
 */

// #ifndef H5PTWRAP_H
// #define H5PTWRAP_H

/* Public HDF5 header */
// #include "hdf5.h"

// #include "H5PTpublic.h"
// #include "H5api_adpt.h"
// Targeting ..\PacketTable.java


// Targeting ..\FL_PacketTable.java



/* Removed "#ifdef VLPT_REMOVED" block.  03/08/2016, -BMR */

// #endif /* H5PTWRAP_H */


// Parsed from H5Cpp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5Cpp_H
// #define __H5Cpp_H

// #include "H5Include.h"
// #include "H5Exception.h"
// #include "H5IdComponent.h"
// #include "H5DataSpace.h"
// #include "H5PropList.h"
// #include "H5FaccProp.h"
// #include "H5FcreatProp.h"
// #include "H5OcreatProp.h"
// #include "H5DcreatProp.h"
// #include "H5DxferProp.h"
// #include "H5LcreatProp.h"
// #include "H5LaccProp.h"
// #include "H5DaccProp.h"
// #include "H5Location.h"
// #include "H5Object.h"
// #include "H5AbstractDs.h"
// #include "H5Attribute.h"
// #include "H5DataType.h"
// #include "H5AtomType.h"
// #include "H5PredType.h"
// #include "H5EnumType.h"
// #include "H5IntType.h"
// #include "H5FloatType.h"
// #include "H5StrType.h"
// #include "H5CompType.h"
// #include "H5ArrayType.h"
// #include "H5VarLenType.h"
// #include "H5DataSet.h"
// #include "H5CommonFG.h"
// #include "H5Group.h"
// #include "H5File.h"
// #include "H5Library.h"

/* Some C++ compilers do not have offsetof macro; define to bypass the problem
   - BMR- -EIP- 2007/08/01
*/
// #ifndef H5_CXX_HAVE_OFFSETOF
// #ifdef HOFFSET
// #endif
// #define HOFFSET(TYPE, MEMBER) ((size_t) &((TYPE *)0)->MEMBER)
// #endif

// #endif // __H5Cpp_H


// Parsed from H5Include.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #include <hdf5.h>

// Define bool type for platforms that don't support bool yet
// #ifdef BOOL_NOTDEFINED
// #endif

// These are defined in H5Opkg.h, which should not be included in the C++ API,
// so re-define them here for now.

/* Initial version of the object header format */
public static final int H5O_VERSION_1 =    1;

/* Revised version - leaves out reserved bytes and alignment padding, and adds
 *      magic number as prefix and checksum as suffix for all chunks.
 */
public static final int H5O_VERSION_2 =    2;



// Parsed from H5Exception.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5Exception_H
// #define __H5Exception_H

// #include <string>
// #ifdef H5_NO_STD
// #else
//     #define H5std_string std::string
// Targeting ..\Exception.java


// Targeting ..\FileIException.java


// Targeting ..\GroupIException.java


// Targeting ..\DataSpaceIException.java


// Targeting ..\DataTypeIException.java


// Targeting ..\ObjHeaderIException.java


// Targeting ..\PropListIException.java


// Targeting ..\DataSetIException.java


// Targeting ..\AttributeIException.java


// Targeting ..\ReferenceException.java


// Targeting ..\LibraryIException.java


// Targeting ..\LocationException.java


// Targeting ..\IdComponentException.java

 // end of IdComponentException
 // namespace H5

// #endif // __H5Exception_H


// Parsed from H5IdComponent.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __IdComponent_H
// #define __IdComponent_H
// Targeting ..\IdComponent.java

 // end class IdComponent
 // namespace H5

// #endif // __IdComponent_H


// Parsed from H5DataSpace.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5DataSpace_H
// #define __H5DataSpace_H
// Targeting ..\DataSpace.java

 // end of DataSpace
 // namespace H5

// #endif // __H5DataSpace_H


// Parsed from H5PropList.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5PropList_H
// #define __H5PropList_H
// Targeting ..\PropList.java

 // end of PropList
 // namespace H5

// #endif  // __H5PropList_H


// Parsed from H5AbstractDs.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __AbstractDs_H
// #define __AbstractDs_H
// Targeting ..\AbstractDs.java

 // end of AbstractDs
 // namespace H5

// #endif // __AbstractDs_H


// Parsed from H5Attribute.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5Attribute_H
// #define __H5Attribute_H
// Targeting ..\Attribute.java

 // end of Attribute
 // namespace H5

// #endif // __H5Attribute_H


// Parsed from H5OcreatProp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5ObjCreatPropList_H
// #define __H5ObjCreatPropList_H
// Targeting ..\ObjCreatPropList.java

 // end of ObjCreatPropList
 // namespace H5

// #endif // __H5ObjCreatPropList_H


// Parsed from H5DcreatProp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5DSCreatPropList_H
// #define __H5DSCreatPropList_H

// Class forwarding
// Targeting ..\DSetCreatPropList.java

 // end of DSetCreatPropList
 // namespace H5

// #endif // __H5DSCreatPropList_H


// Parsed from H5LaccProp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5LinkAccPropList_H
// #define __H5LinkAccPropList_H
// Targeting ..\LinkAccPropList.java

 // end of LinkAccPropList
 // namespace H5

// #endif // __H5LinkAccPropList_H


// Parsed from H5DaccProp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5DSetAccPropList_H
// #define __H5DSetAccPropList_H
// Targeting ..\DSetAccPropList.java

 // end of DSetAccPropList
 // namespace H5

// #endif // __H5DSetAccPropList_H


// Parsed from H5LcreatProp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5LinkCreatPropList_H
// #define __H5LinkCreatPropList_H
// Targeting ..\LinkCreatPropList.java

 // end of LinkCreatPropList
 // namespace H5

// #endif // __H5LinkCreatPropList_H


// Parsed from H5Location.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5Location_H
// #define __H5Location_H

// #include "H5Classes.h"        // constains forward class declarations
// Targeting ..\H5Location.java

 // end of H5Location
 // namespace H5

// #endif // __H5Location_H


// Parsed from H5Object.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5Object_H
// #define __H5Object_H
// Targeting ..\attr_operator_t.java


// Targeting ..\visit_operator_t.java


// Targeting ..\UserData4Aiterate.java


// Targeting ..\UserData4Visit.java


// Targeting ..\H5Object.java

 // end of H5Object
 // namespace H5

// #endif // __H5Object_H


// Parsed from H5CommonFG.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __CommonFG_H
// #define __CommonFG_H

// Class forwarding
// Targeting ..\CommonFG.java

 // end of CommonFG
 // namespace H5

// #endif // __CommonFG_H

/***************************************************************************
                                Design Note
                                ===========
<p>
September 2017:
        <p>
        This class used to be base class of H5File as well, until the
        restructure that moved H5File to be subclass of H5Group.
*/


// Parsed from H5DataType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5DataType_H
// #define __H5DataType_H
// Targeting ..\DataType.java

 // end of DataType
 // namespace H5

// #endif // __H5DataType_H


// Parsed from H5DxferProp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5DSetMemXferPropList_H
// #define __H5DSetMemXferPropList_H
// Targeting ..\DSetMemXferPropList.java

 // end of DSetMemXferPropList
 // namespace H5

// #endif // __H5DSetMemXferPropList_H


// Parsed from H5FaccProp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5FileAccPropList_H
// #define __H5FileAccPropList_H
// Targeting ..\FileAccPropList.java

 // end of FileAccPropList
 // namespace H5

// #endif // __H5FileAccPropList_H


// Parsed from H5FcreatProp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5FileCreatPropList_H
// #define __H5FileCreatPropList_H
// Targeting ..\FileCreatPropList.java

 // end of FileCreatPropList
 // namespace H5

// #endif // __H5FileCreatPropList_H


// Parsed from H5AtomType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5AtomType_H
// #define __H5AtomType_H
// Targeting ..\AtomType.java

 // end of AtomType
 // namespace H5

// #endif // __H5AtomType_H


// Parsed from H5PredType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5PredType_H
// #define __H5PredType_H
// Targeting ..\PredType.java

 // end of PredType
 // namespace H5

// #endif // __H5PredType_H


// Parsed from H5EnumType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5EnumType_H
// #define __H5EnumType_H
// Targeting ..\EnumType.java

 // end of EnumType
 // namespace H5

// #endif // __H5EnumType_H


// Parsed from H5IntType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5IntType_H
// #define __H5IntType_H
// Targeting ..\IntType.java

 // end of IntType
 // namespace H5

// #endif // __H5IntType_H


// Parsed from H5FloatType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5FloatType_H
// #define __H5FloatType_H
// Targeting ..\FloatType.java

 // end of FloatType
 // namespace H5

// #endif // __H5FloatType_H


// Parsed from H5StrType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5StrType_H
// #define __H5StrType_H
// Targeting ..\StrType.java

 // end of StrType
 // namespace H5

// #endif // __H5StrType_H


// Parsed from H5CompType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5CompType_H
// #define __H5CompType_H
// Targeting ..\CompType.java

 // end of CompType
 // namespace H5

// #endif // __H5CompType_H


// Parsed from H5ArrayType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5ArrayType_H
// #define __H5ArrayType_H
// Targeting ..\ArrayType.java

 // end of ArrayType
 // namespace H5

// #endif // __H5ArrayType_H


// Parsed from H5VarLenType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5VarLenType_H
// #define __H5VarLenType_H
// Targeting ..\VarLenType.java

 // end of VarLenType
 // namespace H5

// #endif // __H5VarLenType_H


// Parsed from H5DataSet.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5DataSet_H
// #define __H5DataSet_H
// Targeting ..\DataSet.java

 // end of DataSet
 // namespace H5

// #endif // __H5DataSet_H


// Parsed from H5Group.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __Group_H
// #define __Group_H
// Targeting ..\Group.java

 // end of Group
 // namespace H5

// #endif // __Group_H


// Parsed from H5File.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5File_H
// #define __H5File_H
// Targeting ..\H5File.java

 // end of H5File
 // namespace H5

// #endif // __H5File_H



// Parsed from H5Library.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5Library_H
// #define __H5Library_H
// Targeting ..\H5Library.java

 // end of H5Library
 // namespace H5

// #endif // __H5Library_H


}
