// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.hdf5.global.hdf5.*;


/** \class PropList
    \brief Class PropList inherits from IdComponent and provides wrappers for
    the HDF5 generic property list.
*/
//  Inheritance: IdComponent
@Namespace("H5") @NoOffset @Properties(inherit = org.bytedeco.hdf5.presets.hdf5.class)
public class PropList extends IdComponent {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PropList(Pointer p) { super(p); }

        /**\brief Default property list */
        @MemberGetter public static native @Const @ByRef PropList DEFAULT();

        // Creates a property list of a given type or creates a copy of an
        // existing property list giving the property list id.
        public PropList(@Cast("const hid_t") long plist_id) { super((Pointer)null); allocate(plist_id); }
        private native void allocate(@Cast("const hid_t") long plist_id);

        // Make a copy of the given property list using assignment statement
        public native @ByRef @Name("operator =") PropList put(@Const @ByRef PropList rhs);

        // Compares this property list or class against the given list or class.
        public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef PropList rhs);

        // Close this property list.
        public native @Name("close") void _close();

        // Close a property list class.
        public native void closeClass();

        // Makes a copy of the given property list.
        public native void copy(@Const @ByRef PropList like_plist);

        // Copies a property from this property list or class to another
        public native void copyProp(@ByRef PropList dest, @Cast("const char*") BytePointer name);
        public native void copyProp(@ByRef PropList dest, String name);

        // Copies a property from one property list or property class to another
        public native void copyProp(@ByRef PropList dest, @ByRef PropList src, @Cast("const char*") BytePointer name);
        public native void copyProp(@ByRef PropList dest, @ByRef PropList src, String name);

        // Gets the class of this property list, i.e. H5P_FILE_CREATE,
        // H5P_FILE_ACCESS, ...
        public native @Cast("hid_t") @Name("getClass") long _getClass();

        // Return the name of a generic property list class.
        public native @StdString BytePointer getClassName();

        // Returns the parent class of a generic property class.
        public native @ByVal PropList getClassParent();

        // Returns the number of properties in this property list or class.
        public native @Cast("size_t") long getNumProps();

        // Query the value of a property in a property list.
        public native void getProperty(@Cast("const char*") BytePointer name, Pointer value);
        public native void getProperty(String name, Pointer value);
        public native @StdString BytePointer getProperty(@Cast("const char*") BytePointer name);
        public native @StdString String getProperty(String name);

        // Set a property's value in a property list.
        public native void setProperty(@Cast("const char*") BytePointer name, @Cast("const char*") BytePointer charptr);
        public native void setProperty(String name, String charptr);
        public native void setProperty(@Cast("const char*") BytePointer name, @Const Pointer value);
        public native void setProperty(String name, @Const Pointer value);
        // Deprecated after 1.10.1, missing const
        public native void setProperty(String name, @StdString @ByRef BytePointer strg);

        // Query the size of a property in a property list or class.
        public native @Cast("size_t") long getPropSize(@Cast("const char*") BytePointer name);
        public native @Cast("size_t") long getPropSize(String name);

        // Determines whether a property list is a certain class.
        public native @Cast("bool") boolean isAClass(@Const @ByRef PropList prop_class);

        /** Query the existence of a property in a property object. */
        public native @Cast("bool") boolean propExist(@Cast("const char*") BytePointer name);
        public native @Cast("bool") boolean propExist(String name);

        // Removes a property from a property list.
        public native void removeProp(@Cast("const char*") BytePointer name);
        public native void removeProp(String name);

        /**\brief Returns this class name. */
        public native @StdString BytePointer fromClass();

        // Default constructor: creates a stub PropList object.
        public PropList() { super((Pointer)null); allocate(); }
        private native void allocate();

        // Copy constructor: same as the original PropList.
        public PropList(@Const @ByRef PropList original) { super((Pointer)null); allocate(original); }
        private native void allocate(@Const @ByRef PropList original);

        // Gets the property list id.
        public native @Cast("hid_t") long getId();

        // Destructor: properly terminates access to this property list.

// #ifndef DOXYGEN_SHOULD_SKIP_THIS

        // Deletes the PropList global constant
        public static native void deleteConstants();

}
