// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.hyperscan.global;

import org.bytedeco.hyperscan.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class hyperscan extends org.bytedeco.hyperscan.presets.hyperscan {
    static { Loader.load(); }

// Parsed from hs/hs_common.h

/*
 * Copyright (c) 2015-2019, Intel Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of Intel Corporation nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef HS_COMMON_H_
// #define HS_COMMON_H_

// #if defined(_WIN32)
// #define HS_CDECL    __cdecl
// #else
// #define HS_CDECL
// #endif
// #include <stdlib.h>

/**
 * \file
 * \brief The Hyperscan common API definition.
 *
 * Hyperscan is a high speed regular expression engine.
 *
 * This header contains functions available to both the Hyperscan compiler and
 * runtime.
 */

// #ifdef __cplusplus
// Targeting ../hs_database.java


// Targeting ../hs_database_t.java



/**
 * A type for errors returned by Hyperscan functions.
 */

/**
 * Free a compiled pattern database.
 *
 * The free callback set by \ref hs_set_database_allocator() (or \ref
 * hs_set_allocator()) will be used by this function.
 *
 * @param db
 *      A compiled pattern database. NULL may also be safely provided, in which
 *      case the function does nothing.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_free_database(hs_database_t db);

/**
 * Serialize a pattern database to a stream of bytes.
 *
 * The allocator callback set by \ref hs_set_misc_allocator() (or \ref
 * hs_set_allocator()) will be used by this function.
 *
 * @param db
 *      A compiled pattern database.
 *
 * @param bytes
 *      On success, a pointer to an array of bytes will be returned here.
 *      These bytes can be subsequently relocated or written to disk. The
 *      caller is responsible for freeing this block.
 *
 * @param length
 *      On success, the number of bytes in the generated byte array will be
 *      returned here.
 *
 * @return
 *      \ref HS_SUCCESS on success, \ref HS_NOMEM if the byte array cannot be
 *      allocated, other values may be returned if errors are detected.
 */
public static native @Cast("hs_error_t") int hs_serialize_database(@Const hs_database_t db, @Cast("char**") PointerPointer bytes,
                                          @Cast("size_t*") SizeTPointer length);
public static native @Cast("hs_error_t") int hs_serialize_database(@Const hs_database_t db, @Cast("char**") @ByPtrPtr BytePointer bytes,
                                          @Cast("size_t*") SizeTPointer length);
public static native @Cast("hs_error_t") int hs_serialize_database(@Const hs_database_t db, @Cast("char**") @ByPtrPtr ByteBuffer bytes,
                                          @Cast("size_t*") SizeTPointer length);
public static native @Cast("hs_error_t") int hs_serialize_database(@Const hs_database_t db, @Cast("char**") @ByPtrPtr byte[] bytes,
                                          @Cast("size_t*") SizeTPointer length);

/**
 * Reconstruct a pattern database from a stream of bytes previously generated
 * by \ref hs_serialize_database().
 *
 * This function will allocate sufficient space for the database using the
 * allocator set with \ref hs_set_database_allocator() (or \ref
 * hs_set_allocator()); to use a pre-allocated region of memory, use the \ref
 * hs_deserialize_database_at() function.
 *
 * @param bytes
 *      A byte array generated by \ref hs_serialize_database() representing a
 *      compiled pattern database.
 *
 * @param length
 *      The length of the byte array generated by \ref hs_serialize_database().
 *      This should be the same value as that returned by \ref
 *      hs_serialize_database().
 *
 * @param db
 *      On success, a pointer to a newly allocated \ref hs_database_t will be
 *      returned here. This database can then be used for scanning, and
 *      eventually freed by the caller using \ref hs_free_database().
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_deserialize_database(@Cast("const char*") BytePointer bytes,
                                            @Cast("const size_t") long length,
                                            @Cast("hs_database_t**") PointerPointer db);
public static native @Cast("hs_error_t") int hs_deserialize_database(@Cast("const char*") BytePointer bytes,
                                            @Cast("const size_t") long length,
                                            @ByPtrPtr hs_database_t db);
public static native @Cast("hs_error_t") int hs_deserialize_database(String bytes,
                                            @Cast("const size_t") long length,
                                            @ByPtrPtr hs_database_t db);

/**
 * Reconstruct a pattern database from a stream of bytes previously generated
 * by \ref hs_serialize_database() at a given memory location.
 *
 * This function (unlike \ref hs_deserialize_database()) will write the
 * reconstructed database to the memory location given in the \p db parameter.
 * The amount of space required at this location can be determined with the
 * \ref hs_serialized_database_size() function.
 *
 * @param bytes
 *      A byte array generated by \ref hs_serialize_database() representing a
 *      compiled pattern database.
 *
 * @param length
 *      The length of the byte array generated by \ref hs_serialize_database().
 *      This should be the same value as that returned by \ref
 *      hs_serialize_database().
 *
 * @param db
 *      Pointer to an 8-byte aligned block of memory of sufficient size to hold
 *      the deserialized database. On success, the reconstructed database will
 *      be written to this location. This database can then be used for pattern
 *      matching. The user is responsible for freeing this memory; the \ref
 *      hs_free_database() call should not be used.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_deserialize_database_at(@Cast("const char*") BytePointer bytes,
                                               @Cast("const size_t") long length,
                                               hs_database_t db);
public static native @Cast("hs_error_t") int hs_deserialize_database_at(String bytes,
                                               @Cast("const size_t") long length,
                                               hs_database_t db);

/**
 * Provides the size of the stream state allocated by a single stream opened
 * against the given database.
 *
 * @param database
 *      Pointer to a compiled (streaming mode) pattern database.
 *
 * @param stream_size
 *      On success, the size in bytes of an individual stream opened against the
 *      given database is placed in this parameter.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_stream_size(@Const hs_database_t database,
                                   @Cast("size_t*") SizeTPointer stream_size);

/**
 * Provides the size of the given database in bytes.
 *
 * @param database
 *      Pointer to compiled pattern database.
 *
 * @param database_size
 *      On success, the size of the compiled database in bytes is placed in this
 *      parameter.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_database_size(@Const hs_database_t database,
                                     @Cast("size_t*") SizeTPointer database_size);

/**
 * Utility function for reporting the size that would be required by a
 * database if it were deserialized.
 *
 * This can be used to allocate a shared memory region or other "special"
 * allocation prior to deserializing with the \ref hs_deserialize_database_at()
 * function.
 *
 * @param bytes
 *      Pointer to a byte array generated by \ref hs_serialize_database()
 *      representing a compiled pattern database.
 *
 * @param length
 *      The length of the byte array generated by \ref hs_serialize_database().
 *      This should be the same value as that returned by \ref
 *      hs_serialize_database().
 *
 * @param deserialized_size
 *      On success, the size of the compiled database that would be generated
 *      by \ref hs_deserialize_database_at() is returned here.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_serialized_database_size(@Cast("const char*") BytePointer bytes,
                                                @Cast("const size_t") long length,
                                                @Cast("size_t*") SizeTPointer deserialized_size);
public static native @Cast("hs_error_t") int hs_serialized_database_size(String bytes,
                                                @Cast("const size_t") long length,
                                                @Cast("size_t*") SizeTPointer deserialized_size);

/**
 * Utility function providing information about a database.
 *
 * @param database
 *      Pointer to a compiled database.
 *
 * @param info
 *      On success, a string containing the version and platform information for
 *      the supplied database is placed in the parameter. The string is
 *      allocated using the allocator supplied in \ref hs_set_misc_allocator()
 *      (or malloc() if no allocator was set) and should be freed by the caller.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_database_info(@Const hs_database_t database,
                                     @Cast("char**") PointerPointer info);
public static native @Cast("hs_error_t") int hs_database_info(@Const hs_database_t database,
                                     @Cast("char**") @ByPtrPtr BytePointer info);
public static native @Cast("hs_error_t") int hs_database_info(@Const hs_database_t database,
                                     @Cast("char**") @ByPtrPtr ByteBuffer info);
public static native @Cast("hs_error_t") int hs_database_info(@Const hs_database_t database,
                                     @Cast("char**") @ByPtrPtr byte[] info);

/**
 * Utility function providing information about a serialized database.
 *
 * @param bytes
 *      Pointer to a serialized database.
 *
 * @param length
 *      Length in bytes of the serialized database.
 *
 * @param info
 *      On success, a string containing the version and platform information
 *      for the supplied serialized database is placed in the parameter. The
 *      string is allocated using the allocator supplied in \ref
 *      hs_set_misc_allocator() (or malloc() if no allocator was set) and
 *      should be freed by the caller.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_serialized_database_info(@Cast("const char*") BytePointer bytes,
                                                @Cast("size_t") long length, @Cast("char**") PointerPointer info);
public static native @Cast("hs_error_t") int hs_serialized_database_info(@Cast("const char*") BytePointer bytes,
                                                @Cast("size_t") long length, @Cast("char**") @ByPtrPtr BytePointer info);
public static native @Cast("hs_error_t") int hs_serialized_database_info(String bytes,
                                                @Cast("size_t") long length, @Cast("char**") @ByPtrPtr ByteBuffer info);
public static native @Cast("hs_error_t") int hs_serialized_database_info(@Cast("const char*") BytePointer bytes,
                                                @Cast("size_t") long length, @Cast("char**") @ByPtrPtr byte[] info);
public static native @Cast("hs_error_t") int hs_serialized_database_info(String bytes,
                                                @Cast("size_t") long length, @Cast("char**") @ByPtrPtr BytePointer info);
public static native @Cast("hs_error_t") int hs_serialized_database_info(@Cast("const char*") BytePointer bytes,
                                                @Cast("size_t") long length, @Cast("char**") @ByPtrPtr ByteBuffer info);
public static native @Cast("hs_error_t") int hs_serialized_database_info(String bytes,
                                                @Cast("size_t") long length, @Cast("char**") @ByPtrPtr byte[] info);
// Targeting ../hs_alloc_t.java


// Targeting ../hs_free_t.java



/**
 * Set the allocate and free functions used by Hyperscan for allocating
 * memory at runtime for stream state, scratch space, database bytecode,
 * and various other data structure returned by the Hyperscan API.
 *
 * The function is equivalent to calling \ref hs_set_stream_allocator(),
 * \ref hs_set_scratch_allocator(), \ref hs_set_database_allocator() and
 * \ref hs_set_misc_allocator() with the provided parameters.
 *
 * This call will override any previous allocators that have been set.
 *
 * Note: there is no way to change the allocator used for temporary objects
 * created during the various compile calls (\ref hs_compile(), \ref
 * hs_compile_multi(), \ref hs_compile_ext_multi()).
 *
 * @param alloc_func
 *      A callback function pointer that allocates memory. This function must
 *      return memory suitably aligned for the largest representable data type
 *      on this platform.
 *
 * @param free_func
 *      A callback function pointer that frees allocated memory.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_set_allocator(hs_alloc_t alloc_func,
                                     hs_free_t free_func);

/**
 * Set the allocate and free functions used by Hyperscan for allocating memory
 * for database bytecode produced by the compile calls (\ref hs_compile(), \ref
 * hs_compile_multi(), \ref hs_compile_ext_multi()) and by database
 * deserialization (\ref hs_deserialize_database()).
 *
 * If no database allocation functions are set, or if NULL is used in place of
 * both parameters, then memory allocation will default to standard methods
 * (such as the system malloc() and free() calls).
 *
 * This call will override any previous database allocators that have been set.
 *
 * Note: the database allocator may also be set by calling \ref
 * hs_set_allocator().
 *
 * Note: there is no way to change how temporary objects created during the
 * various compile calls (\ref hs_compile(), \ref hs_compile_multi(), \ref
 * hs_compile_ext_multi()) are allocated.
 *
 * @param alloc_func
 *      A callback function pointer that allocates memory. This function must
 *      return memory suitably aligned for the largest representable data type
 *      on this platform.
 *
 * @param free_func
 *      A callback function pointer that frees allocated memory.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_set_database_allocator(hs_alloc_t alloc_func,
                                              hs_free_t free_func);

/**
 * Set the allocate and free functions used by Hyperscan for allocating memory
 * for items returned by the Hyperscan API such as \ref hs_compile_error_t, \ref
 * hs_expr_info_t and serialized databases.
 *
 * If no misc allocation functions are set, or if NULL is used in place of both
 * parameters, then memory allocation will default to standard methods (such as
 * the system malloc() and free() calls).
 *
 * This call will override any previous misc allocators that have been set.
 *
 * Note: the misc allocator may also be set by calling \ref hs_set_allocator().
 *
 * @param alloc_func
 *      A callback function pointer that allocates memory. This function must
 *      return memory suitably aligned for the largest representable data type
 *      on this platform.
 *
 * @param free_func
 *      A callback function pointer that frees allocated memory.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_set_misc_allocator(hs_alloc_t alloc_func,
                                          hs_free_t free_func);

/**
 * Set the allocate and free functions used by Hyperscan for allocating memory
 * for scratch space by \ref hs_alloc_scratch() and \ref hs_clone_scratch().
 *
 * If no scratch allocation functions are set, or if NULL is used in place of
 * both parameters, then memory allocation will default to standard methods
 * (such as the system malloc() and free() calls).
 *
 * This call will override any previous scratch allocators that have been set.
 *
 * Note: the scratch allocator may also be set by calling \ref
 * hs_set_allocator().
 *
 * @param alloc_func
 *      A callback function pointer that allocates memory. This function must
 *      return memory suitably aligned for the largest representable data type
 *      on this platform.
 *
 * @param free_func
 *      A callback function pointer that frees allocated memory.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_set_scratch_allocator(hs_alloc_t alloc_func,
                                             hs_free_t free_func);

/**
 * Set the allocate and free functions used by Hyperscan for allocating memory
 * for stream state by \ref hs_open_stream().
 *
 * If no stream allocation functions are set, or if NULL is used in place of
 * both parameters, then memory allocation will default to standard methods
 * (such as the system malloc() and free() calls).
 *
 * This call will override any previous stream allocators that have been set.
 *
 * Note: the stream allocator may also be set by calling \ref
 * hs_set_allocator().
 *
 * @param alloc_func
 *      A callback function pointer that allocates memory. This function must
 *      return memory suitably aligned for the largest representable data type
 *      on this platform.
 *
 * @param free_func
 *      A callback function pointer that frees allocated memory.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_set_stream_allocator(hs_alloc_t alloc_func,
                                            hs_free_t free_func);

/**
 * Utility function for identifying this release version.
 *
 * @return
 *      A string containing the version number of this release build and the
 *      date of the build. It is allocated statically, so it does not need to
 *      be freed by the caller.
 */
public static native @Cast("const char*") BytePointer hs_version();

/**
 * Utility function to test the current system architecture.
 *
 * Hyperscan requires the Supplemental Streaming SIMD Extensions 3 instruction
 * set. This function can be called on any x86 platform to determine if the
 * system provides the required instruction set.
 *
 * This function does not test for more advanced features if Hyperscan has
 * been built for a more specific architecture, for example the AVX2
 * instruction set.
 *
 * @return
 *      \ref HS_SUCCESS on success, \ref HS_ARCH_ERROR if system does not
 *      support Hyperscan.
 */
public static native @Cast("hs_error_t") int hs_valid_platform();

/**
 * \defgroup HS_ERROR hs_error_t values
 *
 * \{
 */

/**
 * The engine completed normally.
 */
public static final int HS_SUCCESS =              0;

/**
 * A parameter passed to this function was invalid.
 *
 * This error is only returned in cases where the function can detect an
 * invalid parameter -- it cannot be relied upon to detect (for example)
 * pointers to freed memory or other invalid data.
 */
public static final int HS_INVALID =              (-1);

/**
 * A memory allocation failed.
 */
public static final int HS_NOMEM =                (-2);

/**
 * The engine was terminated by callback.
 *
 * This return value indicates that the target buffer was partially scanned,
 * but that the callback function requested that scanning cease after a match
 * was located.
 */
public static final int HS_SCAN_TERMINATED =      (-3);

/**
 * The pattern compiler failed, and the \ref hs_compile_error_t should be
 * inspected for more detail.
 */
public static final int HS_COMPILER_ERROR =       (-4);

/**
 * The given database was built for a different version of Hyperscan.
 */
public static final int HS_DB_VERSION_ERROR =     (-5);

/**
 * The given database was built for a different platform (i.e., CPU type).
 */
public static final int HS_DB_PLATFORM_ERROR =    (-6);

/**
 * The given database was built for a different mode of operation. This error
 * is returned when streaming calls are used with a block or vectored database
 * and vice versa.
 */
public static final int HS_DB_MODE_ERROR =        (-7);

/**
 * A parameter passed to this function was not correctly aligned.
 */
public static final int HS_BAD_ALIGN =            (-8);

/**
 * The memory allocator (either malloc() or the allocator set with \ref
 * hs_set_allocator()) did not correctly return memory suitably aligned for the
 * largest representable data type on this platform.
 */
public static final int HS_BAD_ALLOC =            (-9);

/**
 * The scratch region was already in use.
 *
 * This error is returned when Hyperscan is able to detect that the scratch
 * region given is already in use by another Hyperscan API call.
 *
 * A separate scratch region, allocated with \ref hs_alloc_scratch() or \ref
 * hs_clone_scratch(), is required for every concurrent caller of the Hyperscan
 * API.
 *
 * For example, this error might be returned when \ref hs_scan() has been
 * called inside a callback delivered by a currently-executing \ref hs_scan()
 * call using the same scratch region.
 *
 * Note: Not all concurrent uses of scratch regions may be detected. This error
 * is intended as a best-effort debugging tool, not a guarantee.
 */
public static final int HS_SCRATCH_IN_USE =       (-10);

/**
 * Unsupported CPU architecture.
 *
 * This error is returned when Hyperscan is able to detect that the current
 * system does not support the required instruction set.
 *
 * At a minimum, Hyperscan requires Supplemental Streaming SIMD Extensions 3
 * (SSSE3).
 */
public static final int HS_ARCH_ERROR =           (-11);

/**
 * Provided buffer was too small.
 *
 * This error indicates that there was insufficient space in the buffer. The
 * call should be repeated with a larger provided buffer.
 *
 * Note: in this situation, it is normal for the amount of space required to be
 * returned in the same manner as the used space would have been returned if the
 * call was successful.
 */
public static final int HS_INSUFFICIENT_SPACE =   (-12);

/**
 * Unexpected internal error.
 *
 * This error indicates that there was unexpected matching behaviors. This
 * could be related to invalid usage of stream and scratch space or invalid memory
 * operations by users.
 *
 */
public static final int HS_UNKNOWN_ERROR =   (-13);

/** \} */

// #ifdef __cplusplus /* extern "C" */
// #endif

// #endif /* HS_COMMON_H_ */


// Parsed from hs/hs_compile.h

/*
 * Copyright (c) 2015-2021, Intel Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of Intel Corporation nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef HS_COMPILE_H_
// #define HS_COMPILE_H_

/**
 * \file
 * \brief The Hyperscan compiler API definition.
 *
 * Hyperscan is a high speed regular expression engine.
 *
 * This header contains functions for compiling regular expressions into
 * Hyperscan databases that can be used by the Hyperscan runtime.
 */

// #include "hs_common.h"

// #ifdef __cplusplus
// Targeting ../hs_compile_error_t.java


// Targeting ../hs_platform_info_t.java


// Targeting ../hs_expr_info_t.java


// Targeting ../hs_expr_ext_t.java



/**
 * \defgroup HS_EXT_FLAG hs_expr_ext_t flags
 *
 * These flags are used in \ref hs_expr_ext_t::flags to indicate which fields
 * are used.
 *
 * \{
 */

/** Flag indicating that the hs_expr_ext::min_offset field is used. */
public static final long HS_EXT_FLAG_MIN_OFFSET =      1L;

/** Flag indicating that the hs_expr_ext::max_offset field is used. */
public static final long HS_EXT_FLAG_MAX_OFFSET =      2L;

/** Flag indicating that the hs_expr_ext::min_length field is used. */
public static final long HS_EXT_FLAG_MIN_LENGTH =      4L;

/** Flag indicating that the hs_expr_ext::edit_distance field is used. */
public static final long HS_EXT_FLAG_EDIT_DISTANCE =   8L;

/** Flag indicating that the hs_expr_ext::hamming_distance field is used. */
public static final long HS_EXT_FLAG_HAMMING_DISTANCE = 16L;

/** \} */

/**
 * The basic regular expression compiler.
 *
 * This is the function call with which an expression is compiled into a
 * Hyperscan database which can be passed to the runtime functions (such as
 * \ref hs_scan(), \ref hs_open_stream(), etc.)
 *
 * @param expression
 *      The NULL-terminated expression to parse. Note that this string must
 *      represent ONLY the pattern to be matched, with no delimiters or flags;
 *      any global flags should be specified with the \p flags argument. For
 *      example, the expression {@code /abc?def/i} should be compiled by providing
 *      {@code abc?def} as the \p expression, and \ref HS_FLAG_CASELESS as the \a
 *      flags.
 *
 * @param flags
 *      Flags which modify the behaviour of the expression. Multiple flags may
 *      be used by ORing them together. Valid values are:
 *       - HS_FLAG_CASELESS - Matching will be performed case-insensitively.
 *       - HS_FLAG_DOTALL - Matching a {@code .} will not exclude newlines.
 *       - HS_FLAG_MULTILINE - {@code ^} and {@code $} anchors match any newlines in data.
 *       - HS_FLAG_SINGLEMATCH - Only one match will be generated for the
 *                               expression per stream.
 *       - HS_FLAG_ALLOWEMPTY - Allow expressions which can match against an
 *                              empty string, such as {@code .*}.
 *       - HS_FLAG_UTF8 - Treat this pattern as a sequence of UTF-8 characters.
 *       - HS_FLAG_UCP - Use Unicode properties for character classes.
 *       - HS_FLAG_PREFILTER - Compile pattern in prefiltering mode.
 *       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset
 *                                when a match is found.
 *       - HS_FLAG_COMBINATION - Parse the expression in logical combination
 *                               syntax.
 *       - HS_FLAG_QUIET - Ignore match reporting for this expression. Used for
 *                         the sub-expressions in logical combinations.
 *
 * @param mode
 *      Compiler mode flags that affect the database as a whole. One of \ref
 *      HS_MODE_STREAM or \ref HS_MODE_BLOCK or \ref HS_MODE_VECTORED must be
 *      supplied, to select between the generation of a streaming, block or
 *      vectored database. In addition, other flags (beginning with HS_MODE_)
 *      may be supplied to enable specific features. See \ref HS_MODE_FLAG for
 *      more details.
 *
 * @param platform
 *      If not NULL, the platform structure is used to determine the target
 *      platform for the database. If NULL, a database suitable for running
 *      on the current host platform is produced.
 *
 * @param db
 *      On success, a pointer to the generated database will be returned in
 *      this parameter, or NULL on failure. The caller is responsible for
 *      deallocating the buffer using the \ref hs_free_database() function.
 *
 * @param error
 *      If the compile fails, a pointer to a \ref hs_compile_error_t will be
 *      returned, providing details of the error condition. The caller is
 *      responsible for deallocating the buffer using the \ref
 *      hs_free_compile_error() function.
 *
 * @return
 *      \ref HS_SUCCESS is returned on successful compilation; \ref
 *      HS_COMPILER_ERROR on failure, with details provided in the error
 *      parameter.
 */
public static native @Cast("hs_error_t") int hs_compile(@Cast("const char*") BytePointer expression, @Cast("unsigned int") int flags,
                               @Cast("unsigned int") int mode,
                               @Const hs_platform_info_t platform,
                               @Cast("hs_database_t**") PointerPointer db, @Cast("hs_compile_error_t**") PointerPointer error);
public static native @Cast("hs_error_t") int hs_compile(@Cast("const char*") BytePointer expression, @Cast("unsigned int") int flags,
                               @Cast("unsigned int") int mode,
                               @Const hs_platform_info_t platform,
                               @ByPtrPtr hs_database_t db, @ByPtrPtr hs_compile_error_t error);
public static native @Cast("hs_error_t") int hs_compile(String expression, @Cast("unsigned int") int flags,
                               @Cast("unsigned int") int mode,
                               @Const hs_platform_info_t platform,
                               @ByPtrPtr hs_database_t db, @ByPtrPtr hs_compile_error_t error);

/**
 * The multiple regular expression compiler.
 *
 * This is the function call with which a set of expressions is compiled into a
 * database which can be passed to the runtime functions (such as \ref
 * hs_scan(), \ref hs_open_stream(), etc.) Each expression can be labelled with
 * a unique integer which is passed into the match callback to identify the
 * pattern that has matched.
 *
 * @param expressions
 *      Array of NULL-terminated expressions to compile. Note that (as for \ref
 *      hs_compile()) these strings must contain only the pattern to be
 *      matched, with no delimiters or flags. For example, the expression
 *      {@code /abc?def/i} should be compiled by providing {@code abc?def} as the first
 *      string in the \p expressions array, and \ref HS_FLAG_CASELESS as the
 *      first value in the \p flags array.
 *
 * @param flags
 *      Array of flags which modify the behaviour of each expression. Multiple
 *      flags may be used by ORing them together.  Specifying the NULL pointer
 *      in place of an array will set the flags value for all patterns to zero.
 *      Valid values are:
 *       - HS_FLAG_CASELESS - Matching will be performed case-insensitively.
 *       - HS_FLAG_DOTALL - Matching a {@code .} will not exclude newlines.
 *       - HS_FLAG_MULTILINE - {@code ^} and {@code $} anchors match any newlines in data.
 *       - HS_FLAG_SINGLEMATCH - Only one match will be generated by patterns
 *                               with this match id per stream.
 *       - HS_FLAG_ALLOWEMPTY - Allow expressions which can match against an
 *                              empty string, such as {@code .*}.
 *       - HS_FLAG_UTF8 - Treat this pattern as a sequence of UTF-8 characters.
 *       - HS_FLAG_UCP - Use Unicode properties for character classes.
 *       - HS_FLAG_PREFILTER - Compile pattern in prefiltering mode.
 *       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset
 *                                when a match is found.
 *       - HS_FLAG_COMBINATION - Parse the expression in logical combination
 *                               syntax.
 *       - HS_FLAG_QUIET - Ignore match reporting for this expression. Used for
 *                         the sub-expressions in logical combinations.
 *
 * @param ids
 *      An array of integers specifying the ID number to be associated with the
 *      corresponding pattern in the expressions array. Specifying the NULL
 *      pointer in place of an array will set the ID value for all patterns to
 *      zero.
 *
 * @param elements
 *      The number of elements in the input arrays.
 *
 * @param mode
 *      Compiler mode flags that affect the database as a whole. One of \ref
 *      HS_MODE_STREAM or \ref HS_MODE_BLOCK or \ref HS_MODE_VECTORED must be
 *      supplied, to select between the generation of a streaming, block or
 *      vectored database. In addition, other flags (beginning with HS_MODE_)
 *      may be supplied to enable specific features. See \ref HS_MODE_FLAG for
 *      more details.
 *
 * @param platform
 *      If not NULL, the platform structure is used to determine the target
 *      platform for the database. If NULL, a database suitable for running
 *      on the current host platform is produced.
 *
 * @param db
 *      On success, a pointer to the generated database will be returned in
 *      this parameter, or NULL on failure. The caller is responsible for
 *      deallocating the buffer using the \ref hs_free_database() function.
 *
 * @param error
 *      If the compile fails, a pointer to a \ref hs_compile_error_t will be
 *      returned, providing details of the error condition. The caller is
 *      responsible for deallocating the buffer using the \ref
 *      hs_free_compile_error() function.
 *
 * @return
 *      \ref HS_SUCCESS is returned on successful compilation; \ref
 *      HS_COMPILER_ERROR on failure, with details provided in the \p error
 *      parameter.
 *
 */
public static native @Cast("hs_error_t") int hs_compile_multi(@Cast("const char*const*") PointerPointer expressions,
                                     @Cast("const unsigned int*") IntPointer flags,
                                     @Cast("const unsigned int*") IntPointer ids,
                                     @Cast("unsigned int") int elements, @Cast("unsigned int") int mode,
                                     @Const hs_platform_info_t platform,
                                     @Cast("hs_database_t**") PointerPointer db,
                                     @Cast("hs_compile_error_t**") PointerPointer error);
public static native @Cast("hs_error_t") int hs_compile_multi(@Cast("const char*const*") @ByPtrPtr BytePointer expressions,
                                     @Cast("const unsigned int*") IntPointer flags,
                                     @Cast("const unsigned int*") IntPointer ids,
                                     @Cast("unsigned int") int elements, @Cast("unsigned int") int mode,
                                     @Const hs_platform_info_t platform,
                                     @ByPtrPtr hs_database_t db,
                                     @ByPtrPtr hs_compile_error_t error);
public static native @Cast("hs_error_t") int hs_compile_multi(@Cast("const char*const*") @ByPtrPtr ByteBuffer expressions,
                                     @Cast("const unsigned int*") IntBuffer flags,
                                     @Cast("const unsigned int*") IntBuffer ids,
                                     @Cast("unsigned int") int elements, @Cast("unsigned int") int mode,
                                     @Const hs_platform_info_t platform,
                                     @ByPtrPtr hs_database_t db,
                                     @ByPtrPtr hs_compile_error_t error);
public static native @Cast("hs_error_t") int hs_compile_multi(@Cast("const char*const*") @ByPtrPtr byte[] expressions,
                                     @Cast("const unsigned int*") int[] flags,
                                     @Cast("const unsigned int*") int[] ids,
                                     @Cast("unsigned int") int elements, @Cast("unsigned int") int mode,
                                     @Const hs_platform_info_t platform,
                                     @ByPtrPtr hs_database_t db,
                                     @ByPtrPtr hs_compile_error_t error);

/**
 * The multiple regular expression compiler with extended parameter support.
 *
 * This function call compiles a group of expressions into a database in the
 * same way as \ref hs_compile_multi(), but allows additional parameters to be
 * specified via an \ref hs_expr_ext_t structure per expression.
 *
 * @param expressions
 *      Array of NULL-terminated expressions to compile. Note that (as for \ref
 *      hs_compile()) these strings must contain only the pattern to be
 *      matched, with no delimiters or flags. For example, the expression
 *      {@code /abc?def/i} should be compiled by providing {@code abc?def} as the first
 *      string in the \p expressions array, and \ref HS_FLAG_CASELESS as the
 *      first value in the \p flags array.
 *
 * @param flags
 *      Array of flags which modify the behaviour of each expression. Multiple
 *      flags may be used by ORing them together. Specifying the NULL pointer
 *      in place of an array will set the flags value for all patterns to zero.
 *      Valid values are:
 *       - HS_FLAG_CASELESS - Matching will be performed case-insensitively.
 *       - HS_FLAG_DOTALL - Matching a {@code .} will not exclude newlines.
 *       - HS_FLAG_MULTILINE - {@code ^} and {@code $} anchors match any newlines in data.
 *       - HS_FLAG_SINGLEMATCH - Only one match will be generated by patterns
 *                               with this match id per stream.
 *       - HS_FLAG_ALLOWEMPTY - Allow expressions which can match against an
 *                              empty string, such as {@code .*}.
 *       - HS_FLAG_UTF8 - Treat this pattern as a sequence of UTF-8 characters.
 *       - HS_FLAG_UCP - Use Unicode properties for character classes.
 *       - HS_FLAG_PREFILTER - Compile pattern in prefiltering mode.
 *       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset
 *                                when a match is found.
 *       - HS_FLAG_COMBINATION - Parse the expression in logical combination
 *                               syntax.
 *       - HS_FLAG_QUIET - Ignore match reporting for this expression. Used for
 *                         the sub-expressions in logical combinations.
 *
 * @param ids
 *      An array of integers specifying the ID number to be associated with the
 *      corresponding pattern in the expressions array. Specifying the NULL
 *      pointer in place of an array will set the ID value for all patterns to
 *      zero.
 *
 * @param ext
 *      An array of pointers to filled \ref hs_expr_ext_t structures that
 *      define extended behaviour for each pattern. NULL may be specified if no
 *      extended behaviour is needed for an individual pattern, or in place of
 *      the whole array if it is not needed for any expressions. Memory used by
 *      these structures must be both allocated and freed by the caller.
 *
 * @param elements
 *      The number of elements in the input arrays.
 *
 * @param mode
 *      Compiler mode flags that affect the database as a whole. One of \ref
 *      HS_MODE_STREAM, \ref HS_MODE_BLOCK or \ref HS_MODE_VECTORED must be
 *      supplied, to select between the generation of a streaming, block or
 *      vectored database. In addition, other flags (beginning with HS_MODE_)
 *      may be supplied to enable specific features. See \ref HS_MODE_FLAG for
 *      more details.
 *
 * @param platform
 *      If not NULL, the platform structure is used to determine the target
 *      platform for the database. If NULL, a database suitable for running
 *      on the current host platform is produced.
 *
 * @param db
 *      On success, a pointer to the generated database will be returned in
 *      this parameter, or NULL on failure. The caller is responsible for
 *      deallocating the buffer using the \ref hs_free_database() function.
 *
 * @param error
 *      If the compile fails, a pointer to a \ref hs_compile_error_t will be
 *      returned, providing details of the error condition. The caller is
 *      responsible for deallocating the buffer using the \ref
 *      hs_free_compile_error() function.
 *
 * @return
 *      \ref HS_SUCCESS is returned on successful compilation; \ref
 *      HS_COMPILER_ERROR on failure, with details provided in the \p error
 *      parameter.
 *
 */
public static native @Cast("hs_error_t") int hs_compile_ext_multi(@Cast("const char*const*") PointerPointer expressions,
                                @Cast("const unsigned int*") IntPointer flags,
                                @Cast("const unsigned int*") IntPointer ids,
                                @Cast("const hs_expr_ext_t*const*") PointerPointer ext,
                                @Cast("unsigned int") int elements, @Cast("unsigned int") int mode,
                                @Const hs_platform_info_t platform,
                                @Cast("hs_database_t**") PointerPointer db, @Cast("hs_compile_error_t**") PointerPointer error);
public static native @Cast("hs_error_t") int hs_compile_ext_multi(@Cast("const char*const*") @ByPtrPtr BytePointer expressions,
                                @Cast("const unsigned int*") IntPointer flags,
                                @Cast("const unsigned int*") IntPointer ids,
                                @Const @ByPtrPtr hs_expr_ext_t ext,
                                @Cast("unsigned int") int elements, @Cast("unsigned int") int mode,
                                @Const hs_platform_info_t platform,
                                @ByPtrPtr hs_database_t db, @ByPtrPtr hs_compile_error_t error);
public static native @Cast("hs_error_t") int hs_compile_ext_multi(@Cast("const char*const*") @ByPtrPtr ByteBuffer expressions,
                                @Cast("const unsigned int*") IntBuffer flags,
                                @Cast("const unsigned int*") IntBuffer ids,
                                @Const @ByPtrPtr hs_expr_ext_t ext,
                                @Cast("unsigned int") int elements, @Cast("unsigned int") int mode,
                                @Const hs_platform_info_t platform,
                                @ByPtrPtr hs_database_t db, @ByPtrPtr hs_compile_error_t error);
public static native @Cast("hs_error_t") int hs_compile_ext_multi(@Cast("const char*const*") @ByPtrPtr byte[] expressions,
                                @Cast("const unsigned int*") int[] flags,
                                @Cast("const unsigned int*") int[] ids,
                                @Const @ByPtrPtr hs_expr_ext_t ext,
                                @Cast("unsigned int") int elements, @Cast("unsigned int") int mode,
                                @Const hs_platform_info_t platform,
                                @ByPtrPtr hs_database_t db, @ByPtrPtr hs_compile_error_t error);

/**
 * The basic pure literal expression compiler.
 *
 * This is the function call with which a pure literal expression (not a
 * common regular expression) is compiled into a Hyperscan database which
 * can be passed to the runtime functions (such as \ref hs_scan(),
 * \ref hs_open_stream(), etc.)
 *
 * @param expression
 *      The NULL-terminated expression to parse. Note that this string must
 *      represent ONLY the pattern to be matched, with no delimiters or flags;
 *      any global flags should be specified with the \p flags argument. For
 *      example, the expression {@code /abc?def/i} should be compiled by providing
 *      {@code abc?def} as the \p expression, and \ref HS_FLAG_CASELESS as the \a
 *      flags. Meanwhile, the string content shall be fully parsed in a literal
 *      sense without any regular grammars. For example, the \p expression
 *      {@code abc?} simply means a char sequence of {@code a}, {@code b}, {@code c}, and {@code ?}. The {@code ?}
 *      here doesn't mean 0 or 1 quantifier under regular semantics.
 *
 * @param flags
 *      Flags which modify the behaviour of the expression. Multiple flags may
 *      be used by ORing them together. Compared to \ref hs_compile(), fewer
 *      valid values are provided:
 *       - HS_FLAG_CASELESS - Matching will be performed case-insensitively.
 *       - HS_FLAG_SINGLEMATCH - Only one match will be generated for the
 *                               expression per stream.
 *       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset
 *                                when a match is found.
 *
 * @param len
 *      The length of the text content of the pure literal expression. As the
 *      text content indicated by \p expression is treated as single character
 *      one by one, the special terminating character {@code \0} should be allowed
 *      to appear in expression, and not treated as a terminator for a string.
 *      Thus, the end of a pure literal expression cannot be indicated by
 *      identifying {@code \0}, but by counting to the expression length.
 *
 * @param mode
 *      Compiler mode flags that affect the database as a whole. One of \ref
 *      HS_MODE_STREAM or \ref HS_MODE_BLOCK or \ref HS_MODE_VECTORED must be
 *      supplied, to select between the generation of a streaming, block or
 *      vectored database. In addition, other flags (beginning with HS_MODE_)
 *      may be supplied to enable specific features. See \ref HS_MODE_FLAG for
 *      more details.
 *
 * @param platform
 *      If not NULL, the platform structure is used to determine the target
 *      platform for the database. If NULL, a database suitable for running
 *      on the current host platform is produced.
 *
 * @param db
 *      On success, a pointer to the generated database will be returned in
 *      this parameter, or NULL on failure. The caller is responsible for
 *      deallocating the buffer using the \ref hs_free_database() function.
 *
 * @param error
 *      If the compile fails, a pointer to a \ref hs_compile_error_t will be
 *      returned, providing details of the error condition. The caller is
 *      responsible for deallocating the buffer using the \ref
 *      hs_free_compile_error() function.
 *
 * @return
 *      \ref HS_SUCCESS is returned on successful compilation; \ref
 *      HS_COMPILER_ERROR on failure, with details provided in the error
 *      parameter.
 */
public static native @Cast("hs_error_t") int hs_compile_lit(@Cast("const char*") BytePointer expression, @Cast("unsigned") int flags,
                                   @Cast("const size_t") long len, @Cast("unsigned") int mode,
                                   @Const hs_platform_info_t platform,
                                   @Cast("hs_database_t**") PointerPointer db,
                                   @Cast("hs_compile_error_t**") PointerPointer error);
public static native @Cast("hs_error_t") int hs_compile_lit(@Cast("const char*") BytePointer expression, @Cast("unsigned") int flags,
                                   @Cast("const size_t") long len, @Cast("unsigned") int mode,
                                   @Const hs_platform_info_t platform,
                                   @ByPtrPtr hs_database_t db,
                                   @ByPtrPtr hs_compile_error_t error);
public static native @Cast("hs_error_t") int hs_compile_lit(String expression, @Cast("unsigned") int flags,
                                   @Cast("const size_t") long len, @Cast("unsigned") int mode,
                                   @Const hs_platform_info_t platform,
                                   @ByPtrPtr hs_database_t db,
                                   @ByPtrPtr hs_compile_error_t error);
/**
 * The multiple pure literal expression compiler.
 *
 * This is the function call with which a set of pure literal expressions is
 * compiled into a database which can be passed to the runtime functions (such
 * as \ref hs_scan(), \ref hs_open_stream(), etc.) Each expression can be
 * labelled with a unique integer which is passed into the match callback to
 * identify the pattern that has matched.
 *
 * @param expressions
 *      The NULL-terminated expression to parse. Note that this string must
 *      represent ONLY the pattern to be matched, with no delimiters or flags;
 *      any global flags should be specified with the \p flags argument. For
 *      example, the expression {@code /abc?def/i} should be compiled by providing
 *      {@code abc?def} as the \p expression, and \ref HS_FLAG_CASELESS as the \a
 *      flags. Meanwhile, the string content shall be fully parsed in a literal
 *      sense without any regular grammars. For example, the \p expression
 *      {@code abc?} simply means a char sequence of {@code a}, {@code b}, {@code c}, and {@code ?}. The {@code ?}
 *      here doesn't mean 0 or 1 quantifier under regular semantics.
 *
 * @param flags
 *      Array of flags which modify the behaviour of each expression. Multiple
 *      flags may be used by ORing them together. Specifying the NULL pointer
 *      in place of an array will set the flags value for all patterns to zero.
 *      Compared to \ref hs_compile_multi(), fewer valid values are provided:
 *       - HS_FLAG_CASELESS - Matching will be performed case-insensitively.
 *       - HS_FLAG_SINGLEMATCH - Only one match will be generated for the
 *                               expression per stream.
 *       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset
 *                                when a match is found.
 *
 * @param ids
 *      An array of integers specifying the ID number to be associated with the
 *      corresponding pattern in the expressions array. Specifying the NULL
 *      pointer in place of an array will set the ID value for all patterns to
 *      zero.
 *
 * @param lens
 *      Array of lengths of the text content of each pure literal expression.
 *      As the text content indicated by \p expression is treated as single
 *      character one by one, the special terminating character {@code \0} should be
 *      allowed to appear in expression, and not treated as a terminator for a
 *      string. Thus, the end of a pure literal expression cannot be indicated
 *      by identifying {@code \0}, but by counting to the expression length.
 *
 * @param elements
 *      The number of elements in the input arrays.
 *
 * @param mode
 *      Compiler mode flags that affect the database as a whole. One of \ref
 *      HS_MODE_STREAM or \ref HS_MODE_BLOCK or \ref HS_MODE_VECTORED must be
 *      supplied, to select between the generation of a streaming, block or
 *      vectored database. In addition, other flags (beginning with HS_MODE_)
 *      may be supplied to enable specific features. See \ref HS_MODE_FLAG for
 *      more details.
 *
 * @param platform
 *      If not NULL, the platform structure is used to determine the target
 *      platform for the database. If NULL, a database suitable for running
 *      on the current host platform is produced.
 *
 * @param db
 *      On success, a pointer to the generated database will be returned in
 *      this parameter, or NULL on failure. The caller is responsible for
 *      deallocating the buffer using the \ref hs_free_database() function.
 *
 * @param error
 *      If the compile fails, a pointer to a \ref hs_compile_error_t will be
 *      returned, providing details of the error condition. The caller is
 *      responsible for deallocating the buffer using the \ref
 *      hs_free_compile_error() function.
 *
 * @return
 *      \ref HS_SUCCESS is returned on successful compilation; \ref
 *      HS_COMPILER_ERROR on failure, with details provided in the error
 *      parameter.
 */
public static native @Cast("hs_error_t") int hs_compile_lit_multi(@Cast("const char*const*") PointerPointer expressions,
                                         @Cast("const unsigned*") IntPointer flags,
                                         @Cast("const unsigned*") IntPointer ids,
                                         @Cast("const size_t*") SizeTPointer lens,
                                         @Cast("unsigned") int elements, @Cast("unsigned") int mode,
                                         @Const hs_platform_info_t platform,
                                         @Cast("hs_database_t**") PointerPointer db,
                                         @Cast("hs_compile_error_t**") PointerPointer error);
public static native @Cast("hs_error_t") int hs_compile_lit_multi(@Cast("const char*const*") @ByPtrPtr BytePointer expressions,
                                         @Cast("const unsigned*") IntPointer flags,
                                         @Cast("const unsigned*") IntPointer ids,
                                         @Cast("const size_t*") SizeTPointer lens,
                                         @Cast("unsigned") int elements, @Cast("unsigned") int mode,
                                         @Const hs_platform_info_t platform,
                                         @ByPtrPtr hs_database_t db,
                                         @ByPtrPtr hs_compile_error_t error);
public static native @Cast("hs_error_t") int hs_compile_lit_multi(@Cast("const char*const*") @ByPtrPtr ByteBuffer expressions,
                                         @Cast("const unsigned*") IntBuffer flags,
                                         @Cast("const unsigned*") IntBuffer ids,
                                         @Cast("const size_t*") SizeTPointer lens,
                                         @Cast("unsigned") int elements, @Cast("unsigned") int mode,
                                         @Const hs_platform_info_t platform,
                                         @ByPtrPtr hs_database_t db,
                                         @ByPtrPtr hs_compile_error_t error);
public static native @Cast("hs_error_t") int hs_compile_lit_multi(@Cast("const char*const*") @ByPtrPtr byte[] expressions,
                                         @Cast("const unsigned*") int[] flags,
                                         @Cast("const unsigned*") int[] ids,
                                         @Cast("const size_t*") SizeTPointer lens,
                                         @Cast("unsigned") int elements, @Cast("unsigned") int mode,
                                         @Const hs_platform_info_t platform,
                                         @ByPtrPtr hs_database_t db,
                                         @ByPtrPtr hs_compile_error_t error);

/**
 * Free an error structure generated by \ref hs_compile(), \ref
 * hs_compile_multi() or \ref hs_compile_ext_multi().
 *
 * @param error
 *      The \ref hs_compile_error_t to be freed. NULL may also be safely
 *      provided.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_free_compile_error(hs_compile_error_t error);

/**
 * Utility function providing information about a regular expression. The
 * information provided in \ref hs_expr_info_t includes the minimum and maximum
 * width of a pattern match.
 *
 * Note: successful analysis of an expression with this function does not imply
 * that compilation of the same expression (via \ref hs_compile(), \ref
 * hs_compile_multi() or \ref hs_compile_ext_multi()) would succeed. This
 * function may return \ref HS_SUCCESS for regular expressions that Hyperscan
 * cannot compile.
 *
 * Note: some per-pattern flags (such as \ref HS_FLAG_ALLOWEMPTY, \ref
 * HS_FLAG_SOM_LEFTMOST) are accepted by this call, but as they do not affect
 * the properties returned in the \ref hs_expr_info_t structure, they will not
 * affect the outcome of this function.
 *
 * @param expression
 *      The NULL-terminated expression to parse. Note that this string must
 *      represent ONLY the pattern to be matched, with no delimiters or flags;
 *      any global flags should be specified with the \p flags argument.  For
 *      example, the expression {@code /abc?def/i} should be compiled by providing
 *      {@code abc?def} as the \p expression, and \ref HS_FLAG_CASELESS as the \a
 *      flags.
 *
 * @param flags
 *      Flags which modify the behaviour of the expression. Multiple flags may
 *      be used by ORing them together. Valid values are:
 *       - HS_FLAG_CASELESS - Matching will be performed case-insensitively.
 *       - HS_FLAG_DOTALL - Matching a {@code .} will not exclude newlines.
 *       - HS_FLAG_MULTILINE - {@code ^} and {@code $} anchors match any newlines in data.
 *       - HS_FLAG_SINGLEMATCH - Only one match will be generated by the
 *                               expression per stream.
 *       - HS_FLAG_ALLOWEMPTY - Allow expressions which can match against an
 *                              empty string, such as {@code .*}.
 *       - HS_FLAG_UTF8 - Treat this pattern as a sequence of UTF-8 characters.
 *       - HS_FLAG_UCP - Use Unicode properties for character classes.
 *       - HS_FLAG_PREFILTER - Compile pattern in prefiltering mode.
 *       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset
 *                                when a match is found.
 *       - HS_FLAG_QUIET - This flag will be ignored.
 *
 * @param info
 *      On success, a pointer to the pattern information will be returned in
 *      this parameter, or NULL on failure. This structure is allocated using
 *      the allocator supplied in \ref hs_set_allocator() (or malloc() if no
 *      allocator was set) and should be freed by the caller.
 *
 * @param error
 *      If the call fails, a pointer to a \ref hs_compile_error_t will be
 *      returned, providing details of the error condition. The caller is
 *      responsible for deallocating the buffer using the \ref
 *      hs_free_compile_error() function.
 *
 * @return
 *      \ref HS_SUCCESS is returned on successful compilation; \ref
 *      HS_COMPILER_ERROR on failure, with details provided in the error
 *      parameter.
 */
public static native @Cast("hs_error_t") int hs_expression_info(@Cast("const char*") BytePointer expression,
                                       @Cast("unsigned int") int flags,
                                       @Cast("hs_expr_info_t**") PointerPointer info,
                                       @Cast("hs_compile_error_t**") PointerPointer error);
public static native @Cast("hs_error_t") int hs_expression_info(@Cast("const char*") BytePointer expression,
                                       @Cast("unsigned int") int flags,
                                       @ByPtrPtr hs_expr_info_t info,
                                       @ByPtrPtr hs_compile_error_t error);
public static native @Cast("hs_error_t") int hs_expression_info(String expression,
                                       @Cast("unsigned int") int flags,
                                       @ByPtrPtr hs_expr_info_t info,
                                       @ByPtrPtr hs_compile_error_t error);

/**
 * Utility function providing information about a regular expression, with
 * extended parameter support. The information provided in \ref hs_expr_info_t
 * includes the minimum and maximum width of a pattern match.
 *
 * Note: successful analysis of an expression with this function does not imply
 * that compilation of the same expression (via \ref hs_compile(), \ref
 * hs_compile_multi() or \ref hs_compile_ext_multi()) would succeed. This
 * function may return \ref HS_SUCCESS for regular expressions that Hyperscan
 * cannot compile.
 *
 * Note: some per-pattern flags (such as \ref HS_FLAG_ALLOWEMPTY, \ref
 * HS_FLAG_SOM_LEFTMOST) are accepted by this call, but as they do not affect
 * the properties returned in the \ref hs_expr_info_t structure, they will not
 * affect the outcome of this function.
 *
 * @param expression
 *      The NULL-terminated expression to parse. Note that this string must
 *      represent ONLY the pattern to be matched, with no delimiters or flags;
 *      any global flags should be specified with the \p flags argument.  For
 *      example, the expression {@code /abc?def/i} should be compiled by providing
 *      {@code abc?def} as the \p expression, and \ref HS_FLAG_CASELESS as the \a
 *      flags.
 *
 * @param flags
 *      Flags which modify the behaviour of the expression. Multiple flags may
 *      be used by ORing them together. Valid values are:
 *       - HS_FLAG_CASELESS - Matching will be performed case-insensitively.
 *       - HS_FLAG_DOTALL - Matching a {@code .} will not exclude newlines.
 *       - HS_FLAG_MULTILINE - {@code ^} and {@code $} anchors match any newlines in data.
 *       - HS_FLAG_SINGLEMATCH - Only one match will be generated by the
 *                               expression per stream.
 *       - HS_FLAG_ALLOWEMPTY - Allow expressions which can match against an
 *                              empty string, such as {@code .*}.
 *       - HS_FLAG_UTF8 - Treat this pattern as a sequence of UTF-8 characters.
 *       - HS_FLAG_UCP - Use Unicode properties for character classes.
 *       - HS_FLAG_PREFILTER - Compile pattern in prefiltering mode.
 *       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset
 *                                when a match is found.
 *       - HS_FLAG_QUIET - This flag will be ignored.
 *
 * @param ext
 *      A pointer to a filled \ref hs_expr_ext_t structure that defines
 *      extended behaviour for this pattern. NULL may be specified if no
 *      extended parameters are needed.
 *
 * @param info
 *      On success, a pointer to the pattern information will be returned in
 *      this parameter, or NULL on failure. This structure is allocated using
 *      the allocator supplied in \ref hs_set_allocator() (or malloc() if no
 *      allocator was set) and should be freed by the caller.
 *
 * @param error
 *      If the call fails, a pointer to a \ref hs_compile_error_t will be
 *      returned, providing details of the error condition. The caller is
 *      responsible for deallocating the buffer using the \ref
 *      hs_free_compile_error() function.
 *
 * @return
 *      \ref HS_SUCCESS is returned on successful compilation; \ref
 *      HS_COMPILER_ERROR on failure, with details provided in the error
 *      parameter.
 */
public static native @Cast("hs_error_t") int hs_expression_ext_info(@Cast("const char*") BytePointer expression,
                                           @Cast("unsigned int") int flags,
                                           @Const hs_expr_ext_t ext,
                                           @Cast("hs_expr_info_t**") PointerPointer info,
                                           @Cast("hs_compile_error_t**") PointerPointer error);
public static native @Cast("hs_error_t") int hs_expression_ext_info(@Cast("const char*") BytePointer expression,
                                           @Cast("unsigned int") int flags,
                                           @Const hs_expr_ext_t ext,
                                           @ByPtrPtr hs_expr_info_t info,
                                           @ByPtrPtr hs_compile_error_t error);
public static native @Cast("hs_error_t") int hs_expression_ext_info(String expression,
                                           @Cast("unsigned int") int flags,
                                           @Const hs_expr_ext_t ext,
                                           @ByPtrPtr hs_expr_info_t info,
                                           @ByPtrPtr hs_compile_error_t error);

/**
 * Populates the platform information based on the current host.
 *
 * @param platform
 *      On success, the pointed to structure is populated based on the current
 *      host.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_populate_platform(hs_platform_info_t platform);

/**
 * \defgroup HS_PATTERN_FLAG Pattern flags
 *
 * \{
 */

/**
 * Compile flag: Set case-insensitive matching.
 *
 * This flag sets the expression to be matched case-insensitively by default.
 * The expression may still use PCRE tokens (notably {@code (?i)} and
 * {@code (?-i)}) to switch case-insensitive matching on and off.
 */
public static final int HS_FLAG_CASELESS =        1;

/**
 * Compile flag: Matching a {@code .} will not exclude newlines.
 *
 * This flag sets any instances of the {@code .} token to match newline characters as
 * well as all other characters. The PCRE specification states that the {@code .}
 * token does not match newline characters by default, so without this flag the
 * {@code .} token will not cross line boundaries.
 */
public static final int HS_FLAG_DOTALL =          2;

/**
 * Compile flag: Set multi-line anchoring.
 *
 * This flag instructs the expression to make the {@code ^} and {@code $} tokens match
 * newline characters as well as the start and end of the stream. If this flag
 * is not specified, the {@code ^} token will only ever match at the start of a
 * stream, and the {@code $} token will only ever match at the end of a stream within
 * the guidelines of the PCRE specification.
 */
public static final int HS_FLAG_MULTILINE =       4;

/**
 * Compile flag: Set single-match only mode.
 *
 * This flag sets the expression's match ID to match at most once. In streaming
 * mode, this means that the expression will return only a single match over
 * the lifetime of the stream, rather than reporting every match as per
 * standard Hyperscan semantics. In block mode or vectored mode, only the first
 * match for each invocation of \ref hs_scan() or \ref hs_scan_vector() will be
 * returned.
 *
 * If multiple expressions in the database share the same match ID, then they
 * either must all specify \ref HS_FLAG_SINGLEMATCH or none of them specify
 * \ref HS_FLAG_SINGLEMATCH. If a group of expressions sharing a match ID
 * specify the flag, then at most one match with the match ID will be generated
 * per stream.
 *
 * Note: The use of this flag in combination with \ref HS_FLAG_SOM_LEFTMOST
 * is not currently supported.
 */
public static final int HS_FLAG_SINGLEMATCH =     8;

/**
 * Compile flag: Allow expressions that can match against empty buffers.
 *
 * This flag instructs the compiler to allow expressions that can match against
 * empty buffers, such as {@code .?}, {@code .*}, {@code (a|)}. Since Hyperscan can return every
 * possible match for an expression, such expressions generally execute very
 * slowly; the default behaviour is to return an error when an attempt to
 * compile one is made. Using this flag will force the compiler to allow such
 * an expression.
 */
public static final int HS_FLAG_ALLOWEMPTY =      16;

/**
 * Compile flag: Enable UTF-8 mode for this expression.
 *
 * This flag instructs Hyperscan to treat the pattern as a sequence of UTF-8
 * characters. The results of scanning invalid UTF-8 sequences with a Hyperscan
 * library that has been compiled with one or more patterns using this flag are
 * undefined.
 */
public static final int HS_FLAG_UTF8 =            32;

/**
 * Compile flag: Enable Unicode property support for this expression.
 *
 * This flag instructs Hyperscan to use Unicode properties, rather than the
 * default ASCII interpretations, for character mnemonics like {@code \w} and {@code \s} as
 * well as the POSIX character classes. It is only meaningful in conjunction
 * with \ref HS_FLAG_UTF8.
 */
public static final int HS_FLAG_UCP =             64;

/**
 * Compile flag: Enable prefiltering mode for this expression.
 *
 * This flag instructs Hyperscan to compile an "approximate" version of this
 * pattern for use in a prefiltering application, even if Hyperscan does not
 * support the pattern in normal operation.
 *
 * The set of matches returned when this flag is used is guaranteed to be a
 * superset of the matches specified by the non-prefiltering expression.
 *
 * If the pattern contains pattern constructs not supported by Hyperscan (such
 * as zero-width assertions, back-references or conditional references) these
 * constructs will be replaced internally with broader constructs that may
 * match more often.
 *
 * Furthermore, in prefiltering mode Hyperscan may simplify a pattern that
 * would otherwise return a "Pattern too large" error at compile time, or for
 * performance reasons (subject to the matching guarantee above).
 *
 * It is generally expected that the application will subsequently confirm
 * prefilter matches with another regular expression matcher that can provide
 * exact matches for the pattern.
 *
 * Note: The use of this flag in combination with \ref HS_FLAG_SOM_LEFTMOST
 * is not currently supported.
 */
public static final int HS_FLAG_PREFILTER =       128;

/**
 * Compile flag: Enable leftmost start of match reporting.
 *
 * This flag instructs Hyperscan to report the leftmost possible start of match
 * offset when a match is reported for this expression. (By default, no start
 * of match is returned.)
 *
 * For all the 3 modes, enabling this behaviour may reduce performance. And
 * particularly, it may increase stream state requirements in streaming mode.
 */
public static final int HS_FLAG_SOM_LEFTMOST =    256;

/**
 * Compile flag: Logical combination.
 *
 * This flag instructs Hyperscan to parse this expression as logical
 * combination syntax.
 * Logical constraints consist of operands, operators and parentheses.
 * The operands are expression indices, and operators can be
 * '!'(NOT), '&'(AND) or '|'(OR).
 * For example:
 *     (101&102&103)|(104&!105)
 *     ((301|302)&303)&(304|305)
 */
public static final int HS_FLAG_COMBINATION =     512;

/**
 * Compile flag: Don't do any match reporting.
 *
 * This flag instructs Hyperscan to ignore match reporting for this expression.
 * It is designed to be used on the sub-expressions in logical combinations.
 */
public static final int HS_FLAG_QUIET =           1024;

/** \} */

/**
 * \defgroup HS_CPU_FEATURES_FLAG CPU feature support flags
 *
 * \{
 */

/**
 * CPU features flag - Intel(R) Advanced Vector Extensions 2 (Intel(R) AVX2)
 *
 * Setting this flag indicates that the target platform supports AVX2
 * instructions.
 */
public static final long HS_CPU_FEATURES_AVX2 =             (1L << 2);

/**
 * CPU features flag - Intel(R) Advanced Vector Extensions 512 (Intel(R) AVX512)
 *
 * Setting this flag indicates that the target platform supports AVX512
 * instructions, specifically AVX-512BW. Using AVX512 implies the use of AVX2.
 */
public static final long HS_CPU_FEATURES_AVX512 =           (1L << 3);

/**
 * CPU features flag - Intel(R) Advanced Vector Extensions 512
 * Vector Byte Manipulation Instructions (Intel(R) AVX512VBMI)
 *
 * Setting this flag indicates that the target platform supports AVX512VBMI
 * instructions. Using AVX512VBMI implies the use of AVX512.
 */
public static final long HS_CPU_FEATURES_AVX512VBMI =       (1L << 4);

/** \} */

/**
 * \defgroup HS_TUNE_FLAG Tuning flags
 *
 * \{
 */

/**
 * Tuning Parameter - Generic
 *
 * This indicates that the compiled database should not be tuned for any
 * particular target platform.
 */
public static final int HS_TUNE_FAMILY_GENERIC = 0;

/**
 * Tuning Parameter - Intel(R) microarchitecture code name Sandy Bridge
 *
 * This indicates that the compiled database should be tuned for the
 * Sandy Bridge microarchitecture.
 */
public static final int HS_TUNE_FAMILY_SNB = 1;

/**
 * Tuning Parameter - Intel(R) microarchitecture code name Ivy Bridge
 *
 * This indicates that the compiled database should be tuned for the
 * Ivy Bridge microarchitecture.
 */
public static final int HS_TUNE_FAMILY_IVB = 2;

/**
 * Tuning Parameter - Intel(R) microarchitecture code name Haswell
 *
 * This indicates that the compiled database should be tuned for the
 * Haswell microarchitecture.
 */
public static final int HS_TUNE_FAMILY_HSW = 3;

/**
 * Tuning Parameter - Intel(R) microarchitecture code name Silvermont
 *
 * This indicates that the compiled database should be tuned for the
 * Silvermont microarchitecture.
 */
public static final int HS_TUNE_FAMILY_SLM = 4;

/**
 * Tuning Parameter - Intel(R) microarchitecture code name Broadwell
 *
 * This indicates that the compiled database should be tuned for the
 * Broadwell microarchitecture.
 */
public static final int HS_TUNE_FAMILY_BDW = 5;

/**
 * Tuning Parameter - Intel(R) microarchitecture code name Skylake
 *
 * This indicates that the compiled database should be tuned for the
 * Skylake microarchitecture.
 */
public static final int HS_TUNE_FAMILY_SKL = 6;

/**
 * Tuning Parameter - Intel(R) microarchitecture code name Skylake Server
 *
 * This indicates that the compiled database should be tuned for the
 * Skylake Server microarchitecture.
 */
public static final int HS_TUNE_FAMILY_SKX = 7;

/**
 * Tuning Parameter - Intel(R) microarchitecture code name Goldmont
 *
 * This indicates that the compiled database should be tuned for the
 * Goldmont microarchitecture.
 */
public static final int HS_TUNE_FAMILY_GLM = 8;

/**
 * Tuning Parameter - Intel(R) microarchitecture code name Icelake
 *
 * This indicates that the compiled database should be tuned for the
 * Icelake microarchitecture.
 */
public static final int HS_TUNE_FAMILY_ICL = 9;

/**
 * Tuning Parameter - Intel(R) microarchitecture code name Icelake Server
 *
 * This indicates that the compiled database should be tuned for the
 * Icelake Server microarchitecture.
 */
public static final int HS_TUNE_FAMILY_ICX = 10;

/** \} */

/**
 * \defgroup HS_MODE_FLAG Compile mode flags
 *
 * The mode flags are used as values for the mode parameter of the various
 * compile calls (\ref hs_compile(), \ref hs_compile_multi() and \ref
 * hs_compile_ext_multi()).
 *
 * A mode value can be built by ORing these flag values together; the only
 * required flag is one of \ref HS_MODE_BLOCK, \ref HS_MODE_STREAM or \ref
 * HS_MODE_VECTORED. Other flags may be added to enable support for additional
 * features.
 *
 *  \{
 */

/**
 * Compiler mode flag: Block scan (non-streaming) database.
 */
public static final int HS_MODE_BLOCK =           1;

/**
 * Compiler mode flag: Alias for \ref HS_MODE_BLOCK.
 */
public static final int HS_MODE_NOSTREAM =        1;

/**
 * Compiler mode flag: Streaming database.
 */
public static final int HS_MODE_STREAM =          2;

/**
 * Compiler mode flag: Vectored scanning database.
 */
public static final int HS_MODE_VECTORED =        4;

/**
 * Compiler mode flag: use full precision to track start of match offsets in
 * stream state.
 *
 * This mode will use the most stream state per pattern, but will always return
 * an accurate start of match offset regardless of how far back in the past it
 * was found.
 *
 * One of the SOM_HORIZON modes must be selected to use the \ref
 * HS_FLAG_SOM_LEFTMOST expression flag.
 */
public static final int HS_MODE_SOM_HORIZON_LARGE =   (1 << 24);

/**
 * Compiler mode flag: use medium precision to track start of match offsets in
 * stream state.
 *
 * This mode will use less stream state than \ref HS_MODE_SOM_HORIZON_LARGE and
 * will limit start of match accuracy to offsets within 2^32 bytes of the
 * end of match offset reported.
 *
 * One of the SOM_HORIZON modes must be selected to use the \ref
 * HS_FLAG_SOM_LEFTMOST expression flag.
 */
public static final int HS_MODE_SOM_HORIZON_MEDIUM =  (1 << 25);

/**
 * Compiler mode flag: use limited precision to track start of match offsets in
 * stream state.
 *
 * This mode will use less stream state than \ref HS_MODE_SOM_HORIZON_LARGE and
 * will limit start of match accuracy to offsets within 2^16 bytes of the
 * end of match offset reported.
 *
 * One of the SOM_HORIZON modes must be selected to use the \ref
 * HS_FLAG_SOM_LEFTMOST expression flag.
 */
public static final int HS_MODE_SOM_HORIZON_SMALL =   (1 << 26);

/** \} */

// #ifdef __cplusplus /* extern "C" */
// #endif

// #endif /* HS_COMPILE_H_ */


// Parsed from hs/hs_runtime.h

/*
 * Copyright (c) 2015-2018, Intel Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of Intel Corporation nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef HS_RUNTIME_H_
// #define HS_RUNTIME_H_

// #include <stdlib.h>

/**
 * \file
 * \brief The Hyperscan runtime API definition.
 *
 * Hyperscan is a high speed regular expression engine.
 *
 * This header contains functions for using compiled Hyperscan databases for
 * scanning data at runtime.
 */

// #include "hs_common.h"

// #ifdef __cplusplus
// Targeting ../hs_stream.java


// Targeting ../hs_stream_t.java


// Targeting ../hs_scratch.java


// Targeting ../hs_scratch_t.java


// Targeting ../match_event_handler.java



/**
 * Open and initialise a stream.
 *
 * @param db
 *      A compiled pattern database.
 *
 * @param flags
 *      Flags modifying the behaviour of the stream. This parameter is provided
 *      for future use and is unused at present.
 *
 * @param stream
 *      On success, a pointer to the generated \ref hs_stream_t will be
 *      returned; NULL on failure.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_open_stream(@Const hs_database_t db, @Cast("unsigned int") int flags,
                                   @Cast("hs_stream_t**") PointerPointer stream);
public static native @Cast("hs_error_t") int hs_open_stream(@Const hs_database_t db, @Cast("unsigned int") int flags,
                                   @ByPtrPtr hs_stream_t stream);

/**
 * Write data to be scanned to the opened stream.
 *
 * This is the function call in which the actual pattern matching takes place
 * as data is written to the stream. Matches will be returned via the \ref
 * match_event_handler callback supplied.
 *
 * @param id
 *      The stream ID (returned by \ref hs_open_stream()) to which the data
 *      will be written.
 *
 * @param data
 *      Pointer to the data to be scanned.
 *
 * @param length
 *      The number of bytes to scan.
 *
 * @param flags
 *      Flags modifying the behaviour of the stream. This parameter is provided
 *      for future use and is unused at present.
 *
 * @param scratch
 *      A per-thread scratch space allocated by \ref hs_alloc_scratch().
 *
 * @param onEvent
 *      Pointer to a match event callback function. If a NULL pointer is given,
 *      no matches will be returned.
 *
 * @param ctxt
 *      The user defined pointer which will be passed to the callback function
 *      when a match occurs.
 *
 * @return
 *      Returns \ref HS_SUCCESS on success; \ref HS_SCAN_TERMINATED if the
 *      match callback indicated that scanning should stop; other values on
 *      error.
 */
public static native @Cast("hs_error_t") int hs_scan_stream(hs_stream_t id, @Cast("const char*") BytePointer data,
                                   @Cast("unsigned int") int length, @Cast("unsigned int") int flags,
                                   hs_scratch_t scratch,
                                   match_event_handler onEvent, Pointer ctxt);
public static native @Cast("hs_error_t") int hs_scan_stream(hs_stream_t id, String data,
                                   @Cast("unsigned int") int length, @Cast("unsigned int") int flags,
                                   hs_scratch_t scratch,
                                   match_event_handler onEvent, Pointer ctxt);

/**
 * Close a stream.
 *
 * This function completes matching on the given stream and frees the memory
 * associated with the stream state. After this call, the stream pointed to by
 * \p id is invalid and can no longer be used. To reuse the stream state after
 * completion, rather than closing it, the \ref hs_reset_stream function can be
 * used.
 *
 * This function must be called for any stream created with \ref
 * hs_open_stream(), even if scanning has been terminated by a non-zero return
 * from the match callback function.
 *
 * Note: This operation may result in matches being returned (via calls to the
 * match event callback) for expressions anchored to the end of the data stream
 * (for example, via the use of the {@code $} meta-character). If these matches are
 * not desired, NULL may be provided as the \ref match_event_handler callback.
 *
 * If NULL is provided as the \ref match_event_handler callback, it is
 * permissible to provide a NULL scratch.
 *
 * @param id
 *      The stream ID returned by \ref hs_open_stream().
 *
 * @param scratch
 *      A per-thread scratch space allocated by \ref hs_alloc_scratch(). This is
 *      allowed to be NULL only if the \p onEvent callback is also NULL.
 *
 * @param onEvent
 *      Pointer to a match event callback function. If a NULL pointer is given,
 *      no matches will be returned.
 *
 * @param ctxt
 *      The user defined pointer which will be passed to the callback function
 *      when a match occurs.
 *
 * @return
 *      Returns \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_close_stream(hs_stream_t id, hs_scratch_t scratch,
                                    match_event_handler onEvent, Pointer ctxt);

/**
 * Reset a stream to an initial state.
 *
 * Conceptually, this is equivalent to performing \ref hs_close_stream() on the
 * given stream, followed by a \ref hs_open_stream(). This new stream replaces
 * the original stream in memory, avoiding the overhead of freeing the old
 * stream and allocating the new one.
 *
 * Note: This operation may result in matches being returned (via calls to the
 * match event callback) for expressions anchored to the end of the original
 * data stream (for example, via the use of the {@code $} meta-character). If these
 * matches are not desired, NULL may be provided as the \ref match_event_handler
 * callback.
 *
 * Note: the stream will also be tied to the same database.
 *
 * @param id
 *      The stream (as created by \ref hs_open_stream()) to be replaced.
 *
 * @param flags
 *      Flags modifying the behaviour of the stream. This parameter is provided
 *      for future use and is unused at present.
 *
 * @param scratch
 *      A per-thread scratch space allocated by \ref hs_alloc_scratch(). This is
 *      allowed to be NULL only if the \p onEvent callback is also NULL.
 *
 * @param onEvent
 *      Pointer to a match event callback function. If a NULL pointer is given,
 *      no matches will be returned.
 *
 * @param context
 *      The user defined pointer which will be passed to the callback function
 *      when a match occurs.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_reset_stream(hs_stream_t id, @Cast("unsigned int") int flags,
                                    hs_scratch_t scratch,
                                    match_event_handler onEvent, Pointer context);

/**
 * Duplicate the given stream. The new stream will have the same state as the
 * original including the current stream offset.
 *
 * @param to_id
 *      On success, a pointer to the new, copied \ref hs_stream_t will be
 *      returned; NULL on failure.
 *
 * @param from_id
 *      The stream (as created by \ref hs_open_stream()) to be copied.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_copy_stream(@Cast("hs_stream_t**") PointerPointer to_id,
                                   @Const hs_stream_t from_id);
public static native @Cast("hs_error_t") int hs_copy_stream(@ByPtrPtr hs_stream_t to_id,
                                   @Const hs_stream_t from_id);

/**
 * Duplicate the given 'from' stream state onto the 'to' stream. The 'to' stream
 * will first be reset (reporting any EOD matches if a non-NULL \p onEvent
 * callback handler is provided).
 *
 * Note: the 'to' stream and the 'from' stream must be open against the same
 * database.
 *
 * @param to_id
 *      On success, a pointer to the new, copied \ref hs_stream_t will be
 *      returned; NULL on failure.
 *
 * @param from_id
 *      The stream (as created by \ref hs_open_stream()) to be copied.
 *
 * @param scratch
 *      A per-thread scratch space allocated by \ref hs_alloc_scratch(). This is
 *      allowed to be NULL only if the \p onEvent callback is also NULL.
 *
 * @param onEvent
 *      Pointer to a match event callback function. If a NULL pointer is given,
 *      no matches will be returned.
 *
 * @param context
 *      The user defined pointer which will be passed to the callback function
 *      when a match occurs.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_reset_and_copy_stream(hs_stream_t to_id,
                                             @Const hs_stream_t from_id,
                                             hs_scratch_t scratch,
                                             match_event_handler onEvent,
                                             Pointer context);

/**
 * Creates a compressed representation of the provided stream in the buffer
 * provided. This compressed representation can be converted back into a stream
 * state by using \ref hs_expand_stream() or \ref hs_reset_and_expand_stream().
 * The size of the compressed representation will be placed into \p used_space.
 *
 * If there is not sufficient space in the buffer to hold the compressed
 * representation, \ref HS_INSUFFICIENT_SPACE will be returned and \p used_space
 * will be populated with the amount of space required.
 *
 * Note: this function does not close the provided stream, you may continue to
 * use the stream or to free it with \ref hs_close_stream().
 *
 * @param stream
 *      The stream (as created by \ref hs_open_stream()) to be compressed.
 *
 * @param buf
 *      Buffer to write the compressed representation into. Note: if the call is
 *      just being used to determine the amount of space required, it is allowed
 *      to pass NULL here and \p buf_space as 0.
 *
 * @param buf_space
 *      The number of bytes in \p buf. If buf_space is too small, the call will
 *      fail with \ref HS_INSUFFICIENT_SPACE.
 *
 * @param used_space
 *      Pointer to where the amount of used space will be written to. The used
 *      buffer space is always less than or equal to \p buf_space. If the call
 *      fails with \ref HS_INSUFFICIENT_SPACE, this pointer will be used to
 *      write out the amount of buffer space required.
 *
 * @return
 *      \ref HS_SUCCESS on success, \ref HS_INSUFFICIENT_SPACE if the provided
 *      buffer is too small.
 */
public static native @Cast("hs_error_t") int hs_compress_stream(@Const hs_stream_t stream, @Cast("char*") BytePointer buf,
                                       @Cast("size_t") long buf_space, @Cast("size_t*") SizeTPointer used_space);
public static native @Cast("hs_error_t") int hs_compress_stream(@Const hs_stream_t stream, @Cast("char*") ByteBuffer buf,
                                       @Cast("size_t") long buf_space, @Cast("size_t*") SizeTPointer used_space);
public static native @Cast("hs_error_t") int hs_compress_stream(@Const hs_stream_t stream, @Cast("char*") byte[] buf,
                                       @Cast("size_t") long buf_space, @Cast("size_t*") SizeTPointer used_space);

/**
 * Decompresses a compressed representation created by \ref hs_compress_stream()
 * into a new stream.
 *
 * Note: \p buf must correspond to a complete compressed representation created
 * by \ref hs_compress_stream() of a stream that was opened against \p db. It is
 * not always possible to detect misuse of this API and behaviour is undefined
 * if these properties are not satisfied.
 *
 * @param db
 *      The compiled pattern database that the compressed stream was opened
 *      against.
 *
 * @param stream
 *      On success, a pointer to the expanded \ref hs_stream_t will be
 *      returned; NULL on failure.
 *
 * @param buf
 *      A compressed representation of a stream. These compressed forms are
 *      created by \ref hs_compress_stream().
 *
 * @param buf_size
 *      The size in bytes of the compressed representation.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_expand_stream(@Const hs_database_t db,
                                     @Cast("hs_stream_t**") PointerPointer stream, @Cast("const char*") BytePointer buf,
                                     @Cast("size_t") long buf_size);
public static native @Cast("hs_error_t") int hs_expand_stream(@Const hs_database_t db,
                                     @ByPtrPtr hs_stream_t stream, @Cast("const char*") BytePointer buf,
                                     @Cast("size_t") long buf_size);
public static native @Cast("hs_error_t") int hs_expand_stream(@Const hs_database_t db,
                                     @ByPtrPtr hs_stream_t stream, String buf,
                                     @Cast("size_t") long buf_size);

/**
 * Decompresses a compressed representation created by \ref hs_compress_stream()
 * on top of the 'to' stream. The 'to' stream will first be reset (reporting
 * any EOD matches if a non-NULL \p onEvent callback handler is provided).
 *
 * Note: the 'to' stream must be opened against the same database as the
 * compressed stream.
 *
 * Note: \p buf must correspond to a complete compressed representation created
 * by \ref hs_compress_stream() of a stream that was opened against \p db. It is
 * not always possible to detect misuse of this API and behaviour is undefined
 * if these properties are not satisfied.
 *
 * @param to_stream
 *      A pointer to a valid stream state. A pointer to the expanded \ref
 *      hs_stream_t will be returned; NULL on failure.
 *
 * @param buf
 *      A compressed representation of a stream. These compressed forms are
 *      created by \ref hs_compress_stream().
 *
 * @param buf_size
 *      The size in bytes of the compressed representation.
 *
 * @param scratch
 *      A per-thread scratch space allocated by \ref hs_alloc_scratch(). This is
 *      allowed to be NULL only if the \p onEvent callback is also NULL.
 *
 * @param onEvent
 *      Pointer to a match event callback function. If a NULL pointer is given,
 *      no matches will be returned.
 *
 * @param context
 *      The user defined pointer which will be passed to the callback function
 *      when a match occurs.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_reset_and_expand_stream(hs_stream_t to_stream,
                                               @Cast("const char*") BytePointer buf, @Cast("size_t") long buf_size,
                                               hs_scratch_t scratch,
                                               match_event_handler onEvent,
                                               Pointer context);
public static native @Cast("hs_error_t") int hs_reset_and_expand_stream(hs_stream_t to_stream,
                                               String buf, @Cast("size_t") long buf_size,
                                               hs_scratch_t scratch,
                                               match_event_handler onEvent,
                                               Pointer context);

/**
 * The block (non-streaming) regular expression scanner.
 *
 * This is the function call in which the actual pattern matching takes place
 * for block-mode pattern databases.
 *
 * @param db
 *      A compiled pattern database.
 *
 * @param data
 *      Pointer to the data to be scanned.
 *
 * @param length
 *      The number of bytes to scan.
 *
 * @param flags
 *      Flags modifying the behaviour of this function. This parameter is
 *      provided for future use and is unused at present.
 *
 * @param scratch
 *      A per-thread scratch space allocated by \ref hs_alloc_scratch() for this
 *      database.
 *
 * @param onEvent
 *      Pointer to a match event callback function. If a NULL pointer is given,
 *      no matches will be returned.
 *
 * @param context
 *      The user defined pointer which will be passed to the callback function.
 *
 * @return
 *      Returns \ref HS_SUCCESS on success; \ref HS_SCAN_TERMINATED if the
 *      match callback indicated that scanning should stop; other values on
 *      error.
 */
public static native @Cast("hs_error_t") int hs_scan(@Const hs_database_t db, @Cast("const char*") BytePointer data,
                            @Cast("unsigned int") int length, @Cast("unsigned int") int flags,
                            hs_scratch_t scratch, match_event_handler onEvent,
                            Pointer context);
public static native @Cast("hs_error_t") int hs_scan(@Const hs_database_t db, String data,
                            @Cast("unsigned int") int length, @Cast("unsigned int") int flags,
                            hs_scratch_t scratch, match_event_handler onEvent,
                            Pointer context);

/**
 * The vectored regular expression scanner.
 *
 * This is the function call in which the actual pattern matching takes place
 * for vectoring-mode pattern databases.
 *
 * @param db
 *      A compiled pattern database.
 *
 * @param data
 *      An array of pointers to the data blocks to be scanned.
 *
 * @param length
 *      An array of lengths (in bytes) of each data block to scan.
 *
 * @param count
 *      Number of data blocks to scan. This should correspond to the size of
 *      of the \p data and \p length arrays.
 *
 * @param flags
 *      Flags modifying the behaviour of this function. This parameter is
 *      provided for future use and is unused at present.
 *
 * @param scratch
 *      A per-thread scratch space allocated by \ref hs_alloc_scratch() for
 *      this database.
 *
 * @param onEvent
 *      Pointer to a match event callback function. If a NULL pointer is given,
 *      no matches will be returned.
 *
 * @param context
 *      The user defined pointer which will be passed to the callback function.
 *
 * @return
 *      Returns \ref HS_SUCCESS on success; \ref HS_SCAN_TERMINATED if the match
 *      callback indicated that scanning should stop; other values on error.
 */
public static native @Cast("hs_error_t") int hs_scan_vector(@Const hs_database_t db,
                                   @Cast("const char*const*") PointerPointer data,
                                   @Cast("const unsigned int*") IntPointer length,
                                   @Cast("unsigned int") int count, @Cast("unsigned int") int flags,
                                   hs_scratch_t scratch,
                                   match_event_handler onEvent, Pointer context);
public static native @Cast("hs_error_t") int hs_scan_vector(@Const hs_database_t db,
                                   @Cast("const char*const*") @ByPtrPtr BytePointer data,
                                   @Cast("const unsigned int*") IntPointer length,
                                   @Cast("unsigned int") int count, @Cast("unsigned int") int flags,
                                   hs_scratch_t scratch,
                                   match_event_handler onEvent, Pointer context);
public static native @Cast("hs_error_t") int hs_scan_vector(@Const hs_database_t db,
                                   @Cast("const char*const*") @ByPtrPtr ByteBuffer data,
                                   @Cast("const unsigned int*") IntBuffer length,
                                   @Cast("unsigned int") int count, @Cast("unsigned int") int flags,
                                   hs_scratch_t scratch,
                                   match_event_handler onEvent, Pointer context);
public static native @Cast("hs_error_t") int hs_scan_vector(@Const hs_database_t db,
                                   @Cast("const char*const*") @ByPtrPtr byte[] data,
                                   @Cast("const unsigned int*") int[] length,
                                   @Cast("unsigned int") int count, @Cast("unsigned int") int flags,
                                   hs_scratch_t scratch,
                                   match_event_handler onEvent, Pointer context);

/**
 * Allocate a "scratch" space for use by Hyperscan.
 *
 * This is required for runtime use, and one scratch space per thread, or
 * concurrent caller, is required. Any allocator callback set by \ref
 * hs_set_scratch_allocator() or \ref hs_set_allocator() will be used by this
 * function.
 *
 * @param db
 *      The database, as produced by \ref hs_compile().
 *
 * @param scratch
 *      On first allocation, a pointer to NULL should be provided so a new
 *      scratch can be allocated. If a scratch block has been previously
 *      allocated, then a pointer to it should be passed back in to see if it
 *      is valid for this database block. If a new scratch block is required,
 *      the original will be freed and the new one returned, otherwise the
 *      previous scratch block will be returned. On success, the scratch block
 *      will be suitable for use with the provided database in addition to any
 *      databases that original scratch space was suitable for.
 *
 * @return
 *      \ref HS_SUCCESS on successful allocation; \ref HS_NOMEM if the
 *      allocation fails.  Other errors may be returned if invalid parameters
 *      are specified.
 */
public static native @Cast("hs_error_t") int hs_alloc_scratch(@Const hs_database_t db,
                                     @Cast("hs_scratch_t**") PointerPointer scratch);
public static native @Cast("hs_error_t") int hs_alloc_scratch(@Const hs_database_t db,
                                     @ByPtrPtr hs_scratch_t scratch);

/**
 * Allocate a scratch space that is a clone of an existing scratch space.
 *
 * This is useful when multiple concurrent threads will be using the same set
 * of compiled databases, and another scratch space is required. Any allocator
 * callback set by \ref hs_set_scratch_allocator() or \ref hs_set_allocator()
 * will be used by this function.
 *
 * @param src
 *      The existing \ref hs_scratch_t to be cloned.
 *
 * @param dest
 *      A pointer to the new scratch space will be returned here.
 *
 * @return
 *      \ref HS_SUCCESS on success; \ref HS_NOMEM if the allocation fails.
 *      Other errors may be returned if invalid parameters are specified.
 */
public static native @Cast("hs_error_t") int hs_clone_scratch(@Const hs_scratch_t src,
                                     @Cast("hs_scratch_t**") PointerPointer dest);
public static native @Cast("hs_error_t") int hs_clone_scratch(@Const hs_scratch_t src,
                                     @ByPtrPtr hs_scratch_t dest);

/**
 * Provides the size of the given scratch space.
 *
 * @param scratch
 *      A per-thread scratch space allocated by \ref hs_alloc_scratch() or \ref
 *      hs_clone_scratch().
 *
 * @param scratch_size
 *      On success, the size of the scratch space in bytes is placed in this
 *      parameter.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_scratch_size(@Const hs_scratch_t scratch,
                                    @Cast("size_t*") SizeTPointer scratch_size);

/**
 * Free a scratch block previously allocated by \ref hs_alloc_scratch() or \ref
 * hs_clone_scratch().
 *
 * The free callback set by \ref hs_set_scratch_allocator() or \ref
 * hs_set_allocator() will be used by this function.
 *
 * @param scratch
 *      The scratch block to be freed. NULL may also be safely provided.
 *
 * @return
 *      \ref HS_SUCCESS on success, other values on failure.
 */
public static native @Cast("hs_error_t") int hs_free_scratch(hs_scratch_t scratch);

/**
 * Callback 'from' return value, indicating that the start of this match was
 * too early to be tracked with the requested SOM_HORIZON precision.
 */
public static final long HS_OFFSET_PAST_HORIZON =    (~0L);

// #ifdef __cplusplus /* extern "C" */
// #endif

// #endif /* HS_RUNTIME_H_ */


// Parsed from hs/hs.h

/*
 * Copyright (c) 2015-2020, Intel Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of Intel Corporation nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef HS_H_
// #define HS_H_

/**
 * \file
 * \brief The complete Hyperscan API definition.
 *
 * Hyperscan is a high speed regular expression engine.
 *
 * This header includes both the Hyperscan compiler and runtime components. See
 * the individual component headers for documentation.
 */

/* The current Hyperscan version information. */

public static final int HS_MAJOR =      5;
public static final int HS_MINOR =      4;
public static final int HS_PATCH =      2;

// #include "hs_compile.h"
// #include "hs_runtime.h"

// #endif /* HS_H_ */


}
