// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.hyperscan;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.hyperscan.global.hyperscan.*;


/**
 * The type of the callback function that will be used by Hyperscan to allocate
 * more memory at runtime as required, for example in \ref hs_open_stream() to
 * allocate stream state.
 *
 * If Hyperscan is to be used in a multi-threaded, or similarly concurrent
 * environment, the allocation function will need to be re-entrant, or
 * similarly safe for concurrent use.
 *
 * @param size
 *      The number of bytes to allocate.
 * @return
 *      A pointer to the region of memory allocated, or NULL on error.
 */
@Properties(inherit = org.bytedeco.hyperscan.presets.hyperscan.class)
public class hs_alloc_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    hs_alloc_t(Pointer p) { super(p); }
    protected hs_alloc_t() { allocate(); }
    private native void allocate();
    public native Pointer call(@Cast("size_t") long size);
}
