// Targeted by JavaCPP version 1.3: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

public class hdf5 extends org.bytedeco.javacpp.presets.hdf5 {
    static { Loader.load(); }

// Parsed from H5pubconf.h

/* src/H5config.h.  Generated from H5config.h.in by configure.  */
/* src/H5config.h.in.  Generated from configure.ac by autoheader.  */

/* Define if building universal (internal helper macro) */
/* #undef H5_AC_APPLE_UNIVERSAL_BUILD */

/* Define if C++ compiler recognizes offsetof */
public static final int H5_CXX_HAVE_OFFSETOF = 1;

/* Define if this is a debug build. */
/* #undef H5_DEBUG_BUILD */

/* Define the default plugins path to compile */
public static final String H5_DEFAULT_PLUGINDIR = "/usr/local/hdf5/lib/plugin";

/* Define if dev_t is a scalar */
public static final int H5_DEV_T_IS_SCALAR = 1;

/* Define to dummy `main' function (if any) required to link to the Fortran
   libraries. */
/* #undef H5_FC_DUMMY_MAIN */

/* Define if F77 and FC dummy `main' functions are identical. */
/* #undef H5_FC_DUMMY_MAIN_EQ_F77 */

/* Define to a macro mangling the given C identifier (in lower and upper
   case), which must not contain underscores, for linking with Fortran. */
/* #undef H5_FC_FUNC */

/* As FC_FUNC, but for C identifiers containing underscores. */
/* #undef H5_FC_FUNC_ */

/* Define if Fortran C_LONG_DOUBLE is different from C_DOUBLE */
/* #undef H5_FORTRAN_C_LONG_DOUBLE_IS_UNIQUE */

/* Define if we have Fortran C_LONG_DOUBLE */
/* #undef H5_FORTRAN_HAVE_C_LONG_DOUBLE */

/* Define if we have Fortran intrinsic C_SIZEOF */
/* #undef H5_FORTRAN_HAVE_C_SIZEOF */

/* Define if we have Fortran intrinsic SIZEOF */
/* #undef H5_FORTRAN_HAVE_SIZEOF */

/* Define if we have Fortran intrinsic STORAGE_SIZE */
/* #undef H5_FORTRAN_HAVE_STORAGE_SIZE */

/* Determine the size of C long double */
/* #undef H5_FORTRAN_SIZEOF_LONG_DOUBLE */

/* Define Fortran compiler ID */
/* #undef H5_Fortran_COMPILER_ID */

/* Define valid Fortran INTEGER KINDs */
/* #undef H5_H5CONFIG_F_IKIND */

/* Define number of valid Fortran INTEGER KINDs */
/* #undef H5_H5CONFIG_F_NUM_IKIND */

/* Define number of valid Fortran REAL KINDs */
/* #undef H5_H5CONFIG_F_NUM_RKIND */

/* Define valid Fortran REAL KINDs */
/* #undef H5_H5CONFIG_F_RKIND */

/* Define valid Fortran REAL KINDs Sizeof */
/* #undef H5_H5CONFIG_F_RKIND_SIZEOF */

/* Define to 1 if you have the `alarm' function. */
public static final int H5_HAVE_ALARM = 1;

/* Define to 1 if you have the `asprintf' function. */
public static final int H5_HAVE_ASPRINTF = 1;

/* Define if the __attribute__(()) extension is present */
public static final int H5_HAVE_ATTRIBUTE = 1;

/* Define if the compiler understands C99 designated initialization of structs
   and unions */
public static final int H5_HAVE_C99_DESIGNATED_INITIALIZER = 1;

/* Define if the compiler understands the __func__ keyword */
public static final int H5_HAVE_C99_FUNC = 1;

/* Define to 1 if you have the `clock_gettime' function. */
public static final int H5_HAVE_CLOCK_GETTIME = 1;

/* Define if the function stack tracing code is to be compiled in */
/* #undef H5_HAVE_CODESTACK */

/* Define if Darwin or Mac OS X */
/* #undef H5_HAVE_DARWIN */

/* Define to 1 if you have the `difftime' function. */
public static final int H5_HAVE_DIFFTIME = 1;

/* Define if the direct I/O virtual file driver (VFD) should be compiled */
/* #undef H5_HAVE_DIRECT */

/* Define to 1 if you have the <dirent.h> header file. */
public static final int H5_HAVE_DIRENT_H = 1;

/* Define to 1 if you have the <dlfcn.h> header file. */
public static final int H5_HAVE_DLFCN_H = 1;

/* Define to 1 if you have the <dmalloc.h> header file. */
/* #undef H5_HAVE_DMALLOC_H */

/* Define if library information should be embedded in the executables */
public static final int H5_HAVE_EMBEDDED_LIBINFO = 1;

/* Define to 1 if you have the `fcntl' function. */
public static final int H5_HAVE_FCNTL = 1;

/* Define to 1 if you have the <features.h> header file. */
public static final int H5_HAVE_FEATURES_H = 1;

/* Define if support for deflate (zlib) filter is enabled */
public static final int H5_HAVE_FILTER_DEFLATE = 1;

/* Define if support for szip filter is enabled */
/* #undef H5_HAVE_FILTER_SZIP */

/* Determine if __float128 is available */
/* #undef H5_HAVE_FLOAT128 */

/* Define to 1 if you have the `flock' function. */
public static final int H5_HAVE_FLOCK = 1;

/* Define to 1 if you have the `fork' function. */
public static final int H5_HAVE_FORK = 1;

/* Define to 1 if you have the `frexpf' function. */
public static final int H5_HAVE_FREXPF = 1;

/* Define to 1 if you have the `frexpl' function. */
public static final int H5_HAVE_FREXPL = 1;

/* Define if the compiler understands the __FUNCTION__ keyword */
public static final int H5_HAVE_FUNCTION = 1;

/* Determine if INTEGER*16 is available */
/* #undef H5_HAVE_Fortran_INTEGER_SIZEOF_16 */

/* Define to 1 if you have the `GetConsoleScreenBufferInfo' function. */
/* #undef H5_HAVE_GETCONSOLESCREENBUFFERINFO */

/* Define to 1 if you have the `gethostname' function. */
public static final int H5_HAVE_GETHOSTNAME = 1;

/* Define to 1 if you have the `getpwuid' function. */
public static final int H5_HAVE_GETPWUID = 1;

/* Define to 1 if you have the `getrusage' function. */
public static final int H5_HAVE_GETRUSAGE = 1;

/* Define to 1 if you have the `gettextinfo' function. */
/* #undef H5_HAVE_GETTEXTINFO */

/* Define to 1 if you have the `gettimeofday' function. */
public static final int H5_HAVE_GETTIMEOFDAY = 1;

/* Define if the compiler understands inline */
public static final int H5_HAVE_INLINE = 1;

/* Define if parallel library will contain instrumentation to detect correct
   optimization operation */
/* #undef H5_HAVE_INSTRUMENTED_LIBRARY */

/* Define to 1 if you have the <inttypes.h> header file. */
public static final int H5_HAVE_INTTYPES_H = 1;

/* Define to 1 if you have the `ioctl' function. */
public static final int H5_HAVE_IOCTL = 1;

/* Define to 1 if you have the <io.h> header file. */
/* #undef H5_HAVE_IO_H */

/* Define to 1 if you have the `dl' library (-ldl). */
public static final int H5_HAVE_LIBDL = 1;

/* Define to 1 if you have the `dmalloc' library (-ldmalloc). */
/* #undef H5_HAVE_LIBDMALLOC */

/* Define to 1 if you have the `m' library (-lm). */
public static final int H5_HAVE_LIBM = 1;

/* Define to 1 if you have the `mpe' library (-lmpe). */
/* #undef H5_HAVE_LIBMPE */

/* Define to 1 if you have the `pthread' library (-lpthread). */
/* #undef H5_HAVE_LIBPTHREAD */

/* Define to 1 if you have the `sz' library (-lsz). */
/* #undef H5_HAVE_LIBSZ */

/* Define to 1 if you have the `ws2_32' library (-lws2_32). */
/* #undef H5_HAVE_LIBWS2_32 */

/* Define to 1 if you have the `z' library (-lz). */
public static final int H5_HAVE_LIBZ = 1;

/* Define to 1 if you have the `longjmp' function. */
public static final int H5_HAVE_LONGJMP = 1;

/* Define to 1 if you have the `lstat' function. */
public static final int H5_HAVE_LSTAT = 1;

/* Define to 1 if you have the <mach/mach_time.h> header file. */
/* #undef H5_HAVE_MACH_MACH_TIME_H */

/* Define to 1 if you have the <memory.h> header file. */
public static final int H5_HAVE_MEMORY_H = 1;

/* Define if we have MPE support */
/* #undef H5_HAVE_MPE */

/* Define to 1 if you have the <mpe.h> header file. */
/* #undef H5_HAVE_MPE_H */

/* Define if MPI_Comm_c2f and MPI_Comm_f2c exist */
/* #undef H5_HAVE_MPI_MULTI_LANG_Comm */

/* Define if MPI_Info_c2f and MPI_Info_f2c exist */
/* #undef H5_HAVE_MPI_MULTI_LANG_Info */

/* Define if we have parallel support */
/* #undef H5_HAVE_PARALLEL */

/* Define to 1 if you have the <pthread.h> header file. */
/* #undef H5_HAVE_PTHREAD_H */

/* Define to 1 if you have the <quadmath.h> header file. */
/* #undef H5_HAVE_QUADMATH_H */

/* Define to 1 if you have the `random' function. */
public static final int H5_HAVE_RANDOM = 1;

/* Define to 1 if you have the `rand_r' function. */
public static final int H5_HAVE_RAND_R = 1;

/* Define to 1 if you have the `setjmp' function. */
public static final int H5_HAVE_SETJMP = 1;

/* Define to 1 if you have the <setjmp.h> header file. */
public static final int H5_HAVE_SETJMP_H = 1;

/* Define to 1 if you have the `setsysinfo' function. */
/* #undef H5_HAVE_SETSYSINFO */

/* Define to 1 if you have the `siglongjmp' function. */
public static final int H5_HAVE_SIGLONGJMP = 1;

/* Define to 1 if you have the `signal' function. */
public static final int H5_HAVE_SIGNAL = 1;

/* Define to 1 if you have the `sigprocmask' function. */
public static final int H5_HAVE_SIGPROCMASK = 1;

/* Define to 1 if you have the `sigsetjmp' function. */
/* #undef H5_HAVE_SIGSETJMP */

/* Define to 1 if you have the `snprintf' function. */
public static final int H5_HAVE_SNPRINTF = 1;

/* Define to 1 if you have the `srandom' function. */
public static final int H5_HAVE_SRANDOM = 1;

/* Define if struct stat has the st_blocks field */
/* #undef H5_HAVE_STAT_ST_BLOCKS */

/* Define to 1 if you have the <stdbool.h> header file. */
public static native @MemberGetter int H5_HAVE_STDBOOL_H();
public static final int H5_HAVE_STDBOOL_H = H5_HAVE_STDBOOL_H();

/* Define to 1 if you have the <stddef.h> header file. */
public static final int H5_HAVE_STDDEF_H = 1;

/* Define to 1 if you have the <stdint.h> header file. */
public static final int H5_HAVE_STDINT_H = 1;

/* Define to 1 if you have the <stdlib.h> header file. */
public static final int H5_HAVE_STDLIB_H = 1;

/* Define to 1 if you have the `strdup' function. */
public static final int H5_HAVE_STRDUP = 1;

/* Define to 1 if you have the <strings.h> header file. */
public static final int H5_HAVE_STRINGS_H = 1;

/* Define to 1 if you have the <string.h> header file. */
public static final int H5_HAVE_STRING_H = 1;

/* Define if struct text_info is defined */
/* #undef H5_HAVE_STRUCT_TEXT_INFO */

/* Define if struct videoconfig is defined */
/* #undef H5_HAVE_STRUCT_VIDEOCONFIG */

/* Define to 1 if you have the `symlink' function. */
public static final int H5_HAVE_SYMLINK = 1;

/* Define to 1 if you have the `system' function. */
public static final int H5_HAVE_SYSTEM = 1;

/* Define to 1 if you have the <sys/file.h> header file. */
public static final int H5_HAVE_SYS_FILE_H = 1;

/* Define to 1 if you have the <sys/ioctl.h> header file. */
public static final int H5_HAVE_SYS_IOCTL_H = 1;

/* Define to 1 if you have the <sys/resource.h> header file. */
public static final int H5_HAVE_SYS_RESOURCE_H = 1;

/* Define to 1 if you have the <sys/socket.h> header file. */
public static final int H5_HAVE_SYS_SOCKET_H = 1;

/* Define to 1 if you have the <sys/stat.h> header file. */
public static final int H5_HAVE_SYS_STAT_H = 1;

/* Define to 1 if you have the <sys/timeb.h> header file. */
public static final int H5_HAVE_SYS_TIMEB_H = 1;

/* Define to 1 if you have the <sys/time.h> header file. */
public static final int H5_HAVE_SYS_TIME_H = 1;

/* Define to 1 if you have the <sys/types.h> header file. */
public static final int H5_HAVE_SYS_TYPES_H = 1;

/* Define to 1 if you have the <szlib.h> header file. */
/* #undef H5_HAVE_SZLIB_H */

/* Define if we have thread safe support */
/* #undef H5_HAVE_THREADSAFE */

/* Define if timezone is a global variable */
public static final int H5_HAVE_TIMEZONE = 1;

/* Define if the ioctl TIOCGETD is defined */
public static final int H5_HAVE_TIOCGETD = 1;

/* Define if the ioctl TIOGWINSZ is defined */
public static final int H5_HAVE_TIOCGWINSZ = 1;

/* Define to 1 if you have the `tmpfile' function. */
public static final int H5_HAVE_TMPFILE = 1;

/* Define if tm_gmtoff is a member of struct tm */
public static final int H5_HAVE_TM_GMTOFF = 1;

/* Define to 1 if you have the <unistd.h> header file. */
public static final int H5_HAVE_UNISTD_H = 1;

/* Define to 1 if you have the `vasprintf' function. */
public static final int H5_HAVE_VASPRINTF = 1;

/* Define to 1 if you have the `vsnprintf' function. */
public static final int H5_HAVE_VSNPRINTF = 1;

/* Define to 1 if you have the `waitpid' function. */
public static final int H5_HAVE_WAITPID = 1;

/* Define if your system has window style path name. */
/* #undef H5_HAVE_WINDOW_PATH */

/* Define to 1 if you have the <winsock2.h> header file. */
/* #undef H5_HAVE_WINSOCK2_H */

/* Define to 1 if you have the <zlib.h> header file. */
public static final int H5_HAVE_ZLIB_H = 1;

/* Define to 1 if you have the `_getvideoconfig' function. */
/* #undef H5_HAVE__GETVIDEOCONFIG */

/* Define to 1 if you have the `_scrsize' function. */
/* #undef H5_HAVE__SCRSIZE */

/* Define if the compiler understands __inline */
public static final int H5_HAVE___INLINE = 1;

/* Define if the compiler understands __inline__ */
public static final int H5_HAVE___INLINE__ = 1;

/* Define if the high-level library headers should be included in hdf5.h */
public static final int H5_INCLUDE_HL = 1;

/* Define if your system can convert long double to (unsigned) long long
   values correctly. */
public static final int H5_LDOUBLE_TO_LLONG_ACCURATE = 1;

/* Define if your system converts long double to (unsigned) long values with
   special algorithm. */
/* #undef H5_LDOUBLE_TO_LONG_SPECIAL */

/* Define if your system can convert (unsigned) long long to long double
   values correctly. */
public static final int H5_LLONG_TO_LDOUBLE_CORRECT = 1;

/* Define if your system can convert (unsigned) long to long double values
   with special algorithm. */
/* #undef H5_LONG_TO_LDOUBLE_SPECIAL */

/* Define to the sub-directory where libtool stores uninstalled libraries. */
public static final String H5_LT_OBJDIR = ".libs/";

/* Define to enable internal memory allocation sanity checking. */
/* #undef H5_MEMORY_ALLOC_SANITY_CHECK */

/* Define if the metadata trace file code is to be compiled in */
/* #undef H5_METADATA_TRACE_FILE */

/* Define if we can violate pointer alignment restrictions */
public static final int H5_NO_ALIGNMENT_RESTRICTIONS = 1;

/* Define if deprecated public API symbols are disabled */
/* #undef H5_NO_DEPRECATED_SYMBOLS */

/* Name of package */
public static final String H5_PACKAGE = "hdf5";

/* Define to the address where bug reports for this package should be sent. */
public static final String H5_PACKAGE_BUGREPORT = "help@hdfgroup.org";

/* Define to the full name of this package. */
public static final String H5_PACKAGE_NAME = "HDF5";

/* Define to the full name and version of this package. */
public static final String H5_PACKAGE_STRING = "HDF5 1.10.0-patch1";

/* Define to the one symbol short name of this package. */
public static final String H5_PACKAGE_TARNAME = "hdf5";

/* Define to the home page for this package. */
public static final String H5_PACKAGE_URL = "";

/* Define to the version of this package. */
public static final String H5_PACKAGE_VERSION = "1.10.0-patch1";

/* Determine the maximum decimal precision in C */
public static final int H5_PAC_C_MAX_REAL_PRECISION = 18;

/* Define Fortran Maximum Real Decimal Precision */
/* #undef H5_PAC_FC_MAX_REAL_PRECISION */

/* Width for printf() for type `long long' or `__int64', use `ll' */
public static final String H5_PRINTF_LL_WIDTH = "l";

/* The size of `bool', as computed by sizeof. */
public static final int H5_SIZEOF_BOOL = 1;

/* The size of `char', as computed by sizeof. */
public static final int H5_SIZEOF_CHAR = 1;

/* The size of `double', as computed by sizeof. */
public static final int H5_SIZEOF_DOUBLE = 8;

/* The size of `float', as computed by sizeof. */
public static final int H5_SIZEOF_FLOAT = 4;

/* The size of `int', as computed by sizeof. */
public static final int H5_SIZEOF_INT = 4;

/* The size of `int16_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT16_T = 2;

/* The size of `int32_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT32_T = 4;

/* The size of `int64_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT64_T = 8;

/* The size of `int8_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT8_T = 1;

/* The size of `int_fast16_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_FAST16_T = 8;

/* The size of `int_fast32_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_FAST32_T = 8;

/* The size of `int_fast64_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_FAST64_T = 8;

/* The size of `int_fast8_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_FAST8_T = 1;

/* The size of `int_least16_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_LEAST16_T = 2;

/* The size of `int_least32_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_LEAST32_T = 4;

/* The size of `int_least64_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_LEAST64_T = 8;

/* The size of `int_least8_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_LEAST8_T = 1;

/* The size of `long', as computed by sizeof. */
public static final int H5_SIZEOF_LONG = 8;

/* The size of `long double', as computed by sizeof. */
public static final int H5_SIZEOF_LONG_DOUBLE = 16;

/* The size of `long long', as computed by sizeof. */
public static final int H5_SIZEOF_LONG_LONG = 8;

/* The size of `off_t', as computed by sizeof. */
public static final int H5_SIZEOF_OFF_T = 8;

/* The size of `ptrdiff_t', as computed by sizeof. */
public static final int H5_SIZEOF_PTRDIFF_T = 8;

/* The size of `short', as computed by sizeof. */
public static final int H5_SIZEOF_SHORT = 2;

/* The size of `size_t', as computed by sizeof. */
public static final int H5_SIZEOF_SIZE_T = 8;

/* The size of `ssize_t', as computed by sizeof. */
public static final int H5_SIZEOF_SSIZE_T = 8;

/* The size of `uint16_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT16_T = 2;

/* The size of `uint32_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT32_T = 4;

/* The size of `uint64_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT64_T = 8;

/* The size of `uint8_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT8_T = 1;

/* The size of `uint_fast16_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_FAST16_T = 8;

/* The size of `uint_fast32_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_FAST32_T = 8;

/* The size of `uint_fast64_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_FAST64_T = 8;

/* The size of `uint_fast8_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_FAST8_T = 1;

/* The size of `uint_least16_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_LEAST16_T = 2;

/* The size of `uint_least32_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_LEAST32_T = 4;

/* The size of `uint_least64_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_LEAST64_T = 8;

/* The size of `uint_least8_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_LEAST8_T = 1;

/* The size of `unsigned', as computed by sizeof. */
public static final int H5_SIZEOF_UNSIGNED = 4;

/* The size of `_Quad', as computed by sizeof. */
public static final int H5_SIZEOF__QUAD = 0;

/* The size of `__float128', as computed by sizeof. */
public static final int H5_SIZEOF___FLOAT128 = 16;

/* The size of `__int64', as computed by sizeof. */
public static final int H5_SIZEOF___INT64 = 0;

/* Define to 1 if you have the ANSI C header files. */
public static final int H5_STDC_HEADERS = 1;

/* Define if strict file format checks are enabled */
/* #undef H5_STRICT_FORMAT_CHECKS */

/* Define if your system supports pthread_attr_setscope(&attribute,
   PTHREAD_SCOPE_SYSTEM) call. */
/* #undef H5_SYSTEM_SCOPE_THREADS */

/* Define to 1 if you can safely include both <sys/time.h> and <time.h>. */
public static final int H5_TIME_WITH_SYS_TIME = 1;

/* Define using v1.6 public API symbols by default */
/* #undef H5_USE_16_API_DEFAULT */

/* Define using v1.8 public API symbols by default */
/* #undef H5_USE_18_API_DEFAULT */

/* Define if a memory checking tool will be used on the library, to cause
   library to be very picky about memory operations and also disable the
   internal free list manager code. */
/* #undef H5_USING_MEMCHECKER */

/* Version number of package */
public static final String H5_VERSION = "1.10.0-patch1";

/* Data accuracy is prefered to speed during data conversions */
public static final int H5_WANT_DATA_ACCURACY = 1;

/* Check exception handling functions during data conversions */
public static final int H5_WANT_DCONV_EXCEPTION = 1;

/* Define WORDS_BIGENDIAN to 1 if your processor stores words with the most
   significant byte first (like Motorola and SPARC, unlike Intel). */
// #if defined AC_APPLE_UNIVERSAL_BUILD
// # if defined __BIG_ENDIAN__
public static final int WORDS_BIGENDIAN = 1;
// # endif
// #else
// # ifndef WORDS_BIGENDIAN
/* #  undef WORDS_BIGENDIAN */
// # endif
// #endif

/* Number of bits in a file offset, on hosts where this is settable. */
/* #undef H5__FILE_OFFSET_BITS */

/* Define for large files, on AIX-style hosts. */
/* #undef H5__LARGE_FILES */

/* Define to empty if `const' does not conform to ANSI C. */
/* #undef H5_const */

/* Define to `long int' if <sys/types.h> does not define. */
/* #undef H5_off_t */

/* Define to `long' if <sys/types.h> does not define. */
/* #undef H5_ptrdiff_t */

/* Define to `unsigned long' if <sys/types.h> does not define. */
/* #undef H5_size_t */

/* Define to `long' if <sys/types.h> does not define. */
/* #undef H5_ssize_t */


// Parsed from H5public.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the HDF5 module.
 */
// #ifndef _H5public_H
// #define _H5public_H

/* Include files for public use... */
/*
 * Since H5pubconf.h is a generated header file, it is messy to try
 * to put a #ifndef _H5pubconf_H ... #endif guard in it.
 * HDF5 has set an internal rule that it is being included here.
 * Source files should NOT include H5pubconf.h directly but include
 * it via H5public.h.  The #ifndef _H5public_H guard above would
 * prevent repeated include.
 */
// #include "H5pubconf.h"		/*from configure                             */

/* API Version macro wrapper definitions */
// #include "H5version.h"

// #ifdef H5_HAVE_FEATURES_H
// #include <features.h>           /*for setting POSIX, BSD, etc. compatibility */
// #endif
// #ifdef H5_HAVE_SYS_TYPES_H
// #include <sys/types.h>
// #endif
// #ifdef H5_STDC_HEADERS
// #   include <limits.h>		/*for H5T_NATIVE_CHAR defn in H5Tpublic.h    */
// #endif
// #ifndef __cplusplus
// # ifdef H5_HAVE_STDINT_H
// #   include <stdint.h>		/*for C9x types				     */
// # endif
// #else
// # ifdef H5_HAVE_STDINT_H_CXX
// #   include <stdint.h>		/*for C9x types	when include from C++	     */
// # endif
// #endif
// #ifdef H5_HAVE_INTTYPES_H
// #   include <inttypes.h>        /* For uint64_t on some platforms            */
// #endif
// #ifdef H5_HAVE_STDDEF_H
// #   include <stddef.h>
// #endif
// #ifdef H5_HAVE_PARALLEL
// #endif


/* Include the Windows API adapter header early */
// #include "H5api_adpt.h"

// #ifdef __cplusplus
// #endif

/* Macros for enabling/disabling particular GCC warnings */
/* (see the following web-sites for more info:
 *      http://www.dbp-consulting.com/tutorials/SuppressingGCCWarnings.html
 *      http://gcc.gnu.org/onlinedocs/gcc/Diagnostic-Pragmas.html#Diagnostic-Pragmas
 */
/* These pragmas are only implemented usefully in gcc 4.6+ */
// #if ((__GNUC__ * 100) + __GNUC_MINOR__) >= 406
// #else
//     #define H5_GCC_DIAG_OFF(x)
//     #define H5_GCC_DIAG_ON(x)
// #endif

/* Version numbers */
public static final int H5_VERS_MAJOR =	1;	/* For major interface/format changes  	     */
public static final int H5_VERS_MINOR =	10;	/* For minor interface/format changes  	     */
public static final int H5_VERS_RELEASE =	0;	/* For tweaks, bug-fixes, or development     */
public static final String H5_VERS_SUBRELEASE = "patch1";	/* For pre-releases like snap0       */
				/* Empty string for real releases.           */
public static final String H5_VERS_INFO =    "HDF5 library version: 1.10.0-patch1";      /* Full version string */

// #define H5check()	H5check_version(H5_VERS_MAJOR,H5_VERS_MINOR,
// 				        H5_VERS_RELEASE)

/* macros for comparing the version */
// #define H5_VERSION_GE(Maj,Min,Rel)
//        (((H5_VERS_MAJOR==Maj) && (H5_VERS_MINOR==Min) && (H5_VERS_RELEASE>=Rel)) ||
//         ((H5_VERS_MAJOR==Maj) && (H5_VERS_MINOR>Min)) ||
//         (H5_VERS_MAJOR>Maj))

// #define H5_VERSION_LE(Maj,Min,Rel)
//        (((H5_VERS_MAJOR==Maj) && (H5_VERS_MINOR==Min) && (H5_VERS_RELEASE<=Rel)) ||
//         ((H5_VERS_MAJOR==Maj) && (H5_VERS_MINOR<Min)) ||
//         (H5_VERS_MAJOR<Maj))

/*
 * Status return values.  Failed integer functions in HDF5 result almost
 * always in a negative value (unsigned failing functions sometimes return
 * zero for failure) while successfull return is non-negative (often zero).
 * The negative failure value is most commonly -1, but don't bet on it.  The
 * proper way to detect failure is something like:
 *
 * 	if((dset = H5Dopen2(file, name)) < 0)
 *	    fprintf(stderr, "unable to open the requested dataset\n");
 */


/*
 * Boolean type.  Successful return values are zero (false) or positive
 * (true). The typical true value is 1 but don't bet on it.  Boolean
 * functions cannot fail.  Functions that return `htri_t' however return zero
 * (false), positive (true), or negative (failure). The proper way to test
 * for truth from a htri_t function is:
 *
 * 	if ((retval = H5Tcommitted(type))>0) {
 *	    printf("data type is committed\n");
 *	} else if (!retval) {
 * 	    printf("data type is not committed\n");
 *	} else {
 * 	    printf("error determining whether data type is committed\n");
 *	}
 */
// #ifdef H5_HAVE_STDBOOL_H
//   #include <stdbool.h>
// #else /* H5_HAVE_STDBOOL_H */
// #endif /* H5_HAVE_STDBOOL_H */

/* Define the ssize_t type if it not is defined */
// #if H5_SIZEOF_SSIZE_T==0
/* Undefine this size, we will re-define it in one of the sections below */
// #undef H5_SIZEOF_SSIZE_T
// #if H5_SIZEOF_SIZE_T==H5_SIZEOF_INT
// #elif H5_SIZEOF_SIZE_T==H5_SIZEOF_LONG
// #elif H5_SIZEOF_SIZE_T==H5_SIZEOF_LONG_LONG
// #else /* Can't find matching type for ssize_t */
// #   error "nothing appropriate for ssize_t"
// #endif
// #endif

/*
 * The sizes of file objects have their own types defined here, use a 64-bit
 * type.
 */
// #if H5_SIZEOF_LONG_LONG >= 8
public static final int H5_SIZEOF_HSIZE_T = H5_SIZEOF_LONG_LONG;
public static final int H5_SIZEOF_HSSIZE_T = H5_SIZEOF_LONG_LONG;
// #else
// #   error "nothing appropriate for hsize_t"
// #endif
public static native @MemberGetter int HSIZE_UNDEF();
public static final int HSIZE_UNDEF = HSIZE_UNDEF();

/*
 * File addresses have their own types.
 */
// #if H5_SIZEOF_INT64_T>=8
public static native @MemberGetter int HADDR_UNDEF();
public static final int HADDR_UNDEF = HADDR_UNDEF();
public static final int H5_SIZEOF_HADDR_T =        H5_SIZEOF_INT64_T;
// #   ifdef H5_HAVE_PARALLEL
// #   endif  /* H5_HAVE_PARALLEL */
// #elif H5_SIZEOF_INT>=8
// #   ifdef H5_HAVE_PARALLEL
// #   endif  /* H5_HAVE_PARALLEL */
// #elif H5_SIZEOF_LONG>=8
// #   ifdef H5_HAVE_PARALLEL
// #   endif  /* H5_HAVE_PARALLEL */
// #elif H5_SIZEOF_LONG_LONG>=8
// #   ifdef H5_HAVE_PARALLEL
// #   endif  /* H5_HAVE_PARALLEL */
// #else
// #   error "nothing appropriate for haddr_t"
// #endif
// #if H5_SIZEOF_HADDR_T ==H5_SIZEOF_INT
public static final String H5_PRINTF_HADDR_FMT =  "%u";
// #elif H5_SIZEOF_HADDR_T ==H5_SIZEOF_LONG
// #elif H5_SIZEOF_HADDR_T ==H5_SIZEOF_LONG_LONG
// #else
// #   error "nothing appropriate for H5_PRINTF_HADDR_FMT"
// #endif
public static final int HADDR_MAX =		(HADDR_UNDEF-1);

/* uint32_t type is used for creation order field for messages.  It may be
 * defined in Posix.1g, otherwise it is defined here.
 */
// #if H5_SIZEOF_UINT32_T>=4
// #elif H5_SIZEOF_SHORT>=4
// #   undef H5_SIZEOF_UINT32_T
// #elif H5_SIZEOF_INT>=4
// #   undef H5_SIZEOF_UINT32_T
// #elif H5_SIZEOF_LONG>=4
// #   undef H5_SIZEOF_UINT32_T
// #else
// #   error "nothing appropriate for uint32_t"
// #endif

/* int64_t type is used for creation order field for links.  It may be
 * defined in Posix.1g, otherwise it is defined here.
 */
// #if H5_SIZEOF_INT64_T>=8
// #elif H5_SIZEOF_INT>=8
// #   undef H5_SIZEOF_INT64_T
// #elif H5_SIZEOF_LONG>=8
// #   undef H5_SIZEOF_INT64_T
// #elif H5_SIZEOF_LONG_LONG>=8
// #   undef H5_SIZEOF_INT64_T
// #else
// #   error "nothing appropriate for int64_t"
// #endif

/* uint64_t type is used for fields for H5O_info_t.  It may be
 * defined in Posix.1g, otherwise it is defined here.
 */
// #if H5_SIZEOF_UINT64_T>=8
// #elif H5_SIZEOF_INT>=8
// #   undef H5_SIZEOF_UINT64_T
// #elif H5_SIZEOF_LONG>=8
// #   undef H5_SIZEOF_UINT64_T
// #elif H5_SIZEOF_LONG_LONG>=8
// #   undef H5_SIZEOF_UINT64_T
// #else
// #   error "nothing appropriate for uint64_t"
// #endif

/* Common iteration orders */
/** enum H5_iter_order_t */
public static final int
    H5_ITER_UNKNOWN = -1,       /* Unknown order */
    H5_ITER_INC = 0,                /* Increasing order */
    H5_ITER_DEC = 1,                /* Decreasing order */
    H5_ITER_NATIVE = 2,             /* No particular order, whatever is fastest */
    H5_ITER_N = 3;		        /* Number of iteration orders */

/* Iteration callback values */
/* (Actually, any postive value will cause the iterator to stop and pass back
 *      that positive value to the function that called the iterator)
 */
public static final int H5_ITER_ERROR =   (-1);
public static final int H5_ITER_CONT =    (0);
public static final int H5_ITER_STOP =    (1);

/*
 * The types of indices on links in groups/attributes on objects.
 * Primarily used for "<do> <foo> by index" routines and for iterating over
 * links in groups/attributes on objects.
 */
/** enum H5_index_t */
public static final int
    H5_INDEX_UNKNOWN = -1,	/* Unknown index type			*/
    H5_INDEX_NAME = 0,		/* Index on names 			*/
    H5_INDEX_CRT_ORDER = 1,		/* Index on creation order 		*/
    H5_INDEX_N = 2;			/* Number of indices defined 		*/

/*
 * Storage info struct used by H5O_info_t and H5F_info_t
 */
public static class H5_ih_info_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5_ih_info_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5_ih_info_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5_ih_info_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5_ih_info_t position(long position) {
        return (H5_ih_info_t)super.position(position);
    }

    public native @Cast("hsize_t") long index_size(); public native H5_ih_info_t index_size(long index_size);     /* btree and/or list */
    public native @Cast("hsize_t") long heap_size(); public native H5_ih_info_t heap_size(long heap_size);
}

/* Functions in H5.c */
public static native @Cast("herr_t") int H5open();
public static native @Cast("herr_t") int H5close();
public static native @Cast("herr_t") int H5dont_atexit();
public static native @Cast("herr_t") int H5garbage_collect();
public static native @Cast("herr_t") int H5set_free_list_limits(int reg_global_lim, int reg_list_lim,
                int arr_global_lim, int arr_list_lim, int blk_global_lim,
                int blk_list_lim);
public static native @Cast("herr_t") int H5get_libversion(@Cast("unsigned*") IntPointer majnum, @Cast("unsigned*") IntPointer minnum,
				@Cast("unsigned*") IntPointer relnum);
public static native @Cast("herr_t") int H5get_libversion(@Cast("unsigned*") IntBuffer majnum, @Cast("unsigned*") IntBuffer minnum,
				@Cast("unsigned*") IntBuffer relnum);
public static native @Cast("herr_t") int H5get_libversion(@Cast("unsigned*") int[] majnum, @Cast("unsigned*") int[] minnum,
				@Cast("unsigned*") int[] relnum);
public static native @Cast("herr_t") int H5check_version(@Cast("unsigned") int majnum, @Cast("unsigned") int minnum,
			       @Cast("unsigned") int relnum);
public static native @Cast("herr_t") int H5is_library_threadsafe(@Cast("hbool_t*") BoolPointer is_ts);
public static native @Cast("herr_t") int H5is_library_threadsafe(@Cast("hbool_t*") boolean[] is_ts);
public static native @Cast("herr_t") int H5free_memory(Pointer mem);
public static native Pointer H5allocate_memory(@Cast("size_t") long size, @Cast("hbool_t") boolean clear);
public static native Pointer H5resize_memory(Pointer mem, @Cast("size_t") long size);

// #ifdef __cplusplus
// #endif
// #endif /* _H5public_H */
 



// Parsed from H5Cpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:	H5Cpublic.h
 *              June 4, 2005
 *              John Mainzer
 *
 * Purpose:     Public include file for cache functions.
 *
 * Modifications:
 *
 *-------------------------------------------------------------------------
 */
// #ifndef _H5Cpublic_H
// #define _H5Cpublic_H

/* Public headers needed by this file */
// #include "H5public.h"

// #ifdef __cplusplus
// #endif

/** enum H5C_cache_incr_mode */
public static final int
    H5C_incr__off = 0,
    H5C_incr__threshold = 1;

/** enum H5C_cache_flash_incr_mode */
public static final int
     H5C_flash_incr__off = 0,
     H5C_flash_incr__add_space = 1;

/** enum H5C_cache_decr_mode */
public static final int
    H5C_decr__off = 0,
    H5C_decr__threshold = 1,
    H5C_decr__age_out = 2,
    H5C_decr__age_out_with_threshold = 3;

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from H5Ipublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains function prototypes for each exported function in
 * the H5I module.
 */
// #ifndef _H5Ipublic_H
// #define _H5Ipublic_H

/* Public headers needed by this file */
// #include "H5public.h"

/*
 * Library type values.  Start with `1' instead of `0' because it makes the
 * tracing output look better when hid_t values are large numbers.  Change the
 * TYPE_BITS in H5I.c if the MAXID gets larger than 32 (an assertion will
 * fail otherwise).
 *
 * When adding types here, add a section to the 'misc19' test in test/tmisc.c
 * to verify that the H5I{inc|dec|get}_ref() routines work correctly with in.
 *
 */
/** enum H5I_type_t */
public static final int
    H5I_UNINIT		=  (-2), /*uninitialized type			    */
    H5I_BADID		=  (-1),	/*invalid Type				    */
    H5I_FILE            = 1,  	/*type ID for File objects      	    */
    H5I_GROUP = 2,	                /*type ID for Group objects     	    */
    H5I_DATATYPE = 3,	        /*type ID for Datatype objects		    */
    H5I_DATASPACE = 4,	        /*type ID for Dataspace objects		    */
    H5I_DATASET = 5,	        /*type ID for Dataset objects		    */
    H5I_ATTR = 6,		        /*type ID for Attribute objects		    */
    H5I_REFERENCE = 7,	        /*type ID for Reference objects		    */
    H5I_VFL = 8,			/*type ID for virtual file layer	    */
    H5I_GENPROP_CLS = 9,            /*type ID for generic property list classes */
    H5I_GENPROP_LST = 10,            /*type ID for generic property lists        */
    H5I_ERROR_CLASS = 11,            /*type ID for error classes		    */
    H5I_ERROR_MSG = 12,              /*type ID for error messages		    */
    H5I_ERROR_STACK = 13,            /*type ID for error stacks		    */
    H5I_NTYPES = 14;		        /*number of library types, MUST BE LAST!    */

/* Type of atoms to return to users */
public static final int H5_SIZEOF_HID_T =         H5_SIZEOF_INT64_T;

/* An invalid object ID. This is also negative for error return. */
public static final int H5I_INVALID_HID =         (-1);

/*
 * Function for freeing objects. This function will be called with an object
 * ID type number and a pointer to the object. The function should free the
 * object and return non-negative to indicate that the object
 * can be removed from the ID type. If the function returns negative
 * (failure) then the object will remain in the ID type.
 */
public static class H5I_free_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5I_free_t(Pointer p) { super(p); }
    protected H5I_free_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(Pointer arg0);
}

/* Type of the function to compare objects & keys */
public static class H5I_search_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5I_search_func_t(Pointer p) { super(p); }
    protected H5I_search_func_t() { allocate(); }
    private native void allocate();
    public native int call(Pointer obj, @Cast("hid_t") int id, Pointer key);
}

// #ifdef __cplusplus
// #endif

/* Public API functions */

public static native @Cast("hid_t") int H5Iregister(@Cast("H5I_type_t") int type, @Const Pointer object);
public static native Pointer H5Iobject_verify(@Cast("hid_t") int id, @Cast("H5I_type_t") int id_type);
public static native Pointer H5Iremove_verify(@Cast("hid_t") int id, @Cast("H5I_type_t") int id_type);
public static native @Cast("H5I_type_t") int H5Iget_type(@Cast("hid_t") int id);
public static native @Cast("hid_t") int H5Iget_file_id(@Cast("hid_t") int id);
public static native @Cast("ssize_t") int H5Iget_name(@Cast("hid_t") int id, @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Iget_name(@Cast("hid_t") int id, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Iget_name(@Cast("hid_t") int id, @Cast("char*") byte[] name, @Cast("size_t") long size);
public static native int H5Iinc_ref(@Cast("hid_t") int id);
public static native int H5Idec_ref(@Cast("hid_t") int id);
public static native int H5Iget_ref(@Cast("hid_t") int id);
public static native @Cast("H5I_type_t") int H5Iregister_type(@Cast("size_t") long hash_size, @Cast("unsigned") int reserved, H5I_free_t free_func);
public static native @Cast("herr_t") int H5Iclear_type(@Cast("H5I_type_t") int type, @Cast("hbool_t") boolean force);
public static native @Cast("herr_t") int H5Idestroy_type(@Cast("H5I_type_t") int type);
public static native int H5Iinc_type_ref(@Cast("H5I_type_t") int type);
public static native int H5Idec_type_ref(@Cast("H5I_type_t") int type);
public static native int H5Iget_type_ref(@Cast("H5I_type_t") int type);
public static native Pointer H5Isearch(@Cast("H5I_type_t") int type, H5I_search_func_t func, Pointer key);
public static native @Cast("herr_t") int H5Inmembers(@Cast("H5I_type_t") int type, @Cast("hsize_t*") LongPointer num_members);
public static native @Cast("herr_t") int H5Inmembers(@Cast("H5I_type_t") int type, @Cast("hsize_t*") LongBuffer num_members);
public static native @Cast("herr_t") int H5Inmembers(@Cast("H5I_type_t") int type, @Cast("hsize_t*") long[] num_members);
public static native @Cast("htri_t") int H5Itype_exists(@Cast("H5I_type_t") int type);
public static native @Cast("htri_t") int H5Iis_valid(@Cast("hid_t") int id);

// #ifdef __cplusplus
// #endif
// #endif /* _H5Ipublic_H */



// Parsed from H5Tpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5T module.
 */
// #ifndef _H5Tpublic_H
// #define _H5Tpublic_H

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Ipublic.h"

// #define HOFFSET(S,M)    (offsetof(S,M))

/* These are the various classes of datatypes */
/* If this goes over 16 types (0-15), the file format will need to change) */
/** enum H5T_class_t */
public static final int
    H5T_NO_CLASS         = -1,  /*error                                      */
    H5T_INTEGER          = 0,   /*integer types                              */
    H5T_FLOAT            = 1,   /*floating-point types                       */
    H5T_TIME             = 2,   /*date and time types                        */
    H5T_STRING           = 3,   /*character string types                     */
    H5T_BITFIELD         = 4,   /*bit field types                            */
    H5T_OPAQUE           = 5,   /*opaque types                               */
    H5T_COMPOUND         = 6,   /*compound types                             */
    H5T_REFERENCE        = 7,   /*reference types                            */
    H5T_ENUM		 = 8,	/*enumeration types                          */
    H5T_VLEN		 = 9,	/*Variable-Length types                      */
    H5T_ARRAY	         = 10,	/*Array types                                */

    H5T_NCLASSES = 11;                /*this must be last                          */

/* Byte orders */
/** enum H5T_order_t */
public static final int
    H5T_ORDER_ERROR      = -1,  /*error                                      */
    H5T_ORDER_LE         = 0,   /*little endian                              */
    H5T_ORDER_BE         = 1,   /*bit endian                                 */
    H5T_ORDER_VAX        = 2,   /*VAX mixed endian                           */
    H5T_ORDER_MIXED      = 3,   /*Compound type with mixed member orders     */
    H5T_ORDER_NONE       = 4;    /*no particular order (strings, bits,..)     */
    /*H5T_ORDER_NONE must be last */

/* Types of integer sign schemes */
/** enum H5T_sign_t */
public static final int
    H5T_SGN_ERROR        = -1,  /*error                                      */
    H5T_SGN_NONE         = 0,   /*this is an unsigned type                   */
    H5T_SGN_2            = 1,   /*two's complement                           */

    H5T_NSGN             = 2;    /*this must be last!                         */

/* Floating-point normalization schemes */
/** enum H5T_norm_t */
public static final int
    H5T_NORM_ERROR       = -1,  /*error                                      */
    H5T_NORM_IMPLIED     = 0,   /*msb of mantissa isn't stored, always 1     */
    H5T_NORM_MSBSET      = 1,   /*msb of mantissa is always 1                */
    H5T_NORM_NONE        = 2;    /*not normalized                             */
    /*H5T_NORM_NONE must be last */

/*
 * Character set to use for text strings.  Do not change these values since
 * they appear in HDF5 files!
 */
/** enum H5T_cset_t */
public static final int
    H5T_CSET_ERROR       = -1,  /*error                                      */
    H5T_CSET_ASCII       = 0,   /*US ASCII                                   */
    H5T_CSET_UTF8        = 1,   /*UTF-8 Unicode encoding		     */
    H5T_CSET_RESERVED_2  = 2,   /*reserved for later use		     */
    H5T_CSET_RESERVED_3  = 3,   /*reserved for later use		     */
    H5T_CSET_RESERVED_4  = 4,   /*reserved for later use		     */
    H5T_CSET_RESERVED_5  = 5,   /*reserved for later use		     */
    H5T_CSET_RESERVED_6  = 6,   /*reserved for later use		     */
    H5T_CSET_RESERVED_7  = 7,   /*reserved for later use		     */
    H5T_CSET_RESERVED_8  = 8,   /*reserved for later use		     */
    H5T_CSET_RESERVED_9  = 9,   /*reserved for later use		     */
    H5T_CSET_RESERVED_10 = 10,  /*reserved for later use		     */
    H5T_CSET_RESERVED_11 = 11,  /*reserved for later use		     */
    H5T_CSET_RESERVED_12 = 12,  /*reserved for later use		     */
    H5T_CSET_RESERVED_13 = 13,  /*reserved for later use		     */
    H5T_CSET_RESERVED_14 = 14,  /*reserved for later use		     */
    H5T_CSET_RESERVED_15 = 15;   /*reserved for later use		     */
public static final int H5T_NCSET = H5T_CSET_RESERVED_2;    		/*Number of character sets actually defined  */

/*
 * Type of padding to use in character strings.  Do not change these values
 * since they appear in HDF5 files!
 */
/** enum H5T_str_t */
public static final int
    H5T_STR_ERROR        = -1,  /*error                                      */
    H5T_STR_NULLTERM     = 0,   /*null terminate like in C                   */
    H5T_STR_NULLPAD      = 1,   /*pad with nulls                             */
    H5T_STR_SPACEPAD     = 2,   /*pad with spaces like in Fortran            */
    H5T_STR_RESERVED_3   = 3,   /*reserved for later use		     */
    H5T_STR_RESERVED_4   = 4,   /*reserved for later use		     */
    H5T_STR_RESERVED_5   = 5,   /*reserved for later use		     */
    H5T_STR_RESERVED_6   = 6,   /*reserved for later use		     */
    H5T_STR_RESERVED_7   = 7,   /*reserved for later use		     */
    H5T_STR_RESERVED_8   = 8,   /*reserved for later use		     */
    H5T_STR_RESERVED_9   = 9,   /*reserved for later use		     */
    H5T_STR_RESERVED_10  = 10,  /*reserved for later use		     */
    H5T_STR_RESERVED_11  = 11,  /*reserved for later use		     */
    H5T_STR_RESERVED_12  = 12,  /*reserved for later use		     */
    H5T_STR_RESERVED_13  = 13,  /*reserved for later use		     */
    H5T_STR_RESERVED_14  = 14,  /*reserved for later use		     */
    H5T_STR_RESERVED_15  = 15;   /*reserved for later use		     */
public static final int H5T_NSTR = H5T_STR_RESERVED_3;		/*num H5T_str_t types actually defined	     */

/* Type of padding to use in other atomic types */
/** enum H5T_pad_t */
public static final int
    H5T_PAD_ERROR        = -1,  /*error                                      */
    H5T_PAD_ZERO         = 0,   /*always set to zero                         */
    H5T_PAD_ONE          = 1,   /*always set to one                          */
    H5T_PAD_BACKGROUND   = 2,   /*set to background value                    */

    H5T_NPAD             = 3;    /*THIS MUST BE LAST                          */

/* Commands sent to conversion functions */
/** enum H5T_cmd_t */
public static final int
    H5T_CONV_INIT	= 0,	/*query and/or initialize private data	     */
    H5T_CONV_CONV	= 1, 	/*convert data from source to dest datatype */
    H5T_CONV_FREE	= 2;	/*function is being removed from path	     */

/* How is the `bkg' buffer used by the conversion function? */
/** enum H5T_bkg_t */
public static final int
    H5T_BKG_NO		= 0, 	/*background buffer is not needed, send NULL */
    H5T_BKG_TEMP	= 1,	/*bkg buffer used as temp storage only       */
    H5T_BKG_YES		= 2;	/*init bkg buf with data before conversion   */

/* Type conversion client data */
public static class H5T_cdata_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5T_cdata_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5T_cdata_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5T_cdata_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5T_cdata_t position(long position) {
        return (H5T_cdata_t)super.position(position);
    }

    public native @Cast("H5T_cmd_t") int command(); public native H5T_cdata_t command(int command);/*what should the conversion function do?    */
    public native @Cast("H5T_bkg_t") int need_bkg(); public native H5T_cdata_t need_bkg(int need_bkg);/*is the background buffer needed?	     */
    public native @Cast("hbool_t") boolean recalc(); public native H5T_cdata_t recalc(boolean recalc);	/*recalculate private data		     */
    public native Pointer priv(); public native H5T_cdata_t priv(Pointer priv);	/*private data				     */
}

/* Conversion function persistence */
/** enum H5T_pers_t */
public static final int
    H5T_PERS_DONTCARE	= -1, 	/*wild card				     */
    H5T_PERS_HARD	= 0,	/*hard conversion function		     */
    H5T_PERS_SOFT	= 1; 	/*soft conversion function		     */

/* The order to retrieve atomic native datatype */
/** enum H5T_direction_t */
public static final int
    H5T_DIR_DEFAULT     = 0,    /*default direction is inscendent            */
    H5T_DIR_ASCEND      = 1,    /*in inscendent order                        */
    H5T_DIR_DESCEND     = 2;     /*in descendent order                        */

/* The exception type passed into the conversion callback function */
/** enum H5T_conv_except_t */
public static final int
    H5T_CONV_EXCEPT_RANGE_HI       = 0,   /*source value is greater than destination's range */
    H5T_CONV_EXCEPT_RANGE_LOW      = 1,   /*source value is less than destination's range    */
    H5T_CONV_EXCEPT_PRECISION      = 2,   /*source value loses precision in destination      */
    H5T_CONV_EXCEPT_TRUNCATE       = 3,   /*source value is truncated in destination         */
    H5T_CONV_EXCEPT_PINF           = 4,   /*source value is positive infinity(floating number) */
    H5T_CONV_EXCEPT_NINF           = 5,   /*source value is negative infinity(floating number) */
    H5T_CONV_EXCEPT_NAN            = 6;    /*source value is NaN(floating number)             */

/* The return value from conversion callback function H5T_conv_except_func_t */
/** enum H5T_conv_ret_t */
public static final int
    H5T_CONV_ABORT      = -1,   /*abort conversion                           */
    H5T_CONV_UNHANDLED  = 0,    /*callback function failed to handle the exception      */
    H5T_CONV_HANDLED    = 1;     /*callback function handled the exception successfully  */

/* Variable Length Datatype struct in memory */
/* (This is only used for VL sequences, not VL strings, which are stored in char *'s) */
public static class hvl_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public hvl_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public hvl_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public hvl_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public hvl_t position(long position) {
        return (hvl_t)super.position(position);
    }

    public native @Cast("size_t") long len(); public native hvl_t len(long len); /* Length of VL data (in base type units) */
    public native Pointer p(); public native hvl_t p(Pointer p);    /* Pointer to VL data */
}

/* Variable Length String information */
public static native @MemberGetter int H5T_VARIABLE();
public static final int H5T_VARIABLE = H5T_VARIABLE();  /* Indicate that a string is variable length (null-terminated in C, instead of fixed length) */

/* Opaque information */
public static final int H5T_OPAQUE_TAG_MAX =      256;     /* Maximum length of an opaque tag */
                                        /* This could be raised without too much difficulty */

// #ifdef __cplusplus
// #endif

/* All datatype conversion functions are... */
public static class H5T_conv_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5T_conv_t(Pointer p) { super(p); }
    protected H5T_conv_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int src_id, @Cast("hid_t") int dst_id, H5T_cdata_t cdata,
      @Cast("size_t") long nelmts, @Cast("size_t") long buf_stride, @Cast("size_t") long bkg_stride, Pointer buf,
      Pointer bkg, @Cast("hid_t") int dset_xfer_plist);
}

/* Exception handler.  If an exception like overflow happenes during conversion,
 * this function is called if it's registered through H5Pset_type_conv_cb.
 */
public static class H5T_conv_except_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5T_conv_except_func_t(Pointer p) { super(p); }
    protected H5T_conv_except_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("H5T_conv_ret_t") int call(@Cast("H5T_conv_except_t") int except_type,
    @Cast("hid_t") int src_id, @Cast("hid_t") int dst_id, Pointer src_buf, Pointer dst_buf, Pointer user_data);
}

/* When this header is included from a private header, don't make calls to H5open() */
// #undef H5OPEN
// #ifndef _H5private_H
// #define H5OPEN          H5open(),
// #else   /* _H5private_H */
// #define H5OPEN
// #endif  /* _H5private_H */

/*
 * The IEEE floating point types in various byte orders.
 */
public static native @MemberGetter int H5T_IEEE_F32BE();
public static final int H5T_IEEE_F32BE = H5T_IEEE_F32BE();
public static native @MemberGetter int H5T_IEEE_F32LE();
public static final int H5T_IEEE_F32LE = H5T_IEEE_F32LE();
public static native @MemberGetter int H5T_IEEE_F64BE();
public static final int H5T_IEEE_F64BE = H5T_IEEE_F64BE();
public static native @MemberGetter int H5T_IEEE_F64LE();
public static final int H5T_IEEE_F64LE = H5T_IEEE_F64LE();
public static native @Cast("hid_t") int H5T_IEEE_F32BE_g(); public static native void H5T_IEEE_F32BE_g(int H5T_IEEE_F32BE_g);
public static native @Cast("hid_t") int H5T_IEEE_F32LE_g(); public static native void H5T_IEEE_F32LE_g(int H5T_IEEE_F32LE_g);
public static native @Cast("hid_t") int H5T_IEEE_F64BE_g(); public static native void H5T_IEEE_F64BE_g(int H5T_IEEE_F64BE_g);
public static native @Cast("hid_t") int H5T_IEEE_F64LE_g(); public static native void H5T_IEEE_F64LE_g(int H5T_IEEE_F64LE_g);

/*
 * These are "standard" types.  For instance, signed (2's complement) and
 * unsigned integers of various sizes and byte orders.
 */
public static native @MemberGetter int H5T_STD_I8BE();
public static final int H5T_STD_I8BE = H5T_STD_I8BE();
public static native @MemberGetter int H5T_STD_I8LE();
public static final int H5T_STD_I8LE = H5T_STD_I8LE();
public static native @MemberGetter int H5T_STD_I16BE();
public static final int H5T_STD_I16BE = H5T_STD_I16BE();
public static native @MemberGetter int H5T_STD_I16LE();
public static final int H5T_STD_I16LE = H5T_STD_I16LE();
public static native @MemberGetter int H5T_STD_I32BE();
public static final int H5T_STD_I32BE = H5T_STD_I32BE();
public static native @MemberGetter int H5T_STD_I32LE();
public static final int H5T_STD_I32LE = H5T_STD_I32LE();
public static native @MemberGetter int H5T_STD_I64BE();
public static final int H5T_STD_I64BE = H5T_STD_I64BE();
public static native @MemberGetter int H5T_STD_I64LE();
public static final int H5T_STD_I64LE = H5T_STD_I64LE();
public static native @MemberGetter int H5T_STD_U8BE();
public static final int H5T_STD_U8BE = H5T_STD_U8BE();
public static native @MemberGetter int H5T_STD_U8LE();
public static final int H5T_STD_U8LE = H5T_STD_U8LE();
public static native @MemberGetter int H5T_STD_U16BE();
public static final int H5T_STD_U16BE = H5T_STD_U16BE();
public static native @MemberGetter int H5T_STD_U16LE();
public static final int H5T_STD_U16LE = H5T_STD_U16LE();
public static native @MemberGetter int H5T_STD_U32BE();
public static final int H5T_STD_U32BE = H5T_STD_U32BE();
public static native @MemberGetter int H5T_STD_U32LE();
public static final int H5T_STD_U32LE = H5T_STD_U32LE();
public static native @MemberGetter int H5T_STD_U64BE();
public static final int H5T_STD_U64BE = H5T_STD_U64BE();
public static native @MemberGetter int H5T_STD_U64LE();
public static final int H5T_STD_U64LE = H5T_STD_U64LE();
public static native @MemberGetter int H5T_STD_B8BE();
public static final int H5T_STD_B8BE = H5T_STD_B8BE();
public static native @MemberGetter int H5T_STD_B8LE();
public static final int H5T_STD_B8LE = H5T_STD_B8LE();
public static native @MemberGetter int H5T_STD_B16BE();
public static final int H5T_STD_B16BE = H5T_STD_B16BE();
public static native @MemberGetter int H5T_STD_B16LE();
public static final int H5T_STD_B16LE = H5T_STD_B16LE();
public static native @MemberGetter int H5T_STD_B32BE();
public static final int H5T_STD_B32BE = H5T_STD_B32BE();
public static native @MemberGetter int H5T_STD_B32LE();
public static final int H5T_STD_B32LE = H5T_STD_B32LE();
public static native @MemberGetter int H5T_STD_B64BE();
public static final int H5T_STD_B64BE = H5T_STD_B64BE();
public static native @MemberGetter int H5T_STD_B64LE();
public static final int H5T_STD_B64LE = H5T_STD_B64LE();
public static native @MemberGetter int H5T_STD_REF_OBJ();
public static final int H5T_STD_REF_OBJ = H5T_STD_REF_OBJ();
public static native @MemberGetter int H5T_STD_REF_DSETREG();
public static final int H5T_STD_REF_DSETREG = H5T_STD_REF_DSETREG();
public static native @Cast("hid_t") int H5T_STD_I8BE_g(); public static native void H5T_STD_I8BE_g(int H5T_STD_I8BE_g);
public static native @Cast("hid_t") int H5T_STD_I8LE_g(); public static native void H5T_STD_I8LE_g(int H5T_STD_I8LE_g);
public static native @Cast("hid_t") int H5T_STD_I16BE_g(); public static native void H5T_STD_I16BE_g(int H5T_STD_I16BE_g);
public static native @Cast("hid_t") int H5T_STD_I16LE_g(); public static native void H5T_STD_I16LE_g(int H5T_STD_I16LE_g);
public static native @Cast("hid_t") int H5T_STD_I32BE_g(); public static native void H5T_STD_I32BE_g(int H5T_STD_I32BE_g);
public static native @Cast("hid_t") int H5T_STD_I32LE_g(); public static native void H5T_STD_I32LE_g(int H5T_STD_I32LE_g);
public static native @Cast("hid_t") int H5T_STD_I64BE_g(); public static native void H5T_STD_I64BE_g(int H5T_STD_I64BE_g);
public static native @Cast("hid_t") int H5T_STD_I64LE_g(); public static native void H5T_STD_I64LE_g(int H5T_STD_I64LE_g);
public static native @Cast("hid_t") int H5T_STD_U8BE_g(); public static native void H5T_STD_U8BE_g(int H5T_STD_U8BE_g);
public static native @Cast("hid_t") int H5T_STD_U8LE_g(); public static native void H5T_STD_U8LE_g(int H5T_STD_U8LE_g);
public static native @Cast("hid_t") int H5T_STD_U16BE_g(); public static native void H5T_STD_U16BE_g(int H5T_STD_U16BE_g);
public static native @Cast("hid_t") int H5T_STD_U16LE_g(); public static native void H5T_STD_U16LE_g(int H5T_STD_U16LE_g);
public static native @Cast("hid_t") int H5T_STD_U32BE_g(); public static native void H5T_STD_U32BE_g(int H5T_STD_U32BE_g);
public static native @Cast("hid_t") int H5T_STD_U32LE_g(); public static native void H5T_STD_U32LE_g(int H5T_STD_U32LE_g);
public static native @Cast("hid_t") int H5T_STD_U64BE_g(); public static native void H5T_STD_U64BE_g(int H5T_STD_U64BE_g);
public static native @Cast("hid_t") int H5T_STD_U64LE_g(); public static native void H5T_STD_U64LE_g(int H5T_STD_U64LE_g);
public static native @Cast("hid_t") int H5T_STD_B8BE_g(); public static native void H5T_STD_B8BE_g(int H5T_STD_B8BE_g);
public static native @Cast("hid_t") int H5T_STD_B8LE_g(); public static native void H5T_STD_B8LE_g(int H5T_STD_B8LE_g);
public static native @Cast("hid_t") int H5T_STD_B16BE_g(); public static native void H5T_STD_B16BE_g(int H5T_STD_B16BE_g);
public static native @Cast("hid_t") int H5T_STD_B16LE_g(); public static native void H5T_STD_B16LE_g(int H5T_STD_B16LE_g);
public static native @Cast("hid_t") int H5T_STD_B32BE_g(); public static native void H5T_STD_B32BE_g(int H5T_STD_B32BE_g);
public static native @Cast("hid_t") int H5T_STD_B32LE_g(); public static native void H5T_STD_B32LE_g(int H5T_STD_B32LE_g);
public static native @Cast("hid_t") int H5T_STD_B64BE_g(); public static native void H5T_STD_B64BE_g(int H5T_STD_B64BE_g);
public static native @Cast("hid_t") int H5T_STD_B64LE_g(); public static native void H5T_STD_B64LE_g(int H5T_STD_B64LE_g);
public static native @Cast("hid_t") int H5T_STD_REF_OBJ_g(); public static native void H5T_STD_REF_OBJ_g(int H5T_STD_REF_OBJ_g);
public static native @Cast("hid_t") int H5T_STD_REF_DSETREG_g(); public static native void H5T_STD_REF_DSETREG_g(int H5T_STD_REF_DSETREG_g);

/*
 * Types which are particular to Unix.
 */
public static native @MemberGetter int H5T_UNIX_D32BE();
public static final int H5T_UNIX_D32BE = H5T_UNIX_D32BE();
public static native @MemberGetter int H5T_UNIX_D32LE();
public static final int H5T_UNIX_D32LE = H5T_UNIX_D32LE();
public static native @MemberGetter int H5T_UNIX_D64BE();
public static final int H5T_UNIX_D64BE = H5T_UNIX_D64BE();
public static native @MemberGetter int H5T_UNIX_D64LE();
public static final int H5T_UNIX_D64LE = H5T_UNIX_D64LE();
public static native @Cast("hid_t") int H5T_UNIX_D32BE_g(); public static native void H5T_UNIX_D32BE_g(int H5T_UNIX_D32BE_g);
public static native @Cast("hid_t") int H5T_UNIX_D32LE_g(); public static native void H5T_UNIX_D32LE_g(int H5T_UNIX_D32LE_g);
public static native @Cast("hid_t") int H5T_UNIX_D64BE_g(); public static native void H5T_UNIX_D64BE_g(int H5T_UNIX_D64BE_g);
public static native @Cast("hid_t") int H5T_UNIX_D64LE_g(); public static native void H5T_UNIX_D64LE_g(int H5T_UNIX_D64LE_g);

/*
 * Types particular to the C language.  String types use `bytes' instead
 * of `bits' as their size.
 */
public static native @MemberGetter int H5T_C_S1();
public static final int H5T_C_S1 = H5T_C_S1();
public static native @Cast("hid_t") int H5T_C_S1_g(); public static native void H5T_C_S1_g(int H5T_C_S1_g);

/*
 * Types particular to Fortran.
 */
public static native @MemberGetter int H5T_FORTRAN_S1();
public static final int H5T_FORTRAN_S1 = H5T_FORTRAN_S1();
public static native @Cast("hid_t") int H5T_FORTRAN_S1_g(); public static native void H5T_FORTRAN_S1_g(int H5T_FORTRAN_S1_g);

/*
 * These types are for Intel CPU's.  They are little endian with IEEE
 * floating point.
 */
public static final int H5T_INTEL_I8 =		H5T_STD_I8LE;
public static final int H5T_INTEL_I16 =		H5T_STD_I16LE;
public static final int H5T_INTEL_I32 =		H5T_STD_I32LE;
public static final int H5T_INTEL_I64 =		H5T_STD_I64LE;
public static final int H5T_INTEL_U8 =		H5T_STD_U8LE;
public static final int H5T_INTEL_U16 =		H5T_STD_U16LE;
public static final int H5T_INTEL_U32 =		H5T_STD_U32LE;
public static final int H5T_INTEL_U64 =		H5T_STD_U64LE;
public static final int H5T_INTEL_B8 =		H5T_STD_B8LE;
public static final int H5T_INTEL_B16 =		H5T_STD_B16LE;
public static final int H5T_INTEL_B32 =		H5T_STD_B32LE;
public static final int H5T_INTEL_B64 =		H5T_STD_B64LE;
public static final int H5T_INTEL_F32 =		H5T_IEEE_F32LE;
public static final int H5T_INTEL_F64 =		H5T_IEEE_F64LE;

/*
 * These types are for DEC Alpha CPU's.  They are little endian with IEEE
 * floating point.
 */
public static final int H5T_ALPHA_I8 =		H5T_STD_I8LE;
public static final int H5T_ALPHA_I16 =		H5T_STD_I16LE;
public static final int H5T_ALPHA_I32 =		H5T_STD_I32LE;
public static final int H5T_ALPHA_I64 =		H5T_STD_I64LE;
public static final int H5T_ALPHA_U8 =		H5T_STD_U8LE;
public static final int H5T_ALPHA_U16 =		H5T_STD_U16LE;
public static final int H5T_ALPHA_U32 =		H5T_STD_U32LE;
public static final int H5T_ALPHA_U64 =		H5T_STD_U64LE;
public static final int H5T_ALPHA_B8 =		H5T_STD_B8LE;
public static final int H5T_ALPHA_B16 =		H5T_STD_B16LE;
public static final int H5T_ALPHA_B32 =		H5T_STD_B32LE;
public static final int H5T_ALPHA_B64 =		H5T_STD_B64LE;
public static final int H5T_ALPHA_F32 =		H5T_IEEE_F32LE;
public static final int H5T_ALPHA_F64 =		H5T_IEEE_F64LE;

/*
 * These types are for MIPS cpu's commonly used in SGI systems. They are big
 * endian with IEEE floating point.
 */
public static final int H5T_MIPS_I8 =		H5T_STD_I8BE;
public static final int H5T_MIPS_I16 =		H5T_STD_I16BE;
public static final int H5T_MIPS_I32 =		H5T_STD_I32BE;
public static final int H5T_MIPS_I64 =		H5T_STD_I64BE;
public static final int H5T_MIPS_U8 =		H5T_STD_U8BE;
public static final int H5T_MIPS_U16 =		H5T_STD_U16BE;
public static final int H5T_MIPS_U32 =		H5T_STD_U32BE;
public static final int H5T_MIPS_U64 =		H5T_STD_U64BE;
public static final int H5T_MIPS_B8 =		H5T_STD_B8BE;
public static final int H5T_MIPS_B16 =		H5T_STD_B16BE;
public static final int H5T_MIPS_B32 =		H5T_STD_B32BE;
public static final int H5T_MIPS_B64 =		H5T_STD_B64BE;
public static final int H5T_MIPS_F32 =		H5T_IEEE_F32BE;
public static final int H5T_MIPS_F64 =		H5T_IEEE_F64BE;

/*
 * The VAX floating point types (i.e. in VAX byte order)
 */
public static native @MemberGetter int H5T_VAX_F32();
public static final int H5T_VAX_F32 = H5T_VAX_F32();
public static native @MemberGetter int H5T_VAX_F64();
public static final int H5T_VAX_F64 = H5T_VAX_F64();
public static native @Cast("hid_t") int H5T_VAX_F32_g(); public static native void H5T_VAX_F32_g(int H5T_VAX_F32_g);
public static native @Cast("hid_t") int H5T_VAX_F64_g(); public static native void H5T_VAX_F64_g(int H5T_VAX_F64_g);

/*
 * The predefined native types. These are the types detected by H5detect and
 * they violate the naming scheme a little.  Instead of a class name,
 * precision and byte order as the last component, they have a C-like type
 * name.  If the type begins with `U' then it is the unsigned version of the
 * integer type; other integer types are signed.  The type LLONG corresponds
 * to C's `long long' and LDOUBLE is `long double' (these types might be the
 * same as `LONG' and `DOUBLE' respectively).
 */
public static native @MemberGetter int H5T_NATIVE_CHAR();
public static final int H5T_NATIVE_CHAR = H5T_NATIVE_CHAR();
public static native @MemberGetter int H5T_NATIVE_SCHAR();
public static final int H5T_NATIVE_SCHAR = H5T_NATIVE_SCHAR();
public static native @MemberGetter int H5T_NATIVE_UCHAR();
public static final int H5T_NATIVE_UCHAR = H5T_NATIVE_UCHAR();
public static native @MemberGetter int H5T_NATIVE_SHORT();
public static final int H5T_NATIVE_SHORT = H5T_NATIVE_SHORT();
public static native @MemberGetter int H5T_NATIVE_USHORT();
public static final int H5T_NATIVE_USHORT = H5T_NATIVE_USHORT();
public static native @MemberGetter int H5T_NATIVE_INT();
public static final int H5T_NATIVE_INT = H5T_NATIVE_INT();
public static native @MemberGetter int H5T_NATIVE_UINT();
public static final int H5T_NATIVE_UINT = H5T_NATIVE_UINT();
public static native @MemberGetter int H5T_NATIVE_LONG();
public static final int H5T_NATIVE_LONG = H5T_NATIVE_LONG();
public static native @MemberGetter int H5T_NATIVE_ULONG();
public static final int H5T_NATIVE_ULONG = H5T_NATIVE_ULONG();
public static native @MemberGetter int H5T_NATIVE_LLONG();
public static final int H5T_NATIVE_LLONG = H5T_NATIVE_LLONG();
public static native @MemberGetter int H5T_NATIVE_ULLONG();
public static final int H5T_NATIVE_ULLONG = H5T_NATIVE_ULLONG();
public static native @MemberGetter int H5T_NATIVE_FLOAT();
public static final int H5T_NATIVE_FLOAT = H5T_NATIVE_FLOAT();
public static native @MemberGetter int H5T_NATIVE_DOUBLE();
public static final int H5T_NATIVE_DOUBLE = H5T_NATIVE_DOUBLE();
// #if H5_SIZEOF_LONG_DOUBLE !=0
public static native @MemberGetter int H5T_NATIVE_LDOUBLE();
public static final int H5T_NATIVE_LDOUBLE = H5T_NATIVE_LDOUBLE();
// #endif
public static native @MemberGetter int H5T_NATIVE_B8();
public static final int H5T_NATIVE_B8 = H5T_NATIVE_B8();
public static native @MemberGetter int H5T_NATIVE_B16();
public static final int H5T_NATIVE_B16 = H5T_NATIVE_B16();
public static native @MemberGetter int H5T_NATIVE_B32();
public static final int H5T_NATIVE_B32 = H5T_NATIVE_B32();
public static native @MemberGetter int H5T_NATIVE_B64();
public static final int H5T_NATIVE_B64 = H5T_NATIVE_B64();
public static native @MemberGetter int H5T_NATIVE_OPAQUE();
public static final int H5T_NATIVE_OPAQUE = H5T_NATIVE_OPAQUE();
public static native @MemberGetter int H5T_NATIVE_HADDR();
public static final int H5T_NATIVE_HADDR = H5T_NATIVE_HADDR();
public static native @MemberGetter int H5T_NATIVE_HSIZE();
public static final int H5T_NATIVE_HSIZE = H5T_NATIVE_HSIZE();
public static native @MemberGetter int H5T_NATIVE_HSSIZE();
public static final int H5T_NATIVE_HSSIZE = H5T_NATIVE_HSSIZE();
public static native @MemberGetter int H5T_NATIVE_HERR();
public static final int H5T_NATIVE_HERR = H5T_NATIVE_HERR();
public static native @MemberGetter int H5T_NATIVE_HBOOL();
public static final int H5T_NATIVE_HBOOL = H5T_NATIVE_HBOOL();
public static native @Cast("hid_t") int H5T_NATIVE_SCHAR_g(); public static native void H5T_NATIVE_SCHAR_g(int H5T_NATIVE_SCHAR_g);
public static native @Cast("hid_t") int H5T_NATIVE_UCHAR_g(); public static native void H5T_NATIVE_UCHAR_g(int H5T_NATIVE_UCHAR_g);
public static native @Cast("hid_t") int H5T_NATIVE_SHORT_g(); public static native void H5T_NATIVE_SHORT_g(int H5T_NATIVE_SHORT_g);
public static native @Cast("hid_t") int H5T_NATIVE_USHORT_g(); public static native void H5T_NATIVE_USHORT_g(int H5T_NATIVE_USHORT_g);
public static native @Cast("hid_t") int H5T_NATIVE_INT_g(); public static native void H5T_NATIVE_INT_g(int H5T_NATIVE_INT_g);
public static native @Cast("hid_t") int H5T_NATIVE_UINT_g(); public static native void H5T_NATIVE_UINT_g(int H5T_NATIVE_UINT_g);
public static native @Cast("hid_t") int H5T_NATIVE_LONG_g(); public static native void H5T_NATIVE_LONG_g(int H5T_NATIVE_LONG_g);
public static native @Cast("hid_t") int H5T_NATIVE_ULONG_g(); public static native void H5T_NATIVE_ULONG_g(int H5T_NATIVE_ULONG_g);
public static native @Cast("hid_t") int H5T_NATIVE_LLONG_g(); public static native void H5T_NATIVE_LLONG_g(int H5T_NATIVE_LLONG_g);
public static native @Cast("hid_t") int H5T_NATIVE_ULLONG_g(); public static native void H5T_NATIVE_ULLONG_g(int H5T_NATIVE_ULLONG_g);
public static native @Cast("hid_t") int H5T_NATIVE_FLOAT_g(); public static native void H5T_NATIVE_FLOAT_g(int H5T_NATIVE_FLOAT_g);
public static native @Cast("hid_t") int H5T_NATIVE_DOUBLE_g(); public static native void H5T_NATIVE_DOUBLE_g(int H5T_NATIVE_DOUBLE_g);
// #if H5_SIZEOF_LONG_DOUBLE !=0
public static native @Cast("hid_t") int H5T_NATIVE_LDOUBLE_g(); public static native void H5T_NATIVE_LDOUBLE_g(int H5T_NATIVE_LDOUBLE_g);
// #endif
public static native @Cast("hid_t") int H5T_NATIVE_B8_g(); public static native void H5T_NATIVE_B8_g(int H5T_NATIVE_B8_g);
public static native @Cast("hid_t") int H5T_NATIVE_B16_g(); public static native void H5T_NATIVE_B16_g(int H5T_NATIVE_B16_g);
public static native @Cast("hid_t") int H5T_NATIVE_B32_g(); public static native void H5T_NATIVE_B32_g(int H5T_NATIVE_B32_g);
public static native @Cast("hid_t") int H5T_NATIVE_B64_g(); public static native void H5T_NATIVE_B64_g(int H5T_NATIVE_B64_g);
public static native @Cast("hid_t") int H5T_NATIVE_OPAQUE_g(); public static native void H5T_NATIVE_OPAQUE_g(int H5T_NATIVE_OPAQUE_g);
public static native @Cast("hid_t") int H5T_NATIVE_HADDR_g(); public static native void H5T_NATIVE_HADDR_g(int H5T_NATIVE_HADDR_g);
public static native @Cast("hid_t") int H5T_NATIVE_HSIZE_g(); public static native void H5T_NATIVE_HSIZE_g(int H5T_NATIVE_HSIZE_g);
public static native @Cast("hid_t") int H5T_NATIVE_HSSIZE_g(); public static native void H5T_NATIVE_HSSIZE_g(int H5T_NATIVE_HSSIZE_g);
public static native @Cast("hid_t") int H5T_NATIVE_HERR_g(); public static native void H5T_NATIVE_HERR_g(int H5T_NATIVE_HERR_g);
public static native @Cast("hid_t") int H5T_NATIVE_HBOOL_g(); public static native void H5T_NATIVE_HBOOL_g(int H5T_NATIVE_HBOOL_g);

/* C9x integer types */
public static native @MemberGetter int H5T_NATIVE_INT8();
public static final int H5T_NATIVE_INT8 = H5T_NATIVE_INT8();
public static native @MemberGetter int H5T_NATIVE_UINT8();
public static final int H5T_NATIVE_UINT8 = H5T_NATIVE_UINT8();
public static native @MemberGetter int H5T_NATIVE_INT_LEAST8();
public static final int H5T_NATIVE_INT_LEAST8 = H5T_NATIVE_INT_LEAST8();
public static native @MemberGetter int H5T_NATIVE_UINT_LEAST8();
public static final int H5T_NATIVE_UINT_LEAST8 = H5T_NATIVE_UINT_LEAST8();
public static native @MemberGetter int H5T_NATIVE_INT_FAST8();
public static final int H5T_NATIVE_INT_FAST8 = H5T_NATIVE_INT_FAST8();
public static native @MemberGetter int H5T_NATIVE_UINT_FAST8();
public static final int H5T_NATIVE_UINT_FAST8 = H5T_NATIVE_UINT_FAST8();
public static native @Cast("hid_t") int H5T_NATIVE_INT8_g(); public static native void H5T_NATIVE_INT8_g(int H5T_NATIVE_INT8_g);
public static native @Cast("hid_t") int H5T_NATIVE_UINT8_g(); public static native void H5T_NATIVE_UINT8_g(int H5T_NATIVE_UINT8_g);
public static native @Cast("hid_t") int H5T_NATIVE_INT_LEAST8_g(); public static native void H5T_NATIVE_INT_LEAST8_g(int H5T_NATIVE_INT_LEAST8_g);
public static native @Cast("hid_t") int H5T_NATIVE_UINT_LEAST8_g(); public static native void H5T_NATIVE_UINT_LEAST8_g(int H5T_NATIVE_UINT_LEAST8_g);
public static native @Cast("hid_t") int H5T_NATIVE_INT_FAST8_g(); public static native void H5T_NATIVE_INT_FAST8_g(int H5T_NATIVE_INT_FAST8_g);
public static native @Cast("hid_t") int H5T_NATIVE_UINT_FAST8_g(); public static native void H5T_NATIVE_UINT_FAST8_g(int H5T_NATIVE_UINT_FAST8_g);

public static native @MemberGetter int H5T_NATIVE_INT16();
public static final int H5T_NATIVE_INT16 = H5T_NATIVE_INT16();
public static native @MemberGetter int H5T_NATIVE_UINT16();
public static final int H5T_NATIVE_UINT16 = H5T_NATIVE_UINT16();
public static native @MemberGetter int H5T_NATIVE_INT_LEAST16();
public static final int H5T_NATIVE_INT_LEAST16 = H5T_NATIVE_INT_LEAST16();
public static native @MemberGetter int H5T_NATIVE_UINT_LEAST16();
public static final int H5T_NATIVE_UINT_LEAST16 = H5T_NATIVE_UINT_LEAST16();
public static native @MemberGetter int H5T_NATIVE_INT_FAST16();
public static final int H5T_NATIVE_INT_FAST16 = H5T_NATIVE_INT_FAST16();
public static native @MemberGetter int H5T_NATIVE_UINT_FAST16();
public static final int H5T_NATIVE_UINT_FAST16 = H5T_NATIVE_UINT_FAST16();
public static native @Cast("hid_t") int H5T_NATIVE_INT16_g(); public static native void H5T_NATIVE_INT16_g(int H5T_NATIVE_INT16_g);
public static native @Cast("hid_t") int H5T_NATIVE_UINT16_g(); public static native void H5T_NATIVE_UINT16_g(int H5T_NATIVE_UINT16_g);
public static native @Cast("hid_t") int H5T_NATIVE_INT_LEAST16_g(); public static native void H5T_NATIVE_INT_LEAST16_g(int H5T_NATIVE_INT_LEAST16_g);
public static native @Cast("hid_t") int H5T_NATIVE_UINT_LEAST16_g(); public static native void H5T_NATIVE_UINT_LEAST16_g(int H5T_NATIVE_UINT_LEAST16_g);
public static native @Cast("hid_t") int H5T_NATIVE_INT_FAST16_g(); public static native void H5T_NATIVE_INT_FAST16_g(int H5T_NATIVE_INT_FAST16_g);
public static native @Cast("hid_t") int H5T_NATIVE_UINT_FAST16_g(); public static native void H5T_NATIVE_UINT_FAST16_g(int H5T_NATIVE_UINT_FAST16_g);

public static native @MemberGetter int H5T_NATIVE_INT32();
public static final int H5T_NATIVE_INT32 = H5T_NATIVE_INT32();
public static native @MemberGetter int H5T_NATIVE_UINT32();
public static final int H5T_NATIVE_UINT32 = H5T_NATIVE_UINT32();
public static native @MemberGetter int H5T_NATIVE_INT_LEAST32();
public static final int H5T_NATIVE_INT_LEAST32 = H5T_NATIVE_INT_LEAST32();
public static native @MemberGetter int H5T_NATIVE_UINT_LEAST32();
public static final int H5T_NATIVE_UINT_LEAST32 = H5T_NATIVE_UINT_LEAST32();
public static native @MemberGetter int H5T_NATIVE_INT_FAST32();
public static final int H5T_NATIVE_INT_FAST32 = H5T_NATIVE_INT_FAST32();
public static native @MemberGetter int H5T_NATIVE_UINT_FAST32();
public static final int H5T_NATIVE_UINT_FAST32 = H5T_NATIVE_UINT_FAST32();
public static native @Cast("hid_t") int H5T_NATIVE_INT32_g(); public static native void H5T_NATIVE_INT32_g(int H5T_NATIVE_INT32_g);
public static native @Cast("hid_t") int H5T_NATIVE_UINT32_g(); public static native void H5T_NATIVE_UINT32_g(int H5T_NATIVE_UINT32_g);
public static native @Cast("hid_t") int H5T_NATIVE_INT_LEAST32_g(); public static native void H5T_NATIVE_INT_LEAST32_g(int H5T_NATIVE_INT_LEAST32_g);
public static native @Cast("hid_t") int H5T_NATIVE_UINT_LEAST32_g(); public static native void H5T_NATIVE_UINT_LEAST32_g(int H5T_NATIVE_UINT_LEAST32_g);
public static native @Cast("hid_t") int H5T_NATIVE_INT_FAST32_g(); public static native void H5T_NATIVE_INT_FAST32_g(int H5T_NATIVE_INT_FAST32_g);
public static native @Cast("hid_t") int H5T_NATIVE_UINT_FAST32_g(); public static native void H5T_NATIVE_UINT_FAST32_g(int H5T_NATIVE_UINT_FAST32_g);

public static native @MemberGetter int H5T_NATIVE_INT64();
public static final int H5T_NATIVE_INT64 = H5T_NATIVE_INT64();
public static native @MemberGetter int H5T_NATIVE_UINT64();
public static final int H5T_NATIVE_UINT64 = H5T_NATIVE_UINT64();
public static native @MemberGetter int H5T_NATIVE_INT_LEAST64();
public static final int H5T_NATIVE_INT_LEAST64 = H5T_NATIVE_INT_LEAST64();
public static native @MemberGetter int H5T_NATIVE_UINT_LEAST64();
public static final int H5T_NATIVE_UINT_LEAST64 = H5T_NATIVE_UINT_LEAST64();
public static native @MemberGetter int H5T_NATIVE_INT_FAST64();
public static final int H5T_NATIVE_INT_FAST64 = H5T_NATIVE_INT_FAST64();
public static native @MemberGetter int H5T_NATIVE_UINT_FAST64();
public static final int H5T_NATIVE_UINT_FAST64 = H5T_NATIVE_UINT_FAST64();
public static native @Cast("hid_t") int H5T_NATIVE_INT64_g(); public static native void H5T_NATIVE_INT64_g(int H5T_NATIVE_INT64_g);
public static native @Cast("hid_t") int H5T_NATIVE_UINT64_g(); public static native void H5T_NATIVE_UINT64_g(int H5T_NATIVE_UINT64_g);
public static native @Cast("hid_t") int H5T_NATIVE_INT_LEAST64_g(); public static native void H5T_NATIVE_INT_LEAST64_g(int H5T_NATIVE_INT_LEAST64_g);
public static native @Cast("hid_t") int H5T_NATIVE_UINT_LEAST64_g(); public static native void H5T_NATIVE_UINT_LEAST64_g(int H5T_NATIVE_UINT_LEAST64_g);
public static native @Cast("hid_t") int H5T_NATIVE_INT_FAST64_g(); public static native void H5T_NATIVE_INT_FAST64_g(int H5T_NATIVE_INT_FAST64_g);
public static native @Cast("hid_t") int H5T_NATIVE_UINT_FAST64_g(); public static native void H5T_NATIVE_UINT_FAST64_g(int H5T_NATIVE_UINT_FAST64_g);

/* Operations defined on all datatypes */
public static native @Cast("hid_t") int H5Tcreate(@Cast("H5T_class_t") int type, @Cast("size_t") long size);
public static native @Cast("hid_t") int H5Tcopy(@Cast("hid_t") int type_id);
public static native @Cast("herr_t") int H5Tclose(@Cast("hid_t") int type_id);
public static native @Cast("htri_t") int H5Tequal(@Cast("hid_t") int type1_id, @Cast("hid_t") int type2_id);
public static native @Cast("herr_t") int H5Tlock(@Cast("hid_t") int type_id);
public static native @Cast("herr_t") int H5Tcommit2(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") int type_id,
    @Cast("hid_t") int lcpl_id, @Cast("hid_t") int tcpl_id, @Cast("hid_t") int tapl_id);
public static native @Cast("herr_t") int H5Tcommit2(@Cast("hid_t") int loc_id, String name, @Cast("hid_t") int type_id,
    @Cast("hid_t") int lcpl_id, @Cast("hid_t") int tcpl_id, @Cast("hid_t") int tapl_id);
public static native @Cast("hid_t") int H5Topen2(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") int tapl_id);
public static native @Cast("hid_t") int H5Topen2(@Cast("hid_t") int loc_id, String name, @Cast("hid_t") int tapl_id);
public static native @Cast("herr_t") int H5Tcommit_anon(@Cast("hid_t") int loc_id, @Cast("hid_t") int type_id, @Cast("hid_t") int tcpl_id, @Cast("hid_t") int tapl_id);
public static native @Cast("hid_t") int H5Tget_create_plist(@Cast("hid_t") int type_id);
public static native @Cast("htri_t") int H5Tcommitted(@Cast("hid_t") int type_id);
public static native @Cast("herr_t") int H5Tencode(@Cast("hid_t") int obj_id, Pointer buf, @Cast("size_t*") SizeTPointer nalloc);
public static native @Cast("hid_t") int H5Tdecode(@Const Pointer buf);
public static native @Cast("herr_t") int H5Tflush(@Cast("hid_t") int type_id);
public static native @Cast("herr_t") int H5Trefresh(@Cast("hid_t") int type_id);

/* Operations defined on compound datatypes */
public static native @Cast("herr_t") int H5Tinsert(@Cast("hid_t") int parent_id, @Cast("const char*") BytePointer name, @Cast("size_t") long offset,
			 @Cast("hid_t") int member_id);
public static native @Cast("herr_t") int H5Tinsert(@Cast("hid_t") int parent_id, String name, @Cast("size_t") long offset,
			 @Cast("hid_t") int member_id);
public static native @Cast("herr_t") int H5Tpack(@Cast("hid_t") int type_id);

/* Operations defined on enumeration datatypes */
public static native @Cast("hid_t") int H5Tenum_create(@Cast("hid_t") int base_id);
public static native @Cast("herr_t") int H5Tenum_insert(@Cast("hid_t") int type, @Cast("const char*") BytePointer name, @Const Pointer value);
public static native @Cast("herr_t") int H5Tenum_insert(@Cast("hid_t") int type, String name, @Const Pointer value);
public static native @Cast("herr_t") int H5Tenum_nameof(@Cast("hid_t") int type, @Const Pointer value, @Cast("char*") BytePointer name,
			     @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Tenum_nameof(@Cast("hid_t") int type, @Const Pointer value, @Cast("char*") ByteBuffer name,
			     @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Tenum_nameof(@Cast("hid_t") int type, @Const Pointer value, @Cast("char*") byte[] name,
			     @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Tenum_valueof(@Cast("hid_t") int type, @Cast("const char*") BytePointer name,
			      Pointer value);
public static native @Cast("herr_t") int H5Tenum_valueof(@Cast("hid_t") int type, String name,
			      Pointer value);

/* Operations defined on variable-length datatypes */
public static native @Cast("hid_t") int H5Tvlen_create(@Cast("hid_t") int base_id);

/* Operations defined on array datatypes */
public static native @Cast("hid_t") int H5Tarray_create2(@Cast("hid_t") int base_id, @Cast("unsigned") int ndims,
            @Cast("const hsize_t*") LongPointer dim);
public static native @Cast("hid_t") int H5Tarray_create2(@Cast("hid_t") int base_id, @Cast("unsigned") int ndims,
            @Cast("const hsize_t*") LongBuffer dim);
public static native @Cast("hid_t") int H5Tarray_create2(@Cast("hid_t") int base_id, @Cast("unsigned") int ndims,
            @Cast("const hsize_t*") long[] dim);
public static native int H5Tget_array_ndims(@Cast("hid_t") int type_id);
public static native int H5Tget_array_dims2(@Cast("hid_t") int type_id, @Cast("hsize_t*") LongPointer dims);
public static native int H5Tget_array_dims2(@Cast("hid_t") int type_id, @Cast("hsize_t*") LongBuffer dims);
public static native int H5Tget_array_dims2(@Cast("hid_t") int type_id, @Cast("hsize_t*") long[] dims);

/* Operations defined on opaque datatypes */
public static native @Cast("herr_t") int H5Tset_tag(@Cast("hid_t") int type, @Cast("const char*") BytePointer tag);
public static native @Cast("herr_t") int H5Tset_tag(@Cast("hid_t") int type, String tag);
public static native @Cast("char*") BytePointer H5Tget_tag(@Cast("hid_t") int type);

/* Querying property values */
public static native @Cast("hid_t") int H5Tget_super(@Cast("hid_t") int type);
public static native @Cast("H5T_class_t") int H5Tget_class(@Cast("hid_t") int type_id);
public static native @Cast("htri_t") int H5Tdetect_class(@Cast("hid_t") int type_id, @Cast("H5T_class_t") int cls);
public static native @Cast("size_t") long H5Tget_size(@Cast("hid_t") int type_id);
public static native @Cast("H5T_order_t") int H5Tget_order(@Cast("hid_t") int type_id);
public static native @Cast("size_t") long H5Tget_precision(@Cast("hid_t") int type_id);
public static native int H5Tget_offset(@Cast("hid_t") int type_id);
public static native @Cast("herr_t") int H5Tget_pad(@Cast("hid_t") int type_id, @Cast("H5T_pad_t*") IntPointer lsb,
			  @Cast("H5T_pad_t*") IntPointer msb);
public static native @Cast("herr_t") int H5Tget_pad(@Cast("hid_t") int type_id, @Cast("H5T_pad_t*") IntBuffer lsb,
			  @Cast("H5T_pad_t*") IntBuffer msb);
public static native @Cast("herr_t") int H5Tget_pad(@Cast("hid_t") int type_id, @Cast("H5T_pad_t*") int[] lsb,
			  @Cast("H5T_pad_t*") int[] msb);
public static native @Cast("H5T_sign_t") int H5Tget_sign(@Cast("hid_t") int type_id);
public static native @Cast("herr_t") int H5Tget_fields(@Cast("hid_t") int type_id, @Cast("size_t*") SizeTPointer spos,
			     @Cast("size_t*") SizeTPointer epos, @Cast("size_t*") SizeTPointer esize,
			     @Cast("size_t*") SizeTPointer mpos, @Cast("size_t*") SizeTPointer msize);
public static native @Cast("size_t") long H5Tget_ebias(@Cast("hid_t") int type_id);
public static native @Cast("H5T_norm_t") int H5Tget_norm(@Cast("hid_t") int type_id);
public static native @Cast("H5T_pad_t") int H5Tget_inpad(@Cast("hid_t") int type_id);
public static native @Cast("H5T_str_t") int H5Tget_strpad(@Cast("hid_t") int type_id);
public static native int H5Tget_nmembers(@Cast("hid_t") int type_id);
public static native @Cast("char*") BytePointer H5Tget_member_name(@Cast("hid_t") int type_id, @Cast("unsigned") int membno);
public static native int H5Tget_member_index(@Cast("hid_t") int type_id, @Cast("const char*") BytePointer name);
public static native int H5Tget_member_index(@Cast("hid_t") int type_id, String name);
public static native @Cast("size_t") long H5Tget_member_offset(@Cast("hid_t") int type_id, @Cast("unsigned") int membno);
public static native @Cast("H5T_class_t") int H5Tget_member_class(@Cast("hid_t") int type_id, @Cast("unsigned") int membno);
public static native @Cast("hid_t") int H5Tget_member_type(@Cast("hid_t") int type_id, @Cast("unsigned") int membno);
public static native @Cast("herr_t") int H5Tget_member_value(@Cast("hid_t") int type_id, @Cast("unsigned") int membno, Pointer value);
public static native @Cast("H5T_cset_t") int H5Tget_cset(@Cast("hid_t") int type_id);
public static native @Cast("htri_t") int H5Tis_variable_str(@Cast("hid_t") int type_id);
public static native @Cast("hid_t") int H5Tget_native_type(@Cast("hid_t") int type_id, @Cast("H5T_direction_t") int direction);

/* Setting property values */
public static native @Cast("herr_t") int H5Tset_size(@Cast("hid_t") int type_id, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Tset_order(@Cast("hid_t") int type_id, @Cast("H5T_order_t") int order);
public static native @Cast("herr_t") int H5Tset_precision(@Cast("hid_t") int type_id, @Cast("size_t") long prec);
public static native @Cast("herr_t") int H5Tset_offset(@Cast("hid_t") int type_id, @Cast("size_t") long offset);
public static native @Cast("herr_t") int H5Tset_pad(@Cast("hid_t") int type_id, @Cast("H5T_pad_t") int lsb, @Cast("H5T_pad_t") int msb);
public static native @Cast("herr_t") int H5Tset_sign(@Cast("hid_t") int type_id, @Cast("H5T_sign_t") int sign);
public static native @Cast("herr_t") int H5Tset_fields(@Cast("hid_t") int type_id, @Cast("size_t") long spos, @Cast("size_t") long epos,
			     @Cast("size_t") long esize, @Cast("size_t") long mpos, @Cast("size_t") long msize);
public static native @Cast("herr_t") int H5Tset_ebias(@Cast("hid_t") int type_id, @Cast("size_t") long ebias);
public static native @Cast("herr_t") int H5Tset_norm(@Cast("hid_t") int type_id, @Cast("H5T_norm_t") int norm);
public static native @Cast("herr_t") int H5Tset_inpad(@Cast("hid_t") int type_id, @Cast("H5T_pad_t") int pad);
public static native @Cast("herr_t") int H5Tset_cset(@Cast("hid_t") int type_id, @Cast("H5T_cset_t") int cset);
public static native @Cast("herr_t") int H5Tset_strpad(@Cast("hid_t") int type_id, @Cast("H5T_str_t") int strpad);

/* Type conversion database */
public static native @Cast("herr_t") int H5Tregister(@Cast("H5T_pers_t") int pers, @Cast("const char*") BytePointer name, @Cast("hid_t") int src_id,
			   @Cast("hid_t") int dst_id, H5T_conv_t func);
public static native @Cast("herr_t") int H5Tregister(@Cast("H5T_pers_t") int pers, String name, @Cast("hid_t") int src_id,
			   @Cast("hid_t") int dst_id, H5T_conv_t func);
public static native @Cast("herr_t") int H5Tunregister(@Cast("H5T_pers_t") int pers, @Cast("const char*") BytePointer name, @Cast("hid_t") int src_id,
			     @Cast("hid_t") int dst_id, H5T_conv_t func);
public static native @Cast("herr_t") int H5Tunregister(@Cast("H5T_pers_t") int pers, String name, @Cast("hid_t") int src_id,
			     @Cast("hid_t") int dst_id, H5T_conv_t func);
public static native H5T_conv_t H5Tfind(@Cast("hid_t") int src_id, @Cast("hid_t") int dst_id, @Cast("H5T_cdata_t**") PointerPointer pcdata);
public static native H5T_conv_t H5Tfind(@Cast("hid_t") int src_id, @Cast("hid_t") int dst_id, @ByPtrPtr H5T_cdata_t pcdata);
public static native @Cast("htri_t") int H5Tcompiler_conv(@Cast("hid_t") int src_id, @Cast("hid_t") int dst_id);
public static native @Cast("herr_t") int H5Tconvert(@Cast("hid_t") int src_id, @Cast("hid_t") int dst_id, @Cast("size_t") long nelmts,
			  Pointer buf, Pointer background, @Cast("hid_t") int plist_id);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Tpublic_H */



// Parsed from H5Lpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5Lpublic.h
 *                      Dec 1 2005
 *                      James Laird
 *
 * Purpose:             Public declarations for the H5L package (links)
 *
 *-------------------------------------------------------------------------
 */
// #ifndef _H5Lpublic_H
// #define _H5Lpublic_H

/* Public headers needed by this file */
// #include "H5public.h"		/* Generic Functions			*/
// #include "H5Ipublic.h"		/* IDs			  		*/
// #include "H5Tpublic.h"		/* Datatypes				*/

/*****************/
/* Public Macros */
/*****************/

/* Maximum length of a link's name */
/* (encoded in a 32-bit unsigned integer) */
public static native @MemberGetter int H5L_MAX_LINK_NAME_LEN();
public static final int H5L_MAX_LINK_NAME_LEN = H5L_MAX_LINK_NAME_LEN();  /* (4GB - 1) */

/* Macro to indicate operation occurs on same location */
public static native @MemberGetter int H5L_SAME_LOC();
public static final int H5L_SAME_LOC = H5L_SAME_LOC();

/* Current version of the H5L_class_t struct */
public static final int H5L_LINK_CLASS_T_VERS = 0;

// #ifdef __cplusplus
// #endif

/*******************/
/* Public Typedefs */
/*******************/

/* Link class types.
 * Values less than 64 are reserved for the HDF5 library's internal use.
 * Values 64 to 255 are for "user-defined" link class types; these types are
 * defined by HDF5 but their behavior can be overridden by users.
 * Users who want to create new classes of links should contact the HDF5
 * development team at hdfhelp@ncsa.uiuc.edu .
 * These values can never change because they appear in HDF5 files.
 */
/** enum H5L_type_t */
public static final int
    H5L_TYPE_ERROR =  (-1),      /* Invalid link type id         */
    H5L_TYPE_HARD = 0,          /* Hard link id                 */
    H5L_TYPE_SOFT = 1,          /* Soft link id                 */
    H5L_TYPE_EXTERNAL = 64,     /* External link id             */
    H5L_TYPE_MAX = 255;	        /* Maximum link type id         */
public static final int H5L_TYPE_BUILTIN_MAX = H5L_TYPE_SOFT;      /* Maximum value link value for "built-in" link types */
public static final int H5L_TYPE_UD_MIN =      H5L_TYPE_EXTERNAL;  /* Link ids at or above this value are "user-defined" link types. */

/* Information struct for link (for H5Lget_info/H5Lget_info_by_idx) */
public static class H5L_info_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5L_info_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5L_info_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5L_info_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5L_info_t position(long position) {
        return (H5L_info_t)super.position(position);
    }

    public native @Cast("H5L_type_t") int type(); public native H5L_info_t type(int type);           /* Type of link                   */
    public native @Cast("hbool_t") boolean corder_valid(); public native H5L_info_t corder_valid(boolean corder_valid);   /* Indicate if creation order is valid */
    public native @Cast("int64_t") int corder(); public native H5L_info_t corder(int corder);         /* Creation order                 */
    public native @Cast("H5T_cset_t") int cset(); public native H5L_info_t cset(int cset);           /* Character set of link name     */
        @Name("u.address") public native @Cast("haddr_t") long u_address(); public native H5L_info_t u_address(long u_address);        /* Address hard link points to    */
        @Name("u.val_size") public native @Cast("size_t") long u_val_size(); public native H5L_info_t u_val_size(long u_val_size);       /* Size of a soft link or UD link value */
}

/* The H5L_class_t struct can be used to override the behavior of a
 * "user-defined" link class. Users should populate the struct with callback
 * functions defined below.
 */
/* Callback prototypes for user-defined links */
/* Link creation callback */
public static class H5L_create_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5L_create_func_t(Pointer p) { super(p); }
    protected H5L_create_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("const char*") BytePointer link_name, @Cast("hid_t") int loc_group,
    @Const Pointer lnkdata, @Cast("size_t") long lnkdata_size, @Cast("hid_t") int lcpl_id);
}

/* Callback for when the link is moved */
public static class H5L_move_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5L_move_func_t(Pointer p) { super(p); }
    protected H5L_move_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("const char*") BytePointer new_name, @Cast("hid_t") int new_loc,
    @Const Pointer lnkdata, @Cast("size_t") long lnkdata_size);
}

/* Callback for when the link is copied */
public static class H5L_copy_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5L_copy_func_t(Pointer p) { super(p); }
    protected H5L_copy_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("const char*") BytePointer new_name, @Cast("hid_t") int new_loc,
    @Const Pointer lnkdata, @Cast("size_t") long lnkdata_size);
}

/* Callback during link traversal */
public static class H5L_traverse_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5L_traverse_func_t(Pointer p) { super(p); }
    protected H5L_traverse_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("hid_t") int call(@Cast("const char*") BytePointer link_name, @Cast("hid_t") int cur_group,
    @Const Pointer lnkdata, @Cast("size_t") long lnkdata_size, @Cast("hid_t") int lapl_id);
}

/* Callback for when the link is deleted */
public static class H5L_delete_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5L_delete_func_t(Pointer p) { super(p); }
    protected H5L_delete_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("const char*") BytePointer link_name, @Cast("hid_t") int file,
    @Const Pointer lnkdata, @Cast("size_t") long lnkdata_size);
}

/* Callback for querying the link */
/* Returns the size of the buffer needed */
public static class H5L_query_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5L_query_func_t(Pointer p) { super(p); }
    protected H5L_query_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("ssize_t") int call(@Cast("const char*") BytePointer link_name, @Const Pointer lnkdata,
    @Cast("size_t") long lnkdata_size, Pointer buf, @Cast("size_t") long buf_size);
}

/* User-defined link types */
public static class H5L_class_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5L_class_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5L_class_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5L_class_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5L_class_t position(long position) {
        return (H5L_class_t)super.position(position);
    }

    public native int version(); public native H5L_class_t version(int version);                    /* Version number of this struct        */
    public native @Cast("H5L_type_t") int id(); public native H5L_class_t id(int id);                  /* Link type ID                         */
    @MemberGetter public native @Cast("const char*") BytePointer comment();            /* Comment for debugging                */
    public native H5L_create_func_t create_func(); public native H5L_class_t create_func(H5L_create_func_t create_func);  /* Callback during link creation        */
    public native H5L_move_func_t move_func(); public native H5L_class_t move_func(H5L_move_func_t move_func);      /* Callback after moving link           */
    public native H5L_copy_func_t copy_func(); public native H5L_class_t copy_func(H5L_copy_func_t copy_func);      /* Callback after copying link          */
    public native H5L_traverse_func_t trav_func(); public native H5L_class_t trav_func(H5L_traverse_func_t trav_func);  /* Callback during link traversal       */
    public native H5L_delete_func_t del_func(); public native H5L_class_t del_func(H5L_delete_func_t del_func);     /* Callback for link deletion           */
    public native H5L_query_func_t query_func(); public native H5L_class_t query_func(H5L_query_func_t query_func);    /* Callback for queries                 */
}

/* Prototype for H5Literate/H5Literate_by_name() operator */
public static class H5L_iterate_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5L_iterate_t(Pointer p) { super(p); }
    protected H5L_iterate_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int group, @Cast("const char*") BytePointer name, @Const H5L_info_t info,
    Pointer op_data);
}

/* Callback for external link traversal */
public static class H5L_elink_traverse_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5L_elink_traverse_t(Pointer p) { super(p); }
    protected H5L_elink_traverse_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("const char*") BytePointer parent_file_name,
    @Cast("const char*") BytePointer parent_group_name, @Cast("const char*") BytePointer child_file_name,
    @Cast("const char*") BytePointer child_object_name, @Cast("unsigned*") IntPointer acc_flags, @Cast("hid_t") int fapl_id,
    Pointer op_data);
}


/********************/
/* Public Variables */
/********************/


/*********************/
/* Public Prototypes */
/*********************/
public static native @Cast("herr_t") int H5Lmove(@Cast("hid_t") int src_loc, @Cast("const char*") BytePointer src_name, @Cast("hid_t") int dst_loc,
    @Cast("const char*") BytePointer dst_name, @Cast("hid_t") int lcpl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lmove(@Cast("hid_t") int src_loc, String src_name, @Cast("hid_t") int dst_loc,
    String dst_name, @Cast("hid_t") int lcpl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lcopy(@Cast("hid_t") int src_loc, @Cast("const char*") BytePointer src_name, @Cast("hid_t") int dst_loc,
    @Cast("const char*") BytePointer dst_name, @Cast("hid_t") int lcpl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lcopy(@Cast("hid_t") int src_loc, String src_name, @Cast("hid_t") int dst_loc,
    String dst_name, @Cast("hid_t") int lcpl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lcreate_hard(@Cast("hid_t") int cur_loc, @Cast("const char*") BytePointer cur_name,
    @Cast("hid_t") int dst_loc, @Cast("const char*") BytePointer dst_name, @Cast("hid_t") int lcpl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lcreate_hard(@Cast("hid_t") int cur_loc, String cur_name,
    @Cast("hid_t") int dst_loc, String dst_name, @Cast("hid_t") int lcpl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lcreate_soft(@Cast("const char*") BytePointer link_target, @Cast("hid_t") int link_loc_id,
    @Cast("const char*") BytePointer link_name, @Cast("hid_t") int lcpl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lcreate_soft(String link_target, @Cast("hid_t") int link_loc_id,
    String link_name, @Cast("hid_t") int lcpl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Ldelete(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Ldelete(@Cast("hid_t") int loc_id, String name, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Ldelete_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Ldelete_by_idx(@Cast("hid_t") int loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lget_val(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name, Pointer buf,
    @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lget_val(@Cast("hid_t") int loc_id, String name, Pointer buf,
    @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lget_val_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    Pointer buf, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lget_val_by_idx(@Cast("hid_t") int loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    Pointer buf, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("htri_t") int H5Lexists(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") int lapl_id);
public static native @Cast("htri_t") int H5Lexists(@Cast("hid_t") int loc_id, String name, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lget_info(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name,
    H5L_info_t linfo, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lget_info(@Cast("hid_t") int loc_id, String name,
    H5L_info_t linfo, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lget_info_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    H5L_info_t linfo, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lget_info_by_idx(@Cast("hid_t") int loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    H5L_info_t linfo, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Lget_name_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") BytePointer name, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Lget_name_by_idx(@Cast("hid_t") int loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") ByteBuffer name, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Lget_name_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") byte[] name, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Lget_name_by_idx(@Cast("hid_t") int loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") BytePointer name, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Lget_name_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") ByteBuffer name, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Lget_name_by_idx(@Cast("hid_t") int loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") byte[] name, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Literate(@Cast("hid_t") int grp_id, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx, H5L_iterate_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Literate(@Cast("hid_t") int grp_id, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx, H5L_iterate_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Literate(@Cast("hid_t") int grp_id, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx, H5L_iterate_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Literate_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx,
    H5L_iterate_t op, Pointer op_data, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name(@Cast("hid_t") int loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx,
    H5L_iterate_t op, Pointer op_data, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx,
    H5L_iterate_t op, Pointer op_data, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name(@Cast("hid_t") int loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx,
    H5L_iterate_t op, Pointer op_data, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx,
    H5L_iterate_t op, Pointer op_data, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name(@Cast("hid_t") int loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx,
    H5L_iterate_t op, Pointer op_data, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lvisit(@Cast("hid_t") int grp_id, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order,
    H5L_iterate_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Lvisit_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, H5L_iterate_t op,
    Pointer op_data, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lvisit_by_name(@Cast("hid_t") int loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, H5L_iterate_t op,
    Pointer op_data, @Cast("hid_t") int lapl_id);

/* UD link functions */
public static native @Cast("herr_t") int H5Lcreate_ud(@Cast("hid_t") int link_loc_id, @Cast("const char*") BytePointer link_name,
    @Cast("H5L_type_t") int link_type, @Const Pointer udata, @Cast("size_t") long udata_size, @Cast("hid_t") int lcpl_id,
    @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lcreate_ud(@Cast("hid_t") int link_loc_id, String link_name,
    @Cast("H5L_type_t") int link_type, @Const Pointer udata, @Cast("size_t") long udata_size, @Cast("hid_t") int lcpl_id,
    @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lregister(@Const H5L_class_t cls);
public static native @Cast("herr_t") int H5Lunregister(@Cast("H5L_type_t") int id);
public static native @Cast("htri_t") int H5Lis_registered(@Cast("H5L_type_t") int id);

/* External link functions */
public static native @Cast("herr_t") int H5Lunpack_elink_val(@Const Pointer ext_linkval, @Cast("size_t") long link_size,
   @Cast("unsigned*") IntPointer flags, @Cast("const char**") PointerPointer filename, @Cast("const char**") PointerPointer obj_path);
public static native @Cast("herr_t") int H5Lunpack_elink_val(@Const Pointer ext_linkval, @Cast("size_t") long link_size,
   @Cast("unsigned*") IntPointer flags, @Cast("const char**") @ByPtrPtr BytePointer filename, @Cast("const char**") @ByPtrPtr BytePointer obj_path);
public static native @Cast("herr_t") int H5Lunpack_elink_val(@Const Pointer ext_linkval, @Cast("size_t") long link_size,
   @Cast("unsigned*") IntBuffer flags, @Cast("const char**") @ByPtrPtr ByteBuffer filename, @Cast("const char**") @ByPtrPtr ByteBuffer obj_path);
public static native @Cast("herr_t") int H5Lunpack_elink_val(@Const Pointer ext_linkval, @Cast("size_t") long link_size,
   @Cast("unsigned*") int[] flags, @Cast("const char**") @ByPtrPtr byte[] filename, @Cast("const char**") @ByPtrPtr byte[] obj_path);
public static native @Cast("herr_t") int H5Lcreate_external(@Cast("const char*") BytePointer file_name, @Cast("const char*") BytePointer obj_name,
    @Cast("hid_t") int link_loc_id, @Cast("const char*") BytePointer link_name, @Cast("hid_t") int lcpl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Lcreate_external(String file_name, String obj_name,
    @Cast("hid_t") int link_loc_id, String link_name, @Cast("hid_t") int lcpl_id, @Cast("hid_t") int lapl_id);

// #ifdef __cplusplus
// #endif
// #endif /* _H5Lpublic_H */



// Parsed from H5Opublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5Opublic.h
 *                      Aug  5 1997
 *                      Robb Matzke <matzke@llnl.gov>
 *
 * Purpose:             Public declarations for the H5O (object header)
 *                      package.
 *
 *-------------------------------------------------------------------------
 */
// #ifndef _H5Opublic_H
// #define _H5Opublic_H

/* Public headers needed by this file */
// #include "H5public.h"		/* Generic Functions			*/
// #include "H5Ipublic.h"		/* IDs			  		*/
// #include "H5Lpublic.h"		/* Links		  		*/

/*****************/
/* Public Macros */
/*****************/

/* Flags for object copy (H5Ocopy) */
public static final int H5O_COPY_SHALLOW_HIERARCHY_FLAG = (0x0001);   /* Copy only immediate members */
public static final int H5O_COPY_EXPAND_SOFT_LINK_FLAG =  (0x0002);   /* Expand soft links into new objects */
public static final int H5O_COPY_EXPAND_EXT_LINK_FLAG =   (0x0004);   /* Expand external links into new objects */
public static final int H5O_COPY_EXPAND_REFERENCE_FLAG =	(0x0008);   /* Copy objects that are pointed by references */
public static final int H5O_COPY_WITHOUT_ATTR_FLAG =      (0x0010);   /* Copy object without copying attributes */
public static final int H5O_COPY_PRESERVE_NULL_FLAG =     (0x0020);   /* Copy NULL messages (empty space) */
public static final int H5O_COPY_MERGE_COMMITTED_DTYPE_FLAG = (0x0040);   /* Merge committed datatypes in dest file */
public static final int H5O_COPY_ALL =                    (0x007F);   /* All object copying flags (for internal checking) */

/* Flags for shared message indexes.
 * Pass these flags in using the mesg_type_flags parameter in
 * H5P_set_shared_mesg_index.
 * (Developers: These flags correspond to object header message type IDs,
 * but we need to assign each kind of message to a different bit so that
 * one index can hold multiple types.)
 */
public static final int H5O_SHMESG_NONE_FLAG =    0x0000;          /* No shared messages */
public static native @MemberGetter int H5O_SHMESG_SDSPACE_FLAG();
public static final int H5O_SHMESG_SDSPACE_FLAG = H5O_SHMESG_SDSPACE_FLAG(); /* Simple Dataspace Message.  */
public static native @MemberGetter int H5O_SHMESG_DTYPE_FLAG();
public static final int H5O_SHMESG_DTYPE_FLAG = H5O_SHMESG_DTYPE_FLAG(); /* Datatype Message.  */
public static native @MemberGetter int H5O_SHMESG_FILL_FLAG();
public static final int H5O_SHMESG_FILL_FLAG = H5O_SHMESG_FILL_FLAG(); /* Fill Value Message. */
public static native @MemberGetter int H5O_SHMESG_PLINE_FLAG();
public static final int H5O_SHMESG_PLINE_FLAG = H5O_SHMESG_PLINE_FLAG(); /* Filter pipeline message.  */
public static native @MemberGetter int H5O_SHMESG_ATTR_FLAG();
public static final int H5O_SHMESG_ATTR_FLAG = H5O_SHMESG_ATTR_FLAG(); /* Attribute Message.  */
public static final int H5O_SHMESG_ALL_FLAG =     (H5O_SHMESG_SDSPACE_FLAG | H5O_SHMESG_DTYPE_FLAG | H5O_SHMESG_FILL_FLAG | H5O_SHMESG_PLINE_FLAG | H5O_SHMESG_ATTR_FLAG);

/* Object header status flag definitions */
public static final int H5O_HDR_CHUNK0_SIZE =             0x03;    /* 2-bit field indicating # of bytes to store the size of chunk 0's data */
public static final int H5O_HDR_ATTR_CRT_ORDER_TRACKED =  0x04;    /* Attribute creation order is tracked */
public static final int H5O_HDR_ATTR_CRT_ORDER_INDEXED =  0x08;    /* Attribute creation order has index */
public static final int H5O_HDR_ATTR_STORE_PHASE_CHANGE = 0x10;    /* Non-default attribute storage phase change values stored */
public static final int H5O_HDR_STORE_TIMES =             0x20;    /* Store access, modification, change & birth times for object */
public static final int H5O_HDR_ALL_FLAGS =       (H5O_HDR_CHUNK0_SIZE | H5O_HDR_ATTR_CRT_ORDER_TRACKED | H5O_HDR_ATTR_CRT_ORDER_INDEXED | H5O_HDR_ATTR_STORE_PHASE_CHANGE | H5O_HDR_STORE_TIMES);

/* Maximum shared message values.  Number of indexes is 8 to allow room to add
 * new types of messages.
 */
public static final int H5O_SHMESG_MAX_NINDEXES = 8;
public static final int H5O_SHMESG_MAX_LIST_SIZE = 5000;

/*******************/
/* Public Typedefs */
/*******************/

/* Types of objects in file */
/** enum H5O_type_t */
public static final int
    H5O_TYPE_UNKNOWN = -1,	/* Unknown object type		*/
    H5O_TYPE_GROUP = 0,	        /* Object is a group		*/
    H5O_TYPE_DATASET = 1,		/* Object is a dataset		*/
    H5O_TYPE_NAMED_DATATYPE = 2, 	/* Object is a named data type	*/
    H5O_TYPE_NTYPES = 3;             /* Number of different object types (must be last!) */

/* Information struct for object header metadata (for H5Oget_info/H5Oget_info_by_name/H5Oget_info_by_idx) */
public static class H5O_hdr_info_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5O_hdr_info_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5O_hdr_info_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5O_hdr_info_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5O_hdr_info_t position(long position) {
        return (H5O_hdr_info_t)super.position(position);
    }

    public native @Cast("unsigned") int version(); public native H5O_hdr_info_t version(int version);		/* Version number of header format in file */
    public native @Cast("unsigned") int nmesgs(); public native H5O_hdr_info_t nmesgs(int nmesgs);		/* Number of object header messages */
    public native @Cast("unsigned") int nchunks(); public native H5O_hdr_info_t nchunks(int nchunks);		/* Number of object header chunks */
    public native @Cast("unsigned") int flags(); public native H5O_hdr_info_t flags(int flags);             /* Object header status flags */
        @Name("space.total") public native @Cast("hsize_t") long space_total(); public native H5O_hdr_info_t space_total(long space_total);		/* Total space for storing object header in file */
        @Name("space.meta") public native @Cast("hsize_t") long space_meta(); public native H5O_hdr_info_t space_meta(long space_meta);		/* Space within header for object header metadata information */
        @Name("space.mesg") public native @Cast("hsize_t") long space_mesg(); public native H5O_hdr_info_t space_mesg(long space_mesg);		/* Space within header for actual message information */
        @Name("space.free") public native @Cast("hsize_t") long space_free(); public native H5O_hdr_info_t space_free(long space_free);		/* Free space within object header */
        @Name("mesg.present") public native @Cast("uint64_t") int mesg_present(); public native H5O_hdr_info_t mesg_present(int mesg_present);	/* Flags to indicate presence of message type in header */
        @Name("mesg.shared") public native @Cast("uint64_t") int mesg_shared(); public native H5O_hdr_info_t mesg_shared(int mesg_shared);	/* Flags to indicate message type is shared in header */
}

/* Information struct for object (for H5Oget_info/H5Oget_info_by_name/H5Oget_info_by_idx) */
public static class H5O_info_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5O_info_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5O_info_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5O_info_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5O_info_t position(long position) {
        return (H5O_info_t)super.position(position);
    }

    public native @Cast("unsigned long") long fileno(); public native H5O_info_t fileno(long fileno);		/* File number that object is located in */
    public native @Cast("haddr_t") long addr(); public native H5O_info_t addr(long addr);		/* Object address in file	*/
    public native @Cast("H5O_type_t") int type(); public native H5O_info_t type(int type);		/* Basic object type (group, dataset, etc.) */
    public native @Cast("unsigned") int rc(); public native H5O_info_t rc(int rc);		/* Reference count of object    */
    public native @ByRef @Cast("time_t*") Pointer atime(); public native H5O_info_t atime(Pointer atime);		/* Access time			*/
    public native @ByRef @Cast("time_t*") Pointer mtime(); public native H5O_info_t mtime(Pointer mtime);		/* Modification time		*/
    public native @ByRef @Cast("time_t*") Pointer ctime(); public native H5O_info_t ctime(Pointer ctime);		/* Change time			*/
    public native @ByRef @Cast("time_t*") Pointer btime(); public native H5O_info_t btime(Pointer btime);		/* Birth time			*/
    public native @Cast("hsize_t") long num_attrs(); public native H5O_info_t num_attrs(long num_attrs);	/* # of attributes attached to object */
    public native @ByRef H5O_hdr_info_t hdr(); public native H5O_info_t hdr(H5O_hdr_info_t hdr);            /* Object header information */
    /* Extra metadata storage for obj & attributes */
        @Name("meta_size.obj") public native @ByRef H5_ih_info_t meta_size_obj(); public native H5O_info_t meta_size_obj(H5_ih_info_t meta_size_obj);             /* v1/v2 B-tree & local/fractal heap for groups, B-tree for chunked datasets */
        @Name("meta_size.attr") public native @ByRef H5_ih_info_t meta_size_attr(); public native H5O_info_t meta_size_attr(H5_ih_info_t meta_size_attr);            /* v2 B-tree & heap for attributes */
}

/* Typedef for message creation indexes */

/* Prototype for H5Ovisit/H5Ovisit_by_name() operator */
public static class H5O_iterate_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5O_iterate_t(Pointer p) { super(p); }
    protected H5O_iterate_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int obj, @Cast("const char*") BytePointer name, @Const H5O_info_t info,
    Pointer op_data);
}

/** enum H5O_mcdt_search_ret_t */
public static final int
    H5O_MCDT_SEARCH_ERROR = -1,	/* Abort H5Ocopy */
    H5O_MCDT_SEARCH_CONT = 0,	/* Continue the global search of all committed datatypes in the destination file */
    H5O_MCDT_SEARCH_STOP = 1;	/* Stop the search, but continue copying.  The committed datatype will be copied but not merged. */

/* Callback to invoke when completing the search for a matching committed datatype from the committed dtype list */
public static class H5O_mcdt_search_cb_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5O_mcdt_search_cb_t(Pointer p) { super(p); }
    protected H5O_mcdt_search_cb_t() { allocate(); }
    private native void allocate();
    public native @Cast("H5O_mcdt_search_ret_t") int call(Pointer op_data);
}

/********************/
/* Public Variables */
/********************/


// #ifdef __cplusplus
// #endif

/*********************/
/* Public Prototypes */
/*********************/
public static native @Cast("hid_t") int H5Oopen(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") int lapl_id);
public static native @Cast("hid_t") int H5Oopen(@Cast("hid_t") int loc_id, String name, @Cast("hid_t") int lapl_id);
public static native @Cast("hid_t") int H5Oopen_by_addr(@Cast("hid_t") int loc_id, @Cast("haddr_t") long addr);
public static native @Cast("hid_t") int H5Oopen_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") int lapl_id);
public static native @Cast("hid_t") int H5Oopen_by_idx(@Cast("hid_t") int loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") int lapl_id);
public static native @Cast("htri_t") int H5Oexists_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") int lapl_id);
public static native @Cast("htri_t") int H5Oexists_by_name(@Cast("hid_t") int loc_id, String name, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Oget_info(@Cast("hid_t") int loc_id, H5O_info_t oinfo);
public static native @Cast("herr_t") int H5Oget_info_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name, H5O_info_t oinfo,
    @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Oget_info_by_name(@Cast("hid_t") int loc_id, String name, H5O_info_t oinfo,
    @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Oget_info_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5O_info_t oinfo,
    @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Oget_info_by_idx(@Cast("hid_t") int loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5O_info_t oinfo,
    @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Olink(@Cast("hid_t") int obj_id, @Cast("hid_t") int new_loc_id, @Cast("const char*") BytePointer new_name,
    @Cast("hid_t") int lcpl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Olink(@Cast("hid_t") int obj_id, @Cast("hid_t") int new_loc_id, String new_name,
    @Cast("hid_t") int lcpl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Oincr_refcount(@Cast("hid_t") int object_id);
public static native @Cast("herr_t") int H5Odecr_refcount(@Cast("hid_t") int object_id);
public static native @Cast("herr_t") int H5Ocopy(@Cast("hid_t") int src_loc_id, @Cast("const char*") BytePointer src_name, @Cast("hid_t") int dst_loc_id,
    @Cast("const char*") BytePointer dst_name, @Cast("hid_t") int ocpypl_id, @Cast("hid_t") int lcpl_id);
public static native @Cast("herr_t") int H5Ocopy(@Cast("hid_t") int src_loc_id, String src_name, @Cast("hid_t") int dst_loc_id,
    String dst_name, @Cast("hid_t") int ocpypl_id, @Cast("hid_t") int lcpl_id);
public static native @Cast("herr_t") int H5Oset_comment(@Cast("hid_t") int obj_id, @Cast("const char*") BytePointer comment);
public static native @Cast("herr_t") int H5Oset_comment(@Cast("hid_t") int obj_id, String comment);
public static native @Cast("herr_t") int H5Oset_comment_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name,
    @Cast("const char*") BytePointer comment, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Oset_comment_by_name(@Cast("hid_t") int loc_id, String name,
    String comment, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Oget_comment(@Cast("hid_t") int obj_id, @Cast("char*") BytePointer comment, @Cast("size_t") long bufsize);
public static native @Cast("ssize_t") int H5Oget_comment(@Cast("hid_t") int obj_id, @Cast("char*") ByteBuffer comment, @Cast("size_t") long bufsize);
public static native @Cast("ssize_t") int H5Oget_comment(@Cast("hid_t") int obj_id, @Cast("char*") byte[] comment, @Cast("size_t") long bufsize);
public static native @Cast("ssize_t") int H5Oget_comment_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name,
    @Cast("char*") BytePointer comment, @Cast("size_t") long bufsize, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Oget_comment_by_name(@Cast("hid_t") int loc_id, String name,
    @Cast("char*") ByteBuffer comment, @Cast("size_t") long bufsize, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Oget_comment_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name,
    @Cast("char*") byte[] comment, @Cast("size_t") long bufsize, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Oget_comment_by_name(@Cast("hid_t") int loc_id, String name,
    @Cast("char*") BytePointer comment, @Cast("size_t") long bufsize, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Oget_comment_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name,
    @Cast("char*") ByteBuffer comment, @Cast("size_t") long bufsize, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Oget_comment_by_name(@Cast("hid_t") int loc_id, String name,
    @Cast("char*") byte[] comment, @Cast("size_t") long bufsize, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Ovisit(@Cast("hid_t") int obj_id, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order,
    H5O_iterate_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Ovisit_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, H5O_iterate_t op,
    Pointer op_data, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Ovisit_by_name(@Cast("hid_t") int loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, H5O_iterate_t op,
    Pointer op_data, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Oclose(@Cast("hid_t") int object_id);
public static native @Cast("herr_t") int H5Oflush(@Cast("hid_t") int obj_id);
public static native @Cast("herr_t") int H5Orefresh(@Cast("hid_t") int oid);
public static native @Cast("herr_t") int H5Odisable_mdc_flushes(@Cast("hid_t") int object_id);
public static native @Cast("herr_t") int H5Oenable_mdc_flushes(@Cast("hid_t") int object_id);
public static native @Cast("herr_t") int H5Oare_mdc_flushes_disabled(@Cast("hid_t") int object_id, @Cast("hbool_t*") BoolPointer are_disabled);
public static native @Cast("herr_t") int H5Oare_mdc_flushes_disabled(@Cast("hid_t") int object_id, @Cast("hbool_t*") boolean[] are_disabled);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Opublic_H */



// Parsed from H5Zpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Thursday, April 16, 1998
 */

// #ifndef _H5Zpublic_H
// #define _H5Zpublic_H

/* Public headers needed by this file */
// #include "H5public.h"

/*
 * Filter identifiers.  Values 0 through 255 are for filters defined by the
 * HDF5 library.  Values 256 through 511 are available for testing new
 * filters. Subsequent values should be obtained from the HDF5 development
 * team at hdf5dev@ncsa.uiuc.edu.  These values will never change because they
 * appear in the HDF5 files.
 */

/* Filter IDs */
public static final int H5Z_FILTER_ERROR =	(-1);	/*no filter			*/
public static final int H5Z_FILTER_NONE =		0;	/*reserved indefinitely		*/
public static final int H5Z_FILTER_DEFLATE =	1; 	/*deflation like gzip	     	*/
public static final int H5Z_FILTER_SHUFFLE =      2;       /*shuffle the data              */
public static final int H5Z_FILTER_FLETCHER32 =   3;       /*fletcher32 checksum of EDC    */
public static final int H5Z_FILTER_SZIP =         4;       /*szip compression              */
public static final int H5Z_FILTER_NBIT =         5;       /*nbit compression              */
public static final int H5Z_FILTER_SCALEOFFSET =  6;       /*scale+offset compression      */
public static final int H5Z_FILTER_RESERVED =     256;	/*filter ids below this value are reserved for library use */

public static final int H5Z_FILTER_MAX =		65535;	/*maximum filter id		*/

/* General macros */
public static final int H5Z_FILTER_ALL =	 	0;	/* Symbol to remove all filters in H5Premove_filter */
public static final int H5Z_MAX_NFILTERS =        32;      /* Maximum number of filters allowed in a pipeline */
                                        /* (should probably be allowed to be an
                                         * unlimited amount, but currently each
                                         * filter uses a bit in a 32-bit field,
                                         * so the format would have to be
                                         * changed to accomodate that)
                                         */

/* Flags for filter definition (stored) */
public static final int H5Z_FLAG_DEFMASK =	0x00ff;	/*definition flag mask		*/
public static final int H5Z_FLAG_MANDATORY =      0x0000;  /*filter is mandatory		*/
public static final int H5Z_FLAG_OPTIONAL =	0x0001;	/*filter is optional		*/

/* Additional flags for filter invocation (not stored) */
public static final int H5Z_FLAG_INVMASK =	0xff00;	/*invocation flag mask		*/
public static final int H5Z_FLAG_REVERSE =	0x0100;	/*reverse direction; read	*/
public static final int H5Z_FLAG_SKIP_EDC =	0x0200;	/*skip EDC filters for read	*/

/* Special parameters for szip compression */
/* [These are aliases for the similar definitions in szlib.h, which we can't
 * include directly due to the duplication of various symbols with the zlib.h
 * header file] */
public static final int H5_SZIP_ALLOW_K13_OPTION_MASK =   1;
public static final int H5_SZIP_CHIP_OPTION_MASK =        2;
public static final int H5_SZIP_EC_OPTION_MASK =          4;
public static final int H5_SZIP_NN_OPTION_MASK =          32;
public static final int H5_SZIP_MAX_PIXELS_PER_BLOCK =    32;

/* Macros for the shuffle filter */
public static final int H5Z_SHUFFLE_USER_NPARMS =    0;    /* Number of parameters that users can set */
public static final int H5Z_SHUFFLE_TOTAL_NPARMS =   1;    /* Total number of parameters for filter */

/* Macros for the szip filter */
public static final int H5Z_SZIP_USER_NPARMS =    2;       /* Number of parameters that users can set */
public static final int H5Z_SZIP_TOTAL_NPARMS =   4;       /* Total number of parameters for filter */
public static final int H5Z_SZIP_PARM_MASK =      0;       /* "User" parameter for option mask */
public static final int H5Z_SZIP_PARM_PPB =       1;       /* "User" parameter for pixels-per-block */
public static final int H5Z_SZIP_PARM_BPP =       2;       /* "Local" parameter for bits-per-pixel */
public static final int H5Z_SZIP_PARM_PPS =       3;       /* "Local" parameter for pixels-per-scanline */

/* Macros for the nbit filter */
public static final int H5Z_NBIT_USER_NPARMS =     0;     /* Number of parameters that users can set */

/* Macros for the scale offset filter */
public static final int H5Z_SCALEOFFSET_USER_NPARMS =      2;    /* Number of parameters that users can set */


/* Special parameters for ScaleOffset filter*/
public static final int H5Z_SO_INT_MINBITS_DEFAULT = 0;
/** enum H5Z_SO_scale_type_t */
public static final int
    H5Z_SO_FLOAT_DSCALE = 0,
    H5Z_SO_FLOAT_ESCALE = 1,
    H5Z_SO_INT          = 2;

/* Current version of the H5Z_class_t struct */
public static final int H5Z_CLASS_T_VERS = (1);

/* Values to decide if EDC is enabled for reading data */
/** enum H5Z_EDC_t */
public static final int
    H5Z_ERROR_EDC       = -1,   /* error value */
    H5Z_DISABLE_EDC     = 0,
    H5Z_ENABLE_EDC      = 1,
    H5Z_NO_EDC          = 2;     /* must be the last */

/* Bit flags for H5Zget_filter_info */
public static final int H5Z_FILTER_CONFIG_ENCODE_ENABLED = (0x0001);
public static final int H5Z_FILTER_CONFIG_DECODE_ENABLED = (0x0002);

/* Return values for filter callback function */
/** enum H5Z_cb_return_t */
public static final int
    H5Z_CB_ERROR  = -1,
    H5Z_CB_FAIL   = 0,    /* I/O should fail if filter fails. */
    H5Z_CB_CONT   = 1,    /* I/O continues if filter fails.   */
    H5Z_CB_NO     = 2;

/* Filter callback function definition */
public static class H5Z_filter_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5Z_filter_func_t(Pointer p) { super(p); }
    protected H5Z_filter_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("H5Z_cb_return_t") int call(@Cast("H5Z_filter_t") int filter, Pointer buf,
                                @Cast("size_t") long buf_size, Pointer op_data);
}

/* Structure for filter callback property */
public static class H5Z_cb_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5Z_cb_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5Z_cb_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5Z_cb_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5Z_cb_t position(long position) {
        return (H5Z_cb_t)super.position(position);
    }

    public native H5Z_filter_func_t func(); public native H5Z_cb_t func(H5Z_filter_func_t func);
    public native Pointer op_data(); public native H5Z_cb_t op_data(Pointer op_data);
}

// #ifdef __cplusplus
// #endif

/*
 * Before a dataset gets created, the "can_apply" callbacks for any filters used
 * in the dataset creation property list are called
 * with the dataset's dataset creation property list, the dataset's datatype and
 * a dataspace describing a chunk (for chunked dataset storage).
 *
 * The "can_apply" callback must determine if the combination of the dataset
 * creation property list setting, the datatype and the dataspace represent a
 * valid combination to apply this filter to.  For example, some cases of
 * invalid combinations may involve the filter not operating correctly on
 * certain datatypes (or certain datatype sizes), or certain sizes of the chunk
 * dataspace.
 *
 * The "can_apply" callback can be the NULL pointer, in which case, the library
 * will assume that it can apply to any combination of dataset creation
 * property list values, datatypes and dataspaces.
 *
 * The "can_apply" callback returns positive a valid combination, zero for an
 * invalid combination and negative for an error.
 */
public static class H5Z_can_apply_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5Z_can_apply_func_t(Pointer p) { super(p); }
    protected H5Z_can_apply_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("htri_t") int call(@Cast("hid_t") int dcpl_id, @Cast("hid_t") int type_id, @Cast("hid_t") int space_id);
}

/*
 * After the "can_apply" callbacks are checked for new datasets, the "set_local"
 * callbacks for any filters used in the dataset creation property list are
 * called.  These callbacks receive the dataset's private copy of the dataset
 * creation property list passed in to H5Dcreate (i.e. not the actual property
 * list passed in to H5Dcreate) and the datatype ID passed in to H5Dcreate
 * (which is not copied and should not be modified) and a dataspace describing
 * the chunk (for chunked dataset storage) (which should also not be modified).
 *
 * The "set_local" callback must set any parameters that are specific to this
 * dataset, based on the combination of the dataset creation property list
 * values, the datatype and the dataspace.  For example, some filters perform
 * different actions based on different datatypes (or datatype sizes) or
 * different number of dimensions or dataspace sizes.
 *
 * The "set_local" callback can be the NULL pointer, in which case, the library
 * will assume that there are no dataset-specific settings for this filter.
 *
 * The "set_local" callback must return non-negative on success and negative
 * for an error.
 */
public static class H5Z_set_local_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5Z_set_local_func_t(Pointer p) { super(p); }
    protected H5Z_set_local_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int dcpl_id, @Cast("hid_t") int type_id, @Cast("hid_t") int space_id);
}

/*
 * A filter gets definition flags and invocation flags (defined above), the
 * client data array and size defined when the filter was added to the
 * pipeline, the size in bytes of the data on which to operate, and pointers
 * to a buffer and its allocated size.
 *
 * The filter should store the result in the supplied buffer if possible,
 * otherwise it can allocate a new buffer, freeing the original.  The
 * allocated size of the new buffer should be returned through the BUF_SIZE
 * pointer and the new buffer through the BUF pointer.
 *
 * The return value from the filter is the number of bytes in the output
 * buffer. If an error occurs then the function should return zero and leave
 * all pointer arguments unchanged.
 */
public static class H5Z_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5Z_func_t(Pointer p) { super(p); }
    protected H5Z_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("size_t") long call(@Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
			     @Cast("const unsigned int*") IntPointer cd_values, @Cast("size_t") long nbytes,
			     @Cast("size_t*") SizeTPointer buf_size, @Cast("void**") @ByPtrPtr Pointer buf);
}

/*
 * The filter table maps filter identification numbers to structs that
 * contain a pointers to the filter function and timing statistics.
 */
public static class H5Z_class2_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5Z_class2_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5Z_class2_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5Z_class2_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5Z_class2_t position(long position) {
        return (H5Z_class2_t)super.position(position);
    }

    public native int version(); public native H5Z_class2_t version(int version);                /* Version number of the H5Z_class_t struct */
    public native @Cast("H5Z_filter_t") int id(); public native H5Z_class2_t id(int id);		/* Filter ID number			     */
    public native @Cast("unsigned") int encoder_present(); public native H5Z_class2_t encoder_present(int encoder_present);   /* Does this filter have an encoder? */
    public native @Cast("unsigned") int decoder_present(); public native H5Z_class2_t decoder_present(int decoder_present);   /* Does this filter have a decoder? */
    @MemberGetter public native @Cast("const char*") BytePointer name();		/* Comment for debugging		     */
    public native H5Z_can_apply_func_t can_apply(); public native H5Z_class2_t can_apply(H5Z_can_apply_func_t can_apply); /* The "can apply" callback for a filter */
    public native H5Z_set_local_func_t set_local(); public native H5Z_class2_t set_local(H5Z_set_local_func_t set_local); /* The "set local" callback for a filter */
    public native H5Z_func_t filter(); public native H5Z_class2_t filter(H5Z_func_t filter);		/* The actual filter function		     */
}

public static native @Cast("herr_t") int H5Zregister(@Const Pointer cls);
public static native @Cast("herr_t") int H5Zunregister(@Cast("H5Z_filter_t") int id);
public static native @Cast("htri_t") int H5Zfilter_avail(@Cast("H5Z_filter_t") int id);
public static native @Cast("herr_t") int H5Zget_filter_info(@Cast("H5Z_filter_t") int filter, @Cast("unsigned int*") IntPointer filter_config_flags);
public static native @Cast("herr_t") int H5Zget_filter_info(@Cast("H5Z_filter_t") int filter, @Cast("unsigned int*") IntBuffer filter_config_flags);
public static native @Cast("herr_t") int H5Zget_filter_info(@Cast("H5Z_filter_t") int filter, @Cast("unsigned int*") int[] filter_config_flags);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif



// Parsed from H5Apublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5A module.
 */
// #ifndef _H5Apublic_H
// #define _H5Apublic_H

/* Public headers needed by this file */
// #include "H5Ipublic.h"		/* IDs			  		*/
// #include "H5Opublic.h"		/* Object Headers			*/
// #include "H5Tpublic.h"		/* Datatypes				*/

// #ifdef __cplusplus
// #endif

/* Information struct for attribute (for H5Aget_info/H5Aget_info_by_idx) */
public static class H5A_info_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5A_info_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5A_info_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5A_info_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5A_info_t position(long position) {
        return (H5A_info_t)super.position(position);
    }

    public native @Cast("hbool_t") boolean corder_valid(); public native H5A_info_t corder_valid(boolean corder_valid);   /* Indicate if creation order is valid */
    public native @Cast("H5O_msg_crt_idx_t") short corder(); public native H5A_info_t corder(short corder);         /* Creation order                 */
    public native @Cast("H5T_cset_t") int cset(); public native H5A_info_t cset(int cset);           /* Character set of attribute name */
    public native @Cast("hsize_t") long data_size(); public native H5A_info_t data_size(long data_size);      /* Size of raw data		  */
}

/* Typedef for H5Aiterate2() callbacks */
public static class H5A_operator2_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5A_operator2_t(Pointer p) { super(p); }
    protected H5A_operator2_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int location_id,
    @Cast("const char*") BytePointer attr_name, @Const H5A_info_t ainfo, Pointer op_data);
}

/* Public function prototypes */
public static native @Cast("hid_t") int H5Acreate2(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer attr_name, @Cast("hid_t") int type_id,
    @Cast("hid_t") int space_id, @Cast("hid_t") int acpl_id, @Cast("hid_t") int aapl_id);
public static native @Cast("hid_t") int H5Acreate2(@Cast("hid_t") int loc_id, String attr_name, @Cast("hid_t") int type_id,
    @Cast("hid_t") int space_id, @Cast("hid_t") int acpl_id, @Cast("hid_t") int aapl_id);
public static native @Cast("hid_t") int H5Acreate_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name, @Cast("const char*") BytePointer attr_name,
    @Cast("hid_t") int type_id, @Cast("hid_t") int space_id, @Cast("hid_t") int acpl_id, @Cast("hid_t") int aapl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("hid_t") int H5Acreate_by_name(@Cast("hid_t") int loc_id, String obj_name, String attr_name,
    @Cast("hid_t") int type_id, @Cast("hid_t") int space_id, @Cast("hid_t") int acpl_id, @Cast("hid_t") int aapl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("hid_t") int H5Aopen(@Cast("hid_t") int obj_id, @Cast("const char*") BytePointer attr_name, @Cast("hid_t") int aapl_id);
public static native @Cast("hid_t") int H5Aopen(@Cast("hid_t") int obj_id, String attr_name, @Cast("hid_t") int aapl_id);
public static native @Cast("hid_t") int H5Aopen_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("const char*") BytePointer attr_name, @Cast("hid_t") int aapl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("hid_t") int H5Aopen_by_name(@Cast("hid_t") int loc_id, String obj_name,
    String attr_name, @Cast("hid_t") int aapl_id, @Cast("hid_t") int lapl_id);
public static native @Cast("hid_t") int H5Aopen_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") int aapl_id,
    @Cast("hid_t") int lapl_id);
public static native @Cast("hid_t") int H5Aopen_by_idx(@Cast("hid_t") int loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") int aapl_id,
    @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Awrite(@Cast("hid_t") int attr_id, @Cast("hid_t") int type_id, @Const Pointer buf);
public static native @Cast("herr_t") int H5Aread(@Cast("hid_t") int attr_id, @Cast("hid_t") int type_id, Pointer buf);
public static native @Cast("herr_t") int H5Aclose(@Cast("hid_t") int attr_id);
public static native @Cast("hid_t") int H5Aget_space(@Cast("hid_t") int attr_id);
public static native @Cast("hid_t") int H5Aget_type(@Cast("hid_t") int attr_id);
public static native @Cast("hid_t") int H5Aget_create_plist(@Cast("hid_t") int attr_id);
public static native @Cast("ssize_t") int H5Aget_name(@Cast("hid_t") int attr_id, @Cast("size_t") long buf_size, @Cast("char*") BytePointer buf);
public static native @Cast("ssize_t") int H5Aget_name(@Cast("hid_t") int attr_id, @Cast("size_t") long buf_size, @Cast("char*") ByteBuffer buf);
public static native @Cast("ssize_t") int H5Aget_name(@Cast("hid_t") int attr_id, @Cast("size_t") long buf_size, @Cast("char*") byte[] buf);
public static native @Cast("ssize_t") int H5Aget_name_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") BytePointer name, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Aget_name_by_idx(@Cast("hid_t") int loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") ByteBuffer name, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Aget_name_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") byte[] name, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Aget_name_by_idx(@Cast("hid_t") int loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") BytePointer name, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Aget_name_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") ByteBuffer name, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("ssize_t") int H5Aget_name_by_idx(@Cast("hid_t") int loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    @Cast("char*") byte[] name, @Cast("size_t") long size, @Cast("hid_t") int lapl_id);
public static native @Cast("hsize_t") long H5Aget_storage_size(@Cast("hid_t") int attr_id);
public static native @Cast("herr_t") int H5Aget_info(@Cast("hid_t") int attr_id, H5A_info_t ainfo);
public static native @Cast("herr_t") int H5Aget_info_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("const char*") BytePointer attr_name, H5A_info_t ainfo, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Aget_info_by_name(@Cast("hid_t") int loc_id, String obj_name,
    String attr_name, H5A_info_t ainfo, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Aget_info_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    H5A_info_t ainfo, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Aget_info_by_idx(@Cast("hid_t") int loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n,
    H5A_info_t ainfo, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Arename(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer old_name, @Cast("const char*") BytePointer new_name);
public static native @Cast("herr_t") int H5Arename(@Cast("hid_t") int loc_id, String old_name, String new_name);
public static native @Cast("herr_t") int H5Arename_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("const char*") BytePointer old_attr_name, @Cast("const char*") BytePointer new_attr_name, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Arename_by_name(@Cast("hid_t") int loc_id, String obj_name,
    String old_attr_name, String new_attr_name, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Aiterate2(@Cast("hid_t") int loc_id, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx, H5A_operator2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Aiterate2(@Cast("hid_t") int loc_id, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx, H5A_operator2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Aiterate2(@Cast("hid_t") int loc_id, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx, H5A_operator2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx, H5A_operator2_t op, Pointer op_data,
    @Cast("hid_t") int lapd_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") int loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx, H5A_operator2_t op, Pointer op_data,
    @Cast("hid_t") int lapd_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx, H5A_operator2_t op, Pointer op_data,
    @Cast("hid_t") int lapd_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") int loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx, H5A_operator2_t op, Pointer op_data,
    @Cast("hid_t") int lapd_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx, H5A_operator2_t op, Pointer op_data,
    @Cast("hid_t") int lapd_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") int loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
    @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx, H5A_operator2_t op, Pointer op_data,
    @Cast("hid_t") int lapd_id);
public static native @Cast("herr_t") int H5Adelete(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Adelete(@Cast("hid_t") int loc_id, String name);
public static native @Cast("herr_t") int H5Adelete_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("const char*") BytePointer attr_name, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Adelete_by_name(@Cast("hid_t") int loc_id, String obj_name,
    String attr_name, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Adelete_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Adelete_by_idx(@Cast("hid_t") int loc_id, String obj_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") int lapl_id);
public static native @Cast("htri_t") int H5Aexists(@Cast("hid_t") int obj_id, @Cast("const char*") BytePointer attr_name);
public static native @Cast("htri_t") int H5Aexists(@Cast("hid_t") int obj_id, String attr_name);
public static native @Cast("htri_t") int H5Aexists_by_name(@Cast("hid_t") int obj_id, @Cast("const char*") BytePointer obj_name,
    @Cast("const char*") BytePointer attr_name, @Cast("hid_t") int lapl_id);
public static native @Cast("htri_t") int H5Aexists_by_name(@Cast("hid_t") int obj_id, String obj_name,
    String attr_name, @Cast("hid_t") int lapl_id);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif

// #endif /* _H5Apublic_H */



// Parsed from H5ACpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5ACpublic.h
 *                      Jul 10 1997
 *                      Robb Matzke <matzke@llnl.gov>
 *
 * Purpose:             Public include file for cache functions.
 *
 * Modifications:
 *
 *-------------------------------------------------------------------------
 */
// #ifndef _H5ACpublic_H
// #define _H5ACpublic_H

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Cpublic.h"

// #ifdef __cplusplus
// #endif

/****************************************************************************
 *
 * structure H5AC_cache_config_t
 *
 * H5AC_cache_config_t is a public structure intended for use in public APIs.
 * At least in its initial incarnation, it is basicaly a copy of struct
 * H5C_auto_size_ctl_t, minus the report_fcn field, and plus the
 * dirty_bytes_threshold field.
 *
 * The report_fcn field is omitted, as including it would require us to
 * make H5C_t structure public.
 *
 * The dirty_bytes_threshold field does not appear in H5C_auto_size_ctl_t,
 * as synchronization between caches on different processes is handled at
 * the H5AC level, not at the level of H5C.  Note however that there is
 * considerable interaction between this value and the other fields in this
 * structure.
 *
 * Similarly, the open_trace_file, close_trace_file, and trace_file_name
 * fields do not appear in H5C_auto_size_ctl_t, as most trace file
 * issues are handled at the H5AC level.  The one exception is storage of
 * the pointer to the trace file, which is handled by H5C.
 *
 * The structure is in H5ACpublic.h as we may wish to allow different
 * configuration options for metadata and raw data caches.
 *
 * The fields of the structure are discussed individually below:
 *
 * version: Integer field containing the version number of this version
 *      of the H5AC_cache_config_t structure.  Any instance of
 *      H5AC_cache_config_t passed to the cache must have a known
 *      version number, or an error will be flagged.
 *
 * rpt_fcn_enabled: Boolean field used to enable and disable the default
 *	reporting function.  This function is invoked every time the
 *	automatic cache resize code is run, and reports on its activities.
 *
 *	This is a debugging function, and should normally be turned off.
 *
 * open_trace_file: Boolean field indicating whether the trace_file_name
 * 	field should be used to open a trace file for the cache.
 *
 *      *** DEPRECATED *** Use H5Fstart/stop logging functions instead
 *
 * 	The trace file is a debuging feature that allow the capture of
 * 	top level metadata cache requests for purposes of debugging and/or
 * 	optimization.  This field should normally be set to FALSE, as
 * 	trace file collection imposes considerable overhead.
 *
 * 	This field should only be set to TRUE when the trace_file_name
 * 	contains the full path of the desired trace file, and either
 * 	there is no open trace file on the cache, or the close_trace_file
 * 	field is also TRUE.
 *
 * close_trace_file: Boolean field indicating whether the current trace
 * 	file (if any) should be closed.
 *
 *      *** DEPRECATED *** Use H5Fstart/stop logging functions instead
 *
 * 	See the above comments on the open_trace_file field.  This field
 * 	should be set to FALSE unless there is an open trace file on the
 * 	cache that you wish to close.
 *
 * trace_file_name: Full path of the trace file to be opened if the
 * 	open_trace_file field is TRUE.
 *
 *      *** DEPRECATED *** Use H5Fstart/stop logging functions instead
 *
 * 	In the parallel case, an ascii representation of the mpi rank of
 * 	the process will be appended to the file name to yield a unique
 * 	trace file name for each process.
 *
 * 	The length of the path must not exceed H5AC__MAX_TRACE_FILE_NAME_LEN
 * 	characters.
 *
 * evictions_enabled:  Boolean field used to either report the current
 * 	evictions enabled status of the cache, or to set the cache's
 *	evictions enabled status.
 *
 * 	In general, the metadata cache should always be allowed to
 * 	evict entries.  However, in some cases it is advantageous to
 * 	disable evictions briefly, and thereby postpone metadata
 * 	writes.  However, this must be done with care, as the cache
 * 	can grow quickly.  If you do this, re-enable evictions as
 * 	soon as possible and monitor cache size.
 *
 * 	At present, evictions can only be disabled if automatic
 * 	cache resizing is also disabled (that is, ( incr_mode ==
 *	H5C_incr__off ) && ( decr_mode == H5C_decr__off )).  There
 *	is no logical reason why this should be so, but it simplifies
 *	implementation and testing, and I can't think of any reason
 *	why it would be desireable.  If you can think of one, I'll
 *	revisit the issue.
 *
 * set_initial_size: Boolean flag indicating whether the size of the
 *      initial size of the cache is to be set to the value given in
 *      the initial_size field.  If set_initial_size is FALSE, the
 *      initial_size field is ignored.
 *
 * initial_size: If enabled, this field contain the size the cache is
 *      to be set to upon receipt of this structure.  Needless to say,
 *      initial_size must lie in the closed interval [min_size, max_size].
 *
 * min_clean_fraction: double in the range 0 to 1 indicating the fraction
 *      of the cache that is to be kept clean.  This field is only used
 *      in parallel mode.  Typical values are 0.1 to 0.5.
 *
 * max_size: Maximum size to which the cache can be adjusted.  The
 *      supplied value must fall in the closed interval
 *      [MIN_MAX_CACHE_SIZE, MAX_MAX_CACHE_SIZE].  Also, max_size must
 *      be greater than or equal to min_size.
 *
 * min_size: Minimum size to which the cache can be adjusted.  The
 *      supplied value must fall in the closed interval
 *      [H5C__MIN_MAX_CACHE_SIZE, H5C__MAX_MAX_CACHE_SIZE].  Also, min_size
 *      must be less than or equal to max_size.
 *
 * epoch_length: Number of accesses on the cache over which to collect
 *      hit rate stats before running the automatic cache resize code,
 *      if it is enabled.
 *
 *      At the end of an epoch, we discard prior hit rate data and start
 *      collecting afresh.  The epoch_length must lie in the closed
 *      interval [H5C__MIN_AR_EPOCH_LENGTH, H5C__MAX_AR_EPOCH_LENGTH].
 *
 *
 * Cache size increase control fields:
 *
 * incr_mode: Instance of the H5C_cache_incr_mode enumerated type whose
 *      value indicates how we determine whether the cache size should be
 *      increased.  At present there are two possible values:
 *
 *      H5C_incr__off:  Don't attempt to increase the size of the cache
 *              automatically.
 *
 *              When this increment mode is selected, the remaining fields
 *              in the cache size increase section ar ignored.
 *
 *      H5C_incr__threshold: Attempt to increase the size of the cache
 *              whenever the average hit rate over the last epoch drops
 *              below the value supplied in the lower_hr_threshold
 *              field.
 *
 *              Note that this attempt will fail if the cache is already
 *              at its maximum size, or if the cache is not already using
 *              all available space.
 *
 *      Note that you must set decr_mode to H5C_incr__off if you
 *      disable metadata cache entry evictions.
 *
 * lower_hr_threshold: Lower hit rate threshold.  If the increment mode
 *      (incr_mode) is H5C_incr__threshold and the hit rate drops below the
 *      value supplied in this field in an epoch, increment the cache size by
 *      size_increment.  Note that cache size may not be incremented above
 *      max_size, and that the increment may be further restricted by the
 *      max_increment field if it is enabled.
 *
 *      When enabled, this field must contain a value in the range [0.0, 1.0].
 *      Depending on the incr_mode selected, it may also have to be less than
 *      upper_hr_threshold.
 *
 * increment:  Double containing the multiplier used to derive the new
 *      cache size from the old if a cache size increment is triggered.
 *      The increment must be greater than 1.0, and should not exceed 2.0.
 *
 *      The new cache size is obtained my multiplying the current max cache
 *      size by the increment, and then clamping to max_size and to stay
 *      within the max_increment as necessary.
 *
 * apply_max_increment:  Boolean flag indicating whether the max_increment
 *      field should be used to limit the maximum cache size increment.
 *
 * max_increment: If enabled by the apply_max_increment field described
 *      above, this field contains the maximum number of bytes by which the
 *      cache size can be increased in a single re-size.
 *
 * flash_incr_mode:  Instance of the H5C_cache_flash_incr_mode enumerated
 *      type whose value indicates whether and by which algorithm we should
 *      make flash increases in the size of the cache to accomodate insertion
 *      of large entries and large increases in the size of a single entry.
 *
 *      The addition of the flash increment mode was occasioned by performance
 *      problems that appear when a local heap is increased to a size in excess
 *      of the current cache size.  While the existing re-size code dealt with
 *      this eventually, performance was very bad for the remainder of the
 *      epoch.
 *
 *      At present, there are two possible values for the flash_incr_mode:
 *
 *      H5C_flash_incr__off:  Don't perform flash increases in the size of
 *              the cache.
 *
 *      H5C_flash_incr__add_space:  Let x be either the size of a newly
 *              newly inserted entry, or the number of bytes by which the
 *              size of an existing entry has been increased.
 *
 *              If
 *                      x > flash_threshold * current max cache size,
 *
 *              increase the current maximum cache size by x * flash_multiple
 *              less any free space in the cache, and star a new epoch.  For
 *              now at least, pay no attention to the maximum increment.
 *
 *      In both of the above cases, the flash increment pays no attention to
 *      the maximum increment (at least in this first incarnation), but DOES
 *      stay within max_size.
 *
 *      With a little thought, it should be obvious that the above flash
 *      cache size increase algorithm is not sufficient for all circumstances
 *      -- for example, suppose the user round robins through
 *      (1/flash_threshold) +1 groups, adding one data set to each on each
 *      pass.  Then all will increase in size at about the same time, requiring
 *      the max cache size to at least double to maintain acceptable
 *      performance, however the above flash increment algorithm will not be
 *      triggered.
 *
 *      Hopefully, the add space algorithms detailed above will be sufficient
 *      for the performance problems encountered to date.  However, we should
 *      expect to revisit the issue.
 *
 * flash_multiple: Double containing the multiple described above in the
 *      H5C_flash_incr__add_space section of the discussion of the
 *      flash_incr_mode section.  This field is ignored unless flash_incr_mode
 *      is H5C_flash_incr__add_space.
 *
 * flash_threshold: Double containing the factor by which current max cache
 *      size is multiplied to obtain the size threshold for the add_space flash
 *      increment algorithm.  The field is ignored unless flash_incr_mode is
 *      H5C_flash_incr__add_space.
 *
 *
 * Cache size decrease control fields:
 *
 * decr_mode: Instance of the H5C_cache_decr_mode enumerated type whose
 *      value indicates how we determine whether the cache size should be
 *      decreased.  At present there are four possibilities.
 *
 *      H5C_decr__off:  Don't attempt to decrease the size of the cache
 *              automatically.
 *
 *              When this increment mode is selected, the remaining fields
 *              in the cache size decrease section are ignored.
 *
 *      H5C_decr__threshold: Attempt to decrease the size of the cache
 *              whenever the average hit rate over the last epoch rises
 *              above the value supplied in the upper_hr_threshold
 *              field.
 *
 *      H5C_decr__age_out:  At the end of each epoch, search the cache for
 *              entries that have not been accessed for at least the number
 *              of epochs specified in the epochs_before_eviction field, and
 *              evict these entries.  Conceptually, the maximum cache size
 *              is then decreased to match the new actual cache size.  However,
 *              this reduction may be modified by the min_size, the
 *              max_decrement, and/or the empty_reserve.
 *
 *      H5C_decr__age_out_with_threshold:  Same as age_out, but we only
 *              attempt to reduce the cache size when the hit rate observed
 *              over the last epoch exceeds the value provided in the
 *              upper_hr_threshold field.
 *
 *      Note that you must set decr_mode to H5C_decr__off if you
 *      disable metadata cache entry evictions.
 *
 * upper_hr_threshold: Upper hit rate threshold.  The use of this field
 *      varies according to the current decr_mode:
 *
 *      H5C_decr__off or H5C_decr__age_out:  The value of this field is
 *              ignored.
 *
 *      H5C_decr__threshold:  If the hit rate exceeds this threshold in any
 *              epoch, attempt to decrement the cache size by size_decrement.
 *
 *              Note that cache size may not be decremented below min_size.
 *
 *              Note also that if the upper_threshold is 1.0, the cache size
 *              will never be reduced.
 *
 *      H5C_decr__age_out_with_threshold:  If the hit rate exceeds this
 *              threshold in any epoch, attempt to reduce the cache size
 *              by evicting entries that have not been accessed for more
 *              than the specified number of epochs.
 *
 * decrement: This field is only used when the decr_mode is
 *      H5C_decr__threshold.
 *
 *      The field is a double containing the multiplier used to derive the
 *      new cache size from the old if a cache size decrement is triggered.
 *      The decrement must be in the range 0.0 (in which case the cache will
 *      try to contract to its minimum size) to 1.0 (in which case the
 *      cache will never shrink).
 *
 * apply_max_decrement:  Boolean flag used to determine whether decrements
 *      in cache size are to be limited by the max_decrement field.
 *
 * max_decrement: Maximum number of bytes by which the cache size can be
 *      decreased in a single re-size.  Note that decrements may also be
 *      restricted by the min_size of the cache, and (in age out modes) by
 *      the empty_reserve field.
 *
 * epochs_before_eviction:  Integer field used in H5C_decr__age_out and
 *      H5C_decr__age_out_with_threshold decrement modes.
 *
 *      This field contains the number of epochs an entry must remain
 *      unaccessed before it is evicted in an attempt to reduce the
 *      cache size.  If applicable, this field must lie in the range
 *      [1, H5C__MAX_EPOCH_MARKERS].
 *
 * apply_empty_reserve:  Boolean field controlling whether the empty_reserve
 *      field is to be used in computing the new cache size when the
 *      decr_mode is H5C_decr__age_out or H5C_decr__age_out_with_threshold.
 *
 * empty_reserve:  To avoid a constant racheting down of cache size by small
 *      amounts in the H5C_decr__age_out and H5C_decr__age_out_with_threshold
 *      modes, this field allows one to require that any cache size
 *      reductions leave the specified fraction of unused space in the cache.
 *
 *      The value of this field must be in the range [0.0, 1.0].  I would
 *      expect typical values to be in the range of 0.01 to 0.1.
 *
 *
 * Parallel Configuration Fields:
 *
 * In PHDF5, all operations that modify metadata must be executed collectively.
 *
 * We used to think that this was enough to ensure consistency across the
 * metadata caches, but since we allow processes to read metadata individually,
 * the order of dirty entries in the LRU list can vary across processes,
 * which can result in inconsistencies between the caches.
 *
 * PHDF5 uses several strategies to prevent such inconsistencies in metadata,
 * all of which use the fact that the same stream of dirty metadata is seen
 * by all processes for purposes of synchronization.  This is done by 
 * having each process count the number of bytes of dirty metadata generated,
 * and then running a "sync point" whenever this count exceeds a user 
 * specified threshold (see dirty_bytes_threshold below).
 *
 * The current metadata write strategy is indicated by the 
 * metadata_write_strategy field.  The possible values of this field, along
 * with the associated metadata write strategies are discussed below.
 *
 * dirty_bytes_threshold:  Threshold of dirty byte creation used to
 * 	synchronize updates between caches. (See above for outline and
 *	motivation.)
 *
 *	This value MUST be consistant across all processes accessing the
 *	file.  This field is ignored unless HDF5 has been compiled for
 *	parallel.
 *
 * metadata_write_strategy: Integer field containing a code indicating the
 *	desired metadata write strategy.  The valid values of this field
 *	are enumerated and discussed below:
 *
 *
 *	H5AC_METADATA_WRITE_STRATEGY__PROCESS_0_ONLY:
 *
 *	When metadata_write_strategy is set to this value, only process 
 *	zero is allowed to write dirty metadata to disk.  All other 
 *	processes must retain dirty metadata until they are informed at
 *	a sync point that the dirty metadata in question has been written
 *	to disk.
 *
 *	When the sync point is reached (or when there is a user generated
 *	flush), process zero flushes sufficient entries to bring it into
 *	complience with its min clean size (or flushes all dirty entries in
 *	the case of a user generated flush), broad casts the list of 
 *	entries just cleaned to all the other processes, and then exits
 *	the sync point.
 *
 *	Upon receipt of the broadcast, the other processes mark the indicated
 *	entries as clean, and leave the sync point as well.
 *
 *
 *	H5AC_METADATA_WRITE_STRATEGY__DISTRIBUTED:
 *
 *	In the distributed metadata write strategy, process zero still makes
 *	the decisions as to what entries should be flushed, but the actual 
 *	flushes are distributed across the processes in the computation to 
 *	the extent possible.
 *
 *	In this strategy, when a sync point is triggered (either by dirty
 *	metadata creation or manual flush), all processes enter a barrier.
 *
 *	On the other side of the barrier, process 0 constructs an ordered
 *	list of the entries to be flushed, and then broadcasts this list
 *	to the caches in all the processes.
 *
 *	All processes then scan the list of entries to be flushed, flushing
 *	some, and marking the rest as clean.  The algorithm for this purpose
 *	ensures that each entry in the list is flushed exactly once, and 
 *	all are marked clean in each cache.
 *
 *	Note that in the case of a flush of the cache, no message passing
 *	is necessary, as all processes have the same list of dirty entries, 
 *	and all of these entries must be flushed.  Thus in this case it is 
 *	sufficient for each process to sort its list of dirty entries after 
 *	leaving the initial barrier, and use this list as if it had been 
 *	received from process zero.
 *
 *	To avoid possible messages from the past/future, all caches must
 *	wait until all caches are done before leaving the sync point.
 *      
 ****************************************************************************/

public static final int H5AC__CURR_CACHE_CONFIG_VERSION = 	1;
public static final int H5AC__MAX_TRACE_FILE_NAME_LEN =		1024;

public static final int H5AC_METADATA_WRITE_STRATEGY__PROCESS_0_ONLY =    0;
public static final int H5AC_METADATA_WRITE_STRATEGY__DISTRIBUTED =       1;

public static class H5AC_cache_config_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5AC_cache_config_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5AC_cache_config_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5AC_cache_config_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5AC_cache_config_t position(long position) {
        return (H5AC_cache_config_t)super.position(position);
    }

    /* general configuration fields: */
    public native int version(); public native H5AC_cache_config_t version(int version);

    public native @Cast("hbool_t") boolean rpt_fcn_enabled(); public native H5AC_cache_config_t rpt_fcn_enabled(boolean rpt_fcn_enabled);

    public native @Cast("hbool_t") boolean open_trace_file(); public native H5AC_cache_config_t open_trace_file(boolean open_trace_file);
    public native @Cast("hbool_t") boolean close_trace_file(); public native H5AC_cache_config_t close_trace_file(boolean close_trace_file);
    public native @Cast("char") byte trace_file_name(int i); public native H5AC_cache_config_t trace_file_name(int i, byte trace_file_name);
    @MemberGetter public native @Cast("char*") BytePointer trace_file_name();

    public native @Cast("hbool_t") boolean evictions_enabled(); public native H5AC_cache_config_t evictions_enabled(boolean evictions_enabled);

    public native @Cast("hbool_t") boolean set_initial_size(); public native H5AC_cache_config_t set_initial_size(boolean set_initial_size);
    public native @Cast("size_t") long initial_size(); public native H5AC_cache_config_t initial_size(long initial_size);

    public native double min_clean_fraction(); public native H5AC_cache_config_t min_clean_fraction(double min_clean_fraction);

    public native @Cast("size_t") long max_size(); public native H5AC_cache_config_t max_size(long max_size);
    public native @Cast("size_t") long min_size(); public native H5AC_cache_config_t min_size(long min_size);

    public native long epoch_length(); public native H5AC_cache_config_t epoch_length(long epoch_length);


    /* size increase control fields: */
    public native @Cast("H5C_cache_incr_mode") int incr_mode(); public native H5AC_cache_config_t incr_mode(int incr_mode);

    public native double lower_hr_threshold(); public native H5AC_cache_config_t lower_hr_threshold(double lower_hr_threshold);

    public native double increment(); public native H5AC_cache_config_t increment(double increment);

    public native @Cast("hbool_t") boolean apply_max_increment(); public native H5AC_cache_config_t apply_max_increment(boolean apply_max_increment);
    public native @Cast("size_t") long max_increment(); public native H5AC_cache_config_t max_increment(long max_increment);

    public native @Cast("H5C_cache_flash_incr_mode") int flash_incr_mode(); public native H5AC_cache_config_t flash_incr_mode(int flash_incr_mode);
    public native double flash_multiple(); public native H5AC_cache_config_t flash_multiple(double flash_multiple);
    public native double flash_threshold(); public native H5AC_cache_config_t flash_threshold(double flash_threshold);


    /* size decrease control fields: */
    public native @Cast("H5C_cache_decr_mode") int decr_mode(); public native H5AC_cache_config_t decr_mode(int decr_mode);

    public native double upper_hr_threshold(); public native H5AC_cache_config_t upper_hr_threshold(double upper_hr_threshold);

    public native double decrement(); public native H5AC_cache_config_t decrement(double decrement);

    public native @Cast("hbool_t") boolean apply_max_decrement(); public native H5AC_cache_config_t apply_max_decrement(boolean apply_max_decrement);
    public native @Cast("size_t") long max_decrement(); public native H5AC_cache_config_t max_decrement(long max_decrement);

    public native int epochs_before_eviction(); public native H5AC_cache_config_t epochs_before_eviction(int epochs_before_eviction);

    public native @Cast("hbool_t") boolean apply_empty_reserve(); public native H5AC_cache_config_t apply_empty_reserve(boolean apply_empty_reserve);
    public native double empty_reserve(); public native H5AC_cache_config_t empty_reserve(double empty_reserve);


    /* parallel configuration fields: */
    public native @Cast("size_t") long dirty_bytes_threshold(); public native H5AC_cache_config_t dirty_bytes_threshold(long dirty_bytes_threshold);
    public native int metadata_write_strategy(); public native H5AC_cache_config_t metadata_write_strategy(int metadata_write_strategy);

}


// #ifdef __cplusplus
// #endif
// #endif



// Parsed from H5Dpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5D module.
 */
// #ifndef _H5Dpublic_H
// #define _H5Dpublic_H

/* System headers needed by this file */

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Ipublic.h"

/*****************/
/* Public Macros */
/*****************/

/* Macros used to "unset" chunk cache configuration parameters */
public static native @MemberGetter int H5D_CHUNK_CACHE_NSLOTS_DEFAULT();
public static final int H5D_CHUNK_CACHE_NSLOTS_DEFAULT = H5D_CHUNK_CACHE_NSLOTS_DEFAULT();
public static native @MemberGetter int H5D_CHUNK_CACHE_NBYTES_DEFAULT();
public static final int H5D_CHUNK_CACHE_NBYTES_DEFAULT = H5D_CHUNK_CACHE_NBYTES_DEFAULT();
public static final double H5D_CHUNK_CACHE_W0_DEFAULT =          (-1.0f);

/* Bit flags for the H5Pset_chunk_opts() and H5Pget_chunk_opts() */
public static final int H5D_CHUNK_DONT_FILTER_PARTIAL_CHUNKS =      (0x0002);

/* Property names for H5LTDdirect_chunk_write */   
public static final String H5D_XFER_DIRECT_CHUNK_WRITE_FLAG_NAME =	        "direct_chunk_flag";
public static final String H5D_XFER_DIRECT_CHUNK_WRITE_FILTERS_NAME =	"direct_chunk_filters";
public static final String H5D_XFER_DIRECT_CHUNK_WRITE_OFFSET_NAME =		"direct_chunk_offset";
public static final String H5D_XFER_DIRECT_CHUNK_WRITE_DATASIZE_NAME =	"direct_chunk_datasize";
 
/*******************/
/* Public Typedefs */
/*******************/

/* Values for the H5D_LAYOUT property */
/** enum H5D_layout_t */
public static final int
    H5D_LAYOUT_ERROR	= -1,

    H5D_COMPACT		= 0,	/*raw data is very small		     */
    H5D_CONTIGUOUS	= 1,	/*the default				     */
    H5D_CHUNKED		= 2,	/*slow and fancy			     */
    H5D_VIRTUAL         = 3,    /*actual data is stored in other datasets     */
    H5D_NLAYOUTS	= 4;	/*this one must be last!		     */

/* Types of chunk index data structures */
/** enum H5D_chunk_index_t */
public static final int
    H5D_CHUNK_IDX_BTREE	= 0,	/* v1 B-tree index (default)                 */
    H5D_CHUNK_IDX_SINGLE = 1,   /* Single Chunk index (cur dims[]=max dims[]=chunk dims[]; filtered & non-filtered) */
    H5D_CHUNK_IDX_NONE = 2,     /* Implicit: No Index (H5D_ALLOC_TIME_EARLY, non-filtered, fixed dims) */
    H5D_CHUNK_IDX_FARRAY = 3,	/* Fixed array (for 0 unlimited dims)	     */
    H5D_CHUNK_IDX_EARRAY = 4,	/* Extensible array (for 1 unlimited dim)    */
    H5D_CHUNK_IDX_BT2 = 5,   	/* v2 B-tree index (for >1 unlimited dims)   */
    H5D_CHUNK_IDX_NTYPES = 6;	/*this one must be last!		     */

/* Values for the space allocation time property */
/** enum H5D_alloc_time_t */
public static final int
    H5D_ALLOC_TIME_ERROR	= -1,
    H5D_ALLOC_TIME_DEFAULT  	= 0,
    H5D_ALLOC_TIME_EARLY	= 1,
    H5D_ALLOC_TIME_LATE		= 2,
    H5D_ALLOC_TIME_INCR		= 3;

/* Values for the status of space allocation */
/** enum H5D_space_status_t */
public static final int
    H5D_SPACE_STATUS_ERROR		= -1,
    H5D_SPACE_STATUS_NOT_ALLOCATED	= 0,
    H5D_SPACE_STATUS_PART_ALLOCATED	= 1,
    H5D_SPACE_STATUS_ALLOCATED		= 2;

/* Values for time of writing fill value property */
/** enum H5D_fill_time_t */
public static final int
    H5D_FILL_TIME_ERROR	= -1,
    H5D_FILL_TIME_ALLOC = 0,
    H5D_FILL_TIME_NEVER	= 1,
    H5D_FILL_TIME_IFSET	= 2;

/* Values for fill value status */
/** enum H5D_fill_value_t */
public static final int
    H5D_FILL_VALUE_ERROR        = -1,
    H5D_FILL_VALUE_UNDEFINED    = 0,
    H5D_FILL_VALUE_DEFAULT      = 1,
    H5D_FILL_VALUE_USER_DEFINED = 2;

/* Values for VDS bounds option */
/** enum H5D_vds_view_t */
public static final int
    H5D_VDS_ERROR               = -1,
    H5D_VDS_FIRST_MISSING       = 0,
    H5D_VDS_LAST_AVAILABLE      = 1;

/* Callback for H5Pset_append_flush() in a dataset access property list */
public static class H5D_append_cb_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5D_append_cb_t(Pointer p) { super(p); }
    protected H5D_append_cb_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int dataset_id, @Cast("hsize_t*") LongPointer cur_dims, Pointer op_data);
}

/********************/
/* Public Variables */
/********************/

/*********************/
/* Public Prototypes */
/*********************/
// #ifdef __cplusplus
// #endif

/* Define the operator function pointer for H5Diterate() */
public static class H5D_operator_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5D_operator_t(Pointer p) { super(p); }
    protected H5D_operator_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(Pointer elem, @Cast("hid_t") int type_id, @Cast("unsigned") int ndim,
				 @Cast("const hsize_t*") LongPointer point, Pointer operator_data);
}

/* Define the operator function pointer for H5Dscatter() */
public static class H5D_scatter_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5D_scatter_func_t(Pointer p) { super(p); }
    protected H5D_scatter_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("const void**") @ByPtrPtr Pointer src_buf,
                                     @Cast("size_t*") SizeTPointer src_buf_bytes_used,
                                     Pointer op_data);
}

/* Define the operator function pointer for H5Dgather() */
public static class H5D_gather_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5D_gather_func_t(Pointer p) { super(p); }
    protected H5D_gather_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Const Pointer dst_buf,
                                    @Cast("size_t") long dst_buf_bytes_used, Pointer op_data);
}

public static native @Cast("hid_t") int H5Dcreate2(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") int type_id,
    @Cast("hid_t") int space_id, @Cast("hid_t") int lcpl_id, @Cast("hid_t") int dcpl_id, @Cast("hid_t") int dapl_id);
public static native @Cast("hid_t") int H5Dcreate2(@Cast("hid_t") int loc_id, String name, @Cast("hid_t") int type_id,
    @Cast("hid_t") int space_id, @Cast("hid_t") int lcpl_id, @Cast("hid_t") int dcpl_id, @Cast("hid_t") int dapl_id);
public static native @Cast("hid_t") int H5Dcreate_anon(@Cast("hid_t") int file_id, @Cast("hid_t") int type_id, @Cast("hid_t") int space_id,
    @Cast("hid_t") int plist_id, @Cast("hid_t") int dapl_id);
public static native @Cast("hid_t") int H5Dopen2(@Cast("hid_t") int file_id, @Cast("const char*") BytePointer name, @Cast("hid_t") int dapl_id);
public static native @Cast("hid_t") int H5Dopen2(@Cast("hid_t") int file_id, String name, @Cast("hid_t") int dapl_id);
public static native @Cast("herr_t") int H5Dclose(@Cast("hid_t") int dset_id);
public static native @Cast("hid_t") int H5Dget_space(@Cast("hid_t") int dset_id);
public static native @Cast("herr_t") int H5Dget_space_status(@Cast("hid_t") int dset_id, @Cast("H5D_space_status_t*") IntPointer allocation);
public static native @Cast("herr_t") int H5Dget_space_status(@Cast("hid_t") int dset_id, @Cast("H5D_space_status_t*") IntBuffer allocation);
public static native @Cast("herr_t") int H5Dget_space_status(@Cast("hid_t") int dset_id, @Cast("H5D_space_status_t*") int[] allocation);
public static native @Cast("hid_t") int H5Dget_type(@Cast("hid_t") int dset_id);
public static native @Cast("hid_t") int H5Dget_create_plist(@Cast("hid_t") int dset_id);
public static native @Cast("hid_t") int H5Dget_access_plist(@Cast("hid_t") int dset_id);
public static native @Cast("hsize_t") long H5Dget_storage_size(@Cast("hid_t") int dset_id);
public static native @Cast("haddr_t") long H5Dget_offset(@Cast("hid_t") int dset_id);
public static native @Cast("herr_t") int H5Dread(@Cast("hid_t") int dset_id, @Cast("hid_t") int mem_type_id, @Cast("hid_t") int mem_space_id,
			@Cast("hid_t") int file_space_id, @Cast("hid_t") int plist_id, Pointer buf);
public static native @Cast("herr_t") int H5Dwrite(@Cast("hid_t") int dset_id, @Cast("hid_t") int mem_type_id, @Cast("hid_t") int mem_space_id,
			 @Cast("hid_t") int file_space_id, @Cast("hid_t") int plist_id, @Const Pointer buf);
public static native @Cast("herr_t") int H5Diterate(Pointer buf, @Cast("hid_t") int type_id, @Cast("hid_t") int space_id,
            H5D_operator_t op, Pointer operator_data);
public static native @Cast("herr_t") int H5Dvlen_reclaim(@Cast("hid_t") int type_id, @Cast("hid_t") int space_id, @Cast("hid_t") int plist_id, Pointer buf);
public static native @Cast("herr_t") int H5Dvlen_get_buf_size(@Cast("hid_t") int dataset_id, @Cast("hid_t") int type_id, @Cast("hid_t") int space_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Dvlen_get_buf_size(@Cast("hid_t") int dataset_id, @Cast("hid_t") int type_id, @Cast("hid_t") int space_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Dvlen_get_buf_size(@Cast("hid_t") int dataset_id, @Cast("hid_t") int type_id, @Cast("hid_t") int space_id, @Cast("hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Dfill(@Const Pointer fill, @Cast("hid_t") int fill_type, Pointer buf,
        @Cast("hid_t") int buf_type, @Cast("hid_t") int space);
public static native @Cast("herr_t") int H5Dset_extent(@Cast("hid_t") int dset_id, @Cast("const hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Dset_extent(@Cast("hid_t") int dset_id, @Cast("const hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Dset_extent(@Cast("hid_t") int dset_id, @Cast("const hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Dflush(@Cast("hid_t") int dset_id);
public static native @Cast("herr_t") int H5Drefresh(@Cast("hid_t") int dset_id);
public static native @Cast("herr_t") int H5Dscatter(H5D_scatter_func_t op, Pointer op_data, @Cast("hid_t") int type_id,
    @Cast("hid_t") int dst_space_id, Pointer dst_buf);
public static native @Cast("herr_t") int H5Dgather(@Cast("hid_t") int src_space_id, @Const Pointer src_buf, @Cast("hid_t") int type_id,
    @Cast("size_t") long dst_buf_size, Pointer dst_buf, H5D_gather_func_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Ddebug(@Cast("hid_t") int dset_id);

/* Internal API routines */
public static native @Cast("herr_t") int H5Dformat_convert(@Cast("hid_t") int dset_id);
public static native @Cast("herr_t") int H5Dget_chunk_index_type(@Cast("hid_t") int did, @Cast("H5D_chunk_index_t*") IntPointer idx_type);
public static native @Cast("herr_t") int H5Dget_chunk_index_type(@Cast("hid_t") int did, @Cast("H5D_chunk_index_t*") IntBuffer idx_type);
public static native @Cast("herr_t") int H5Dget_chunk_index_type(@Cast("hid_t") int did, @Cast("H5D_chunk_index_t*") int[] idx_type);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Dpublic_H */



// Parsed from H5Epublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5E module.
 */
// #ifndef _H5Epublic_H
// #define _H5Epublic_H

// #include <stdio.h>              /*FILE arg of H5Eprint()                     */

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Ipublic.h"

/* Value for the default error stack */
public static native @MemberGetter int H5E_DEFAULT();
public static final int H5E_DEFAULT = H5E_DEFAULT();

/* Different kinds of error information */
/** enum H5E_type_t */
public static final int
    H5E_MAJOR = 0,
    H5E_MINOR = 1;

/* Information about an error; element of error stack */
public static class H5E_error2_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5E_error2_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5E_error2_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5E_error2_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5E_error2_t position(long position) {
        return (H5E_error2_t)super.position(position);
    }

    public native @Cast("hid_t") int cls_id(); public native H5E_error2_t cls_id(int cls_id);         /*class ID                           */
    public native @Cast("hid_t") int maj_num(); public native H5E_error2_t maj_num(int maj_num);	/*major error ID		     */
    public native @Cast("hid_t") int min_num(); public native H5E_error2_t min_num(int min_num);	/*minor error number		     */
    public native @Cast("unsigned") int line(); public native H5E_error2_t line(int line);		/*line in file where error occurs    */
    @MemberGetter public native @Cast("const char*") BytePointer func_name();   	/*function in which error occurred   */
    @MemberGetter public native @Cast("const char*") BytePointer file_name();	/*file in which error occurred       */
    @MemberGetter public native @Cast("const char*") BytePointer desc();		/*optional supplied description      */
}

/* When this header is included from a private header, don't make calls to H5open() */
// #undef H5OPEN
// #ifndef _H5private_H
// #define H5OPEN          H5open(),
// #else   /* _H5private_H */
// #define H5OPEN
// #endif  /* _H5private_H */

/* HDF5 error class */
// #define H5E_ERR_CLS		(H5OPEN H5E_ERR_CLS_g)


/* Include the automatically generated public header information */
/* (This includes the list of major and minor error codes for the library) */
// #include "H5Epubgen.h"

/*
 * One often needs to temporarily disable automatic error reporting when
 * trying something that's likely or expected to fail.  The code to try can
 * be nested between calls to H5Eget_auto() and H5Eset_auto(), but it's
 * easier just to use this macro like:
 * 	H5E_BEGIN_TRY {
 *	    ...stuff here that's likely to fail...
 *      } H5E_END_TRY;
 *
 * Warning: don't break, return, or longjmp() from the body of the loop or
 *	    the error reporting won't be properly restored!
 *
 * These two macros still use the old API functions for backward compatibility
 * purpose.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS
// #else /* H5_NO_DEPRECATED_SYMBOLS */
// #define H5E_BEGIN_TRY {
//     H5E_auto_t saved_efunc;
//     void *H5E_saved_edata;
// 
//     (void)H5Eget_auto(H5E_DEFAULT, &saved_efunc, &H5E_saved_edata);
//     (void)H5Eset_auto(H5E_DEFAULT, NULL, NULL);

// #define H5E_END_TRY
//     (void)H5Eset_auto(H5E_DEFAULT, saved_efunc, H5E_saved_edata);
// }
// #endif /* H5_NO_DEPRECATED_SYMBOLS */

/*
 * Public API Convenience Macros for Error reporting - Documented
 */
/* Use the Standard C __FILE__ & __LINE__ macros instead of typing them in */
// #define H5Epush_sim(func, cls, maj, min, str) H5Epush2(H5E_DEFAULT, __FILE__, func, __LINE__, cls, maj, min, str)

/*
 * Public API Convenience Macros for Error reporting - Undocumented
 */
/* Use the Standard C __FILE__ & __LINE__ macros instead of typing them in */
/*  And return after pushing error onto stack */
// #define H5Epush_ret(func, cls, maj, min, str, ret) {
//     H5Epush2(H5E_DEFAULT, __FILE__, func, __LINE__, cls, maj, min, str);
//     return(ret);
// }

/* Use the Standard C __FILE__ & __LINE__ macros instead of typing them in
 * And goto a label after pushing error onto stack.
 */
// #define H5Epush_goto(func, cls, maj, min, str, label) {
//     H5Epush2(H5E_DEFAULT, __FILE__, func, __LINE__, cls, maj, min, str);
//     goto label;
// }

/* Error stack traversal direction */
/** enum H5E_direction_t */
public static final int
    H5E_WALK_UPWARD	= 0,		/*begin deep, end at API function    */
    H5E_WALK_DOWNWARD	= 1;		/*begin at API function, end deep    */


// #ifdef __cplusplus
// #endif

/* Error stack traversal callback function pointers */
public static class H5E_walk2_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5E_walk2_t(Pointer p) { super(p); }
    protected H5E_walk2_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("unsigned") int n, @Const H5E_error2_t err_desc,
    Pointer client_data);
}
public static class H5E_auto2_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5E_auto2_t(Pointer p) { super(p); }
    protected H5E_auto2_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int estack, Pointer client_data);
}

/* Public API functions */
public static native @Cast("hid_t") int H5Eregister_class(@Cast("const char*") BytePointer cls_name, @Cast("const char*") BytePointer lib_name,
    @Cast("const char*") BytePointer version);
public static native @Cast("hid_t") int H5Eregister_class(String cls_name, String lib_name,
    String version);
public static native @Cast("herr_t") int H5Eunregister_class(@Cast("hid_t") int class_id);
public static native @Cast("herr_t") int H5Eclose_msg(@Cast("hid_t") int err_id);
public static native @Cast("hid_t") int H5Ecreate_msg(@Cast("hid_t") int cls, @Cast("H5E_type_t") int msg_type, @Cast("const char*") BytePointer msg);
public static native @Cast("hid_t") int H5Ecreate_msg(@Cast("hid_t") int cls, @Cast("H5E_type_t") int msg_type, String msg);
public static native @Cast("hid_t") int H5Ecreate_stack();
public static native @Cast("hid_t") int H5Eget_current_stack();
public static native @Cast("herr_t") int H5Eclose_stack(@Cast("hid_t") int stack_id);
public static native @Cast("ssize_t") int H5Eget_class_name(@Cast("hid_t") int class_id, @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Eget_class_name(@Cast("hid_t") int class_id, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Eget_class_name(@Cast("hid_t") int class_id, @Cast("char*") byte[] name, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Eset_current_stack(@Cast("hid_t") int err_stack_id);
public static native @Cast("herr_t") int H5Epush2(@Cast("hid_t") int err_stack, @Cast("const char*") BytePointer file, @Cast("const char*") BytePointer func, @Cast("unsigned") int line,
    @Cast("hid_t") int cls_id, @Cast("hid_t") int maj_id, @Cast("hid_t") int min_id, @Cast("const char*") BytePointer msg);
public static native @Cast("herr_t") int H5Epush2(@Cast("hid_t") int err_stack, String file, String func, @Cast("unsigned") int line,
    @Cast("hid_t") int cls_id, @Cast("hid_t") int maj_id, @Cast("hid_t") int min_id, String msg);
public static native @Cast("herr_t") int H5Epop(@Cast("hid_t") int err_stack, @Cast("size_t") long count);
public static native @Cast("herr_t") int H5Eprint2(@Cast("hid_t") int err_stack, @Cast("FILE*") Pointer stream);
public static native @Cast("herr_t") int H5Ewalk2(@Cast("hid_t") int err_stack, @Cast("H5E_direction_t") int direction, H5E_walk2_t func,
    Pointer client_data);
public static native @Cast("herr_t") int H5Eget_auto2(@Cast("hid_t") int estack_id, @ByPtrPtr H5E_auto2_t func, @Cast("void**") PointerPointer client_data);
public static native @Cast("herr_t") int H5Eget_auto2(@Cast("hid_t") int estack_id, @ByPtrPtr H5E_auto2_t func, @Cast("void**") @ByPtrPtr Pointer client_data);
public static native @Cast("herr_t") int H5Eset_auto2(@Cast("hid_t") int estack_id, H5E_auto2_t func, Pointer client_data);
public static native @Cast("herr_t") int H5Eclear2(@Cast("hid_t") int err_stack);
public static native @Cast("herr_t") int H5Eauto_is_v2(@Cast("hid_t") int err_stack, @Cast("unsigned*") IntPointer is_stack);
public static native @Cast("herr_t") int H5Eauto_is_v2(@Cast("hid_t") int err_stack, @Cast("unsigned*") IntBuffer is_stack);
public static native @Cast("herr_t") int H5Eauto_is_v2(@Cast("hid_t") int err_stack, @Cast("unsigned*") int[] is_stack);
public static native @Cast("ssize_t") int H5Eget_msg(@Cast("hid_t") int msg_id, @Cast("H5E_type_t*") IntPointer type, @Cast("char*") BytePointer msg,
    @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Eget_msg(@Cast("hid_t") int msg_id, @Cast("H5E_type_t*") IntBuffer type, @Cast("char*") ByteBuffer msg,
    @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Eget_msg(@Cast("hid_t") int msg_id, @Cast("H5E_type_t*") int[] type, @Cast("char*") byte[] msg,
    @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Eget_num(@Cast("hid_t") int error_stack_id);


/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS
// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif

// #endif /* end _H5Epublic_H */



// Parsed from H5Fpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5F module.
 */
// #ifndef _H5Fpublic_H
// #define _H5Fpublic_H

/* Public header files needed by this file */
// #include "H5public.h"
// #include "H5ACpublic.h"
// #include "H5Ipublic.h"

/* When this header is included from a private header, don't make calls to H5check() */
// #undef H5CHECK
// #ifndef _H5private_H
// #define H5CHECK          H5check(),
// #else   /* _H5private_H */
// #define H5CHECK
// #endif  /* _H5private_H */

/* When this header is included from a private HDF5 header, don't make calls to H5open() */
// #undef H5OPEN
// #ifndef _H5private_H
// #define H5OPEN        H5open(),
// #else   /* _H5private_H */
// #define H5OPEN
// #endif  /* _H5private_H */

/*
 * These are the bits that can be passed to the `flags' argument of
 * H5Fcreate() and H5Fopen(). Use the bit-wise OR operator (|) to combine
 * them as needed.  As a side effect, they call H5check_version() to make sure
 * that the application is compiled with a version of the hdf5 header files
 * which are compatible with the library to which the application is linked.
 * We're assuming that these constants are used rather early in the hdf5
 * session.
 *
 * Note that H5F_ACC_DEBUG is deprecated (nonfuncational) but retained as a
 * symbol for backward compatibility.
 */
public static native @MemberGetter int H5F_ACC_RDONLY();
public static final int H5F_ACC_RDONLY = H5F_ACC_RDONLY();	/*absence of rdwr => rd-only */
public static native @MemberGetter int H5F_ACC_RDWR();
public static final int H5F_ACC_RDWR = H5F_ACC_RDWR();	/*open for read and write    */
public static native @MemberGetter int H5F_ACC_TRUNC();
public static final int H5F_ACC_TRUNC = H5F_ACC_TRUNC();	/*overwrite existing files   */
public static native @MemberGetter int H5F_ACC_EXCL();
public static final int H5F_ACC_EXCL = H5F_ACC_EXCL();	/*fail if file already exists*/
/* NOTE: 0x0008u was H5F_ACC_DEBUG, now deprecated */
public static native @MemberGetter int H5F_ACC_CREAT();
public static final int H5F_ACC_CREAT = H5F_ACC_CREAT();	/*create non-existing files  */
public static native @MemberGetter int H5F_ACC_SWMR_WRITE();
public static final int H5F_ACC_SWMR_WRITE = H5F_ACC_SWMR_WRITE(); /*indicate that this file is
                                                 * open for writing in a
                                                 * single-writer/multi-reader (SWMR)
                                                 * scenario.  Note that the
                                                 * process(es) opening the file
                                                 * for reading must open the file
                                                 * with RDONLY access, and use
                                                 * the special "SWMR_READ" access
                                                 * flag. */
public static native @MemberGetter int H5F_ACC_SWMR_READ();
public static final int H5F_ACC_SWMR_READ = H5F_ACC_SWMR_READ(); /*indicate that this file is
                                                 * open for reading in a
                                                 * single-writer/multi-reader (SWMR)
                                                 * scenario.  Note that the
                                                 * process(es) opening the file
                                                 * for SWMR reading must also
                                                 * open the file with the RDONLY
                                                 * flag.  */

/* Value passed to H5Pset_elink_acc_flags to cause flags to be taken from the
 * parent file. */
public static native @MemberGetter int H5F_ACC_DEFAULT();
public static final int H5F_ACC_DEFAULT = H5F_ACC_DEFAULT();	/*ignore setting on lapl     */

/* Flags for H5Fget_obj_count() & H5Fget_obj_ids() calls */
public static final int H5F_OBJ_FILE =	(0x0001);       /* File objects */
public static final int H5F_OBJ_DATASET =	(0x0002);       /* Dataset objects */
public static final int H5F_OBJ_GROUP =	(0x0004);       /* Group objects */
public static final int H5F_OBJ_DATATYPE = (0x0008);      /* Named datatype objects */
public static final int H5F_OBJ_ATTR =    (0x0010);       /* Attribute objects */
public static final int H5F_OBJ_ALL = 	(H5F_OBJ_FILE|H5F_OBJ_DATASET|H5F_OBJ_GROUP|H5F_OBJ_DATATYPE|H5F_OBJ_ATTR);
public static final int H5F_OBJ_LOCAL =   (0x0020);       /* Restrict search to objects opened through current file ID */
                                        /* (as opposed to objects opened through any file ID accessing this file) */

public static native @MemberGetter int H5F_FAMILY_DEFAULT();
public static final int H5F_FAMILY_DEFAULT = H5F_FAMILY_DEFAULT();

// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */

/* The difference between a single file and a set of mounted files */
/** enum H5F_scope_t */
public static final int
    H5F_SCOPE_LOCAL	= 0,	/*specified file handle only		*/
    H5F_SCOPE_GLOBAL	= 1; 	/*entire virtual file			*/

/* Unlimited file size for H5Pset_external() */
public static native @MemberGetter long H5F_UNLIMITED();
public static final long H5F_UNLIMITED = H5F_UNLIMITED();

/* How does file close behave?
 * H5F_CLOSE_DEFAULT - Use the degree pre-defined by underlining VFL
 * H5F_CLOSE_WEAK    - file closes only after all opened objects are closed
 * H5F_CLOSE_SEMI    - if no opened objects, file is close; otherwise, file
		       close fails
 * H5F_CLOSE_STRONG  - if there are opened objects, close them first, then
		       close file
 */
/** enum H5F_close_degree_t */
public static final int
    H5F_CLOSE_DEFAULT   = 0,
    H5F_CLOSE_WEAK      = 1,
    H5F_CLOSE_SEMI      = 2,
    H5F_CLOSE_STRONG    = 3;

/* Current "global" information about file */
public static class H5F_info2_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5F_info2_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5F_info2_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5F_info2_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5F_info2_t position(long position) {
        return (H5F_info2_t)super.position(position);
    }

	@Name("super.version") public native @Cast("unsigned") int _super_version(); public native H5F_info2_t _super_version(int _super_version);	/* Superblock version # */
	@Name("super.super_size") public native @Cast("hsize_t") long _super_super_size(); public native H5F_info2_t _super_super_size(long _super_super_size);	/* Superblock size */
	@Name("super.super_ext_size") public native @Cast("hsize_t") long _super_super_ext_size(); public native H5F_info2_t _super_super_ext_size(long _super_super_ext_size);	/* Superblock extension size */
	@Name("free.version") public native @Cast("unsigned") int free_version(); public native H5F_info2_t free_version(int free_version);	/* Version # of file free space management */
	@Name("free.meta_size") public native @Cast("hsize_t") long free_meta_size(); public native H5F_info2_t free_meta_size(long free_meta_size);	/* Free space manager metadata size */
	@Name("free.tot_space") public native @Cast("hsize_t") long free_tot_space(); public native H5F_info2_t free_tot_space(long free_tot_space);	/* Amount of free space in the file */
	@Name("sohm.version") public native @Cast("unsigned") int sohm_version(); public native H5F_info2_t sohm_version(int sohm_version);	/* Version # of shared object header info */
	@Name("sohm.hdr_size") public native @Cast("hsize_t") long sohm_hdr_size(); public native H5F_info2_t sohm_hdr_size(long sohm_hdr_size);       /* Shared object header message header size */
	@Name("sohm.msgs_info") public native @ByRef H5_ih_info_t sohm_msgs_info(); public native H5F_info2_t sohm_msgs_info(H5_ih_info_t sohm_msgs_info);      /* Shared object header message index & heap size */
}

/*
 * Types of allocation requests. The values larger than H5FD_MEM_DEFAULT
 * should not change other than adding new types to the end. These numbers
 * might appear in files.
 *
 * Note: please change the log VFD flavors array if you change this
 * enumeration.
 */
/** enum H5F_mem_t */
public static final int
    H5FD_MEM_NOLIST     = -1,   /* Data should not appear in the free list.
                                 * Must be negative.
                                 */
    H5FD_MEM_DEFAULT    = 0,    /* Value not yet set.  Can also be the
                                 * datatype set in a larger allocation
                                 * that will be suballocated by the library.
                                 * Must be zero.
                                 */
    H5FD_MEM_SUPER      = 1,    /* Superblock data */
    H5FD_MEM_BTREE      = 2,    /* B-tree data */
    H5FD_MEM_DRAW       = 3,    /* Raw data (content of datasets, etc.) */
    H5FD_MEM_GHEAP      = 4,    /* Global heap data */
    H5FD_MEM_LHEAP      = 5,    /* Local heap data */
    H5FD_MEM_OHDR       = 6,    /* Object header data */

    H5FD_MEM_NTYPES = 7;             /* Sentinel value - must be last */

/* Free space section information */
public static class H5F_sect_info_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5F_sect_info_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5F_sect_info_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5F_sect_info_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5F_sect_info_t position(long position) {
        return (H5F_sect_info_t)super.position(position);
    }

    public native @Cast("haddr_t") long addr(); public native H5F_sect_info_t addr(long addr);   /* Address of free space section */
    public native @Cast("hsize_t") long size(); public native H5F_sect_info_t size(long size);   /* Size of free space section */
}

/* Library's file format versions */
/** enum H5F_libver_t */
public static final int
    H5F_LIBVER_EARLIEST = 0,        /* Use the earliest possible format for storing objects */
    H5F_LIBVER_LATEST = 1;           /* Use the latest possible format available for storing objects*/

/* File space handling strategy */
/** enum H5F_file_space_type_t */
public static final int
    H5F_FILE_SPACE_DEFAULT = 0,     /* Default (or current) free space strategy setting */
    H5F_FILE_SPACE_ALL_PERSIST = 1, /* Persistent free space managers, aggregators, virtual file driver */
    H5F_FILE_SPACE_ALL = 2,	    /* Non-persistent free space managers, aggregators, virtual file driver */
				    /* This is the library default */
    H5F_FILE_SPACE_AGGR_VFD = 3,    /* Aggregators, Virtual file driver */
    H5F_FILE_SPACE_VFD = 4,	    /* Virtual file driver */
    H5F_FILE_SPACE_NTYPES = 5;	    /* must be last */

/* Data structure to report the collection of read retries for metadata items with checksum */
/* Used by public routine H5Fget_metadata_read_retry_info() */
public static final int H5F_NUM_METADATA_READ_RETRY_TYPES =	21;
public static class H5F_retry_info_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5F_retry_info_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5F_retry_info_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5F_retry_info_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5F_retry_info_t position(long position) {
        return (H5F_retry_info_t)super.position(position);
    }

    public native @Cast("unsigned") int nbins(); public native H5F_retry_info_t nbins(int nbins);
    public native @Cast("uint32_t*") ShortPointer retries(int i); public native H5F_retry_info_t retries(int i, ShortPointer retries);
    @MemberGetter public native @Cast("uint32_t**") PointerPointer retries();
}

/* Callback for H5Pset_object_flush_cb() in a file access property list */
public static class H5F_flush_cb_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5F_flush_cb_t(Pointer p) { super(p); }
    protected H5F_flush_cb_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int object_id, Pointer udata);
}


// #ifdef __cplusplus
// #endif

/* Functions in H5F.c */
public static native @Cast("htri_t") int H5Fis_hdf5(@Cast("const char*") BytePointer filename);
public static native @Cast("htri_t") int H5Fis_hdf5(String filename);
public static native @Cast("hid_t") int H5Fcreate(@Cast("const char*") BytePointer filename, @Cast("unsigned") int flags,
		  	  @Cast("hid_t") int create_plist, @Cast("hid_t") int access_plist);
public static native @Cast("hid_t") int H5Fcreate(String filename, @Cast("unsigned") int flags,
		  	  @Cast("hid_t") int create_plist, @Cast("hid_t") int access_plist);
public static native @Cast("hid_t") int H5Fopen(@Cast("const char*") BytePointer filename, @Cast("unsigned") int flags,
		        @Cast("hid_t") int access_plist);
public static native @Cast("hid_t") int H5Fopen(String filename, @Cast("unsigned") int flags,
		        @Cast("hid_t") int access_plist);
public static native @Cast("hid_t") int H5Freopen(@Cast("hid_t") int file_id);
public static native @Cast("herr_t") int H5Fflush(@Cast("hid_t") int object_id, @Cast("H5F_scope_t") int scope);
public static native @Cast("herr_t") int H5Fclose(@Cast("hid_t") int file_id);
public static native @Cast("hid_t") int H5Fget_create_plist(@Cast("hid_t") int file_id);
public static native @Cast("hid_t") int H5Fget_access_plist(@Cast("hid_t") int file_id);
public static native @Cast("herr_t") int H5Fget_intent(@Cast("hid_t") int file_id, @Cast("unsigned*") IntPointer intent);
public static native @Cast("herr_t") int H5Fget_intent(@Cast("hid_t") int file_id, @Cast("unsigned*") IntBuffer intent);
public static native @Cast("herr_t") int H5Fget_intent(@Cast("hid_t") int file_id, @Cast("unsigned*") int[] intent);
public static native @Cast("ssize_t") int H5Fget_obj_count(@Cast("hid_t") int file_id, @Cast("unsigned") int types);
public static native @Cast("ssize_t") int H5Fget_obj_ids(@Cast("hid_t") int file_id, @Cast("unsigned") int types, @Cast("size_t") long max_objs, @Cast("hid_t*") IntPointer obj_id_list);
public static native @Cast("ssize_t") int H5Fget_obj_ids(@Cast("hid_t") int file_id, @Cast("unsigned") int types, @Cast("size_t") long max_objs, @Cast("hid_t*") IntBuffer obj_id_list);
public static native @Cast("ssize_t") int H5Fget_obj_ids(@Cast("hid_t") int file_id, @Cast("unsigned") int types, @Cast("size_t") long max_objs, @Cast("hid_t*") int[] obj_id_list);
public static native @Cast("herr_t") int H5Fget_vfd_handle(@Cast("hid_t") int file_id, @Cast("hid_t") int fapl, @Cast("void**") PointerPointer file_handle);
public static native @Cast("herr_t") int H5Fget_vfd_handle(@Cast("hid_t") int file_id, @Cast("hid_t") int fapl, @Cast("void**") @ByPtrPtr Pointer file_handle);
public static native @Cast("herr_t") int H5Fmount(@Cast("hid_t") int loc, @Cast("const char*") BytePointer name, @Cast("hid_t") int child, @Cast("hid_t") int plist);
public static native @Cast("herr_t") int H5Fmount(@Cast("hid_t") int loc, String name, @Cast("hid_t") int child, @Cast("hid_t") int plist);
public static native @Cast("herr_t") int H5Funmount(@Cast("hid_t") int loc, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Funmount(@Cast("hid_t") int loc, String name);
public static native @Cast("hssize_t") long H5Fget_freespace(@Cast("hid_t") int file_id);
public static native @Cast("herr_t") int H5Fget_filesize(@Cast("hid_t") int file_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Fget_filesize(@Cast("hid_t") int file_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Fget_filesize(@Cast("hid_t") int file_id, @Cast("hsize_t*") long[] size);
public static native @Cast("ssize_t") int H5Fget_file_image(@Cast("hid_t") int file_id, Pointer buf_ptr, @Cast("size_t") long buf_len);
public static native @Cast("herr_t") int H5Fget_mdc_config(@Cast("hid_t") int file_id,
				H5AC_cache_config_t config_ptr);
public static native @Cast("herr_t") int H5Fset_mdc_config(@Cast("hid_t") int file_id,
				H5AC_cache_config_t config_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_hit_rate(@Cast("hid_t") int file_id, DoublePointer hit_rate_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_hit_rate(@Cast("hid_t") int file_id, DoubleBuffer hit_rate_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_hit_rate(@Cast("hid_t") int file_id, double[] hit_rate_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_size(@Cast("hid_t") int file_id,
                              @Cast("size_t*") SizeTPointer max_size_ptr,
                              @Cast("size_t*") SizeTPointer min_clean_size_ptr,
                              @Cast("size_t*") SizeTPointer cur_size_ptr,
                              IntPointer cur_num_entries_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_size(@Cast("hid_t") int file_id,
                              @Cast("size_t*") SizeTPointer max_size_ptr,
                              @Cast("size_t*") SizeTPointer min_clean_size_ptr,
                              @Cast("size_t*") SizeTPointer cur_size_ptr,
                              IntBuffer cur_num_entries_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_size(@Cast("hid_t") int file_id,
                              @Cast("size_t*") SizeTPointer max_size_ptr,
                              @Cast("size_t*") SizeTPointer min_clean_size_ptr,
                              @Cast("size_t*") SizeTPointer cur_size_ptr,
                              int[] cur_num_entries_ptr);
public static native @Cast("herr_t") int H5Freset_mdc_hit_rate_stats(@Cast("hid_t") int file_id);
public static native @Cast("ssize_t") int H5Fget_name(@Cast("hid_t") int obj_id, @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Fget_name(@Cast("hid_t") int obj_id, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Fget_name(@Cast("hid_t") int obj_id, @Cast("char*") byte[] name, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Fget_info2(@Cast("hid_t") int obj_id, H5F_info2_t finfo);
public static native @Cast("herr_t") int H5Fget_metadata_read_retry_info(@Cast("hid_t") int file_id, H5F_retry_info_t info);
public static native @Cast("herr_t") int H5Fstart_swmr_write(@Cast("hid_t") int file_id);
public static native @Cast("ssize_t") int H5Fget_free_sections(@Cast("hid_t") int file_id, @Cast("H5F_mem_t") int type,
    @Cast("size_t") long nsects, H5F_sect_info_t sect_info);
public static native @Cast("herr_t") int H5Fclear_elink_file_cache(@Cast("hid_t") int file_id);
public static native @Cast("herr_t") int H5Fstart_mdc_logging(@Cast("hid_t") int file_id);
public static native @Cast("herr_t") int H5Fstop_mdc_logging(@Cast("hid_t") int file_id);
public static native @Cast("herr_t") int H5Fget_mdc_logging_status(@Cast("hid_t") int file_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("hbool_t*") BoolPointer is_currently_logging);
public static native @Cast("herr_t") int H5Fget_mdc_logging_status(@Cast("hid_t") int file_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("hbool_t*") boolean[] is_currently_logging);
public static native @Cast("herr_t") int H5Fformat_convert(@Cast("hid_t") int fid);
// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Fpublic_H */



// Parsed from H5FDpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Monday, July 26, 1999
 */
// #ifndef _H5FDpublic_H
// #define _H5FDpublic_H

// #include "H5public.h"
// #include "H5Fpublic.h"		/*for H5F_close_degree_t */

public static final int H5_HAVE_VFL = 1; /*define a convenient app feature test*/
public static final int H5FD_VFD_DEFAULT = 0;   /* Default VFL driver value */

/* Types of allocation requests: see H5Fpublic.h  */

/* Map "fractal heap" header blocks to 'ohdr' type file memory, since its
 * a fair amount of work to add a new kind of file memory and they are similar
 * enough to object headers and probably too minor to deserve their own type.
 *
 * Map "fractal heap" indirect blocks to 'ohdr' type file memory, since they
 * are similar to fractal heap header blocks.
 *
 * Map "fractal heap" direct blocks to 'lheap' type file memory, since they
 * will be replacing local heaps.
 *
 * Map "fractal heap" 'huge' objects to 'draw' type file memory, since they
 * represent large objects that are directly stored in the file.
 *
 *      -QAK
 */
public static final int H5FD_MEM_FHEAP_HDR =      H5FD_MEM_OHDR;
public static final int H5FD_MEM_FHEAP_IBLOCK =   H5FD_MEM_OHDR;
public static final int H5FD_MEM_FHEAP_DBLOCK =   H5FD_MEM_LHEAP;
public static final int H5FD_MEM_FHEAP_HUGE_OBJ = H5FD_MEM_DRAW;

/* Map "free space" header blocks to 'ohdr' type file memory, since its
 * a fair amount of work to add a new kind of file memory and they are similar
 * enough to object headers and probably too minor to deserve their own type.
 *
 * Map "free space" serialized sections to 'lheap' type file memory, since they
 * are similar enough to local heap info.
 *
 *      -QAK
 */
public static final int H5FD_MEM_FSPACE_HDR =     H5FD_MEM_OHDR;
public static final int H5FD_MEM_FSPACE_SINFO =   H5FD_MEM_LHEAP;

/* Map "shared object header message" master table to 'ohdr' type file memory,
 * since its a fair amount of work to add a new kind of file memory and they are
 * similar enough to object headers and probably too minor to deserve their own
 * type.
 *
 * Map "shared object header message" indices to 'btree' type file memory,
 * since they are similar enough to B-tree nodes.
 *
 *      -QAK
 */
public static final int H5FD_MEM_SOHM_TABLE =     H5FD_MEM_OHDR;
public static final int H5FD_MEM_SOHM_INDEX =     H5FD_MEM_BTREE;

/* Map "extensible array" header blocks to 'ohdr' type file memory, since its
 * a fair amount of work to add a new kind of file memory and they are similar
 * enough to object headers and probably too minor to deserve their own type.
 *
 * Map "extensible array" index blocks to 'ohdr' type file memory, since they
 * are similar to extensible array header blocks.
 *
 * Map "extensible array" super blocks to 'btree' type file memory, since they
 * are similar enough to B-tree nodes.
 *
 * Map "extensible array" data blocks & pages to 'lheap' type file memory, since
 * they are similar enough to local heap info.
 *
 *      -QAK
 */
public static final int H5FD_MEM_EARRAY_HDR =     H5FD_MEM_OHDR;
public static final int H5FD_MEM_EARRAY_IBLOCK =  H5FD_MEM_OHDR;
public static final int H5FD_MEM_EARRAY_SBLOCK =  H5FD_MEM_BTREE;
public static final int H5FD_MEM_EARRAY_DBLOCK =  H5FD_MEM_LHEAP;
public static final int H5FD_MEM_EARRAY_DBLK_PAGE =  H5FD_MEM_LHEAP;

/* Map "fixed array" header blocks to 'ohdr' type file memory, since its
 * a fair amount of work to add a new kind of file memory and they are similar
 * enough to object headers and probably too minor to deserve their own type.
 *
 * Map "fixed array" data blocks & pages to 'lheap' type file memory, since
 * they are similar enough to local heap info.
 *
 */
public static final int H5FD_MEM_FARRAY_HDR =     H5FD_MEM_OHDR;
public static final int H5FD_MEM_FARRAY_DBLOCK =  H5FD_MEM_LHEAP;
public static final int H5FD_MEM_FARRAY_DBLK_PAGE =  H5FD_MEM_LHEAP;

/*
 * A free-list map which maps all types of allocation requests to a single
 * free list.  This is useful for drivers that don't really care about
 * keeping different requests segregated in the underlying file and which
 * want to make most efficient reuse of freed memory.  The use of the
 * H5FD_MEM_SUPER free list is arbitrary.
 */
// #define H5FD_FLMAP_SINGLE {
//     H5FD_MEM_SUPER,			/*default*/
//     H5FD_MEM_SUPER,			/*super*/
//     H5FD_MEM_SUPER,			/*btree*/
//     H5FD_MEM_SUPER,			/*draw*/
//     H5FD_MEM_SUPER,			/*gheap*/
//     H5FD_MEM_SUPER,			/*lheap*/
//     H5FD_MEM_SUPER			/*ohdr*/
// }

/*
 * A free-list map which segregates requests into `raw' or `meta' data
 * pools.
 */
// #define H5FD_FLMAP_DICHOTOMY {
//     H5FD_MEM_SUPER,			/*default*/
//     H5FD_MEM_SUPER,			/*super*/
//     H5FD_MEM_SUPER,			/*btree*/
//     H5FD_MEM_DRAW,			/*draw*/
//     H5FD_MEM_DRAW,			/*gheap*/
//     H5FD_MEM_SUPER,			/*lheap*/
//     H5FD_MEM_SUPER			/*ohdr*/
// }

/*
 * The default free list map which causes each request type to use it's own
 * free-list.
 */
// #define H5FD_FLMAP_DEFAULT {
//     H5FD_MEM_DEFAULT,			/*default*/
//     H5FD_MEM_DEFAULT,			/*super*/
//     H5FD_MEM_DEFAULT,			/*btree*/
//     H5FD_MEM_DEFAULT,			/*draw*/
//     H5FD_MEM_DEFAULT,			/*gheap*/
//     H5FD_MEM_DEFAULT,			/*lheap*/
//     H5FD_MEM_DEFAULT			/*ohdr*/
// }


/* Define VFL driver features that can be enabled on a per-driver basis */
/* These are returned with the 'query' function pointer in H5FD_class_t */
    /*
     * Defining H5FD_FEAT_AGGREGATE_METADATA for a VFL driver means that
     * the library will attempt to allocate a larger block for metadata and
     * then sub-allocate each metadata request from that larger block.
     */
public static final int H5FD_FEAT_AGGREGATE_METADATA =    0x00000001;
    /*
     * Defining H5FD_FEAT_ACCUMULATE_METADATA for a VFL driver means that
     * the library will attempt to cache metadata as it is written to the file
     * and build up a larger block of metadata to eventually pass to the VFL
     * 'write' routine.
     *
     * Distinguish between updating the metadata accumulator on writes and
     * reads.  This is particularly (perhaps only, even) important for MPI-I/O
     * where we guarantee that writes are collective, but reads may not be.
     * If we were to allow the metadata accumulator to be written during a
     * read operation, the application would hang.
     */
public static final int H5FD_FEAT_ACCUMULATE_METADATA_WRITE =     0x00000002;
public static final int H5FD_FEAT_ACCUMULATE_METADATA_READ =      0x00000004;
public static final int H5FD_FEAT_ACCUMULATE_METADATA =   (H5FD_FEAT_ACCUMULATE_METADATA_WRITE|H5FD_FEAT_ACCUMULATE_METADATA_READ);
    /*
     * Defining H5FD_FEAT_DATA_SIEVE for a VFL driver means that
     * the library will attempt to cache raw data as it is read from/written to
     * a file in a "data seive" buffer.  See Rajeev Thakur's papers:
     *  http://www.mcs.anl.gov/~thakur/papers/romio-coll.ps.gz
     *  http://www.mcs.anl.gov/~thakur/papers/mpio-high-perf.ps.gz
     */
public static final int H5FD_FEAT_DATA_SIEVE =            0x00000008;
    /*
     * Defining H5FD_FEAT_AGGREGATE_SMALLDATA for a VFL driver means that
     * the library will attempt to allocate a larger block for "small" raw data
     * and then sub-allocate "small" raw data requests from that larger block.
     */
public static final int H5FD_FEAT_AGGREGATE_SMALLDATA =   0x00000010;
    /*
     * Defining H5FD_FEAT_IGNORE_DRVRINFO for a VFL driver means that
     * the library will ignore the driver info that is encoded in the file
     * for the VFL driver.  (This will cause the driver info to be eliminated
     * from the file when it is flushed/closed, if the file is opened R/W).
     */
public static final int H5FD_FEAT_IGNORE_DRVRINFO =       0x00000020;
    /*
     * Defining the H5FD_FEAT_DIRTY_DRVRINFO_LOAD for a VFL driver means that
     * the library will mark the driver info dirty when the file is opened
     * R/W.  This will cause the driver info to be re-encoded when the file
     * is flushed/closed.
     */
public static final int H5FD_FEAT_DIRTY_DRVRINFO_LOAD =   0x00000040;
    /*
     * Defining H5FD_FEAT_POSIX_COMPAT_HANDLE for a VFL driver means that
     * the handle for the VFD (returned with the 'get_handle' callback) is
     * of type 'int' and is compatible with POSIX I/O calls.
     */
public static final int H5FD_FEAT_POSIX_COMPAT_HANDLE =   0x00000080;    
    /*
     * Defining H5FD_FEAT_HAS_MPI for a VFL driver means that
     * the driver makes use of MPI communication and code may retrieve
     * communicator/rank information from it
     */
public static final int H5FD_FEAT_HAS_MPI =               0x00000100;
    /*
     * Defining the H5FD_FEAT_ALLOCATE_EARLY for a VFL driver will force
     * the library to use the H5D_ALLOC_TIME_EARLY on dataset create
     * instead of the default H5D_ALLOC_TIME_LATE
     */
public static final int H5FD_FEAT_ALLOCATE_EARLY =        0x00000200;
    /* 
     * Defining H5FD_FEAT_ALLOW_FILE_IMAGE for a VFL driver means that
     * the driver is able to use a file image in the fapl as the initial
     * contents of a file.
     */
public static final int H5FD_FEAT_ALLOW_FILE_IMAGE =      0x00000400;
    /*
     * Defining H5FD_FEAT_CAN_USE_FILE_IMAGE_CALLBACKS for a VFL driver
     * means that the driver is able to use callbacks to make a copy of the
     * image to store in memory.
     */
public static final int H5FD_FEAT_CAN_USE_FILE_IMAGE_CALLBACKS = 0x00000800;
    /*
     * Defining H5FD_FEAT_SUPPORTS_SWMR_IO for a VFL driver means that the
     * driver supports the single-writer/multiple-readers I/O pattern.
     */
public static final int H5FD_FEAT_SUPPORTS_SWMR_IO =      0x00001000;

/* Forward declaration */

/* Class information for each file driver */
public static class H5FD_class_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5FD_class_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5FD_class_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5FD_class_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5FD_class_t position(long position) {
        return (H5FD_class_t)super.position(position);
    }

    @MemberGetter public native @Cast("const char*") BytePointer name();
    public native @Cast("haddr_t") long maxaddr(); public native H5FD_class_t maxaddr(long maxaddr);
    public native @Cast("H5F_close_degree_t") int fc_degree(); public native H5FD_class_t fc_degree(int fc_degree);
    public static class Int_Terminate extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Int_Terminate(Pointer p) { super(p); }
        protected Int_Terminate() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call();
    }
    public native Int_Terminate terminate(); public native H5FD_class_t terminate(Int_Terminate terminate);
    public static class Sb_size_H5FD_t extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Sb_size_H5FD_t(Pointer p) { super(p); }
        protected Sb_size_H5FD_t() { allocate(); }
        private native void allocate();
        public native @Cast("hsize_t") long call(H5FD_t file);
    }
    public native Sb_size_H5FD_t sb_size(); public native H5FD_class_t sb_size(Sb_size_H5FD_t sb_size);
    public static class Sb_encode_H5FD_t_BytePointer_BytePointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Sb_encode_H5FD_t_BytePointer_BytePointer(Pointer p) { super(p); }
        protected Sb_encode_H5FD_t_BytePointer_BytePointer() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(H5FD_t file, @Cast("char*") BytePointer name,
                             @Cast("unsigned char*") BytePointer p);
    }
    public native Sb_encode_H5FD_t_BytePointer_BytePointer sb_encode(); public native H5FD_class_t sb_encode(Sb_encode_H5FD_t_BytePointer_BytePointer sb_encode);
    public static class Sb_decode_H5FD_t_BytePointer_BytePointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Sb_decode_H5FD_t_BytePointer_BytePointer(Pointer p) { super(p); }
        protected Sb_decode_H5FD_t_BytePointer_BytePointer() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(H5FD_t f, @Cast("const char*") BytePointer name, @Cast("const unsigned char*") BytePointer p);
    }
    public native Sb_decode_H5FD_t_BytePointer_BytePointer sb_decode(); public native H5FD_class_t sb_decode(Sb_decode_H5FD_t_BytePointer_BytePointer sb_decode);
    public native @Cast("size_t") long fapl_size(); public native H5FD_class_t fapl_size(long fapl_size);
    public static class Fapl_get_H5FD_t extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Fapl_get_H5FD_t(Pointer p) { super(p); }
        protected Fapl_get_H5FD_t() { allocate(); }
        private native void allocate();
        public native Pointer call(H5FD_t file);
    }
    public native Fapl_get_H5FD_t fapl_get(); public native H5FD_class_t fapl_get(Fapl_get_H5FD_t fapl_get);
    public static class Fapl_copy_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Fapl_copy_Pointer(Pointer p) { super(p); }
        protected Fapl_copy_Pointer() { allocate(); }
        private native void allocate();
        public native Pointer call(@Const Pointer fapl);
    }
    public native Fapl_copy_Pointer fapl_copy(); public native H5FD_class_t fapl_copy(Fapl_copy_Pointer fapl_copy);
    public static class Fapl_free_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Fapl_free_Pointer(Pointer p) { super(p); }
        protected Fapl_free_Pointer() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(Pointer fapl);
    }
    public native Fapl_free_Pointer fapl_free(); public native H5FD_class_t fapl_free(Fapl_free_Pointer fapl_free);
    public native @Cast("size_t") long dxpl_size(); public native H5FD_class_t dxpl_size(long dxpl_size);
    public static class Dxpl_copy_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Dxpl_copy_Pointer(Pointer p) { super(p); }
        protected Dxpl_copy_Pointer() { allocate(); }
        private native void allocate();
        public native Pointer call(@Const Pointer dxpl);
    }
    public native Dxpl_copy_Pointer dxpl_copy(); public native H5FD_class_t dxpl_copy(Dxpl_copy_Pointer dxpl_copy);
    public static class Dxpl_free_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Dxpl_free_Pointer(Pointer p) { super(p); }
        protected Dxpl_free_Pointer() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(Pointer dxpl);
    }
    public native Dxpl_free_Pointer dxpl_free(); public native H5FD_class_t dxpl_free(Dxpl_free_Pointer dxpl_free);
    public static class Open_BytePointer_int_int_long extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Open_BytePointer_int_int_long(Pointer p) { super(p); }
        protected Open_BytePointer_int_int_long() { allocate(); }
        private native void allocate();
        public native H5FD_t call(@Cast("const char*") BytePointer name, @Cast("unsigned") int flags, @Cast("hid_t") int fapl,
                        @Cast("haddr_t") long maxaddr);
    }
    public native Open_BytePointer_int_int_long open(); public native H5FD_class_t open(Open_BytePointer_int_int_long open);
    public static class Close_H5FD_t extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Close_H5FD_t(Pointer p) { super(p); }
        protected Close_H5FD_t() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(H5FD_t file);
    }
    public native @Name("close") Close_H5FD_t _close(); public native H5FD_class_t _close(Close_H5FD_t _close);
    public static class Cmp_H5FD_t_H5FD_t extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Cmp_H5FD_t_H5FD_t(Pointer p) { super(p); }
        protected Cmp_H5FD_t_H5FD_t() { allocate(); }
        private native void allocate();
        public native int call(@Const H5FD_t f1, @Const H5FD_t f2);
    }
    public native Cmp_H5FD_t_H5FD_t cmp(); public native H5FD_class_t cmp(Cmp_H5FD_t_H5FD_t cmp);
    public static class Query_H5FD_t_CLongPointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Query_H5FD_t_CLongPointer(Pointer p) { super(p); }
        protected Query_H5FD_t_CLongPointer() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(@Const H5FD_t f1, @Cast("unsigned long*") CLongPointer flags);
    }
    public native Query_H5FD_t_CLongPointer query(); public native H5FD_class_t query(Query_H5FD_t_CLongPointer query);
    public static class Get_type_map_H5FD_t_IntPointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Get_type_map_H5FD_t_IntPointer(Pointer p) { super(p); }
        protected Get_type_map_H5FD_t_IntPointer() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(@Const H5FD_t file, @Cast("H5FD_mem_t*") IntPointer type_map);
    }
    public native Get_type_map_H5FD_t_IntPointer get_type_map(); public native H5FD_class_t get_type_map(Get_type_map_H5FD_t_IntPointer get_type_map);
    public static class Alloc_H5FD_t_int_int_long extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Alloc_H5FD_t_int_int_long(Pointer p) { super(p); }
        protected Alloc_H5FD_t_int_int_long() { allocate(); }
        private native void allocate();
        public native @Cast("haddr_t") long call(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") int dxpl_id, @Cast("hsize_t") long size);
    }
    public native Alloc_H5FD_t_int_int_long alloc(); public native H5FD_class_t alloc(Alloc_H5FD_t_int_int_long alloc);
    public static class Free_H5FD_t_int_int_long_long extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Free_H5FD_t_int_int_long_long(Pointer p) { super(p); }
        protected Free_H5FD_t_int_int_long_long() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") int dxpl_id,
                        @Cast("haddr_t") long addr, @Cast("hsize_t") long size);
    }
    public native Free_H5FD_t_int_int_long_long free(); public native H5FD_class_t free(Free_H5FD_t_int_int_long_long free);
    public static class Get_eoa_H5FD_t_int extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Get_eoa_H5FD_t_int(Pointer p) { super(p); }
        protected Get_eoa_H5FD_t_int() { allocate(); }
        private native void allocate();
        public native @Cast("haddr_t") long call(@Const H5FD_t file, @Cast("H5FD_mem_t") int type);
    }
    public native Get_eoa_H5FD_t_int get_eoa(); public native H5FD_class_t get_eoa(Get_eoa_H5FD_t_int get_eoa);
    public static class Set_eoa_H5FD_t_int_long extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Set_eoa_H5FD_t_int_long(Pointer p) { super(p); }
        protected Set_eoa_H5FD_t_int_long() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("haddr_t") long addr);
    }
    public native Set_eoa_H5FD_t_int_long set_eoa(); public native H5FD_class_t set_eoa(Set_eoa_H5FD_t_int_long set_eoa);
    public static class Get_eof_H5FD_t_int extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Get_eof_H5FD_t_int(Pointer p) { super(p); }
        protected Get_eof_H5FD_t_int() { allocate(); }
        private native void allocate();
        public native @Cast("haddr_t") long call(@Const H5FD_t file, @Cast("H5FD_mem_t") int type);
    }
    public native Get_eof_H5FD_t_int get_eof(); public native H5FD_class_t get_eof(Get_eof_H5FD_t_int get_eof);
    public static class Get_handle_H5FD_t_int_PointerPointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Get_handle_H5FD_t_int_PointerPointer(Pointer p) { super(p); }
        protected Get_handle_H5FD_t_int_PointerPointer() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(H5FD_t file, @Cast("hid_t") int fapl, @Cast("void**") PointerPointer file_handle);
    }
    public native Get_handle_H5FD_t_int_PointerPointer get_handle(); public native H5FD_class_t get_handle(Get_handle_H5FD_t_int_PointerPointer get_handle);
    public static class Read_H5FD_t_int_int_long_long_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Read_H5FD_t_int_int_long_long_Pointer(Pointer p) { super(p); }
        protected Read_H5FD_t_int_int_long_long_Pointer() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") int dxpl,
                        @Cast("haddr_t") long addr, @Cast("size_t") long size, Pointer buffer);
    }
    public native Read_H5FD_t_int_int_long_long_Pointer read(); public native H5FD_class_t read(Read_H5FD_t_int_int_long_long_Pointer read);
    public static class Write_H5FD_t_int_int_long_long_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Write_H5FD_t_int_int_long_long_Pointer(Pointer p) { super(p); }
        protected Write_H5FD_t_int_int_long_long_Pointer() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") int dxpl,
                         @Cast("haddr_t") long addr, @Cast("size_t") long size, @Const Pointer buffer);
    }
    public native Write_H5FD_t_int_int_long_long_Pointer write(); public native H5FD_class_t write(Write_H5FD_t_int_int_long_long_Pointer write);
    public static class Flush_H5FD_t_int_int extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Flush_H5FD_t_int_int(Pointer p) { super(p); }
        protected Flush_H5FD_t_int_int() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(H5FD_t file, @Cast("hid_t") int dxpl_id, @Cast("unsigned") int closing);
    }
    public native Flush_H5FD_t_int_int flush(); public native H5FD_class_t flush(Flush_H5FD_t_int_int flush);
    public static class Truncate_H5FD_t_int_boolean extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Truncate_H5FD_t_int_boolean(Pointer p) { super(p); }
        protected Truncate_H5FD_t_int_boolean() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(H5FD_t file, @Cast("hid_t") int dxpl_id, @Cast("hbool_t") boolean closing);
    }
    public native Truncate_H5FD_t_int_boolean truncate(); public native H5FD_class_t truncate(Truncate_H5FD_t_int_boolean truncate);
    public static class Lock_H5FD_t_boolean extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Lock_H5FD_t_boolean(Pointer p) { super(p); }
        protected Lock_H5FD_t_boolean() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(H5FD_t file, @Cast("hbool_t") boolean rw);
    }
    public native Lock_H5FD_t_boolean lock(); public native H5FD_class_t lock(Lock_H5FD_t_boolean lock);
    public static class Unlock_H5FD_t extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Unlock_H5FD_t(Pointer p) { super(p); }
        protected Unlock_H5FD_t() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(H5FD_t file);
    }
    public native Unlock_H5FD_t unlock(); public native H5FD_class_t unlock(Unlock_H5FD_t unlock);
    public native @Cast("H5FD_mem_t") int fl_map(int i); public native H5FD_class_t fl_map(int i, int fl_map);
    @MemberGetter public native @Cast("H5FD_mem_t*") IntPointer fl_map();
}

/* A free list is a singly-linked list of address/size pairs. */
public static class H5FD_free_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5FD_free_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5FD_free_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5FD_free_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5FD_free_t position(long position) {
        return (H5FD_free_t)super.position(position);
    }

    public native @Cast("haddr_t") long addr(); public native H5FD_free_t addr(long addr);
    public native @Cast("hsize_t") long size(); public native H5FD_free_t size(long size);
    public native H5FD_free_t next(); public native H5FD_free_t next(H5FD_free_t next);
}

/*
 * The main datatype for each driver. Public fields common to all drivers
 * are declared here and the driver appends private fields in memory.
 */
public static class H5FD_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5FD_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5FD_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5FD_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5FD_t position(long position) {
        return (H5FD_t)super.position(position);
    }

    public native @Cast("hid_t") int driver_id(); public native H5FD_t driver_id(int driver_id);      /*driver ID for this file   */
    @MemberGetter public native @Const H5FD_class_t cls();            /*constant class info       */
    public native @Cast("unsigned long") long fileno(); public native H5FD_t fileno(long fileno);         /* File 'serial' number     */
    public native @Cast("unsigned long") long feature_flags(); public native H5FD_t feature_flags(long feature_flags);  /* VFL Driver feature Flags */
    public native @Cast("haddr_t") long maxaddr(); public native H5FD_t maxaddr(long maxaddr);        /* For this file, overrides class */
    public native @Cast("haddr_t") long base_addr(); public native H5FD_t base_addr(long base_addr);      /* Base address for HDF5 data w/in file */
    public native @Cast("hbool_t") boolean swmr_read(); public native H5FD_t swmr_read(boolean swmr_read);	/* Whether the file is open for SWMR read access */
					/* Information from file open flags, for SWMR access */

    /* Space allocation management fields */
    public native @Cast("hsize_t") long threshold(); public native H5FD_t threshold(long threshold);      /* Threshold for alignment  */
    public native @Cast("hsize_t") long alignment(); public native H5FD_t alignment(long alignment);      /* Allocation alignment     */
}

/* Define enum for the source of file image callbacks */
/** enum H5FD_file_image_op_t */
public static final int
    H5FD_FILE_IMAGE_OP_NO_OP = 0,
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_SET = 1,     
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_COPY = 2,
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_GET = 3,
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_CLOSE = 4,
    H5FD_FILE_IMAGE_OP_FILE_OPEN = 5,
    H5FD_FILE_IMAGE_OP_FILE_RESIZE = 6,
    H5FD_FILE_IMAGE_OP_FILE_CLOSE = 7;

/* Define structure to hold file image callbacks */
public static class H5FD_file_image_callbacks_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5FD_file_image_callbacks_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5FD_file_image_callbacks_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5FD_file_image_callbacks_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5FD_file_image_callbacks_t position(long position) {
        return (H5FD_file_image_callbacks_t)super.position(position);
    }

    public static class Image_malloc_long_int_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Image_malloc_long_int_Pointer(Pointer p) { super(p); }
        protected Image_malloc_long_int_Pointer() { allocate(); }
        private native void allocate();
        public native Pointer call(@Cast("size_t") long size, @Cast("H5FD_file_image_op_t") int file_image_op, 
                                Pointer udata);
    }
    public native Image_malloc_long_int_Pointer image_malloc(); public native H5FD_file_image_callbacks_t image_malloc(Image_malloc_long_int_Pointer image_malloc);
    public static class Image_memcpy_Pointer_Pointer_long_int_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Image_memcpy_Pointer_Pointer_long_int_Pointer(Pointer p) { super(p); }
        protected Image_memcpy_Pointer_Pointer_long_int_Pointer() { allocate(); }
        private native void allocate();
        public native Pointer call(Pointer dest, @Const Pointer src, @Cast("size_t") long size,
                                @Cast("H5FD_file_image_op_t") int file_image_op, Pointer udata);
    }
    public native Image_memcpy_Pointer_Pointer_long_int_Pointer image_memcpy(); public native H5FD_file_image_callbacks_t image_memcpy(Image_memcpy_Pointer_Pointer_long_int_Pointer image_memcpy);
    public static class Image_realloc_Pointer_long_int_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Image_realloc_Pointer_long_int_Pointer(Pointer p) { super(p); }
        protected Image_realloc_Pointer_long_int_Pointer() { allocate(); }
        private native void allocate();
        public native Pointer call(Pointer ptr, @Cast("size_t") long size, 
                                @Cast("H5FD_file_image_op_t") int file_image_op, Pointer udata);
    }
    public native Image_realloc_Pointer_long_int_Pointer image_realloc(); public native H5FD_file_image_callbacks_t image_realloc(Image_realloc_Pointer_long_int_Pointer image_realloc);
    public static class Image_free_Pointer_int_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Image_free_Pointer_int_Pointer(Pointer p) { super(p); }
        protected Image_free_Pointer_int_Pointer() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(Pointer ptr, @Cast("H5FD_file_image_op_t") int file_image_op, 
                              Pointer udata);
    }
    public native Image_free_Pointer_int_Pointer image_free(); public native H5FD_file_image_callbacks_t image_free(Image_free_Pointer_int_Pointer image_free);
    public static class Udata_copy_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Udata_copy_Pointer(Pointer p) { super(p); }
        protected Udata_copy_Pointer() { allocate(); }
        private native void allocate();
        public native Pointer call(Pointer udata);
    }
    public native Udata_copy_Pointer udata_copy(); public native H5FD_file_image_callbacks_t udata_copy(Udata_copy_Pointer udata_copy);
    public static class Udata_free_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Udata_free_Pointer(Pointer p) { super(p); }
        protected Udata_free_Pointer() { allocate(); }
        private native void allocate();
        public native @Cast("herr_t") int call(Pointer udata);
    }
    public native Udata_free_Pointer udata_free(); public native H5FD_file_image_callbacks_t udata_free(Udata_free_Pointer udata_free);
    public native Pointer udata(); public native H5FD_file_image_callbacks_t udata(Pointer udata);
}

// #ifdef __cplusplus
// #endif

/* Function prototypes */
public static native @Cast("hid_t") int H5FDregister(@Const H5FD_class_t cls);
public static native @Cast("herr_t") int H5FDunregister(@Cast("hid_t") int driver_id);
public static native H5FD_t H5FDopen(@Cast("const char*") BytePointer name, @Cast("unsigned") int flags, @Cast("hid_t") int fapl_id,
                        @Cast("haddr_t") long maxaddr);
public static native H5FD_t H5FDopen(String name, @Cast("unsigned") int flags, @Cast("hid_t") int fapl_id,
                        @Cast("haddr_t") long maxaddr);
public static native @Cast("herr_t") int H5FDclose(H5FD_t file);
public static native int H5FDcmp(@Const H5FD_t f1, @Const H5FD_t f2);
public static native int H5FDquery(@Const H5FD_t f, @Cast("unsigned long*") CLongPointer flags);
public static native @Cast("haddr_t") long H5FDalloc(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") int dxpl_id, @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5FDfree(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") int dxpl_id,
                       @Cast("haddr_t") long addr, @Cast("hsize_t") long size);
public static native @Cast("haddr_t") long H5FDget_eoa(H5FD_t file, @Cast("H5FD_mem_t") int type);
public static native @Cast("herr_t") int H5FDset_eoa(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("haddr_t") long eoa);
public static native @Cast("haddr_t") long H5FDget_eof(H5FD_t file, @Cast("H5FD_mem_t") int type);
public static native @Cast("herr_t") int H5FDget_vfd_handle(H5FD_t file, @Cast("hid_t") int fapl, @Cast("void**") PointerPointer file_handle);
public static native @Cast("herr_t") int H5FDget_vfd_handle(H5FD_t file, @Cast("hid_t") int fapl, @Cast("void**") @ByPtrPtr Pointer file_handle);
public static native @Cast("herr_t") int H5FDread(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") int dxpl_id,
                       @Cast("haddr_t") long addr, @Cast("size_t") long size, Pointer buf);
public static native @Cast("herr_t") int H5FDwrite(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") int dxpl_id,
                        @Cast("haddr_t") long addr, @Cast("size_t") long size, @Const Pointer buf);
public static native @Cast("herr_t") int H5FDflush(H5FD_t file, @Cast("hid_t") int dxpl_id, @Cast("unsigned") int closing);
public static native @Cast("herr_t") int H5FDtruncate(H5FD_t file, @Cast("hid_t") int dxpl_id, @Cast("hbool_t") boolean closing);
public static native @Cast("herr_t") int H5FDlock(H5FD_t file, @Cast("hbool_t") boolean rw);
public static native @Cast("herr_t") int H5FDunlock(H5FD_t file);

// #ifdef __cplusplus
// #endif
// #endif



// Parsed from H5Gpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5Gpublic.h
 *                      Jul 11 1997
 *                      Robb Matzke <matzke@llnl.gov>
 *
 * Purpose:             Public declarations for the H5G package
 *
 *-------------------------------------------------------------------------
 */
// #ifndef _H5Gpublic_H
// #define _H5Gpublic_H

/* System headers needed by this file */
// #include <sys/types.h>

/* Public headers needed by this file */
// #include "H5public.h"		/* Generic Functions			*/
// #include "H5Lpublic.h"		/* Links                                */
// #include "H5Opublic.h"		/* Object headers			*/
// #include "H5Tpublic.h"		/* Datatypes				*/

/*****************/
/* Public Macros */
/*****************/

// #ifdef __cplusplus
// #endif

/*******************/
/* Public Typedefs */
/*******************/

/* Types of link storage for groups */
/** enum H5G_storage_type_t */
public static final int
    H5G_STORAGE_TYPE_UNKNOWN = -1,	/* Unknown link storage type	*/
    H5G_STORAGE_TYPE_SYMBOL_TABLE = 0,      /* Links in group are stored with a "symbol table" */
                                        /* (this is sometimes called "old-style" groups) */
    H5G_STORAGE_TYPE_COMPACT = 1,		/* Links are stored in object header */
    H5G_STORAGE_TYPE_DENSE = 2; 		/* Links are stored in fractal heap & indexed with v2 B-tree */

/* Information struct for group (for H5Gget_info/H5Gget_info_by_name/H5Gget_info_by_idx) */
public static class H5G_info_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5G_info_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5G_info_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5G_info_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5G_info_t position(long position) {
        return (H5G_info_t)super.position(position);
    }

    public native @Cast("H5G_storage_type_t") int storage_type(); public native H5G_info_t storage_type(int storage_type);	/* Type of storage for links in group */
    public native @Cast("hsize_t") long nlinks(); public native H5G_info_t nlinks(long nlinks);		        /* Number of links in group */
    public native @Cast("int64_t") int max_corder(); public native H5G_info_t max_corder(int max_corder);             /* Current max. creation order value for group */
    public native @Cast("hbool_t") boolean mounted(); public native H5G_info_t mounted(boolean mounted);                /* Whether group has a file mounted on it */
}

/********************/
/* Public Variables */
/********************/


/*********************/
/* Public Prototypes */
/*********************/
public static native @Cast("hid_t") int H5Gcreate2(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") int lcpl_id,
    @Cast("hid_t") int gcpl_id, @Cast("hid_t") int gapl_id);
public static native @Cast("hid_t") int H5Gcreate2(@Cast("hid_t") int loc_id, String name, @Cast("hid_t") int lcpl_id,
    @Cast("hid_t") int gcpl_id, @Cast("hid_t") int gapl_id);
public static native @Cast("hid_t") int H5Gcreate_anon(@Cast("hid_t") int loc_id, @Cast("hid_t") int gcpl_id, @Cast("hid_t") int gapl_id);
public static native @Cast("hid_t") int H5Gopen2(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") int gapl_id);
public static native @Cast("hid_t") int H5Gopen2(@Cast("hid_t") int loc_id, String name, @Cast("hid_t") int gapl_id);
public static native @Cast("hid_t") int H5Gget_create_plist(@Cast("hid_t") int group_id);
public static native @Cast("herr_t") int H5Gget_info(@Cast("hid_t") int loc_id, H5G_info_t ginfo);
public static native @Cast("herr_t") int H5Gget_info_by_name(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name, H5G_info_t ginfo,
    @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Gget_info_by_name(@Cast("hid_t") int loc_id, String name, H5G_info_t ginfo,
    @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Gget_info_by_idx(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5G_info_t ginfo,
    @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Gget_info_by_idx(@Cast("hid_t") int loc_id, String group_name,
    @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5G_info_t ginfo,
    @Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Gclose(@Cast("hid_t") int group_id);
public static native @Cast("herr_t") int H5Gflush(@Cast("hid_t") int group_id);
public static native @Cast("herr_t") int H5Grefresh(@Cast("hid_t") int group_id);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Gpublic_H */



// Parsed from H5MMpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5MMproto.h
 *                      Jul 10 1997
 *                      Robb Matzke <matzke@llnl.gov>
 *
 * Purpose:             Public declarations for the H5MM (memory management)
 *                      package.
 *
 * Modifications:
 *
 *-------------------------------------------------------------------------
 */
// #ifndef _H5MMpublic_H
// #define _H5MMpublic_H

/* Public headers needed by this file */
// #include "H5public.h"

/* These typedefs are currently used for VL datatype allocation/freeing */
public static class H5MM_allocate_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5MM_allocate_t(Pointer p) { super(p); }
    protected H5MM_allocate_t() { allocate(); }
    private native void allocate();
    public native Pointer call(@Cast("size_t") long size, Pointer alloc_info);
}
public static class H5MM_free_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5MM_free_t(Pointer p) { super(p); }
    protected H5MM_free_t() { allocate(); }
    private native void allocate();
    public native void call(Pointer mem, Pointer free_info);
}

// #ifdef __cplusplus
// #endif

// #ifdef __cplusplus
// #endif
// #endif /* _H5MMpublic_H */



// Parsed from H5Ppublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains function prototypes for each exported function in the
 * H5P module.
 */
// #ifndef _H5Ppublic_H
// #define _H5Ppublic_H

/* System headers needed by this file */

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5ACpublic.h"
// #include "H5Dpublic.h"
// #include "H5Fpublic.h"
// #include "H5FDpublic.h"
// #include "H5Ipublic.h"
// #include "H5Lpublic.h"
// #include "H5Opublic.h"
// #include "H5MMpublic.h"
// #include "H5Tpublic.h"
// #include "H5Zpublic.h"


/*****************/
/* Public Macros */
/*****************/

/* When this header is included from a private HDF5 header, don't make calls to H5open() */
// #undef H5OPEN
// #ifndef _H5private_H
// #define H5OPEN        H5open(),
// #else   /* _H5private_H */
// #define H5OPEN
// #endif  /* _H5private_H */

/*
 * The library's property list classes
 */

public static native @MemberGetter int H5P_ROOT();
public static final int H5P_ROOT = H5P_ROOT();
public static native @MemberGetter int H5P_OBJECT_CREATE();
public static final int H5P_OBJECT_CREATE = H5P_OBJECT_CREATE();
public static native @MemberGetter int H5P_FILE_CREATE();
public static final int H5P_FILE_CREATE = H5P_FILE_CREATE();
public static native @MemberGetter int H5P_FILE_ACCESS();
public static final int H5P_FILE_ACCESS = H5P_FILE_ACCESS();
public static native @MemberGetter int H5P_DATASET_CREATE();
public static final int H5P_DATASET_CREATE = H5P_DATASET_CREATE();
public static native @MemberGetter int H5P_DATASET_ACCESS();
public static final int H5P_DATASET_ACCESS = H5P_DATASET_ACCESS();
public static native @MemberGetter int H5P_DATASET_XFER();
public static final int H5P_DATASET_XFER = H5P_DATASET_XFER();
public static native @MemberGetter int H5P_FILE_MOUNT();
public static final int H5P_FILE_MOUNT = H5P_FILE_MOUNT();
public static native @MemberGetter int H5P_GROUP_CREATE();
public static final int H5P_GROUP_CREATE = H5P_GROUP_CREATE();
public static native @MemberGetter int H5P_GROUP_ACCESS();
public static final int H5P_GROUP_ACCESS = H5P_GROUP_ACCESS();
public static native @MemberGetter int H5P_DATATYPE_CREATE();
public static final int H5P_DATATYPE_CREATE = H5P_DATATYPE_CREATE();
public static native @MemberGetter int H5P_DATATYPE_ACCESS();
public static final int H5P_DATATYPE_ACCESS = H5P_DATATYPE_ACCESS();
public static native @MemberGetter int H5P_STRING_CREATE();
public static final int H5P_STRING_CREATE = H5P_STRING_CREATE();
public static native @MemberGetter int H5P_ATTRIBUTE_CREATE();
public static final int H5P_ATTRIBUTE_CREATE = H5P_ATTRIBUTE_CREATE();
public static native @MemberGetter int H5P_ATTRIBUTE_ACCESS();
public static final int H5P_ATTRIBUTE_ACCESS = H5P_ATTRIBUTE_ACCESS();
public static native @MemberGetter int H5P_OBJECT_COPY();
public static final int H5P_OBJECT_COPY = H5P_OBJECT_COPY();
public static native @MemberGetter int H5P_LINK_CREATE();
public static final int H5P_LINK_CREATE = H5P_LINK_CREATE();
public static native @MemberGetter int H5P_LINK_ACCESS();
public static final int H5P_LINK_ACCESS = H5P_LINK_ACCESS();

/*
 * The library's default property lists
 */
public static native @MemberGetter int H5P_FILE_CREATE_DEFAULT();
public static final int H5P_FILE_CREATE_DEFAULT = H5P_FILE_CREATE_DEFAULT();
public static native @MemberGetter int H5P_FILE_ACCESS_DEFAULT();
public static final int H5P_FILE_ACCESS_DEFAULT = H5P_FILE_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_DATASET_CREATE_DEFAULT();
public static final int H5P_DATASET_CREATE_DEFAULT = H5P_DATASET_CREATE_DEFAULT();
public static native @MemberGetter int H5P_DATASET_ACCESS_DEFAULT();
public static final int H5P_DATASET_ACCESS_DEFAULT = H5P_DATASET_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_DATASET_XFER_DEFAULT();
public static final int H5P_DATASET_XFER_DEFAULT = H5P_DATASET_XFER_DEFAULT();
public static native @MemberGetter int H5P_FILE_MOUNT_DEFAULT();
public static final int H5P_FILE_MOUNT_DEFAULT = H5P_FILE_MOUNT_DEFAULT();
public static native @MemberGetter int H5P_GROUP_CREATE_DEFAULT();
public static final int H5P_GROUP_CREATE_DEFAULT = H5P_GROUP_CREATE_DEFAULT();
public static native @MemberGetter int H5P_GROUP_ACCESS_DEFAULT();
public static final int H5P_GROUP_ACCESS_DEFAULT = H5P_GROUP_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_DATATYPE_CREATE_DEFAULT();
public static final int H5P_DATATYPE_CREATE_DEFAULT = H5P_DATATYPE_CREATE_DEFAULT();
public static native @MemberGetter int H5P_DATATYPE_ACCESS_DEFAULT();
public static final int H5P_DATATYPE_ACCESS_DEFAULT = H5P_DATATYPE_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_ATTRIBUTE_CREATE_DEFAULT();
public static final int H5P_ATTRIBUTE_CREATE_DEFAULT = H5P_ATTRIBUTE_CREATE_DEFAULT();
public static native @MemberGetter int H5P_ATTRIBUTE_ACCESS_DEFAULT();
public static final int H5P_ATTRIBUTE_ACCESS_DEFAULT = H5P_ATTRIBUTE_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_OBJECT_COPY_DEFAULT();
public static final int H5P_OBJECT_COPY_DEFAULT = H5P_OBJECT_COPY_DEFAULT();
public static native @MemberGetter int H5P_LINK_CREATE_DEFAULT();
public static final int H5P_LINK_CREATE_DEFAULT = H5P_LINK_CREATE_DEFAULT();
public static native @MemberGetter int H5P_LINK_ACCESS_DEFAULT();
public static final int H5P_LINK_ACCESS_DEFAULT = H5P_LINK_ACCESS_DEFAULT();

/* Common creation order flags (for links in groups and attributes on objects) */
public static final int H5P_CRT_ORDER_TRACKED =           0x0001;
public static final int H5P_CRT_ORDER_INDEXED =           0x0002;

/* Default value for all property list classes */
public static native @MemberGetter int H5P_DEFAULT();
public static final int H5P_DEFAULT = H5P_DEFAULT();

// #ifdef __cplusplus
// #endif

/*******************/
/* Public Typedefs */
/*******************/


/* Define property list class callback function pointer types */
public static class H5P_cls_create_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5P_cls_create_func_t(Pointer p) { super(p); }
    protected H5P_cls_create_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int prop_id, Pointer create_data);
}
public static class H5P_cls_copy_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5P_cls_copy_func_t(Pointer p) { super(p); }
    protected H5P_cls_copy_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int new_prop_id, @Cast("hid_t") int old_prop_id,
                                      Pointer copy_data);
}
public static class H5P_cls_close_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5P_cls_close_func_t(Pointer p) { super(p); }
    protected H5P_cls_close_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int prop_id, Pointer close_data);
}

/* Define property list callback function pointer types */
public static class H5P_prp_cb1_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5P_prp_cb1_t(Pointer p) { super(p); }
    protected H5P_prp_cb1_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("const char*") BytePointer name, @Cast("size_t") long size, Pointer value);
}
public static class H5P_prp_cb2_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5P_prp_cb2_t(Pointer p) { super(p); }
    protected H5P_prp_cb2_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int prop_id, @Cast("const char*") BytePointer name, @Cast("size_t") long size, Pointer value);
}
public static class H5P_prp_encode_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5P_prp_encode_func_t(Pointer p) { super(p); }
    protected H5P_prp_encode_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Const Pointer value, @Cast("void**") @ByPtrPtr Pointer buf, @Cast("size_t*") SizeTPointer size);
}
public static class H5P_prp_decode_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5P_prp_decode_func_t(Pointer p) { super(p); }
    protected H5P_prp_decode_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("const void**") @ByPtrPtr Pointer buf, Pointer value);
}
public static class H5P_prp_compare_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5P_prp_compare_func_t(Pointer p) { super(p); }
    protected H5P_prp_compare_func_t() { allocate(); }
    private native void allocate();
    public native int call(@Const Pointer value1, @Const Pointer value2, @Cast("size_t") long size);
}

/* Define property list iteration function type */
public static class H5P_iterate_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5P_iterate_t(Pointer p) { super(p); }
    protected H5P_iterate_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int id, @Cast("const char*") BytePointer name, Pointer iter_data);
}

/* Actual IO mode property */
/** enum H5D_mpio_actual_chunk_opt_mode_t */
public static final int
    /* The default value, H5D_MPIO_NO_CHUNK_OPTIMIZATION, is used for all I/O
     * operations that do not use chunk optimizations, including non-collective
     * I/O and contiguous collective I/O.
     */
    H5D_MPIO_NO_CHUNK_OPTIMIZATION = 0,
    H5D_MPIO_LINK_CHUNK = 1,
    H5D_MPIO_MULTI_CHUNK = 2;

/** enum H5D_mpio_actual_io_mode_t */
public static final int
    /* The following four values are conveniently defined as a bit field so that
     * we can switch from the default to indpendent or collective and then to
     * mixed without having to check the original value. 
     * 
     * NO_COLLECTIVE means that either collective I/O wasn't requested or that 
     * no I/O took place.
     *
     * CHUNK_INDEPENDENT means that collective I/O was requested, but the
     * chunk optimization scheme chose independent I/O for each chunk.
     */
    H5D_MPIO_NO_COLLECTIVE =  0x0,
    H5D_MPIO_CHUNK_INDEPENDENT =  0x1,
    H5D_MPIO_CHUNK_COLLECTIVE =  0x2,
    H5D_MPIO_CHUNK_MIXED =  0x1 | 0x2,

    /* The contiguous case is separate from the bit field. */
    H5D_MPIO_CONTIGUOUS_COLLECTIVE =  0x4; 

/* Broken collective IO property */
/** enum H5D_mpio_no_collective_cause_t */
public static final int
    H5D_MPIO_COLLECTIVE =  0x00,
    H5D_MPIO_SET_INDEPENDENT =  0x01,
    H5D_MPIO_DATATYPE_CONVERSION =  0x02,
    H5D_MPIO_DATA_TRANSFORMS =  0x04,
    H5D_MPIO_MPI_OPT_TYPES_ENV_VAR_DISABLED =  0x08,
    H5D_MPIO_NOT_SIMPLE_OR_SCALAR_DATASPACES =  0x10,
    H5D_MPIO_NOT_CONTIGUOUS_OR_CHUNKED_DATASET =  0x20,
    H5D_MPIO_FILTERS =  0x40;

/********************/
/* Public Variables */
/********************/

/* Property list class IDs */
/* (Internal to library, do not use!  Use macros above) */
public static native @Cast("hid_t") int H5P_CLS_ROOT_ID_g(); public static native void H5P_CLS_ROOT_ID_g(int H5P_CLS_ROOT_ID_g);
public static native @Cast("hid_t") int H5P_CLS_OBJECT_CREATE_ID_g(); public static native void H5P_CLS_OBJECT_CREATE_ID_g(int H5P_CLS_OBJECT_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_CLS_FILE_CREATE_ID_g(); public static native void H5P_CLS_FILE_CREATE_ID_g(int H5P_CLS_FILE_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_CLS_FILE_ACCESS_ID_g(); public static native void H5P_CLS_FILE_ACCESS_ID_g(int H5P_CLS_FILE_ACCESS_ID_g);
public static native @Cast("hid_t") int H5P_CLS_DATASET_CREATE_ID_g(); public static native void H5P_CLS_DATASET_CREATE_ID_g(int H5P_CLS_DATASET_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_CLS_DATASET_ACCESS_ID_g(); public static native void H5P_CLS_DATASET_ACCESS_ID_g(int H5P_CLS_DATASET_ACCESS_ID_g);
public static native @Cast("hid_t") int H5P_CLS_DATASET_XFER_ID_g(); public static native void H5P_CLS_DATASET_XFER_ID_g(int H5P_CLS_DATASET_XFER_ID_g);
public static native @Cast("hid_t") int H5P_CLS_FILE_MOUNT_ID_g(); public static native void H5P_CLS_FILE_MOUNT_ID_g(int H5P_CLS_FILE_MOUNT_ID_g);
public static native @Cast("hid_t") int H5P_CLS_GROUP_CREATE_ID_g(); public static native void H5P_CLS_GROUP_CREATE_ID_g(int H5P_CLS_GROUP_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_CLS_GROUP_ACCESS_ID_g(); public static native void H5P_CLS_GROUP_ACCESS_ID_g(int H5P_CLS_GROUP_ACCESS_ID_g);
public static native @Cast("hid_t") int H5P_CLS_DATATYPE_CREATE_ID_g(); public static native void H5P_CLS_DATATYPE_CREATE_ID_g(int H5P_CLS_DATATYPE_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_CLS_DATATYPE_ACCESS_ID_g(); public static native void H5P_CLS_DATATYPE_ACCESS_ID_g(int H5P_CLS_DATATYPE_ACCESS_ID_g);
public static native @Cast("hid_t") int H5P_CLS_STRING_CREATE_ID_g(); public static native void H5P_CLS_STRING_CREATE_ID_g(int H5P_CLS_STRING_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_CLS_ATTRIBUTE_CREATE_ID_g(); public static native void H5P_CLS_ATTRIBUTE_CREATE_ID_g(int H5P_CLS_ATTRIBUTE_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_CLS_ATTRIBUTE_ACCESS_ID_g(); public static native void H5P_CLS_ATTRIBUTE_ACCESS_ID_g(int H5P_CLS_ATTRIBUTE_ACCESS_ID_g);
public static native @Cast("hid_t") int H5P_CLS_OBJECT_COPY_ID_g(); public static native void H5P_CLS_OBJECT_COPY_ID_g(int H5P_CLS_OBJECT_COPY_ID_g);
public static native @Cast("hid_t") int H5P_CLS_LINK_CREATE_ID_g(); public static native void H5P_CLS_LINK_CREATE_ID_g(int H5P_CLS_LINK_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_CLS_LINK_ACCESS_ID_g(); public static native void H5P_CLS_LINK_ACCESS_ID_g(int H5P_CLS_LINK_ACCESS_ID_g);

/* Default roperty list IDs */
/* (Internal to library, do not use!  Use macros above) */
public static native @Cast("hid_t") int H5P_LST_FILE_CREATE_ID_g(); public static native void H5P_LST_FILE_CREATE_ID_g(int H5P_LST_FILE_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_LST_FILE_ACCESS_ID_g(); public static native void H5P_LST_FILE_ACCESS_ID_g(int H5P_LST_FILE_ACCESS_ID_g);
public static native @Cast("hid_t") int H5P_LST_DATASET_CREATE_ID_g(); public static native void H5P_LST_DATASET_CREATE_ID_g(int H5P_LST_DATASET_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_LST_DATASET_ACCESS_ID_g(); public static native void H5P_LST_DATASET_ACCESS_ID_g(int H5P_LST_DATASET_ACCESS_ID_g);
public static native @Cast("hid_t") int H5P_LST_DATASET_XFER_ID_g(); public static native void H5P_LST_DATASET_XFER_ID_g(int H5P_LST_DATASET_XFER_ID_g);
public static native @Cast("hid_t") int H5P_LST_FILE_MOUNT_ID_g(); public static native void H5P_LST_FILE_MOUNT_ID_g(int H5P_LST_FILE_MOUNT_ID_g);
public static native @Cast("hid_t") int H5P_LST_GROUP_CREATE_ID_g(); public static native void H5P_LST_GROUP_CREATE_ID_g(int H5P_LST_GROUP_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_LST_GROUP_ACCESS_ID_g(); public static native void H5P_LST_GROUP_ACCESS_ID_g(int H5P_LST_GROUP_ACCESS_ID_g);
public static native @Cast("hid_t") int H5P_LST_DATATYPE_CREATE_ID_g(); public static native void H5P_LST_DATATYPE_CREATE_ID_g(int H5P_LST_DATATYPE_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_LST_DATATYPE_ACCESS_ID_g(); public static native void H5P_LST_DATATYPE_ACCESS_ID_g(int H5P_LST_DATATYPE_ACCESS_ID_g);
public static native @Cast("hid_t") int H5P_LST_ATTRIBUTE_CREATE_ID_g(); public static native void H5P_LST_ATTRIBUTE_CREATE_ID_g(int H5P_LST_ATTRIBUTE_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_LST_ATTRIBUTE_ACCESS_ID_g(); public static native void H5P_LST_ATTRIBUTE_ACCESS_ID_g(int H5P_LST_ATTRIBUTE_ACCESS_ID_g);
public static native @Cast("hid_t") int H5P_LST_OBJECT_COPY_ID_g(); public static native void H5P_LST_OBJECT_COPY_ID_g(int H5P_LST_OBJECT_COPY_ID_g);
public static native @Cast("hid_t") int H5P_LST_LINK_CREATE_ID_g(); public static native void H5P_LST_LINK_CREATE_ID_g(int H5P_LST_LINK_CREATE_ID_g);
public static native @Cast("hid_t") int H5P_LST_LINK_ACCESS_ID_g(); public static native void H5P_LST_LINK_ACCESS_ID_g(int H5P_LST_LINK_ACCESS_ID_g);

/*********************/
/* Public Prototypes */
/*********************/

/* Generic property list routines */
public static native @Cast("hid_t") int H5Pcreate_class(@Cast("hid_t") int parent, @Cast("const char*") BytePointer name,
    H5P_cls_create_func_t cls_create, Pointer create_data,
    H5P_cls_copy_func_t cls_copy, Pointer copy_data,
    H5P_cls_close_func_t cls_close, Pointer close_data);
public static native @Cast("hid_t") int H5Pcreate_class(@Cast("hid_t") int parent, String name,
    H5P_cls_create_func_t cls_create, Pointer create_data,
    H5P_cls_copy_func_t cls_copy, Pointer copy_data,
    H5P_cls_close_func_t cls_close, Pointer close_data);
public static native @Cast("char*") BytePointer H5Pget_class_name(@Cast("hid_t") int pclass_id);
public static native @Cast("hid_t") int H5Pcreate(@Cast("hid_t") int cls_id);
public static native @Cast("herr_t") int H5Pregister2(@Cast("hid_t") int cls_id, @Cast("const char*") BytePointer name, @Cast("size_t") long size,
    Pointer def_value, @Cast("H5P_prp_create_func_t") H5P_prp_cb1_t prp_create,
    @Cast("H5P_prp_set_func_t") H5P_prp_cb2_t prp_set, @Cast("H5P_prp_get_func_t") H5P_prp_cb2_t prp_get,
    @Cast("H5P_prp_delete_func_t") H5P_prp_cb2_t prp_del, @Cast("H5P_prp_copy_func_t") H5P_prp_cb1_t prp_copy,
    H5P_prp_compare_func_t prp_cmp, @Cast("H5P_prp_close_func_t") H5P_prp_cb1_t prp_close);
public static native @Cast("herr_t") int H5Pregister2(@Cast("hid_t") int cls_id, String name, @Cast("size_t") long size,
    Pointer def_value, @Cast("H5P_prp_create_func_t") H5P_prp_cb1_t prp_create,
    @Cast("H5P_prp_set_func_t") H5P_prp_cb2_t prp_set, @Cast("H5P_prp_get_func_t") H5P_prp_cb2_t prp_get,
    @Cast("H5P_prp_delete_func_t") H5P_prp_cb2_t prp_del, @Cast("H5P_prp_copy_func_t") H5P_prp_cb1_t prp_copy,
    H5P_prp_compare_func_t prp_cmp, @Cast("H5P_prp_close_func_t") H5P_prp_cb1_t prp_close);
public static native @Cast("herr_t") int H5Pinsert2(@Cast("hid_t") int plist_id, @Cast("const char*") BytePointer name, @Cast("size_t") long size,
    Pointer value, @Cast("H5P_prp_set_func_t") H5P_prp_cb2_t prp_set, @Cast("H5P_prp_get_func_t") H5P_prp_cb2_t prp_get,
    @Cast("H5P_prp_delete_func_t") H5P_prp_cb2_t prp_delete, @Cast("H5P_prp_copy_func_t") H5P_prp_cb1_t prp_copy,
    H5P_prp_compare_func_t prp_cmp, @Cast("H5P_prp_close_func_t") H5P_prp_cb1_t prp_close);
public static native @Cast("herr_t") int H5Pinsert2(@Cast("hid_t") int plist_id, String name, @Cast("size_t") long size,
    Pointer value, @Cast("H5P_prp_set_func_t") H5P_prp_cb2_t prp_set, @Cast("H5P_prp_get_func_t") H5P_prp_cb2_t prp_get,
    @Cast("H5P_prp_delete_func_t") H5P_prp_cb2_t prp_delete, @Cast("H5P_prp_copy_func_t") H5P_prp_cb1_t prp_copy,
    H5P_prp_compare_func_t prp_cmp, @Cast("H5P_prp_close_func_t") H5P_prp_cb1_t prp_close);
public static native @Cast("herr_t") int H5Pset(@Cast("hid_t") int plist_id, @Cast("const char*") BytePointer name, Pointer value);
public static native @Cast("herr_t") int H5Pset(@Cast("hid_t") int plist_id, String name, Pointer value);
public static native @Cast("htri_t") int H5Pexist(@Cast("hid_t") int plist_id, @Cast("const char*") BytePointer name);
public static native @Cast("htri_t") int H5Pexist(@Cast("hid_t") int plist_id, String name);
public static native @Cast("herr_t") int H5Pencode(@Cast("hid_t") int plist_id, Pointer buf, @Cast("size_t*") SizeTPointer nalloc);
public static native @Cast("hid_t") int H5Pdecode(@Const Pointer buf);
public static native @Cast("herr_t") int H5Pget_size(@Cast("hid_t") int id, @Cast("const char*") BytePointer name, @Cast("size_t*") SizeTPointer size);
public static native @Cast("herr_t") int H5Pget_size(@Cast("hid_t") int id, String name, @Cast("size_t*") SizeTPointer size);
public static native @Cast("herr_t") int H5Pget_nprops(@Cast("hid_t") int id, @Cast("size_t*") SizeTPointer nprops);
public static native @Cast("hid_t") int H5Pget_class(@Cast("hid_t") int plist_id);
public static native @Cast("hid_t") int H5Pget_class_parent(@Cast("hid_t") int pclass_id);
public static native @Cast("herr_t") int H5Pget(@Cast("hid_t") int plist_id, @Cast("const char*") BytePointer name, Pointer value);
public static native @Cast("herr_t") int H5Pget(@Cast("hid_t") int plist_id, String name, Pointer value);
public static native @Cast("htri_t") int H5Pequal(@Cast("hid_t") int id1, @Cast("hid_t") int id2);
public static native @Cast("htri_t") int H5Pisa_class(@Cast("hid_t") int plist_id, @Cast("hid_t") int pclass_id);
public static native int H5Piterate(@Cast("hid_t") int id, IntPointer idx, H5P_iterate_t iter_func,
            Pointer iter_data);
public static native int H5Piterate(@Cast("hid_t") int id, IntBuffer idx, H5P_iterate_t iter_func,
            Pointer iter_data);
public static native int H5Piterate(@Cast("hid_t") int id, int[] idx, H5P_iterate_t iter_func,
            Pointer iter_data);
public static native @Cast("herr_t") int H5Pcopy_prop(@Cast("hid_t") int dst_id, @Cast("hid_t") int src_id, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Pcopy_prop(@Cast("hid_t") int dst_id, @Cast("hid_t") int src_id, String name);
public static native @Cast("herr_t") int H5Premove(@Cast("hid_t") int plist_id, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Premove(@Cast("hid_t") int plist_id, String name);
public static native @Cast("herr_t") int H5Punregister(@Cast("hid_t") int pclass_id, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Punregister(@Cast("hid_t") int pclass_id, String name);
public static native @Cast("herr_t") int H5Pclose_class(@Cast("hid_t") int plist_id);
public static native @Cast("herr_t") int H5Pclose(@Cast("hid_t") int plist_id);
public static native @Cast("hid_t") int H5Pcopy(@Cast("hid_t") int plist_id);

/* Object creation property list (OCPL) routines */
public static native @Cast("herr_t") int H5Pset_attr_phase_change(@Cast("hid_t") int plist_id, @Cast("unsigned") int max_compact, @Cast("unsigned") int min_dense);
public static native @Cast("herr_t") int H5Pget_attr_phase_change(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer max_compact, @Cast("unsigned*") IntPointer min_dense);
public static native @Cast("herr_t") int H5Pget_attr_phase_change(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer max_compact, @Cast("unsigned*") IntBuffer min_dense);
public static native @Cast("herr_t") int H5Pget_attr_phase_change(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] max_compact, @Cast("unsigned*") int[] min_dense);
public static native @Cast("herr_t") int H5Pset_attr_creation_order(@Cast("hid_t") int plist_id, @Cast("unsigned") int crt_order_flags);
public static native @Cast("herr_t") int H5Pget_attr_creation_order(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer crt_order_flags);
public static native @Cast("herr_t") int H5Pget_attr_creation_order(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer crt_order_flags);
public static native @Cast("herr_t") int H5Pget_attr_creation_order(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] crt_order_flags);
public static native @Cast("herr_t") int H5Pset_obj_track_times(@Cast("hid_t") int plist_id, @Cast("hbool_t") boolean track_times);
public static native @Cast("herr_t") int H5Pget_obj_track_times(@Cast("hid_t") int plist_id, @Cast("hbool_t*") BoolPointer track_times);
public static native @Cast("herr_t") int H5Pget_obj_track_times(@Cast("hid_t") int plist_id, @Cast("hbool_t*") boolean[] track_times);
public static native @Cast("herr_t") int H5Pmodify_filter(@Cast("hid_t") int plist_id, @Cast("H5Z_filter_t") int filter,
        @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
        @Cast("const unsigned int*") IntPointer cd_values);
public static native @Cast("herr_t") int H5Pmodify_filter(@Cast("hid_t") int plist_id, @Cast("H5Z_filter_t") int filter,
        @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
        @Cast("const unsigned int*") IntBuffer cd_values);
public static native @Cast("herr_t") int H5Pmodify_filter(@Cast("hid_t") int plist_id, @Cast("H5Z_filter_t") int filter,
        @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
        @Cast("const unsigned int*") int[] cd_values);
public static native @Cast("herr_t") int H5Pset_filter(@Cast("hid_t") int plist_id, @Cast("H5Z_filter_t") int filter,
        @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
        @Cast("const unsigned int*") IntPointer c_values);
public static native @Cast("herr_t") int H5Pset_filter(@Cast("hid_t") int plist_id, @Cast("H5Z_filter_t") int filter,
        @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
        @Cast("const unsigned int*") IntBuffer c_values);
public static native @Cast("herr_t") int H5Pset_filter(@Cast("hid_t") int plist_id, @Cast("H5Z_filter_t") int filter,
        @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
        @Cast("const unsigned int*") int[] c_values);
public static native int H5Pget_nfilters(@Cast("hid_t") int plist_id);
public static native @Cast("H5Z_filter_t") int H5Pget_filter2(@Cast("hid_t") int plist_id, @Cast("unsigned") int filter,
       @Cast("unsigned int*") IntPointer flags,
       @Cast("size_t*") SizeTPointer cd_nelmts,
       @Cast("unsigned*") IntPointer cd_values,
       @Cast("size_t") long namelen, @Cast("char*") BytePointer name,
       @Cast("unsigned*") IntPointer filter_config);
public static native @Cast("H5Z_filter_t") int H5Pget_filter2(@Cast("hid_t") int plist_id, @Cast("unsigned") int filter,
       @Cast("unsigned int*") IntBuffer flags,
       @Cast("size_t*") SizeTPointer cd_nelmts,
       @Cast("unsigned*") IntBuffer cd_values,
       @Cast("size_t") long namelen, @Cast("char*") ByteBuffer name,
       @Cast("unsigned*") IntBuffer filter_config);
public static native @Cast("H5Z_filter_t") int H5Pget_filter2(@Cast("hid_t") int plist_id, @Cast("unsigned") int filter,
       @Cast("unsigned int*") int[] flags,
       @Cast("size_t*") SizeTPointer cd_nelmts,
       @Cast("unsigned*") int[] cd_values,
       @Cast("size_t") long namelen, @Cast("char*") byte[] name,
       @Cast("unsigned*") int[] filter_config);
public static native @Cast("herr_t") int H5Pget_filter_by_id2(@Cast("hid_t") int plist_id, @Cast("H5Z_filter_t") int id,
       @Cast("unsigned int*") IntPointer flags, @Cast("size_t*") SizeTPointer cd_nelmts,
       @Cast("unsigned*") IntPointer cd_values, @Cast("size_t") long namelen, @Cast("char*") BytePointer name,
       @Cast("unsigned*") IntPointer filter_config);
public static native @Cast("herr_t") int H5Pget_filter_by_id2(@Cast("hid_t") int plist_id, @Cast("H5Z_filter_t") int id,
       @Cast("unsigned int*") IntBuffer flags, @Cast("size_t*") SizeTPointer cd_nelmts,
       @Cast("unsigned*") IntBuffer cd_values, @Cast("size_t") long namelen, @Cast("char*") ByteBuffer name,
       @Cast("unsigned*") IntBuffer filter_config);
public static native @Cast("herr_t") int H5Pget_filter_by_id2(@Cast("hid_t") int plist_id, @Cast("H5Z_filter_t") int id,
       @Cast("unsigned int*") int[] flags, @Cast("size_t*") SizeTPointer cd_nelmts,
       @Cast("unsigned*") int[] cd_values, @Cast("size_t") long namelen, @Cast("char*") byte[] name,
       @Cast("unsigned*") int[] filter_config);
public static native @Cast("htri_t") int H5Pall_filters_avail(@Cast("hid_t") int plist_id);
public static native @Cast("herr_t") int H5Premove_filter(@Cast("hid_t") int plist_id, @Cast("H5Z_filter_t") int filter);
public static native @Cast("herr_t") int H5Pset_deflate(@Cast("hid_t") int plist_id, @Cast("unsigned") int aggression);
public static native @Cast("herr_t") int H5Pset_fletcher32(@Cast("hid_t") int plist_id);

/* File creation property list (FCPL) routines */
public static native @Cast("herr_t") int H5Pset_userblock(@Cast("hid_t") int plist_id, @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5Pget_userblock(@Cast("hid_t") int plist_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Pget_userblock(@Cast("hid_t") int plist_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Pget_userblock(@Cast("hid_t") int plist_id, @Cast("hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Pset_sizes(@Cast("hid_t") int plist_id, @Cast("size_t") long sizeof_addr,
       @Cast("size_t") long sizeof_size);
public static native @Cast("herr_t") int H5Pget_sizes(@Cast("hid_t") int plist_id, @Cast("size_t*") SizeTPointer sizeof_addr,
       @Cast("size_t*") SizeTPointer sizeof_size);
public static native @Cast("herr_t") int H5Pset_sym_k(@Cast("hid_t") int plist_id, @Cast("unsigned") int ik, @Cast("unsigned") int lk);
public static native @Cast("herr_t") int H5Pget_sym_k(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer ik, @Cast("unsigned*") IntPointer lk);
public static native @Cast("herr_t") int H5Pget_sym_k(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer ik, @Cast("unsigned*") IntBuffer lk);
public static native @Cast("herr_t") int H5Pget_sym_k(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] ik, @Cast("unsigned*") int[] lk);
public static native @Cast("herr_t") int H5Pset_istore_k(@Cast("hid_t") int plist_id, @Cast("unsigned") int ik);
public static native @Cast("herr_t") int H5Pget_istore_k(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer ik);
public static native @Cast("herr_t") int H5Pget_istore_k(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer ik);
public static native @Cast("herr_t") int H5Pget_istore_k(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] ik);
public static native @Cast("herr_t") int H5Pset_shared_mesg_nindexes(@Cast("hid_t") int plist_id, @Cast("unsigned") int nindexes);
public static native @Cast("herr_t") int H5Pget_shared_mesg_nindexes(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer nindexes);
public static native @Cast("herr_t") int H5Pget_shared_mesg_nindexes(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer nindexes);
public static native @Cast("herr_t") int H5Pget_shared_mesg_nindexes(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] nindexes);
public static native @Cast("herr_t") int H5Pset_shared_mesg_index(@Cast("hid_t") int plist_id, @Cast("unsigned") int index_num, @Cast("unsigned") int mesg_type_flags, @Cast("unsigned") int min_mesg_size);
public static native @Cast("herr_t") int H5Pget_shared_mesg_index(@Cast("hid_t") int plist_id, @Cast("unsigned") int index_num, @Cast("unsigned*") IntPointer mesg_type_flags, @Cast("unsigned*") IntPointer min_mesg_size);
public static native @Cast("herr_t") int H5Pget_shared_mesg_index(@Cast("hid_t") int plist_id, @Cast("unsigned") int index_num, @Cast("unsigned*") IntBuffer mesg_type_flags, @Cast("unsigned*") IntBuffer min_mesg_size);
public static native @Cast("herr_t") int H5Pget_shared_mesg_index(@Cast("hid_t") int plist_id, @Cast("unsigned") int index_num, @Cast("unsigned*") int[] mesg_type_flags, @Cast("unsigned*") int[] min_mesg_size);
public static native @Cast("herr_t") int H5Pset_shared_mesg_phase_change(@Cast("hid_t") int plist_id, @Cast("unsigned") int max_list, @Cast("unsigned") int min_btree);
public static native @Cast("herr_t") int H5Pget_shared_mesg_phase_change(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer max_list, @Cast("unsigned*") IntPointer min_btree);
public static native @Cast("herr_t") int H5Pget_shared_mesg_phase_change(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer max_list, @Cast("unsigned*") IntBuffer min_btree);
public static native @Cast("herr_t") int H5Pget_shared_mesg_phase_change(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] max_list, @Cast("unsigned*") int[] min_btree);
public static native @Cast("herr_t") int H5Pset_file_space(@Cast("hid_t") int plist_id, @Cast("H5F_file_space_type_t") int strategy, @Cast("hsize_t") long threshold);
public static native @Cast("herr_t") int H5Pget_file_space(@Cast("hid_t") int plist_id, @Cast("H5F_file_space_type_t*") IntPointer strategy, @Cast("hsize_t*") LongPointer threshold);
public static native @Cast("herr_t") int H5Pget_file_space(@Cast("hid_t") int plist_id, @Cast("H5F_file_space_type_t*") IntBuffer strategy, @Cast("hsize_t*") LongBuffer threshold);
public static native @Cast("herr_t") int H5Pget_file_space(@Cast("hid_t") int plist_id, @Cast("H5F_file_space_type_t*") int[] strategy, @Cast("hsize_t*") long[] threshold);

/* File access property list (FAPL) routines */
public static native @Cast("herr_t") int H5Pset_alignment(@Cast("hid_t") int fapl_id, @Cast("hsize_t") long threshold,
    @Cast("hsize_t") long alignment);
public static native @Cast("herr_t") int H5Pget_alignment(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") LongPointer threshold,
    @Cast("hsize_t*") LongPointer alignment);
public static native @Cast("herr_t") int H5Pget_alignment(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") LongBuffer threshold,
    @Cast("hsize_t*") LongBuffer alignment);
public static native @Cast("herr_t") int H5Pget_alignment(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") long[] threshold,
    @Cast("hsize_t*") long[] alignment);
public static native @Cast("herr_t") int H5Pset_driver(@Cast("hid_t") int plist_id, @Cast("hid_t") int driver_id,
        @Const Pointer driver_info);
public static native @Cast("hid_t") int H5Pget_driver(@Cast("hid_t") int plist_id);
public static native Pointer H5Pget_driver_info(@Cast("hid_t") int plist_id);
public static native @Cast("herr_t") int H5Pset_family_offset(@Cast("hid_t") int fapl_id, @Cast("hsize_t") long offset);
public static native @Cast("herr_t") int H5Pget_family_offset(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") LongPointer offset);
public static native @Cast("herr_t") int H5Pget_family_offset(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") LongBuffer offset);
public static native @Cast("herr_t") int H5Pget_family_offset(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") long[] offset);
public static native @Cast("herr_t") int H5Pset_multi_type(@Cast("hid_t") int fapl_id, @Cast("H5FD_mem_t") int type);
public static native @Cast("herr_t") int H5Pget_multi_type(@Cast("hid_t") int fapl_id, @Cast("H5FD_mem_t*") IntPointer type);
public static native @Cast("herr_t") int H5Pget_multi_type(@Cast("hid_t") int fapl_id, @Cast("H5FD_mem_t*") IntBuffer type);
public static native @Cast("herr_t") int H5Pget_multi_type(@Cast("hid_t") int fapl_id, @Cast("H5FD_mem_t*") int[] type);
public static native @Cast("herr_t") int H5Pset_cache(@Cast("hid_t") int plist_id, int mdc_nelmts,
       @Cast("size_t") long rdcc_nslots, @Cast("size_t") long rdcc_nbytes,
       double rdcc_w0);
public static native @Cast("herr_t") int H5Pget_cache(@Cast("hid_t") int plist_id,
       IntPointer mdc_nelmts,
       @Cast("size_t*") SizeTPointer rdcc_nslots,
       @Cast("size_t*") SizeTPointer rdcc_nbytes, DoublePointer rdcc_w0);
public static native @Cast("herr_t") int H5Pget_cache(@Cast("hid_t") int plist_id,
       IntBuffer mdc_nelmts,
       @Cast("size_t*") SizeTPointer rdcc_nslots,
       @Cast("size_t*") SizeTPointer rdcc_nbytes, DoubleBuffer rdcc_w0);
public static native @Cast("herr_t") int H5Pget_cache(@Cast("hid_t") int plist_id,
       int[] mdc_nelmts,
       @Cast("size_t*") SizeTPointer rdcc_nslots,
       @Cast("size_t*") SizeTPointer rdcc_nbytes, double[] rdcc_w0);
public static native @Cast("herr_t") int H5Pset_mdc_config(@Cast("hid_t") int plist_id,
       H5AC_cache_config_t config_ptr);
public static native @Cast("herr_t") int H5Pget_mdc_config(@Cast("hid_t") int plist_id,
       H5AC_cache_config_t config_ptr);	/* out */
public static native @Cast("herr_t") int H5Pset_gc_references(@Cast("hid_t") int fapl_id, @Cast("unsigned") int gc_ref);
public static native @Cast("herr_t") int H5Pget_gc_references(@Cast("hid_t") int fapl_id, @Cast("unsigned*") IntPointer gc_ref);
public static native @Cast("herr_t") int H5Pget_gc_references(@Cast("hid_t") int fapl_id, @Cast("unsigned*") IntBuffer gc_ref);
public static native @Cast("herr_t") int H5Pget_gc_references(@Cast("hid_t") int fapl_id, @Cast("unsigned*") int[] gc_ref);
public static native @Cast("herr_t") int H5Pset_fclose_degree(@Cast("hid_t") int fapl_id, @Cast("H5F_close_degree_t") int degree);
public static native @Cast("herr_t") int H5Pget_fclose_degree(@Cast("hid_t") int fapl_id, @Cast("H5F_close_degree_t*") IntPointer degree);
public static native @Cast("herr_t") int H5Pget_fclose_degree(@Cast("hid_t") int fapl_id, @Cast("H5F_close_degree_t*") IntBuffer degree);
public static native @Cast("herr_t") int H5Pget_fclose_degree(@Cast("hid_t") int fapl_id, @Cast("H5F_close_degree_t*") int[] degree);
public static native @Cast("herr_t") int H5Pset_meta_block_size(@Cast("hid_t") int fapl_id, @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5Pget_meta_block_size(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Pget_meta_block_size(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Pget_meta_block_size(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Pset_sieve_buf_size(@Cast("hid_t") int fapl_id, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Pget_sieve_buf_size(@Cast("hid_t") int fapl_id, @Cast("size_t*") SizeTPointer size);
public static native @Cast("herr_t") int H5Pset_small_data_block_size(@Cast("hid_t") int fapl_id, @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5Pget_small_data_block_size(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Pget_small_data_block_size(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Pget_small_data_block_size(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Pset_libver_bounds(@Cast("hid_t") int plist_id, @Cast("H5F_libver_t") int low,
    @Cast("H5F_libver_t") int high);
public static native @Cast("herr_t") int H5Pget_libver_bounds(@Cast("hid_t") int plist_id, @Cast("H5F_libver_t*") IntPointer low,
    @Cast("H5F_libver_t*") IntPointer high);
public static native @Cast("herr_t") int H5Pget_libver_bounds(@Cast("hid_t") int plist_id, @Cast("H5F_libver_t*") IntBuffer low,
    @Cast("H5F_libver_t*") IntBuffer high);
public static native @Cast("herr_t") int H5Pget_libver_bounds(@Cast("hid_t") int plist_id, @Cast("H5F_libver_t*") int[] low,
    @Cast("H5F_libver_t*") int[] high);
public static native @Cast("herr_t") int H5Pset_elink_file_cache_size(@Cast("hid_t") int plist_id, @Cast("unsigned") int efc_size);
public static native @Cast("herr_t") int H5Pget_elink_file_cache_size(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer efc_size);
public static native @Cast("herr_t") int H5Pget_elink_file_cache_size(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer efc_size);
public static native @Cast("herr_t") int H5Pget_elink_file_cache_size(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] efc_size);
public static native @Cast("herr_t") int H5Pset_file_image(@Cast("hid_t") int fapl_id, Pointer buf_ptr, @Cast("size_t") long buf_len);
public static native @Cast("herr_t") int H5Pget_file_image(@Cast("hid_t") int fapl_id, @Cast("void**") PointerPointer buf_ptr_ptr, @Cast("size_t*") SizeTPointer buf_len_ptr);
public static native @Cast("herr_t") int H5Pget_file_image(@Cast("hid_t") int fapl_id, @Cast("void**") @ByPtrPtr Pointer buf_ptr_ptr, @Cast("size_t*") SizeTPointer buf_len_ptr);
public static native @Cast("herr_t") int H5Pset_file_image_callbacks(@Cast("hid_t") int fapl_id,
       H5FD_file_image_callbacks_t callbacks_ptr);
public static native @Cast("herr_t") int H5Pget_file_image_callbacks(@Cast("hid_t") int fapl_id,
       H5FD_file_image_callbacks_t callbacks_ptr);
public static native @Cast("herr_t") int H5Pset_core_write_tracking(@Cast("hid_t") int fapl_id, @Cast("hbool_t") boolean is_enabled, @Cast("size_t") long page_size);
public static native @Cast("herr_t") int H5Pget_core_write_tracking(@Cast("hid_t") int fapl_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("size_t*") SizeTPointer page_size);
public static native @Cast("herr_t") int H5Pget_core_write_tracking(@Cast("hid_t") int fapl_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("size_t*") SizeTPointer page_size);
public static native @Cast("herr_t") int H5Pset_metadata_read_attempts(@Cast("hid_t") int plist_id, @Cast("unsigned") int attempts);
public static native @Cast("herr_t") int H5Pget_metadata_read_attempts(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer attempts);
public static native @Cast("herr_t") int H5Pget_metadata_read_attempts(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer attempts);
public static native @Cast("herr_t") int H5Pget_metadata_read_attempts(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] attempts);
public static native @Cast("herr_t") int H5Pset_object_flush_cb(@Cast("hid_t") int plist_id, H5F_flush_cb_t func, Pointer udata);
public static native @Cast("herr_t") int H5Pget_object_flush_cb(@Cast("hid_t") int plist_id, @ByPtrPtr H5F_flush_cb_t func, @Cast("void**") PointerPointer udata);
public static native @Cast("herr_t") int H5Pget_object_flush_cb(@Cast("hid_t") int plist_id, @ByPtrPtr H5F_flush_cb_t func, @Cast("void**") @ByPtrPtr Pointer udata);
public static native @Cast("herr_t") int H5Pset_mdc_log_options(@Cast("hid_t") int plist_id, @Cast("hbool_t") boolean is_enabled, @Cast("const char*") BytePointer location, @Cast("hbool_t") boolean start_on_access);
public static native @Cast("herr_t") int H5Pset_mdc_log_options(@Cast("hid_t") int plist_id, @Cast("hbool_t") boolean is_enabled, String location, @Cast("hbool_t") boolean start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") int plist_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("char*") BytePointer location, @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") BoolPointer start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") int plist_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("char*") ByteBuffer location, @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") boolean[] start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") int plist_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("char*") byte[] location, @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") BoolPointer start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") int plist_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("char*") BytePointer location, @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") boolean[] start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") int plist_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("char*") ByteBuffer location, @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") BoolPointer start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") int plist_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("char*") byte[] location, @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") boolean[] start_on_access);
// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */

/* Dataset creation property list (DCPL) routines */
public static native @Cast("herr_t") int H5Pset_layout(@Cast("hid_t") int plist_id, @Cast("H5D_layout_t") int layout);
public static native @Cast("H5D_layout_t") int H5Pget_layout(@Cast("hid_t") int plist_id);
public static native @Cast("herr_t") int H5Pset_chunk(@Cast("hid_t") int plist_id, int ndims, @Cast("const hsize_t*") LongPointer dim);
public static native @Cast("herr_t") int H5Pset_chunk(@Cast("hid_t") int plist_id, int ndims, @Cast("const hsize_t*") LongBuffer dim);
public static native @Cast("herr_t") int H5Pset_chunk(@Cast("hid_t") int plist_id, int ndims, @Cast("const hsize_t*") long[] dim);
public static native int H5Pget_chunk(@Cast("hid_t") int plist_id, int max_ndims, @Cast("hsize_t*") LongPointer dim);
public static native int H5Pget_chunk(@Cast("hid_t") int plist_id, int max_ndims, @Cast("hsize_t*") LongBuffer dim);
public static native int H5Pget_chunk(@Cast("hid_t") int plist_id, int max_ndims, @Cast("hsize_t*") long[] dim);
public static native @Cast("herr_t") int H5Pset_virtual(@Cast("hid_t") int dcpl_id, @Cast("hid_t") int vspace_id,
    @Cast("const char*") BytePointer src_file_name, @Cast("const char*") BytePointer src_dset_name, @Cast("hid_t") int src_space_id);
public static native @Cast("herr_t") int H5Pset_virtual(@Cast("hid_t") int dcpl_id, @Cast("hid_t") int vspace_id,
    String src_file_name, String src_dset_name, @Cast("hid_t") int src_space_id);
public static native @Cast("herr_t") int H5Pget_virtual_count(@Cast("hid_t") int dcpl_id, @Cast("size_t*") SizeTPointer count);
public static native @Cast("hid_t") int H5Pget_virtual_vspace(@Cast("hid_t") int dcpl_id, @Cast("size_t") long index);
public static native @Cast("hid_t") int H5Pget_virtual_srcspace(@Cast("hid_t") int dcpl_id, @Cast("size_t") long index);
public static native @Cast("ssize_t") int H5Pget_virtual_filename(@Cast("hid_t") int dcpl_id, @Cast("size_t") long index,
    @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Pget_virtual_filename(@Cast("hid_t") int dcpl_id, @Cast("size_t") long index,
    @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Pget_virtual_filename(@Cast("hid_t") int dcpl_id, @Cast("size_t") long index,
    @Cast("char*") byte[] name, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Pget_virtual_dsetname(@Cast("hid_t") int dcpl_id, @Cast("size_t") long index,
    @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Pget_virtual_dsetname(@Cast("hid_t") int dcpl_id, @Cast("size_t") long index,
    @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Pget_virtual_dsetname(@Cast("hid_t") int dcpl_id, @Cast("size_t") long index,
    @Cast("char*") byte[] name, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Pset_external(@Cast("hid_t") int plist_id, @Cast("const char*") BytePointer name, @Cast("off_t") long offset,
          @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5Pset_external(@Cast("hid_t") int plist_id, String name, @Cast("off_t") long offset,
          @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5Pset_chunk_opts(@Cast("hid_t") int plist_id, @Cast("unsigned") int opts);
public static native @Cast("herr_t") int H5Pget_chunk_opts(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer opts);
public static native @Cast("herr_t") int H5Pget_chunk_opts(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer opts);
public static native @Cast("herr_t") int H5Pget_chunk_opts(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] opts);
public static native int H5Pget_external_count(@Cast("hid_t") int plist_id);
public static native @Cast("herr_t") int H5Pget_external(@Cast("hid_t") int plist_id, @Cast("unsigned") int idx, @Cast("size_t") long name_size,
          @Cast("char*") BytePointer name, @Cast("off_t*") SizeTPointer offset,
          @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Pget_external(@Cast("hid_t") int plist_id, @Cast("unsigned") int idx, @Cast("size_t") long name_size,
          @Cast("char*") ByteBuffer name, @Cast("off_t*") SizeTPointer offset,
          @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Pget_external(@Cast("hid_t") int plist_id, @Cast("unsigned") int idx, @Cast("size_t") long name_size,
          @Cast("char*") byte[] name, @Cast("off_t*") SizeTPointer offset,
          @Cast("hsize_t*") long[] size);
public static native @Cast("herr_t") int H5Pset_szip(@Cast("hid_t") int plist_id, @Cast("unsigned") int options_mask, @Cast("unsigned") int pixels_per_block);
public static native @Cast("herr_t") int H5Pset_shuffle(@Cast("hid_t") int plist_id);
public static native @Cast("herr_t") int H5Pset_nbit(@Cast("hid_t") int plist_id);
public static native @Cast("herr_t") int H5Pset_scaleoffset(@Cast("hid_t") int plist_id, @Cast("H5Z_SO_scale_type_t") int scale_type, int scale_factor);
public static native @Cast("herr_t") int H5Pset_fill_value(@Cast("hid_t") int plist_id, @Cast("hid_t") int type_id,
     @Const Pointer value);
public static native @Cast("herr_t") int H5Pget_fill_value(@Cast("hid_t") int plist_id, @Cast("hid_t") int type_id,
     Pointer value);
public static native @Cast("herr_t") int H5Pfill_value_defined(@Cast("hid_t") int plist, @Cast("H5D_fill_value_t*") IntPointer status);
public static native @Cast("herr_t") int H5Pfill_value_defined(@Cast("hid_t") int plist, @Cast("H5D_fill_value_t*") IntBuffer status);
public static native @Cast("herr_t") int H5Pfill_value_defined(@Cast("hid_t") int plist, @Cast("H5D_fill_value_t*") int[] status);
public static native @Cast("herr_t") int H5Pset_alloc_time(@Cast("hid_t") int plist_id, @Cast("H5D_alloc_time_t") int alloc_time);
public static native @Cast("herr_t") int H5Pget_alloc_time(@Cast("hid_t") int plist_id, @Cast("H5D_alloc_time_t*") IntPointer alloc_time);
public static native @Cast("herr_t") int H5Pget_alloc_time(@Cast("hid_t") int plist_id, @Cast("H5D_alloc_time_t*") IntBuffer alloc_time);
public static native @Cast("herr_t") int H5Pget_alloc_time(@Cast("hid_t") int plist_id, @Cast("H5D_alloc_time_t*") int[] alloc_time);
public static native @Cast("herr_t") int H5Pset_fill_time(@Cast("hid_t") int plist_id, @Cast("H5D_fill_time_t") int fill_time);
public static native @Cast("herr_t") int H5Pget_fill_time(@Cast("hid_t") int plist_id, @Cast("H5D_fill_time_t*") IntPointer fill_time);
public static native @Cast("herr_t") int H5Pget_fill_time(@Cast("hid_t") int plist_id, @Cast("H5D_fill_time_t*") IntBuffer fill_time);
public static native @Cast("herr_t") int H5Pget_fill_time(@Cast("hid_t") int plist_id, @Cast("H5D_fill_time_t*") int[] fill_time);

/* Dataset access property list (DAPL) routines */
public static native @Cast("herr_t") int H5Pset_chunk_cache(@Cast("hid_t") int dapl_id, @Cast("size_t") long rdcc_nslots,
       @Cast("size_t") long rdcc_nbytes, double rdcc_w0);
public static native @Cast("herr_t") int H5Pget_chunk_cache(@Cast("hid_t") int dapl_id,
       @Cast("size_t*") SizeTPointer rdcc_nslots,
       @Cast("size_t*") SizeTPointer rdcc_nbytes,
       DoublePointer rdcc_w0);
public static native @Cast("herr_t") int H5Pget_chunk_cache(@Cast("hid_t") int dapl_id,
       @Cast("size_t*") SizeTPointer rdcc_nslots,
       @Cast("size_t*") SizeTPointer rdcc_nbytes,
       DoubleBuffer rdcc_w0);
public static native @Cast("herr_t") int H5Pget_chunk_cache(@Cast("hid_t") int dapl_id,
       @Cast("size_t*") SizeTPointer rdcc_nslots,
       @Cast("size_t*") SizeTPointer rdcc_nbytes,
       double[] rdcc_w0);
public static native @Cast("herr_t") int H5Pset_virtual_view(@Cast("hid_t") int plist_id, @Cast("H5D_vds_view_t") int view);
public static native @Cast("herr_t") int H5Pget_virtual_view(@Cast("hid_t") int plist_id, @Cast("H5D_vds_view_t*") IntPointer view);
public static native @Cast("herr_t") int H5Pget_virtual_view(@Cast("hid_t") int plist_id, @Cast("H5D_vds_view_t*") IntBuffer view);
public static native @Cast("herr_t") int H5Pget_virtual_view(@Cast("hid_t") int plist_id, @Cast("H5D_vds_view_t*") int[] view);
public static native @Cast("herr_t") int H5Pset_virtual_printf_gap(@Cast("hid_t") int plist_id, @Cast("hsize_t") long gap_size);
public static native @Cast("herr_t") int H5Pget_virtual_printf_gap(@Cast("hid_t") int plist_id, @Cast("hsize_t*") LongPointer gap_size);
public static native @Cast("herr_t") int H5Pget_virtual_printf_gap(@Cast("hid_t") int plist_id, @Cast("hsize_t*") LongBuffer gap_size);
public static native @Cast("herr_t") int H5Pget_virtual_printf_gap(@Cast("hid_t") int plist_id, @Cast("hsize_t*") long[] gap_size);
public static native @Cast("herr_t") int H5Pset_append_flush(@Cast("hid_t") int plist_id, @Cast("unsigned") int ndims,
    @Cast("const hsize_t*") LongPointer boundary, H5D_append_cb_t func, Pointer udata);
public static native @Cast("herr_t") int H5Pset_append_flush(@Cast("hid_t") int plist_id, @Cast("unsigned") int ndims,
    @Cast("const hsize_t*") LongBuffer boundary, H5D_append_cb_t func, Pointer udata);
public static native @Cast("herr_t") int H5Pset_append_flush(@Cast("hid_t") int plist_id, @Cast("unsigned") int ndims,
    @Cast("const hsize_t*") long[] boundary, H5D_append_cb_t func, Pointer udata);
public static native @Cast("herr_t") int H5Pget_append_flush(@Cast("hid_t") int plist_id, @Cast("unsigned") int dims,
    @Cast("hsize_t*") LongPointer boundary, @ByPtrPtr H5D_append_cb_t func, @Cast("void**") PointerPointer udata);
public static native @Cast("herr_t") int H5Pget_append_flush(@Cast("hid_t") int plist_id, @Cast("unsigned") int dims,
    @Cast("hsize_t*") LongPointer boundary, @ByPtrPtr H5D_append_cb_t func, @Cast("void**") @ByPtrPtr Pointer udata);
public static native @Cast("herr_t") int H5Pget_append_flush(@Cast("hid_t") int plist_id, @Cast("unsigned") int dims,
    @Cast("hsize_t*") LongBuffer boundary, @ByPtrPtr H5D_append_cb_t func, @Cast("void**") @ByPtrPtr Pointer udata);
public static native @Cast("herr_t") int H5Pget_append_flush(@Cast("hid_t") int plist_id, @Cast("unsigned") int dims,
    @Cast("hsize_t*") long[] boundary, @ByPtrPtr H5D_append_cb_t func, @Cast("void**") @ByPtrPtr Pointer udata);
public static native @Cast("herr_t") int H5Pset_efile_prefix(@Cast("hid_t") int dapl_id, @Cast("const char*") BytePointer prefix);
public static native @Cast("herr_t") int H5Pset_efile_prefix(@Cast("hid_t") int dapl_id, String prefix);
public static native @Cast("ssize_t") int H5Pget_efile_prefix(@Cast("hid_t") int dapl_id, @Cast("char*") BytePointer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Pget_efile_prefix(@Cast("hid_t") int dapl_id, @Cast("char*") ByteBuffer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Pget_efile_prefix(@Cast("hid_t") int dapl_id, @Cast("char*") byte[] prefix, @Cast("size_t") long size);

/* Dataset xfer property list (DXPL) routines */
public static native @Cast("herr_t") int H5Pset_data_transform(@Cast("hid_t") int plist_id, @Cast("const char*") BytePointer expression);
public static native @Cast("herr_t") int H5Pset_data_transform(@Cast("hid_t") int plist_id, String expression);
public static native @Cast("ssize_t") int H5Pget_data_transform(@Cast("hid_t") int plist_id, @Cast("char*") BytePointer expression, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Pget_data_transform(@Cast("hid_t") int plist_id, @Cast("char*") ByteBuffer expression, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Pget_data_transform(@Cast("hid_t") int plist_id, @Cast("char*") byte[] expression, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Pset_buffer(@Cast("hid_t") int plist_id, @Cast("size_t") long size, Pointer tconv,
        Pointer bkg);
public static native @Cast("size_t") long H5Pget_buffer(@Cast("hid_t") int plist_id, @Cast("void**") PointerPointer tconv,
        @Cast("void**") PointerPointer bkg);
public static native @Cast("size_t") long H5Pget_buffer(@Cast("hid_t") int plist_id, @Cast("void**") @ByPtrPtr Pointer tconv,
        @Cast("void**") @ByPtrPtr Pointer bkg);
public static native @Cast("herr_t") int H5Pset_preserve(@Cast("hid_t") int plist_id, @Cast("hbool_t") boolean status);
public static native int H5Pget_preserve(@Cast("hid_t") int plist_id);
public static native @Cast("herr_t") int H5Pset_edc_check(@Cast("hid_t") int plist_id, @Cast("H5Z_EDC_t") int check);
public static native @Cast("H5Z_EDC_t") int H5Pget_edc_check(@Cast("hid_t") int plist_id);
public static native @Cast("herr_t") int H5Pset_filter_callback(@Cast("hid_t") int plist_id, H5Z_filter_func_t func,
                                     Pointer op_data);
public static native @Cast("herr_t") int H5Pset_btree_ratios(@Cast("hid_t") int plist_id, double left, double middle,
       double right);
public static native @Cast("herr_t") int H5Pget_btree_ratios(@Cast("hid_t") int plist_id, DoublePointer left,
       DoublePointer middle,
       DoublePointer right);
public static native @Cast("herr_t") int H5Pget_btree_ratios(@Cast("hid_t") int plist_id, DoubleBuffer left,
       DoubleBuffer middle,
       DoubleBuffer right);
public static native @Cast("herr_t") int H5Pget_btree_ratios(@Cast("hid_t") int plist_id, double[] left,
       double[] middle,
       double[] right);
public static native @Cast("herr_t") int H5Pset_vlen_mem_manager(@Cast("hid_t") int plist_id,
                                       H5MM_allocate_t alloc_func,
                                       Pointer alloc_info, H5MM_free_t free_func,
                                       Pointer free_info);
public static native @Cast("herr_t") int H5Pget_vlen_mem_manager(@Cast("hid_t") int plist_id,
                                       @ByPtrPtr H5MM_allocate_t alloc_func,
                                       @Cast("void**") PointerPointer alloc_info,
                                       @ByPtrPtr H5MM_free_t free_func,
                                       @Cast("void**") PointerPointer free_info);
public static native @Cast("herr_t") int H5Pget_vlen_mem_manager(@Cast("hid_t") int plist_id,
                                       @ByPtrPtr H5MM_allocate_t alloc_func,
                                       @Cast("void**") @ByPtrPtr Pointer alloc_info,
                                       @ByPtrPtr H5MM_free_t free_func,
                                       @Cast("void**") @ByPtrPtr Pointer free_info);
public static native @Cast("herr_t") int H5Pset_hyper_vector_size(@Cast("hid_t") int fapl_id, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Pget_hyper_vector_size(@Cast("hid_t") int fapl_id, @Cast("size_t*") SizeTPointer size);
public static native @Cast("herr_t") int H5Pset_type_conv_cb(@Cast("hid_t") int dxpl_id, H5T_conv_except_func_t op, Pointer operate_data);
public static native @Cast("herr_t") int H5Pget_type_conv_cb(@Cast("hid_t") int dxpl_id, @ByPtrPtr H5T_conv_except_func_t op, @Cast("void**") PointerPointer operate_data);
public static native @Cast("herr_t") int H5Pget_type_conv_cb(@Cast("hid_t") int dxpl_id, @ByPtrPtr H5T_conv_except_func_t op, @Cast("void**") @ByPtrPtr Pointer operate_data);
// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */

/* Link creation property list (LCPL) routines */
public static native @Cast("herr_t") int H5Pset_create_intermediate_group(@Cast("hid_t") int plist_id, @Cast("unsigned") int crt_intmd);
public static native @Cast("herr_t") int H5Pget_create_intermediate_group(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer crt_intmd);
public static native @Cast("herr_t") int H5Pget_create_intermediate_group(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer crt_intmd);
public static native @Cast("herr_t") int H5Pget_create_intermediate_group(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] crt_intmd);

/* Group creation property list (GCPL) routines */
public static native @Cast("herr_t") int H5Pset_local_heap_size_hint(@Cast("hid_t") int plist_id, @Cast("size_t") long size_hint);
public static native @Cast("herr_t") int H5Pget_local_heap_size_hint(@Cast("hid_t") int plist_id, @Cast("size_t*") SizeTPointer size_hint);
public static native @Cast("herr_t") int H5Pset_link_phase_change(@Cast("hid_t") int plist_id, @Cast("unsigned") int max_compact, @Cast("unsigned") int min_dense);
public static native @Cast("herr_t") int H5Pget_link_phase_change(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer max_compact, @Cast("unsigned*") IntPointer min_dense);
public static native @Cast("herr_t") int H5Pget_link_phase_change(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer max_compact, @Cast("unsigned*") IntBuffer min_dense);
public static native @Cast("herr_t") int H5Pget_link_phase_change(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] max_compact, @Cast("unsigned*") int[] min_dense);
public static native @Cast("herr_t") int H5Pset_est_link_info(@Cast("hid_t") int plist_id, @Cast("unsigned") int est_num_entries, @Cast("unsigned") int est_name_len);
public static native @Cast("herr_t") int H5Pget_est_link_info(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer est_num_entries, @Cast("unsigned*") IntPointer est_name_len);
public static native @Cast("herr_t") int H5Pget_est_link_info(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer est_num_entries, @Cast("unsigned*") IntBuffer est_name_len);
public static native @Cast("herr_t") int H5Pget_est_link_info(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] est_num_entries, @Cast("unsigned*") int[] est_name_len);
public static native @Cast("herr_t") int H5Pset_link_creation_order(@Cast("hid_t") int plist_id, @Cast("unsigned") int crt_order_flags);
public static native @Cast("herr_t") int H5Pget_link_creation_order(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer crt_order_flags);
public static native @Cast("herr_t") int H5Pget_link_creation_order(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer crt_order_flags);
public static native @Cast("herr_t") int H5Pget_link_creation_order(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] crt_order_flags);

/* String creation property list (STRCPL) routines */
public static native @Cast("herr_t") int H5Pset_char_encoding(@Cast("hid_t") int plist_id, @Cast("H5T_cset_t") int encoding);
public static native @Cast("herr_t") int H5Pget_char_encoding(@Cast("hid_t") int plist_id, @Cast("H5T_cset_t*") IntPointer encoding);
public static native @Cast("herr_t") int H5Pget_char_encoding(@Cast("hid_t") int plist_id, @Cast("H5T_cset_t*") IntBuffer encoding);
public static native @Cast("herr_t") int H5Pget_char_encoding(@Cast("hid_t") int plist_id, @Cast("H5T_cset_t*") int[] encoding);

/* Link access property list (LAPL) routines */
public static native @Cast("herr_t") int H5Pset_nlinks(@Cast("hid_t") int plist_id, @Cast("size_t") long nlinks);
public static native @Cast("herr_t") int H5Pget_nlinks(@Cast("hid_t") int plist_id, @Cast("size_t*") SizeTPointer nlinks);
public static native @Cast("herr_t") int H5Pset_elink_prefix(@Cast("hid_t") int plist_id, @Cast("const char*") BytePointer prefix);
public static native @Cast("herr_t") int H5Pset_elink_prefix(@Cast("hid_t") int plist_id, String prefix);
public static native @Cast("ssize_t") int H5Pget_elink_prefix(@Cast("hid_t") int plist_id, @Cast("char*") BytePointer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Pget_elink_prefix(@Cast("hid_t") int plist_id, @Cast("char*") ByteBuffer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Pget_elink_prefix(@Cast("hid_t") int plist_id, @Cast("char*") byte[] prefix, @Cast("size_t") long size);
public static native @Cast("hid_t") int H5Pget_elink_fapl(@Cast("hid_t") int lapl_id);
public static native @Cast("herr_t") int H5Pset_elink_fapl(@Cast("hid_t") int lapl_id, @Cast("hid_t") int fapl_id);
public static native @Cast("herr_t") int H5Pset_elink_acc_flags(@Cast("hid_t") int lapl_id, @Cast("unsigned") int flags);
public static native @Cast("herr_t") int H5Pget_elink_acc_flags(@Cast("hid_t") int lapl_id, @Cast("unsigned*") IntPointer flags);
public static native @Cast("herr_t") int H5Pget_elink_acc_flags(@Cast("hid_t") int lapl_id, @Cast("unsigned*") IntBuffer flags);
public static native @Cast("herr_t") int H5Pget_elink_acc_flags(@Cast("hid_t") int lapl_id, @Cast("unsigned*") int[] flags);
public static native @Cast("herr_t") int H5Pset_elink_cb(@Cast("hid_t") int lapl_id, H5L_elink_traverse_t func, Pointer op_data);
public static native @Cast("herr_t") int H5Pget_elink_cb(@Cast("hid_t") int lapl_id, @ByPtrPtr H5L_elink_traverse_t func, @Cast("void**") PointerPointer op_data);
public static native @Cast("herr_t") int H5Pget_elink_cb(@Cast("hid_t") int lapl_id, @ByPtrPtr H5L_elink_traverse_t func, @Cast("void**") @ByPtrPtr Pointer op_data);

/* Object copy property list (OCPYPL) routines */
public static native @Cast("herr_t") int H5Pset_copy_object(@Cast("hid_t") int plist_id, @Cast("unsigned") int crt_intmd);
public static native @Cast("herr_t") int H5Pget_copy_object(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntPointer crt_intmd);
public static native @Cast("herr_t") int H5Pget_copy_object(@Cast("hid_t") int plist_id, @Cast("unsigned*") IntBuffer crt_intmd);
public static native @Cast("herr_t") int H5Pget_copy_object(@Cast("hid_t") int plist_id, @Cast("unsigned*") int[] crt_intmd);
public static native @Cast("herr_t") int H5Padd_merge_committed_dtype_path(@Cast("hid_t") int plist_id, @Cast("const char*") BytePointer path);
public static native @Cast("herr_t") int H5Padd_merge_committed_dtype_path(@Cast("hid_t") int plist_id, String path);
public static native @Cast("herr_t") int H5Pfree_merge_committed_dtype_paths(@Cast("hid_t") int plist_id);
public static native @Cast("herr_t") int H5Pset_mcdt_search_cb(@Cast("hid_t") int plist_id, H5O_mcdt_search_cb_t func, Pointer op_data);
public static native @Cast("herr_t") int H5Pget_mcdt_search_cb(@Cast("hid_t") int plist_id, @ByPtrPtr H5O_mcdt_search_cb_t func, @Cast("void**") PointerPointer op_data);
public static native @Cast("herr_t") int H5Pget_mcdt_search_cb(@Cast("hid_t") int plist_id, @ByPtrPtr H5O_mcdt_search_cb_t func, @Cast("void**") @ByPtrPtr Pointer op_data);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS
// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* _H5Ppublic_H */



// Parsed from H5PLpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5. The full HDF5 copyright notice, including      *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic document set and is     *
 * linked from the top-level documents page.  It can also be found at        *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have access   *
 * to either file, you may request a copy from help@hdfgroup.org.            *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Programmer:  Raymond Lu <songyulu@hdfgroup.org>
 *              13 February 2013
 */

// #ifndef _H5PLpublic_H
// #define _H5PLpublic_H

/* Public headers needed by this file */
// #include "H5public.h"          /* Generic Functions                    */

/*******************/
/* Public Typedefs */
/*******************/

/* Plugin type used by the plugin library */
/** enum H5PL_type_t */
public static final int
    H5PL_TYPE_ERROR        = -1,  /*error                    */
    H5PL_TYPE_FILTER       = 0,   /*filter                   */
    H5PL_TYPE_NONE         = 1;    /*this must be last!       */

/* Common dynamic plugin type flags used by the set/get_loading_state functions */
public static final int H5PL_FILTER_PLUGIN = 0x0001;
public static final int H5PL_ALL_PLUGIN = 0xFFFF;

// #ifdef __cplusplus
// #endif

/* plugin state */
public static native @Cast("herr_t") int H5PLset_loading_state(@Cast("unsigned int") int plugin_type);
public static native @Cast("herr_t") int H5PLget_loading_state(@Cast("unsigned int*") IntPointer plugin_type);
public static native @Cast("herr_t") int H5PLget_loading_state(@Cast("unsigned int*") IntBuffer plugin_type);
public static native @Cast("herr_t") int H5PLget_loading_state(@Cast("unsigned int*") int[] plugin_type);

// #ifdef __cplusplus
// #endif

// #endif /* _H5PLpublic_H */



// Parsed from H5Rpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5R module.
 */
// #ifndef _H5Rpublic_H
// #define _H5Rpublic_H

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Gpublic.h"
// #include "H5Ipublic.h"

/*
 * Reference types allowed.
 */
/** enum H5R_type_t */
public static final int
    H5R_BADTYPE     =    (-1),   /*invalid Reference Type                     */
    H5R_OBJECT =    (-1) + 1,                 /*Object reference                           */
    H5R_DATASET_REGION =    (-1) + 2,         /*Dataset Region Reference                   */
    H5R_MAXTYPE =    (-1) + 3;                 /*highest type (Invalid as true type)	     */

/* Note! Be careful with the sizes of the references because they should really
 * depend on the run-time values in the file.  Unfortunately, the arrays need
 * to be defined at compile-time, so we have to go with the worst case sizes for
 * them.  -QAK
 */
public static native @MemberGetter int H5R_OBJ_REF_BUF_SIZE();
public static final int H5R_OBJ_REF_BUF_SIZE = H5R_OBJ_REF_BUF_SIZE();
/* Object reference structure for user's code */ /* Needs to be large enough to store largest haddr_t in a worst case machine (ie. 8 bytes currently) */

public static native @MemberGetter int H5R_DSET_REG_REF_BUF_SIZE();
public static final int H5R_DSET_REG_REF_BUF_SIZE = H5R_DSET_REG_REF_BUF_SIZE();
/* 4 is used instead of sizeof(int) to permit portability between
   the Crays and other machines (the heap ID is always encoded as an int32 anyway)
*/
/* Dataset Region reference structure for user's code *//* Buffer to store heap ID and index */
/* Needs to be large enough to store largest haddr_t in a worst case machine (ie. 8 bytes currently) plus an int */

/* Publicly visible data structures */

// #ifdef __cplusplus
// #endif

/* Functions in H5R.c */
public static native @Cast("herr_t") int H5Rcreate(Pointer ref, @Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name,
			 @Cast("H5R_type_t") int ref_type, @Cast("hid_t") int space_id);
public static native @Cast("herr_t") int H5Rcreate(Pointer ref, @Cast("hid_t") int loc_id, String name,
			 @Cast("H5R_type_t") int ref_type, @Cast("hid_t") int space_id);
public static native @Cast("hid_t") int H5Rdereference2(@Cast("hid_t") int obj_id, @Cast("hid_t") int oapl_id, @Cast("H5R_type_t") int ref_type, @Const Pointer ref);
public static native @Cast("hid_t") int H5Rget_region(@Cast("hid_t") int dataset, @Cast("H5R_type_t") int ref_type, @Const Pointer ref);
public static native @Cast("herr_t") int H5Rget_obj_type2(@Cast("hid_t") int id, @Cast("H5R_type_t") int ref_type, @Const Pointer _ref,
    @Cast("H5O_type_t*") IntPointer obj_type);
public static native @Cast("herr_t") int H5Rget_obj_type2(@Cast("hid_t") int id, @Cast("H5R_type_t") int ref_type, @Const Pointer _ref,
    @Cast("H5O_type_t*") IntBuffer obj_type);
public static native @Cast("herr_t") int H5Rget_obj_type2(@Cast("hid_t") int id, @Cast("H5R_type_t") int ref_type, @Const Pointer _ref,
    @Cast("H5O_type_t*") int[] obj_type);
public static native @Cast("ssize_t") int H5Rget_name(@Cast("hid_t") int loc_id, @Cast("H5R_type_t") int ref_type, @Const Pointer ref,
    @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Rget_name(@Cast("hid_t") int loc_id, @Cast("H5R_type_t") int ref_type, @Const Pointer ref,
    @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5Rget_name(@Cast("hid_t") int loc_id, @Cast("H5R_type_t") int ref_type, @Const Pointer ref,
    @Cast("char*") byte[] name, @Cast("size_t") long size);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif

// #endif  /* _H5Rpublic_H */



// Parsed from H5Spublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5S module.
 */
// #ifndef _H5Spublic_H
// #define _H5Spublic_H

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Ipublic.h"

/* Define atomic datatypes */
public static native @MemberGetter int H5S_ALL();
public static final int H5S_ALL = H5S_ALL();
public static final int H5S_UNLIMITED =   HSIZE_UNDEF;

/* Define user-level maximum number of dimensions */
public static final int H5S_MAX_RANK =    32;

/* Different types of dataspaces */
/** enum H5S_class_t */
public static final int
    H5S_NO_CLASS         = -1,  /*error                                      */
    H5S_SCALAR           = 0,   /*scalar variable                            */
    H5S_SIMPLE           = 1,   /*simple data space                          */
    H5S_NULL             = 2;    /*null data space                            */

/* Different ways of combining selections */
/** enum H5S_seloper_t */
public static final int
    H5S_SELECT_NOOP      = -1,  /* error                                     */
    H5S_SELECT_SET       = 0,   /* Select "set" operation 		     */
    H5S_SELECT_OR = 1,              /* Binary "or" operation for hyperslabs
                                 * (add new selection to existing selection)
                                 * Original region:  AAAAAAAAAA
                                 * New region:             BBBBBBBBBB
                                 * A or B:           CCCCCCCCCCCCCCCC
                                 */
    H5S_SELECT_AND = 2,             /* Binary "and" operation for hyperslabs
                                 * (only leave overlapped regions in selection)
                                 * Original region:  AAAAAAAAAA
                                 * New region:             BBBBBBBBBB
                                 * A and B:                CCCC
                                 */
    H5S_SELECT_XOR = 3,             /* Binary "xor" operation for hyperslabs
                                 * (only leave non-overlapped regions in selection)
                                 * Original region:  AAAAAAAAAA
                                 * New region:             BBBBBBBBBB
                                 * A xor B:          CCCCCC    CCCCCC
                                 */
    H5S_SELECT_NOTB = 4,            /* Binary "not" operation for hyperslabs
                                 * (only leave non-overlapped regions in original selection)
                                 * Original region:  AAAAAAAAAA
                                 * New region:             BBBBBBBBBB
                                 * A not B:          CCCCCC
                                 */
    H5S_SELECT_NOTA = 5,            /* Binary "not" operation for hyperslabs
                                 * (only leave non-overlapped regions in new selection)
                                 * Original region:  AAAAAAAAAA
                                 * New region:             BBBBBBBBBB
                                 * B not A:                    CCCCCC
                                 */
    H5S_SELECT_APPEND = 6,          /* Append elements to end of point selection */
    H5S_SELECT_PREPEND = 7,         /* Prepend elements to beginning of point selection */
    H5S_SELECT_INVALID = 8;          /* Invalid upper bound on selection operations */

/* Enumerated type for the type of selection */
/** enum H5S_sel_type */
public static final int
    H5S_SEL_ERROR	= -1, 	/* Error			*/
    H5S_SEL_NONE	= 0,    /* Nothing selected 		*/
    H5S_SEL_POINTS	= 1,    /* Sequence of points selected	*/
    H5S_SEL_HYPERSLABS  = 2,    /* "New-style" hyperslab selection defined	*/
    H5S_SEL_ALL		= 3,    /* Entire extent selected	*/
    H5S_SEL_N = 4;			/*THIS MUST BE LAST		*/

// #ifdef __cplusplus
// #endif

/* Functions in H5S.c */
public static native @Cast("hid_t") int H5Screate(@Cast("H5S_class_t") int type);
public static native @Cast("hid_t") int H5Screate_simple(int rank, @Cast("const hsize_t*") LongPointer dims,
			       @Cast("const hsize_t*") LongPointer maxdims);
public static native @Cast("hid_t") int H5Screate_simple(int rank, @Cast("const hsize_t*") LongBuffer dims,
			       @Cast("const hsize_t*") LongBuffer maxdims);
public static native @Cast("hid_t") int H5Screate_simple(int rank, @Cast("const hsize_t*") long[] dims,
			       @Cast("const hsize_t*") long[] maxdims);
public static native @Cast("herr_t") int H5Sset_extent_simple(@Cast("hid_t") int space_id, int rank,
				    @Cast("const hsize_t*") LongPointer dims,
				    @Cast("const hsize_t*") LongPointer max);
public static native @Cast("herr_t") int H5Sset_extent_simple(@Cast("hid_t") int space_id, int rank,
				    @Cast("const hsize_t*") LongBuffer dims,
				    @Cast("const hsize_t*") LongBuffer max);
public static native @Cast("herr_t") int H5Sset_extent_simple(@Cast("hid_t") int space_id, int rank,
				    @Cast("const hsize_t*") long[] dims,
				    @Cast("const hsize_t*") long[] max);
public static native @Cast("hid_t") int H5Scopy(@Cast("hid_t") int space_id);
public static native @Cast("herr_t") int H5Sclose(@Cast("hid_t") int space_id);
public static native @Cast("herr_t") int H5Sencode(@Cast("hid_t") int obj_id, Pointer buf, @Cast("size_t*") SizeTPointer nalloc);
public static native @Cast("hid_t") int H5Sdecode(@Const Pointer buf);
public static native @Cast("hssize_t") long H5Sget_simple_extent_npoints(@Cast("hid_t") int space_id);
public static native int H5Sget_simple_extent_ndims(@Cast("hid_t") int space_id);
public static native int H5Sget_simple_extent_dims(@Cast("hid_t") int space_id, @Cast("hsize_t*") LongPointer dims,
				      @Cast("hsize_t*") LongPointer maxdims);
public static native int H5Sget_simple_extent_dims(@Cast("hid_t") int space_id, @Cast("hsize_t*") LongBuffer dims,
				      @Cast("hsize_t*") LongBuffer maxdims);
public static native int H5Sget_simple_extent_dims(@Cast("hid_t") int space_id, @Cast("hsize_t*") long[] dims,
				      @Cast("hsize_t*") long[] maxdims);
public static native @Cast("htri_t") int H5Sis_simple(@Cast("hid_t") int space_id);
public static native @Cast("hssize_t") long H5Sget_select_npoints(@Cast("hid_t") int spaceid);
public static native @Cast("herr_t") int H5Sselect_hyperslab(@Cast("hid_t") int space_id, @Cast("H5S_seloper_t") int op,
				   @Cast("const hsize_t*") LongPointer start,
				   @Cast("const hsize_t*") LongPointer _stride,
				   @Cast("const hsize_t*") LongPointer count,
				   @Cast("const hsize_t*") LongPointer _block);
public static native @Cast("herr_t") int H5Sselect_hyperslab(@Cast("hid_t") int space_id, @Cast("H5S_seloper_t") int op,
				   @Cast("const hsize_t*") LongBuffer start,
				   @Cast("const hsize_t*") LongBuffer _stride,
				   @Cast("const hsize_t*") LongBuffer count,
				   @Cast("const hsize_t*") LongBuffer _block);
public static native @Cast("herr_t") int H5Sselect_hyperslab(@Cast("hid_t") int space_id, @Cast("H5S_seloper_t") int op,
				   @Cast("const hsize_t*") long[] start,
				   @Cast("const hsize_t*") long[] _stride,
				   @Cast("const hsize_t*") long[] count,
				   @Cast("const hsize_t*") long[] _block);
/* #define NEW_HYPERSLAB_API */
/* Note that these haven't been working for a while and were never
 *      publicly released - QAK */
// #ifdef NEW_HYPERSLAB_API
// #endif /* NEW_HYPERSLAB_API */
public static native @Cast("herr_t") int H5Sselect_elements(@Cast("hid_t") int space_id, @Cast("H5S_seloper_t") int op,
    @Cast("size_t") long num_elem, @Cast("const hsize_t*") LongPointer coord);
public static native @Cast("herr_t") int H5Sselect_elements(@Cast("hid_t") int space_id, @Cast("H5S_seloper_t") int op,
    @Cast("size_t") long num_elem, @Cast("const hsize_t*") LongBuffer coord);
public static native @Cast("herr_t") int H5Sselect_elements(@Cast("hid_t") int space_id, @Cast("H5S_seloper_t") int op,
    @Cast("size_t") long num_elem, @Cast("const hsize_t*") long[] coord);
public static native @Cast("H5S_class_t") int H5Sget_simple_extent_type(@Cast("hid_t") int space_id);
public static native @Cast("herr_t") int H5Sset_extent_none(@Cast("hid_t") int space_id);
public static native @Cast("herr_t") int H5Sextent_copy(@Cast("hid_t") int dst_id,@Cast("hid_t") int src_id);
public static native @Cast("htri_t") int H5Sextent_equal(@Cast("hid_t") int sid1, @Cast("hid_t") int sid2);
public static native @Cast("herr_t") int H5Sselect_all(@Cast("hid_t") int spaceid);
public static native @Cast("herr_t") int H5Sselect_none(@Cast("hid_t") int spaceid);
public static native @Cast("herr_t") int H5Soffset_simple(@Cast("hid_t") int space_id, @Cast("const hssize_t*") LongPointer offset);
public static native @Cast("herr_t") int H5Soffset_simple(@Cast("hid_t") int space_id, @Cast("const hssize_t*") LongBuffer offset);
public static native @Cast("herr_t") int H5Soffset_simple(@Cast("hid_t") int space_id, @Cast("const hssize_t*") long[] offset);
public static native @Cast("htri_t") int H5Sselect_valid(@Cast("hid_t") int spaceid);
public static native @Cast("htri_t") int H5Sis_regular_hyperslab(@Cast("hid_t") int spaceid);
public static native @Cast("htri_t") int H5Sget_regular_hyperslab(@Cast("hid_t") int spaceid, @Cast("hsize_t*") LongPointer start,
    @Cast("hsize_t*") LongPointer stride, @Cast("hsize_t*") LongPointer count, @Cast("hsize_t*") LongPointer block);
public static native @Cast("htri_t") int H5Sget_regular_hyperslab(@Cast("hid_t") int spaceid, @Cast("hsize_t*") LongBuffer start,
    @Cast("hsize_t*") LongBuffer stride, @Cast("hsize_t*") LongBuffer count, @Cast("hsize_t*") LongBuffer block);
public static native @Cast("htri_t") int H5Sget_regular_hyperslab(@Cast("hid_t") int spaceid, @Cast("hsize_t*") long[] start,
    @Cast("hsize_t*") long[] stride, @Cast("hsize_t*") long[] count, @Cast("hsize_t*") long[] block);
public static native @Cast("hssize_t") long H5Sget_select_hyper_nblocks(@Cast("hid_t") int spaceid);
public static native @Cast("hssize_t") long H5Sget_select_elem_npoints(@Cast("hid_t") int spaceid);
public static native @Cast("herr_t") int H5Sget_select_hyper_blocklist(@Cast("hid_t") int spaceid, @Cast("hsize_t") long startblock,
    @Cast("hsize_t") long numblocks, @Cast("hsize_t*") LongPointer buf);
public static native @Cast("herr_t") int H5Sget_select_hyper_blocklist(@Cast("hid_t") int spaceid, @Cast("hsize_t") long startblock,
    @Cast("hsize_t") long numblocks, @Cast("hsize_t*") LongBuffer buf);
public static native @Cast("herr_t") int H5Sget_select_hyper_blocklist(@Cast("hid_t") int spaceid, @Cast("hsize_t") long startblock,
    @Cast("hsize_t") long numblocks, @Cast("hsize_t*") long[] buf);
public static native @Cast("herr_t") int H5Sget_select_elem_pointlist(@Cast("hid_t") int spaceid, @Cast("hsize_t") long startpoint,
    @Cast("hsize_t") long numpoints, @Cast("hsize_t*") LongPointer buf);
public static native @Cast("herr_t") int H5Sget_select_elem_pointlist(@Cast("hid_t") int spaceid, @Cast("hsize_t") long startpoint,
    @Cast("hsize_t") long numpoints, @Cast("hsize_t*") LongBuffer buf);
public static native @Cast("herr_t") int H5Sget_select_elem_pointlist(@Cast("hid_t") int spaceid, @Cast("hsize_t") long startpoint,
    @Cast("hsize_t") long numpoints, @Cast("hsize_t*") long[] buf);
public static native @Cast("herr_t") int H5Sget_select_bounds(@Cast("hid_t") int spaceid, @Cast("hsize_t*") LongPointer start,
    @Cast("hsize_t*") LongPointer end);
public static native @Cast("herr_t") int H5Sget_select_bounds(@Cast("hid_t") int spaceid, @Cast("hsize_t*") LongBuffer start,
    @Cast("hsize_t*") LongBuffer end);
public static native @Cast("herr_t") int H5Sget_select_bounds(@Cast("hid_t") int spaceid, @Cast("hsize_t*") long[] start,
    @Cast("hsize_t*") long[] end);
public static native @Cast("H5S_sel_type") int H5Sget_select_type(@Cast("hid_t") int spaceid);

// #ifdef __cplusplus
// #endif
// #endif /* _H5Spublic_H */



// Parsed from H5FDcore.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Monday, August  2, 1999
 *
 * Purpose:	The public header file for the core driver.
 */
// #ifndef H5FDcore_H
// #define H5FDcore_H

public static native @MemberGetter int H5FD_CORE();
public static final int H5FD_CORE = H5FD_CORE();

// #ifdef __cplusplus
// #endif
public static native @Cast("hid_t") int H5FD_core_init();
public static native @Cast("herr_t") int H5Pset_fapl_core(@Cast("hid_t") int fapl_id, @Cast("size_t") long increment,
				@Cast("hbool_t") boolean backing_store);
public static native @Cast("herr_t") int H5Pget_fapl_core(@Cast("hid_t") int fapl_id, @Cast("size_t*") SizeTPointer increment,
				@Cast("hbool_t*") BoolPointer backing_store);
public static native @Cast("herr_t") int H5Pget_fapl_core(@Cast("hid_t") int fapl_id, @Cast("size_t*") SizeTPointer increment,
				@Cast("hbool_t*") boolean[] backing_store);
// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5FDdirect.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Raymond Lu <slu@hdfgroup.uiuc.edu>
 *              Wednesday, 20 September 2006
 *
 * Purpose:	The public header file for the direct driver.
 */
// #ifndef H5FDdirect_H
// #define H5FDdirect_H

// #ifdef H5_HAVE_DIRECT
// #else
public static final int H5FD_DIRECT =      (-1);
// #endif /* H5_HAVE_DIRECT */

// #ifdef H5_HAVE_DIRECT

// #endif /* H5_HAVE_DIRECT */

// #endif



// Parsed from H5FDfamily.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Monday, August  4, 1999
 *
 * Purpose:	The public header file for the family driver.
 */
// #ifndef H5FDfamily_H
// #define H5FDfamily_H

public static native @MemberGetter int H5FD_FAMILY();
public static final int H5FD_FAMILY = H5FD_FAMILY();

// #ifdef __cplusplus
// #endif

public static native @Cast("hid_t") int H5FD_family_init();
public static native @Cast("herr_t") int H5Pset_fapl_family(@Cast("hid_t") int fapl_id, @Cast("hsize_t") long memb_size,
			  @Cast("hid_t") int memb_fapl_id);
public static native @Cast("herr_t") int H5Pget_fapl_family(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") LongPointer memb_size,
			  @Cast("hid_t*") IntPointer memb_fapl_id);
public static native @Cast("herr_t") int H5Pget_fapl_family(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") LongBuffer memb_size,
			  @Cast("hid_t*") IntBuffer memb_fapl_id);
public static native @Cast("herr_t") int H5Pget_fapl_family(@Cast("hid_t") int fapl_id, @Cast("hsize_t*") long[] memb_size,
			  @Cast("hid_t*") int[] memb_fapl_id);

// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5FDlog.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Quincey Koziol <koziol@ncsa.uiuc.edu>
 *              Monday, April 17, 2000
 *
 * Purpose:	The public header file for the log driver.
 */
// #ifndef H5FDlog_H
// #define H5FDlog_H

public static native @MemberGetter int H5FD_LOG();
public static final int H5FD_LOG = H5FD_LOG();

/* Flags for H5Pset_fapl_log() */
/* Flags for tracking where reads/writes/seeks occur */
public static final int H5FD_LOG_LOC_READ =   0x00000001;
public static final int H5FD_LOG_LOC_WRITE =  0x00000002;
public static final int H5FD_LOG_LOC_SEEK =   0x00000004;
public static final int H5FD_LOG_LOC_IO =     (H5FD_LOG_LOC_READ|H5FD_LOG_LOC_WRITE|H5FD_LOG_LOC_SEEK);
/* Flags for tracking number of times each byte is read/written */
public static final int H5FD_LOG_FILE_READ =  0x00000008;
public static final int H5FD_LOG_FILE_WRITE = 0x00000010;
public static final int H5FD_LOG_FILE_IO =    (H5FD_LOG_FILE_READ|H5FD_LOG_FILE_WRITE);
/* Flag for tracking "flavor" (type) of information stored at each byte */
public static final int H5FD_LOG_FLAVOR =     0x00000020;
/* Flags for tracking total number of reads/writes/seeks/truncates */
public static final int H5FD_LOG_NUM_READ =   0x00000040;
public static final int H5FD_LOG_NUM_WRITE =  0x00000080;
public static final int H5FD_LOG_NUM_SEEK =   0x00000100;
public static final int H5FD_LOG_NUM_TRUNCATE = 0x00000200;
public static final int H5FD_LOG_NUM_IO =     (H5FD_LOG_NUM_READ|H5FD_LOG_NUM_WRITE|H5FD_LOG_NUM_SEEK|H5FD_LOG_NUM_TRUNCATE);
/* Flags for tracking time spent in open/stat/read/write/seek/close */
public static final int H5FD_LOG_TIME_OPEN =  0x00000400;
public static final int H5FD_LOG_TIME_STAT =  0x00000800;
public static final int H5FD_LOG_TIME_READ =  0x00001000;
public static final int H5FD_LOG_TIME_WRITE = 0x00002000;
public static final int H5FD_LOG_TIME_SEEK =  0x00004000;
public static final int H5FD_LOG_TIME_CLOSE = 0x00008000;
public static final int H5FD_LOG_TIME_IO =    (H5FD_LOG_TIME_OPEN|H5FD_LOG_TIME_STAT|H5FD_LOG_TIME_READ|H5FD_LOG_TIME_WRITE|H5FD_LOG_TIME_SEEK|H5FD_LOG_TIME_CLOSE);
/* Flag for tracking allocation of space in file */
public static final int H5FD_LOG_ALLOC =      0x00010000;
public static final int H5FD_LOG_ALL =        (H5FD_LOG_ALLOC|H5FD_LOG_TIME_IO|H5FD_LOG_NUM_IO|H5FD_LOG_FLAVOR|H5FD_LOG_FILE_IO|H5FD_LOG_LOC_IO);

// #ifdef __cplusplus
// #endif

public static native @Cast("hid_t") int H5FD_log_init();
public static native @Cast("herr_t") int H5Pset_fapl_log(@Cast("hid_t") int fapl_id, @Cast("const char*") BytePointer logfile, @Cast("unsigned long long") long flags, @Cast("size_t") long buf_size);
public static native @Cast("herr_t") int H5Pset_fapl_log(@Cast("hid_t") int fapl_id, String logfile, @Cast("unsigned long long") long flags, @Cast("size_t") long buf_size);

// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5FDmpi.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Quincey Koziol <koziol@ncsa.uiuc.edu>
 *              Friday, January 30, 2004
 *
 * Purpose:	The public header file for common items for all MPI VFL drivers
 */
// #ifndef H5FDmpi_H
// #define H5FDmpi_H

/***** Macros for One linked collective IO case. *****/
/* The default value to do one linked collective IO for all chunks.
   If the average number of chunks per process is greater than this value,
      the library will create an MPI derived datatype to link all chunks to do collective IO.
      The user can set this value through an API. */

public static final int H5D_ONE_LINK_CHUNK_IO_THRESHOLD = 0;
/***** Macros for multi-chunk collective IO case. *****/
/* The default value of the threshold to do collective IO for this chunk.
   If the average percentage of processes per chunk is greater than the default value,
   collective IO is done for this chunk.
*/

public static final int H5D_MULTI_CHUNK_IO_COL_THRESHOLD = 60;
/* Type of I/O for data transfer properties */
/** enum H5FD_mpio_xfer_t */
public static final int
    H5FD_MPIO_INDEPENDENT = 0, 		/*zero is the default*/
    H5FD_MPIO_COLLECTIVE = 1;

/* Type of chunked dataset I/O */
/** enum H5FD_mpio_chunk_opt_t */
public static final int
    H5FD_MPIO_CHUNK_DEFAULT = 0,
    H5FD_MPIO_CHUNK_ONE_IO = 1,  		/*zero is the default*/
    H5FD_MPIO_CHUNK_MULTI_IO = 2;

/* Type of collective I/O */
/** enum H5FD_mpio_collective_opt_t */
public static final int
    H5FD_MPIO_COLLECTIVE_IO = 0,
    H5FD_MPIO_INDIVIDUAL_IO = 1;  		/*zero is the default*/

/* Include all the MPI VFL headers */
// #include "H5FDmpio.h"           /* MPI I/O file driver			*/

// #endif /* H5FDmpi_H */



// Parsed from H5FDmulti.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Monday, August  2, 1999
 *
 * Purpose:	The public header file for the "multi" driver.
 */
// #ifndef H5FDmulti_H
// #define H5FDmulti_H

public static native @MemberGetter int H5FD_MULTI();
public static final int H5FD_MULTI = H5FD_MULTI();

// #ifdef __cplusplus
// #endif
public static native @Cast("hid_t") int H5FD_multi_init();
public static native @Cast("herr_t") int H5Pset_fapl_multi(@Cast("hid_t") int fapl_id, @Cast("const H5FD_mem_t*") IntPointer memb_map,
			 @Cast("const hid_t*") IntPointer memb_fapl, @Cast("const char*const*") PointerPointer memb_name,
			 @Cast("const haddr_t*") LongPointer memb_addr, @Cast("hbool_t") boolean relax);
public static native @Cast("herr_t") int H5Pset_fapl_multi(@Cast("hid_t") int fapl_id, @Cast("const H5FD_mem_t*") IntPointer memb_map,
			 @Cast("const hid_t*") IntPointer memb_fapl, @Cast("const char*const*") @ByPtrPtr BytePointer memb_name,
			 @Cast("const haddr_t*") LongPointer memb_addr, @Cast("hbool_t") boolean relax);
public static native @Cast("herr_t") int H5Pset_fapl_multi(@Cast("hid_t") int fapl_id, @Cast("const H5FD_mem_t*") IntBuffer memb_map,
			 @Cast("const hid_t*") IntBuffer memb_fapl, @Cast("const char*const*") @ByPtrPtr ByteBuffer memb_name,
			 @Cast("const haddr_t*") LongBuffer memb_addr, @Cast("hbool_t") boolean relax);
public static native @Cast("herr_t") int H5Pset_fapl_multi(@Cast("hid_t") int fapl_id, @Cast("const H5FD_mem_t*") int[] memb_map,
			 @Cast("const hid_t*") int[] memb_fapl, @Cast("const char*const*") @ByPtrPtr byte[] memb_name,
			 @Cast("const haddr_t*") long[] memb_addr, @Cast("hbool_t") boolean relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") int fapl_id, @Cast("H5FD_mem_t*") IntPointer memb_map,
			 @Cast("hid_t*") IntPointer memb_fapl, @Cast("char**") PointerPointer memb_name,
			 @Cast("haddr_t*") LongPointer memb_addr, @Cast("hbool_t*") BoolPointer relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") int fapl_id, @Cast("H5FD_mem_t*") IntPointer memb_map,
			 @Cast("hid_t*") IntPointer memb_fapl, @Cast("char**") @ByPtrPtr BytePointer memb_name,
			 @Cast("haddr_t*") LongPointer memb_addr, @Cast("hbool_t*") BoolPointer relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") int fapl_id, @Cast("H5FD_mem_t*") IntBuffer memb_map,
			 @Cast("hid_t*") IntBuffer memb_fapl, @Cast("char**") @ByPtrPtr ByteBuffer memb_name,
			 @Cast("haddr_t*") LongBuffer memb_addr, @Cast("hbool_t*") boolean[] relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") int fapl_id, @Cast("H5FD_mem_t*") int[] memb_map,
			 @Cast("hid_t*") int[] memb_fapl, @Cast("char**") @ByPtrPtr byte[] memb_name,
			 @Cast("haddr_t*") long[] memb_addr, @Cast("hbool_t*") BoolPointer relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") int fapl_id, @Cast("H5FD_mem_t*") IntPointer memb_map,
			 @Cast("hid_t*") IntPointer memb_fapl, @Cast("char**") @ByPtrPtr BytePointer memb_name,
			 @Cast("haddr_t*") LongPointer memb_addr, @Cast("hbool_t*") boolean[] relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") int fapl_id, @Cast("H5FD_mem_t*") IntBuffer memb_map,
			 @Cast("hid_t*") IntBuffer memb_fapl, @Cast("char**") @ByPtrPtr ByteBuffer memb_name,
			 @Cast("haddr_t*") LongBuffer memb_addr, @Cast("hbool_t*") BoolPointer relax);
public static native @Cast("herr_t") int H5Pget_fapl_multi(@Cast("hid_t") int fapl_id, @Cast("H5FD_mem_t*") int[] memb_map,
			 @Cast("hid_t*") int[] memb_fapl, @Cast("char**") @ByPtrPtr byte[] memb_name,
			 @Cast("haddr_t*") long[] memb_addr, @Cast("hbool_t*") boolean[] relax);
public static native @Cast("herr_t") int H5Pset_fapl_split(@Cast("hid_t") int fapl, @Cast("const char*") BytePointer meta_ext,
			 @Cast("hid_t") int meta_plist_id, @Cast("const char*") BytePointer raw_ext,
			 @Cast("hid_t") int raw_plist_id);
public static native @Cast("herr_t") int H5Pset_fapl_split(@Cast("hid_t") int fapl, String meta_ext,
			 @Cast("hid_t") int meta_plist_id, String raw_ext,
			 @Cast("hid_t") int raw_plist_id);
// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5FDsec2.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Monday, August  2, 1999
 *
 * Purpose:	The public header file for the sec2 driver.
 */
// #ifndef H5FDsec2_H
// #define H5FDsec2_H

public static native @MemberGetter int H5FD_SEC2();
public static final int H5FD_SEC2 = H5FD_SEC2();

// #ifdef __cplusplus
// #endif

public static native @Cast("hid_t") int H5FD_sec2_init();
public static native @Cast("herr_t") int H5Pset_fapl_sec2(@Cast("hid_t") int fapl_id);

// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5FDstdio.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Robb Matzke <matzke@llnl.gov>
 *              Monday, August  2, 1999
 *
 * Purpose:	The public header file for the sec2 driver.
 */
// #ifndef H5FDstdio_H
// #define H5FDstdio_H

// #include "H5Ipublic.h"

public static native @MemberGetter int H5FD_STDIO();
public static final int H5FD_STDIO = H5FD_STDIO();

// #ifdef __cplusplus
// #endif

public static native @Cast("hid_t") int H5FD_stdio_init();
public static native @Cast("herr_t") int H5Pset_fapl_stdio(@Cast("hid_t") int fapl_id);

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from H5DOpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5DOpublic_H
// #define _H5DOpublic_H

// #ifdef __cplusplus
// #endif

/*-------------------------------------------------------------------------
 *
 * "Optimized dataset" routines.
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5DOwrite_chunk(@Cast("hid_t") int dset_id, @Cast("hid_t") int dxpl_id, @Cast("uint32_t") short filters, 
    @Cast("const hsize_t*") LongPointer offset, @Cast("size_t") long data_size, @Const Pointer buf);
public static native @Cast("herr_t") int H5DOwrite_chunk(@Cast("hid_t") int dset_id, @Cast("hid_t") int dxpl_id, @Cast("uint32_t") short filters, 
    @Cast("const hsize_t*") LongBuffer offset, @Cast("size_t") long data_size, @Const Pointer buf);
public static native @Cast("herr_t") int H5DOwrite_chunk(@Cast("hid_t") int dset_id, @Cast("hid_t") int dxpl_id, @Cast("uint32_t") short filters, 
    @Cast("const hsize_t*") long[] offset, @Cast("size_t") long data_size, @Const Pointer buf);

public static native @Cast("herr_t") int H5DOappend(@Cast("hid_t") int dset_id, @Cast("hid_t") int dxpl_id, @Cast("unsigned") int axis,
    @Cast("size_t") long extension, @Cast("hid_t") int memtype, @Const Pointer buf);

// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5DSpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5DSpublic_H
// #define _H5DSpublic_H



public static final String DIMENSION_SCALE_CLASS = "DIMENSION_SCALE";
public static final String DIMENSION_LIST =        "DIMENSION_LIST";
public static final String REFERENCE_LIST =        "REFERENCE_LIST";
public static final String DIMENSION_LABELS =      "DIMENSION_LABELS";


public static class H5DS_iterate_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5DS_iterate_t(Pointer p) { super(p); }
    protected H5DS_iterate_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("hid_t") int dset, @Cast("unsigned") int dim, @Cast("hid_t") int scale, Pointer visitor_data);
}


// #ifdef __cplusplus
// #endif

public static native @Cast("herr_t") int H5DSattach_scale( @Cast("hid_t") int did,
                        @Cast("hid_t") int dsid,
                        @Cast("unsigned int") int idx);

public static native @Cast("herr_t") int H5DSdetach_scale( @Cast("hid_t") int did,
                        @Cast("hid_t") int dsid,
                        @Cast("unsigned int") int idx);

public static native @Cast("herr_t") int H5DSset_scale( @Cast("hid_t") int dsid,
                     @Cast("const char*") BytePointer dimname);
public static native @Cast("herr_t") int H5DSset_scale( @Cast("hid_t") int dsid,
                     String dimname);

public static native int H5DSget_num_scales( @Cast("hid_t") int did,
                       @Cast("unsigned int") int dim);

public static native @Cast("herr_t") int H5DSset_label( @Cast("hid_t") int did,
                     @Cast("unsigned int") int idx,
                     @Cast("const char*") BytePointer label);
public static native @Cast("herr_t") int H5DSset_label( @Cast("hid_t") int did,
                     @Cast("unsigned int") int idx,
                     String label);

public static native @Cast("ssize_t") int H5DSget_label( @Cast("hid_t") int did,
                      @Cast("unsigned int") int idx,
                      @Cast("char*") BytePointer label,
                      @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5DSget_label( @Cast("hid_t") int did,
                      @Cast("unsigned int") int idx,
                      @Cast("char*") ByteBuffer label,
                      @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5DSget_label( @Cast("hid_t") int did,
                      @Cast("unsigned int") int idx,
                      @Cast("char*") byte[] label,
                      @Cast("size_t") long size);

public static native @Cast("ssize_t") int H5DSget_scale_name( @Cast("hid_t") int did,
                           @Cast("char*") BytePointer name,
                           @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5DSget_scale_name( @Cast("hid_t") int did,
                           @Cast("char*") ByteBuffer name,
                           @Cast("size_t") long size);
public static native @Cast("ssize_t") int H5DSget_scale_name( @Cast("hid_t") int did,
                           @Cast("char*") byte[] name,
                           @Cast("size_t") long size);

public static native @Cast("htri_t") int H5DSis_scale( @Cast("hid_t") int did);

public static native @Cast("herr_t") int H5DSiterate_scales( @Cast("hid_t") int did,
                          @Cast("unsigned int") int dim,
                          IntPointer idx,
                          H5DS_iterate_t visitor,
                          Pointer visitor_data);
public static native @Cast("herr_t") int H5DSiterate_scales( @Cast("hid_t") int did,
                          @Cast("unsigned int") int dim,
                          IntBuffer idx,
                          H5DS_iterate_t visitor,
                          Pointer visitor_data);
public static native @Cast("herr_t") int H5DSiterate_scales( @Cast("hid_t") int did,
                          @Cast("unsigned int") int dim,
                          int[] idx,
                          H5DS_iterate_t visitor,
                          Pointer visitor_data);

public static native @Cast("htri_t") int H5DSis_attached( @Cast("hid_t") int did,
                       @Cast("hid_t") int dsid,
                       @Cast("unsigned int") int idx);



// #ifdef __cplusplus
// #endif

// #endif


// Parsed from H5LTpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5LTpublic_H
// #define _H5LTpublic_H

/* Flag definitions for H5LTopen_file_image() */
public static final int H5LT_FILE_IMAGE_OPEN_RW =      0x0001; /* Open image for read-write */
public static final int H5LT_FILE_IMAGE_DONT_COPY =    0x0002; /* The HDF5 lib won't copy   */
/* user supplied image buffer. The same image is open with the core driver.  */
public static final int H5LT_FILE_IMAGE_DONT_RELEASE = 0x0004; /* The HDF5 lib won't        */
/* deallocate user supplied image buffer. The user application is reponsible */
/* for doing so.                                                             */ 
public static final int H5LT_FILE_IMAGE_ALL =          0x0007;

/** enum H5LT_lang_t */
public static final int
    H5LT_LANG_ERR = -1, /*this is the first*/
    H5LT_DDL      = 0,  /*for DDL*/
    H5LT_C        = 1,  /*for C*/
    H5LT_FORTRAN  = 2,  /*for Fortran*/
    H5LT_NO_LANG  = 3;   /*this is the last*/

// #ifdef __cplusplus
// #endif

/*-------------------------------------------------------------------------
 *
 * Make dataset functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5LTmake_dataset( @Cast("hid_t") int loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         int rank,
                         @Cast("const hsize_t*") LongPointer dims,
                         @Cast("hid_t") int type_id,
                         @Const Pointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset( @Cast("hid_t") int loc_id,
                         String dset_name,
                         int rank,
                         @Cast("const hsize_t*") LongBuffer dims,
                         @Cast("hid_t") int type_id,
                         @Const Pointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset( @Cast("hid_t") int loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         int rank,
                         @Cast("const hsize_t*") long[] dims,
                         @Cast("hid_t") int type_id,
                         @Const Pointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset( @Cast("hid_t") int loc_id,
                         String dset_name,
                         int rank,
                         @Cast("const hsize_t*") LongPointer dims,
                         @Cast("hid_t") int type_id,
                         @Const Pointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset( @Cast("hid_t") int loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         int rank,
                         @Cast("const hsize_t*") LongBuffer dims,
                         @Cast("hid_t") int type_id,
                         @Const Pointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset( @Cast("hid_t") int loc_id,
                         String dset_name,
                         int rank,
                         @Cast("const hsize_t*") long[] dims,
                         @Cast("hid_t") int type_id,
                         @Const Pointer buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_char( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongPointer dims,
                              @Cast("const char*") BytePointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_char( @Cast("hid_t") int loc_id,
                              String dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongBuffer dims,
                              String buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_char( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              int rank,
                              @Cast("const hsize_t*") long[] dims,
                              @Cast("const char*") BytePointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_char( @Cast("hid_t") int loc_id,
                              String dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongPointer dims,
                              String buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_char( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongBuffer dims,
                              @Cast("const char*") BytePointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_char( @Cast("hid_t") int loc_id,
                              String dset_name,
                              int rank,
                              @Cast("const hsize_t*") long[] dims,
                              String buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_short( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongPointer dims,
                               @Const ShortPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_short( @Cast("hid_t") int loc_id,
                               String dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongBuffer dims,
                               @Const ShortBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_short( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               int rank,
                               @Cast("const hsize_t*") long[] dims,
                               @Const short[] buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_short( @Cast("hid_t") int loc_id,
                               String dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongPointer dims,
                               @Const ShortPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_short( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongBuffer dims,
                               @Const ShortBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_short( @Cast("hid_t") int loc_id,
                               String dset_name,
                               int rank,
                               @Cast("const hsize_t*") long[] dims,
                               @Const short[] buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_int( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             int rank,
                             @Cast("const hsize_t*") LongPointer dims,
                             @Const IntPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_int( @Cast("hid_t") int loc_id,
                             String dset_name,
                             int rank,
                             @Cast("const hsize_t*") LongBuffer dims,
                             @Const IntBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_int( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             int rank,
                             @Cast("const hsize_t*") long[] dims,
                             @Const int[] buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_int( @Cast("hid_t") int loc_id,
                             String dset_name,
                             int rank,
                             @Cast("const hsize_t*") LongPointer dims,
                             @Const IntPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_int( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             int rank,
                             @Cast("const hsize_t*") LongBuffer dims,
                             @Const IntBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_int( @Cast("hid_t") int loc_id,
                             String dset_name,
                             int rank,
                             @Cast("const hsize_t*") long[] dims,
                             @Const int[] buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_long( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongPointer dims,
                              @Const CLongPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_long( @Cast("hid_t") int loc_id,
                              String dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongBuffer dims,
                              @Const CLongPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_long( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              int rank,
                              @Cast("const hsize_t*") long[] dims,
                              @Const CLongPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_long( @Cast("hid_t") int loc_id,
                              String dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongPointer dims,
                              @Const CLongPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_long( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              int rank,
                              @Cast("const hsize_t*") LongBuffer dims,
                              @Const CLongPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_long( @Cast("hid_t") int loc_id,
                              String dset_name,
                              int rank,
                              @Cast("const hsize_t*") long[] dims,
                              @Const CLongPointer buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_float( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongPointer dims,
                               @Const FloatPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_float( @Cast("hid_t") int loc_id,
                               String dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongBuffer dims,
                               @Const FloatBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_float( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               int rank,
                               @Cast("const hsize_t*") long[] dims,
                               @Const float[] buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_float( @Cast("hid_t") int loc_id,
                               String dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongPointer dims,
                               @Const FloatPointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_float( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               int rank,
                               @Cast("const hsize_t*") LongBuffer dims,
                               @Const FloatBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_float( @Cast("hid_t") int loc_id,
                               String dset_name,
                               int rank,
                               @Cast("const hsize_t*") long[] dims,
                               @Const float[] buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_double( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                int rank,
                                @Cast("const hsize_t*") LongPointer dims,
                                @Const DoublePointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_double( @Cast("hid_t") int loc_id,
                                String dset_name,
                                int rank,
                                @Cast("const hsize_t*") LongBuffer dims,
                                @Const DoubleBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_double( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                int rank,
                                @Cast("const hsize_t*") long[] dims,
                                @Const double[] buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_double( @Cast("hid_t") int loc_id,
                                String dset_name,
                                int rank,
                                @Cast("const hsize_t*") LongPointer dims,
                                @Const DoublePointer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_double( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                int rank,
                                @Cast("const hsize_t*") LongBuffer dims,
                                @Const DoubleBuffer buffer );
public static native @Cast("herr_t") int H5LTmake_dataset_double( @Cast("hid_t") int loc_id,
                                String dset_name,
                                int rank,
                                @Cast("const hsize_t*") long[] dims,
                                @Const double[] buffer );

public static native @Cast("herr_t") int H5LTmake_dataset_string( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               @Cast("const char*") BytePointer buf );
public static native @Cast("herr_t") int H5LTmake_dataset_string( @Cast("hid_t") int loc_id,
                               String dset_name,
                               String buf );


/*-------------------------------------------------------------------------
 *
 * Read dataset functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5LTread_dataset( @Cast("hid_t") int loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         @Cast("hid_t") int type_id,
                         Pointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset( @Cast("hid_t") int loc_id,
                         String dset_name,
                         @Cast("hid_t") int type_id,
                         Pointer buffer );

public static native @Cast("herr_t") int H5LTread_dataset_char( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("char*") BytePointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_char( @Cast("hid_t") int loc_id,
                              String dset_name,
                              @Cast("char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_char( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("char*") byte[] buffer );
public static native @Cast("herr_t") int H5LTread_dataset_char( @Cast("hid_t") int loc_id,
                              String dset_name,
                              @Cast("char*") BytePointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_char( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_char( @Cast("hid_t") int loc_id,
                              String dset_name,
                              @Cast("char*") byte[] buffer );

public static native @Cast("herr_t") int H5LTread_dataset_short( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               ShortPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_short( @Cast("hid_t") int loc_id,
                               String dset_name,
                               ShortBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_short( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               short[] buffer );
public static native @Cast("herr_t") int H5LTread_dataset_short( @Cast("hid_t") int loc_id,
                               String dset_name,
                               ShortPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_short( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               ShortBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_short( @Cast("hid_t") int loc_id,
                               String dset_name,
                               short[] buffer );

public static native @Cast("herr_t") int H5LTread_dataset_int( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             IntPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_int( @Cast("hid_t") int loc_id,
                             String dset_name,
                             IntBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_int( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             int[] buffer );
public static native @Cast("herr_t") int H5LTread_dataset_int( @Cast("hid_t") int loc_id,
                             String dset_name,
                             IntPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_int( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             IntBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_int( @Cast("hid_t") int loc_id,
                             String dset_name,
                             int[] buffer );

public static native @Cast("herr_t") int H5LTread_dataset_long( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              CLongPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_long( @Cast("hid_t") int loc_id,
                              String dset_name,
                              CLongPointer buffer );

public static native @Cast("herr_t") int H5LTread_dataset_float( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               FloatPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_float( @Cast("hid_t") int loc_id,
                               String dset_name,
                               FloatBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_float( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               float[] buffer );
public static native @Cast("herr_t") int H5LTread_dataset_float( @Cast("hid_t") int loc_id,
                               String dset_name,
                               FloatPointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_float( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               FloatBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_float( @Cast("hid_t") int loc_id,
                               String dset_name,
                               float[] buffer );

public static native @Cast("herr_t") int H5LTread_dataset_double( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                DoublePointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_double( @Cast("hid_t") int loc_id,
                                String dset_name,
                                DoubleBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_double( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                double[] buffer );
public static native @Cast("herr_t") int H5LTread_dataset_double( @Cast("hid_t") int loc_id,
                                String dset_name,
                                DoublePointer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_double( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                DoubleBuffer buffer );
public static native @Cast("herr_t") int H5LTread_dataset_double( @Cast("hid_t") int loc_id,
                                String dset_name,
                                double[] buffer );

public static native @Cast("herr_t") int H5LTread_dataset_string( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                @Cast("char*") BytePointer buf );
public static native @Cast("herr_t") int H5LTread_dataset_string( @Cast("hid_t") int loc_id,
                                String dset_name,
                                @Cast("char*") ByteBuffer buf );
public static native @Cast("herr_t") int H5LTread_dataset_string( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                @Cast("char*") byte[] buf );
public static native @Cast("herr_t") int H5LTread_dataset_string( @Cast("hid_t") int loc_id,
                                String dset_name,
                                @Cast("char*") BytePointer buf );
public static native @Cast("herr_t") int H5LTread_dataset_string( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer dset_name,
                                @Cast("char*") ByteBuffer buf );
public static native @Cast("herr_t") int H5LTread_dataset_string( @Cast("hid_t") int loc_id,
                                String dset_name,
                                @Cast("char*") byte[] buf );

/*-------------------------------------------------------------------------
 *
 * Query dataset functions
 *
 *-------------------------------------------------------------------------
 */


public static native @Cast("herr_t") int H5LTget_dataset_ndims( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             IntPointer rank );
public static native @Cast("herr_t") int H5LTget_dataset_ndims( @Cast("hid_t") int loc_id,
                             String dset_name,
                             IntBuffer rank );
public static native @Cast("herr_t") int H5LTget_dataset_ndims( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             int[] rank );
public static native @Cast("herr_t") int H5LTget_dataset_ndims( @Cast("hid_t") int loc_id,
                             String dset_name,
                             IntPointer rank );
public static native @Cast("herr_t") int H5LTget_dataset_ndims( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             IntBuffer rank );
public static native @Cast("herr_t") int H5LTget_dataset_ndims( @Cast("hid_t") int loc_id,
                             String dset_name,
                             int[] rank );

public static native @Cast("herr_t") int H5LTget_dataset_info( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("hsize_t*") LongPointer dims,
                             @Cast("H5T_class_t*") IntPointer type_class,
                             @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_dataset_info( @Cast("hid_t") int loc_id,
                             String dset_name,
                             @Cast("hsize_t*") LongBuffer dims,
                             @Cast("H5T_class_t*") IntBuffer type_class,
                             @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_dataset_info( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("hsize_t*") long[] dims,
                             @Cast("H5T_class_t*") int[] type_class,
                             @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_dataset_info( @Cast("hid_t") int loc_id,
                             String dset_name,
                             @Cast("hsize_t*") LongPointer dims,
                             @Cast("H5T_class_t*") IntPointer type_class,
                             @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_dataset_info( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("hsize_t*") LongBuffer dims,
                             @Cast("H5T_class_t*") IntBuffer type_class,
                             @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_dataset_info( @Cast("hid_t") int loc_id,
                             String dset_name,
                             @Cast("hsize_t*") long[] dims,
                             @Cast("H5T_class_t*") int[] type_class,
                             @Cast("size_t*") SizeTPointer type_size );

public static native @Cast("herr_t") int H5LTfind_dataset( @Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name );
public static native @Cast("herr_t") int H5LTfind_dataset( @Cast("hid_t") int loc_id, String name );



/*-------------------------------------------------------------------------
 *
 * Set attribute functions
 *
 *-------------------------------------------------------------------------
 */


public static native @Cast("herr_t") int H5LTset_attribute_string( @Cast("hid_t") int loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Cast("const char*") BytePointer attr_data );
public static native @Cast("herr_t") int H5LTset_attribute_string( @Cast("hid_t") int loc_id,
                                 String obj_name,
                                 String attr_name,
                                 String attr_data );

public static native @Cast("herr_t") int H5LTset_attribute_char( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("const char*") BytePointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_char( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               String buffer,
                               @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_uchar( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("const unsigned char*") BytePointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uchar( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("const unsigned char*") ByteBuffer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uchar( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("const unsigned char*") byte[] buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uchar( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("const unsigned char*") BytePointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uchar( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("const unsigned char*") ByteBuffer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uchar( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("const unsigned char*") byte[] buffer,
                               @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_short( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Const ShortPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_short( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Const ShortBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_short( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Const short[] buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_short( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Const ShortPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_short( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Const ShortBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_short( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Const short[] buffer,
                              @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_ushort( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("const unsigned short*") ShortPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_ushort( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("const unsigned short*") ShortBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_ushort( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("const unsigned short*") short[] buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_ushort( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("const unsigned short*") ShortPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_ushort( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("const unsigned short*") ShortBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_ushort( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("const unsigned short*") short[] buffer,
                              @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_int( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Const IntPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_int( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Const IntBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_int( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Const int[] buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_int( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Const IntPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_int( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Const IntBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_int( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Const int[] buffer,
                              @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_uint( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("const unsigned int*") IntPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uint( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("const unsigned int*") IntBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uint( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("const unsigned int*") int[] buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uint( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("const unsigned int*") IntPointer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uint( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("const unsigned int*") IntBuffer buffer,
                              @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_uint( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("const unsigned int*") int[] buffer,
                              @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_long( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Const CLongPointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_long( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Const CLongPointer buffer,
                               @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_long_long( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Const LongPointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_long_long( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Const LongBuffer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_long_long( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Const long[] buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_long_long( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Const LongPointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_long_long( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Const LongBuffer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_long_long( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Const long[] buffer,
                               @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_ulong( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("const unsigned long*") CLongPointer buffer,
                               @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_ulong( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("const unsigned long*") CLongPointer buffer,
                               @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_float( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                @Const FloatPointer buffer,
                                @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_float( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                @Const FloatBuffer buffer,
                                @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_float( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                @Const float[] buffer,
                                @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_float( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                @Const FloatPointer buffer,
                                @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_float( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                @Const FloatBuffer buffer,
                                @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_float( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                @Const float[] buffer,
                                @Cast("size_t") long size );

public static native @Cast("herr_t") int H5LTset_attribute_double( @Cast("hid_t") int loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Const DoublePointer buffer,
                                 @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_double( @Cast("hid_t") int loc_id,
                                 String obj_name,
                                 String attr_name,
                                 @Const DoubleBuffer buffer,
                                 @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_double( @Cast("hid_t") int loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Const double[] buffer,
                                 @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_double( @Cast("hid_t") int loc_id,
                                 String obj_name,
                                 String attr_name,
                                 @Const DoublePointer buffer,
                                 @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_double( @Cast("hid_t") int loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Const DoubleBuffer buffer,
                                 @Cast("size_t") long size );
public static native @Cast("herr_t") int H5LTset_attribute_double( @Cast("hid_t") int loc_id,
                                 String obj_name,
                                 String attr_name,
                                 @Const double[] buffer,
                                 @Cast("size_t") long size );

/*-------------------------------------------------------------------------
 *
 * Get attribute functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5LTget_attribute( @Cast("hid_t") int loc_id,
                          @Cast("const char*") BytePointer obj_name,
                          @Cast("const char*") BytePointer attr_name,
                          @Cast("hid_t") int mem_type_id,
                          Pointer data );
public static native @Cast("herr_t") int H5LTget_attribute( @Cast("hid_t") int loc_id,
                          String obj_name,
                          String attr_name,
                          @Cast("hid_t") int mem_type_id,
                          Pointer data );

public static native @Cast("herr_t") int H5LTget_attribute_string( @Cast("hid_t") int loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Cast("char*") BytePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_string( @Cast("hid_t") int loc_id,
                                 String obj_name,
                                 String attr_name,
                                 @Cast("char*") ByteBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_string( @Cast("hid_t") int loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Cast("char*") byte[] data );
public static native @Cast("herr_t") int H5LTget_attribute_string( @Cast("hid_t") int loc_id,
                                 String obj_name,
                                 String attr_name,
                                 @Cast("char*") BytePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_string( @Cast("hid_t") int loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 @Cast("char*") ByteBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_string( @Cast("hid_t") int loc_id,
                                 String obj_name,
                                 String attr_name,
                                 @Cast("char*") byte[] data );

public static native @Cast("herr_t") int H5LTget_attribute_char( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("char*") BytePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_char( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("char*") ByteBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_char( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("char*") byte[] data );
public static native @Cast("herr_t") int H5LTget_attribute_char( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("char*") BytePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_char( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("char*") ByteBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_char( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("char*") byte[] data );

public static native @Cast("herr_t") int H5LTget_attribute_uchar( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("unsigned char*") BytePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_uchar( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("unsigned char*") ByteBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_uchar( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("unsigned char*") byte[] data );
public static native @Cast("herr_t") int H5LTget_attribute_uchar( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("unsigned char*") BytePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_uchar( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("unsigned char*") ByteBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_uchar( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("unsigned char*") byte[] data );

public static native @Cast("herr_t") int H5LTget_attribute_short( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                ShortPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_short( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                ShortBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_short( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                short[] data );
public static native @Cast("herr_t") int H5LTget_attribute_short( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                ShortPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_short( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                ShortBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_short( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                short[] data );

public static native @Cast("herr_t") int H5LTget_attribute_ushort( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                @Cast("unsigned short*") ShortPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_ushort( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                @Cast("unsigned short*") ShortBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_ushort( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                @Cast("unsigned short*") short[] data );
public static native @Cast("herr_t") int H5LTget_attribute_ushort( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                @Cast("unsigned short*") ShortPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_ushort( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                @Cast("unsigned short*") ShortBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_ushort( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                @Cast("unsigned short*") short[] data );

public static native @Cast("herr_t") int H5LTget_attribute_int( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              IntPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_int( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              IntBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_int( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              int[] data );
public static native @Cast("herr_t") int H5LTget_attribute_int( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              IntPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_int( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              IntBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_int( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              int[] data );

public static native @Cast("herr_t") int H5LTget_attribute_uint( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("unsigned int*") IntPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_uint( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("unsigned int*") IntBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_uint( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("unsigned int*") int[] data );
public static native @Cast("herr_t") int H5LTget_attribute_uint( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("unsigned int*") IntPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_uint( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer obj_name,
                              @Cast("const char*") BytePointer attr_name,
                              @Cast("unsigned int*") IntBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_uint( @Cast("hid_t") int loc_id,
                              String obj_name,
                              String attr_name,
                              @Cast("unsigned int*") int[] data );

public static native @Cast("herr_t") int H5LTget_attribute_long( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               CLongPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_long( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               CLongPointer data );

public static native @Cast("herr_t") int H5LTget_attribute_long_long( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               LongPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_long_long( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               LongBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_long_long( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               long[] data );
public static native @Cast("herr_t") int H5LTget_attribute_long_long( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               LongPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_long_long( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               LongBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_long_long( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               long[] data );

public static native @Cast("herr_t") int H5LTget_attribute_ulong( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("unsigned long*") CLongPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_ulong( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("unsigned long*") CLongPointer data );

public static native @Cast("herr_t") int H5LTget_attribute_float( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                FloatPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_float( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                FloatBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_float( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                float[] data );
public static native @Cast("herr_t") int H5LTget_attribute_float( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                FloatPointer data );
public static native @Cast("herr_t") int H5LTget_attribute_float( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                FloatBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_float( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                float[] data );

public static native @Cast("herr_t") int H5LTget_attribute_double( @Cast("hid_t") int loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 DoublePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_double( @Cast("hid_t") int loc_id,
                                 String obj_name,
                                 String attr_name,
                                 DoubleBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_double( @Cast("hid_t") int loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 double[] data );
public static native @Cast("herr_t") int H5LTget_attribute_double( @Cast("hid_t") int loc_id,
                                 String obj_name,
                                 String attr_name,
                                 DoublePointer data );
public static native @Cast("herr_t") int H5LTget_attribute_double( @Cast("hid_t") int loc_id,
                                 @Cast("const char*") BytePointer obj_name,
                                 @Cast("const char*") BytePointer attr_name,
                                 DoubleBuffer data );
public static native @Cast("herr_t") int H5LTget_attribute_double( @Cast("hid_t") int loc_id,
                                 String obj_name,
                                 String attr_name,
                                 double[] data );


/*-------------------------------------------------------------------------
 *
 * Query attribute functions
 *
 *-------------------------------------------------------------------------
 */


public static native @Cast("herr_t") int H5LTget_attribute_ndims( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                IntPointer rank );
public static native @Cast("herr_t") int H5LTget_attribute_ndims( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                IntBuffer rank );
public static native @Cast("herr_t") int H5LTget_attribute_ndims( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                int[] rank );
public static native @Cast("herr_t") int H5LTget_attribute_ndims( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                IntPointer rank );
public static native @Cast("herr_t") int H5LTget_attribute_ndims( @Cast("hid_t") int loc_id,
                                @Cast("const char*") BytePointer obj_name,
                                @Cast("const char*") BytePointer attr_name,
                                IntBuffer rank );
public static native @Cast("herr_t") int H5LTget_attribute_ndims( @Cast("hid_t") int loc_id,
                                String obj_name,
                                String attr_name,
                                int[] rank );

public static native @Cast("herr_t") int H5LTget_attribute_info( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("hsize_t*") LongPointer dims,
                               @Cast("H5T_class_t*") IntPointer type_class,
                               @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_attribute_info( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("hsize_t*") LongBuffer dims,
                               @Cast("H5T_class_t*") IntBuffer type_class,
                               @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_attribute_info( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("hsize_t*") long[] dims,
                               @Cast("H5T_class_t*") int[] type_class,
                               @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_attribute_info( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("hsize_t*") LongPointer dims,
                               @Cast("H5T_class_t*") IntPointer type_class,
                               @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_attribute_info( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer obj_name,
                               @Cast("const char*") BytePointer attr_name,
                               @Cast("hsize_t*") LongBuffer dims,
                               @Cast("H5T_class_t*") IntBuffer type_class,
                               @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5LTget_attribute_info( @Cast("hid_t") int loc_id,
                               String obj_name,
                               String attr_name,
                               @Cast("hsize_t*") long[] dims,
                               @Cast("H5T_class_t*") int[] type_class,
                               @Cast("size_t*") SizeTPointer type_size );





/*-------------------------------------------------------------------------
 *
 * General functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("hid_t") int H5LTtext_to_dtype(@Cast("const char*") BytePointer text, @Cast("H5LT_lang_t") int lang_type);
public static native @Cast("hid_t") int H5LTtext_to_dtype(String text, @Cast("H5LT_lang_t") int lang_type);
public static native @Cast("herr_t") int H5LTdtype_to_text(@Cast("hid_t") int dtype, @Cast("char*") BytePointer str, @Cast("H5LT_lang_t") int lang_type, @Cast("size_t*") SizeTPointer len);
public static native @Cast("herr_t") int H5LTdtype_to_text(@Cast("hid_t") int dtype, @Cast("char*") ByteBuffer str, @Cast("H5LT_lang_t") int lang_type, @Cast("size_t*") SizeTPointer len);
public static native @Cast("herr_t") int H5LTdtype_to_text(@Cast("hid_t") int dtype, @Cast("char*") byte[] str, @Cast("H5LT_lang_t") int lang_type, @Cast("size_t*") SizeTPointer len);


/*-------------------------------------------------------------------------
 *
 * Utility functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5LTfind_attribute( @Cast("hid_t") int loc_id, @Cast("const char*") BytePointer name );
public static native @Cast("herr_t") int H5LTfind_attribute( @Cast("hid_t") int loc_id, String name );

public static native @Cast("htri_t") int H5LTpath_valid(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer path, @Cast("hbool_t") boolean check_object_valid);
public static native @Cast("htri_t") int H5LTpath_valid(@Cast("hid_t") int loc_id, String path, @Cast("hbool_t") boolean check_object_valid);

/*-------------------------------------------------------------------------
 *
 * File image operations functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("hid_t") int H5LTopen_file_image(Pointer buf_ptr, @Cast("size_t") long buf_size, @Cast("unsigned") int flags);

// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5IMpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5IMpublic_H
// #define _H5IMpublic_H


// #ifdef __cplusplus
// #endif


public static native @Cast("herr_t") int H5IMmake_image_8bit( @Cast("hid_t") int loc_id,
                            @Cast("const char*") BytePointer dset_name,
                            @Cast("hsize_t") long width,
                            @Cast("hsize_t") long height,
                            @Cast("const unsigned char*") BytePointer buffer );
public static native @Cast("herr_t") int H5IMmake_image_8bit( @Cast("hid_t") int loc_id,
                            String dset_name,
                            @Cast("hsize_t") long width,
                            @Cast("hsize_t") long height,
                            @Cast("const unsigned char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5IMmake_image_8bit( @Cast("hid_t") int loc_id,
                            @Cast("const char*") BytePointer dset_name,
                            @Cast("hsize_t") long width,
                            @Cast("hsize_t") long height,
                            @Cast("const unsigned char*") byte[] buffer );
public static native @Cast("herr_t") int H5IMmake_image_8bit( @Cast("hid_t") int loc_id,
                            String dset_name,
                            @Cast("hsize_t") long width,
                            @Cast("hsize_t") long height,
                            @Cast("const unsigned char*") BytePointer buffer );
public static native @Cast("herr_t") int H5IMmake_image_8bit( @Cast("hid_t") int loc_id,
                            @Cast("const char*") BytePointer dset_name,
                            @Cast("hsize_t") long width,
                            @Cast("hsize_t") long height,
                            @Cast("const unsigned char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5IMmake_image_8bit( @Cast("hid_t") int loc_id,
                            String dset_name,
                            @Cast("hsize_t") long width,
                            @Cast("hsize_t") long height,
                            @Cast("const unsigned char*") byte[] buffer );

public static native @Cast("herr_t") int H5IMmake_image_24bit( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("hsize_t") long width,
                             @Cast("hsize_t") long height,
                             @Cast("const char*") BytePointer interlace,
                             @Cast("const unsigned char*") BytePointer buffer );
public static native @Cast("herr_t") int H5IMmake_image_24bit( @Cast("hid_t") int loc_id,
                             String dset_name,
                             @Cast("hsize_t") long width,
                             @Cast("hsize_t") long height,
                             String interlace,
                             @Cast("const unsigned char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5IMmake_image_24bit( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("hsize_t") long width,
                             @Cast("hsize_t") long height,
                             @Cast("const char*") BytePointer interlace,
                             @Cast("const unsigned char*") byte[] buffer );
public static native @Cast("herr_t") int H5IMmake_image_24bit( @Cast("hid_t") int loc_id,
                             String dset_name,
                             @Cast("hsize_t") long width,
                             @Cast("hsize_t") long height,
                             String interlace,
                             @Cast("const unsigned char*") BytePointer buffer );
public static native @Cast("herr_t") int H5IMmake_image_24bit( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("hsize_t") long width,
                             @Cast("hsize_t") long height,
                             @Cast("const char*") BytePointer interlace,
                             @Cast("const unsigned char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5IMmake_image_24bit( @Cast("hid_t") int loc_id,
                             String dset_name,
                             @Cast("hsize_t") long width,
                             @Cast("hsize_t") long height,
                             String interlace,
                             @Cast("const unsigned char*") byte[] buffer );

public static native @Cast("herr_t") int H5IMget_image_info( @Cast("hid_t") int loc_id,
                     @Cast("const char*") BytePointer dset_name,
                     @Cast("hsize_t*") LongPointer width,
                     @Cast("hsize_t*") LongPointer height,
                     @Cast("hsize_t*") LongPointer planes,
                     @Cast("char*") BytePointer interlace,
                     @Cast("hssize_t*") LongPointer npals );
public static native @Cast("herr_t") int H5IMget_image_info( @Cast("hid_t") int loc_id,
                     String dset_name,
                     @Cast("hsize_t*") LongBuffer width,
                     @Cast("hsize_t*") LongBuffer height,
                     @Cast("hsize_t*") LongBuffer planes,
                     @Cast("char*") ByteBuffer interlace,
                     @Cast("hssize_t*") LongBuffer npals );
public static native @Cast("herr_t") int H5IMget_image_info( @Cast("hid_t") int loc_id,
                     @Cast("const char*") BytePointer dset_name,
                     @Cast("hsize_t*") long[] width,
                     @Cast("hsize_t*") long[] height,
                     @Cast("hsize_t*") long[] planes,
                     @Cast("char*") byte[] interlace,
                     @Cast("hssize_t*") long[] npals );
public static native @Cast("herr_t") int H5IMget_image_info( @Cast("hid_t") int loc_id,
                     String dset_name,
                     @Cast("hsize_t*") LongPointer width,
                     @Cast("hsize_t*") LongPointer height,
                     @Cast("hsize_t*") LongPointer planes,
                     @Cast("char*") BytePointer interlace,
                     @Cast("hssize_t*") LongPointer npals );
public static native @Cast("herr_t") int H5IMget_image_info( @Cast("hid_t") int loc_id,
                     @Cast("const char*") BytePointer dset_name,
                     @Cast("hsize_t*") LongBuffer width,
                     @Cast("hsize_t*") LongBuffer height,
                     @Cast("hsize_t*") LongBuffer planes,
                     @Cast("char*") ByteBuffer interlace,
                     @Cast("hssize_t*") LongBuffer npals );
public static native @Cast("herr_t") int H5IMget_image_info( @Cast("hid_t") int loc_id,
                     String dset_name,
                     @Cast("hsize_t*") long[] width,
                     @Cast("hsize_t*") long[] height,
                     @Cast("hsize_t*") long[] planes,
                     @Cast("char*") byte[] interlace,
                     @Cast("hssize_t*") long[] npals );

public static native @Cast("herr_t") int H5IMread_image( @Cast("hid_t") int loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("unsigned char*") BytePointer buffer );
public static native @Cast("herr_t") int H5IMread_image( @Cast("hid_t") int loc_id,
                       String dset_name,
                       @Cast("unsigned char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5IMread_image( @Cast("hid_t") int loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("unsigned char*") byte[] buffer );
public static native @Cast("herr_t") int H5IMread_image( @Cast("hid_t") int loc_id,
                       String dset_name,
                       @Cast("unsigned char*") BytePointer buffer );
public static native @Cast("herr_t") int H5IMread_image( @Cast("hid_t") int loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("unsigned char*") ByteBuffer buffer );
public static native @Cast("herr_t") int H5IMread_image( @Cast("hid_t") int loc_id,
                       String dset_name,
                       @Cast("unsigned char*") byte[] buffer );

public static native @Cast("herr_t") int H5IMmake_palette( @Cast("hid_t") int loc_id,
                         @Cast("const char*") BytePointer pal_name,
                         @Cast("const hsize_t*") LongPointer pal_dims,
                         @Cast("const unsigned char*") BytePointer pal_data );
public static native @Cast("herr_t") int H5IMmake_palette( @Cast("hid_t") int loc_id,
                         String pal_name,
                         @Cast("const hsize_t*") LongBuffer pal_dims,
                         @Cast("const unsigned char*") ByteBuffer pal_data );
public static native @Cast("herr_t") int H5IMmake_palette( @Cast("hid_t") int loc_id,
                         @Cast("const char*") BytePointer pal_name,
                         @Cast("const hsize_t*") long[] pal_dims,
                         @Cast("const unsigned char*") byte[] pal_data );
public static native @Cast("herr_t") int H5IMmake_palette( @Cast("hid_t") int loc_id,
                         String pal_name,
                         @Cast("const hsize_t*") LongPointer pal_dims,
                         @Cast("const unsigned char*") BytePointer pal_data );
public static native @Cast("herr_t") int H5IMmake_palette( @Cast("hid_t") int loc_id,
                         @Cast("const char*") BytePointer pal_name,
                         @Cast("const hsize_t*") LongBuffer pal_dims,
                         @Cast("const unsigned char*") ByteBuffer pal_data );
public static native @Cast("herr_t") int H5IMmake_palette( @Cast("hid_t") int loc_id,
                         String pal_name,
                         @Cast("const hsize_t*") long[] pal_dims,
                         @Cast("const unsigned char*") byte[] pal_data );

public static native @Cast("herr_t") int H5IMlink_palette( @Cast("hid_t") int loc_id,
                        @Cast("const char*") BytePointer image_name,
                        @Cast("const char*") BytePointer pal_name );
public static native @Cast("herr_t") int H5IMlink_palette( @Cast("hid_t") int loc_id,
                        String image_name,
                        String pal_name );

public static native @Cast("herr_t") int H5IMunlink_palette( @Cast("hid_t") int loc_id,
                           @Cast("const char*") BytePointer image_name,
                           @Cast("const char*") BytePointer pal_name );
public static native @Cast("herr_t") int H5IMunlink_palette( @Cast("hid_t") int loc_id,
                           String image_name,
                           String pal_name );

public static native @Cast("herr_t") int H5IMget_npalettes( @Cast("hid_t") int loc_id,
                          @Cast("const char*") BytePointer image_name,
                          @Cast("hssize_t*") LongPointer npals );
public static native @Cast("herr_t") int H5IMget_npalettes( @Cast("hid_t") int loc_id,
                          String image_name,
                          @Cast("hssize_t*") LongBuffer npals );
public static native @Cast("herr_t") int H5IMget_npalettes( @Cast("hid_t") int loc_id,
                          @Cast("const char*") BytePointer image_name,
                          @Cast("hssize_t*") long[] npals );
public static native @Cast("herr_t") int H5IMget_npalettes( @Cast("hid_t") int loc_id,
                          String image_name,
                          @Cast("hssize_t*") LongPointer npals );
public static native @Cast("herr_t") int H5IMget_npalettes( @Cast("hid_t") int loc_id,
                          @Cast("const char*") BytePointer image_name,
                          @Cast("hssize_t*") LongBuffer npals );
public static native @Cast("herr_t") int H5IMget_npalettes( @Cast("hid_t") int loc_id,
                          String image_name,
                          @Cast("hssize_t*") long[] npals );

public static native @Cast("herr_t") int H5IMget_palette_info( @Cast("hid_t") int loc_id,
                        @Cast("const char*") BytePointer image_name,
                        int pal_number,
                        @Cast("hsize_t*") LongPointer pal_dims );
public static native @Cast("herr_t") int H5IMget_palette_info( @Cast("hid_t") int loc_id,
                        String image_name,
                        int pal_number,
                        @Cast("hsize_t*") LongBuffer pal_dims );
public static native @Cast("herr_t") int H5IMget_palette_info( @Cast("hid_t") int loc_id,
                        @Cast("const char*") BytePointer image_name,
                        int pal_number,
                        @Cast("hsize_t*") long[] pal_dims );
public static native @Cast("herr_t") int H5IMget_palette_info( @Cast("hid_t") int loc_id,
                        String image_name,
                        int pal_number,
                        @Cast("hsize_t*") LongPointer pal_dims );
public static native @Cast("herr_t") int H5IMget_palette_info( @Cast("hid_t") int loc_id,
                        @Cast("const char*") BytePointer image_name,
                        int pal_number,
                        @Cast("hsize_t*") LongBuffer pal_dims );
public static native @Cast("herr_t") int H5IMget_palette_info( @Cast("hid_t") int loc_id,
                        String image_name,
                        int pal_number,
                        @Cast("hsize_t*") long[] pal_dims );

public static native @Cast("herr_t") int H5IMget_palette( @Cast("hid_t") int loc_id,
                        @Cast("const char*") BytePointer image_name,
                        int pal_number,
                        @Cast("unsigned char*") BytePointer pal_data );
public static native @Cast("herr_t") int H5IMget_palette( @Cast("hid_t") int loc_id,
                        String image_name,
                        int pal_number,
                        @Cast("unsigned char*") ByteBuffer pal_data );
public static native @Cast("herr_t") int H5IMget_palette( @Cast("hid_t") int loc_id,
                        @Cast("const char*") BytePointer image_name,
                        int pal_number,
                        @Cast("unsigned char*") byte[] pal_data );
public static native @Cast("herr_t") int H5IMget_palette( @Cast("hid_t") int loc_id,
                        String image_name,
                        int pal_number,
                        @Cast("unsigned char*") BytePointer pal_data );
public static native @Cast("herr_t") int H5IMget_palette( @Cast("hid_t") int loc_id,
                        @Cast("const char*") BytePointer image_name,
                        int pal_number,
                        @Cast("unsigned char*") ByteBuffer pal_data );
public static native @Cast("herr_t") int H5IMget_palette( @Cast("hid_t") int loc_id,
                        String image_name,
                        int pal_number,
                        @Cast("unsigned char*") byte[] pal_data );

public static native @Cast("herr_t") int H5IMis_image( @Cast("hid_t") int loc_id,
                     @Cast("const char*") BytePointer dset_name );
public static native @Cast("herr_t") int H5IMis_image( @Cast("hid_t") int loc_id,
                     String dset_name );

public static native @Cast("herr_t") int H5IMis_palette( @Cast("hid_t") int loc_id,
                     @Cast("const char*") BytePointer dset_name );
public static native @Cast("herr_t") int H5IMis_palette( @Cast("hid_t") int loc_id,
                     String dset_name );

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from H5TBpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5TBpublic_H
// #define _H5TBpublic_H


// #ifdef __cplusplus
// #endif


/*-------------------------------------------------------------------------
 *
 * Create functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5TBmake_table( @Cast("const char*") BytePointer table_title,
                       @Cast("hid_t") int loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") PointerPointer field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") IntPointer field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );
public static native @Cast("herr_t") int H5TBmake_table( @Cast("const char*") BytePointer table_title,
                       @Cast("hid_t") int loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") @ByPtrPtr BytePointer field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") IntPointer field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );
public static native @Cast("herr_t") int H5TBmake_table( String table_title,
                       @Cast("hid_t") int loc_id,
                       String dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") @ByPtrPtr ByteBuffer field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") IntBuffer field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );
public static native @Cast("herr_t") int H5TBmake_table( @Cast("const char*") BytePointer table_title,
                       @Cast("hid_t") int loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") @ByPtrPtr byte[] field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") int[] field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );
public static native @Cast("herr_t") int H5TBmake_table( String table_title,
                       @Cast("hid_t") int loc_id,
                       String dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") @ByPtrPtr BytePointer field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") IntPointer field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );
public static native @Cast("herr_t") int H5TBmake_table( @Cast("const char*") BytePointer table_title,
                       @Cast("hid_t") int loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") @ByPtrPtr ByteBuffer field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") IntBuffer field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );
public static native @Cast("herr_t") int H5TBmake_table( String table_title,
                       @Cast("hid_t") int loc_id,
                       String dset_name,
                       @Cast("hsize_t") long nfields,
                       @Cast("hsize_t") long nrecords,
                       @Cast("size_t") long type_size,
                       @Cast("const char**") @ByPtrPtr byte[] field_names,
                       @Cast("const size_t*") SizeTPointer field_offset,
                       @Cast("const hid_t*") int[] field_types,
                       @Cast("hsize_t") long chunk_size,
                       Pointer fill_data,
                       int compress,
                       @Const Pointer buf );


/*-------------------------------------------------------------------------
 *
 * Write functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5TBappend_records( @Cast("hid_t") int loc_id,
                           @Cast("const char*") BytePointer dset_name,
                           @Cast("hsize_t") long nrecords,
                           @Cast("size_t") long type_size,
                           @Cast("const size_t*") SizeTPointer field_offset,
                           @Cast("const size_t*") SizeTPointer dst_sizes,
                           @Const Pointer buf );
public static native @Cast("herr_t") int H5TBappend_records( @Cast("hid_t") int loc_id,
                           String dset_name,
                           @Cast("hsize_t") long nrecords,
                           @Cast("size_t") long type_size,
                           @Cast("const size_t*") SizeTPointer field_offset,
                           @Cast("const size_t*") SizeTPointer dst_sizes,
                           @Const Pointer buf );

public static native @Cast("herr_t") int H5TBwrite_records( @Cast("hid_t") int loc_id,
                          @Cast("const char*") BytePointer dset_name,
                          @Cast("hsize_t") long start,
                          @Cast("hsize_t") long nrecords,
                          @Cast("size_t") long type_size,
                          @Cast("const size_t*") SizeTPointer field_offset,
                          @Cast("const size_t*") SizeTPointer dst_sizes,
                          @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_records( @Cast("hid_t") int loc_id,
                          String dset_name,
                          @Cast("hsize_t") long start,
                          @Cast("hsize_t") long nrecords,
                          @Cast("size_t") long type_size,
                          @Cast("const size_t*") SizeTPointer field_offset,
                          @Cast("const size_t*") SizeTPointer dst_sizes,
                          @Const Pointer buf );


public static native @Cast("herr_t") int H5TBwrite_fields_name( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("const char*") BytePointer field_names,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_fields_name( @Cast("hid_t") int loc_id,
                              String dset_name,
                              String field_names,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              @Const Pointer buf );

public static native @Cast("herr_t") int H5TBwrite_fields_index( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               @Cast("hsize_t") long nfields,
                               @Const IntPointer field_index,
                               @Cast("hsize_t") long start,
                               @Cast("hsize_t") long nrecords,
                               @Cast("size_t") long type_size,
                               @Cast("const size_t*") SizeTPointer field_offset,
                               @Cast("const size_t*") SizeTPointer dst_sizes,
                               @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_fields_index( @Cast("hid_t") int loc_id,
                               String dset_name,
                               @Cast("hsize_t") long nfields,
                               @Const IntBuffer field_index,
                               @Cast("hsize_t") long start,
                               @Cast("hsize_t") long nrecords,
                               @Cast("size_t") long type_size,
                               @Cast("const size_t*") SizeTPointer field_offset,
                               @Cast("const size_t*") SizeTPointer dst_sizes,
                               @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_fields_index( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               @Cast("hsize_t") long nfields,
                               @Const int[] field_index,
                               @Cast("hsize_t") long start,
                               @Cast("hsize_t") long nrecords,
                               @Cast("size_t") long type_size,
                               @Cast("const size_t*") SizeTPointer field_offset,
                               @Cast("const size_t*") SizeTPointer dst_sizes,
                               @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_fields_index( @Cast("hid_t") int loc_id,
                               String dset_name,
                               @Cast("hsize_t") long nfields,
                               @Const IntPointer field_index,
                               @Cast("hsize_t") long start,
                               @Cast("hsize_t") long nrecords,
                               @Cast("size_t") long type_size,
                               @Cast("const size_t*") SizeTPointer field_offset,
                               @Cast("const size_t*") SizeTPointer dst_sizes,
                               @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_fields_index( @Cast("hid_t") int loc_id,
                               @Cast("const char*") BytePointer dset_name,
                               @Cast("hsize_t") long nfields,
                               @Const IntBuffer field_index,
                               @Cast("hsize_t") long start,
                               @Cast("hsize_t") long nrecords,
                               @Cast("size_t") long type_size,
                               @Cast("const size_t*") SizeTPointer field_offset,
                               @Cast("const size_t*") SizeTPointer dst_sizes,
                               @Const Pointer buf );
public static native @Cast("herr_t") int H5TBwrite_fields_index( @Cast("hid_t") int loc_id,
                               String dset_name,
                               @Cast("hsize_t") long nfields,
                               @Const int[] field_index,
                               @Cast("hsize_t") long start,
                               @Cast("hsize_t") long nrecords,
                               @Cast("size_t") long type_size,
                               @Cast("const size_t*") SizeTPointer field_offset,
                               @Cast("const size_t*") SizeTPointer dst_sizes,
                               @Const Pointer buf );


/*-------------------------------------------------------------------------
 *
 * Read functions
 *
 *-------------------------------------------------------------------------
 */



public static native @Cast("herr_t") int H5TBread_table( @Cast("hid_t") int loc_id,
                       @Cast("const char*") BytePointer dset_name,
                       @Cast("size_t") long dst_size,
                       @Cast("const size_t*") SizeTPointer dst_offset,
                       @Cast("const size_t*") SizeTPointer dst_sizes,
                       Pointer dst_buf );
public static native @Cast("herr_t") int H5TBread_table( @Cast("hid_t") int loc_id,
                       String dset_name,
                       @Cast("size_t") long dst_size,
                       @Cast("const size_t*") SizeTPointer dst_offset,
                       @Cast("const size_t*") SizeTPointer dst_sizes,
                       Pointer dst_buf );


public static native @Cast("herr_t") int H5TBread_fields_name( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name,
                             @Cast("const char*") BytePointer field_names,
                             @Cast("hsize_t") long start,
                             @Cast("hsize_t") long nrecords,
                             @Cast("size_t") long type_size,
                             @Cast("const size_t*") SizeTPointer field_offset,
                             @Cast("const size_t*") SizeTPointer dst_sizes,
                             Pointer buf );
public static native @Cast("herr_t") int H5TBread_fields_name( @Cast("hid_t") int loc_id,
                             String dset_name,
                             String field_names,
                             @Cast("hsize_t") long start,
                             @Cast("hsize_t") long nrecords,
                             @Cast("size_t") long type_size,
                             @Cast("const size_t*") SizeTPointer field_offset,
                             @Cast("const size_t*") SizeTPointer dst_sizes,
                             Pointer buf );

public static native @Cast("herr_t") int H5TBread_fields_index( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("hsize_t") long nfields,
                              @Const IntPointer field_index,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              Pointer buf );
public static native @Cast("herr_t") int H5TBread_fields_index( @Cast("hid_t") int loc_id,
                              String dset_name,
                              @Cast("hsize_t") long nfields,
                              @Const IntBuffer field_index,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              Pointer buf );
public static native @Cast("herr_t") int H5TBread_fields_index( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("hsize_t") long nfields,
                              @Const int[] field_index,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              Pointer buf );
public static native @Cast("herr_t") int H5TBread_fields_index( @Cast("hid_t") int loc_id,
                              String dset_name,
                              @Cast("hsize_t") long nfields,
                              @Const IntPointer field_index,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              Pointer buf );
public static native @Cast("herr_t") int H5TBread_fields_index( @Cast("hid_t") int loc_id,
                              @Cast("const char*") BytePointer dset_name,
                              @Cast("hsize_t") long nfields,
                              @Const IntBuffer field_index,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              Pointer buf );
public static native @Cast("herr_t") int H5TBread_fields_index( @Cast("hid_t") int loc_id,
                              String dset_name,
                              @Cast("hsize_t") long nfields,
                              @Const int[] field_index,
                              @Cast("hsize_t") long start,
                              @Cast("hsize_t") long nrecords,
                              @Cast("size_t") long type_size,
                              @Cast("const size_t*") SizeTPointer field_offset,
                              @Cast("const size_t*") SizeTPointer dst_sizes,
                              Pointer buf );


public static native @Cast("herr_t") int H5TBread_records( @Cast("hid_t") int loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         @Cast("hsize_t") long start,
                         @Cast("hsize_t") long nrecords,
                         @Cast("size_t") long type_size,
                         @Cast("const size_t*") SizeTPointer dst_offset,
                         @Cast("const size_t*") SizeTPointer dst_sizes,
                         Pointer buf );
public static native @Cast("herr_t") int H5TBread_records( @Cast("hid_t") int loc_id,
                         String dset_name,
                         @Cast("hsize_t") long start,
                         @Cast("hsize_t") long nrecords,
                         @Cast("size_t") long type_size,
                         @Cast("const size_t*") SizeTPointer dst_offset,
                         @Cast("const size_t*") SizeTPointer dst_sizes,
                         Pointer buf );

/*-------------------------------------------------------------------------
 *
 * Inquiry functions
 *
 *-------------------------------------------------------------------------
 */


public static native @Cast("herr_t") int H5TBget_table_info( @Cast("hid_t") int loc_id,
                            @Cast("const char*") BytePointer dset_name,
                            @Cast("hsize_t*") LongPointer nfields,
                            @Cast("hsize_t*") LongPointer nrecords );
public static native @Cast("herr_t") int H5TBget_table_info( @Cast("hid_t") int loc_id,
                            String dset_name,
                            @Cast("hsize_t*") LongBuffer nfields,
                            @Cast("hsize_t*") LongBuffer nrecords );
public static native @Cast("herr_t") int H5TBget_table_info( @Cast("hid_t") int loc_id,
                            @Cast("const char*") BytePointer dset_name,
                            @Cast("hsize_t*") long[] nfields,
                            @Cast("hsize_t*") long[] nrecords );
public static native @Cast("herr_t") int H5TBget_table_info( @Cast("hid_t") int loc_id,
                            String dset_name,
                            @Cast("hsize_t*") LongPointer nfields,
                            @Cast("hsize_t*") LongPointer nrecords );
public static native @Cast("herr_t") int H5TBget_table_info( @Cast("hid_t") int loc_id,
                            @Cast("const char*") BytePointer dset_name,
                            @Cast("hsize_t*") LongBuffer nfields,
                            @Cast("hsize_t*") LongBuffer nrecords );
public static native @Cast("herr_t") int H5TBget_table_info( @Cast("hid_t") int loc_id,
                            String dset_name,
                            @Cast("hsize_t*") long[] nfields,
                            @Cast("hsize_t*") long[] nrecords );

public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") int loc_id,
                           @Cast("const char*") BytePointer dset_name,
                           @Cast("char**") PointerPointer field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") int loc_id,
                           @Cast("const char*") BytePointer dset_name,
                           @Cast("char**") @ByPtrPtr BytePointer field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") int loc_id,
                           String dset_name,
                           @Cast("char**") @ByPtrPtr ByteBuffer field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") int loc_id,
                           @Cast("const char*") BytePointer dset_name,
                           @Cast("char**") @ByPtrPtr byte[] field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") int loc_id,
                           String dset_name,
                           @Cast("char**") @ByPtrPtr BytePointer field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") int loc_id,
                           @Cast("const char*") BytePointer dset_name,
                           @Cast("char**") @ByPtrPtr ByteBuffer field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );
public static native @Cast("herr_t") int H5TBget_field_info( @Cast("hid_t") int loc_id,
                           String dset_name,
                           @Cast("char**") @ByPtrPtr byte[] field_names,
                           @Cast("size_t*") SizeTPointer field_sizes,
                           @Cast("size_t*") SizeTPointer field_offsets,
                           @Cast("size_t*") SizeTPointer type_size );


/*-------------------------------------------------------------------------
 *
 * Manipulation functions
 *
 *-------------------------------------------------------------------------
 */


public static native @Cast("herr_t") int H5TBdelete_record( @Cast("hid_t") int loc_id,
                          @Cast("const char*") BytePointer dset_name,
                          @Cast("hsize_t") long start,
                          @Cast("hsize_t") long nrecords );
public static native @Cast("herr_t") int H5TBdelete_record( @Cast("hid_t") int loc_id,
                          String dset_name,
                          @Cast("hsize_t") long start,
                          @Cast("hsize_t") long nrecords );


public static native @Cast("herr_t") int H5TBinsert_record( @Cast("hid_t") int loc_id,
                          @Cast("const char*") BytePointer dset_name,
                          @Cast("hsize_t") long start,
                          @Cast("hsize_t") long nrecords,
                          @Cast("size_t") long dst_size,
                          @Cast("const size_t*") SizeTPointer dst_offset,
                          @Cast("const size_t*") SizeTPointer dst_sizes,
                          Pointer buf );
public static native @Cast("herr_t") int H5TBinsert_record( @Cast("hid_t") int loc_id,
                          String dset_name,
                          @Cast("hsize_t") long start,
                          @Cast("hsize_t") long nrecords,
                          @Cast("size_t") long dst_size,
                          @Cast("const size_t*") SizeTPointer dst_offset,
                          @Cast("const size_t*") SizeTPointer dst_sizes,
                          Pointer buf );

public static native @Cast("herr_t") int H5TBadd_records_from( @Cast("hid_t") int loc_id,
                             @Cast("const char*") BytePointer dset_name1,
                             @Cast("hsize_t") long start1,
                             @Cast("hsize_t") long nrecords,
                             @Cast("const char*") BytePointer dset_name2,
                             @Cast("hsize_t") long start2 );
public static native @Cast("herr_t") int H5TBadd_records_from( @Cast("hid_t") int loc_id,
                             String dset_name1,
                             @Cast("hsize_t") long start1,
                             @Cast("hsize_t") long nrecords,
                             String dset_name2,
                             @Cast("hsize_t") long start2 );

public static native @Cast("herr_t") int H5TBcombine_tables( @Cast("hid_t") int loc_id1,
                           @Cast("const char*") BytePointer dset_name1,
                           @Cast("hid_t") int loc_id2,
                           @Cast("const char*") BytePointer dset_name2,
                           @Cast("const char*") BytePointer dset_name3 );
public static native @Cast("herr_t") int H5TBcombine_tables( @Cast("hid_t") int loc_id1,
                           String dset_name1,
                           @Cast("hid_t") int loc_id2,
                           String dset_name2,
                           String dset_name3 );

public static native @Cast("herr_t") int H5TBinsert_field( @Cast("hid_t") int loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         @Cast("const char*") BytePointer field_name,
                         @Cast("hid_t") int field_type,
                         @Cast("hsize_t") long position,
                         @Const Pointer fill_data,
                         @Const Pointer buf );
public static native @Cast("herr_t") int H5TBinsert_field( @Cast("hid_t") int loc_id,
                         String dset_name,
                         String field_name,
                         @Cast("hid_t") int field_type,
                         @Cast("hsize_t") long position,
                         @Const Pointer fill_data,
                         @Const Pointer buf );

public static native @Cast("herr_t") int H5TBdelete_field( @Cast("hid_t") int loc_id,
                         @Cast("const char*") BytePointer dset_name,
                         @Cast("const char*") BytePointer field_name );
public static native @Cast("herr_t") int H5TBdelete_field( @Cast("hid_t") int loc_id,
                         String dset_name,
                         String field_name );


/*-------------------------------------------------------------------------
 *
 * Table attribute functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5TBAget_title( @Cast("hid_t") int loc_id,
                       @Cast("char*") BytePointer table_title );
public static native @Cast("herr_t") int H5TBAget_title( @Cast("hid_t") int loc_id,
                       @Cast("char*") ByteBuffer table_title );
public static native @Cast("herr_t") int H5TBAget_title( @Cast("hid_t") int loc_id,
                       @Cast("char*") byte[] table_title );

public static native @Cast("htri_t") int H5TBAget_fill(@Cast("hid_t") int loc_id,
                      @Cast("const char*") BytePointer dset_name,
                      @Cast("hid_t") int dset_id,
                      @Cast("unsigned char*") BytePointer dst_buf);
public static native @Cast("htri_t") int H5TBAget_fill(@Cast("hid_t") int loc_id,
                      String dset_name,
                      @Cast("hid_t") int dset_id,
                      @Cast("unsigned char*") ByteBuffer dst_buf);
public static native @Cast("htri_t") int H5TBAget_fill(@Cast("hid_t") int loc_id,
                      @Cast("const char*") BytePointer dset_name,
                      @Cast("hid_t") int dset_id,
                      @Cast("unsigned char*") byte[] dst_buf);
public static native @Cast("htri_t") int H5TBAget_fill(@Cast("hid_t") int loc_id,
                      String dset_name,
                      @Cast("hid_t") int dset_id,
                      @Cast("unsigned char*") BytePointer dst_buf);
public static native @Cast("htri_t") int H5TBAget_fill(@Cast("hid_t") int loc_id,
                      @Cast("const char*") BytePointer dset_name,
                      @Cast("hid_t") int dset_id,
                      @Cast("unsigned char*") ByteBuffer dst_buf);
public static native @Cast("htri_t") int H5TBAget_fill(@Cast("hid_t") int loc_id,
                      String dset_name,
                      @Cast("hid_t") int dset_id,
                      @Cast("unsigned char*") byte[] dst_buf);

// #ifdef __cplusplus
// #endif


// #endif



// Parsed from H5PTpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5PTpublic_H
// #define _H5PTpublic_H


// #ifdef __cplusplus
// #endif

/*-------------------------------------------------------------------------
 * Create/Open/Close functions
 *-------------------------------------------------------------------------
 */
/* NOTE: H5PTcreate is replacing H5PTcreate_fl for better name due to the
   removal of H5PTcreate_vl.  H5PTcreate_fl may be retired in 1.8.19. */
public static native @Cast("hid_t") int H5PTcreate(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer dset_name,
			@Cast("hid_t") int dtype_id, @Cast("hsize_t") long chunk_size, @Cast("hid_t") int plist_id);
public static native @Cast("hid_t") int H5PTcreate(@Cast("hid_t") int loc_id, String dset_name,
			@Cast("hid_t") int dtype_id, @Cast("hsize_t") long chunk_size, @Cast("hid_t") int plist_id);

public static native @Cast("hid_t") int H5PTopen(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer dset_name);
public static native @Cast("hid_t") int H5PTopen(@Cast("hid_t") int loc_id, String dset_name);

public static native @Cast("herr_t") int H5PTclose(@Cast("hid_t") int table_id);

/* This function may be removed from the packet table in release 1.8.19. */
public static native @Cast("hid_t") int H5PTcreate_fl(@Cast("hid_t") int loc_id, @Cast("const char*") BytePointer dset_name,
			@Cast("hid_t") int dtype_id, @Cast("hsize_t") long chunk_size, int compression);
public static native @Cast("hid_t") int H5PTcreate_fl(@Cast("hid_t") int loc_id, String dset_name,
			@Cast("hid_t") int dtype_id, @Cast("hsize_t") long chunk_size, int compression);


/*-------------------------------------------------------------------------
 * Write functions
 *-------------------------------------------------------------------------
 */
public static native @Cast("herr_t") int H5PTappend(@Cast("hid_t") int table_id, @Cast("size_t") long nrecords, @Const Pointer data);

/*-------------------------------------------------------------------------
 * Read functions
 *-------------------------------------------------------------------------
 */
public static native @Cast("herr_t") int H5PTget_next(@Cast("hid_t") int table_id, @Cast("size_t") long nrecords, Pointer data);

public static native @Cast("herr_t") int H5PTread_packets(@Cast("hid_t") int table_id, @Cast("hsize_t") long start,
			@Cast("size_t") long nrecords, Pointer data);

/*-------------------------------------------------------------------------
 * Inquiry functions
 *-------------------------------------------------------------------------
 */
public static native @Cast("herr_t") int H5PTget_num_packets(@Cast("hid_t") int table_id, @Cast("hsize_t*") LongPointer nrecords);
public static native @Cast("herr_t") int H5PTget_num_packets(@Cast("hid_t") int table_id, @Cast("hsize_t*") LongBuffer nrecords);
public static native @Cast("herr_t") int H5PTget_num_packets(@Cast("hid_t") int table_id, @Cast("hsize_t*") long[] nrecords);

public static native @Cast("herr_t") int H5PTis_valid(@Cast("hid_t") int table_id);

public static native @Cast("herr_t") int H5PTis_varlen(@Cast("hid_t") int table_id);

/*-------------------------------------------------------------------------
 *
 * Accessor functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("hid_t") int H5PTget_dataset(@Cast("hid_t") int table_id);

public static native @Cast("hid_t") int H5PTget_type(@Cast("hid_t") int table_id);

/*-------------------------------------------------------------------------
 *
 * Packet Table "current index" functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5PTcreate_index( @Cast("hid_t") int table_id );

public static native @Cast("herr_t") int H5PTset_index( @Cast("hid_t") int table_id,
                             @Cast("hsize_t") long pt_index );

public static native @Cast("herr_t") int H5PTget_index( @Cast("hid_t") int table_id,
                             @Cast("hsize_t*") LongPointer pt_index );
public static native @Cast("herr_t") int H5PTget_index( @Cast("hid_t") int table_id,
                             @Cast("hsize_t*") LongBuffer pt_index );
public static native @Cast("herr_t") int H5PTget_index( @Cast("hid_t") int table_id,
                             @Cast("hsize_t*") long[] pt_index );

/*-------------------------------------------------------------------------
 *
 * Memory Management functions
 *
 *-------------------------------------------------------------------------
 */

public static native @Cast("herr_t") int H5PTfree_vlen_buff( @Cast("hid_t") int table_id,
                               @Cast("size_t") long bufflen,
                               Pointer buff );

// #ifdef __cplusplus
// #endif

// #endif



// Parsed from H5LDpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef _H5LDpublic_H
// #define _H5LDpublic_H

// #ifdef __cplusplus
// #endif

public static native @Cast("herr_t") int H5LDget_dset_dims(@Cast("hid_t") int did, @Cast("hsize_t*") LongPointer cur_dims);
public static native @Cast("herr_t") int H5LDget_dset_dims(@Cast("hid_t") int did, @Cast("hsize_t*") LongBuffer cur_dims);
public static native @Cast("herr_t") int H5LDget_dset_dims(@Cast("hid_t") int did, @Cast("hsize_t*") long[] cur_dims);
public static native @Cast("size_t") long H5LDget_dset_type_size(@Cast("hid_t") int did, @Cast("const char*") BytePointer fields);
public static native @Cast("size_t") long H5LDget_dset_type_size(@Cast("hid_t") int did, String fields);
public static native @Cast("herr_t") int H5LDget_dset_elmts(@Cast("hid_t") int did, @Cast("const hsize_t*") LongPointer prev_dims,
    @Cast("const hsize_t*") LongPointer cur_dims, @Cast("const char*") BytePointer fields, Pointer buf);
public static native @Cast("herr_t") int H5LDget_dset_elmts(@Cast("hid_t") int did, @Cast("const hsize_t*") LongBuffer prev_dims,
    @Cast("const hsize_t*") LongBuffer cur_dims, String fields, Pointer buf);
public static native @Cast("herr_t") int H5LDget_dset_elmts(@Cast("hid_t") int did, @Cast("const hsize_t*") long[] prev_dims,
    @Cast("const hsize_t*") long[] cur_dims, @Cast("const char*") BytePointer fields, Pointer buf);
public static native @Cast("herr_t") int H5LDget_dset_elmts(@Cast("hid_t") int did, @Cast("const hsize_t*") LongPointer prev_dims,
    @Cast("const hsize_t*") LongPointer cur_dims, String fields, Pointer buf);
public static native @Cast("herr_t") int H5LDget_dset_elmts(@Cast("hid_t") int did, @Cast("const hsize_t*") LongBuffer prev_dims,
    @Cast("const hsize_t*") LongBuffer cur_dims, @Cast("const char*") BytePointer fields, Pointer buf);
public static native @Cast("herr_t") int H5LDget_dset_elmts(@Cast("hid_t") int did, @Cast("const hsize_t*") long[] prev_dims,
    @Cast("const hsize_t*") long[] cur_dims, String fields, Pointer buf);

// #ifdef __cplusplus
// #endif

// #endif /* _H5LDpublic_H */



// Parsed from H5Include.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #include <hdf5.h>

// Define bool type for platforms that don't support bool yet
// #ifdef BOOL_NOTDEFINED
// #endif

// These are defined in H5Opkg.h, which should not be included in the C++ API,
// so re-define them here for now.

/* Initial version of the object header format */
public static final int H5O_VERSION_1 =	1;

/* Revised version - leaves out reserved bytes and alignment padding, and adds
 *      magic number as prefix and checksum as suffix for all chunks.
 */
public static final int H5O_VERSION_2 =	2;



// Parsed from H5Exception.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5Exception_H
// #define __H5Exception_H

// #include <string>

// #ifndef H5_NO_NAMESPACE
// #ifdef H5_NO_STD
// #else
//     #define H5std_string std::string
// #endif
// #endif

/** \class Exception
    \brief Exception provides wrappers of HDF5 error handling functions.
    <p>
    Many classes are derived from Exception for specific HDF5 C interfaces.
*/
@Namespace("H5") @NoOffset public static class Exception extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Exception(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Exception(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Exception position(long position) {
        return (Exception)super.position(position);
    }

	// Creates an exception with a function name where the failure occurs
	// and an optional detailed message
	public Exception(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/);
	public Exception(@StdString BytePointer func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString BytePointer func_name);
	public Exception(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/);
	public Exception(@StdString String func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString String func_name);

	// Returns a character string that describes the error specified by
	// a major error number.
	public native @StdString BytePointer getMajorString( @Cast("hid_t") int err_major_id );

	// Returns a character string that describes the error specified by
	// a minor error number.
	public native @StdString BytePointer getMinorString( @Cast("hid_t") int err_minor_id );

	// Returns the detailed message set at the time the exception is thrown
	public native @StdString BytePointer getDetailMsg();
	public native @Cast("const char*") BytePointer getCDetailMsg();	// C string of detailed message
	public native @StdString BytePointer getFuncName();	// function name as a string object
	public native @Cast("const char*") BytePointer getCFuncName();	// function name as a char string

	// Turns on the automatic error printing.
	public static native void setAutoPrint( @ByPtrRef H5E_auto2_t func, Pointer client_data);

	// Turns off the automatic error printing.
	public static native void dontPrint();

	// Retrieves the current settings for the automatic error stack
	// traversal function and its data.
	public static native void getAutoPrint( @ByPtrRef H5E_auto2_t func, @Cast("void**") PointerPointer client_data);
	public static native void getAutoPrint( @ByPtrRef H5E_auto2_t func, @Cast("void**") @ByPtrPtr Pointer client_data);

	// Clears the error stack for the current thread.
	public static native void clearErrorStack();

	// Walks the error stack for the current thread, calling the
	// specified function.
	public static native void walkErrorStack( @Cast("H5E_direction_t") int direction,
					H5E_walk2_t func, Pointer client_data);

	// Prints the error stack in a default manner.
	public static native void printErrorStack(@Cast("FILE*") Pointer stream/*=stderr*/,
					    @Cast("hid_t") int err_stack/*=H5E_DEFAULT*/);
	public static native void printErrorStack(); // Static
	public native void printError(@Cast("FILE*") Pointer stream/*=NULL*/);
	public native void printError();

	// Default constructor
	public Exception() { super((Pointer)null); allocate(); }
	private native void allocate();

	// copy constructor
	public Exception( @Const @ByRef Exception orig) { super((Pointer)null); allocate(orig); }
	private native void allocate( @Const @ByRef Exception orig);

	// virtual Destructor
}

@Namespace("H5") public static class FileIException extends Exception {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileIException(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public FileIException(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public FileIException position(long position) {
        return (FileIException)super.position(position);
    }

	public FileIException( @StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate( @StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/);
	public FileIException( @StdString BytePointer func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate( @StdString BytePointer func_name);
	public FileIException( @StdString String func_name, @StdString String message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate( @StdString String func_name, @StdString String message/*=DEFAULT_MSG*/);
	public FileIException( @StdString String func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate( @StdString String func_name);
	public FileIException() { super((Pointer)null); allocate(); }
	private native void allocate();
}

@Namespace("H5") public static class GroupIException extends Exception {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public GroupIException(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public GroupIException(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public GroupIException position(long position) {
        return (GroupIException)super.position(position);
    }

	public GroupIException( @StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate( @StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/);
	public GroupIException( @StdString BytePointer func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate( @StdString BytePointer func_name);
	public GroupIException( @StdString String func_name, @StdString String message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate( @StdString String func_name, @StdString String message/*=DEFAULT_MSG*/);
	public GroupIException( @StdString String func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate( @StdString String func_name);
	public GroupIException() { super((Pointer)null); allocate(); }
	private native void allocate();
}

@Namespace("H5") public static class DataSpaceIException extends Exception {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DataSpaceIException(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DataSpaceIException(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DataSpaceIException position(long position) {
        return (DataSpaceIException)super.position(position);
    }

	public DataSpaceIException(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/);
	public DataSpaceIException(@StdString BytePointer func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString BytePointer func_name);
	public DataSpaceIException(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/);
	public DataSpaceIException(@StdString String func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString String func_name);
	public DataSpaceIException() { super((Pointer)null); allocate(); }
	private native void allocate();
}

@Namespace("H5") public static class DataTypeIException extends Exception {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DataTypeIException(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DataTypeIException(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DataTypeIException position(long position) {
        return (DataTypeIException)super.position(position);
    }

	public DataTypeIException(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/);
	public DataTypeIException(@StdString BytePointer func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString BytePointer func_name);
	public DataTypeIException(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/);
	public DataTypeIException(@StdString String func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString String func_name);
	public DataTypeIException() { super((Pointer)null); allocate(); }
	private native void allocate();
}

@Namespace("H5") public static class PropListIException extends Exception {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PropListIException(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public PropListIException(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public PropListIException position(long position) {
        return (PropListIException)super.position(position);
    }

	public PropListIException(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/);
	public PropListIException(@StdString BytePointer func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString BytePointer func_name);
	public PropListIException(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/);
	public PropListIException(@StdString String func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString String func_name);
	public PropListIException() { super((Pointer)null); allocate(); }
	private native void allocate();
}

@Namespace("H5") public static class DataSetIException extends Exception {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DataSetIException(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DataSetIException(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DataSetIException position(long position) {
        return (DataSetIException)super.position(position);
    }

	public DataSetIException(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/);
	public DataSetIException(@StdString BytePointer func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString BytePointer func_name);
	public DataSetIException(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/);
	public DataSetIException(@StdString String func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString String func_name);
	public DataSetIException() { super((Pointer)null); allocate(); }
	private native void allocate();
}

@Namespace("H5") public static class AttributeIException extends Exception {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AttributeIException(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AttributeIException(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public AttributeIException position(long position) {
        return (AttributeIException)super.position(position);
    }

	public AttributeIException(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/);
	public AttributeIException(@StdString BytePointer func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString BytePointer func_name);
	public AttributeIException(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/);
	public AttributeIException(@StdString String func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString String func_name);
	public AttributeIException() { super((Pointer)null); allocate(); }
	private native void allocate();
}

@Namespace("H5") public static class ReferenceException extends Exception {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ReferenceException(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ReferenceException(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ReferenceException position(long position) {
        return (ReferenceException)super.position(position);
    }

	public ReferenceException(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/);
	public ReferenceException(@StdString BytePointer func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString BytePointer func_name);
	public ReferenceException(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/);
	public ReferenceException(@StdString String func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString String func_name);
	public ReferenceException() { super((Pointer)null); allocate(); }
	private native void allocate();
}

@Namespace("H5") public static class LibraryIException extends Exception {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LibraryIException(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public LibraryIException(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public LibraryIException position(long position) {
        return (LibraryIException)super.position(position);
    }

	public LibraryIException(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/);
	public LibraryIException(@StdString BytePointer func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString BytePointer func_name);
	public LibraryIException(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/);
	public LibraryIException(@StdString String func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString String func_name);
	public LibraryIException() { super((Pointer)null); allocate(); }
	private native void allocate();
}

@Namespace("H5") public static class LocationException extends Exception {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LocationException(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public LocationException(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public LocationException position(long position) {
        return (LocationException)super.position(position);
    }

	public LocationException(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/);
	public LocationException(@StdString BytePointer func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString BytePointer func_name);
	public LocationException(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/);
	public LocationException(@StdString String func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString String func_name);
	public LocationException() { super((Pointer)null); allocate(); }
	private native void allocate();
}

@Namespace("H5") public static class IdComponentException extends Exception {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IdComponentException(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public IdComponentException(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public IdComponentException position(long position) {
        return (IdComponentException)super.position(position);
    }

	public IdComponentException(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString BytePointer func_name, @StdString BytePointer message/*=DEFAULT_MSG*/);
	public IdComponentException(@StdString BytePointer func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString BytePointer func_name);
	public IdComponentException(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/) { super((Pointer)null); allocate(func_name, message); }
	private native void allocate(@StdString String func_name, @StdString String message/*=DEFAULT_MSG*/);
	public IdComponentException(@StdString String func_name) { super((Pointer)null); allocate(func_name); }
	private native void allocate(@StdString String func_name);
	public IdComponentException() { super((Pointer)null); allocate(); }
	private native void allocate();
}

// #ifndef H5_NO_NAMESPACE

// #endif

// #endif // __H5Exception_H


// Parsed from H5IdComponent.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __IdComponent_H
// #define __IdComponent_H

// IdComponent represents an HDF5 object that has an identifier.

// #ifndef H5_NO_NAMESPACE
// #endif
/** \class IdComponent
    \brief Class IdComponent provides wrappers of the C functions that
     operate on an HDF5 identifier.
    <p>
    In most cases, the C library handles these operations and an application
    rarely needs them.
*/
@Namespace("H5") @NoOffset public static class IdComponent extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IdComponent(Pointer p) { super(p); }


	// Increment reference counter.
	public native void incRefCount(@Cast("const hid_t") int obj_id);
	public native void incRefCount();

	// Decrement reference counter.
	public native void decRefCount(@Cast("const hid_t") int obj_id);
	public native void decRefCount();

	// Get the reference counter to this identifier.
	public native int getCounter(@Cast("const hid_t") int obj_id);
	public native int getCounter();

	// Returns an HDF5 object type, given the object id.
	public static native @Cast("H5I_type_t") int getHDFObjType(@Cast("const hid_t") int obj_id);

	// Returns an HDF5 object type of this object.
	public native @Cast("H5I_type_t") int getHDFObjType();

	// Assignment operator.
	public native @ByRef @Name("operator =") IdComponent put( @Const @ByRef IdComponent rhs );

	// Sets the identifier of this object to a new value.
	public native void setId(@Cast("const hid_t") int new_id);

	// *** Deprecation warning ***
	// The following two constructors are no longer appropriate after the
	// data member "id" had been moved to the sub-classes.
	// The copy constructor is a noop and is removed in 1.8.15 and the
	// other will be removed from 1.10 release, and then from 1.8 if its
	// removal does not raise any problems in two 1.10 releases.

	// Creates an object to hold an HDF5 identifier.

// #ifndef DOXYGEN_SHOULD_SKIP_THIS

	// Copy constructor: makes copy of the original IdComponent object.
	// IdComponent( const IdComponent& original ); - removed from 1.8.15

	// Gets the identifier of this object.
	public native @Cast("hid_t") int getId();

	// Pure virtual function for there are various H5*close for the
	// subclasses.
	public native @Name("close") void _close();

	// Makes and returns the string "<class-name>::<func_name>";
	// <class-name> is returned by fromClass().
	public native @StdString BytePointer inMemFunc(@Cast("const char*") BytePointer func_name);
	public native @StdString String inMemFunc(String func_name);

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

// #endif // DOXYGEN_SHOULD_SKIP_THIS

	// Destructor

} // end class IdComponent

// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __IdComponent_H


// Parsed from H5DataSpace.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5DataSpace_H
// #define __H5DataSpace_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** Class DataSpace operates on HDF5 dataspaces. */
@Namespace("H5") @NoOffset public static class DataSpace extends IdComponent {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DataSpace(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DataSpace(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DataSpace position(long position) {
        return (DataSpace)super.position(position);
    }

	/**\brief Default DataSpace objects */
	@MemberGetter public static native @Const @ByRef DataSpace ALL();

	// Creates a dataspace object given the space type
	public DataSpace(@Cast("H5S_class_t") int type/*=H5S_SCALAR*/) { super((Pointer)null); allocate(type); }
	private native void allocate(@Cast("H5S_class_t") int type/*=H5S_SCALAR*/);
	public DataSpace() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Creates a simple dataspace
	public DataSpace(int rank, @Cast("const hsize_t*") LongPointer dims, @Cast("const hsize_t*") LongPointer maxdims/*=NULL*/) { super((Pointer)null); allocate(rank, dims, maxdims); }
	private native void allocate(int rank, @Cast("const hsize_t*") LongPointer dims, @Cast("const hsize_t*") LongPointer maxdims/*=NULL*/);
	public DataSpace(int rank, @Cast("const hsize_t*") LongPointer dims) { super((Pointer)null); allocate(rank, dims); }
	private native void allocate(int rank, @Cast("const hsize_t*") LongPointer dims);
	public DataSpace(int rank, @Cast("const hsize_t*") LongBuffer dims, @Cast("const hsize_t*") LongBuffer maxdims/*=NULL*/) { super((Pointer)null); allocate(rank, dims, maxdims); }
	private native void allocate(int rank, @Cast("const hsize_t*") LongBuffer dims, @Cast("const hsize_t*") LongBuffer maxdims/*=NULL*/);
	public DataSpace(int rank, @Cast("const hsize_t*") LongBuffer dims) { super((Pointer)null); allocate(rank, dims); }
	private native void allocate(int rank, @Cast("const hsize_t*") LongBuffer dims);
	public DataSpace(int rank, @Cast("const hsize_t*") long[] dims, @Cast("const hsize_t*") long[] maxdims/*=NULL*/) { super((Pointer)null); allocate(rank, dims, maxdims); }
	private native void allocate(int rank, @Cast("const hsize_t*") long[] dims, @Cast("const hsize_t*") long[] maxdims/*=NULL*/);
	public DataSpace(int rank, @Cast("const hsize_t*") long[] dims) { super((Pointer)null); allocate(rank, dims); }
	private native void allocate(int rank, @Cast("const hsize_t*") long[] dims);

	// Creates a DataSpace object using an existing dataspace id.

	// Copy constructor: makes a copy of the original DataSpace object.
	public DataSpace(@Const @ByRef DataSpace original) { super((Pointer)null); allocate(original); }
	private native void allocate(@Const @ByRef DataSpace original);

	// Assignment operator
	public native @ByRef @Name("operator =") DataSpace put( @Const @ByRef DataSpace rhs );

	// Closes this dataspace.
	public native @Name("close") void _close();

	// Makes copy of an existing dataspace.
	public native void copy(@Const @ByRef DataSpace like_space);

	// Copies the extent of this dataspace.
	public native void extentCopy(@Const @ByRef DataSpace dest_space);
	// Kept for backward compatibility only.

	// Gets the bounding box containing the current selection.
	public native void getSelectBounds( @Cast("hsize_t*") LongPointer start, @Cast("hsize_t*") LongPointer end );
	public native void getSelectBounds( @Cast("hsize_t*") LongBuffer start, @Cast("hsize_t*") LongBuffer end );
	public native void getSelectBounds( @Cast("hsize_t*") long[] start, @Cast("hsize_t*") long[] end );

	// Gets the number of element points in the current selection.
	public native @Cast("hssize_t") long getSelectElemNpoints();

	// Retrieves the list of element points currently selected.
	public native void getSelectElemPointlist( @Cast("hsize_t") long startpoint, @Cast("hsize_t") long numpoints, @Cast("hsize_t*") LongPointer buf );
	public native void getSelectElemPointlist( @Cast("hsize_t") long startpoint, @Cast("hsize_t") long numpoints, @Cast("hsize_t*") LongBuffer buf );
	public native void getSelectElemPointlist( @Cast("hsize_t") long startpoint, @Cast("hsize_t") long numpoints, @Cast("hsize_t*") long[] buf );

	// Gets the list of hyperslab blocks currently selected.
	public native void getSelectHyperBlocklist( @Cast("hsize_t") long startblock, @Cast("hsize_t") long numblocks, @Cast("hsize_t*") LongPointer buf );
	public native void getSelectHyperBlocklist( @Cast("hsize_t") long startblock, @Cast("hsize_t") long numblocks, @Cast("hsize_t*") LongBuffer buf );
	public native void getSelectHyperBlocklist( @Cast("hsize_t") long startblock, @Cast("hsize_t") long numblocks, @Cast("hsize_t*") long[] buf );

	// Get number of hyperslab blocks.
	public native @Cast("hssize_t") long getSelectHyperNblocks();

	// Gets the number of elements in this dataspace selection.
	public native @Cast("hssize_t") long getSelectNpoints();

	// Retrieves dataspace dimension size and maximum size.
	public native int getSimpleExtentDims( @Cast("hsize_t*") LongPointer dims, @Cast("hsize_t*") LongPointer maxdims/*=NULL*/ );
	public native int getSimpleExtentDims( @Cast("hsize_t*") LongPointer dims );
	public native int getSimpleExtentDims( @Cast("hsize_t*") LongBuffer dims, @Cast("hsize_t*") LongBuffer maxdims/*=NULL*/ );
	public native int getSimpleExtentDims( @Cast("hsize_t*") LongBuffer dims );
	public native int getSimpleExtentDims( @Cast("hsize_t*") long[] dims, @Cast("hsize_t*") long[] maxdims/*=NULL*/ );
	public native int getSimpleExtentDims( @Cast("hsize_t*") long[] dims );

	// Gets the dimensionality of this dataspace.
	public native int getSimpleExtentNdims();

	// Gets the number of elements in this dataspace.
	// 12/05/00 - changed return type to hssize_t from hsize_t - C API
	public native @Cast("hssize_t") long getSimpleExtentNpoints();

	// Gets the current class of this dataspace.
	public native @Cast("H5S_class_t") int getSimpleExtentType();

	// Determines if this dataspace is a simple one.
	public native @Cast("bool") boolean isSimple();

	// Sets the offset of this simple dataspace.
	public native void offsetSimple( @Cast("const hssize_t*") LongPointer offset );
	public native void offsetSimple( @Cast("const hssize_t*") LongBuffer offset );
	public native void offsetSimple( @Cast("const hssize_t*") long[] offset );

	// Selects the entire dataspace.
	public native void selectAll();

	// Selects array elements to be included in the selection for
	// this dataspace.
	public native void selectElements( @Cast("H5S_seloper_t") int op, @Cast("const size_t") long num_elements, @Cast("const hsize_t*") LongPointer coord);
	public native void selectElements( @Cast("H5S_seloper_t") int op, @Cast("const size_t") long num_elements, @Cast("const hsize_t*") LongBuffer coord);
	public native void selectElements( @Cast("H5S_seloper_t") int op, @Cast("const size_t") long num_elements, @Cast("const hsize_t*") long[] coord);

	// Selects a hyperslab region to add to the current selected region.
	public native void selectHyperslab( @Cast("H5S_seloper_t") int op, @Cast("const hsize_t*") LongPointer count, @Cast("const hsize_t*") LongPointer start, @Cast("const hsize_t*") LongPointer stride/*=NULL*/, @Cast("const hsize_t*") LongPointer block/*=NULL*/ );
	public native void selectHyperslab( @Cast("H5S_seloper_t") int op, @Cast("const hsize_t*") LongPointer count, @Cast("const hsize_t*") LongPointer start );
	public native void selectHyperslab( @Cast("H5S_seloper_t") int op, @Cast("const hsize_t*") LongBuffer count, @Cast("const hsize_t*") LongBuffer start, @Cast("const hsize_t*") LongBuffer stride/*=NULL*/, @Cast("const hsize_t*") LongBuffer block/*=NULL*/ );
	public native void selectHyperslab( @Cast("H5S_seloper_t") int op, @Cast("const hsize_t*") LongBuffer count, @Cast("const hsize_t*") LongBuffer start );
	public native void selectHyperslab( @Cast("H5S_seloper_t") int op, @Cast("const hsize_t*") long[] count, @Cast("const hsize_t*") long[] start, @Cast("const hsize_t*") long[] stride/*=NULL*/, @Cast("const hsize_t*") long[] block/*=NULL*/ );
	public native void selectHyperslab( @Cast("H5S_seloper_t") int op, @Cast("const hsize_t*") long[] count, @Cast("const hsize_t*") long[] start );

	// Resets the selection region to include no elements.
	public native void selectNone();

	// Verifies that the selection is within the extent of the dataspace.
	public native @Cast("bool") boolean selectValid();

	// Removes the extent from this dataspace.
	public native void setExtentNone();

	// Sets or resets the size of this dataspace.
	public native void setExtentSimple( int rank, @Cast("const hsize_t*") LongPointer current_size, @Cast("const hsize_t*") LongPointer maximum_size/*=NULL*/ );
	public native void setExtentSimple( int rank, @Cast("const hsize_t*") LongPointer current_size );
	public native void setExtentSimple( int rank, @Cast("const hsize_t*") LongBuffer current_size, @Cast("const hsize_t*") LongBuffer maximum_size/*=NULL*/ );
	public native void setExtentSimple( int rank, @Cast("const hsize_t*") LongBuffer current_size );
	public native void setExtentSimple( int rank, @Cast("const hsize_t*") long[] current_size, @Cast("const hsize_t*") long[] maximum_size/*=NULL*/ );
	public native void setExtentSimple( int rank, @Cast("const hsize_t*") long[] current_size );

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Gets the dataspace id.
	public native @Cast("hid_t") int getId();

	// Deletes the global constant
	public static native void deleteConstants();

	// Destructor: properly terminates access to this dataspace.
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5DataSpace_H


// Parsed from H5PropList.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5PropList_H
// #define __H5PropList_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** Class PropList provides operations for generic property lists. */
@Namespace("H5") @NoOffset public static class PropList extends IdComponent {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PropList(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public PropList(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public PropList position(long position) {
        return (PropList)super.position(position);
    }

	/**\brief Default property list */
        @MemberGetter public static native @Const @ByRef PropList DEFAULT();

	// Creates a property list of a given type or creates a copy of an
	// existing property list giving the property list id.
	public PropList(@Cast("const hid_t") int plist_id) { super((Pointer)null); allocate(plist_id); }
	private native void allocate(@Cast("const hid_t") int plist_id);

	// Make a copy of the given property list using assignment statement
	public native @ByRef @Name("operator =") PropList put( @Const @ByRef PropList rhs );

	// Compares this property list or class against the given list or class.
	public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef PropList rhs);

	// Close this property list.
	public native @Name("close") void _close();

	// Close a property list class.
	public native void closeClass();

	// Makes a copy of the given property list.
	public native void copy( @Const @ByRef PropList like_plist );

	// Copies a property from this property list or class to another
	public native void copyProp( @ByRef PropList dest, @Cast("const char*") BytePointer name);
	public native void copyProp( @ByRef PropList dest, String name);

	// Copies a property from one property list or property class to another
	public native void copyProp( @ByRef PropList dest, @ByRef PropList src, @Cast("const char*") BytePointer name);
	public native void copyProp( @ByRef PropList dest, @ByRef PropList src, String name);

	// Gets the class of this property list, i.e. H5P_FILE_CREATE,
	// H5P_FILE_ACCESS, ...
	public native @Cast("hid_t") @Name("getClass") int _getClass();

	// Return the name of a generic property list class.
	public native @StdString BytePointer getClassName();

	// Returns the parent class of a generic property class.
	public native @ByVal PropList getClassParent();

	// Returns the number of properties in this property list or class.
	public native @Cast("size_t") long getNumProps();

	// Query the value of a property in a property list.
	public native void getProperty(@Cast("const char*") BytePointer name, Pointer value);
	public native void getProperty(String name, Pointer value);
	public native @StdString BytePointer getProperty(@Cast("const char*") BytePointer name);
	public native @StdString String getProperty(String name);

	// Set a property's value in a property list.
	public native void setProperty(@Cast("const char*") BytePointer name, Pointer value);
	public native void setProperty(String name, Pointer value);
	public native void setProperty(@Cast("const char*") BytePointer name, @Cast("const char*") BytePointer charptr);
	public native void setProperty(String name, String charptr);

	// Query the size of a property in a property list or class.
	public native @Cast("size_t") long getPropSize(@Cast("const char*") BytePointer name);
	public native @Cast("size_t") long getPropSize(String name);

	// Determines whether a property list is a certain class.
	public native @Cast("bool") boolean isAClass(@Const @ByRef PropList prop_class);

	/** Query the existance of a property in a property object. */
	public native @Cast("bool") boolean propExist(@Cast("const char*") BytePointer name);
	public native @Cast("bool") boolean propExist(String name);

	// Removes a property from a property list.
	public native void removeProp(@Cast("const char*") BytePointer name);
	public native void removeProp(String name);

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Default constructor: creates a stub PropList object.
	public PropList() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Copy constructor: creates a copy of a PropList object.
	public PropList(@Const @ByRef PropList original) { super((Pointer)null); allocate(original); }
	private native void allocate(@Const @ByRef PropList original);

	// Gets the property list id.
	public native @Cast("hid_t") int getId();

	// Destructor: properly terminates access to this property list.

// #ifndef DOXYGEN_SHOULD_SKIP_THIS

	// Deletes the PropList global constant
	public static native void deleteConstants();
}

// #ifndef H5_NO_NAMESPACE

// #endif
// #endif  // __H5PropList_H


// Parsed from H5Location.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5Location_H
// #define __H5Location_H

// #include "H5Classes.h"		// constains forward class declarations

// #ifndef H5_NO_NAMESPACE
// #endif  // forward declaration for UserData4Aiterate

// Define the operator function pointer for H5Aiterate().
public static class attr_operator_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    attr_operator_t(Pointer p) { super(p); }
    protected attr_operator_t() { allocate(); }
    private native void allocate();
    public native void call( @ByRef H5Location loc,
            @Cast({"", "std::string", "std::string&"}) @Adapter("StringAdapter") BytePointer attr_name,
            Pointer operator_data);
}

/** User data for attribute iteration */
@Namespace("H5") public static class UserData4Aiterate extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public UserData4Aiterate() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public UserData4Aiterate(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public UserData4Aiterate(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public UserData4Aiterate position(long position) {
        return (UserData4Aiterate)super.position(position);
    }

	public native attr_operator_t op(); public native UserData4Aiterate op(attr_operator_t op);
	public native Pointer opData(); public native UserData4Aiterate opData(Pointer opData);
	public native H5Location location(); public native UserData4Aiterate location(H5Location location);
}

/** \class H5Location
    \brief H5Location is an abstract base class, added in version 1.8.12.
    <p>
    It provides a collection of wrappers for the C functions that take a
    location identifier to specify the HDF5 object.  The location identifier
    can be either file, group, dataset, or named datatype.
*/
// Most of these methods were in H5Object but are now moved here because
// a location can be a file, group, dataset, or named datatype. -BMR, 2013-10-1
@Namespace("H5") public static class H5Location extends IdComponent {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5Location(Pointer p) { super(p); }

	// Creates an attribute for the specified object at this location
	// PropList is currently not used, so always be default.
	public native @ByVal Attribute createAttribute( @Cast("const char*") BytePointer name, @Const @ByRef DataType type, @Const @ByRef DataSpace space, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList create_plist );
	public native @ByVal Attribute createAttribute( @Cast("const char*") BytePointer name, @Const @ByRef DataType type, @Const @ByRef DataSpace space );
	public native @ByVal Attribute createAttribute( String name, @Const @ByRef DataType type, @Const @ByRef DataSpace space, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList create_plist );
	public native @ByVal Attribute createAttribute( String name, @Const @ByRef DataType type, @Const @ByRef DataSpace space );

	// Given its name, opens the attribute that belongs to an object at
	// this location.
	public native @ByVal Attribute openAttribute( @Cast("const char*") BytePointer name );
	public native @ByVal Attribute openAttribute( String name );

	// Given its index, opens the attribute that belongs to an object at
	// this location.
	public native @ByVal Attribute openAttribute( @Cast("const unsigned int") int idx );

	// Flushes all buffers associated with this location to disk.
	public native void flush( @Cast("H5F_scope_t") int scope );

	// Gets the name of the file, specified by this location.
	public native @StdString BytePointer getFileName();

	// Determines the number of attributes at this location.
	public native int getNumAttrs();

// #ifndef H5_NO_DEPRECATED_SYMBOLS
// #endif /* H5_NO_DEPRECATED_SYMBOLS */

	// Retrieves the type of object that an object reference points to.
	public native @Cast("H5O_type_t") int getRefObjType(Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/);
	public native @Cast("H5O_type_t") int getRefObjType(Pointer ref);
	// Note: getRefObjType deprecates getObjType, but getObjType's name is
	// misleading, so getRefObjType is used in the new function instead.

	// Iterate user's function over the attributes at this location.
	public native int iterateAttrs(attr_operator_t user_op, @Cast("unsigned*") IntPointer idx/*=NULL*/, Pointer op_data/*=NULL*/);
	public native int iterateAttrs(attr_operator_t user_op);
	public native int iterateAttrs(attr_operator_t user_op, @Cast("unsigned*") IntBuffer idx/*=NULL*/, Pointer op_data/*=NULL*/);
	public native int iterateAttrs(attr_operator_t user_op, @Cast("unsigned*") int[] idx/*=NULL*/, Pointer op_data/*=NULL*/);

	// Checks whether the named attribute exists at this location.
	public native @Cast("bool") boolean attrExists(@Cast("const char*") BytePointer name);
	public native @Cast("bool") boolean attrExists(String name);

	// Renames the named attribute to a new name.
	public native void renameAttr(@Cast("const char*") BytePointer oldname, @Cast("const char*") BytePointer newname);
	public native void renameAttr(String oldname, String newname);

	// Removes the named attribute from this location.
	public native void removeAttr(@Cast("const char*") BytePointer name);
	public native void removeAttr(String name);

	// Sets the comment for an HDF5 object specified by its name.
	public native void setComment(@Cast("const char*") BytePointer name, @Cast("const char*") BytePointer comment);
	public native void setComment(String name, String comment);
	public native void setComment(@Cast("const char*") BytePointer comment);
	public native void setComment(String comment);

	// Retrieves comment for the HDF5 object specified by its name.
	public native @Cast("ssize_t") int getComment(@Cast("const char*") BytePointer name, @Cast("size_t") long buf_size, @Cast("char*") BytePointer comment);
	public native @Cast("ssize_t") int getComment(String name, @Cast("size_t") long buf_size, @Cast("char*") ByteBuffer comment);
	public native @Cast("ssize_t") int getComment(@Cast("const char*") BytePointer name, @Cast("size_t") long buf_size, @Cast("char*") byte[] comment);
	public native @Cast("ssize_t") int getComment(String name, @Cast("size_t") long buf_size, @Cast("char*") BytePointer comment);
	public native @Cast("ssize_t") int getComment(@Cast("const char*") BytePointer name, @Cast("size_t") long buf_size, @Cast("char*") ByteBuffer comment);
	public native @Cast("ssize_t") int getComment(String name, @Cast("size_t") long buf_size, @Cast("char*") byte[] comment);
	public native @StdString BytePointer getComment(@Cast("const char*") BytePointer name, @Cast("size_t") long buf_size/*=0*/);
	public native @StdString BytePointer getComment(@Cast("const char*") BytePointer name);
	public native @StdString String getComment(String name, @Cast("size_t") long buf_size/*=0*/);
	public native @StdString String getComment(String name);

	// Removes the comment for the HDF5 object specified by its name.
	public native void removeComment(@Cast("const char*") BytePointer name);
	public native void removeComment(String name);

	// Creates a reference to a named object or to a dataset region
	// in this object.
	public native void reference(Pointer ref, @Cast("const char*") BytePointer name, 
				@Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/);
	public native void reference(Pointer ref, @Cast("const char*") BytePointer name);
	public native void reference(Pointer ref, String name, 
				@Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/);
	public native void reference(Pointer ref, String name);
	public native void reference(Pointer ref, @Cast("const char*") BytePointer name, @Const @ByRef DataSpace dataspace,
				@Cast("H5R_type_t") int ref_type/*=H5R_DATASET_REGION*/);
	public native void reference(Pointer ref, @Cast("const char*") BytePointer name, @Const @ByRef DataSpace dataspace);
	public native void reference(Pointer ref, String name, @Const @ByRef DataSpace dataspace,
				@Cast("H5R_type_t") int ref_type/*=H5R_DATASET_REGION*/);
	public native void reference(Pointer ref, String name, @Const @ByRef DataSpace dataspace);

	// Open a referenced object whose location is specified by either
	// a file, an HDF5 object, or an attribute.
	public native void dereference(@Const @ByRef H5Location loc, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist);
	public native void dereference(@Const @ByRef H5Location loc, @Const Pointer ref);
	public native void dereference(@Const @ByRef Attribute attr, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist);
	public native void dereference(@Const @ByRef Attribute attr, @Const Pointer ref);

	// Retrieves a dataspace with the region pointed to selected.
	public native @ByVal DataSpace getRegion(Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_DATASET_REGION*/);
	public native @ByVal DataSpace getRegion(Pointer ref);

	/**\brief Returns an identifier. (pure virtual) */
	public native @Cast("hid_t") int getId();

} /* end class H5Location */

// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5Location_H


// Parsed from H5Object.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5Object_H
// #define __H5Object_H

// #include "H5Location.h"
// #include "H5Classes.h"		// constains forward class declarations

// H5Object is a baseclass.  It has these subclasses:
// Group, DataSet, and DataType.
// DataType, in turn, has several specific datatypes as subclasses.
// Modification:
//	Sept 18, 2012: Added class H5Location in between IdComponent and
//		H5Object.  An H5File now inherits from H5Location.  All HDF5
//		wrappers in H5Object are moved up to H5Location.  H5Object
//		is left mostly empty for future wrappers that are only for
//		group, dataset, and named datatype.  Note that the reason for
//		adding H5Location instead of simply moving H5File to be under
//		H5Object is H5File is not an HDF5 object, and renaming H5Object
//		to H5Location will risk breaking user applications.
//		-BMR
//	Apr 2, 2014: Added wrapper getObjName for H5Iget_name 
// #ifndef H5_NO_NAMESPACE
// #endif

/** \class H5Object
    \brief Class H5Object is a bridge between H5Location and DataSet, DataType,
     and Group.
    <p>
    All the wrappers in H5Object were moved to H5Location.
*/
@Namespace("H5") public static class H5Object extends H5Location {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5Object(Pointer p) { super(p); }

// #ifndef DOXYGEN_SHOULD_SKIP_THIS
	// Gets the name of this HDF5 object, i.e., Group, DataSet, or
	// DataType.
	public native @Cast("ssize_t") int getObjName(@Cast("char*") BytePointer obj_name, @Cast("size_t") long buf_size/*=0*/);
	public native @Cast("ssize_t") int getObjName(@Cast("char*") BytePointer obj_name);
	public native @Cast("ssize_t") int getObjName(@Cast("char*") ByteBuffer obj_name, @Cast("size_t") long buf_size/*=0*/);
	public native @Cast("ssize_t") int getObjName(@Cast("char*") ByteBuffer obj_name);
	public native @Cast("ssize_t") int getObjName(@Cast("char*") byte[] obj_name, @Cast("size_t") long buf_size/*=0*/);
	public native @Cast("ssize_t") int getObjName(@Cast("char*") byte[] obj_name);
	public native @Cast("ssize_t") int getObjName(@StdString String obj_name, @Cast("size_t") long len/*=0*/);
	public native @Cast("ssize_t") int getObjName(@StdString String obj_name);
	public native @StdString BytePointer getObjName();

	// Noop destructor.

} /* end class H5Object */

// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5Object_H


// Parsed from H5AbstractDs.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __AbstractDs_H
// #define __AbstractDs_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** \class AbstractDs
    \brief AbstractDs is an abstract base class, inherited by Attribute
     and DataSet.
    <p>
    It provides a collection of services that are common to both Attribute
    and DataSet.  AbstractDs inherits from H5Object.
*/
@Namespace("H5") public static class AbstractDs extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AbstractDs(Pointer p) { super(p); }

	// Gets a copy the datatype of that this abstract dataset uses.
	// Note that this datatype is a generic one and can only be accessed
	// via generic member functions, i.e., member functions belong
	// to DataType.  To get specific datatype, i.e. EnumType, FloatType,
	// etc..., use the specific functions, that follow, instead.
	public native @ByVal DataType getDataType();

	// Gets a copy of the specific datatype of this abstract dataset.
	public native @ByVal ArrayType getArrayType();
	public native @ByVal CompType getCompType();
	public native @ByVal EnumType getEnumType();
	public native @ByVal IntType getIntType();
	public native @ByVal FloatType getFloatType();
	public native @ByVal StrType getStrType();
	public native @ByVal VarLenType getVarLenType();

	/**\brief Gets the size in memory of this abstract dataset. */
	public native @Cast("size_t") long getInMemDataSize();

	/**\brief Gets the dataspace of this abstract dataset - pure virtual. */
	public native @ByVal DataSpace getSpace();

	// Gets the class of the datatype that is used by this abstract
	// dataset.
	public native @Cast("H5T_class_t") int getTypeClass();

	/**\brief Returns the amount of storage size required - pure virtual. */
	public native @Cast("hsize_t") long getStorageSize();

	// Returns this class name - pure virtual.
	public native @StdString BytePointer fromClass();

	// Destructor
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __AbstractDs_H


// Parsed from H5Attribute.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5Attribute_H
// #define __H5Attribute_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** \class Attribute
    \brief Class Attribute operates on HDF5 attributes.
    <p>
    An attribute has many characteristics similar to a dataset, thus both
    Attribute and DataSet are derivatives of AbstractDs.  Attribute also
    inherits from IdComponent because an attribute is an HDF5 component that
    is identified by an identifier.
*/
@Namespace("H5") @NoOffset public static class Attribute extends AbstractDs {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Attribute(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Attribute(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Attribute position(long position) {
        return (Attribute)super.position(position);
    }
    public IdComponent asIdComponent() { return asIdComponent(this); }
    @Namespace public static native @Name("static_cast<H5::IdComponent*>") IdComponent asIdComponent(Attribute pointer);


	// Copy constructor: makes a copy of an existing Attribute object.
	public Attribute( @Const @ByRef Attribute original ) { super((Pointer)null); allocate(original); }
	private native void allocate( @Const @ByRef Attribute original );

	// Default constructor
	public Attribute() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Creates a copy of an existing attribute using the attribute id
	public Attribute( @Cast("const hid_t") int attr_id ) { super((Pointer)null); allocate(attr_id); }
	private native void allocate( @Cast("const hid_t") int attr_id );

	// Closes this attribute.
	public native @Name("close") void _close();

	// Gets the name of the file, in which this attribute belongs.
	public native @StdString BytePointer getFileName();

	// Gets the name of this attribute.
	public native @Cast("ssize_t") int getName(@Cast("char*") BytePointer attr_name, @Cast("size_t") long buf_size/*=0*/);
	public native @Cast("ssize_t") int getName(@Cast("char*") BytePointer attr_name);
	public native @Cast("ssize_t") int getName(@Cast("char*") ByteBuffer attr_name, @Cast("size_t") long buf_size/*=0*/);
	public native @Cast("ssize_t") int getName(@Cast("char*") ByteBuffer attr_name);
	public native @Cast("ssize_t") int getName(@Cast("char*") byte[] attr_name, @Cast("size_t") long buf_size/*=0*/);
	public native @Cast("ssize_t") int getName(@Cast("char*") byte[] attr_name);
	public native @StdString BytePointer getName(@Cast("size_t") long len);
	public native @StdString BytePointer getName();
	public native @Cast("ssize_t") int getName(@StdString String attr_name, @Cast("size_t") long len/*=0*/);
	public native @Cast("ssize_t") int getName(@StdString String attr_name);
	// The overloaded function below is replaced by the one above and it
	// is kept for backward compatibility purpose.
	public native @Cast("ssize_t") int getName( @Cast("size_t") long buf_size, @StdString BytePointer attr_name );
	public native @Cast("ssize_t") int getName( @Cast("size_t") long buf_size, @StdString String attr_name );

	// Gets a copy of the dataspace for this attribute.
	public native @ByVal DataSpace getSpace();

	// Returns the amount of storage size required for this attribute.
	public native @Cast("hsize_t") long getStorageSize();

	// Returns the in memory size of this attribute's data.
	public native @Cast("size_t") long getInMemDataSize();

	// Reads data from this attribute.
	public native void read( @Const @ByRef DataType mem_type, Pointer buf );
	public native void read( @Const @ByRef DataType mem_type, @StdString BytePointer strg );
	public native void read( @Const @ByRef DataType mem_type, @StdString String strg );

	// Writes data to this attribute.
	public native void write(@Const @ByRef DataType mem_type, @Const Pointer buf );
	public native void write(@Const @ByRef DataType mem_type, @StdString BytePointer strg );
	public native void write(@Const @ByRef DataType mem_type, @StdString String strg );

	// Flushes all buffers associated with the file specified by this
	// attribute to disk.
	public native void flush( @Cast("H5F_scope_t") int scope );

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Gets the attribute id.
	public native @Cast("hid_t") int getId();

	// Destructor: properly terminates access to this attribute.

}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5Attribute_H


// Parsed from H5OcreatProp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5ObjCreatPropList_H
// #define __H5ObjCreatPropList_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** Class ObjCreatPropList represents the HDF5 object creation property list. */
@Namespace("H5") @NoOffset public static class ObjCreatPropList extends PropList {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ObjCreatPropList(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ObjCreatPropList(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ObjCreatPropList position(long position) {
        return (ObjCreatPropList)super.position(position);
    }

	/**\brief Default object creation property list. */
	@MemberGetter public static native @Const @ByRef ObjCreatPropList DEFAULT();

	// Creates a object creation property list.
	public ObjCreatPropList() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Sets attribute storage phase change thresholds.
	public native void setAttrPhaseChange(@Cast("unsigned") int max_compact/*=8*/, @Cast("unsigned") int min_dense/*=6*/);
	public native void setAttrPhaseChange();

	// Gets attribute storage phase change thresholds.
	public native void getAttrPhaseChange(@Cast("unsigned*") @ByRef IntPointer max_compact, @Cast("unsigned*") @ByRef IntPointer min_dense);
	public native void getAttrPhaseChange(@Cast("unsigned*") @ByRef IntBuffer max_compact, @Cast("unsigned*") @ByRef IntBuffer min_dense);
	public native void getAttrPhaseChange(@Cast("unsigned*") @ByRef int[] max_compact, @Cast("unsigned*") @ByRef int[] min_dense);

	// Sets tracking and indexing of attribute creation order.
	public native void setAttrCrtOrder(@Cast("unsigned") int crt_order_flags);

	// Gets tracking and indexing settings for attribute creation order.
	public native @Cast("unsigned") int getAttrCrtOrder();


	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Copy constructor: creates a copy of a ObjCreatPropList object.
	public ObjCreatPropList( @Const @ByRef ObjCreatPropList original ) { super((Pointer)null); allocate(original); }
	private native void allocate( @Const @ByRef ObjCreatPropList original );

	// Creates a copy of an existing object creation property list
	// using the property list id.
	public ObjCreatPropList(@Cast("const hid_t") int plist_id) { super((Pointer)null); allocate(plist_id); }
	private native void allocate(@Cast("const hid_t") int plist_id);

	// Noop destructor

// #ifndef DOXYGEN_SHOULD_SKIP_THIS

        // Deletes the global constant, should only be used by the library
        public static native void deleteConstants();

}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5ObjCreatPropList_H


// Parsed from H5DcreatProp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// Class DSetCreatPropList represents the HDF5 dataset creation property list
// and inherits from PropList.

// #ifndef __H5DSCreatPropList_H
// #define __H5DSCreatPropList_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** \class DSetCreatPropList
    \brief Class DSetCreatPropList represents the dataset creation property
    list.
*/
@Namespace("H5") @NoOffset public static class DSetCreatPropList extends ObjCreatPropList {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DSetCreatPropList(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DSetCreatPropList(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DSetCreatPropList position(long position) {
        return (DSetCreatPropList)super.position(position);
    }

	/**\brief Default dataset creation property list. */
	@MemberGetter public static native @Const @ByRef DSetCreatPropList DEFAULT();

	// Creates a dataset creation property list.
	public DSetCreatPropList() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Queries whether all the filters set in this property list are
	// available currently.
	public native @Cast("bool") boolean allFiltersAvail();

	// Get space allocation time for this property.
	public native @Cast("H5D_alloc_time_t") int getAllocTime();

	// Set space allocation time for dataset during creation.
	public native void setAllocTime(@Cast("H5D_alloc_time_t") int alloc_time);

	// Retrieves the size of the chunks used to store a chunked layout dataset.
	public native int getChunk( int max_ndims, @Cast("hsize_t*") LongPointer dim );
	public native int getChunk( int max_ndims, @Cast("hsize_t*") LongBuffer dim );
	public native int getChunk( int max_ndims, @Cast("hsize_t*") long[] dim );

	// Sets the size of the chunks used to store a chunked layout dataset.
	public native void setChunk( int ndims, @Cast("const hsize_t*") LongPointer dim );
	public native void setChunk( int ndims, @Cast("const hsize_t*") LongBuffer dim );
	public native void setChunk( int ndims, @Cast("const hsize_t*") long[] dim );

	// Returns information about an external file.
	public native void getExternal( @Cast("unsigned") int idx, @Cast("size_t") long name_size, @Cast("char*") BytePointer name, @Cast("off_t*") @ByRef SizeTPointer offset, @Cast("hsize_t*") @ByRef LongPointer size );
	public native void getExternal( @Cast("unsigned") int idx, @Cast("size_t") long name_size, @Cast("char*") ByteBuffer name, @Cast("off_t*") @ByRef SizeTPointer offset, @Cast("hsize_t*") @ByRef LongBuffer size );
	public native void getExternal( @Cast("unsigned") int idx, @Cast("size_t") long name_size, @Cast("char*") byte[] name, @Cast("off_t*") @ByRef SizeTPointer offset, @Cast("hsize_t*") @ByRef long[] size );

	// Returns the number of external files for a dataset.
	public native int getExternalCount();

	// Gets fill value writing time.
	public native @Cast("H5D_fill_time_t") int getFillTime();

	// Sets fill value writing time for dataset.
	public native void setFillTime(@Cast("H5D_fill_time_t") int fill_time);

	// Retrieves a dataset fill value.
	public native void getFillValue( @Const @ByRef DataType fvalue_type, Pointer value );

	// Sets a dataset fill value.
	public native void setFillValue( @Const @ByRef DataType fvalue_type, @Const Pointer value );

	// Returns information about a filter in a pipeline.
	public native @Cast("H5Z_filter_t") int getFilter(int filter_number, @Cast("unsigned int*") @ByRef IntPointer flags, @Cast("size_t*") @ByRef SizeTPointer cd_nelmts, @Cast("unsigned int*") IntPointer cd_values, @Cast("size_t") long namelen, @Cast("char*") BytePointer name, @Cast("unsigned int*") @ByRef IntPointer filter_config);
	public native @Cast("H5Z_filter_t") int getFilter(int filter_number, @Cast("unsigned int*") @ByRef IntBuffer flags, @Cast("size_t*") @ByRef SizeTPointer cd_nelmts, @Cast("unsigned int*") IntBuffer cd_values, @Cast("size_t") long namelen, @Cast("char*") ByteBuffer name, @Cast("unsigned int*") @ByRef IntBuffer filter_config);
	public native @Cast("H5Z_filter_t") int getFilter(int filter_number, @Cast("unsigned int*") @ByRef int[] flags, @Cast("size_t*") @ByRef SizeTPointer cd_nelmts, @Cast("unsigned int*") int[] cd_values, @Cast("size_t") long namelen, @Cast("char*") byte[] name, @Cast("unsigned int*") @ByRef int[] filter_config);

	// Returns information about a filter in a pipeline given the filter id.
	public native void getFilterById(@Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int*") @ByRef IntPointer flags, @Cast("size_t*") @ByRef SizeTPointer cd_nelmts, @Cast("unsigned int*") IntPointer cd_values, @Cast("size_t") long namelen, @Cast("char*") BytePointer name, @Cast("unsigned int*") @ByRef IntPointer filter_config);
	public native void getFilterById(@Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int*") @ByRef IntBuffer flags, @Cast("size_t*") @ByRef SizeTPointer cd_nelmts, @Cast("unsigned int*") IntBuffer cd_values, @Cast("size_t") long namelen, @Cast("char*") ByteBuffer name, @Cast("unsigned int*") @ByRef IntBuffer filter_config);
	public native void getFilterById(@Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int*") @ByRef int[] flags, @Cast("size_t*") @ByRef SizeTPointer cd_nelmts, @Cast("unsigned int*") int[] cd_values, @Cast("size_t") long namelen, @Cast("char*") byte[] name, @Cast("unsigned int*") @ByRef int[] filter_config);

	// Gets the layout of the raw data storage of the data that uses this
	// property list.
	public native @Cast("H5D_layout_t") int getLayout();

	// Sets the type of storage used to store the raw data for the
	// dataset that uses this property list.
	public native void setLayout(@Cast("H5D_layout_t") int layout);

	// Returns the number of filters in the pipeline.
	public native int getNfilters();

	// Checks if fill value has been defined for this property.
	public native @Cast("H5D_fill_value_t") int isFillValueDefined();

	// Modifies the specified filter.
	public native void modifyFilter( @Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts, @Cast("const unsigned int*") IntPointer cd_values );
	public native void modifyFilter( @Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts, @Cast("const unsigned int*") IntBuffer cd_values );
	public native void modifyFilter( @Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts, @Cast("const unsigned int*") int[] cd_values );

	// Remove one or all filters from the filter pipeline.
	public native void removeFilter( @Cast("H5Z_filter_t") int filter_id);

	// Sets compression method and compression level.
	public native void setDeflate( int level );

	// Adds an external file to the list of external files.
	public native void setExternal( @Cast("const char*") BytePointer name, @Cast("off_t") long offset, @Cast("hsize_t") long size );
	public native void setExternal( String name, @Cast("off_t") long offset, @Cast("hsize_t") long size );

	// Adds a filter to the filter pipeline.
	public native void setFilter( @Cast("H5Z_filter_t") int filter, @Cast("unsigned int") int flags/*=0*/, @Cast("size_t") long cd_nelmts/*=0*/, @Cast("const unsigned int*") IntPointer cd_values/*=NULL*/);
	public native void setFilter( @Cast("H5Z_filter_t") int filter);
	public native void setFilter( @Cast("H5Z_filter_t") int filter, @Cast("unsigned int") int flags/*=0*/, @Cast("size_t") long cd_nelmts/*=0*/, @Cast("const unsigned int*") IntBuffer cd_values/*=NULL*/);
	public native void setFilter( @Cast("H5Z_filter_t") int filter, @Cast("unsigned int") int flags/*=0*/, @Cast("size_t") long cd_nelmts/*=0*/, @Cast("const unsigned int*") int[] cd_values/*=NULL*/);

	// Sets Fletcher32 checksum of EDC for this property list.
	public native void setFletcher32();

	// Sets method of the shuffle filter.
	public native void setShuffle();

	// Sets SZIP compression method.
	public native void setSzip(@Cast("unsigned int") int options_mask, @Cast("unsigned int") int pixels_per_block);

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Copy constructor: creates a copy of a DSetCreatPropList object.
	public DSetCreatPropList(@Const @ByRef DSetCreatPropList orig) { super((Pointer)null); allocate(orig); }
	private native void allocate(@Const @ByRef DSetCreatPropList orig);

	// Creates a copy of an existing dataset creation property list
	// using the property list id.
	public DSetCreatPropList(@Cast("const hid_t") int plist_id) { super((Pointer)null); allocate(plist_id); }
	private native void allocate(@Cast("const hid_t") int plist_id);

	// Noop destructor.

// #ifndef DOXYGEN_SHOULD_SKIP_THIS

        // Deletes the global constant, should only be used by the library
        public static native void deleteConstants();
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5DSCreatPropList_H


// Parsed from H5CommonFG.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __CommonFG_H
// #define __CommonFG_H

// #ifndef H5_NO_NAMESPACE
// #endif

// Class forwarding

/** \class CommonFG
    \brief \a CommonFG is an abstract base class of H5File and H5Group.
    <p>
    It provides common operations of H5File and H5Group.
*/
@Namespace("H5") public static class CommonFG extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CommonFG(Pointer p) { super(p); }

	// Creates a new group at this location which can be a file
	// or another group.
	public native @ByVal Group createGroup(@Cast("const char*") BytePointer name, @Cast("size_t") long size_hint/*=0*/);
	public native @ByVal Group createGroup(@Cast("const char*") BytePointer name);
	public native @ByVal Group createGroup(String name, @Cast("size_t") long size_hint/*=0*/);
	public native @ByVal Group createGroup(String name);

	// Opens an existing group in a location which can be a file
	// or another group.
	public native @ByVal Group openGroup(@Cast("const char*") BytePointer name);
	public native @ByVal Group openGroup(String name);

	// Creates a new dataset at this location.
	public native @ByVal DataSet createDataSet(@Cast("const char*") BytePointer name, @Const @ByRef DataType data_type, @Const @ByRef DataSpace data_space, @Const @ByRef(nullValue = "H5::DSetCreatPropList::DEFAULT") DSetCreatPropList create_plist);
	public native @ByVal DataSet createDataSet(@Cast("const char*") BytePointer name, @Const @ByRef DataType data_type, @Const @ByRef DataSpace data_space);
	public native @ByVal DataSet createDataSet(String name, @Const @ByRef DataType data_type, @Const @ByRef DataSpace data_space, @Const @ByRef(nullValue = "H5::DSetCreatPropList::DEFAULT") DSetCreatPropList create_plist);
	public native @ByVal DataSet createDataSet(String name, @Const @ByRef DataType data_type, @Const @ByRef DataSpace data_space);

	// Opens an existing dataset at this location.
	public native @ByVal DataSet openDataSet(@Cast("const char*") BytePointer name);
	public native @ByVal DataSet openDataSet(String name);

	// Returns the value of a symbolic link.
	public native @StdString BytePointer getLinkval(@Cast("const char*") BytePointer link_name, @Cast("size_t") long size/*=0*/);
	public native @StdString BytePointer getLinkval(@Cast("const char*") BytePointer link_name);
	public native @StdString String getLinkval(String link_name, @Cast("size_t") long size/*=0*/);
	public native @StdString String getLinkval(String link_name);

	// Returns the number of objects in this group.
	public native @Cast("hsize_t") long getNumObjs();

	// Retrieves the name of an object in this group, given the
	// object's index.
	public native @StdString BytePointer getObjnameByIdx(@Cast("hsize_t") long idx);
	public native @Cast("ssize_t") int getObjnameByIdx(@Cast("hsize_t") long idx, @Cast("char*") BytePointer name, @Cast("size_t") long size);
	public native @Cast("ssize_t") int getObjnameByIdx(@Cast("hsize_t") long idx, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
	public native @Cast("ssize_t") int getObjnameByIdx(@Cast("hsize_t") long idx, @Cast("char*") byte[] name, @Cast("size_t") long size);
	public native @Cast("ssize_t") int getObjnameByIdx(@Cast("hsize_t") long idx, @StdString String name, @Cast("size_t") long size);

	// Retrieves the type of an object in this file or group, given the
	// object's name
	public native @Cast("H5O_type_t") int childObjType(@StdString BytePointer objname);
	public native @Cast("H5O_type_t") int childObjType(@StdString String objname);
	public native @Cast("H5O_type_t") int childObjType(@Cast("hsize_t") long index, @Cast("H5_index_t") int index_type/*=H5_INDEX_NAME*/, @Cast("H5_iter_order_t") int order/*=H5_ITER_INC*/, @Cast("const char*") BytePointer objname/*="."*/);
	public native @Cast("H5O_type_t") int childObjType(@Cast("hsize_t") long index);
	public native @Cast("H5O_type_t") int childObjType(@Cast("hsize_t") long index, @Cast("H5_index_t") int index_type/*=H5_INDEX_NAME*/, @Cast("H5_iter_order_t") int order/*=H5_ITER_INC*/, String objname/*="."*/);

	// Returns the object header version of an object in this file or group,
	// given the object's name.
	public native @Cast("unsigned") int childObjVersion(@Cast("const char*") BytePointer objname);
	public native @Cast("unsigned") int childObjVersion(String objname);

// #ifndef H5_NO_DEPRECATED_SYMBOLS
// #endif /* H5_NO_DEPRECATED_SYMBOLS */

	// Creates a link of the specified type from new_name to current_name;
	// both names are interpreted relative to the specified location id.
	public native void link(@Cast("H5L_type_t") int link_type, @Cast("const char*") BytePointer curr_name, @Cast("const char*") BytePointer new_name);
	public native void link(@Cast("H5L_type_t") int link_type, String curr_name, String new_name);

	// Removes the specified name at this location.
	public native void unlink(@Cast("const char*") BytePointer name);
	public native void unlink(String name);

	// Mounts the file 'child' onto this location.
	public native void mount(@Cast("const char*") BytePointer name, @Const @ByRef H5File child, @Const @ByRef PropList plist);
	public native void mount(String name, @Const @ByRef H5File child, @Const @ByRef PropList plist); // backward compatibility // backward compatibility

	// Unmounts the file named 'name' from this parent location.
	public native void unmount(@Cast("const char*") BytePointer name);
	public native void unmount(String name);

	// Renames an object at this location.
	public native void move(@Cast("const char*") BytePointer src, @Cast("const char*") BytePointer dst);
	public native void move(String src, String dst);

	// Opens a generic named datatype in this location.
	public native @ByVal DataType openDataType(@Cast("const char*") BytePointer name);
	public native @ByVal DataType openDataType(String name);

	// Opens a named array datatype in this location.
	public native @ByVal ArrayType openArrayType(@Cast("const char*") BytePointer name);
	public native @ByVal ArrayType openArrayType(String name);

	// Opens a named compound datatype in this location.
	public native @ByVal CompType openCompType(@Cast("const char*") BytePointer name);
	public native @ByVal CompType openCompType(String name);

	// Opens a named enumeration datatype in this location.
	public native @ByVal EnumType openEnumType(@Cast("const char*") BytePointer name);
	public native @ByVal EnumType openEnumType(String name);

	// Opens a named integer datatype in this location.
	public native @ByVal IntType openIntType(@Cast("const char*") BytePointer name);
	public native @ByVal IntType openIntType(String name);

	// Opens a named floating-point datatype in this location.
	public native @ByVal FloatType openFloatType(@Cast("const char*") BytePointer name);
	public native @ByVal FloatType openFloatType(String name);

	// Opens a named string datatype in this location.
	public native @ByVal StrType openStrType(@Cast("const char*") BytePointer name);
	public native @ByVal StrType openStrType(String name);

	// Opens a named variable length datatype in this location.
	public native @ByVal VarLenType openVarLenType(@Cast("const char*") BytePointer name);
	public native @ByVal VarLenType openVarLenType(String name);

// #ifndef DOXYGEN_SHOULD_SKIP_THIS
	/** For subclasses, H5File and Group, to return the correct
	 *  object id, i.e. file or group id. */
	public native @Cast("hid_t") int getLocId();


	/** For subclasses, H5File and Group, to throw appropriate exception. */
	public native void throwException(@StdString BytePointer func_name, @StdString BytePointer msg);
	public native void throwException(@StdString String func_name, @StdString String msg);

	// Default constructor.

	// Noop destructor.

} // end of CommonFG declaration

// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __CommonFG_H



// Parsed from H5DataType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// Class DataType inherits from H5Object and has several subclasses for
// specific HDF5 data types.

// #ifndef __H5DataType_H
// #define __H5DataType_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** \class DataType
    \brief Class DataType provides generic operations on HDF5 datatypes.
    <p>
    DataType inherits from H5Object because a named datatype is an HDF5
    object and is a base class of ArrayType, AtomType, CompType, EnumType,
    and VarLenType.
*/
@Namespace("H5") @NoOffset public static class DataType extends H5Object {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DataType(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DataType(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DataType position(long position) {
        return (DataType)super.position(position);
    }

	// Creates a datatype given its class and size
	public DataType( @Cast("const H5T_class_t") int type_class, @Cast("size_t") long size ) { super((Pointer)null); allocate(type_class, size); }
	private native void allocate( @Cast("const H5T_class_t") int type_class, @Cast("size_t") long size );

	// Copy constructor: makes a copy of the original object
	public DataType( @Const @ByRef DataType original ) { super((Pointer)null); allocate(original); }
	private native void allocate( @Const @ByRef DataType original );

	// Creates a copy of a predefined type
	public DataType(@Const @ByRef PredType pred_type) { super((Pointer)null); allocate(pred_type); }
	private native void allocate(@Const @ByRef PredType pred_type);

	// Creates a datatype by way of dereference.
	public DataType(@Const @ByRef H5Location loc, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist) { super((Pointer)null); allocate(loc, ref, ref_type, plist); }
	private native void allocate(@Const @ByRef H5Location loc, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist);
	public DataType(@Const @ByRef H5Location loc, @Const Pointer ref) { super((Pointer)null); allocate(loc, ref); }
	private native void allocate(@Const @ByRef H5Location loc, @Const Pointer ref);
	public DataType(@Const @ByRef Attribute attr, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist) { super((Pointer)null); allocate(attr, ref, ref_type, plist); }
	private native void allocate(@Const @ByRef Attribute attr, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist);
	public DataType(@Const @ByRef Attribute attr, @Const Pointer ref) { super((Pointer)null); allocate(attr, ref); }
	private native void allocate(@Const @ByRef Attribute attr, @Const Pointer ref);

	// Closes this datatype.
	public native @Name("close") void _close();

	// Copies an existing datatype to this datatype object.
	public native void copy(@Const @ByRef DataType like_type);

	// Copies the datatype of dset to this datatype object.
	public native void copy(@Const @ByRef DataSet dset);

	// Returns the datatype class identifier.
	public native @Cast("H5T_class_t") @Name("getClass") int _getClass();

	// Commits a transient datatype to a file; this datatype becomes
	// a named datatype which can be accessed from the location.
	public native void commit(@Const @ByRef H5Location loc, @Cast("const char*") BytePointer name);
	public native void commit(@Const @ByRef H5Location loc, String name);
	// These two overloaded functions are kept for backward compatibility
	// only; they missed the const.

	// Determines whether this datatype is a named datatype or
	// a transient datatype.
	public native @Cast("bool") boolean committed();

        // Finds a conversion function that can handle the conversion
        // this datatype to the given datatype, dest.
	public native H5T_conv_t find( @Const @ByRef DataType dest, @Cast("H5T_cdata_t**") PointerPointer pcdata );
	public native H5T_conv_t find( @Const @ByRef DataType dest, @ByPtrPtr H5T_cdata_t pcdata );

	// Converts data from between specified datatypes.
	public native void convert( @Const @ByRef DataType dest, @Cast("size_t") long nelmts, Pointer buf, Pointer background, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist);
	public native void convert( @Const @ByRef DataType dest, @Cast("size_t") long nelmts, Pointer buf, Pointer background);

	// Assignment operator
	public native @ByRef @Name("operator =") DataType put( @Const @ByRef DataType rhs );

	// Determines whether two datatypes are the same.
	public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef DataType compared_type );

	// Locks a datatype.
	public native void lock();

	// Returns the size of a datatype.
	public native @Cast("size_t") long getSize();

	// Returns the base datatype from which a datatype is derived.
	// Note: not quite right for specific types yet???
	public native @ByVal DataType getSuper();

	// Registers a conversion function.
	public native void registerFunc(@Cast("H5T_pers_t") int pers, @Cast("const char*") BytePointer name, @Const @ByRef DataType dest, H5T_conv_t func );
	public native void registerFunc(@Cast("H5T_pers_t") int pers, String name, @Const @ByRef DataType dest, H5T_conv_t func );

	// Removes a conversion function from all conversion paths.
	public native void unregister( @Cast("H5T_pers_t") int pers, @Cast("const char*") BytePointer name, @Const @ByRef DataType dest, H5T_conv_t func );
	public native void unregister( @Cast("H5T_pers_t") int pers, String name, @Const @ByRef DataType dest, H5T_conv_t func );

	// Tags an opaque datatype.
	public native void setTag( @Cast("const char*") BytePointer tag );
	public native void setTag( String tag );

	// Gets the tag associated with an opaque datatype.
	public native @StdString BytePointer getTag();

	// Checks whether this datatype contains (or is) a certain type class.
	public native @Cast("bool") boolean detectClass(@Cast("H5T_class_t") int cls);

	// Checks whether this datatype is a variable-length string.
	public native @Cast("bool") boolean isVariableStr();

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Creates a copy of an existing DataType using its id
	public DataType( @Cast("const hid_t") int type_id ) { super((Pointer)null); allocate(type_id); }
	private native void allocate( @Cast("const hid_t") int type_id );

	// Default constructor
	public DataType() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Gets the datatype id.
	public native @Cast("hid_t") int getId();

	// Destructor: properly terminates access to this datatype.
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5DataType_H


// Parsed from H5DxferProp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// Class DSetMemXferPropList represents the HDF5 dataset transfer property list
// and inherits from PropList.

// #ifndef __H5DSetMemXferPropList_H
// #define __H5DSetMemXferPropList_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** \class DSetMemXferPropList
    \brief Class DSetMemXferPropList represents the dataset memory and
    transfer property list.
*/
@Namespace("H5") @NoOffset public static class DSetMemXferPropList extends PropList {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DSetMemXferPropList(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DSetMemXferPropList(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DSetMemXferPropList position(long position) {
        return (DSetMemXferPropList)super.position(position);
    }

	/**\brief Default dataset memory and transfer property list. */
	@MemberGetter public static native @Const @ByRef DSetMemXferPropList DEFAULT();

	// Creates a dataset memory and transfer property list.
	public DSetMemXferPropList() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Creates a dataset transform property list.
	public DSetMemXferPropList(@Cast("const char*") BytePointer expression) { super((Pointer)null); allocate(expression); }
	private native void allocate(@Cast("const char*") BytePointer expression);
	public DSetMemXferPropList(String expression) { super((Pointer)null); allocate(expression); }
	private native void allocate(String expression);

	// Sets type conversion and background buffers.
	public native void setBuffer( @Cast("size_t") long size, Pointer tconv, Pointer bkg );

	// Reads buffer settings.
	public native @Cast("size_t") long getBuffer( @Cast("void**") PointerPointer tconv, @Cast("void**") PointerPointer bkg );
	public native @Cast("size_t") long getBuffer( @Cast("void**") @ByPtrPtr Pointer tconv, @Cast("void**") @ByPtrPtr Pointer bkg );

	// Sets B-tree split ratios for a dataset transfer property list.
	public native void setBtreeRatios( double left, double middle, double right );

	// Gets B-tree split ratios for a dataset transfer property list.
	public native void getBtreeRatios( @ByRef DoublePointer left, @ByRef DoublePointer middle, @ByRef DoublePointer right );
	public native void getBtreeRatios( @ByRef DoubleBuffer left, @ByRef DoubleBuffer middle, @ByRef DoubleBuffer right );
	public native void getBtreeRatios( @ByRef double[] left, @ByRef double[] middle, @ByRef double[] right );

	// Sets data transform expression.
	public native void setDataTransform(@Cast("const char*") BytePointer expression);
	public native void setDataTransform(String expression);

	// Gets data transform expression.
	public native @Cast("ssize_t") int getDataTransform(@Cast("char*") BytePointer exp, @Cast("size_t") long buf_size/*=0*/);
	public native @Cast("ssize_t") int getDataTransform(@Cast("char*") BytePointer exp);
	public native @Cast("ssize_t") int getDataTransform(@Cast("char*") ByteBuffer exp, @Cast("size_t") long buf_size/*=0*/);
	public native @Cast("ssize_t") int getDataTransform(@Cast("char*") ByteBuffer exp);
	public native @Cast("ssize_t") int getDataTransform(@Cast("char*") byte[] exp, @Cast("size_t") long buf_size/*=0*/);
	public native @Cast("ssize_t") int getDataTransform(@Cast("char*") byte[] exp);
	public native @StdString BytePointer getDataTransform();

	// Sets the dataset transfer property list status to TRUE or FALSE.
	public native void setPreserve( @Cast("bool") boolean status );

	// Checks status of the dataset transfer property list.
	public native @Cast("bool") boolean getPreserve();

	// Sets an exception handling callback for datatype conversion.
	public native void setTypeConvCB( H5T_conv_except_func_t op, Pointer user_data);

	// Gets the exception handling callback for datatype conversion.
	public native void getTypeConvCB( @ByPtrPtr H5T_conv_except_func_t op, @Cast("void**") PointerPointer user_data);
	public native void getTypeConvCB( @ByPtrPtr H5T_conv_except_func_t op, @Cast("void**") @ByPtrPtr Pointer user_data);

	// Sets the memory manager for variable-length datatype
	// allocation in H5Dread and H5Dvlen_reclaim.
	public native void setVlenMemManager( H5MM_allocate_t alloc, Pointer alloc_info,
					H5MM_free_t free, Pointer free_info );

	// alloc and free are set to NULL, indicating that system
	// malloc and free are to be used.
	public native void setVlenMemManager();

	// Gets the memory manager for variable-length datatype
	// allocation in H5Dread and H5Tvlen_reclaim.
	public native void getVlenMemManager( @ByPtrRef H5MM_allocate_t alloc, @Cast("void**") PointerPointer alloc_info,
					@ByPtrRef H5MM_free_t free, @Cast("void**") PointerPointer free_info );
	public native void getVlenMemManager( @ByPtrRef H5MM_allocate_t alloc, @Cast("void**") @ByPtrPtr Pointer alloc_info,
					@ByPtrRef H5MM_free_t free, @Cast("void**") @ByPtrPtr Pointer free_info );

	// Sets the size of a contiguous block reserved for small data.
	public native void setSmallDataBlockSize(@Cast("hsize_t") long size);

	// Returns the current small data block size setting.
	public native @Cast("hsize_t") long getSmallDataBlockSize();

	// Sets number of I/O vectors to be read/written in hyperslab I/O.
	public native void setHyperVectorSize(@Cast("size_t") long vector_size);

	// Returns the number of I/O vectors to be read/written in
	// hyperslab I/O.
	public native @Cast("size_t") long getHyperVectorSize();

	// Enables or disables error-detecting for a dataset reading
	// process.
	public native void setEDCCheck(@Cast("H5Z_EDC_t") int check);

	// Determines whether error-detection is enabled for dataset reads.
	public native @Cast("H5Z_EDC_t") int getEDCCheck();

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Copy constructor: makes a copy of a DSetMemXferPropList object.
	public DSetMemXferPropList(@Const @ByRef DSetMemXferPropList orig) { super((Pointer)null); allocate(orig); }
	private native void allocate(@Const @ByRef DSetMemXferPropList orig);

	// Creates a copy of an existing dataset memory and transfer
	// property list using the property list id.
	public DSetMemXferPropList(@Cast("const hid_t") int plist_id) { super((Pointer)null); allocate(plist_id); }
	private native void allocate(@Cast("const hid_t") int plist_id);

	// Noop destructor

// #ifndef DOXYGEN_SHOULD_SKIP_THIS

        // Deletes the global constant, should only be used by the library
        public static native void deleteConstants();
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5DSetMemXferPropList_H


// Parsed from H5FaccProp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// Class FileAccPropList represents the HDF5 file access property list and
// inherits from DataType.

// #ifndef __H5FileAccPropList_H
// #define __H5FileAccPropList_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** Class FileAccPropList represents the HDF5 file access property list. */
@Namespace("H5") @NoOffset public static class FileAccPropList extends PropList {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileAccPropList(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public FileAccPropList(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public FileAccPropList position(long position) {
        return (FileAccPropList)super.position(position);
    }

	/**\brief Default file access property list. */
	@MemberGetter public static native @Const @ByRef FileAccPropList DEFAULT();

	// Creates a file access property list.
	public FileAccPropList() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Modifies this property list to use the H5FD_STDIO driver
	public native void setStdio();

	// Set file driver for this property list
	public native void setDriver(@Cast("hid_t") int new_driver_id, @Const Pointer new_driver_info);

	// Returns a low-level file driver identifier.
	public native @Cast("hid_t") int getDriver();

	// Sets offset for family driver.
	public native void setFamilyOffset(@Cast("hsize_t") long offset);

	// Gets offset for family driver.
	public native @Cast("hsize_t") long getFamilyOffset();

	// Modifies this file access property list to use the sec2 driver.
	public native void setSec2();

	// Modifies this file access property list to use the H5FD_CORE
	// driver.
	public native void setCore(@Cast("size_t") long increment, @Cast("hbool_t") boolean backing_store);

	// Queries H5FD_CORE driver properties.
	public native void getCore(@Cast("size_t*") @ByRef SizeTPointer increment, @Cast("hbool_t*") @ByRef BoolPointer backing_store);
	public native void getCore(@Cast("size_t*") @ByRef SizeTPointer increment, @Cast("hbool_t*") @ByRef boolean[] backing_store);

	// Sets this file access properties list to the family driver.
	public native void setFamily( @Cast("hsize_t") long memb_size, @Const @ByRef FileAccPropList memb_plist );

	// Returns information about the family file access property list.
	public native void getFamily(@Cast("hsize_t*") @ByRef LongPointer memb_size, @ByRef FileAccPropList memb_plist);
	public native void getFamily(@Cast("hsize_t*") @ByRef LongBuffer memb_size, @ByRef FileAccPropList memb_plist);
	public native void getFamily(@Cast("hsize_t*") @ByRef long[] memb_size, @ByRef FileAccPropList memb_plist);
	public native @ByVal FileAccPropList getFamily(@Cast("hsize_t*") @ByRef LongPointer memb_size);
	public native @ByVal FileAccPropList getFamily(@Cast("hsize_t*") @ByRef LongBuffer memb_size);
	public native @ByVal FileAccPropList getFamily(@Cast("hsize_t*") @ByRef long[] memb_size);

	// Emulates the old split file driver,
	public native void setSplit(@Const @ByRef FileAccPropList meta_plist,
	              @Const @ByRef FileAccPropList raw_plist,
	              @Cast("const char*") BytePointer meta_ext/*=".meta"*/,
	              @Cast("const char*") BytePointer raw_ext/*=".raw"*/ );
	public native void setSplit(@Const @ByRef FileAccPropList meta_plist,
	              @Const @ByRef FileAccPropList raw_plist,
	              String meta_ext/*=".meta"*/,
	              String raw_ext/*=".raw"*/ );
	
	// These two overloaded functions are kept for backward compatibility
	// only; they missed the const's and will be removed in future release.
	
	

	// Sets the maximum size of the data sieve buffer.
	public native void setSieveBufSize(@Cast("size_t") long bufsize);

	// Returns the current settings for the data sieve buffer size
	// property
	public native @Cast("size_t") long getSieveBufSize();

	// Sets the minimum size of metadata block allocations.
	public native void setMetaBlockSize(@Cast("hsize_t*") @ByRef LongPointer block_size);
	public native void setMetaBlockSize(@Cast("hsize_t*") @ByRef LongBuffer block_size);
	public native void setMetaBlockSize(@Cast("hsize_t*") @ByRef long[] block_size);

	// Returns the current metadata block size setting.
	public native @Cast("hsize_t") long getMetaBlockSize();

	// Modifies this file access property list to use the logging driver.
	public native void setLog(@Cast("const char*") BytePointer logfile, @Cast("unsigned") int flags, @Cast("size_t") long buf_size);
	public native void setLog(String logfile, @Cast("unsigned") int flags, @Cast("size_t") long buf_size);

	// Sets alignment properties of this file access property list
	public native void setAlignment( @Cast("hsize_t") long threshold/*=1*/, @Cast("hsize_t") long alignment/*=1*/ );
	public native void setAlignment( );

	// Retrieves the current settings for alignment properties from
	// this property list.
	public native void getAlignment( @Cast("hsize_t*") @ByRef LongPointer threshold, @Cast("hsize_t*") @ByRef LongPointer alignment );
	public native void getAlignment( @Cast("hsize_t*") @ByRef LongBuffer threshold, @Cast("hsize_t*") @ByRef LongBuffer alignment );
	public native void getAlignment( @Cast("hsize_t*") @ByRef long[] threshold, @Cast("hsize_t*") @ByRef long[] alignment );

	// Sets data type for multi driver.
	public native void setMultiType(@Cast("H5FD_mem_t") int dtype);

	// Returns the data type property for MULTI driver.
	public native @Cast("H5FD_mem_t") int getMultiType();

	// Sets the meta data cache and raw data chunk cache parameters.
	public native void setCache( int mdc_nelmts, @Cast("size_t") long rdcc_nelmts, @Cast("size_t") long rdcc_nbytes, double rdcc_w0 );

	// Queries the meta data cache and raw data chunk cache parameters.
	public native void getCache( @ByRef IntPointer mdc_nelmts, @Cast("size_t*") @ByRef SizeTPointer rdcc_nelmts, @Cast("size_t*") @ByRef SizeTPointer rdcc_nbytes, @ByRef DoublePointer rdcc_w0 );
	public native void getCache( @ByRef IntBuffer mdc_nelmts, @Cast("size_t*") @ByRef SizeTPointer rdcc_nelmts, @Cast("size_t*") @ByRef SizeTPointer rdcc_nbytes, @ByRef DoubleBuffer rdcc_w0 );
	public native void getCache( @ByRef int[] mdc_nelmts, @Cast("size_t*") @ByRef SizeTPointer rdcc_nelmts, @Cast("size_t*") @ByRef SizeTPointer rdcc_nbytes, @ByRef double[] rdcc_w0 );

	// Sets the degree for the file close behavior.
	public native void setFcloseDegree(@Cast("H5F_close_degree_t") int degree);

	// Returns the degree for the file close behavior.
	public native @Cast("H5F_close_degree_t") int getFcloseDegree();

	// Sets garbage collecting references flag.
	public native void setGcReferences( @Cast("unsigned") int gc_ref/*=0*/ );
	public native void setGcReferences( );

	// Returns garbage collecting references setting.
	public native @Cast("unsigned") int getGcReferences();

	// Sets bounds on versions of library format to be used when creating
	// or writing objects.
	public native void setLibverBounds(@Cast("H5F_libver_t") int libver_low, @Cast("H5F_libver_t") int libver_high);

	// Gets the current settings for the library version format bounds.
	public native void getLibverBounds(@Cast("H5F_libver_t*") @ByRef IntPointer libver_low, @Cast("H5F_libver_t*") @ByRef IntPointer libver_high);
	public native void getLibverBounds(@Cast("H5F_libver_t*") @ByRef IntBuffer libver_low, @Cast("H5F_libver_t*") @ByRef IntBuffer libver_high);
	public native void getLibverBounds(@Cast("H5F_libver_t*") @ByRef int[] libver_low, @Cast("H5F_libver_t*") @ByRef int[] libver_high);

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Copy constructor: creates a copy of a FileAccPropList object.
	public FileAccPropList( @Const @ByRef FileAccPropList original ) { super((Pointer)null); allocate(original); }
	private native void allocate( @Const @ByRef FileAccPropList original );

	// Creates a copy of an existing file access property list
	// using the property list id.
	public FileAccPropList(@Cast("const hid_t") int plist_id) { super((Pointer)null); allocate(plist_id); }
	private native void allocate(@Cast("const hid_t") int plist_id);

	// Noop destructor

// #ifndef DOXYGEN_SHOULD_SKIP_THIS

        // Deletes the global constant, should only be used by the library
        public static native void deleteConstants();

}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5FileAccPropList_H


// Parsed from H5FcreatProp.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5FileCreatPropList_H
// #define __H5FileCreatPropList_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** Class FileCreatPropList represents the HDF5 file create property list. */
@Namespace("H5") @NoOffset public static class FileCreatPropList extends PropList {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileCreatPropList(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public FileCreatPropList(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public FileCreatPropList position(long position) {
        return (FileCreatPropList)super.position(position);
    }

	/**\brief Default file creation property list. */
	@MemberGetter public static native @Const @ByRef FileCreatPropList DEFAULT();

	// Creates a file create property list.
	public FileCreatPropList() { super((Pointer)null); allocate(); }
	private native void allocate();

// #ifndef H5_NO_DEPRECATED_SYMBOLS
// #endif /* H5_NO_DEPRECATED_SYMBOLS */

	// Sets the userblock size field of a file creation property list.
	public native void setUserblock( @Cast("hsize_t") long size );

	// Gets the size of a user block in this file creation property list.
	public native @Cast("hsize_t") long getUserblock();

	// Retrieves the size-of address and size quantities stored in a
	// file according to this file creation property list.
	public native void getSizes( @Cast("size_t*") @ByRef SizeTPointer sizeof_addr, @Cast("size_t*") @ByRef SizeTPointer sizeof_size );

	// Sets file size-of addresses and sizes.
	public native void setSizes( @Cast("size_t") long sizeof_addr/*=4*/, @Cast("size_t") long sizeof_size/*=4*/ );
	public native void setSizes( );

	// Retrieves the size of the symbol table B-tree 1/2 rank and the
	// symbol table leaf node 1/2 size.
	public native void getSymk( @Cast("unsigned*") @ByRef IntPointer int_nodes_k, @Cast("unsigned*") @ByRef IntPointer leaf_nodes_k );
	public native void getSymk( @Cast("unsigned*") @ByRef IntBuffer int_nodes_k, @Cast("unsigned*") @ByRef IntBuffer leaf_nodes_k );
	public native void getSymk( @Cast("unsigned*") @ByRef int[] int_nodes_k, @Cast("unsigned*") @ByRef int[] leaf_nodes_k );

	// Sets the size of parameters used to control the symbol table nodes.
	public native void setSymk( @Cast("unsigned") int int_nodes_k, @Cast("unsigned") int leaf_nodes_k );

	// Returns the 1/2 rank of an indexed storage B-tree.
	public native @Cast("unsigned") int getIstorek();

	// Sets the size of parameter used to control the B-trees for
	// indexing chunked datasets.
	public native void setIstorek( @Cast("unsigned") int ik );

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Copy constructor: creates a copy of a FileCreatPropList object.
	public FileCreatPropList(@Const @ByRef FileCreatPropList orig) { super((Pointer)null); allocate(orig); }
	private native void allocate(@Const @ByRef FileCreatPropList orig);

	// Creates a copy of an existing file create property list
	// using the property list id.
	public FileCreatPropList(@Cast("const hid_t") int plist_id) { super((Pointer)null); allocate(plist_id); }
	private native void allocate(@Cast("const hid_t") int plist_id);

	// Noop destructor

// #ifndef DOXYGEN_SHOULD_SKIP_THIS

	// Deletes the global constant, should only be used by the library
	public static native void deleteConstants();

}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5FileCreatPropList_H


// Parsed from H5AtomType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5AtomType_H
// #define __H5AtomType_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** \class AtomType
    \brief AtomType is a base class, inherited by IntType, FloatType,
     StrType, and PredType.
    <p>
    AtomType provides operations on HDF5 atomic datatypes.  It also inherits
    from DataType.
*/
@Namespace("H5") public static class AtomType extends DataType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AtomType(Pointer p) { super(p); }

	// Returns the byte order of an atomic datatype.
	public native @Cast("H5T_order_t") int getOrder();
	public native @Cast("H5T_order_t") int getOrder( @StdString BytePointer order_string );
	public native @Cast("H5T_order_t") int getOrder( @StdString String order_string );

	// Sets the byte ordering of an atomic datatype.
	public native void setOrder( @Cast("H5T_order_t") int order );

	// Retrieves the bit offset of the first significant bit.
	// 12/05/00 - changed return type to int from size_t - C API
	public native int getOffset();

	// Sets the bit offset of the first significant bit.
	public native void setOffset( @Cast("size_t") long offset );

	// Retrieves the padding type of the least and most-significant bit padding.
	public native void getPad( @Cast("H5T_pad_t*") @ByRef IntPointer lsb, @Cast("H5T_pad_t*") @ByRef IntPointer msb );
	public native void getPad( @Cast("H5T_pad_t*") @ByRef IntBuffer lsb, @Cast("H5T_pad_t*") @ByRef IntBuffer msb );
	public native void getPad( @Cast("H5T_pad_t*") @ByRef int[] lsb, @Cast("H5T_pad_t*") @ByRef int[] msb );

	// Sets the least and most-significant bits padding types
	public native void setPad( @Cast("H5T_pad_t") int lsb, @Cast("H5T_pad_t") int msb );

	// Returns the precision of an atomic datatype.
	public native @Cast("size_t") long getPrecision();

	// Sets the precision of an atomic datatype.
	public native void setPrecision( @Cast("size_t") long precision );

	// Sets the total size for an atomic datatype.
	public native void setSize( @Cast("size_t") long size );

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

// #ifndef DOXYGEN_SHOULD_SKIP_THIS
	// Copy constructor - makes copy of the original object
	public AtomType( @Const @ByRef AtomType original ) { super((Pointer)null); allocate(original); }
	private native void allocate( @Const @ByRef AtomType original );

	// Noop destructor
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5AtomType_H


// Parsed from H5PredType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5PredType_H
// #define __H5PredType_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** \class PredType
    \brief Class PredType holds the definition of all the HDF5 predefined
    datatypes.
    <p>
    These types can only be made copy of, not created by H5Tcreate or
    closed by H5Tclose.  They are treated as constants.
*/
@Namespace("H5") @NoOffset public static class PredType extends AtomType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PredType(Pointer p) { super(p); }

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Makes a copy of the predefined type and stores the new
	// id in the left hand side object.
	public native @ByRef @Name("operator =") PredType put( @Const @ByRef PredType rhs );

	// Copy constructor - makes copy of the original object
	public PredType( @Const @ByRef PredType original ) { super((Pointer)null); allocate(original); }
	private native void allocate( @Const @ByRef PredType original );

	// Noop destructor

	/** \brief This dummy function do not inherit from DataType - it will
	    throw a DataTypeIException if invoked.
	*/
	public native void commit(@ByRef H5Location loc, @StdString BytePointer name );
	public native void commit(@ByRef H5Location loc, @StdString String name );
	/** \brief This dummy function do not inherit from DataType - it will
	    throw a DataTypeIException if invoked.
	*/
	/** \brief This dummy function do not inherit from DataType - it will
	    throw a DataTypeIException if invoked.
	*/
	public native @Cast("bool") boolean committed();

	/**\brief PredType constants */
	@MemberGetter public static native @Const @ByRef PredType STD_I8BE();
	@MemberGetter public static native @Const @ByRef PredType STD_I8LE();
	@MemberGetter public static native @Const @ByRef PredType STD_I16BE();
	@MemberGetter public static native @Const @ByRef PredType STD_I16LE();
	@MemberGetter public static native @Const @ByRef PredType STD_I32BE();
	@MemberGetter public static native @Const @ByRef PredType STD_I32LE();
	@MemberGetter public static native @Const @ByRef PredType STD_I64BE();
	@MemberGetter public static native @Const @ByRef PredType STD_I64LE();
	@MemberGetter public static native @Const @ByRef PredType STD_U8BE();
	@MemberGetter public static native @Const @ByRef PredType STD_U8LE();
	@MemberGetter public static native @Const @ByRef PredType STD_U16BE();
	@MemberGetter public static native @Const @ByRef PredType STD_U16LE();
	@MemberGetter public static native @Const @ByRef PredType STD_U32BE();
	@MemberGetter public static native @Const @ByRef PredType STD_U32LE();
	@MemberGetter public static native @Const @ByRef PredType STD_U64BE();
	@MemberGetter public static native @Const @ByRef PredType STD_U64LE();
	@MemberGetter public static native @Const @ByRef PredType STD_B8BE();
	@MemberGetter public static native @Const @ByRef PredType STD_B8LE();
	@MemberGetter public static native @Const @ByRef PredType STD_B16BE();
	@MemberGetter public static native @Const @ByRef PredType STD_B16LE();
	@MemberGetter public static native @Const @ByRef PredType STD_B32BE();
	@MemberGetter public static native @Const @ByRef PredType STD_B32LE();
	@MemberGetter public static native @Const @ByRef PredType STD_B64BE();
	@MemberGetter public static native @Const @ByRef PredType STD_B64LE();
	@MemberGetter public static native @Const @ByRef PredType STD_REF_OBJ();
	@MemberGetter public static native @Const @ByRef PredType STD_REF_DSETREG();

	@MemberGetter public static native @Const @ByRef PredType C_S1();
	@MemberGetter public static native @Const @ByRef PredType FORTRAN_S1();

	@MemberGetter public static native @Const @ByRef PredType IEEE_F32BE();
	@MemberGetter public static native @Const @ByRef PredType IEEE_F32LE();
	@MemberGetter public static native @Const @ByRef PredType IEEE_F64BE();
	@MemberGetter public static native @Const @ByRef PredType IEEE_F64LE();

	@MemberGetter public static native @Const @ByRef PredType UNIX_D32BE();
	@MemberGetter public static native @Const @ByRef PredType UNIX_D32LE();
	@MemberGetter public static native @Const @ByRef PredType UNIX_D64BE();
	@MemberGetter public static native @Const @ByRef PredType UNIX_D64LE();

	@MemberGetter public static native @Const @ByRef PredType INTEL_I8();
	@MemberGetter public static native @Const @ByRef PredType INTEL_I16();
	@MemberGetter public static native @Const @ByRef PredType INTEL_I32();
	@MemberGetter public static native @Const @ByRef PredType INTEL_I64();
	@MemberGetter public static native @Const @ByRef PredType INTEL_U8();
	@MemberGetter public static native @Const @ByRef PredType INTEL_U16();
	@MemberGetter public static native @Const @ByRef PredType INTEL_U32();
	@MemberGetter public static native @Const @ByRef PredType INTEL_U64();
	@MemberGetter public static native @Const @ByRef PredType INTEL_B8();
	@MemberGetter public static native @Const @ByRef PredType INTEL_B16();
	@MemberGetter public static native @Const @ByRef PredType INTEL_B32();
	@MemberGetter public static native @Const @ByRef PredType INTEL_B64();
	@MemberGetter public static native @Const @ByRef PredType INTEL_F32();
	@MemberGetter public static native @Const @ByRef PredType INTEL_F64();

	@MemberGetter public static native @Const @ByRef PredType ALPHA_I8();
	@MemberGetter public static native @Const @ByRef PredType ALPHA_I16();
	@MemberGetter public static native @Const @ByRef PredType ALPHA_I32();
	@MemberGetter public static native @Const @ByRef PredType ALPHA_I64();
	@MemberGetter public static native @Const @ByRef PredType ALPHA_U8();
	@MemberGetter public static native @Const @ByRef PredType ALPHA_U16();
	@MemberGetter public static native @Const @ByRef PredType ALPHA_U32();
	@MemberGetter public static native @Const @ByRef PredType ALPHA_U64();
	@MemberGetter public static native @Const @ByRef PredType ALPHA_B8();
	@MemberGetter public static native @Const @ByRef PredType ALPHA_B16();
	@MemberGetter public static native @Const @ByRef PredType ALPHA_B32();
	@MemberGetter public static native @Const @ByRef PredType ALPHA_B64();
	@MemberGetter public static native @Const @ByRef PredType ALPHA_F32();
	@MemberGetter public static native @Const @ByRef PredType ALPHA_F64();

	@MemberGetter public static native @Const @ByRef PredType MIPS_I8();
	@MemberGetter public static native @Const @ByRef PredType MIPS_I16();
	@MemberGetter public static native @Const @ByRef PredType MIPS_I32();
	@MemberGetter public static native @Const @ByRef PredType MIPS_I64();
	@MemberGetter public static native @Const @ByRef PredType MIPS_U8();
	@MemberGetter public static native @Const @ByRef PredType MIPS_U16();
	@MemberGetter public static native @Const @ByRef PredType MIPS_U32();
	@MemberGetter public static native @Const @ByRef PredType MIPS_U64();
	@MemberGetter public static native @Const @ByRef PredType MIPS_B8();
	@MemberGetter public static native @Const @ByRef PredType MIPS_B16();
	@MemberGetter public static native @Const @ByRef PredType MIPS_B32();
	@MemberGetter public static native @Const @ByRef PredType MIPS_B64();
	@MemberGetter public static native @Const @ByRef PredType MIPS_F32();
	@MemberGetter public static native @Const @ByRef PredType MIPS_F64();

	@MemberGetter public static native @Const @ByRef PredType NATIVE_CHAR();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_SCHAR();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UCHAR();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_SHORT();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_USHORT();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_INT();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UINT();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_LONG();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_ULONG();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_LLONG();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_ULLONG();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_FLOAT();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_DOUBLE();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_LDOUBLE();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_B8();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_B16();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_B32();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_B64();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_OPAQUE();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_HSIZE();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_HSSIZE();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_HERR();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_HBOOL();

	@MemberGetter public static native @Const @ByRef PredType NATIVE_INT8();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UINT8();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_INT16();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UINT16();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_INT32();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UINT32();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_INT64();
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UINT64();

// LEAST types
// #if H5_SIZEOF_INT_LEAST8_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_INT_LEAST8();
// #endif /* H5_SIZEOF_INT_LEAST8_T */
// #if H5_SIZEOF_UINT_LEAST8_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UINT_LEAST8();
// #endif /* H5_SIZEOF_UINT_LEAST8_T */

// #if H5_SIZEOF_INT_LEAST16_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_INT_LEAST16();
// #endif /* H5_SIZEOF_INT_LEAST16_T */
// #if H5_SIZEOF_UINT_LEAST16_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UINT_LEAST16();
// #endif /* H5_SIZEOF_UINT_LEAST16_T */

// #if H5_SIZEOF_INT_LEAST32_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_INT_LEAST32();
// #endif /* H5_SIZEOF_INT_LEAST32_T */
// #if H5_SIZEOF_UINT_LEAST32_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UINT_LEAST32();
// #endif /* H5_SIZEOF_UINT_LEAST32_T */

// #if H5_SIZEOF_INT_LEAST64_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_INT_LEAST64();
// #endif /* H5_SIZEOF_INT_LEAST64_T */
// #if H5_SIZEOF_UINT_LEAST64_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UINT_LEAST64();
// #endif /* H5_SIZEOF_UINT_LEAST64_T */

// FAST types
// #if H5_SIZEOF_INT_FAST8_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_INT_FAST8();
// #endif /* H5_SIZEOF_INT_FAST8_T */
// #if H5_SIZEOF_UINT_FAST8_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UINT_FAST8();
// #endif /* H5_SIZEOF_UINT_FAST8_T */

// #if H5_SIZEOF_INT_FAST16_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_INT_FAST16();
// #endif /* H5_SIZEOF_INT_FAST16_T */
// #if H5_SIZEOF_UINT_FAST16_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UINT_FAST16();
// #endif /* H5_SIZEOF_UINT_FAST16_T */

// #if H5_SIZEOF_INT_FAST32_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_INT_FAST32();
// #endif /* H5_SIZEOF_INT_FAST32_T */
// #if H5_SIZEOF_UINT_FAST32_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UINT_FAST32();
// #endif /* H5_SIZEOF_UINT_FAST32_T */

// #if H5_SIZEOF_INT_FAST64_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_INT_FAST64();
// #endif /* H5_SIZEOF_INT_FAST64_T */
// #if H5_SIZEOF_UINT_FAST64_T != 0
	@MemberGetter public static native @Const @ByRef PredType NATIVE_UINT_FAST64();
// #endif /* H5_SIZEOF_UINT_FAST64_T */

// #ifndef DOXYGEN_SHOULD_SKIP_THIS

        // Deletes the PredType global constants
        public static native void deleteConstants();

        // Dummy constant
        @MemberGetter public static native @Const @ByRef PredType PREDTYPE_CONST();

}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5PredType_H


// Parsed from H5EnumType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5EnumType_H
// #define __H5EnumType_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** Class EnumType operates on HDF5 enum datatypes. */
@Namespace("H5") public static class EnumType extends DataType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public EnumType(Pointer p) { super(p); }

	// Creates an empty enumeration datatype based on a native signed
	// integer type, whose size is given by size.
	public EnumType( @Cast("size_t") long size ) { super((Pointer)null); allocate(size); }
	private native void allocate( @Cast("size_t") long size );

	// Gets the enum datatype of the specified dataset
	public EnumType( @Const @ByRef DataSet dataset ) { super((Pointer)null); allocate(dataset); }
	private native void allocate( @Const @ByRef DataSet dataset );  // H5Dget_type

	// Creates a new enum datatype based on an integer datatype
	public EnumType( @Const @ByRef IntType data_type ) { super((Pointer)null); allocate(data_type); }
	private native void allocate( @Const @ByRef IntType data_type );  // H5Tenum_create

	// Returns the number of members in this enumeration datatype.
	public native int getNmembers();

	// Returns the index of a member in this enumeration data type.
	public native int getMemberIndex(@Cast("const char*") BytePointer name);
	public native int getMemberIndex(String name);

	// Returns the value of an enumeration datatype member
	public native void getMemberValue( @Cast("unsigned") int memb_no, Pointer value );

	// Inserts a new member to this enumeration type.
	public native void insert( @Cast("const char*") BytePointer name, Pointer value );
	public native void insert( String name, Pointer value );

	// Returns the symbol name corresponding to a specified member
	// of this enumeration datatype.
	public native @StdString BytePointer nameOf( Pointer value, @Cast("size_t") long size );

	// Returns the value corresponding to a specified member of this
	// enumeration datatype.
	public native void valueOf( @Cast("const char*") BytePointer name, Pointer value );
	public native void valueOf( String name, Pointer value );

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Default constructor
	public EnumType() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Creates an enumeration datatype using an existing id
	public EnumType( @Cast("const hid_t") int existing_id ) { super((Pointer)null); allocate(existing_id); }
	private native void allocate( @Cast("const hid_t") int existing_id );

	// Copy constructor: makes a copy of the original EnumType object.
	public EnumType( @Const @ByRef EnumType original ) { super((Pointer)null); allocate(original); }
	private native void allocate( @Const @ByRef EnumType original );
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5EnumType_H


// Parsed from H5IntType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5IntType_H
// #define __H5IntType_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** Class IntType operates on HDF5 integer datatype. */
@Namespace("H5") public static class IntType extends AtomType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IntType(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public IntType(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public IntType position(long position) {
        return (IntType)super.position(position);
    }

	// Creates an integer type using a predefined type
	public IntType(@Const @ByRef PredType pred_type) { super((Pointer)null); allocate(pred_type); }
	private native void allocate(@Const @ByRef PredType pred_type);

	// Gets the integer datatype of the specified dataset
	public IntType(@Const @ByRef DataSet dataset) { super((Pointer)null); allocate(dataset); }
	private native void allocate(@Const @ByRef DataSet dataset);

	// Retrieves the sign type for an integer type
	public native @Cast("H5T_sign_t") int getSign();

	// Sets the sign proprety for an integer type.
	public native void setSign( @Cast("H5T_sign_t") int sign );

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Default constructor
	public IntType() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Creates a integer datatype using an existing id
	public IntType(@Cast("const hid_t") int existing_id) { super((Pointer)null); allocate(existing_id); }
	private native void allocate(@Cast("const hid_t") int existing_id);

	// Copy constructor: makes copy of IntType object
	public IntType(@Const @ByRef IntType original) { super((Pointer)null); allocate(original); }
	private native void allocate(@Const @ByRef IntType original);

	// Noop destructor.
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5IntType_H


// Parsed from H5FloatType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5FloatType_H
// #define __H5FloatType_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** Class FloatType operates on HDF5 floating point datatype. */
@Namespace("H5") public static class FloatType extends AtomType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FloatType(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public FloatType(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public FloatType position(long position) {
        return (FloatType)super.position(position);
    }

	// Creates a floating-point type using a predefined type.
	public FloatType( @Const @ByRef PredType pred_type ) { super((Pointer)null); allocate(pred_type); }
	private native void allocate( @Const @ByRef PredType pred_type );

	// Gets the floating-point datatype of the specified dataset.
	public FloatType( @Const @ByRef DataSet dataset ) { super((Pointer)null); allocate(dataset); }
	private native void allocate( @Const @ByRef DataSet dataset );

	// Retrieves the exponent bias of a floating-point type.
	public native @Cast("size_t") long getEbias();

	// Sets the exponent bias of a floating-point type.
	public native void setEbias( @Cast("size_t") long ebias );

	// Retrieves floating point datatype bit field information.
	public native void getFields( @Cast("size_t*") @ByRef SizeTPointer spos, @Cast("size_t*") @ByRef SizeTPointer epos, @Cast("size_t*") @ByRef SizeTPointer esize, @Cast("size_t*") @ByRef SizeTPointer mpos, @Cast("size_t*") @ByRef SizeTPointer msize );

	// Sets locations and sizes of floating point bit fields.
	public native void setFields( @Cast("size_t") long spos, @Cast("size_t") long epos, @Cast("size_t") long esize, @Cast("size_t") long mpos, @Cast("size_t") long msize );

	// Retrieves the internal padding type for unused bits in floating-point datatypes.
	public native @Cast("H5T_pad_t") int getInpad( @StdString BytePointer pad_string );
	public native @Cast("H5T_pad_t") int getInpad( @StdString String pad_string );

	// Fills unused internal floating point bits.
	public native void setInpad( @Cast("H5T_pad_t") int inpad );

	// Retrieves mantissa normalization of a floating-point datatype.
	public native @Cast("H5T_norm_t") int getNorm( @StdString BytePointer norm_string );
	public native @Cast("H5T_norm_t") int getNorm( @StdString String norm_string );

	// Sets the mantissa normalization of a floating-point datatype.
	public native void setNorm( @Cast("H5T_norm_t") int norm );

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Default constructor
	public FloatType() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Creates a floating-point datatype using an existing id.
	public FloatType( @Cast("const hid_t") int existing_id ) { super((Pointer)null); allocate(existing_id); }
	private native void allocate( @Cast("const hid_t") int existing_id );

	// Copy constructor: makes a copy of the original FloatType object.
	public FloatType( @Const @ByRef FloatType original ) { super((Pointer)null); allocate(original); }
	private native void allocate( @Const @ByRef FloatType original );

	// Noop destructor.
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5FloatType_H


// Parsed from H5StrType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5StrType_H
// #define __H5StrType_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** Class StrType operates on HDF5 string datatypes. */
@Namespace("H5") public static class StrType extends AtomType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StrType(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public StrType(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public StrType position(long position) {
        return (StrType)super.position(position);
    }

	// Creates a string type using a predefined type
	public StrType(@Const @ByRef PredType pred_type) { super((Pointer)null); allocate(pred_type); }
	private native void allocate(@Const @ByRef PredType pred_type);

	// Creates a string type with specified length - may be obsolete
	public StrType(@Const @ByRef PredType pred_type, @Cast("const size_t") long size) { super((Pointer)null); allocate(pred_type, size); }
	private native void allocate(@Const @ByRef PredType pred_type, @Cast("const size_t") long size);

	// Creates a string type with specified length
	public StrType(int dummy, @Cast("const size_t") long size) { super((Pointer)null); allocate(dummy, size); }
	private native void allocate(int dummy, @Cast("const size_t") long size);

        // Gets the string datatype of the specified dataset
	public StrType(@Const @ByRef DataSet dataset) { super((Pointer)null); allocate(dataset); }
	private native void allocate(@Const @ByRef DataSet dataset);

	// Retrieves the character set type of this string datatype.
	public native @Cast("H5T_cset_t") int getCset();

	// Sets character set to be used.
	public native void setCset(@Cast("H5T_cset_t") int cset);

	// Retrieves the string padding method for this string datatype.
	public native @Cast("H5T_str_t") int getStrpad();

	// Defines the storage mechanism for character strings.
	public native void setStrpad(@Cast("H5T_str_t") int strpad);

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// default constructor
	public StrType() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Creates a string datatype using an existing id
	public StrType(@Cast("const hid_t") int existing_id) { super((Pointer)null); allocate(existing_id); }
	private native void allocate(@Cast("const hid_t") int existing_id);

	// Copy constructor - makes a copy of the original object
	public StrType(@Const @ByRef StrType original) { super((Pointer)null); allocate(original); }
	private native void allocate(@Const @ByRef StrType original);

	// Noop destructor.
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5StrType_H


// Parsed from H5CompType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5CompType_H
// #define __H5CompType_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** \class CompType
    \brief CompType is a derivative of a DataType and operates on HDF5
    compound datatypes.
*/
@Namespace("H5") public static class CompType extends DataType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CompType(Pointer p) { super(p); }

	// Default constructor
	public CompType() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Creates a compound datatype using an existing id
	public CompType( @Cast("const hid_t") int existing_id ) { super((Pointer)null); allocate(existing_id); }
	private native void allocate( @Cast("const hid_t") int existing_id );

	// Creates a new compound datatype, given the type's size
	public CompType( @Cast("size_t") long size ) { super((Pointer)null); allocate(size); }
	private native void allocate( @Cast("size_t") long size ); // H5Tcreate

	// Gets the compound datatype of the specified dataset
	public CompType( @Const @ByRef DataSet dataset ) { super((Pointer)null); allocate(dataset); }
	private native void allocate( @Const @ByRef DataSet dataset );  // H5Dget_type

	// Copy constructor - makes a copy of original object
	public CompType( @Const @ByRef CompType original ) { super((Pointer)null); allocate(original); }
	private native void allocate( @Const @ByRef CompType original );

	// Returns the type class of the specified member of this compound
	// datatype.  It provides to the user a way of knowing what type
	// to create another datatype of the same class
	public native @Cast("H5T_class_t") int getMemberClass( @Cast("unsigned") int member_num );

	// Returns the index of a member in this compound data type.
	public native int getMemberIndex(@Cast("const char*") BytePointer name);
	public native int getMemberIndex(String name);

	// Returns the offset of a member of this compound datatype.
	public native @Cast("size_t") long getMemberOffset( @Cast("unsigned") int memb_no );

	// Returns the name of a member of this compound datatype.
	public native @StdString BytePointer getMemberName( @Cast("unsigned") int member_num );

	// Returns the generic datatype of the specified member in
	// this compound datatype.
	public native @ByVal DataType getMemberDataType( @Cast("unsigned") int member_num );

	// Returns the array datatype of the specified member in
	// this compound datatype.
	public native @ByVal ArrayType getMemberArrayType( @Cast("unsigned") int member_num );

	// Returns the compound datatype of the specified member in
	// this compound datatype.
	public native @ByVal CompType getMemberCompType( @Cast("unsigned") int member_num );

	// Returns the enumeration datatype of the specified member in
	// this compound datatype.
	public native @ByVal EnumType getMemberEnumType( @Cast("unsigned") int member_num );

	// Returns the integer datatype of the specified member in
	// this compound datatype.
	public native @ByVal IntType getMemberIntType( @Cast("unsigned") int member_num );

	// Returns the floating-point datatype of the specified member in
	// this compound datatype.
	public native @ByVal FloatType getMemberFloatType( @Cast("unsigned") int member_num );

	// Returns the string datatype of the specified member in
	// this compound datatype.
	public native @ByVal StrType getMemberStrType( @Cast("unsigned") int member_num );

	// Returns the variable length datatype of the specified member in
	// this compound datatype.
	public native @ByVal VarLenType getMemberVarLenType( @Cast("unsigned") int member_num );

	// Returns the number of members in this compound datatype.
	public native int getNmembers();

	// Adds a new member to this compound datatype.
	public native void insertMember( @StdString BytePointer name, @Cast("size_t") long offset, @Const @ByRef DataType new_member );
	public native void insertMember( @StdString String name, @Cast("size_t") long offset, @Const @ByRef DataType new_member );

	// Recursively removes padding from within this compound datatype.
	public native void pack();

	// Sets the total size for this compound datatype.
	public native void setSize(@Cast("size_t") long size);

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Noop destructor.
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5CompType_H


// Parsed from H5ArrayType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5ArrayType_H
// #define __H5ArrayType_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** \class ArrayType
    \brief Class ArrayType inherits from DataType and provides wrappers for
     the HDF5's Array Datatypes.
*/
@Namespace("H5") @NoOffset public static class ArrayType extends DataType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ArrayType(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ArrayType(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ArrayType position(long position) {
        return (ArrayType)super.position(position);
    }

	// Constructor that creates a new array data type based on the
	// specified base type.
	public ArrayType(@Const @ByRef DataType base_type, int ndims, @Cast("const hsize_t*") LongPointer dims) { super((Pointer)null); allocate(base_type, ndims, dims); }
	private native void allocate(@Const @ByRef DataType base_type, int ndims, @Cast("const hsize_t*") LongPointer dims);
	public ArrayType(@Const @ByRef DataType base_type, int ndims, @Cast("const hsize_t*") LongBuffer dims) { super((Pointer)null); allocate(base_type, ndims, dims); }
	private native void allocate(@Const @ByRef DataType base_type, int ndims, @Cast("const hsize_t*") LongBuffer dims);
	public ArrayType(@Const @ByRef DataType base_type, int ndims, @Cast("const hsize_t*") long[] dims) { super((Pointer)null); allocate(base_type, ndims, dims); }
	private native void allocate(@Const @ByRef DataType base_type, int ndims, @Cast("const hsize_t*") long[] dims);

	// Assignment operator
	public native @ByRef @Name("operator =") ArrayType put(@Const @ByRef ArrayType rhs);

	// Stores the rank and dimensions in memory.
	public native void setArrayInfo();

	// Returns the number of dimensions of this array datatype.
	public native int getArrayNDims();

	// Returns the sizes of dimensions of this array datatype.
	public native int getArrayDims(@Cast("hsize_t*") LongPointer dims);
	public native int getArrayDims(@Cast("hsize_t*") LongBuffer dims);
	public native int getArrayDims(@Cast("hsize_t*") long[] dims);

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Copy constructor: makes copy of the original object.
	public ArrayType( @Const @ByRef ArrayType original ) { super((Pointer)null); allocate(original); }
	private native void allocate( @Const @ByRef ArrayType original );

	// Constructor that takes an existing id
	public ArrayType( @Cast("const hid_t") int existing_id ) { super((Pointer)null); allocate(existing_id); }
	private native void allocate( @Cast("const hid_t") int existing_id );

	// Noop destructor

	// Default constructor
	public ArrayType() { super((Pointer)null); allocate(); }
	private native void allocate();
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5ArrayType_H


// Parsed from H5VarLenType.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5VarLenType_H
// #define __H5VarLenType_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** VarLenType operates on the HDF5 C's Variable-length Datatypes. */
@Namespace("H5") public static class VarLenType extends DataType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public VarLenType(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public VarLenType(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public VarLenType position(long position) {
        return (VarLenType)super.position(position);
    }

	// Constructor that creates a variable-length datatype based
	// on the specified base type.
	public VarLenType(@Const DataType base_type) { super((Pointer)null); allocate(base_type); }
	private native void allocate(@Const DataType base_type);

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Copy constructor: makes copy of the original object.
	public VarLenType( @Const @ByRef VarLenType original ) { super((Pointer)null); allocate(original); }
	private native void allocate( @Const @ByRef VarLenType original );

	// Constructor that takes an existing id
	public VarLenType( @Cast("const hid_t") int existing_id ) { super((Pointer)null); allocate(existing_id); }
	private native void allocate( @Cast("const hid_t") int existing_id );

	// Noop destructor

	// Default constructor
	public VarLenType() { super((Pointer)null); allocate(); }
	private native void allocate();
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5VarLenType_H


// Parsed from H5DataSet.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5DataSet_H
// #define __H5DataSet_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** \class DataSet
    \brief Class DataSet operates on HDF5 datasets.
    <p>
    An datasets has many characteristics similar to an attribute, thus both
    Attribute and DataSet are derivatives of AbstractDs.  DataSet also
    inherits from H5Object because a dataset is an HDF5 object.
*/
@Namespace("H5") @NoOffset public static class DataSet extends H5Object {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DataSet(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DataSet(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DataSet position(long position) {
        return (DataSet)super.position(position);
    }
    public AbstractDs asAbstractDs() { return asAbstractDs(this); }
    @Namespace public static native @Name("static_cast<H5::AbstractDs*>") AbstractDs asAbstractDs(DataSet pointer);


	// Close this dataset.
	public native @Name("close") void _close();

	// Extends the dataset with unlimited dimension.
	public native void extend( @Cast("const hsize_t*") LongPointer size );
	public native void extend( @Cast("const hsize_t*") LongBuffer size );
	public native void extend( @Cast("const hsize_t*") long[] size );

	// Fills a selection in memory with a value
	public native void fillMemBuf(@Const Pointer fill, @ByRef DataType fill_type, Pointer buf, @ByRef DataType buf_type, @ByRef DataSpace space); // kept for backward compatibility

	// Fills a selection in memory with zero
	public native void fillMemBuf(Pointer buf, @ByRef DataType buf_type, @ByRef DataSpace space); // kept for backward compatibility

	// Gets the creation property list of this dataset.
	public native @ByVal DSetCreatPropList getCreatePlist();

	// Returns the address of this dataset in the file.
	public native @Cast("haddr_t") long getOffset();

	// Gets the dataspace of this dataset.
	public native @ByVal DataSpace getSpace();

	// Determines whether space has been allocated for a dataset.
	public native void getSpaceStatus(@Cast("H5D_space_status_t*") @ByRef IntPointer status);
	public native void getSpaceStatus(@Cast("H5D_space_status_t*") @ByRef IntBuffer status);
	public native void getSpaceStatus(@Cast("H5D_space_status_t*") @ByRef int[] status);

	// Returns the amount of storage size required for this dataset.
	public native @Cast("hsize_t") long getStorageSize();

	// Returns the in memory size of this attribute's data.
	public native @Cast("size_t") long getInMemDataSize();

	// Returns the number of bytes required to store VL data.
	public native @Cast("hsize_t") long getVlenBufSize(@Const @ByRef DataType type, @Const @ByRef DataSpace space ); // kept for backward compatibility

	// Reclaims VL datatype memory buffers.
	public static native void vlenReclaim(@Const @ByRef DataType type, @Const @ByRef DataSpace space, @Const @ByRef DSetMemXferPropList xfer_plist, Pointer buf );
	public static native void vlenReclaim(Pointer buf, @Const @ByRef DataType type, @Const @ByRef(nullValue = "H5::DataSpace::ALL") DataSpace space, @Const @ByRef(nullValue = "H5::DSetMemXferPropList::DEFAULT") DSetMemXferPropList xfer_plist);
	public static native void vlenReclaim(Pointer buf, @Const @ByRef DataType type);

	// Reads the data of this dataset and stores it in the provided buffer.
	// The memory and file dataspaces and the transferring property list
	// can be defaults.
	public native void read( Pointer buf, @Const @ByRef DataType mem_type, @Const @ByRef(nullValue = "H5::DataSpace::ALL") DataSpace mem_space, @Const @ByRef(nullValue = "H5::DataSpace::ALL") DataSpace file_space, @Const @ByRef(nullValue = "H5::DSetMemXferPropList::DEFAULT") DSetMemXferPropList xfer_plist );
	public native void read( Pointer buf, @Const @ByRef DataType mem_type );
        public native void read( @StdString BytePointer buf, @Const @ByRef DataType mem_type, @Const @ByRef(nullValue = "H5::DataSpace::ALL") DataSpace mem_space, @Const @ByRef(nullValue = "H5::DataSpace::ALL") DataSpace file_space, @Const @ByRef(nullValue = "H5::DSetMemXferPropList::DEFAULT") DSetMemXferPropList xfer_plist );
        public native void read( @StdString BytePointer buf, @Const @ByRef DataType mem_type );
        public native void read( @StdString String buf, @Const @ByRef DataType mem_type, @Const @ByRef(nullValue = "H5::DataSpace::ALL") DataSpace mem_space, @Const @ByRef(nullValue = "H5::DataSpace::ALL") DataSpace file_space, @Const @ByRef(nullValue = "H5::DSetMemXferPropList::DEFAULT") DSetMemXferPropList xfer_plist );
        public native void read( @StdString String buf, @Const @ByRef DataType mem_type );

	// Writes the buffered data to this dataset.
	// The memory and file dataspaces and the transferring property list
	// can be defaults.
	public native void write( @Const Pointer buf, @Const @ByRef DataType mem_type, @Const @ByRef(nullValue = "H5::DataSpace::ALL") DataSpace mem_space, @Const @ByRef(nullValue = "H5::DataSpace::ALL") DataSpace file_space, @Const @ByRef(nullValue = "H5::DSetMemXferPropList::DEFAULT") DSetMemXferPropList xfer_plist );
	public native void write( @Const Pointer buf, @Const @ByRef DataType mem_type );
        public native void write( @StdString BytePointer buf, @Const @ByRef DataType mem_type, @Const @ByRef(nullValue = "H5::DataSpace::ALL") DataSpace mem_space, @Const @ByRef(nullValue = "H5::DataSpace::ALL") DataSpace file_space, @Const @ByRef(nullValue = "H5::DSetMemXferPropList::DEFAULT") DSetMemXferPropList xfer_plist );
        public native void write( @StdString BytePointer buf, @Const @ByRef DataType mem_type );
        public native void write( @StdString String buf, @Const @ByRef DataType mem_type, @Const @ByRef(nullValue = "H5::DataSpace::ALL") DataSpace mem_space, @Const @ByRef(nullValue = "H5::DataSpace::ALL") DataSpace file_space, @Const @ByRef(nullValue = "H5::DSetMemXferPropList::DEFAULT") DSetMemXferPropList xfer_plist );
        public native void write( @StdString String buf, @Const @ByRef DataType mem_type );

	// Iterates the selected elements in the specified dataspace - not implemented in C++ style yet
        public native int iterateElems( Pointer buf, @Const @ByRef DataType type, @Const @ByRef DataSpace space, H5D_operator_t op, Pointer op_data/*=NULL*/ );
        public native int iterateElems( Pointer buf, @Const @ByRef DataType type, @Const @ByRef DataSpace space, H5D_operator_t op );

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Creates a dataset by way of dereference.
	public DataSet(@Const @ByRef H5Location loc, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist) { super((Pointer)null); allocate(loc, ref, ref_type, plist); }
	private native void allocate(@Const @ByRef H5Location loc, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist);
	public DataSet(@Const @ByRef H5Location loc, @Const Pointer ref) { super((Pointer)null); allocate(loc, ref); }
	private native void allocate(@Const @ByRef H5Location loc, @Const Pointer ref);
	public DataSet(@Const @ByRef Attribute attr, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist) { super((Pointer)null); allocate(attr, ref, ref_type, plist); }
	private native void allocate(@Const @ByRef Attribute attr, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist);
	public DataSet(@Const @ByRef Attribute attr, @Const Pointer ref) { super((Pointer)null); allocate(attr, ref); }
	private native void allocate(@Const @ByRef Attribute attr, @Const Pointer ref);

	// Default constructor.
	public DataSet() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Copy constructor.
	public DataSet( @Const @ByRef DataSet original ) { super((Pointer)null); allocate(original); }
	private native void allocate( @Const @ByRef DataSet original );

	// Creates a copy of an existing DataSet using its id.
	public DataSet(@Cast("const hid_t") int existing_id) { super((Pointer)null); allocate(existing_id); }
	private native void allocate(@Cast("const hid_t") int existing_id);

        // Gets the dataset id.
        public native @Cast("hid_t") int getId();

	// Destructor: properly terminates access to this dataset.

}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5DataSet_H


// Parsed from H5Group.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5Group_H
// #define __H5Group_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** \class Group
    \brief Class Group represents an HDF5 group.
    <p>
    It inherits many operations from H5Location and CommonFG.
*/
@Namespace("H5") @NoOffset public static class Group extends H5Object {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Group(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Group(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Group position(long position) {
        return (Group)super.position(position);
    }
    public CommonFG asCommonFG() { return asCommonFG(this); }
    @Namespace public static native @Name("static_cast<H5::CommonFG*>") CommonFG asCommonFG(Group pointer);

	// Close this group.
	public native @Name("close") void _close();

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Throw group exception.
	public native void throwException(@StdString BytePointer func_name, @StdString BytePointer msg);
	public native void throwException(@StdString String func_name, @StdString String msg);

	// for CommonFG to get the file id.
	public native @Cast("hid_t") int getLocId();

	// Creates a group by way of dereference.
	public Group(@Const @ByRef H5Location loc, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist) { super((Pointer)null); allocate(loc, ref, ref_type, plist); }
	private native void allocate(@Const @ByRef H5Location loc, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist);
	public Group(@Const @ByRef H5Location loc, @Const Pointer ref) { super((Pointer)null); allocate(loc, ref); }
	private native void allocate(@Const @ByRef H5Location loc, @Const Pointer ref);
        public Group(@Const @ByRef Attribute attr, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist) { super((Pointer)null); allocate(attr, ref, ref_type, plist); }
        private native void allocate(@Const @ByRef Attribute attr, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist);
        public Group(@Const @ByRef Attribute attr, @Const Pointer ref) { super((Pointer)null); allocate(attr, ref); }
        private native void allocate(@Const @ByRef Attribute attr, @Const Pointer ref);

	// default constructor
	public Group() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Copy constructor: makes a copy of the original object
	public Group(@Const @ByRef Group original) { super((Pointer)null); allocate(original); }
	private native void allocate(@Const @ByRef Group original);

	// Gets the group id.
	public native @Cast("hid_t") int getId();

	// Destructor

	// Creates a copy of an existing group using its id.
	public Group( @Cast("const hid_t") int group_id ) { super((Pointer)null); allocate(group_id); }
	private native void allocate( @Cast("const hid_t") int group_id );
}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5Group_H


// Parsed from H5File.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5File_H
// #define __H5File_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** \class H5File
    \brief Class H5File represents an HDF5 file.
    <p>
    It inherits from H5Location and CommonFG.
*/
@Namespace("H5") @NoOffset public static class H5File extends H5Location {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5File(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5File(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public H5File position(long position) {
        return (H5File)super.position(position);
    }
    public CommonFG asCommonFG() { return asCommonFG(this); }
    @Namespace public static native @Name("static_cast<H5::CommonFG*>") CommonFG asCommonFG(H5File pointer);

	// Creates or opens an HDF5 file.
	public H5File( @Cast("const char*") BytePointer name, @Cast("unsigned int") int flags,
		   @Const @ByRef(nullValue = "H5::FileCreatPropList::DEFAULT") FileCreatPropList create_plist,
		   @Const @ByRef(nullValue = "H5::FileAccPropList::DEFAULT") FileAccPropList access_plist ) { super((Pointer)null); allocate(name, flags, create_plist, access_plist); }
	private native void allocate( @Cast("const char*") BytePointer name, @Cast("unsigned int") int flags,
		   @Const @ByRef(nullValue = "H5::FileCreatPropList::DEFAULT") FileCreatPropList create_plist,
		   @Const @ByRef(nullValue = "H5::FileAccPropList::DEFAULT") FileAccPropList access_plist );
	public H5File( @Cast("const char*") BytePointer name, @Cast("unsigned int") int flags ) { super((Pointer)null); allocate(name, flags); }
	private native void allocate( @Cast("const char*") BytePointer name, @Cast("unsigned int") int flags );
	public H5File( String name, @Cast("unsigned int") int flags,
		   @Const @ByRef(nullValue = "H5::FileCreatPropList::DEFAULT") FileCreatPropList create_plist,
		   @Const @ByRef(nullValue = "H5::FileAccPropList::DEFAULT") FileAccPropList access_plist ) { super((Pointer)null); allocate(name, flags, create_plist, access_plist); }
	private native void allocate( String name, @Cast("unsigned int") int flags,
		   @Const @ByRef(nullValue = "H5::FileCreatPropList::DEFAULT") FileCreatPropList create_plist,
		   @Const @ByRef(nullValue = "H5::FileAccPropList::DEFAULT") FileAccPropList access_plist );
	public H5File( String name, @Cast("unsigned int") int flags ) { super((Pointer)null); allocate(name, flags); }
	private native void allocate( String name, @Cast("unsigned int") int flags );

	// Open the file
	public native void openFile(@StdString BytePointer name, @Cast("unsigned int") int flags,
		    @Const @ByRef(nullValue = "H5::FileAccPropList::DEFAULT") FileAccPropList access_plist);
	public native void openFile(@StdString BytePointer name, @Cast("unsigned int") int flags);
	public native void openFile(@StdString String name, @Cast("unsigned int") int flags,
		    @Const @ByRef(nullValue = "H5::FileAccPropList::DEFAULT") FileAccPropList access_plist);
	public native void openFile(@StdString String name, @Cast("unsigned int") int flags);

	// Close this file.
	public native @Name("close") void _close();

	// Gets the access property list of this file.
	public native @ByVal FileAccPropList getAccessPlist();

	// Gets the creation property list of this file.
	public native @ByVal FileCreatPropList getCreatePlist();

	// Retrieves the file size of an opened file.
	public native @Cast("hsize_t") long getFileSize();

	// Returns the amount of free space in the file.
	public native @Cast("hssize_t") long getFreeSpace();

	// Returns the number of opened object IDs (files, datasets, groups
	// and datatypes) in the same file.
	public native @Cast("ssize_t") int getObjCount(@Cast("unsigned") int types/*=H5F_OBJ_ALL*/);
	public native @Cast("ssize_t") int getObjCount();

	// Retrieves a list of opened object IDs (files, datasets, groups
	// and datatypes) in the same file.
	public native void getObjIDs(@Cast("unsigned") int types, @Cast("size_t") long max_objs, @Cast("hid_t*") IntPointer oid_list);
	public native void getObjIDs(@Cast("unsigned") int types, @Cast("size_t") long max_objs, @Cast("hid_t*") IntBuffer oid_list);
	public native void getObjIDs(@Cast("unsigned") int types, @Cast("size_t") long max_objs, @Cast("hid_t*") int[] oid_list);

	// Returns the pointer to the file handle of the low-level file driver.
	public native void getVFDHandle(@Cast("void**") PointerPointer file_handle);
	public native void getVFDHandle(@Cast("void**") @ByPtrPtr Pointer file_handle);
	public native void getVFDHandle(@Const @ByRef FileAccPropList fapl, @Cast("void**") PointerPointer file_handle);
	public native void getVFDHandle(@Const @ByRef FileAccPropList fapl, @Cast("void**") @ByPtrPtr Pointer file_handle); // kept for backward compatibility

	// Determines if a file, specified by its name, is in HDF5 format
	public static native @Cast("bool") boolean isHdf5(@Cast("const char*") BytePointer name );
	public static native @Cast("bool") boolean isHdf5(String name );

	// Reopens this file.
	public native void reOpen();	// added for better name

// #ifndef DOXYGEN_SHOULD_SKIP_THIS
	public native void reopen();  // obsolete in favor of reOpen()

	// Gets the file id
	public native @Cast("hid_t") int getLocId();

	// Creates an H5File using an existing file id.  Not recommended
	// in applications.
	public H5File(@Cast("hid_t") int existing_id) { super((Pointer)null); allocate(existing_id); }
	private native void allocate(@Cast("hid_t") int existing_id);

// #endif // DOXYGEN_SHOULD_SKIP_THIS

	/**\brief Returns this class name. */
	public native @StdString BytePointer fromClass();

	// Throw file exception.
	public native void throwException(@StdString BytePointer func_name, @StdString BytePointer msg);
	public native void throwException(@StdString String func_name, @StdString String msg);

	// Default constructor
	public H5File() { super((Pointer)null); allocate(); }
	private native void allocate();

	// Copy constructor: makes a copy of the original H5File object.
	public H5File(@Const @ByRef H5File original) { super((Pointer)null); allocate(original); }
	private native void allocate(@Const @ByRef H5File original);

	// Gets the HDF5 file id.
	public native @Cast("hid_t") int getId();

	// H5File destructor.

}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5File_H


// Parsed from H5Library.h

// C++ informative line for the emacs editor: -*- C++ -*-
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// #ifndef __H5Library_H
// #define __H5Library_H

// #ifndef H5_NO_NAMESPACE
// #endif

/** \class H5Library
    \brief Class H5Library operates the HDF5 library globably.
    <p>
    It is not neccessary to construct an instance of H5Library to use the
    methods.
*/
@Namespace("H5") @NoOffset public static class H5Library extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5Library(Pointer p) { super(p); }

// #ifndef DOXYGEN_SHOULD_SKIP_THIS
        public static native @Cast("bool") boolean need_cleanup(); public static native void need_cleanup(boolean need_cleanup); // indicates if H5close should be called
                             // - unused, will be removed in future releases.
// #endif // DOXYGEN_SHOULD_SKIP_THIS

	// Initializes the HDF5 library.
	public static native void open();

	// Flushes all data to disk, closes files, and cleans up memory.
	public static native @Name("close") void _close();

	// Instructs library not to install atexit cleanup routine
	public static native void dontAtExit();

	// Returns the HDF library release number.
	public static native void getLibVersion( @Cast("unsigned*") @ByRef IntPointer majnum, @Cast("unsigned*") @ByRef IntPointer minnum, @Cast("unsigned*") @ByRef IntPointer relnum );
	public static native void getLibVersion( @Cast("unsigned*") @ByRef IntBuffer majnum, @Cast("unsigned*") @ByRef IntBuffer minnum, @Cast("unsigned*") @ByRef IntBuffer relnum );
	public static native void getLibVersion( @Cast("unsigned*") @ByRef int[] majnum, @Cast("unsigned*") @ByRef int[] minnum, @Cast("unsigned*") @ByRef int[] relnum );

	// Verifies that the arguments match the version numbers compiled
	// into the library
	public static native void checkVersion( @Cast("unsigned") int majnum, @Cast("unsigned") int minnum, @Cast("unsigned") int relnum );

	// Walks through all the garbage collection routines for the library,
	// which are supposed to free any unused memory they have allocated.
	public static native void garbageCollect();

	// Sets limits on the different kinds of free lists.
	public static native void setFreeListLimits(int reg_global_lim, int reg_list_lim, int arr_global_lim, int arr_list_lim, int blk_global_lim, int blk_list_lim);

        // Initializes C++ library and registers terminating functions at exit.
	// Only for the library functions, not for user-defined functions.
        public static native void initH5cpp();

        // Sends request for terminating the HDF5 library.
        public static native void termH5cpp();

}
// #ifndef H5_NO_NAMESPACE

// #endif
// #endif // __H5Library_H


}
