// Targeted by JavaCPP version 1.4: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.opencv_core.*;
import static org.bytedeco.javacpp.opencv_imgproc.*;
import static org.bytedeco.javacpp.opencv_imgcodecs.*;
import static org.bytedeco.javacpp.opencv_videoio.*;
import static org.bytedeco.javacpp.opencv_highgui.*;

public class opencv_bioinspired extends org.bytedeco.javacpp.presets.opencv_bioinspired {
    static { Loader.load(); }

// Parsed from <opencv2/bioinspired.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_BIOINSPIRED_HPP__
// #define __OPENCV_BIOINSPIRED_HPP__

// #include "opencv2/core.hpp"
// #include "opencv2/bioinspired/retina.hpp"
// #include "opencv2/bioinspired/retinafasttonemapping.hpp"
// #include "opencv2/bioinspired/transientareassegmentationmodule.hpp"

/** \defgroup bioinspired Biologically inspired vision models and derivated tools
<p>
The module provides biological visual systems models (human visual system and others). It also
provides derivated objects that take advantage of those bio-inspired models.
<p>
\ref bioinspired_retina
<p>
*/

// #endif


// Parsed from opencv2/bioinspired/bioinspired.hpp

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifdef __OPENCV_BUILD
// #endif

// #include "opencv2/bioinspired.hpp"


// Parsed from opencv2/bioinspired/retina.hpp

/*#******************************************************************************
 ** IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
 **
 ** By downloading, copying, installing or using the software you agree to this license.
 ** If you do not agree to this license, do not download, install,
 ** copy or use the software.
 **
 **
 ** bioinspired : interfaces allowing OpenCV users to integrate Human Vision System models. Presented models originate from Jeanny Herault's original research and have been reused and adapted by the author&collaborators for computed vision applications since his thesis with Alice Caplier at Gipsa-Lab.
 ** Use: extract still images & image sequences features, from contours details to motion spatio-temporal features, etc. for high level visual scene analysis. Also contribute to image enhancement/compression such as tone mapping.
 **
 ** Maintainers : Listic lab (code author current affiliation & applications) and Gipsa Lab (original research origins & applications)
 **
 **  Creation - enhancement process 2007-2015
 **      Author: Alexandre Benoit (benoit.alexandre.vision@gmail.com), LISTIC lab, Annecy le vieux, France
 **
 ** Theses algorithm have been developped by Alexandre BENOIT since his thesis with Alice Caplier at Gipsa-Lab (www.gipsa-lab.inpg.fr) and the research he pursues at LISTIC Lab (www.listic.univ-savoie.fr).
 ** Refer to the following research paper for more information:
 ** Benoit A., Caplier A., Durette B., Herault, J., "USING HUMAN VISUAL SYSTEM MODELING FOR BIO-INSPIRED LOW LEVEL IMAGE PROCESSING", Elsevier, Computer Vision and Image Understanding 114 (2010), pp. 758-773, DOI: http://dx.doi.org/10.1016/j.cviu.2010.01.011
 ** This work have been carried out thanks to Jeanny Herault who's research and great discussions are the basis of all this work, please take a look at his book:
 ** Vision: Images, Signals and Neural Networks: Models of Neural Processing in Visual Perception (Progress in Neural Processing),By: Jeanny Herault, ISBN: 9814273686. WAPI (Tower ID): 113266891.
 **
 ** The retina filter includes the research contributions of phd/research collegues from which code has been redrawn by the author :
 ** _take a look at the retinacolor.hpp module to discover Brice Chaix de Lavarene color mosaicing/demosaicing and the reference paper:
 ** ====> B. Chaix de Lavarene, D. Alleysson, B. Durette, J. Herault (2007). "Efficient demosaicing through recursive filtering", IEEE International Conference on Image Processing ICIP 2007
 ** _take a look at imagelogpolprojection.hpp to discover retina spatial log sampling which originates from Barthelemy Durette phd with Jeanny Herault. A Retina / V1 cortex projection is also proposed and originates from Jeanny's discussions.
 ** ====> more informations in the above cited Jeanny Heraults's book.
 **
 **                          License Agreement
 **               For Open Source Computer Vision Library
 **
 ** Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
 ** Copyright (C) 2008-2011, Willow Garage Inc., all rights reserved.
 **
 **               For Human Visual System tools (bioinspired)
 ** Copyright (C) 2007-2015, LISTIC Lab, Annecy le Vieux and GIPSA Lab, Grenoble, France, all rights reserved.
 **
 ** Third party copyrights are property of their respective owners.
 **
 ** Redistribution and use in source and binary forms, with or without modification,
 ** are permitted provided that the following conditions are met:
 **
 ** * Redistributions of source code must retain the above copyright notice,
 **    this list of conditions and the following disclaimer.
 **
 ** * Redistributions in binary form must reproduce the above copyright notice,
 **    this list of conditions and the following disclaimer in the documentation
 **    and/or other materials provided with the distribution.
 **
 ** * The name of the copyright holders may not be used to endorse or promote products
 **    derived from this software without specific prior written permission.
 **
 ** This software is provided by the copyright holders and contributors "as is" and
 ** any express or implied warranties, including, but not limited to, the implied
 ** warranties of merchantability and fitness for a particular purpose are disclaimed.
 ** In no event shall the Intel Corporation or contributors be liable for any direct,
 ** indirect, incidental, special, exemplary, or consequential damages
 ** (including, but not limited to, procurement of substitute goods or services;
 ** loss of use, data, or profits; or business interruption) however caused
 ** and on any theory of liability, whether in contract, strict liability,
 ** or tort (including negligence or otherwise) arising in any way out of
 ** the use of this software, even if advised of the possibility of such damage.
 *******************************************************************************/

// #ifndef __OPENCV_BIOINSPIRED_RETINA_HPP__
// #define __OPENCV_BIOINSPIRED_RETINA_HPP__

/**
\file
\date Jul 19, 2011
@author Alexandre Benoit
*/

// #include "opencv2/core.hpp" // for all OpenCV core functionalities access, including cv::Exception support

/** \addtogroup bioinspired
 *  \{ */

/** enum cv::bioinspired:: */
public static final int
    /** each pixel position is either R, G or B in a random choice */
    RETINA_COLOR_RANDOM = 0,
    /** color sampling is RGBRGBRGB..., line 2 BRGBRGBRG..., line 3, GBRGBRGBR... */
    RETINA_COLOR_DIAGONAL = 1,
    /** standard bayer sampling */
    RETINA_COLOR_BAYER = 2;


/** \brief retina model parameters structure
    <p>
    For better clarity, check explenations on the comments of methods : setupOPLandIPLParvoChannel and setupIPLMagnoChannel
    <p>
    Here is the default configuration file of the retina module. It gives results such as the first
    retina output shown on the top of this page.
    <p>
    <pre>{@code {xml}
    <?xml version="1.0"?>
    <opencv_storage>
    <OPLandIPLparvo>
        <colorMode>1</colorMode>
        <normaliseOutput>1</normaliseOutput>
        <photoreceptorsLocalAdaptationSensitivity>7.5e-01</photoreceptorsLocalAdaptationSensitivity>
        <photoreceptorsTemporalConstant>9.0e-01</photoreceptorsTemporalConstant>
        <photoreceptorsSpatialConstant>5.3e-01</photoreceptorsSpatialConstant>
        <horizontalCellsGain>0.01</horizontalCellsGain>
        <hcellsTemporalConstant>0.5</hcellsTemporalConstant>
        <hcellsSpatialConstant>7.</hcellsSpatialConstant>
        <ganglionCellsSensitivity>7.5e-01</ganglionCellsSensitivity></OPLandIPLparvo>
    <IPLmagno>
        <normaliseOutput>1</normaliseOutput>
        <parasolCells_beta>0.</parasolCells_beta>
        <parasolCells_tau>0.</parasolCells_tau>
        <parasolCells_k>7.</parasolCells_k>
        <amacrinCellsTemporalCutFrequency>2.0e+00</amacrinCellsTemporalCutFrequency>
        <V0CompressionParameter>9.5e-01</V0CompressionParameter>
        <localAdaptintegration_tau>0.</localAdaptintegration_tau>
        <localAdaptintegration_k>7.</localAdaptintegration_k></IPLmagno>
    </opencv_storage>
    }</pre>
    <p>
    Here is the 'realistic" setup used to obtain the second retina output shown on the top of this page.
    <p>
    <pre>{@code {xml}
    <?xml version="1.0"?>
    <opencv_storage>
    <OPLandIPLparvo>
      <colorMode>1</colorMode>
      <normaliseOutput>1</normaliseOutput>
      <photoreceptorsLocalAdaptationSensitivity>8.9e-01</photoreceptorsLocalAdaptationSensitivity>
      <photoreceptorsTemporalConstant>9.0e-01</photoreceptorsTemporalConstant>
      <photoreceptorsSpatialConstant>5.3e-01</photoreceptorsSpatialConstant>
      <horizontalCellsGain>0.3</horizontalCellsGain>
      <hcellsTemporalConstant>0.5</hcellsTemporalConstant>
      <hcellsSpatialConstant>7.</hcellsSpatialConstant>
      <ganglionCellsSensitivity>8.9e-01</ganglionCellsSensitivity></OPLandIPLparvo>
    <IPLmagno>
      <normaliseOutput>1</normaliseOutput>
      <parasolCells_beta>0.</parasolCells_beta>
      <parasolCells_tau>0.</parasolCells_tau>
      <parasolCells_k>7.</parasolCells_k>
      <amacrinCellsTemporalCutFrequency>2.0e+00</amacrinCellsTemporalCutFrequency>
      <V0CompressionParameter>9.5e-01</V0CompressionParameter>
      <localAdaptintegration_tau>0.</localAdaptintegration_tau>
      <localAdaptintegration_k>7.</localAdaptintegration_k></IPLmagno>
    </opencv_storage>
    }</pre>
      */
    @Namespace("cv::bioinspired") public static class RetinaParameters extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public RetinaParameters() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public RetinaParameters(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public RetinaParameters(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public RetinaParameters position(long position) {
            return (RetinaParameters)super.position(position);
        }
     
        /** Outer Plexiform Layer (OPL) and Inner Plexiform Layer Parvocellular (IplParvo) parameters */
        @NoOffset public static class OPLandIplParvoParameters extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public OPLandIplParvoParameters(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public OPLandIplParvoParameters(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public OPLandIplParvoParameters position(long position) {
                return (OPLandIplParvoParameters)super.position(position);
            }
        
               public OPLandIplParvoParameters() { super((Pointer)null); allocate(); }
               private native void allocate(); // default setup
               public native @Cast("bool") boolean colorMode(); public native OPLandIplParvoParameters colorMode(boolean colorMode);
               public native @Cast("bool") boolean normaliseOutput(); public native OPLandIplParvoParameters normaliseOutput(boolean normaliseOutput);
               public native float photoreceptorsLocalAdaptationSensitivity(); public native OPLandIplParvoParameters photoreceptorsLocalAdaptationSensitivity(float photoreceptorsLocalAdaptationSensitivity);
               public native float photoreceptorsTemporalConstant(); public native OPLandIplParvoParameters photoreceptorsTemporalConstant(float photoreceptorsTemporalConstant);
               public native float photoreceptorsSpatialConstant(); public native OPLandIplParvoParameters photoreceptorsSpatialConstant(float photoreceptorsSpatialConstant);
               public native float horizontalCellsGain(); public native OPLandIplParvoParameters horizontalCellsGain(float horizontalCellsGain);
               public native float hcellsTemporalConstant(); public native OPLandIplParvoParameters hcellsTemporalConstant(float hcellsTemporalConstant);
               public native float hcellsSpatialConstant(); public native OPLandIplParvoParameters hcellsSpatialConstant(float hcellsSpatialConstant);
               public native float ganglionCellsSensitivity(); public native OPLandIplParvoParameters ganglionCellsSensitivity(float ganglionCellsSensitivity);
        }
        /** Inner Plexiform Layer Magnocellular channel (IplMagno) */
        @NoOffset public static class IplMagnoParameters extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public IplMagnoParameters(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public IplMagnoParameters(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public IplMagnoParameters position(long position) {
                return (IplMagnoParameters)super.position(position);
            }
        
            public IplMagnoParameters() { super((Pointer)null); allocate(); }
            private native void allocate(); // default setup
            public native @Cast("bool") boolean normaliseOutput(); public native IplMagnoParameters normaliseOutput(boolean normaliseOutput);
            public native float parasolCells_beta(); public native IplMagnoParameters parasolCells_beta(float parasolCells_beta);
            public native float parasolCells_tau(); public native IplMagnoParameters parasolCells_tau(float parasolCells_tau);
            public native float parasolCells_k(); public native IplMagnoParameters parasolCells_k(float parasolCells_k);
            public native float amacrinCellsTemporalCutFrequency(); public native IplMagnoParameters amacrinCellsTemporalCutFrequency(float amacrinCellsTemporalCutFrequency);
            public native float V0CompressionParameter(); public native IplMagnoParameters V0CompressionParameter(float V0CompressionParameter);
            public native float localAdaptintegration_tau(); public native IplMagnoParameters localAdaptintegration_tau(float localAdaptintegration_tau);
            public native float localAdaptintegration_k(); public native IplMagnoParameters localAdaptintegration_k(float localAdaptintegration_k);
        }
        public native @ByRef OPLandIplParvoParameters OPLandIplParvo(); public native RetinaParameters OPLandIplParvo(OPLandIplParvoParameters OPLandIplParvo);
        public native @ByRef IplMagnoParameters IplMagno(); public native RetinaParameters IplMagno(IplMagnoParameters IplMagno);
    }



/** \brief class which allows the Gipsa/Listic Labs model to be used with OpenCV.
<p>
This retina model allows spatio-temporal image processing (applied on still images, video sequences).
As a summary, these are the retina model properties:
- It applies a spectral whithening (mid-frequency details enhancement)
- high frequency spatio-temporal noise reduction
- low frequency luminance to be reduced (luminance range compression)
- local logarithmic luminance compression allows details to be enhanced in low light conditions
<p>
USE : this model can be used basically for spatio-temporal video effects but also for :
     _using the getParvo method output matrix : texture analysiswith enhanced signal to noise ratio and enhanced details robust against input images luminance ranges
     _using the getMagno method output matrix : motion analysis also with the previously cited properties
<p>
for more information, reer to the following papers :
Benoit A., Caplier A., Durette B., Herault, J., "USING HUMAN VISUAL SYSTEM MODELING FOR BIO-INSPIRED LOW LEVEL IMAGE PROCESSING", Elsevier, Computer Vision and Image Understanding 114 (2010), pp. 758-773, DOI: http://dx.doi.org/10.1016/j.cviu.2010.01.011
Vision: Images, Signals and Neural Networks: Models of Neural Processing in Visual Perception (Progress in Neural Processing),By: Jeanny Herault, ISBN: 9814273686. WAPI (Tower ID): 113266891.
<p>
The retina filter includes the research contributions of phd/research collegues from which code has been redrawn by the author :
take a look at the retinacolor.hpp module to discover Brice Chaix de Lavarene color mosaicing/demosaicing and the reference paper:
B. Chaix de Lavarene, D. Alleysson, B. Durette, J. Herault (2007). "Efficient demosaicing through recursive filtering", IEEE International Conference on Image Processing ICIP 2007
take a look at imagelogpolprojection.hpp to discover retina spatial log sampling which originates from Barthelemy Durette phd with Jeanny Herault. A Retina / V1 cortex projection is also proposed and originates from Jeanny's discussions.
more informations in the above cited Jeanny Heraults's book.
 */
@Namespace("cv::bioinspired") public static class Retina extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Retina(Pointer p) { super(p); }


    
    /** \brief Retreive retina input buffer size
    @return the retina input buffer size
     */
    public native @ByVal Size getInputSize();

    /** \brief Retreive retina output buffer size that can be different from the input if a spatial log
    transformation is applied
    @return the retina output buffer size
     */
    public native @ByVal Size getOutputSize();

    /** \brief Try to open an XML retina parameters file to adjust current retina instance setup
    <p>
    - if the xml file does not exist, then default setup is applied
    - warning, Exceptions are thrown if read XML file is not valid
    @param retinaParameterFile the parameters filename
    @param applyDefaultSetupOnFailure set to true if an error must be thrown on error
    <p>
    You can retrieve the current parameters structure using the method Retina::getParameters and update
    it before running method Retina::setup.
     */
    public native void setup(@Str BytePointer retinaParameterFile/*=""*/, @Cast("const bool") boolean applyDefaultSetupOnFailure/*=true*/);
    public native void setup();
    public native void setup(@Str String retinaParameterFile/*=""*/, @Cast("const bool") boolean applyDefaultSetupOnFailure/*=true*/);

    /** \overload
    @param fs the open Filestorage which contains retina parameters
    @param applyDefaultSetupOnFailure set to true if an error must be thrown on error
    */
    public native void setup(@ByRef FileStorage fs, @Cast("const bool") boolean applyDefaultSetupOnFailure/*=true*/);
    public native void setup(@ByRef FileStorage fs);

    /** \overload
    @param newParameters a parameters structures updated with the new target configuration.
    */
    public native void setup(@ByVal RetinaParameters newParameters);

    /**
    @return the current parameters setup
    */
    public native @ByVal RetinaParameters getParameters();

    /** \brief Outputs a string showing the used parameters setup
    @return a string which contains formated parameters information
     */
    public native @Str BytePointer printSetup();

    /** \brief Write xml/yml formated parameters information
    @param fs the filename of the xml file that will be open and writen with formatted parameters
    information
     */
    public native void write( @Str BytePointer fs );
    public native void write( @Str String fs );

    /** \overload */
    public native void write( @ByRef FileStorage fs );

    /** \brief Setup the OPL and IPL parvo channels (see biologocal model)
    <p>
    OPL is referred as Outer Plexiform Layer of the retina, it allows the spatio-temporal filtering
    which withens the spectrum and reduces spatio-temporal noise while attenuating global luminance
    (low frequency energy) IPL parvo is the OPL next processing stage, it refers to a part of the
    Inner Plexiform layer of the retina, it allows high contours sensitivity in foveal vision. See
    reference papers for more informations.
    for more informations, please have a look at the paper Benoit A., Caplier A., Durette B., Herault, J., "USING HUMAN VISUAL SYSTEM MODELING FOR BIO-INSPIRED LOW LEVEL IMAGE PROCESSING", Elsevier, Computer Vision and Image Understanding 114 (2010), pp. 758-773, DOI: http://dx.doi.org/10.1016/j.cviu.2010.01.011
    @param colorMode specifies if (true) color is processed of not (false) to then processing gray
    level image
    @param normaliseOutput specifies if (true) output is rescaled between 0 and 255 of not (false)
    @param photoreceptorsLocalAdaptationSensitivity the photoreceptors sensitivity renage is 0-1
    (more log compression effect when value increases)
    @param photoreceptorsTemporalConstant the time constant of the first order low pass filter of
    the photoreceptors, use it to cut high temporal frequencies (noise or fast motion), unit is
    frames, typical value is 1 frame
    @param photoreceptorsSpatialConstant the spatial constant of the first order low pass filter of
    the photoreceptors, use it to cut high spatial frequencies (noise or thick contours), unit is
    pixels, typical value is 1 pixel
    @param horizontalCellsGain gain of the horizontal cells network, if 0, then the mean value of
    the output is zero, if the parameter is near 1, then, the luminance is not filtered and is
    still reachable at the output, typicall value is 0
    @param HcellsTemporalConstant the time constant of the first order low pass filter of the
    horizontal cells, use it to cut low temporal frequencies (local luminance variations), unit is
    frames, typical value is 1 frame, as the photoreceptors
    @param HcellsSpatialConstant the spatial constant of the first order low pass filter of the
    horizontal cells, use it to cut low spatial frequencies (local luminance), unit is pixels,
    typical value is 5 pixel, this value is also used for local contrast computing when computing
    the local contrast adaptation at the ganglion cells level (Inner Plexiform Layer parvocellular
    channel model)
    @param ganglionCellsSensitivity the compression strengh of the ganglion cells local adaptation
    output, set a value between 0.6 and 1 for best results, a high value increases more the low
    value sensitivity... and the output saturates faster, recommended value: 0.7
     */
    public native void setupOPLandIPLParvoChannel(@Cast("const bool") boolean colorMode/*=true*/, @Cast("const bool") boolean normaliseOutput/*=true*/, float photoreceptorsLocalAdaptationSensitivity/*=0.7f*/, float photoreceptorsTemporalConstant/*=0.5f*/, float photoreceptorsSpatialConstant/*=0.53f*/, float horizontalCellsGain/*=0.f*/, float HcellsTemporalConstant/*=1.f*/, float HcellsSpatialConstant/*=7.f*/, float ganglionCellsSensitivity/*=0.7f*/);
    public native void setupOPLandIPLParvoChannel();

    /** \brief Set parameters values for the Inner Plexiform Layer (IPL) magnocellular channel
    <p>
    this channel processes signals output from OPL processing stage in peripheral vision, it allows
    motion information enhancement. It is decorrelated from the details channel. See reference
    papers for more details.
    <p>
    @param normaliseOutput specifies if (true) output is rescaled between 0 and 255 of not (false)
    @param parasolCells_beta the low pass filter gain used for local contrast adaptation at the
    IPL level of the retina (for ganglion cells local adaptation), typical value is 0
    @param parasolCells_tau the low pass filter time constant used for local contrast adaptation
    at the IPL level of the retina (for ganglion cells local adaptation), unit is frame, typical
    value is 0 (immediate response)
    @param parasolCells_k the low pass filter spatial constant used for local contrast adaptation
    at the IPL level of the retina (for ganglion cells local adaptation), unit is pixels, typical
    value is 5
    @param amacrinCellsTemporalCutFrequency the time constant of the first order high pass fiter of
    the magnocellular way (motion information channel), unit is frames, typical value is 1.2
    @param V0CompressionParameter the compression strengh of the ganglion cells local adaptation
    output, set a value between 0.6 and 1 for best results, a high value increases more the low
    value sensitivity... and the output saturates faster, recommended value: 0.95
    @param localAdaptintegration_tau specifies the temporal constant of the low pas filter
    involved in the computation of the local "motion mean" for the local adaptation computation
    @param localAdaptintegration_k specifies the spatial constant of the low pas filter involved
    in the computation of the local "motion mean" for the local adaptation computation
     */
    public native void setupIPLMagnoChannel(@Cast("const bool") boolean normaliseOutput/*=true*/, float parasolCells_beta/*=0.f*/, float parasolCells_tau/*=0.f*/, float parasolCells_k/*=7.f*/, float amacrinCellsTemporalCutFrequency/*=1.2f*/, float V0CompressionParameter/*=0.95f*/, float localAdaptintegration_tau/*=0.f*/, float localAdaptintegration_k/*=7.f*/);
    public native void setupIPLMagnoChannel();

    /** \brief Method which allows retina to be applied on an input image,
    <p>
    after run, encapsulated retina module is ready to deliver its outputs using dedicated
    acccessors, see getParvo and getMagno methods
    @param inputImage the input Mat image to be processed, can be gray level or BGR coded in any
    format (from 8bit to 16bits)
     */
    public native void run(@ByVal Mat inputImage);
    public native void run(@ByVal UMat inputImage);
    public native void run(@ByVal GpuMat inputImage);

    /** \brief Method which processes an image in the aim to correct its luminance correct
    backlight problems, enhance details in shadows.
    <p>
    This method is designed to perform High Dynamic Range image tone mapping (compress \>8bit/pixel
    images to 8bit/pixel). This is a simplified version of the Retina Parvocellular model
    (simplified version of the run/getParvo methods call) since it does not include the
    spatio-temporal filter modelling the Outer Plexiform Layer of the retina that performs spectral
    whitening and many other stuff. However, it works great for tone mapping and in a faster way.
    <p>
    Check the demos and experiments section to see examples and the way to perform tone mapping
    using the original retina model and the method.
    <p>
    @param inputImage the input image to process (should be coded in float format : CV_32F,
    CV_32FC1, CV_32F_C3, CV_32F_C4, the 4th channel won't be considered).
    @param outputToneMappedImage the output 8bit/channel tone mapped image (CV_8U or CV_8UC3 format).
     */
    public native void applyFastToneMapping(@ByVal Mat inputImage, @ByVal Mat outputToneMappedImage);
    public native void applyFastToneMapping(@ByVal UMat inputImage, @ByVal UMat outputToneMappedImage);
    public native void applyFastToneMapping(@ByVal GpuMat inputImage, @ByVal GpuMat outputToneMappedImage);

    /** \brief Accessor of the details channel of the retina (models foveal vision).
    <p>
    Warning, getParvoRAW methods return buffers that are not rescaled within range [0;255] while
    the non RAW method allows a normalized matrix to be retrieved.
    <p>
    @param retinaOutput_parvo the output buffer (reallocated if necessary), format can be :
    -   a Mat, this output is rescaled for standard 8bits image processing use in OpenCV
    -   RAW methods actually return a 1D matrix (encoding is R1, R2, ... Rn, G1, G2, ..., Gn, B1,
    B2, ...Bn), this output is the original retina filter model output, without any
    quantification or rescaling.
    @see getParvoRAW
     */
    public native void getParvo(@ByVal Mat retinaOutput_parvo);
    public native void getParvo(@ByVal UMat retinaOutput_parvo);
    public native void getParvo(@ByVal GpuMat retinaOutput_parvo);

    /** \brief Accessor of the details channel of the retina (models foveal vision).
    @see getParvo
     */
    public native void getParvoRAW(@ByVal Mat retinaOutput_parvo);
    public native void getParvoRAW(@ByVal UMat retinaOutput_parvo);
    public native void getParvoRAW(@ByVal GpuMat retinaOutput_parvo);

    /** \brief Accessor of the motion channel of the retina (models peripheral vision).
    <p>
    Warning, getMagnoRAW methods return buffers that are not rescaled within range [0;255] while
    the non RAW method allows a normalized matrix to be retrieved.
    @param retinaOutput_magno the output buffer (reallocated if necessary), format can be :
    -   a Mat, this output is rescaled for standard 8bits image processing use in OpenCV
    -   RAW methods actually return a 1D matrix (encoding is M1, M2,... Mn), this output is the
    original retina filter model output, without any quantification or rescaling.
    @see getMagnoRAW
     */
    public native void getMagno(@ByVal Mat retinaOutput_magno);
    public native void getMagno(@ByVal UMat retinaOutput_magno);
    public native void getMagno(@ByVal GpuMat retinaOutput_magno);

    /** \brief Accessor of the motion channel of the retina (models peripheral vision).
    @see getMagno
     */
    public native void getMagnoRAW(@ByVal Mat retinaOutput_magno);
    public native void getMagnoRAW(@ByVal UMat retinaOutput_magno);
    public native void getMagnoRAW(@ByVal GpuMat retinaOutput_magno);

    /** \overload */
    public native @Const @ByVal Mat getMagnoRAW();
    /** \overload */
    public native @Const @ByVal Mat getParvoRAW();

    /** \brief Activate color saturation as the final step of the color demultiplexing process -\> this
    saturation is a sigmoide function applied to each channel of the demultiplexed image.
    @param saturateColors boolean that activates color saturation (if true) or desactivate (if false)
    @param colorSaturationValue the saturation factor : a simple factor applied on the chrominance
    buffers
     */
    public native void setColorSaturation(@Cast("const bool") boolean saturateColors/*=true*/, float colorSaturationValue/*=4.0f*/);
    public native void setColorSaturation();

    /** \brief Clears all retina buffers
    <p>
    (equivalent to opening the eyes after a long period of eye close ;o) whatchout the temporal
    transition occuring just after this method call.
     */
    public native void clearBuffers();

    /** \brief Activate/desactivate the Magnocellular pathway processing (motion information extraction), by
    default, it is activated
    @param activate true if Magnocellular output should be activated, false if not... if activated,
    the Magnocellular output can be retrieved using the **getMagno** methods
     */
    public native void activateMovingContoursProcessing(@Cast("const bool") boolean activate);

    /** \brief Activate/desactivate the Parvocellular pathway processing (contours information extraction), by
    default, it is activated
    @param activate true if Parvocellular (contours information extraction) output should be
    activated, false if not... if activated, the Parvocellular output can be retrieved using the
    Retina::getParvo methods
     */
    public native void activateContoursProcessing(@Cast("const bool") boolean activate);

    /** \overload */
    public static native @Ptr Retina create(@ByVal Size inputSize);
    /** \brief Constructors from standardized interfaces : retreive a smart pointer to a Retina instance
    <p>
    @param inputSize the input frame size
    @param colorMode the chosen processing mode : with or without color processing
    @param colorSamplingMethod specifies which kind of color sampling will be used :
    -   cv::bioinspired::RETINA_COLOR_RANDOM: each pixel position is either R, G or B in a random choice
    -   cv::bioinspired::RETINA_COLOR_DIAGONAL: color sampling is RGBRGBRGB..., line 2 BRGBRGBRG..., line 3, GBRGBRGBR...
    -   cv::bioinspired::RETINA_COLOR_BAYER: standard bayer sampling
    @param useRetinaLogSampling activate retina log sampling, if true, the 2 following parameters can
    be used
    @param reductionFactor only usefull if param useRetinaLogSampling=true, specifies the reduction
    factor of the output frame (as the center (fovea) is high resolution and corners can be
    underscaled, then a reduction of the output is allowed without precision leak
    @param samplingStrenght only usefull if param useRetinaLogSampling=true, specifies the strenght of
    the log scale that is applied
     */
    public static native @Ptr Retina create(@ByVal Size inputSize, @Cast("const bool") boolean colorMode,
                                               int colorSamplingMethod/*=cv::bioinspired::RETINA_COLOR_BAYER*/,
                                               @Cast("const bool") boolean useRetinaLogSampling/*=false*/,
                                               float reductionFactor/*=1.0f*/, float samplingStrenght/*=10.0f*/);
    public static native @Ptr Retina create(@ByVal Size inputSize, @Cast("const bool") boolean colorMode);
}

/** \} */



// #endif /* __OPENCV_BIOINSPIRED_RETINA_HPP__ */


// Parsed from opencv2/bioinspired/retinafasttonemapping.hpp


/*#******************************************************************************
 ** IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
 **
 ** By downloading, copying, installing or using the software you agree to this license.
 ** If you do not agree to this license, do not download, install,
 ** copy or use the software.
 **
 **
 ** bioinspired : interfaces allowing OpenCV users to integrate Human Vision System models. Presented models originate from Jeanny Herault's original research and have been reused and adapted by the author&collaborators for computed vision applications since his thesis with Alice Caplier at Gipsa-Lab.
 **
 ** Maintainers : Listic lab (code author current affiliation & applications) and Gipsa Lab (original research origins & applications)
 **
 **  Creation - enhancement process 2007-2013
 **      Author: Alexandre Benoit (benoit.alexandre.vision@gmail.com), LISTIC lab, Annecy le vieux, France
 **
 ** Theses algorithm have been developped by Alexandre BENOIT since his thesis with Alice Caplier at Gipsa-Lab (www.gipsa-lab.inpg.fr) and the research he pursues at LISTIC Lab (www.listic.univ-savoie.fr).
 ** Refer to the following research paper for more information:
 ** Benoit A., Caplier A., Durette B., Herault, J., "USING HUMAN VISUAL SYSTEM MODELING FOR BIO-INSPIRED LOW LEVEL IMAGE PROCESSING", Elsevier, Computer Vision and Image Understanding 114 (2010), pp. 758-773, DOI: http://dx.doi.org/10.1016/j.cviu.2010.01.011
 ** This work have been carried out thanks to Jeanny Herault who's research and great discussions are the basis of all this work, please take a look at his book:
 ** Vision: Images, Signals and Neural Networks: Models of Neural Processing in Visual Perception (Progress in Neural Processing),By: Jeanny Herault, ISBN: 9814273686. WAPI (Tower ID): 113266891.
 **
 **
 **
 **
 **
 ** This class is based on image processing tools of the author and already used within the Retina class (this is the same code as method retina::applyFastToneMapping, but in an independent class, it is ligth from a memory requirement point of view). It implements an adaptation of the efficient tone mapping algorithm propose by David Alleyson, Sabine Susstruck and Laurence Meylan's work, please cite:
 ** -> Meylan L., Alleysson D., and Susstrunk S., A Model of Retinal Local Adaptation for the Tone Mapping of Color Filter Array Images, Journal of Optical Society of America, A, Vol. 24, N 9, September, 1st, 2007, pp. 2807-2816
 **
 **
 **                          License Agreement
 **               For Open Source Computer Vision Library
 **
 ** Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
 ** Copyright (C) 2008-2011, Willow Garage Inc., all rights reserved.
 **
 **               For Human Visual System tools (bioinspired)
 ** Copyright (C) 2007-2011, LISTIC Lab, Annecy le Vieux and GIPSA Lab, Grenoble, France, all rights reserved.
 **
 ** Third party copyrights are property of their respective owners.
 **
 ** Redistribution and use in source and binary forms, with or without modification,
 ** are permitted provided that the following conditions are met:
 **
 ** * Redistributions of source code must retain the above copyright notice,
 **    this list of conditions and the following disclaimer.
 **
 ** * Redistributions in binary form must reproduce the above copyright notice,
 **    this list of conditions and the following disclaimer in the documentation
 **    and/or other materials provided with the distribution.
 **
 ** * The name of the copyright holders may not be used to endorse or promote products
 **    derived from this software without specific prior written permission.
 **
 ** This software is provided by the copyright holders and contributors "as is" and
 ** any express or implied warranties, including, but not limited to, the implied
 ** warranties of merchantability and fitness for a particular purpose are disclaimed.
 ** In no event shall the Intel Corporation or contributors be liable for any direct,
 ** indirect, incidental, special, exemplary, or consequential damages
 ** (including, but not limited to, procurement of substitute goods or services;
 ** loss of use, data, or profits; or business interruption) however caused
 ** and on any theory of liability, whether in contract, strict liability,
 ** or tort (including negligence or otherwise) arising in any way out of
 ** the use of this software, even if advised of the possibility of such damage.
 *******************************************************************************/

// #ifndef __OPENCV_BIOINSPIRED_RETINAFASTTONEMAPPING_HPP__
// #define __OPENCV_BIOINSPIRED_RETINAFASTTONEMAPPING_HPP__

/**
\file
\date May 26, 2013
@author Alexandre Benoit
 */

// #include "opencv2/core.hpp" // for all OpenCV core functionalities access, including cv::Exception support

/** \addtogroup bioinspired
 *  \{
<p>
/** \brief  a wrapper class which allows the tone mapping algorithm of Meylan&al(2007) to be used with OpenCV.
<p>
This algorithm is already implemented in thre Retina class (retina::applyFastToneMapping) but used it does not require all the retina model to be allocated. This allows a light memory use for low memory devices (smartphones, etc.
As a summary, these are the model properties:
- 2 stages of local luminance adaptation with a different local neighborhood for each.
- first stage models the retina photorecetors local luminance adaptation
- second stage models th ganglion cells local information adaptation
- compared to the initial publication, this class uses spatio-temporal low pass filters instead of spatial only filters.
  this can help noise robustness and temporal stability for video sequence use cases.
<p>
for more information, read to the following papers :
Meylan L., Alleysson D., and Susstrunk S., A Model of Retinal Local Adaptation for the Tone Mapping of Color Filter Array Images, Journal of Optical Society of America, A, Vol. 24, N 9, September, 1st, 2007, pp. 2807-2816Benoit A., Caplier A., Durette B., Herault, J., "USING HUMAN VISUAL SYSTEM MODELING FOR BIO-INSPIRED LOW LEVEL IMAGE PROCESSING", Elsevier, Computer Vision and Image Understanding 114 (2010), pp. 758-773, DOI: http://dx.doi.org/10.1016/j.cviu.2010.01.011
regarding spatio-temporal filter and the bigger retina model :
Vision: Images, Signals and Neural Networks: Models of Neural Processing in Visual Perception (Progress in Neural Processing),By: Jeanny Herault, ISBN: 9814273686. WAPI (Tower ID): 113266891.
*/
@Namespace("cv::bioinspired") public static class RetinaFastToneMapping extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RetinaFastToneMapping(Pointer p) { super(p); }


    /** \brief applies a luminance correction (initially High Dynamic Range (HDR) tone mapping)
    <p>
    using only the 2 local adaptation stages of the retina parvocellular channel : photoreceptors
    level and ganlion cells level. Spatio temporal filtering is applied but limited to temporal
    smoothing and eventually high frequencies attenuation. This is a lighter method than the one
    available using the regular retina::run method. It is then faster but it does not include
    complete temporal filtering nor retina spectral whitening. Then, it can have a more limited
    effect on images with a very high dynamic range. This is an adptation of the original still
    image HDR tone mapping algorithm of David Alleyson, Sabine Susstruck and Laurence Meylan's
    work, please cite: -> Meylan L., Alleysson D., and Susstrunk S., A Model of Retinal Local
    Adaptation for the Tone Mapping of Color Filter Array Images, Journal of Optical Society of
    America, A, Vol. 24, N 9, September, 1st, 2007, pp. 2807-2816
    <p>
    @param inputImage the input image to process RGB or gray levels
    @param outputToneMappedImage the output tone mapped image
    */
    public native void applyFastToneMapping(@ByVal Mat inputImage, @ByVal Mat outputToneMappedImage);
    public native void applyFastToneMapping(@ByVal UMat inputImage, @ByVal UMat outputToneMappedImage);
    public native void applyFastToneMapping(@ByVal GpuMat inputImage, @ByVal GpuMat outputToneMappedImage);

    /** \brief updates tone mapping behaviors by adjusing the local luminance computation area
    <p>
    @param photoreceptorsNeighborhoodRadius the first stage local adaptation area
    @param ganglioncellsNeighborhoodRadius the second stage local adaptation area
    @param meanLuminanceModulatorK the factor applied to modulate the meanLuminance information
    (default is 1, see reference paper)
     */
    public native void setup(float photoreceptorsNeighborhoodRadius/*=3.f*/, float ganglioncellsNeighborhoodRadius/*=1.f*/, float meanLuminanceModulatorK/*=1.f*/);
    public native void setup();

    public static native @Ptr RetinaFastToneMapping create(@ByVal Size inputSize);
}


/** \} */



// #endif /* __OPENCV_BIOINSPIRED_RETINAFASTTONEMAPPING_HPP__ */


// Parsed from opencv2/bioinspired/transientareassegmentationmodule.hpp

/*#******************************************************************************
 ** IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
 **
 ** By downloading, copying, installing or using the software you agree to this license.
 ** If you do not agree to this license, do not download, install,
 ** copy or use the software.
 **
 **
 ** bioinspired : interfaces allowing OpenCV users to integrate Human Vision System models.
 ** TransientAreasSegmentationModule Use: extract areas that present spatio-temporal changes.
 ** => It should be used at the output of the cv::bioinspired::Retina::getMagnoRAW() output that enhances spatio-temporal changes
 **
 ** Maintainers : Listic lab (code author current affiliation & applications)
 **
 **  Creation - enhancement process 2007-2015
 **      Author: Alexandre Benoit (benoit.alexandre.vision@gmail.com), LISTIC lab, Annecy le vieux, France
 **
 ** Theses algorithm have been developped by Alexandre BENOIT since his thesis with Alice Caplier at Gipsa-Lab (www.gipsa-lab.inpg.fr) and the research he pursues at LISTIC Lab (www.listic.univ-savoie.fr).
 ** Refer to the following research paper for more information:
 ** Strat, S.T.; Benoit, A.; Lambert, P., "Retina enhanced bag of words descriptors for video classification," Signal Processing Conference (EUSIPCO), 2014 Proceedings of the 22nd European , vol., no., pp.1307,1311, 1-5 Sept. 2014 (http://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=6952461&isnumber=6951911)
 ** Benoit A., Caplier A., Durette B., Herault, J., "USING HUMAN VISUAL SYSTEM MODELING FOR BIO-INSPIRED LOW LEVEL IMAGE PROCESSING", Elsevier, Computer Vision and Image Understanding 114 (2010), pp. 758-773, DOI: http://dx.doi.org/10.1016/j.cviu.2010.01.011
 ** This work have been carried out thanks to Jeanny Herault who's research and great discussions are the basis of all this work, please take a look at his book:
 ** Vision: Images, Signals and Neural Networks: Models of Neural Processing in Visual Perception (Progress in Neural Processing),By: Jeanny Herault, ISBN: 9814273686. WAPI (Tower ID): 113266891.
 **
 **
 **                          License Agreement
 **               For Open Source Computer Vision Library
 **
 ** Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
 ** Copyright (C) 2008-2011, Willow Garage Inc., all rights reserved.
 **
 **               For Human Visual System tools (bioinspired)
 ** Copyright (C) 2007-2015, LISTIC Lab, Annecy le Vieux and GIPSA Lab, Grenoble, France, all rights reserved.
 **
 ** Third party copyrights are property of their respective owners.
 **
 ** Redistribution and use in source and binary forms, with or without modification,
 ** are permitted provided that the following conditions are met:
 **
 ** * Redistributions of source code must retain the above copyright notice,
 **    this list of conditions and the following disclaimer.
 **
 ** * Redistributions in binary form must reproduce the above copyright notice,
 **    this list of conditions and the following disclaimer in the documentation
 **    and/or other materials provided with the distribution.
 **
 ** * The name of the copyright holders may not be used to endorse or promote products
 **    derived from this software without specific prior written permission.
 **
 ** This software is provided by the copyright holders and contributors "as is" and
 ** any express or implied warranties, including, but not limited to, the implied
 ** warranties of merchantability and fitness for a particular purpose are disclaimed.
 ** In no event shall the Intel Corporation or contributors be liable for any direct,
 ** indirect, incidental, special, exemplary, or consequential damages
 ** (including, but not limited to, procurement of substitute goods or services;
 ** loss of use, data, or profits; or business interruption) however caused
 ** and on any theory of liability, whether in contract, strict liability,
 ** or tort (including negligence or otherwise) arising in any way out of
 ** the use of this software, even if advised of the possibility of such damage.
 *******************************************************************************/

// #ifndef SEGMENTATIONMODULE_HPP_
// #define SEGMENTATIONMODULE_HPP_

/**
\file
\date 2007-2013
@author Alexandre BENOIT, benoit.alexandre.vision\gmail.com
*/

// #include "opencv2/core.hpp" // for all OpenCV core functionalities access, including cv::Exception support
/** \addtogroup bioinspired
 *  \{
<p>
/** \brief parameter structure that stores the transient events detector setup parameters
*/
@Namespace("cv::bioinspired") @NoOffset public static class SegmentationParameters extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SegmentationParameters(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public SegmentationParameters(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public SegmentationParameters position(long position) {
        return (SegmentationParameters)super.position(position);
    }
 // CV_EXPORTS_W_MAP to export to python native dictionnaries
	// default structure instance construction with default values	
	public SegmentationParameters() { super((Pointer)null); allocate(); }
	private native void allocate();
	// all properties list
	public native float thresholdON(); public native SegmentationParameters thresholdON(float thresholdON);
	public native float thresholdOFF(); public native SegmentationParameters thresholdOFF(float thresholdOFF);
	/** the time constant of the first order low pass filter, use it to cut high temporal frequencies (noise or fast motion), unit is frames, typical value is 0.5 frame */
	public native float localEnergy_temporalConstant(); public native SegmentationParameters localEnergy_temporalConstant(float localEnergy_temporalConstant);
	/** the spatial constant of the first order low pass filter, use it to cut high spatial frequencies (noise or thick contours), unit is pixels, typical value is 5 pixel */
	public native float localEnergy_spatialConstant(); public native SegmentationParameters localEnergy_spatialConstant(float localEnergy_spatialConstant);
	/** local neighborhood energy filtering parameters : the aim is to get information about the energy neighborhood to perform a center surround energy analysis */
	public native float neighborhoodEnergy_temporalConstant(); public native SegmentationParameters neighborhoodEnergy_temporalConstant(float neighborhoodEnergy_temporalConstant);
	public native float neighborhoodEnergy_spatialConstant(); public native SegmentationParameters neighborhoodEnergy_spatialConstant(float neighborhoodEnergy_spatialConstant);
	/** context neighborhood energy filtering parameters : the aim is to get information about the energy on a wide neighborhood area to filtered out local effects */
	public native float contextEnergy_temporalConstant(); public native SegmentationParameters contextEnergy_temporalConstant(float contextEnergy_temporalConstant);
	public native float contextEnergy_spatialConstant(); public native SegmentationParameters contextEnergy_spatialConstant(float contextEnergy_spatialConstant);
}

/** \brief class which provides a transient/moving areas segmentation module
<p>
perform a locally adapted segmentation by using the retina magno input data Based on Alexandre
BENOIT thesis: "Le système visuel humain au secours de la vision par ordinateur"
<p>
3 spatio temporal filters are used:
- a first one which filters the noise and local variations of the input motion energy
- a second (more powerfull low pass spatial filter) which gives the neighborhood motion energy the
segmentation consists in the comparison of these both outputs, if the local motion energy is higher
to the neighborhood otion energy, then the area is considered as moving and is segmented
- a stronger third low pass filter helps decision by providing a smooth information about the
"motion context" in a wider area
 */

@Namespace("cv::bioinspired") public static class TransientAreasSegmentationModule extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TransientAreasSegmentationModule(Pointer p) { super(p); }



    /** \brief return the sze of the manage input and output images
    */
    public native @ByVal Size getSize();

    /** \brief try to open an XML segmentation parameters file to adjust current segmentation instance setup
    <p>
    - if the xml file does not exist, then default setup is applied
    - warning, Exceptions are thrown if read XML file is not valid
    @param segmentationParameterFile : the parameters filename
    @param applyDefaultSetupOnFailure : set to true if an error must be thrown on error
     */
    public native void setup(@Str BytePointer segmentationParameterFile/*=""*/, @Cast("const bool") boolean applyDefaultSetupOnFailure/*=true*/);
    public native void setup();
    public native void setup(@Str String segmentationParameterFile/*=""*/, @Cast("const bool") boolean applyDefaultSetupOnFailure/*=true*/);

    /** \brief try to open an XML segmentation parameters file to adjust current segmentation instance setup
    <p>
    - if the xml file does not exist, then default setup is applied
    - warning, Exceptions are thrown if read XML file is not valid
    @param fs : the open Filestorage which contains segmentation parameters
    @param applyDefaultSetupOnFailure : set to true if an error must be thrown on error
    */
    public native void setup(@ByRef FileStorage fs, @Cast("const bool") boolean applyDefaultSetupOnFailure/*=true*/);
    public native void setup(@ByRef FileStorage fs);

    /** \brief try to open an XML segmentation parameters file to adjust current segmentation instance setup
    <p>
    - if the xml file does not exist, then default setup is applied
    - warning, Exceptions are thrown if read XML file is not valid
    @param newParameters : a parameters structures updated with the new target configuration
     */
    public native void setup(@ByVal SegmentationParameters newParameters);

    /** \brief return the current parameters setup
    */
    public native @ByVal SegmentationParameters getParameters();

    /** \brief parameters setup display method
    @return a string which contains formatted parameters information
    */
    public native @Str BytePointer printSetup();

    /** \brief write xml/yml formated parameters information
    @param fs : the filename of the xml file that will be open and writen with formatted parameters information
    */
    public native void write( @Str BytePointer fs );
    public native void write( @Str String fs );

    /** \brief write xml/yml formated parameters information
    @param fs : a cv::Filestorage object ready to be filled
    */
    public native void write( @ByRef FileStorage fs );

    /** \brief main processing method, get result using methods getSegmentationPicture()
    @param inputToSegment : the image to process, it must match the instance buffer size !
    @param channelIndex : the channel to process in case of multichannel images
    */
    public native void run(@ByVal Mat inputToSegment, int channelIndex/*=0*/);
    public native void run(@ByVal Mat inputToSegment);
    public native void run(@ByVal UMat inputToSegment, int channelIndex/*=0*/);
    public native void run(@ByVal UMat inputToSegment);
    public native void run(@ByVal GpuMat inputToSegment, int channelIndex/*=0*/);
    public native void run(@ByVal GpuMat inputToSegment);

    /** \brief access function
    @return the last segmentation result: a boolean picture which is resampled between 0 and 255 for a display purpose
   */
    public native void getSegmentationPicture(@ByVal Mat transientAreas);
    public native void getSegmentationPicture(@ByVal UMat transientAreas);
    public native void getSegmentationPicture(@ByVal GpuMat transientAreas);

    /** \brief cleans all the buffers of the instance
    */
    public native void clearAllBuffers();

    /** \brief allocator
    @param inputSize : size of the images input to segment (output will be the same size)
     */
    public static native @Ptr TransientAreasSegmentationModule create(@ByVal Size inputSize);
}

/** \} */

 // namespaces end : cv and bioinspired


// #endif




}
