// Targeted by JavaCPP version 1.4: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.opencv_core.*;
import static org.bytedeco.javacpp.opencv_imgproc.*;
import static org.bytedeco.javacpp.opencv_imgcodecs.*;
import static org.bytedeco.javacpp.opencv_videoio.*;
import static org.bytedeco.javacpp.opencv_highgui.*;
import static org.bytedeco.javacpp.opencv_flann.*;
import static org.bytedeco.javacpp.opencv_ml.*;
import static org.bytedeco.javacpp.opencv_features2d.*;
import static org.bytedeco.javacpp.opencv_calib3d.*;
import static org.bytedeco.javacpp.opencv_ximgproc.*;
import static org.bytedeco.javacpp.opencv_video.*;

public class opencv_optflow extends org.bytedeco.javacpp.presets.opencv_optflow {
    static { Loader.load(); }

// Parsed from <opencv2/optflow.hpp>

/*
By downloading, copying, installing or using the software you agree to this
license. If you do not agree to this license, do not download, install,
copy or use the software.


                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)

Copyright (C) 2013, OpenCV Foundation, all rights reserved.
Third party copyrights are property of their respective owners.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are
disclaimed. In no event shall copyright holders or contributors be liable for
any direct, indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.
*/

// #ifndef __OPENCV_OPTFLOW_HPP__
// #define __OPENCV_OPTFLOW_HPP__

// #include "opencv2/core.hpp"
// #include "opencv2/video.hpp"

/**
\defgroup optflow Optical Flow Algorithms
<p>
Dense optical flow algorithms compute motion for each point:
<p>
- cv::optflow::calcOpticalFlowSF
- cv::optflow::createOptFlow_DeepFlow
<p>
Motion templates is alternative technique for detecting motion and computing its direction.
See samples/motempl.py.
<p>
- cv::motempl::updateMotionHistory
- cv::motempl::calcMotionGradient
- cv::motempl::calcGlobalOrientation
- cv::motempl::segmentMotion
<p>
Functions reading and writing .flo files in "Middlebury" format, see: <http://vision.middlebury.edu/flow/code/flow-code/README.txt>
<p>
- cv::optflow::readOpticalFlow
- cv::optflow::writeOpticalFlow
 <p>
 */

// #include "opencv2/optflow/pcaflow.hpp"
// #include "opencv2/optflow/sparse_matching_gpc.hpp"
    
/** \addtogroup optflow
 *  \{
<p>
/** \overload */
@Namespace("cv::optflow") public static native void calcOpticalFlowSF( @ByVal Mat from, @ByVal Mat to, @ByVal Mat flow,
                                     int layers, int averaging_block_size, int max_flow);
@Namespace("cv::optflow") public static native void calcOpticalFlowSF( @ByVal UMat from, @ByVal UMat to, @ByVal UMat flow,
                                     int layers, int averaging_block_size, int max_flow);
@Namespace("cv::optflow") public static native void calcOpticalFlowSF( @ByVal GpuMat from, @ByVal GpuMat to, @ByVal GpuMat flow,
                                     int layers, int averaging_block_size, int max_flow);

/** \brief Calculate an optical flow using "SimpleFlow" algorithm.
<p>
@param from First 8-bit 3-channel image.
@param to Second 8-bit 3-channel image of the same size as prev
@param flow computed flow image that has the same size as prev and type CV_32FC2
@param layers Number of layers
@param averaging_block_size Size of block through which we sum up when calculate cost function
for pixel
@param max_flow maximal flow that we search at each level
@param sigma_dist vector smooth spatial sigma parameter
@param sigma_color vector smooth color sigma parameter
@param postprocess_window window size for postprocess cross bilateral filter
@param sigma_dist_fix spatial sigma for postprocess cross bilateralf filter
@param sigma_color_fix color sigma for postprocess cross bilateral filter
@param occ_thr threshold for detecting occlusions
@param upscale_averaging_radius window size for bilateral upscale operation
@param upscale_sigma_dist spatial sigma for bilateral upscale operation
@param upscale_sigma_color color sigma for bilateral upscale operation
@param speed_up_thr threshold to detect point with irregular flow - where flow should be
recalculated after upscale
<p>
See \cite Tao2012 . And site of project - <http://graphics.berkeley.edu/papers/Tao-SAN-2012-05/>.
<p>
\note
   -   An example using the simpleFlow algorithm can be found at samples/simpleflow_demo.cpp
 */
@Namespace("cv::optflow") public static native void calcOpticalFlowSF( @ByVal Mat from, @ByVal Mat to, @ByVal Mat flow, int layers,
                                     int averaging_block_size, int max_flow,
                                     double sigma_dist, double sigma_color, int postprocess_window,
                                     double sigma_dist_fix, double sigma_color_fix, double occ_thr,
                                     int upscale_averaging_radius, double upscale_sigma_dist,
                                     double upscale_sigma_color, double speed_up_thr );
@Namespace("cv::optflow") public static native void calcOpticalFlowSF( @ByVal UMat from, @ByVal UMat to, @ByVal UMat flow, int layers,
                                     int averaging_block_size, int max_flow,
                                     double sigma_dist, double sigma_color, int postprocess_window,
                                     double sigma_dist_fix, double sigma_color_fix, double occ_thr,
                                     int upscale_averaging_radius, double upscale_sigma_dist,
                                     double upscale_sigma_color, double speed_up_thr );
@Namespace("cv::optflow") public static native void calcOpticalFlowSF( @ByVal GpuMat from, @ByVal GpuMat to, @ByVal GpuMat flow, int layers,
                                     int averaging_block_size, int max_flow,
                                     double sigma_dist, double sigma_color, int postprocess_window,
                                     double sigma_dist_fix, double sigma_color_fix, double occ_thr,
                                     int upscale_averaging_radius, double upscale_sigma_dist,
                                     double upscale_sigma_color, double speed_up_thr );

/** \brief Fast dense optical flow based on PyrLK sparse matches interpolation.
<p>
@param from first 8-bit 3-channel or 1-channel image.
@param to  second 8-bit 3-channel or 1-channel image of the same size as from
@param flow computed flow image that has the same size as from and CV_32FC2 type
@param grid_step stride used in sparse match computation. Lower values usually
       result in higher quality but slow down the algorithm.
@param k number of nearest-neighbor matches considered, when fitting a locally affine
       model. Lower values can make the algorithm noticeably faster at the cost of
       some quality degradation.
@param sigma parameter defining how fast the weights decrease in the locally-weighted affine
       fitting. Higher values can help preserve fine details, lower values can help to get rid
       of the noise in the output flow.
@param use_post_proc defines whether the ximgproc::fastGlobalSmootherFilter() is used
       for post-processing after interpolation
@param fgs_lambda see the respective parameter of the ximgproc::fastGlobalSmootherFilter()
@param fgs_sigma  see the respective parameter of the ximgproc::fastGlobalSmootherFilter()
 */
@Namespace("cv::optflow") public static native void calcOpticalFlowSparseToDense( @ByVal Mat from, @ByVal Mat to, @ByVal Mat flow,
                                                 int grid_step/*=8*/, int k/*=128*/, float sigma/*=0.05f*/,
                                                 @Cast("bool") boolean use_post_proc/*=true*/, float fgs_lambda/*=500.0f*/,
                                                 float fgs_sigma/*=1.5f*/ );
@Namespace("cv::optflow") public static native void calcOpticalFlowSparseToDense( @ByVal Mat from, @ByVal Mat to, @ByVal Mat flow );
@Namespace("cv::optflow") public static native void calcOpticalFlowSparseToDense( @ByVal UMat from, @ByVal UMat to, @ByVal UMat flow,
                                                 int grid_step/*=8*/, int k/*=128*/, float sigma/*=0.05f*/,
                                                 @Cast("bool") boolean use_post_proc/*=true*/, float fgs_lambda/*=500.0f*/,
                                                 float fgs_sigma/*=1.5f*/ );
@Namespace("cv::optflow") public static native void calcOpticalFlowSparseToDense( @ByVal UMat from, @ByVal UMat to, @ByVal UMat flow );
@Namespace("cv::optflow") public static native void calcOpticalFlowSparseToDense( @ByVal GpuMat from, @ByVal GpuMat to, @ByVal GpuMat flow,
                                                 int grid_step/*=8*/, int k/*=128*/, float sigma/*=0.05f*/,
                                                 @Cast("bool") boolean use_post_proc/*=true*/, float fgs_lambda/*=500.0f*/,
                                                 float fgs_sigma/*=1.5f*/ );
@Namespace("cv::optflow") public static native void calcOpticalFlowSparseToDense( @ByVal GpuMat from, @ByVal GpuMat to, @ByVal GpuMat flow );

/** \brief Read a .flo file
<p>
@param path Path to the file to be loaded
<p>
The function readOpticalFlow loads a flow field from a file and returns it as a single matrix.
Resulting Mat has a type CV_32FC2 - floating-point, 2-channel. First channel corresponds to the
flow in the horizontal direction (u), second - vertical (v).
 */
@Namespace("cv::optflow") public static native @ByVal Mat readOpticalFlow( @Str BytePointer path );
@Namespace("cv::optflow") public static native @ByVal Mat readOpticalFlow( @Str String path );
/** \brief Write a .flo to disk
<p>
@param path Path to the file to be written
@param flow Flow field to be stored
<p>
The function stores a flow field in a file, returns true on success, false otherwise.
The flow field must be a 2-channel, floating-point matrix (CV_32FC2). First channel corresponds
to the flow in the horizontal direction (u), second - vertical (v).
 */
@Namespace("cv::optflow") public static native @Cast("bool") boolean writeOpticalFlow( @Str BytePointer path, @ByVal Mat flow );
@Namespace("cv::optflow") public static native @Cast("bool") boolean writeOpticalFlow( @Str String path, @ByVal Mat flow );
@Namespace("cv::optflow") public static native @Cast("bool") boolean writeOpticalFlow( @Str String path, @ByVal UMat flow );
@Namespace("cv::optflow") public static native @Cast("bool") boolean writeOpticalFlow( @Str BytePointer path, @ByVal UMat flow );
@Namespace("cv::optflow") public static native @Cast("bool") boolean writeOpticalFlow( @Str BytePointer path, @ByVal GpuMat flow );
@Namespace("cv::optflow") public static native @Cast("bool") boolean writeOpticalFlow( @Str String path, @ByVal GpuMat flow );

/** \brief Variational optical flow refinement
<p>
This class implements variational refinement of the input flow field, i.e.
it uses input flow to initialize the minimization of the following functional:
\f$E(U) = \int_{\Omega} \delta \Psi(E_I) + \gamma \Psi(E_G) + \alpha \Psi(E_S) \f$,
where \f$E_I,E_G,E_S\f$ are color constancy, gradient constancy and smoothness terms
respectively. \f$\Psi(s^2)=\sqrt{s^2+\epsilon^2}\f$ is a robust penalizer to limit the
influence of outliers. A complete formulation and a description of the minimization
procedure can be found in \cite Brox2004
*/
@Namespace("cv::optflow") public static class VariationalRefinement extends DenseOpticalFlow {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public VariationalRefinement(Pointer p) { super(p); }

    /** \brief \ref calc function overload to handle separate horizontal (u) and vertical (v) flow components
    (to avoid extra splits/merges) */
    public native void calcUV(@ByVal Mat I0, @ByVal Mat I1, @ByVal Mat flow_u, @ByVal Mat flow_v);
    public native void calcUV(@ByVal UMat I0, @ByVal UMat I1, @ByVal UMat flow_u, @ByVal UMat flow_v);
    public native void calcUV(@ByVal GpuMat I0, @ByVal GpuMat I1, @ByVal GpuMat flow_u, @ByVal GpuMat flow_v);

    /** \brief Number of outer (fixed-point) iterations in the minimization procedure.
    @see setFixedPointIterations */
    public native int getFixedPointIterations();
    /** \copybrief getFixedPointIterations @see getFixedPointIterations */
    public native void setFixedPointIterations(int val);

    /** \brief Number of inner successive over-relaxation (SOR) iterations
        in the minimization procedure to solve the respective linear system.
    @see setSorIterations */
    public native int getSorIterations();
    /** \copybrief getSorIterations @see getSorIterations */
    public native void setSorIterations(int val);

    /** \brief Relaxation factor in SOR
    @see setOmega */
    public native float getOmega();
    /** \copybrief getOmega @see getOmega */
    public native void setOmega(float val);

    /** \brief Weight of the smoothness term
    @see setAlpha */
    public native float getAlpha();
    /** \copybrief getAlpha @see getAlpha */
    public native void setAlpha(float val);

    /** \brief Weight of the color constancy term
    @see setDelta */
    public native float getDelta();
    /** \copybrief getDelta @see getDelta */
    public native void setDelta(float val);

    /** \brief Weight of the gradient constancy term
    @see setGamma */
    public native float getGamma();
    /** \copybrief getGamma @see getGamma */
    public native void setGamma(float val);
}

/** \brief Creates an instance of VariationalRefinement
*/
@Namespace("cv::optflow") public static native @Ptr VariationalRefinement createVariationalFlowRefinement();

/** \brief DeepFlow optical flow algorithm implementation.
<p>
The class implements the DeepFlow optical flow algorithm described in \cite Weinzaepfel2013 . See
also <http://lear.inrialpes.fr/src/deepmatching/> .
Parameters - class fields - that may be modified after creating a class instance:
-   member float alpha
Smoothness assumption weight
-   member float delta
Color constancy assumption weight
-   member float gamma
Gradient constancy weight
-   member float sigma
Gaussian smoothing parameter
-   member int minSize
Minimal dimension of an image in the pyramid (next, smaller images in the pyramid are generated
until one of the dimensions reaches this size)
-   member float downscaleFactor
Scaling factor in the image pyramid (must be \< 1)
-   member int fixedPointIterations
How many iterations on each level of the pyramid
-   member int sorIterations
Iterations of Succesive Over-Relaxation (solver)
-   member float omega
Relaxation factor in SOR
 */
@Namespace("cv::optflow") public static native @Ptr DenseOpticalFlow createOptFlow_DeepFlow();

/** Additional interface to the SimpleFlow algorithm - calcOpticalFlowSF() */
@Namespace("cv::optflow") public static native @Ptr DenseOpticalFlow createOptFlow_SimpleFlow();

/** Additional interface to the Farneback's algorithm - calcOpticalFlowFarneback() */
@Namespace("cv::optflow") public static native @Ptr DenseOpticalFlow createOptFlow_Farneback();

/** Additional interface to the SparseToDenseFlow algorithm - calcOpticalFlowSparseToDense() */
@Namespace("cv::optflow") public static native @Ptr DenseOpticalFlow createOptFlow_SparseToDense();

/** \brief DIS optical flow algorithm.
<p>
This class implements the Dense Inverse Search (DIS) optical flow algorithm. More
details about the algorithm can be found at \cite Kroeger2016 . Includes three presets with preselected
parameters to provide reasonable trade-off between speed and quality. However, even the slowest preset is
still relatively fast, use DeepFlow if you need better quality and don't care about speed.
<p>
This implementation includes several additional features compared to the algorithm described in the paper,
including spatial propagation of flow vectors (\ref getUseSpatialPropagation), as well as an option to
utilize an initial flow approximation passed to \ref calc (which is, essentially, temporal propagation,
if the previous frame's flow field is passed).
*/
@Namespace("cv::optflow") public static class DISOpticalFlow extends DenseOpticalFlow {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DISOpticalFlow(Pointer p) { super(p); }

    /** enum cv::optflow::DISOpticalFlow:: */
    public static final int
        PRESET_ULTRAFAST = 0,
        PRESET_FAST = 1,
        PRESET_MEDIUM = 2;

    /** \brief Finest level of the Gaussian pyramid on which the flow is computed (zero level
        corresponds to the original image resolution). The final flow is obtained by bilinear upscaling.
        @see setFinestScale */
    public native int getFinestScale();
    /** \copybrief getFinestScale @see getFinestScale */
    public native void setFinestScale(int val);

    /** \brief Size of an image patch for matching (in pixels). Normally, default 8x8 patches work well
        enough in most cases.
        @see setPatchSize */
    public native int getPatchSize();
    /** \copybrief getPatchSize @see getPatchSize */
    public native void setPatchSize(int val);

    /** \brief Stride between neighbor patches. Must be less than patch size. Lower values correspond
        to higher flow quality.
        @see setPatchStride */
    public native int getPatchStride();
    /** \copybrief getPatchStride @see getPatchStride */
    public native void setPatchStride(int val);

    /** \brief Maximum number of gradient descent iterations in the patch inverse search stage. Higher values
        may improve quality in some cases.
        @see setGradientDescentIterations */
    public native int getGradientDescentIterations();
    /** \copybrief getGradientDescentIterations @see getGradientDescentIterations */
    public native void setGradientDescentIterations(int val);

    /** \brief Number of fixed point iterations of variational refinement per scale. Set to zero to
        disable variational refinement completely. Higher values will typically result in more smooth and
        high-quality flow.
    @see setGradientDescentIterations */
    public native int getVariationalRefinementIterations();
    /** \copybrief getGradientDescentIterations @see getGradientDescentIterations */
    public native void setVariationalRefinementIterations(int val);

    /** \brief Weight of the smoothness term
    @see setVariationalRefinementAlpha */
    public native float getVariationalRefinementAlpha();
    /** \copybrief getVariationalRefinementAlpha @see getVariationalRefinementAlpha */
    public native void setVariationalRefinementAlpha(float val);

    /** \brief Weight of the color constancy term
    @see setVariationalRefinementDelta */
    public native float getVariationalRefinementDelta();
    /** \copybrief getVariationalRefinementDelta @see getVariationalRefinementDelta */
    public native void setVariationalRefinementDelta(float val);

    /** \brief Weight of the gradient constancy term
    @see setVariationalRefinementGamma */
    public native float getVariationalRefinementGamma();
    /** \copybrief getVariationalRefinementGamma @see getVariationalRefinementGamma */
    public native void setVariationalRefinementGamma(float val);


    /** \brief Whether to use mean-normalization of patches when computing patch distance. It is turned on
        by default as it typically provides a noticeable quality boost because of increased robustness to
        illumination variations. Turn it off if you are certain that your sequence doesn't contain any changes
        in illumination.
    @see setUseMeanNormalization */
    public native @Cast("bool") boolean getUseMeanNormalization();
    /** \copybrief getUseMeanNormalization @see getUseMeanNormalization */
    public native void setUseMeanNormalization(@Cast("bool") boolean val);

    /** \brief Whether to use spatial propagation of good optical flow vectors. This option is turned on by
        default, as it tends to work better on average and can sometimes help recover from major errors
        introduced by the coarse-to-fine scheme employed by the DIS optical flow algorithm. Turning this
        option off can make the output flow field a bit smoother, however.
    @see setUseSpatialPropagation */
    public native @Cast("bool") boolean getUseSpatialPropagation();
    /** \copybrief getUseSpatialPropagation @see getUseSpatialPropagation */
    public native void setUseSpatialPropagation(@Cast("bool") boolean val);
}

/** \brief Creates an instance of DISOpticalFlow
<p>
@param preset one of PRESET_ULTRAFAST, PRESET_FAST and PRESET_MEDIUM
*/
@Namespace("cv::optflow") public static native @Ptr DISOpticalFlow createOptFlow_DIS(int preset/*=cv::optflow::DISOpticalFlow::PRESET_FAST*/);
@Namespace("cv::optflow") public static native @Ptr DISOpticalFlow createOptFlow_DIS();

/** \} */

 //optflow


// #include "opencv2/optflow/motempl.hpp"

// #endif


// Parsed from <opencv2/optflow/motempl.hpp>

/*
By downloading, copying, installing or using the software you agree to this
license. If you do not agree to this license, do not download, install,
copy or use the software.


                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)

Copyright (C) 2013, OpenCV Foundation, all rights reserved.
Third party copyrights are property of their respective owners.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are
disclaimed. In no event shall copyright holders or contributors be liable for
any direct, indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.
*/

// #ifndef __OPENCV_OPTFLOW_MOTEMPL_HPP__
// #define __OPENCV_OPTFLOW_MOTEMPL_HPP__

// #include "opencv2/core.hpp"

/** \addtogroup optflow
 *  \{
<p>
/** \brief Updates the motion history image by a moving silhouette.
<p>
@param silhouette Silhouette mask that has non-zero pixels where the motion occurs.
@param mhi Motion history image that is updated by the function (single-channel, 32-bit
floating-point).
@param timestamp Current time in milliseconds or other units.
@param duration Maximal duration of the motion track in the same units as timestamp .
<p>
The function updates the motion history image as follows:
<p>
\f[\texttt{mhi} (x,y)= \forkthree{\texttt{timestamp}}{if \(\texttt{silhouette}(x,y) \ne 0\)}{0}{if \(\texttt{silhouette}(x,y) = 0\) and \(\texttt{mhi} < (\texttt{timestamp} - \texttt{duration})\)}{\texttt{mhi}(x,y)}{otherwise}\f]
<p>
That is, MHI pixels where the motion occurs are set to the current timestamp , while the pixels
where the motion happened last time a long time ago are cleared.
<p>
The function, together with calcMotionGradient and calcGlobalOrientation , implements a motion
templates technique described in \cite Davis97 and \cite Bradski00 .
 */
@Namespace("cv::motempl") public static native void updateMotionHistory( @ByVal Mat silhouette, @ByVal Mat mhi,
                                       double timestamp, double duration );
@Namespace("cv::motempl") public static native void updateMotionHistory( @ByVal UMat silhouette, @ByVal UMat mhi,
                                       double timestamp, double duration );
@Namespace("cv::motempl") public static native void updateMotionHistory( @ByVal GpuMat silhouette, @ByVal GpuMat mhi,
                                       double timestamp, double duration );

/** \brief Calculates a gradient orientation of a motion history image.
<p>
@param mhi Motion history single-channel floating-point image.
@param mask Output mask image that has the type CV_8UC1 and the same size as mhi . Its non-zero
elements mark pixels where the motion gradient data is correct.
@param orientation Output motion gradient orientation image that has the same type and the same
size as mhi . Each pixel of the image is a motion orientation, from 0 to 360 degrees.
@param delta1 Minimal (or maximal) allowed difference between mhi values within a pixel
neighborhood.
@param delta2 Maximal (or minimal) allowed difference between mhi values within a pixel
neighborhood. That is, the function finds the minimum ( \f$m(x,y)\f$ ) and maximum ( \f$M(x,y)\f$ ) mhi
values over \f$3 \times 3\f$ neighborhood of each pixel and marks the motion orientation at \f$(x, y)\f$
as valid only if
\f[\min ( \texttt{delta1}  ,  \texttt{delta2}  )  \le  M(x,y)-m(x,y)  \le   \max ( \texttt{delta1}  , \texttt{delta2} ).\f]
@param apertureSize Aperture size of the Sobel operator.
<p>
The function calculates a gradient orientation at each pixel \f$(x, y)\f$ as:
<p>
\f[\texttt{orientation} (x,y)= \arctan{\frac{d\texttt{mhi}/dy}{d\texttt{mhi}/dx}}\f]
<p>
In fact, fastAtan2 and phase are used so that the computed angle is measured in degrees and covers
the full range 0..360. Also, the mask is filled to indicate pixels where the computed angle is
valid.
<p>
\note
   -   (Python) An example on how to perform a motion template technique can be found at
        opencv_source_code/samples/python2/motempl.py
 */
@Namespace("cv::motempl") public static native void calcMotionGradient( @ByVal Mat mhi, @ByVal Mat mask, @ByVal Mat orientation,
                                      double delta1, double delta2, int apertureSize/*=3*/ );
@Namespace("cv::motempl") public static native void calcMotionGradient( @ByVal Mat mhi, @ByVal Mat mask, @ByVal Mat orientation,
                                      double delta1, double delta2 );
@Namespace("cv::motempl") public static native void calcMotionGradient( @ByVal UMat mhi, @ByVal UMat mask, @ByVal UMat orientation,
                                      double delta1, double delta2, int apertureSize/*=3*/ );
@Namespace("cv::motempl") public static native void calcMotionGradient( @ByVal UMat mhi, @ByVal UMat mask, @ByVal UMat orientation,
                                      double delta1, double delta2 );
@Namespace("cv::motempl") public static native void calcMotionGradient( @ByVal GpuMat mhi, @ByVal GpuMat mask, @ByVal GpuMat orientation,
                                      double delta1, double delta2, int apertureSize/*=3*/ );
@Namespace("cv::motempl") public static native void calcMotionGradient( @ByVal GpuMat mhi, @ByVal GpuMat mask, @ByVal GpuMat orientation,
                                      double delta1, double delta2 );

/** \brief Calculates a global motion orientation in a selected region.
<p>
@param orientation Motion gradient orientation image calculated by the function calcMotionGradient
@param mask Mask image. It may be a conjunction of a valid gradient mask, also calculated by
calcMotionGradient , and the mask of a region whose direction needs to be calculated.
@param mhi Motion history image calculated by updateMotionHistory .
@param timestamp Timestamp passed to updateMotionHistory .
@param duration Maximum duration of a motion track in milliseconds, passed to updateMotionHistory
<p>
The function calculates an average motion direction in the selected region and returns the angle
between 0 degrees and 360 degrees. The average direction is computed from the weighted orientation
histogram, where a recent motion has a larger weight and the motion occurred in the past has a
smaller weight, as recorded in mhi .
 */
@Namespace("cv::motempl") public static native double calcGlobalOrientation( @ByVal Mat orientation, @ByVal Mat mask, @ByVal Mat mhi,
                                           double timestamp, double duration );
@Namespace("cv::motempl") public static native double calcGlobalOrientation( @ByVal UMat orientation, @ByVal UMat mask, @ByVal UMat mhi,
                                           double timestamp, double duration );
@Namespace("cv::motempl") public static native double calcGlobalOrientation( @ByVal GpuMat orientation, @ByVal GpuMat mask, @ByVal GpuMat mhi,
                                           double timestamp, double duration );

/** \brief Splits a motion history image into a few parts corresponding to separate independent motions (for
example, left hand, right hand).
<p>
@param mhi Motion history image.
@param segmask Image where the found mask should be stored, single-channel, 32-bit floating-point.
@param boundingRects Vector containing ROIs of motion connected components.
@param timestamp Current time in milliseconds or other units.
@param segThresh Segmentation threshold that is recommended to be equal to the interval between
motion history "steps" or greater.
<p>
The function finds all of the motion segments and marks them in segmask with individual values
(1,2,...). It also computes a vector with ROIs of motion connected components. After that the motion
direction for every component can be calculated with calcGlobalOrientation using the extracted mask
of the particular component.
 */
@Namespace("cv::motempl") public static native void segmentMotion( @ByVal Mat mhi, @ByVal Mat segmask,
                                 @ByRef RectVector boundingRects,
                                 double timestamp, double segThresh );
@Namespace("cv::motempl") public static native void segmentMotion( @ByVal UMat mhi, @ByVal UMat segmask,
                                 @ByRef RectVector boundingRects,
                                 double timestamp, double segThresh );
@Namespace("cv::motempl") public static native void segmentMotion( @ByVal GpuMat mhi, @ByVal GpuMat segmask,
                                 @ByRef RectVector boundingRects,
                                 double timestamp, double segThresh );
                                 

/** \} */


                                 
                                 
// #endif


}
