// Targeted by JavaCPP version 1.4: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import org.bytedeco.javacpp.annotation.Index;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.opencv_core.*;
import static org.bytedeco.javacpp.opencv_imgproc.*;
import static org.bytedeco.javacpp.opencv_dnn.*;
import static org.bytedeco.javacpp.opencv_imgcodecs.*;
import static org.bytedeco.javacpp.opencv_videoio.*;
import static org.bytedeco.javacpp.opencv_highgui.*;
import static org.bytedeco.javacpp.opencv_flann.*;
import static org.bytedeco.javacpp.opencv_ml.*;
import static org.bytedeco.javacpp.opencv_features2d.*;

public class opencv_text extends org.bytedeco.javacpp.presets.opencv_text {
    static { Loader.load(); }

@Name("std::deque<int>") public static class IntDeque extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IntDeque(Pointer p) { super(p); }
    public IntDeque(int ... array) { this(array.length); put(array); }
    public IntDeque()       { allocate();  }
    public IntDeque(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator=") @ByRef IntDeque put(@ByRef IntDeque x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    @Index public native int get(@Cast("size_t") long i);
    public native IntDeque put(@Cast("size_t") long i, int value);

    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator++") @ByRef Iterator increment();
        public native @Name("operator==") boolean equals(@ByRef Iterator it);
        public native @Name("operator*") int get();
    }

    public IntDeque put(int ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

@Name("std::vector<cv::text::ERStat>") public static class ERStatVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ERStatVector(Pointer p) { super(p); }
    public ERStatVector(ERStat value) { this(1); put(0, value); }
    public ERStatVector(ERStat ... array) { this(array.length); put(array); }
    public ERStatVector()       { allocate();  }
    public ERStatVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator=") @ByRef ERStatVector put(@ByRef ERStatVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    @Index public native @ByRef ERStat get(@Cast("size_t") long i);
    public native ERStatVector put(@Cast("size_t") long i, ERStat value);

    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator++") @ByRef Iterator increment();
        public native @Name("operator==") boolean equals(@ByRef Iterator it);
        public native @Name("operator*") @ByRef ERStat get();
    }

    public ERStat pop_back() {
        long size = size();
        ERStat value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public ERStatVector push_back(ERStat value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public ERStatVector put(ERStat value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public ERStatVector put(ERStat ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

@Name("std::vector<std::vector<cv::text::ERStat> >") public static class ERStatVectorVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ERStatVectorVector(Pointer p) { super(p); }
    public ERStatVectorVector(ERStatVector value) { this(1); put(0, value); }
    public ERStatVectorVector(ERStatVector ... array) { this(array.length); put(array); }
    public ERStatVectorVector()       { allocate();  }
    public ERStatVectorVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator=") @ByRef ERStatVectorVector put(@ByRef ERStatVectorVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    @Index public native @ByRef ERStatVector get(@Cast("size_t") long i);
    public native ERStatVectorVector put(@Cast("size_t") long i, ERStatVector value);

    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator++") @ByRef Iterator increment();
        public native @Name("operator==") boolean equals(@ByRef Iterator it);
        public native @Name("operator*") @ByRef ERStatVector get();
    }

    public ERStatVector pop_back() {
        long size = size();
        ERStatVector value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public ERStatVectorVector push_back(ERStatVector value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public ERStatVectorVector put(ERStatVector value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public ERStatVectorVector put(ERStatVector ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

@Name("std::vector<double>") public static class DoubleVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DoubleVector(Pointer p) { super(p); }
    public DoubleVector(double value) { this(1); put(0, value); }
    public DoubleVector(double ... array) { this(array.length); put(array); }
    public DoubleVector()       { allocate();  }
    public DoubleVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator=") @ByRef DoubleVector put(@ByRef DoubleVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    @Index public native double get(@Cast("size_t") long i);
    public native DoubleVector put(@Cast("size_t") long i, double value);

    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator++") @ByRef Iterator increment();
        public native @Name("operator==") boolean equals(@ByRef Iterator it);
        public native @Name("operator*") double get();
    }

    public double pop_back() {
        long size = size();
        double value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public DoubleVector push_back(double value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public DoubleVector put(double value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public DoubleVector put(double ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

@Name("std::vector<std::string>") public static class StdStringVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StdStringVector(Pointer p) { super(p); }
    public StdStringVector(BytePointer value) { this(1); put(0, value); }
    public StdStringVector(BytePointer ... array) { this(array.length); put(array); }
    public StdStringVector(String value) { this(1); put(0, value); }
    public StdStringVector(String ... array) { this(array.length); put(array); }
    public StdStringVector()       { allocate();  }
    public StdStringVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator=") @ByRef StdStringVector put(@ByRef StdStringVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    @Index public native @StdString BytePointer get(@Cast("size_t") long i);
    public native StdStringVector put(@Cast("size_t") long i, BytePointer value);
    @ValueSetter @Index public native StdStringVector put(@Cast("size_t") long i, @StdString String value);

    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator++") @ByRef Iterator increment();
        public native @Name("operator==") boolean equals(@ByRef Iterator it);
        public native @Name("operator*") @StdString BytePointer get();
    }

    public BytePointer pop_back() {
        long size = size();
        BytePointer value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public StdStringVector push_back(BytePointer value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public StdStringVector put(BytePointer value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public StdStringVector put(BytePointer ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }

    public StdStringVector push_back(String value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public StdStringVector put(String value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public StdStringVector put(String ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

// Parsed from <opencv2/text.hpp>

/*
By downloading, copying, installing or using the software you agree to this
license. If you do not agree to this license, do not download, install,
copy or use the software.

                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)

Copyright (C) 2013, OpenCV Foundation, all rights reserved.
Third party copyrights are property of their respective owners.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are
disclaimed. In no event shall copyright holders or contributors be liable for
any direct, indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.
*/

// #ifndef __OPENCV_TEXT_HPP__
// #define __OPENCV_TEXT_HPP__

// #include "opencv2/text/erfilter.hpp"
// #include "opencv2/text/ocr.hpp"
// #include "opencv2/text/textDetector.hpp"

/** \defgroup text Scene Text Detection and Recognition
<p>
The opencv_text module provides different algorithms for text detection and recognition in natural
scene images.
  <p>
  \{
    \defgroup text_detect Scene Text Detection
<p>
Class-specific Extremal Regions for Scene Text Detection
--------------------------------------------------------
<p>
The scene text detection algorithm described below has been initially proposed by Lukás Neumann &
Jiri Matas \cite Neumann11. The main idea behind Class-specific Extremal Regions is similar to the MSER
in that suitable Extremal Regions (ERs) are selected from the whole component tree of the image.
However, this technique differs from MSER in that selection of suitable ERs is done by a sequential
classifier trained for character detection, i.e. dropping the stability requirement of MSERs and
selecting class-specific (not necessarily stable) regions.
<p>
The component tree of an image is constructed by thresholding by an increasing value step-by-step
from 0 to 255 and then linking the obtained connected components from successive levels in a
hierarchy by their inclusion relation:
<p>
![image](pics/component_tree.png)
<p>
The component tree may contain a huge number of regions even for a very simple image as shown in
the previous image. This number can easily reach the order of 1 x 10\^6 regions for an average 1
Megapixel image. In order to efficiently select suitable regions among all the ERs the algorithm
make use of a sequential classifier with two differentiated stages.
<p>
In the first stage incrementally computable descriptors (area, perimeter, bounding box, and Euler's
number) are computed (in O(1)) for each region r and used as features for a classifier which
estimates the class-conditional probability p(r|character). Only the ERs which correspond to local
maximum of the probability p(r|character) are selected (if their probability is above a global limit
p_min and the difference between local maximum and local minimum is greater than a delta_min
value).
<p>
In the second stage, the ERs that passed the first stage are classified into character and
non-character classes using more informative but also more computationally expensive features. (Hole
area ratio, convex hull ratio, and the number of outer boundary inflexion points).
<p>
This ER filtering process is done in different single-channel projections of the input image in
order to increase the character localization recall.
<p>
After the ER filtering is done on each input channel, character candidates must be grouped in
high-level text blocks (i.e. words, text lines, paragraphs, ...). The opencv_text module implements
two different grouping algorithms: the Exhaustive Search algorithm proposed in \cite Neumann12 for
grouping horizontally aligned text, and the method proposed by Lluis Gomez and Dimosthenis Karatzas
in \cite Gomez13 \cite Gomez14 for grouping arbitrary oriented text (see erGrouping).
<p>
To see the text detector at work, have a look at the textdetection demo:
<https://github.com/opencv/opencv_contrib/blob/master/modules/text/samples/textdetection.cpp>
    <p>
    \defgroup text_recognize Scene Text Recognition
  \}
*/

// #endif


// Parsed from <opencv2/text/erfilter.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_TEXT_ERFILTER_HPP__
// #define __OPENCV_TEXT_ERFILTER_HPP__

// #include "opencv2/core.hpp"
// #include <vector>
// #include <deque>
// #include <string>

/** \addtogroup text_detect
 *  \{
<p>
/** \brief The ERStat structure represents a class-specific Extremal Region (ER).
<p>
An ER is a 4-connected set of pixels with all its grey-level values smaller than the values in its
outer boundary. A class-specific ER is selected (using a classifier) from all the ER's in the
component tree of the image. :
 */
@Namespace("cv::text") @NoOffset public static class ERStat extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ERStat(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ERStat(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ERStat position(long position) {
        return (ERStat)super.position(position);
    }

    /** Constructor */
    public ERStat(int level/*=256*/, int pixel/*=0*/, int x/*=0*/, int y/*=0*/) { super((Pointer)null); allocate(level, pixel, x, y); }
    private native void allocate(int level/*=256*/, int pixel/*=0*/, int x/*=0*/, int y/*=0*/);
    public ERStat() { super((Pointer)null); allocate(); }
    private native void allocate();
    /** Destructor */

    /** seed point and the threshold (max grey-level value) */
    public native int pixel(); public native ERStat pixel(int pixel);
    public native int level(); public native ERStat level(int level);

    /** incrementally computable features */
    public native int area(); public native ERStat area(int area);
    public native int perimeter(); public native ERStat perimeter(int perimeter);
    /** Euler's number */
    public native int euler(); public native ERStat euler(int euler);
    public native @ByRef Rect rect(); public native ERStat rect(Rect rect);
    /** order 1 raw moments to derive the centroid */
    public native double raw_moments(int i); public native ERStat raw_moments(int i, double raw_moments);
    @MemberGetter public native DoublePointer raw_moments();
    /** order 2 central moments to construct the covariance matrix */
    public native double central_moments(int i); public native ERStat central_moments(int i, double central_moments);
    @MemberGetter public native DoublePointer central_moments();
    /** horizontal crossings */
    public native @Ptr IntDeque crossings(); public native ERStat crossings(IntDeque crossings);
    /** median of the crossings at three different height levels */
    public native float med_crossings(); public native ERStat med_crossings(float med_crossings);

    /** 2nd stage features */
    public native float hole_area_ratio(); public native ERStat hole_area_ratio(float hole_area_ratio);
    public native float convex_hull_ratio(); public native ERStat convex_hull_ratio(float convex_hull_ratio);
    public native float num_inflexion_points(); public native ERStat num_inflexion_points(float num_inflexion_points);

    // TODO Other features can be added (average color, standard deviation, and such)


    // TODO shall we include the pixel list whenever available (i.e. after 2nd stage) ?
    public native @StdVector IntPointer pixels(); public native ERStat pixels(IntPointer pixels);

    /** probability that the ER belongs to the class we are looking for */
    public native double probability(); public native ERStat probability(double probability);

    /** pointers preserving the tree structure of the component tree */
    public native ERStat parent(); public native ERStat parent(ERStat parent);
    public native ERStat child(); public native ERStat child(ERStat child);
    public native ERStat next(); public native ERStat next(ERStat next);
    public native ERStat prev(); public native ERStat prev(ERStat prev);

    /** whenever the regions is a local maxima of the probability */
    public native @Cast("bool") boolean local_maxima(); public native ERStat local_maxima(boolean local_maxima);
    public native ERStat max_probability_ancestor(); public native ERStat max_probability_ancestor(ERStat max_probability_ancestor);
    public native ERStat min_probability_ancestor(); public native ERStat min_probability_ancestor(ERStat min_probability_ancestor);
}

/** \brief Base class for 1st and 2nd stages of Neumann and Matas scene text detection algorithm \cite Neumann12. :
<p>
Extracts the component tree (if needed) and filter the extremal regions (ER's) by using a given classifier.
 */
@Namespace("cv::text") public static class ERFilter extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ERFilter(Pointer p) { super(p); }


    /** \brief Callback with the classifier is made a class.
    <p>
    By doing it we hide SVM, Boost etc. Developers can provide their own classifiers to the
    ERFilter algorithm.
     */
    public static class Callback extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Callback(Pointer p) { super(p); }
    
        /** \brief The classifier must return probability measure for the region.
        <p>
        @param  stat :   The region to be classified
         */
        public native double eval(@Const @ByRef ERStat stat); //const = 0; //TODO why cannot use const = 0 here?
    }

    /** \brief The key method of ERFilter algorithm.
    <p>
    Takes image on input and returns the selected regions in a vector of ERStat only distinctive
    ERs which correspond to characters are selected by a sequential classifier
    <p>
    @param image Single channel image CV_8UC1
    <p>
    @param regions Output for the 1st stage and Input/Output for the 2nd. The selected Extremal Regions
    are stored here.
    <p>
    Extracts the component tree (if needed) and filter the extremal regions (ER's) by using a given
    classifier.
     */
    public native void run( @ByVal Mat image, @ByRef ERStatVector regions );
    public native void run( @ByVal UMat image, @ByRef ERStatVector regions );
    public native void run( @ByVal GpuMat image, @ByRef ERStatVector regions );


    /** set/get methods to set the algorithm properties, */
    public native void setCallback(@Ptr Callback cb);
    public native void setThresholdDelta(int thresholdDelta);
    public native void setMinArea(float minArea);
    public native void setMaxArea(float maxArea);
    public native void setMinProbability(float minProbability);
    public native void setMinProbabilityDiff(float minProbabilityDiff);
    public native void setNonMaxSuppression(@Cast("bool") boolean nonMaxSuppression);
    public native int getNumRejected();
}



/** \brief Create an Extremal Region Filter for the 1st stage classifier of N&M algorithm \cite Neumann12.
<p>
@param  cb :   Callback with the classifier. Default classifier can be implicitly load with function
loadClassifierNM1, e.g. from file in samples/cpp/trained_classifierNM1.xml
@param  thresholdDelta :   Threshold step in subsequent thresholds when extracting the component tree
@param  minArea :   The minimum area (% of image size) allowed for retreived ER's
@param  maxArea :   The maximum area (% of image size) allowed for retreived ER's
@param  minProbability :   The minimum probability P(er|character) allowed for retreived ER's
@param  nonMaxSuppression :   Whenever non-maximum suppression is done over the branch probabilities
@param  minProbabilityDiff :   The minimum probability difference between local maxima and local minima ERs
<p>
The component tree of the image is extracted by a threshold increased step by step from 0 to 255,
incrementally computable descriptors (aspect_ratio, compactness, number of holes, and number of
horizontal crossings) are computed for each ER and used as features for a classifier which estimates
the class-conditional probability P(er|character). The value of P(er|character) is tracked using the
inclusion relation of ER across all thresholds and only the ERs which correspond to local maximum of
the probability P(er|character) are selected (if the local maximum of the probability is above a
global limit pmin and the difference between local maximum and local minimum is greater than
minProbabilityDiff).
 */
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM1(@Ptr ERFilter.Callback cb,
                                                  int thresholdDelta/*=1*/, float minArea/*=(float)0.00025*/,
                                                  float maxArea/*=(float)0.13*/, float minProbability/*=(float)0.4*/,
                                                  @Cast("bool") boolean nonMaxSuppression/*=true*/,
                                                  float minProbabilityDiff/*=(float)0.1*/);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM1(@Ptr ERFilter.Callback cb);

/** \brief Create an Extremal Region Filter for the 2nd stage classifier of N&M algorithm \cite Neumann12.
<p>
@param  cb :   Callback with the classifier. Default classifier can be implicitly load with function
loadClassifierNM2, e.g. from file in samples/cpp/trained_classifierNM2.xml
@param  minProbability :   The minimum probability P(er|character) allowed for retreived ER's
<p>
In the second stage, the ERs that passed the first stage are classified into character and
non-character classes using more informative but also more computationally expensive features. The
classifier uses all the features calculated in the first stage and the following additional
features: hole area ratio, convex hull ratio, and number of outer inflexion points.
 */
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM2(@Ptr ERFilter.Callback cb,
                                                  float minProbability/*=(float)0.3*/);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM2(@Ptr ERFilter.Callback cb);

/** \brief Reads an Extremal Region Filter for the 1st stage classifier of N&M algorithm
    from the provided path e.g. /path/to/cpp/trained_classifierNM1.xml
<p>
\overload
 */
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM1(@Str BytePointer filename,
                                                  int thresholdDelta/*=1*/, float minArea/*=(float)0.00025*/,
                                                  float maxArea/*=(float)0.13*/, float minProbability/*=(float)0.4*/,
                                                  @Cast("bool") boolean nonMaxSuppression/*=true*/,
                                                  float minProbabilityDiff/*=(float)0.1*/);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM1(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM1(@Str String filename,
                                                  int thresholdDelta/*=1*/, float minArea/*=(float)0.00025*/,
                                                  float maxArea/*=(float)0.13*/, float minProbability/*=(float)0.4*/,
                                                  @Cast("bool") boolean nonMaxSuppression/*=true*/,
                                                  float minProbabilityDiff/*=(float)0.1*/);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM1(@Str String filename);

/** \brief Reads an Extremal Region Filter for the 2nd stage classifier of N&M algorithm
    from the provided path e.g. /path/to/cpp/trained_classifierNM2.xml
<p>
\overload
 */
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM2(@Str BytePointer filename,
                                                  float minProbability/*=(float)0.3*/);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM2(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM2(@Str String filename,
                                                  float minProbability/*=(float)0.3*/);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM2(@Str String filename);

/** \brief Allow to implicitly load the default classifier when creating an ERFilter object.
<p>
@param filename The XML or YAML file with the classifier model (e.g. trained_classifierNM1.xml)
<p>
returns a pointer to ERFilter::Callback.
 */
@Namespace("cv::text") public static native @Ptr ERFilter.Callback loadClassifierNM1(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr ERFilter.Callback loadClassifierNM1(@Str String filename);

/** \brief Allow to implicitly load the default classifier when creating an ERFilter object.
<p>
@param filename The XML or YAML file with the classifier model (e.g. trained_classifierNM2.xml)
<p>
returns a pointer to ERFilter::Callback.
 */
@Namespace("cv::text") public static native @Ptr ERFilter.Callback loadClassifierNM2(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr ERFilter.Callback loadClassifierNM2(@Str String filename);


/** computeNMChannels operation modes */
/** enum cv::text:: */
public static final int ERFILTER_NM_RGBLGrad = 0,
       ERFILTER_NM_IHSGrad = 1;

/** \brief Compute the different channels to be processed independently in the N&M algorithm \cite Neumann12.
<p>
@param _src Source image. Must be RGB CV_8UC3.
<p>
@param _channels Output vector\<Mat\> where computed channels are stored.
<p>
@param _mode Mode of operation. Currently the only available options are:
**ERFILTER_NM_RGBLGrad** (used by default) and **ERFILTER_NM_IHSGrad**.
<p>
In N&M algorithm, the combination of intensity (I), hue (H), saturation (S), and gradient magnitude
channels (Grad) are used in order to obtain high localization recall. This implementation also
provides an alternative combination of red (R), green (G), blue (B), lightness (L), and gradient
magnitude (Grad).
 */
@Namespace("cv::text") public static native void computeNMChannels(@ByVal Mat _src, @ByVal MatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal Mat _src, @ByVal MatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal Mat _src, @ByVal UMatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal Mat _src, @ByVal UMatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal Mat _src, @ByVal GpuMatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal Mat _src, @ByVal GpuMatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal UMat _src, @ByVal MatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal UMat _src, @ByVal MatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal UMat _src, @ByVal UMatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal UMat _src, @ByVal UMatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal UMat _src, @ByVal GpuMatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal UMat _src, @ByVal GpuMatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal GpuMat _src, @ByVal MatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal GpuMat _src, @ByVal MatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal GpuMat _src, @ByVal UMatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal GpuMat _src, @ByVal UMatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal GpuMat _src, @ByVal GpuMatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal GpuMat _src, @ByVal GpuMatVector _channels);



/** text::erGrouping operation modes */
/** enum cv::text::erGrouping_Modes */
public static final int

    /** Exhaustive Search algorithm proposed in \cite Neumann11 for grouping horizontally aligned text.
    The algorithm models a verification function for all the possible ER sequences. The
    verification fuction for ER pairs consists in a set of threshold-based pairwise rules which
    compare measurements of two regions (height ratio, centroid angle, and region distance). The
    verification function for ER triplets creates a word text line estimate using Least
    Median-Squares fitting for a given triplet and then verifies that the estimate is valid (based
    on thresholds created during training). Verification functions for sequences larger than 3 are
    approximated by verifying that the text line parameters of all (sub)sequences of length 3 are
    consistent.
    */
    ERGROUPING_ORIENTATION_HORIZ = 0,
    /** Text grouping method proposed in \cite Gomez13 \cite Gomez14 for grouping arbitrary oriented text. Regions
    are agglomerated by Single Linkage Clustering in a weighted feature space that combines proximity
    (x,y coordinates) and similarity measures (color, size, gradient magnitude, stroke width, etc.).
    SLC provides a dendrogram where each node represents a text group hypothesis. Then the algorithm
    finds the branches corresponding to text groups by traversing this dendrogram with a stopping rule
    that combines the output of a rotation invariant text group classifier and a probabilistic measure
    for hierarchical clustering validity assessment.
     */
    ERGROUPING_ORIENTATION_ANY = 1;

/** \brief Find groups of Extremal Regions that are organized as text blocks.
<p>
@param img Original RGB or Greyscale image from wich the regions were extracted.
<p>
@param channels Vector of single channel images CV_8UC1 from wich the regions were extracted.
<p>
@param regions Vector of ER's retrieved from the ERFilter algorithm from each channel.
<p>
@param groups The output of the algorithm is stored in this parameter as set of lists of indexes to
provided regions.
<p>
@param groups_rects The output of the algorithm are stored in this parameter as list of rectangles.
<p>
@param method Grouping method (see text::erGrouping_Modes). Can be one of ERGROUPING_ORIENTATION_HORIZ,
ERGROUPING_ORIENTATION_ANY.
<p>
@param filename The XML or YAML file with the classifier model (e.g.
samples/trained_classifier_erGrouping.xml). Only to use when grouping method is
ERGROUPING_ORIENTATION_ANY.
<p>
@param minProbablity The minimum probability for accepting a group. Only to use when grouping
method is ERGROUPING_ORIENTATION_ANY.
 */
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);

@Namespace("cv::text") public static native void erGrouping(@ByVal Mat image, @ByVal Mat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str BytePointer filename/*=cv::String()*/,
                                           float minProbablity/*=(float)0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat image, @ByVal Mat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat image, @ByVal Mat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str String filename/*=cv::String()*/,
                                           float minProbablity/*=(float)0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat image, @ByVal UMat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str String filename/*=cv::String()*/,
                                           float minProbablity/*=(float)0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat image, @ByVal UMat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat image, @ByVal UMat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str BytePointer filename/*=cv::String()*/,
                                           float minProbablity/*=(float)0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat image, @ByVal GpuMat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str BytePointer filename/*=cv::String()*/,
                                           float minProbablity/*=(float)0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat image, @ByVal GpuMat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat image, @ByVal GpuMat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str String filename/*=cv::String()*/,
                                           float minProbablity/*=(float)0.5*/);

/** \brief Converts MSER contours (vector\<Point\>) to ERStat regions.
<p>
@param image Source image CV_8UC1 from which the MSERs where extracted.
<p>
@param contours Input vector with all the contours (vector\<Point\>).
<p>
@param regions Output where the ERStat regions are stored.
<p>
It takes as input the contours provided by the OpenCV MSER feature detector and returns as output
two vectors of ERStats. This is because MSER() output contains both MSER+ and MSER- regions in a
single vector\<Point\>, the function separates them in two different vectors (this is as if the
ERStats where extracted from two different channels).
<p>
An example of MSERsToERStats in use can be found in the text detection webcam_demo:
<https://github.com/opencv/opencv_contrib/blob/master/modules/text/samples/webcam_demo.cpp>
 */
@Namespace("cv::text") public static native void MSERsToERStats(@ByVal Mat image, @ByRef PointVectorVector contours,
                               @ByRef ERStatVectorVector regions);
@Namespace("cv::text") public static native void MSERsToERStats(@ByVal UMat image, @ByRef PointVectorVector contours,
                               @ByRef ERStatVectorVector regions);
@Namespace("cv::text") public static native void MSERsToERStats(@ByVal GpuMat image, @ByRef PointVectorVector contours,
                               @ByRef ERStatVectorVector regions);

// Utility funtion for scripting
@Namespace("cv::text") public static native void detectRegions(@ByVal Mat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef PointVectorVector regions);
@Namespace("cv::text") public static native void detectRegions(@ByVal UMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef PointVectorVector regions);
@Namespace("cv::text") public static native void detectRegions(@ByVal GpuMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef PointVectorVector regions);


/** \brief Extracts text regions from image.
<p>
@param image Source image where text blocks needs to be extracted from.  Should be CV_8UC3 (color).
@param er_filter1 Extremal Region Filter for the 1st stage classifier of N&M algorithm \cite Neumann12
@param er_filter2 Extremal Region Filter for the 2nd stage classifier of N&M algorithm \cite Neumann12
@param groups_rects Output list of rectangle blocks with text
@param method Grouping method (see text::erGrouping_Modes). Can be one of ERGROUPING_ORIENTATION_HORIZ, ERGROUPING_ORIENTATION_ANY.
@param filename The XML or YAML file with the classifier model (e.g. samples/trained_classifier_erGrouping.xml). Only to use when grouping method is ERGROUPING_ORIENTATION_ANY.
@param minProbability The minimum probability for accepting a group. Only to use when grouping method is ERGROUPING_ORIENTATION_ANY.
 <p>
 <p>
 */
@Namespace("cv::text") public static native void detectRegions(@ByVal Mat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str BytePointer filename/*=cv::String()*/,
                                           float minProbability/*=(float)0.5*/);
@Namespace("cv::text") public static native void detectRegions(@ByVal Mat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void detectRegions(@ByVal Mat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str String filename/*=cv::String()*/,
                                           float minProbability/*=(float)0.5*/);
@Namespace("cv::text") public static native void detectRegions(@ByVal UMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str String filename/*=cv::String()*/,
                                           float minProbability/*=(float)0.5*/);
@Namespace("cv::text") public static native void detectRegions(@ByVal UMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void detectRegions(@ByVal UMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str BytePointer filename/*=cv::String()*/,
                                           float minProbability/*=(float)0.5*/);
@Namespace("cv::text") public static native void detectRegions(@ByVal GpuMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str BytePointer filename/*=cv::String()*/,
                                           float minProbability/*=(float)0.5*/);
@Namespace("cv::text") public static native void detectRegions(@ByVal GpuMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void detectRegions(@ByVal GpuMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str String filename/*=cv::String()*/,
                                           float minProbability/*=(float)0.5*/);

/** \} */



// #endif // _OPENCV_TEXT_ERFILTER_HPP_


// Parsed from <opencv2/text/ocr.hpp>

/*M//////////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_TEXT_OCR_HPP__
// #define __OPENCV_TEXT_OCR_HPP__

// #include <opencv2/core.hpp>

// #include <vector>
// #include <string>

/** \addtogroup text_recognize
 *  \{ */

/** enum cv::text:: */
public static final int
    OCR_LEVEL_WORD = 0,
    OCR_LEVEL_TEXTLINE = 1;

/** Tesseract.PageSegMode Enumeration */
/** enum cv::text::page_seg_mode */
public static final int
    PSM_OSD_ONLY = 0,
    PSM_AUTO_OSD = 1,
    PSM_AUTO_ONLY = 2,
    PSM_AUTO = 3,
    PSM_SINGLE_COLUMN = 4,
    PSM_SINGLE_BLOCK_VERT_TEXT = 5,
    PSM_SINGLE_BLOCK = 6,
    PSM_SINGLE_LINE = 7,
    PSM_SINGLE_WORD = 8,
    PSM_CIRCLE_WORD = 9,
    PSM_SINGLE_CHAR = 10;

/** Tesseract.OcrEngineMode Enumeration */
/** enum cv::text::ocr_engine_mode */
public static final int
    OEM_TESSERACT_ONLY = 0,
    OEM_CUBE_ONLY = 1,
    OEM_TESSERACT_CUBE_COMBINED = 2,
    OEM_DEFAULT = 3;

//base class BaseOCR declares a common API that would be used in a typical text recognition scenario
@Namespace("cv::text") public static class BaseOCR extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BaseOCR(Pointer p) { super(p); }

    public native void run(@ByRef Mat image, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString BytePointer output_text);
    public native void run(@ByRef Mat image, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString String output_text);
    public native void run(@ByRef Mat image, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);
}

/** \brief OCRTesseract class provides an interface with the tesseract-ocr API (v3.02.02) in C++.
<p>
Notice that it is compiled only when tesseract-ocr is correctly installed.
<p>
\note
   -   (C++) An example of OCRTesseract recognition combined with scene text detection can be found
        at the end_to_end_recognition demo:
        <https://github.com/opencv/opencv_contrib/blob/master/modules/text/samples/end_to_end_recognition.cpp>
    -   (C++) Another example of OCRTesseract recognition combined with scene text detection can be
        found at the webcam_demo:
        <https://github.com/opencv/opencv_contrib/blob/master/modules/text/samples/webcam_demo.cpp>
 */
@Namespace("cv::text") public static class OCRTesseract extends BaseOCR {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public OCRTesseract(Pointer p) { super(p); }

    /** \brief Recognize text using the tesseract-ocr API.
    <p>
    Takes image on input and returns recognized text in the output_text parameter. Optionally
    provides also the Rects for individual text elements found (e.g. words), and the list of those
    text elements with their confidence values.
    <p>
    @param image Input image CV_8UC1 or CV_8UC3
    @param output_text Output text of the tesseract-ocr.
    @param component_rects If provided the method will output a list of Rects for the individual
    text elements found (e.g. words or text lines).
    @param component_texts If provided the method will output a list of text strings for the
    recognition of individual text elements found (e.g. words or text lines).
    @param component_confidences If provided the method will output a list of confidence values
    for the recognition of individual text elements found (e.g. words or text lines).
    @param component_level OCR_LEVEL_WORD (by default), or OCR_LEVEL_TEXTLINE.
     */
    public native void run(@ByRef Mat image, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString BytePointer output_text);
    public native void run(@ByRef Mat image, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString String output_text);
    public native void run(@ByRef Mat image, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);

    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);

    // aliases for scripting
    public native @Str BytePointer run(@ByVal Mat image, int min_confidence, int component_level/*=0*/);
    public native @Str BytePointer run(@ByVal Mat image, int min_confidence);
    public native @Str String run(@ByVal UMat image, int min_confidence, int component_level/*=0*/);
    public native @Str String run(@ByVal UMat image, int min_confidence);
    public native @Str BytePointer run(@ByVal GpuMat image, int min_confidence, int component_level/*=0*/);
    public native @Str BytePointer run(@ByVal GpuMat image, int min_confidence);

    public native @Str BytePointer run(@ByVal Mat image, @ByVal Mat mask, int min_confidence, int component_level/*=0*/);
    public native @Str BytePointer run(@ByVal Mat image, @ByVal Mat mask, int min_confidence);
    public native @Str String run(@ByVal UMat image, @ByVal UMat mask, int min_confidence, int component_level/*=0*/);
    public native @Str String run(@ByVal UMat image, @ByVal UMat mask, int min_confidence);
    public native @Str BytePointer run(@ByVal GpuMat image, @ByVal GpuMat mask, int min_confidence, int component_level/*=0*/);
    public native @Str BytePointer run(@ByVal GpuMat image, @ByVal GpuMat mask, int min_confidence);

    public native void setWhiteList(@Str BytePointer char_whitelist);
    public native void setWhiteList(@Str String char_whitelist);


    /** \brief Creates an instance of the OCRTesseract class. Initializes Tesseract.
    <p>
    @param datapath the name of the parent directory of tessdata ended with "/", or NULL to use the
    system's default directory.
    @param language an ISO 639-3 code or NULL will default to "eng".
    @param char_whitelist specifies the list of characters used for recognition. NULL defaults to
    "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".
    @param oem tesseract-ocr offers different OCR Engine Modes (OEM), by default
    tesseract::OEM_DEFAULT is used. See the tesseract-ocr API documentation for other possible
    values.
    @param psmode tesseract-ocr offers different Page Segmentation Modes (PSM) tesseract::PSM_AUTO
    (fully automatic layout analysis) is used. See the tesseract-ocr API documentation for other
    possible values.
     */
    public static native @Ptr OCRTesseract create(@Cast("const char*") BytePointer datapath/*=NULL*/, @Cast("const char*") BytePointer language/*=NULL*/,
                                        @Cast("const char*") BytePointer char_whitelist/*=NULL*/, int oem/*=cv::text::OEM_DEFAULT*/, int psmode/*=cv::text::PSM_AUTO*/);
    public static native @Ptr OCRTesseract create();
    public static native @Ptr OCRTesseract create(String datapath/*=NULL*/, String language/*=NULL*/,
                                        String char_whitelist/*=NULL*/, int oem/*=cv::text::OEM_DEFAULT*/, int psmode/*=cv::text::PSM_AUTO*/);
}


/* OCR HMM Decoder */

/** enum cv::text::decoder_mode */
public static final int
    OCR_DECODER_VITERBI = 0; // Other algorithms may be added

/* OCR classifier type*/
/** enum cv::text::classifier_type */
public static final int
    OCR_KNN_CLASSIFIER = 0,
    OCR_CNN_CLASSIFIER = 1;

/** \brief OCRHMMDecoder class provides an interface for OCR using Hidden Markov Models.
<p>
\note
   -   (C++) An example on using OCRHMMDecoder recognition combined with scene text detection can
        be found at the webcam_demo sample:
        <https://github.com/opencv/opencv_contrib/blob/master/modules/text/samples/webcam_demo.cpp>
 */
@Namespace("cv::text") @NoOffset public static class OCRHMMDecoder extends BaseOCR {
    static { Loader.load(); }
    /** Default native constructor. */
    public OCRHMMDecoder() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public OCRHMMDecoder(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public OCRHMMDecoder(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public OCRHMMDecoder position(long position) {
        return (OCRHMMDecoder)super.position(position);
    }


    /** \brief Callback with the character classifier is made a class.
    <p>
    This way it hides the feature extractor and the classifier itself, so developers can write
    their own OCR code.
    <p>
    The default character classifier and feature extractor can be loaded using the utility function
    loadOCRHMMClassifierNM and KNN model provided in
    <https://github.com/opencv/opencv_contrib/blob/master/modules/text/samples/OCRHMM_knn_model_data.xml.gz>.
     */
    public static class ClassifierCallback extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public ClassifierCallback() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ClassifierCallback(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ClassifierCallback(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public ClassifierCallback position(long position) {
            return (ClassifierCallback)super.position(position);
        }
    
        /** \brief The character classifier must return a (ranked list of) class(es) id('s)
        <p>
        @param image Input image CV_8UC1 or CV_8UC3 with a single letter.
        @param out_class The classifier returns the character class categorical label, or list of
        class labels, to which the input image corresponds.
        @param out_confidence The classifier returns the probability of the input image
        corresponding to each classes in out_class.
         */
        public native void eval( @ByVal Mat image, @StdVector IntPointer out_class, @ByRef DoubleVector out_confidence);
        public native void eval( @ByVal Mat image, @StdVector IntBuffer out_class, @ByRef DoubleVector out_confidence);
        public native void eval( @ByVal Mat image, @StdVector int[] out_class, @ByRef DoubleVector out_confidence);
        public native void eval( @ByVal UMat image, @StdVector IntPointer out_class, @ByRef DoubleVector out_confidence);
        public native void eval( @ByVal UMat image, @StdVector IntBuffer out_class, @ByRef DoubleVector out_confidence);
        public native void eval( @ByVal UMat image, @StdVector int[] out_class, @ByRef DoubleVector out_confidence);
        public native void eval( @ByVal GpuMat image, @StdVector IntPointer out_class, @ByRef DoubleVector out_confidence);
        public native void eval( @ByVal GpuMat image, @StdVector IntBuffer out_class, @ByRef DoubleVector out_confidence);
        public native void eval( @ByVal GpuMat image, @StdVector int[] out_class, @ByRef DoubleVector out_confidence);
    }
    /** \brief Recognize text using HMM.
    <p>
    Takes binary image on input and returns recognized text in the output_text parameter. Optionally
    provides also the Rects for individual text elements found (e.g. words), and the list of those
    text elements with their confidence values.
    <p>
    @param image Input binary image CV_8UC1 with a single text line (or word).
    <p>
    @param output_text Output text. Most likely character sequence found by the HMM decoder.
    <p>
    @param component_rects If provided the method will output a list of Rects for the individual
    text elements found (e.g. words).
    <p>
    @param component_texts If provided the method will output a list of text strings for the
    recognition of individual text elements found (e.g. words).
    <p>
    @param component_confidences If provided the method will output a list of confidence values
    for the recognition of individual text elements found (e.g. words).
    <p>
    @param component_level Only OCR_LEVEL_WORD is supported.
     */
    public native void run(@ByRef Mat image, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString BytePointer output_text);
    public native void run(@ByRef Mat image, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString String output_text);
    public native void run(@ByRef Mat image, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);

    /** \brief Recognize text using HMM.
    <p>
    Takes an image and a mask (where each connected component corresponds to a segmented character)
    on input and returns recognized text in the output_text parameter. Optionally
    provides also the Rects for individual text elements found (e.g. words), and the list of those
    text elements with their confidence values.
    <p>
    @param image Input image CV_8UC1 or CV_8UC3 with a single text line (or word).
    @param mask Input binary image CV_8UC1 same size as input image. Each connected component in mask corresponds to a segmented character in the input image.
    <p>
    @param output_text Output text. Most likely character sequence found by the HMM decoder.
    <p>
    @param component_rects If provided the method will output a list of Rects for the individual
    text elements found (e.g. words).
    <p>
    @param component_texts If provided the method will output a list of text strings for the
    recognition of individual text elements found (e.g. words).
    <p>
    @param component_confidences If provided the method will output a list of confidence values
    for the recognition of individual text elements found (e.g. words).
    <p>
    @param component_level Only OCR_LEVEL_WORD is supported.
     */
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);

    // aliases for scripting
    public native @Str BytePointer run(@ByVal Mat image, int min_confidence, int component_level/*=0*/);
    public native @Str BytePointer run(@ByVal Mat image, int min_confidence);
    public native @Str String run(@ByVal UMat image, int min_confidence, int component_level/*=0*/);
    public native @Str String run(@ByVal UMat image, int min_confidence);
    public native @Str BytePointer run(@ByVal GpuMat image, int min_confidence, int component_level/*=0*/);
    public native @Str BytePointer run(@ByVal GpuMat image, int min_confidence);

    public native @Str BytePointer run(@ByVal Mat image, @ByVal Mat mask, int min_confidence, int component_level/*=0*/);
    public native @Str BytePointer run(@ByVal Mat image, @ByVal Mat mask, int min_confidence);
    public native @Str String run(@ByVal UMat image, @ByVal UMat mask, int min_confidence, int component_level/*=0*/);
    public native @Str String run(@ByVal UMat image, @ByVal UMat mask, int min_confidence);
    public native @Str BytePointer run(@ByVal GpuMat image, @ByVal GpuMat mask, int min_confidence, int component_level/*=0*/);
    public native @Str BytePointer run(@ByVal GpuMat image, @ByVal GpuMat mask, int min_confidence);

    /** \brief Creates an instance of the OCRHMMDecoder class. Initializes HMMDecoder.
    <p>
    @param classifier The character classifier with built in feature extractor.
    <p>
    @param vocabulary The language vocabulary (chars when ascii english text). vocabulary.size()
    must be equal to the number of classes of the classifier.
    <p>
    @param transition_probabilities_table Table with transition probabilities between character
    pairs. cols == rows == vocabulary.size().
    <p>
    @param emission_probabilities_table Table with observation emission probabilities. cols ==
    rows == vocabulary.size().
    <p>
    @param mode HMM Decoding algorithm. Only OCR_DECODER_VITERBI is available for the moment
    (<http://en.wikipedia.org/wiki/Viterbi_algorithm>).
     */
    public static native @Ptr OCRHMMDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString BytePointer vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table,
                                         @Cast("cv::text::decoder_mode") int mode/*=cv::text::OCR_DECODER_VITERBI*/);
    public static native @Ptr OCRHMMDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString BytePointer vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table);
    public static native @Ptr OCRHMMDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString String vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table,
                                         @Cast("cv::text::decoder_mode") int mode/*=cv::text::OCR_DECODER_VITERBI*/);
    public static native @Ptr OCRHMMDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString String vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table);
    public static native @Ptr OCRHMMDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString String vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table,
                                         @Cast("cv::text::decoder_mode") int mode/*=cv::text::OCR_DECODER_VITERBI*/);
    public static native @Ptr OCRHMMDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString String vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table);
    public static native @Ptr OCRHMMDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString BytePointer vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table,
                                         @Cast("cv::text::decoder_mode") int mode/*=cv::text::OCR_DECODER_VITERBI*/);
    public static native @Ptr OCRHMMDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString BytePointer vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table);
    public static native @Ptr OCRHMMDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString BytePointer vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table,
                                         @Cast("cv::text::decoder_mode") int mode/*=cv::text::OCR_DECODER_VITERBI*/);
    public static native @Ptr OCRHMMDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString BytePointer vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table);
    public static native @Ptr OCRHMMDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString String vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table,
                                         @Cast("cv::text::decoder_mode") int mode/*=cv::text::OCR_DECODER_VITERBI*/);
    public static native @Ptr OCRHMMDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString String vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table);         // HMM Decoding algorithm (only Viterbi for the moment)         // HMM Decoding algorithm (only Viterbi for the moment)

    /** \brief Creates an instance of the OCRHMMDecoder class. Loads and initializes HMMDecoder from the specified path
     <p>
     \overload
     */
    public static native @Ptr OCRHMMDecoder create(@Str BytePointer filename,
    
                                         @Str BytePointer vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table,
                                         int mode/*=cv::text::OCR_DECODER_VITERBI*/,
    
                                         int classifier/*=cv::text::OCR_KNN_CLASSIFIER*/);
    public static native @Ptr OCRHMMDecoder create(@Str BytePointer filename,
    
                                         @Str BytePointer vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table);
    public static native @Ptr OCRHMMDecoder create(@Str String filename,
    
                                         @Str String vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table,
                                         int mode/*=cv::text::OCR_DECODER_VITERBI*/,
    
                                         int classifier/*=cv::text::OCR_KNN_CLASSIFIER*/);
    public static native @Ptr OCRHMMDecoder create(@Str String filename,
    
                                         @Str String vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table);
    public static native @Ptr OCRHMMDecoder create(@Str String filename,
    
                                         @Str String vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table,
                                         int mode/*=cv::text::OCR_DECODER_VITERBI*/,
    
                                         int classifier/*=cv::text::OCR_KNN_CLASSIFIER*/);
    public static native @Ptr OCRHMMDecoder create(@Str String filename,
    
                                         @Str String vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table);
    public static native @Ptr OCRHMMDecoder create(@Str BytePointer filename,
    
                                         @Str BytePointer vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table,
                                         int mode/*=cv::text::OCR_DECODER_VITERBI*/,
    
                                         int classifier/*=cv::text::OCR_KNN_CLASSIFIER*/);
    public static native @Ptr OCRHMMDecoder create(@Str BytePointer filename,
    
                                         @Str BytePointer vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table);
    public static native @Ptr OCRHMMDecoder create(@Str BytePointer filename,
    
                                         @Str BytePointer vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table,
                                         int mode/*=cv::text::OCR_DECODER_VITERBI*/,
    
                                         int classifier/*=cv::text::OCR_KNN_CLASSIFIER*/);
    public static native @Ptr OCRHMMDecoder create(@Str BytePointer filename,
    
                                         @Str BytePointer vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table);
    public static native @Ptr OCRHMMDecoder create(@Str String filename,
    
                                         @Str String vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table,
                                         int mode/*=cv::text::OCR_DECODER_VITERBI*/,
    
                                         int classifier/*=cv::text::OCR_KNN_CLASSIFIER*/);
    public static native @Ptr OCRHMMDecoder create(@Str String filename,
    
                                         @Str String vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table);
}

/** \brief Allow to implicitly load the default character classifier when creating an OCRHMMDecoder object.
<p>
@param filename The XML or YAML file with the classifier model (e.g. OCRHMM_knn_model_data.xml)
<p>
The KNN default classifier is based in the scene text recognition method proposed by Lukás Neumann &
Jiri Matas in [Neumann11b]. Basically, the region (contour) in the input image is normalized to a
fixed size, while retaining the centroid and aspect ratio, in order to extract a feature vector
based on gradient orientations along the chain-code of its perimeter. Then, the region is classified
using a KNN model trained with synthetic data of rendered characters with different standard font
types.
<p>
@deprecated loadOCRHMMClassifier instead
 */

@Namespace("cv::text") public static native @Ptr OCRHMMDecoder.ClassifierCallback loadOCRHMMClassifierNM(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr OCRHMMDecoder.ClassifierCallback loadOCRHMMClassifierNM(@Str String filename);

/** \brief Allow to implicitly load the default character classifier when creating an OCRHMMDecoder object.
<p>
@param filename The XML or YAML file with the classifier model (e.g. OCRBeamSearch_CNN_model_data.xml.gz)
<p>
The CNN default classifier is based in the scene text recognition method proposed by Adam Coates &
Andrew NG in [Coates11a]. The character classifier consists in a Single Layer Convolutional Neural Network and
a linear classifier. It is applied to the input image in a sliding window fashion, providing a set of recognitions
at each window location.
<p>
@deprecated use loadOCRHMMClassifier instead
 */
@Namespace("cv::text") public static native @Ptr OCRHMMDecoder.ClassifierCallback loadOCRHMMClassifierCNN(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr OCRHMMDecoder.ClassifierCallback loadOCRHMMClassifierCNN(@Str String filename);

/** \brief Allow to implicitly load the default character classifier when creating an OCRHMMDecoder object.
 <p>
 @param filename The XML or YAML file with the classifier model (e.g. OCRBeamSearch_CNN_model_data.xml.gz)
 <p>
 @param classifier Can be one of classifier_type enum values.
 <p>
 */
@Namespace("cv::text") public static native @Ptr OCRHMMDecoder.ClassifierCallback loadOCRHMMClassifier(@Str BytePointer filename, int classifier);
@Namespace("cv::text") public static native @Ptr OCRHMMDecoder.ClassifierCallback loadOCRHMMClassifier(@Str String filename, int classifier);
/** \}
<p>
/** \brief Utility function to create a tailored language model transitions table from a given list of words (lexicon).
 *
 * @param vocabulary The language vocabulary (chars when ASCII English text).
 *
 * @param lexicon The list of words that are expected to be found in a particular image.
 *
 * @param transition_probabilities_table Output table with transition probabilities between character pairs. cols == rows == vocabulary.size().
 *
 * The function calculate frequency statistics of character pairs from the given lexicon and fills the output transition_probabilities_table with them. The transition_probabilities_table can be used as input in the OCRHMMDecoder::create() and OCRBeamSearchDecoder::create() methods.
 * \note
 *    -   (C++) An alternative would be to load the default generic language transition table provided in the text module samples folder (created from ispell 42869 english words list) :
 *            <https://github.com/opencv/opencv_contrib/blob/master/modules/text/samples/OCRHMM_transitions_table.xml>
 **/
@Namespace("cv::text") public static native void createOCRHMMTransitionsTable(@StdString BytePointer vocabulary, @ByRef StdStringVector lexicon, @ByVal Mat transition_probabilities_table);
@Namespace("cv::text") public static native void createOCRHMMTransitionsTable(@StdString String vocabulary, @ByRef StdStringVector lexicon, @ByVal Mat transition_probabilities_table);
@Namespace("cv::text") public static native void createOCRHMMTransitionsTable(@StdString String vocabulary, @ByRef StdStringVector lexicon, @ByVal UMat transition_probabilities_table);
@Namespace("cv::text") public static native void createOCRHMMTransitionsTable(@StdString BytePointer vocabulary, @ByRef StdStringVector lexicon, @ByVal UMat transition_probabilities_table);
@Namespace("cv::text") public static native void createOCRHMMTransitionsTable(@StdString BytePointer vocabulary, @ByRef StdStringVector lexicon, @ByVal GpuMat transition_probabilities_table);
@Namespace("cv::text") public static native void createOCRHMMTransitionsTable(@StdString String vocabulary, @ByRef StdStringVector lexicon, @ByVal GpuMat transition_probabilities_table);

@Namespace("cv::text") public static native @ByVal Mat createOCRHMMTransitionsTable(@Str BytePointer vocabulary, @ByRef StringVector lexicon);
@Namespace("cv::text") public static native @ByVal Mat createOCRHMMTransitionsTable(@Str String vocabulary, @ByRef StringVector lexicon);


/* OCR BeamSearch Decoder */

/** \brief OCRBeamSearchDecoder class provides an interface for OCR using Beam Search algorithm.
<p>
\note
   -   (C++) An example on using OCRBeamSearchDecoder recognition combined with scene text detection can
        be found at the demo sample:
        <https://github.com/opencv/opencv_contrib/blob/master/modules/text/samples/word_recognition.cpp>
 */
@Namespace("cv::text") @NoOffset public static class OCRBeamSearchDecoder extends BaseOCR {
    static { Loader.load(); }
    /** Default native constructor. */
    public OCRBeamSearchDecoder() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public OCRBeamSearchDecoder(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public OCRBeamSearchDecoder(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public OCRBeamSearchDecoder position(long position) {
        return (OCRBeamSearchDecoder)super.position(position);
    }


    /** \brief Callback with the character classifier is made a class.
    <p>
    This way it hides the feature extractor and the classifier itself, so developers can write
    their own OCR code.
    <p>
    The default character classifier and feature extractor can be loaded using the utility funtion
    loadOCRBeamSearchClassifierCNN with all its parameters provided in
    <https://github.com/opencv/opencv_contrib/blob/master/modules/text/samples/OCRBeamSearch_CNN_model_data.xml.gz>.
     */
    public static class ClassifierCallback extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public ClassifierCallback() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ClassifierCallback(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ClassifierCallback(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public ClassifierCallback position(long position) {
            return (ClassifierCallback)super.position(position);
        }
    
        /** \brief The character classifier must return a (ranked list of) class(es) id('s)
        <p>
        @param image Input image CV_8UC1 or CV_8UC3 with a single letter.
        @param recognition_probabilities For each of the N characters found the classifier returns a list with
        class probabilities for each class.
        @param oversegmentation The classifier returns a list of N+1 character locations' x-coordinates,
        including 0 as start-sequence location.
         */
        public native void eval( @ByVal Mat image, @StdVector DoubleVector recognition_probabilities, @StdVector IntPointer oversegmentation );
        public native void eval( @ByVal Mat image, @StdVector DoubleVector recognition_probabilities, @StdVector IntBuffer oversegmentation );
        public native void eval( @ByVal Mat image, @StdVector DoubleVector recognition_probabilities, @StdVector int[] oversegmentation );
        public native void eval( @ByVal UMat image, @StdVector DoubleVector recognition_probabilities, @StdVector IntPointer oversegmentation );
        public native void eval( @ByVal UMat image, @StdVector DoubleVector recognition_probabilities, @StdVector IntBuffer oversegmentation );
        public native void eval( @ByVal UMat image, @StdVector DoubleVector recognition_probabilities, @StdVector int[] oversegmentation );
        public native void eval( @ByVal GpuMat image, @StdVector DoubleVector recognition_probabilities, @StdVector IntPointer oversegmentation );
        public native void eval( @ByVal GpuMat image, @StdVector DoubleVector recognition_probabilities, @StdVector IntBuffer oversegmentation );
        public native void eval( @ByVal GpuMat image, @StdVector DoubleVector recognition_probabilities, @StdVector int[] oversegmentation );

        public native int getWindowSize();
        public native int getStepSize();
    }
    /** \brief Recognize text using Beam Search.
    <p>
    Takes image on input and returns recognized text in the output_text parameter. Optionally
    provides also the Rects for individual text elements found (e.g. words), and the list of those
    text elements with their confidence values.
    <p>
    @param image Input binary image CV_8UC1 with a single text line (or word).
    <p>
    @param output_text Output text. Most likely character sequence found by the HMM decoder.
    <p>
    @param component_rects If provided the method will output a list of Rects for the individual
    text elements found (e.g. words).
    <p>
    @param component_texts If provided the method will output a list of text strings for the
    recognition of individual text elements found (e.g. words).
    <p>
    @param component_confidences If provided the method will output a list of confidence values
    for the recognition of individual text elements found (e.g. words).
    <p>
    @param component_level Only OCR_LEVEL_WORD is supported.
     */
    public native void run(@ByRef Mat image, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString BytePointer output_text);
    public native void run(@ByRef Mat image, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString String output_text);
    public native void run(@ByRef Mat image, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);

    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString BytePointer output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=0*/);
    public native void run(@ByRef Mat image, @ByRef Mat mask, @StdString String output_text, RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/, @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=0*/);

    // aliases for scripting
    public native @Str BytePointer run(@ByVal Mat image, int min_confidence, int component_level/*=0*/);
    public native @Str BytePointer run(@ByVal Mat image, int min_confidence);
    public native @Str String run(@ByVal UMat image, int min_confidence, int component_level/*=0*/);
    public native @Str String run(@ByVal UMat image, int min_confidence);
    public native @Str BytePointer run(@ByVal GpuMat image, int min_confidence, int component_level/*=0*/);
    public native @Str BytePointer run(@ByVal GpuMat image, int min_confidence);

    public native @Str BytePointer run(@ByVal Mat image, @ByVal Mat mask, int min_confidence, int component_level/*=0*/);
    public native @Str BytePointer run(@ByVal Mat image, @ByVal Mat mask, int min_confidence);
    public native @Str String run(@ByVal UMat image, @ByVal UMat mask, int min_confidence, int component_level/*=0*/);
    public native @Str String run(@ByVal UMat image, @ByVal UMat mask, int min_confidence);
    public native @Str BytePointer run(@ByVal GpuMat image, @ByVal GpuMat mask, int min_confidence, int component_level/*=0*/);
    public native @Str BytePointer run(@ByVal GpuMat image, @ByVal GpuMat mask, int min_confidence);

    /** \brief Creates an instance of the OCRBeamSearchDecoder class. Initializes HMMDecoder.
    <p>
    @param classifier The character classifier with built in feature extractor.
    <p>
    @param vocabulary The language vocabulary (chars when ASCII English text). vocabulary.size()
    must be equal to the number of classes of the classifier.
    <p>
    @param transition_probabilities_table Table with transition probabilities between character
    pairs. cols == rows == vocabulary.size().
    <p>
    @param emission_probabilities_table Table with observation emission probabilities. cols ==
    rows == vocabulary.size().
    <p>
    @param mode HMM Decoding algorithm. Only OCR_DECODER_VITERBI is available for the moment
    (<http://en.wikipedia.org/wiki/Viterbi_algorithm>).
    <p>
    @param beam_size Size of the beam in Beam Search algorithm.
     */
    public static native @Ptr OCRBeamSearchDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString BytePointer vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table,
                                         @Cast("cv::text::decoder_mode") int mode/*=cv::text::OCR_DECODER_VITERBI*/,
                                         int beam_size/*=500*/);
    public static native @Ptr OCRBeamSearchDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString BytePointer vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table);
    public static native @Ptr OCRBeamSearchDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString String vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table,
                                         @Cast("cv::text::decoder_mode") int mode/*=cv::text::OCR_DECODER_VITERBI*/,
                                         int beam_size/*=500*/);
    public static native @Ptr OCRBeamSearchDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString String vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table);
    public static native @Ptr OCRBeamSearchDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString String vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table,
                                         @Cast("cv::text::decoder_mode") int mode/*=cv::text::OCR_DECODER_VITERBI*/,
                                         int beam_size/*=500*/);
    public static native @Ptr OCRBeamSearchDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString String vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table);
    public static native @Ptr OCRBeamSearchDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString BytePointer vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table,
                                         @Cast("cv::text::decoder_mode") int mode/*=cv::text::OCR_DECODER_VITERBI*/,
                                         int beam_size/*=500*/);
    public static native @Ptr OCRBeamSearchDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString BytePointer vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table);
    public static native @Ptr OCRBeamSearchDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString BytePointer vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table,
                                         @Cast("cv::text::decoder_mode") int mode/*=cv::text::OCR_DECODER_VITERBI*/,
                                         int beam_size/*=500*/);
    public static native @Ptr OCRBeamSearchDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString BytePointer vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table);
    public static native @Ptr OCRBeamSearchDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString String vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table,
                                         @Cast("cv::text::decoder_mode") int mode/*=cv::text::OCR_DECODER_VITERBI*/,
                                         int beam_size/*=500*/);
    public static native @Ptr OCRBeamSearchDecoder create(@Ptr ClassifierCallback classifier,
                                         @StdString String vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table);                              // Size of the beam in Beam Search algorithm                              // Size of the beam in Beam Search algorithm

    /** \brief Creates an instance of the OCRBeamSearchDecoder class. Initializes HMMDecoder from the specified path.
    <p>
    \overload
     <p>
     */
    public static native @Ptr OCRBeamSearchDecoder create(@Str BytePointer filename,
                                         @Str BytePointer vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table,
                                         int mode/*=cv::text::OCR_DECODER_VITERBI*/,
                                         int beam_size/*=500*/);
    public static native @Ptr OCRBeamSearchDecoder create(@Str BytePointer filename,
                                         @Str BytePointer vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table);
    public static native @Ptr OCRBeamSearchDecoder create(@Str String filename,
                                         @Str String vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table,
                                         int mode/*=cv::text::OCR_DECODER_VITERBI*/,
                                         int beam_size/*=500*/);
    public static native @Ptr OCRBeamSearchDecoder create(@Str String filename,
                                         @Str String vocabulary,
                                         @ByVal Mat transition_probabilities_table,
                                         @ByVal Mat emission_probabilities_table);
    public static native @Ptr OCRBeamSearchDecoder create(@Str String filename,
                                         @Str String vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table,
                                         int mode/*=cv::text::OCR_DECODER_VITERBI*/,
                                         int beam_size/*=500*/);
    public static native @Ptr OCRBeamSearchDecoder create(@Str String filename,
                                         @Str String vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table);
    public static native @Ptr OCRBeamSearchDecoder create(@Str BytePointer filename,
                                         @Str BytePointer vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table,
                                         int mode/*=cv::text::OCR_DECODER_VITERBI*/,
                                         int beam_size/*=500*/);
    public static native @Ptr OCRBeamSearchDecoder create(@Str BytePointer filename,
                                         @Str BytePointer vocabulary,
                                         @ByVal UMat transition_probabilities_table,
                                         @ByVal UMat emission_probabilities_table);
    public static native @Ptr OCRBeamSearchDecoder create(@Str BytePointer filename,
                                         @Str BytePointer vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table,
                                         int mode/*=cv::text::OCR_DECODER_VITERBI*/,
                                         int beam_size/*=500*/);
    public static native @Ptr OCRBeamSearchDecoder create(@Str BytePointer filename,
                                         @Str BytePointer vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table);
    public static native @Ptr OCRBeamSearchDecoder create(@Str String filename,
                                         @Str String vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table,
                                         int mode/*=cv::text::OCR_DECODER_VITERBI*/,
                                         int beam_size/*=500*/);
    public static native @Ptr OCRBeamSearchDecoder create(@Str String filename,
                                         @Str String vocabulary,
                                         @ByVal GpuMat transition_probabilities_table,
                                         @ByVal GpuMat emission_probabilities_table);
}

/** \brief Allow to implicitly load the default character classifier when creating an OCRBeamSearchDecoder object.
<p>
@param filename The XML or YAML file with the classifier model (e.g. OCRBeamSearch_CNN_model_data.xml.gz)
<p>
The CNN default classifier is based in the scene text recognition method proposed by Adam Coates &
Andrew NG in [Coates11a]. The character classifier consists in a Single Layer Convolutional Neural Network and
a linear classifier. It is applied to the input image in a sliding window fashion, providing a set of recognitions
at each window location.
 */

@Namespace("cv::text") public static native @Ptr OCRBeamSearchDecoder.ClassifierCallback loadOCRBeamSearchClassifierCNN(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr OCRBeamSearchDecoder.ClassifierCallback loadOCRBeamSearchClassifierCNN(@Str String filename);


/** \brief OCRHolisticWordRecognizer class provides the functionallity of segmented wordspotting.
 * Given a predefined vocabulary , a DictNet is employed to select the most probable
 * word given an input image.
 *
 * DictNet is described in detail in:
 * Max Jaderberg et al.: Reading Text in the Wild with Convolutional Neural Networks, IJCV 2015
 * http://arxiv.org/abs/1412.1842
 */
@Namespace("cv::text") public static class OCRHolisticWordRecognizer extends BaseOCR {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public OCRHolisticWordRecognizer(Pointer p) { super(p); }

    public native void run(@ByRef Mat image,
                         @StdString BytePointer output_text,
                         RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/,
                         @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=cv::text::OCR_LEVEL_WORD*/);
    public native void run(@ByRef Mat image,
                         @StdString BytePointer output_text);
    public native void run(@ByRef Mat image,
                         @StdString String output_text,
                         RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/,
                         @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=cv::text::OCR_LEVEL_WORD*/);
    public native void run(@ByRef Mat image,
                         @StdString String output_text);
    public native void run(@ByRef Mat image,
                         @StdString BytePointer output_text,
                         RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/,
                         @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=cv::text::OCR_LEVEL_WORD*/);
    public native void run(@ByRef Mat image,
                         @StdString String output_text,
                         RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/,
                         @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=cv::text::OCR_LEVEL_WORD*/);
    public native void run(@ByRef Mat image,
                         @StdString BytePointer output_text,
                         RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/,
                         @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=cv::text::OCR_LEVEL_WORD*/);
    public native void run(@ByRef Mat image,
                         @StdString String output_text,
                         RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/,
                         @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=cv::text::OCR_LEVEL_WORD*/);

    /** \brief Recognize text using a segmentation based word-spotting/classifier cnn.
    <p>
    Takes image on input and returns recognized text in the output_text parameter. Optionally
    provides also the Rects for individual text elements found (e.g. words), and the list of those
    text elements with their confidence values.
    <p>
    @param image Input image CV_8UC1 or CV_8UC3
    <p>
    @param mask is totally ignored and is only available for compatibillity reasons
    <p>
    @param output_text Output text of the the word spoting, always one that exists in the dictionary.
    <p>
    @param component_rects Not applicable for word spotting can be be NULL if not, a single elemnt will
        be put in the vector.
    <p>
    @param component_texts Not applicable for word spotting can be be NULL if not, a single elemnt will
        be put in the vector.
    <p>
    @param component_confidences Not applicable for word spotting can be be NULL if not, a single elemnt will
        be put in the vector.
    <p>
    @param component_level must be OCR_LEVEL_WORD.
     */
    public native void run(@ByRef Mat image,
                         @ByRef Mat mask,
                         @StdString BytePointer output_text,
                         RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/,
                         @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=cv::text::OCR_LEVEL_WORD*/);
    public native void run(@ByRef Mat image,
                         @ByRef Mat mask,
                         @StdString BytePointer output_text);
    public native void run(@ByRef Mat image,
                         @ByRef Mat mask,
                         @StdString String output_text,
                         RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/,
                         @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=cv::text::OCR_LEVEL_WORD*/);
    public native void run(@ByRef Mat image,
                         @ByRef Mat mask,
                         @StdString String output_text);
    public native void run(@ByRef Mat image,
                         @ByRef Mat mask,
                         @StdString BytePointer output_text,
                         RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/,
                         @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=cv::text::OCR_LEVEL_WORD*/);
    public native void run(@ByRef Mat image,
                         @ByRef Mat mask,
                         @StdString String output_text,
                         RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/,
                         @StdVector FloatPointer component_confidences/*=NULL*/,
                         int component_level/*=cv::text::OCR_LEVEL_WORD*/);
    public native void run(@ByRef Mat image,
                         @ByRef Mat mask,
                         @StdString BytePointer output_text,
                         RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/,
                         @StdVector FloatBuffer component_confidences/*=NULL*/,
                         int component_level/*=cv::text::OCR_LEVEL_WORD*/);
    public native void run(@ByRef Mat image,
                         @ByRef Mat mask,
                         @StdString String output_text,
                         RectVector component_rects/*=NULL*/,
                         StdStringVector component_texts/*=NULL*/,
                         @StdVector float[] component_confidences/*=NULL*/,
                         int component_level/*=cv::text::OCR_LEVEL_WORD*/);

    /** \brief Creates an instance of the OCRHolisticWordRecognizer class.
     */
    public static native @Ptr OCRHolisticWordRecognizer create(@StdString BytePointer archFilename,
                                                     @StdString BytePointer weightsFilename,
                                                     @StdString BytePointer wordsFilename);
    public static native @Ptr OCRHolisticWordRecognizer create(@StdString String archFilename,
                                                     @StdString String weightsFilename,
                                                     @StdString String wordsFilename);
}

/** \} */

 // cv::text::


// #endif // _OPENCV_TEXT_OCR_HPP_


}
