// Targeted by JavaCPP version 1.4: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.opencv_core.*;
import static org.bytedeco.javacpp.opencv_imgproc.*;
import static org.bytedeco.javacpp.opencv_imgcodecs.*;

public class opencv_videoio extends org.bytedeco.javacpp.presets.opencv_videoio {
    static { Loader.load(); }

// Parsed from <opencv2/videoio/videoio_c.h>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                        Intel License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000, Intel Corporation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of Intel Corporation may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_VIDEOIO_H
// #define OPENCV_VIDEOIO_H

// #include "opencv2/core/core_c.h"

// #ifdef __cplusplus
// #endif /* __cplusplus */

/**
  \addtogroup videoio_c
  \{
*/

/****************************************************************************************\
*                         Working with Video Files and Cameras                           *
\****************************************************************************************/

/** \brief "black box" capture structure
<p>
In C++ use cv::VideoCapture
*/
@Opaque public static class CvCapture extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public CvCapture() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CvCapture(Pointer p) { super(p); }
}

/** \brief start capturing frames from video file
*/
public static native CvCapture cvCreateFileCapture( @Cast("const char*") BytePointer filename );
public static native CvCapture cvCreateFileCapture( String filename );

/** \brief start capturing frames from video file. allows specifying a preferred API to use
*/
public static native CvCapture cvCreateFileCaptureWithPreference( @Cast("const char*") BytePointer filename, int apiPreference);
public static native CvCapture cvCreateFileCaptureWithPreference( String filename, int apiPreference);

/** enum  */
public static final int
    CV_CAP_ANY      = 0,     // autodetect

    CV_CAP_MIL      = 100,   // MIL proprietary drivers

    CV_CAP_VFW      = 200,   // platform native
    CV_CAP_V4L      = 200,
    CV_CAP_V4L2     = 200,

    CV_CAP_FIREWARE = 300,   // IEEE 1394 drivers
    CV_CAP_FIREWIRE = 300,
    CV_CAP_IEEE1394 = 300,
    CV_CAP_DC1394   = 300,
    CV_CAP_CMU1394  = 300,

    CV_CAP_STEREO   = 400,   // TYZX proprietary drivers
    CV_CAP_TYZX     = 400,
    CV_TYZX_LEFT    = 400,
    CV_TYZX_RIGHT   = 401,
    CV_TYZX_COLOR   = 402,
    CV_TYZX_Z       = 403,

    CV_CAP_QT       = 500,   // QuickTime

    CV_CAP_UNICAP   = 600,   // Unicap drivers

    CV_CAP_DSHOW    = 700,   // DirectShow (via videoInput)
    CV_CAP_MSMF     = 1400,  // Microsoft Media Foundation (via videoInput)

    CV_CAP_PVAPI    = 800,   // PvAPI, Prosilica GigE SDK

    CV_CAP_OPENNI   = 900,   // OpenNI (for Kinect)
    CV_CAP_OPENNI_ASUS = 910,   // OpenNI (for Asus Xtion)

    CV_CAP_ANDROID  = 1000,  // Android - not used
    CV_CAP_ANDROID_BACK = CV_CAP_ANDROID+99, // Android back camera - not used
    CV_CAP_ANDROID_FRONT = CV_CAP_ANDROID+98, // Android front camera - not used

    CV_CAP_XIAPI    = 1100,   // XIMEA Camera API

    CV_CAP_AVFOUNDATION = 1200,  // AVFoundation framework for iOS (OS X Lion will have the same API)

    CV_CAP_GIGANETIX = 1300,  // Smartek Giganetix GigEVisionSDK

    CV_CAP_INTELPERC = 1500, // Intel Perceptual Computing

    CV_CAP_OPENNI2 = 1600,   // OpenNI2 (for Kinect)
    CV_CAP_GPHOTO2 = 1700,
    CV_CAP_GSTREAMER = 1800, // GStreamer
    CV_CAP_FFMPEG = 1900,    // FFMPEG
    CV_CAP_IMAGES = 2000,    // OpenCV Image Sequence (e.g. img_%02d.jpg)

    CV_CAP_ARAVIS = 2100;     // Aravis GigE SDK

/** \brief start capturing frames from camera: index = camera_index + domain_offset (CV_CAP_*)
*/
public static native CvCapture cvCreateCameraCapture( int index );

/** \brief grab a frame, return 1 on success, 0 on fail.
  <p>
  this function is thought to be fast
*/
public static native int cvGrabFrame( CvCapture capture );

/** \brief get the frame grabbed with cvGrabFrame(..)
  <p>
  This function may apply some frame processing like
  frame decompression, flipping etc.
  \warning !!!DO NOT RELEASE or MODIFY the retrieved frame!!!
*/
public static native IplImage cvRetrieveFrame( CvCapture capture, int streamIdx/*=0*/ );
public static native IplImage cvRetrieveFrame( CvCapture capture );

/** \brief Just a combination of cvGrabFrame and cvRetrieveFrame
  <p>
  \warning !!!DO NOT RELEASE or MODIFY the retrieved frame!!!
*/
public static native IplImage cvQueryFrame( CvCapture capture );

/** \brief stop capturing/reading and free resources
*/
public static native void cvReleaseCapture( @Cast("CvCapture**") PointerPointer capture );
public static native void cvReleaseCapture( @ByPtrPtr CvCapture capture );

/** enum  */
public static final int
    // modes of the controlling registers (can be: auto, manual, auto single push, absolute Latter allowed with any other mode)
    // every feature can have only one mode turned on at a time
    CV_CAP_PROP_DC1394_OFF         = -4,  //turn the feature off (not controlled manually nor automatically)
    CV_CAP_PROP_DC1394_MODE_MANUAL = -3, //set automatically when a value of the feature is set by the user
    CV_CAP_PROP_DC1394_MODE_AUTO = -2,
    CV_CAP_PROP_DC1394_MODE_ONE_PUSH_AUTO = -1,
    CV_CAP_PROP_POS_MSEC       = 0,
    CV_CAP_PROP_POS_FRAMES     = 1,
    CV_CAP_PROP_POS_AVI_RATIO  = 2,
    CV_CAP_PROP_FRAME_WIDTH    = 3,
    CV_CAP_PROP_FRAME_HEIGHT   = 4,
    CV_CAP_PROP_FPS            = 5,
    CV_CAP_PROP_FOURCC         = 6,
    CV_CAP_PROP_FRAME_COUNT    = 7,
    CV_CAP_PROP_FORMAT         = 8,
    CV_CAP_PROP_MODE           = 9,
    CV_CAP_PROP_BRIGHTNESS    = 10,
    CV_CAP_PROP_CONTRAST      = 11,
    CV_CAP_PROP_SATURATION    = 12,
    CV_CAP_PROP_HUE           = 13,
    CV_CAP_PROP_GAIN          = 14,
    CV_CAP_PROP_EXPOSURE      = 15,
    CV_CAP_PROP_CONVERT_RGB   = 16,
    CV_CAP_PROP_WHITE_BALANCE_BLUE_U = 17,
    CV_CAP_PROP_RECTIFICATION = 18,
    CV_CAP_PROP_MONOCHROME    = 19,
    CV_CAP_PROP_SHARPNESS     = 20,
    CV_CAP_PROP_AUTO_EXPOSURE = 21, // exposure control done by camera,
                                   // user can adjust refernce level
                                   // using this feature
    CV_CAP_PROP_GAMMA         = 22,
    CV_CAP_PROP_TEMPERATURE   = 23,
    CV_CAP_PROP_TRIGGER       = 24,
    CV_CAP_PROP_TRIGGER_DELAY = 25,
    CV_CAP_PROP_WHITE_BALANCE_RED_V = 26,
    CV_CAP_PROP_ZOOM          = 27,
    CV_CAP_PROP_FOCUS         = 28,
    CV_CAP_PROP_GUID          = 29,
    CV_CAP_PROP_ISO_SPEED     = 30,
    CV_CAP_PROP_MAX_DC1394    = 31,
    CV_CAP_PROP_BACKLIGHT     = 32,
    CV_CAP_PROP_PAN           = 33,
    CV_CAP_PROP_TILT          = 34,
    CV_CAP_PROP_ROLL          = 35,
    CV_CAP_PROP_IRIS          = 36,
    CV_CAP_PROP_SETTINGS      = 37,
    CV_CAP_PROP_BUFFERSIZE    = 38,
    CV_CAP_PROP_AUTOFOCUS     = 39,
    CV_CAP_PROP_SAR_NUM       = 40,
    CV_CAP_PROP_SAR_DEN       = 41,

    CV_CAP_PROP_AUTOGRAB      = 1024, // property for videoio class CvCapture_Android only
    CV_CAP_PROP_SUPPORTED_PREVIEW_SIZES_STRING= 1025, // readonly, tricky property, returns cpnst char* indeed
    CV_CAP_PROP_PREVIEW_FORMAT= 1026, // readonly, tricky property, returns cpnst char* indeed

    // OpenNI map generators
    CV_CAP_OPENNI_DEPTH_GENERATOR =  1 << 31,
    CV_CAP_OPENNI_IMAGE_GENERATOR =  1 << 30,
    CV_CAP_OPENNI_IR_GENERATOR    =  1 << 29,
    CV_CAP_OPENNI_GENERATORS_MASK =  CV_CAP_OPENNI_DEPTH_GENERATOR + CV_CAP_OPENNI_IMAGE_GENERATOR + CV_CAP_OPENNI_IR_GENERATOR,

    // Properties of cameras available through OpenNI interfaces
    CV_CAP_PROP_OPENNI_OUTPUT_MODE     = 100,
    CV_CAP_PROP_OPENNI_FRAME_MAX_DEPTH = 101, // in mm
    CV_CAP_PROP_OPENNI_BASELINE        = 102, // in mm
    CV_CAP_PROP_OPENNI_FOCAL_LENGTH    = 103, // in pixels
    CV_CAP_PROP_OPENNI_REGISTRATION    = 104, // flag
    CV_CAP_PROP_OPENNI_REGISTRATION_ON =  CV_CAP_PROP_OPENNI_REGISTRATION, // flag that synchronizes the remapping depth map to image map
                                                                          // by changing depth generator's view point (if the flag is "on") or
                                                                          // sets this view point to its normal one (if the flag is "off").
    CV_CAP_PROP_OPENNI_APPROX_FRAME_SYNC = 105,
    CV_CAP_PROP_OPENNI_MAX_BUFFER_SIZE   = 106,
    CV_CAP_PROP_OPENNI_CIRCLE_BUFFER     = 107,
    CV_CAP_PROP_OPENNI_MAX_TIME_DURATION = 108,

    CV_CAP_PROP_OPENNI_GENERATOR_PRESENT = 109,
    CV_CAP_PROP_OPENNI2_SYNC = 110,
    CV_CAP_PROP_OPENNI2_MIRROR = 111,

    CV_CAP_OPENNI_IMAGE_GENERATOR_PRESENT         =  CV_CAP_OPENNI_IMAGE_GENERATOR + CV_CAP_PROP_OPENNI_GENERATOR_PRESENT,
    CV_CAP_OPENNI_IMAGE_GENERATOR_OUTPUT_MODE     =  CV_CAP_OPENNI_IMAGE_GENERATOR + CV_CAP_PROP_OPENNI_OUTPUT_MODE,
    CV_CAP_OPENNI_DEPTH_GENERATOR_PRESENT         =  CV_CAP_OPENNI_DEPTH_GENERATOR + CV_CAP_PROP_OPENNI_GENERATOR_PRESENT,
    CV_CAP_OPENNI_DEPTH_GENERATOR_BASELINE        =  CV_CAP_OPENNI_DEPTH_GENERATOR + CV_CAP_PROP_OPENNI_BASELINE,
    CV_CAP_OPENNI_DEPTH_GENERATOR_FOCAL_LENGTH    =  CV_CAP_OPENNI_DEPTH_GENERATOR + CV_CAP_PROP_OPENNI_FOCAL_LENGTH,
    CV_CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION    =  CV_CAP_OPENNI_DEPTH_GENERATOR + CV_CAP_PROP_OPENNI_REGISTRATION,
    CV_CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION_ON =  CV_CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION,
    CV_CAP_OPENNI_IR_GENERATOR_PRESENT            =  CV_CAP_OPENNI_IR_GENERATOR + CV_CAP_PROP_OPENNI_GENERATOR_PRESENT,

    // Properties of cameras available through GStreamer interface
    CV_CAP_GSTREAMER_QUEUE_LENGTH           = 200, // default is 1

    // PVAPI
    CV_CAP_PROP_PVAPI_MULTICASTIP           = 300, // ip for anable multicast master mode. 0 for disable multicast
    CV_CAP_PROP_PVAPI_FRAMESTARTTRIGGERMODE = 301, // FrameStartTriggerMode: Determines how a frame is initiated
    CV_CAP_PROP_PVAPI_DECIMATIONHORIZONTAL  = 302, // Horizontal sub-sampling of the image
    CV_CAP_PROP_PVAPI_DECIMATIONVERTICAL    = 303, // Vertical sub-sampling of the image
    CV_CAP_PROP_PVAPI_BINNINGX              = 304, // Horizontal binning factor
    CV_CAP_PROP_PVAPI_BINNINGY              = 305, // Vertical binning factor
    CV_CAP_PROP_PVAPI_PIXELFORMAT           = 306, // Pixel format

    // Properties of cameras available through XIMEA SDK interface
    CV_CAP_PROP_XI_DOWNSAMPLING                                 = 400, // Change image resolution by binning or skipping.
    CV_CAP_PROP_XI_DATA_FORMAT                                  = 401, // Output data format.
    CV_CAP_PROP_XI_OFFSET_X                                     = 402, // Horizontal offset from the origin to the area of interest (in pixels).
    CV_CAP_PROP_XI_OFFSET_Y                                     = 403, // Vertical offset from the origin to the area of interest (in pixels).
    CV_CAP_PROP_XI_TRG_SOURCE                                   = 404, // Defines source of trigger.
    CV_CAP_PROP_XI_TRG_SOFTWARE                                 = 405, // Generates an internal trigger. PRM_TRG_SOURCE must be set to TRG_SOFTWARE.
    CV_CAP_PROP_XI_GPI_SELECTOR                                 = 406, // Selects general purpose input
    CV_CAP_PROP_XI_GPI_MODE                                     = 407, // Set general purpose input mode
    CV_CAP_PROP_XI_GPI_LEVEL                                    = 408, // Get general purpose level
    CV_CAP_PROP_XI_GPO_SELECTOR                                 = 409, // Selects general purpose output
    CV_CAP_PROP_XI_GPO_MODE                                     = 410, // Set general purpose output mode
    CV_CAP_PROP_XI_LED_SELECTOR                                 = 411, // Selects camera signalling LED
    CV_CAP_PROP_XI_LED_MODE                                     = 412, // Define camera signalling LED functionality
    CV_CAP_PROP_XI_MANUAL_WB                                    = 413, // Calculates White Balance(must be called during acquisition)
    CV_CAP_PROP_XI_AUTO_WB                                      = 414, // Automatic white balance
    CV_CAP_PROP_XI_AEAG                                         = 415, // Automatic exposure/gain
    CV_CAP_PROP_XI_EXP_PRIORITY                                 = 416, // Exposure priority (0.5 - exposure 50%, gain 50%).
    CV_CAP_PROP_XI_AE_MAX_LIMIT                                 = 417, // Maximum limit of exposure in AEAG procedure
    CV_CAP_PROP_XI_AG_MAX_LIMIT                                 = 418,  // Maximum limit of gain in AEAG procedure
    CV_CAP_PROP_XI_AEAG_LEVEL                                   = 419, // Average intensity of output signal AEAG should achieve(in %)
    CV_CAP_PROP_XI_TIMEOUT                                      = 420, // Image capture timeout in milliseconds
    CV_CAP_PROP_XI_EXPOSURE                                     = 421, // Exposure time in microseconds
    CV_CAP_PROP_XI_EXPOSURE_BURST_COUNT                         = 422, // Sets the number of times of exposure in one frame.
    CV_CAP_PROP_XI_GAIN_SELECTOR                                = 423, // Gain selector for parameter Gain allows to select different type of gains.
    CV_CAP_PROP_XI_GAIN                                         = 424, // Gain in dB
    CV_CAP_PROP_XI_DOWNSAMPLING_TYPE                            = 426, // Change image downsampling type.
    CV_CAP_PROP_XI_BINNING_SELECTOR                             = 427, // Binning engine selector.
    CV_CAP_PROP_XI_BINNING_VERTICAL                             = 428, // Vertical Binning - number of vertical photo-sensitive cells to combine together.
    CV_CAP_PROP_XI_BINNING_HORIZONTAL                           = 429, // Horizontal Binning - number of horizontal photo-sensitive cells to combine together.
    CV_CAP_PROP_XI_BINNING_PATTERN                              = 430, // Binning pattern type.
    CV_CAP_PROP_XI_DECIMATION_SELECTOR                          = 431, // Decimation engine selector.
    CV_CAP_PROP_XI_DECIMATION_VERTICAL                          = 432, // Vertical Decimation - vertical sub-sampling of the image - reduces the vertical resolution of the image by the specified vertical decimation factor.
    CV_CAP_PROP_XI_DECIMATION_HORIZONTAL                        = 433, // Horizontal Decimation - horizontal sub-sampling of the image - reduces the horizontal resolution of the image by the specified vertical decimation factor.
    CV_CAP_PROP_XI_DECIMATION_PATTERN                           = 434, // Decimation pattern type.
    CV_CAP_PROP_XI_TEST_PATTERN_GENERATOR_SELECTOR              = 587, // Selects which test pattern generator is controlled by the TestPattern feature.
    CV_CAP_PROP_XI_TEST_PATTERN                                 = 588, // Selects which test pattern type is generated by the selected generator.
    CV_CAP_PROP_XI_IMAGE_DATA_FORMAT                            = 435, // Output data format.
    CV_CAP_PROP_XI_SHUTTER_TYPE                                 = 436, // Change sensor shutter type(CMOS sensor).
    CV_CAP_PROP_XI_SENSOR_TAPS                                  = 437, // Number of taps
    CV_CAP_PROP_XI_AEAG_ROI_OFFSET_X                            = 439, // Automatic exposure/gain ROI offset X
    CV_CAP_PROP_XI_AEAG_ROI_OFFSET_Y                            = 440, // Automatic exposure/gain ROI offset Y
    CV_CAP_PROP_XI_AEAG_ROI_WIDTH                               = 441, // Automatic exposure/gain ROI Width
    CV_CAP_PROP_XI_AEAG_ROI_HEIGHT                              = 442, // Automatic exposure/gain ROI Height
    CV_CAP_PROP_XI_BPC                                          = 445, // Correction of bad pixels
    CV_CAP_PROP_XI_WB_KR                                        = 448, // White balance red coefficient
    CV_CAP_PROP_XI_WB_KG                                        = 449, // White balance green coefficient
    CV_CAP_PROP_XI_WB_KB                                        = 450, // White balance blue coefficient
    CV_CAP_PROP_XI_WIDTH                                        = 451, // Width of the Image provided by the device (in pixels).
    CV_CAP_PROP_XI_HEIGHT                                       = 452, // Height of the Image provided by the device (in pixels).
    CV_CAP_PROP_XI_REGION_SELECTOR                              = 589, // Selects Region in Multiple ROI which parameters are set by width, height, ... ,region mode
    CV_CAP_PROP_XI_REGION_MODE                                  = 595, // Activates/deactivates Region selected by Region Selector
    CV_CAP_PROP_XI_LIMIT_BANDWIDTH                              = 459, // Set/get bandwidth(datarate)(in Megabits)
    CV_CAP_PROP_XI_SENSOR_DATA_BIT_DEPTH                        = 460, // Sensor output data bit depth.
    CV_CAP_PROP_XI_OUTPUT_DATA_BIT_DEPTH                        = 461, // Device output data bit depth.
    CV_CAP_PROP_XI_IMAGE_DATA_BIT_DEPTH                         = 462, // bitdepth of data returned by function xiGetImage
    CV_CAP_PROP_XI_OUTPUT_DATA_PACKING                          = 463, // Device output data packing (or grouping) enabled. Packing could be enabled if output_data_bit_depth > 8 and packing capability is available.
    CV_CAP_PROP_XI_OUTPUT_DATA_PACKING_TYPE                     = 464, // Data packing type. Some cameras supports only specific packing type.
    CV_CAP_PROP_XI_IS_COOLED                                    = 465, // Returns 1 for cameras that support cooling.
    CV_CAP_PROP_XI_COOLING                                      = 466, // Start camera cooling.
    CV_CAP_PROP_XI_TARGET_TEMP                                  = 467, // Set sensor target temperature for cooling.
    CV_CAP_PROP_XI_CHIP_TEMP                                    = 468, // Camera sensor temperature
    CV_CAP_PROP_XI_HOUS_TEMP                                    = 469, // Camera housing tepmerature
    CV_CAP_PROP_XI_HOUS_BACK_SIDE_TEMP                          = 590, // Camera housing back side tepmerature
    CV_CAP_PROP_XI_SENSOR_BOARD_TEMP                            = 596, // Camera sensor board temperature
    CV_CAP_PROP_XI_CMS                                          = 470, // Mode of color management system.
    CV_CAP_PROP_XI_APPLY_CMS                                    = 471, // Enable applying of CMS profiles to xiGetImage (see XI_PRM_INPUT_CMS_PROFILE, XI_PRM_OUTPUT_CMS_PROFILE).
    CV_CAP_PROP_XI_IMAGE_IS_COLOR                               = 474, // Returns 1 for color cameras.
    CV_CAP_PROP_XI_COLOR_FILTER_ARRAY                           = 475, // Returns color filter array type of RAW data.
    CV_CAP_PROP_XI_GAMMAY                                       = 476, // Luminosity gamma
    CV_CAP_PROP_XI_GAMMAC                                       = 477, // Chromaticity gamma
    CV_CAP_PROP_XI_SHARPNESS                                    = 478, // Sharpness Strenght
    CV_CAP_PROP_XI_CC_MATRIX_00                                 = 479, // Color Correction Matrix element [0][0]
    CV_CAP_PROP_XI_CC_MATRIX_01                                 = 480, // Color Correction Matrix element [0][1]
    CV_CAP_PROP_XI_CC_MATRIX_02                                 = 481, // Color Correction Matrix element [0][2]
    CV_CAP_PROP_XI_CC_MATRIX_03                                 = 482, // Color Correction Matrix element [0][3]
    CV_CAP_PROP_XI_CC_MATRIX_10                                 = 483, // Color Correction Matrix element [1][0]
    CV_CAP_PROP_XI_CC_MATRIX_11                                 = 484, // Color Correction Matrix element [1][1]
    CV_CAP_PROP_XI_CC_MATRIX_12                                 = 485, // Color Correction Matrix element [1][2]
    CV_CAP_PROP_XI_CC_MATRIX_13                                 = 486, // Color Correction Matrix element [1][3]
    CV_CAP_PROP_XI_CC_MATRIX_20                                 = 487, // Color Correction Matrix element [2][0]
    CV_CAP_PROP_XI_CC_MATRIX_21                                 = 488, // Color Correction Matrix element [2][1]
    CV_CAP_PROP_XI_CC_MATRIX_22                                 = 489, // Color Correction Matrix element [2][2]
    CV_CAP_PROP_XI_CC_MATRIX_23                                 = 490, // Color Correction Matrix element [2][3]
    CV_CAP_PROP_XI_CC_MATRIX_30                                 = 491, // Color Correction Matrix element [3][0]
    CV_CAP_PROP_XI_CC_MATRIX_31                                 = 492, // Color Correction Matrix element [3][1]
    CV_CAP_PROP_XI_CC_MATRIX_32                                 = 493, // Color Correction Matrix element [3][2]
    CV_CAP_PROP_XI_CC_MATRIX_33                                 = 494, // Color Correction Matrix element [3][3]
    CV_CAP_PROP_XI_DEFAULT_CC_MATRIX                            = 495, // Set default Color Correction Matrix
    CV_CAP_PROP_XI_TRG_SELECTOR                                 = 498, // Selects the type of trigger.
    CV_CAP_PROP_XI_ACQ_FRAME_BURST_COUNT                        = 499, // Sets number of frames acquired by burst. This burst is used only if trigger is set to FrameBurstStart
    CV_CAP_PROP_XI_DEBOUNCE_EN                                  = 507, // Enable/Disable debounce to selected GPI
    CV_CAP_PROP_XI_DEBOUNCE_T0                                  = 508, // Debounce time (x * 10us)
    CV_CAP_PROP_XI_DEBOUNCE_T1                                  = 509, // Debounce time (x * 10us)
    CV_CAP_PROP_XI_DEBOUNCE_POL                                 = 510, // Debounce polarity (pol = 1 t0 - falling edge, t1 - rising edge)
    CV_CAP_PROP_XI_LENS_MODE                                    = 511, // Status of lens control interface. This shall be set to XI_ON before any Lens operations.
    CV_CAP_PROP_XI_LENS_APERTURE_VALUE                          = 512, // Current lens aperture value in stops. Examples: 2.8, 4, 5.6, 8, 11
    CV_CAP_PROP_XI_LENS_FOCUS_MOVEMENT_VALUE                    = 513, // Lens current focus movement value to be used by XI_PRM_LENS_FOCUS_MOVE in motor steps.
    CV_CAP_PROP_XI_LENS_FOCUS_MOVE                              = 514, // Moves lens focus motor by steps set in XI_PRM_LENS_FOCUS_MOVEMENT_VALUE.
    CV_CAP_PROP_XI_LENS_FOCUS_DISTANCE                          = 515, // Lens focus distance in cm.
    CV_CAP_PROP_XI_LENS_FOCAL_LENGTH                            = 516, // Lens focal distance in mm.
    CV_CAP_PROP_XI_LENS_FEATURE_SELECTOR                        = 517, // Selects the current feature which is accessible by XI_PRM_LENS_FEATURE.
    CV_CAP_PROP_XI_LENS_FEATURE                                 = 518, // Allows access to lens feature value currently selected by XI_PRM_LENS_FEATURE_SELECTOR.
    CV_CAP_PROP_XI_DEVICE_MODEL_ID                              = 521, // Return device model id
    CV_CAP_PROP_XI_DEVICE_SN                                    = 522, // Return device serial number
    CV_CAP_PROP_XI_IMAGE_DATA_FORMAT_RGB32_ALPHA                = 529, // The alpha channel of RGB32 output image format.
    CV_CAP_PROP_XI_IMAGE_PAYLOAD_SIZE                           = 530, // Buffer size in bytes sufficient for output image returned by xiGetImage
    CV_CAP_PROP_XI_TRANSPORT_PIXEL_FORMAT                       = 531, // Current format of pixels on transport layer.
    CV_CAP_PROP_XI_SENSOR_CLOCK_FREQ_HZ                         = 532, // Sensor clock frequency in Hz.
    CV_CAP_PROP_XI_SENSOR_CLOCK_FREQ_INDEX                      = 533, // Sensor clock frequency index. Sensor with selected frequencies have possibility to set the frequency only by this index.
    CV_CAP_PROP_XI_SENSOR_OUTPUT_CHANNEL_COUNT                  = 534, // Number of output channels from sensor used for data transfer.
    CV_CAP_PROP_XI_FRAMERATE                                    = 535, // Define framerate in Hz
    CV_CAP_PROP_XI_COUNTER_SELECTOR                             = 536, // Select counter
    CV_CAP_PROP_XI_COUNTER_VALUE                                = 537, // Counter status
    CV_CAP_PROP_XI_ACQ_TIMING_MODE                              = 538, // Type of sensor frames timing.
    CV_CAP_PROP_XI_AVAILABLE_BANDWIDTH                          = 539, // Calculate and return available interface bandwidth(int Megabits)
    CV_CAP_PROP_XI_BUFFER_POLICY                                = 540, // Data move policy
    CV_CAP_PROP_XI_LUT_EN                                       = 541, // Activates LUT.
    CV_CAP_PROP_XI_LUT_INDEX                                    = 542, // Control the index (offset) of the coefficient to access in the LUT.
    CV_CAP_PROP_XI_LUT_VALUE                                    = 543, // Value at entry LUTIndex of the LUT
    CV_CAP_PROP_XI_TRG_DELAY                                    = 544, // Specifies the delay in microseconds (us) to apply after the trigger reception before activating it.
    CV_CAP_PROP_XI_TS_RST_MODE                                  = 545, // Defines how time stamp reset engine will be armed
    CV_CAP_PROP_XI_TS_RST_SOURCE                                = 546, // Defines which source will be used for timestamp reset. Writing this parameter will trigger settings of engine (arming)
    CV_CAP_PROP_XI_IS_DEVICE_EXIST                              = 547, // Returns 1 if camera connected and works properly.
    CV_CAP_PROP_XI_ACQ_BUFFER_SIZE                              = 548, // Acquisition buffer size in buffer_size_unit. Default bytes.
    CV_CAP_PROP_XI_ACQ_BUFFER_SIZE_UNIT                         = 549, // Acquisition buffer size unit in bytes. Default 1. E.g. Value 1024 means that buffer_size is in KiBytes
    CV_CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_SIZE                    = 550, // Acquisition transport buffer size in bytes
    CV_CAP_PROP_XI_BUFFERS_QUEUE_SIZE                           = 551, // Queue of field/frame buffers
    CV_CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_COMMIT                  = 552, // Number of buffers to commit to low level
    CV_CAP_PROP_XI_RECENT_FRAME                                 = 553, // GetImage returns most recent frame
    CV_CAP_PROP_XI_DEVICE_RESET                                 = 554, // Resets the camera to default state.
    CV_CAP_PROP_XI_COLUMN_FPN_CORRECTION                        = 555, // Correction of column FPN
    CV_CAP_PROP_XI_ROW_FPN_CORRECTION                           = 591, // Correction of row FPN
    CV_CAP_PROP_XI_SENSOR_MODE                                  = 558, // Current sensor mode. Allows to select sensor mode by one integer. Setting of this parameter affects: image dimensions and downsampling.
    CV_CAP_PROP_XI_HDR                                          = 559, // Enable High Dynamic Range feature.
    CV_CAP_PROP_XI_HDR_KNEEPOINT_COUNT                          = 560, // The number of kneepoints in the PWLR.
    CV_CAP_PROP_XI_HDR_T1                                       = 561, // position of first kneepoint(in % of XI_PRM_EXPOSURE)
    CV_CAP_PROP_XI_HDR_T2                                       = 562, // position of second kneepoint (in % of XI_PRM_EXPOSURE)
    CV_CAP_PROP_XI_KNEEPOINT1                                   = 563, // value of first kneepoint (% of sensor saturation)
    CV_CAP_PROP_XI_KNEEPOINT2                                   = 564, // value of second kneepoint (% of sensor saturation)
    CV_CAP_PROP_XI_IMAGE_BLACK_LEVEL                            = 565, // Last image black level counts. Can be used for Offline processing to recall it.
    CV_CAP_PROP_XI_HW_REVISION                                  = 571, // Returns hardware revision number.
    CV_CAP_PROP_XI_DEBUG_LEVEL                                  = 572, // Set debug level
    CV_CAP_PROP_XI_AUTO_BANDWIDTH_CALCULATION                   = 573, // Automatic bandwidth calculation,
    CV_CAP_PROP_XI_FFS_FILE_ID                                  = 594, // File number.
    CV_CAP_PROP_XI_FFS_FILE_SIZE                                = 580, // Size of file.
    CV_CAP_PROP_XI_FREE_FFS_SIZE                                = 581, // Size of free camera FFS.
    CV_CAP_PROP_XI_USED_FFS_SIZE                                = 582, // Size of used camera FFS.
    CV_CAP_PROP_XI_FFS_ACCESS_KEY                               = 583, // Setting of key enables file operations on some cameras.
    CV_CAP_PROP_XI_SENSOR_FEATURE_SELECTOR                      = 585, // Selects the current feature which is accessible by XI_PRM_SENSOR_FEATURE_VALUE.
    CV_CAP_PROP_XI_SENSOR_FEATURE_VALUE                         = 586, // Allows access to sensor feature value currently selected by XI_PRM_SENSOR_FEATURE_SELECTOR.


    // Properties for Android cameras
    CV_CAP_PROP_ANDROID_FLASH_MODE = 8001,
    CV_CAP_PROP_ANDROID_FOCUS_MODE = 8002,
    CV_CAP_PROP_ANDROID_WHITE_BALANCE = 8003,
    CV_CAP_PROP_ANDROID_ANTIBANDING = 8004,
    CV_CAP_PROP_ANDROID_FOCAL_LENGTH = 8005,
    CV_CAP_PROP_ANDROID_FOCUS_DISTANCE_NEAR = 8006,
    CV_CAP_PROP_ANDROID_FOCUS_DISTANCE_OPTIMAL = 8007,
    CV_CAP_PROP_ANDROID_FOCUS_DISTANCE_FAR = 8008,
    CV_CAP_PROP_ANDROID_EXPOSE_LOCK = 8009,
    CV_CAP_PROP_ANDROID_WHITEBALANCE_LOCK = 8010,

    // Properties of cameras available through AVFOUNDATION interface
    CV_CAP_PROP_IOS_DEVICE_FOCUS = 9001,
    CV_CAP_PROP_IOS_DEVICE_EXPOSURE = 9002,
    CV_CAP_PROP_IOS_DEVICE_FLASH = 9003,
    CV_CAP_PROP_IOS_DEVICE_WHITEBALANCE = 9004,
    CV_CAP_PROP_IOS_DEVICE_TORCH = 9005,

    // Properties of cameras available through Smartek Giganetix Ethernet Vision interface
    /* --- Vladimir Litvinenko (litvinenko.vladimir@gmail.com) --- */
    CV_CAP_PROP_GIGA_FRAME_OFFSET_X = 10001,
    CV_CAP_PROP_GIGA_FRAME_OFFSET_Y = 10002,
    CV_CAP_PROP_GIGA_FRAME_WIDTH_MAX = 10003,
    CV_CAP_PROP_GIGA_FRAME_HEIGH_MAX = 10004,
    CV_CAP_PROP_GIGA_FRAME_SENS_WIDTH = 10005,
    CV_CAP_PROP_GIGA_FRAME_SENS_HEIGH = 10006,

    CV_CAP_PROP_INTELPERC_PROFILE_COUNT               = 11001,
    CV_CAP_PROP_INTELPERC_PROFILE_IDX                 = 11002,
    CV_CAP_PROP_INTELPERC_DEPTH_LOW_CONFIDENCE_VALUE  = 11003,
    CV_CAP_PROP_INTELPERC_DEPTH_SATURATION_VALUE      = 11004,
    CV_CAP_PROP_INTELPERC_DEPTH_CONFIDENCE_THRESHOLD  = 11005,
    CV_CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_HORZ     = 11006,
    CV_CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_VERT     = 11007,

    // Intel PerC streams
    CV_CAP_INTELPERC_DEPTH_GENERATOR =  1 << 29,
    CV_CAP_INTELPERC_IMAGE_GENERATOR =  1 << 28,
    CV_CAP_INTELPERC_GENERATORS_MASK =  CV_CAP_INTELPERC_DEPTH_GENERATOR + CV_CAP_INTELPERC_IMAGE_GENERATOR;

// Generic camera output modes.
// Currently, these are supported through the libv4l interface only.
/** enum  */
public static final int
    CV_CAP_MODE_BGR  = 0, // BGR24 (default)
    CV_CAP_MODE_RGB  = 1, // RGB24
    CV_CAP_MODE_GRAY = 2, // Y8
    CV_CAP_MODE_YUYV = 3;  // YUYV

/** enum  */
public static final int
    // Data given from depth generator.
    CV_CAP_OPENNI_DEPTH_MAP                 = 0, // Depth values in mm (CV_16UC1)
    CV_CAP_OPENNI_POINT_CLOUD_MAP           = 1, // XYZ in meters (CV_32FC3)
    CV_CAP_OPENNI_DISPARITY_MAP             = 2, // Disparity in pixels (CV_8UC1)
    CV_CAP_OPENNI_DISPARITY_MAP_32F         = 3, // Disparity in pixels (CV_32FC1)
    CV_CAP_OPENNI_VALID_DEPTH_MASK          = 4, // CV_8UC1

    // Data given from RGB image generator.
    CV_CAP_OPENNI_BGR_IMAGE                 = 5,
    CV_CAP_OPENNI_GRAY_IMAGE                = 6,

    // Data given from IR image generator.
    CV_CAP_OPENNI_IR_IMAGE                  = 7;

// Supported output modes of OpenNI image generator
/** enum  */
public static final int
    CV_CAP_OPENNI_VGA_30HZ     = 0,
    CV_CAP_OPENNI_SXGA_15HZ    = 1,
    CV_CAP_OPENNI_SXGA_30HZ    = 2,
    CV_CAP_OPENNI_QVGA_30HZ    = 3,
    CV_CAP_OPENNI_QVGA_60HZ    = 4;

/** enum  */
public static final int
    CV_CAP_INTELPERC_DEPTH_MAP              = 0, // Each pixel is a 16-bit integer. The value indicates the distance from an object to the camera's XY plane or the Cartesian depth.
    CV_CAP_INTELPERC_UVDEPTH_MAP            = 1, // Each pixel contains two 32-bit floating point values in the range of 0-1, representing the mapping of depth coordinates to the color coordinates.
    CV_CAP_INTELPERC_IR_MAP                 = 2, // Each pixel is a 16-bit integer. The value indicates the intensity of the reflected laser beam.
    CV_CAP_INTELPERC_IMAGE                  = 3;

// gPhoto2 properties, if propertyId is less than 0 then work on widget with that __additive inversed__ camera setting ID
// Get IDs by using CAP_PROP_GPHOTO2_WIDGET_ENUMERATE.
// @see CvCaptureCAM_GPHOTO2 for more info
/** enum  */
public static final int
    CV_CAP_PROP_GPHOTO2_PREVIEW           = 17001, // Capture only preview from liveview mode.
    CV_CAP_PROP_GPHOTO2_WIDGET_ENUMERATE  = 17002, // Readonly, returns (const char *).
    CV_CAP_PROP_GPHOTO2_RELOAD_CONFIG     = 17003, // Trigger, only by set. Reload camera settings.
    CV_CAP_PROP_GPHOTO2_RELOAD_ON_CHANGE  = 17004, // Reload all settings on set.
    CV_CAP_PROP_GPHOTO2_COLLECT_MSGS      = 17005, // Collect messages with details.
    CV_CAP_PROP_GPHOTO2_FLUSH_MSGS        = 17006, // Readonly, returns (const char *).
    CV_CAP_PROP_SPEED                     = 17007, // Exposure speed. Can be readonly, depends on camera program.
    CV_CAP_PROP_APERTURE                  = 17008, // Aperture. Can be readonly, depends on camera program.
    CV_CAP_PROP_EXPOSUREPROGRAM           = 17009, // Camera exposure program.
    CV_CAP_PROP_VIEWFINDER                = 17010;  // Enter liveview mode.

/** \brief retrieve capture properties
*/
public static native double cvGetCaptureProperty( CvCapture capture, int property_id );
/** \brief set capture properties
*/
public static native int cvSetCaptureProperty( CvCapture capture, int property_id, double value );

/** \brief Return the type of the capturer (eg, ::CV_CAP_VFW, ::CV_CAP_UNICAP)
<p>
It is unknown if created with ::CV_CAP_ANY
*/
public static native int cvGetCaptureDomain( CvCapture capture);

/** \brief "black box" video file writer structure
<p>
In C++ use cv::VideoWriter
*/
@Opaque public static class CvVideoWriter extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public CvVideoWriter() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CvVideoWriter(Pointer p) { super(p); }
}

/** Macro to construct the fourcc code of the codec. Same as CV_FOURCC() */
// #define CV_FOURCC_MACRO(c1, c2, c3, c4) (((c1) & 255) + (((c2) & 255) << 8) + (((c3) & 255) << 16) + (((c4) & 255) << 24))

/** \brief Constructs the fourcc code of the codec function
<p>
Simply call it with 4 chars fourcc code like {@code CV_FOURCC('I', 'Y', 'U', 'V')}
<p>
List of codes can be obtained at [Video Codecs by FOURCC](http://www.fourcc.org/codecs.php) page.
FFMPEG backend with MP4 container natively uses other values as fourcc code:
see [ObjectType](http://www.mp4ra.org/codecs.html).
*/
public static native int CV_FOURCC(@Cast("char") byte c1, @Cast("char") byte c2, @Cast("char") byte c3, @Cast("char") byte c4);

/** (Windows only) Open Codec Selection Dialog */
public static final int CV_FOURCC_PROMPT = -1;
/** (Linux only) Use default codec for specified filename */
public static native @MemberGetter int CV_FOURCC_DEFAULT();
public static final int CV_FOURCC_DEFAULT = CV_FOURCC_DEFAULT();

/** \brief initialize video file writer
*/
public static native CvVideoWriter cvCreateVideoWriter( @Cast("const char*") BytePointer filename, int fourcc,
                                           double fps, @ByVal CvSize frame_size,
                                           int is_color/*=1*/);
public static native CvVideoWriter cvCreateVideoWriter( @Cast("const char*") BytePointer filename, int fourcc,
                                           double fps, @ByVal CvSize frame_size);
public static native CvVideoWriter cvCreateVideoWriter( String filename, int fourcc,
                                           double fps, @ByVal CvSize frame_size,
                                           int is_color/*=1*/);
public static native CvVideoWriter cvCreateVideoWriter( String filename, int fourcc,
                                           double fps, @ByVal CvSize frame_size);

/** \brief write frame to video file
*/
public static native int cvWriteFrame( CvVideoWriter writer, @Const IplImage image );

/** \brief close video file writer
*/
public static native void cvReleaseVideoWriter( @Cast("CvVideoWriter**") PointerPointer writer );
public static native void cvReleaseVideoWriter( @ByPtrPtr CvVideoWriter writer );

// ***************************************************************************************
/** \name Obsolete functions/synonyms
 *  \{ */
/** @deprecated use cvCreateCameraCapture() instead */
public static native CvCapture cvCaptureFromCAM(int arg1);
/** @deprecated use cvCreateFileCapture() instead */
public static native CvCapture cvCaptureFromFile(@Cast("const char*") BytePointer arg1);
public static native CvCapture cvCaptureFromFile(String arg1);
/** @deprecated use cvCreateFileCapture() instead */
public static native CvCapture cvCaptureFromAVI(@Cast("const char*") BytePointer arg1);
public static native CvCapture cvCaptureFromAVI(String arg1);
/** @deprecated use cvCreateVideoWriter() instead */
public static native CvVideoWriter cvCreateAVIWriter(@Cast("const char*") BytePointer arg1, int arg2, double arg3, @ByVal CvSize arg4, int arg5);
public static native CvVideoWriter cvCreateAVIWriter(String arg1, int arg2, double arg3, @ByVal CvSize arg4, int arg5);
/** @deprecated use cvWriteFrame() instead */
public static native int cvWriteToAVI(CvVideoWriter arg1, IplImage arg2);
/**  \} Obsolete...
 <p>
 *  \} videoio_c */

// #ifdef __cplusplus
// #endif

// #endif //OPENCV_VIDEOIO_H


// Parsed from <opencv2/videoio.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_VIDEOIO_HPP
// #define OPENCV_VIDEOIO_HPP

// #include "opencv2/core.hpp"

/**
  \defgroup videoio Video I/O
  <p>
  \brief Read and write video or images sequence with OpenCV
  <p>
  ### See also:
  - \ref videoio_overview
  - Tutorials: \ref tutorial_table_of_content_videoio
  \{
    \defgroup videoio_flags_base Flags for video I/O
    \defgroup videoio_flags_others Additional flags for video I/O API backends
    \defgroup videoio_c C API for video I/O
    \defgroup videoio_ios iOS glue for video I/O
    \defgroup videoio_winrt WinRT glue for video I/O
  \}
*/

////////////////////////////////// video io /////////////////////////////////

/** \addtogroup videoio
 *  \{
 <p>
 *  \addtogroup videoio_flags_base
 *  \{
<p>
<p>
/** \brief %VideoCapture API backends identifier.
<p>
Select preferred API for a capture object.
To be used in the VideoCapture::VideoCapture() constructor or VideoCapture::open()
<p>
\note Backends are available only if they have been built with your OpenCV binaries.
See \ref videoio_overview for more information.
*/
/** enum cv::VideoCaptureAPIs */
public static final int
       /** Auto detect == 0 */
       CAP_ANY          = 0,
       /** Video For Windows (platform native) */
       CAP_VFW          = 200,
       /** V4L/V4L2 capturing support via libv4l */
       CAP_V4L          = 200,
       /** Same as CAP_V4L */
       CAP_V4L2         =  CAP_V4L,
       /** IEEE 1394 drivers */
       CAP_FIREWIRE     = 300,
       /** Same as CAP_FIREWIRE */
       CAP_FIREWARE     =  CAP_FIREWIRE,
       /** Same as CAP_FIREWIRE */
       CAP_IEEE1394     =  CAP_FIREWIRE,
       /** Same as CAP_FIREWIRE */
       CAP_DC1394       =  CAP_FIREWIRE,
       /** Same as CAP_FIREWIRE */
       CAP_CMU1394      =  CAP_FIREWIRE,
       /** QuickTime */
       CAP_QT           = 500,
       /** Unicap drivers */
       CAP_UNICAP       = 600,
       /** DirectShow (via videoInput) */
       CAP_DSHOW        = 700,
       /** PvAPI, Prosilica GigE SDK */
       CAP_PVAPI        = 800,
       /** OpenNI (for Kinect) */
       CAP_OPENNI       = 900,
       /** OpenNI (for Asus Xtion) */
       CAP_OPENNI_ASUS  = 910,
       /** Android - not used */
       CAP_ANDROID      = 1000,
       /** XIMEA Camera API */
       CAP_XIAPI        = 1100,
       /** AVFoundation framework for iOS (OS X Lion will have the same API) */
       CAP_AVFOUNDATION = 1200,
       /** Smartek Giganetix GigEVisionSDK */
       CAP_GIGANETIX    = 1300,
       /** Microsoft Media Foundation (via videoInput) */
       CAP_MSMF         = 1400,
       /** Microsoft Windows Runtime using Media Foundation */
       CAP_WINRT        = 1410,
       /** Intel Perceptual Computing SDK */
       CAP_INTELPERC    = 1500,
       /** OpenNI2 (for Kinect) */
       CAP_OPENNI2      = 1600,
       /** OpenNI2 (for Asus Xtion and Occipital Structure sensors) */
       CAP_OPENNI2_ASUS = 1610,
       /** gPhoto2 connection */
       CAP_GPHOTO2      = 1700,
       /** GStreamer */
       CAP_GSTREAMER    = 1800,
       /** Open and record video file or stream using the FFMPEG library */
       CAP_FFMPEG       = 1900,
       /** OpenCV Image Sequence (e.g. img_%02d.jpg) */
       CAP_IMAGES       = 2000,
       /** Aravis SDK */
       CAP_ARAVIS       = 2100,
       /** Built-in OpenCV MotionJPEG codec */
       CAP_OPENCV_MJPEG = 2200,
       /** Intel MediaSDK */
       CAP_INTEL_MFX    = 2300;

/** \brief %VideoCapture generic properties identifier.
 <p>
 Reading / writing properties involves many layers. Some unexpected result might happens along this chain.
 Effective behaviour depends from device hardware, driver and API Backend.
 \sa videoio_flags_others, VideoCapture::get(), VideoCapture::set()
*/
/** enum cv::VideoCaptureProperties */
public static final int
       /** Current position of the video file in milliseconds. */
       CAP_PROP_POS_MSEC       = 0,
       /** 0-based index of the frame to be decoded/captured next. */
       CAP_PROP_POS_FRAMES     = 1,
       /** Relative position of the video file: 0=start of the film, 1=end of the film. */
       CAP_PROP_POS_AVI_RATIO  = 2,
       /** Width of the frames in the video stream. */
       CAP_PROP_FRAME_WIDTH    = 3,
       /** Height of the frames in the video stream. */
       CAP_PROP_FRAME_HEIGHT   = 4,
       /** Frame rate. */
       CAP_PROP_FPS            = 5,
       /** 4-character code of codec. see VideoWriter::fourcc . */
       CAP_PROP_FOURCC         = 6,
       /** Number of frames in the video file. */
       CAP_PROP_FRAME_COUNT    = 7,
       /** Format of the %Mat objects returned by VideoCapture::retrieve(). */
       CAP_PROP_FORMAT         = 8,
       /** Backend-specific value indicating the current capture mode. */
       CAP_PROP_MODE           = 9,
       /** Brightness of the image (only for those cameras that support). */
       CAP_PROP_BRIGHTNESS    = 10,
       /** Contrast of the image (only for cameras). */
       CAP_PROP_CONTRAST      = 11,
       /** Saturation of the image (only for cameras). */
       CAP_PROP_SATURATION    = 12,
       /** Hue of the image (only for cameras). */
       CAP_PROP_HUE           = 13,
       /** Gain of the image (only for those cameras that support). */
       CAP_PROP_GAIN          = 14,
       /** Exposure (only for those cameras that support). */
       CAP_PROP_EXPOSURE      = 15,
       /** Boolean flags indicating whether images should be converted to RGB. */
       CAP_PROP_CONVERT_RGB   = 16,
       /** Currently unsupported. */
       CAP_PROP_WHITE_BALANCE_BLUE_U = 17,
       /** Rectification flag for stereo cameras (note: only supported by DC1394 v 2.x backend currently). */
       CAP_PROP_RECTIFICATION = 18,
       CAP_PROP_MONOCHROME    = 19,
       CAP_PROP_SHARPNESS     = 20,
       /** DC1394: exposure control done by camera, user can adjust reference level using this feature. */
       CAP_PROP_AUTO_EXPOSURE = 21,
       CAP_PROP_GAMMA         = 22,
       CAP_PROP_TEMPERATURE   = 23,
       CAP_PROP_TRIGGER       = 24,
       CAP_PROP_TRIGGER_DELAY = 25,
       CAP_PROP_WHITE_BALANCE_RED_V = 26,
       CAP_PROP_ZOOM          = 27,
       CAP_PROP_FOCUS         = 28,
       CAP_PROP_GUID          = 29,
       CAP_PROP_ISO_SPEED     = 30,
       CAP_PROP_BACKLIGHT     = 32,
       CAP_PROP_PAN           = 33,
       CAP_PROP_TILT          = 34,
       CAP_PROP_ROLL          = 35,
       CAP_PROP_IRIS          = 36,
       /** Pop up video/camera filter dialog (note: only supported by DSHOW backend currently. The property value is ignored) */
       CAP_PROP_SETTINGS      = 37,
       CAP_PROP_BUFFERSIZE    = 38,
       CAP_PROP_AUTOFOCUS     = 39;


/** \brief Generic camera output modes identifier.
\note Currently, these are supported through the libv4l backend only.
*/
/** enum cv::VideoCaptureModes */
public static final int
       /** BGR24 (default) */
       CAP_MODE_BGR  = 0,
       /** RGB24 */
       CAP_MODE_RGB  = 1,
       /** Y8 */
       CAP_MODE_GRAY = 2,
       /** YUYV */
       CAP_MODE_YUYV = 3;

/** \brief %VideoWriter generic properties identifier.
 \sa VideoWriter::get(), VideoWriter::set()
*/
/** enum cv::VideoWriterProperties */
public static final int
  /** Current quality (0..100%) of the encoded videostream. Can be adjusted dynamically in some codecs. */
  VIDEOWRITER_PROP_QUALITY = 1,
  /** (Read-only): Size of just encoded video frame. Note that the encoding order may be different from representation order. */
  VIDEOWRITER_PROP_FRAMEBYTES = 2,
  /** Number of stripes for parallel encoding. -1 for auto detection. */
  VIDEOWRITER_PROP_NSTRIPES = 3;

/** \} videoio_flags_base
 <p>
 *  \addtogroup videoio_flags_others
 *  \{
<p>
/** \name IEEE 1394 drivers
    \{
*/

/** \brief Modes of the IEEE 1394 controlling registers
(can be: auto, manual, auto single push, absolute Latter allowed with any other mode)
every feature can have only one mode turned on at a time
*/
/** enum cv:: */
public static final int /** turn the feature off (not controlled manually nor automatically). */
 CAP_PROP_DC1394_OFF                = -4,
       /** set automatically when a value of the feature is set by the user. */
       CAP_PROP_DC1394_MODE_MANUAL        = -3,
       CAP_PROP_DC1394_MODE_AUTO          = -2,
       CAP_PROP_DC1394_MODE_ONE_PUSH_AUTO = -1,
       CAP_PROP_DC1394_MAX                = 31;

/** \} IEEE 1394 drivers
<p>
/** \name OpenNI (for Kinect)
    \{
*/

/** OpenNI map generators */
/** enum cv:: */
public static final int CAP_OPENNI_DEPTH_GENERATOR =  1 << 31,
       CAP_OPENNI_IMAGE_GENERATOR =  1 << 30,
       CAP_OPENNI_IR_GENERATOR    =  1 << 29,
       CAP_OPENNI_GENERATORS_MASK =  CAP_OPENNI_DEPTH_GENERATOR + CAP_OPENNI_IMAGE_GENERATOR + CAP_OPENNI_IR_GENERATOR;

/** Properties of cameras available through OpenNI backend */
/** enum cv:: */
public static final int CAP_PROP_OPENNI_OUTPUT_MODE       = 100,
       /** In mm */
       CAP_PROP_OPENNI_FRAME_MAX_DEPTH   = 101,
       /** In mm */
       CAP_PROP_OPENNI_BASELINE          = 102,
       /** In pixels */
       CAP_PROP_OPENNI_FOCAL_LENGTH      = 103,
       /** Flag that synchronizes the remapping depth map to image map
 *  by changing depth generator's view point (if the flag is "on") or
 *  sets this view point to its normal one (if the flag is "off"). */
       CAP_PROP_OPENNI_REGISTRATION      = 104,
       CAP_PROP_OPENNI_REGISTRATION_ON   =  CAP_PROP_OPENNI_REGISTRATION,
       CAP_PROP_OPENNI_APPROX_FRAME_SYNC = 105,
       CAP_PROP_OPENNI_MAX_BUFFER_SIZE   = 106,
       CAP_PROP_OPENNI_CIRCLE_BUFFER     = 107,
       CAP_PROP_OPENNI_MAX_TIME_DURATION = 108,
       CAP_PROP_OPENNI_GENERATOR_PRESENT = 109,
       CAP_PROP_OPENNI2_SYNC             = 110,
       CAP_PROP_OPENNI2_MIRROR           = 111;

/** OpenNI shortcuts */
/** enum cv:: */
public static final int CAP_OPENNI_IMAGE_GENERATOR_PRESENT         =  CAP_OPENNI_IMAGE_GENERATOR + CAP_PROP_OPENNI_GENERATOR_PRESENT,
       CAP_OPENNI_IMAGE_GENERATOR_OUTPUT_MODE     =  CAP_OPENNI_IMAGE_GENERATOR + CAP_PROP_OPENNI_OUTPUT_MODE,
       CAP_OPENNI_DEPTH_GENERATOR_PRESENT         =  CAP_OPENNI_DEPTH_GENERATOR + CAP_PROP_OPENNI_GENERATOR_PRESENT,
       CAP_OPENNI_DEPTH_GENERATOR_BASELINE        =  CAP_OPENNI_DEPTH_GENERATOR + CAP_PROP_OPENNI_BASELINE,
       CAP_OPENNI_DEPTH_GENERATOR_FOCAL_LENGTH    =  CAP_OPENNI_DEPTH_GENERATOR + CAP_PROP_OPENNI_FOCAL_LENGTH,
       CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION    =  CAP_OPENNI_DEPTH_GENERATOR + CAP_PROP_OPENNI_REGISTRATION,
       CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION_ON =  CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION,
       CAP_OPENNI_IR_GENERATOR_PRESENT            =  CAP_OPENNI_IR_GENERATOR + CAP_PROP_OPENNI_GENERATOR_PRESENT;

/** OpenNI data given from depth generator */
/** enum cv:: */
public static final int /** Depth values in mm (CV_16UC1) */
 CAP_OPENNI_DEPTH_MAP         = 0,
       /** XYZ in meters (CV_32FC3) */
       CAP_OPENNI_POINT_CLOUD_MAP   = 1,
       /** Disparity in pixels (CV_8UC1) */
       CAP_OPENNI_DISPARITY_MAP     = 2,
       /** Disparity in pixels (CV_32FC1) */
       CAP_OPENNI_DISPARITY_MAP_32F = 3,
       /** CV_8UC1 */
       CAP_OPENNI_VALID_DEPTH_MASK  = 4,

       /** Data given from RGB image generator */
       CAP_OPENNI_BGR_IMAGE         = 5,
       /** Data given from RGB image generator */
       CAP_OPENNI_GRAY_IMAGE        = 6,

       /** Data given from IR image generator */
       CAP_OPENNI_IR_IMAGE          = 7;

/** Supported output modes of OpenNI image generator */
/** enum cv:: */
public static final int CAP_OPENNI_VGA_30HZ  = 0,
       CAP_OPENNI_SXGA_15HZ = 1,
       CAP_OPENNI_SXGA_30HZ = 2,
       CAP_OPENNI_QVGA_30HZ = 3,
       CAP_OPENNI_QVGA_60HZ = 4;

/** \} OpenNI
<p>
/** \name GStreamer
    \{
*/

/** enum cv:: */
public static final int /** Default is 1 */
 CAP_PROP_GSTREAMER_QUEUE_LENGTH = 200;

/** \} GStreamer
<p>
/** \name PvAPI, Prosilica GigE SDK
    \{
*/

/** PVAPI */
/** enum cv:: */
public static final int /** IP for enable multicast master mode. 0 for disable multicast. */
 CAP_PROP_PVAPI_MULTICASTIP           = 300,
       /** FrameStartTriggerMode: Determines how a frame is initiated. */
       CAP_PROP_PVAPI_FRAMESTARTTRIGGERMODE = 301,
       /** Horizontal sub-sampling of the image. */
       CAP_PROP_PVAPI_DECIMATIONHORIZONTAL  = 302,
       /** Vertical sub-sampling of the image. */
       CAP_PROP_PVAPI_DECIMATIONVERTICAL    = 303,
       /** Horizontal binning factor. */
       CAP_PROP_PVAPI_BINNINGX              = 304,
       /** Vertical binning factor. */
       CAP_PROP_PVAPI_BINNINGY              = 305,
       /** Pixel format. */
       CAP_PROP_PVAPI_PIXELFORMAT           = 306;

/** PVAPI: FrameStartTriggerMode */
/** enum cv:: */
public static final int /** Freerun */
 CAP_PVAPI_FSTRIGMODE_FREERUN     = 0,
       /** SyncIn1 */
       CAP_PVAPI_FSTRIGMODE_SYNCIN1     = 1,
       /** SyncIn2 */
       CAP_PVAPI_FSTRIGMODE_SYNCIN2     = 2,
       /** FixedRate */
       CAP_PVAPI_FSTRIGMODE_FIXEDRATE   = 3,
       /** Software */
       CAP_PVAPI_FSTRIGMODE_SOFTWARE    = 4;

/** PVAPI: DecimationHorizontal, DecimationVertical */
/** enum cv:: */
public static final int /** Off */
 CAP_PVAPI_DECIMATION_OFF       = 1,
       /** 2 out of 4 decimation */
       CAP_PVAPI_DECIMATION_2OUTOF4   = 2,
       /** 2 out of 8 decimation */
       CAP_PVAPI_DECIMATION_2OUTOF8   = 4,
       /** 2 out of 16 decimation */
       CAP_PVAPI_DECIMATION_2OUTOF16  = 8;

/** PVAPI: PixelFormat */
/** enum cv:: */
public static final int /** Mono8 */
 CAP_PVAPI_PIXELFORMAT_MONO8    = 1,
       /** Mono16 */
       CAP_PVAPI_PIXELFORMAT_MONO16   = 2,
       /** Bayer8 */
       CAP_PVAPI_PIXELFORMAT_BAYER8   = 3,
       /** Bayer16 */
       CAP_PVAPI_PIXELFORMAT_BAYER16  = 4,
       /** Rgb24 */
       CAP_PVAPI_PIXELFORMAT_RGB24    = 5,
       /** Bgr24 */
       CAP_PVAPI_PIXELFORMAT_BGR24    = 6,
       /** Rgba32 */
       CAP_PVAPI_PIXELFORMAT_RGBA32   = 7,
       /** Bgra32 */
       CAP_PVAPI_PIXELFORMAT_BGRA32   = 8;

/** \} PvAPI
<p>
/** \name XIMEA Camera API
    \{
*/

/** Properties of cameras available through XIMEA SDK backend */
/** enum cv:: */
public static final int /** Change image resolution by binning or skipping. */
 CAP_PROP_XI_DOWNSAMPLING                                 = 400,
       /** Output data format. */
       CAP_PROP_XI_DATA_FORMAT                                  = 401,
       /** Horizontal offset from the origin to the area of interest (in pixels). */
       CAP_PROP_XI_OFFSET_X                                     = 402,
       /** Vertical offset from the origin to the area of interest (in pixels). */
       CAP_PROP_XI_OFFSET_Y                                     = 403,
       /** Defines source of trigger. */
       CAP_PROP_XI_TRG_SOURCE                                   = 404,
       /** Generates an internal trigger. PRM_TRG_SOURCE must be set to TRG_SOFTWARE. */
       CAP_PROP_XI_TRG_SOFTWARE                                 = 405,
       /** Selects general purpose input. */
       CAP_PROP_XI_GPI_SELECTOR                                 = 406,
       /** Set general purpose input mode. */
       CAP_PROP_XI_GPI_MODE                                     = 407,
       /** Get general purpose level. */
       CAP_PROP_XI_GPI_LEVEL                                    = 408,
       /** Selects general purpose output. */
       CAP_PROP_XI_GPO_SELECTOR                                 = 409,
       /** Set general purpose output mode. */
       CAP_PROP_XI_GPO_MODE                                     = 410,
       /** Selects camera signalling LED. */
       CAP_PROP_XI_LED_SELECTOR                                 = 411,
       /** Define camera signalling LED functionality. */
       CAP_PROP_XI_LED_MODE                                     = 412,
       /** Calculates White Balance(must be called during acquisition). */
       CAP_PROP_XI_MANUAL_WB                                    = 413,
       /** Automatic white balance. */
       CAP_PROP_XI_AUTO_WB                                      = 414,
       /** Automatic exposure/gain. */
       CAP_PROP_XI_AEAG                                         = 415,
       /** Exposure priority (0.5 - exposure 50%, gain 50%). */
       CAP_PROP_XI_EXP_PRIORITY                                 = 416,
       /** Maximum limit of exposure in AEAG procedure. */
       CAP_PROP_XI_AE_MAX_LIMIT                                 = 417,
       /** Maximum limit of gain in AEAG procedure. */
       CAP_PROP_XI_AG_MAX_LIMIT                                 = 418,
       /** Average intensity of output signal AEAG should achieve(in %). */
       CAP_PROP_XI_AEAG_LEVEL                                   = 419,
       /** Image capture timeout in milliseconds. */
       CAP_PROP_XI_TIMEOUT                                      = 420,
       /** Exposure time in microseconds. */
       CAP_PROP_XI_EXPOSURE                                     = 421,
       /** Sets the number of times of exposure in one frame. */
       CAP_PROP_XI_EXPOSURE_BURST_COUNT                         = 422,
       /** Gain selector for parameter Gain allows to select different type of gains. */
       CAP_PROP_XI_GAIN_SELECTOR                                = 423,
       /** Gain in dB. */
       CAP_PROP_XI_GAIN                                         = 424,
       /** Change image downsampling type. */
       CAP_PROP_XI_DOWNSAMPLING_TYPE                            = 426,
       /** Binning engine selector. */
       CAP_PROP_XI_BINNING_SELECTOR                             = 427,
       /** Vertical Binning - number of vertical photo-sensitive cells to combine together. */
       CAP_PROP_XI_BINNING_VERTICAL                             = 428,
       /** Horizontal Binning - number of horizontal photo-sensitive cells to combine together. */
       CAP_PROP_XI_BINNING_HORIZONTAL                           = 429,
       /** Binning pattern type. */
       CAP_PROP_XI_BINNING_PATTERN                              = 430,
       /** Decimation engine selector. */
       CAP_PROP_XI_DECIMATION_SELECTOR                          = 431,
       /** Vertical Decimation - vertical sub-sampling of the image - reduces the vertical resolution of the image by the specified vertical decimation factor. */
       CAP_PROP_XI_DECIMATION_VERTICAL                          = 432,
       /** Horizontal Decimation - horizontal sub-sampling of the image - reduces the horizontal resolution of the image by the specified vertical decimation factor. */
       CAP_PROP_XI_DECIMATION_HORIZONTAL                        = 433,
       /** Decimation pattern type. */
       CAP_PROP_XI_DECIMATION_PATTERN                           = 434,
       /** Selects which test pattern generator is controlled by the TestPattern feature. */
       CAP_PROP_XI_TEST_PATTERN_GENERATOR_SELECTOR              = 587,
       /** Selects which test pattern type is generated by the selected generator. */
       CAP_PROP_XI_TEST_PATTERN                                 = 588,
       /** Output data format. */
       CAP_PROP_XI_IMAGE_DATA_FORMAT                            = 435,
       /** Change sensor shutter type(CMOS sensor). */
       CAP_PROP_XI_SHUTTER_TYPE                                 = 436,
       /** Number of taps. */
       CAP_PROP_XI_SENSOR_TAPS                                  = 437,
       /** Automatic exposure/gain ROI offset X. */
       CAP_PROP_XI_AEAG_ROI_OFFSET_X                            = 439,
       /** Automatic exposure/gain ROI offset Y. */
       CAP_PROP_XI_AEAG_ROI_OFFSET_Y                            = 440,
       /** Automatic exposure/gain ROI Width. */
       CAP_PROP_XI_AEAG_ROI_WIDTH                               = 441,
       /** Automatic exposure/gain ROI Height. */
       CAP_PROP_XI_AEAG_ROI_HEIGHT                              = 442,
       /** Correction of bad pixels. */
       CAP_PROP_XI_BPC                                          = 445,
       /** White balance red coefficient. */
       CAP_PROP_XI_WB_KR                                        = 448,
       /** White balance green coefficient. */
       CAP_PROP_XI_WB_KG                                        = 449,
       /** White balance blue coefficient. */
       CAP_PROP_XI_WB_KB                                        = 450,
       /** Width of the Image provided by the device (in pixels). */
       CAP_PROP_XI_WIDTH                                        = 451,
       /** Height of the Image provided by the device (in pixels). */
       CAP_PROP_XI_HEIGHT                                       = 452,
       /** Selects Region in Multiple ROI which parameters are set by width, height, ... ,region mode. */
       CAP_PROP_XI_REGION_SELECTOR                              = 589,
       /** Activates/deactivates Region selected by Region Selector. */
       CAP_PROP_XI_REGION_MODE                                  = 595,
       /** Set/get bandwidth(datarate)(in Megabits). */
       CAP_PROP_XI_LIMIT_BANDWIDTH                              = 459,
       /** Sensor output data bit depth. */
       CAP_PROP_XI_SENSOR_DATA_BIT_DEPTH                        = 460,
       /** Device output data bit depth. */
       CAP_PROP_XI_OUTPUT_DATA_BIT_DEPTH                        = 461,
       /** bitdepth of data returned by function xiGetImage. */
       CAP_PROP_XI_IMAGE_DATA_BIT_DEPTH                         = 462,
       /** Device output data packing (or grouping) enabled. Packing could be enabled if output_data_bit_depth > 8 and packing capability is available. */
       CAP_PROP_XI_OUTPUT_DATA_PACKING                          = 463,
       /** Data packing type. Some cameras supports only specific packing type. */
       CAP_PROP_XI_OUTPUT_DATA_PACKING_TYPE                     = 464,
       /** Returns 1 for cameras that support cooling. */
       CAP_PROP_XI_IS_COOLED                                    = 465,
       /** Start camera cooling. */
       CAP_PROP_XI_COOLING                                      = 466,
       /** Set sensor target temperature for cooling. */
       CAP_PROP_XI_TARGET_TEMP                                  = 467,
       /** Camera sensor temperature. */
       CAP_PROP_XI_CHIP_TEMP                                    = 468,
       /** Camera housing temperature. */
       CAP_PROP_XI_HOUS_TEMP                                    = 469,
       /** Camera housing back side temperature. */
       CAP_PROP_XI_HOUS_BACK_SIDE_TEMP                          = 590,
       /** Camera sensor board temperature. */
       CAP_PROP_XI_SENSOR_BOARD_TEMP                            = 596,
       /** Mode of color management system. */
       CAP_PROP_XI_CMS                                          = 470,
       /** Enable applying of CMS profiles to xiGetImage (see XI_PRM_INPUT_CMS_PROFILE, XI_PRM_OUTPUT_CMS_PROFILE). */
       CAP_PROP_XI_APPLY_CMS                                    = 471,
       /** Returns 1 for color cameras. */
       CAP_PROP_XI_IMAGE_IS_COLOR                               = 474,
       /** Returns color filter array type of RAW data. */
       CAP_PROP_XI_COLOR_FILTER_ARRAY                           = 475,
       /** Luminosity gamma. */
       CAP_PROP_XI_GAMMAY                                       = 476,
       /** Chromaticity gamma. */
       CAP_PROP_XI_GAMMAC                                       = 477,
       /** Sharpness Strength. */
       CAP_PROP_XI_SHARPNESS                                    = 478,
       /** Color Correction Matrix element [0][0]. */
       CAP_PROP_XI_CC_MATRIX_00                                 = 479,
       /** Color Correction Matrix element [0][1]. */
       CAP_PROP_XI_CC_MATRIX_01                                 = 480,
       /** Color Correction Matrix element [0][2]. */
       CAP_PROP_XI_CC_MATRIX_02                                 = 481,
       /** Color Correction Matrix element [0][3]. */
       CAP_PROP_XI_CC_MATRIX_03                                 = 482,
       /** Color Correction Matrix element [1][0]. */
       CAP_PROP_XI_CC_MATRIX_10                                 = 483,
       /** Color Correction Matrix element [1][1]. */
       CAP_PROP_XI_CC_MATRIX_11                                 = 484,
       /** Color Correction Matrix element [1][2]. */
       CAP_PROP_XI_CC_MATRIX_12                                 = 485,
       /** Color Correction Matrix element [1][3]. */
       CAP_PROP_XI_CC_MATRIX_13                                 = 486,
       /** Color Correction Matrix element [2][0]. */
       CAP_PROP_XI_CC_MATRIX_20                                 = 487,
       /** Color Correction Matrix element [2][1]. */
       CAP_PROP_XI_CC_MATRIX_21                                 = 488,
       /** Color Correction Matrix element [2][2]. */
       CAP_PROP_XI_CC_MATRIX_22                                 = 489,
       /** Color Correction Matrix element [2][3]. */
       CAP_PROP_XI_CC_MATRIX_23                                 = 490,
       /** Color Correction Matrix element [3][0]. */
       CAP_PROP_XI_CC_MATRIX_30                                 = 491,
       /** Color Correction Matrix element [3][1]. */
       CAP_PROP_XI_CC_MATRIX_31                                 = 492,
       /** Color Correction Matrix element [3][2]. */
       CAP_PROP_XI_CC_MATRIX_32                                 = 493,
       /** Color Correction Matrix element [3][3]. */
       CAP_PROP_XI_CC_MATRIX_33                                 = 494,
       /** Set default Color Correction Matrix. */
       CAP_PROP_XI_DEFAULT_CC_MATRIX                            = 495,
       /** Selects the type of trigger. */
       CAP_PROP_XI_TRG_SELECTOR                                 = 498,
       /** Sets number of frames acquired by burst. This burst is used only if trigger is set to FrameBurstStart. */
       CAP_PROP_XI_ACQ_FRAME_BURST_COUNT                        = 499,
       /** Enable/Disable debounce to selected GPI. */
       CAP_PROP_XI_DEBOUNCE_EN                                  = 507,
       /** Debounce time (x * 10us). */
       CAP_PROP_XI_DEBOUNCE_T0                                  = 508,
       /** Debounce time (x * 10us). */
       CAP_PROP_XI_DEBOUNCE_T1                                  = 509,
       /** Debounce polarity (pol = 1 t0 - falling edge, t1 - rising edge). */
       CAP_PROP_XI_DEBOUNCE_POL                                 = 510,
       /** Status of lens control interface. This shall be set to XI_ON before any Lens operations. */
       CAP_PROP_XI_LENS_MODE                                    = 511,
       /** Current lens aperture value in stops. Examples: 2.8, 4, 5.6, 8, 11. */
       CAP_PROP_XI_LENS_APERTURE_VALUE                          = 512,
       /** Lens current focus movement value to be used by XI_PRM_LENS_FOCUS_MOVE in motor steps. */
       CAP_PROP_XI_LENS_FOCUS_MOVEMENT_VALUE                    = 513,
       /** Moves lens focus motor by steps set in XI_PRM_LENS_FOCUS_MOVEMENT_VALUE. */
       CAP_PROP_XI_LENS_FOCUS_MOVE                              = 514,
       /** Lens focus distance in cm. */
       CAP_PROP_XI_LENS_FOCUS_DISTANCE                          = 515,
       /** Lens focal distance in mm. */
       CAP_PROP_XI_LENS_FOCAL_LENGTH                            = 516,
       /** Selects the current feature which is accessible by XI_PRM_LENS_FEATURE. */
       CAP_PROP_XI_LENS_FEATURE_SELECTOR                        = 517,
       /** Allows access to lens feature value currently selected by XI_PRM_LENS_FEATURE_SELECTOR. */
       CAP_PROP_XI_LENS_FEATURE                                 = 518,
       /** Returns device model id. */
       CAP_PROP_XI_DEVICE_MODEL_ID                              = 521,
       /** Returns device serial number. */
       CAP_PROP_XI_DEVICE_SN                                    = 522,
       /** The alpha channel of RGB32 output image format. */
       CAP_PROP_XI_IMAGE_DATA_FORMAT_RGB32_ALPHA                = 529,
       /** Buffer size in bytes sufficient for output image returned by xiGetImage. */
       CAP_PROP_XI_IMAGE_PAYLOAD_SIZE                           = 530,
       /** Current format of pixels on transport layer. */
       CAP_PROP_XI_TRANSPORT_PIXEL_FORMAT                       = 531,
       /** Sensor clock frequency in Hz. */
       CAP_PROP_XI_SENSOR_CLOCK_FREQ_HZ                         = 532,
       /** Sensor clock frequency index. Sensor with selected frequencies have possibility to set the frequency only by this index. */
       CAP_PROP_XI_SENSOR_CLOCK_FREQ_INDEX                      = 533,
       /** Number of output channels from sensor used for data transfer. */
       CAP_PROP_XI_SENSOR_OUTPUT_CHANNEL_COUNT                  = 534,
       /** Define framerate in Hz. */
       CAP_PROP_XI_FRAMERATE                                    = 535,
       /** Select counter. */
       CAP_PROP_XI_COUNTER_SELECTOR                             = 536,
       /** Counter status. */
       CAP_PROP_XI_COUNTER_VALUE                                = 537,
       /** Type of sensor frames timing. */
       CAP_PROP_XI_ACQ_TIMING_MODE                              = 538,
       /** Calculate and returns available interface bandwidth(int Megabits). */
       CAP_PROP_XI_AVAILABLE_BANDWIDTH                          = 539,
       /** Data move policy. */
       CAP_PROP_XI_BUFFER_POLICY                                = 540,
       /** Activates LUT. */
       CAP_PROP_XI_LUT_EN                                       = 541,
       /** Control the index (offset) of the coefficient to access in the LUT. */
       CAP_PROP_XI_LUT_INDEX                                    = 542,
       /** Value at entry LUTIndex of the LUT. */
       CAP_PROP_XI_LUT_VALUE                                    = 543,
       /** Specifies the delay in microseconds (us) to apply after the trigger reception before activating it. */
       CAP_PROP_XI_TRG_DELAY                                    = 544,
       /** Defines how time stamp reset engine will be armed. */
       CAP_PROP_XI_TS_RST_MODE                                  = 545,
       /** Defines which source will be used for timestamp reset. Writing this parameter will trigger settings of engine (arming). */
       CAP_PROP_XI_TS_RST_SOURCE                                = 546,
       /** Returns 1 if camera connected and works properly. */
       CAP_PROP_XI_IS_DEVICE_EXIST                              = 547,
       /** Acquisition buffer size in buffer_size_unit. Default bytes. */
       CAP_PROP_XI_ACQ_BUFFER_SIZE                              = 548,
       /** Acquisition buffer size unit in bytes. Default 1. E.g. Value 1024 means that buffer_size is in KiBytes. */
       CAP_PROP_XI_ACQ_BUFFER_SIZE_UNIT                         = 549,
       /** Acquisition transport buffer size in bytes. */
       CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_SIZE                    = 550,
       /** Queue of field/frame buffers. */
       CAP_PROP_XI_BUFFERS_QUEUE_SIZE                           = 551,
       /** Number of buffers to commit to low level. */
       CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_COMMIT                  = 552,
       /** GetImage returns most recent frame. */
       CAP_PROP_XI_RECENT_FRAME                                 = 553,
       /** Resets the camera to default state. */
       CAP_PROP_XI_DEVICE_RESET                                 = 554,
       /** Correction of column FPN. */
       CAP_PROP_XI_COLUMN_FPN_CORRECTION                        = 555,
       /** Correction of row FPN. */
       CAP_PROP_XI_ROW_FPN_CORRECTION                           = 591,
       /** Current sensor mode. Allows to select sensor mode by one integer. Setting of this parameter affects: image dimensions and downsampling. */
       CAP_PROP_XI_SENSOR_MODE                                  = 558,
       /** Enable High Dynamic Range feature. */
       CAP_PROP_XI_HDR                                          = 559,
       /** The number of kneepoints in the PWLR. */
       CAP_PROP_XI_HDR_KNEEPOINT_COUNT                          = 560,
       /** Position of first kneepoint(in % of XI_PRM_EXPOSURE). */
       CAP_PROP_XI_HDR_T1                                       = 561,
       /** Position of second kneepoint (in % of XI_PRM_EXPOSURE). */
       CAP_PROP_XI_HDR_T2                                       = 562,
       /** Value of first kneepoint (% of sensor saturation). */
       CAP_PROP_XI_KNEEPOINT1                                   = 563,
       /** Value of second kneepoint (% of sensor saturation). */
       CAP_PROP_XI_KNEEPOINT2                                   = 564,
       /** Last image black level counts. Can be used for Offline processing to recall it. */
       CAP_PROP_XI_IMAGE_BLACK_LEVEL                            = 565,
       /** Returns hardware revision number. */
       CAP_PROP_XI_HW_REVISION                                  = 571,
       /** Set debug level. */
       CAP_PROP_XI_DEBUG_LEVEL                                  = 572,
       /** Automatic bandwidth calculation. */
       CAP_PROP_XI_AUTO_BANDWIDTH_CALCULATION                   = 573,
       /** File number. */
       CAP_PROP_XI_FFS_FILE_ID                                  = 594,
       /** Size of file. */
       CAP_PROP_XI_FFS_FILE_SIZE                                = 580,
       /** Size of free camera FFS. */
       CAP_PROP_XI_FREE_FFS_SIZE                                = 581,
       /** Size of used camera FFS. */
       CAP_PROP_XI_USED_FFS_SIZE                                = 582,
       /** Setting of key enables file operations on some cameras. */
       CAP_PROP_XI_FFS_ACCESS_KEY                               = 583,
       /** Selects the current feature which is accessible by XI_PRM_SENSOR_FEATURE_VALUE. */
       CAP_PROP_XI_SENSOR_FEATURE_SELECTOR                      = 585,
       /** Allows access to sensor feature value currently selected by XI_PRM_SENSOR_FEATURE_SELECTOR. */
       CAP_PROP_XI_SENSOR_FEATURE_VALUE                         = 586;

/** \} XIMEA
<p>
/** \name AVFoundation framework for iOS
    OS X Lion will have the same API
    \{
*/

/** Properties of cameras available through AVFOUNDATION backend */
/** enum cv:: */
public static final int CAP_PROP_IOS_DEVICE_FOCUS        = 9001,
       CAP_PROP_IOS_DEVICE_EXPOSURE     = 9002,
       CAP_PROP_IOS_DEVICE_FLASH        = 9003,
       CAP_PROP_IOS_DEVICE_WHITEBALANCE = 9004,
       CAP_PROP_IOS_DEVICE_TORCH        = 9005;

/** \name Smartek Giganetix GigEVisionSDK
    \{
*/

/** Properties of cameras available through Smartek Giganetix Ethernet Vision backend */
/* --- Vladimir Litvinenko (litvinenko.vladimir@gmail.com) --- */
/** enum cv:: */
public static final int CAP_PROP_GIGA_FRAME_OFFSET_X   = 10001,
       CAP_PROP_GIGA_FRAME_OFFSET_Y   = 10002,
       CAP_PROP_GIGA_FRAME_WIDTH_MAX  = 10003,
       CAP_PROP_GIGA_FRAME_HEIGH_MAX  = 10004,
       CAP_PROP_GIGA_FRAME_SENS_WIDTH = 10005,
       CAP_PROP_GIGA_FRAME_SENS_HEIGH = 10006;

/** \} Smartek
<p>
/** \name Intel Perceptual Computing SDK
    \{
*/
/** enum cv:: */
public static final int CAP_PROP_INTELPERC_PROFILE_COUNT               = 11001,
       CAP_PROP_INTELPERC_PROFILE_IDX                 = 11002,
       CAP_PROP_INTELPERC_DEPTH_LOW_CONFIDENCE_VALUE  = 11003,
       CAP_PROP_INTELPERC_DEPTH_SATURATION_VALUE      = 11004,
       CAP_PROP_INTELPERC_DEPTH_CONFIDENCE_THRESHOLD  = 11005,
       CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_HORZ     = 11006,
       CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_VERT     = 11007;

/** Intel Perceptual Streams */
/** enum cv:: */
public static final int CAP_INTELPERC_DEPTH_GENERATOR =  1 << 29,
       CAP_INTELPERC_IMAGE_GENERATOR =  1 << 28,
       CAP_INTELPERC_GENERATORS_MASK =  CAP_INTELPERC_DEPTH_GENERATOR + CAP_INTELPERC_IMAGE_GENERATOR;

/** enum cv:: */
public static final int /** Each pixel is a 16-bit integer. The value indicates the distance from an object to the camera's XY plane or the Cartesian depth. */
 CAP_INTELPERC_DEPTH_MAP              = 0,
       /** Each pixel contains two 32-bit floating point values in the range of 0-1, representing the mapping of depth coordinates to the color coordinates. */
       CAP_INTELPERC_UVDEPTH_MAP            = 1,
       /** Each pixel is a 16-bit integer. The value indicates the intensity of the reflected laser beam. */
       CAP_INTELPERC_IR_MAP                 = 2,
       CAP_INTELPERC_IMAGE                  = 3;

/** \} Intel Perceptual
<p>
/** \name gPhoto2 connection
    \{
*/

/** \brief gPhoto2 properties
<p>
If {@code propertyId} is less than 0 then work on widget with that __additive inversed__ camera setting ID
Get IDs by using CAP_PROP_GPHOTO2_WIDGET_ENUMERATE.
@see CvCaptureCAM_GPHOTO2 for more info
*/
/** enum cv:: */
public static final int /** Capture only preview from liveview mode. */
 CAP_PROP_GPHOTO2_PREVIEW           = 17001,
       /** Readonly, returns (const char *). */
       CAP_PROP_GPHOTO2_WIDGET_ENUMERATE  = 17002,
       /** Trigger, only by set. Reload camera settings. */
       CAP_PROP_GPHOTO2_RELOAD_CONFIG     = 17003,
       /** Reload all settings on set. */
       CAP_PROP_GPHOTO2_RELOAD_ON_CHANGE  = 17004,
       /** Collect messages with details. */
       CAP_PROP_GPHOTO2_COLLECT_MSGS      = 17005,
       /** Readonly, returns (const char *). */
       CAP_PROP_GPHOTO2_FLUSH_MSGS        = 17006,
       /** Exposure speed. Can be readonly, depends on camera program. */
       CAP_PROP_SPEED                     = 17007,
       /** Aperture. Can be readonly, depends on camera program. */
       CAP_PROP_APERTURE                  = 17008,
       /** Camera exposure program. */
       CAP_PROP_EXPOSUREPROGRAM           = 17009,
       /** Enter liveview mode. */
       CAP_PROP_VIEWFINDER                = 17010;

/** \} gPhoto2
<p>
<p>
/** \name Images backend
    \{
*/

/** \brief Images backend properties
<p>
*/
/** enum cv:: */
public static final int CAP_PROP_IMAGES_BASE = 18000,
       CAP_PROP_IMAGES_LAST = 19000; // excluding

/** \} Images
 <p>
 *  \} videoio_flags_others */


@Namespace("cv") @Opaque public static class IVideoCapture extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public IVideoCapture() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IVideoCapture(Pointer p) { super(p); }
}

/** \brief Class for video capturing from video files, image sequences or cameras.
<p>
The class provides C++ API for capturing video from cameras or for reading video files and image sequences.
<p>
Here is how the class can be used:
\include samples/cpp/videocapture_basic.cpp
<p>
\note In \ref videoio_c "C API" the black-box structure {@code CvCapture} is used instead of %VideoCapture.
\note
-   (C++) A basic sample on using the %VideoCapture interface can be found at
    {@code OPENCV_SOURCE_CODE/samples/cpp/videocapture_starter.cpp}
-   (Python) A basic sample on using the %VideoCapture interface can be found at
    {@code OPENCV_SOURCE_CODE/samples/python/video.py}
-   (Python) A multi threaded video processing sample can be found at
    {@code OPENCV_SOURCE_CODE/samples/python/video_threaded.py}
-   (Python) %VideoCapture sample showcasing some features of the Video4Linux2 backend
    {@code OPENCV_SOURCE_CODE/samples/python/video_v4l2.py}
 */
@Namespace("cv") @NoOffset public static class VideoCapture extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public VideoCapture(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public VideoCapture(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public VideoCapture position(long position) {
        return (VideoCapture)super.position(position);
    }

    /** \brief Default constructor
    \note In \ref videoio_c "C API", when you finished working with video, release CvCapture structure with
    cvReleaseCapture(), or use Ptr\<CvCapture\> that calls cvReleaseCapture() automatically in the
    destructor.
     */
    public VideoCapture() { super((Pointer)null); allocate(); }
    private native void allocate();

    /** \overload
    \brief  Open video file or a capturing device or a IP video stream for video capturing
    <p>
    Same as VideoCapture(const String& filename, int apiPreference) but using default Capture API backends
    */
    public VideoCapture(@Str BytePointer filename) { super((Pointer)null); allocate(filename); }
    private native void allocate(@Str BytePointer filename);
    public VideoCapture(@Str String filename) { super((Pointer)null); allocate(filename); }
    private native void allocate(@Str String filename);

    /** \overload
    \brief  Open video file or a capturing device or a IP video stream for video capturing with API Preference
    <p>
    @param filename it can be:
    - name of video file (eg. {@code video.avi})
    - or image sequence (eg. {@code img_%02d.jpg}, which will read samples like {@code img_00.jpg, img_01.jpg, img_02.jpg, ...})
    - or URL of video stream (eg. {@code protocol://host:port/script_name?script_params|auth}).
      Note that each video stream or IP camera feed has its own URL scheme. Please refer to the
      documentation of source stream to know the right URL.
    @param apiPreference preferred Capture API backends to use. Can be used to enforce a specific reader
    implementation if multiple are available: e.g. cv::CAP_FFMPEG or cv::CAP_IMAGES or cv::CAP_DSHOW.
    \sa The list of supported API backends cv::VideoCaptureAPIs
    */
    public VideoCapture(@Str BytePointer filename, int apiPreference) { super((Pointer)null); allocate(filename, apiPreference); }
    private native void allocate(@Str BytePointer filename, int apiPreference);
    public VideoCapture(@Str String filename, int apiPreference) { super((Pointer)null); allocate(filename, apiPreference); }
    private native void allocate(@Str String filename, int apiPreference);

    /** \overload
    \brief  Open a camera for video capturing
    <p>
    @param index camera_id + domain_offset (CAP_*) id of the video capturing device to open. To open default camera using default backend just pass 0.
    Use a {@code domain_offset} to enforce a specific reader implementation if multiple are available like cv::CAP_FFMPEG or cv::CAP_IMAGES or cv::CAP_DSHOW.
    e.g. to open Camera 1 using the MS Media Foundation API use {@code index = 1 + cv::CAP_MSMF}
    <p>
    \sa The list of supported API backends cv::VideoCaptureAPIs
    */
    public VideoCapture(int index) { super((Pointer)null); allocate(index); }
    private native void allocate(int index);

    /** \brief Default destructor
    <p>
    The method first calls VideoCapture::release to close the already opened file or camera.
    */

    /** \brief  Open video file or a capturing device or a IP video stream for video capturing
    <p>
    \overload
    <p>
    Parameters are same as the constructor VideoCapture(const String& filename)
    @return {@code true} if the file has been successfully opened
    <p>
    The method first calls VideoCapture::release to close the already opened file or camera.
     */
    public native @Cast("bool") boolean open(@Str BytePointer filename);
    public native @Cast("bool") boolean open(@Str String filename);

    /** \brief  Open a camera for video capturing
    <p>
    \overload
    <p>
    Parameters are same as the constructor VideoCapture(int index)
    @return {@code true} if the camera has been successfully opened.
    <p>
    The method first calls VideoCapture::release to close the already opened file or camera.
    */
    public native @Cast("bool") boolean open(int index);

   /** \brief  Open a camera for video capturing
    <p>
    \overload
    <p>
    Parameters are similar as the constructor VideoCapture(int index),except it takes an additional argument apiPreference.
    Definitely, is same as open(int index) where {@code index=cameraNum + apiPreference}
    @return {@code true} if the camera has been successfully opened.
    */
    public native @Cast("bool") boolean open(int cameraNum, int apiPreference);

    /** \brief Returns true if video capturing has been initialized already.
    <p>
    If the previous call to VideoCapture constructor or VideoCapture::open() succeeded, the method returns
    true.
     */
    public native @Cast("bool") boolean isOpened();

    /** \brief Closes video file or capturing device.
    <p>
    The method is automatically called by subsequent VideoCapture::open and by VideoCapture
    destructor.
    <p>
    The C function also deallocates memory and clears \*capture pointer.
     */
    public native void release();

    /** \brief Grabs the next frame from video file or capturing device.
    <p>
    @return {@code true} (non-zero) in the case of success.
    <p>
    The method/function grabs the next frame from video file or camera and returns true (non-zero) in
    the case of success.
    <p>
    The primary use of the function is in multi-camera environments, especially when the cameras do not
    have hardware synchronization. That is, you call VideoCapture::grab() for each camera and after that
    call the slower method VideoCapture::retrieve() to decode and get frame from each camera. This way
    the overhead on demosaicing or motion jpeg decompression etc. is eliminated and the retrieved frames
    from different cameras will be closer in time.
    <p>
    Also, when a connected camera is multi-head (for example, a stereo camera or a Kinect device), the
    correct way of retrieving data from it is to call VideoCapture::grab() first and then call
    VideoCapture::retrieve() one or more times with different values of the channel parameter.
    <p>
    \ref tutorial_kinect_openni
     */
    public native @Cast("bool") boolean grab();

    /** \brief Decodes and returns the grabbed video frame.
    <p>
    @param [out] image the video frame is returned here. If no frames has been grabbed the image will be empty.
    @param flag it could be a frame index or a driver specific flag
    @return {@code false} if no frames has been grabbed
    <p>
    The method decodes and returns the just grabbed frame. If no frames has been grabbed
    (camera has been disconnected, or there are no more frames in video file), the method returns false
    and the function returns an empty image (with %cv::Mat, test it with Mat::empty()).
    <p>
    \sa read()
    <p>
    \note In \ref videoio_c "C API", functions cvRetrieveFrame() and cv.RetrieveFrame() return image stored inside the video
    capturing structure. It is not allowed to modify or release the image! You can copy the frame using
    :ocvcvCloneImage and then do whatever you want with the copy.
     */
    public native @Cast("bool") boolean retrieve(@ByVal Mat image, int flag/*=0*/);
    public native @Cast("bool") boolean retrieve(@ByVal Mat image);
    public native @Cast("bool") boolean retrieve(@ByVal UMat image, int flag/*=0*/);
    public native @Cast("bool") boolean retrieve(@ByVal UMat image);
    public native @Cast("bool") boolean retrieve(@ByVal GpuMat image, int flag/*=0*/);
    public native @Cast("bool") boolean retrieve(@ByVal GpuMat image);

    /** \brief Stream operator to read the next video frame.
    \sa read()
    */
    public native @ByRef @Name("operator >>") VideoCapture shiftRight(@ByRef Mat image);

    /** \overload
    \sa read()
    */
    public native @ByRef @Name("operator >>") VideoCapture shiftRight(@ByRef UMat image);

    /** \brief Grabs, decodes and returns the next video frame.
    <p>
    @param [out] image the video frame is returned here. If no frames has been grabbed the image will be empty.
    @return {@code false} if no frames has been grabbed
    <p>
    The method/function combines VideoCapture::grab() and VideoCapture::retrieve() in one call. This is the
    most convenient method for reading video files or capturing data from decode and returns the just
    grabbed frame. If no frames has been grabbed (camera has been disconnected, or there are no more
    frames in video file), the method returns false and the function returns empty image (with %cv::Mat, test it with Mat::empty()).
    <p>
    \note In \ref videoio_c "C API", functions cvRetrieveFrame() and cv.RetrieveFrame() return image stored inside the video
    capturing structure. It is not allowed to modify or release the image! You can copy the frame using
    :ocvcvCloneImage and then do whatever you want with the copy.
     */
    public native @Cast("bool") boolean read(@ByVal Mat image);
    public native @Cast("bool") boolean read(@ByVal UMat image);
    public native @Cast("bool") boolean read(@ByVal GpuMat image);

    /** \brief Sets a property in the VideoCapture.
    <p>
    @param propId Property identifier from cv::VideoCaptureProperties (eg. cv::CAP_PROP_POS_MSEC, cv::CAP_PROP_POS_FRAMES, ...)
    or one from \ref videoio_flags_others
    @param value Value of the property.
    @return {@code true} if the property is supported by backend used by the VideoCapture instance.
    \note Even if it returns {@code true} this doesn't ensure that the property
    value has been accepted by the capture device. See note in VideoCapture::get()
     */
    public native @Cast("bool") boolean set(int propId, double value);

    /** \brief Returns the specified VideoCapture property
    <p>
    @param propId Property identifier from cv::VideoCaptureProperties (eg. cv::CAP_PROP_POS_MSEC, cv::CAP_PROP_POS_FRAMES, ...)
    or one from \ref videoio_flags_others
    @return Value for the specified property. Value 0 is returned when querying a property that is
    not supported by the backend used by the VideoCapture instance.
    <p>
    \note Reading / writing properties involves many layers. Some unexpected result might happens
    along this chain.
    <pre>{@code {.txt}
    `VideoCapture -> API Backend -> Operating System -> Device Driver -> Device Hardware`
    }</pre>
    The returned value might be different from what really used by the device or it could be encoded
    using device dependant rules (eg. steps or percentage). Effective behaviour depends from device
    driver and API Backend
    <p>
    */
    public native double get(int propId);

    /** \brief Open video file or a capturing device or a IP video stream for video capturing with API Preference
    <p>
    \overload
    <p>
    Parameters are same as the constructor VideoCapture(const String& filename, int apiPreference)
    @return {@code true} if the file has been successfully opened
    <p>
    The method first calls VideoCapture::release to close the already opened file or camera.
    */
    public native @Cast("bool") boolean open(@Str BytePointer filename, int apiPreference);
    public native @Cast("bool") boolean open(@Str String filename, int apiPreference);
}

@Namespace("cv") @Opaque public static class IVideoWriter extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public IVideoWriter() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IVideoWriter(Pointer p) { super(p); }
}

/** \example videowriter_basic.cpp
An example using VideoCapture and VideoWriter class
 */
/** \brief Video writer class.
<p>
The class provides C++ API for writing video files or image sequences.
 */
@Namespace("cv") @NoOffset public static class VideoWriter extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public VideoWriter(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public VideoWriter(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public VideoWriter position(long position) {
        return (VideoWriter)super.position(position);
    }

    /** \brief Default constructors
    <p>
    The constructors/functions initialize video writers.
    -   On Linux FFMPEG is used to write videos;
    -   On Windows FFMPEG or VFW is used;
    -   On MacOSX QTKit is used.
     */
    public VideoWriter() { super((Pointer)null); allocate(); }
    private native void allocate();

    /** \overload
    @param filename Name of the output video file.
    @param fourcc 4-character code of codec used to compress the frames. For example,
    VideoWriter::fourcc('P','I','M','1') is a MPEG-1 codec, VideoWriter::fourcc('M','J','P','G') is a
    motion-jpeg codec etc. List of codes can be obtained at [Video Codecs by
    FOURCC](http://www.fourcc.org/codecs.php) page. FFMPEG backend with MP4 container natively uses
    other values as fourcc code: see [ObjectType](http://www.mp4ra.org/codecs.html),
    so you may receive a warning message from OpenCV about fourcc code conversion.
    @param fps Framerate of the created video stream.
    @param frameSize Size of the video frames.
    @param isColor If it is not zero, the encoder will expect and encode color frames, otherwise it
    will work with grayscale frames (the flag is currently supported on Windows only).
    <p>
    \b Tips:
    - With some backends {@code fourcc=-1} pops up the codec selection dialog from the system.
    - To save image sequence use a proper filename (eg. {@code img_%02d.jpg}) and {@code fourcc=0}
      OR {@code fps=0}. Use uncompressed image format (eg. {@code img_%02d.BMP}) to save raw frames.
    - Most codecs are lossy. If you want lossless video file you need to use a lossless codecs
      (eg. FFMPEG FFV1, Huffman HFYU, Lagarith LAGS, etc...)
    - If FFMPEG is enabled, using {@code codec=0; fps=0;} you can create an uncompressed (raw) video file.
    */
    public VideoWriter(@Str BytePointer filename, int fourcc, double fps,
                    @ByVal Size frameSize, @Cast("bool") boolean isColor/*=true*/) { super((Pointer)null); allocate(filename, fourcc, fps, frameSize, isColor); }
    private native void allocate(@Str BytePointer filename, int fourcc, double fps,
                    @ByVal Size frameSize, @Cast("bool") boolean isColor/*=true*/);
    public VideoWriter(@Str BytePointer filename, int fourcc, double fps,
                    @ByVal Size frameSize) { super((Pointer)null); allocate(filename, fourcc, fps, frameSize); }
    private native void allocate(@Str BytePointer filename, int fourcc, double fps,
                    @ByVal Size frameSize);
    public VideoWriter(@Str String filename, int fourcc, double fps,
                    @ByVal Size frameSize, @Cast("bool") boolean isColor/*=true*/) { super((Pointer)null); allocate(filename, fourcc, fps, frameSize, isColor); }
    private native void allocate(@Str String filename, int fourcc, double fps,
                    @ByVal Size frameSize, @Cast("bool") boolean isColor/*=true*/);
    public VideoWriter(@Str String filename, int fourcc, double fps,
                    @ByVal Size frameSize) { super((Pointer)null); allocate(filename, fourcc, fps, frameSize); }
    private native void allocate(@Str String filename, int fourcc, double fps,
                    @ByVal Size frameSize);

    /** \overload
    The {@code apiPreference} parameter allows to specify API backends to use. Can be used to enforce a specific reader implementation
    if multiple are available: e.g. cv::CAP_FFMPEG or cv::CAP_GSTREAMER.
     */
    public VideoWriter(@Str BytePointer filename, int apiPreference, int fourcc, double fps,
                    @ByVal Size frameSize, @Cast("bool") boolean isColor/*=true*/) { super((Pointer)null); allocate(filename, apiPreference, fourcc, fps, frameSize, isColor); }
    private native void allocate(@Str BytePointer filename, int apiPreference, int fourcc, double fps,
                    @ByVal Size frameSize, @Cast("bool") boolean isColor/*=true*/);
    public VideoWriter(@Str BytePointer filename, int apiPreference, int fourcc, double fps,
                    @ByVal Size frameSize) { super((Pointer)null); allocate(filename, apiPreference, fourcc, fps, frameSize); }
    private native void allocate(@Str BytePointer filename, int apiPreference, int fourcc, double fps,
                    @ByVal Size frameSize);
    public VideoWriter(@Str String filename, int apiPreference, int fourcc, double fps,
                    @ByVal Size frameSize, @Cast("bool") boolean isColor/*=true*/) { super((Pointer)null); allocate(filename, apiPreference, fourcc, fps, frameSize, isColor); }
    private native void allocate(@Str String filename, int apiPreference, int fourcc, double fps,
                    @ByVal Size frameSize, @Cast("bool") boolean isColor/*=true*/);
    public VideoWriter(@Str String filename, int apiPreference, int fourcc, double fps,
                    @ByVal Size frameSize) { super((Pointer)null); allocate(filename, apiPreference, fourcc, fps, frameSize); }
    private native void allocate(@Str String filename, int apiPreference, int fourcc, double fps,
                    @ByVal Size frameSize);

    /** \brief Default destructor
    <p>
    The method first calls VideoWriter::release to close the already opened file.
    */

    /** \brief Initializes or reinitializes video writer.
    <p>
    The method opens video writer. Parameters are the same as in the constructor
    VideoWriter::VideoWriter.
    @return {@code true} if video writer has been successfully initialized
    <p>
    The method first calls VideoWriter::release to close the already opened file.
     */
    public native @Cast("bool") boolean open(@Str BytePointer filename, int fourcc, double fps,
                          @ByVal Size frameSize, @Cast("bool") boolean isColor/*=true*/);
    public native @Cast("bool") boolean open(@Str BytePointer filename, int fourcc, double fps,
                          @ByVal Size frameSize);
    public native @Cast("bool") boolean open(@Str String filename, int fourcc, double fps,
                          @ByVal Size frameSize, @Cast("bool") boolean isColor/*=true*/);
    public native @Cast("bool") boolean open(@Str String filename, int fourcc, double fps,
                          @ByVal Size frameSize);

    /** \overload
     */
    public native @Cast("bool") boolean open(@Str BytePointer filename, int apiPreference, int fourcc, double fps,
                          @ByVal Size frameSize, @Cast("bool") boolean isColor/*=true*/);
    public native @Cast("bool") boolean open(@Str BytePointer filename, int apiPreference, int fourcc, double fps,
                          @ByVal Size frameSize);
    public native @Cast("bool") boolean open(@Str String filename, int apiPreference, int fourcc, double fps,
                          @ByVal Size frameSize, @Cast("bool") boolean isColor/*=true*/);
    public native @Cast("bool") boolean open(@Str String filename, int apiPreference, int fourcc, double fps,
                          @ByVal Size frameSize);

    /** \brief Returns true if video writer has been successfully initialized.
    */
    public native @Cast("bool") boolean isOpened();

    /** \brief Closes the video writer.
    <p>
    The method is automatically called by subsequent VideoWriter::open and by the VideoWriter
    destructor.
     */
    public native void release();

    /** \brief Stream operator to write the next video frame.
    \sa write
    */
    public native @ByRef @Name("operator <<") VideoWriter shiftLeft(@Const @ByRef Mat image);

    /** \brief Writes the next video frame
    <p>
    @param image The written frame
    <p>
    The function/method writes the specified image to video file. It must have the same size as has
    been specified when opening the video writer.
     */
    public native void write(@Const @ByRef Mat image);

    /** \brief Sets a property in the VideoWriter.
     <p>
     @param propId Property identifier from cv::VideoWriterProperties (eg. cv::VIDEOWRITER_PROP_QUALITY)
     or one of \ref videoio_flags_others
     <p>
     @param value Value of the property.
     @return  {@code true} if the property is supported by the backend used by the VideoWriter instance.
     */
    public native @Cast("bool") boolean set(int propId, double value);

    /** \brief Returns the specified VideoWriter property
     <p>
     @param propId Property identifier from cv::VideoWriterProperties (eg. cv::VIDEOWRITER_PROP_QUALITY)
     or one of \ref videoio_flags_others
     <p>
     @return Value for the specified property. Value 0 is returned when querying a property that is
     not supported by the backend used by the VideoWriter instance.
     */
    public native double get(int propId);

    /** \brief Concatenates 4 chars to a fourcc code
    <p>
    @return a fourcc code
    <p>
    This static method constructs the fourcc code of the codec to be used in the constructor
    VideoWriter::VideoWriter or VideoWriter::open.
     */
    public static native int fourcc(@Cast("char") byte c1, @Cast("char") byte c2, @Cast("char") byte c3, @Cast("char") byte c4);
}




/** \} videoio */

 // cv

// #endif //OPENCV_VIDEOIO_HPP


}
