/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.structured_light;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.structured_light.StructuredLightPattern;
import org.opencv.utils.Converters;

public class GrayCodePattern
extends StructuredLightPattern {
    protected GrayCodePattern(long addr) {
        super(addr);
    }

    public static GrayCodePattern __fromPtr__(long addr) {
        return new GrayCodePattern(addr);
    }

    public static GrayCodePattern create(int width, int height) {
        GrayCodePattern retVal = GrayCodePattern.__fromPtr__(GrayCodePattern.create_0(width, height));
        return retVal;
    }

    public boolean getProjPixel(List<Mat> patternImages, int x, int y, Point projPix) {
        Mat patternImages_mat = Converters.vector_Mat_to_Mat(patternImages);
        double[] projPix_out = new double[2];
        boolean retVal = GrayCodePattern.getProjPixel_0(this.nativeObj, patternImages_mat.nativeObj, x, y, projPix_out);
        if (projPix != null) {
            projPix.x = projPix_out[0];
            projPix.y = projPix_out[1];
        }
        return retVal;
    }

    public long getNumberOfPatternImages() {
        long retVal = GrayCodePattern.getNumberOfPatternImages_0(this.nativeObj);
        return retVal;
    }

    public void getImagesForShadowMasks(Mat blackImage, Mat whiteImage) {
        GrayCodePattern.getImagesForShadowMasks_0(this.nativeObj, blackImage.nativeObj, whiteImage.nativeObj);
    }

    public void setBlackThreshold(long value) {
        GrayCodePattern.setBlackThreshold_0(this.nativeObj, value);
    }

    public void setWhiteThreshold(long value) {
        GrayCodePattern.setWhiteThreshold_0(this.nativeObj, value);
    }

    @Override
    protected void finalize() throws Throwable {
        GrayCodePattern.delete(this.nativeObj);
    }

    private static native long create_0(int var0, int var1);

    private static native boolean getProjPixel_0(long var0, long var2, int var4, int var5, double[] var6);

    private static native long getNumberOfPatternImages_0(long var0);

    private static native void getImagesForShadowMasks_0(long var0, long var2, long var4);

    private static native void setBlackThreshold_0(long var0, long var2);

    private static native void setWhiteThreshold_0(long var0, long var2);

    private static native void delete(long var0);
}

