// Targeted by JavaCPP version 1.4.4: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.opencv_core.*;
import static org.bytedeco.javacpp.opencv_imgproc.*;
import static org.bytedeco.javacpp.opencv_imgcodecs.*;
import static org.bytedeco.javacpp.opencv_videoio.*;
import static org.bytedeco.javacpp.opencv_highgui.*;
import static org.bytedeco.javacpp.opencv_flann.*;
import static org.bytedeco.javacpp.opencv_features2d.*;
import static org.bytedeco.javacpp.opencv_calib3d.*;

public class opencv_aruco extends org.bytedeco.javacpp.presets.opencv_aruco {
    static { Loader.load(); }

// Parsed from <opencv2/aruco/dictionary.hpp>

/*
By downloading, copying, installing or using the software you agree to this
license. If you do not agree to this license, do not download, install,
copy or use the software.

                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)

Copyright (C) 2013, OpenCV Foundation, all rights reserved.
Third party copyrights are property of their respective owners.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are
disclaimed. In no event shall copyright holders or contributors be liable for
any direct, indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.
*/

// #ifndef __OPENCV_DICTIONARY_HPP__
// #define __OPENCV_DICTIONARY_HPP__

// #include <opencv2/core.hpp>

/** \addtogroup aruco
 *  \{
<p>
<p>
/**
 * \brief Dictionary/Set of markers. It contains the inner codification
 *
 * bytesList contains the marker codewords where
 * - bytesList.rows is the dictionary size
 * - each marker is encoded using {@code nbytes = ceil(markerSize*markerSize/8.)}
 * - each row contains all 4 rotations of the marker, so its length is {@code 4*nbytes}
 *
 * {@code bytesList.ptr(i)[k*nbytes + j]} is then the j-th byte of i-th marker, in its k-th rotation.
 */
@Namespace("cv::aruco") @NoOffset public static class Dictionary extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Dictionary(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Dictionary(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Dictionary position(long position) {
        return (Dictionary)super.position(position);
    }

    public native @ByRef Mat bytesList(); public native Dictionary bytesList(Mat bytesList);         // marker code information
    public native int markerSize(); public native Dictionary markerSize(int markerSize);        // number of bits per dimension
    public native int maxCorrectionBits(); public native Dictionary maxCorrectionBits(int maxCorrectionBits); // maximum number of bits that can be corrected


    /**
      */
    public Dictionary(@Const @ByRef(nullValue = "cv::Mat()") Mat _bytesList, int _markerSize/*=0*/, int _maxcorr/*=0*/) { super((Pointer)null); allocate(_bytesList, _markerSize, _maxcorr); }
    private native void allocate(@Const @ByRef(nullValue = "cv::Mat()") Mat _bytesList, int _markerSize/*=0*/, int _maxcorr/*=0*/);
    public Dictionary() { super((Pointer)null); allocate(); }
    private native void allocate();


    /**
    Dictionary(const Dictionary &_dictionary);
    */


    /**
      */
    public Dictionary(@Ptr Dictionary _dictionary) { super((Pointer)null); allocate(_dictionary); }
    private native void allocate(@Ptr Dictionary _dictionary);


    /**
     * @see generateCustomDictionary
     */
    public static native @Ptr Dictionary create(int nMarkers, int markerSize, int randomSeed/*=0*/);
    public static native @Ptr Dictionary create(int nMarkers, int markerSize);


    /**
     * @see generateCustomDictionary
     */
    public static native @Ptr @Name("create") Dictionary create_from(int nMarkers, int markerSize,
                @Ptr Dictionary baseDictionary, int randomSeed/*=0*/);
    public static native @Ptr @Name("create") Dictionary create_from(int nMarkers, int markerSize,
                @Ptr Dictionary baseDictionary);

    /**
     * @see getPredefinedDictionary
     */
    public static native @Ptr Dictionary get(int dict);

    /**
     * \brief Given a matrix of bits. Returns whether if marker is identified or not.
     * It returns by reference the correct id (if any) and the correct rotation
     */
    public native @Cast("bool") boolean identify(@Const @ByRef Mat onlyBits, @ByRef IntPointer idx, @ByRef IntPointer rotation, double maxCorrectionRate);
    public native @Cast("bool") boolean identify(@Const @ByRef Mat onlyBits, @ByRef IntBuffer idx, @ByRef IntBuffer rotation, double maxCorrectionRate);
    public native @Cast("bool") boolean identify(@Const @ByRef Mat onlyBits, @ByRef int[] idx, @ByRef int[] rotation, double maxCorrectionRate);

    /**
      * \brief Returns the distance of the input bits to the specific id. If allRotations is true,
      * the four posible bits rotation are considered
      */
    public native int getDistanceToId(@ByVal Mat bits, int id, @Cast("bool") boolean allRotations/*=true*/);
    public native int getDistanceToId(@ByVal Mat bits, int id);
    public native int getDistanceToId(@ByVal UMat bits, int id, @Cast("bool") boolean allRotations/*=true*/);
    public native int getDistanceToId(@ByVal UMat bits, int id);
    public native int getDistanceToId(@ByVal GpuMat bits, int id, @Cast("bool") boolean allRotations/*=true*/);
    public native int getDistanceToId(@ByVal GpuMat bits, int id);


    /**
     * \brief Draw a canonical marker image
     */
    public native void drawMarker(int id, int sidePixels, @ByVal Mat _img, int borderBits/*=1*/);
    public native void drawMarker(int id, int sidePixels, @ByVal Mat _img);
    public native void drawMarker(int id, int sidePixels, @ByVal UMat _img, int borderBits/*=1*/);
    public native void drawMarker(int id, int sidePixels, @ByVal UMat _img);
    public native void drawMarker(int id, int sidePixels, @ByVal GpuMat _img, int borderBits/*=1*/);
    public native void drawMarker(int id, int sidePixels, @ByVal GpuMat _img);


    /**
      * \brief Transform matrix of bits to list of bytes in the 4 rotations
      */
    public static native @ByVal Mat getByteListFromBits(@Const @ByRef Mat bits);


    /**
      * \brief Transform list of bytes to matrix of bits
      */
    public static native @ByVal Mat getBitsFromByteList(@Const @ByRef Mat byteList, int markerSize);
}




/**
 * \brief Predefined markers dictionaries/sets
 * Each dictionary indicates the number of bits and the number of markers contained
 * - DICT_ARUCO_ORIGINAL: standard ArUco Library Markers. 1024 markers, 5x5 bits, 0 minimum
                          distance
 */
/** enum cv::aruco::PREDEFINED_DICTIONARY_NAME */
public static final int
    DICT_4X4_50 = 0,
    DICT_4X4_100 = 1,
    DICT_4X4_250 = 2,
    DICT_4X4_1000 = 3,
    DICT_5X5_50 = 4,
    DICT_5X5_100 = 5,
    DICT_5X5_250 = 6,
    DICT_5X5_1000 = 7,
    DICT_6X6_50 = 8,
    DICT_6X6_100 = 9,
    DICT_6X6_250 = 10,
    DICT_6X6_1000 = 11,
    DICT_7X7_50 = 12,
    DICT_7X7_100 = 13,
    DICT_7X7_250 = 14,
    DICT_7X7_1000 = 15,
    DICT_ARUCO_ORIGINAL = 16,
    /** 4x4 bits, minimum hamming distance between any two codes = 5, 30 codes */
    DICT_APRILTAG_16h5 = 17,
    /** 5x5 bits, minimum hamming distance between any two codes = 9, 35 codes */
    DICT_APRILTAG_25h9 = 18,
    /** 6x6 bits, minimum hamming distance between any two codes = 10, 2320 codes */
    DICT_APRILTAG_36h10 = 19,
    /** 6x6 bits, minimum hamming distance between any two codes = 11, 587 codes */
    DICT_APRILTAG_36h11 = 20;


/**
  * \brief Returns one of the predefined dictionaries defined in PREDEFINED_DICTIONARY_NAME
  */
@Namespace("cv::aruco") public static native @Ptr Dictionary getPredefinedDictionary(@Cast("cv::aruco::PREDEFINED_DICTIONARY_NAME") int name);


/**
  * \brief Returns one of the predefined dictionaries referenced by DICT_*.
  */


/**
  * @see generateCustomDictionary
  */
@Namespace("cv::aruco") public static native @Ptr @Name("generateCustomDictionary") Dictionary custom_dictionary(
        int nMarkers,
        int markerSize,
        int randomSeed/*=0*/);
@Namespace("cv::aruco") public static native @Ptr @Name("generateCustomDictionary") Dictionary custom_dictionary(
        int nMarkers,
        int markerSize);


/**
  * \brief Generates a new customizable marker dictionary
  *
  * @param nMarkers number of markers in the dictionary
  * @param markerSize number of bits per dimension of each markers
  * @param baseDictionary Include the markers in this dictionary at the beginning (optional)
  * @param randomSeed a user supplied seed for theRNG()
  *
  * This function creates a new dictionary composed by nMarkers markers and each markers composed
  * by markerSize x markerSize bits. If baseDictionary is provided, its markers are directly
  * included and the rest are generated based on them. If the size of baseDictionary is higher
  * than nMarkers, only the first nMarkers in baseDictionary are taken and no new marker is added.
  */
@Namespace("cv::aruco") public static native @Ptr @Name("generateCustomDictionary") Dictionary custom_dictionary_from(
        int nMarkers,
        int markerSize,
        @Ptr Dictionary baseDictionary,
        int randomSeed/*=0*/);
@Namespace("cv::aruco") public static native @Ptr @Name("generateCustomDictionary") Dictionary custom_dictionary_from(
        int nMarkers,
        int markerSize,
        @Ptr Dictionary baseDictionary);



/** \} */



// #endif


// Parsed from <opencv2/aruco.hpp>

/*
By downloading, copying, installing or using the software you agree to this
license. If you do not agree to this license, do not download, install,
copy or use the software.

                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)

Copyright (C) 2013, OpenCV Foundation, all rights reserved.
Third party copyrights are property of their respective owners.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are
disclaimed. In no event shall copyright holders or contributors be liable for
any direct, indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.
*/

// #ifndef __OPENCV_ARUCO_HPP__
// #define __OPENCV_ARUCO_HPP__

// #include <opencv2/core.hpp>
// #include <vector>
// #include "opencv2/aruco/dictionary.hpp"

/**
 * \defgroup aruco ArUco Marker Detection
 * This module is dedicated to square fiducial markers (also known as Augmented Reality Markers)
 * These markers are useful for easy, fast and robust camera pose estimation.ç
 *
 * The main functionalities are:
 * - Detection of markers in an image
 * - Pose estimation from a single marker or from a board/set of markers
 * - Detection of ChArUco board for high subpixel accuracy
 * - Camera calibration from both, ArUco boards and ChArUco boards.
 * - Detection of ChArUco diamond markers
 * The samples directory includes easy examples of how to use the module.
 *
 * The implementation is based on the ArUco Library by R. Muñoz-Salinas and S. Garrido-Jurado \cite Aruco2014.
 *
 * Markers can also be detected based on the AprilTag 2 \cite wang2016iros fiducial detection method.
 *
 * \sa S. Garrido-Jurado, R. Muñoz-Salinas, F. J. Madrid-Cuevas, and M. J. Marín-Jiménez. 2014.
 * "Automatic generation and detection of highly reliable fiducial markers under occlusion".
 * Pattern Recogn. 47, 6 (June 2014), 2280-2292. DOI=10.1016/j.patcog.2014.01.005
 *
 * \sa http://www.uco.es/investiga/grupos/ava/node/26
 *
 * This module has been originally developed by Sergio Garrido-Jurado as a project
 * for Google Summer of Code 2015 (GSoC 15).
 *
 *
*/

/** \addtogroup aruco
 *  \{ */

/** enum cv::aruco::CornerRefineMethod */
public static final int
    /** Tag and corners detection based on the ArUco approach */
    CORNER_REFINE_NONE = 0,
    /** ArUco approach and refine the corners locations using corner subpixel accuracy */
    CORNER_REFINE_SUBPIX = 1,
    /** ArUco approach and refine the corners locations using the contour-points line fitting */
    CORNER_REFINE_CONTOUR = 2,
    /** Tag and corners detection based on the AprilTag 2 approach \cite wang2016iros */
    CORNER_REFINE_APRILTAG = 3;

/**
 * \brief Parameters for the detectMarker process:
 * - adaptiveThreshWinSizeMin: minimum window size for adaptive thresholding before finding
 *   contours (default 3).
 * - adaptiveThreshWinSizeMax: maximum window size for adaptive thresholding before finding
 *   contours (default 23).
 * - adaptiveThreshWinSizeStep: increments from adaptiveThreshWinSizeMin to adaptiveThreshWinSizeMax
 *   during the thresholding (default 10).
 * - adaptiveThreshConstant: constant for adaptive thresholding before finding contours (default 7)
 * - minMarkerPerimeterRate: determine minimum perimeter for marker contour to be detected. This
 *   is defined as a rate respect to the maximum dimension of the input image (default 0.03).
 * - maxMarkerPerimeterRate:  determine maximum perimeter for marker contour to be detected. This
 *   is defined as a rate respect to the maximum dimension of the input image (default 4.0).
 * - polygonalApproxAccuracyRate: minimum accuracy during the polygonal approximation process to
 *   determine which contours are squares.
 * - minCornerDistanceRate: minimum distance between corners for detected markers relative to its
 *   perimeter (default 0.05)
 * - minDistanceToBorder: minimum distance of any corner to the image border for detected markers
 *   (in pixels) (default 3)
 * - minMarkerDistanceRate: minimum mean distance beetween two marker corners to be considered
 *   similar, so that the smaller one is removed. The rate is relative to the smaller perimeter
 *   of the two markers (default 0.05).
 * - cornerRefinementMethod: corner refinement method. (CORNER_REFINE_NONE, no refinement.
 *   CORNER_REFINE_SUBPIX, do subpixel refinement. CORNER_REFINE_CONTOUR use contour-Points,
 *   CORNER_REFINE_APRILTAG  use the AprilTag2 approach)
 * - cornerRefinementWinSize: window size for the corner refinement process (in pixels) (default 5).
 * - cornerRefinementMaxIterations: maximum number of iterations for stop criteria of the corner
 *   refinement process (default 30).
 * - cornerRefinementMinAccuracy: minimum error for the stop cristeria of the corner refinement
 *   process (default: 0.1)
 * - markerBorderBits: number of bits of the marker border, i.e. marker border width (default 1).
 * - perpectiveRemovePixelPerCell: number of bits (per dimension) for each cell of the marker
 *   when removing the perspective (default 8).
 * - perspectiveRemoveIgnoredMarginPerCell: width of the margin of pixels on each cell not
 *   considered for the determination of the cell bit. Represents the rate respect to the total
 *   size of the cell, i.e. perpectiveRemovePixelPerCell (default 0.13)
 * - maxErroneousBitsInBorderRate: maximum number of accepted erroneous bits in the border (i.e.
 *   number of allowed white bits in the border). Represented as a rate respect to the total
 *   number of bits per marker (default 0.35).
 * - minOtsuStdDev: minimun standard deviation in pixels values during the decodification step to
 *   apply Otsu thresholding (otherwise, all the bits are set to 0 or 1 depending on mean higher
 *   than 128 or not) (default 5.0)
 * - errorCorrectionRate error correction rate respect to the maximun error correction capability
 *   for each dictionary. (default 0.6).
 * - aprilTagMinClusterPixels: reject quads containing too few pixels.
 * - aprilTagMaxNmaxima: how many corner candidates to consider when segmenting a group of pixels into a quad.
 * - aprilTagCriticalRad: Reject quads where pairs of edges have angles that are close to straight or close to
 *   180 degrees. Zero means that no quads are rejected. (In radians).
 * - aprilTagMaxLineFitMse:  When fitting lines to the contours, what is the maximum mean squared error
 *   allowed?  This is useful in rejecting contours that are far from being quad shaped; rejecting
 *   these quads "early" saves expensive decoding processing.
 * - aprilTagMinWhiteBlackDiff: When we build our model of black & white pixels, we add an extra check that
 *   the white model must be (overall) brighter than the black model.  How much brighter? (in pixel values, [0,255]).
 * - aprilTagDeglitch:  should the thresholded image be deglitched? Only useful for very noisy images
 * - aprilTagQuadDecimate: Detection of quads can be done on a lower-resolution image, improving speed at a
 *   cost of pose accuracy and a slight decrease in detection rate. Decoding the binary payload is still
 *   done at full resolution.
 * - aprilTagQuadSigma: What Gaussian blur should be applied to the segmented image (used for quad detection?)
 *   Parameter is the standard deviation in pixels.  Very noisy images benefit from non-zero values (e.g. 0.8).
 */
@Namespace("cv::aruco") @NoOffset public static class DetectorParameters extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DetectorParameters(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DetectorParameters(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DetectorParameters position(long position) {
        return (DetectorParameters)super.position(position);
    }


    public DetectorParameters() { super((Pointer)null); allocate(); }
    private native void allocate();

    public static native @Ptr DetectorParameters create();

    public native int adaptiveThreshWinSizeMin(); public native DetectorParameters adaptiveThreshWinSizeMin(int adaptiveThreshWinSizeMin);
    public native int adaptiveThreshWinSizeMax(); public native DetectorParameters adaptiveThreshWinSizeMax(int adaptiveThreshWinSizeMax);
    public native int adaptiveThreshWinSizeStep(); public native DetectorParameters adaptiveThreshWinSizeStep(int adaptiveThreshWinSizeStep);
    public native double adaptiveThreshConstant(); public native DetectorParameters adaptiveThreshConstant(double adaptiveThreshConstant);
    public native double minMarkerPerimeterRate(); public native DetectorParameters minMarkerPerimeterRate(double minMarkerPerimeterRate);
    public native double maxMarkerPerimeterRate(); public native DetectorParameters maxMarkerPerimeterRate(double maxMarkerPerimeterRate);
    public native double polygonalApproxAccuracyRate(); public native DetectorParameters polygonalApproxAccuracyRate(double polygonalApproxAccuracyRate);
    public native double minCornerDistanceRate(); public native DetectorParameters minCornerDistanceRate(double minCornerDistanceRate);
    public native int minDistanceToBorder(); public native DetectorParameters minDistanceToBorder(int minDistanceToBorder);
    public native double minMarkerDistanceRate(); public native DetectorParameters minMarkerDistanceRate(double minMarkerDistanceRate);
    public native int cornerRefinementMethod(); public native DetectorParameters cornerRefinementMethod(int cornerRefinementMethod);
    public native int cornerRefinementWinSize(); public native DetectorParameters cornerRefinementWinSize(int cornerRefinementWinSize);
    public native int cornerRefinementMaxIterations(); public native DetectorParameters cornerRefinementMaxIterations(int cornerRefinementMaxIterations);
    public native double cornerRefinementMinAccuracy(); public native DetectorParameters cornerRefinementMinAccuracy(double cornerRefinementMinAccuracy);
    public native int markerBorderBits(); public native DetectorParameters markerBorderBits(int markerBorderBits);
    public native int perspectiveRemovePixelPerCell(); public native DetectorParameters perspectiveRemovePixelPerCell(int perspectiveRemovePixelPerCell);
    public native double perspectiveRemoveIgnoredMarginPerCell(); public native DetectorParameters perspectiveRemoveIgnoredMarginPerCell(double perspectiveRemoveIgnoredMarginPerCell);
    public native double maxErroneousBitsInBorderRate(); public native DetectorParameters maxErroneousBitsInBorderRate(double maxErroneousBitsInBorderRate);
    public native double minOtsuStdDev(); public native DetectorParameters minOtsuStdDev(double minOtsuStdDev);
    public native double errorCorrectionRate(); public native DetectorParameters errorCorrectionRate(double errorCorrectionRate);

    // April :: User-configurable parameters.
    public native float aprilTagQuadDecimate(); public native DetectorParameters aprilTagQuadDecimate(float aprilTagQuadDecimate);
    public native float aprilTagQuadSigma(); public native DetectorParameters aprilTagQuadSigma(float aprilTagQuadSigma);

    // April :: Internal variables
    public native int aprilTagMinClusterPixels(); public native DetectorParameters aprilTagMinClusterPixels(int aprilTagMinClusterPixels);
    public native int aprilTagMaxNmaxima(); public native DetectorParameters aprilTagMaxNmaxima(int aprilTagMaxNmaxima);
    public native float aprilTagCriticalRad(); public native DetectorParameters aprilTagCriticalRad(float aprilTagCriticalRad);
    public native float aprilTagMaxLineFitMse(); public native DetectorParameters aprilTagMaxLineFitMse(float aprilTagMaxLineFitMse);
    public native int aprilTagMinWhiteBlackDiff(); public native DetectorParameters aprilTagMinWhiteBlackDiff(int aprilTagMinWhiteBlackDiff);
    public native int aprilTagDeglitch(); public native DetectorParameters aprilTagDeglitch(int aprilTagDeglitch);
}



/**
 * \brief Basic marker detection
 *
 * @param image input image
 * @param dictionary indicates the type of markers that will be searched
 * @param corners vector of detected marker corners. For each marker, its four corners
 * are provided, (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers,
 * the dimensions of this array is Nx4. The order of the corners is clockwise.
 * @param ids vector of identifiers of the detected markers. The identifier is of type int
 * (e.g. std::vector<int>). For N detected markers, the size of ids is also N.
 * The identifiers have the same order than the markers in the imgPoints array.
 * @param parameters marker detection parameters
 * @param rejectedImgPoints contains the imgPoints of those squares whose inner code has not a
 * correct codification. Useful for debugging purposes.
 * @param cameraMatrix optional input 3x3 floating-point camera matrix
 * \f$A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\f$
 * @param distCoeff optional vector of distortion coefficients
 * \f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\f$ of 4, 5, 8 or 12 elements
 *
 * Performs marker detection in the input image. Only markers included in the specific dictionary
 * are searched. For each detected marker, it returns the 2D position of its corner in the image
 * and its corresponding identifier.
 * Note that this function does not perform pose estimation.
 * \sa estimatePoseSingleMarkers,  estimatePoseBoard
 *
 */
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal Mat image, @Ptr Dictionary dictionary, @ByVal MatVector corners,
                                @ByVal Mat ids, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rejectedImgPoints, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeff);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal Mat image, @Ptr Dictionary dictionary, @ByVal MatVector corners,
                                @ByVal Mat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal Mat image, @Ptr Dictionary dictionary, @ByVal UMatVector corners,
                                @ByVal Mat ids, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rejectedImgPoints, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeff);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal Mat image, @Ptr Dictionary dictionary, @ByVal UMatVector corners,
                                @ByVal Mat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal Mat image, @Ptr Dictionary dictionary, @ByVal GpuMatVector corners,
                                @ByVal Mat ids, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rejectedImgPoints, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeff);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal Mat image, @Ptr Dictionary dictionary, @ByVal GpuMatVector corners,
                                @ByVal Mat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal UMat image, @Ptr Dictionary dictionary, @ByVal MatVector corners,
                                @ByVal UMat ids, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rejectedImgPoints, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeff);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal UMat image, @Ptr Dictionary dictionary, @ByVal MatVector corners,
                                @ByVal UMat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal UMat image, @Ptr Dictionary dictionary, @ByVal UMatVector corners,
                                @ByVal UMat ids, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rejectedImgPoints, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeff);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal UMat image, @Ptr Dictionary dictionary, @ByVal UMatVector corners,
                                @ByVal UMat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal UMat image, @Ptr Dictionary dictionary, @ByVal GpuMatVector corners,
                                @ByVal UMat ids, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rejectedImgPoints, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeff);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal UMat image, @Ptr Dictionary dictionary, @ByVal GpuMatVector corners,
                                @ByVal UMat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal GpuMat image, @Ptr Dictionary dictionary, @ByVal MatVector corners,
                                @ByVal GpuMat ids, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rejectedImgPoints, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeff);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal GpuMat image, @Ptr Dictionary dictionary, @ByVal MatVector corners,
                                @ByVal GpuMat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal GpuMat image, @Ptr Dictionary dictionary, @ByVal UMatVector corners,
                                @ByVal GpuMat ids, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rejectedImgPoints, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeff);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal GpuMat image, @Ptr Dictionary dictionary, @ByVal UMatVector corners,
                                @ByVal GpuMat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal GpuMat image, @Ptr Dictionary dictionary, @ByVal GpuMatVector corners,
                                @ByVal GpuMat ids, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rejectedImgPoints, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeff);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal GpuMat image, @Ptr Dictionary dictionary, @ByVal GpuMatVector corners,
                                @ByVal GpuMat ids);



/**
 * \brief Pose estimation for single markers
 *
 * @param corners vector of already detected markers corners. For each marker, its four corners
 * are provided, (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers,
 * the dimensions of this array should be Nx4. The order of the corners should be clockwise.
 * \sa detectMarkers
 * @param markerLength the length of the markers' side. The returning translation vectors will
 * be in the same unit. Normally, unit is meters.
 * @param cameraMatrix input 3x3 floating-point camera matrix
 * \f$A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\f$
 * @param distCoeffs vector of distortion coefficients
 * \f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\f$ of 4, 5, 8 or 12 elements
 * @param rvecs array of output rotation vectors (\sa Rodrigues) (e.g. std::vector<cv::Vec3d>).
 * Each element in rvecs corresponds to the specific marker in imgPoints.
 * @param tvecs array of output translation vectors (e.g. std::vector<cv::Vec3d>).
 * Each element in tvecs corresponds to the specific marker in imgPoints.
 * @param _objPoints array of object points of all the marker corners
 *
 * This function receives the detected markers and returns their pose estimation respect to
 * the camera individually. So for each marker, one rotation and translation vector is returned.
 * The returned transformation is the one that transforms points from each marker coordinate system
 * to the camera coordinate system.
 * The marker corrdinate system is centered on the middle of the marker, with the Z axis
 * perpendicular to the marker plane.
 * The coordinates of the four corners of the marker in its own coordinate system are:
 * (-markerLength/2, markerLength/2, 0), (markerLength/2, markerLength/2, 0),
 * (markerLength/2, -markerLength/2, 0), (-markerLength/2, -markerLength/2, 0)
 */
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal MatVector corners, float markerLength,
                                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Mat rvecs, @ByVal Mat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat _objPoints);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal MatVector corners, float markerLength,
                                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Mat rvecs, @ByVal Mat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal UMatVector corners, float markerLength,
                                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Mat rvecs, @ByVal Mat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat _objPoints);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal UMatVector corners, float markerLength,
                                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Mat rvecs, @ByVal Mat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal GpuMatVector corners, float markerLength,
                                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Mat rvecs, @ByVal Mat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat _objPoints);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal GpuMatVector corners, float markerLength,
                                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Mat rvecs, @ByVal Mat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal MatVector corners, float markerLength,
                                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal UMat rvecs, @ByVal UMat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat _objPoints);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal MatVector corners, float markerLength,
                                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal UMat rvecs, @ByVal UMat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal UMatVector corners, float markerLength,
                                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal UMat rvecs, @ByVal UMat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat _objPoints);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal UMatVector corners, float markerLength,
                                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal UMat rvecs, @ByVal UMat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal GpuMatVector corners, float markerLength,
                                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal UMat rvecs, @ByVal UMat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat _objPoints);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal GpuMatVector corners, float markerLength,
                                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal UMat rvecs, @ByVal UMat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal MatVector corners, float markerLength,
                                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal GpuMat rvecs, @ByVal GpuMat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat _objPoints);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal MatVector corners, float markerLength,
                                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal GpuMat rvecs, @ByVal GpuMat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal UMatVector corners, float markerLength,
                                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal GpuMat rvecs, @ByVal GpuMat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat _objPoints);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal UMatVector corners, float markerLength,
                                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal GpuMat rvecs, @ByVal GpuMat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal GpuMatVector corners, float markerLength,
                                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal GpuMat rvecs, @ByVal GpuMat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat _objPoints);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal GpuMatVector corners, float markerLength,
                                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal GpuMat rvecs, @ByVal GpuMat tvecs);



/**
 * \brief Board of markers
 *
 * A board is a set of markers in the 3D space with a common cordinate system.
 * The common form of a board of marker is a planar (2D) board, however any 3D layout can be used.
 * A Board object is composed by:
 * - The object points of the marker corners, i.e. their coordinates respect to the board system.
 * - The dictionary which indicates the type of markers of the board
 * - The identifier of all the markers in the board.
 */
@Namespace("cv::aruco") public static class Board extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public Board() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Board(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Board(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public Board position(long position) {
        return (Board)super.position(position);
    }

    /**
    * \brief Provide way to create Board by passing nessesary data. Specially needed in Python.
    *
    * @param objPoints array of object points of all the marker corners in the board
    * @param dictionary the dictionary of markers employed for this board
    * @param ids vector of the identifiers of the markers in the board
    *
    */
    public static native @Ptr Board create(@ByVal MatVector objPoints, @Ptr Dictionary dictionary, @ByVal Mat ids);
    public static native @Ptr Board create(@ByVal UMatVector objPoints, @Ptr Dictionary dictionary, @ByVal Mat ids);
    public static native @Ptr Board create(@ByVal GpuMatVector objPoints, @Ptr Dictionary dictionary, @ByVal Mat ids);
    public static native @Ptr Board create(@ByVal MatVector objPoints, @Ptr Dictionary dictionary, @ByVal UMat ids);
    public static native @Ptr Board create(@ByVal UMatVector objPoints, @Ptr Dictionary dictionary, @ByVal UMat ids);
    public static native @Ptr Board create(@ByVal GpuMatVector objPoints, @Ptr Dictionary dictionary, @ByVal UMat ids);
    public static native @Ptr Board create(@ByVal MatVector objPoints, @Ptr Dictionary dictionary, @ByVal GpuMat ids);
    public static native @Ptr Board create(@ByVal UMatVector objPoints, @Ptr Dictionary dictionary, @ByVal GpuMat ids);
    public static native @Ptr Board create(@ByVal GpuMatVector objPoints, @Ptr Dictionary dictionary, @ByVal GpuMat ids);
    /** array of object points of all the marker corners in the board
     *  each marker include its 4 corners in CCW order. For M markers, the size is Mx4. */
    public native @ByRef Point3fVectorVector objPoints(); public native Board objPoints(Point3fVectorVector objPoints);

    /** the dictionary of markers employed for this board */
    public native @Ptr Dictionary dictionary(); public native Board dictionary(Dictionary dictionary);

    /** vector of the identifiers of the markers in the board (same size than objPoints)
     *  The identifiers refers to the board dictionary */
    public native @StdVector IntPointer ids(); public native Board ids(IntPointer ids);
}



/**
 * \brief Planar board with grid arrangement of markers
 * More common type of board. All markers are placed in the same plane in a grid arrangment.
 * The board can be drawn using drawPlanarBoard() function (\sa drawPlanarBoard)
 */
@Namespace("cv::aruco") @NoOffset public static class GridBoard extends Board {
    static { Loader.load(); }
    /** Default native constructor. */
    public GridBoard() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public GridBoard(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public GridBoard(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public GridBoard position(long position) {
        return (GridBoard)super.position(position);
    }

    /**
     * \brief Draw a GridBoard
     *
     * @param outSize size of the output image in pixels.
     * @param img output image with the board. The size of this image will be outSize
     * and the board will be on the center, keeping the board proportions.
     * @param marginSize minimum margins (in pixels) of the board in the output image
     * @param borderBits width of the marker borders.
     *
     * This function return the image of the GridBoard, ready to be printed.
     */
    public native void draw(@ByVal Size outSize, @ByVal Mat img, int marginSize/*=0*/, int borderBits/*=1*/);
    public native void draw(@ByVal Size outSize, @ByVal Mat img);
    public native void draw(@ByVal Size outSize, @ByVal UMat img, int marginSize/*=0*/, int borderBits/*=1*/);
    public native void draw(@ByVal Size outSize, @ByVal UMat img);
    public native void draw(@ByVal Size outSize, @ByVal GpuMat img, int marginSize/*=0*/, int borderBits/*=1*/);
    public native void draw(@ByVal Size outSize, @ByVal GpuMat img);


    /**
     * \brief Create a GridBoard object
     *
     * @param markersX number of markers in X direction
     * @param markersY number of markers in Y direction
     * @param markerLength marker side length (normally in meters)
     * @param markerSeparation separation between two markers (same unit as markerLength)
     * @param dictionary dictionary of markers indicating the type of markers
     * @param firstMarker id of first marker in dictionary to use on board.
     * @return the output GridBoard object
     *
     * This functions creates a GridBoard object given the number of markers in each direction and
     * the marker size and marker separation.
     */
    public static native @Ptr GridBoard create(int markersX, int markersY, float markerLength,
                                             float markerSeparation, @Ptr Dictionary dictionary, int firstMarker/*=0*/);
    public static native @Ptr GridBoard create(int markersX, int markersY, float markerLength,
                                             float markerSeparation, @Ptr Dictionary dictionary);

    /**
      *
      */
    public native @ByVal Size getGridSize();

    /**
      *
      */
    public native float getMarkerLength();

    /**
      *
      */
    public native float getMarkerSeparation();
}



/**
 * \brief Pose estimation for a board of markers
 *
 * @param corners vector of already detected markers corners. For each marker, its four corners
 * are provided, (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers, the
 * dimensions of this array should be Nx4. The order of the corners should be clockwise.
 * @param ids list of identifiers for each marker in corners
 * @param board layout of markers in the board. The layout is composed by the marker identifiers
 * and the positions of each marker corner in the board reference system.
 * @param cameraMatrix input 3x3 floating-point camera matrix
 * \f$A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\f$
 * @param distCoeffs vector of distortion coefficients
 * \f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\f$ of 4, 5, 8 or 12 elements
 * @param rvec Output vector (e.g. cv::Mat) corresponding to the rotation vector of the board
 * (see cv::Rodrigues). Used as initial guess if not empty.
 * @param tvec Output vector (e.g. cv::Mat) corresponding to the translation vector of the board.
 * @param useExtrinsicGuess defines whether initial guess for \b rvec and \b tvec will be used or not.
 * Used as initial guess if not empty.
 *
 * This function receives the detected markers and returns the pose of a marker board composed
 * by those markers.
 * A Board of marker has a single world coordinate system which is defined by the board layout.
 * The returned transformation is the one that transforms points from the board coordinate system
 * to the camera coordinate system.
 * Input markers that are not included in the board layout are ignored.
 * The function returns the number of markers from the input employed for the board pose estimation.
 * Note that returning a 0 means the pose has not been estimated.
 */
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal MatVector corners, @ByVal Mat ids, @Ptr Board board,
                                   @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                   @ByVal Mat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal MatVector corners, @ByVal Mat ids, @Ptr Board board,
                                   @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                   @ByVal Mat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal UMatVector corners, @ByVal Mat ids, @Ptr Board board,
                                   @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                   @ByVal Mat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal UMatVector corners, @ByVal Mat ids, @Ptr Board board,
                                   @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                   @ByVal Mat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal GpuMatVector corners, @ByVal Mat ids, @Ptr Board board,
                                   @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                   @ByVal Mat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal GpuMatVector corners, @ByVal Mat ids, @Ptr Board board,
                                   @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                   @ByVal Mat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal MatVector corners, @ByVal UMat ids, @Ptr Board board,
                                   @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                   @ByVal UMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal MatVector corners, @ByVal UMat ids, @Ptr Board board,
                                   @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                   @ByVal UMat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal UMatVector corners, @ByVal UMat ids, @Ptr Board board,
                                   @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                   @ByVal UMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal UMatVector corners, @ByVal UMat ids, @Ptr Board board,
                                   @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                   @ByVal UMat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal GpuMatVector corners, @ByVal UMat ids, @Ptr Board board,
                                   @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                   @ByVal UMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal GpuMatVector corners, @ByVal UMat ids, @Ptr Board board,
                                   @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                   @ByVal UMat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal MatVector corners, @ByVal GpuMat ids, @Ptr Board board,
                                   @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                   @ByVal GpuMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal MatVector corners, @ByVal GpuMat ids, @Ptr Board board,
                                   @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                   @ByVal GpuMat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal UMatVector corners, @ByVal GpuMat ids, @Ptr Board board,
                                   @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                   @ByVal GpuMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal UMatVector corners, @ByVal GpuMat ids, @Ptr Board board,
                                   @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                   @ByVal GpuMat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal GpuMatVector corners, @ByVal GpuMat ids, @Ptr Board board,
                                   @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                   @ByVal GpuMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal GpuMatVector corners, @ByVal GpuMat ids, @Ptr Board board,
                                   @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                   @ByVal GpuMat tvec);




/**
 * \brief Refind not detected markers based on the already detected and the board layout
 *
 * @param image input image
 * @param board layout of markers in the board.
 * @param detectedCorners vector of already detected marker corners.
 * @param detectedIds vector of already detected marker identifiers.
 * @param rejectedCorners vector of rejected candidates during the marker detection process.
 * @param cameraMatrix optional input 3x3 floating-point camera matrix
 * \f$A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\f$
 * @param distCoeffs optional vector of distortion coefficients
 * \f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\f$ of 4, 5, 8 or 12 elements
 * @param minRepDistance minimum distance between the corners of the rejected candidate and the
 * reprojected marker in order to consider it as a correspondence.
 * @param errorCorrectionRate rate of allowed erroneous bits respect to the error correction
 * capability of the used dictionary. -1 ignores the error correction step.
 * @param checkAllOrders Consider the four posible corner orders in the rejectedCorners array.
 * If it set to false, only the provided corner order is considered (default true).
 * @param recoveredIdxs Optional array to returns the indexes of the recovered candidates in the
 * original rejectedCorners array.
 * @param parameters marker detection parameters
 *
 * This function tries to find markers that were not detected in the basic detecMarkers function.
 * First, based on the current detected marker and the board layout, the function interpolates
 * the position of the missing markers. Then it tries to find correspondence between the reprojected
 * markers and the rejected candidates based on the minRepDistance and errorCorrectionRate
 * parameters.
 * If camera parameters and distortion coefficients are provided, missing markers are reprojected
 * using projectPoint function. If not, missing marker projections are interpolated using global
 * homography, and all the marker corners in the board must have the same Z coordinate.
 */
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal Mat image,@Ptr Board board, @ByVal MatVector detectedCorners,
    @ByVal Mat detectedIds, @ByVal MatVector rejectedCorners,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs,
    float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/, @Cast("bool") boolean checkAllOrders/*=true*/,
    @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat recoveredIdxs, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal Mat image,@Ptr Board board, @ByVal MatVector detectedCorners,
    @ByVal Mat detectedIds, @ByVal MatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal Mat image,@Ptr Board board, @ByVal UMatVector detectedCorners,
    @ByVal Mat detectedIds, @ByVal UMatVector rejectedCorners,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs,
    float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/, @Cast("bool") boolean checkAllOrders/*=true*/,
    @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat recoveredIdxs, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal Mat image,@Ptr Board board, @ByVal UMatVector detectedCorners,
    @ByVal Mat detectedIds, @ByVal UMatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal Mat image,@Ptr Board board, @ByVal GpuMatVector detectedCorners,
    @ByVal Mat detectedIds, @ByVal GpuMatVector rejectedCorners,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs,
    float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/, @Cast("bool") boolean checkAllOrders/*=true*/,
    @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat recoveredIdxs, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal Mat image,@Ptr Board board, @ByVal GpuMatVector detectedCorners,
    @ByVal Mat detectedIds, @ByVal GpuMatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal UMat image,@Ptr Board board, @ByVal MatVector detectedCorners,
    @ByVal UMat detectedIds, @ByVal MatVector rejectedCorners,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs,
    float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/, @Cast("bool") boolean checkAllOrders/*=true*/,
    @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat recoveredIdxs, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal UMat image,@Ptr Board board, @ByVal MatVector detectedCorners,
    @ByVal UMat detectedIds, @ByVal MatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal UMat image,@Ptr Board board, @ByVal UMatVector detectedCorners,
    @ByVal UMat detectedIds, @ByVal UMatVector rejectedCorners,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs,
    float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/, @Cast("bool") boolean checkAllOrders/*=true*/,
    @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat recoveredIdxs, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal UMat image,@Ptr Board board, @ByVal UMatVector detectedCorners,
    @ByVal UMat detectedIds, @ByVal UMatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal UMat image,@Ptr Board board, @ByVal GpuMatVector detectedCorners,
    @ByVal UMat detectedIds, @ByVal GpuMatVector rejectedCorners,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs,
    float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/, @Cast("bool") boolean checkAllOrders/*=true*/,
    @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat recoveredIdxs, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal UMat image,@Ptr Board board, @ByVal GpuMatVector detectedCorners,
    @ByVal UMat detectedIds, @ByVal GpuMatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal GpuMat image,@Ptr Board board, @ByVal MatVector detectedCorners,
    @ByVal GpuMat detectedIds, @ByVal MatVector rejectedCorners,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs,
    float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/, @Cast("bool") boolean checkAllOrders/*=true*/,
    @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat recoveredIdxs, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal GpuMat image,@Ptr Board board, @ByVal MatVector detectedCorners,
    @ByVal GpuMat detectedIds, @ByVal MatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal GpuMat image,@Ptr Board board, @ByVal UMatVector detectedCorners,
    @ByVal GpuMat detectedIds, @ByVal UMatVector rejectedCorners,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs,
    float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/, @Cast("bool") boolean checkAllOrders/*=true*/,
    @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat recoveredIdxs, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal GpuMat image,@Ptr Board board, @ByVal UMatVector detectedCorners,
    @ByVal GpuMat detectedIds, @ByVal UMatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal GpuMat image,@Ptr Board board, @ByVal GpuMatVector detectedCorners,
    @ByVal GpuMat detectedIds, @ByVal GpuMatVector rejectedCorners,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs,
    float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/, @Cast("bool") boolean checkAllOrders/*=true*/,
    @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat recoveredIdxs, @Ptr DetectorParameters parameters/*=cv::aruco::DetectorParameters::create()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(
    @ByVal GpuMat image,@Ptr Board board, @ByVal GpuMatVector detectedCorners,
    @ByVal GpuMat detectedIds, @ByVal GpuMatVector rejectedCorners);



/**
 * \brief Draw detected markers in image
 *
 * @param image input/output image. It must have 1 or 3 channels. The number of channels is not
 * altered.
 * @param corners positions of marker corners on input image.
 * (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers, the dimensions of
 * this array should be Nx4. The order of the corners should be clockwise.
 * @param ids vector of identifiers for markers in markersCorners .
 * Optional, if not provided, ids are not painted.
 * @param borderColor color of marker borders. Rest of colors (text color and first corner color)
 * are calculated based on this one to improve visualization.
 *
 * Given an array of detected marker corners and its corresponding ids, this functions draws
 * the markers in the image. The marker borders are painted and the markers identifiers if provided.
 * Useful for debugging purposes.
 */
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal Mat image, @ByVal MatVector corners,
                                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat ids,
                                      @ByVal(nullValue = "cv::Scalar(0, 255, 0)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal Mat image, @ByVal MatVector corners);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal Mat image, @ByVal UMatVector corners,
                                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat ids,
                                      @ByVal(nullValue = "cv::Scalar(0, 255, 0)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal Mat image, @ByVal UMatVector corners);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal Mat image, @ByVal GpuMatVector corners,
                                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat ids,
                                      @ByVal(nullValue = "cv::Scalar(0, 255, 0)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal Mat image, @ByVal GpuMatVector corners);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal UMat image, @ByVal MatVector corners,
                                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat ids,
                                      @ByVal(nullValue = "cv::Scalar(0, 255, 0)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal UMat image, @ByVal MatVector corners);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal UMat image, @ByVal UMatVector corners,
                                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat ids,
                                      @ByVal(nullValue = "cv::Scalar(0, 255, 0)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal UMat image, @ByVal UMatVector corners);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal UMat image, @ByVal GpuMatVector corners,
                                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat ids,
                                      @ByVal(nullValue = "cv::Scalar(0, 255, 0)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal UMat image, @ByVal GpuMatVector corners);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal GpuMat image, @ByVal MatVector corners,
                                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat ids,
                                      @ByVal(nullValue = "cv::Scalar(0, 255, 0)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal GpuMat image, @ByVal MatVector corners);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal GpuMat image, @ByVal UMatVector corners,
                                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat ids,
                                      @ByVal(nullValue = "cv::Scalar(0, 255, 0)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal GpuMat image, @ByVal UMatVector corners);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal GpuMat image, @ByVal GpuMatVector corners,
                                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat ids,
                                      @ByVal(nullValue = "cv::Scalar(0, 255, 0)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedMarkers(@ByVal GpuMat image, @ByVal GpuMatVector corners);



/**
 * \brief Draw coordinate system axis from pose estimation
 *
 * @param image input/output image. It must have 1 or 3 channels. The number of channels is not
 * altered.
 * @param cameraMatrix input 3x3 floating-point camera matrix
 * \f$A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\f$
 * @param distCoeffs vector of distortion coefficients
 * \f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\f$ of 4, 5, 8 or 12 elements
 * @param rvec rotation vector of the coordinate system that will be drawn. (\sa Rodrigues).
 * @param tvec translation vector of the coordinate system that will be drawn.
 * @param length length of the painted axis in the same unit than tvec (usually in meters)
 *
 * Given the pose estimation of a marker or board, this function draws the axis of the world
 * coordinate system, i.e. the system centered on the marker/board. Useful for debugging purposes.
 */
@Namespace("cv::aruco") public static native void drawAxis(@ByVal Mat image, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                           @ByVal Mat rvec, @ByVal Mat tvec, float length);
@Namespace("cv::aruco") public static native void drawAxis(@ByVal UMat image, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                           @ByVal UMat rvec, @ByVal UMat tvec, float length);
@Namespace("cv::aruco") public static native void drawAxis(@ByVal GpuMat image, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                           @ByVal GpuMat rvec, @ByVal GpuMat tvec, float length);



/**
 * \brief Draw a canonical marker image
 *
 * @param dictionary dictionary of markers indicating the type of markers
 * @param id identifier of the marker that will be returned. It has to be a valid id
 * in the specified dictionary.
 * @param sidePixels size of the image in pixels
 * @param img output image with the marker
 * @param borderBits width of the marker border.
 *
 * This function returns a marker image in its canonical form (i.e. ready to be printed)
 */
@Namespace("cv::aruco") public static native void drawMarker(@Ptr Dictionary dictionary, int id, int sidePixels, @ByVal Mat img,
                             int borderBits/*=1*/);
@Namespace("cv::aruco") public static native void drawMarker(@Ptr Dictionary dictionary, int id, int sidePixels, @ByVal Mat img);
@Namespace("cv::aruco") public static native void drawMarker(@Ptr Dictionary dictionary, int id, int sidePixels, @ByVal UMat img,
                             int borderBits/*=1*/);
@Namespace("cv::aruco") public static native void drawMarker(@Ptr Dictionary dictionary, int id, int sidePixels, @ByVal UMat img);
@Namespace("cv::aruco") public static native void drawMarker(@Ptr Dictionary dictionary, int id, int sidePixels, @ByVal GpuMat img,
                             int borderBits/*=1*/);
@Namespace("cv::aruco") public static native void drawMarker(@Ptr Dictionary dictionary, int id, int sidePixels, @ByVal GpuMat img);



/**
 * \brief Draw a planar board
 * \sa _drawPlanarBoardImpl
 *
 * @param board layout of the board that will be drawn. The board should be planar,
 * z coordinate is ignored
 * @param outSize size of the output image in pixels.
 * @param img output image with the board. The size of this image will be outSize
 * and the board will be on the center, keeping the board proportions.
 * @param marginSize minimum margins (in pixels) of the board in the output image
 * @param borderBits width of the marker borders.
 *
 * This function return the image of a planar board, ready to be printed. It assumes
 * the Board layout specified is planar by ignoring the z coordinates of the object points.
 */
@Namespace("cv::aruco") public static native void drawPlanarBoard(@Ptr Board board, @ByVal Size outSize, @ByVal Mat img,
                                  int marginSize/*=0*/, int borderBits/*=1*/);
@Namespace("cv::aruco") public static native void drawPlanarBoard(@Ptr Board board, @ByVal Size outSize, @ByVal Mat img);
@Namespace("cv::aruco") public static native void drawPlanarBoard(@Ptr Board board, @ByVal Size outSize, @ByVal UMat img,
                                  int marginSize/*=0*/, int borderBits/*=1*/);
@Namespace("cv::aruco") public static native void drawPlanarBoard(@Ptr Board board, @ByVal Size outSize, @ByVal UMat img);
@Namespace("cv::aruco") public static native void drawPlanarBoard(@Ptr Board board, @ByVal Size outSize, @ByVal GpuMat img,
                                  int marginSize/*=0*/, int borderBits/*=1*/);
@Namespace("cv::aruco") public static native void drawPlanarBoard(@Ptr Board board, @ByVal Size outSize, @ByVal GpuMat img);



/**
 * \brief Implementation of drawPlanarBoard that accepts a raw Board pointer.
 */




/**
 * \brief Calibrate a camera using aruco markers
 *
 * @param corners vector of detected marker corners in all frames.
 * The corners should have the same format returned by detectMarkers (see #detectMarkers).
 * @param ids list of identifiers for each marker in corners
 * @param counter number of markers in each frame so that corners and ids can be split
 * @param board Marker Board layout
 * @param imageSize Size of the image used only to initialize the intrinsic camera matrix.
 * @param cameraMatrix Output 3x3 floating-point camera matrix
 * \f$A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\f$ . If CV\_CALIB\_USE\_INTRINSIC\_GUESS
 * and/or CV_CALIB_FIX_ASPECT_RATIO are specified, some or all of fx, fy, cx, cy must be
 * initialized before calling the function.
 * @param distCoeffs Output vector of distortion coefficients
 * \f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\f$ of 4, 5, 8 or 12 elements
 * @param rvecs Output vector of rotation vectors (see Rodrigues ) estimated for each board view
 * (e.g. std::vector<cv::Mat>>). That is, each k-th rotation vector together with the corresponding
 * k-th translation vector (see the next output parameter description) brings the board pattern
 * from the model coordinate space (in which object points are specified) to the world coordinate
 * space, that is, a real position of the board pattern in the k-th pattern view (k=0.. *M* -1).
 * @param tvecs Output vector of translation vectors estimated for each pattern view.
 * @param stdDeviationsIntrinsics Output vector of standard deviations estimated for intrinsic parameters.
 * Order of deviations values:
 * \f$(f_x, f_y, c_x, c_y, k_1, k_2, p_1, p_2, k_3, k_4, k_5, k_6 , s_1, s_2, s_3,
 * s_4, \tau_x, \tau_y)\f$ If one of parameters is not estimated, it's deviation is equals to zero.
 * @param stdDeviationsExtrinsics Output vector of standard deviations estimated for extrinsic parameters.
 * Order of deviations values: \f$(R_1, T_1, \dotsc , R_M, T_M)\f$ where M is number of pattern views,
 * \f$R_i, T_i\f$ are concatenated 1x3 vectors.
 * @param perViewErrors Output vector of average re-projection errors estimated for each pattern view.
 * @param flags flags Different flags  for the calibration process (see #calibrateCamera for details).
 * @param criteria Termination criteria for the iterative optimization algorithm.
 *
 * This function calibrates a camera using an Aruco Board. The function receives a list of
 * detected markers from several views of the Board. The process is similar to the chessboard
 * calibration in calibrateCamera(). The function returns the final re-projection error.
 */
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal MatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
    @ByVal MatVector rvecs, @ByVal MatVector tvecs,
    @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
    @ByVal Mat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal MatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
    @ByVal MatVector rvecs, @ByVal MatVector tvecs,
    @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
    @ByVal Mat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal UMatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
    @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
    @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
    @ByVal Mat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal UMatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
    @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
    @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
    @ByVal Mat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal GpuMatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
    @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
    @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
    @ByVal Mat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal GpuMatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
    @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
    @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
    @ByVal Mat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal MatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
    @ByVal MatVector rvecs, @ByVal MatVector tvecs,
    @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
    @ByVal UMat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal MatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
    @ByVal MatVector rvecs, @ByVal MatVector tvecs,
    @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
    @ByVal UMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal UMatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
    @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
    @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
    @ByVal UMat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal UMatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
    @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
    @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
    @ByVal UMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal GpuMatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
    @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
    @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
    @ByVal UMat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal GpuMatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
    @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
    @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
    @ByVal UMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal MatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
    @ByVal MatVector rvecs, @ByVal MatVector tvecs,
    @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
    @ByVal GpuMat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal MatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
    @ByVal MatVector rvecs, @ByVal MatVector tvecs,
    @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
    @ByVal GpuMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal UMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
    @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
    @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
    @ByVal GpuMat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal UMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
    @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
    @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
    @ByVal GpuMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal GpuMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
    @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
    @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
    @ByVal GpuMat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(
    @ByVal GpuMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
    @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
    @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
    @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
    @ByVal GpuMat perViewErrors);


/** \brief It's the same function as #calibrateCameraAruco but without calibration error estimation.
 */
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal MatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal MatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal UMatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal UMatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal GpuMatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal GpuMatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal MatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal MatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal UMatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal UMatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal GpuMatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal GpuMatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal MatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal MatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal UMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal UMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal GpuMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(
  @ByVal GpuMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
  @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs);


/**
 * \brief Given a board configuration and a set of detected markers, returns the corresponding
 * image points and object points to call solvePnP
 *
 * @param board Marker board layout.
 * @param detectedCorners List of detected marker corners of the board.
 * @param detectedIds List of identifiers for each marker.
 * @param objPoints Vector of vectors of board marker points in the board coordinate space.
 * @param imgPoints Vector of vectors of the projections of board marker corner points.
*/
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal MatVector detectedCorners,
  @ByVal Mat detectedIds, @ByVal Mat objPoints, @ByVal Mat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal UMatVector detectedCorners,
  @ByVal Mat detectedIds, @ByVal Mat objPoints, @ByVal Mat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal GpuMatVector detectedCorners,
  @ByVal Mat detectedIds, @ByVal Mat objPoints, @ByVal Mat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal MatVector detectedCorners,
  @ByVal UMat detectedIds, @ByVal UMat objPoints, @ByVal UMat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal UMatVector detectedCorners,
  @ByVal UMat detectedIds, @ByVal UMat objPoints, @ByVal UMat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal GpuMatVector detectedCorners,
  @ByVal UMat detectedIds, @ByVal UMat objPoints, @ByVal UMat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal MatVector detectedCorners,
  @ByVal GpuMat detectedIds, @ByVal GpuMat objPoints, @ByVal GpuMat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal UMatVector detectedCorners,
  @ByVal GpuMat detectedIds, @ByVal GpuMat objPoints, @ByVal GpuMat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal GpuMatVector detectedCorners,
  @ByVal GpuMat detectedIds, @ByVal GpuMat objPoints, @ByVal GpuMat imgPoints);


/** \} */



// #endif


// Parsed from <opencv2/aruco/charuco.hpp>

/*
By downloading, copying, installing or using the software you agree to this
license. If you do not agree to this license, do not download, install,
copy or use the software.

                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)

Copyright (C) 2013, OpenCV Foundation, all rights reserved.
Third party copyrights are property of their respective owners.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are
disclaimed. In no event shall copyright holders or contributors be liable for
any direct, indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.
*/

// #ifndef __OPENCV_CHARUCO_HPP__
// #define __OPENCV_CHARUCO_HPP__

// #include <opencv2/core.hpp>
// #include <vector>
// #include <opencv2/aruco.hpp>

/** \addtogroup aruco
 *  \{
<p>
<p>
/**
 * \brief ChArUco board
 * Specific class for ChArUco boards. A ChArUco board is a planar board where the markers are placed
 * inside the white squares of a chessboard. The benefits of ChArUco boards is that they provide
 * both, ArUco markers versatility and chessboard corner precision, which is important for
 * calibration and pose estimation.
 * This class also allows the easy creation and drawing of ChArUco boards.
 */
@Namespace("cv::aruco") @NoOffset public static class CharucoBoard extends Board {
    static { Loader.load(); }
    /** Default native constructor. */
    public CharucoBoard() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CharucoBoard(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CharucoBoard(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CharucoBoard position(long position) {
        return (CharucoBoard)super.position(position);
    }

    // vector of chessboard 3D corners precalculated
    public native @ByRef @Cast("std::vector<cv::Point3f>*") Point3fVector chessboardCorners(); public native CharucoBoard chessboardCorners(Point3fVector chessboardCorners);

    // for each charuco corner, nearest marker id and nearest marker corner id of each marker
    public native @ByRef IntVectorVector nearestMarkerIdx(); public native CharucoBoard nearestMarkerIdx(IntVectorVector nearestMarkerIdx);
    public native @ByRef IntVectorVector nearestMarkerCorners(); public native CharucoBoard nearestMarkerCorners(IntVectorVector nearestMarkerCorners);

    /**
     * \brief Draw a ChArUco board
     *
     * @param outSize size of the output image in pixels.
     * @param img output image with the board. The size of this image will be outSize
     * and the board will be on the center, keeping the board proportions.
     * @param marginSize minimum margins (in pixels) of the board in the output image
     * @param borderBits width of the marker borders.
     *
     * This function return the image of the ChArUco board, ready to be printed.
     */
    public native void draw(@ByVal Size outSize, @ByVal Mat img, int marginSize/*=0*/, int borderBits/*=1*/);
    public native void draw(@ByVal Size outSize, @ByVal Mat img);
    public native void draw(@ByVal Size outSize, @ByVal UMat img, int marginSize/*=0*/, int borderBits/*=1*/);
    public native void draw(@ByVal Size outSize, @ByVal UMat img);
    public native void draw(@ByVal Size outSize, @ByVal GpuMat img, int marginSize/*=0*/, int borderBits/*=1*/);
    public native void draw(@ByVal Size outSize, @ByVal GpuMat img);


    /**
     * \brief Create a CharucoBoard object
     *
     * @param squaresX number of chessboard squares in X direction
     * @param squaresY number of chessboard squares in Y direction
     * @param squareLength chessboard square side length (normally in meters)
     * @param markerLength marker side length (same unit than squareLength)
     * @param dictionary dictionary of markers indicating the type of markers.
     * The first markers in the dictionary are used to fill the white chessboard squares.
     * @return the output CharucoBoard object
     *
     * This functions creates a CharucoBoard object given the number of squares in each direction
     * and the size of the markers and chessboard squares.
     */
    public static native @Ptr CharucoBoard create(int squaresX, int squaresY, float squareLength,
                                                float markerLength, @Ptr Dictionary dictionary);

    /**
      *
      */
    public native @ByVal Size getChessboardSize();

    /**
      *
      */
    public native float getSquareLength();

    /**
      *
      */
    public native float getMarkerLength();
}




/**
 * \brief Interpolate position of ChArUco board corners
 * @param markerCorners vector of already detected markers corners. For each marker, its four
 * corners are provided, (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers, the
 * dimensions of this array should be Nx4. The order of the corners should be clockwise.
 * @param markerIds list of identifiers for each marker in corners
 * @param image input image necesary for corner refinement. Note that markers are not detected and
 * should be sent in corners and ids parameters.
 * @param board layout of ChArUco board.
 * @param charucoCorners interpolated chessboard corners
 * @param charucoIds interpolated chessboard corners identifiers
 * @param cameraMatrix optional 3x3 floating-point camera matrix
 * \f$A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\f$
 * @param distCoeffs optional vector of distortion coefficients
 * \f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\f$ of 4, 5, 8 or 12 elements
 * @param minMarkers number of adjacent markers that must be detected to return a charuco corner
 *
 * This function receives the detected markers and returns the 2D position of the chessboard corners
 * from a ChArUco board using the detected Aruco markers. If camera parameters are provided,
 * the process is based in an approximated pose estimation, else it is based on local homography.
 * Only visible corners are returned. For each corner, its corresponding identifier is
 * also returned in charucoIds.
 * The function returns the number of interpolated corners.
 */
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal MatVector markerCorners, @ByVal Mat markerIds,
                                           @ByVal Mat image, @Ptr CharucoBoard board,
                                           @ByVal Mat charucoCorners, @ByVal Mat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal MatVector markerCorners, @ByVal Mat markerIds,
                                           @ByVal Mat image, @Ptr CharucoBoard board,
                                           @ByVal Mat charucoCorners, @ByVal Mat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal UMatVector markerCorners, @ByVal Mat markerIds,
                                           @ByVal Mat image, @Ptr CharucoBoard board,
                                           @ByVal Mat charucoCorners, @ByVal Mat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal UMatVector markerCorners, @ByVal Mat markerIds,
                                           @ByVal Mat image, @Ptr CharucoBoard board,
                                           @ByVal Mat charucoCorners, @ByVal Mat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal GpuMatVector markerCorners, @ByVal Mat markerIds,
                                           @ByVal Mat image, @Ptr CharucoBoard board,
                                           @ByVal Mat charucoCorners, @ByVal Mat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal GpuMatVector markerCorners, @ByVal Mat markerIds,
                                           @ByVal Mat image, @Ptr CharucoBoard board,
                                           @ByVal Mat charucoCorners, @ByVal Mat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal MatVector markerCorners, @ByVal UMat markerIds,
                                           @ByVal UMat image, @Ptr CharucoBoard board,
                                           @ByVal UMat charucoCorners, @ByVal UMat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal MatVector markerCorners, @ByVal UMat markerIds,
                                           @ByVal UMat image, @Ptr CharucoBoard board,
                                           @ByVal UMat charucoCorners, @ByVal UMat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal UMatVector markerCorners, @ByVal UMat markerIds,
                                           @ByVal UMat image, @Ptr CharucoBoard board,
                                           @ByVal UMat charucoCorners, @ByVal UMat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal UMatVector markerCorners, @ByVal UMat markerIds,
                                           @ByVal UMat image, @Ptr CharucoBoard board,
                                           @ByVal UMat charucoCorners, @ByVal UMat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal GpuMatVector markerCorners, @ByVal UMat markerIds,
                                           @ByVal UMat image, @Ptr CharucoBoard board,
                                           @ByVal UMat charucoCorners, @ByVal UMat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal GpuMatVector markerCorners, @ByVal UMat markerIds,
                                           @ByVal UMat image, @Ptr CharucoBoard board,
                                           @ByVal UMat charucoCorners, @ByVal UMat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal MatVector markerCorners, @ByVal GpuMat markerIds,
                                           @ByVal GpuMat image, @Ptr CharucoBoard board,
                                           @ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal MatVector markerCorners, @ByVal GpuMat markerIds,
                                           @ByVal GpuMat image, @Ptr CharucoBoard board,
                                           @ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal UMatVector markerCorners, @ByVal GpuMat markerIds,
                                           @ByVal GpuMat image, @Ptr CharucoBoard board,
                                           @ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal UMatVector markerCorners, @ByVal GpuMat markerIds,
                                           @ByVal GpuMat image, @Ptr CharucoBoard board,
                                           @ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal GpuMatVector markerCorners, @ByVal GpuMat markerIds,
                                           @ByVal GpuMat image, @Ptr CharucoBoard board,
                                           @ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal GpuMatVector markerCorners, @ByVal GpuMat markerIds,
                                           @ByVal GpuMat image, @Ptr CharucoBoard board,
                                           @ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds);




/**
 * \brief Pose estimation for a ChArUco board given some of their corners
 * @param charucoCorners vector of detected charuco corners
 * @param charucoIds list of identifiers for each corner in charucoCorners
 * @param board layout of ChArUco board.
 * @param cameraMatrix input 3x3 floating-point camera matrix
 * \f$A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\f$
 * @param distCoeffs vector of distortion coefficients
 * \f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\f$ of 4, 5, 8 or 12 elements
 * @param rvec Output vector (e.g. cv::Mat) corresponding to the rotation vector of the board
 * (see cv::Rodrigues).
 * @param tvec Output vector (e.g. cv::Mat) corresponding to the translation vector of the board.
 * @param useExtrinsicGuess defines whether initial guess for \b rvec and \b tvec will be used or not.
 *
 * This function estimates a Charuco board pose from some detected corners.
 * The function checks if the input corners are enough and valid to perform pose estimation.
 * If pose estimation is valid, returns true, else returns false.
 */
@Namespace("cv::aruco") public static native @Cast("bool") boolean estimatePoseCharucoBoard(@ByVal Mat charucoCorners, @ByVal Mat charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Mat cameraMatrix,
                                           @ByVal Mat distCoeffs, @ByVal Mat rvec, @ByVal Mat tvec,
                                           @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native @Cast("bool") boolean estimatePoseCharucoBoard(@ByVal Mat charucoCorners, @ByVal Mat charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Mat cameraMatrix,
                                           @ByVal Mat distCoeffs, @ByVal Mat rvec, @ByVal Mat tvec);
@Namespace("cv::aruco") public static native @Cast("bool") boolean estimatePoseCharucoBoard(@ByVal UMat charucoCorners, @ByVal UMat charucoIds,
                                           @Ptr CharucoBoard board, @ByVal UMat cameraMatrix,
                                           @ByVal UMat distCoeffs, @ByVal UMat rvec, @ByVal UMat tvec,
                                           @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native @Cast("bool") boolean estimatePoseCharucoBoard(@ByVal UMat charucoCorners, @ByVal UMat charucoIds,
                                           @Ptr CharucoBoard board, @ByVal UMat cameraMatrix,
                                           @ByVal UMat distCoeffs, @ByVal UMat rvec, @ByVal UMat tvec);
@Namespace("cv::aruco") public static native @Cast("bool") boolean estimatePoseCharucoBoard(@ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds,
                                           @Ptr CharucoBoard board, @ByVal GpuMat cameraMatrix,
                                           @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec, @ByVal GpuMat tvec,
                                           @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native @Cast("bool") boolean estimatePoseCharucoBoard(@ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds,
                                           @Ptr CharucoBoard board, @ByVal GpuMat cameraMatrix,
                                           @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec, @ByVal GpuMat tvec);




/**
 * \brief Draws a set of Charuco corners
 * @param image input/output image. It must have 1 or 3 channels. The number of channels is not
 * altered.
 * @param charucoCorners vector of detected charuco corners
 * @param charucoIds list of identifiers for each corner in charucoCorners
 * @param cornerColor color of the square surrounding each corner
 *
 * This function draws a set of detected Charuco corners. If identifiers vector is provided, it also
 * draws the id of each corner.
 */
@Namespace("cv::aruco") public static native void drawDetectedCornersCharuco(@ByVal Mat image, @ByVal Mat charucoCorners,
                                             @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat charucoIds,
                                             @ByVal(nullValue = "cv::Scalar(255, 0, 0)") Scalar cornerColor);
@Namespace("cv::aruco") public static native void drawDetectedCornersCharuco(@ByVal Mat image, @ByVal Mat charucoCorners);
@Namespace("cv::aruco") public static native void drawDetectedCornersCharuco(@ByVal UMat image, @ByVal UMat charucoCorners,
                                             @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat charucoIds,
                                             @ByVal(nullValue = "cv::Scalar(255, 0, 0)") Scalar cornerColor);
@Namespace("cv::aruco") public static native void drawDetectedCornersCharuco(@ByVal UMat image, @ByVal UMat charucoCorners);
@Namespace("cv::aruco") public static native void drawDetectedCornersCharuco(@ByVal GpuMat image, @ByVal GpuMat charucoCorners,
                                             @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat charucoIds,
                                             @ByVal(nullValue = "cv::Scalar(255, 0, 0)") Scalar cornerColor);
@Namespace("cv::aruco") public static native void drawDetectedCornersCharuco(@ByVal GpuMat image, @ByVal GpuMat charucoCorners);



/**
 * \brief Calibrate a camera using Charuco corners
 *
 * @param charucoCorners vector of detected charuco corners per frame
 * @param charucoIds list of identifiers for each corner in charucoCorners per frame
 * @param board Marker Board layout
 * @param imageSize input image size
 * @param cameraMatrix Output 3x3 floating-point camera matrix
 * \f$A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\f$ . If CV\_CALIB\_USE\_INTRINSIC\_GUESS
 * and/or CV_CALIB_FIX_ASPECT_RATIO are specified, some or all of fx, fy, cx, cy must be
 * initialized before calling the function.
 * @param distCoeffs Output vector of distortion coefficients
 * \f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\f$ of 4, 5, 8 or 12 elements
 * @param rvecs Output vector of rotation vectors (see Rodrigues ) estimated for each board view
 * (e.g. std::vector<cv::Mat>>). That is, each k-th rotation vector together with the corresponding
 * k-th translation vector (see the next output parameter description) brings the board pattern
 * from the model coordinate space (in which object points are specified) to the world coordinate
 * space, that is, a real position of the board pattern in the k-th pattern view (k=0.. *M* -1).
 * @param tvecs Output vector of translation vectors estimated for each pattern view.
 * @param stdDeviationsIntrinsics Output vector of standard deviations estimated for intrinsic parameters.
 * Order of deviations values:
 * \f$(f_x, f_y, c_x, c_y, k_1, k_2, p_1, p_2, k_3, k_4, k_5, k_6 , s_1, s_2, s_3,
 * s_4, \tau_x, \tau_y)\f$ If one of parameters is not estimated, it's deviation is equals to zero.
 * @param stdDeviationsExtrinsics Output vector of standard deviations estimated for extrinsic parameters.
 * Order of deviations values: \f$(R_1, T_1, \dotsc , R_M, T_M)\f$ where M is number of pattern views,
 * \f$R_i, T_i\f$ are concatenated 1x3 vectors.
 * @param perViewErrors Output vector of average re-projection errors estimated for each pattern view.
 * @param flags flags Different flags  for the calibration process (see #calibrateCamera for details).
 * @param criteria Termination criteria for the iterative optimization algorithm.
 *
 * This function calibrates a camera using a set of corners of a  Charuco Board. The function
 * receives a list of detected corners and its identifiers from several views of the Board.
 * The function returns the final re-projection error.
 */
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal MatVector charucoCorners, @ByVal MatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
    @ByVal MatVector rvecs, @ByVal MatVector tvecs,
    @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
    @ByVal Mat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal MatVector charucoCorners, @ByVal MatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
    @ByVal MatVector rvecs, @ByVal MatVector tvecs,
    @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
    @ByVal Mat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
    @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
    @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
    @ByVal Mat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
    @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
    @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
    @ByVal Mat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
    @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
    @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
    @ByVal Mat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
    @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
    @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
    @ByVal Mat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal MatVector charucoCorners, @ByVal MatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
    @ByVal MatVector rvecs, @ByVal MatVector tvecs,
    @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
    @ByVal UMat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal MatVector charucoCorners, @ByVal MatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
    @ByVal MatVector rvecs, @ByVal MatVector tvecs,
    @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
    @ByVal UMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
    @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
    @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
    @ByVal UMat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
    @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
    @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
    @ByVal UMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
    @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
    @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
    @ByVal UMat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
    @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
    @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
    @ByVal UMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal MatVector charucoCorners, @ByVal MatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
    @ByVal MatVector rvecs, @ByVal MatVector tvecs,
    @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
    @ByVal GpuMat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal MatVector charucoCorners, @ByVal MatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
    @ByVal MatVector rvecs, @ByVal MatVector tvecs,
    @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
    @ByVal GpuMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
    @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
    @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
    @ByVal GpuMat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
    @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
    @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
    @ByVal GpuMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
    @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
    @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
    @ByVal GpuMat perViewErrors, int flags/*=0*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(
    @ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds, @Ptr CharucoBoard board,
    @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
    @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
    @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
    @ByVal GpuMat perViewErrors);

/** \brief It's the same function as #calibrateCameraCharuco but without calibration error estimation.
*/
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal MatVector charucoCorners, @ByVal MatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal MatVector charucoCorners, @ByVal MatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal MatVector charucoCorners, @ByVal MatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal MatVector charucoCorners, @ByVal MatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal MatVector charucoCorners, @ByVal MatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal MatVector charucoCorners, @ByVal MatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
  @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rvecs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector tvecs, int flags/*=0*/,
  @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(
  @ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds, @Ptr CharucoBoard board,
  @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs);



/**
 * \brief Detect ChArUco Diamond markers
 *
 * @param image input image necessary for corner subpixel.
 * @param markerCorners list of detected marker corners from detectMarkers function.
 * @param markerIds list of marker ids in markerCorners.
 * @param squareMarkerLengthRate rate between square and marker length:
 * squareMarkerLengthRate = squareLength/markerLength. The real units are not necessary.
 * @param diamondCorners output list of detected diamond corners (4 corners per diamond). The order
 * is the same than in marker corners: top left, top right, bottom right and bottom left. Similar
 * format than the corners returned by detectMarkers (e.g std::vector<std::vector<cv::Point2f> > ).
 * @param diamondIds ids of the diamonds in diamondCorners. The id of each diamond is in fact of
 * type Vec4i, so each diamond has 4 ids, which are the ids of the aruco markers composing the
 * diamond.
 * @param cameraMatrix Optional camera calibration matrix.
 * @param distCoeffs Optional camera distortion coefficients.
 *
 * This function detects Diamond markers from the previous detected ArUco markers. The diamonds
 * are returned in the diamondCorners and diamondIds parameters. If camera calibration parameters
 * are provided, the diamond search is based on reprojection. If not, diamond search is based on
 * homography. Homography is faster than reprojection but can slightly reduce the detection rate.
 */
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal Mat image, @ByVal MatVector markerCorners,
                                       @ByVal Mat markerIds, float squareMarkerLengthRate,
                                       @ByVal MatVector diamondCorners, @ByVal Mat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal Mat image, @ByVal MatVector markerCorners,
                                       @ByVal Mat markerIds, float squareMarkerLengthRate,
                                       @ByVal MatVector diamondCorners, @ByVal Mat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal Mat image, @ByVal UMatVector markerCorners,
                                       @ByVal Mat markerIds, float squareMarkerLengthRate,
                                       @ByVal UMatVector diamondCorners, @ByVal Mat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal Mat image, @ByVal UMatVector markerCorners,
                                       @ByVal Mat markerIds, float squareMarkerLengthRate,
                                       @ByVal UMatVector diamondCorners, @ByVal Mat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal Mat image, @ByVal GpuMatVector markerCorners,
                                       @ByVal Mat markerIds, float squareMarkerLengthRate,
                                       @ByVal GpuMatVector diamondCorners, @ByVal Mat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal Mat image, @ByVal GpuMatVector markerCorners,
                                       @ByVal Mat markerIds, float squareMarkerLengthRate,
                                       @ByVal GpuMatVector diamondCorners, @ByVal Mat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal UMat image, @ByVal MatVector markerCorners,
                                       @ByVal UMat markerIds, float squareMarkerLengthRate,
                                       @ByVal MatVector diamondCorners, @ByVal UMat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal UMat image, @ByVal MatVector markerCorners,
                                       @ByVal UMat markerIds, float squareMarkerLengthRate,
                                       @ByVal MatVector diamondCorners, @ByVal UMat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal UMat image, @ByVal UMatVector markerCorners,
                                       @ByVal UMat markerIds, float squareMarkerLengthRate,
                                       @ByVal UMatVector diamondCorners, @ByVal UMat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal UMat image, @ByVal UMatVector markerCorners,
                                       @ByVal UMat markerIds, float squareMarkerLengthRate,
                                       @ByVal UMatVector diamondCorners, @ByVal UMat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal UMat image, @ByVal GpuMatVector markerCorners,
                                       @ByVal UMat markerIds, float squareMarkerLengthRate,
                                       @ByVal GpuMatVector diamondCorners, @ByVal UMat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal UMat image, @ByVal GpuMatVector markerCorners,
                                       @ByVal UMat markerIds, float squareMarkerLengthRate,
                                       @ByVal GpuMatVector diamondCorners, @ByVal UMat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal GpuMat image, @ByVal MatVector markerCorners,
                                       @ByVal GpuMat markerIds, float squareMarkerLengthRate,
                                       @ByVal MatVector diamondCorners, @ByVal GpuMat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal GpuMat image, @ByVal MatVector markerCorners,
                                       @ByVal GpuMat markerIds, float squareMarkerLengthRate,
                                       @ByVal MatVector diamondCorners, @ByVal GpuMat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal GpuMat image, @ByVal UMatVector markerCorners,
                                       @ByVal GpuMat markerIds, float squareMarkerLengthRate,
                                       @ByVal UMatVector diamondCorners, @ByVal GpuMat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal GpuMat image, @ByVal UMatVector markerCorners,
                                       @ByVal GpuMat markerIds, float squareMarkerLengthRate,
                                       @ByVal UMatVector diamondCorners, @ByVal GpuMat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal GpuMat image, @ByVal GpuMatVector markerCorners,
                                       @ByVal GpuMat markerIds, float squareMarkerLengthRate,
                                       @ByVal GpuMatVector diamondCorners, @ByVal GpuMat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal GpuMat image, @ByVal GpuMatVector markerCorners,
                                       @ByVal GpuMat markerIds, float squareMarkerLengthRate,
                                       @ByVal GpuMatVector diamondCorners, @ByVal GpuMat diamondIds);



/**
 * \brief Draw a set of detected ChArUco Diamond markers
 *
 * @param image input/output image. It must have 1 or 3 channels. The number of channels is not
 * altered.
 * @param diamondCorners positions of diamond corners in the same format returned by
 * detectCharucoDiamond(). (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers,
 * the dimensions of this array should be Nx4. The order of the corners should be clockwise.
 * @param diamondIds vector of identifiers for diamonds in diamondCorners, in the same format
 * returned by detectCharucoDiamond() (e.g. std::vector<Vec4i>).
 * Optional, if not provided, ids are not painted.
 * @param borderColor color of marker borders. Rest of colors (text color and first corner color)
 * are calculated based on this one.
 *
 * Given an array of detected diamonds, this functions draws them in the image. The marker borders
 * are painted and the markers identifiers if provided.
 * Useful for debugging purposes.
 */
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal Mat image, @ByVal MatVector diamondCorners,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat diamondIds,
                                       @ByVal(nullValue = "cv::Scalar(0, 0, 255)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal Mat image, @ByVal MatVector diamondCorners);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal Mat image, @ByVal UMatVector diamondCorners,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat diamondIds,
                                       @ByVal(nullValue = "cv::Scalar(0, 0, 255)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal Mat image, @ByVal UMatVector diamondCorners);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal Mat image, @ByVal GpuMatVector diamondCorners,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat diamondIds,
                                       @ByVal(nullValue = "cv::Scalar(0, 0, 255)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal Mat image, @ByVal GpuMatVector diamondCorners);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal UMat image, @ByVal MatVector diamondCorners,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat diamondIds,
                                       @ByVal(nullValue = "cv::Scalar(0, 0, 255)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal UMat image, @ByVal MatVector diamondCorners);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal UMat image, @ByVal UMatVector diamondCorners,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat diamondIds,
                                       @ByVal(nullValue = "cv::Scalar(0, 0, 255)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal UMat image, @ByVal UMatVector diamondCorners);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal UMat image, @ByVal GpuMatVector diamondCorners,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat diamondIds,
                                       @ByVal(nullValue = "cv::Scalar(0, 0, 255)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal UMat image, @ByVal GpuMatVector diamondCorners);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal GpuMat image, @ByVal MatVector diamondCorners,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat diamondIds,
                                       @ByVal(nullValue = "cv::Scalar(0, 0, 255)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal GpuMat image, @ByVal MatVector diamondCorners);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal GpuMat image, @ByVal UMatVector diamondCorners,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat diamondIds,
                                       @ByVal(nullValue = "cv::Scalar(0, 0, 255)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal GpuMat image, @ByVal UMatVector diamondCorners);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal GpuMat image, @ByVal GpuMatVector diamondCorners,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat diamondIds,
                                       @ByVal(nullValue = "cv::Scalar(0, 0, 255)") Scalar borderColor);
@Namespace("cv::aruco") public static native void drawDetectedDiamonds(@ByVal GpuMat image, @ByVal GpuMatVector diamondCorners);




/**
 * \brief Draw a ChArUco Diamond marker
 *
 * @param dictionary dictionary of markers indicating the type of markers.
 * @param ids list of 4 ids for each ArUco marker in the ChArUco marker.
 * @param squareLength size of the chessboard squares in pixels.
 * @param markerLength size of the markers in pixels.
 * @param img output image with the marker. The size of this image will be
 * 3*squareLength + 2*marginSize,.
 * @param marginSize minimum margins (in pixels) of the marker in the output image
 * @param borderBits width of the marker borders.
 *
 * This function return the image of a ChArUco marker, ready to be printed.
 */
// TODO cannot be exported yet; conversion from/to Vec4i is not wrapped in core
@Namespace("cv::aruco") public static native void drawCharucoDiamond(@Ptr Dictionary dictionary, @ByVal Scalar4i ids, int squareLength,
                                   int markerLength, @ByVal Mat img, int marginSize/*=0*/,
                                   int borderBits/*=1*/);
@Namespace("cv::aruco") public static native void drawCharucoDiamond(@Ptr Dictionary dictionary, @ByVal Scalar4i ids, int squareLength,
                                   int markerLength, @ByVal Mat img);
@Namespace("cv::aruco") public static native void drawCharucoDiamond(@Ptr Dictionary dictionary, @ByVal Scalar4i ids, int squareLength,
                                   int markerLength, @ByVal UMat img, int marginSize/*=0*/,
                                   int borderBits/*=1*/);
@Namespace("cv::aruco") public static native void drawCharucoDiamond(@Ptr Dictionary dictionary, @ByVal Scalar4i ids, int squareLength,
                                   int markerLength, @ByVal UMat img);
@Namespace("cv::aruco") public static native void drawCharucoDiamond(@Ptr Dictionary dictionary, @ByVal Scalar4i ids, int squareLength,
                                   int markerLength, @ByVal GpuMat img, int marginSize/*=0*/,
                                   int borderBits/*=1*/);
@Namespace("cv::aruco") public static native void drawCharucoDiamond(@Ptr Dictionary dictionary, @ByVal Scalar4i ids, int squareLength,
                                   int markerLength, @ByVal GpuMat img);




/** \} */



// #endif


}
