// Targeted by JavaCPP version 1.4.4: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.opencv_core.*;
import static org.bytedeco.javacpp.opencv_imgproc.*;
import static org.bytedeco.javacpp.opencv_cudaarithm.*;
import static org.bytedeco.javacpp.opencv_cudafilters.*;

public class opencv_cudaimgproc extends org.bytedeco.javacpp.presets.opencv_cudaimgproc {
    static { Loader.load(); }

// Parsed from <opencv2/cudaimgproc.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CUDAIMGPROC_HPP
// #define OPENCV_CUDAIMGPROC_HPP

// #ifndef __cplusplus
// #endif

// #include "opencv2/core/cuda.hpp"
// #include "opencv2/imgproc.hpp"

/**
  \addtogroup cuda
  \{
    \defgroup cudaimgproc Image Processing
    \{
      \defgroup cudaimgproc_color Color space processing
      \defgroup cudaimgproc_hist Histogram Calculation
      \defgroup cudaimgproc_hough Hough Transform
      \defgroup cudaimgproc_feature Feature Detection
    \}
  \}
*/

/** \addtogroup cudaimgproc
 *  \{
<p>
/////////////////////////// Color Processing ///////////////////////////
 <p>
 *  \addtogroup cudaimgproc_color
 *  \{
<p>
/** \brief Converts an image from one color space to another.
<p>
@param src Source image with CV_8U , CV_16U , or CV_32F depth and 1, 3, or 4 channels.
@param dst Destination image.
@param code Color space conversion code. For details, see cvtColor .
@param dcn Number of channels in the destination image. If the parameter is 0, the number of the
channels is derived automatically from src and the code .
@param stream Stream for the asynchronous version.
<p>
3-channel color spaces (like HSV, XYZ, and so on) can be stored in a 4-channel image for better
performance.
<p>
\sa cvtColor
 */
@Namespace("cv::cuda") public static native void cvtColor(@ByVal Mat src, @ByVal Mat dst, int code, int dcn/*=0*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void cvtColor(@ByVal Mat src, @ByVal Mat dst, int code);
@Namespace("cv::cuda") public static native void cvtColor(@ByVal UMat src, @ByVal UMat dst, int code, int dcn/*=0*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void cvtColor(@ByVal UMat src, @ByVal UMat dst, int code);
@Namespace("cv::cuda") public static native void cvtColor(@ByVal GpuMat src, @ByVal GpuMat dst, int code, int dcn/*=0*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void cvtColor(@ByVal GpuMat src, @ByVal GpuMat dst, int code);

/** enum cv::cuda::DemosaicTypes */
public static final int
    /** Bayer Demosaicing (Malvar, He, and Cutler) */
    COLOR_BayerBG2BGR_MHT = 256,
    COLOR_BayerGB2BGR_MHT = 257,
    COLOR_BayerRG2BGR_MHT = 258,
    COLOR_BayerGR2BGR_MHT = 259,

    COLOR_BayerBG2RGB_MHT = COLOR_BayerRG2BGR_MHT,
    COLOR_BayerGB2RGB_MHT = COLOR_BayerGR2BGR_MHT,
    COLOR_BayerRG2RGB_MHT = COLOR_BayerBG2BGR_MHT,
    COLOR_BayerGR2RGB_MHT = COLOR_BayerGB2BGR_MHT,

    COLOR_BayerBG2GRAY_MHT = 260,
    COLOR_BayerGB2GRAY_MHT = 261,
    COLOR_BayerRG2GRAY_MHT = 262,
    COLOR_BayerGR2GRAY_MHT = 263;

/** \brief Converts an image from Bayer pattern to RGB or grayscale.
<p>
@param src Source image (8-bit or 16-bit single channel).
@param dst Destination image.
@param code Color space conversion code (see the description below).
@param dcn Number of channels in the destination image. If the parameter is 0, the number of the
channels is derived automatically from src and the code .
@param stream Stream for the asynchronous version.
<p>
The function can do the following transformations:
<p>
-   Demosaicing using bilinear interpolation
    <p>
    > -   COLOR_BayerBG2GRAY , COLOR_BayerGB2GRAY , COLOR_BayerRG2GRAY , COLOR_BayerGR2GRAY
    > -   COLOR_BayerBG2BGR , COLOR_BayerGB2BGR , COLOR_BayerRG2BGR , COLOR_BayerGR2BGR
<p>
-   Demosaicing using Malvar-He-Cutler algorithm (\cite MHT2011)
    <p>
    > -   COLOR_BayerBG2GRAY_MHT , COLOR_BayerGB2GRAY_MHT , COLOR_BayerRG2GRAY_MHT ,
    >     COLOR_BayerGR2GRAY_MHT
    > -   COLOR_BayerBG2BGR_MHT , COLOR_BayerGB2BGR_MHT , COLOR_BayerRG2BGR_MHT ,
    >     COLOR_BayerGR2BGR_MHT
<p>
\sa cvtColor
 */
@Namespace("cv::cuda") public static native void demosaicing(@ByVal Mat src, @ByVal Mat dst, int code, int dcn/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void demosaicing(@ByVal Mat src, @ByVal Mat dst, int code);
@Namespace("cv::cuda") public static native void demosaicing(@ByVal UMat src, @ByVal UMat dst, int code, int dcn/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void demosaicing(@ByVal UMat src, @ByVal UMat dst, int code);
@Namespace("cv::cuda") public static native void demosaicing(@ByVal GpuMat src, @ByVal GpuMat dst, int code, int dcn/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void demosaicing(@ByVal GpuMat src, @ByVal GpuMat dst, int code);

/** \brief Exchanges the color channels of an image in-place.
<p>
@param image Source image. Supports only CV_8UC4 type.
@param dstOrder Integer array describing how channel values are permutated. The n-th entry of the
array contains the number of the channel that is stored in the n-th channel of the output image.
E.g. Given an RGBA image, aDstOrder = [3,2,1,0] converts this to ABGR channel order.
@param stream Stream for the asynchronous version.
<p>
The methods support arbitrary permutations of the original channels, including replication.
 */
@Namespace("cv::cuda") public static native void swapChannels(@ByVal Mat image, @Const IntPointer dstOrder, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal Mat image, @Const IntPointer dstOrder);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal Mat image, @Const IntBuffer dstOrder, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal Mat image, @Const IntBuffer dstOrder);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal Mat image, @Const int[] dstOrder, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal Mat image, @Const int[] dstOrder);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal UMat image, @Const IntPointer dstOrder, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal UMat image, @Const IntPointer dstOrder);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal UMat image, @Const IntBuffer dstOrder, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal UMat image, @Const IntBuffer dstOrder);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal UMat image, @Const int[] dstOrder, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal UMat image, @Const int[] dstOrder);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal GpuMat image, @Const IntPointer dstOrder, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal GpuMat image, @Const IntPointer dstOrder);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal GpuMat image, @Const IntBuffer dstOrder, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal GpuMat image, @Const IntBuffer dstOrder);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal GpuMat image, @Const int[] dstOrder, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void swapChannels(@ByVal GpuMat image, @Const int[] dstOrder);

/** \brief Routines for correcting image color gamma.
<p>
@param src Source image (3- or 4-channel 8 bit).
@param dst Destination image.
@param forward true for forward gamma correction or false for inverse gamma correction.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void gammaCorrection(@ByVal Mat src, @ByVal Mat dst, @Cast("bool") boolean forward/*=true*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void gammaCorrection(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void gammaCorrection(@ByVal UMat src, @ByVal UMat dst, @Cast("bool") boolean forward/*=true*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void gammaCorrection(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void gammaCorrection(@ByVal GpuMat src, @ByVal GpuMat dst, @Cast("bool") boolean forward/*=true*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void gammaCorrection(@ByVal GpuMat src, @ByVal GpuMat dst);

/** enum cv::cuda::AlphaCompTypes */
public static final int ALPHA_OVER = 0, ALPHA_IN = 1, ALPHA_OUT = 2, ALPHA_ATOP = 3, ALPHA_XOR = 4, ALPHA_PLUS = 5, ALPHA_OVER_PREMUL = 6, ALPHA_IN_PREMUL = 7, ALPHA_OUT_PREMUL = 8,
       ALPHA_ATOP_PREMUL = 9, ALPHA_XOR_PREMUL = 10, ALPHA_PLUS_PREMUL = 11, ALPHA_PREMUL = 12;

/** \brief Composites two images using alpha opacity values contained in each image.
<p>
@param img1 First image. Supports CV_8UC4 , CV_16UC4 , CV_32SC4 and CV_32FC4 types.
@param img2 Second image. Must have the same size and the same type as img1 .
@param dst Destination image.
@param alpha_op Flag specifying the alpha-blending operation:
-   **ALPHA_OVER**
-   **ALPHA_IN**
-   **ALPHA_OUT**
-   **ALPHA_ATOP**
-   **ALPHA_XOR**
-   **ALPHA_PLUS**
-   **ALPHA_OVER_PREMUL**
-   **ALPHA_IN_PREMUL**
-   **ALPHA_OUT_PREMUL**
-   **ALPHA_ATOP_PREMUL**
-   **ALPHA_XOR_PREMUL**
-   **ALPHA_PLUS_PREMUL**
-   **ALPHA_PREMUL**
@param stream Stream for the asynchronous version.
<p>
\note
   -   An example demonstrating the use of alphaComp can be found at
        opencv_source_code/samples/gpu/alpha_comp.cpp
 */
@Namespace("cv::cuda") public static native void alphaComp(@ByVal Mat img1, @ByVal Mat img2, @ByVal Mat dst, int alpha_op, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void alphaComp(@ByVal Mat img1, @ByVal Mat img2, @ByVal Mat dst, int alpha_op);
@Namespace("cv::cuda") public static native void alphaComp(@ByVal UMat img1, @ByVal UMat img2, @ByVal UMat dst, int alpha_op, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void alphaComp(@ByVal UMat img1, @ByVal UMat img2, @ByVal UMat dst, int alpha_op);
@Namespace("cv::cuda") public static native void alphaComp(@ByVal GpuMat img1, @ByVal GpuMat img2, @ByVal GpuMat dst, int alpha_op, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void alphaComp(@ByVal GpuMat img1, @ByVal GpuMat img2, @ByVal GpuMat dst, int alpha_op);

/** \} cudaimgproc_color
<p>
////////////////////////////// Histogram ///////////////////////////////
 <p>
 *  \addtogroup cudaimgproc_hist
 *  \{
<p>
/** \brief Calculates histogram for one channel 8-bit image.
<p>
@param src Source image with CV_8UC1 type.
@param hist Destination histogram with one row, 256 columns, and the CV_32SC1 type.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void calcHist(@ByVal Mat src, @ByVal Mat hist, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcHist(@ByVal Mat src, @ByVal Mat hist);
@Namespace("cv::cuda") public static native void calcHist(@ByVal UMat src, @ByVal UMat hist, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcHist(@ByVal UMat src, @ByVal UMat hist);
@Namespace("cv::cuda") public static native void calcHist(@ByVal GpuMat src, @ByVal GpuMat hist, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcHist(@ByVal GpuMat src, @ByVal GpuMat hist);

/** \brief Calculates histogram for one channel 8-bit image confined in given mask.
<p>
@param src Source image with CV_8UC1 type.
@param hist Destination histogram with one row, 256 columns, and the CV_32SC1 type.
@param mask A mask image same size as src and of type CV_8UC1.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void calcHist(@ByVal Mat src, @ByVal Mat mask, @ByVal Mat hist, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcHist(@ByVal Mat src, @ByVal Mat mask, @ByVal Mat hist);
@Namespace("cv::cuda") public static native void calcHist(@ByVal UMat src, @ByVal UMat mask, @ByVal UMat hist, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcHist(@ByVal UMat src, @ByVal UMat mask, @ByVal UMat hist);
@Namespace("cv::cuda") public static native void calcHist(@ByVal GpuMat src, @ByVal GpuMat mask, @ByVal GpuMat hist, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcHist(@ByVal GpuMat src, @ByVal GpuMat mask, @ByVal GpuMat hist);

/** \brief Equalizes the histogram of a grayscale image.
<p>
@param src Source image with CV_8UC1 type.
@param dst Destination image.
@param stream Stream for the asynchronous version.
<p>
\sa equalizeHist
 */
@Namespace("cv::cuda") public static native void equalizeHist(@ByVal Mat src, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void equalizeHist(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void equalizeHist(@ByVal UMat src, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void equalizeHist(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void equalizeHist(@ByVal GpuMat src, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void equalizeHist(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Base class for Contrast Limited Adaptive Histogram Equalization. :
 */
@Name("cv::cuda::CLAHE") public static class CudaCLAHE extends CLAHE {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CudaCLAHE(Pointer p) { super(p); }

    /** \brief Equalizes the histogram of a grayscale image using Contrast Limited Adaptive Histogram Equalization.
    <p>
    @param src Source image with CV_8UC1 type.
    @param dst Destination image.
    @param stream Stream for the asynchronous version.
     */
    public native void apply(@ByVal Mat src, @ByVal Mat dst, @ByRef Stream stream);
    public native void apply(@ByVal UMat src, @ByVal UMat dst, @ByRef Stream stream);
    public native void apply(@ByVal GpuMat src, @ByVal GpuMat dst, @ByRef Stream stream);
}

/** \brief Creates implementation for cuda::CLAHE .
<p>
@param clipLimit Threshold for contrast limiting.
@param tileGridSize Size of grid for histogram equalization. Input image will be divided into
equally sized rectangular tiles. tileGridSize defines the number of tiles in row and column.
 */
@Namespace("cv::cuda") public static native @Ptr CudaCLAHE createCLAHE(double clipLimit/*=40.0*/, @ByVal(nullValue = "cv::Size(8, 8)") Size tileGridSize);
@Namespace("cv::cuda") public static native @Ptr CudaCLAHE createCLAHE();

/** \brief Computes levels with even distribution.
<p>
@param levels Destination array. levels has 1 row, nLevels columns, and the CV_32SC1 type.
@param nLevels Number of computed levels. nLevels must be at least 2.
@param lowerLevel Lower boundary value of the lowest level.
@param upperLevel Upper boundary value of the greatest level.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void evenLevels(@ByVal Mat levels, int nLevels, int lowerLevel, int upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void evenLevels(@ByVal Mat levels, int nLevels, int lowerLevel, int upperLevel);
@Namespace("cv::cuda") public static native void evenLevels(@ByVal UMat levels, int nLevels, int lowerLevel, int upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void evenLevels(@ByVal UMat levels, int nLevels, int lowerLevel, int upperLevel);
@Namespace("cv::cuda") public static native void evenLevels(@ByVal GpuMat levels, int nLevels, int lowerLevel, int upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void evenLevels(@ByVal GpuMat levels, int nLevels, int lowerLevel, int upperLevel);

/** \brief Calculates a histogram with evenly distributed bins.
<p>
@param src Source image. CV_8U, CV_16U, or CV_16S depth and 1 or 4 channels are supported. For
a four-channel image, all channels are processed separately.
@param hist Destination histogram with one row, histSize columns, and the CV_32S type.
@param histSize Size of the histogram.
@param lowerLevel Lower boundary of lowest-level bin.
@param upperLevel Upper boundary of highest-level bin.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void histEven(@ByVal Mat src, @ByVal Mat hist, int histSize, int lowerLevel, int upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histEven(@ByVal Mat src, @ByVal Mat hist, int histSize, int lowerLevel, int upperLevel);
@Namespace("cv::cuda") public static native void histEven(@ByVal UMat src, @ByVal UMat hist, int histSize, int lowerLevel, int upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histEven(@ByVal UMat src, @ByVal UMat hist, int histSize, int lowerLevel, int upperLevel);
@Namespace("cv::cuda") public static native void histEven(@ByVal GpuMat src, @ByVal GpuMat hist, int histSize, int lowerLevel, int upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histEven(@ByVal GpuMat src, @ByVal GpuMat hist, int histSize, int lowerLevel, int upperLevel);
/** \overload */
@Namespace("cv::cuda") public static native void histEven(@ByVal Mat src, GpuMat hist, IntPointer histSize, IntPointer lowerLevel, IntPointer upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histEven(@ByVal Mat src, GpuMat hist, IntPointer histSize, IntPointer lowerLevel, IntPointer upperLevel);
@Namespace("cv::cuda") public static native void histEven(@ByVal Mat src, GpuMat hist, IntBuffer histSize, IntBuffer lowerLevel, IntBuffer upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histEven(@ByVal Mat src, GpuMat hist, IntBuffer histSize, IntBuffer lowerLevel, IntBuffer upperLevel);
@Namespace("cv::cuda") public static native void histEven(@ByVal Mat src, GpuMat hist, int[] histSize, int[] lowerLevel, int[] upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histEven(@ByVal Mat src, GpuMat hist, int[] histSize, int[] lowerLevel, int[] upperLevel);
@Namespace("cv::cuda") public static native void histEven(@ByVal UMat src, GpuMat hist, IntPointer histSize, IntPointer lowerLevel, IntPointer upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histEven(@ByVal UMat src, GpuMat hist, IntPointer histSize, IntPointer lowerLevel, IntPointer upperLevel);
@Namespace("cv::cuda") public static native void histEven(@ByVal UMat src, GpuMat hist, IntBuffer histSize, IntBuffer lowerLevel, IntBuffer upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histEven(@ByVal UMat src, GpuMat hist, IntBuffer histSize, IntBuffer lowerLevel, IntBuffer upperLevel);
@Namespace("cv::cuda") public static native void histEven(@ByVal UMat src, GpuMat hist, int[] histSize, int[] lowerLevel, int[] upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histEven(@ByVal UMat src, GpuMat hist, int[] histSize, int[] lowerLevel, int[] upperLevel);
@Namespace("cv::cuda") public static native void histEven(@ByVal GpuMat src, GpuMat hist, IntPointer histSize, IntPointer lowerLevel, IntPointer upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histEven(@ByVal GpuMat src, GpuMat hist, IntPointer histSize, IntPointer lowerLevel, IntPointer upperLevel);
@Namespace("cv::cuda") public static native void histEven(@ByVal GpuMat src, GpuMat hist, IntBuffer histSize, IntBuffer lowerLevel, IntBuffer upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histEven(@ByVal GpuMat src, GpuMat hist, IntBuffer histSize, IntBuffer lowerLevel, IntBuffer upperLevel);
@Namespace("cv::cuda") public static native void histEven(@ByVal GpuMat src, GpuMat hist, int[] histSize, int[] lowerLevel, int[] upperLevel, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histEven(@ByVal GpuMat src, GpuMat hist, int[] histSize, int[] lowerLevel, int[] upperLevel);

/** \brief Calculates a histogram with bins determined by the levels array.
<p>
@param src Source image. CV_8U , CV_16U , or CV_16S depth and 1 or 4 channels are supported.
For a four-channel image, all channels are processed separately.
@param hist Destination histogram with one row, (levels.cols-1) columns, and the CV_32SC1 type.
@param levels Number of levels in the histogram.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void histRange(@ByVal Mat src, @ByVal Mat hist, @ByVal Mat levels, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histRange(@ByVal Mat src, @ByVal Mat hist, @ByVal Mat levels);
@Namespace("cv::cuda") public static native void histRange(@ByVal UMat src, @ByVal UMat hist, @ByVal UMat levels, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histRange(@ByVal UMat src, @ByVal UMat hist, @ByVal UMat levels);
@Namespace("cv::cuda") public static native void histRange(@ByVal GpuMat src, @ByVal GpuMat hist, @ByVal GpuMat levels, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histRange(@ByVal GpuMat src, @ByVal GpuMat hist, @ByVal GpuMat levels);
/** \overload */
@Namespace("cv::cuda") public static native void histRange(@ByVal Mat src, GpuMat hist, @Const GpuMat levels, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histRange(@ByVal Mat src, GpuMat hist, @Const GpuMat levels);
@Namespace("cv::cuda") public static native void histRange(@ByVal UMat src, GpuMat hist, @Const GpuMat levels, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void histRange(@ByVal UMat src, GpuMat hist, @Const GpuMat levels);

/** \} cudaimgproc_hist
<p>
//////////////////////////////// Canny ////////////////////////////////
<p>
/** \brief Base class for Canny Edge Detector. :
 */
@Namespace("cv::cuda") public static class CannyEdgeDetector extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CannyEdgeDetector(Pointer p) { super(p); }

    /** \brief Finds edges in an image using the \cite Canny86 algorithm.
    <p>
    @param image Single-channel 8-bit input image.
    @param edges Output edge map. It has the same size and type as image.
    @param stream Stream for the asynchronous version.
     */
    public native void detect(@ByVal Mat image, @ByVal Mat edges, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal Mat image, @ByVal Mat edges);
    public native void detect(@ByVal UMat image, @ByVal UMat edges, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal UMat image, @ByVal UMat edges);
    public native void detect(@ByVal GpuMat image, @ByVal GpuMat edges, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal GpuMat image, @ByVal GpuMat edges);
    /** \overload
    @param dx First derivative of image in the vertical direction. Support only CV_32S type.
    @param dy First derivative of image in the horizontal direction. Support only CV_32S type.
    @param edges Output edge map. It has the same size and type as image.
    @param stream Stream for the asynchronous version.
    */
    public native void detect(@ByVal Mat dx, @ByVal Mat dy, @ByVal Mat edges, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal Mat dx, @ByVal Mat dy, @ByVal Mat edges);
    public native void detect(@ByVal UMat dx, @ByVal UMat dy, @ByVal UMat edges, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal UMat dx, @ByVal UMat dy, @ByVal UMat edges);
    public native void detect(@ByVal GpuMat dx, @ByVal GpuMat dy, @ByVal GpuMat edges, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal GpuMat dx, @ByVal GpuMat dy, @ByVal GpuMat edges);

    public native void setLowThreshold(double low_thresh);
    public native double getLowThreshold();

    public native void setHighThreshold(double high_thresh);
    public native double getHighThreshold();

    public native void setAppertureSize(int apperture_size);
    public native int getAppertureSize();

    public native void setL2Gradient(@Cast("bool") boolean L2gradient);
    public native @Cast("bool") boolean getL2Gradient();
}

/** \brief Creates implementation for cuda::CannyEdgeDetector .
<p>
@param low_thresh First threshold for the hysteresis procedure.
@param high_thresh Second threshold for the hysteresis procedure.
@param apperture_size Aperture size for the Sobel operator.
@param L2gradient Flag indicating whether a more accurate \f$L_2\f$ norm
\f$=\sqrt{(dI/dx)^2 + (dI/dy)^2}\f$ should be used to compute the image gradient magnitude (
L2gradient=true ), or a faster default \f$L_1\f$ norm \f$=|dI/dx|+|dI/dy|\f$ is enough ( L2gradient=false
).
 */
@Namespace("cv::cuda") public static native @Ptr CannyEdgeDetector createCannyEdgeDetector(double low_thresh, double high_thresh, int apperture_size/*=3*/, @Cast("bool") boolean L2gradient/*=false*/);
@Namespace("cv::cuda") public static native @Ptr CannyEdgeDetector createCannyEdgeDetector(double low_thresh, double high_thresh);

/////////////////////////// Hough Transform ////////////////////////////

//////////////////////////////////////
// HoughLines

/** \addtogroup cudaimgproc_hough
 *  \{
<p>
/** \brief Base class for lines detector algorithm. :
 */
@Namespace("cv::cuda") public static class HoughLinesDetector extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public HoughLinesDetector(Pointer p) { super(p); }

    /** \brief Finds lines in a binary image using the classical Hough transform.
    <p>
    @param src 8-bit, single-channel binary source image.
    @param lines Output vector of lines. Each line is represented by a two-element vector
    \f$(\rho, \theta)\f$ . \f$\rho\f$ is the distance from the coordinate origin \f$(0,0)\f$ (top-left corner of
    the image). \f$\theta\f$ is the line rotation angle in radians (
    \f$0 \sim \textrm{vertical line}, \pi/2 \sim \textrm{horizontal line}\f$ ).
    @param stream Stream for the asynchronous version.
    <p>
    \sa HoughLines
     */
    public native void detect(@ByVal Mat src, @ByVal Mat lines, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal Mat src, @ByVal Mat lines);
    public native void detect(@ByVal UMat src, @ByVal UMat lines, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal UMat src, @ByVal UMat lines);
    public native void detect(@ByVal GpuMat src, @ByVal GpuMat lines, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal GpuMat src, @ByVal GpuMat lines);

    /** \brief Downloads results from cuda::HoughLinesDetector::detect to host memory.
    <p>
    @param d_lines Result of cuda::HoughLinesDetector::detect .
    @param h_lines Output host array.
    @param h_votes Optional output array for line's votes.
    @param stream Stream for the asynchronous version.
     */
    public native void downloadResults(@ByVal Mat d_lines, @ByVal Mat h_lines, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat h_votes, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void downloadResults(@ByVal Mat d_lines, @ByVal Mat h_lines);
    public native void downloadResults(@ByVal UMat d_lines, @ByVal UMat h_lines, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat h_votes, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void downloadResults(@ByVal UMat d_lines, @ByVal UMat h_lines);
    public native void downloadResults(@ByVal GpuMat d_lines, @ByVal GpuMat h_lines, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat h_votes, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void downloadResults(@ByVal GpuMat d_lines, @ByVal GpuMat h_lines);

    public native void setRho(float rho);
    public native float getRho();

    public native void setTheta(float theta);
    public native float getTheta();

    public native void setThreshold(int threshold);
    public native int getThreshold();

    public native void setDoSort(@Cast("bool") boolean doSort);
    public native @Cast("bool") boolean getDoSort();

    public native void setMaxLines(int maxLines);
    public native int getMaxLines();
}

/** \brief Creates implementation for cuda::HoughLinesDetector .
<p>
@param rho Distance resolution of the accumulator in pixels.
@param theta Angle resolution of the accumulator in radians.
@param threshold Accumulator threshold parameter. Only those lines are returned that get enough
votes ( \f$>\texttt{threshold}\f$ ).
@param doSort Performs lines sort by votes.
@param maxLines Maximum number of output lines.
 */
@Namespace("cv::cuda") public static native @Ptr HoughLinesDetector createHoughLinesDetector(float rho, float theta, int threshold, @Cast("bool") boolean doSort/*=false*/, int maxLines/*=4096*/);
@Namespace("cv::cuda") public static native @Ptr HoughLinesDetector createHoughLinesDetector(float rho, float theta, int threshold);


//////////////////////////////////////
// HoughLinesP

/** \brief Base class for line segments detector algorithm. :
 */
@Namespace("cv::cuda") public static class HoughSegmentDetector extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public HoughSegmentDetector(Pointer p) { super(p); }

    /** \brief Finds line segments in a binary image using the probabilistic Hough transform.
    <p>
    @param src 8-bit, single-channel binary source image.
    @param lines Output vector of lines. Each line is represented by a 4-element vector
    \f$(x_1, y_1, x_2, y_2)\f$ , where \f$(x_1,y_1)\f$ and \f$(x_2, y_2)\f$ are the ending points of each detected
    line segment.
    @param stream Stream for the asynchronous version.
    <p>
    \sa HoughLinesP
     */
    public native void detect(@ByVal Mat src, @ByVal Mat lines, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal Mat src, @ByVal Mat lines);
    public native void detect(@ByVal UMat src, @ByVal UMat lines, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal UMat src, @ByVal UMat lines);
    public native void detect(@ByVal GpuMat src, @ByVal GpuMat lines, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal GpuMat src, @ByVal GpuMat lines);

    public native void setRho(float rho);
    public native float getRho();

    public native void setTheta(float theta);
    public native float getTheta();

    public native void setMinLineLength(int minLineLength);
    public native int getMinLineLength();

    public native void setMaxLineGap(int maxLineGap);
    public native int getMaxLineGap();

    public native void setMaxLines(int maxLines);
    public native int getMaxLines();
}

/** \brief Creates implementation for cuda::HoughSegmentDetector .
<p>
@param rho Distance resolution of the accumulator in pixels.
@param theta Angle resolution of the accumulator in radians.
@param minLineLength Minimum line length. Line segments shorter than that are rejected.
@param maxLineGap Maximum allowed gap between points on the same line to link them.
@param maxLines Maximum number of output lines.
 */
@Namespace("cv::cuda") public static native @Ptr HoughSegmentDetector createHoughSegmentDetector(float rho, float theta, int minLineLength, int maxLineGap, int maxLines/*=4096*/);
@Namespace("cv::cuda") public static native @Ptr HoughSegmentDetector createHoughSegmentDetector(float rho, float theta, int minLineLength, int maxLineGap);

//////////////////////////////////////
// HoughCircles

/** \brief Base class for circles detector algorithm. :
 */
@Namespace("cv::cuda") public static class HoughCirclesDetector extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public HoughCirclesDetector(Pointer p) { super(p); }

    /** \brief Finds circles in a grayscale image using the Hough transform.
    <p>
    @param src 8-bit, single-channel grayscale input image.
    @param circles Output vector of found circles. Each vector is encoded as a 3-element
    floating-point vector \f$(x, y, radius)\f$ .
    @param stream Stream for the asynchronous version.
    <p>
    \sa HoughCircles
     */
    public native void detect(@ByVal Mat src, @ByVal Mat circles, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal Mat src, @ByVal Mat circles);
    public native void detect(@ByVal UMat src, @ByVal UMat circles, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal UMat src, @ByVal UMat circles);
    public native void detect(@ByVal GpuMat src, @ByVal GpuMat circles, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal GpuMat src, @ByVal GpuMat circles);

    public native void setDp(float dp);
    public native float getDp();

    public native void setMinDist(float minDist);
    public native float getMinDist();

    public native void setCannyThreshold(int cannyThreshold);
    public native int getCannyThreshold();

    public native void setVotesThreshold(int votesThreshold);
    public native int getVotesThreshold();

    public native void setMinRadius(int minRadius);
    public native int getMinRadius();

    public native void setMaxRadius(int maxRadius);
    public native int getMaxRadius();

    public native void setMaxCircles(int maxCircles);
    public native int getMaxCircles();
}

/** \brief Creates implementation for cuda::HoughCirclesDetector .
<p>
@param dp Inverse ratio of the accumulator resolution to the image resolution. For example, if
dp=1 , the accumulator has the same resolution as the input image. If dp=2 , the accumulator has
half as big width and height.
@param minDist Minimum distance between the centers of the detected circles. If the parameter is
too small, multiple neighbor circles may be falsely detected in addition to a true one. If it is
too large, some circles may be missed.
@param cannyThreshold The higher threshold of the two passed to Canny edge detector (the lower one
is twice smaller).
@param votesThreshold The accumulator threshold for the circle centers at the detection stage. The
smaller it is, the more false circles may be detected.
@param minRadius Minimum circle radius.
@param maxRadius Maximum circle radius.
@param maxCircles Maximum number of output circles.
 */
@Namespace("cv::cuda") public static native @Ptr HoughCirclesDetector createHoughCirclesDetector(float dp, float minDist, int cannyThreshold, int votesThreshold, int minRadius, int maxRadius, int maxCircles/*=4096*/);
@Namespace("cv::cuda") public static native @Ptr HoughCirclesDetector createHoughCirclesDetector(float dp, float minDist, int cannyThreshold, int votesThreshold, int minRadius, int maxRadius);

//////////////////////////////////////
// GeneralizedHough

/** \brief Creates implementation for generalized hough transform from \cite Ballard1981 .
 */
@Namespace("cv::cuda") public static native @Ptr GeneralizedHoughBallard createGeneralizedHoughBallard();

/** \brief Creates implementation for generalized hough transform from \cite Guil1999 .
 */
@Namespace("cv::cuda") public static native @Ptr GeneralizedHoughGuil createGeneralizedHoughGuil();

/** \} cudaimgproc_hough
<p>
////////////////////////// Corners Detection ///////////////////////////
 <p>
 *  \addtogroup cudaimgproc_feature
 *  \{
<p>
/** \brief Base class for Cornerness Criteria computation. :
 */
@Namespace("cv::cuda") public static class CornernessCriteria extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CornernessCriteria(Pointer p) { super(p); }

    /** \brief Computes the cornerness criteria at each image pixel.
    <p>
    @param src Source image.
    @param dst Destination image containing cornerness values. It will have the same size as src and
    CV_32FC1 type.
    @param stream Stream for the asynchronous version.
     */
    public native void compute(@ByVal Mat src, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void compute(@ByVal Mat src, @ByVal Mat dst);
    public native void compute(@ByVal UMat src, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void compute(@ByVal UMat src, @ByVal UMat dst);
    public native void compute(@ByVal GpuMat src, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void compute(@ByVal GpuMat src, @ByVal GpuMat dst);
}

/** \brief Creates implementation for Harris cornerness criteria.
<p>
@param srcType Input source type. Only CV_8UC1 and CV_32FC1 are supported for now.
@param blockSize Neighborhood size.
@param ksize Aperture parameter for the Sobel operator.
@param k Harris detector free parameter.
@param borderType Pixel extrapolation method. Only BORDER_REFLECT101 and BORDER_REPLICATE are
supported for now.
<p>
\sa cornerHarris
 */
@Namespace("cv::cuda") public static native @Ptr CornernessCriteria createHarrisCorner(int srcType, int blockSize, int ksize, double k, int borderType/*=cv::BORDER_REFLECT101*/);
@Namespace("cv::cuda") public static native @Ptr CornernessCriteria createHarrisCorner(int srcType, int blockSize, int ksize, double k);

/** \brief Creates implementation for the minimum eigen value of a 2x2 derivative covariation matrix (the
cornerness criteria).
<p>
@param srcType Input source type. Only CV_8UC1 and CV_32FC1 are supported for now.
@param blockSize Neighborhood size.
@param ksize Aperture parameter for the Sobel operator.
@param borderType Pixel extrapolation method. Only BORDER_REFLECT101 and BORDER_REPLICATE are
supported for now.
<p>
\sa cornerMinEigenVal
 */
@Namespace("cv::cuda") public static native @Ptr CornernessCriteria createMinEigenValCorner(int srcType, int blockSize, int ksize, int borderType/*=cv::BORDER_REFLECT101*/);
@Namespace("cv::cuda") public static native @Ptr CornernessCriteria createMinEigenValCorner(int srcType, int blockSize, int ksize);

////////////////////////// Corners Detection ///////////////////////////

/** \brief Base class for Corners Detector. :
 */
@Namespace("cv::cuda") public static class CornersDetector extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CornersDetector(Pointer p) { super(p); }

    /** \brief Determines strong corners on an image.
    <p>
    @param image Input 8-bit or floating-point 32-bit, single-channel image.
    @param corners Output vector of detected corners (1-row matrix with CV_32FC2 type with corners
    positions).
    @param mask Optional region of interest. If the image is not empty (it needs to have the type
    CV_8UC1 and the same size as image ), it specifies the region in which the corners are detected.
    @param stream Stream for the asynchronous version.
     */
    public native void detect(@ByVal Mat image, @ByVal Mat corners, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal Mat image, @ByVal Mat corners);
    public native void detect(@ByVal UMat image, @ByVal UMat corners, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal UMat image, @ByVal UMat corners);
    public native void detect(@ByVal GpuMat image, @ByVal GpuMat corners, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detect(@ByVal GpuMat image, @ByVal GpuMat corners);
}

/** \brief Creates implementation for cuda::CornersDetector .
<p>
@param srcType Input source type. Only CV_8UC1 and CV_32FC1 are supported for now.
@param maxCorners Maximum number of corners to return. If there are more corners than are found,
the strongest of them is returned.
@param qualityLevel Parameter characterizing the minimal accepted quality of image corners. The
parameter value is multiplied by the best corner quality measure, which is the minimal eigenvalue
(see cornerMinEigenVal ) or the Harris function response (see cornerHarris ). The corners with the
quality measure less than the product are rejected. For example, if the best corner has the
quality measure = 1500, and the qualityLevel=0.01 , then all the corners with the quality measure
less than 15 are rejected.
@param minDistance Minimum possible Euclidean distance between the returned corners.
@param blockSize Size of an average block for computing a derivative covariation matrix over each
pixel neighborhood. See cornerEigenValsAndVecs .
@param useHarrisDetector Parameter indicating whether to use a Harris detector (see cornerHarris)
or cornerMinEigenVal.
@param harrisK Free parameter of the Harris detector.
 */
@Namespace("cv::cuda") public static native @Ptr CornersDetector createGoodFeaturesToTrackDetector(int srcType, int maxCorners/*=1000*/, double qualityLevel/*=0.01*/, double minDistance/*=0.0*/,
                                                                  int blockSize/*=3*/, @Cast("bool") boolean useHarrisDetector/*=false*/, double harrisK/*=0.04*/);
@Namespace("cv::cuda") public static native @Ptr CornersDetector createGoodFeaturesToTrackDetector(int srcType);

/** \} cudaimgproc_feature
<p>
<p>
///////////////////////////// Mean Shift //////////////////////////////
<p>
/** \brief Performs mean-shift filtering for each point of the source image.
<p>
@param src Source image. Only CV_8UC4 images are supported for now.
@param dst Destination image containing the color of mapped points. It has the same size and type
as src .
@param sp Spatial window radius.
@param sr Color window radius.
@param criteria Termination criteria. See TermCriteria.
@param stream Stream for the asynchronous version.
<p>
It maps each point of the source image into another point. As a result, you have a new color and new
position of each point.
 */
@Namespace("cv::cuda") public static native void meanShiftFiltering(@ByVal Mat src, @ByVal Mat dst, int sp, int sr,
                                   @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::MAX_ITER + cv::TermCriteria::EPS, 5, 1)") TermCriteria criteria,
                                   @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanShiftFiltering(@ByVal Mat src, @ByVal Mat dst, int sp, int sr);
@Namespace("cv::cuda") public static native void meanShiftFiltering(@ByVal UMat src, @ByVal UMat dst, int sp, int sr,
                                   @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::MAX_ITER + cv::TermCriteria::EPS, 5, 1)") TermCriteria criteria,
                                   @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanShiftFiltering(@ByVal UMat src, @ByVal UMat dst, int sp, int sr);
@Namespace("cv::cuda") public static native void meanShiftFiltering(@ByVal GpuMat src, @ByVal GpuMat dst, int sp, int sr,
                                   @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::MAX_ITER + cv::TermCriteria::EPS, 5, 1)") TermCriteria criteria,
                                   @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanShiftFiltering(@ByVal GpuMat src, @ByVal GpuMat dst, int sp, int sr);

/** \brief Performs a mean-shift procedure and stores information about processed points (their colors and
positions) in two images.
<p>
@param src Source image. Only CV_8UC4 images are supported for now.
@param dstr Destination image containing the color of mapped points. The size and type is the same
as src .
@param dstsp Destination image containing the position of mapped points. The size is the same as
src size. The type is CV_16SC2 .
@param sp Spatial window radius.
@param sr Color window radius.
@param criteria Termination criteria. See TermCriteria.
@param stream Stream for the asynchronous version.
<p>
\sa cuda::meanShiftFiltering
 */
@Namespace("cv::cuda") public static native void meanShiftProc(@ByVal Mat src, @ByVal Mat dstr, @ByVal Mat dstsp, int sp, int sr,
                              @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::MAX_ITER + cv::TermCriteria::EPS, 5, 1)") TermCriteria criteria,
                              @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanShiftProc(@ByVal Mat src, @ByVal Mat dstr, @ByVal Mat dstsp, int sp, int sr);
@Namespace("cv::cuda") public static native void meanShiftProc(@ByVal UMat src, @ByVal UMat dstr, @ByVal UMat dstsp, int sp, int sr,
                              @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::MAX_ITER + cv::TermCriteria::EPS, 5, 1)") TermCriteria criteria,
                              @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanShiftProc(@ByVal UMat src, @ByVal UMat dstr, @ByVal UMat dstsp, int sp, int sr);
@Namespace("cv::cuda") public static native void meanShiftProc(@ByVal GpuMat src, @ByVal GpuMat dstr, @ByVal GpuMat dstsp, int sp, int sr,
                              @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::MAX_ITER + cv::TermCriteria::EPS, 5, 1)") TermCriteria criteria,
                              @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanShiftProc(@ByVal GpuMat src, @ByVal GpuMat dstr, @ByVal GpuMat dstsp, int sp, int sr);

/** \brief Performs a mean-shift segmentation of the source image and eliminates small segments.
<p>
@param src Source image. Only CV_8UC4 images are supported for now.
@param dst Segmented image with the same size and type as src (host or gpu memory).
@param sp Spatial window radius.
@param sr Color window radius.
@param minsize Minimum segment size. Smaller segments are merged.
@param criteria Termination criteria. See TermCriteria.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void meanShiftSegmentation(@ByVal Mat src, @ByVal Mat dst, int sp, int sr, int minsize,
                                      @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::MAX_ITER + cv::TermCriteria::EPS, 5, 1)") TermCriteria criteria,
                                      @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanShiftSegmentation(@ByVal Mat src, @ByVal Mat dst, int sp, int sr, int minsize);
@Namespace("cv::cuda") public static native void meanShiftSegmentation(@ByVal UMat src, @ByVal UMat dst, int sp, int sr, int minsize,
                                      @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::MAX_ITER + cv::TermCriteria::EPS, 5, 1)") TermCriteria criteria,
                                      @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanShiftSegmentation(@ByVal UMat src, @ByVal UMat dst, int sp, int sr, int minsize);
@Namespace("cv::cuda") public static native void meanShiftSegmentation(@ByVal GpuMat src, @ByVal GpuMat dst, int sp, int sr, int minsize,
                                      @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::MAX_ITER + cv::TermCriteria::EPS, 5, 1)") TermCriteria criteria,
                                      @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanShiftSegmentation(@ByVal GpuMat src, @ByVal GpuMat dst, int sp, int sr, int minsize);

/////////////////////////// Match Template ////////////////////////////

/** \brief Base class for Template Matching. :
 */
@Namespace("cv::cuda") public static class TemplateMatching extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TemplateMatching(Pointer p) { super(p); }

    /** \brief Computes a proximity map for a raster template and an image where the template is searched for.
    <p>
    @param image Source image.
    @param templ Template image with the size and type the same as image .
    @param result Map containing comparison results ( CV_32FC1 ). If image is *W x H* and templ is *w
    x h*, then result must be *W-w+1 x H-h+1*.
    @param stream Stream for the asynchronous version.
     */
    public native void match(@ByVal Mat image, @ByVal Mat templ, @ByVal Mat result, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void match(@ByVal Mat image, @ByVal Mat templ, @ByVal Mat result);
    public native void match(@ByVal UMat image, @ByVal UMat templ, @ByVal UMat result, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void match(@ByVal UMat image, @ByVal UMat templ, @ByVal UMat result);
    public native void match(@ByVal GpuMat image, @ByVal GpuMat templ, @ByVal GpuMat result, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void match(@ByVal GpuMat image, @ByVal GpuMat templ, @ByVal GpuMat result);
}

/** \brief Creates implementation for cuda::TemplateMatching .
<p>
@param srcType Input source type. CV_32F and CV_8U depth images (1..4 channels) are supported
for now.
@param method Specifies the way to compare the template with the image.
@param user_block_size You can use field user_block_size to set specific block size. If you
leave its default value Size(0,0) then automatic estimation of block size will be used (which is
optimized for speed). By varying user_block_size you can reduce memory requirements at the cost
of speed.
<p>
The following methods are supported for the CV_8U depth images for now:
<p>
-   CV_TM_SQDIFF
-   CV_TM_SQDIFF_NORMED
-   CV_TM_CCORR
-   CV_TM_CCORR_NORMED
-   CV_TM_CCOEFF
-   CV_TM_CCOEFF_NORMED
<p>
The following methods are supported for the CV_32F images for now:
<p>
-   CV_TM_SQDIFF
-   CV_TM_CCORR
<p>
\sa matchTemplate
 */
@Namespace("cv::cuda") public static native @Ptr TemplateMatching createTemplateMatching(int srcType, int method, @ByVal(nullValue = "cv::Size()") Size user_block_size);
@Namespace("cv::cuda") public static native @Ptr TemplateMatching createTemplateMatching(int srcType, int method);

////////////////////////// Bilateral Filter ///////////////////////////

/** \brief Performs bilateral filtering of passed image
<p>
@param src Source image. Supports only (channels != 2 && depth() != CV_8S && depth() != CV_32S
&& depth() != CV_64F).
@param dst Destination imagwe.
@param kernel_size Kernel window size.
@param sigma_color Filter sigma in the color space.
@param sigma_spatial Filter sigma in the coordinate space.
@param borderMode Border type. See borderInterpolate for details. BORDER_REFLECT101 ,
BORDER_REPLICATE , BORDER_CONSTANT , BORDER_REFLECT and BORDER_WRAP are supported for now.
@param stream Stream for the asynchronous version.
<p>
\sa bilateralFilter
 */
@Namespace("cv::cuda") public static native void bilateralFilter(@ByVal Mat src, @ByVal Mat dst, int kernel_size, float sigma_color, float sigma_spatial,
                                int borderMode/*=cv::BORDER_DEFAULT*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bilateralFilter(@ByVal Mat src, @ByVal Mat dst, int kernel_size, float sigma_color, float sigma_spatial);
@Namespace("cv::cuda") public static native void bilateralFilter(@ByVal UMat src, @ByVal UMat dst, int kernel_size, float sigma_color, float sigma_spatial,
                                int borderMode/*=cv::BORDER_DEFAULT*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bilateralFilter(@ByVal UMat src, @ByVal UMat dst, int kernel_size, float sigma_color, float sigma_spatial);
@Namespace("cv::cuda") public static native void bilateralFilter(@ByVal GpuMat src, @ByVal GpuMat dst, int kernel_size, float sigma_color, float sigma_spatial,
                                int borderMode/*=cv::BORDER_DEFAULT*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bilateralFilter(@ByVal GpuMat src, @ByVal GpuMat dst, int kernel_size, float sigma_color, float sigma_spatial);

///////////////////////////// Blending ////////////////////////////////

/** \brief Performs linear blending of two images.
<p>
@param img1 First image. Supports only CV_8U and CV_32F depth.
@param img2 Second image. Must have the same size and the same type as img1 .
@param weights1 Weights for first image. Must have tha same size as img1 . Supports only CV_32F
type.
@param weights2 Weights for second image. Must have tha same size as img2 . Supports only CV_32F
type.
@param result Destination image.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void blendLinear(@ByVal Mat img1, @ByVal Mat img2, @ByVal Mat weights1, @ByVal Mat weights2,
                            @ByVal Mat result, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void blendLinear(@ByVal Mat img1, @ByVal Mat img2, @ByVal Mat weights1, @ByVal Mat weights2,
                            @ByVal Mat result);
@Namespace("cv::cuda") public static native void blendLinear(@ByVal UMat img1, @ByVal UMat img2, @ByVal UMat weights1, @ByVal UMat weights2,
                            @ByVal UMat result, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void blendLinear(@ByVal UMat img1, @ByVal UMat img2, @ByVal UMat weights1, @ByVal UMat weights2,
                            @ByVal UMat result);
@Namespace("cv::cuda") public static native void blendLinear(@ByVal GpuMat img1, @ByVal GpuMat img2, @ByVal GpuMat weights1, @ByVal GpuMat weights2,
                            @ByVal GpuMat result, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void blendLinear(@ByVal GpuMat img1, @ByVal GpuMat img2, @ByVal GpuMat weights1, @ByVal GpuMat weights2,
                            @ByVal GpuMat result);

/** \} */

 // namespace cv { namespace cuda {

// #endif /* OPENCV_CUDAIMGPROC_HPP */


}
