/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.helper;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.bytedeco.javacpp.tensorflow;

public class tensorflow
extends org.bytedeco.javacpp.presets.tensorflow {

    public static abstract class AbstractSession
    extends Pointer {
        tensorflow.SessionOptions options;

        public AbstractSession(Pointer p) {
            super(p);
        }

        public AbstractSession(tensorflow.SessionOptions options) {
            this.options = options;
            if (org.bytedeco.javacpp.tensorflow.NewSession(options, (tensorflow.Session)this).ok() && !this.isNull()) {
                this.deallocator(new DeleteDeallocator((tensorflow.Session)this));
            }
        }

        @Namespace
        public static native void delete(tensorflow.Session var0);

        static {
            Loader.load();
        }

        protected static class DeleteDeallocator
        extends tensorflow.Session
        implements Pointer.Deallocator {
            DeleteDeallocator(tensorflow.Session p) {
                super(p);
            }

            public void deallocate() {
                tensorflow.Session.delete(this);
                this.setNull();
            }
        }
    }

    public static abstract class AbstractTensor
    extends Pointer
    implements Indexable {
        public AbstractTensor(Pointer p) {
            super(p);
        }

        public static tensorflow.Tensor create(float[] data, tensorflow.TensorShape shape) {
            tensorflow.Tensor t = new tensorflow.Tensor(1, shape);
            FloatBuffer b = (FloatBuffer)t.createBuffer();
            b.put(data);
            return t;
        }

        public static tensorflow.Tensor create(double[] data, tensorflow.TensorShape shape) {
            tensorflow.Tensor t = new tensorflow.Tensor(2, shape);
            DoubleBuffer b = (DoubleBuffer)t.createBuffer();
            b.put(data);
            return t;
        }

        public static tensorflow.Tensor create(int[] data, tensorflow.TensorShape shape) {
            tensorflow.Tensor t = new tensorflow.Tensor(3, shape);
            IntBuffer b = (IntBuffer)t.createBuffer();
            b.put(data);
            return t;
        }

        public static tensorflow.Tensor create(short[] data, tensorflow.TensorShape shape) {
            tensorflow.Tensor t = new tensorflow.Tensor(5, shape);
            ShortBuffer b = (ShortBuffer)t.createBuffer();
            b.put(data);
            return t;
        }

        public static tensorflow.Tensor create(byte[] data, tensorflow.TensorShape shape) {
            tensorflow.Tensor t = new tensorflow.Tensor(6, shape);
            ByteBuffer b = (ByteBuffer)t.createBuffer();
            b.put(data);
            return t;
        }

        public static tensorflow.Tensor create(long[] data, tensorflow.TensorShape shape) {
            tensorflow.Tensor t = new tensorflow.Tensor(9, shape);
            LongBuffer b = (LongBuffer)t.createBuffer();
            b.put(data);
            return t;
        }

        public static tensorflow.Tensor create(String[] data, tensorflow.TensorShape shape) {
            tensorflow.Tensor t = new tensorflow.Tensor(7, shape);
            StringArray a = t.createStringArray();
            int i = 0;
            while ((long)i < a.capacity()) {
                a.position(i).put(data[i]);
                ++i;
            }
            return t;
        }

        public abstract int dtype();

        public abstract int dims();

        public abstract long dim_size(int var1);

        public abstract long NumElements();

        public abstract long TotalBytes();

        public abstract BytePointer tensor_data();

        public <B extends Buffer> B createBuffer() {
            return this.createBuffer(0);
        }

        public <B extends Buffer> B createBuffer(int index) {
            BytePointer ptr = this.tensor_data();
            int size = (int)this.TotalBytes();
            switch (this.dtype()) {
                case 1: 
                case 8: {
                    return (B)new FloatPointer((Pointer)ptr).position((long)index).capacity((long)(size / 4)).asBuffer();
                }
                case 2: {
                    return (B)new DoublePointer((Pointer)ptr).position((long)index).capacity((long)(size / 8)).asBuffer();
                }
                case 3: 
                case 13: {
                    return (B)new IntPointer((Pointer)ptr).position((long)index).capacity((long)(size / 4)).asBuffer();
                }
                case 4: 
                case 6: 
                case 10: 
                case 11: 
                case 12: {
                    return (B)ptr.position((long)index).capacity((long)size).asBuffer();
                }
                case 5: 
                case 14: {
                    return (B)new ShortPointer((Pointer)ptr).position((long)index).capacity((long)(size / 2)).asBuffer();
                }
                case 9: {
                    return (B)new LongPointer((Pointer)ptr).position((long)index).capacity((long)(size / 8)).asBuffer();
                }
            }
            assert (false);
            return null;
        }

        public <I extends Indexer> I createIndexer() {
            return this.createIndexer(true);
        }

        public <I extends Indexer> I createIndexer(boolean direct) {
            BytePointer ptr = this.tensor_data();
            int size = (int)this.TotalBytes();
            boolean complex = this.dtype() == 8;
            int dims = complex ? this.dims() + 1 : this.dims();
            long[] sizes = new long[dims];
            long[] strides = new long[dims];
            sizes[dims - 1] = complex ? 2L : (long)((int)this.dim_size(dims - 1));
            strides[dims - 1] = 1L;
            for (int i = dims - 2; i >= 0; --i) {
                sizes[i] = (int)this.dim_size(i);
                strides[i] = sizes[i + 1] * strides[i + 1];
            }
            switch (this.dtype()) {
                case 1: 
                case 8: {
                    return (I)FloatIndexer.create((FloatPointer)new FloatPointer((Pointer)ptr).capacity((long)(size / 4)), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
                }
                case 2: {
                    return (I)DoubleIndexer.create((DoublePointer)new DoublePointer((Pointer)ptr).capacity((long)(size / 8)), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
                }
                case 3: 
                case 13: {
                    return (I)IntIndexer.create((IntPointer)new IntPointer((Pointer)ptr).capacity((long)(size / 4)), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
                }
                case 4: 
                case 10: 
                case 12: {
                    return (I)UByteIndexer.create((BytePointer)ptr.capacity((long)size), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
                }
                case 6: 
                case 11: {
                    return (I)ByteIndexer.create((BytePointer)ptr.capacity((long)size), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
                }
                case 14: {
                    return (I)UShortIndexer.create((ShortPointer)new ShortPointer((Pointer)ptr).capacity((long)(size / 2)), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
                }
                case 5: {
                    return (I)ShortIndexer.create((ShortPointer)new ShortPointer((Pointer)ptr).capacity((long)(size / 2)), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
                }
                case 9: {
                    return (I)LongIndexer.create((LongPointer)new LongPointer((Pointer)ptr).capacity((long)(size / 8)), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
                }
            }
            assert (false);
            return null;
        }

        public StringArray createStringArray() {
            if (this.dtype() != 7) {
                return null;
            }
            long size = this.NumElements();
            return (StringArray)new StringArray((Pointer)this.tensor_data()).capacity(size).limit(size);
        }

        static {
            Loader.load();
        }
    }

    @Name(value={"std::string"})
    public static class StringArray
    extends Pointer {
        public StringArray(Pointer p) {
            super(p);
        }

        public StringArray() {
            this.allocate();
        }

        private native void allocate();

        public StringArray(StringArray p) {
            this.allocate(p);
        }

        private native void allocate(@ByRef StringArray var1);

        public StringArray(BytePointer s, long count) {
            this.allocate(s, count);
        }

        private native void allocate(@Cast(value={"char*"}) BytePointer var1, long var2);

        public StringArray(String s) {
            this.allocate(s);
        }

        private native void allocate(String var1);

        @Name(value={"operator="})
        @ByRef
        public native StringArray put(@ByRef StringArray var1);

        @Name(value={"operator="})
        @ByRef
        public native StringArray put(String var1);

        public StringArray position(long position) {
            return (StringArray)super.position(position);
        }

        @Cast(value={"size_t"})
        public native long size();

        public native void resize(@Cast(value={"size_t"}) long var1);

        @Index
        @Cast(value={"char"})
        public native int get(@Cast(value={"size_t"}) long var1);

        public native StringArray put(@Cast(value={"size_t"}) long var1, int var3);

        @Cast(value={"const char*"})
        public native BytePointer data();

        public String toString() {
            long length = this.size();
            byte[] bytes = new byte[length < Integer.MAX_VALUE ? (int)length : Integer.MAX_VALUE];
            this.data().get(bytes);
            return new String(bytes);
        }

        static {
            Loader.load();
        }
    }

    public static abstract class AbstractTF_Session
    extends Pointer {
        protected tensorflow.TF_Graph graph;
        protected tensorflow.TF_SessionOptions opts;
        protected tensorflow.TF_Status status;

        public AbstractTF_Session(Pointer p) {
            super(p);
        }

        public static tensorflow.TF_Session newSession(tensorflow.TF_Graph graph, tensorflow.TF_SessionOptions opts, tensorflow.TF_Status status) {
            tensorflow.TF_Session s = org.bytedeco.javacpp.tensorflow.TF_NewSession(graph, opts, status);
            if (s != null) {
                s.graph = graph;
                s.opts = opts;
                s.status = status;
                s.deallocator(new DeleteDeallocator(s));
            }
            return s;
        }

        public void delete() {
            this.deallocate();
        }

        protected static class DeleteDeallocator
        extends tensorflow.TF_Session
        implements Pointer.Deallocator {
            DeleteDeallocator(tensorflow.TF_Session s) {
                super(s);
            }

            public void deallocate() {
                org.bytedeco.javacpp.tensorflow.TF_DeleteSession(this, tensorflow.TF_Status.newStatus());
            }
        }
    }

    public static abstract class AbstractTF_ImportGraphDefOptions
    extends Pointer {
        public AbstractTF_ImportGraphDefOptions(Pointer p) {
            super(p);
        }

        public static tensorflow.TF_ImportGraphDefOptions newImportGraphDefOptions() {
            tensorflow.TF_ImportGraphDefOptions o = org.bytedeco.javacpp.tensorflow.TF_NewImportGraphDefOptions();
            if (o != null) {
                o.deallocator(new DeleteDeallocator(o));
            }
            return o;
        }

        public void delete() {
            this.deallocate();
        }

        protected static class DeleteDeallocator
        extends tensorflow.TF_ImportGraphDefOptions
        implements Pointer.Deallocator {
            DeleteDeallocator(tensorflow.TF_ImportGraphDefOptions s) {
                super(s);
            }

            public void deallocate() {
                org.bytedeco.javacpp.tensorflow.TF_DeleteImportGraphDefOptions(this);
            }
        }
    }

    public static abstract class AbstractTF_Graph
    extends Pointer {
        public AbstractTF_Graph(Pointer p) {
            super(p);
        }

        public static tensorflow.TF_Graph newGraph() {
            tensorflow.TF_Graph g = org.bytedeco.javacpp.tensorflow.TF_NewGraph();
            if (g != null) {
                g.deallocator(new DeleteDeallocator(g));
            }
            return g;
        }

        public void delete() {
            this.deallocate();
        }

        protected static class DeleteDeallocator
        extends tensorflow.TF_Graph
        implements Pointer.Deallocator {
            DeleteDeallocator(tensorflow.TF_Graph s) {
                super(s);
            }

            public void deallocate() {
                org.bytedeco.javacpp.tensorflow.TF_DeleteGraph(this);
            }
        }
    }

    public static abstract class AbstractTF_SessionOptions
    extends Pointer {
        public AbstractTF_SessionOptions(Pointer p) {
            super(p);
        }

        public static tensorflow.TF_SessionOptions newSessionOptions() {
            tensorflow.TF_SessionOptions o = org.bytedeco.javacpp.tensorflow.TF_NewSessionOptions();
            if (o != null) {
                o.deallocator(new DeleteDeallocator(o));
            }
            return o;
        }

        public void delete() {
            this.deallocate();
        }

        protected static class DeleteDeallocator
        extends tensorflow.TF_SessionOptions
        implements Pointer.Deallocator {
            DeleteDeallocator(tensorflow.TF_SessionOptions s) {
                super(s);
            }

            public void deallocate() {
                org.bytedeco.javacpp.tensorflow.TF_DeleteSessionOptions(this);
            }
        }
    }

    public static abstract class AbstractTF_Tensor
    extends Pointer {
        protected static tensorflow.Deallocator_Pointer_long_Pointer dummyDeallocator = new tensorflow.Deallocator_Pointer_long_Pointer(){

            @Override
            public void call(Pointer data, long len, Pointer arg) {
            }
        };
        protected Pointer pointer;

        public AbstractTF_Tensor(Pointer p) {
            super(p);
        }

        public static tensorflow.TF_Tensor newTensor(int dtype, long[] dims, Pointer data) {
            tensorflow.TF_Tensor t = org.bytedeco.javacpp.tensorflow.TF_NewTensor(dtype, dims, dims.length, data, data.limit(), dummyDeallocator, null);
            if (t != null) {
                t.pointer = data;
                t.deallocator(new DeleteDeallocator(t));
            }
            return t;
        }

        public static tensorflow.TF_Tensor allocateTensor(int dtype, long[] dims, long length) {
            tensorflow.TF_Tensor t = org.bytedeco.javacpp.tensorflow.TF_AllocateTensor(dtype, dims, dims.length, length);
            if (t != null) {
                t.deallocator(new DeleteDeallocator(t));
            }
            return t;
        }

        public void delete() {
            this.deallocate();
        }

        protected static class DeleteDeallocator
        extends tensorflow.TF_Tensor
        implements Pointer.Deallocator {
            DeleteDeallocator(tensorflow.TF_Tensor s) {
                super(s);
            }

            public void deallocate() {
                org.bytedeco.javacpp.tensorflow.TF_DeleteTensor(this);
            }
        }
    }

    public static abstract class AbstractTF_Buffer
    extends Pointer {
        public AbstractTF_Buffer(Pointer p) {
            super(p);
        }

        public static tensorflow.TF_Buffer newBuffer() {
            tensorflow.TF_Buffer b = org.bytedeco.javacpp.tensorflow.TF_NewBuffer();
            if (b != null) {
                b.deallocator(new DeleteDeallocator(b));
            }
            return b;
        }

        public static tensorflow.TF_Buffer newBufferFromString(byte[] proto) {
            return AbstractTF_Buffer.newBufferFromString((Pointer)new BytePointer(proto));
        }

        public static tensorflow.TF_Buffer newBufferFromString(Pointer proto) {
            tensorflow.TF_Buffer b = org.bytedeco.javacpp.tensorflow.TF_NewBufferFromString(proto, proto.limit());
            if (b != null) {
                b.deallocator(new DeleteDeallocator(b));
            }
            return b;
        }

        public void delete() {
            this.deallocate();
        }

        protected static class DeleteDeallocator
        extends tensorflow.TF_Buffer
        implements Pointer.Deallocator {
            DeleteDeallocator(tensorflow.TF_Buffer s) {
                super(s);
            }

            public void deallocate() {
                org.bytedeco.javacpp.tensorflow.TF_DeleteBuffer(this);
            }
        }
    }

    public static abstract class AbstractTF_Status
    extends Pointer {
        public AbstractTF_Status(Pointer p) {
            super(p);
        }

        public static tensorflow.TF_Status newStatus() {
            tensorflow.TF_Status s = org.bytedeco.javacpp.tensorflow.TF_NewStatus();
            if (s != null) {
                s.deallocator(new DeleteDeallocator(s));
            }
            return s;
        }

        public void delete() {
            this.deallocate();
        }

        protected static class DeleteDeallocator
        extends tensorflow.TF_Status
        implements Pointer.Deallocator {
            DeleteDeallocator(tensorflow.TF_Status s) {
                super(s);
            }

            public void deallocate() {
                org.bytedeco.javacpp.tensorflow.TF_DeleteStatus(this);
            }
        }
    }
}

