/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import org.tensorflow.lite.TensorFlowLite;

enum DataType {
    FLOAT32(1),
    INT32(2),
    UINT8(3),
    INT64(4),
    BYTEBUFFER(999);

    private final int value;
    private static final DataType[] values;

    private DataType(int value) {
        this.value = value;
    }

    int getNumber() {
        return this.value;
    }

    static DataType fromNumber(int c) {
        for (DataType t : values) {
            if (t.value != c) continue;
            return t;
        }
        throw new IllegalArgumentException("DataType error: DataType " + c + " is not recognized in Java (version " + TensorFlowLite.version() + ")");
    }

    int elemByteSize() {
        switch (this) {
            case FLOAT32: {
                return 4;
            }
            case INT32: {
                return 4;
            }
            case UINT8: {
                return 1;
            }
            case INT64: {
                return 8;
            }
            case BYTEBUFFER: {
                return 1;
            }
        }
        throw new IllegalArgumentException("DataType error: DataType " + (Object)((Object)this) + " is not supported yet");
    }

    String toStringName() {
        switch (this) {
            case FLOAT32: {
                return "float";
            }
            case INT32: {
                return "int";
            }
            case UINT8: {
                return "byte";
            }
            case INT64: {
                return "long";
            }
            case BYTEBUFFER: {
                return "ByteBuffer";
            }
        }
        throw new IllegalArgumentException("DataType error: DataType " + (Object)((Object)this) + " is not supported yet");
    }

    static {
        values = DataType.values();
    }
}

