/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.Tensor;
import org.tensorflow.lite.TensorFlowLite;

final class NativeInterpreterWrapper
implements AutoCloseable {
    private static final int ERROR_BUFFER_SIZE = 512;
    private long errorHandle;
    private long interpreterHandle;
    private long modelHandle;
    private int inputSize;
    private long inferenceDurationNanoseconds = -1L;
    private ByteBuffer modelByteBuffer;
    private Map<String, Integer> inputsIndexes;
    private Map<String, Integer> outputsIndexes;
    private boolean isMemoryAllocated = false;

    NativeInterpreterWrapper(String modelPath) {
        this(modelPath, -1);
    }

    NativeInterpreterWrapper(String modelPath, int numThreads) {
        this.errorHandle = NativeInterpreterWrapper.createErrorReporter(512);
        this.modelHandle = NativeInterpreterWrapper.createModel(modelPath, this.errorHandle);
        this.interpreterHandle = NativeInterpreterWrapper.createInterpreter(this.modelHandle, this.errorHandle, numThreads);
        this.isMemoryAllocated = true;
    }

    NativeInterpreterWrapper(ByteBuffer byteBuffer) {
        this(byteBuffer, -1);
    }

    NativeInterpreterWrapper(ByteBuffer buffer, int numThreads) {
        if (buffer == null || !(buffer instanceof MappedByteBuffer) && (!buffer.isDirect() || buffer.order() != ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Model ByteBuffer should be either a MappedByteBuffer of the model file, or a direct ByteBuffer using ByteOrder.nativeOrder() which contains bytes of model content.");
        }
        this.modelByteBuffer = buffer;
        this.errorHandle = NativeInterpreterWrapper.createErrorReporter(512);
        this.modelHandle = NativeInterpreterWrapper.createModelWithBuffer(this.modelByteBuffer, this.errorHandle);
        this.interpreterHandle = NativeInterpreterWrapper.createInterpreter(this.modelHandle, this.errorHandle, numThreads);
        this.isMemoryAllocated = true;
    }

    @Override
    public void close() {
        NativeInterpreterWrapper.delete(this.errorHandle, this.modelHandle, this.interpreterHandle);
        this.errorHandle = 0L;
        this.modelHandle = 0L;
        this.interpreterHandle = 0L;
        this.modelByteBuffer = null;
        this.inputsIndexes = null;
        this.outputsIndexes = null;
        this.isMemoryAllocated = false;
    }

    Tensor[] run(Object[] inputs) {
        if (inputs == null || inputs.length == 0) {
            throw new IllegalArgumentException("Input error: Inputs should not be null or empty.");
        }
        int[] dataTypes = new int[inputs.length];
        Object[] sizes = new Object[inputs.length];
        int[] numsOfBytes = new int[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            DataType dataType = NativeInterpreterWrapper.dataTypeOf(inputs[i]);
            dataTypes[i] = dataType.getNumber();
            if (dataType == DataType.BYTEBUFFER) {
                ByteBuffer buffer = (ByteBuffer)inputs[i];
                if (buffer == null || !buffer.isDirect() || buffer.order() != ByteOrder.nativeOrder()) {
                    throw new IllegalArgumentException("Input error: ByteBuffer should be a direct ByteBuffer that uses ByteOrder.nativeOrder().");
                }
                numsOfBytes[i] = buffer.limit();
                sizes[i] = NativeInterpreterWrapper.getInputDims(this.interpreterHandle, i, numsOfBytes[i]);
                continue;
            }
            if (NativeInterpreterWrapper.isNonEmptyArray(inputs[i])) {
                int[] dims = NativeInterpreterWrapper.shapeOf(inputs[i]);
                sizes[i] = dims;
                numsOfBytes[i] = dataType.elemByteSize() * NativeInterpreterWrapper.numElements(dims);
                continue;
            }
            throw new IllegalArgumentException(String.format("Input error: %d-th element of the %d inputs is not an array or a ByteBuffer.", i, inputs.length));
        }
        this.inferenceDurationNanoseconds = -1L;
        long[] outputsHandles = NativeInterpreterWrapper.run(this.interpreterHandle, this.errorHandle, sizes, dataTypes, numsOfBytes, inputs, this, this.isMemoryAllocated);
        if (outputsHandles == null || outputsHandles.length == 0) {
            throw new IllegalStateException("Internal error: Interpreter has no outputs.");
        }
        this.isMemoryAllocated = true;
        Tensor[] outputs = new Tensor[outputsHandles.length];
        for (int i = 0; i < outputsHandles.length; ++i) {
            outputs[i] = Tensor.fromHandle(outputsHandles[i]);
        }
        return outputs;
    }

    private static native long[] run(long var0, long var2, Object[] var4, int[] var5, int[] var6, Object[] var7, NativeInterpreterWrapper var8, boolean var9);

    void resizeInput(int idx, int[] dims) {
        if (NativeInterpreterWrapper.resizeInput(this.interpreterHandle, this.errorHandle, idx, dims)) {
            this.isMemoryAllocated = false;
        }
    }

    private static native boolean resizeInput(long var0, long var2, int var4, int[] var5);

    void setUseNNAPI(boolean useNNAPI) {
        NativeInterpreterWrapper.useNNAPI(this.interpreterHandle, useNNAPI);
    }

    void setNumThreads(int numThreads) {
        NativeInterpreterWrapper.numThreads(this.interpreterHandle, numThreads);
    }

    int getInputIndex(String name) {
        if (this.inputsIndexes == null) {
            String[] names = NativeInterpreterWrapper.getInputNames(this.interpreterHandle);
            this.inputsIndexes = new HashMap<String, Integer>();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    this.inputsIndexes.put(names[i], i);
                }
            }
        }
        if (this.inputsIndexes.containsKey(name)) {
            return this.inputsIndexes.get(name);
        }
        throw new IllegalArgumentException(String.format("Input error: '%s' is not a valid name for any input. Names of inputs and their indexes are %s", name, this.inputsIndexes.toString()));
    }

    int getOutputIndex(String name) {
        if (this.outputsIndexes == null) {
            String[] names = NativeInterpreterWrapper.getOutputNames(this.interpreterHandle);
            this.outputsIndexes = new HashMap<String, Integer>();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    this.outputsIndexes.put(names[i], i);
                }
            }
        }
        if (this.outputsIndexes.containsKey(name)) {
            return this.outputsIndexes.get(name);
        }
        throw new IllegalArgumentException(String.format("Input error: '%s' is not a valid name for any output. Names of outputs and their indexes are %s", name, this.outputsIndexes.toString()));
    }

    static int numElements(int[] shape) {
        if (shape == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < shape.length; ++i) {
            n *= shape[i];
        }
        return n;
    }

    static boolean isNonEmptyArray(Object o) {
        return o != null && o.getClass().isArray() && Array.getLength(o) != 0;
    }

    static DataType dataTypeOf(Object o) {
        if (o != null) {
            Class<?> c = o.getClass();
            while (c.isArray()) {
                c = c.getComponentType();
            }
            if (Float.TYPE.equals(c)) {
                return DataType.FLOAT32;
            }
            if (Integer.TYPE.equals(c)) {
                return DataType.INT32;
            }
            if (Byte.TYPE.equals(c)) {
                return DataType.UINT8;
            }
            if (Long.TYPE.equals(c)) {
                return DataType.INT64;
            }
            if (ByteBuffer.class.isInstance(o)) {
                return DataType.BYTEBUFFER;
            }
        }
        throw new IllegalArgumentException("DataType error: cannot resolve DataType of " + o.getClass().getName());
    }

    static int[] shapeOf(Object o) {
        int size = NativeInterpreterWrapper.numDimensions(o);
        int[] dimensions = new int[size];
        NativeInterpreterWrapper.fillShape(o, 0, dimensions);
        return dimensions;
    }

    static int numDimensions(Object o) {
        if (o == null || !o.getClass().isArray()) {
            return 0;
        }
        if (Array.getLength(o) == 0) {
            throw new IllegalArgumentException("Array lengths cannot be 0.");
        }
        return 1 + NativeInterpreterWrapper.numDimensions(Array.get(o, 0));
    }

    static void fillShape(Object o, int dim, int[] shape) {
        if (shape == null || dim == shape.length) {
            return;
        }
        int len = Array.getLength(o);
        if (shape[dim] == 0) {
            shape[dim] = len;
        } else if (shape[dim] != len) {
            throw new IllegalArgumentException(String.format("Mismatched lengths (%d and %d) in dimension %d", shape[dim], len, dim));
        }
        for (int i = 0; i < len; ++i) {
            NativeInterpreterWrapper.fillShape(Array.get(o, i), dim + 1, shape);
        }
    }

    Long getLastNativeInferenceDurationNanoseconds() {
        return this.inferenceDurationNanoseconds < 0L ? null : Long.valueOf(this.inferenceDurationNanoseconds);
    }

    int[] getInputDims(int index) {
        return NativeInterpreterWrapper.getInputDims(this.interpreterHandle, index, -1);
    }

    private static native int[] getInputDims(long var0, int var2, int var3);

    String getOutputDataType(int index) {
        int type = NativeInterpreterWrapper.getOutputDataType(this.interpreterHandle, index);
        return DataType.fromNumber(type).toStringName();
    }

    private static native int getOutputDataType(long var0, int var2);

    private static native String[] getInputNames(long var0);

    private static native String[] getOutputNames(long var0);

    private static native void useNNAPI(long var0, boolean var2);

    private static native void numThreads(long var0, int var2);

    private static native long createErrorReporter(int var0);

    private static native long createModel(String var0, long var1);

    private static native long createModelWithBuffer(ByteBuffer var0, long var1);

    private static native long createInterpreter(long var0, long var2, int var4);

    private static native void delete(long var0, long var2, long var4);

    static {
        TensorFlowLite.init();
    }
}

