/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.util.Arrays;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.NativeInterpreterWrapper;
import org.tensorflow.lite.TensorFlowLite;

final class Tensor {
    final long nativeHandle;
    final DataType dtype;
    final int[] shapeCopy;

    static Tensor fromHandle(long nativeHandle) {
        return new Tensor(nativeHandle);
    }

    <T> T copyTo(T dst) {
        if (NativeInterpreterWrapper.dataTypeOf(dst) != this.dtype) {
            throw new IllegalArgumentException(String.format("Output error: Cannot convert an TensorFlowLite tensor with type %s to a Java object of type %s (which is compatible with the TensorFlowLite type %s)", new Object[]{this.dtype, dst.getClass().getName(), NativeInterpreterWrapper.dataTypeOf(dst)}));
        }
        int[] dstShape = NativeInterpreterWrapper.shapeOf(dst);
        if (!Arrays.equals(dstShape, this.shapeCopy)) {
            throw new IllegalArgumentException(String.format("Output error: Shape of output target %s does not match with the shape of the Tensor %s.", Arrays.toString(dstShape), Arrays.toString(this.shapeCopy)));
        }
        Tensor.readMultiDimensionalArray(this.nativeHandle, dst);
        return dst;
    }

    private Tensor(long nativeHandle) {
        this.nativeHandle = nativeHandle;
        this.dtype = DataType.fromNumber(Tensor.dtype(nativeHandle));
        this.shapeCopy = Tensor.shape(nativeHandle);
    }

    private static native int dtype(long var0);

    private static native int[] shape(long var0);

    private static native void readMultiDimensionalArray(long var0, Object var2);

    static {
        TensorFlowLite.init();
    }
}

