/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public final class OperatorProcessor
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;
    private boolean hasRun = false;
    private static final String OP_PACKAGE = "org.tensorflow.op";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        if (annotations.size() == 0) {
            return false;
        }
        if (annotations.size() != 1) {
            throw new IllegalStateException("Unexpected - multiple annotations registered: " + annotations);
        }
        TypeElement annotation = annotations.iterator().next();
        Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith(annotation);
        if (annotated.size() == 0) {
            return true;
        }
        if (this.hasRun) {
            for (Element element : annotated) {
                this.error(element, "The Operator processor has already processed @Operator annotated sources\nand written out an Ops API. It cannot process additional @Operator sources.\nOne reason this can happen is if other annotation processors generate\nnew @Operator source files.", new Object[0]);
            }
            return true;
        }
        HashSet<TypeElement> opClasses = new HashSet<TypeElement>();
        if (!this.collectOpClasses(roundEnv, opClasses, annotation)) {
            return true;
        }
        if (opClasses.isEmpty()) {
            return true;
        }
        this.writeApi();
        this.hasRun = true;
        return true;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(String.format("%s.annotation.Operator", OP_PACKAGE));
    }

    private void writeApi() {
        try (PrintWriter writer = new PrintWriter(this.filer.createSourceFile(String.format("%s.Ops", OP_PACKAGE), new Element[0]).openWriter());){
            writer.println(String.format("package %s;", OP_PACKAGE));
            writer.println("public class Ops{}");
        }
        catch (IOException e) {
            this.error(null, "Unexpected failure generating API: %s", e.getMessage());
        }
    }

    private boolean collectOpClasses(RoundEnvironment roundEnv, Set<TypeElement> opClasses, TypeElement annotation) {
        boolean result = true;
        for (Element element : roundEnv.getElementsAnnotatedWith(annotation)) {
            if (!(element instanceof TypeElement)) {
                this.error(element, "@Operator can only be applied to classes, but this is a %s", element.getKind().toString());
                result = false;
                continue;
            }
            opClasses.add((TypeElement)element);
        }
        return result;
    }

    private void error(Element e, String message, Object ... args) {
        if (args != null && args.length > 0) {
            message = String.format(message, args);
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, message, e);
    }
}

