/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.util.ArrayList;
import java.util.LinkedList;
import org.bytedeco.javacpp.tools.Declarator;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.TemplateMap;
import org.bytedeco.javacpp.tools.Type;

class Context {
    String namespace = null;
    Type group = null;
    boolean inaccessible = false;
    Declarator variable = null;
    TemplateMap templateMap = null;
    LinkedList<String> usingList = null;

    Context() {
        this.usingList = new LinkedList();
    }

    Context(Context c) {
        this.namespace = c.namespace;
        this.group = c.group;
        this.inaccessible = c.inaccessible;
        this.variable = c.variable;
        this.templateMap = c.templateMap;
        this.usingList = c.usingList;
    }

    String[] qualify(String cppName) {
        String ns;
        if (cppName == null || cppName.length() == 0) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        String string = ns = this.namespace != null ? this.namespace : "";
        while (ns != null) {
            String name = ns.length() > 0 ? ns + "::" + cppName : cppName;
            TemplateMap map = this.templateMap;
            while (map != null) {
                if (name.equals(map.getName())) {
                    String args = "<";
                    String separator = "";
                    for (String s : map.values()) {
                        args = args + separator + s;
                        separator = ",";
                    }
                    names.add(name + args + (args.endsWith(">") ? " >" : ">"));
                    break;
                }
                map = map.parent;
            }
            names.add(name);
            ns = InfoMap.normalize(ns, false, true);
            int i = ns.lastIndexOf("::");
            ns = i >= 0 ? ns.substring(0, i) : (ns.length() > 0 ? "" : null);
        }
        for (String s : this.usingList) {
            String prefix = InfoMap.normalize(cppName, false, true);
            int i = s.lastIndexOf("::") + 2;
            ns = s.substring(0, i);
            String suffix = s.substring(i);
            if (suffix.length() != 0 && !prefix.equals(suffix)) continue;
            names.add(ns + cppName);
        }
        return names.toArray(new String[names.size()]);
    }

    String shorten(String javaName) {
        if (this.group != null) {
            int lastDot = 0;
            String s1 = javaName;
            String s2 = this.group.javaName + '.';
            for (int i = 0; i < s1.length() && i < s2.length() && s1.charAt(i) == s2.charAt(i); ++i) {
                if (s1.charAt(i) != '.') continue;
                lastDot = i;
            }
            if (lastDot > 0) {
                javaName = javaName.substring(lastDot + 1);
            }
        }
        return javaName;
    }
}

