/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.ByteIndexer;

public class ByteArrayIndexer
extends ByteIndexer {
    protected byte[] array;

    public ByteArrayIndexer(byte[] array, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public byte[] array() {
        return this.array;
    }

    @Override
    public byte get(int i) {
        return this.array[i];
    }

    @Override
    public ByteIndexer get(int i, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[i * this.strides[0] + n];
        }
        return this;
    }

    @Override
    public byte get(int i, int j) {
        return this.array[i * this.strides[0] + j];
    }

    @Override
    public ByteIndexer get(int i, int j, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[i * this.strides[0] + j * this.strides[1] + n];
        }
        return this;
    }

    @Override
    public byte get(int i, int j, int k) {
        return this.array[i * this.strides[0] + j * this.strides[1] + k];
    }

    @Override
    public byte get(int ... indices) {
        return this.array[this.index(indices)];
    }

    @Override
    public ByteIndexer get(int[] indices, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[this.index(indices) + n];
        }
        return this;
    }

    @Override
    public ByteIndexer put(int i, byte b) {
        this.array[i] = b;
        return this;
    }

    @Override
    public ByteIndexer put(int i, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + n] = b[offset + n];
        }
        return this;
    }

    @Override
    public ByteIndexer put(int i, int j, byte b) {
        this.array[i * this.strides[0] + j] = b;
        return this;
    }

    @Override
    public ByteIndexer put(int i, int j, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + j * this.strides[1] + n] = b[offset + n];
        }
        return this;
    }

    @Override
    public ByteIndexer put(int i, int j, int k, byte b) {
        this.array[i * this.strides[0] + j * this.strides[1] + k] = b;
        return this;
    }

    @Override
    public ByteIndexer put(int[] indices, byte b) {
        this.array[this.index((int[])indices)] = b;
        return this;
    }

    @Override
    public ByteIndexer put(int[] indices, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[this.index((int[])indices) + n] = b[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

