/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.UByteIndexer;

public class UByteArrayIndexer
extends UByteIndexer {
    protected byte[] array;

    public UByteArrayIndexer(byte[] array, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public byte[] array() {
        return this.array;
    }

    @Override
    public int get(int i) {
        return this.array[i] & 0xFF;
    }

    @Override
    public UByteIndexer get(int i, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[i * this.strides[0] + n] & 0xFF;
        }
        return this;
    }

    @Override
    public int get(int i, int j) {
        return this.array[i * this.strides[0] + j] & 0xFF;
    }

    @Override
    public UByteIndexer get(int i, int j, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[i * this.strides[0] + j * this.strides[1] + n] & 0xFF;
        }
        return this;
    }

    @Override
    public int get(int i, int j, int k) {
        return this.array[i * this.strides[0] + j * this.strides[1] + k] & 0xFF;
    }

    @Override
    public int get(int ... indices) {
        return this.array[this.index(indices)] & 0xFF;
    }

    @Override
    public UByteIndexer get(int[] indices, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[this.index(indices) + n] & 0xFF;
        }
        return this;
    }

    @Override
    public UByteIndexer put(int i, int b) {
        this.array[i] = (byte)b;
        return this;
    }

    @Override
    public UByteIndexer put(int i, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + n] = (byte)b[offset + n];
        }
        return this;
    }

    @Override
    public UByteIndexer put(int i, int j, int b) {
        this.array[i * this.strides[0] + j] = (byte)b;
        return this;
    }

    @Override
    public UByteIndexer put(int i, int j, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + j * this.strides[1] + n] = (byte)b[offset + n];
        }
        return this;
    }

    @Override
    public UByteIndexer put(int i, int j, int k, int b) {
        this.array[i * this.strides[0] + j * this.strides[1] + k] = (byte)b;
        return this;
    }

    @Override
    public UByteIndexer put(int[] indices, int b) {
        this.array[this.index((int[])indices)] = (byte)b;
        return this;
    }

    @Override
    public UByteIndexer put(int[] indices, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[this.index((int[])indices) + n] = (byte)b[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

