/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.tools.ClassScanner;
import org.bytedeco.javacpp.tools.Generator;
import org.bytedeco.javacpp.tools.Logger;
import org.bytedeco.javacpp.tools.Parser;
import org.bytedeco.javacpp.tools.ParserException;
import org.bytedeco.javacpp.tools.Piper;
import org.bytedeco.javacpp.tools.UserClassLoader;

public class Builder {
    final Logger logger;
    File outputDirectory = null;
    String outputName = null;
    String jarPrefix = null;
    boolean compile = true;
    boolean header = false;
    boolean copyLibs = false;
    Properties properties = null;
    ClassScanner classScanner = null;
    Map<String, String> environmentVariables = null;
    Collection<String> compilerOptions = null;

    File parse(String[] classPath, Class cls) throws IOException, ParserException {
        return new Parser(this.logger, this.properties).parse(this.outputDirectory, classPath, cls);
    }

    static void includeJavaPaths(ClassProperties properties, boolean header) {
        String macpath;
        if (properties.getProperty("platform", "").startsWith("android")) {
            return;
        }
        String platform = Loader.getPlatform();
        final String jvmlink = properties.getProperty("platform.link.prefix", "") + "jvm" + properties.getProperty("platform.link.suffix", "");
        final String jvmlib = properties.getProperty("platform.library.prefix", "") + "jvm" + properties.getProperty("platform.library.suffix", "");
        final String[] jnipath = new String[2];
        final String[] jvmpath = new String[2];
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (new File(dir, "jni.h").exists()) {
                    jnipath[0] = dir.getAbsolutePath();
                }
                if (new File(dir, "jni_md.h").exists()) {
                    jnipath[1] = dir.getAbsolutePath();
                }
                if (new File(dir, jvmlink).exists()) {
                    jvmpath[0] = dir.getAbsolutePath();
                }
                if (new File(dir, jvmlib).exists()) {
                    jvmpath[1] = dir.getAbsolutePath();
                }
                return new File(dir, name).isDirectory();
            }
        };
        File javaHome = new File(System.getProperty("java.home")).getParentFile();
        try {
            javaHome = javaHome.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LinkedList<File> dirs = new LinkedList<File>(Arrays.asList(javaHome.listFiles(filter)));
        while (!dirs.isEmpty()) {
            File d = dirs.pop();
            String dpath = d.getPath();
            for (File f : d.listFiles(filter)) {
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (dpath.startsWith(f.getPath())) continue;
                dirs.add(f);
            }
        }
        if (jnipath[0] != null && jnipath[0].equals(jnipath[1])) {
            jnipath[1] = null;
        } else if (jnipath[0] == null && new File(macpath = "/System/Library/Frameworks/JavaVM.framework/Headers/").isDirectory()) {
            jnipath[0] = macpath;
        }
        if (jvmpath[0] != null && jvmpath[0].equals(jvmpath[1])) {
            jvmpath[1] = null;
        }
        properties.addAll("platform.includepath", jnipath);
        if (platform.equals(properties.getProperty("platform", platform))) {
            if (header) {
                properties.get("platform.link").add(0, "jvm");
                properties.addAll("platform.linkpath", jvmpath);
            }
            if (platform.startsWith("macosx")) {
                properties.addAll("platform.framework", "JavaVM");
            }
        }
    }

    int compile(String sourceFilename, String outputFilename, ClassProperties properties) throws IOException, InterruptedException {
        String p2;
        LinkedList<String> command = new LinkedList<String>();
        Builder.includeJavaPaths(properties, this.header);
        String platform = Loader.getPlatform();
        String compilerPath = properties.getProperty("platform.compiler");
        command.add(compilerPath);
        String p = properties.getProperty("platform.sysroot.prefix", "");
        for (String s : properties.get("platform.sysroot")) {
            if (!new File(s).isDirectory()) continue;
            if (p.endsWith(" ")) {
                command.add(p.trim());
                command.add(s);
                continue;
            }
            command.add(p + s);
        }
        p = properties.getProperty("platform.includepath.prefix", "");
        for (String s : properties.get("platform.includepath")) {
            if (!new File(s).isDirectory()) continue;
            if (p.endsWith(" ")) {
                command.add(p.trim());
                command.add(s);
                continue;
            }
            command.add(p + s);
        }
        command.add(sourceFilename);
        LinkedList<String> allOptions = properties.get("platform.compiler.*");
        if (allOptions.isEmpty()) {
            allOptions.add("default");
        }
        for (String s : allOptions) {
            if (s == null || s.length() == 0) continue;
            p2 = "platform.compiler." + s;
            String options = properties.getProperty(p2);
            if (options != null && options.length() > 0) {
                command.addAll(Arrays.asList(options.split(" ")));
                continue;
            }
            if ("default".equals(s)) continue;
            this.logger.warn("Could not get the property named \"" + p2 + "\"");
        }
        command.addAll(this.compilerOptions);
        String output = properties.getProperty("platform.compiler.output");
        if (output != null && output.length() > 0) {
            command.addAll(Arrays.asList(output.split(" ")));
        }
        if (output == null || output.length() == 0 || output.endsWith(" ")) {
            command.add(outputFilename);
        } else {
            command.add((String)command.removeLast() + outputFilename);
        }
        String p3 = properties.getProperty("platform.linkpath.prefix", "");
        p2 = properties.getProperty("platform.linkpath.prefix2");
        for (String string : properties.get("platform.linkpath")) {
            if (!new File(string).isDirectory()) continue;
            if (p3.endsWith(" ")) {
                command.add(p3.trim());
                command.add(string);
            } else {
                command.add(p3 + string);
            }
            if (p2 == null) continue;
            if (p2.endsWith(" ")) {
                command.add(p2.trim());
                command.add(string);
                continue;
            }
            command.add(p2 + string);
        }
        String p4 = properties.getProperty("platform.link.prefix", "");
        Object x = properties.getProperty("platform.link.suffix", "");
        int i = command.size();
        for (String s : properties.get("platform.link")) {
            String[] libnameversion = s.split("@");
            s = libnameversion.length == 3 && libnameversion[1].length() == 0 ? libnameversion[0] + libnameversion[2] : libnameversion[0];
            if (p4.endsWith(" ") && ((String)x).startsWith(" ")) {
                command.add(i, p4.trim());
                command.add(i + 1, s);
                command.add(i + 2, ((String)x).trim());
                continue;
            }
            if (p4.endsWith(" ")) {
                command.add(i, p4.trim());
                command.add(i + 1, s + (String)x);
                continue;
            }
            if (((String)x).startsWith(" ")) {
                command.add(i, p4 + s);
                command.add(i + 1, ((String)x).trim());
                continue;
            }
            command.add(i, p4 + s + (String)x);
        }
        p4 = properties.getProperty("platform.frameworkpath.prefix", "");
        for (String s : properties.get("platform.frameworkpath")) {
            if (!new File(s).isDirectory()) continue;
            if (p4.endsWith(" ")) {
                command.add(p4.trim());
                command.add(s);
                continue;
            }
            command.add(p4 + s);
        }
        p4 = properties.getProperty("platform.framework.prefix", "");
        x = properties.getProperty("platform.framework.suffix", "");
        for (String string : properties.get("platform.framework")) {
            if (p4.endsWith(" ") && ((String)x).startsWith(" ")) {
                command.add(p4.trim());
                command.add(string);
                command.add(((String)x).trim());
                continue;
            }
            if (p4.endsWith(" ")) {
                command.add(p4.trim());
                command.add(string + (String)x);
                continue;
            }
            if (((String)x).startsWith(" ")) {
                command.add(p4 + string);
                command.add(((String)x).trim());
                continue;
            }
            command.add(p4 + string + (String)x);
        }
        String text = "";
        boolean windows = platform.startsWith("windows");
        for (String string : command) {
            boolean hasSpaces;
            boolean bl = hasSpaces = string.indexOf(" ") > 0;
            if (hasSpaces) {
                text = text + (windows ? "\"" : "'");
            }
            text = text + string;
            if (hasSpaces) {
                text = text + (windows ? "\"" : "'");
            }
            text = text + " ";
        }
        this.logger.info(text);
        ProcessBuilder pb = new ProcessBuilder(command);
        if (this.environmentVariables != null) {
            pb.environment().putAll(this.environmentVariables);
        }
        Process process = pb.start();
        new Piper(this.logger, process.getErrorStream(), System.err).start();
        new Piper(this.logger, process.getInputStream(), System.out).start();
        return process.waitFor();
    }

    File generateAndCompile(Class[] classes, String outputName) throws IOException, InterruptedException {
        File outputFile = null;
        File outputPath = this.outputDirectory;
        ClassProperties p = Loader.loadProperties(classes, this.properties, true);
        String platform = p.getProperty("platform");
        String sourcePrefix = new File(outputPath, outputName).getPath();
        String sourceSuffix = p.getProperty("platform.source.suffix", ".cpp");
        String libraryPath = p.getProperty("platform.library.path", "");
        String libraryName = p.getProperty("platform.library.prefix", "") + outputName + p.getProperty("platform.library.suffix", "");
        if (outputPath == null) {
            try {
                String resourceName = '/' + classes[classes.length - 1].getName().replace('.', '/') + ".class";
                String resourceURL = classes[classes.length - 1].getResource(resourceName).toString();
                File packageDir = new File(new URI(resourceURL.substring(0, resourceURL.lastIndexOf(47) + 1)));
                File targetDir = libraryPath.length() > 0 ? new File(new URI(resourceURL.substring(0, resourceURL.length() - resourceName.length() + 1))) : new File(packageDir, platform);
                outputPath = new File(targetDir, libraryPath);
                sourcePrefix = new File(packageDir, outputName).getPath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (!outputPath.exists()) {
            outputPath.mkdirs();
        }
        Generator generator = new Generator(this.logger, p);
        String sourceFilename = sourcePrefix + sourceSuffix;
        String headerFilename = this.header ? sourcePrefix + ".h" : null;
        String classPath = System.getProperty("java.class.path");
        for (String s : this.classScanner.getClassLoader().getPaths()) {
            classPath = classPath + File.pathSeparator + s;
        }
        this.logger.info("Generating " + sourceFilename);
        if (generator.generate(sourceFilename, headerFilename, classPath, classes)) {
            generator.close();
            if (this.compile) {
                String libraryFilename = outputPath.getPath() + File.separator + libraryName;
                this.logger.info("Compiling " + libraryFilename);
                int exitValue = this.compile(sourceFilename, libraryFilename, p);
                if (exitValue == 0) {
                    new File(sourceFilename).delete();
                    outputFile = new File(libraryFilename);
                } else {
                    System.exit(exitValue);
                }
            } else {
                outputFile = new File(sourceFilename);
            }
        } else {
            this.logger.info("Nothing generated for " + sourceFilename);
        }
        return outputFile;
    }

    void createJar(File jarFile, String[] classPath, File ... files) throws IOException {
        this.logger.info("Creating " + jarFile);
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(jarFile));
        for (File f : files) {
            int length;
            String name = f.getPath();
            if (classPath != null) {
                int i;
                String[] names = new String[classPath.length];
                for (i = 0; i < classPath.length; ++i) {
                    String path = new File(classPath[i]).getCanonicalPath();
                    if (!name.startsWith(path)) continue;
                    names[i] = name.substring(path.length() + 1);
                }
                for (i = 0; i < names.length; ++i) {
                    if (names[i] == null || names[i].length() >= name.length()) continue;
                    name = names[i];
                }
            }
            ZipEntry e = new ZipEntry(name.replace(File.separatorChar, '/'));
            e.setTime(f.lastModified());
            jos.putNextEntry(e);
            FileInputStream fis = new FileInputStream(f);
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) != -1) {
                jos.write(buffer, 0, length);
            }
            fis.close();
            jos.closeEntry();
        }
        jos.close();
    }

    public Builder() {
        this(new Logger());
    }

    public Builder(Logger logger) {
        this.logger = logger;
        System.setProperty("org.bytedeco.javacpp.loadlibraries", "false");
        this.properties = Loader.loadProperties();
        this.classScanner = new ClassScanner(logger, new LinkedList<Class>(), new UserClassLoader(Thread.currentThread().getContextClassLoader()));
        this.compilerOptions = new LinkedList<String>();
    }

    public Builder classPaths(String classPaths) {
        this.classPaths(classPaths == null ? null : classPaths.split(File.pathSeparator));
        return this;
    }

    public Builder classPaths(String ... classPaths) {
        this.classScanner.getClassLoader().addPaths(classPaths);
        return this;
    }

    public Builder outputDirectory(String outputDirectory) {
        this.outputDirectory(outputDirectory == null ? null : new File(outputDirectory));
        return this;
    }

    public Builder outputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public Builder compile(boolean compile) {
        this.compile = compile;
        return this;
    }

    public Builder header(boolean header) {
        this.header = header;
        return this;
    }

    public Builder copyLibs(boolean copyLibs) {
        this.copyLibs = copyLibs;
        return this;
    }

    public Builder outputName(String outputName) {
        this.outputName = outputName;
        return this;
    }

    public Builder jarPrefix(String jarPrefix) {
        this.jarPrefix = jarPrefix;
        return this;
    }

    public Builder properties(String platform) {
        if (platform != null) {
            this.properties = Loader.loadProperties(platform);
        }
        return this;
    }

    public Builder properties(Properties properties) {
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                this.property((String)e.getKey(), (String)e.getValue());
            }
        }
        return this;
    }

    public Builder propertyFile(String filename) throws IOException {
        this.propertyFile(filename == null ? null : new File(filename));
        return this;
    }

    public Builder propertyFile(File propertyFile) throws IOException {
        if (propertyFile == null) {
            return this;
        }
        FileInputStream fis = new FileInputStream(propertyFile);
        this.properties = new Properties();
        try {
            this.properties.load(new InputStreamReader(fis));
        }
        catch (NoSuchMethodError e) {
            this.properties.load(fis);
        }
        fis.close();
        return this;
    }

    public Builder property(String keyValue) {
        int equalIndex = keyValue.indexOf(61);
        if (equalIndex < 0) {
            equalIndex = keyValue.indexOf(58);
        }
        this.property(keyValue.substring(2, equalIndex), keyValue.substring(equalIndex + 1));
        return this;
    }

    public Builder property(String key, String value) {
        if (key.length() > 0 && value.length() > 0) {
            this.properties.put(key, value);
        }
        return this;
    }

    public Builder classesOrPackages(String ... classesOrPackages) throws IOException {
        if (classesOrPackages == null) {
            this.classScanner.addPackage(null, true);
        } else {
            for (String s : classesOrPackages) {
                this.classScanner.addClassOrPackage(s);
            }
        }
        return this;
    }

    public Builder environmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public Builder compilerOptions(String ... options) {
        if (options != null) {
            this.compilerOptions.addAll(Arrays.asList(options));
        }
        return this;
    }

    public File[] build() throws IOException, InterruptedException, ParserException {
        File f;
        if (this.classScanner.getClasses().isEmpty()) {
            return null;
        }
        LinkedList<File> outputFiles = new LinkedList<File>();
        LinkedHashMap<String, LinkedList<Class>> map = new LinkedHashMap<String, LinkedList<Class>>();
        for (Class c : this.classScanner.getClasses()) {
            if (Loader.getEnclosingClass(c) != c) continue;
            ClassProperties p = Loader.loadProperties(c, this.properties, false);
            String target = p.getProperty("target");
            if (target != null && !c.getName().equals(target)) {
                f = this.parse(this.classScanner.getClassLoader().getPaths(), c);
                if (f == null) continue;
                outputFiles.add(f);
                continue;
            }
            String libraryName = this.outputName != null ? this.outputName : p.getProperty("platform.library", "");
            if (libraryName.length() == 0) continue;
            LinkedList<Class> classList = (LinkedList<Class>)map.get(libraryName);
            if (classList == null) {
                classList = new LinkedList<Class>();
                map.put(libraryName, classList);
            }
            classList.addAll(p.getEffectiveClasses());
        }
        for (String libraryName : map.keySet()) {
            LinkedList classList = (LinkedList)map.get(libraryName);
            Class[] classArray = classList.toArray(new Class[classList.size()]);
            f = this.generateAndCompile(classArray, libraryName);
            if (f == null) continue;
            outputFiles.add(f);
            if (!this.copyLibs) continue;
            ClassProperties p = Loader.loadProperties(classArray, this.properties, false);
            LinkedList<String> preloads = new LinkedList<String>();
            preloads.addAll(p.get("platform.preload"));
            preloads.addAll(p.get("platform.link"));
            p = Loader.loadProperties(classArray, this.properties, true);
            File directory = f.getParentFile();
            for (String s : preloads) {
                int length;
                File fi;
                URL[] urls = Loader.findLibrary(null, p, s);
                try {
                    fi = new File(urls[0].toURI());
                }
                catch (Exception e) {
                    continue;
                }
                File fo = new File(directory, fi.getName());
                if (!fi.exists() || outputFiles.contains(fo)) continue;
                this.logger.info("Copying " + fi);
                FileInputStream fis = new FileInputStream(fi);
                FileOutputStream fos = new FileOutputStream(fo);
                byte[] buffer = new byte[1024];
                while ((length = fis.read(buffer)) != -1) {
                    fos.write(buffer, 0, length);
                }
                fos.close();
                fis.close();
                outputFiles.add(fo);
            }
        }
        File[] files = outputFiles.toArray(new File[outputFiles.size()]);
        if (this.jarPrefix != null && files.length > 0) {
            File jarFile = new File(this.jarPrefix + "-" + this.properties.get("platform") + ".jar");
            File d = jarFile.getParentFile();
            if (d != null && !d.exists()) {
                d.mkdir();
            }
            this.createJar(jarFile, this.outputDirectory == null ? this.classScanner.getClassLoader().getPaths() : null, files);
        }
        return files;
    }

    public static void printHelp() {
        String version = Builder.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "unknown";
        }
        System.out.println("JavaCPP version " + version + "\n" + "Copyright (C) 2011-2015 Samuel Audet <samuel.audet@gmail.com>\n" + "Project site: https://github.com/bytedeco/javacpp");
        System.out.println();
        System.out.println("Usage: java -jar javacpp.jar [options] [class or package (suffixed with .* or .**)]");
        System.out.println();
        System.out.println("where options include:");
        System.out.println();
        System.out.println("    -classpath <path>      Load user classes from path");
        System.out.println("    -d <directory>         Output all generated files to directory");
        System.out.println("    -o <name>              Output everything in a file named after given name");
        System.out.println("    -nocompile             Do not compile or delete the generated source files");
        System.out.println("    -header                Generate header file with declarations of callbacks functions");
        System.out.println("    -copylibs              Copy to output directory dependent libraries (link and preload)");
        System.out.println("    -jarprefix <prefix>    Also create a JAR file named \"<prefix>-<platform>.jar\"");
        System.out.println("    -properties <resource> Load all properties from resource");
        System.out.println("    -propertyfile <file>   Load all properties from file");
        System.out.println("    -D<property>=<value>   Set property to value");
        System.out.println("    -Xcompiler <option>    Pass option directly to compiler");
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        boolean addedClasses = false;
        Builder builder = new Builder();
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i]) || "--help".equals(args[i])) {
                Builder.printHelp();
                System.exit(0);
                continue;
            }
            if ("-classpath".equals(args[i]) || "-cp".equals(args[i]) || "-lib".equals(args[i])) {
                builder.classPaths(args[++i]);
                continue;
            }
            if ("-d".equals(args[i])) {
                builder.outputDirectory(args[++i]);
                continue;
            }
            if ("-o".equals(args[i])) {
                builder.outputName(args[++i]);
                continue;
            }
            if ("-cpp".equals(args[i]) || "-nocompile".equals(args[i])) {
                builder.compile(false);
                continue;
            }
            if ("-header".equals(args[i])) {
                builder.header(true);
                continue;
            }
            if ("-copylibs".equals(args[i])) {
                builder.copyLibs(true);
                continue;
            }
            if ("-jarprefix".equals(args[i])) {
                builder.jarPrefix(args[++i]);
                continue;
            }
            if ("-properties".equals(args[i])) {
                builder.properties(args[++i]);
                continue;
            }
            if ("-propertyfile".equals(args[i])) {
                builder.propertyFile(args[++i]);
                continue;
            }
            if (args[i].startsWith("-D")) {
                builder.property(args[i]);
                continue;
            }
            if ("-Xcompiler".equals(args[i])) {
                builder.compilerOptions(args[++i]);
                continue;
            }
            if (args[i].startsWith("-")) {
                builder.logger.error("Invalid option \"" + args[i] + "\"");
                Builder.printHelp();
                System.exit(1);
                continue;
            }
            builder.classesOrPackages(args[i]);
            addedClasses = true;
        }
        if (!addedClasses) {
            builder.classesOrPackages(null);
        }
        builder.build();
    }
}

