/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.tools.Logger;

public class Loader {
    private static final Logger logger = Logger.create(Loader.class);
    private static final String PLATFORM;
    private static java.util.Properties platformProperties;
    static File cacheDir;
    static File tempDir;
    static Map<String, String> loadedLibraries;
    static WeakHashMap<Class<? extends Pointer>, HashMap<String, Integer>> memberOffsets;

    public static String getPlatform() {
        return System.getProperty("org.bytedeco.javacpp.platform", PLATFORM);
    }

    public static java.util.Properties loadProperties() {
        String name = Loader.getPlatform();
        if (platformProperties != null && name.equals(platformProperties.getProperty("platform"))) {
            return platformProperties;
        }
        platformProperties = Loader.loadProperties(name, null);
        return platformProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static java.util.Properties loadProperties(String name, String defaults) {
        java.util.Properties p;
        block30: {
            if (defaults == null) {
                defaults = "generic";
            }
            p = new java.util.Properties();
            p.put("platform", name);
            p.put("platform.path.separator", File.pathSeparator);
            String s = System.mapLibraryName("/");
            int i = s.indexOf(47);
            p.put("platform.library.prefix", s.substring(0, i));
            p.put("platform.library.suffix", s.substring(i + 1));
            name = "properties/" + name + ".properties";
            InputStream is = Loader.class.getResourceAsStream(name);
            try {
                try {
                    p.load(new InputStreamReader(is));
                }
                catch (NoSuchMethodError e) {
                    p.load(is);
                }
            }
            catch (Exception e) {
                name = "properties/" + defaults + ".properties";
                InputStream is2 = Loader.class.getResourceAsStream(name);
                try {
                    p.load(new InputStreamReader(is2));
                }
                catch (NoSuchMethodError e2) {
                    p.load(is2);
                }
                try {
                    if (is2 != null) {
                        is2.close();
                    }
                    break block30;
                }
                catch (IOException ex) {
                    logger.error("Unable to close resource : " + ex.getMessage());
                }
                break block30;
                catch (Exception ex) {
                    try {
                        if (is2 != null) {
                            is2.close();
                        }
                        break block30;
                    }
                    catch (IOException ex2) {
                        logger.error("Unable to close resource : " + ex2.getMessage());
                    }
                    break block30;
                    catch (Throwable throwable) {
                        try {
                            if (is2 != null) {
                                is2.close();
                            }
                        }
                        catch (IOException ex3) {
                            logger.error("Unable to close resource : " + ex3.getMessage());
                        }
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    logger.error("Unable to close resource : " + ex.getMessage());
                }
            }
        }
        return p;
    }

    public static Class getEnclosingClass(Class cls) {
        Platform p;
        Class<?> c = cls;
        while (c.getDeclaringClass() != null && !c.isAnnotationPresent(Properties.class) && (!c.isAnnotationPresent(Platform.class) || (p = c.getAnnotation(Platform.class)).pragma().length <= 0 && p.define().length <= 0 && p.include().length <= 0 && p.cinclude().length <= 0 && p.includepath().length <= 0 && p.compiler().length <= 0 && p.linkpath().length <= 0 && p.link().length <= 0 && p.frameworkpath().length <= 0 && p.framework().length <= 0 && p.preloadpath().length <= 0 && p.preload().length <= 0 && p.library().length() <= 0)) {
            c = c.getDeclaringClass();
        }
        return c;
    }

    public static ClassProperties loadProperties(Class[] cls, java.util.Properties properties, boolean inherit) {
        ClassProperties cp = new ClassProperties(properties);
        for (Class c : cls) {
            cp.load(c, inherit);
        }
        return cp;
    }

    public static ClassProperties loadProperties(Class cls, java.util.Properties properties, boolean inherit) {
        ClassProperties cp = new ClassProperties(properties);
        cp.load(cls, inherit);
        return cp;
    }

    public static Class getCallerClass(int i) {
        Object classContext = null;
        try {
            new SecurityManager(){

                public Class[] getClassContext() {
                    return super.getClassContext();
                }
            }.getClassContext();
        }
        catch (NoSuchMethodError e) {
            logger.error("No definition of this method : " + e.getMessage());
        }
        if (classContext != null) {
            for (int j = 0; j < (classContext).length; ++j) {
                if (classContext[j] != Loader.class) continue;
                return classContext[i + j];
            }
        } else {
            try {
                StackTraceElement[] classNames = Thread.currentThread().getStackTrace();
                for (int j = 0; j < classNames.length; ++j) {
                    if (Class.forName(classNames[j].getClassName()) != Loader.class) continue;
                    return Class.forName(classNames[i + j].getClassName());
                }
            }
            catch (ClassNotFoundException e) {
                logger.error("No definition for the class found : " + e.getMessage());
            }
        }
        return null;
    }

    public static File cacheResource(String name) throws IOException {
        Class cls = Loader.getCallerClass(2);
        return Loader.cacheResource(cls, name);
    }

    public static File cacheResource(Class cls, String name) throws IOException {
        return Loader.cacheResource(cls.getResource(name));
    }

    public static File[] cacheResources(String name) throws IOException {
        Class cls = Loader.getCallerClass(2);
        return Loader.cacheResources(cls, name);
    }

    public static File[] cacheResources(Class cls, String name) throws IOException {
        URL[] urls = Loader.findResources(cls, name);
        File[] files = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            files[i] = Loader.cacheResource(urls[i]);
        }
        return files;
    }

    public static File cacheResource(URL resourceURL) throws IOException {
        return Loader.cacheResource(resourceURL, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File cacheResource(URL resourceURL, String target) throws IOException {
        long timestamp;
        long size;
        File urlFile = new File(resourceURL.getPath());
        String name = urlFile.getName();
        File cacheSubdir = Loader.getCacheDir().getCanonicalFile();
        URLConnection urlConnection = resourceURL.openConnection();
        if (urlConnection instanceof JarURLConnection) {
            JarFile jarFile = ((JarURLConnection)urlConnection).getJarFile();
            JarEntry jarEntry = ((JarURLConnection)urlConnection).getJarEntry();
            File jarFileFile = new File(jarFile.getName());
            File jarEntryFile = new File(jarEntry.getName());
            size = jarEntry.getSize();
            timestamp = jarEntry.getTime();
            cacheSubdir = new File(cacheSubdir, jarFileFile.getName() + File.separator + jarEntryFile.getParent());
        } else {
            size = urlFile.length();
            timestamp = urlFile.lastModified();
            cacheSubdir = new File(cacheSubdir, name);
        }
        if (resourceURL.getRef() != null) {
            name = resourceURL.getRef();
        }
        File file = new File(cacheSubdir, name);
        if (target != null && target.length() > 0) {
            Path path = file.toPath();
            Path targetPath = Paths.get(target, new String[0]);
            try {
                if (file.exists() && Files.isSymbolicLink(path) && Files.readSymbolicLink(path).equals(targetPath) || !targetPath.isAbsolute() || targetPath.equals(path)) return file;
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating symbolic link " + path);
                }
                file.delete();
                Files.createSymbolicLink(path, targetPath, new FileAttribute[0]);
                return file;
            }
            catch (IOException | UnsupportedOperationException e) {
                if (!logger.isDebugEnabled()) return null;
                logger.debug("Failed to create symbolic link " + path + ": " + e);
                return null;
            }
        } else if (!file.exists() || file.length() != size || file.lastModified() != timestamp || !cacheSubdir.equals(file.getCanonicalFile().getParentFile())) {
            if (logger.isDebugEnabled()) {
                logger.debug("Extracting " + resourceURL);
            }
            file.delete();
            Loader.extractResource(resourceURL, file, null, null);
            file.setLastModified(timestamp);
            return file;
        } else {
            while (System.currentTimeMillis() - file.lastModified() >= 0L && System.currentTimeMillis() - file.lastModified() < 1000L) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return file;
    }

    public static File extractResource(String name, File directory, String prefix, String suffix) throws IOException {
        Class cls = Loader.getCallerClass(2);
        return Loader.extractResource(cls, name, directory, prefix, suffix);
    }

    public static File extractResource(Class cls, String name, File directory, String prefix, String suffix) throws IOException {
        return Loader.extractResource(cls.getResource(name), directory, prefix, suffix);
    }

    public static File[] extractResources(String name, File directory, String prefix, String suffix) throws IOException {
        Class cls = Loader.getCallerClass(2);
        return Loader.extractResources(cls, name, directory, prefix, suffix);
    }

    public static File[] extractResources(Class cls, String name, File directory, String prefix, String suffix) throws IOException {
        URL[] urls = Loader.findResources(cls, name);
        File[] files = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            files[i] = Loader.extractResource(urls[i], directory, prefix, suffix);
        }
        return files;
    }

    public static File extractResource(URL resourceURL, File directoryOrFile, String prefix, String suffix) throws IOException {
        URLConnection urlConnection;
        URLConnection uRLConnection = urlConnection = resourceURL != null ? resourceURL.openConnection() : null;
        if (urlConnection instanceof JarURLConnection) {
            JarFile jarFile = ((JarURLConnection)urlConnection).getJarFile();
            JarEntry jarEntry = ((JarURLConnection)urlConnection).getJarEntry();
            String jarFileName = jarFile.getName();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.endsWith("/")) {
                jarEntryName = jarEntryName + "/";
            }
            if (jarEntry.isDirectory() || jarFile.getJarEntry(jarEntryName) != null) {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith(jarEntryName)) continue;
                    File file = new File(directoryOrFile, entryName.substring(jarEntryName.length()));
                    if (entry.isDirectory()) {
                        file.mkdirs();
                    } else {
                        String s = resourceURL.toString();
                        URL u = new URL(s.substring(0, s.indexOf("!/") + 2) + entryName);
                        file = Loader.extractResource(u, file, prefix, suffix);
                    }
                    file.setLastModified(entry.getTime());
                }
                return directoryOrFile;
            }
        }
        InputStream is = urlConnection != null ? urlConnection.getInputStream() : null;
        OutputStream os = null;
        if (is == null) {
            return null;
        }
        File file = null;
        boolean fileExisted = false;
        try {
            int length;
            if (prefix == null && suffix == null) {
                File directory;
                if (directoryOrFile == null) {
                    directoryOrFile = new File(System.getProperty("java.io.tmpdir"));
                }
                if (directoryOrFile.isDirectory()) {
                    directory = directoryOrFile;
                    file = new File(directoryOrFile, new File(resourceURL.getPath()).getName());
                } else {
                    directory = directoryOrFile.getParentFile();
                    file = directoryOrFile;
                }
                if (directory != null) {
                    directory.mkdirs();
                }
                fileExisted = file.exists();
            } else {
                file = File.createTempFile(prefix, suffix, directoryOrFile);
            }
            os = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            if (file != null && !fileExisted) {
                file.delete();
            }
            throw e;
        }
        finally {
            is.close();
            if (os != null) {
                os.close();
            }
        }
        return file;
    }

    public static URL[] findResources(Class cls, String name) throws IOException {
        if (!name.startsWith("/")) {
            String s = cls.getName().replace('.', '/');
            int n = s.lastIndexOf(47);
            if (n >= 0) {
                name = s.substring(0, n + 1) + name;
            }
        } else {
            name = name.substring(1);
        }
        Enumeration<URL> urls = cls.getClassLoader().getResources(name);
        ArrayList<URL> array = new ArrayList<URL>();
        while (urls.hasMoreElements()) {
            array.add(urls.nextElement());
        }
        return array.toArray(new URL[array.size()]);
    }

    public static File getCacheDir() throws IOException {
        if (cacheDir == null) {
            String[] dirNames;
            for (String dirName : dirNames = new String[]{System.getProperty("org.bytedeco.javacpp.cachedir"), System.getProperty("user.home") + "/.javacpp/cache/", System.getProperty("java.io.tmpdir") + "/.javacpp-" + System.getProperty("user.name") + "/cache/"}) {
                File f;
                if (dirName == null || !(f = new File(dirName)).exists() && !f.mkdirs()) continue;
                cacheDir = f;
                break;
            }
        }
        if (cacheDir == null) {
            throw new IOException("Could not create the cache: Set the \"org.bytedeco.javacpp.cachedir\" system property.");
        }
        return cacheDir;
    }

    public static File getTempDir() {
        if (tempDir == null) {
            File tmpdir = new File(System.getProperty("java.io.tmpdir"));
            for (int i = 0; i < 1000; ++i) {
                File f = new File(tmpdir, "javacpp" + System.nanoTime());
                if (!f.mkdir()) continue;
                tempDir = f;
                tempDir.deleteOnExit();
                break;
            }
        }
        return tempDir;
    }

    public static boolean isLoadLibraries() {
        String s = System.getProperty("org.bytedeco.javacpp.loadlibraries", "true").toLowerCase();
        return s.equals("true") || s.equals("t") || s.equals("");
    }

    public static String load() {
        return Loader.load(Loader.getCallerClass(2), Loader.loadProperties(), false);
    }

    public static String load(boolean pathsFirst) {
        Class cls = Loader.getCallerClass(2);
        return Loader.load(cls, Loader.loadProperties(), pathsFirst);
    }

    public static String load(Class cls) {
        return Loader.load(cls, Loader.loadProperties(), false);
    }

    public static String load(Class cls, java.util.Properties properties, boolean pathsFirst) {
        if (!Loader.isLoadLibraries() || cls == null) {
            return null;
        }
        ClassProperties p = Loader.loadProperties(cls = Loader.getEnclosingClass(cls), properties, true);
        List<String> targets = p.get("target");
        if (targets.isEmpty()) {
            if (p.getInheritedClasses() != null) {
                for (Class c : p.getInheritedClasses()) {
                    targets.add(c.getName());
                }
            }
            targets.add(cls.getName());
        }
        for (String s : targets) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Loading class " + s);
                }
                Class.forName(s, true, cls.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to load class " + s + ": " + ex);
                }
                NoClassDefFoundError e = new NoClassDefFoundError(ex.toString());
                e.initCause(ex);
                throw e;
            }
        }
        String cacheDir = null;
        try {
            cacheDir = Loader.getCacheDir().getCanonicalPath();
        }
        catch (IOException s) {
            // empty catch block
        }
        ArrayList<String> preloads = new ArrayList<String>();
        preloads.addAll(p.get("platform.preload"));
        preloads.addAll(p.get("platform.link"));
        UnsatisfiedLinkError preloadError = null;
        for (String preload : preloads) {
            try {
                URL[] urls = Loader.findLibrary(cls, p, preload, pathsFirst);
                String filename = Loader.loadLibrary(urls, preload);
                if (cacheDir == null || !filename.startsWith(cacheDir)) continue;
                Loader.createLibraryLink(filename, p, preload);
            }
            catch (UnsatisfiedLinkError e) {
                preloadError = e;
            }
        }
        try {
            String library = p.getProperty("platform.library");
            URL[] urls = Loader.findLibrary(cls, p, library, pathsFirst);
            String filename = Loader.loadLibrary(urls, library);
            if (cacheDir != null && filename.startsWith(cacheDir)) {
                Loader.createLibraryLink(filename, p, library);
            }
            return filename;
        }
        catch (UnsatisfiedLinkError e) {
            if (preloadError != null && e.getCause() == null) {
                e.initCause(preloadError);
            }
            throw e;
        }
    }

    public static URL[] findLibrary(Class cls, ClassProperties properties, String libnameversion, boolean pathsFirst) {
        if (libnameversion.trim().endsWith("#")) {
            return new URL[0];
        }
        String[] split = libnameversion.split("#");
        String[] s = split[0].split("@");
        String[] s2 = (split.length > 1 ? split[1] : split[0]).split("@");
        String libname = s[0];
        String libname2 = s2[0];
        String version = s.length > 1 ? s[s.length - 1] : "";
        String version2 = s2.length > 1 ? s2[s2.length - 1] : "";
        String subdir = properties.getProperty("platform") + '/';
        String prefix = properties.getProperty("platform.library.prefix", "");
        String suffix = properties.getProperty("platform.library.suffix", "");
        String[] styles = new String[]{prefix + libname + suffix + version, prefix + libname + version + suffix, prefix + libname + suffix};
        String[] styles2 = new String[]{prefix + libname2 + suffix + version2, prefix + libname2 + version2 + suffix, prefix + libname2 + suffix};
        String[] suffixes = properties.get("platform.library.suffix").toArray(new String[0]);
        if (suffixes.length > 1) {
            styles = new String[3 * suffixes.length];
            styles2 = new String[3 * suffixes.length];
            for (int i = 0; i < suffixes.length; ++i) {
                styles[3 * i] = prefix + libname + suffixes[i] + version;
                styles[3 * i + 1] = prefix + libname + version + suffixes[i];
                styles[3 * i + 2] = prefix + libname + suffixes[i];
                styles2[3 * i] = prefix + libname2 + suffixes[i] + version2;
                styles2[3 * i + 1] = prefix + libname2 + version2 + suffixes[i];
                styles2[3 * i + 2] = prefix + libname2 + suffixes[i];
            }
        }
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(properties.get("platform.preloadpath"));
        paths.addAll(properties.get("platform.linkpath"));
        String libpath = System.getProperty("java.library.path", "");
        if (libpath.length() > 0) {
            paths.addAll(Arrays.asList(libpath.split(File.pathSeparator)));
        }
        ArrayList<URL> urls = new ArrayList<URL>(styles.length * (1 + paths.size()));
        for (int i = 0; cls != null && i < styles.length; ++i) {
            URL u = cls.getResource(subdir + styles[i]);
            if (u == null) continue;
            if (!styles[i].equals(styles2[i])) {
                try {
                    u = new URL(u + "#" + styles2[i]);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            urls.add(u);
        }
        int k = pathsFirst ? 0 : urls.size();
        for (int i = 0; paths.size() > 0 && i < styles.length; ++i) {
            for (String path : paths) {
                File file = new File(path, styles[i]);
                if (!file.exists()) continue;
                try {
                    URL u = file.toURI().toURL();
                    if (!styles[i].equals(styles2[i])) {
                        u = new URL(u + "#" + styles2[i]);
                    }
                    urls.add(k++, u);
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static String loadLibrary(URL[] urls, String libnameversion) {
        if (!Loader.isLoadLibraries()) {
            return null;
        }
        String[] split = libnameversion.split("#");
        String libnameversion2 = split[0];
        if (split.length > 1) {
            libnameversion2 = split[1];
        }
        String filename = loadedLibraries.get(libnameversion2);
        UnsatisfiedLinkError loadError = null;
        try {
            for (URL url : urls) {
                File file;
                URI uri = url.toURI();
                try {
                    file = new File(uri);
                }
                catch (Exception exc) {
                    try {
                        file = new File(uri.getPath());
                        if (file.exists()) {
                            String filename2 = file.getAbsolutePath();
                            if (logger.isDebugEnabled()) {
                                logger.debug("Preloading " + filename2);
                            }
                            try {
                                System.load(filename2);
                            }
                            catch (UnsatisfiedLinkError e) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Failed to preload " + filename2 + ": " + e);
                                }
                            }
                        }
                    }
                    catch (Exception filename2) {
                        // empty catch block
                    }
                    file = Loader.cacheResource(url, filename);
                }
                if (filename != null) {
                    return filename;
                }
                if (file == null || !file.exists()) continue;
                String filename2 = file.getAbsolutePath();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Loading " + filename2);
                    }
                    loadedLibraries.put(libnameversion2, filename2);
                    System.load(filename2);
                    return filename2;
                }
                catch (UnsatisfiedLinkError e) {
                    loadError = e;
                    loadedLibraries.remove(libnameversion2);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Failed to load " + filename2 + ": " + e);
                }
            }
            if (filename != null) {
                return filename;
            }
            String libname = libnameversion.split("#")[0].split("@")[0];
            if (logger.isDebugEnabled()) {
                logger.debug("Loading library " + libname);
            }
            loadedLibraries.put(libnameversion2, libname);
            System.loadLibrary(libname);
            return libname;
        }
        catch (UnsatisfiedLinkError e) {
            loadedLibraries.remove(libnameversion2);
            if (loadError != null && e.getCause() == null) {
                e.initCause(loadError);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to load for " + libnameversion + ": " + e);
            }
            throw e;
        }
        catch (IOException | URISyntaxException ex) {
            loadedLibraries.remove(libnameversion2);
            if (loadError != null && ex.getCause() == null) {
                ex.initCause(loadError);
            }
            UnsatisfiedLinkError e = new UnsatisfiedLinkError(ex.toString());
            e.initCause(ex);
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to extract for " + libnameversion + ": " + e);
            }
            throw e;
        }
    }

    public static String createLibraryLink(String filename, ClassProperties properties, String libnameversion) {
        String version;
        File file = new File(filename);
        String parent = file.getParent();
        String name = file.getName();
        String link = null;
        String[] split = libnameversion.split("#");
        String[] s = (split.length > 1 ? split[1] : split[0]).split("@");
        String libname = s[0];
        String string = version = s.length > 1 ? s[s.length - 1] : "";
        if (version.length() == 0) {
            return filename;
        }
        for (String suffix : properties.get("platform.library.suffix")) {
            int n = name.lastIndexOf(suffix);
            int n2 = name.lastIndexOf(version);
            if (n <= 0 || n2 <= 0) continue;
            link = name.substring(0, n < n2 ? n : n2) + suffix;
            break;
        }
        if (link != null && link.length() > 0 && !link.equals(name)) {
            File linkFile = new File(parent, link);
            Path linkPath = linkFile.toPath();
            Path targetPath = Paths.get(name, new String[0]);
            try {
                if (!(linkFile.exists() && Files.isSymbolicLink(linkPath) && Files.readSymbolicLink(linkPath).equals(targetPath) || targetPath.isAbsolute() || targetPath.equals(linkPath))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Creating symbolic link " + linkPath);
                    }
                    linkFile.delete();
                    Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
                }
                filename = linkFile.toString();
            }
            catch (IOException | UnsupportedOperationException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to create symbolic link " + linkPath + ": " + e);
                }
                return null;
            }
        }
        return filename;
    }

    static Class putMemberOffset(String typeName, String member, int offset) throws ClassNotFoundException {
        Class<?> c = Class.forName(typeName.replace('/', '.'), false, Loader.class.getClassLoader());
        if (member != null) {
            Loader.putMemberOffset(c.asSubclass(Pointer.class), member, offset);
        }
        return c;
    }

    static synchronized void putMemberOffset(Class<? extends Pointer> type, String member, int offset) {
        HashMap<String, Integer> offsets = memberOffsets.get(type);
        if (offsets == null) {
            offsets = new HashMap();
            memberOffsets.put(type, offsets);
        }
        offsets.put(member, offset);
    }

    public static int offsetof(Class<? extends Pointer> type, String member) {
        return memberOffsets.get(type).get(member);
    }

    public static int sizeof(Class<? extends Pointer> type) {
        return memberOffsets.get(type).get("sizeof");
    }

    static {
        platformProperties = null;
        String jvmName = System.getProperty("java.vm.name", "").toLowerCase();
        String osName = System.getProperty("os.name", "").toLowerCase();
        String osArch = System.getProperty("os.arch", "").toLowerCase();
        String abiType = System.getProperty("sun.arch.abi", "").toLowerCase();
        String libPath = System.getProperty("sun.boot.library.path", "").toLowerCase();
        if (jvmName.startsWith("dalvik") && osName.startsWith("linux")) {
            osName = "android";
        } else if (jvmName.startsWith("robovm") && osName.startsWith("darwin")) {
            osName = "ios";
            osArch = "arm";
        } else if (osName.startsWith("mac os x") || osName.startsWith("darwin")) {
            osName = "macosx";
        } else {
            int spaceIndex = osName.indexOf(32);
            if (spaceIndex > 0) {
                osName = osName.substring(0, spaceIndex);
            }
        }
        if (osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686")) {
            osArch = "x86";
        } else if (osArch.equals("amd64") || osArch.equals("x86-64") || osArch.equals("x64")) {
            osArch = "x86_64";
        } else if (osArch.startsWith("aarch64") || osArch.startsWith("armv8") || osArch.startsWith("arm64")) {
            osArch = "arm64";
        } else if (osArch.startsWith("arm") && (abiType.equals("gnueabihf") || libPath.contains("openjdk-armhf"))) {
            osArch = "armhf";
        } else if (osArch.startsWith("arm")) {
            osArch = "arm";
        }
        PLATFORM = osName + "-" + osArch;
        cacheDir = null;
        tempDir = null;
        loadedLibraries = Collections.synchronizedMap(new HashMap());
        memberOffsets = new WeakHashMap();
    }
}

