/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bytedeco.javacpp.tools.Declarator;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.TemplateMap;
import org.bytedeco.javacpp.tools.Type;

class Context {
    String namespace = null;
    String baseType = null;
    String cppName = null;
    String javaName = null;
    String constName = null;
    String constBaseName = null;
    boolean immutable = false;
    boolean inaccessible = false;
    boolean objectify = false;
    boolean virtualize = false;
    Declarator variable = null;
    InfoMap infoMap = null;
    TemplateMap templateMap = null;
    List<String> usingList = null;
    Map<String, String> namespaceMap = null;

    Context() {
        this.usingList = new ArrayList<String>();
        this.namespaceMap = new HashMap<String, String>();
    }

    Context(Context c) {
        this.namespace = c.namespace;
        this.baseType = c.baseType;
        this.cppName = c.cppName;
        this.javaName = c.javaName;
        this.constName = c.constName;
        this.constBaseName = c.constBaseName;
        this.immutable = c.immutable;
        this.inaccessible = c.inaccessible;
        this.objectify = c.objectify;
        this.virtualize = c.virtualize;
        this.variable = c.variable;
        this.infoMap = c.infoMap;
        this.templateMap = c.templateMap;
        this.usingList = c.usingList;
        this.namespaceMap = c.namespaceMap;
    }

    String[] qualify(String cppName) {
        String ns;
        if (cppName == null || cppName.length() == 0) {
            return new String[0];
        }
        if (cppName.startsWith("::")) {
            return new String[]{cppName.substring(2)};
        }
        for (Map.Entry<String, String> e : this.namespaceMap.entrySet()) {
            cppName = cppName.replaceAll(e.getKey() + "::", e.getValue() + "::");
        }
        ArrayList<String> names = new ArrayList<String>();
        String string = ns = this.namespace != null ? this.namespace : "";
        while (ns != null) {
            String name = ns.length() > 0 ? ns + "::" + cppName : cppName;
            TemplateMap map = this.templateMap;
            while (map != null) {
                if (name.equals(map.getName())) {
                    Object args = "<";
                    String separator = "";
                    for (Type t : map.values()) {
                        if (t == null) continue;
                        args = (String)args + separator + t.cppName;
                        separator = ",";
                    }
                    names.add(name + (String)args + (((String)args).endsWith(">") ? " >" : ">"));
                    break;
                }
                map = map.parent;
            }
            names.add(name);
            for (String s : this.usingList) {
                String prefix = this.infoMap.normalize(cppName, false, true);
                int i = s.lastIndexOf("::") + 2;
                String ns2 = ns.length() > 0 ? ns + "::" + s.substring(0, i) : s.substring(0, i);
                String suffix = s.substring(i);
                if (suffix.length() != 0 && !prefix.equals(suffix)) continue;
                names.add(ns2 + cppName);
            }
            int i = (ns = this.infoMap.normalize(ns, false, true)).lastIndexOf("::");
            ns = i >= 0 ? ns.substring(0, i) : (ns.length() > 0 ? "" : null);
        }
        return names.toArray(new String[names.size()]);
    }

    String shorten(String javaName) {
        if (this.javaName != null) {
            int lastDot = 0;
            String s1 = javaName;
            String s2 = this.javaName + '.';
            for (int i = 0; i < s1.length() && i < s2.length() && s1.charAt(i) == s2.charAt(i); ++i) {
                if (s1.charAt(i) != '.') continue;
                lastDot = i;
            }
            if (lastDot > 0) {
                javaName = javaName.substring(lastDot + 1);
            }
        }
        return javaName;
    }
}

