/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Raw;
import org.bytedeco.javacpp.indexer.UByteIndexer;

public class UByteRawIndexer
extends UByteIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected BytePointer pointer;
    final long base;
    final long size;

    public UByteRawIndexer(BytePointer pointer) {
        this(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public UByteRawIndexer(BytePointer pointer, long[] sizes) {
        this(pointer, sizes, UByteRawIndexer.strides(sizes));
    }

    public UByteRawIndexer(BytePointer pointer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.pointer = pointer;
        this.base = pointer.address() + pointer.position();
        this.size = pointer.limit() - pointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    @Override
    public int get(long i) {
        return RAW.getByte(this.base + UByteRawIndexer.checkIndex(i, this.size)) & 0xFF;
    }

    @Override
    public UByteIndexer get(long i, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.get(i * this.strides[0] + (long)n) & 0xFF;
        }
        return this;
    }

    @Override
    public int get(long i, long j) {
        return this.get(i * this.strides[0] + j) & 0xFF;
    }

    @Override
    public UByteIndexer get(long i, long j, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.get(i * this.strides[0] + j * this.strides[1] + (long)n) & 0xFF;
        }
        return this;
    }

    @Override
    public int get(long i, long j, long k) {
        return this.get(i * this.strides[0] + j * this.strides[1] + k) & 0xFF;
    }

    @Override
    public int get(long ... indices) {
        return this.get(this.index(indices)) & 0xFF;
    }

    @Override
    public UByteIndexer get(long[] indices, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.get(this.index(indices) + (long)n) & 0xFF;
        }
        return this;
    }

    @Override
    public UByteIndexer put(long i, int b) {
        RAW.putByte(this.base + UByteRawIndexer.checkIndex(i, this.size), (byte)b);
        return this;
    }

    @Override
    public UByteIndexer put(long i, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + (long)n, (int)((byte)b[offset + n]));
        }
        return this;
    }

    @Override
    public UByteIndexer put(long i, long j, int b) {
        this.put(i * this.strides[0] + j, (int)((byte)b));
        return this;
    }

    @Override
    public UByteIndexer put(long i, long j, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + j * this.strides[1] + (long)n, (int)((byte)b[offset + n]));
        }
        return this;
    }

    @Override
    public UByteIndexer put(long i, long j, long k, int b) {
        this.put(i * this.strides[0] + j * this.strides[1] + k, (int)((byte)b));
        return this;
    }

    @Override
    public UByteIndexer put(long[] indices, int b) {
        this.put(this.index(indices), (int)((byte)b));
        return this;
    }

    @Override
    public UByteIndexer put(long[] indices, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(this.index(indices) + (long)n, (int)((byte)b[offset + n]));
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

