/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.cvkernels;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.Parallel;

public class cvkernels
extends org.bytedeco.javacpp.cvkernels {
    private static ThreadLocal<ParallelData[]> parallelData = new ThreadLocal<ParallelData[]>(){

        @Override
        protected ParallelData[] initialValue() {
            ParallelData[] pd = new ParallelData[Parallel.getNumThreads()];
            for (int i = 0; i < pd.length; ++i) {
                pd[i] = new ParallelData();
            }
            return pd;
        }
    };

    public static void multiWarpColorTransform(cvkernels.KernelData data, opencv_core.CvRect roi, final opencv_core.CvScalar fillColor) {
        int h;
        int w;
        int y;
        int x;
        final int size = data.capacity();
        final ParallelData[] pd = parallelData.get();
        for (int i = 0; i < pd.length; ++i) {
            cvkernels.KernelData d;
            int j;
            if (pd[i].data == null || pd[i].data.capacity() < size) {
                pd[i].data = new cvkernels.KernelData(size);
                for (j = 0; j < size; ++j) {
                    d = pd[i].data.position(j);
                    data.position(j);
                    if (data.dstDstDot() == null) continue;
                    d.dstDstDot(ByteBuffer.allocateDirect(data.dstDstDot().capacity() * 8).order(ByteOrder.nativeOrder()).asDoubleBuffer());
                }
            }
            for (j = 0; j < size; ++j) {
                d = pd[i].data.position(j);
                d.put((Pointer)data.position(j));
                d.dstDstDot(d.dstDstDot());
            }
        }
        opencv_core.IplImage img = data.position(0).srcImg();
        final int depth = img.depth();
        if (roi != null) {
            x = roi.x();
            y = roi.y();
            w = roi.width();
            h = roi.height();
        } else {
            x = 0;
            y = 0;
            w = img.width();
            h = img.height();
        }
        Parallel.loop(y, y + h, pd.length, new Parallel.Looper(){

            @Override
            public void loop(int from, int to, int looperID) {
                opencv_core.CvRect r = pd[looperID].roi.x(x).y(from).width(w).height(to - from);
                if (depth == 32) {
                    org.bytedeco.javacpp.cvkernels.multiWarpColorTransform32F((cvkernels.KernelData)pd[looperID].data.position(0), (int)size, (opencv_core.CvRect)r, (opencv_core.CvScalar)fillColor);
                } else if (depth == 8) {
                    org.bytedeco.javacpp.cvkernels.multiWarpColorTransform8U((cvkernels.KernelData)pd[looperID].data.position(0), (int)size, (opencv_core.CvRect)r, (opencv_core.CvScalar)fillColor);
                } else assert (false);
            }
        });
        for (int i = 0; i < size; ++i) {
            int dstCount = 0;
            int dstCountZero = 0;
            int dstCountOutlier = 0;
            double srcDstDot = 0.0;
            double[] dstDstDot = null;
            if (data.dstDstDot() != null) {
                dstDstDot = new double[data.dstDstDot().capacity()];
            }
            for (int j = 0; j < pd.length; ++j) {
                cvkernels.KernelData d = pd[j].data.position(i);
                dstCount += d.dstCount();
                dstCountZero += d.dstCountZero();
                dstCountOutlier += d.dstCountOutlier();
                srcDstDot += d.srcDstDot();
                if (dstDstDot == null || d.dstDstDot() == null) continue;
                for (int k = 0; k < dstDstDot.length; ++k) {
                    int n = k;
                    dstDstDot[n] = dstDstDot[n] + d.dstDstDot().get(k);
                }
            }
            data.position(i);
            data.dstCount(dstCount);
            data.dstCountZero(dstCountZero);
            data.dstCountOutlier(dstCountOutlier);
            data.srcDstDot(srcDstDot);
            if (dstDstDot == null || data.dstDstDot() == null) continue;
            data.dstDstDot().position(0);
            data.dstDstDot().put(dstDstDot);
        }
    }

    private static class ParallelData {
        cvkernels.KernelData data = null;
        opencv_core.CvRect roi = new opencv_core.CvRect();

        private ParallelData() {
        }
    }
}

