/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.bytedeco.javacv.OpenCVFrameConverter;

public class Java2DFrameUtils {
    private static OpenCVFrameConverter.ToIplImage iplConv = new OpenCVFrameConverter.ToIplImage();
    private static OpenCVFrameConverter.ToMat matConv = new OpenCVFrameConverter.ToMat();
    private static Java2DFrameConverter biConv = new Java2DFrameConverter();

    public static BufferedImage deepCopy(BufferedImage image1) {
        ColorModel cm = image1.getColorModel();
        WritableRaster raster = image1.copyData(image1.getRaster().createCompatibleWritableRaster());
        BufferedImage copied = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
        return copied;
    }

    public static synchronized BufferedImage toBufferedImage(opencv_core.IplImage src) {
        return Java2DFrameUtils.deepCopy(biConv.getBufferedImage(iplConv.convert(src).clone()));
    }

    public static synchronized BufferedImage toBufferedImage(opencv_core.Mat src) {
        return Java2DFrameUtils.deepCopy(biConv.getBufferedImage(matConv.convert(src).clone()));
    }

    public static synchronized BufferedImage toBufferedImage(Frame src) {
        return Java2DFrameUtils.deepCopy(biConv.getBufferedImage(src.clone()));
    }

    public static synchronized opencv_core.IplImage toIplImage(opencv_core.Mat src) {
        return iplConv.convertToIplImage(matConv.convert(src)).clone();
    }

    public static synchronized opencv_core.IplImage toIplImage(Frame src) {
        return iplConv.convertToIplImage(src).clone();
    }

    public static synchronized opencv_core.IplImage toIplImage(BufferedImage src) {
        return iplConv.convertToIplImage(biConv.convert(src)).clone();
    }

    public static synchronized opencv_core.Mat toMat(opencv_core.IplImage src) {
        return matConv.convertToMat(iplConv.convert(src).clone());
    }

    public static synchronized opencv_core.Mat toMat(Frame src) {
        return matConv.convertToMat(src).clone();
    }

    public static synchronized opencv_core.Mat toMat(BufferedImage src) {
        return matConv.convertToMat(biConv.convert(src)).clone();
    }

    public static synchronized Frame toFrame(opencv_core.IplImage src) {
        return iplConv.convert(src).clone();
    }

    public static synchronized Frame toFrame(opencv_core.Mat src) {
        return matConv.convert(src).clone();
    }

    public static synchronized Frame toFrame(BufferedImage src) {
        return biConv.convert(src).clone();
    }
}

