/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.lept;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameConverter;

public class LeptonicaFrameConverter
extends FrameConverter<lept.PIX> {
    lept.PIX pix;
    ByteBuffer frameBuffer;
    ByteBuffer pixBuffer;

    static boolean isEqual(Frame frame, lept.PIX pix) {
        return pix != null && frame != null && frame.image != null && frame.image.length > 0 && frame.imageWidth == pix.w() && frame.imageHeight == pix.h() && frame.imageChannels == pix.d() / 8 && frame.imageDepth == 8 && (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) || new Pointer(frame.image[0]).address() == pix.data().address()) && frame.imageStride * Math.abs(frame.imageDepth) / 8 == pix.wpl() * 4;
    }

    @Override
    public lept.PIX convert(Frame frame) {
        if (frame == null || frame.image == null) {
            return null;
        }
        if (frame.opaque instanceof lept.PIX) {
            return (lept.PIX)frame.opaque;
        }
        if (!LeptonicaFrameConverter.isEqual(frame, this.pix)) {
            Pointer data;
            if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                this.pixBuffer = ByteBuffer.allocateDirect(frame.imageHeight * frame.imageStride).order(ByteOrder.BIG_ENDIAN);
                data = new Pointer((Buffer)this.pixBuffer);
            } else {
                data = new Pointer(frame.image[0].position(0));
            }
            this.pix = lept.PIX.create((int)frame.imageWidth, (int)frame.imageHeight, (int)(frame.imageChannels * 8), (Pointer)data).wpl(frame.imageStride / 4 * Math.abs(frame.imageDepth) / 8);
        }
        if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
            ((ByteBuffer)this.pixBuffer.position(0)).asIntBuffer().put(((ByteBuffer)frame.image[0].position(0)).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer());
        }
        return this.pix;
    }

    @Override
    public Frame convert(lept.PIX pix) {
        if (pix == null) {
            return null;
        }
        lept.PIX tempPix = null;
        if (pix.colormap() != null) {
            tempPix = pix = lept.pixRemoveColormap((lept.PIX)pix, (int)2);
        } else if (pix.d() < 8) {
            switch (pix.d()) {
                case 1: {
                    tempPix = pix = lept.pixConvert1To8(null, (lept.PIX)pix, (byte)0, (byte)-1);
                    break;
                }
                case 2: {
                    tempPix = pix = lept.pixConvert2To8((lept.PIX)pix, (byte)0, (byte)85, (byte)-86, (byte)-1, (int)0);
                    break;
                }
                case 4: {
                    tempPix = pix = lept.pixConvert4To8((lept.PIX)pix, (int)0);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (!LeptonicaFrameConverter.isEqual(this.frame, pix)) {
            this.frame = new Frame();
            this.frame.imageWidth = pix.w();
            this.frame.imageHeight = pix.h();
            this.frame.imageDepth = 8;
            this.frame.imageChannels = pix.d() / 8;
            this.frame.imageStride = pix.wpl() * 4;
            if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                this.frameBuffer = ByteBuffer.allocateDirect(this.frame.imageHeight * this.frame.imageStride).order(ByteOrder.LITTLE_ENDIAN);
                this.frame.image = new Buffer[]{this.frameBuffer};
            } else {
                this.frame.image = new Buffer[]{pix.createBuffer()};
            }
        }
        if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
            ((ByteBuffer)this.frameBuffer.position(0)).asIntBuffer().put(pix.createBuffer().order(ByteOrder.BIG_ENDIAN).asIntBuffer());
        }
        if (tempPix != null) {
            this.frame.opaque = pix.clone();
            lept.pixDestroy((lept.PIX)tempPix);
        } else {
            this.frame.opaque = pix;
        }
        return this.frame;
    }
}

