/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import org.bytedeco.javacpp.cvkernels;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_calib3d;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.CameraDevice;
import org.bytedeco.javacv.ImageTransformer;
import org.bytedeco.javacv.JavaCV;
import org.bytedeco.javacv.ProjectiveColorTransformer;
import org.bytedeco.javacv.ProjectorDevice;
import org.bytedeco.javacv.cvkernels;

public class ProCamTransformer
implements ImageTransformer {
    protected CameraDevice camera = null;
    protected ProjectorDevice projector = null;
    protected ProjectiveColorTransformer surfaceTransformer = null;
    protected ProjectiveColorTransformer projectorTransformer = null;
    protected opencv_core.IplImage[] projectorImage = null;
    protected opencv_core.IplImage[] surfaceImage = null;
    protected opencv_core.CvScalar fillColor = opencv_core.cvScalar((double)0.0, (double)0.0, (double)0.0, (double)1.0);
    protected opencv_core.CvRect roi = new opencv_core.CvRect();
    protected opencv_core.CvMat frontoParallelH = null;
    protected opencv_core.CvMat invFrontoParallelH = null;
    protected opencv_core.CvMat invCameraMatrix = null;
    protected cvkernels.KernelData kernelData = null;
    protected opencv_core.CvMat[] H1 = null;
    protected opencv_core.CvMat[] H2 = null;
    protected opencv_core.CvMat[] X = null;

    public ProCamTransformer(double[] referencePoints, CameraDevice camera, ProjectorDevice projector) {
        this(referencePoints, camera, projector, null);
    }

    public ProCamTransformer(double[] referencePoints, CameraDevice camera, ProjectorDevice projector, opencv_core.CvMat n) {
        this.camera = camera;
        this.projector = projector;
        if (referencePoints != null) {
            this.surfaceTransformer = new ProjectiveColorTransformer(camera.cameraMatrix, camera.cameraMatrix, null, null, n, referencePoints, null, null, 3, 0);
        }
        double[] referencePoints1 = new double[]{0.0, 0.0, camera.imageWidth / 2, camera.imageHeight, camera.imageWidth, 0.0};
        double[] referencePoints2 = new double[]{0.0, 0.0, projector.imageWidth / 2, projector.imageHeight, projector.imageWidth, 0.0};
        if (n != null) {
            this.invCameraMatrix = opencv_core.CvMat.create((int)3, (int)3);
            opencv_core.cvInvert((opencv_core.CvArr)camera.cameraMatrix, (opencv_core.CvArr)this.invCameraMatrix);
            JavaCV.perspectiveTransform(referencePoints2, referencePoints1, this.invCameraMatrix, projector.cameraMatrix, projector.R, projector.T, n, true);
        }
        this.projectorTransformer = new ProjectiveColorTransformer(camera.cameraMatrix, projector.cameraMatrix, projector.R, projector.T, null, referencePoints1, referencePoints2, projector.colorMixingMatrix, 1, 3);
        if (referencePoints != null && n != null) {
            this.frontoParallelH = camera.getFrontoParallelH(referencePoints, n, opencv_core.CvMat.create((int)3, (int)3));
            this.invFrontoParallelH = this.frontoParallelH.clone();
            opencv_core.cvInvert((opencv_core.CvArr)this.frontoParallelH, (opencv_core.CvArr)this.invFrontoParallelH);
        }
    }

    public int getNumGains() {
        return this.projectorTransformer.getNumGains();
    }

    public int getNumBiases() {
        return this.projectorTransformer.getNumBiases();
    }

    public opencv_core.CvScalar getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(opencv_core.CvScalar fillColor) {
        this.fillColor = fillColor;
    }

    public ProjectiveColorTransformer getSurfaceTransformer() {
        return this.surfaceTransformer;
    }

    public ProjectiveColorTransformer getProjectorTransformer() {
        return this.projectorTransformer;
    }

    public opencv_core.IplImage getProjectorImage(int pyramidLevel) {
        return this.projectorImage[pyramidLevel];
    }

    public void setProjectorImage(opencv_core.IplImage projectorImage0, int minLevel, int maxLevel) {
        this.setProjectorImage(projectorImage0, minLevel, maxLevel, true);
    }

    public void setProjectorImage(opencv_core.IplImage projectorImage0, int minLevel, int maxLevel, boolean convertToFloat) {
        if (this.projectorImage == null || this.projectorImage.length != maxLevel + 1) {
            this.projectorImage = new opencv_core.IplImage[maxLevel + 1];
        }
        if (projectorImage0.depth() == 32 || !convertToFloat) {
            this.projectorImage[minLevel] = projectorImage0;
        } else {
            opencv_core.IplROI ir;
            if (this.projectorImage[minLevel] == null) {
                this.projectorImage[minLevel] = opencv_core.IplImage.create((int)projectorImage0.width(), (int)projectorImage0.height(), (int)32, (int)projectorImage0.nChannels(), (int)projectorImage0.origin());
            }
            if ((ir = projectorImage0.roi()) != null) {
                int align = 1 << maxLevel + 1;
                this.roi.x(Math.max(0, (int)Math.floor((double)ir.xOffset() / (double)align) * align));
                this.roi.y(Math.max(0, (int)Math.floor((double)ir.yOffset() / (double)align) * align));
                this.roi.width(Math.min(projectorImage0.width(), (int)Math.ceil((double)ir.width() / (double)align) * align));
                this.roi.height(Math.min(projectorImage0.height(), (int)Math.ceil((double)ir.height() / (double)align) * align));
                opencv_core.cvSetImageROI((opencv_core.IplImage)projectorImage0, (opencv_core.CvRect)this.roi);
                opencv_core.cvSetImageROI((opencv_core.IplImage)this.projectorImage[minLevel], (opencv_core.CvRect)this.roi);
            } else {
                opencv_core.cvResetImageROI((opencv_core.IplImage)projectorImage0);
                opencv_core.cvResetImageROI((opencv_core.IplImage)this.projectorImage[minLevel]);
            }
            opencv_core.cvConvertScale((opencv_core.CvArr)projectorImage0, (opencv_core.CvArr)this.projectorImage[minLevel], (double)0.00392156862745098, (double)0.0);
        }
        for (int i = minLevel + 1; i <= maxLevel; ++i) {
            opencv_core.IplROI ir;
            int w = this.projectorImage[i - 1].width() / 2;
            int h = this.projectorImage[i - 1].height() / 2;
            int d = this.projectorImage[i - 1].depth();
            int c = this.projectorImage[i - 1].nChannels();
            int o = this.projectorImage[i - 1].origin();
            if (this.projectorImage[i] == null) {
                this.projectorImage[i] = opencv_core.IplImage.create((int)w, (int)h, (int)d, (int)c, (int)o);
            }
            if ((ir = this.projectorImage[i - 1].roi()) != null) {
                this.roi.x(ir.xOffset() / 2);
                this.roi.width(ir.width() / 2);
                this.roi.y(ir.yOffset() / 2);
                this.roi.height(ir.height() / 2);
                opencv_core.cvSetImageROI((opencv_core.IplImage)this.projectorImage[i], (opencv_core.CvRect)this.roi);
            } else {
                opencv_core.cvResetImageROI((opencv_core.IplImage)this.projectorImage[i]);
            }
            opencv_imgproc.cvPyrDown((opencv_core.CvArr)this.projectorImage[i - 1], (opencv_core.CvArr)this.projectorImage[i], (int)7);
            opencv_core.cvResetImageROI((opencv_core.IplImage)this.projectorImage[i - 1]);
        }
    }

    public opencv_core.IplImage getSurfaceImage(int pyramidLevel) {
        return this.surfaceImage[pyramidLevel];
    }

    public void setSurfaceImage(opencv_core.IplImage surfaceImage0, int pyramidLevels) {
        if (this.surfaceImage == null || this.surfaceImage.length != pyramidLevels) {
            this.surfaceImage = new opencv_core.IplImage[pyramidLevels];
        }
        this.surfaceImage[0] = surfaceImage0;
        opencv_core.cvResetImageROI((opencv_core.IplImage)surfaceImage0);
        for (int i = 1; i < pyramidLevels; ++i) {
            int w = this.surfaceImage[i - 1].width() / 2;
            int h = this.surfaceImage[i - 1].height() / 2;
            int d = this.surfaceImage[i - 1].depth();
            int c = this.surfaceImage[i - 1].nChannels();
            int o = this.surfaceImage[i - 1].origin();
            if (this.surfaceImage[i] == null) {
                this.surfaceImage[i] = opencv_core.IplImage.create((int)w, (int)h, (int)d, (int)c, (int)o);
            } else {
                opencv_core.cvResetImageROI((opencv_core.IplImage)this.surfaceImage[i]);
            }
            opencv_imgproc.cvPyrDown((opencv_core.CvArr)this.surfaceImage[i - 1], (opencv_core.CvArr)this.surfaceImage[i], (int)7);
        }
    }

    protected void prepareTransforms(opencv_core.CvMat H1, opencv_core.CvMat H2, opencv_core.CvMat X, int pyramidLevel, Parameters p) {
        ProjectiveColorTransformer.Parameters cameraParameters = p.getSurfaceParameters();
        ProjectiveColorTransformer.Parameters projectorParameters = p.getProjectorParameters();
        if (this.surfaceTransformer != null) {
            opencv_core.cvInvert((opencv_core.CvArr)cameraParameters.getH(), (opencv_core.CvArr)H1);
        }
        opencv_core.cvInvert((opencv_core.CvArr)projectorParameters.getH(), (opencv_core.CvArr)H2);
        if (pyramidLevel > 0) {
            int scale = 1 << pyramidLevel;
            if (this.surfaceTransformer != null) {
                H1.put(2, H1.get(2) / (double)scale);
                H1.put(5, H1.get(5) / (double)scale);
                H1.put(6, H1.get(6) * (double)scale);
                H1.put(7, H1.get(7) * (double)scale);
            }
            H2.put(2, H2.get(2) / (double)scale);
            H2.put(5, H2.get(5) / (double)scale);
            H2.put(6, H2.get(6) * (double)scale);
            H2.put(7, H2.get(7) * (double)scale);
        }
        double[] x = this.projector.colorMixingMatrix.get();
        double[] a = projectorParameters.getColorParameters();
        double a2 = a[0];
        X.put(new double[]{a2 * x[0], a2 * x[1], a2 * x[2], a[1], a2 * x[3], a2 * x[4], a2 * x[5], a[2], a2 * x[6], a2 * x[7], a2 * x[8], a[3], 0.0, 0.0, 0.0, 1.0});
    }

    public void transform(opencv_core.IplImage srcImage, opencv_core.IplImage dstImage, opencv_core.CvRect roi, int pyramidLevel, ImageTransformer.Parameters parameters, boolean inverse) {
        if (inverse) {
            throw new UnsupportedOperationException("Inverse transform not supported.");
        }
        Parameters p = (Parameters)parameters;
        ProjectiveColorTransformer.Parameters cameraParameters = p.getSurfaceParameters();
        ProjectiveColorTransformer.Parameters projectorParameters = p.getProjectorParameters();
        if (p.tempImage == null || p.tempImage.length <= pyramidLevel) {
            Parameters.access$002(p, new opencv_core.IplImage[pyramidLevel + 1]);
        }
        ((Parameters)p).tempImage[pyramidLevel] = opencv_core.IplImage.createIfNotCompatible((opencv_core.IplImage)p.tempImage[pyramidLevel], (opencv_core.IplImage)dstImage);
        if (roi == null) {
            opencv_core.cvResetImageROI((opencv_core.IplImage)p.tempImage[pyramidLevel]);
        } else {
            opencv_core.cvSetImageROI((opencv_core.IplImage)p.tempImage[pyramidLevel], (opencv_core.CvRect)roi);
        }
        if (this.surfaceTransformer != null) {
            this.surfaceTransformer.transform(srcImage, p.tempImage[pyramidLevel], roi, pyramidLevel, cameraParameters, false);
        }
        this.projectorTransformer.transform(this.projectorImage[pyramidLevel], dstImage, roi, pyramidLevel, projectorParameters, false);
        if (this.surfaceTransformer != null) {
            opencv_core.cvMul((opencv_core.CvArr)dstImage, (opencv_core.CvArr)p.tempImage[pyramidLevel], (opencv_core.CvArr)dstImage, (double)(1.0 / dstImage.highValue()));
        } else {
            opencv_core.cvCopy((opencv_core.CvArr)p.tempImage[pyramidLevel], (opencv_core.CvArr)dstImage);
        }
    }

    @Override
    public void transform(opencv_core.CvMat srcPts, opencv_core.CvMat dstPts, ImageTransformer.Parameters parameters, boolean inverse) {
        if (this.surfaceTransformer != null) {
            this.surfaceTransformer.transform(srcPts, dstPts, ((Parameters)parameters).surfaceParameters, inverse);
        } else if (dstPts != srcPts) {
            dstPts.put(srcPts);
        }
    }

    @Override
    public void transform(ImageTransformer.Data[] data, opencv_core.CvRect roi, ImageTransformer.Parameters[] parameters, boolean[] inverses) {
        int i;
        assert (data.length == parameters.length);
        if (this.kernelData == null || this.kernelData.capacity() < (long)data.length) {
            this.kernelData = new cvkernels.KernelData((long)data.length);
        }
        if ((this.H1 == null || this.H1.length < data.length) && this.surfaceTransformer != null) {
            this.H1 = new opencv_core.CvMat[data.length];
            for (i = 0; i < this.H1.length; ++i) {
                this.H1[i] = opencv_core.CvMat.create((int)3, (int)3);
            }
        }
        if (this.H2 == null || this.H2.length < data.length) {
            this.H2 = new opencv_core.CvMat[data.length];
            for (i = 0; i < this.H2.length; ++i) {
                this.H2[i] = opencv_core.CvMat.create((int)3, (int)3);
            }
        }
        if (this.X == null || this.X.length < data.length) {
            this.X = new opencv_core.CvMat[data.length];
            for (i = 0; i < this.X.length; ++i) {
                this.X[i] = opencv_core.CvMat.create((int)4, (int)4);
            }
        }
        for (i = 0; i < data.length; ++i) {
            this.kernelData.position((long)i);
            this.kernelData.srcImg(this.projectorImage[data[i].pyramidLevel]);
            this.kernelData.srcImg2(this.surfaceTransformer == null ? null : data[i].srcImg);
            this.kernelData.subImg(data[i].subImg);
            this.kernelData.srcDotImg(data[i].srcDotImg);
            this.kernelData.mask(data[i].mask);
            this.kernelData.zeroThreshold(data[i].zeroThreshold);
            this.kernelData.outlierThreshold(data[i].outlierThreshold);
            if (inverses != null && inverses[i]) {
                throw new UnsupportedOperationException("Inverse transform not supported.");
            }
            this.prepareTransforms(this.surfaceTransformer == null ? null : this.H1[i], this.H2[i], this.X[i], data[i].pyramidLevel, (Parameters)parameters[i]);
            this.kernelData.H1(this.H2[i]);
            this.kernelData.H2(this.surfaceTransformer == null ? null : this.H1[i]);
            this.kernelData.X(this.X[i]);
            this.kernelData.transImg(data[i].transImg);
            this.kernelData.dstImg(data[i].dstImg);
            this.kernelData.dstDstDot(data[i].dstDstDot);
        }
        long fullCapacity = this.kernelData.capacity();
        this.kernelData.capacity((long)data.length);
        cvkernels.multiWarpColorTransform(this.kernelData, roi, this.getFillColor());
        this.kernelData.capacity(fullCapacity);
        for (int i2 = 0; i2 < data.length; ++i2) {
            this.kernelData.position((long)i2);
            data[i2].dstCount = this.kernelData.dstCount();
            data[i2].dstCountZero = this.kernelData.dstCountZero();
            data[i2].dstCountOutlier = this.kernelData.dstCountOutlier();
            data[i2].srcDstDot = this.kernelData.srcDstDot();
        }
    }

    @Override
    public Parameters createParameters() {
        return new Parameters();
    }

    public class Parameters
    implements ImageTransformer.Parameters {
        private ProjectiveColorTransformer.Parameters surfaceParameters = null;
        private ProjectiveColorTransformer.Parameters projectorParameters = null;
        private opencv_core.IplImage[] tempImage = null;
        private opencv_core.CvMat H = opencv_core.CvMat.create((int)3, (int)3);
        private opencv_core.CvMat R = opencv_core.CvMat.create((int)3, (int)3);
        private opencv_core.CvMat n = opencv_core.CvMat.create((int)3, (int)1);
        private opencv_core.CvMat t = opencv_core.CvMat.create((int)3, (int)1);

        protected Parameters() {
            this.reset(false);
        }

        protected Parameters(ProjectiveColorTransformer.Parameters surfaceParameters, ProjectiveColorTransformer.Parameters projectorParameters) {
            this.reset(surfaceParameters, projectorParameters);
        }

        public ProjectiveColorTransformer.Parameters getSurfaceParameters() {
            return this.surfaceParameters;
        }

        public ProjectiveColorTransformer.Parameters getProjectorParameters() {
            return this.projectorParameters;
        }

        private int getSizeForSurface() {
            return ProCamTransformer.this.surfaceTransformer == null ? 0 : this.surfaceParameters.size() - ProCamTransformer.this.surfaceTransformer.getNumGains() - ProCamTransformer.this.surfaceTransformer.getNumBiases();
        }

        private int getSizeForProjector() {
            return this.projectorParameters.size();
        }

        @Override
        public int size() {
            return this.getSizeForSurface() + this.getSizeForProjector();
        }

        @Override
        public double[] get() {
            double[] p = new double[this.size()];
            for (int i = 0; i < p.length; ++i) {
                p[i] = this.get(i);
            }
            return p;
        }

        @Override
        public double get(int i) {
            if (i < this.getSizeForSurface()) {
                return this.surfaceParameters.get(i);
            }
            return this.projectorParameters.get(i - this.getSizeForSurface());
        }

        @Override
        public void set(double ... p) {
            for (int i = 0; i < p.length; ++i) {
                this.set(i, p[i]);
            }
        }

        @Override
        public void set(int i, double p) {
            if (i < this.getSizeForSurface()) {
                this.surfaceParameters.set(i, p);
            } else {
                this.projectorParameters.set(i - this.getSizeForSurface(), p);
            }
        }

        @Override
        public void set(ImageTransformer.Parameters p) {
            Parameters pcp = (Parameters)p;
            if (ProCamTransformer.this.surfaceTransformer != null) {
                this.surfaceParameters.set(pcp.getSurfaceParameters());
                this.surfaceParameters.resetColor(false);
            }
            this.projectorParameters.set(pcp.getProjectorParameters());
        }

        @Override
        public void reset(boolean asIdentity) {
            this.reset(null, null);
        }

        public void reset(ProjectiveColorTransformer.Parameters surfaceParameters, ProjectiveColorTransformer.Parameters projectorParameters) {
            if (surfaceParameters == null && ProCamTransformer.this.surfaceTransformer != null) {
                surfaceParameters = ProCamTransformer.this.surfaceTransformer.createParameters();
            }
            if (projectorParameters == null) {
                projectorParameters = ProCamTransformer.this.projectorTransformer.createParameters();
            }
            this.surfaceParameters = surfaceParameters;
            this.projectorParameters = projectorParameters;
            this.setSubspace(this.getSubspace());
        }

        @Override
        public double getConstraintError() {
            double error = ProCamTransformer.this.surfaceTransformer == null ? 0.0 : this.surfaceParameters.getConstraintError();
            this.projectorParameters.update();
            return error;
        }

        @Override
        public void compose(ImageTransformer.Parameters p1, boolean inverse1, ImageTransformer.Parameters p2, boolean inverse2) {
            throw new UnsupportedOperationException("Compose operation not supported.");
        }

        @Override
        public boolean preoptimize() {
            double[] p = this.setSubspaceInternal(this.getSubspaceInternal());
            if (p != null) {
                this.set(8, p[8]);
                this.set(9, p[9]);
                this.set(10, p[10]);
                return true;
            }
            return false;
        }

        @Override
        public void setSubspace(double ... p) {
            double[] dst = this.setSubspaceInternal(p);
            if (dst != null) {
                this.set(dst);
            }
        }

        @Override
        public double[] getSubspace() {
            return this.getSubspaceInternal();
        }

        private double[] setSubspaceInternal(double ... p) {
            if (ProCamTransformer.this.invFrontoParallelH == null) {
                return null;
            }
            double[] dst = new double[11];
            this.t.put(new double[]{p[0], p[1], p[2]});
            opencv_calib3d.Rodrigues((opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.t), (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.R), null);
            this.t.put(new double[]{p[3], p[4], p[5]});
            this.H.put(new double[]{this.R.get(0), this.R.get(1), this.t.get(0), this.R.get(3), this.R.get(4), this.t.get(1), this.R.get(6), this.R.get(7), this.t.get(2)});
            opencv_core.cvMatMul((opencv_core.CvArr)this.H, (opencv_core.CvArr)ProCamTransformer.this.invFrontoParallelH, (opencv_core.CvArr)this.H);
            opencv_core.cvMatMul((opencv_core.CvArr)ProCamTransformer.this.surfaceTransformer.getK2(), (opencv_core.CvArr)this.H, (opencv_core.CvArr)this.H);
            opencv_core.cvMatMul((opencv_core.CvArr)this.H, (opencv_core.CvArr)ProCamTransformer.this.surfaceTransformer.getInvK1(), (opencv_core.CvArr)this.H);
            opencv_core.cvGEMM((opencv_core.CvArr)this.R, (opencv_core.CvArr)this.t, (double)1.0, null, (double)0.0, (opencv_core.CvArr)this.t, (int)1);
            double scale = 1.0 / this.t.get(2);
            this.n.put(new double[]{0.0, 0.0, 1.0});
            opencv_core.cvGEMM((opencv_core.CvArr)this.R, (opencv_core.CvArr)this.n, (double)scale, null, (double)0.0, (opencv_core.CvArr)this.n, (int)0);
            double[] src = ProCamTransformer.this.projectorTransformer.getReferencePoints2();
            JavaCV.perspectiveTransform(src, dst, ProCamTransformer.this.projectorTransformer.getInvK1(), ProCamTransformer.this.projectorTransformer.getK2(), ProCamTransformer.this.projectorTransformer.getR(), ProCamTransformer.this.projectorTransformer.getT(), this.n, true);
            dst[8] = dst[0];
            dst[9] = dst[2];
            dst[10] = dst[4];
            JavaCV.perspectiveTransform(ProCamTransformer.this.surfaceTransformer.getReferencePoints1(), dst, this.H);
            return dst;
        }

        private double[] getSubspaceInternal() {
            if (ProCamTransformer.this.frontoParallelH == null) {
                return null;
            }
            opencv_core.cvMatMul((opencv_core.CvArr)ProCamTransformer.this.surfaceTransformer.getK1(), (opencv_core.CvArr)ProCamTransformer.this.frontoParallelH, (opencv_core.CvArr)this.H);
            opencv_core.cvMatMul((opencv_core.CvArr)this.surfaceParameters.getH(), (opencv_core.CvArr)this.H, (opencv_core.CvArr)this.H);
            opencv_core.cvMatMul((opencv_core.CvArr)ProCamTransformer.this.surfaceTransformer.getInvK2(), (opencv_core.CvArr)this.H, (opencv_core.CvArr)this.H);
            JavaCV.HtoRt(this.H, this.R, this.t);
            opencv_calib3d.Rodrigues((opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.R), (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.n), null);
            double[] p = new double[]{this.n.get(0), this.n.get(1), this.n.get(2), this.t.get(0), this.t.get(1), this.t.get(2)};
            return p;
        }

        public opencv_core.CvMat getN() {
            double[] src = ProCamTransformer.this.projectorTransformer.getReferencePoints2();
            double[] dst = (double[])ProCamTransformer.this.projectorTransformer.getReferencePoints1().clone();
            dst[0] = this.projectorParameters.get(0);
            dst[2] = this.projectorParameters.get(1);
            dst[4] = this.projectorParameters.get(2);
            opencv_core.cvTranspose((opencv_core.CvArr)ProCamTransformer.this.projectorTransformer.getR(), (opencv_core.CvArr)this.R);
            opencv_core.cvGEMM((opencv_core.CvArr)this.R, (opencv_core.CvArr)ProCamTransformer.this.projectorTransformer.getT(), (double)-1.0, null, (double)0.0, (opencv_core.CvArr)this.t, (int)0);
            JavaCV.getPlaneParameters(src, dst, ProCamTransformer.this.projectorTransformer.getInvK2(), ProCamTransformer.this.projectorTransformer.getK1(), this.R, this.t, this.n);
            double d = 1.0 + opencv_core.cvDotProduct((opencv_core.CvArr)this.n, (opencv_core.CvArr)ProCamTransformer.this.projectorTransformer.getT());
            opencv_core.cvGEMM((opencv_core.CvArr)this.R, (opencv_core.CvArr)this.n, (double)(1.0 / d), null, (double)0.0, (opencv_core.CvArr)this.n, (int)0);
            return this.n;
        }

        public opencv_core.CvMat getN0() {
            this.n = this.getN();
            if (ProCamTransformer.this.surfaceTransformer == null) {
                return this.n;
            }
            ProCamTransformer.this.camera.getFrontoParallelH(this.surfaceParameters.get(), this.n, this.R);
            opencv_core.cvInvert((opencv_core.CvArr)this.surfaceParameters.getH(), (opencv_core.CvArr)this.H);
            opencv_core.cvMatMul((opencv_core.CvArr)this.H, (opencv_core.CvArr)ProCamTransformer.this.surfaceTransformer.getK2(), (opencv_core.CvArr)this.H);
            opencv_core.cvMatMul((opencv_core.CvArr)this.H, (opencv_core.CvArr)this.R, (opencv_core.CvArr)this.H);
            opencv_core.cvMatMul((opencv_core.CvArr)ProCamTransformer.this.surfaceTransformer.getInvK1(), (opencv_core.CvArr)this.H, (opencv_core.CvArr)this.H);
            JavaCV.HtoRt(this.H, this.R, this.t);
            opencv_core.cvGEMM((opencv_core.CvArr)this.R, (opencv_core.CvArr)this.t, (double)1.0, null, (double)0.0, (opencv_core.CvArr)this.t, (int)1);
            double scale = 1.0 / this.t.get(2);
            this.n.put(new double[]{0.0, 0.0, 1.0});
            opencv_core.cvGEMM((opencv_core.CvArr)this.R, (opencv_core.CvArr)this.n, (double)scale, null, (double)0.0, (opencv_core.CvArr)this.n, (int)0);
            return this.n;
        }

        @Override
        public Parameters clone() {
            Parameters p = new Parameters();
            p.surfaceParameters = this.surfaceParameters == null ? null : this.surfaceParameters.clone();
            p.projectorParameters = this.projectorParameters.clone();
            return p;
        }

        public String toString() {
            if (this.surfaceParameters != null) {
                return this.surfaceParameters.toString() + this.projectorParameters.toString();
            }
            return this.projectorParameters.toString();
        }

        static /* synthetic */ opencv_core.IplImage[] access$002(Parameters x0, opencv_core.IplImage[] x1) {
            x0.tempImage = x1;
            return x1;
        }
    }
}

