/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.io.File;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_calib3d;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.BaseChildSettings;
import org.bytedeco.javacv.CameraDevice;
import org.bytedeco.javacv.JavaCV;
import org.bytedeco.javacv.ProjectorDevice;

public class ProjectiveDevice {
    private Settings settings;
    public int imageWidth = 0;
    public int imageHeight = 0;
    public opencv_core.CvMat cameraMatrix = null;
    public opencv_core.CvMat distortionCoeffs = null;
    public opencv_core.CvMat extrParams = null;
    public opencv_core.CvMat reprojErrs = null;
    public double avgReprojErr;
    public double maxReprojErr;
    public opencv_core.CvMat R = null;
    public opencv_core.CvMat T = null;
    public opencv_core.CvMat E = null;
    public opencv_core.CvMat F = null;
    public double avgEpipolarErr;
    public double maxEpipolarErr;
    public String colorOrder = "BGR";
    public opencv_core.CvMat colorMixingMatrix = null;
    public opencv_core.CvMat additiveLight = null;
    public double avgColorErr;
    public double colorR2 = 1.0;
    private boolean fixedPointMaps = false;
    private int mapsPyramidLevel = 0;
    private opencv_core.IplImage[] undistortMaps1 = new opencv_core.IplImage[]{null};
    private opencv_core.IplImage[] undistortMaps2 = new opencv_core.IplImage[]{null};
    private opencv_core.IplImage[] distortMaps1 = new opencv_core.IplImage[]{null};
    private opencv_core.IplImage[] distortMaps2 = new opencv_core.IplImage[]{null};
    private opencv_core.IplImage tempImage = null;
    private static ThreadLocal<opencv_core.CvMat> temp3x3 = opencv_core.CvMat.createThreadLocal((int)3, (int)3);
    private static ThreadLocal<opencv_core.CvMat> B4x3 = opencv_core.CvMat.createThreadLocal((int)4, (int)3);
    private static ThreadLocal<opencv_core.CvMat> a4x1 = opencv_core.CvMat.createThreadLocal((int)4, (int)1);
    private static ThreadLocal<opencv_core.CvMat> t3x1 = opencv_core.CvMat.createThreadLocal((int)3, (int)1);
    private static ThreadLocal<opencv_core.CvMat> relativeR3x3 = opencv_core.CvMat.createThreadLocal((int)3, (int)3);
    private static ThreadLocal<opencv_core.CvMat> relativeT3x1 = opencv_core.CvMat.createThreadLocal((int)3, (int)1);
    private static ThreadLocal<opencv_core.CvMat> R13x3 = opencv_core.CvMat.createThreadLocal((int)3, (int)3);
    private static ThreadLocal<opencv_core.CvMat> P13x4 = opencv_core.CvMat.createThreadLocal((int)3, (int)4);
    private static ThreadLocal<opencv_core.CvMat> R23x3 = opencv_core.CvMat.createThreadLocal((int)3, (int)3);
    private static ThreadLocal<opencv_core.CvMat> P23x4 = opencv_core.CvMat.createThreadLocal((int)3, (int)4);

    public ProjectiveDevice(String name) {
        Settings s = new Settings();
        s.name = name;
        this.setSettings(s);
    }

    public ProjectiveDevice(String name, File file) throws Exception {
        this(name);
        this.readParameters(file);
    }

    public ProjectiveDevice(String name, String filename) throws Exception {
        this(name);
        this.readParameters(filename);
    }

    public ProjectiveDevice(String name, opencv_core.FileStorage fs) throws Exception {
        this(name);
        this.readParameters(fs);
    }

    public ProjectiveDevice(Settings settings) throws Exception {
        this.setSettings(settings);
        if (settings instanceof CalibratedSettings) {
            this.readParameters(((CalibratedSettings)settings).parametersFile);
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void rescale(int imageWidth, int imageHeight) {
        if ((imageWidth != this.imageWidth || imageHeight != this.imageHeight) && this.cameraMatrix != null) {
            double sx = (double)imageWidth / (double)this.imageWidth;
            double sy = (double)imageHeight / (double)this.imageHeight;
            this.cameraMatrix.put(0, sx * this.cameraMatrix.get(0));
            this.cameraMatrix.put(1, sx * this.cameraMatrix.get(1));
            this.cameraMatrix.put(2, sx * this.cameraMatrix.get(2));
            this.cameraMatrix.put(3, sy * this.cameraMatrix.get(3));
            this.cameraMatrix.put(4, sy * this.cameraMatrix.get(4));
            this.cameraMatrix.put(5, sy * this.cameraMatrix.get(5));
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            int p = this.mapsPyramidLevel;
            this.distortMaps2[p] = null;
            this.distortMaps1[p] = null;
            this.undistortMaps2[p] = null;
            this.undistortMaps1[p] = null;
        }
    }

    public int[] getRGBColorOrder() {
        int[] order = new int[3];
        block5: for (int i = 0; i < 3; ++i) {
            switch (Character.toUpperCase(this.colorOrder.charAt(i))) {
                case 'B': {
                    order[i] = 2;
                    continue block5;
                }
                case 'G': {
                    order[i] = 1;
                    continue block5;
                }
                case 'R': {
                    order[i] = 0;
                    continue block5;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
        return order;
    }

    public static double[] undistort(double[] xd, double[] k) {
        double k1 = k[0];
        double k2 = k[1];
        double k3 = k.length > 4 ? k[4] : 0.0;
        double k4 = k.length > 5 ? k[5] : 0.0;
        double k5 = k.length > 6 ? k[6] : 0.0;
        double k6 = k.length > 7 ? k[7] : 0.0;
        double p1 = k[2];
        double p2 = k[3];
        double[] xu = (double[])xd.clone();
        for (int i = 0; i < xd.length / 2; ++i) {
            double x = xu[i * 2];
            double y = xu[i * 2 + 1];
            double xo = xd[i * 2];
            double yo = xd[i * 2 + 1];
            for (int j = 0; j < 20; ++j) {
                double r_2 = x * x + y * y;
                double k_radial = 1.0 + k1 * r_2 + k2 * r_2 * r_2 + k3 * r_2 * r_2 * r_2;
                double delta_x = 2.0 * p1 * x * y + p2 * (r_2 + 2.0 * x * x);
                double delta_y = p1 * (r_2 + 2.0 * y * y) + 2.0 * p2 * x * y;
                x = (xo - delta_x) / k_radial;
                y = (yo - delta_y) / k_radial;
            }
            xu[i * 2] = x;
            xu[i * 2 + 1] = y;
        }
        return xu;
    }

    public double[] undistort(double ... x) {
        double[] xn = ProjectiveDevice.normalize(x, this.cameraMatrix);
        double[] xu = ProjectiveDevice.undistort(xn, this.distortionCoeffs.get());
        return ProjectiveDevice.unnormalize(xu, this.cameraMatrix);
    }

    public static double[] distort(double[] xu, double[] k) {
        double k1 = k[0];
        double k2 = k[1];
        double k3 = k.length > 4 ? k[4] : 0.0;
        double k4 = k.length > 5 ? k[5] : 0.0;
        double k5 = k.length > 6 ? k[6] : 0.0;
        double k6 = k.length > 7 ? k[7] : 0.0;
        double p1 = k[2];
        double p2 = k[3];
        double[] xd = (double[])xu.clone();
        for (int i = 0; i < xu.length / 2; ++i) {
            double x = xu[i * 2];
            double y = xu[i * 2 + 1];
            double r_2 = x * x + y * y;
            double k_radial = 1.0 + k1 * r_2 + k2 * r_2 * r_2 + k3 * r_2 * r_2 * r_2;
            double delta_x = 2.0 * p1 * x * y + p2 * (r_2 + 2.0 * x * x);
            double delta_y = p1 * (r_2 + 2.0 * y * y) + 2.0 * p2 * x * y;
            xd[i * 2] = x * k_radial + delta_x;
            xd[i * 2 + 1] = y * k_radial + delta_y;
        }
        return xd;
    }

    public double[] distort(double ... x) {
        double[] xn = ProjectiveDevice.normalize(x, this.cameraMatrix);
        double[] xd = ProjectiveDevice.distort(xn, this.distortionCoeffs.get());
        return ProjectiveDevice.unnormalize(xd, this.cameraMatrix);
    }

    public static double[] normalize(double[] xu, opencv_core.CvMat K) {
        double[] xn = (double[])xu.clone();
        double fx = K.get(0) / K.get(8);
        double fy = K.get(4) / K.get(8);
        double dx = K.get(2) / K.get(8);
        double dy = K.get(5) / K.get(8);
        double s = K.get(1) / K.get(8);
        for (int i = 0; i < xu.length / 2; ++i) {
            xn[i * 2] = (xu[i * 2] - dx) / fx - s * (xu[i * 2 + 1] + dy) / (fx * fy);
            xn[i * 2 + 1] = (xu[i * 2 + 1] - dy) / fy;
        }
        return xn;
    }

    public static double[] unnormalize(double[] xn, opencv_core.CvMat K) {
        double[] xu = (double[])xn.clone();
        double fx = K.get(0) / K.get(8);
        double fy = K.get(4) / K.get(8);
        double dx = K.get(2) / K.get(8);
        double dy = K.get(5) / K.get(8);
        double s = K.get(1) / K.get(8);
        for (int i = 0; i < xn.length / 2; ++i) {
            xu[i * 2] = fx * xn[i * 2] + dx + s * xn[i * 2 + 1];
            xu[i * 2 + 1] = fy * xn[i * 2 + 1] + dy;
        }
        return xu;
    }

    public boolean isFixedPointMaps() {
        return this.fixedPointMaps;
    }

    public void setFixedPointMaps(boolean fixedPointMaps) {
        if (this.fixedPointMaps != fixedPointMaps) {
            this.fixedPointMaps = fixedPointMaps;
            int p = this.mapsPyramidLevel;
            this.distortMaps2[p] = null;
            this.distortMaps1[p] = null;
            this.undistortMaps2[p] = null;
            this.undistortMaps1[p] = null;
        }
    }

    public int getMapsPyramidLevel() {
        return this.mapsPyramidLevel;
    }

    public void setMapsPyramidLevel(int mapsPyramidLevel) {
        if (this.mapsPyramidLevel != mapsPyramidLevel) {
            this.mapsPyramidLevel = mapsPyramidLevel;
            int p = mapsPyramidLevel;
            if (p >= this.undistortMaps1.length || p >= this.undistortMaps2.length || p >= this.distortMaps1.length || p >= this.distortMaps2.length) {
                this.undistortMaps1 = Arrays.copyOf(this.undistortMaps1, p + 1);
                this.undistortMaps2 = Arrays.copyOf(this.undistortMaps2, p + 1);
                this.distortMaps1 = Arrays.copyOf(this.distortMaps1, p + 1);
                this.distortMaps2 = Arrays.copyOf(this.distortMaps2, p + 1);
            }
        }
    }

    private void initUndistortMaps() {
        int p = this.mapsPyramidLevel;
        if (this.undistortMaps1[p] == null || this.undistortMaps2[p] == null) {
            if (this.fixedPointMaps) {
                this.undistortMaps1[p] = opencv_core.IplImage.create((int)this.imageWidth, (int)this.imageHeight, (int)-2147483632, (int)2);
                this.undistortMaps2[p] = opencv_core.IplImage.create((int)this.imageWidth, (int)this.imageHeight, (int)16, (int)1);
            } else {
                this.undistortMaps1[p] = opencv_core.IplImage.create((int)this.imageWidth, (int)this.imageHeight, (int)32, (int)1);
                this.undistortMaps2[p] = opencv_core.IplImage.create((int)this.imageWidth, (int)this.imageHeight, (int)32, (int)1);
            }
            opencv_core.Mat A = opencv_core.cvarrToMat((opencv_core.CvArr)this.cameraMatrix);
            opencv_core.Mat m1 = opencv_core.cvarrToMat((opencv_core.CvArr)this.undistortMaps1[p]);
            opencv_core.Mat m2 = opencv_core.cvarrToMat((opencv_core.CvArr)this.undistortMaps2[p]);
            opencv_calib3d.initUndistortRectifyMap((opencv_core.Mat)A, (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.distortionCoeffs), (opencv_core.Mat)new opencv_core.Mat(), (opencv_core.Mat)A, (opencv_core.Size)m1.size(), (int)m1.type(), (opencv_core.Mat)m1, (opencv_core.Mat)m2);
            if (this.mapsPyramidLevel > 0) {
                opencv_core.IplImage map1 = this.undistortMaps1[p];
                opencv_core.IplImage map2 = this.undistortMaps2[p];
                int w = this.imageWidth >> p;
                int h = this.imageHeight >> p;
                this.undistortMaps1[p] = opencv_core.IplImage.create((int)w, (int)h, (int)map1.depth(), (int)map1.nChannels());
                this.undistortMaps2[p] = opencv_core.IplImage.create((int)w, (int)h, (int)map2.depth(), (int)map2.nChannels());
                opencv_imgproc.cvResize((opencv_core.CvArr)map1, (opencv_core.CvArr)this.undistortMaps1[p], (int)0);
                opencv_imgproc.cvResize((opencv_core.CvArr)map2, (opencv_core.CvArr)this.undistortMaps2[p], (int)0);
            }
        }
    }

    public opencv_core.IplImage getUndistortMap1() {
        this.initUndistortMaps();
        return this.undistortMaps1[this.mapsPyramidLevel];
    }

    public opencv_core.IplImage getUndistortMap2() {
        this.initUndistortMaps();
        return this.undistortMaps2[this.mapsPyramidLevel];
    }

    public void undistort(opencv_core.IplImage src, opencv_core.IplImage dst) {
        if (src != null && dst != null) {
            this.initUndistortMaps();
            opencv_imgproc.cvRemap((opencv_core.CvArr)src, (opencv_core.CvArr)dst, (opencv_core.CvArr)this.undistortMaps1[this.mapsPyramidLevel], (opencv_core.CvArr)this.undistortMaps2[this.mapsPyramidLevel], (int)9, (opencv_core.CvScalar)opencv_core.CvScalar.ZERO);
        }
    }

    public opencv_core.IplImage undistort(opencv_core.IplImage image) {
        if (image != null) {
            this.initUndistortMaps();
            this.tempImage = opencv_core.IplImage.createIfNotCompatible((opencv_core.IplImage)this.tempImage, (opencv_core.IplImage)image);
            opencv_core.cvResetImageROI((opencv_core.IplImage)this.tempImage);
            opencv_imgproc.cvRemap((opencv_core.CvArr)image, (opencv_core.CvArr)this.tempImage, (opencv_core.CvArr)this.undistortMaps1[this.mapsPyramidLevel], (opencv_core.CvArr)this.undistortMaps2[this.mapsPyramidLevel], (int)9, (opencv_core.CvScalar)opencv_core.CvScalar.ZERO);
            return this.tempImage;
        }
        return null;
    }

    private void initDistortMaps() {
        int p = this.mapsPyramidLevel;
        if (this.distortMaps1[p] == null || this.distortMaps2[p] == null) {
            opencv_core.IplImage mapx = opencv_core.IplImage.create((int)this.imageWidth, (int)this.imageHeight, (int)32, (int)1);
            opencv_core.IplImage mapy = opencv_core.IplImage.create((int)this.imageWidth, (int)this.imageHeight, (int)32, (int)1);
            FloatBuffer bufx = mapx.getFloatBuffer();
            FloatBuffer bufy = mapy.getFloatBuffer();
            int width = mapx.width();
            int height = mapx.height();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    double[] distxy = this.undistort(x, y);
                    bufx.put((float)distxy[0]);
                    bufy.put((float)distxy[1]);
                }
            }
            if (this.fixedPointMaps) {
                this.distortMaps1[p] = opencv_core.IplImage.create((int)this.imageWidth, (int)this.imageHeight, (int)-2147483632, (int)2);
                this.distortMaps2[p] = opencv_core.IplImage.create((int)this.imageWidth, (int)this.imageHeight, (int)16, (int)1);
                opencv_imgproc.cvConvertMaps((opencv_core.CvArr)mapx, (opencv_core.CvArr)mapy, (opencv_core.CvArr)this.distortMaps1[p], (opencv_core.CvArr)this.distortMaps2[p]);
                mapx.release();
                mapy.release();
            } else {
                this.distortMaps1[p] = mapx;
                this.distortMaps2[p] = mapy;
            }
            if (this.mapsPyramidLevel > 0) {
                opencv_core.IplImage map1 = this.distortMaps1[p];
                opencv_core.IplImage map2 = this.distortMaps2[p];
                int w = this.imageWidth >> p;
                int h = this.imageHeight >> p;
                this.distortMaps1[p] = opencv_core.IplImage.create((int)w, (int)h, (int)map1.depth(), (int)map1.nChannels());
                this.distortMaps2[p] = opencv_core.IplImage.create((int)w, (int)h, (int)map2.depth(), (int)map2.nChannels());
                opencv_imgproc.cvResize((opencv_core.CvArr)map1, (opencv_core.CvArr)this.distortMaps1[p], (int)0);
                opencv_imgproc.cvResize((opencv_core.CvArr)map2, (opencv_core.CvArr)this.distortMaps2[p], (int)0);
            }
        }
    }

    public opencv_core.IplImage getDistortMap1() {
        this.initDistortMaps();
        return this.distortMaps1[this.mapsPyramidLevel];
    }

    public opencv_core.IplImage getDistortMap2() {
        this.initDistortMaps();
        return this.distortMaps2[this.mapsPyramidLevel];
    }

    public void distort(opencv_core.IplImage src, opencv_core.IplImage dst) {
        if (src != null && dst != null) {
            this.initDistortMaps();
            opencv_imgproc.cvRemap((opencv_core.CvArr)src, (opencv_core.CvArr)dst, (opencv_core.CvArr)this.distortMaps1[this.mapsPyramidLevel], (opencv_core.CvArr)this.distortMaps2[this.mapsPyramidLevel], (int)9, (opencv_core.CvScalar)opencv_core.CvScalar.ZERO);
        }
    }

    public opencv_core.IplImage distort(opencv_core.IplImage image) {
        if (image != null) {
            this.initDistortMaps();
            this.tempImage = opencv_core.IplImage.createIfNotCompatible((opencv_core.IplImage)this.tempImage, (opencv_core.IplImage)image);
            opencv_imgproc.cvRemap((opencv_core.CvArr)image, (opencv_core.CvArr)this.tempImage, (opencv_core.CvArr)this.distortMaps1[this.mapsPyramidLevel], (opencv_core.CvArr)this.distortMaps2[this.mapsPyramidLevel], (int)9, (opencv_core.CvScalar)opencv_core.CvScalar.ZERO);
            return this.tempImage;
        }
        return null;
    }

    public opencv_core.CvMat getBackProjectionMatrix(opencv_core.CvMat n, double d, opencv_core.CvMat B) {
        opencv_core.CvMat temp = temp3x3.get();
        temp.cols(1);
        temp.step(temp.step() / 3);
        B.rows(3);
        opencv_core.cvGEMM((opencv_core.CvArr)this.R, (opencv_core.CvArr)this.T, (double)-1.0, null, (double)0.0, (opencv_core.CvArr)temp, (int)1);
        opencv_core.cvGEMM((opencv_core.CvArr)temp, (opencv_core.CvArr)n, (double)1.0, null, (double)0.0, (opencv_core.CvArr)B, (int)2);
        double a = opencv_core.cvDotProduct((opencv_core.CvArr)n, (opencv_core.CvArr)temp) + d;
        B.put(0, B.get(0) - a);
        B.put(4, B.get(4) - a);
        B.put(8, B.get(8) - a);
        B.rows(4);
        temp.cols(3);
        temp.step(temp.step() * 3);
        B.put(9, n.get());
        opencv_core.cvMatMul((opencv_core.CvArr)this.cameraMatrix, (opencv_core.CvArr)this.R, (opencv_core.CvArr)temp);
        opencv_core.cvInvert((opencv_core.CvArr)temp, (opencv_core.CvArr)temp, (int)0);
        opencv_core.cvMatMul((opencv_core.CvArr)B, (opencv_core.CvArr)temp, (opencv_core.CvArr)B);
        opencv_core.cvConvertScale((opencv_core.CvArr)B, (opencv_core.CvArr)B, (double)(1.0 / B.get(11)), (double)0.0);
        return B;
    }

    public opencv_core.CvMat getFrontoParallelH(double[] roipts, opencv_core.CvMat n, opencv_core.CvMat H) {
        opencv_core.CvMat B = B4x3.get();
        opencv_core.CvMat a = a4x1.get();
        opencv_core.CvMat t = t3x1.get();
        double s = Math.signum(n.get(2));
        double[] dir = JavaCV.unitize(-s * n.get(1), s * n.get(0));
        double theta = Math.acos(s * n.get(2) / JavaCV.norm(n.get()));
        t.put(new double[]{theta * dir[0], theta * dir[1], 0.0});
        opencv_calib3d.Rodrigues((opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)t), (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)H), null);
        opencv_core.cvMatMul((opencv_core.CvArr)this.R, (opencv_core.CvArr)H, (opencv_core.CvArr)H);
        double x = 0.0;
        double y = 0.0;
        if (roipts != null) {
            double x1 = roipts[0];
            double y1 = roipts[1];
            double x2 = roipts[4];
            double y2 = roipts[5];
            double x3 = roipts[2];
            double y3 = roipts[3];
            double x4 = roipts[6];
            double y4 = roipts[7];
            double u = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / ((y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1));
            x = x1 + u * (x2 - x1);
            y = y1 + u * (y2 - y1);
        }
        this.getBackProjectionMatrix(n, -1.0, B);
        t.put(new double[]{x, y, 1.0});
        opencv_core.cvMatMul((opencv_core.CvArr)B, (opencv_core.CvArr)t, (opencv_core.CvArr)a);
        H.put(2, a.get(0) / a.get(3));
        H.put(5, a.get(1) / a.get(3));
        H.put(8, a.get(2) / a.get(3));
        return H;
    }

    public opencv_core.CvMat getRectifyingHomography(ProjectiveDevice peer, opencv_core.CvMat H) {
        opencv_core.CvMat relativeR = relativeR3x3.get();
        opencv_core.CvMat relativeT = relativeT3x1.get();
        opencv_core.cvGEMM((opencv_core.CvArr)this.R, (opencv_core.CvArr)peer.R, (double)1.0, null, (double)0.0, (opencv_core.CvArr)relativeR, (int)2);
        opencv_core.cvGEMM((opencv_core.CvArr)relativeR, (opencv_core.CvArr)peer.T, (double)-1.0, (opencv_core.CvArr)this.T, (double)1.0, (opencv_core.CvArr)relativeT, (int)0);
        opencv_core.CvMat R1 = R13x3.get();
        opencv_core.CvMat P1 = P13x4.get();
        opencv_core.CvMat R2 = R23x3.get();
        opencv_core.CvMat P2 = P23x4.get();
        opencv_core.Size imageSize = new opencv_core.Size((peer.imageWidth + this.imageWidth) / 2, (peer.imageHeight + this.imageHeight) / 2);
        opencv_calib3d.stereoRectify((opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)peer.cameraMatrix), (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.cameraMatrix), (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)peer.distortionCoeffs), (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.distortionCoeffs), (opencv_core.Size)imageSize, (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)relativeR), (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)relativeT), (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)R1), (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)R2), (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)P1), (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)P2), (opencv_core.Mat)new opencv_core.Mat(), (int)0, (double)-1.0, (opencv_core.Size)new opencv_core.Size(), null, null);
        opencv_core.cvMatMul((opencv_core.CvArr)this.cameraMatrix, (opencv_core.CvArr)R2, (opencv_core.CvArr)R2);
        opencv_core.cvInvert((opencv_core.CvArr)this.cameraMatrix, (opencv_core.CvArr)R1);
        opencv_core.cvMatMul((opencv_core.CvArr)R2, (opencv_core.CvArr)R1, (opencv_core.CvArr)H);
        return H;
    }

    public static ProjectiveDevice[] read(String filename) throws Exception {
        opencv_core.FileStorage fs = new opencv_core.FileStorage(filename, 0);
        CameraDevice[] cameraDevices = CameraDevice.read(fs);
        ProjectorDevice[] projectorDevices = ProjectorDevice.read(fs);
        ProjectiveDevice[] devices = new ProjectiveDevice[cameraDevices.length + projectorDevices.length];
        int i = 0;
        for (CameraDevice cameraDevice : cameraDevices) {
            devices[i++] = cameraDevice;
        }
        for (ProjectiveDevice projectiveDevice : projectorDevices) {
            devices[i++] = projectiveDevice;
        }
        fs.release();
        return devices;
    }

    public static void write(String filename, ProjectiveDevice[] ... devices) {
        int totalLength = 0;
        for (ProjectiveDevice[] ds : devices) {
            totalLength += ds.length;
        }
        ProjectiveDevice[] allDevices = new ProjectiveDevice[totalLength];
        int i = 0;
        ProjectiveDevice[][] projectiveDeviceArray = devices;
        int n = projectiveDeviceArray.length;
        for (int j = 0; j < n; ++j) {
            ProjectiveDevice[] ds;
            for (ProjectiveDevice d : ds = projectiveDeviceArray[j]) {
                allDevices[i++] = d;
            }
        }
        ProjectiveDevice.write(filename, allDevices);
    }

    public static void write(String filename, ProjectiveDevice ... devices) {
        opencv_core.FileStorage fs = new opencv_core.FileStorage(filename, 1);
        opencv_core.shiftLeft((opencv_core.FileStorage)opencv_core.shiftLeft((opencv_core.FileStorage)fs, (String)"Cameras"), (String)"[");
        for (ProjectiveDevice d : devices) {
            if (!(d instanceof CameraDevice)) continue;
            opencv_core.write((opencv_core.FileStorage)fs, (String)d.getSettings().getName());
        }
        opencv_core.shiftLeft((opencv_core.FileStorage)fs, (String)"]");
        opencv_core.shiftLeft((opencv_core.FileStorage)opencv_core.shiftLeft((opencv_core.FileStorage)fs, (String)"Projectors"), (String)"[");
        for (ProjectiveDevice d : devices) {
            if (!(d instanceof ProjectorDevice)) continue;
            opencv_core.write((opencv_core.FileStorage)fs, (String)d.getSettings().getName());
        }
        opencv_core.shiftLeft((opencv_core.FileStorage)fs, (String)"]");
        for (ProjectiveDevice d : devices) {
            d.writeParameters(fs);
        }
        fs.release();
    }

    public void writeParameters(File file) {
        this.writeParameters(file.getAbsolutePath());
    }

    public void writeParameters(String filename) {
        opencv_core.FileStorage fs = new opencv_core.FileStorage(filename, 1);
        this.writeParameters(fs);
        fs.release();
    }

    public void writeParameters(opencv_core.FileStorage fs) {
        opencv_core.shiftLeft((opencv_core.FileStorage)opencv_core.shiftLeft((opencv_core.FileStorage)fs, (String)this.getSettings().getName()), (String)"{");
        opencv_core.write((opencv_core.FileStorage)fs, (String)"imageWidth", (int)this.imageWidth);
        opencv_core.write((opencv_core.FileStorage)fs, (String)"imageHeight", (int)this.imageHeight);
        opencv_core.write((opencv_core.FileStorage)fs, (String)"responseGamma", (double)this.getSettings().getResponseGamma());
        if (this.cameraMatrix != null) {
            opencv_core.write((opencv_core.FileStorage)fs, (String)"cameraMatrix", (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.cameraMatrix));
        }
        if (this.distortionCoeffs != null) {
            opencv_core.write((opencv_core.FileStorage)fs, (String)"distortionCoeffs", (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.distortionCoeffs));
        }
        if (this.extrParams != null) {
            opencv_core.write((opencv_core.FileStorage)fs, (String)"extrParams", (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.extrParams));
        }
        if (this.reprojErrs != null) {
            opencv_core.write((opencv_core.FileStorage)fs, (String)"reprojErrs", (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.reprojErrs));
        }
        opencv_core.write((opencv_core.FileStorage)fs, (String)"avgReprojErr", (double)this.avgReprojErr);
        opencv_core.write((opencv_core.FileStorage)fs, (String)"maxReprojErr", (double)this.maxReprojErr);
        if (this.R != null) {
            opencv_core.write((opencv_core.FileStorage)fs, (String)"R", (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.R));
        }
        if (this.T != null) {
            opencv_core.write((opencv_core.FileStorage)fs, (String)"T", (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.T));
        }
        if (this.E != null) {
            opencv_core.write((opencv_core.FileStorage)fs, (String)"E", (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.E));
        }
        if (this.F != null) {
            opencv_core.write((opencv_core.FileStorage)fs, (String)"F", (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.F));
        }
        opencv_core.write((opencv_core.FileStorage)fs, (String)"avgEpipolarErr", (double)this.avgEpipolarErr);
        opencv_core.write((opencv_core.FileStorage)fs, (String)"maxEpipolarErr", (double)this.maxEpipolarErr);
        opencv_core.write((opencv_core.FileStorage)fs, (String)"colorOrder", (String)this.colorOrder);
        if (this.colorMixingMatrix != null) {
            opencv_core.write((opencv_core.FileStorage)fs, (String)"colorMixingMatrix", (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.colorMixingMatrix));
        }
        if (this.additiveLight != null) {
            opencv_core.write((opencv_core.FileStorage)fs, (String)"additiveLight", (opencv_core.Mat)opencv_core.cvarrToMat((opencv_core.CvArr)this.additiveLight));
        }
        opencv_core.write((opencv_core.FileStorage)fs, (String)"avgColorErr", (double)this.avgColorErr);
        opencv_core.write((opencv_core.FileStorage)fs, (String)"colorR2", (double)this.colorR2);
        opencv_core.shiftLeft((opencv_core.FileStorage)fs, (String)"}");
    }

    public void readParameters(File file) throws Exception {
        this.readParameters(file.getAbsolutePath());
    }

    public void readParameters(String filename) throws Exception {
        opencv_core.FileStorage fs = new opencv_core.FileStorage(filename, 0);
        this.readParameters(fs);
        fs.release();
    }

    public void readParameters(opencv_core.FileStorage fs) throws Exception {
        if (fs == null) {
            throw new Exception("Error: FileStorage is null, cannot read parameters for device " + this.getSettings().getName() + ". Is the parametersFile correct?");
        }
        opencv_core.FileNode fn = fs.get(this.getSettings().getName());
        if (fn == null) {
            throw new Exception("Error: FileNode is null, cannot read parameters for device " + this.getSettings().getName() + ". Is the name correct?");
        }
        opencv_core.FileNode n = fn.get("imageWidth");
        if (n.isInt()) {
            this.imageWidth = n.asInt();
        }
        if ((n = fn.get("imageHeight")).isInt()) {
            this.imageHeight = n.asInt();
        }
        if ((n = fn.get("gamma")).isReal()) {
            this.getSettings().setResponseGamma(n.asDouble());
        }
        opencv_core.Mat m = new opencv_core.Mat();
        opencv_core.read((opencv_core.FileNode)fn.get("cameraMatrix"), (opencv_core.Mat)m);
        this.cameraMatrix = m.empty() ? null : opencv_core.cvMat((opencv_core.Mat)m).clone();
        opencv_core.read((opencv_core.FileNode)fn.get("distortionCoeffs"), (opencv_core.Mat)m);
        this.distortionCoeffs = m.empty() ? null : opencv_core.cvMat((opencv_core.Mat)m).clone();
        opencv_core.read((opencv_core.FileNode)fn.get("extrParams"), (opencv_core.Mat)m);
        this.extrParams = m.empty() ? null : opencv_core.cvMat((opencv_core.Mat)m).clone();
        opencv_core.read((opencv_core.FileNode)fn.get("reprojErrs"), (opencv_core.Mat)m);
        this.reprojErrs = m.empty() ? null : opencv_core.cvMat((opencv_core.Mat)m).clone();
        n = fn.get("avgReprojErr");
        if (n.isReal()) {
            this.avgReprojErr = n.asDouble();
        }
        if ((n = fn.get("maxReprojErr")).isReal()) {
            this.maxReprojErr = n.asDouble();
        }
        opencv_core.read((opencv_core.FileNode)fn.get("R"), (opencv_core.Mat)m);
        this.R = m.empty() ? null : opencv_core.cvMat((opencv_core.Mat)m).clone();
        opencv_core.read((opencv_core.FileNode)fn.get("T"), (opencv_core.Mat)m);
        this.T = m.empty() ? null : opencv_core.cvMat((opencv_core.Mat)m).clone();
        opencv_core.read((opencv_core.FileNode)fn.get("E"), (opencv_core.Mat)m);
        this.E = m.empty() ? null : opencv_core.cvMat((opencv_core.Mat)m).clone();
        opencv_core.read((opencv_core.FileNode)fn.get("F"), (opencv_core.Mat)m);
        this.F = m.empty() ? null : opencv_core.cvMat((opencv_core.Mat)m).clone();
        n = fn.get("avgEpipolarErr");
        if (n.isReal()) {
            this.avgEpipolarErr = n.asDouble();
        }
        if ((n = fn.get("maxEpipolarErr")).isReal()) {
            this.maxEpipolarErr = n.asDouble();
        }
        if ((n = fn.get("colorOrder")).isString()) {
            this.colorOrder = n.asBytePointer().getString();
        }
        opencv_core.read((opencv_core.FileNode)fn.get("colorMixingMatrix"), (opencv_core.Mat)m);
        this.colorMixingMatrix = m.empty() ? null : opencv_core.cvMat((opencv_core.Mat)m).clone();
        opencv_core.read((opencv_core.FileNode)fn.get("additiveLight"), (opencv_core.Mat)m);
        this.additiveLight = m.empty() ? null : opencv_core.cvMat((opencv_core.Mat)m).clone();
        n = fn.get("avgColorErr");
        if (n.isReal()) {
            this.avgColorErr = n.asDouble();
        }
        if ((n = fn.get("colorR2")).isReal()) {
            this.colorR2 = n.asDouble();
        }
    }

    public String toString() {
        String s = this.getSettings().getName() + " (" + this.imageWidth + " x " + this.imageHeight + ")\n";
        for (int i = 0; i < this.getSettings().getName().length(); ++i) {
            s = s + "=";
        }
        s = s + "\nIntrinsics\n----------\ncamera matrix = " + (this.cameraMatrix == null ? "null" : this.cameraMatrix.toString(16)) + "\ndistortion coefficients = " + (this.distortionCoeffs == null ? "null" : this.distortionCoeffs) + "\nreprojection RMS/max error (pixels) = " + (float)this.avgReprojErr + " / " + (float)this.maxReprojErr + "\n\nExtrinsics\n----------\nrotation = " + (this.R == null ? "null" : this.R.toString(11)) + "\ntranslation = " + (this.T == null ? "null" : this.T.toString(14)) + "\nepipolar RMS/max error (pixels) = " + (float)this.avgEpipolarErr + " / " + (float)this.maxEpipolarErr + "\n\nColor\n-----\norder = " + this.colorOrder + "\nmixing matrix = " + (this.colorMixingMatrix == null ? "null" : this.colorMixingMatrix.toString(16)) + "\nadditive light = " + (this.additiveLight == null ? "null" : this.additiveLight.toString(17)) + "\nnormalized RMSE (intensity) = " + (float)this.avgColorErr + "\nR^2 (intensity) = " + (float)this.colorR2;
        return s;
    }

    public static class Exception
    extends java.lang.Exception {
        public Exception(String message) {
            super(message);
        }

        public Exception(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class CalibratedSettings
    extends Settings {
        File parametersFile = new File("calibration.yaml");

        public CalibratedSettings() {
        }

        public CalibratedSettings(CalibratedSettings settings) {
            super(settings);
            this.parametersFile = settings.parametersFile;
        }

        public File getParametersFile() {
            return this.parametersFile;
        }

        public void setParametersFile(File parametersFile) {
            this.parametersFile = parametersFile;
        }

        public String getParametersFilename() {
            return this.parametersFile == null ? "" : this.parametersFile.getPath();
        }

        public void setParametersFilename(String parametersFilename) {
            this.parametersFile = parametersFilename == null || parametersFilename.length() == 0 ? null : new File(parametersFilename);
        }
    }

    public static class CalibrationSettings
    extends Settings {
        double initAspectRatio = 1.0;
        int flags = 14720;

        public CalibrationSettings() {
        }

        public CalibrationSettings(CalibrationSettings settings) {
            super(settings);
            this.initAspectRatio = settings.initAspectRatio;
            this.flags = settings.flags;
        }

        public double getInitAspectRatio() {
            return this.initAspectRatio;
        }

        public void setInitAspectRatio(double initAspectRatio) {
            this.initAspectRatio = initAspectRatio;
        }

        public boolean isUseIntrinsicGuess() {
            return (this.flags & 1) != 0;
        }

        public void setUseIntrinsicGuess(boolean useIntrinsicGuess) {
            this.flags = useIntrinsicGuess ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        }

        public boolean isFixAspectRatio() {
            return (this.flags & 2) != 0;
        }

        public void setFixAspectRatio(boolean fixAspectRatio) {
            this.flags = fixAspectRatio ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        }

        public boolean isFixPrincipalPoint() {
            return (this.flags & 4) != 0;
        }

        public void setFixPrincipalPoint(boolean fixPrincipalPoint) {
            this.flags = fixPrincipalPoint ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        }

        public boolean isZeroTangentDist() {
            return (this.flags & 8) != 0;
        }

        public void setZeroTangentDist(boolean zeroTangentDist) {
            this.flags = zeroTangentDist ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
        }

        public boolean isFixFocalLength() {
            return (this.flags & 0x10) != 0;
        }

        public void setFixFocalLength(boolean fixFocalLength) {
            this.flags = fixFocalLength ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
        }

        public boolean isFixK1() {
            return (this.flags & 0x20) != 0;
        }

        public void setFixK1(boolean fixK1) {
            this.flags = fixK1 ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
        }

        public boolean isFixK2() {
            return (this.flags & 0x40) != 0;
        }

        public void setFixK2(boolean fixK2) {
            this.flags = fixK2 ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
        }

        public boolean isFixK3() {
            return (this.flags & 0x80) != 0;
        }

        public void setFixK3(boolean fixK3) {
            this.flags = fixK3 ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
        }

        public boolean isFixK4() {
            return (this.flags & 0x800) != 0;
        }

        public void setFixK4(boolean fixK4) {
            this.flags = fixK4 ? (this.flags |= 0x800) : (this.flags &= 0xFFFFF7FF);
        }

        public boolean isFixK5() {
            return (this.flags & 0x1000) != 0;
        }

        public void setFixK5(boolean fixK5) {
            this.flags = fixK5 ? (this.flags |= 0x1000) : (this.flags &= 0xFFFFEFFF);
        }

        public boolean isFixK6() {
            return (this.flags & 0x2000) != 0;
        }

        public void setFixK6(boolean fixK6) {
            this.flags = fixK6 ? (this.flags |= 0x2000) : (this.flags &= 0xFFFFDFFF);
        }

        public boolean isRationalModel() {
            return (this.flags & 0x4000) != 0;
        }

        public void setRationalModel(boolean rationalModel) {
            this.flags = rationalModel ? (this.flags |= 0x4000) : (this.flags &= 0xFFFFBFFF);
        }

        public boolean isStereoFixIntrinsic() {
            return (this.flags & 0x100) != 0;
        }

        public void setStereoFixIntrinsic(boolean stereoFixIntrinsic) {
            this.flags = stereoFixIntrinsic ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
        }

        public boolean isStereoSameFocalLength() {
            return (this.flags & 0x200) != 0;
        }

        public void setStereoSameFocalLength(boolean stereoSameFocalLength) {
            this.flags = stereoSameFocalLength ? (this.flags |= 0x200) : (this.flags &= 0xFFFFFDFF);
        }
    }

    public static class Settings
    extends BaseChildSettings {
        String name = "";
        double responseGamma = 0.0;

        public Settings() {
        }

        public Settings(Settings settings) {
            this.name = settings.name;
            this.responseGamma = settings.responseGamma;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.firePropertyChange("name", this.name, this.name);
        }

        public double getResponseGamma() {
            return this.responseGamma;
        }

        public void setResponseGamma(double responseGamma) {
            this.responseGamma = responseGamma;
        }
    }
}

