// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.librealsense;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.librealsense.global.RealSense.*;


    @Namespace("rs") @Properties(inherit = org.bytedeco.librealsense.presets.RealSense.class)
public class device extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public device(Pointer p) { super(p); }
    
        /** retrieve a human readable device model string
         *  @return  the model string, such as "Intel RealSense F200" or "Intel RealSense R200" */
        public native @Cast("const char*") BytePointer get_name();

        /** retrieve the unique serial number of the device
         *  @return  the serial number, in a format specific to the device model */
        public native @Cast("const char*") BytePointer get_serial();

        /** retrieve the USB port number of the device
         *  @return  the USB port number, in a format specific to the device model */
        public native @Cast("const char*") BytePointer get_usb_port_id();

        /** retrieve the version of the firmware currently installed on the device
         *  @return  firmware version string, in a format is specific to device model */
        public native @Cast("const char*") BytePointer get_firmware_version();

        /** retrieve camera specific information like the versions of the various componnents
         *  @return  camera info string, in a format specific to the device model */
        public native @Cast("const char*") BytePointer get_info(@Cast("rs::camera_info") int info);

        /** retrieve extrinsic transformation between the viewpoints of two different streams
         *  @param from_stream [in]  stream whose coordinate space we will transform from
         *  @param to_stream [in]    stream whose coordinate space we will transform to
         *  @return                 the transformation between the two streams */
        public native @ByVal extrinsics get_extrinsics(@Cast("rs::stream") int from_stream, @Cast("rs::stream") int to_stream);

        /** retrieve extrinsic transformation between the viewpoints of specific stream and the motion module
         *  @param from_stream [in]  stream whose coordinate space we will transform from
         *  @return                 the transformation between the  specific stream and motion module */
        public native @ByVal extrinsics get_motion_extrinsics_from(@Cast("rs::stream") int from_stream);

        /** retrieve mapping between the units of the depth image and meters
         *  @return  depth in meters corresponding to a depth value of 1 */
        public native float get_depth_scale();

        /** determine if the device allows a specific option to be queried and set
         *  @param option [in]  the option to check for support
         *  @return            true if the option can be queried and set */
        public native @Cast("bool") boolean supports_option(@Cast("rs::option") int option);

        /** determine the number of streaming modes available for a given stream
         *  @param stream [in]  the stream whose modes will be enumerated
         *  @return            the count of available modes */
        public native int get_stream_mode_count(@Cast("rs::stream") int stream);

        /** determine the properties of a specific streaming mode
         *  @param stream [in]      the stream whose mode will be queried
         *  @param index [in]       the zero based index of the streaming mode
         *  @param width [out]      the width of a frame image in pixels
         *  @param height [out]     the height of a frame image in pixels
         *  @param format [out]     the pixel format of a frame image
         *  @param framerate [out]  the number of frames which will be streamed per second */
        public native void get_stream_mode(@Cast("rs::stream") int stream, int index, @ByRef IntPointer width, @ByRef IntPointer height, @Cast("rs::format*") @ByRef IntPointer format, @ByRef IntPointer framerate);
        public native void get_stream_mode(@Cast("rs::stream") int stream, int index, @ByRef IntBuffer width, @ByRef IntBuffer height, @Cast("rs::format*") @ByRef IntBuffer format, @ByRef IntBuffer framerate);
        public native void get_stream_mode(@Cast("rs::stream") int stream, int index, @ByRef int[] width, @ByRef int[] height, @Cast("rs::format*") @ByRef int[] format, @ByRef int[] framerate);

        /** enable a specific stream and request specific properties
         *  @param stream [in]                   the stream to enable
         *  @param width [in]                    the desired width of a frame image in pixels, or 0 if any width is acceptable
         *  @param height [in]                   the desired height of a frame image in pixels, or 0 if any height is acceptable
         *  @param format [in]                   the pixel format of a frame image, or ANY if any format is acceptable
         *  @param framerate [in]                the number of frames which will be streamed per second, or 0 if any framerate is acceptable
         *  @param output_buffer_type [in]       output buffer format (continous in memory / native with pitch) */
        public native void enable_stream(@Cast("rs::stream") int stream, int width, int height, @Cast("rs::format") int format, int framerate, @Cast("rs::output_buffer_format") int output_buffer_type/*=rs::output_buffer_format::continous*/);
        public native void enable_stream(@Cast("rs::stream") int stream, int width, int height, @Cast("rs::format") int format, int framerate);

        /** enable a specific stream and request properties using a preset
         *  @param stream [in]  the stream to enable
         *  @param preset [in]  the preset to use to enable the stream */
        public native void enable_stream(@Cast("rs::stream") int stream, @Cast("rs::preset") int preset);

        /** disable a specific stream
         *  @param stream [in]  the stream to disable */
        public native void disable_stream(@Cast("rs::stream") int stream);

        /** determine if a specific stream is enabled
         *  @param stream [in]  the stream to check
         *  @return            true if the stream is currently enabled */
        public native @Cast("bool") boolean is_stream_enabled(@Cast("rs::stream") int stream);

        /** retrieve the width in pixels of a specific stream, equivalent to the width field from the stream's intrinsic
         *  @param stream [in]  the stream whose width to retrieve
         *  @return            the width in pixels of images from this stream */
        public native int get_stream_width(@Cast("rs::stream") int stream);

        /** retrieve the height in pixels of a specific stream, equivalent to the height field from the stream's intrinsic
         *  @param stream [in]  the stream whose height to retrieve
         *  @return            the height in pixels of images from this stream */
        public native int get_stream_height(@Cast("rs::stream") int stream);

        /** retrieve the pixel format for a specific stream
         *  @param stream [in]  the stream whose format to retrieve
         *  @return            the pixel format of the stream */
        public native @Cast("rs::format") int get_stream_format(@Cast("rs::stream") int stream);

        /** retrieve the framerate for a specific stream
         *  @param stream [in]  the stream whose framerate to retrieve
         *  @return            the framerate of the stream, in frames per second */
        public native int get_stream_framerate(@Cast("rs::stream") int stream);

        /** retrieve intrinsic camera parameters for a specific stream
         *  @param stream [in]  the stream whose parameters to retrieve
         *  @return            the intrinsic parameters of the stream */
        public native @ByVal intrinsics get_stream_intrinsics(@Cast("rs::stream") int stream);

        /** retrieve intrinsic camera parameters for the motion module
         *  @return            the intrinsic parameters of the stream */
        public native @ByVal motion_intrinsics get_motion_intrinsics();

        /** sets the callback for frame arrival event. provided callback will be called the instant new frame of given stream becomes available
         *  once callback is set on certain stream type, frames of this type will no longer be available throuhg wait/poll methods (those two approaches are mutually exclusive) 
         *  while wait/poll methods provide consistent set of syncronized frames at the expense of extra latency,
         *  set frame callbacks provides low latency solution with no syncronization
         *  @param stream [in]    the stream 
         *  @param on_frame [in]  frame callback to be invoke on every new frame
         *  @return            the framerate of the stream, in frames per second */
        public native void set_frame_callback(@Cast("rs::stream") int stream, @ByVal FrameFunction frame_handler);

        /** sets the callback for motion module event. provided callback will be called the instant new motion or timestamp event is available. 
         *  Note: rs_enable_motion_tracking  is responsible for activating the motion module on-board the device. One of the services it provides is producing shared and high-resolution timestamps for all component hooked-up to it. Usually, librealsense takes care of that and copies the timestamps to the relevant frames.
         *  However, when the user has an external device(like a compass) and wishes to synchronize it precisely with image and motion stream he can connect the sensor to a GPIO avaialbe on some devices. Every time sensor will signal, the user will get a timestamp callback with a frame number, source ID and a timestamp.
         *  This would allow advanced user to synchronize his compass events(presumably coming though I2C or some other method) with realsense data.
         *  @param stream [in]             the stream 
         *  @param motion_handler [in]     frame callback to be invoke on every new motion event
         *  @param timestamp_handler [in]  frame callback to be invoke on every new timestamp event (can be left-out)
         *  @return                       the framerate of the stream, in frames per second */
        public native void enable_motion_tracking(@ByVal MotionFunction motion_handler, @ByVal TimestampFunction timestamp_handler);

        /** sets the callback for motion module event. provided callback will be called the instant new motion event is available. 
         *  @param stream [in]             the stream 
         *  @param motion_handler [in]     frame callback to be invoke on every new motion event
         *  @return                       the framerate of the stream, in frames per second */
        public native void enable_motion_tracking(@ByVal MotionFunction motion_handler);

        /** disable events polling */
        public native void disable_motion_tracking();

        /** check if data acquisition is active         */
        public native int is_motion_tracking_active();


        /** begin streaming on all enabled streams for this device */
        public native void start(@Cast("rs::source") byte source/*=rs::source::video*/);
        public native void start();

        /** end streaming on all streams for this device */
        public native void stop(@Cast("rs::source") byte source/*=rs::source::video*/);
        public native void stop();

        /** determine if the device is currently streaming
         *  @return  true if the device is currently streaming */
        public native @Cast("bool") boolean is_streaming();

        /** retrieve the available range of values of a supported option
         *  @param option [in]  the option whose range should be queried
         *  @param min [out]    the minimum value which will be accepted for this option
         *  @param max [out]    the maximum value which will be accepted for this option
         *  @param step [out]   the granularity of options which accept discrete values, or zero if the option accepts continuous values */
        public native void get_option_range(@Cast("rs::option") int option, @ByRef DoublePointer min, @ByRef DoublePointer max, @ByRef DoublePointer step);
        public native void get_option_range(@Cast("rs::option") int option, @ByRef DoubleBuffer min, @ByRef DoubleBuffer max, @ByRef DoubleBuffer step);
        public native void get_option_range(@Cast("rs::option") int option, @ByRef double[] min, @ByRef double[] max, @ByRef double[] step);

        /** retrieve the available range of values of a supported option
         *  @param option [in]  the option whose range should be queried
         *  @param min [out]    the minimum value which will be accepted for this option
         *  @param max [out]    the maximum value which will be accepted for this option
         *  @param step [out]   the granularity of options which accept discrete values, or zero if the option accepts continuous values
         *  @param def [out]    the default value of the option */
        public native void get_option_range(@Cast("rs::option") int option, @ByRef DoublePointer min, @ByRef DoublePointer max, @ByRef DoublePointer step, @ByRef DoublePointer def);
        public native void get_option_range(@Cast("rs::option") int option, @ByRef DoubleBuffer min, @ByRef DoubleBuffer max, @ByRef DoubleBuffer step, @ByRef DoubleBuffer def);
        public native void get_option_range(@Cast("rs::option") int option, @ByRef double[] min, @ByRef double[] max, @ByRef double[] step, @ByRef double[] def);

        /** efficiently retrieve the value of an arbitrary number of options, using minimal hardware IO
         *  @param options [in]  the array of options which should be queried
         *  @param count [in]    the length of the options and values arrays
         *  @param values [out]  the array which will receive the values of the queried options */
        public native void get_options(@Cast("const rs::option*") IntPointer options, @Cast("size_t") long count, DoublePointer values);
        public native void get_options(@Cast("const rs::option*") IntBuffer options, @Cast("size_t") long count, DoubleBuffer values);
        public native void get_options(@Cast("const rs::option*") int[] options, @Cast("size_t") long count, double[] values);

        /** efficiently set the value of an arbitrary number of options, using minimal hardware IO
         *  @param options [in]  the array of options which should be set
         *  @param count [in]    the length of the options and values arrays
         *  @param values [in]   the array of values to which the options should be set */
        public native void set_options(@Cast("const rs::option*") IntPointer options, @Cast("size_t") long count, @Const DoublePointer values);
        public native void set_options(@Cast("const rs::option*") IntBuffer options, @Cast("size_t") long count, @Const DoubleBuffer values);
        public native void set_options(@Cast("const rs::option*") int[] options, @Cast("size_t") long count, @Const double[] values);

        /** retrieve the current value of a single option
         *  @param option [in]  the option whose value should be retrieved
         *  @return            the value of the option */
        public native double get_option(@Cast("rs::option") int option);
        
        /** retrieve the device specific option description
         *  @param option [in]  the option whose description should be retrieved
         *  @return            the value of the option */
        public native @Cast("const char*") BytePointer get_option_description(@Cast("rs::option") int option);

        /** set the current value of a single option
         *  @param option [in]  the option whose value should be set
         *  @param value [in]   the value of the option */
        
        ///
        public native void set_option(@Cast("rs::option") int option, double value);

        /** block until new frames are available
         *  */
        public native void wait_for_frames();

        /** check if new frames are available, without blocking
         *  @return  true if new frames are available, false if no new frames have arrived */
        public native @Cast("bool") boolean poll_for_frames();

        /** determine device capabilities
         *  @param capability [in]  the capability to check for support
         *  @return                true if device has this capability */
        public native @Cast("bool") boolean supports(@Cast("rs::capabilities") int capability);


        /** determine device capabilities
         *  @param capability [in]  the capability to check for support
         *  @return                true if device has this capability */

        /** retrieve the time at which the latest frame on a stream was captured
         *  @param stream [in]  the stream whose latest frame we are interested in
         *  @return            the timestamp of the frame, in milliseconds since the device was started */
        public native double get_frame_timestamp(@Cast("rs::stream") int stream);

        /** retrieve the frame number
         *  @param stream [in]  the stream whose latest frame we are interested in
         *  @return            the number of the frame, since the device was started */
        public native @Cast("unsigned long long") long get_frame_number(@Cast("rs::stream") int stream);

        /** retrieve the contents of the latest frame on a stream
         *  @param stream [in]  the stream whose latest frame we are interested in
         *  @return            the pointer to the start of the frame data */
        public native @Const Pointer get_frame_data(@Cast("rs::stream") int stream);

        /** send device specific data to the device
         *  @param type [in]  describes the content of the memory buffer, how it will be interpreted by the device
         *  @param data [in]  raw data buffer to be sent to the device
         *  @param size [in]  size in bytes of the buffer */
        public native void send_blob_to_device(@Cast("rs::blob_type") int type, Pointer data, int size);
    }
