// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.lz4.global;

import org.bytedeco.lz4.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class lz4 extends org.bytedeco.lz4.presets.lz4 {
    static { Loader.load(); }

// Parsed from <lz4.h>

/*
 *  LZ4 - Fast LZ compression algorithm
 *  Header File
 *  Copyright (C) 2011-2020, Yann Collet.

   BSD 2-Clause License (http://www.opensource.org/licenses/bsd-license.php)

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

       * Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
       * Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following disclaimer
   in the documentation and/or other materials provided with the
   distribution.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

   You can contact the author at :
    - LZ4 homepage : http://www.lz4.org
    - LZ4 source repository : https://github.com/lz4/lz4
*/
// #if defined (__cplusplus)
// #endif

// #ifndef LZ4_H_2983827168210
// #define LZ4_H_2983827168210

/* --- Dependency --- */
// #include <stddef.h>   /* size_t */


/**
  Introduction
  <p>
  LZ4 is lossless compression algorithm, providing compression speed >500 MB/s per core,
  scalable with multi-cores CPU. It features an extremely fast decoder, with speed in
  multiple GB/s per core, typically reaching RAM speed limits on multi-core systems.
  <p>
  The LZ4 compression library provides in-memory compression and decompression functions.
  It gives full buffer control to user.
  Compression can be done in:
    - a single step (described as Simple Functions)
    - a single step, reusing a context (described in Advanced Functions)
    - unbounded multiple steps (described as Streaming compression)
  <p>
  lz4.h generates and decodes LZ4-compressed blocks (doc/lz4_Block_format.md).
  Decompressing such a compressed block requires additional metadata.
  Exact metadata depends on exact decompression function.
  For the typical case of LZ4_decompress_safe(),
  metadata includes block's compressed size, and maximum bound of decompressed size.
  Each application is free to encode and pass such metadata in whichever way it wants.
  <p>
  lz4.h only handle blocks, it can not generate Frames.
  <p>
  Blocks are different from Frames (doc/lz4_Frame_format.md).
  Frames bundle both blocks and metadata in a specified manner.
  Embedding metadata is required for compressed data to be self-contained and portable.
  Frame format is delivered through a companion API, declared in lz4frame.h.
  The {@code lz4} CLI can only manage frames.
*/

/*^***************************************************************
*  Export parameters
*****************************************************************/
/*
*  LZ4_DLL_EXPORT :
*  Enable exporting of functions when building a Windows DLL
*  LZ4LIB_VISIBILITY :
*  Control library symbols visibility.
*/
// #ifndef LZ4LIB_VISIBILITY
// #  if defined(__GNUC__) && (__GNUC__ >= 4)
// #    define LZ4LIB_VISIBILITY __attribute__ ((visibility ("default")))
// #  else
// #    define LZ4LIB_VISIBILITY
// #  endif
// #endif
// #if defined(LZ4_DLL_EXPORT) && (LZ4_DLL_EXPORT==1)
// #  define LZ4LIB_API __declspec(dllexport) LZ4LIB_VISIBILITY
// #elif defined(LZ4_DLL_IMPORT) && (LZ4_DLL_IMPORT==1)
// #  define LZ4LIB_API __declspec(dllimport) LZ4LIB_VISIBILITY /* It isn't required but allows to generate better code, saving a function pointer load from the IAT and an indirect jump.*/
// #else
// #  define LZ4LIB_API LZ4LIB_VISIBILITY
// #endif

/** LZ4_FREESTANDING :
 *  When this macro is set to 1, it enables "freestanding mode" that is
 *  suitable for typical freestanding environment which doesn't support
 *  standard C library.
 *
 *  - LZ4_FREESTANDING is a compile-time switch.
 *  - It requires the following macros to be defined:
 *    LZ4_memcpy, LZ4_memmove, LZ4_memset.
 *  - It only enables LZ4/HC functions which don't use heap.
 *    All LZ4F_* functions are not supported.
 *  - See tests/freestanding.c to check its basic setup.
 */
// #if defined(LZ4_FREESTANDING) && (LZ4_FREESTANDING == 1)
public static final int LZ4_HEAPMODE = 0;
public static final int LZ4HC_HEAPMODE = 0;
public static final int LZ4_STATIC_LINKING_ONLY_DISABLE_MEMORY_ALLOCATION = 1;
// #  if !defined(LZ4_memcpy)
// #    error "LZ4_FREESTANDING requires macro 'LZ4_memcpy'."
// #  endif
// #  if !defined(LZ4_memset)
// #    error "LZ4_FREESTANDING requires macro 'LZ4_memset'."
// #  endif
// #  if !defined(LZ4_memmove)
// #    error "LZ4_FREESTANDING requires macro 'LZ4_memmove'."
// #  endif
// #elif ! defined(LZ4_FREESTANDING)
public static final int LZ4_FREESTANDING = 0;
// #endif


/*------   Version   ------*/
public static final int LZ4_VERSION_MAJOR =    1;    /* for breaking interface changes  */
public static final int LZ4_VERSION_MINOR =    9;    /* for new (non-breaking) interface capabilities */
public static final int LZ4_VERSION_RELEASE =  4;    /* for tweaks, bug-fixes, or development */

public static final int LZ4_VERSION_NUMBER = (LZ4_VERSION_MAJOR *100*100 + LZ4_VERSION_MINOR *100 + LZ4_VERSION_RELEASE);

// #define LZ4_LIB_VERSION LZ4_VERSION_MAJOR.Z4_VERSION_MINOR.Z4_VERSION_RELEASE
// #define LZ4_QUOTE(str) #str
// #define LZ4_EXPAND_AND_QUOTE(str) LZ4_QUOTE(str)
public static native @MemberGetter @Cast("const char*") BytePointer LZ4_VERSION_STRING();
public static final BytePointer LZ4_VERSION_STRING = LZ4_VERSION_STRING();  /* requires v1.7.3+ */

/** library version number; useful to check dll version; requires v1.3.0+ */
public static native int LZ4_versionNumber();
/** library version string; useful to check dll version; requires v1.7.5+ */
public static native @Cast("const char*") BytePointer LZ4_versionString();


/*-************************************
*  Tuning parameter
**************************************/
public static final int LZ4_MEMORY_USAGE_MIN = 10;
public static final int LZ4_MEMORY_USAGE_DEFAULT = 14;
public static final int LZ4_MEMORY_USAGE_MAX = 20;

/**
 * LZ4_MEMORY_USAGE :
 * Memory usage formula : N->2^N Bytes (examples : 10 -> 1KB; 12 -> 4KB ; 16 -> 64KB; 20 -> 1MB; )
 * Increasing memory usage improves compression ratio, at the cost of speed.
 * Reduced memory usage may improve speed at the cost of ratio, thanks to better cache locality.
 * Default value is 14, for 16KB, which nicely fits into Intel x86 L1 cache
 */
// #ifndef LZ4_MEMORY_USAGE
public static final int LZ4_MEMORY_USAGE = LZ4_MEMORY_USAGE_DEFAULT;
// #endif

// #if (LZ4_MEMORY_USAGE < LZ4_MEMORY_USAGE_MIN)
// #  error "LZ4_MEMORY_USAGE is too small !"
// #endif

// #if (LZ4_MEMORY_USAGE > LZ4_MEMORY_USAGE_MAX)
// #  error "LZ4_MEMORY_USAGE is too large !"
// #endif

/*-************************************
*  Simple Functions
**************************************/
/** LZ4_compress_default() :
 *  Compresses 'srcSize' bytes from buffer 'src'
 *  into already allocated 'dst' buffer of size 'dstCapacity'.
 *  Compression is guaranteed to succeed if 'dstCapacity' >= LZ4_compressBound(srcSize).
 *  It also runs faster, so it's a recommended setting.
 *  If the function cannot compress 'src' into a more limited 'dst' budget,
 *  compression stops *immediately*, and the function result is zero.
 *  In which case, 'dst' content is undefined (invalid).
 *      srcSize : max supported value is LZ4_MAX_INPUT_SIZE.
 *      dstCapacity : size of buffer 'dst' (which must be already allocated)
 *     @return  : the number of bytes written into buffer 'dst' (necessarily <= dstCapacity)
 *                or 0 if compression fails
 * Note : This function is protected against buffer overflow scenarios (never writes outside 'dst' buffer, nor read outside 'source' buffer).
 */
public static native int LZ4_compress_default(@Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst, int srcSize, int dstCapacity);
public static native int LZ4_compress_default(String src, @Cast("char*") ByteBuffer dst, int srcSize, int dstCapacity);
public static native int LZ4_compress_default(@Cast("const char*") BytePointer src, @Cast("char*") byte[] dst, int srcSize, int dstCapacity);
public static native int LZ4_compress_default(String src, @Cast("char*") BytePointer dst, int srcSize, int dstCapacity);
public static native int LZ4_compress_default(@Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst, int srcSize, int dstCapacity);
public static native int LZ4_compress_default(String src, @Cast("char*") byte[] dst, int srcSize, int dstCapacity);

/** LZ4_decompress_safe() :
 *  compressedSize : is the exact complete size of the compressed block.
 *  dstCapacity : is the size of destination buffer (which must be already allocated), presumed an upper bound of decompressed size.
 * @return : the number of bytes decompressed into destination buffer (necessarily <= dstCapacity)
 *           If destination buffer is not large enough, decoding will stop and output an error code (negative value).
 *           If the source stream is detected malformed, the function will stop decoding and return a negative result.
 * Note 1 : This function is protected against malicious data packets :
 *          it will never writes outside 'dst' buffer, nor read outside 'source' buffer,
 *          even if the compressed block is maliciously modified to order the decoder to do these actions.
 *          In such case, the decoder stops immediately, and considers the compressed block malformed.
 * Note 2 : compressedSize and dstCapacity must be provided to the function, the compressed block does not contain them.
 *          The implementation is free to send / store / derive this information in whichever way is most beneficial.
 *          If there is a need for a different format which bundles together both compressed data and its metadata, consider looking at lz4frame.h instead.
 */
public static native int LZ4_decompress_safe(@Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst, int compressedSize, int dstCapacity);
public static native int LZ4_decompress_safe(String src, @Cast("char*") ByteBuffer dst, int compressedSize, int dstCapacity);
public static native int LZ4_decompress_safe(@Cast("const char*") BytePointer src, @Cast("char*") byte[] dst, int compressedSize, int dstCapacity);
public static native int LZ4_decompress_safe(String src, @Cast("char*") BytePointer dst, int compressedSize, int dstCapacity);
public static native int LZ4_decompress_safe(@Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst, int compressedSize, int dstCapacity);
public static native int LZ4_decompress_safe(String src, @Cast("char*") byte[] dst, int compressedSize, int dstCapacity);


/*-************************************
*  Advanced Functions
**************************************/
public static final int LZ4_MAX_INPUT_SIZE =        0x7E000000;   /* 2 113 929 216 bytes */
// #define LZ4_COMPRESSBOUND(isize)  ((unsigned)(isize) > (unsigned)LZ4_MAX_INPUT_SIZE ? 0 : (isize) + ((isize)/255) + 16)

/** LZ4_compressBound() :
    Provides the maximum size that LZ4 compression may output in a "worst case" scenario (input data not compressible)
    This function is primarily useful for memory allocation purposes (destination buffer size).
    Macro LZ4_COMPRESSBOUND() is also provided for compilation-time evaluation (stack memory allocation for example).
    Note that LZ4_compress_default() compresses faster when dstCapacity is >= LZ4_compressBound(srcSize)
        inputSize  : max supported value is LZ4_MAX_INPUT_SIZE
        return : maximum output size in a "worst case" scenario
              or 0, if input size is incorrect (too large or negative)
*/
public static native int LZ4_compressBound(int inputSize);

/** LZ4_compress_fast() :
    Same as LZ4_compress_default(), but allows selection of "acceleration" factor.
    The larger the acceleration value, the faster the algorithm, but also the lesser the compression.
    It's a trade-off. It can be fine tuned, with each successive value providing roughly +~3% to speed.
    An acceleration value of "1" is the same as regular LZ4_compress_default()
    Values <= 0 will be replaced by LZ4_ACCELERATION_DEFAULT (currently == 1, see lz4.c).
    Values > LZ4_ACCELERATION_MAX will be replaced by LZ4_ACCELERATION_MAX (currently == 65537, see lz4.c).
*/
public static native int LZ4_compress_fast(@Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast(String src, @Cast("char*") ByteBuffer dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast(@Cast("const char*") BytePointer src, @Cast("char*") byte[] dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast(String src, @Cast("char*") BytePointer dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast(@Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast(String src, @Cast("char*") byte[] dst, int srcSize, int dstCapacity, int acceleration);


/** LZ4_compress_fast_extState() :
 *  Same as LZ4_compress_fast(), using an externally allocated memory space for its state.
 *  Use LZ4_sizeofState() to know how much memory must be allocated,
 *  and allocate it on 8-bytes boundaries (using {@code malloc()} typically).
 *  Then, provide this buffer as {@code void* state} to compression function.
 */
public static native int LZ4_sizeofState();
public static native int LZ4_compress_fast_extState(Pointer state, @Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast_extState(Pointer state, String src, @Cast("char*") ByteBuffer dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast_extState(Pointer state, @Cast("const char*") BytePointer src, @Cast("char*") byte[] dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast_extState(Pointer state, String src, @Cast("char*") BytePointer dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast_extState(Pointer state, @Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast_extState(Pointer state, String src, @Cast("char*") byte[] dst, int srcSize, int dstCapacity, int acceleration);


/** LZ4_compress_destSize() :
 *  Reverse the logic : compresses as much data as possible from 'src' buffer
 *  into already allocated buffer 'dst', of size >= 'targetDestSize'.
 *  This function either compresses the entire 'src' content into 'dst' if it's large enough,
 *  or fill 'dst' buffer completely with as much data as possible from 'src'.
 *  note: acceleration parameter is fixed to "default".
 *
 * *srcSizePtr : will be modified to indicate how many bytes where read from 'src' to fill 'dst'.
 *               New value is necessarily <= input value.
 * @return : Nb bytes written into 'dst' (necessarily <= targetDestSize)
 *           or 0 if compression fails.
 *
 * Note : from v1.8.2 to v1.9.1, this function had a bug (fixed un v1.9.2+):
 *        the produced compressed content could, in specific circumstances,
 *        require to be decompressed into a destination buffer larger
 *        by at least 1 byte than the content to decompress.
 *        If an application uses {@code LZ4_compress_destSize()},
 *        it's highly recommended to update liblz4 to v1.9.2 or better.
 *        If this can't be done or ensured,
 *        the receiving decompression function should provide
 *        a dstCapacity which is > decompressedSize, by at least 1 byte.
 *        See https://github.com/lz4/lz4/issues/859 for details
 */
public static native int LZ4_compress_destSize(@Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst, IntPointer srcSizePtr, int targetDstSize);
public static native int LZ4_compress_destSize(String src, @Cast("char*") ByteBuffer dst, IntBuffer srcSizePtr, int targetDstSize);
public static native int LZ4_compress_destSize(@Cast("const char*") BytePointer src, @Cast("char*") byte[] dst, int[] srcSizePtr, int targetDstSize);
public static native int LZ4_compress_destSize(String src, @Cast("char*") BytePointer dst, IntPointer srcSizePtr, int targetDstSize);
public static native int LZ4_compress_destSize(@Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst, IntBuffer srcSizePtr, int targetDstSize);
public static native int LZ4_compress_destSize(String src, @Cast("char*") byte[] dst, int[] srcSizePtr, int targetDstSize);


/** LZ4_decompress_safe_partial() :
 *  Decompress an LZ4 compressed block, of size 'srcSize' at position 'src',
 *  into destination buffer 'dst' of size 'dstCapacity'.
 *  Up to 'targetOutputSize' bytes will be decoded.
 *  The function stops decoding on reaching this objective.
 *  This can be useful to boost performance
 *  whenever only the beginning of a block is required.
 *
 * @return : the number of bytes decoded in {@code dst} (necessarily <= targetOutputSize)
 *           If source stream is detected malformed, function returns a negative result.
 *
 *  Note 1 : @return can be < targetOutputSize, if compressed block contains less data.
 *
 *  Note 2 : targetOutputSize must be <= dstCapacity
 *
 *  Note 3 : this function effectively stops decoding on reaching targetOutputSize,
 *           so dstCapacity is kind of redundant.
 *           This is because in older versions of this function,
 *           decoding operation would still write complete sequences.
 *           Therefore, there was no guarantee that it would stop writing at exactly targetOutputSize,
 *           it could write more bytes, though only up to dstCapacity.
 *           Some "margin" used to be required for this operation to work properly.
 *           Thankfully, this is no longer necessary.
 *           The function nonetheless keeps the same signature, in an effort to preserve API compatibility.
 *
 *  Note 4 : If srcSize is the exact size of the block,
 *           then targetOutputSize can be any value,
 *           including larger than the block's decompressed size.
 *           The function will, at most, generate block's decompressed size.
 *
 *  Note 5 : If srcSize is _larger_ than block's compressed size,
 *           then targetOutputSize **MUST** be <= block's decompressed size.
 *           Otherwise, *silent corruption will occur*.
 */
public static native int LZ4_decompress_safe_partial(@Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst, int srcSize, int targetOutputSize, int dstCapacity);
public static native int LZ4_decompress_safe_partial(String src, @Cast("char*") ByteBuffer dst, int srcSize, int targetOutputSize, int dstCapacity);
public static native int LZ4_decompress_safe_partial(@Cast("const char*") BytePointer src, @Cast("char*") byte[] dst, int srcSize, int targetOutputSize, int dstCapacity);
public static native int LZ4_decompress_safe_partial(String src, @Cast("char*") BytePointer dst, int srcSize, int targetOutputSize, int dstCapacity);
public static native int LZ4_decompress_safe_partial(@Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst, int srcSize, int targetOutputSize, int dstCapacity);
public static native int LZ4_decompress_safe_partial(String src, @Cast("char*") byte[] dst, int srcSize, int targetOutputSize, int dstCapacity);
// Targeting ..\LZ4Stream.java

  /* incomplete type (defined later) */

/**
 Note about RC_INVOKED
 <p>
 - RC_INVOKED is predefined symbol of rc.exe (the resource compiler which is part of MSVC/Visual Studio).
   https://docs.microsoft.com/en-us/windows/win32/menurc/predefined-macros
 <p>
 - Since rc.exe is a legacy compiler, it truncates long symbol (> 30 chars)
   and reports warning "RC4011: identifier truncated".
 <p>
 - To eliminate the warning, we surround long preprocessor symbol with
   "#if !defined(RC_INVOKED) ... #endif" block that means
   "skip this block when rc.exe is trying to read it".
*/
// #if !defined(RC_INVOKED) /* https://docs.microsoft.com/en-us/windows/win32/menurc/predefined-macros */
// #if !defined(LZ4_STATIC_LINKING_ONLY_DISABLE_MEMORY_ALLOCATION)
public static native LZ4Stream LZ4_createStream();
public static native int LZ4_freeStream(LZ4Stream streamPtr);
// #endif /* !defined(LZ4_STATIC_LINKING_ONLY_DISABLE_MEMORY_ALLOCATION) */
// #endif

/** LZ4_resetStream_fast() : v1.9.0+
 *  Use this to prepare an LZ4_stream_t for a new chain of dependent blocks
 *  (e.g., LZ4_compress_fast_continue()).
 *
 *  An LZ4_stream_t must be initialized once before usage.
 *  This is automatically done when created by LZ4_createStream().
 *  However, should the LZ4_stream_t be simply declared on stack (for example),
 *  it's necessary to initialize it first, using LZ4_initStream().
 *
 *  After init, start any new stream with LZ4_resetStream_fast().
 *  A same LZ4_stream_t can be re-used multiple times consecutively
 *  and compress multiple streams,
 *  provided that it starts each new stream with LZ4_resetStream_fast().
 *
 *  LZ4_resetStream_fast() is much faster than LZ4_initStream(),
 *  but is not compatible with memory regions containing garbage data.
 *
 *  Note: it's only useful to call LZ4_resetStream_fast()
 *        in the context of streaming compression.
 *        The *extState* functions perform their own resets.
 *        Invoking LZ4_resetStream_fast() before is redundant, and even counterproductive.
 */
public static native void LZ4_resetStream_fast(LZ4Stream streamPtr);

/** LZ4_loadDict() :
 *  Use this function to reference a static dictionary into LZ4_stream_t.
 *  The dictionary must remain available during compression.
 *  LZ4_loadDict() triggers a reset, so any previous data will be forgotten.
 *  The same dictionary will have to be loaded on decompression side for successful decoding.
 *  Dictionary are useful for better compression of small data (KB range).
 *  While LZ4 accept any input as dictionary,
 *  results are generally better when using Zstandard's Dictionary Builder.
 *  Loading a size of 0 is allowed, and is the same as reset.
 * @return : loaded dictionary size, in bytes (necessarily <= 64 KB)
 */
public static native int LZ4_loadDict(LZ4Stream streamPtr, @Cast("const char*") BytePointer dictionary, int dictSize);
public static native int LZ4_loadDict(LZ4Stream streamPtr, String dictionary, int dictSize);

/** LZ4_compress_fast_continue() :
 *  Compress 'src' content using data from previously compressed blocks, for better compression ratio.
 * 'dst' buffer must be already allocated.
 *  If dstCapacity >= LZ4_compressBound(srcSize), compression is guaranteed to succeed, and runs faster.
 *
 * @return : size of compressed block
 *           or 0 if there is an error (typically, cannot fit into 'dst').
 *
 *  Note 1 : Each invocation to LZ4_compress_fast_continue() generates a new block.
 *           Each block has precise boundaries.
 *           Each block must be decompressed separately, calling LZ4_decompress_*() with relevant metadata.
 *           It's not possible to append blocks together and expect a single invocation of LZ4_decompress_*() to decompress them together.
 *
 *  Note 2 : The previous 64KB of source data is __assumed__ to remain present, unmodified, at same address in memory !
 *
 *  Note 3 : When input is structured as a double-buffer, each buffer can have any size, including < 64 KB.
 *           Make sure that buffers are separated, by at least one byte.
 *           This construction ensures that each block only depends on previous block.
 *
 *  Note 4 : If input buffer is a ring-buffer, it can have any size, including < 64 KB.
 *
 *  Note 5 : After an error, the stream status is undefined (invalid), it can only be reset or freed.
 */
public static native int LZ4_compress_fast_continue(LZ4Stream streamPtr, @Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast_continue(LZ4Stream streamPtr, String src, @Cast("char*") ByteBuffer dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast_continue(LZ4Stream streamPtr, @Cast("const char*") BytePointer src, @Cast("char*") byte[] dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast_continue(LZ4Stream streamPtr, String src, @Cast("char*") BytePointer dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast_continue(LZ4Stream streamPtr, @Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst, int srcSize, int dstCapacity, int acceleration);
public static native int LZ4_compress_fast_continue(LZ4Stream streamPtr, String src, @Cast("char*") byte[] dst, int srcSize, int dstCapacity, int acceleration);

/** LZ4_saveDict() :
 *  If last 64KB data cannot be guaranteed to remain available at its current memory location,
 *  save it into a safer place (char* safeBuffer).
 *  This is schematically equivalent to a memcpy() followed by LZ4_loadDict(),
 *  but is much faster, because LZ4_saveDict() doesn't need to rebuild tables.
 * @return : saved dictionary size in bytes (necessarily <= maxDictSize), or 0 if error.
 */
public static native int LZ4_saveDict(LZ4Stream streamPtr, @Cast("char*") BytePointer safeBuffer, int maxDictSize);
public static native int LZ4_saveDict(LZ4Stream streamPtr, @Cast("char*") ByteBuffer safeBuffer, int maxDictSize);
public static native int LZ4_saveDict(LZ4Stream streamPtr, @Cast("char*") byte[] safeBuffer, int maxDictSize);
// Targeting ..\LZ4StreamDecode.java

   /* tracking context */

/** LZ4_createStreamDecode() and LZ4_freeStreamDecode() :
 *  creation / destruction of streaming decompression tracking context.
 *  A tracking context can be re-used multiple times.
 */
// #if !defined(RC_INVOKED) /* https://docs.microsoft.com/en-us/windows/win32/menurc/predefined-macros */
// #if !defined(LZ4_STATIC_LINKING_ONLY_DISABLE_MEMORY_ALLOCATION)
public static native LZ4StreamDecode LZ4_createStreamDecode();
public static native int LZ4_freeStreamDecode(LZ4StreamDecode LZ4_stream);
// #endif /* !defined(LZ4_STATIC_LINKING_ONLY_DISABLE_MEMORY_ALLOCATION) */
// #endif

/** LZ4_setStreamDecode() :
 *  An LZ4_streamDecode_t context can be allocated once and re-used multiple times.
 *  Use this function to start decompression of a new stream of blocks.
 *  A dictionary can optionally be set. Use NULL or size 0 for a reset order.
 *  Dictionary is presumed stable : it must remain accessible and unmodified during next decompression.
 * @return : 1 if OK, 0 if error
 */
public static native int LZ4_setStreamDecode(LZ4StreamDecode LZ4_streamDecode, @Cast("const char*") BytePointer dictionary, int dictSize);
public static native int LZ4_setStreamDecode(LZ4StreamDecode LZ4_streamDecode, String dictionary, int dictSize);

/** LZ4_decoderRingBufferSize() : v1.8.2+
 *  Note : in a ring buffer scenario (optional),
 *  blocks are presumed decompressed next to each other
 *  up to the moment there is not enough remaining space for next block (remainingSize < maxBlockSize),
 *  at which stage it resumes from beginning of ring buffer.
 *  When setting such a ring buffer for streaming decompression,
 *  provides the minimum size of this ring buffer
 *  to be compatible with any source respecting maxBlockSize condition.
 * @return : minimum ring buffer size,
 *           or 0 if there is an error (invalid maxBlockSize).
 */
public static native int LZ4_decoderRingBufferSize(int maxBlockSize);
// #define LZ4_DECODER_RING_BUFFER_SIZE(maxBlockSize) (65536 + 14 + (maxBlockSize))  /* for static allocation; maxBlockSize presumed valid */

/** LZ4_decompress_*_continue() :
 *  These decoding functions allow decompression of consecutive blocks in "streaming" mode.
 *  A block is an unsplittable entity, it must be presented entirely to a decompression function.
 *  Decompression functions only accepts one block at a time.
 *  The last 64KB of previously decoded data *must* remain available and unmodified at the memory position where they were decoded.
 *  If less than 64KB of data has been decoded, all the data must be present.
 *
 *  Special : if decompression side sets a ring buffer, it must respect one of the following conditions :
 *  - Decompression buffer size is _at least_ LZ4_decoderRingBufferSize(maxBlockSize).
 *    maxBlockSize is the maximum size of any single block. It can have any value > 16 bytes.
 *    In which case, encoding and decoding buffers do not need to be synchronized.
 *    Actually, data can be produced by any source compliant with LZ4 format specification, and respecting maxBlockSize.
 *  - Synchronized mode :
 *    Decompression buffer size is _exactly_ the same as compression buffer size,
 *    and follows exactly same update rule (block boundaries at same positions),
 *    and decoding function is provided with exact decompressed size of each block (exception for last block of the stream),
 *    _then_ decoding & encoding ring buffer can have any size, including small ones ( < 64 KB).
 *  - Decompression buffer is larger than encoding buffer, by a minimum of maxBlockSize more bytes.
 *    In which case, encoding and decoding buffers do not need to be synchronized,
 *    and encoding ring buffer can have any size, including small ones ( < 64 KB).
 *
 *  Whenever these conditions are not possible,
 *  save the last 64KB of decoded data into a safe buffer where it can't be modified during decompression,
 *  then indicate where this data is saved using LZ4_setStreamDecode(), before decompressing next block.
*/
public static native int LZ4_decompress_safe_continue(LZ4StreamDecode LZ4_streamDecode,
                        @Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst,
                        int srcSize, int dstCapacity);
public static native int LZ4_decompress_safe_continue(LZ4StreamDecode LZ4_streamDecode,
                        String src, @Cast("char*") ByteBuffer dst,
                        int srcSize, int dstCapacity);
public static native int LZ4_decompress_safe_continue(LZ4StreamDecode LZ4_streamDecode,
                        @Cast("const char*") BytePointer src, @Cast("char*") byte[] dst,
                        int srcSize, int dstCapacity);
public static native int LZ4_decompress_safe_continue(LZ4StreamDecode LZ4_streamDecode,
                        String src, @Cast("char*") BytePointer dst,
                        int srcSize, int dstCapacity);
public static native int LZ4_decompress_safe_continue(LZ4StreamDecode LZ4_streamDecode,
                        @Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst,
                        int srcSize, int dstCapacity);
public static native int LZ4_decompress_safe_continue(LZ4StreamDecode LZ4_streamDecode,
                        String src, @Cast("char*") byte[] dst,
                        int srcSize, int dstCapacity);


/** LZ4_decompress_*_usingDict() :
 *  These decoding functions work the same as
 *  a combination of LZ4_setStreamDecode() followed by LZ4_decompress_*_continue()
 *  They are stand-alone, and don't need an LZ4_streamDecode_t structure.
 *  Dictionary is presumed stable : it must remain accessible and unmodified during decompression.
 *  Performance tip : Decompression speed can be substantially increased
 *                    when dst == dictStart + dictSize.
 */
public static native int LZ4_decompress_safe_usingDict(@Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst,
                              int srcSize, int dstCapacity,
                              @Cast("const char*") BytePointer dictStart, int dictSize);
public static native int LZ4_decompress_safe_usingDict(String src, @Cast("char*") ByteBuffer dst,
                              int srcSize, int dstCapacity,
                              String dictStart, int dictSize);
public static native int LZ4_decompress_safe_usingDict(@Cast("const char*") BytePointer src, @Cast("char*") byte[] dst,
                              int srcSize, int dstCapacity,
                              @Cast("const char*") BytePointer dictStart, int dictSize);
public static native int LZ4_decompress_safe_usingDict(String src, @Cast("char*") BytePointer dst,
                              int srcSize, int dstCapacity,
                              String dictStart, int dictSize);
public static native int LZ4_decompress_safe_usingDict(@Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst,
                              int srcSize, int dstCapacity,
                              @Cast("const char*") BytePointer dictStart, int dictSize);
public static native int LZ4_decompress_safe_usingDict(String src, @Cast("char*") byte[] dst,
                              int srcSize, int dstCapacity,
                              String dictStart, int dictSize);

public static native int LZ4_decompress_safe_partial_usingDict(@Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst,
                                      int compressedSize,
                                      int targetOutputSize, int maxOutputSize,
                                      @Cast("const char*") BytePointer dictStart, int dictSize);
public static native int LZ4_decompress_safe_partial_usingDict(String src, @Cast("char*") ByteBuffer dst,
                                      int compressedSize,
                                      int targetOutputSize, int maxOutputSize,
                                      String dictStart, int dictSize);
public static native int LZ4_decompress_safe_partial_usingDict(@Cast("const char*") BytePointer src, @Cast("char*") byte[] dst,
                                      int compressedSize,
                                      int targetOutputSize, int maxOutputSize,
                                      @Cast("const char*") BytePointer dictStart, int dictSize);
public static native int LZ4_decompress_safe_partial_usingDict(String src, @Cast("char*") BytePointer dst,
                                      int compressedSize,
                                      int targetOutputSize, int maxOutputSize,
                                      String dictStart, int dictSize);
public static native int LZ4_decompress_safe_partial_usingDict(@Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst,
                                      int compressedSize,
                                      int targetOutputSize, int maxOutputSize,
                                      @Cast("const char*") BytePointer dictStart, int dictSize);
public static native int LZ4_decompress_safe_partial_usingDict(String src, @Cast("char*") byte[] dst,
                                      int compressedSize,
                                      int targetOutputSize, int maxOutputSize,
                                      String dictStart, int dictSize);

// #endif /* LZ4_H_2983827168210 */


/*^*************************************
 * !!!!!!   STATIC LINKING ONLY   !!!!!!
 ***************************************/

/*-****************************************************************************
 * Experimental section
 *
 * Symbols declared in this section must be considered unstable. Their
 * signatures or semantics may change, or they may be removed altogether in the
 * future. They are therefore only safe to depend on when the caller is
 * statically linked against the library.
 *
 * To protect against unsafe usage, not only are the declarations guarded,
 * the definitions are hidden by default
 * when building LZ4 as a shared/dynamic library.
 *
 * In order to access these declarations,
 * define LZ4_STATIC_LINKING_ONLY in your application
 * before including LZ4's headers.
 *
 * In order to make their implementations accessible dynamically, you must
 * define LZ4_PUBLISH_STATIC_FUNCTIONS when building the LZ4 library.
 ******************************************************************************/






// #if defined (__cplusplus)
// #endif


// Parsed from <lz4hc.h>

/*
   LZ4 HC - High Compression Mode of LZ4
   Header File
   Copyright (C) 2011-2020, Yann Collet.
   BSD 2-Clause License (http://www.opensource.org/licenses/bsd-license.php)

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

       * Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
       * Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following disclaimer
   in the documentation and/or other materials provided with the
   distribution.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

   You can contact the author at :
   - LZ4 source repository : https://github.com/lz4/lz4
   - LZ4 public forum : https://groups.google.com/forum/#!forum/lz4c
*/
// #ifndef LZ4_HC_H_19834876238432
// #define LZ4_HC_H_19834876238432

// #if defined (__cplusplus)
// #endif

/* --- Dependency --- */
/* note : lz4hc requires lz4.h/lz4.c for compilation */
// #include "lz4.h"   /* stddef, LZ4LIB_API, LZ4_DEPRECATED */


/* --- Useful constants --- */
public static final int LZ4HC_CLEVEL_MIN =         3;
public static final int LZ4HC_CLEVEL_DEFAULT =     9;
public static final int LZ4HC_CLEVEL_OPT_MIN =    10;
public static final int LZ4HC_CLEVEL_MAX =        12;


/*-************************************
 *  Block Compression
 **************************************/
/** LZ4_compress_HC() :
 *  Compress data from {@code src} into {@code dst}, using the powerful but slower "HC" algorithm.
 * {@code dst} must be already allocated.
 *  Compression is guaranteed to succeed if {@code dstCapacity >= LZ4_compressBound(srcSize)} (see "lz4.h")
 *  Max supported {@code srcSize} value is LZ4_MAX_INPUT_SIZE (see "lz4.h")
 * {@code compressionLevel} : any value between 1 and LZ4HC_CLEVEL_MAX will work.
 *                      Values > LZ4HC_CLEVEL_MAX behave the same as LZ4HC_CLEVEL_MAX.
 * @return : the number of bytes written into 'dst'
 *           or 0 if compression fails.
 */
public static native int LZ4_compress_HC(@Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst, int srcSize, int dstCapacity, int compressionLevel);
public static native int LZ4_compress_HC(String src, @Cast("char*") ByteBuffer dst, int srcSize, int dstCapacity, int compressionLevel);
public static native int LZ4_compress_HC(@Cast("const char*") BytePointer src, @Cast("char*") byte[] dst, int srcSize, int dstCapacity, int compressionLevel);
public static native int LZ4_compress_HC(String src, @Cast("char*") BytePointer dst, int srcSize, int dstCapacity, int compressionLevel);
public static native int LZ4_compress_HC(@Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst, int srcSize, int dstCapacity, int compressionLevel);
public static native int LZ4_compress_HC(String src, @Cast("char*") byte[] dst, int srcSize, int dstCapacity, int compressionLevel);


/* Note :
 *   Decompression functions are provided within "lz4.h" (BSD license)
 */


/** LZ4_compress_HC_extStateHC() :
 *  Same as LZ4_compress_HC(), but using an externally allocated memory segment for {@code state}.
 * {@code state} size is provided by LZ4_sizeofStateHC().
 *  Memory segment must be aligned on 8-bytes boundaries (which a normal malloc() should do properly).
 */
public static native int LZ4_sizeofStateHC();
public static native int LZ4_compress_HC_extStateHC(Pointer stateHC, @Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst, int srcSize, int maxDstSize, int compressionLevel);
public static native int LZ4_compress_HC_extStateHC(Pointer stateHC, String src, @Cast("char*") ByteBuffer dst, int srcSize, int maxDstSize, int compressionLevel);
public static native int LZ4_compress_HC_extStateHC(Pointer stateHC, @Cast("const char*") BytePointer src, @Cast("char*") byte[] dst, int srcSize, int maxDstSize, int compressionLevel);
public static native int LZ4_compress_HC_extStateHC(Pointer stateHC, String src, @Cast("char*") BytePointer dst, int srcSize, int maxDstSize, int compressionLevel);
public static native int LZ4_compress_HC_extStateHC(Pointer stateHC, @Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst, int srcSize, int maxDstSize, int compressionLevel);
public static native int LZ4_compress_HC_extStateHC(Pointer stateHC, String src, @Cast("char*") byte[] dst, int srcSize, int maxDstSize, int compressionLevel);


/** LZ4_compress_HC_destSize() : v1.9.0+
 *  Will compress as much data as possible from {@code src}
 *  to fit into {@code targetDstSize} budget.
 *  Result is provided in 2 parts :
 * @return : the number of bytes written into 'dst' (necessarily <= targetDstSize)
 *           or 0 if compression fails.
 * {@code srcSizePtr} : on success, *srcSizePtr is updated to indicate how much bytes were read from {@code src}
 */
public static native int LZ4_compress_HC_destSize(Pointer stateHC,
                                  @Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst,
                                        IntPointer srcSizePtr, int targetDstSize,
                                        int compressionLevel);
public static native int LZ4_compress_HC_destSize(Pointer stateHC,
                                  String src, @Cast("char*") ByteBuffer dst,
                                        IntBuffer srcSizePtr, int targetDstSize,
                                        int compressionLevel);
public static native int LZ4_compress_HC_destSize(Pointer stateHC,
                                  @Cast("const char*") BytePointer src, @Cast("char*") byte[] dst,
                                        int[] srcSizePtr, int targetDstSize,
                                        int compressionLevel);
public static native int LZ4_compress_HC_destSize(Pointer stateHC,
                                  String src, @Cast("char*") BytePointer dst,
                                        IntPointer srcSizePtr, int targetDstSize,
                                        int compressionLevel);
public static native int LZ4_compress_HC_destSize(Pointer stateHC,
                                  @Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst,
                                        IntBuffer srcSizePtr, int targetDstSize,
                                        int compressionLevel);
public static native int LZ4_compress_HC_destSize(Pointer stateHC,
                                  String src, @Cast("char*") byte[] dst,
                                        int[] srcSizePtr, int targetDstSize,
                                        int compressionLevel);
// Targeting ..\LZ4StreamHC.java

   /* incomplete type (defined later) */

/** LZ4_createStreamHC() and LZ4_freeStreamHC() :
 *  These functions create and release memory for LZ4 HC streaming state.
 *  Newly created states are automatically initialized.
 *  A same state can be used multiple times consecutively,
 *  starting with LZ4_resetStreamHC_fast() to start a new stream of blocks.
 */
public static native LZ4StreamHC LZ4_createStreamHC();
public static native int LZ4_freeStreamHC(LZ4StreamHC streamHCPtr);

/*
  These functions compress data in successive blocks of any size,
  using previous blocks as dictionary, to improve compression ratio.
  One key assumption is that previous blocks (up to 64 KB) remain read-accessible while compressing next blocks.
  There is an exception for ring buffers, which can be smaller than 64 KB.
  Ring-buffer scenario is automatically detected and handled within LZ4_compress_HC_continue().

  Before starting compression, state must be allocated and properly initialized.
  LZ4_createStreamHC() does both, though compression level is set to LZ4HC_CLEVEL_DEFAULT.

  Selecting the compression level can be done with LZ4_resetStreamHC_fast() (starts a new stream)
  or LZ4_setCompressionLevel() (anytime, between blocks in the same stream) (experimental).
  LZ4_resetStreamHC_fast() only works on states which have been properly initialized at least once,
  which is automatically the case when state is created using LZ4_createStreamHC().

  After reset, a first "fictional block" can be designated as initial dictionary,
  using LZ4_loadDictHC() (Optional).

  Invoke LZ4_compress_HC_continue() to compress each successive block.
  The number of blocks is unlimited.
  Previous input blocks, including initial dictionary when present,
  must remain accessible and unmodified during compression.

  It's allowed to update compression level anytime between blocks,
  using LZ4_setCompressionLevel() (experimental).

  'dst' buffer should be sized to handle worst case scenarios
  (see LZ4_compressBound(), it ensures compression success).
  In case of failure, the API does not guarantee recovery,
  so the state _must_ be reset.
  To ensure compression success
  whenever `dst` buffer size cannot be made >= LZ4_compressBound(),
  consider using LZ4_compress_HC_continue_destSize().

  Whenever previous input blocks can't be preserved unmodified in-place during compression of next blocks,
  it's possible to copy the last blocks into a more stable memory space, using LZ4_saveDictHC().
  Return value of LZ4_saveDictHC() is the size of dictionary effectively saved into 'safeBuffer' (<= 64 KB)

  After completing a streaming compression,
  it's possible to start a new stream of blocks, using the same LZ4_streamHC_t state,
  just by resetting it, using LZ4_resetStreamHC_fast().
*/

public static native void LZ4_resetStreamHC_fast(LZ4StreamHC streamHCPtr, int compressionLevel);   /* v1.9.0+ */
public static native int LZ4_loadDictHC(LZ4StreamHC streamHCPtr, @Cast("const char*") BytePointer dictionary, int dictSize);
public static native int LZ4_loadDictHC(LZ4StreamHC streamHCPtr, String dictionary, int dictSize);

public static native int LZ4_compress_HC_continue(LZ4StreamHC streamHCPtr,
                                   @Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst,
                                         int srcSize, int maxDstSize);
public static native int LZ4_compress_HC_continue(LZ4StreamHC streamHCPtr,
                                   String src, @Cast("char*") ByteBuffer dst,
                                         int srcSize, int maxDstSize);
public static native int LZ4_compress_HC_continue(LZ4StreamHC streamHCPtr,
                                   @Cast("const char*") BytePointer src, @Cast("char*") byte[] dst,
                                         int srcSize, int maxDstSize);
public static native int LZ4_compress_HC_continue(LZ4StreamHC streamHCPtr,
                                   String src, @Cast("char*") BytePointer dst,
                                         int srcSize, int maxDstSize);
public static native int LZ4_compress_HC_continue(LZ4StreamHC streamHCPtr,
                                   @Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst,
                                         int srcSize, int maxDstSize);
public static native int LZ4_compress_HC_continue(LZ4StreamHC streamHCPtr,
                                   String src, @Cast("char*") byte[] dst,
                                         int srcSize, int maxDstSize);

/** LZ4_compress_HC_continue_destSize() : v1.9.0+
 *  Similar to LZ4_compress_HC_continue(),
 *  but will read as much data as possible from {@code src}
 *  to fit into {@code targetDstSize} budget.
 *  Result is provided into 2 parts :
 * @return : the number of bytes written into 'dst' (necessarily <= targetDstSize)
 *           or 0 if compression fails.
 * {@code srcSizePtr} : on success, *srcSizePtr will be updated to indicate how much bytes were read from {@code src}.
 *           Note that this function may not consume the entire input.
 */
public static native int LZ4_compress_HC_continue_destSize(LZ4StreamHC LZ4_streamHCPtr,
                                           @Cast("const char*") BytePointer src, @Cast("char*") BytePointer dst,
                                                 IntPointer srcSizePtr, int targetDstSize);
public static native int LZ4_compress_HC_continue_destSize(LZ4StreamHC LZ4_streamHCPtr,
                                           String src, @Cast("char*") ByteBuffer dst,
                                                 IntBuffer srcSizePtr, int targetDstSize);
public static native int LZ4_compress_HC_continue_destSize(LZ4StreamHC LZ4_streamHCPtr,
                                           @Cast("const char*") BytePointer src, @Cast("char*") byte[] dst,
                                                 int[] srcSizePtr, int targetDstSize);
public static native int LZ4_compress_HC_continue_destSize(LZ4StreamHC LZ4_streamHCPtr,
                                           String src, @Cast("char*") BytePointer dst,
                                                 IntPointer srcSizePtr, int targetDstSize);
public static native int LZ4_compress_HC_continue_destSize(LZ4StreamHC LZ4_streamHCPtr,
                                           @Cast("const char*") BytePointer src, @Cast("char*") ByteBuffer dst,
                                                 IntBuffer srcSizePtr, int targetDstSize);
public static native int LZ4_compress_HC_continue_destSize(LZ4StreamHC LZ4_streamHCPtr,
                                           String src, @Cast("char*") byte[] dst,
                                                 int[] srcSizePtr, int targetDstSize);

public static native int LZ4_saveDictHC(LZ4StreamHC streamHCPtr, @Cast("char*") BytePointer safeBuffer, int maxDictSize);
public static native int LZ4_saveDictHC(LZ4StreamHC streamHCPtr, @Cast("char*") ByteBuffer safeBuffer, int maxDictSize);
public static native int LZ4_saveDictHC(LZ4StreamHC streamHCPtr, @Cast("char*") byte[] safeBuffer, int maxDictSize);



/*^**********************************************
 * !!!!!!   STATIC LINKING ONLY   !!!!!!
 ***********************************************/

/*-******************************************************************
 * PRIVATE DEFINITIONS :
 * Do not use these definitions directly.
 * They are merely exposed to allow static allocation of `LZ4_streamHC_t`.
 * Declare an `LZ4_streamHC_t` directly, rather than any type below.
 * Even then, only do so in the context of static linking, as definitions may change between versions.
 ********************************************************************/



// #if defined (__cplusplus)
// #endif

// #endif /* LZ4_HC_H_19834876238432 */


/*-**************************************************
 * !!!!!     STATIC LINKING ONLY     !!!!!
 * Following definitions are considered experimental.
 * They should not be linked from DLL,
 * as there is no guarantee of API stability yet.
 * Prototypes will be promoted to "stable" status
 * after successful usage in real-life scenarios.
 ***************************************************/
// #ifdef LZ4_HC_STATIC_LINKING_ONLY   /* protection macro */
// #ifndef LZ4_HC_SLO_098092834
// #define LZ4_HC_SLO_098092834



// Parsed from <lz4frame.h>

/*
   LZ4F - LZ4-Frame library
   Header File
   Copyright (C) 2011-2020, Yann Collet.
   BSD 2-Clause License (http://www.opensource.org/licenses/bsd-license.php)

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

       * Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
       * Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following disclaimer
   in the documentation and/or other materials provided with the
   distribution.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

   You can contact the author at :
   - LZ4 source repository : https://github.com/lz4/lz4
   - LZ4 public forum : https://groups.google.com/forum/#!forum/lz4c
*/

/* LZ4F is a stand-alone API able to create and decode LZ4 frames
 * conformant with specification v1.6.1 in doc/lz4_Frame_format.md .
 * Generated frames are compatible with `lz4` CLI.
 *
 * LZ4F also offers streaming capabilities.
 *
 * lz4.h is not required when using lz4frame.h,
 * except to extract common constants such as LZ4_VERSION_NUMBER.
 * */

// #ifndef LZ4F_H_09782039843
// #define LZ4F_H_09782039843

// #if defined (__cplusplus)
// #endif

/* ---   Dependency   --- */
// #include <stddef.h>   /* size_t */


/**
 * Introduction
 *
 * lz4frame.h implements LZ4 frame specification: see doc/lz4_Frame_format.md .
 * LZ4 Frames are compatible with {@code lz4} CLI,
 * and designed to be interoperable with any system.
**/

/*-***************************************************************
 *  Compiler specifics
 *****************************************************************/
/*  LZ4_DLL_EXPORT :
 *  Enable exporting of functions when building a Windows DLL
 *  LZ4FLIB_VISIBILITY :
 *  Control library symbols visibility.
 */
// #ifndef LZ4FLIB_VISIBILITY
// #  if defined(__GNUC__) && (__GNUC__ >= 4)
// #    define LZ4FLIB_VISIBILITY __attribute__ ((visibility ("default")))
// #  else
// #    define LZ4FLIB_VISIBILITY
// #  endif
// #endif
// #if defined(LZ4_DLL_EXPORT) && (LZ4_DLL_EXPORT==1)
// #  define LZ4FLIB_API __declspec(dllexport) LZ4FLIB_VISIBILITY
// #elif defined(LZ4_DLL_IMPORT) && (LZ4_DLL_IMPORT==1)
// #  define LZ4FLIB_API __declspec(dllimport) LZ4FLIB_VISIBILITY
// #else
// #  define LZ4FLIB_API LZ4FLIB_VISIBILITY
// #endif

// #ifdef LZ4F_DISABLE_DEPRECATE_WARNINGS
// #  define LZ4F_DEPRECATE(x) x
// #else
// #  if defined(_MSC_VER)
// #    define LZ4F_DEPRECATE(x) x   /* __declspec(deprecated) x - only works with C++ */
// #  elif defined(__clang__) || (defined(__GNUC__) && (__GNUC__ >= 6))
// #    define LZ4F_DEPRECATE(x) x __attribute__((deprecated))
// #  else
// #    define LZ4F_DEPRECATE(x) x   /* no deprecation warning for this compiler */
// #  endif
// #endif


/*-************************************
 *  Error management
 **************************************/

/** tells when a function result is an error code */
public static native @Cast("unsigned") int LZ4F_isError(@Cast("LZ4F_errorCode_t") long code);
/** return error code string; for debugging */
public static native @Cast("const char*") BytePointer LZ4F_getErrorName(@Cast("LZ4F_errorCode_t") long code);


/*-************************************
 *  Frame compression types
 ************************************* */
/* #define LZ4F_ENABLE_OBSOLETE_ENUMS   // uncomment to enable obsolete enums */
// #ifdef LZ4F_ENABLE_OBSOLETE_ENUMS
// #else
// #  define LZ4F_OBSOLETE_ENUM(x)
// #endif

/* The larger the block size, the (slightly) better the compression ratio,
 * though there are diminishing returns.
 * Larger blocks also increase memory usage on both compression and decompression sides.
 */
/** enum LZ4F_blockSizeID_t */
public static final int
    LZ4F_default = 0,
    LZ4F_max64KB = 4,
    LZ4F_max256KB = 5,
    LZ4F_max1MB = 6,
    LZ4F_max4MB = 7;

/* Linked blocks sharply reduce inefficiencies when using small blocks,
 * they compress better.
 * However, some LZ4 decoders are only compatible with independent blocks */
/** enum LZ4F_blockMode_t */
public static final int
    LZ4F_blockLinked = 0,
    LZ4F_blockIndependent = 1;

/** enum LZ4F_contentChecksum_t */
public static final int
    LZ4F_noContentChecksum = 0,
    LZ4F_contentChecksumEnabled = 1;

/** enum LZ4F_blockChecksum_t */
public static final int
    LZ4F_noBlockChecksum = 0,
    LZ4F_blockChecksumEnabled = 1;

/** enum LZ4F_frameType_t */
public static final int
    LZ4F_frame = 0,
    LZ4F_skippableFrame = 1;
// Targeting ..\LZ4FFrameInfo.java



// #define LZ4F_INIT_FRAMEINFO   { LZ4F_default, LZ4F_blockLinked, LZ4F_noContentChecksum, LZ4F_frame, 0L, 0, LZ4F_noBlockChecksum }
// Targeting ..\LZ4FPreferences.java



// #define LZ4F_INIT_PREFERENCES   { LZ4F_INIT_FRAMEINFO, 0, 0, 0, { 0, 0, 0 } }    /* v1.8.3+ */


/*-*********************************
*  Simple compression function
***********************************/

public static native int LZ4F_compressionLevel_max();   /* v1.8.0+ */

/** LZ4F_compressFrameBound() :
 *  Returns the maximum possible compressed size with LZ4F_compressFrame() given srcSize and preferences.
 * {@code preferencesPtr} is optional. It can be replaced by NULL, in which case, the function will assume default preferences.
 *  Note : this result is only usable with LZ4F_compressFrame().
 *         It may also be relevant to LZ4F_compressUpdate() _only if_ no flush() operation is ever performed.
 */
public static native @Cast("size_t") long LZ4F_compressFrameBound(@Cast("size_t") long srcSize, @Const LZ4FPreferences preferencesPtr);

/** LZ4F_compressFrame() :
 *  Compress an entire srcBuffer into a valid LZ4 frame.
 *  dstCapacity MUST be >= LZ4F_compressFrameBound(srcSize, preferencesPtr).
 *  The LZ4F_preferences_t structure is optional : you can provide NULL as argument. All preferences will be set to default.
 * @return : number of bytes written into dstBuffer.
 *           or an error code if it fails (can be tested using LZ4F_isError())
 */
public static native @Cast("size_t") long LZ4F_compressFrame(Pointer dstBuffer, @Cast("size_t") long dstCapacity,
                                @Const Pointer srcBuffer, @Cast("size_t") long srcSize,
                                @Const LZ4FPreferences preferencesPtr);
// Targeting ..\LZ4FCompressionContext.java

   /* incomplete type */
// Targeting ..\LZ4FCompressOptions.java



/*---   Resource Management   ---*/

public static final int LZ4F_VERSION = 100;    /* This number can be used to check for an incompatible API breaking change */
public static native @Cast("unsigned") int LZ4F_getVersion();

/** LZ4F_createCompressionContext() :
 *  The first thing to do is to create a compressionContext object,
 *  which will keep track of operation state during streaming compression.
 *  This is achieved using LZ4F_createCompressionContext(), which takes as argument a version,
 *  and a pointer to LZ4F_cctx*, to write the resulting pointer into.
 *  @version provided MUST be LZ4F_VERSION. It is intended to track potential version mismatch, notably when using DLL.
 *  The function provides a pointer to a fully allocated LZ4F_cctx object.
 *  \cctxPtr MUST be != NULL.
 *  If @return != zero, context creation failed.
 *  A created compression context can be employed multiple times for consecutive streaming operations.
 *  Once all streaming compression jobs are completed,
 *  the state object can be released using LZ4F_freeCompressionContext().
 *  Note1 : LZ4F_freeCompressionContext() is always successful. Its return value can be ignored.
 *  Note2 : LZ4F_freeCompressionContext() works fine with NULL input pointers (do nothing).
**/
public static native @Cast("LZ4F_errorCode_t") long LZ4F_createCompressionContext(@Cast("LZ4F_cctx**") PointerPointer cctxPtr, @Cast("unsigned") int version);
public static native @Cast("LZ4F_errorCode_t") long LZ4F_createCompressionContext(@ByPtrPtr LZ4FCompressionContext cctxPtr, @Cast("unsigned") int version);
public static native @Cast("LZ4F_errorCode_t") long LZ4F_freeCompressionContext(LZ4FCompressionContext cctx);


/*----    Compression    ----*/

public static final int LZ4F_HEADER_SIZE_MIN =  7;   /* LZ4 Frame header size can vary, depending on selected parameters */
public static final int LZ4F_HEADER_SIZE_MAX = 19;

/* Size in bytes of a block header in little-endian format. Highest bit indicates if block data is uncompressed */
public static final int LZ4F_BLOCK_HEADER_SIZE = 4;

/* Size in bytes of a block checksum footer in little-endian format. */
public static final int LZ4F_BLOCK_CHECKSUM_SIZE = 4;

/* Size in bytes of the content checksum. */
public static final int LZ4F_CONTENT_CHECKSUM_SIZE = 4;

/** LZ4F_compressBegin() :
 *  will write the frame header into dstBuffer.
 *  dstCapacity must be >= LZ4F_HEADER_SIZE_MAX bytes.
 * {@code prefsPtr} is optional : you can provide NULL as argument, all preferences will then be set to default.
 * @return : number of bytes written into dstBuffer for the header
 *           or an error code (which can be tested using LZ4F_isError())
 */
public static native @Cast("size_t") long LZ4F_compressBegin(LZ4FCompressionContext cctx,
                                      Pointer dstBuffer, @Cast("size_t") long dstCapacity,
                                      @Const LZ4FPreferences prefsPtr);

/** LZ4F_compressBound() :
 *  Provides minimum dstCapacity required to guarantee success of
 *  LZ4F_compressUpdate(), given a srcSize and preferences, for a worst case scenario.
 *  When srcSize==0, LZ4F_compressBound() provides an upper bound for LZ4F_flush() and LZ4F_compressEnd() instead.
 *  Note that the result is only valid for a single invocation of LZ4F_compressUpdate().
 *  When invoking LZ4F_compressUpdate() multiple times,
 *  if the output buffer is gradually filled up instead of emptied and re-used from its start,
 *  one must check if there is enough remaining capacity before each invocation, using LZ4F_compressBound().
 * @return is always the same for a srcSize and prefsPtr.
 *  prefsPtr is optional : when NULL is provided, preferences will be set to cover worst case scenario.
 *  tech details :
 * @return if automatic flushing is not enabled, includes the possibility that internal buffer might already be filled by up to (blockSize-1) bytes.
 *  It also includes frame footer (ending + checksum), since it might be generated by LZ4F_compressEnd().
 * @return doesn't include frame header, as it was already generated by LZ4F_compressBegin().
 */
public static native @Cast("size_t") long LZ4F_compressBound(@Cast("size_t") long srcSize, @Const LZ4FPreferences prefsPtr);

/** LZ4F_compressUpdate() :
 *  LZ4F_compressUpdate() can be called repetitively to compress as much data as necessary.
 *  Important rule: dstCapacity MUST be large enough to ensure operation success even in worst case situations.
 *  This value is provided by LZ4F_compressBound().
 *  If this condition is not respected, LZ4F_compress() will fail (result is an errorCode).
 *  After an error, the state is left in a UB state, and must be re-initialized or freed.
 *  If previously an uncompressed block was written, buffered data is flushed
 *  before appending compressed data is continued.
 * {@code cOptPtr} is optional : NULL can be provided, in which case all options are set to default.
 * @return : number of bytes written into {@code dstBuffer} (it can be zero, meaning input data was just buffered).
 *           or an error code if it fails (which can be tested using LZ4F_isError())
 */
public static native @Cast("size_t") long LZ4F_compressUpdate(LZ4FCompressionContext cctx,
                                       Pointer dstBuffer, @Cast("size_t") long dstCapacity,
                                 @Const Pointer srcBuffer, @Cast("size_t") long srcSize,
                                 @Const LZ4FCompressOptions cOptPtr);

/** LZ4F_flush() :
 *  When data must be generated and sent immediately, without waiting for a block to be completely filled,
 *  it's possible to call LZ4_flush(). It will immediately compress any data buffered within cctx.
 * {@code dstCapacity} must be large enough to ensure the operation will be successful.
 * {@code cOptPtr} is optional : it's possible to provide NULL, all options will be set to default.
 * @return : nb of bytes written into dstBuffer (can be zero, when there is no data stored within cctx)
 *           or an error code if it fails (which can be tested using LZ4F_isError())
 *  Note : LZ4F_flush() is guaranteed to be successful when dstCapacity >= LZ4F_compressBound(0, prefsPtr).
 */
public static native @Cast("size_t") long LZ4F_flush(LZ4FCompressionContext cctx,
                              Pointer dstBuffer, @Cast("size_t") long dstCapacity,
                        @Const LZ4FCompressOptions cOptPtr);

/** LZ4F_compressEnd() :
 *  To properly finish an LZ4 frame, invoke LZ4F_compressEnd().
 *  It will flush whatever data remained within {@code cctx} (like LZ4_flush())
 *  and properly finalize the frame, with an endMark and a checksum.
 * {@code cOptPtr} is optional : NULL can be provided, in which case all options will be set to default.
 * @return : nb of bytes written into dstBuffer, necessarily >= 4 (endMark),
 *           or an error code if it fails (which can be tested using LZ4F_isError())
 *  Note : LZ4F_compressEnd() is guaranteed to be successful when dstCapacity >= LZ4F_compressBound(0, prefsPtr).
 *  A successful call to LZ4F_compressEnd() makes {@code cctx} available again for another compression task.
 */
public static native @Cast("size_t") long LZ4F_compressEnd(LZ4FCompressionContext cctx,
                                    Pointer dstBuffer, @Cast("size_t") long dstCapacity,
                              @Const LZ4FCompressOptions cOptPtr);
// Targeting ..\LZ4FDecompressionContext.java

   /* incomplete type */
// Targeting ..\LZ4FDecompressOptions.java




/* Resource management */

/** LZ4F_createDecompressionContext() :
 *  Create an LZ4F_dctx object, to track all decompression operations.
 *  @version provided MUST be LZ4F_VERSION.
 *  \dctxPtr MUST be valid.
 *  The function fills \dctxPtr with the value of a pointer to an allocated and initialized LZ4F_dctx object.
 *  The @return is an errorCode, which can be tested using LZ4F_isError().
 *  dctx memory can be released using LZ4F_freeDecompressionContext();
 *  Result of LZ4F_freeDecompressionContext() indicates current state of decompressionContext when being released.
 *  That is, it should be == 0 if decompression has been completed fully and correctly.
 */
public static native @Cast("LZ4F_errorCode_t") long LZ4F_createDecompressionContext(@Cast("LZ4F_dctx**") PointerPointer dctxPtr, @Cast("unsigned") int version);
public static native @Cast("LZ4F_errorCode_t") long LZ4F_createDecompressionContext(@ByPtrPtr LZ4FDecompressionContext dctxPtr, @Cast("unsigned") int version);
public static native @Cast("LZ4F_errorCode_t") long LZ4F_freeDecompressionContext(LZ4FDecompressionContext dctx);


/*-***********************************
*  Streaming decompression functions
*************************************/

public static final int LZ4F_MAGICNUMBER = 0x184D2204;
public static final int LZ4F_MAGIC_SKIPPABLE_START = 0x184D2A50;
public static final int LZ4F_MIN_SIZE_TO_KNOW_HEADER_LENGTH = 5;

/** LZ4F_headerSize() : v1.9.0+
 *  Provide the header size of a frame starting at {@code src}.
 * {@code srcSize} must be >= LZ4F_MIN_SIZE_TO_KNOW_HEADER_LENGTH,
 *  which is enough to decode the header length.
 * @return : size of frame header
 *           or an error code, which can be tested using LZ4F_isError()
 *  note : Frame header size is variable, but is guaranteed to be
 *         >= LZ4F_HEADER_SIZE_MIN bytes, and <= LZ4F_HEADER_SIZE_MAX bytes.
 */
public static native @Cast("size_t") long LZ4F_headerSize(@Const Pointer src, @Cast("size_t") long srcSize);

/** LZ4F_getFrameInfo() :
 *  This function extracts frame parameters (max blockSize, dictID, etc.).
 *  Its usage is optional: user can also invoke LZ4F_decompress() directly.
 *
 *  Extracted information will fill an existing LZ4F_frameInfo_t structure.
 *  This can be useful for allocation and dictionary identification purposes.
 *
 *  LZ4F_getFrameInfo() can work in the following situations :
 *
 *  1) At the beginning of a new frame, before any invocation of LZ4F_decompress().
 *     It will decode header from {@code srcBuffer},
 *     consuming the header and starting the decoding process.
 *
 *     Input size must be large enough to contain the full frame header.
 *     Frame header size can be known beforehand by LZ4F_headerSize().
 *     Frame header size is variable, but is guaranteed to be >= LZ4F_HEADER_SIZE_MIN bytes,
 *     and not more than <= LZ4F_HEADER_SIZE_MAX bytes.
 *     Hence, blindly providing LZ4F_HEADER_SIZE_MAX bytes or more will always work.
 *     It's allowed to provide more input data than the header size,
 *     LZ4F_getFrameInfo() will only consume the header.
 *
 *     If input size is not large enough,
 *     aka if it's smaller than header size,
 *     function will fail and return an error code.
 *
 *  2) After decoding has been started,
 *     it's possible to invoke LZ4F_getFrameInfo() anytime
 *     to extract already decoded frame parameters stored within dctx.
 *
 *     Note that, if decoding has barely started,
 *     and not yet read enough information to decode the header,
 *     LZ4F_getFrameInfo() will fail.
 *
 *  The number of bytes consumed from srcBuffer will be updated in *srcSizePtr (necessarily <= original value).
 *  LZ4F_getFrameInfo() only consumes bytes when decoding has not yet started,
 *  and when decoding the header has been successful.
 *  Decompression must then resume from (srcBuffer + *srcSizePtr).
 *
 * @return : a hint about how many srcSize bytes LZ4F_decompress() expects for next call,
 *           or an error code which can be tested using LZ4F_isError().
 *  note 1 : in case of error, dctx is not modified. Decoding operation can resume from beginning safely.
 *  note 2 : frame parameters are *copied into* an already allocated LZ4F_frameInfo_t structure.
 */
public static native @Cast("size_t") long LZ4F_getFrameInfo(LZ4FDecompressionContext dctx,
                  LZ4FFrameInfo frameInfoPtr,
            @Const Pointer srcBuffer, @Cast("size_t*") SizeTPointer srcSizePtr);

/** LZ4F_decompress() :
 *  Call this function repetitively to regenerate data compressed in {@code srcBuffer}.
 *
 *  The function requires a valid dctx state.
 *  It will read up to *srcSizePtr bytes from srcBuffer,
 *  and decompress data into dstBuffer, of capacity *dstSizePtr.
 *
 *  The nb of bytes consumed from srcBuffer will be written into *srcSizePtr (necessarily <= original value).
 *  The nb of bytes decompressed into dstBuffer will be written into *dstSizePtr (necessarily <= original value).
 *
 *  The function does not necessarily read all input bytes, so always check value in *srcSizePtr.
 *  Unconsumed source data must be presented again in subsequent invocations.
 *
 * {@code dstBuffer} can freely change between each consecutive function invocation.
 * {@code dstBuffer} content will be overwritten.
 *
 * @return : an hint of how many {@code srcSize} bytes LZ4F_decompress() expects for next call.
 *  Schematically, it's the size of the current (or remaining) compressed block + header of next block.
 *  Respecting the hint provides some small speed benefit, because it skips intermediate buffers.
 *  This is just a hint though, it's always possible to provide any srcSize.
 *
 *  When a frame is fully decoded, @return will be 0 (no more data expected).
 *  When provided with more bytes than necessary to decode a frame,
 *  LZ4F_decompress() will stop reading exactly at end of current frame, and @return 0.
 *
 *  If decompression failed, @return is an error code, which can be tested using LZ4F_isError().
 *  After a decompression error, the {@code dctx} context is not resumable.
 *  Use LZ4F_resetDecompressionContext() to return to clean state.
 *
 *  After a frame is fully decoded, dctx can be used again to decompress another frame.
 */
public static native @Cast("size_t") long LZ4F_decompress(LZ4FDecompressionContext dctx,
                Pointer dstBuffer, @Cast("size_t*") SizeTPointer dstSizePtr,
          @Const Pointer srcBuffer, @Cast("size_t*") SizeTPointer srcSizePtr,
          @Const LZ4FDecompressOptions dOptPtr);


/** LZ4F_resetDecompressionContext() : added in v1.8.0
 *  In case of an error, the context is left in "undefined" state.
 *  In which case, it's necessary to reset it, before re-using it.
 *  This method can also be used to abruptly stop any unfinished decompression,
 *  and start a new one using same context resources. */
public static native void LZ4F_resetDecompressionContext(LZ4FDecompressionContext dctx);   /* always successful */



// #if defined (__cplusplus)
// #endif

// #endif  /* LZ4F_H_09782039843 */



}
