// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.mkldnn;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.mkldnn.global.mklml.*;

import static org.bytedeco.mkldnn.global.mkldnn.*;


/** Generic description of blocked data layout for most memory formats.
 *
 * @see \ref understanding_memory_formats */
@Properties(inherit = org.bytedeco.mkldnn.presets.mkldnn.class)
public class mkldnn_blocking_desc_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mkldnn_blocking_desc_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mkldnn_blocking_desc_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mkldnn_blocking_desc_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mkldnn_blocking_desc_t position(long position) {
        return (mkldnn_blocking_desc_t)super.position(position);
    }

    /** Block size for each of the dimensions. */
    @MemberGetter public native @Const IntPointer block_dims();
    /** strides[0]: stride between the first elements of adjacent blocks.
     * \n strides[1]: strides between elements in the same block. */
    @MemberGetter public native @Const CLongPointer strides(int i);
    @MemberGetter public native @Cast("const long**") PointerPointer strides();
    /** Size of the data including padding in each dimension. */
    @MemberGetter public native @Const IntPointer padding_dims();
    /** Per-dimension offset from the padding to actual data, the top-level
     * tensor with offsets applied must lie within the padding area. */
    @MemberGetter public native @Const IntPointer offset_padding_to_data();
    /** Offset from memory origin to the current block, non-zero only in
     * a description of a memory sub-block. */
    public native @Cast("ptrdiff_t") long offset_padding(); public native mkldnn_blocking_desc_t offset_padding(long setter);
}
