// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.mkldnn;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.mkldnn.global.mklml.*;

import static org.bytedeco.mkldnn.global.mkldnn.*;


/** A descriptor for an RNN operation. */
@Properties(inherit = org.bytedeco.mkldnn.presets.mkldnn.class)
public class mkldnn_rnn_desc_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mkldnn_rnn_desc_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mkldnn_rnn_desc_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mkldnn_rnn_desc_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mkldnn_rnn_desc_t position(long position) {
        return (mkldnn_rnn_desc_t)super.position(position);
    }

    /** The kind of primitive. Used for self-identifying the primitive
     * descriptor. Must be #mkldnn_rnn. */
    public native @Cast("mkldnn_primitive_kind_t") int primitive_kind(); public native mkldnn_rnn_desc_t primitive_kind(int setter);
    /** The kind of propagation. Possible values: #mkldnn_forward_training,
     * #mkldnn_forward_inference, and #mkldnn_backward. */
    public native @Cast("mkldnn_prop_kind_t") int prop_kind(); public native mkldnn_rnn_desc_t prop_kind(int setter);
    /** The RNN cell desc. */
    public native @ByRef mkldnn_rnn_cell_desc_t cell_desc(); public native mkldnn_rnn_desc_t cell_desc(mkldnn_rnn_cell_desc_t setter);
    /** The direction of RNN primitive execution. */
    public native @Cast("mkldnn_rnn_direction_t") int direction(); public native mkldnn_rnn_desc_t direction(int setter);
    /** Source layer memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t src_layer_desc(); public native mkldnn_rnn_desc_t src_layer_desc(mkldnn_memory_desc_t setter);
    /** Source iteration memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t src_iter_desc(); public native mkldnn_rnn_desc_t src_iter_desc(mkldnn_memory_desc_t setter);
    /** Weights layer memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t weights_layer_desc(); public native mkldnn_rnn_desc_t weights_layer_desc(mkldnn_memory_desc_t setter);
    /** Weights iteration memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t weights_iter_desc(); public native mkldnn_rnn_desc_t weights_iter_desc(mkldnn_memory_desc_t setter);
    /** Bias memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t bias_desc(); public native mkldnn_rnn_desc_t bias_desc(mkldnn_memory_desc_t setter);
    /** Destination layer memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t dst_layer_desc(); public native mkldnn_rnn_desc_t dst_layer_desc(mkldnn_memory_desc_t setter);
    /** Destination iter memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t dst_iter_desc(); public native mkldnn_rnn_desc_t dst_iter_desc(mkldnn_memory_desc_t setter);
    /** Source gradient layer memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t diff_src_layer_desc(); public native mkldnn_rnn_desc_t diff_src_layer_desc(mkldnn_memory_desc_t setter);
    /** Source gradient iter memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t diff_src_iter_desc(); public native mkldnn_rnn_desc_t diff_src_iter_desc(mkldnn_memory_desc_t setter);
    /** Weights gradient layer memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t diff_weights_layer_desc(); public native mkldnn_rnn_desc_t diff_weights_layer_desc(mkldnn_memory_desc_t setter);
    /** Weights gradient iter memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t diff_weights_iter_desc(); public native mkldnn_rnn_desc_t diff_weights_iter_desc(mkldnn_memory_desc_t setter);
    /** Bias gradient memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t diff_bias_desc(); public native mkldnn_rnn_desc_t diff_bias_desc(mkldnn_memory_desc_t setter);
    /** Destination gradient layer memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t diff_dst_layer_desc(); public native mkldnn_rnn_desc_t diff_dst_layer_desc(mkldnn_memory_desc_t setter);
    /** Destination gradient iteration memory descriptor. */
    public native @ByRef mkldnn_memory_desc_t diff_dst_iter_desc(); public native mkldnn_rnn_desc_t diff_dst_iter_desc(mkldnn_memory_desc_t setter);
}
