// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.mkldnn;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.mkldnn.global.mklml.*;

import static org.bytedeco.mkldnn.global.mkldnn.*;


// #ifndef DOXYGEN_SHOULD_SKIP_THIS
// #endif

/** Base class for all computational primitives. */
@Namespace("mkldnn") @Properties(inherit = org.bytedeco.mkldnn.presets.mkldnn.class)
public class primitive extends mkldnn_primitive_handle {
    static { Loader.load(); }
    /** Default native constructor. */
    public primitive() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public primitive(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public primitive(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public primitive position(long position) {
        return (primitive)super.position(position);
    }

    /** A proxy to C primitive kind enum */
    /** enum class mkldnn::primitive::kind */
    public static final int
        undefined_primitive = mkldnn_undefined_primitive,
        memory = mkldnn_memory,
        view = mkldnn_view,
        reorder = mkldnn_reorder,
        concat = mkldnn_concat,
        concat_inplace = mkldnn_concat_inplace,
        sum = mkldnn_sum,
        convolution = mkldnn_convolution,
        deconvolution = mkldnn_deconvolution,
        shuffle = mkldnn_shuffle,
        eltwise = mkldnn_eltwise,
        softmax = mkldnn_softmax,
        pooling = mkldnn_pooling,
        lrn = mkldnn_lrn,
        batch_normalization = mkldnn_batch_normalization,
        inner_product = mkldnn_inner_product,
        rnn = mkldnn_rnn;

    /** A wrapper structure to specify a particular output of a primitive. */
    @NoOffset public static class at extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public at(Pointer p) { super(p); }
    
        /** The underlying C API structure. */
        
        ///
        public native @ByRef mkldnn_primitive_at_t data(); public native at data(mkldnn_primitive_at_t setter);
        /** Constructs a wrapper specifying \p aprimitive output with index \p
         *  at.
         * 
         *  @param aprimitive The target primitive.
         *  @param at The output index. */

        public at(@Const @ByRef primitive aprimitive, @Cast("size_t") long at/*=0*/) { super((Pointer)null); allocate(aprimitive, at); }
        private native void allocate(@Const @ByRef primitive aprimitive, @Cast("size_t") long at/*=0*/);
        public at(@Const @ByRef primitive aprimitive) { super((Pointer)null); allocate(aprimitive); }
        private native void allocate(@Const @ByRef primitive aprimitive);
        /** Returns the specified output. */
        public native @ByVal @Name("operator mkldnn::primitive") primitive asPrimitive();
    }

    /** Returns the descriptor of the underlying C API primitive. */
    public native @Name("get_primitive_desc") @Const mkldnn_primitive_desc get_mkldnn_primitive_desc();
    // TODO: use the C++ API wrapper structure.
}
