// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.mkldnn;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.mkldnn.global.mklml.*;

import static org.bytedeco.mkldnn.global.mkldnn.*;


/** \}
 <p>
 *  \addtogroup cpp_api_batch_norm Batch normalization
 *  A primitive to perform batch normalization.
 * 
 *  @see \ref c_api_batch_normalization in \ref c_api
 *  \{ */

@Namespace("mkldnn") @Properties(inherit = org.bytedeco.mkldnn.presets.mkldnn.class)
public class batch_normalization_forward extends primitive {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public batch_normalization_forward(Pointer p) { super(p); }

    @NoOffset public static class desc extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public desc(Pointer p) { super(p); }
    
        public native @ByRef mkldnn_batch_normalization_desc_t data(); public native desc data(mkldnn_batch_normalization_desc_t setter);
        public desc(@Cast("mkldnn::prop_kind") int aprop_kind, @Const @ByRef memory.desc src_desc, float epsilon,
                        @Cast("unsigned") int flags) { super((Pointer)null); allocate(aprop_kind, src_desc, epsilon, flags); }
        private native void allocate(@Cast("mkldnn::prop_kind") int aprop_kind, @Const @ByRef memory.desc src_desc, float epsilon,
                        @Cast("unsigned") int flags);
    }

    public static class primitive_desc extends org.bytedeco.mkldnn.primitive_desc {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public primitive_desc(Pointer p) { super(p); }
    
        public primitive_desc(@Const @ByRef desc desc, @Const @ByRef engine e) { super((Pointer)null); allocate(desc, e); }
        private native void allocate(@Const @ByRef desc desc, @Const @ByRef engine e);

        public primitive_desc(@Const @ByRef desc desc, @Const @ByRef primitive_attr attr, @Const @ByRef engine e) { super((Pointer)null); allocate(desc, attr, e); }
        private native void allocate(@Const @ByRef desc desc, @Const @ByRef primitive_attr attr, @Const @ByRef engine e);

        public native @ByVal memory.primitive_desc src_primitive_desc();
        public native @ByVal memory.primitive_desc weights_primitive_desc();
        public native @ByVal memory.primitive_desc dst_primitive_desc();
        public native @ByVal memory.primitive_desc workspace_primitive_desc();

        public native @ByVal memory.primitive_desc mean_primitive_desc();
        public native @ByVal memory.primitive_desc variance_primitive_desc();
    }

    public batch_normalization_forward(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef primitive.at mean,
                @Const @ByRef primitive.at variance, @Const @ByRef primitive.at weights,
                @Const @ByRef memory dst) { super((Pointer)null); allocate(aprimitive_desc, src, mean, variance, weights, dst); }
    private native void allocate(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef primitive.at mean,
                @Const @ByRef primitive.at variance, @Const @ByRef primitive.at weights,
                @Const @ByRef memory dst);

    public batch_normalization_forward(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef primitive.at mean,
                @Const @ByRef primitive.at variance, @Const @ByRef memory dst) { super((Pointer)null); allocate(aprimitive_desc, src, mean, variance, dst); }
    private native void allocate(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef primitive.at mean,
                @Const @ByRef primitive.at variance, @Const @ByRef memory dst);

    /** \warning batch_normalization_forward has two constructors with very
     *           similar signatures:
     *            - (pd, src, weights, dst, mean, variance) // 2 in, 3 out
     *            - (pd, src, dst, mean, variance, workspace) // 1 in, 4 out
     *           The only way to distinguish between them is to explicitly
     *           cast all input parameters to their type; that is, to
     *           const primitive:at &. */
    public batch_normalization_forward(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef primitive.at weights,
                @Const @ByRef memory dst, @Const @ByRef memory mean, @Const @ByRef memory variance) { super((Pointer)null); allocate(aprimitive_desc, src, weights, dst, mean, variance); }
    private native void allocate(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef primitive.at weights,
                @Const @ByRef memory dst, @Const @ByRef memory mean, @Const @ByRef memory variance);

    public batch_normalization_forward(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef primitive.at weights,
                @Const @ByRef memory dst, @Const @ByRef memory mean, @Const @ByRef memory variance,
                @Const @ByRef memory workspace) { super((Pointer)null); allocate(aprimitive_desc, src, weights, dst, mean, variance, workspace); }
    private native void allocate(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef primitive.at weights,
                @Const @ByRef memory dst, @Const @ByRef memory mean, @Const @ByRef memory variance,
                @Const @ByRef memory workspace);

    public batch_normalization_forward(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef memory dst, @Const @ByRef memory mean,
                @Const @ByRef memory variance) { super((Pointer)null); allocate(aprimitive_desc, src, dst, mean, variance); }
    private native void allocate(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef memory dst, @Const @ByRef memory mean,
                @Const @ByRef memory variance);

    /** \warning batch_normalization_forward has two constructors with very
     *           similar signatures:
     *            - (pd, src, weights, dst, mean, variance) // 2 in, 3 out
     *            - (pd, src, dst, mean, variance, workspace) // 1 in, 4 out
     *           The only way to distinguish between them is to explicitly
     *           cast all input parameters to their type; that is, to
     *           const primitive:at &.
     *  \note To make users' experience a little better, this constructor
     *        checks whether parameters match the corresponding primitive
     *        descriptor, and if not, calls the other (proper) constructor. */
    public batch_normalization_forward(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef memory dst, @Const @ByRef memory mean,
                @Const @ByRef memory variance, @Const @ByRef memory workspace) { super((Pointer)null); allocate(aprimitive_desc, src, dst, mean, variance, workspace); }
    private native void allocate(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef memory dst, @Const @ByRef memory mean,
                @Const @ByRef memory variance, @Const @ByRef memory workspace);

    public batch_normalization_forward(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef primitive.at weights,
                @Const @ByRef memory dst) { super((Pointer)null); allocate(aprimitive_desc, src, weights, dst); }
    private native void allocate(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef primitive.at weights,
                @Const @ByRef memory dst);

    public batch_normalization_forward(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef memory dst) { super((Pointer)null); allocate(aprimitive_desc, src, dst); }
    private native void allocate(@Const @ByRef primitive_desc aprimitive_desc,
                @Const @ByRef primitive.at src, @Const @ByRef memory dst);
}
