// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.mkldnn;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.mkldnn.global.mklml.*;

import static org.bytedeco.mkldnn.global.mkldnn.*;


/** \}
 <p>
 *  \}
 <p>
 *  \addtogroup cpp_api_primitives Primitives
 *  \{
 <p>
 *  \addtogroup cpp_api_primitive_descriptors Primitive descriptors
 *  \{
 <p>
 *  A base class for all primitive descriptors. */
@Name("mkldnn::primitive_desc") @NoOffset @Properties(inherit = org.bytedeco.mkldnn.presets.mkldnn.class)
public class primitive_desc extends mkldnn_primitive_desc_handle {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public primitive_desc(Pointer p) { super(p); }

    public primitive_desc(const_mkldnn_op_desc_t desc, @Const primitive_attr attr,
                @Const @ByRef engine e, @Const mkldnn_primitive_desc hint_fwd_pd) { super((Pointer)null); allocate(desc, attr, e, hint_fwd_pd); }
    private native void allocate(const_mkldnn_op_desc_t desc, @Const primitive_attr attr,
                @Const @ByRef engine e, @Const mkldnn_primitive_desc hint_fwd_pd);

    public native @ByVal engine get_engine();

    public native @ByVal primitive_attr get_primitive_attr();

    /** Returns implementation name */
    
    ///
    public native @Cast("const char*") BytePointer impl_info_str();

    /** Advances the next implementation for the given op descriptor.
     * 
     *  Returns:
     *  - \c true on success
     *  - \c false if the last implementation reached, and
     *    the primitive descriptor itself is kept unchanged */
    public native @Cast("bool") boolean next_impl();

    /** Queries and returns requested memory primitive descriptor. */
    public native @ByVal memory.primitive_desc query_mpd(@Cast("mkldnn::query") int what, int idx/*=0*/);
    public native @ByVal memory.primitive_desc query_mpd(@Cast("mkldnn::query") int what);

    // register specialized queries, e.g. src_primitive_desc()
// #   define REG_QUERY_MPD(name, what, idx)
//     memory::primitive_desc name ## _primitive_desc() const
//     { return query_mpd(what ## _pd, idx); }
}
