// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.mkldnn.global;

import org.bytedeco.mkldnn.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.mkldnn.global.mklml.*;

public class mkldnn extends org.bytedeco.mkldnn.presets.mkldnn {
    static { Loader.load(); }

// Targeting ../mkldnn_primitive_desc_vector.java


// Targeting ../primitive_vector.java


// Targeting ../memory_primitive_desc_vector.java


// Parsed from mkldnn_types.h

/*******************************************************************************
* Copyright 2016-2018 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

// #ifndef MKLDNN_TYPES_H
// #define MKLDNN_TYPES_H

// #ifdef __cplusplus
// #endif

// #ifndef DOXYGEN_SHOULD_SKIP_THIS
// #endif
// Targeting ../mkldnn_version_t.java



/** Status values returned by Intel(R) MKL-DNN functions. */
/** enum mkldnn_status_t */
public static final int
    /** The operation was successful */
    mkldnn_success = 0,
    /** The operation failed due to an out-of-memory condition */
    mkldnn_out_of_memory = 1,
    /** The operation failed and should be retried */
    mkldnn_try_again = 2,
    /** The operation failed because of incorrect function arguments  */
    mkldnn_invalid_arguments = 3,
    /** The operation failed because a primitive was not ready for execution */
    mkldnn_not_ready = 4,
    /** The operation failed because requested functionality is not implemented
     */
    mkldnn_unimplemented = 5,
    /** Primitive iterator passed over last primitive descriptor */
    mkldnn_iterator_ends = 6,
    /** Primitive or engine failed on execution */
    mkldnn_runtime_error = 7,
    /** Queried element is not required for given primitive */
    mkldnn_not_required = 8;

/** Data type specification */
/** enum mkldnn_data_type_t */
public static final int
    /** Undefined data type, used for empty memory descriptors. */
    mkldnn_data_type_undef = 0,
    /** 32-bit/single-precision floating point. */
    mkldnn_f32 = 1,
    /** 32-bit signed integer. */
    mkldnn_s32 = 2,
    /** 16-bit signed integer. */
    mkldnn_s16 = 4,
    /** 8-bit signed integer. */
    mkldnn_s8 = 5,
    /** 8-bit unsigned integer. */
    mkldnn_u8 = 6,
    /** bfloat 16-bit. */
    mkldnn_bf16 = 7;

/** Rounding mode */
/** enum mkldnn_round_mode_t */
public static final int
    /** Round nearest */
    mkldnn_round_nearest = 1,
    /** Round down */
    mkldnn_round_down = 2;

/** Memory format specification.
 *
 * Intel MKL-DNN formats describe physical data layout. The physical layout
 * is described as a sequence of the dimensions as they are laid out in the
 * memory (from the outer-most to the inner-most). Note that this order
 * doesn't affect the logical order of the dimensions that is kept in the
 * {@code dims} field of the mkldnn_memory_desc_t structure. The logical order of the
 * dimensions is specified by the type of tensor.
 *
 * For example, CNN 5D tensor always has its logical dimensions in the order
 * {@code (batch, channels, depth, height, width)}, while the physical layout might be
 * #mkldnn_ncdhw or #mkldnn_ndhwc:
 *
 * ~~~cpp
 * int batch = 2, channels = 16, depth = 13, height = 13, width = 13;
 *
 * int ndims = 5; // 5D tensor
 * mkldnn_dims_t dims = {batch, channels, depth, height, width};
 *
 * mkldnn_memory_desc_t data_in_ncdhw;
 * mkldnn_memory_desc_init(&data_in_ncdhw, 5, dims, mlkdnn_ncdhw);
 *
 * // note that in both cases dims passed are the same
 * mkldnn_memory_desc_t data_in_ndhwc;
 * mkldnn_memory_desc_init(&data_in_ndhwc, 5, dims, mlkdnn_ndhwc);
 * ~~~
 *
 * The following notation applies to memory format names:
 *  - \c 'n' denotes the mini-batch dimension
 *  - \c 'c' denotes a channels dimension
 *  - When there are multiple channel dimensions (for example, in convolution
 *    weights tensor), \c 'i' and \c 'o' denote dimensions of input and output
 *    channels
 *  - \c 'd', \c 'h', and \c 'w' denote spatial depth, height, and width
 *    respectively
 *  - Upper-case letters indicate that the data is laid out in blocks
 *    for a particular dimension. In such cases, the format name contains both
 *    upper- and lower-case letters for that dimension with a lower-case letter
 *    preceded by the block size. For example: \c 'mkldnn_nChw8c' describes a
 *    format where the outermost dimension is mini-batch, followed by the
 *    channel block number, followed by the spatial height and width, and
 *    finally followed by 8-element channel blocks.
 *
 * \note
 *    Channel designations can be different. For example, both the \c
 *    'mkldnn_nc' and \c 'mkldnn_io' formats can be used to describe a 2D
 *    tensor.
 *
 * @see \ref understanding_memory_formats
 */
/** enum mkldnn_memory_format_t */
public static final int
    /** Undefined memory format, used for empty memory descriptors. */
    mkldnn_format_undef = 0,
    /** Unspecified format. The primitive selects a format
     * automatically. */
    mkldnn_any = 1,
    /** A tensor in a generic format described by the stride and blocking
     * values in each dimension. See #mkldnn_blocking_desc_t for more
     * information. */
    mkldnn_blocked = 2,
    /** 1D data tensor. */
    mkldnn_x = 3,
    /** 2D data tensor. */
    mkldnn_nc = 4,
    /** 3D data tensor with the physical layout \c ncw.
     * Logical dimensions come in the order: (n, c, w) */
    mkldnn_ncw = 5,
    /** 3D data tensor with the physical layout \c nwc.
     * Logical dimensions come in the order: (n, c, w) */
    mkldnn_nwc = 6,
    /** 4D data tensor with the physical layout \c nchw, used in Caffe.
     * Logical dimensions come in the order: (n, c, h, w) */
    mkldnn_nchw = 7,
    /** 4D data tensor with the physical layout \c nhwc, used in TensorFlow.
     * Logical dimensions come in the order: (n, c, h, w) */
    mkldnn_nhwc = 8,
    /** 4D data tensor with the physical layout \c chwn, used in Neon.
     * Logical dimensions come in the order: (n, c, h, w) */
    mkldnn_chwn = 9,
    /** 5D data tensor with the physical layout \c ncdhw.
     * Logical dimensions come in the order: (n, c, d, h, w) */
    mkldnn_ncdhw = 10,
    /** 5D data tensor with the physical layout \c ndhwc, used in TensorFlow.
     * Logical dimensions come in the order: (n, c, d, h, w) */
    mkldnn_ndhwc = 11,
    /** 2D weights tensor with physical layout \c oi.
     * Logical dimensions come in the order: (o, i) */
    mkldnn_oi = 12,
    /** 2D weights tensor with physical layout \c io.
     * Logical dimensions come in the order: (o, i) */
    mkldnn_io = 13,
    /** 3D weights tensor with physical layout \c oiw.
     * Logical dimensions come in the order: (o, i, w) */
    mkldnn_oiw = 14,
    /** 3D weights tensor with physical layout \c owi.
     * Logical dimensions come in the order: (o, i, w) */
    mkldnn_owi = 15,
    /** 3D weights tensor with physical layout \c wio.
     * Logical dimensions come in the order: (o, i, w) */
    mkldnn_wio = 16,
    /** 4D weights tensor with physical layout \c oihw, used in Caffe.
     * Logical dimensions come in the order: (o, i, h, w) */
    mkldnn_oihw = 17,
    /** 4D weights tensor with physical layout \c hwio, used in TensorFlow.
     * Logical dimensions come in the order: (o, i, h, w) */
    mkldnn_hwio = 18,
    /** 4D weights tensor with physical layout \c ohwi.
     * Logical dimensions come in the order: (o, i, h, w) */
    mkldnn_ohwi = 19,
    /** 4D weights tensor with physical layout \c ihwo.
     * Logical dimensions come in the order: (o, i, h, w) */
    mkldnn_ihwo = 20,
    /** 4D weights tensor with physical layout \c iohw.
     * Logical dimensions come in the order: (o, i, h, w) */
    mkldnn_iohw = 21,
    /** 5D weights tensor with physical layout \c iodhw, used in Caffe.
     * Logical dimensions come in the order: (o, i, d, h, w) */
    mkldnn_oidhw = 22,
    /** 5D weights tensor with physical layout \c dhwio, used in TensorFlow.
     * Logical dimensions come in the order: (o, i, d, h, w) */
    mkldnn_dhwio = 23,
    /** 5D weights tensor with physical layout \c odhwi.
     * Logical dimensions come in the order: (o, i, d, h, w) */
    mkldnn_odhwi = 24,
    /** 4D grouped weights tensor with the physical layout \c goiw.
     * Logical dimensions come in the order: (g, o, i, w) */
    mkldnn_goiw = 25,
    /** 5D grouped weights tensor with the physical layout \c goihw,
     * used in Caffe.
     * Logical dimensions come in the order: (g, o, i, h, w) */
    mkldnn_goihw = 26,
    /** 5D grouped weights tensor with the physical layout \c hwigo,
     * used in TensorFlow.
     * Logical dimensions come in the order: (g, o, i, h, w) */
    mkldnn_hwigo = 27,
    /** 5D grouped weights tensor with the physical layout \c giohw.
     * Logical dimensions come in the order: (g, o, i, h, w) */
    mkldnn_giohw = 28,
    /** 6D grouped weights tensor with the physical layout \c goidhw,
     * used in Caffe.
     * Logical dimensions come in the order: (g, o, i, d, h, w) */
    mkldnn_goidhw = 29,
    /** 3D RNN data tensor in the format (batch, seq_length, input channels). */
    mkldnn_ntc = 30,
    /** 3D RNN data tensor in the format (seq_length, batch, input channels). */
    mkldnn_tnc = 31,
    /** 5D RNN states tensor in the format (num_layers, num_directions,
     * num_states, batch, state channels). */
    mkldnn_ldsnc = 32,
    /** 5D RNN weights tensor in the format (num_layers, num_directions,
     *  input_channels, num_gates, output_channels).
     *
     *  - For LSTM cells, the gates order is input, forget, candidate
     *    and output gate.
     *  - For GRU cells, the gates order is update, reset and output gate. */
    mkldnn_ldigo = 33,
    /** 5D RNN weights tensor in the format (num_layers, num_directions,
     * num_gates, output_channels, input_channels).
     *
     *  - For LSTM cells, the gates order is input, forget, candidate
     *    and output gate.
     *  - For GRU cells, the gates order is update, reset and output gate. */
    mkldnn_ldgoi = 34,
    /** 4D RNN bias tensor in the format (num_layers, num_directions,
     * num_gates, output_channels).
     *
     *  - For LSTM cells, the gates order is input, forget, candidate
     *    and output gate.
     *  - For GRU cells, the gates order is update, reset and output gate. */
    mkldnn_ldgo = 35,

    /* Opaque data types, are not to be used explicitly */

    /* data */
    mkldnn_nCw4c = 36,
    mkldnn_nCw8c = 37,
    mkldnn_nCw16c = 38,
    mkldnn_nChw4c = 39,
    mkldnn_nChw8c = 40,
    mkldnn_nChw16c = 41,
    mkldnn_nCdhw4c = 42,
    mkldnn_nCdhw8c = 43,
    mkldnn_nCdhw16c = 44,

    /* weights, 3D */
    mkldnn_Owi4o = 45,
    mkldnn_OIw4i4o = 46,
    mkldnn_Owi8o = 47,
    mkldnn_OIw8i8o = 48,
    mkldnn_OIw8o8i = 49,
    mkldnn_OIw16i16o = 50,
    mkldnn_OIw16o16i = 51,
    mkldnn_Oiw4o = 52,
    mkldnn_Oiw16o = 53,
    mkldnn_Owi16o = 54,
    mkldnn_OIw8i16o2i = 55,
    mkldnn_OIw8o16i2o = 56,
    mkldnn_IOw8o16i2o = 57,
    mkldnn_IOw16o16i = 58,
    mkldnn_OIw4i16o4i = 59,
    /** blocked weights format with additional buffer
     * with size equal to the number of output channels
     * and containing the values:
     * O[i:0,OC] = -128 * SUM(j:0,IC;w:0,W)(weights(i,j,w))*/
    mkldnn_OIw4i16o4i_s8s8 = 60,

    /* weights, 4D */
    /** weights format with additional buffer
     * size equal to the number of output channels
     * and containing the values:
     * O[i:0,OC] = -128 * SUM(j:0,IC;h:0,H;w:0,W)(weights(i,j,h,w))*/
    mkldnn_hwio_s8s8 = 61,
    mkldnn_oIhw8i = 62,
    mkldnn_oIhw16i = 63,
    mkldnn_OIhw4i4o = 64,
    mkldnn_OIhw8i8o = 65,
    mkldnn_OIhw16i16o = 66,
    mkldnn_OIhw4i16o4i = 67,
    /** blocked weights format with additional buffer
     * with size equal to the number of output channels
     * and containing the values:
     * O[i:0,OC] = -128 * SUM(j:0,IC;h:0,H;w:0,W)(weights(i,j,h,w))*/
    mkldnn_OIhw4i16o4i_s8s8 = 68,
    mkldnn_OIhw8i16o2i = 69,
    mkldnn_IOhw8i16o2i = 70,
    mkldnn_OIhw8o16i2o = 71,
    mkldnn_IOhw8o16i2o = 72,
    mkldnn_OIhw8o8i = 73,
    mkldnn_OIhw16o16i = 74,
    mkldnn_IOhw16o16i = 75,
    mkldnn_Oihw8o = 76,
    mkldnn_Oihw4o = 77,
    mkldnn_Oihw16o = 78,
    mkldnn_Ohwi8o = 79,
    mkldnn_Ohwi4o = 80,
    mkldnn_Ohwi16o = 81,
    mkldnn_OhIw16o4i = 82,

    /* weights, 5D */
    mkldnn_oIdhw8i = 83,
    mkldnn_oIdhw16i = 84,
    mkldnn_OIdhw4i4o = 85,
    mkldnn_Odhwi4o = 86,
    mkldnn_OIdhw8i8o = 87,
    mkldnn_OIdhw8o8i = 88,
    mkldnn_Odhwi8o = 89,
    mkldnn_OIdhw16i16o = 90,
    mkldnn_OIdhw16o16i = 91,
    mkldnn_Oidhw4o = 92,
    mkldnn_Oidhw16o = 93,
    mkldnn_Odhwi16o = 94,
    mkldnn_OIdhw8i16o2i = 95,
    mkldnn_OIdhw8o16i2o = 96,
    mkldnn_IOdhw8o16i2o = 97,

    /* weights w/ groups, 4D */
    mkldnn_gOwi4o = 98,
    mkldnn_gOIw4i4o = 99,
    mkldnn_gOwi8o = 100,
    mkldnn_gOIw8o8i = 101,
    mkldnn_gOIw8i8o = 102,
    mkldnn_gOIw16i16o = 103,
    mkldnn_gOIw16o16i = 104,
    mkldnn_gOiw4o = 105,
    mkldnn_gOiw16o = 106,
    mkldnn_gOwi16o = 107,
    mkldnn_gOIw8i16o2i = 108,
    mkldnn_gOIw8o16i2o = 109,
    mkldnn_gIOw8o16i2o = 110,
    mkldnn_gIOw16o16i = 111,
    mkldnn_gOIw4i16o4i = 112,
    /** blocked weights format with additional buffer
     * with size equal to the number of output channels
     * multiplied by number of groups and containing the values:
     * O[i:0,G*OC] = -128 * SUM(j:0,IC;w:0,W)(weights(i,j,w))*/
    mkldnn_gOIw4i16o4i_s8s8 = 113,
    mkldnn_Goiw16g = 114,
    /** blocked weights format with additional buffer
     * with size equal to the number of groups and containing the values:
     * O[i:0,G] = -128 * SUM(w:0,W)(weights(i,i,w))*/
    mkldnn_Goiw16g_s8s8 = 115,

    /* weights w/ groups, 5D */
    /** weights format with additional buffer
     * size equal to the number of output channels
     * multiplied by number of groups and containing the values:
     * O[i:0,G*OC] = -128 * SUM(j:0,IC;h:0,H;w:0,W)(weights(i,j,h,w))*/
    mkldnn_hwigo_s8s8 = 116,
    mkldnn_gOIhw4i4o = 117,
    mkldnn_gOIhw8i8o = 118,
    mkldnn_gOIhw16i16o = 119,
    mkldnn_gOIhw4i16o4i = 120,
    /** blocked weights format with additional buffer
     * with size equal to the number of output channels
     * multiplied by number of groups and containing the values:
     * O[i:0,G*OC] = -128 * SUM(j:0,IC;h:0,H;w:0,W)(weights(i,j,h,w))*/
    mkldnn_gOIhw4i16o4i_s8s8 = 121,
    mkldnn_gOIhw2i8o4i = 122,
    /** blocked weights format with additional buffer
     * with size equal to the number of output channels
     * multiplied by number of groups and containing the values:
     * O[i:0,G*OC] = -128 * SUM(j:0,IC;h:0,H;w:0,W)(weights(i,j,h,w))*/
    mkldnn_gOIhw2i8o4i_s8s8 = 123,
    mkldnn_gOIhw8i16o2i = 124,
    mkldnn_gIOhw8i16o2i = 125,
    mkldnn_gOIhw8o16i2o = 126,
    mkldnn_gIOhw8o16i2o = 127,
    mkldnn_gOIhw4o4i = 128,
    /** blocked weights format with additional buffer
     * with size equal to the number of output channels
     * and containing the values:
     * O[i:0,OC] = -128 * SUM(j:0,IC;h:0,H;w:0,W)(weights(i,j,h,w))*/
    mkldnn_gOIhw4o4i_s8s8 = 129,
    mkldnn_gOIhw8o8i = 130,
    mkldnn_gOIhw16o16i = 131,
    mkldnn_gIOhw16o16i = 132,
    mkldnn_gOihw8o = 133,
    mkldnn_gOihw4o = 134,
    mkldnn_gOihw16o = 135,
    mkldnn_gOhwi8o = 136,
    mkldnn_gOhwi4o = 137,
    mkldnn_gOhwi16o = 138,
    mkldnn_Goihw8g = 139,
    mkldnn_Goihw16g = 140,
    /** blocked weights format with additional buffer
     * with size equal to the number of groups and containing the values:
     * O[i:0,G] = -128 * SUM(h:0,H;w:0,W)(weights(i,i,h,w))*/
    mkldnn_Goihw16g_s8s8 = 141,
    mkldnn_gOhIw16o4i = 142,

    /* weights w/ groups, 6D */
    mkldnn_gOIdhw4i4o = 143,
    mkldnn_gOdhwi4o = 144,
    mkldnn_gOIdhw8i8o = 145,
    mkldnn_gOIdhw8o8i = 146,
    mkldnn_gOdhwi8o = 147,
    mkldnn_gOIdhw8i16o2i = 148,
    mkldnn_gOIdhw8o16i2o = 149,
    mkldnn_gIOdhw8o16i2o = 150,
    mkldnn_gOIdhw16i16o = 151,
    mkldnn_gOIdhw16o16i = 152,
    mkldnn_gOidhw4o = 153,
    mkldnn_gOidhw16o = 154,
    mkldnn_gOdhwi16o = 155,

    mkldnn_wino_fmt = 156,

    mkldnn_rnn_packed = 157,

    /** Just a sentinel, not real memory format. Must be changed after new
     * format is added. */
    mkldnn_format_last = 158;

/** Kinds of padding. Define how to interpret the data in padding regions. */
/** enum mkldnn_padding_kind_t */
public static final int
    /** The data in padding regions is zero. */
    mkldnn_padding_zero = 0;

/** Kinds of propagation. */
/** enum mkldnn_prop_kind_t */
public static final int
    /* TODO: suggest renames */
    /** Undefined propagation type. */
    mkldnn_prop_kind_undef = 0,
    /** Forward data propagation (training mode). In this mode primitives
     * perform computations necessary for subsequent backward propagation. */
    mkldnn_forward_training = 64,
    /** Forward data propagation (inference mode). In this mode primitives
     * perform only computations that are necessary for inference and omit
     * computations that are necessary only for backward propagation. */
    mkldnn_forward_inference = 96,
    /** Forward data propagation (alias for \c mkldnn_forward_inference) */
    mkldnn_forward_scoring = mkldnn_forward_inference,
   /** Forward data propagation (alias for \c mkldnn_forward_training) */
    mkldnn_forward = mkldnn_forward_training,
    /** Backward propagation (with respect to all parameters */
    mkldnn_backward = 128,
    /** Backward data propagation */
    mkldnn_backward_data = 160,
    /** Backward weights propagation */
    mkldnn_backward_weights = 192,
    /** Backward bias propagation */
    mkldnn_backward_bias = 193;

/** Kinds of primitives. Used to implement a way to extend the library with new
 * primitives without changing the ABI. */
/** enum mkldnn_primitive_kind_t */
public static final int
    /** Undefined primitive (XXX: why do we have it?). */
    mkldnn_undefined_primitive = 0,
    /** A memory primitive. */
    mkldnn_memory = 1,
    /** A view primitive. */
    mkldnn_view = 2,
    /** A reorder primitive.*/
    mkldnn_reorder = 3,
    /** A shuffle primitive.*/
    mkldnn_shuffle = 4,
    /** A (out-of-place) concat primitive. */
    mkldnn_concat = 5,
    /** A (in-place) concat primitive. */
    mkldnn_concat_inplace = 6,
    /** A sum primitive. */
    mkldnn_sum = 7,
    /** A convolution primitive. */
    mkldnn_convolution = 8,
    /** A deconvolution primitive. */
    mkldnn_deconvolution = 9,
    /** An element-wise primitive. */
    mkldnn_eltwise = 10,
    /** A Softmax primitive. */
    mkldnn_softmax = 11,
    /** A pooling primitive. */
    mkldnn_pooling = 12,
    /** An LRN primitive. */
    mkldnn_lrn = 13,
    /** An batch normalization primitive. */
    mkldnn_batch_normalization = 14,
    /** An inner product primitive. */
    mkldnn_inner_product = 15,
    /** A rnn primitive. */
    mkldnn_rnn = 16;

/** Kinds of algorithms. */
/** enum mkldnn_alg_kind_t */
public static final int
    mkldnn_alg_kind_undef = 0,
    /** Direct convolution */
    mkldnn_convolution_direct = 0x1,
    /** Winograd convolution */
    mkldnn_convolution_winograd = 0x2,
    /** Convolution algorithm(either direct or Winograd) is chosen just in time **/
    mkldnn_convolution_auto = 0x3,
    /** Direct deconvolution */
    mkldnn_deconvolution_direct = 0xa,
    /** Winograd deconvolution */
    mkldnn_deconvolution_winograd = 0xb,
    /** Eltwise: ReLU */
    mkldnn_eltwise_relu = 0x1f,
    /** Eltwise: hyperbolic tangent non-linearity (tanh) */
    mkldnn_eltwise_tanh = 0x2f,
    /** Eltwise: parametric exponential linear unit (elu) */
    mkldnn_eltwise_elu = 0x3f,
    /** Eltwise: square */
    mkldnn_eltwise_square = 0x4f,
    /** Eltwise: abs */
    mkldnn_eltwise_abs = 0x5f,
    /** Eltwise: square root */
    mkldnn_eltwise_sqrt = 0x6f,
    /** Eltwise: linear */
    mkldnn_eltwise_linear = 0x7f,
    /** Eltwise: bounded_relu */
    mkldnn_eltwise_bounded_relu = 0x8f,
    /** Eltwise: soft_relu */
    mkldnn_eltwise_soft_relu = 0x9f,
    /** Eltwise: logistic */
    mkldnn_eltwise_logistic = 0xaf,
    /** Eltwise: exponent */
    mkldnn_eltwise_exp = 0xbf,
    /** Eltwise: gelu */
    mkldnn_eltwise_gelu = 0xcf,
    /** Max pooling */
    mkldnn_pooling_max = 0x1ff,
    /** Average pooling include padding */
    mkldnn_pooling_avg_include_padding = 0x2ff,
    /** Average pooling exclude padding */
    mkldnn_pooling_avg_exclude_padding = 0x3ff,
    mkldnn_pooling_avg = mkldnn_pooling_avg_exclude_padding,
    /** Local response normalization (LRN) across multiple channels */
    mkldnn_lrn_across_channels = 0xaff,
    /** LRN within a single channel */
    mkldnn_lrn_within_channel = 0xbff,
    /** RNN cell */
    mkldnn_vanilla_rnn = 0x1fff,
    /** LSTM cell */
    mkldnn_vanilla_lstm = 0x2fff,
    /** GRU cell */
    mkldnn_vanilla_gru = 0x3fff,
    /** GRU cell with linear before reset
     *
     * Modification of original GRU cell. Differs from #mkldnn_vanilla_gru
     * in how the new memory gate is calculated:
     * <pre>{@code \[ c_t = tanh(W_c*x_t + b_{c_x} + r_t*(U_c*h_{t-1}+b_{c_h})) \]}</pre>
     * Primitive expects 4 biases on input:
     * {@code [b_{u}, b_{r}, b_{c_x}, b_{c_h}]}
     * */
    mkldnn_gru_linear_before_reset = 0x4fff;

/** Flags for batch-normalization primititve. */
/** enum mkldnn_batch_normalization_flag_t */
public static final int
    /** Use global statistics
     *
     * If specified
     *  - on forward propagation use mean and variance provided by user (input)
     *  - on backward propagation reduces the amount of computations, since
     *    mean and variance are considered as constants
     *
     *  If not specified:
     *   - on forward propagation mean and variance are computed and stored in
     *     output
     *   - on backward propagation compute full derivative wrt to data
     */
    mkldnn_use_global_stats = 0x1,
    /** Use scale and shift parameters
     *
     * If specified:
     *  - on forward propagation use scale and shift (aka scale and bias) for
     *    the batch normalization results
     *  - on backward propagation (for prop_kind == #mkldnn_backward) compute
     *    diff wrt to scale and shift (hence one extra output used)
     *
     * If no specified:
     *  - on backward propagation prop_kind == #mkldnn_backward_data has the
     *    same behavior as prop_kind == #mkldnn_backward
     */
    mkldnn_use_scaleshift = 0x2,
    /** Fuse with ReLU
     *
     * If specified:
     *  - on inference this option behaves the same as if the primitive were
     *    fused with ReLU via post ops API
     *  - on training primitive requires workspace (required to be able to
     *    perform backward pass)
     */
    mkldnn_fuse_bn_relu = 0x4;

/** \} */

/** \addtogroup c_api_types_memory Auxiliary types for memory description
 *  \{ */

/** Maximum number of dimensions a tensor can have. Only restricts the amount
 * of space used for the tensor description. Individual computational
 * primitives may support only tensors of certain dimensions. */
public static final int TENSOR_MAX_DIMS = 12;

/** A type to describe tensor dimensions. */
/** A type to describe strides within a tensor. */
// Targeting ../mkldnn_blocking_desc_t.java



/** enum mkldnn_wino_memory_format_t */
public static final int
    /** Undefined memory format, used for empty memory descriptors. */
    mkldnn_wino_undef = 0,
    /** Tensors of weights for 2x3 winograd convolutions. */
    mkldnn_wino_wei_aaOIoi = 1,
    mkldnn_wino_wei_aaOio = 2,
    mkldnn_wino_wei_aaOBiOo = 3,
    /** Tensor of weights for 4x3 convolution. */
    mkldnn_wino_wei_OBaaIBOIio = 4;
// Targeting ../mkldnn_wino_desc_t.java



/** enum mkldnn_rnn_packed_memory_format_t */
public static final int
    mkldnn_packed_format_undef = 0,
    mkldnn_ldigo_p = 1,
    mkldnn_ldgoi_p = 2;

/* Maximum number of parts of RNN weights tensor that require separate
 * computation. */
public static final int MKLDNN_RNN_MAX_N_PARTS = 4;
// Targeting ../mkldnn_rnn_packed_desc_t.java


// Targeting ../mkldnn_op_desc_t.java


// Targeting ../const_mkldnn_op_desc_t.java


// Targeting ../mkldnn_memory_desc_t.java


// Targeting ../mkldnn_convolution_desc_t.java



/** A descriptor of a deconvolution operation. */
// Targeting ../mkldnn_shuffle_desc_t.java


// Targeting ../mkldnn_eltwise_desc_t.java


// Targeting ../mkldnn_softmax_desc_t.java


// Targeting ../mkldnn_pooling_desc_t.java


// Targeting ../mkldnn_lrn_desc_t.java


// Targeting ../mkldnn_batch_normalization_desc_t.java


// Targeting ../mkldnn_inner_product_desc_t.java



/** Flags for RNN cell. */
/** enum mkldnn_rnn_cell_flags_t */
public static final int
    mkldnn_rnn_cell_with_relu = 0x1,
    mkldnn_rnn_cell_with_clipping = 0x2;
// Targeting ../mkldnn_rnn_cell_desc_t.java



/** A direction of RNN primitive execution. */
/** enum mkldnn_rnn_direction_t */
public static final int
    /* Unidirectional execution of RNN primitive from left to right. */
    mkldnn_unidirectional_left2right = 0,
    /* Unidirectional execution of RNN primitive from right to left. */
    mkldnn_unidirectional_right2left = 1,
    /* Bidirectional execution of RNN primitive with concatenation of the
     * results. */
    mkldnn_bidirectional_concat = 2,
    /* Bidirectional execution of RNN primitive with summation of the
     * results. */
    mkldnn_bidirectional_sum = 3,
    mkldnn_unidirectional = mkldnn_unidirectional_left2right;
// Targeting ../mkldnn_rnn_desc_t.java



/** \} */

/** \addtogroup c_api_engine_types Engine
 * \{ */

/** \brief Kinds of engines. */
/** enum mkldnn_engine_kind_t */
public static final int
    /** An unspecified engine. */
    mkldnn_any_engine = 0,
    /** CPU engine. */
    mkldnn_cpu = 1;
// Targeting ../mkldnn_engine.java


/** \brief An engine handle. */
// Targeting ../mkldnn_primitive_desc_iterator.java



/** \brief A primitive descriptor iterator handle. */

/** \brief A constant primitive descriptor iterator handle. */
// Targeting ../mkldnn_primitive_desc.java



/** \brief A primitive descriptor handle. */

/** \brief A constant primitive descriptor handle. */
// Targeting ../mkldnn_primitive_attr.java



/** \brief A primitive descriptor attributes handle that controls primitive
 * behavior. */

/** \brief A constant primitive descriptor attributes handle. */
// Targeting ../mkldnn_post_ops.java



/** \brief A post operation chain handle. */

/** \brief A constant post operation chain handle. */
// Targeting ../mkldnn_primitive.java


/** A primitive handle. */
/** A constant primitive handle. */
// Targeting ../mkldnn_primitive_at_t.java



/** \} */

/** \addtogroup c_api_types_query Queries
 * \{ */

/** Primitive descriptor query specification
 *
 * For generic function mkldnn_primitive_desc_query(), the type of result must
 * agree with the queried argument. The correspondence table:
 *      Query                        | type of result
 *      --------------------------------------------------------------
 *      #mkldnn_query_engine         | mkldnn_engine_t *
 *      #mkldnn_query_primitive_kind | mkldnn_primitive_kind_t *
 *      *_s32                        | int *
 *      *_s64                        | ptrdiff_t *
 *      *_f64                        | double *
 *      *_str                        | const char **
 *      #mkldnn_query_op_d           | const_mkldnn_op_desc_t *
 *      *_md                         | const mkldnn_memory_desc_t **
 *      *_${op}_d                    | const mkldnn_${op}_desc_t **
 *      *_pd                         | const_mkldnn_primitive_desc_t *
 *
 * \note
 *     Rule of thumb: all opaque types and structures are returned by
 *     reference. All numbers are returned by value.
 *
 * \warning
 *     All returned references point to constant objects and are valid only
 *     during the lifetime of the queried primitive descriptor. Returned objects
 *     must not be destroyed by the user. If you need to keep the object longer
 *     than the lifetime of the queried primitive descriptor, use
 *     mkldnn_primitive_desc_clone() to make a copy. */
/** enum mkldnn_query_t */
public static final int
    /** no query */
    mkldnn_query_undef = 0,

    /** execution engine */
    mkldnn_query_engine = 1,
    /** primitive kind */
    mkldnn_query_primitive_kind = 2,

    /** number of inputs expected */
    mkldnn_query_num_of_inputs_s32 = 3,
    /** number of outputs expected */
    mkldnn_query_num_of_outputs_s32 = 4,

    /** runtime estimation (seconds) */
    mkldnn_query_time_estimate_f64 = 5,
    /** memory consumption -- extra
                                           (scratch) memory, additional to all
                                           inputs and outputs memory (bytes) */
    mkldnn_query_memory_consumption_s64 = 6,

    /** implementation name */
    mkldnn_query_impl_info_str = 7,

    /* memory and op descriptor section */
    /** stub */
    mkldnn_query_some_d = 64,
    /** op descriptor */
    mkldnn_query_op_d = 65,
    /** memory descriptor for memory and view */
    mkldnn_query_memory_d = 66,
    /** convolution descriptor */
    mkldnn_query_convolution_d = 67,
    /** deconvolution descriptor */
    mkldnn_query_deconvolution_d = 68,
    /** shuffle descriptor */
    mkldnn_query_shuffle_d = 69,
    /** eltwise descriptor */
    mkldnn_query_eltwise_d = 70,
    /** softmax descriptor */
    mkldnn_query_softmax_d = 71,
    /** pooling descriptor */
    mkldnn_query_pooling_d = 72,
    /** lrn descriptor */
    mkldnn_query_lrn_d = 73,
    /** batch normalization descriptor */
    mkldnn_query_batch_normalization_d = 74,
    /** inner product descriptor */
    mkldnn_query_inner_product_d = 75,
    /** rnn descriptor */
    mkldnn_query_rnn_d = 76,

    /* (memory) primitive descriptor section */
    /** stub */
    mkldnn_query_some_pd = 128,
    /** input memory primitive desc */
    mkldnn_query_input_pd = 129,
    /** output memory primitive desc */
    mkldnn_query_output_pd = 130,
    /** source memory primitive desc */
    mkldnn_query_src_pd = 131,
    /** source gradient memory primitive desc */
    mkldnn_query_diff_src_pd = 132,
    /** weights memory primitive descriptor desc */
    mkldnn_query_weights_pd = 133,
    /** weights grad. memory primitive desc */
    mkldnn_query_diff_weights_pd = 134,
    /** destination memory primitive desc */
    mkldnn_query_dst_pd = 135,
    /** destination grad. memory primitive desc */
    mkldnn_query_diff_dst_pd = 136,
    /** workspace memory primitive desc */
    mkldnn_query_workspace_pd = 137;

/** \} */

/** \addtogroup c_api_types_stream Execution stream
 * \{ */

/** \brief Kinds of streams. */
/** enum mkldnn_stream_kind_t */
public static final int
    /** An unspecified engine. */
    mkldnn_any_stream = 0,
    /** Eager stream. */
    mkldnn_eager = 1,
    /** Lazy stream. */
    mkldnn_lazy = 2,
    /** An eager stream that doesn't hold primitives inside it.
     * Call to mkldnn_stream_rerun() always returns mkldnn_invalid_arguments. */
    mkldnn_eager_nostore = 3;
// Targeting ../mkldnn_stream.java


/** An execution stream handle. */
/** A constant execution stream handle. */

/** \} */
/** \} */
/** \} */

// #ifdef __cplusplus
// #endif


// #endif


// Parsed from mkldnn.h

/*******************************************************************************
* Copyright 2016-2018 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

// #ifndef MKLDNN_H
// #define MKLDNN_H

// #ifndef DOXYGEN_SHOULD_SKIP_THIS
// #endif /* DOXYGEN_SHOULD_SKIP_THIS */

// #ifdef __cplusplus
// #endif

/** \addtogroup c_api C API
 * \{ */

/** \addtogroup c_api_primitive Primitive operations
 * \{ */

/** \addtogroup c_api_primitive_common Common primitive operations
 * \{ */

/** Creates a primitive descriptor \p iterator for given \p op_desc, \p engine,
 * and optionally a hint primitive descriptor from forward propagation
 * (required for backward propagation). Pass \c NULL for forward propagation.
 */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_iterator_create(
        @ByPtrPtr mkldnn_primitive_desc_iterator iterator,
        const_mkldnn_op_desc_t op_desc, mkldnn_engine engine,
        @Const mkldnn_primitive_desc hint_forward_primitive_desc);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_iterator_create(
        @Cast("mkldnn_primitive_desc_iterator_t*") PointerPointer iterator,
        const_mkldnn_op_desc_t op_desc, mkldnn_engine engine,
        @Const mkldnn_primitive_desc hint_forward_primitive_desc);

/** Creates a primitive descriptor \p iterator for given \p op_desc, \p attr,
 * \p engine, and optionally a hint primitive descriptor from forward
 * propagation (required for backward propagation). Pass \c NULL for forward
 * propagation.
 */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_iterator_create_v2(
        @ByPtrPtr mkldnn_primitive_desc_iterator iterator,
        const_mkldnn_op_desc_t op_desc, @Const mkldnn_primitive_attr attr,
        mkldnn_engine engine,
        @Const mkldnn_primitive_desc hint_forward_primitive_desc);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_iterator_create_v2(
        @Cast("mkldnn_primitive_desc_iterator_t*") PointerPointer iterator,
        const_mkldnn_op_desc_t op_desc, @Const mkldnn_primitive_attr attr,
        mkldnn_engine engine,
        @Const mkldnn_primitive_desc hint_forward_primitive_desc);

/** Iterates over primitive descriptors. Returns #mkldnn_iterator_ends if no
 * more primitive descriptors are available. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_iterator_next(
        mkldnn_primitive_desc_iterator iterator);

/** Fetches the current primitive descriptor.
 *
 * \note
 *     The user should delete the fetched primitive descriptor using
 *     mkldnn_primitive_desc_destroy() once it is no longer needed. */
public static native mkldnn_primitive_desc mkldnn_primitive_desc_iterator_fetch(
        @Const mkldnn_primitive_desc_iterator iterator);

/** Deletes a primitive descriptor \p iterator */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_iterator_destroy(
        mkldnn_primitive_desc_iterator iterator);

/** Creates a \p primitive_desc using \p op_desc, \p engine, and optionally a
 * hint primitive descriptor from forward propagation. The call is equivalent
 * to creating a primitive descriptor iterator, immediately fetching a
 * primitive descriptor, and then destroying the iterator. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_create(
        @ByPtrPtr mkldnn_primitive_desc primitive_desc,
        const_mkldnn_op_desc_t op_desc, mkldnn_engine engine,
        @Const mkldnn_primitive_desc hint_forward_primitive_desc);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_create(
        @Cast("mkldnn_primitive_desc_t*") PointerPointer primitive_desc,
        const_mkldnn_op_desc_t op_desc, mkldnn_engine engine,
        @Const mkldnn_primitive_desc hint_forward_primitive_desc);

/** Creates a \p primitive_desc using \p op_desc, \p attr, \p engine, and
 * optionally a hint primitive descriptor from forward propagation. The call is
 * equivalent to creating a primitive descriptor iterator, immediately fetching
 * a primitive descriptor, and then destroying the iterator. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_create_v2(
        @ByPtrPtr mkldnn_primitive_desc primitive_desc,
        const_mkldnn_op_desc_t op_desc, @Const mkldnn_primitive_attr attr,
        mkldnn_engine engine,
        @Const mkldnn_primitive_desc hint_forward_primitive_desc);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_create_v2(
        @Cast("mkldnn_primitive_desc_t*") PointerPointer primitive_desc,
        const_mkldnn_op_desc_t op_desc, @Const mkldnn_primitive_attr attr,
        mkldnn_engine engine,
        @Const mkldnn_primitive_desc hint_forward_primitive_desc);

/** Makes a copy of a \p primitive_desc. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_clone(
        @ByPtrPtr mkldnn_primitive_desc primitive_desc,
        @Const mkldnn_primitive_desc existing_primitive_desc);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_clone(
        @Cast("mkldnn_primitive_desc_t*") PointerPointer primitive_desc,
        @Const mkldnn_primitive_desc existing_primitive_desc);

/** Returns a constant reference to the attribute of a \p primitive_desc.
 *
 * \warning
 *      The user should not destroy the obtained \p attr.
 *
 * \warning
 *      The lifetime of an \p attr is the same as that of a \p primitive_desc,
 *      so it is illegal to use the \p attr once \p primitive_desc has been
 *      destroyed. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_get_attr(
        @Const mkldnn_primitive_desc primitive_desc,
        @Const @ByPtrPtr mkldnn_primitive_attr attr);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_get_attr(
        @Const mkldnn_primitive_desc primitive_desc,
        @Cast("const_mkldnn_primitive_attr_t*") PointerPointer attr);

/** Deletes a \p primitive_desc. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_destroy(
        mkldnn_primitive_desc primitive_desc);

/** Queries primitive descriptor
 *
 * One of the most typical use cases is to query a convolution primitive
 * descriptor created with source, weights, and destination formats equal
 * to #mkldnn_any about the corresponding memory primitive descriptors
 * (\p what equals #mkldnn_query_src_pd, #mkldnn_query_weights_pd, and
 * #mkldnn_query_dst_pd respectively) to be able to prepare memory and
 * create reorders if required.
 *
 * Another quite typical use case is to query an operation primitive
 * descriptor for a workspace (\p what equals #mkldnn_query_workspace_pd).
 * The returned status #mkldnn_not_required indicates that a workspace is
 * not required.
 *
 * A few other possibilities:
 *  - query a memory primitive descriptor for the underlying memory
 *    descriptor (#mkldnn_query_memory_d)
 *  - query an operation primitive descriptor for the underlying operation
 *    descriptor (#mkldnn_query_convolution_d, #mkldnn_query_eltwise_d,
 *    #mkldnn_query_rnn_d, etc.)
 *  - query an operation primitive descriptor for the implementation
 *    information string (#mkldnn_query_impl_info_str)
 *  - query an operation primitive descriptor for the number of inputs and
 *    outputs (#mkldnn_query_num_of_inputs_s32 and
 *    #mkldnn_query_num_of_outputs_s32 respectively)
 *
 * @see mkldnn_query_t for more options
 */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_desc_query(
        @Const mkldnn_primitive_desc primitive_desc, @Cast("mkldnn_query_t") int what,
        int index, Pointer result);

/** Queries primitive descriptor for memory descriptor
 *
 * @return NULL in case of any error (in particular if the queried entity is
 * not of type mkldnn_memory_desc_t).
 *
 * This is just a specialized version of mkldnn_primitive_desc_query
 * used for convenience.
 */
public static native @Const mkldnn_memory_desc_t mkldnn_primitive_desc_query_memory_d(
        @Const mkldnn_primitive_desc primitive_desc);

/** Queries primitive descriptor for primitive descriptor
 *
 * @return NULL in case of any error (in particular if the queried entity is
 * not of type const_mkldnn_primitive_desc_t).
 *
 * This is just a specialized version of mkldnn_primitive_desc_query
 * used for convenience.
 *
 * Example: Query an operation primitive descriptor for a workspace
 *         (\p what equals #mkldnn_query_workspace_pd). Returned
 *         NULL indicates that the primitive does not require a workspace.
 *         Otherwise, a user should prepare the workspace and pass it
 *         to the corresponding primitive.
 */
public static native @Const mkldnn_primitive_desc mkldnn_primitive_desc_query_pd(
        @Const mkldnn_primitive_desc primitive_desc, @Cast("mkldnn_query_t") int what,
        int index);

/** Queries primitive descriptor for signed 32bit int
 *
 * @return 0 in case of any error (in particular if the queried entity is
 * not of type int32_t). Note that 0 might also be the actual returned
 * value.
 *
 * This is just a specialized version of mkldnn_primitive_desc_query
 * used for convenience.
 */
public static native int mkldnn_primitive_desc_query_s32(
        @Const mkldnn_primitive_desc primitive_desc, @Cast("mkldnn_query_t") int what,
        int index);

/** Creates a \p primitive using a \p primitive_desc descriptor and arrays of
 * \p inputs and \p outputs. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_create(
        @ByPtrPtr mkldnn_primitive primitive,
        @Const mkldnn_primitive_desc primitive_desc,
        @Const mkldnn_primitive_at_t inputs,
        @Const @ByPtrPtr mkldnn_primitive outputs);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_create(
        @Cast("mkldnn_primitive_t*") PointerPointer primitive,
        @Const mkldnn_primitive_desc primitive_desc,
        @Const mkldnn_primitive_at_t inputs,
        @Cast("const_mkldnn_primitive_t*") PointerPointer outputs);

/** Retrieves a reference to the \p primitive_desc descriptor of given \p
 * primitive.
 *
 * \warning
 *     The returned object must not be destroyed by the user. The \c const
 *     qualifier of the returned object prevents such attempts. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_get_primitive_desc(
        @Const mkldnn_primitive primitive,
        @Const @ByPtrPtr mkldnn_primitive_desc primitive_desc);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_get_primitive_desc(
        @Const mkldnn_primitive primitive,
        @Cast("const_mkldnn_primitive_desc_t*") PointerPointer primitive_desc);

/** For a \p primitive, returns \p input at the \p index position. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_get_input_at(
        @Const mkldnn_primitive primitive, @Cast("size_t") long index,
        mkldnn_primitive_at_t input);

/** For a \p primitive, returns \p output at the \p index position. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_get_output(
        @Const mkldnn_primitive primitive, @Cast("size_t") long index,
        @Const @ByPtrPtr mkldnn_primitive output);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_get_output(
        @Const mkldnn_primitive primitive, @Cast("size_t") long index,
        @Cast("const_mkldnn_primitive_t*") PointerPointer output);

/** Deletes a \p primitive. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_destroy(
        mkldnn_primitive primitive);

/** Creates an #mkldnn_primitive_at_t structure from a \p primitive and \p
 * output_index. This function only fills in the data structure
 * and does not check whether arguments are correct. The actual error checking
 * is done when the resulting #mkldnn_primitive_at structure is passed to a
 * primitive creation function. */
public static native @ByVal mkldnn_primitive_at_t mkldnn_primitive_at(
        @Const mkldnn_primitive primitive, @Cast("size_t") long output_index);

/** \} */

/** \addtogroup c_api_attributes Attributes
 * An extension for controlling primitive behavior.
 * \{ */

/** Creates an empty (default) \p attr attribute. All the parameters are set to
 * default values.
 *
 * An empty attribute is used in primitive descriptor creation whenever it
 * is not passed explicitly, e.g. in mkldnn_primitive_desc_create.
 */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_create(
        @ByPtrPtr mkldnn_primitive_attr attr);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_create(
        @Cast("mkldnn_primitive_attr_t*") PointerPointer attr);

/** Makes a copy of an \p existing_attr. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_clone(
        @ByPtrPtr mkldnn_primitive_attr attr,
        @Const mkldnn_primitive_attr existing_attr);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_clone(
        @Cast("mkldnn_primitive_attr_t*") PointerPointer attr,
        @Const mkldnn_primitive_attr existing_attr);

/** Deletes an \p attr. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_destroy(
        mkldnn_primitive_attr attr);

/** Returns integer output rounding mode \p round_mode for a given \p attr,
 * previously set by mkldnn_primitive_attr_set_int_output_round_mode. */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_get_int_output_round_mode(
        @Const mkldnn_primitive_attr attr, @Cast("mkldnn_round_mode_t*") IntPointer round_mode);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_get_int_output_round_mode(
        @Const mkldnn_primitive_attr attr, @Cast("mkldnn_round_mode_t*") IntBuffer round_mode);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_get_int_output_round_mode(
        @Const mkldnn_primitive_attr attr, @Cast("mkldnn_round_mode_t*") int[] round_mode);

/** Sets output rounding mode \p round_mode for integer operations for a given
 * \p attr.
 *
 * The default value is #mkldnn_round_nearest.
 */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_set_int_output_round_mode(
        mkldnn_primitive_attr attr, @Cast("mkldnn_round_mode_t") int round_mode);

/** Returns \p count, correspondence scale \p mask, and a pointer to a constant
 * floating point array of output \p scales for given \p attr, previously set
 * by mkldnn_primitive_attr_set_output_scales.
 *
 * \warning
 *      The \p scales array points to the internal \p attr field, so the user
 *      should not modify or destroy \p scales.
 *
 * \warning
 *      The lifetime of \p scales is the same as that of the \p attr to which it
 *      belongs, so it is illegal to use \p scales after \p attr is destroyed.
 */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_get_output_scales(
        @Const mkldnn_primitive_attr attr, IntPointer count, IntPointer mask,
        @Cast("const float**") PointerPointer scales);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_get_output_scales(
        @Const mkldnn_primitive_attr attr, IntPointer count, IntPointer mask,
        @Const @ByPtrPtr FloatPointer scales);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_get_output_scales(
        @Const mkldnn_primitive_attr attr, IntBuffer count, IntBuffer mask,
        @Const @ByPtrPtr FloatBuffer scales);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_get_output_scales(
        @Const mkldnn_primitive_attr attr, int[] count, int[] mask,
        @Const @ByPtrPtr float[] scales);

/** Sets output \p scales for primitive operations. The number of elements \p
 * count and correspondence scale \p mask are stored for future use.
 *
 * The \p mask argument defines the correspondence between the output tensor
 * dimensions and the \p scales array. Set the i-th bit of \p mask to 1 to use a
 * dedicated scaling factor for each slice of the output tensor over the i-th
 * dimension. Set \p mask to 0 to use a common scaling factor for the whole
 * output tensor.
 *
 * \note
 *      The dimension order is always native and does not depend on the actual
 *      layout used. Examples:
 *       - 2D dimensional data the order of dimensions is always: (n, c)
 *       - 4D dimensional data the order is always: (n, c, h, w)
 *       - 5D dimensional weights the order is always: (g, oc, ic, kh, kw)
 *
 * Example usage:
 * <pre>{@code
 *      int mb = 32, oc = 32, oh = 14, ow = 14; // convolution output params
 *      float scales[oc] = { ... }; // unique output scales per output channel
 *      int oc_dim = 1; // mb_dim = 0, channel_dim = 1, height_dim = 2, ...
 *
 *      mkldnn_convolution_desc_t cd; // create & configure convolution op_desc
 *
 *      mkldnn_primitive_attr_t attr;
 *      mkldnn_primitive_attr_create(&attr);  // create default attributes
 *      mkldnn_primitive_attr_set_output_scales(attr, oc, 1 << oc_dim, scales);
 *
 *      mkldnn_primitive_desc_t cpd;
 *      mkldnn_primitive_desc_create_v2(&cpd, &cd, attr, NULL);
 * }</pre>
 *
 * \note
 *      There is no way to check that \p count corresponds to \p mask until an
 *      actual primitive descriptor is created, so it is the user's
 *      responsibility to set proper values. The following formula must hold:
 *
 *      <pre>{@code \[count = \prod\limits_{d \in mask} output.dims[d]\]}</pre>
 */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_set_output_scales(
        mkldnn_primitive_attr attr, int count, int mask,
        @Const FloatPointer scales);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_set_output_scales(
        mkldnn_primitive_attr attr, int count, int mask,
        @Const FloatBuffer scales);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_set_output_scales(
        mkldnn_primitive_attr attr, int count, int mask,
        @Const float[] scales);

/** Returns \p post_ops for given \p attr.
 *
 * \warning
 *      \p post_ops points to the internal \p attr field, so the user should not
 *      modify or destroy \p post_ops. Also, the lifetime of \p post_ops is the
 *      same as that of the \p attr it belongs to, so it is illegal to use \p
 *      post_ops after \p attr has been destroyed.
 */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_get_post_ops(
        @Const mkldnn_primitive_attr attr, @Const @ByPtrPtr mkldnn_post_ops post_ops);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_get_post_ops(
        @Const mkldnn_primitive_attr attr, @Cast("const_mkldnn_post_ops_t*") PointerPointer post_ops);

/** Sets configured \p post_ops to an attribute \p attr for future use (when
 * primitive descriptor is being created).
 *
 * \note
 *      At this point in time, there is no way to check whether the primitive
 *      descriptor does or does not support a given sequence of post operations.
 *      Therefore the user should handle an error that might occur at the
 *      mkldnn_primitive_desc_create call.
 */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_set_post_ops(
        mkldnn_primitive_attr attr, @Const mkldnn_post_ops post_ops);

/** \addtogroup c_api_attributes_post_ops Sequence of post operations
 * An extension for performing extra operations after a base operation.
 * \{ */

/** Creates an empty sequence of post operations \p post_ops. */
public static native @Cast("mkldnn_status_t") int mkldnn_post_ops_create(@ByPtrPtr mkldnn_post_ops post_ops);
public static native @Cast("mkldnn_status_t") int mkldnn_post_ops_create(@Cast("mkldnn_post_ops_t*") PointerPointer post_ops);

/** Deletes a \p post_ops sequence. */
public static native @Cast("mkldnn_status_t") int mkldnn_post_ops_destroy(mkldnn_post_ops post_ops);

/** Returns the \p length of post operations for given \p post_ops. */
public static native int mkldnn_post_ops_len(@Const mkldnn_post_ops post_ops);

/** Returns the type of post operation with index \p index in given
 * \p post_ops. In case of error, returns #mkldnn_undefined_primitive. */
public static native @Cast("mkldnn_primitive_kind_t") int mkldnn_post_ops_get_kind(
        @Const mkldnn_post_ops post_ops, int index);

/** Appends accumulation (sum) post operation to the \p post_ops. Prior to
 * accumulating the result, the previous value would be multiplied by \p scale.
 *
 * The kind of this post operation is #mkldnn_sum.
 *
 * This feature might improve performance for cases like residual learning
 * blocks, where the result of convolution is accumulated to the previously
 * computed activations. The parameter \p scale might be extreme for the
 * integer-based computations when the result and previous activations have
 * different logical scaling factors.
 *
 * In the simplest case when the accumulation is the only post operation, the
 * computations would be:
 * dst[] <- scale * dst[] + op(...) // instead of dst[] <- op(...)
 *
 * \note
 *      This post operation (as well as all the others) disregards the original
 *      layout of the destination; that is, the layout of the original
 *      destination is expected to be the same as the layout of the stored
 *      destination.
 */
public static native @Cast("mkldnn_status_t") int mkldnn_post_ops_append_sum(
        mkldnn_post_ops post_ops, float scale);

/** Gets the parameters of the accumulation (sum) post operation with index
 * \p index in the sequence of \p post_ops.
 *
 * \note
 *      If index \p index would not correspond to the accumulation post
 *      operation, the function returns #mkldnn_invalid_arguments.
 */
public static native @Cast("mkldnn_status_t") int mkldnn_post_ops_get_params_sum(
        @Const mkldnn_post_ops post_ops, int index, FloatPointer scale);
public static native @Cast("mkldnn_status_t") int mkldnn_post_ops_get_params_sum(
        @Const mkldnn_post_ops post_ops, int index, FloatBuffer scale);
public static native @Cast("mkldnn_status_t") int mkldnn_post_ops_get_params_sum(
        @Const mkldnn_post_ops post_ops, int index, float[] scale);

/** Appends eltwise post operation to the \p post_ops with given parameters
 * \p kind, \p alpha, and \p beta (@see mkldnn_eltwise_forward_desc_init and
 * mkldnn_eltwise_desc_t).
 *
 * The kind of this post operation is #mkldnn_eltwise.
 *
 * In the simplest case when the eltwise is the only post operation, the
 * computations would be:
 * dst[] <- scale * eltwise_op ( op(...) ) // instead of dst[] <- op(...)
 * where eltwise_op is configured with the given parameters.
 */
public static native @Cast("mkldnn_status_t") int mkldnn_post_ops_append_eltwise(
        mkldnn_post_ops post_ops, float scale, @Cast("mkldnn_alg_kind_t") int alg,
        float alpha, float beta);

/** Gets the eltwise parameters of the post operation with index \p index in
 * the sequence of \p post_ops.
 */
public static native @Cast("mkldnn_status_t") int mkldnn_post_ops_get_params_eltwise(
        @Const mkldnn_post_ops post_ops, int index, FloatPointer scale,
        @Cast("mkldnn_alg_kind_t*") IntPointer alg, FloatPointer alpha, FloatPointer beta);
public static native @Cast("mkldnn_status_t") int mkldnn_post_ops_get_params_eltwise(
        @Const mkldnn_post_ops post_ops, int index, FloatBuffer scale,
        @Cast("mkldnn_alg_kind_t*") IntBuffer alg, FloatBuffer alpha, FloatBuffer beta);
public static native @Cast("mkldnn_status_t") int mkldnn_post_ops_get_params_eltwise(
        @Const mkldnn_post_ops post_ops, int index, float[] scale,
        @Cast("mkldnn_alg_kind_t*") int[] alg, float[] alpha, float[] beta);

/** \} */

/** \} */

/** \addtogroup c_api_memory Memory
 * A primitive to describe and store data.
 *
 * The library supports various data types and formats. Memory hierarchy
 * consists of three levels of abstraction:
 * 1. **Memory descriptor** -- engine agnostic logical description of data
 *      (number of dimensions, dimensions themselves, and data type), and
 *      optionally the format/layout that describes the physical representation
 *      of data in memory. If the format is not known yet, one can pass
 *      #mkldnn_any. This approach is used to allow compute-intensive
 *      primitives to specify the most appropriate format on their own with
 *      users required to reorder the data if the incoming format doesn't match
 *      the primitive's selection. Memory descriptor can be created with the
 *      mkldnn_memory_desc_init() function or by directly filling the
 *      mkldnn_memory_desc_t structure. The latter requires deep knowledge of
 *      how the physical data representation is mapped to the structure. The
 *      \ref understanding_memory_formats topic should shed some light on that.
 * 2. **Memory primitive descriptor** -- logical description of data that is
 *      fully defined; that is, it cannot contain #mkldnn_any as a format. It
 *      also has the engine specified. A memory primitive descriptor is created
 *      by calling mkldnn_memory_primitive_desc_create() with two arguments: an
 *      mkldnn_memory_desc_t and an mkldnn_engine_t. It has the same type as
 *      other primitive descriptors and can be:
 *      - queried to return the underlying memory descriptor using
 *        mkldnn_primitive_desc_query() and
 *        mkldnn_primitive_desc_query_memory_d().
 *      - compared with another memory primitive descriptor using
 *        mkldnn_memory_primitive_desc_equal(). This is especially useful when
 *        checking whether a primitive requires reorder from the user's data
 *        format to the primitive's format.
 *      - queried to return the size of the data using
 *        mkldnn_memory_primitive_desc_get_size(). As described in
 *        \ref understanding_memory_formats, the size of data sometimes cannot
 *        be computed as the product of dimensions times the size of the data
 *        type. So users are encouraged to use this function for better code
 *        portability.
 * 3. **Memory primitive** or simply **memory** -- a pseudo-primitive that is
 *      defined by a memory primitive descriptor and a handle to the data
 *      itself. (In the case of CPU engine, the handle is simply a pointer to
 *      \c void.) The data handle can be queried using
 *      mkldnn_memory_get_data_handle() and set using
 *      mkldnn_memory_set_data_handle(). The latter function always sets the
 *      memory in the padding region to zero, which is the invariant maintained
 *      by all the primitives in Intel MKL-DNN. See
 *      \ref understanding_memory_formats for more details.
 *      A memory primitive can be created using mkldnn_primitive_create() with
 *      empty inputs and outputs. In this case, the memory primitive's data
 *      handle must be set manually using mkldnn_memory_set_data_handle().
 *
 * Along with ordinary memory with all dimensions being positive, Intel
 * MKL-DNN supports *zero-volume* memory with one or more dimensions set to
 * zero. This is to support the NumPy\* convention.
 * If a *zero-volume* memory is passed to a primitive, the primitive does
 * not perform any computations on this memory. For example:
 *  - Convolution with {@code (0 batch, 3 input channels, 13 height, 13 width)}
 *    source and {@code (16 output channels, 3 inputs, channel, 3 height, 3 width)}
 *    weights would produce {@code (0 batch, 16 ouput channels, 11 height, 11 width)}
 *    destination (assuming strides are {@code 1} and paddings are zero) and perform
 *    zero multiply-add operations.
 *  - Concatenation of three memories of shapes {@code (3, 4, 13, 13)},
 *    {@code (3, 0, 13, 13)}, and {@code (3, 1, 13, 13)} along the second axis would produce
 *    the output of the shape {@code (3, 5, 13, 13)}, effectively ignoring the second
 *    input (however, if the user created a concatenation primitive descriptor
 *    with three inputs they should also provide all three memories to the
 *    concatenation primitive, including the one with zero second dimension).
 *  - However, Intel MKL-DNN would return an error when attempting to create a
 *    convolution with *zero-volume* memory passed for weights because such a
 *    convolution is not well-defined:
 *    ~~~
 *    dst(1, 16, 11, 11) <-- src(1, 0, 13, 13) (*) wei(16, 0, 3, 3)
 *    ~~~
 *    Should the values in the destination be zeroes or just not accessed at
 *    all? Moreover, backward pass w.r.t. weights in such cases is also not
 *    well-defined.
 *
 *  Data handle of *zero-volume* memory is never accessed and hence can be
 *  unset (NULL in case of CPU engine).
 *
 * @see \ref understanding_memory_formats
 * \{ */

/** Initializes a \p memory_desc memory descriptor using \p ndims, \p dims, \p
 * data_type, and data \p format. \p format can be #mkldnn_any, which means
 * that specific data layouts are not permitted. */
public static native @Cast("mkldnn_status_t") int mkldnn_memory_desc_init(
        mkldnn_memory_desc_t memory_desc, int ndims, @Const IntPointer dims,
        @Cast("mkldnn_data_type_t") int data_type, @Cast("mkldnn_memory_format_t") int format);
public static native @Cast("mkldnn_status_t") int mkldnn_memory_desc_init(
        mkldnn_memory_desc_t memory_desc, int ndims, @Const IntBuffer dims,
        @Cast("mkldnn_data_type_t") int data_type, @Cast("mkldnn_memory_format_t") int format);
public static native @Cast("mkldnn_status_t") int mkldnn_memory_desc_init(
        mkldnn_memory_desc_t memory_desc, int ndims, @Const int[] dims,
        @Cast("mkldnn_data_type_t") int data_type, @Cast("mkldnn_memory_format_t") int format);

/** Creates a \p memory_primitive_desc memory primitive descriptor using \p
 * memory_desc and \p engine. \p memory_desc cannot be uncertain; that is, it
 * cannot be initialized with #mkldnn_any. */
public static native @Cast("mkldnn_status_t") int mkldnn_memory_primitive_desc_create(
        @ByPtrPtr mkldnn_primitive_desc memory_primitive_desc,
        @Const mkldnn_memory_desc_t memory_desc, mkldnn_engine engine);
public static native @Cast("mkldnn_status_t") int mkldnn_memory_primitive_desc_create(
        @Cast("mkldnn_primitive_desc_t*") PointerPointer memory_primitive_desc,
        @Const mkldnn_memory_desc_t memory_desc, mkldnn_engine engine);

/** Creates a \p view_primitive_desc for a given \p memory_primitive_desc, with
 * \p dims sizes and \p offsets offsets. May fail if the format used does not
 * allow obtaining the desired view. In this case, consider using the extract
 * primitive. */
public static native @Cast("mkldnn_status_t") int mkldnn_view_primitive_desc_create(
        @ByPtrPtr mkldnn_primitive_desc view_primitive_desc,
        @Const mkldnn_primitive_desc memory_primitive_desc,
        @Const IntPointer dims, @Const IntPointer offsets);
public static native @Cast("mkldnn_status_t") int mkldnn_view_primitive_desc_create(
        @Cast("mkldnn_primitive_desc_t*") PointerPointer view_primitive_desc,
        @Const mkldnn_primitive_desc memory_primitive_desc,
        @Const IntBuffer dims, @Const IntBuffer offsets);
public static native @Cast("mkldnn_status_t") int mkldnn_view_primitive_desc_create(
        @ByPtrPtr mkldnn_primitive_desc view_primitive_desc,
        @Const mkldnn_primitive_desc memory_primitive_desc,
        @Const int[] dims, @Const int[] offsets);
public static native @Cast("mkldnn_status_t") int mkldnn_view_primitive_desc_create(
        @Cast("mkldnn_primitive_desc_t*") PointerPointer view_primitive_desc,
        @Const mkldnn_primitive_desc memory_primitive_desc,
        @Const IntPointer dims, @Const IntPointer offsets);
public static native @Cast("mkldnn_status_t") int mkldnn_view_primitive_desc_create(
        @ByPtrPtr mkldnn_primitive_desc view_primitive_desc,
        @Const mkldnn_primitive_desc memory_primitive_desc,
        @Const IntBuffer dims, @Const IntBuffer offsets);
public static native @Cast("mkldnn_status_t") int mkldnn_view_primitive_desc_create(
        @Cast("mkldnn_primitive_desc_t*") PointerPointer view_primitive_desc,
        @Const mkldnn_primitive_desc memory_primitive_desc,
        @Const int[] dims, @Const int[] offsets);

/** Compares two descriptors of memory primitives.
 * @return 1 if the descriptors are the same.
 * @return 0 if the descriptors are different.
 *
 * Use this function to identify whether a reorder is required for the memory
 * primitives. \p lhs and \p rhs must be either memory or view primitive
 * descriptors. */
public static native int mkldnn_memory_primitive_desc_equal(
        @Const mkldnn_primitive_desc lhs,
        @Const mkldnn_primitive_desc rhs);

/** Returns the size (in bytes) that is required for given \p
 * memory_primitive_desc */
/* XXX: view? */
public static native @Cast("size_t") long mkldnn_memory_primitive_desc_get_size(
        @Const mkldnn_primitive_desc memory_primitive_desc);

/** For a \p memory primitive, returns the data \p handle. For the CPU engine,
 * the data handle is a pointer to the actual data. */
/* XXX: view? */
public static native @Cast("mkldnn_status_t") int mkldnn_memory_get_data_handle(
        @Const mkldnn_primitive memory, @Cast("void**") PointerPointer handle);
public static native @Cast("mkldnn_status_t") int mkldnn_memory_get_data_handle(
        @Const mkldnn_primitive memory, @Cast("void**") @ByPtrPtr Pointer handle);

/** For a \p memory primitive, sets the data \p handle. */
public static native @Cast("mkldnn_status_t") int mkldnn_memory_set_data_handle(
        mkldnn_primitive memory, Pointer handle);

/** \} */

/** \addtogroup c_api_reorder Reorder
 * A primitive to copy data between memory formats.
 * \{ */

/** Initializes a \p reorder_primitive_desc using descriptors of \p input and
 * \p output memory primitives.
 *
 * Order of inputs:
 *  - input (#mkldnn_query_input_pd, 0)
 *
 * Order of outputs:
 *  - output (#mkldnn_query_output_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_reorder_primitive_desc_create(
        @ByPtrPtr mkldnn_primitive_desc reorder_primitive_desc,
        @Const mkldnn_primitive_desc input,
        @Const mkldnn_primitive_desc output);
public static native @Cast("mkldnn_status_t") int mkldnn_reorder_primitive_desc_create(
        @Cast("mkldnn_primitive_desc_t*") PointerPointer reorder_primitive_desc,
        @Const mkldnn_primitive_desc input,
        @Const mkldnn_primitive_desc output);

/** Initializes a \p reorder_primitive_desc using an \p attr attribute and
 * descriptors of \p input and \p output memory primitives.
 *
 * Order of inputs:
 *  - input (#mkldnn_query_input_pd, 0)
 *
 * Order of outputs:
 *  - output (#mkldnn_query_output_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_reorder_primitive_desc_create_v2(
        @ByPtrPtr mkldnn_primitive_desc reorder_primitive_desc,
        @Const mkldnn_primitive_desc input,
        @Const mkldnn_primitive_desc output,
        @Const mkldnn_primitive_attr attr);
public static native @Cast("mkldnn_status_t") int mkldnn_reorder_primitive_desc_create_v2(
        @Cast("mkldnn_primitive_desc_t*") PointerPointer reorder_primitive_desc,
        @Const mkldnn_primitive_desc input,
        @Const mkldnn_primitive_desc output,
        @Const mkldnn_primitive_attr attr);

/** \} */

/** \addtogroup c_api_concat Concat
 * A primitive to concatenate data by arbitrary dimension.
 * \{ */

/** Creates out-of-place \p concat_primitive_desc for concatenation of \p n
 * inputs by \p concat_dimension with resulting \p output_desc memory
 * descriptor. \p output_desc can be NULL or specified with the #mkldnn_any
 * format -- in this case, the appropriate memory format would be chosen
 * automatically.
 *
 * Order of inputs:
 *  - input 0 (#mkldnn_query_input_pd, 0)
 *  - input 1 (#mkldnn_query_input_pd, 1)
 *  - ...
 *  - input \p n - 1 (#mkldnn_query_input_pd, \p n - 1)
 *
 * Order of outputs:
 *  - output (#mkldnn_query_output_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_concat_primitive_desc_create(
        @ByPtrPtr mkldnn_primitive_desc concat_primitive_desc,
        @Const mkldnn_memory_desc_t output_desc, int n, int concat_dimension,
        @Const @ByPtrPtr mkldnn_primitive_desc input_pds);
public static native @Cast("mkldnn_status_t") int mkldnn_concat_primitive_desc_create(
        @Cast("mkldnn_primitive_desc_t*") PointerPointer concat_primitive_desc,
        @Const mkldnn_memory_desc_t output_desc, int n, int concat_dimension,
        @Cast("const_mkldnn_primitive_desc_t*") PointerPointer input_pds);

// #if 0
// #endif

/** \} */

/** \addtogroup c_api_sum Sum
 * A primitive to sum data.
 * \{ */

/** Creates out-of-place \p sum_primitive_desc for sum of \p n
 * inputs multiplied by scale with resulting \p output_desc memory
 * descriptor. \p output_desc can be NULL or specified with the #mkldnn_any
 * format -- in this case, the appropriate memory format would be chosen
 * automatically.
 *
 * Order of inputs:
 *  - input 0 (#mkldnn_query_input_pd, 0)
 *  - input 1 (#mkldnn_query_input_pd, 1)
 *  - ...
 *  - input \p n - 1 (#mkldnn_query_input_pd, \p n - 1)
 *
 * Order of outputs:
 *  - output (#mkldnn_query_output_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_sum_primitive_desc_create(
        @ByPtrPtr mkldnn_primitive_desc sum_primitive_desc,
        @Const mkldnn_memory_desc_t output_desc, int n, @Const FloatPointer scales,
        @Const @ByPtrPtr mkldnn_primitive_desc input_pds);
public static native @Cast("mkldnn_status_t") int mkldnn_sum_primitive_desc_create(
        @Cast("mkldnn_primitive_desc_t*") PointerPointer sum_primitive_desc,
        @Const mkldnn_memory_desc_t output_desc, int n, @Const FloatBuffer scales,
        @Cast("const_mkldnn_primitive_desc_t*") PointerPointer input_pds);
public static native @Cast("mkldnn_status_t") int mkldnn_sum_primitive_desc_create(
        @ByPtrPtr mkldnn_primitive_desc sum_primitive_desc,
        @Const mkldnn_memory_desc_t output_desc, int n, @Const float[] scales,
        @Const @ByPtrPtr mkldnn_primitive_desc input_pds);
public static native @Cast("mkldnn_status_t") int mkldnn_sum_primitive_desc_create(
        @Cast("mkldnn_primitive_desc_t*") PointerPointer sum_primitive_desc,
        @Const mkldnn_memory_desc_t output_desc, int n, @Const FloatPointer scales,
        @Cast("const_mkldnn_primitive_desc_t*") PointerPointer input_pds);
public static native @Cast("mkldnn_status_t") int mkldnn_sum_primitive_desc_create(
        @ByPtrPtr mkldnn_primitive_desc sum_primitive_desc,
        @Const mkldnn_memory_desc_t output_desc, int n, @Const FloatBuffer scales,
        @Const @ByPtrPtr mkldnn_primitive_desc input_pds);
public static native @Cast("mkldnn_status_t") int mkldnn_sum_primitive_desc_create(
        @Cast("mkldnn_primitive_desc_t*") PointerPointer sum_primitive_desc,
        @Const mkldnn_memory_desc_t output_desc, int n, @Const float[] scales,
        @Cast("const_mkldnn_primitive_desc_t*") PointerPointer input_pds);

/** \} */

/** \addtogroup c_api_convolution Convolution
 * A primitive to compute convolution using different algorithms.
 *
 * <pre>{@code \[dst[n][oc][oh][ow]  =
 *     \sum_{kw=0}^{KW}\sum_{kh=0}^{KH}\sum_{ic=0}^{IC}
 *     src[n][ic][oh \cdot s_h - p_l[0] + kh][ow \cdot s_w - p_r[1] + kw]
 *     \cdot weights[g][oc][ic][kh][kw]
 *     + bias[g][oc],\]}</pre>
 *
 * where size of output spatial domain is given by
 * {@code  OH = \left\lfloor{\frac{IH - KH + p_l[0] + p_r[0]}{s_h}}
 *          \right\rfloor + 1},
 * {@code  OW = \left\lfloor{\frac{IW - KW + p_l[1] + p_r[1]}{s_w}}
 *          \right\rfloor + 1},
 *
 * and summation is carried over input channels {@code ic} in
 * group {@code g}, and {@code s_h, s_w} are \p strides and
 * {@code p_l, p_r} are \p padding_l and \p padding_r.
 * \{ */

/** Initializes a convolution descriptor \p conv_desc for forward propagation
 * using \p prop_kind (possible values are #mkldnn_forward_training and
 * #mkldnn_forward_inference), \p alg_kind, memory descriptors, \p strides, \p
 * padding_l, \p padding_r, and \p padding_kind. In order to create a
 * convolution without bias, \p bias_desc should either be \c NULL or point to
 * a descriptor with memory format equal to #mkldnn_format_undef.
 *
 * \note If \p padding_r is \c NULL, the padding is supposed to be symmetric.
 *
 * \note Memory descriptors are allowed to be initialized with #mkldnn_any
 * value of \p format_kind.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - weights (#mkldnn_query_weights_pd, 0)
 *  - bias (#mkldnn_query_weights_pd, 1), if created with bias
 *
 * Order of outputs:
 *  - dst (#mkldnn_query_dst_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_convolution_forward_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const IntPointer strides,
        @Const IntPointer padding_l, @Const IntPointer padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_convolution_forward_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const IntBuffer strides,
        @Const IntBuffer padding_l, @Const IntBuffer padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_convolution_forward_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const int[] strides,
        @Const int[] padding_l, @Const int[] padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);

/** Initializes a dilated convolution descriptor \p conv_desc for forward
 * propagation using \p prop_kind (possible values are #mkldnn_forward_training
 * and #mkldnn_forward_inference), \p alg_kind, memory descriptors, \p strides,
 * \p dilates, \p padding_l, \p padding_r, and \p padding_kind.
 * In order to create a dilated convolution without bias, \p bias_desc
 * should either be \c NULL or point to a descriptor with memory format equal
 * to #mkldnn_format_undef.
 *
 * \note If \p padding_r is \c NULL, the padding is supposed to be symmetric.
 *
 * \note Memory descriptors are allowed to be initialized with #mkldnn_any
 * value of \p format_kind.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - weights (#mkldnn_query_weights_pd, 0)
 *  - bias (#mkldnn_query_weights_pd, 1), if created with bias
 *
 * Order of outputs:
 *  - dst (#mkldnn_query_dst_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_convolution_forward_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const IntPointer strides,
        @Const IntPointer dilates, @Const IntPointer padding_l,
        @Const IntPointer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_convolution_forward_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const IntBuffer strides,
        @Const IntBuffer dilates, @Const IntBuffer padding_l,
        @Const IntBuffer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_convolution_forward_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const int[] strides,
        @Const int[] dilates, @Const int[] padding_l,
        @Const int[] padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);

/** Initializes a convolution descriptor \p conv_desc for backward propagation
 * with respect to data using \p alg_kind, memory descriptors, \p strides, \p
 * padding_l, \p padding_r, and \p padding_kind.
 *
 * \note Memory descriptors are allowed to be initialized with #mkldnn_any
 * value of \p format_kind.
 *
 * Order of inputs:
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *  - weights (#mkldnn_query_weights_pd, 0)
 *
 * Order of outputs:
 *  - diff_src (#mkldnn_query_diff_src_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_convolution_backward_data_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntPointer strides,
        @Const IntPointer padding_l, @Const IntPointer padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_convolution_backward_data_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntBuffer strides,
        @Const IntBuffer padding_l, @Const IntBuffer padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_convolution_backward_data_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const int[] strides,
        @Const int[] padding_l, @Const int[] padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);

/** Initializes a dilated convolution descriptor \p conv_desc for backward
 * propagation with respect to data using \p alg_kind, memory descriptors, \p
 * strides, \p dilates \p padding_l, \p padding_r, and \p padding_kind.
 *
 * \note Memory descriptors are allowed to be initialized with #mkldnn_any
 * value of \p format_kind.
 *
 * Order of inputs:
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *  - weights (#mkldnn_query_weights_pd, 0)
 *
 * Order of outputs:
 *  - diff_src (#mkldnn_query_diff_src_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_convolution_backward_data_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntPointer strides,
        @Const IntPointer dilates, @Const IntPointer padding_l,
        @Const IntPointer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_convolution_backward_data_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntBuffer strides,
        @Const IntBuffer dilates, @Const IntBuffer padding_l,
        @Const IntBuffer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_convolution_backward_data_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const int[] strides,
        @Const int[] dilates, @Const int[] padding_l,
        @Const int[] padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);

/** Initializes a convolution descriptor \p conv_desc for backward propagation
 * with respect to weights using \p alg_kind, memory descriptors, \p strides,
 * \p padding_l, \p padding_r, and \p padding_kind.
 *
 * \note Memory descriptors are allowed to be initialized with #mkldnn_any
 * value of \p format_kind.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *
 * Order of outputs:
 *  - diff_weights (#mkldnn_query_diff_weights_pd, 0)
 *  - diff_bias (#mkldnn_query_diff_weights_pd, 1), if created with bias
 */
public static native @Cast("mkldnn_status_t") int mkldnn_convolution_backward_weights_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t diff_weights_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntPointer strides,
        @Const IntPointer padding_l, @Const IntPointer padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_convolution_backward_weights_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t diff_weights_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntBuffer strides,
        @Const IntBuffer padding_l, @Const IntBuffer padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_convolution_backward_weights_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t diff_weights_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const int[] strides,
        @Const int[] padding_l, @Const int[] padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);

/** Initializes a convolution descriptor \p conv_desc for backward propagation
 * with respect to weights using \p alg_kind, memory descriptors, \p strides,
 * \p dilates \p padding_l, \p padding_r, and \p padding_kind.
 *
 * \note Memory descriptors are allowed to be initialized with #mkldnn_any
 * value of \p format_kind.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *
 * Order of outputs:
 *  - diff_weights (#mkldnn_query_diff_weights_pd, 0)
 *  - diff_bias (#mkldnn_query_diff_weights_pd, 1), if created with bias
 */
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_convolution_backward_weights_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t diff_weights_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntPointer strides,
        @Const IntPointer dilates, @Const IntPointer padding_l,
        @Const IntPointer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_convolution_backward_weights_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t diff_weights_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntBuffer strides,
        @Const IntBuffer dilates, @Const IntBuffer padding_l,
        @Const IntBuffer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_convolution_backward_weights_desc_init(
        mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t diff_weights_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const int[] strides,
        @Const int[] dilates, @Const int[] padding_l,
        @Const int[] padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);

/** \} */

/** \addtogroup c_api_deconvolution Deconvolution
 * A primitive to compute deconvolution using different algorithms.
 *
 * \{ */


/** Initializes a deconvolution descriptor \p deconv_desc for forward
 * propagation using \p prop_kind (possible values are #mkldnn_forward_training
 * and #mkldnn_forward_inference), \p alg_kind, memory descriptors, \p strides,
 * \p padding_l, \p padding_r, and \p padding_kind. In order to create a
 * deconvolution without bias, \p bias_desc should either be \c NULL or point to
 * a descriptor with memory format equal to #mkldnn_format_undef.
 *
 * \note If \p padding_r is \c NULL, the padding is supposed to be symmetric.
 *
 * \note Memory descriptors are allowed to be initialized with #mkldnn_any
 * value of \p format_kind.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - weights (#mkldnn_query_weights_pd, 0)
 *  - bias (#mkldnn_query_weights_pd, 1), if created with bias
 *
 * Order of outputs:
 *  - dst (#mkldnn_query_dst_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_deconvolution_forward_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const IntPointer strides,
        @Const IntPointer padding_l, @Const IntPointer padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_deconvolution_forward_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const IntBuffer strides,
        @Const IntBuffer padding_l, @Const IntBuffer padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_deconvolution_forward_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const int[] strides,
        @Const int[] padding_l, @Const int[] padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);

/** Initializes a dilated deconvolution descriptor \p deconv_desc for forward
 * propagation using \p prop_kind (possible values are #mkldnn_forward_training
 * and #mkldnn_forward_inference), \p alg_kind, memory descriptors, \p strides,
 * \p dilates, \p padding_l, \p padding_r, and \p padding_kind. In order to
 * create a dilated deconvolution without bias, \p bias_desc should either be
 * \c NULL or point to a descriptor with memory format equal to
 * #mkldnn_format_undef.
 *
 * \note If \p padding_r is \c NULL, the padding is supposed to be symmetric.
 *
 * \note Memory descriptors are allowed to be initialized with #mkldnn_any
 * value of \p format_kind.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - weights (#mkldnn_query_weights_pd, 0)
 *  - bias (#mkldnn_query_weights_pd, 1), if created with bias
 *
 * Order of outputs:
 *  - dst (#mkldnn_query_dst_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_deconvolution_forward_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const IntPointer strides,
        @Const IntPointer dilates, @Const IntPointer padding_l,
        @Const IntPointer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_deconvolution_forward_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const IntBuffer strides,
        @Const IntBuffer dilates, @Const IntBuffer padding_l,
        @Const IntBuffer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_deconvolution_forward_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const int[] strides,
        @Const int[] dilates, @Const int[] padding_l,
        @Const int[] padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);

/** Initializes a deconvolution descriptor \p conv_desc for backward propagation
 * with respect to data using \p alg_kind, memory descriptors, \p strides, \p
 * padding_l, \p padding_r, and \p padding_kind.
 *
 * \note Memory descriptors are allowed to be initialized with #mkldnn_any
 * value of \p format_kind.
 *
 * Order of inputs:
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *  - weights (#mkldnn_query_weights_pd, 0)
 *
 * Order of outputs:
 *  - diff_src (#mkldnn_query_diff_src_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_deconvolution_backward_data_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntPointer strides,
        @Const IntPointer padding_l, @Const IntPointer padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_deconvolution_backward_data_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntBuffer strides,
        @Const IntBuffer padding_l, @Const IntBuffer padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_deconvolution_backward_data_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const int[] strides,
        @Const int[] padding_l, @Const int[] padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);

/** Initializes a dilated deconvolution descriptor \p conv_desc for backward
 * propagation with respect to data using \p alg_kind, memory descriptors, \p
 * strides, \p dilates, \p padding_l, \p padding_r, and \p padding_kind.
 *
 * \note Memory descriptors are allowed to be initialized with #mkldnn_any
 * value of \p format_kind.
 *
 * Order of inputs:
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *  - weights (#mkldnn_query_weights_pd, 0)
 *
 * Order of outputs:
 *  - diff_src (#mkldnn_query_diff_src_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_deconvolution_backward_data_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntPointer strides,
        @Const IntPointer dilates, @Const IntPointer padding_l,
        @Const IntPointer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_deconvolution_backward_data_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntBuffer strides,
        @Const IntBuffer dilates, @Const IntBuffer padding_l,
        @Const IntBuffer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_deconvolution_backward_data_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const int[] strides,
        @Const int[] dilates, @Const int[] padding_l,
        @Const int[] padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);

/** Initializes a deconvolution descriptor \p conv_desc for backward propagation
 * with respect to weights using \p alg_kind, memory descriptors, \p strides,
 * \p padding_l, \p padding_r, and \p padding_kind.
 *
 * \note Memory descriptors are allowed to be initialized with #mkldnn_any
 * value of \p format_kind.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *
 * Order of outputs:
 *  - diff_weights (#mkldnn_query_diff_weights_pd, 0)
 *  - diff_bias (#mkldnn_query_diff_weights_pd, 1), if created with bias
 */
public static native @Cast("mkldnn_status_t") int mkldnn_deconvolution_backward_weights_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t diff_weights_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntPointer strides,
        @Const IntPointer padding_l, @Const IntPointer padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_deconvolution_backward_weights_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t diff_weights_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntBuffer strides,
        @Const IntBuffer padding_l, @Const IntBuffer padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_deconvolution_backward_weights_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t diff_weights_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const int[] strides,
        @Const int[] padding_l, @Const int[] padding_r,
        @Cast("mkldnn_padding_kind_t") int padding_kind);

/** Initializes a dilated deconvolution descriptor \p conv_desc for backward
 * propagation with respect to weights using \p alg_kind, memory descriptors,
 * \p strides, \p dilates, \p padding_l, \p padding_r, and \p padding_kind.
 *
 * \note Memory descriptors are allowed to be initialized with #mkldnn_any
 * value of \p format_kind.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *
 * Order of outputs:
 *  - diff_weights (#mkldnn_query_diff_weights_pd, 0)
 *  - diff_bias (#mkldnn_query_diff_weights_pd, 1), if created with bias
 */
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_deconvolution_backward_weights_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t diff_weights_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntPointer strides,
        @Const IntPointer dilates, @Const IntPointer padding_l,
        @Const IntPointer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_deconvolution_backward_weights_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t diff_weights_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntBuffer strides,
        @Const IntBuffer dilates, @Const IntBuffer padding_l,
        @Const IntBuffer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_dilated_deconvolution_backward_weights_desc_init(
        @Cast("mkldnn_deconvolution_desc_t*") mkldnn_convolution_desc_t conv_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t diff_weights_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const int[] strides,
        @Const int[] dilates, @Const int[] padding_l,
        @Const int[] padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);

/** \} */

/** \addtogroup c_api_shuffle Shuffle
 * A primitive to shuffle data along the axis.
 * \{ */

/** Initializes a \p shuffle_desc for forward propagation using \p prop_kind,
 * memory descriptor \p data_desc, \p axis, and \p group_size.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *
 * Order of outputs:
 *  - dst (#mkldnn_query_dst_pd, 0)
 *
 */
public static native @Cast("mkldnn_status_t") int mkldnn_shuffle_forward_desc_init(
        mkldnn_shuffle_desc_t shuffle_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Const mkldnn_memory_desc_t data_desc, int axis, int group_size);

/** Initializes a \p shuffle_desc for backward propagation using memory
 * descriptor \p diff_data_desc, \p axis, and \p group_size.
 *
 *
 * Order of inputs:
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *
 * Order of outputs:
 *  - diff_src (#mkldnn_query_diff_src_pd, 0)
 *
 */
public static native @Cast("mkldnn_status_t") int mkldnn_shuffle_backward_desc_init(
        mkldnn_shuffle_desc_t shuffle_desc,
        @Const mkldnn_memory_desc_t diff_data_desc, int axis, int group_size);

/** \} */

/** \addtogroup c_api_eltwise Eltwise
 * A primitive to compute element-wise operations like parametric rectifier
 * linear unit (ReLU).
 *
 * Both forward and backward passes support in-place operation; that is, src
 * and dst point to the same memory for forward pass, and diff_dst and diff_src
 * point to the same memory for backward pass.
 *
 * \warning Because the original src is required for backward pass, in-place
 * forward pass in general cannot be applied during training. However, for some
 * kinds of element-wise operations (namely ReLU with alpha parameter equals 0),
 * dst and src can be interchangeable for the backward pass, which enables
 * performing in-place forward even for training.
 *
 * \{ */

/** Initializes an \p eltwise_desc for forward propagation using \p prop_kind
 * (possible values are #mkldnn_forward_training and #mkldnn_forward_inference),
 * \p alg_kind algorithm, memory descriptor \p data_desc, \p alpha, and
 * \p beta parameters.
 *
 * @see mkldnn_eltwise_desc_t for details.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *
 * Order of outputs:
 *  - dst (#mkldnn_query_dst_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_eltwise_forward_desc_init(
        mkldnn_eltwise_desc_t eltwise_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t data_desc,
        float alpha, float beta);

/** Initializes an \p eltwise_desc for backward propagation using \p alg_kind
 * algorithm memory descriptors \p diff_data_desc and \p data_desc, and the
 * \p alpha and \p beta parameters.
 *
 * @see mkldnn_eltwise_desc_t for details.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *
 * Order of outputs:
 *  - diff_src (#mkldnn_query_diff_src_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_eltwise_backward_desc_init(
        mkldnn_eltwise_desc_t eltwise_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_data_desc,
        @Const mkldnn_memory_desc_t data_desc, float alpha, float beta);

/** \} */

/** \addtogroup c_api_softmax Softmax
 * A primitive to perform softmax.
 *
 * <pre>{@code \[dst[u][c][in] =
 *    \frac{\exp(src[ou][c][in]) - \max\limits_{c}(src[ou][c][in])}
 *    {\sum\limits_{c}\{\exp(src[ou][c][in])
 *    - \max\limits_{c}(src[ou][c][in])\}},\]}</pre>
 *
 * where {@code ou, iu} are outer and inner sizes repectively, defined
 * by \p data_desc.dims and \p softmax_axis.
 * \{ */

/** Initializes a \p softmax_desc for forward propagation using \p prop_kind
 * (possible values are #mkldnn_forward_training and #mkldnn_forward_inference)
 * and memory descriptor \p data_desc.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *
 * Order of outputs:
 *  - dst (#mkldnn_query_dst_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_softmax_forward_desc_init(
        mkldnn_softmax_desc_t softmax_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Const mkldnn_memory_desc_t data_desc, int softmax_axis);

/** Initializes a \p softmax_desc for backward propagation using memory
 * descriptors \p diff_desc and \p data_desc.
 *
 * Order of inputs:
 *  - dst (#mkldnn_query_dst_pd, 0)
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *
 * Order of outputs:
 *  - diff_src (#mkldnn_query_diff_src_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_softmax_backward_desc_init(
        mkldnn_softmax_desc_t softmax_desc,
        @Const mkldnn_memory_desc_t diff_desc,
        @Const mkldnn_memory_desc_t data_desc, int softmax_axis);

/** \} */

/** \addtogroup c_api_pooling Pooling
 * A primitive to perform max or average pooling.
 *
 * Max pooling:
 * <pre>{@code \[dst[n][oc][oh][ow] =
 *     \max\limits_{kw,kh}
 *     (src[n][ic][oh \cdot s_h - p_l[0] + kh][ow \cdot s_w - p_r[1] + kw]),\]}</pre>
 *
 * Average pooling:
 * <pre>{@code \[dst[n][oc][oh][ow] =
 *     \frac{1}{KW \cdot KH}\sum\limits_{kw,kh}
 *     src[n][ic][oh \cdot s_h - p_l[0] + kh][ow \cdot s_w - p_r[1] + kw],\]}</pre>
 *
 * where {@code p_l, p_r} are \p padding_l and \p padding_r respectively, and
 * output spatial dimensions are calculated similarly to how they are done in
 * convolution.
 *
 * During training, max pooling requires a workspace on forward
 * (#mkldnn_forward_training) and backward (#mkldnn_backward) passes to
 * save indices where maximum was found. The workspace layout is opaque, and
 * the indices cannot be restored from it. However, one can use backward
 * pooling to perform up-sampling (used in some detection topologies).
 *
 * \{ */

/** Initializes a pooling descriptor \p pool_desc for forward propagation using
 * \p prop_kind (possible values are #mkldnn_forward_training and
 * #mkldnn_forward_inference), \p alg_kind, memory descriptors, and pooling
 * parameters in the spatial domain: \p strides, \p kernel sizes, \p padding_l,
 * \p padding_r, and \p padding_kind.
 *
 * \note If \p padding_r is \c NULL, the padding is supposed to be symmetric.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *
 * Order of outputs:
 *  - dst (#mkldnn_query_dst_pd, 0)
 *  - workspace (#mkldnn_query_workspace_pd, 0),
 *      if \p alg_kind = #mkldnn_pooling_max and
 *      \p prop_kind = #mkldnn_forward_training
 */
public static native @Cast("mkldnn_status_t") int mkldnn_pooling_forward_desc_init(
        mkldnn_pooling_desc_t pool_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const IntPointer strides,
        @Const IntPointer kernel, @Const IntPointer padding_l,
        @Const IntPointer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_pooling_forward_desc_init(
        mkldnn_pooling_desc_t pool_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const IntBuffer strides,
        @Const IntBuffer kernel, @Const IntBuffer padding_l,
        @Const IntBuffer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_pooling_forward_desc_init(
        mkldnn_pooling_desc_t pool_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t dst_desc, @Const int[] strides,
        @Const int[] kernel, @Const int[] padding_l,
        @Const int[] padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);

/** Initializes a pooling descriptor \p pool_desc for backward propagation
 * using \p alg_kind, memory descriptors, and pooling parameters in the spatial
 * domain: \p strides, \p kernel sizes, \p padding_l, \p padding_r, and \p
 * padding_kind.
 *
 * \note If \p padding_r is \c NULL, the padding is supposed to be symmetric.
 *
 * Order of inputs:
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *  - workspace (#mkldnn_query_workspace_pd, 0),
 *      if \p alg_kind = #mkldnn_pooling_max
 *
 * Order of outputs:
 *  - diff_src (#mkldnn_query_diff_src_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_pooling_backward_desc_init(
        mkldnn_pooling_desc_t pool_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntPointer strides,
        @Const IntPointer kernel, @Const IntPointer padding_l,
        @Const IntPointer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_pooling_backward_desc_init(
        mkldnn_pooling_desc_t pool_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const IntBuffer strides,
        @Const IntBuffer kernel, @Const IntBuffer padding_l,
        @Const IntBuffer padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_pooling_backward_desc_init(
        mkldnn_pooling_desc_t pool_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc, @Const int[] strides,
        @Const int[] kernel, @Const int[] padding_l,
        @Const int[] padding_r, @Cast("mkldnn_padding_kind_t") int padding_kind);

/** \} */

/** \addtogroup c_api_lrn LRN
 * A primitive to perform local response normalization (LRN) across or within
 * channels.
 *
 * LRN accross channels:
 * <pre>{@code \[dst[n][c][h][w] = \left\{k + \frac{\alpha}{n_{l}}
 *                      \sum\limits_{i=-(n_{l}-1)/2}^{(n_{l}+1)/2}
 *                      (src[n][c+i][h][w])^2\right\}^{-\beta}
 *                      src[n][c][h][w],\]}</pre>
 *
 * LRN within channels:
 * <pre>{@code \[dst[n][c][h][w] = \left\{k + \frac{\alpha}{n_{l}}
 *                      \sum\limits_{i=-(n_{l}-1)/2}^{(n_{l}+1)/2}
 *                      (src[n][c][h+i][w+i])^2\right\}^{-\beta}
 *                      src[n][c][h][w],\]}</pre>
 *
 * where {@code n_{l}} is the \p local_size.
 *
 * During training, LRN might or might not require a workspace on forward
 * (#mkldnn_forward_training) and backward (#mkldnn_backward) passes. The
 * behavior is implementation specific. Optimized implementations typically
 * require a workspace and use it to save some intermediate results from the
 * forward pass that accelerate computations on the backward pass.
 *
 * To check whether a workspace is required, query the LRN primitive descriptor
 * for the workspace (#mkldnn_query_workspace_pd). Success indicates that the
 * workspace is required and its description will be returned.
 * @see mkldnn_primitive_desc_query and mkldnn_primitive_desc_query_pd
 *
 * \{ */

/** Initializes an \p lrn_desc for forward propagation using \p prop_kind
 * (possible values are #mkldnn_forward_training and #mkldnn_forward_inference),
 * \p alg_kind, memory descriptor \p data_desc, and regularization
 * parameters \p local_size, \p alpha, \p beta, and \p k.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *
 * Order of outputs:
 *  - dst (#mkldnn_query_dst_pd, 0)
 *  - workspace (#mkldnn_query_workspace_pd, 0),
 *      if the underlying implementation requires
 */
public static native @Cast("mkldnn_status_t") int mkldnn_lrn_forward_desc_init(
        mkldnn_lrn_desc_t lrn_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Cast("mkldnn_alg_kind_t") int alg_kind, @Const mkldnn_memory_desc_t data_desc,
        int local_size, float alpha, float beta, float k);

/** Initializes an \p lrn_desc for backward propagation using \p alg_kind,
 * memory descriptors \p data_desc and \p diff_data_desc, and regularization
 * parameters \p local_size, \p alpha, \p beta, and \p k.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *  - workspace (#mkldnn_query_workspace_pd, 0),
 *      if the underlying implementation requires
 *
 * Order of outputs:
 *  - diff_src (#mkldnn_query_diff_src_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_lrn_backward_desc_init(
        mkldnn_lrn_desc_t lrn_desc, @Cast("mkldnn_alg_kind_t") int alg_kind,
        @Const mkldnn_memory_desc_t diff_data_desc,
        @Const mkldnn_memory_desc_t data_desc, int local_size, float alpha,
        float beta, float k);

/** \} */

/** \addtogroup c_api_batch_normalization Batch Normalization
 * A primitive to perform batch normalization.
 *
 * <pre>{@code \[dst[n][c][h][w] = \gamma[c] \frac{src[n][c][h][w] - \mu[c]}
 *                      {\sqrt{\sigma[c] + eps}} + \beta[c],\]}</pre>
 *
 * where {@code \gamma[c], \beta[c]} are weights and bias for a channel and,
 *
 * {@code \mu[c] = \frac{1}{NHW} \sum\limits_{whn} src[n][c][h][w]},
 * {@code \sigma[c] = \frac{1}{NHW} \sum\limits_{whn}
 *                              (src[n][c][h][w] - \mu[c])^2},
 *
 * and \c eps is a constant to improve numerical stability.
 *
 * Both forward and backward passes support in-place operation; that is, src
 * and dst point to the same memory for forward pass, and diff_dst and diff_src
 * point to the same memory for backward pass.
 *
 * Batch normalization supports different flavors controlled by
 * mkldnn_batch_normalization_desc_t. For example, batch normalization can
 * compute the mean and variance on its own or take them as inputs. It can
 * either perform scaling and shifting using gamma and beta parameters or not.
 * Optionally it can also perform a fused ReLU, which in case of training would
 * also require a workspace.
 *
 * @see mkldnn_batch_normalization_desc_t
 * \{ */

/** Initializes a batch normalization descriptor \p bnrm_desc for forward
 * propagation using \p prop_kind (possible values are
 * #mkldnn_forward_training and #mkldnn_forward_inference), memory descriptor
 * \p data_desc, normalization parameter \p epsilon, and \p flags set using bit
 * flags of type mkldnn_batch_normalization_desc_t.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - mean (#mkldnn_query_src_pd, 1),
 *      if #mkldnn_use_global_stats bit-flags is set in \p flags
 *  - variance (#mkldnn_query_src_pd, 2),
 *      if #mkldnn_use_global_stats bit-flags is set in \p flags
 *  - scale_and_shift (#mkldnn_query_weights_pd, 0),
 *      if #mkldnn_use_scaleshift bit-flags is set in \p flags
 *
 * Order of outputs:
 *  - dst (#mkldnn_query_dst_pd, 0)
 *  - mean (#mkldnn_query_dst_pd, 1),
 *      if #mkldnn_use_global_stats bit-flags is not set in \p flags
 *      \p prop_kind = #mkldnn_forward_training
 *  - variance (#mkldnn_query_dst_pd, 2),
 *      if #mkldnn_use_global_stats bit-flags is not set in \p flags
 *      and \p prop_kind = #mkldnn_forward_training
 *  - workspace (#mkldnn_query_workspace_pd, 0),
 *      if #mkldnn_fuse_bn_relu bit-flags is set in \p flags
 *      and \p prop_kind = #mkldnn_forward_training
 *
 * \note In-place operation is supported; that is, dst points to the same memory
 *       as src.
 *
 * @see mkldnn_batch_normalization_desc_t
 */
public static native @Cast("mkldnn_status_t") int mkldnn_batch_normalization_forward_desc_init(
        mkldnn_batch_normalization_desc_t bnrm_desc,
        @Cast("mkldnn_prop_kind_t") int prop_kind, @Const mkldnn_memory_desc_t data_desc,
        float epsilon, @Cast("unsigned") int flags);

/** Initializes a batch normalization descriptor \p bnrm_desc for backward
 * propagation with respect to data and scale-shift parameters using memory
 * descriptors \p data_desc and \p diff_data_desc, normalization parameter
 * \p epsilon, and \p flags set using bit flags of type
 * mkldnn_batch_normalization_desc_t.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - mean (#mkldnn_query_src_pd, 1)
 *  - variance (#mkldnn_query_src_pd, 2)
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *  - scale_and_shift (#mkldnn_query_weights_pd, 0),
 *      if #mkldnn_use_scaleshift bit-flags is set in \p flags
 *  - workspace (#mkldnn_query_workspace_pd, 0),
 *      if #mkldnn_fuse_bn_relu bit-flags is set in \p flags
 *
 * Order of outputs:
 *  - diff_src (#mkldnn_query_diff_src_pd, 0)
 *  - diff_scale_and_shift (#mkldnn_query_diff_weights_pd, 0),
 *      if #mkldnn_use_scaleshift bit-flags is set in \p flags
 *      and \p prop_kind = #mkldnn_backward
 *
 * \note in-place operation is supported,
 *       i.e. diff_src points to the same memory as diff_dst.
 *
 * @see mkldnn_batch_normalization_desc_t
 */
public static native @Cast("mkldnn_status_t") int mkldnn_batch_normalization_backward_desc_init(
        mkldnn_batch_normalization_desc_t bnrm_desc,
        @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Const mkldnn_memory_desc_t diff_data_desc,
        @Const mkldnn_memory_desc_t data_desc,
        float epsilon, @Cast("unsigned") int flags);

/** \} */

/** \addtogroup c_api_inner_product Inner product
 * A primitive to compute an inner product.
 *
 * Inner product layer is also known as fully connected layer.
 * With spatial dimension:
 *
 * <pre>{@code \[dst[n][oc] = \sum\limits_{ic, kh, kw}
 *                 src[n][ic][kh][kw] \cdot weights[oc][ic][kh][kw]
 *                 + bias[oc]\]}</pre>
 * \{ */

/** Initializes an inner product descriptor \p ip_desc for forward propagation
 * using \p prop_kind (possible values are #mkldnn_forward_training and
 * #mkldnn_forward_inference) and memory descriptors. In order to create an
 * inner product without bias, \p bias_desc should be either \c NULL or a
 * pointer to a descriptor with memory format equal to #mkldnn_format_undef.
 *
 * \note
 *     Memory descriptors are allowed to be initialized with #mkldnn_any value
 *     of \p format_kind.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - weights (#mkldnn_query_weights_pd, 0)
 *  - bias (#mkldnn_query_weights_pd, 1), if created with bias
 *
 * Order of outputs:
 *  - dst (#mkldnn_query_dst_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_inner_product_forward_desc_init(
        mkldnn_inner_product_desc_t ip_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_desc);

/** Initializes an inner product descriptor \p ip_desc for backward propagation
 * with respect to data using memory descriptors.
 *
 * \note
 *     Memory descriptors are allowed to be initialized with #mkldnn_any value
 *     of \p format_kind.
 *
 * Order of inputs:
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *  - weights (#mkldnn_query_weights_pd, 0)
 *
 * Order of outputs:
 *  - diff_src (#mkldnn_query_diff_src_pd, 0)
 */
public static native @Cast("mkldnn_status_t") int mkldnn_inner_product_backward_data_desc_init(
        mkldnn_inner_product_desc_t ip_desc,
        @Const mkldnn_memory_desc_t diff_src_desc,
        @Const mkldnn_memory_desc_t weights_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc);

/** Initializes an inner product descriptor \p ip_desc for backward propagation
 * with respect to weights using memory descriptors.
 *
 * \note
 *     Memory descriptors are allowed to be initialized with #mkldnn_any value
 *     of \p format_kind.
 *
 * Order of inputs:
 *  - src (#mkldnn_query_src_pd, 0)
 *  - diff_dst (#mkldnn_query_diff_dst_pd, 0)
 *
 * Order of outputs:
 *  - diff_weights (#mkldnn_query_diff_weights_pd, 0)
 *  - diff_bias (#mkldnn_query_diff_weights_pd, 1), if created with bias
 */
public static native @Cast("mkldnn_status_t") int mkldnn_inner_product_backward_weights_desc_init(
        mkldnn_inner_product_desc_t ip_desc,
        @Const mkldnn_memory_desc_t src_desc,
        @Const mkldnn_memory_desc_t diff_weights_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_desc);

/** \} */

/** \addtogroup c_api_rnn RNN
 * A primitive to compute the common recurrent layer.
 * \todo add additional description for the group
 * \{ */

/**
 * Initializes a recurrent cell descriptor \p rnn_cell_desc
 * using \p rnn_cell_desc, \p kind (possible values are
 *  #mkldnn_vanilla_rnn, #mkldnn_vanilla_lstm, #mkldnn_vanilla_gru, and
 *  #mkldnn_gru_linear_before_reset),
 *  \p f (possible values are #mkldnn_eltwise_relu and
 *   #mkldnn_eltwise_tanh), \p flags, \p alpha, and \p clipping.
 */
public static native @Cast("mkldnn_status_t") int mkldnn_rnn_cell_desc_init(
        mkldnn_rnn_cell_desc_t rnn_cell_desc,
        @Cast("mkldnn_alg_kind_t") int kind, @Cast("mkldnn_alg_kind_t") int f,
        @Cast("unsigned int") int flags, float alpha, float clipping);

/** Returns the number of gates of a particular \p rnn_cell_desc. */
public static native int mkldnn_rnn_cell_get_gates_count(
        @Const mkldnn_rnn_cell_desc_t rnn_cell_desc);

/** Returns the number of states of a particular \p rnn_cell_desc. */
public static native int mkldnn_rnn_cell_get_states_count(
        @Const mkldnn_rnn_cell_desc_t rnn_cell_desc);

/** Sets quantization \p scale and \p shift for RNN data tensors.
 *  For performance reasons, low precision configuration of RNN primitive
 *  expects input activations to have unsigned int8 data type. Scale and shift
 *  used to quantize floating point data to unsigned integer must be passed to
 *  RNN primitive using attributes.
 *  Example usage:
 * <pre>{@code
 *      // rnn parameters
 *      int l = 2, t = 2, mb = 32, sic = 32, slc = 32, dic = 32, dlc = 32;
 *      // activations quantization parameters
 *      float scale = ..., shift = ..;
 *
 *      mkldnn_primitive_attr_t rnn_attr;
 *      // create default attributes
 *      mkldnn_primitive_attr_create(&rnn_attr);
 *
 *      // set scale and shift for int8 quantization of activation
 *      mkldnn_primitive_attr_set_rnn_data_qparams(rnn_attr, scale, shift);
 *
 *      // create & configure rnn op_desc
 *      mkldnn_rnn_desc_t rnn_d;
 *      mkldnn_primitive_desc_t rnn_pd;
 *      mkldnn_primitive_desc_create_v2(&rnn_pd, &rnn_d, attr, NULL);
 * }</pre>
 * \note
 *      Quantization scale and shift are common for src_layer, src_iter,
 *      dst_iter and dst_layer.
 */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_set_rnn_data_qparams(
        mkldnn_primitive_attr attr, float scale, float shift);

/** Sets quantization scales \p weights_scales for RNN weights tensors.
 * Low precision configuration of RNN primitive expects input weights to have
 * signed int8 data type. Scales used to quantize floating point data
 * to signed integer must be passed to RNN primitive using attributes.
 * The \p mask argument defines correspondence between output tensor dimensions
 * and the \p weights_scales array. Set i-th bit of \p mask to 1 to use
 * dedicated scaling factor for each slice of the output tensor over i-th
 * dimension. Set \p mask to 0 to use common scaling factor for the whole output
 * tensor. Example usage:
 * <pre>{@code
 *      // rnn parameters
 *      int l = 2, t = 2, mb = 32, sic = 32, slc = 32, dic = 32, dlc = 32;
 *      // unique output scales per output channel
 *      float weights_scales[dic * n_gates] = { ... };
 *      // mask that specifies last two dimensions of ldigo format
 *      int mask = 0x3;
 *
 *      mkldnn_primitive_attr_t attr;
 *      // create default attributes
 *      mkldnn_primitive_attr_create(&attr);
 *
 *      // set output channel-wise weights scales
 *      mkldnn_primitive_attr_set_rnn_weights_qparams(attr, dic * n_gates, mask,
 *              weights_scales);
 *
 *      // create & configure rnn op_desc
 *      mkldnn_rnn_desc_t rnn_d;
 *      mkldnn_primitive_desc_t rnn_pd;
 *      mkldnn_primitive_desc_create_v2(&rnn_pd, &rnn_d, attr, NULL);
 * }</pre>
 * \note
 *      The dimension order is always native and does not depend on the actual
 *      layout used. For example, 5 dimensional weights always have
 *      (l, d, i, g, o) logical dimension ordering.
 * \note
 *      Quantization sales are common for weights_layer and weights_iteration
 * \note
 *      There is no way to check that \p count corresponds to \p mask until an
 *      actual primitive descriptor is created, so it is user's responsibility
 *      to set proper values. The following formula must be held:
 *
 *      <pre>{@code \[count = \prod\limits_{d \in mask} output.dims[d]\]}</pre>
 */
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_set_rnn_weights_qparams(
        mkldnn_primitive_attr attr, int count, int mask,
                @Const FloatPointer weights_scales);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_set_rnn_weights_qparams(
        mkldnn_primitive_attr attr, int count, int mask,
                @Const FloatBuffer weights_scales);
public static native @Cast("mkldnn_status_t") int mkldnn_primitive_attr_set_rnn_weights_qparams(
        mkldnn_primitive_attr attr, int count, int mask,
                @Const float[] weights_scales);

/** Initializes a rnn descriptor \p rnn_desc for forward propagation
 * using \p prop_kind, \p rnn_cell_desc, \p direction, and memory descriptors.
 * \note If \p prop_kind equals #mkldnn_forward_training, you must query a
 * workspace memory descriptor before creating the primitive.
 *
 * \p src_iter_desc, \p bias_desc, and \p dst_iter_desc are allowed to either be
 * \c NULL or point to a zero memory descriptor, which would indicate that the
 * RNN primitive should not use them.
 *
 * \note All memory descriptors except \p src_iter_desc are allowed to be
 * initialized with #mkldnn_any value of \p format_kind.
 *
 * Order of inputs:
 *  - src_layer (#mkldnn_query_src_pd, 0)
 *  - src_iter (#mkldnn_query_src_pd, 1), if used
 *  - weights_layer (#mkldnn_query_weights_pd, 0)
 *  - weights_iter (#mkldnn_query_weights_pd, 1)
 *  - bias (#mkldnn_query_weights_pd, 2), if used
 *
 * Order of outputs:
 *  - dst_layer (#mkldnn_query_dst_pd, 0)
 *  - dst_iter (#mkldnn_query_dst_pd, 1), if used
 *  - workspace (#mkldnn_query_workspace_pd, 0),
 *      if \p prop_kind equals #mkldnn_forward_training
 */
public static native @Cast("mkldnn_status_t") int mkldnn_rnn_forward_desc_init(
        mkldnn_rnn_desc_t rnn_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Const mkldnn_rnn_cell_desc_t rnn_cell_desc,
        @Cast("const mkldnn_rnn_direction_t") int direction,
        @Const mkldnn_memory_desc_t src_layer_desc,
        @Const mkldnn_memory_desc_t src_iter_desc,
        @Const mkldnn_memory_desc_t weights_layer_desc,
        @Const mkldnn_memory_desc_t weights_iter_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_layer_desc,
        @Const mkldnn_memory_desc_t dst_iter_desc);

/** Initializes a rnn descriptor \p rnn_desc for backward propagation
 * using \p prop_kind, \p rnn_cell_desc, \p direction, and memory descriptors.
 * \note All memory descriptors are allowed to be initialized with
 * #mkldnn_any value of \p format_kind.
 *
 * \p src_iter_desc (simultaneously with \p diff_src_iter_desc),
 * \p bias_desc (simultaneously with \p diff_bias_desc), and
 * \p dst_iter_desc (simultaneously with \p diff_src_iter_desc) are allowed to
 * either be \c NULL or point to a zero memory descriptor, which would indicate
 * that the RNN primitive should not use them.
 *
 * Order of inputs:
 *  - src_layer (#mkldnn_query_src_pd, 0)
 *  - src_iter (#mkldnn_query_src_pd, 1), if used
 *  - weights_layer (#mkldnn_query_weights_pd, 0)
 *  - weights_iter (#mkldnn_query_weights_pd, 1)
 *  - bias (#mkldnn_query_weights_pd, 2), if used
 *  - dst_layer (#mkldnn_query_dst_pd, 0)
 *  - dst_iter (#mkldnn_query_dst_pd, 1), if used
 *  - diff_dst_layer (#mkldnn_query_diff_dst_pd, 0)
 *  - diff_dst_iter (#mkldnn_query_diff_dst_pd, 1), if used
 *  - workspace (#mkldnn_query_workspace_pd, 0)
 *
 * Order of outputs:
 *  - diff_src_layer (#mkldnn_query_diff_src_pd, 0)
 *  - diff_src_iter (#mkldnn_query_diff_src_pd, 1), if used
 *  - diff_weights_layer (#mkldnn_query_diff_weights_pd, 0)
 *  - diff_weights_iter (#mkldnn_query_diff_weights_pd, 1)
 *  - diff_bias (#mkldnn_query_diff_weights_pd, 2), if used
 */
public static native @Cast("mkldnn_status_t") int mkldnn_rnn_backward_desc_init(
        mkldnn_rnn_desc_t rnn_desc, @Cast("mkldnn_prop_kind_t") int prop_kind,
        @Const mkldnn_rnn_cell_desc_t rnn_cell_desc,
        @Cast("const mkldnn_rnn_direction_t") int direction,
        @Const mkldnn_memory_desc_t src_layer_desc,
        @Const mkldnn_memory_desc_t src_iter_desc,
        @Const mkldnn_memory_desc_t weights_layer_desc,
        @Const mkldnn_memory_desc_t weights_iter_desc,
        @Const mkldnn_memory_desc_t bias_desc,
        @Const mkldnn_memory_desc_t dst_layer_desc,
        @Const mkldnn_memory_desc_t dst_iter_desc,
        @Const mkldnn_memory_desc_t diff_src_layer_desc,
        @Const mkldnn_memory_desc_t diff_src_iter_desc,
        @Const mkldnn_memory_desc_t diff_weights_layer_desc,
        @Const mkldnn_memory_desc_t diff_weights_iter_desc,
        @Const mkldnn_memory_desc_t diff_bias_desc,
        @Const mkldnn_memory_desc_t diff_dst_layer,
        @Const mkldnn_memory_desc_t diff_dst_iter_desc);

/** \} */

/** \} */

/** \addtogroup c_api_engine Engine operations
 * \{ */

/** Returns the number of engines of a particular \p kind. */
public static native @Cast("size_t") long mkldnn_engine_get_count(@Cast("mkldnn_engine_kind_t") int kind);

/** Creates an \p engine of particular \p kind and \p index. */
public static native @Cast("mkldnn_status_t") int mkldnn_engine_create(@ByPtrPtr mkldnn_engine engine,
        @Cast("mkldnn_engine_kind_t") int kind, @Cast("size_t") long index);
public static native @Cast("mkldnn_status_t") int mkldnn_engine_create(@Cast("mkldnn_engine_t*") PointerPointer engine,
        @Cast("mkldnn_engine_kind_t") int kind, @Cast("size_t") long index);

/** Returns the kind of an \p engine. */
public static native @Cast("mkldnn_status_t") int mkldnn_engine_get_kind(mkldnn_engine engine,
        @Cast("mkldnn_engine_kind_t*") IntPointer kind);
public static native @Cast("mkldnn_status_t") int mkldnn_engine_get_kind(mkldnn_engine engine,
        @Cast("mkldnn_engine_kind_t*") IntBuffer kind);
public static native @Cast("mkldnn_status_t") int mkldnn_engine_get_kind(mkldnn_engine engine,
        @Cast("mkldnn_engine_kind_t*") int[] kind);

/** Destroys an \p engine. */
public static native @Cast("mkldnn_status_t") int mkldnn_engine_destroy(mkldnn_engine engine);

/** \} */

/** \addtogroup c_api_stream Execution stream operations
 * \{ */

/** Creates an execution \p stream of \p stream_kind. */
public static native @Cast("mkldnn_status_t") int mkldnn_stream_create(@ByPtrPtr mkldnn_stream stream,
        @Cast("mkldnn_stream_kind_t") int stream_kind);
public static native @Cast("mkldnn_status_t") int mkldnn_stream_create(@Cast("mkldnn_stream_t*") PointerPointer stream,
        @Cast("mkldnn_stream_kind_t") int stream_kind);

/** Submits \p primitives to an execution \p stream. The number of primitives
 * is \p n.  All or none of the primitives can be lazy. In case of an error,
 * returns the offending \p error_primitive if it is not \c NULL. */
public static native @Cast("mkldnn_status_t") int mkldnn_stream_submit(mkldnn_stream stream,
        @Cast("size_t") long n, @ByPtrPtr mkldnn_primitive primitives,
        @ByPtrPtr mkldnn_primitive error_primitive);
public static native @Cast("mkldnn_status_t") int mkldnn_stream_submit(mkldnn_stream stream,
        @Cast("size_t") long n, @Cast("mkldnn_primitive_t*") PointerPointer primitives,
        @Cast("mkldnn_primitive_t*") PointerPointer error_primitive);

/** Waits for all primitives in the execution \p stream to finish. Returns
 * immediately if \p block is zero. In case of an error, returns
 * the offending \p error_primitive if it is not \c NULL. */
public static native @Cast("mkldnn_status_t") int mkldnn_stream_wait(mkldnn_stream stream,
        int block, @ByPtrPtr mkldnn_primitive error_primitive);
public static native @Cast("mkldnn_status_t") int mkldnn_stream_wait(mkldnn_stream stream,
        int block, @Cast("mkldnn_primitive_t*") PointerPointer error_primitive);

/** Reruns all the primitives within the \p stream. In case of an error,
 * returns the offending \p error_primitive if it is not \c NULL. */
public static native @Cast("mkldnn_status_t") int mkldnn_stream_rerun(mkldnn_stream stream,
        @ByPtrPtr mkldnn_primitive error_primitive);
public static native @Cast("mkldnn_status_t") int mkldnn_stream_rerun(mkldnn_stream stream,
        @Cast("mkldnn_primitive_t*") PointerPointer error_primitive);

/** Destroys an execution \p stream. */
public static native @Cast("mkldnn_status_t") int mkldnn_stream_destroy(mkldnn_stream stream);

/** \} */

/** \addtogroup c_api_service Service functions
 * \{ */

/** Sets verbosity level (print information to stdout).
 * Possible levels are:
 *  - 0 -- no verbose output (default)
 *  - 1 -- primitive information at execution
 *  - 2 -- primitive information at creation and execution
 *
 * \note
 *     Dumping information might affect performance.
 *     This setting overrides the MKLDNN_VERBOSE environment variable. */
public static native @Cast("mkldnn_status_t") int mkldnn_set_verbose(int level);

/** Sets jit dump control.
 * dump equals:
 *  - zero -- turn jit dump off (default)
 *  - non-zero -- turn jit dump on
 *
 * \note
 *     This setting overrides the MKLDNN_JIT_DUMP environment variable. */
public static native @Cast("mkldnn_status_t") int mkldnn_set_jit_dump(int dump);

/** Gets library version information.
 * Version information includes:
 *  - major -- major version number
 *  - minor -- minor version number
 *  - patch -- patch release number
 *  - hash -- git commit hash */
public static native @Const mkldnn_version_t mkldnn_version();

/** \} */

/** \addtogroup c_api_blas BLAS functions
 * A subset of Basic Linear ALgebra (BLAS) functions to perform
 * matrix-matrix multiplication.
 * \{ */

/** SGEMM performs a matrix-matrix multiplication operation defined as
 *
 * C := alpha*op( A )*op( B ) + beta*C
 *
 * where
 *  - op( X ) is one of op( X ) = X or op( X ) = X**T,
 *  - alpha and beta are scalars,
 *  - A, B and C are matrices, with op( A ) an m by k matrix, op( B ) a k by n matrix
 *    and C an m by n matrix.
 *
 * The matrices are assumed to be stored in column-major order (the elements
 * in a matrix columns are contiguous in memory).
 *
 * \note
 *      The API is different from the standard BLAS routine
 *      because it returns mkldnn_status_t for error handling.
 *      XERBLA is not supported: no error message will be printed
 *      in case of incorrect parameters. */
public static native @Cast("mkldnn_status_t") int mkldnn_sgemm(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb,
        @Const IntPointer M, @Const IntPointer N, @Const IntPointer K,
        @Const FloatPointer alpha, @Const FloatPointer A, @Const IntPointer lda,
        @Const FloatPointer B, @Const IntPointer ldb,
        @Const FloatPointer beta, FloatPointer C, @Const IntPointer ldc);
public static native @Cast("mkldnn_status_t") int mkldnn_sgemm(String transa, String transb,
        @Const IntBuffer M, @Const IntBuffer N, @Const IntBuffer K,
        @Const FloatBuffer alpha, @Const FloatBuffer A, @Const IntBuffer lda,
        @Const FloatBuffer B, @Const IntBuffer ldb,
        @Const FloatBuffer beta, FloatBuffer C, @Const IntBuffer ldc);
public static native @Cast("mkldnn_status_t") int mkldnn_sgemm(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb,
        @Const int[] M, @Const int[] N, @Const int[] K,
        @Const float[] alpha, @Const float[] A, @Const int[] lda,
        @Const float[] B, @Const int[] ldb,
        @Const float[] beta, float[] C, @Const int[] ldc);
public static native @Cast("mkldnn_status_t") int mkldnn_sgemm(String transa, String transb,
        @Const IntPointer M, @Const IntPointer N, @Const IntPointer K,
        @Const FloatPointer alpha, @Const FloatPointer A, @Const IntPointer lda,
        @Const FloatPointer B, @Const IntPointer ldb,
        @Const FloatPointer beta, FloatPointer C, @Const IntPointer ldc);
public static native @Cast("mkldnn_status_t") int mkldnn_sgemm(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb,
        @Const IntBuffer M, @Const IntBuffer N, @Const IntBuffer K,
        @Const FloatBuffer alpha, @Const FloatBuffer A, @Const IntBuffer lda,
        @Const FloatBuffer B, @Const IntBuffer ldb,
        @Const FloatBuffer beta, FloatBuffer C, @Const IntBuffer ldc);
public static native @Cast("mkldnn_status_t") int mkldnn_sgemm(String transa, String transb,
        @Const int[] M, @Const int[] N, @Const int[] K,
        @Const float[] alpha, @Const float[] A, @Const int[] lda,
        @Const float[] B, @Const int[] ldb,
        @Const float[] beta, float[] C, @Const int[] ldc);

/** gemm_s8u8s32 and gemm_s8s8s32 perform a matrix-matrix multiplication
 * operation and add the result to a scalar-matrix product. For the final
 * result, a vector is added to each row or column of the output matrix.
 * The operation is defined as:
 *
 * C := alpha*(op(A) + A_offset) * (op(B) + B_offset) + beta*C + C_offset
 *
 * where
 *  - op( X ) = X or op( X ) = X**T,
 *  - A_offset is an m-by-k matrix with every element equal to the value oa,
 *  - B_offset is an k-by-n matrix with every element equal to the value ob,
 *  - C_offset is an m-by-n matrix defined by the oc array, size len:
 *    - if offsetc = F: len must be at least 1
 *    - if offsetc = C: len must be at least max(1, m)
 *    - if offsetc = R: len must be at least max(1, n)
 *  - alpha and beta are scalars, and A, B and C are matrices, with op( A )
 *    an m-by-k matrix, op( B ) a k-by-n matrix and C an m-by-n matrix.
 *
 * The matrices are assumed to be stored in column-major order (the elements
 * in a matrix columns are contiguous in memory).
 *
 * \note
 *      The API is different compared with the standard BLAS routine
 *      because it returns mkldnn_status_t for error handling.
 *      XERBLA is not supported: no error message will be printed
 *      in case of incorrect parameters. */
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_s8u8s32(@Cast("const char*") BytePointer transa,
        @Cast("const char*") BytePointer transb, @Cast("const char*") BytePointer offsetc, @Const IntPointer M, @Const IntPointer N,
        @Const IntPointer K, @Const FloatPointer alpha, @Const BytePointer A, @Const IntPointer lda,
        @Const BytePointer ao, @Cast("const uint8_t*") BytePointer B, @Const IntPointer ldb, @Const BytePointer bo,
        @Const FloatPointer beta, IntPointer c, @Const IntPointer ldc, @Const IntPointer co);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_s8u8s32(String transa,
        String transb, String offsetc, @Const IntBuffer M, @Const IntBuffer N,
        @Const IntBuffer K, @Const FloatBuffer alpha, @Const ByteBuffer A, @Const IntBuffer lda,
        @Const ByteBuffer ao, @Cast("const uint8_t*") ByteBuffer B, @Const IntBuffer ldb, @Const ByteBuffer bo,
        @Const FloatBuffer beta, IntBuffer c, @Const IntBuffer ldc, @Const IntBuffer co);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_s8u8s32(@Cast("const char*") BytePointer transa,
        @Cast("const char*") BytePointer transb, @Cast("const char*") BytePointer offsetc, @Const int[] M, @Const int[] N,
        @Const int[] K, @Const float[] alpha, @Const byte[] A, @Const int[] lda,
        @Const byte[] ao, @Cast("const uint8_t*") byte[] B, @Const int[] ldb, @Const byte[] bo,
        @Const float[] beta, int[] c, @Const int[] ldc, @Const int[] co);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_s8u8s32(String transa,
        String transb, String offsetc, @Const IntPointer M, @Const IntPointer N,
        @Const IntPointer K, @Const FloatPointer alpha, @Const BytePointer A, @Const IntPointer lda,
        @Const BytePointer ao, @Cast("const uint8_t*") BytePointer B, @Const IntPointer ldb, @Const BytePointer bo,
        @Const FloatPointer beta, IntPointer c, @Const IntPointer ldc, @Const IntPointer co);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_s8u8s32(@Cast("const char*") BytePointer transa,
        @Cast("const char*") BytePointer transb, @Cast("const char*") BytePointer offsetc, @Const IntBuffer M, @Const IntBuffer N,
        @Const IntBuffer K, @Const FloatBuffer alpha, @Const ByteBuffer A, @Const IntBuffer lda,
        @Const ByteBuffer ao, @Cast("const uint8_t*") ByteBuffer B, @Const IntBuffer ldb, @Const ByteBuffer bo,
        @Const FloatBuffer beta, IntBuffer c, @Const IntBuffer ldc, @Const IntBuffer co);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_s8u8s32(String transa,
        String transb, String offsetc, @Const int[] M, @Const int[] N,
        @Const int[] K, @Const float[] alpha, @Const byte[] A, @Const int[] lda,
        @Const byte[] ao, @Cast("const uint8_t*") byte[] B, @Const int[] ldb, @Const byte[] bo,
        @Const float[] beta, int[] c, @Const int[] ldc, @Const int[] co);

public static native @Cast("mkldnn_status_t") int mkldnn_gemm_s8s8s32(@Cast("const char*") BytePointer transa,
        @Cast("const char*") BytePointer transb, @Cast("const char*") BytePointer offsetc, @Const IntPointer M, @Const IntPointer N,
        @Const IntPointer K, @Const FloatPointer alpha, @Const BytePointer A, @Const IntPointer lda,
        @Const BytePointer ao, @Const BytePointer B, @Const IntPointer ldb, @Const BytePointer bo,
        @Const FloatPointer beta, IntPointer c, @Const IntPointer ldc, @Const IntPointer co);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_s8s8s32(String transa,
        String transb, String offsetc, @Const IntBuffer M, @Const IntBuffer N,
        @Const IntBuffer K, @Const FloatBuffer alpha, @Const ByteBuffer A, @Const IntBuffer lda,
        @Const ByteBuffer ao, @Const ByteBuffer B, @Const IntBuffer ldb, @Const ByteBuffer bo,
        @Const FloatBuffer beta, IntBuffer c, @Const IntBuffer ldc, @Const IntBuffer co);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_s8s8s32(@Cast("const char*") BytePointer transa,
        @Cast("const char*") BytePointer transb, @Cast("const char*") BytePointer offsetc, @Const int[] M, @Const int[] N,
        @Const int[] K, @Const float[] alpha, @Const byte[] A, @Const int[] lda,
        @Const byte[] ao, @Const byte[] B, @Const int[] ldb, @Const byte[] bo,
        @Const float[] beta, int[] c, @Const int[] ldc, @Const int[] co);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_s8s8s32(String transa,
        String transb, String offsetc, @Const IntPointer M, @Const IntPointer N,
        @Const IntPointer K, @Const FloatPointer alpha, @Const BytePointer A, @Const IntPointer lda,
        @Const BytePointer ao, @Const BytePointer B, @Const IntPointer ldb, @Const BytePointer bo,
        @Const FloatPointer beta, IntPointer c, @Const IntPointer ldc, @Const IntPointer co);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_s8s8s32(@Cast("const char*") BytePointer transa,
        @Cast("const char*") BytePointer transb, @Cast("const char*") BytePointer offsetc, @Const IntBuffer M, @Const IntBuffer N,
        @Const IntBuffer K, @Const FloatBuffer alpha, @Const ByteBuffer A, @Const IntBuffer lda,
        @Const ByteBuffer ao, @Const ByteBuffer B, @Const IntBuffer ldb, @Const ByteBuffer bo,
        @Const FloatBuffer beta, IntBuffer c, @Const IntBuffer ldc, @Const IntBuffer co);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_s8s8s32(String transa,
        String transb, String offsetc, @Const int[] M, @Const int[] N,
        @Const int[] K, @Const float[] alpha, @Const byte[] A, @Const int[] lda,
        @Const byte[] ao, @Const byte[] B, @Const int[] ldb, @Const byte[] bo,
        @Const float[] beta, int[] c, @Const int[] ldc, @Const int[] co);

/** gemm_bf16bf16f32 performs a matrix-matrix multiplication operation defined
 * as
 *
 * C := alpha*op( A )*op( B ) + beta*C
 *
 * where
 *  - op( X ) is one of op( X ) = X or op( X ) = X**T,
 *  - alpha and beta are scalars,
 *  - A, B and C are matrices, with op( A ) an m by k matrix, op( B ) a k by n
 *    matrix and C an m by n matrix.
 *
 * The matrices are assumed to be stored in column-major order (the elements
 * in a matrix columns are contiguous in memory).
 *
 * \note
 *      The API is different from the standard BLAS routine
 *      because it returns mkldnn_status_t for error handling.
 *      XERBLA is not supported: no error message will be printed
 *      in case of incorrect parameters. */
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_bf16bf16f32(@Cast("const char*") BytePointer transa,
        @Cast("const char*") BytePointer transb, @Const IntPointer M, @Const IntPointer N, @Const IntPointer K,
        @Const FloatPointer alpha, @Cast("const mkldnn_bfloat16_t*") ShortPointer A, @Const IntPointer lda,
        @Cast("const mkldnn_bfloat16_t*") ShortPointer B, @Const IntPointer ldb, @Const FloatPointer beta,
        FloatPointer c, @Const IntPointer ldc);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_bf16bf16f32(String transa,
        String transb, @Const IntBuffer M, @Const IntBuffer N, @Const IntBuffer K,
        @Const FloatBuffer alpha, @Cast("const mkldnn_bfloat16_t*") ShortBuffer A, @Const IntBuffer lda,
        @Cast("const mkldnn_bfloat16_t*") ShortBuffer B, @Const IntBuffer ldb, @Const FloatBuffer beta,
        FloatBuffer c, @Const IntBuffer ldc);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_bf16bf16f32(@Cast("const char*") BytePointer transa,
        @Cast("const char*") BytePointer transb, @Const int[] M, @Const int[] N, @Const int[] K,
        @Const float[] alpha, @Cast("const mkldnn_bfloat16_t*") short[] A, @Const int[] lda,
        @Cast("const mkldnn_bfloat16_t*") short[] B, @Const int[] ldb, @Const float[] beta,
        float[] c, @Const int[] ldc);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_bf16bf16f32(String transa,
        String transb, @Const IntPointer M, @Const IntPointer N, @Const IntPointer K,
        @Const FloatPointer alpha, @Cast("const mkldnn_bfloat16_t*") ShortPointer A, @Const IntPointer lda,
        @Cast("const mkldnn_bfloat16_t*") ShortPointer B, @Const IntPointer ldb, @Const FloatPointer beta,
        FloatPointer c, @Const IntPointer ldc);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_bf16bf16f32(@Cast("const char*") BytePointer transa,
        @Cast("const char*") BytePointer transb, @Const IntBuffer M, @Const IntBuffer N, @Const IntBuffer K,
        @Const FloatBuffer alpha, @Cast("const mkldnn_bfloat16_t*") ShortBuffer A, @Const IntBuffer lda,
        @Cast("const mkldnn_bfloat16_t*") ShortBuffer B, @Const IntBuffer ldb, @Const FloatBuffer beta,
        FloatBuffer c, @Const IntBuffer ldc);
public static native @Cast("mkldnn_status_t") int mkldnn_gemm_bf16bf16f32(String transa,
        String transb, @Const int[] M, @Const int[] N, @Const int[] K,
        @Const float[] alpha, @Cast("const mkldnn_bfloat16_t*") short[] A, @Const int[] lda,
        @Cast("const mkldnn_bfloat16_t*") short[] B, @Const int[] ldb, @Const float[] beta,
        float[] c, @Const int[] ldc);

/** \} */

/** \} */

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from mkldnn.hpp

/*******************************************************************************
* Copyright 2016-2018 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

// #ifndef MKLDNN_HPP
// #define MKLDNN_HPP

// #ifndef DOXYGEN_SHOULD_SKIP_THIS
// #endif

/** \addtogroup cpp_api C++ API
 *  \{
 <p>
 *  \addtogroup cpp_api_utils Utils
 *  \{
 <p>
 *  A class that provides the destructor for an Intel(R) MKL-DNN C handle */
// Targeting ../mkldnn_engine_handle.java


// Targeting ../mkldnn_primitive_desc_handle.java


// Targeting ../mkldnn_primitive_attr_handle.java


// Targeting ../mkldnn_post_ops_handle.java


// Targeting ../mkldnn_primitive_handle.java


// Targeting ../mkldnn_stream_handle.java


// Targeting ../primitive.java




///
@Namespace("mkldnn") public static native @Cast("mkldnn_primitive_kind_t") int convert_to_c(@Cast("mkldnn::primitive::kind") int akind);
// Targeting ../error.java






/** \}
 <p>
 *  \addtogroup cpp_api_enums Common data types and enumerations
 *  A proxy to \ref c_api_types in \ref c_api.
 * 
 *  \{ */

/** enum mkldnn::round_mode */
public static final int
    round_nearest = mkldnn_round_nearest,
    round_down = mkldnn_round_down;

/** enum mkldnn::padding_kind */
public static final int
    zero = mkldnn_padding_zero;

/** enum mkldnn::prop_kind */
public static final int
    forward_training = mkldnn_forward_training,
    forward_scoring = mkldnn_forward_scoring,
    forward_inference = mkldnn_forward_inference,
    forward = mkldnn_forward,
    backward = mkldnn_backward,
    backward_data = mkldnn_backward_data,
    backward_weights = mkldnn_backward_weights,
    backward_bias = mkldnn_backward_bias;

/** enum mkldnn::algorithm */
public static final int
    algorithm_undef = mkldnn_alg_kind_undef,
    convolution_auto = mkldnn_convolution_auto,
    convolution_direct = mkldnn_convolution_direct,
    convolution_winograd = mkldnn_convolution_winograd,
    deconvolution_direct = mkldnn_deconvolution_direct,
    deconvolution_winograd = mkldnn_deconvolution_winograd,
    eltwise_relu = mkldnn_eltwise_relu,
    eltwise_tanh = mkldnn_eltwise_tanh,
    eltwise_elu = mkldnn_eltwise_elu,
    eltwise_square = mkldnn_eltwise_square,
    eltwise_abs = mkldnn_eltwise_abs,
    eltwise_sqrt = mkldnn_eltwise_sqrt,
    eltwise_linear = mkldnn_eltwise_linear,
    eltwise_bounded_relu = mkldnn_eltwise_bounded_relu,
    eltwise_soft_relu = mkldnn_eltwise_soft_relu,
    eltwise_logistic = mkldnn_eltwise_logistic,
    eltwise_exp = mkldnn_eltwise_exp,
    eltwise_gelu = mkldnn_eltwise_gelu,
    lrn_across_channels = mkldnn_lrn_across_channels,
    lrn_within_channel  = mkldnn_lrn_within_channel,
    pooling_max = mkldnn_pooling_max,
    pooling_avg = mkldnn_pooling_avg,
    pooling_avg_include_padding = mkldnn_pooling_avg_include_padding,
    pooling_avg_exclude_padding = mkldnn_pooling_avg_exclude_padding,
    vanilla_rnn = mkldnn_vanilla_rnn,
    vanilla_lstm = mkldnn_vanilla_lstm,
    vanilla_gru = mkldnn_vanilla_gru,
    gru_linear_before_reset = mkldnn_gru_linear_before_reset;

/** enum mkldnn::batch_normalization_flag */
public static final int
    use_global_stats = mkldnn_use_global_stats,
    use_scale_shift = mkldnn_use_scaleshift,
    fuse_bn_relu = mkldnn_fuse_bn_relu;

/** enum mkldnn::rnn_direction */
public static final int
    unidirectional_left2right = mkldnn_unidirectional_left2right,
    unidirectional_right2left = mkldnn_unidirectional_right2left,
    unidirectional = mkldnn_unidirectional,
    bidirectional_concat = mkldnn_bidirectional_concat,
    bidirectional_sum = mkldnn_bidirectional_sum;

/** enum mkldnn::query */
public static final int
    undef = mkldnn_query_undef,

    eengine = mkldnn_query_engine,
    primitive_kind = mkldnn_query_primitive_kind,

    num_of_inputs_s32 = mkldnn_query_num_of_inputs_s32,
    num_of_outputs_s32 = mkldnn_query_num_of_outputs_s32,

    time_estimate_f64 = mkldnn_query_time_estimate_f64,
    memory_consumption_s64 = mkldnn_query_memory_consumption_s64,

    impl_info_str = mkldnn_query_impl_info_str,

    op_d = mkldnn_query_op_d,
    memory_d = mkldnn_query_memory_d,
    convolution_d = mkldnn_query_convolution_d,
    deconvolution_d = mkldnn_query_deconvolution_d,
    shuffle_d = mkldnn_query_shuffle_d,
    eltwise_d = mkldnn_query_eltwise_d,
    softmax_d = mkldnn_query_softmax_d,
    pooling_d = mkldnn_query_pooling_d,
    lrn_d = mkldnn_query_lrn_d,
    batch_normalization_d = mkldnn_query_batch_normalization_d,
    inner_product_d = mkldnn_query_inner_product_d,
    rnn_d = mkldnn_query_rnn_d,

    input_pd = mkldnn_query_input_pd,
    output_pd = mkldnn_query_output_pd,
    src_pd = mkldnn_query_src_pd,
    diff_src_pd = mkldnn_query_diff_src_pd,
    weights_pd = mkldnn_query_weights_pd,
    diff_weights_pd = mkldnn_query_diff_weights_pd,
    dst_pd = mkldnn_query_dst_pd,
    diff_dst_pd = mkldnn_query_diff_dst_pd,
    workspace_pd = mkldnn_query_workspace_pd;
// Targeting ../post_ops.java


// Targeting ../primitive_attr.java


// Targeting ../engine.java


// Targeting ../memory.java



@Namespace("mkldnn") public static native @ByVal memory.desc zero_md();

@Namespace("mkldnn") public static native @ByVal memory null_memory(@ByVal engine eng);

@Namespace("mkldnn") public static native void check_num_parameters(@Const mkldnn_primitive_desc aprimitive_desc, int n_inputs, int n_outputs,
    @StdString BytePointer prim_name);
@Namespace("mkldnn") public static native void check_num_parameters(@Const mkldnn_primitive_desc aprimitive_desc, int n_inputs, int n_outputs,
    @StdString String prim_name);


@Namespace("mkldnn") public static native @Cast("bool") boolean is_null_memory(@Const mkldnn_primitive aprimitive);

@Namespace("mkldnn") public static native @Cast("bool") @Name("operator ==") boolean equals(@Cast("mkldnn_data_type_t") int a, @Cast("mkldnn::memory::data_type") int b);
@Namespace("mkldnn") public static native @Cast("bool") @Name("operator !=") boolean notEquals(@Cast("mkldnn_data_type_t") int a, @Cast("mkldnn::memory::data_type") int b);
// Targeting ../reorder.java


// Targeting ../view.java


// Targeting ../concat.java


// Targeting ../sum.java


// Targeting ../primitive_desc.java


// Targeting ../convolution_forward.java


// Targeting ../convolution_backward_data.java


// Targeting ../convolution_backward_weights.java


// Targeting ../deconvolution_forward.java


// Targeting ../deconvolution_backward_data.java


// Targeting ../deconvolution_backward_weights.java


// Targeting ../lrn_forward.java


// Targeting ../lrn_backward.java


// Targeting ../pooling_forward.java


// Targeting ../pooling_backward.java


// Targeting ../eltwise_forward.java


// Targeting ../eltwise_backward.java


// Targeting ../softmax_forward.java


// Targeting ../softmax_backward.java


// Targeting ../batch_normalization_forward.java


// Targeting ../batch_normalization_backward.java


// Targeting ../inner_product_forward.java


// Targeting ../inner_product_backward_data.java


// Targeting ../inner_product_backward_weights.java


// Targeting ../rnn_cell.java


// Targeting ../rnn_forward.java


// Targeting ../rnn_backward.java


// Targeting ../shuffle_forward.java


// Targeting ../shuffle_backward.java


// Targeting ../stream.java



// #undef REG_QUERY_MPD

/** \}
 <p>
 *  \} C++ API */

 // namespace mkldnn

// #endif


}
