// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.mkldnn;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.mkldnn.global.mklml.*;

import static org.bytedeco.mkldnn.global.mkldnn.*;


/** Memory descriptor. The description is based on a number of dimensions,
 * dimensions themselves, plus information about elements type and memory
 * format. Additionally, contains format-specific descriptions of the data
 * layout. */
@Properties(inherit = org.bytedeco.mkldnn.presets.mkldnn.class)
public class mkldnn_memory_desc_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mkldnn_memory_desc_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mkldnn_memory_desc_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mkldnn_memory_desc_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mkldnn_memory_desc_t position(long position) {
        return (mkldnn_memory_desc_t)super.position(position);
    }
    @Override public mkldnn_memory_desc_t getPointer(long i) {
        return new mkldnn_memory_desc_t((Pointer)this).offsetAddress(i);
    }

    /** The kind of primitive. Used for self-identifying the primitive
     * descriptor. Must be #mkldnn_memory. */
    public native @Cast("mkldnn_primitive_kind_t") int primitive_kind(); public native mkldnn_memory_desc_t primitive_kind(int setter);
    /** Number of dimensions */
    public native int ndims(); public native mkldnn_memory_desc_t ndims(int setter);
    /** Dimensions in the following order:
     * - CNN data tensors: mini-batch, channel, spatial
     *   (<code>{N, C, [[D,] H,] W}</code>)
     * - CNN weight tensors: group (optional), output channel, input channel,
     *   spatial (<code>{[G,] O, I, [[D,] H,] W}</code>)
     * - RNN data tensors: time, mini-batch, channels (<code>{T, N, C}</code>)
     *   or layers, directions, states, mini-batch, channels (<code>{L, D, S, N, C}</code>)
     * - RNN weight tensor: layers, directions, input channel, gates, output channels
     *   (<code>{L, D, I, G, O}</code>).
     *
     * \note
     *    The order of dimensions does not depend on the memory format, so
     *    whether the data is laid out in #mkldnn_nchw or #mkldnn_nhwc
     *    the dims for 4D CN data tensor would be <code>{N, C, H, W}</code>.
     */
    @MemberGetter public native IntPointer dims();
    /** Data type of the tensor elements. */
    public native @Cast("mkldnn_data_type_t") int data_type(); public native mkldnn_memory_desc_t data_type(int setter);
    /** Memory format. */
    public native @Cast("mkldnn_memory_format_t") int format(); public native mkldnn_memory_desc_t format(int setter);
        /** Description of the data layout for memory formats that use
         * blocking. */
        @Name("layout_desc.blocking") public native @ByRef mkldnn_blocking_desc_t layout_desc_blocking(); public native mkldnn_memory_desc_t layout_desc_blocking(mkldnn_blocking_desc_t setter);
        /** Tensor of weights for integer 8bit winograd convolution. */
        @Name("layout_desc.wino_desc") public native @ByRef mkldnn_wino_desc_t layout_desc_wino_desc(); public native mkldnn_memory_desc_t layout_desc_wino_desc(mkldnn_wino_desc_t setter);
        /** Tensor of packed weights for RNN. */
        @Name("layout_desc.rnn_packed_desc") public native @ByRef mkldnn_rnn_packed_desc_t layout_desc_rnn_packed_desc(); public native mkldnn_memory_desc_t layout_desc_rnn_packed_desc(mkldnn_rnn_packed_desc_t setter);
        /* ... other descriptions possible */
}
