// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.mkldnn;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.mkldnn.global.mklml.*;

import static org.bytedeco.mkldnn.global.mkldnn.*;


/** \}
 <p>
 *  \addtogroup cpp_api_pooling Pooling
 *  A primitive to perform max or average pooling.
 * 
 *  @see \ref c_api_pooling in \ref c_api
 *  \{ */

@Namespace("mkldnn") @Properties(inherit = org.bytedeco.mkldnn.presets.mkldnn.class)
public class pooling_forward extends primitive {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public pooling_forward(Pointer p) { super(p); }

    @NoOffset public static class desc extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public desc(Pointer p) { super(p); }
    
        public native @ByRef mkldnn_pooling_desc_t data(); public native desc data(mkldnn_pooling_desc_t setter);
        public desc(@Cast("mkldnn::prop_kind") int aprop_kind, @Cast("mkldnn::algorithm") int aalgorithm,
                        @Const @ByRef memory.desc src_desc,
                        @Const @ByRef memory.desc dst_desc,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntPointer strides,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntPointer kernel,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntPointer padding_l,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntPointer padding_r,
                        @Cast("const mkldnn::padding_kind") int apadding_kind) { super((Pointer)null); allocate(aprop_kind, aalgorithm, src_desc, dst_desc, strides, kernel, padding_l, padding_r, apadding_kind); }
        private native void allocate(@Cast("mkldnn::prop_kind") int aprop_kind, @Cast("mkldnn::algorithm") int aalgorithm,
                        @Const @ByRef memory.desc src_desc,
                        @Const @ByRef memory.desc dst_desc,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntPointer strides,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntPointer kernel,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntPointer padding_l,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntPointer padding_r,
                        @Cast("const mkldnn::padding_kind") int apadding_kind);
        public desc(@Cast("mkldnn::prop_kind") int aprop_kind, @Cast("mkldnn::algorithm") int aalgorithm,
                        @Const @ByRef memory.desc src_desc,
                        @Const @ByRef memory.desc dst_desc,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntBuffer strides,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntBuffer kernel,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntBuffer padding_l,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntBuffer padding_r,
                        @Cast("const mkldnn::padding_kind") int apadding_kind) { super((Pointer)null); allocate(aprop_kind, aalgorithm, src_desc, dst_desc, strides, kernel, padding_l, padding_r, apadding_kind); }
        private native void allocate(@Cast("mkldnn::prop_kind") int aprop_kind, @Cast("mkldnn::algorithm") int aalgorithm,
                        @Const @ByRef memory.desc src_desc,
                        @Const @ByRef memory.desc dst_desc,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntBuffer strides,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntBuffer kernel,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntBuffer padding_l,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal IntBuffer padding_r,
                        @Cast("const mkldnn::padding_kind") int apadding_kind);
        public desc(@Cast("mkldnn::prop_kind") int aprop_kind, @Cast("mkldnn::algorithm") int aalgorithm,
                        @Const @ByRef memory.desc src_desc,
                        @Const @ByRef memory.desc dst_desc,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal int[] strides,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal int[] kernel,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal int[] padding_l,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal int[] padding_r,
                        @Cast("const mkldnn::padding_kind") int apadding_kind) { super((Pointer)null); allocate(aprop_kind, aalgorithm, src_desc, dst_desc, strides, kernel, padding_l, padding_r, apadding_kind); }
        private native void allocate(@Cast("mkldnn::prop_kind") int aprop_kind, @Cast("mkldnn::algorithm") int aalgorithm,
                        @Const @ByRef memory.desc src_desc,
                        @Const @ByRef memory.desc dst_desc,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal int[] strides,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal int[] kernel,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal int[] padding_l,
                        @Const @StdVector("std::remove_extent<mkldnn_dims_t>::type") @ByVal int[] padding_r,
                        @Cast("const mkldnn::padding_kind") int apadding_kind);
    }

    public static class primitive_desc extends org.bytedeco.mkldnn.primitive_desc {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public primitive_desc(Pointer p) { super(p); }
    
        public primitive_desc(@Const @ByRef desc desc, @Const @ByRef engine e) { super((Pointer)null); allocate(desc, e); }
        private native void allocate(@Const @ByRef desc desc, @Const @ByRef engine e);

        public primitive_desc(@Const @ByRef desc desc, @Const @ByRef primitive_attr attr, @Const @ByRef engine e) { super((Pointer)null); allocate(desc, attr, e); }
        private native void allocate(@Const @ByRef desc desc, @Const @ByRef primitive_attr attr, @Const @ByRef engine e);

        public native @ByVal memory.primitive_desc src_primitive_desc();
        public native @ByVal memory.primitive_desc dst_primitive_desc();
        public native @ByVal memory.primitive_desc workspace_primitive_desc();
    }

    public pooling_forward(@Const @ByRef primitive_desc aprimitive_desc, @Const @ByRef primitive.at src,
                @Const @ByRef memory dst) { super((Pointer)null); allocate(aprimitive_desc, src, dst); }
    private native void allocate(@Const @ByRef primitive_desc aprimitive_desc, @Const @ByRef primitive.at src,
                @Const @ByRef memory dst);

    public pooling_forward(@Const @ByRef primitive_desc aprimitive_desc, @Const @ByRef primitive.at src,
                @Const @ByRef memory dst, @Const @ByRef memory workspace) { super((Pointer)null); allocate(aprimitive_desc, src, dst, workspace); }
    private native void allocate(@Const @ByRef primitive_desc aprimitive_desc, @Const @ByRef primitive.at src,
                @Const @ByRef memory dst, @Const @ByRef memory workspace);
}
