/*******************************************************************************
* Copyright 1999-2020 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!      Intel(R) Math Kernel Library (Intel(R) MKL) stdcall interface for LAPACK routines
!******************************************************************************/

#ifndef _MKL_LAPACK_STDCALL_H_
#define _MKL_LAPACK_STDCALL_H_

#include "mkl_types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#if defined(MKL_STDCALL)

#ifndef MKL_STDCALL_WARNING
#define MKL_STDCALL_WARNING
#warning stdcall has been deprecated
#endif

void __stdcall CGESVDQ( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex8* cwork, MKL_INT* lcwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void __stdcall CGESVDQ_( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex8* cwork, MKL_INT* lcwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void __stdcall cgesvdq( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex8* cwork, MKL_INT* lcwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void __stdcall cgesvdq_( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex8* cwork, MKL_INT* lcwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall DGESVDQ( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, double* work, MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void __stdcall DGESVDQ_( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, double* work, MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void __stdcall dgesvdq( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, double* work, MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void __stdcall dgesvdq_( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, double* work, MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall SGESVDQ( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* s, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, float* work, MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void __stdcall SGESVDQ_( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* s, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, float* work, MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void __stdcall sgesvdq( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* s, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, float* work, MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void __stdcall sgesvdq_( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* s, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, float* work, MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall ZGESVDQ( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex16* cwork, MKL_INT* lcwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void __stdcall ZGESVDQ_( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex16* cwork, MKL_INT* lcwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void __stdcall zgesvdq( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex16* cwork, MKL_INT* lcwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void __stdcall zgesvdq_( const char* joba, int joba_len, const char* jobp, int jobp_len, const char* jobr, int jobr_len, const char* jobu, int jobu_len, const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex16* cwork, MKL_INT* lcwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall CLAUNHR_COL_GETRFNP2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );
void __stdcall CLAUNHR_COL_GETRFNP2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );
void __stdcall claunhr_col_getrfnp2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );
void __stdcall claunhr_col_getrfnp2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );

void __stdcall CLAUNHR_COL_GETRFNP( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );
void __stdcall CLAUNHR_COL_GETRFNP_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );
void __stdcall claunhr_col_getrfnp( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );
void __stdcall claunhr_col_getrfnp_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );

void __stdcall DLAORHR_COL_GETRFNP2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );
void __stdcall DLAORHR_COL_GETRFNP2_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );
void __stdcall dlaorhr_col_getrfnp2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );
void __stdcall dlaorhr_col_getrfnp2_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );

void __stdcall DLAORHR_COL_GETRFNP( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );
void __stdcall DLAORHR_COL_GETRFNP_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );
void __stdcall dlaorhr_col_getrfnp( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );
void __stdcall dlaorhr_col_getrfnp_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );

void __stdcall SLAORHR_COL_GETRFNP2( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );
void __stdcall SLAORHR_COL_GETRFNP2_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );
void __stdcall slaorhr_col_getrfnp2( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );
void __stdcall slaorhr_col_getrfnp2_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );

void __stdcall SLAORHR_COL_GETRFNP( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );
void __stdcall SLAORHR_COL_GETRFNP_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );
void __stdcall slaorhr_col_getrfnp( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );
void __stdcall slaorhr_col_getrfnp_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );

void __stdcall ZLAUNHR_COL_GETRFNP2( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );
void __stdcall ZLAUNHR_COL_GETRFNP2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );
void __stdcall zlaunhr_col_getrfnp2( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );
void __stdcall zlaunhr_col_getrfnp2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );

void __stdcall ZLAUNHR_COL_GETRFNP( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );
void __stdcall ZLAUNHR_COL_GETRFNP_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );
void __stdcall zlaunhr_col_getrfnp( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );
void __stdcall zlaunhr_col_getrfnp_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );

void __stdcall CUNGTSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall CUNGTSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cungtsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cungtsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall CUNHR_COL( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* d, MKL_INT* info );
void __stdcall CUNHR_COL_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* d, MKL_INT* info );
void __stdcall cunhr_col( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* d, MKL_INT* info );
void __stdcall cunhr_col_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* d, MKL_INT* info );

void __stdcall DORGTSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, double* a, const MKL_INT* lda, const double* t, const MKL_INT* ldt, double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DORGTSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, double* a, const MKL_INT* lda, const double* t, const MKL_INT* ldt, double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorgtsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, double* a, const MKL_INT* lda, const double* t, const MKL_INT* ldt, double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorgtsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, double* a, const MKL_INT* lda, const double* t, const MKL_INT* ldt, double* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall DORHR_COL( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* lda, double* t, const MKL_INT* ldt, double* d, MKL_INT* info );
void __stdcall DORHR_COL_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* lda, double* t, const MKL_INT* ldt, double* d, MKL_INT* info );
void __stdcall dorhr_col( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* lda, double* t, const MKL_INT* ldt, double* d, MKL_INT* info );
void __stdcall dorhr_col_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* lda, double* t, const MKL_INT* ldt, double* d, MKL_INT* info );

void __stdcall SORGTSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t, const MKL_INT* ldt, float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SORGTSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t, const MKL_INT* ldt, float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorgtsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t, const MKL_INT* ldt, float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorgtsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t, const MKL_INT* ldt, float* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SORHR_COL( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* lda, float* t, const MKL_INT* ldt, float* d, MKL_INT* info );
void __stdcall SORHR_COL_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* lda, float* t, const MKL_INT* ldt, float* d, MKL_INT* info );
void __stdcall sorhr_col( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* lda, float* t, const MKL_INT* ldt, float* d, MKL_INT* info );
void __stdcall sorhr_col_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* lda, float* t, const MKL_INT* ldt, float* d, MKL_INT* info );

void __stdcall ZUNGTSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZUNGTSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall zungtsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall zungtsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZUNHR_COL( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* d, MKL_INT* info );
void __stdcall ZUNHR_COL_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* d, MKL_INT* info );
void __stdcall zunhr_col( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* d, MKL_INT* info );
void __stdcall zunhr_col_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* d, MKL_INT* info );

void __stdcall CGELQ( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                      const MKL_INT* lda, MKL_Complex8* t,
                      const MKL_INT* tsize, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGELQ_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* t,
                       const MKL_INT* tsize, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgelq( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                      const MKL_INT* lda, MKL_Complex8* t,
                      const MKL_INT* tsize, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgelq_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* t,
                       const MKL_INT* tsize, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );

void __stdcall CGELQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
                       const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void __stdcall CGELQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void __stdcall cgelqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
                       const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void __stdcall cgelqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );

void __stdcall CGELQT3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall CGELQT3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_INT* info );
void __stdcall cgelqt3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall cgelqt3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_INT* info );

void __stdcall CGEMLQ( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* lda,
                       const MKL_Complex8* t, const MKL_INT* tsize,
                       MKL_Complex8* c, const MKL_INT* ldc,
                       MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall CGEMLQ_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* t, const MKL_INT* tsize,
                        MKL_Complex8* c, const MKL_INT* ldc,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall cgemlq( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* lda,
                       const MKL_Complex8* t, const MKL_INT* tsize,
                       MKL_Complex8* c, const MKL_INT* ldc,
                       MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall cgemlq_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* t, const MKL_INT* tsize,
                        MKL_Complex8* c, const MKL_INT* ldc,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );

void __stdcall CGEMLQT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* mb,
                        const MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* c, const MKL_INT* ldc,
                        MKL_Complex8* work, MKL_INT* info );
void __stdcall CGEMLQT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_Complex8* v, const MKL_INT* ldv,
                         const MKL_Complex8* t, const MKL_INT* ldt,
                         MKL_Complex8* c, const MKL_INT* ldc,
                         MKL_Complex8* work, MKL_INT* info );
void __stdcall cgemlqt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* mb,
                        const MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* c, const MKL_INT* ldc,
                        MKL_Complex8* work, MKL_INT* info );
void __stdcall cgemlqt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_Complex8* v, const MKL_INT* ldv,
                         const MKL_Complex8* t, const MKL_INT* ldt,
                         MKL_Complex8* c, const MKL_INT* ldc,
                         MKL_Complex8* work, MKL_INT* info );

void __stdcall CGEQR( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                      const MKL_INT* lda, MKL_Complex8* t,
                      const MKL_INT* tsize, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGEQR_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* t,
                       const MKL_INT* tsize, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgeqr( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                      const MKL_INT* lda, MKL_Complex8* t,
                      const MKL_INT* tsize, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgeqr_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* t,
                       const MKL_INT* tsize, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );

void __stdcall CGETSLS( const char* trans, int trans_len, const MKL_INT* m,
                        const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGETSLS_( const char* trans, int trans_len, const MKL_INT* m,
                         const MKL_INT* n, const MKL_INT* nrhs,
                         MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgetsls( const char* trans, int trans_len, const MKL_INT* m,
                        const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgetsls_( const char* trans, int trans_len, const MKL_INT* m,
                         const MKL_INT* n, const MKL_INT* nrhs,
                         MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall CLAMSWLQ( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_Complex8* c,
                         const MKL_INT* ldc, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall CLAMSWLQ_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_Complex8* t,
                          const MKL_INT* ldt, MKL_Complex8* c,
                          const MKL_INT* ldc, MKL_Complex8* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall clamswlq( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_Complex8* c,
                         const MKL_INT* ldc, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall clamswlq_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_Complex8* t,
                          const MKL_INT* ldt, MKL_Complex8* c,
                          const MKL_INT* ldc, MKL_Complex8* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall CLAMTSQR( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_Complex8* c,
                         const MKL_INT* ldc, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall CLAMTSQR_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_Complex8* t,
                          const MKL_INT* ldt, MKL_Complex8* c,
                          const MKL_INT* ldc, MKL_Complex8* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall clamtsqr( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_Complex8* c,
                         const MKL_INT* ldc, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall clamtsqr_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_Complex8* t,
                          const MKL_INT* ldt, MKL_Complex8* c,
                          const MKL_INT* ldc, MKL_Complex8* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall CLASWLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall CLASWLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall claswlq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall claswlq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall CLATSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall CLATSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall clatsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall clatsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall CTPLQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                       const MKL_INT* mb, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* t,
                       const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void __stdcall CTPLQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        const MKL_INT* mb, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void __stdcall ctplqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                       const MKL_INT* mb, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* t,
                       const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void __stdcall ctplqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        const MKL_INT* mb, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );

void __stdcall CTPLQT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall CTPLQT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_INT* info );
void __stdcall ctplqt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall ctplqt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_INT* info );

void __stdcall CTPMLQT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                        const MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info );
void __stdcall CTPMLQT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                         const MKL_Complex8* v, const MKL_INT* ldv,
                         const MKL_Complex8* t, const MKL_INT* ldt,
                         MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* work,
                         MKL_INT* info );
void __stdcall ctpmlqt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                        const MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info );
void __stdcall ctpmlqt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                         const MKL_Complex8* v, const MKL_INT* ldv,
                         const MKL_Complex8* t, const MKL_INT* ldt,
                         MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* work,
                         MKL_INT* info );

void __stdcall DGELQ( const MKL_INT* m, const MKL_INT* n, double* a,
                      const MKL_INT* lda, double* t, const MKL_INT* tsize,
                      double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DGELQ_( const MKL_INT* m, const MKL_INT* n, double* a,
                       const MKL_INT* lda, double* t,
                       const MKL_INT* tsize, double* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall dgelq( const MKL_INT* m, const MKL_INT* n, double* a,
                      const MKL_INT* lda, double* t, const MKL_INT* tsize,
                      double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dgelq_( const MKL_INT* m, const MKL_INT* n, double* a,
                       const MKL_INT* lda, double* t,
                       const MKL_INT* tsize, double* work,
                       const MKL_INT* lwork, MKL_INT* info );

void __stdcall DGELQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                       double* a, const MKL_INT* lda, double* t,
                       const MKL_INT* ldt, double* work, MKL_INT* info );
void __stdcall DGELQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        double* a, const MKL_INT* lda, double* t,
                        const MKL_INT* ldt, double* work, MKL_INT* info );
void __stdcall dgelqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                       double* a, const MKL_INT* lda, double* t,
                       const MKL_INT* ldt, double* work, MKL_INT* info );
void __stdcall dgelqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        double* a, const MKL_INT* lda, double* t,
                        const MKL_INT* ldt, double* work, MKL_INT* info );

void __stdcall DGELQT3( const MKL_INT* m, const MKL_INT* n, double* a,
                        const MKL_INT* lda, double* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall DGELQT3_( const MKL_INT* m, const MKL_INT* n, double* a,
                         const MKL_INT* lda, double* t, const MKL_INT* ldt,
                         MKL_INT* info );
void __stdcall dgelqt3( const MKL_INT* m, const MKL_INT* n, double* a,
                        const MKL_INT* lda, double* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall dgelqt3_( const MKL_INT* m, const MKL_INT* n, double* a,
                         const MKL_INT* lda, double* t, const MKL_INT* ldt,
                         MKL_INT* info );

void __stdcall DGEMLQ( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const double* a, const MKL_INT* lda,
                       const double* t, const MKL_INT* tsize, double* c,
                       const MKL_INT* ldc, double* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall DGEMLQ_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const double* a, const MKL_INT* lda,
                        const double* t, const MKL_INT* tsize, double* c,
                        const MKL_INT* ldc, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall dgemlq( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const double* a, const MKL_INT* lda,
                       const double* t, const MKL_INT* tsize, double* c,
                       const MKL_INT* ldc, double* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall dgemlq_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const double* a, const MKL_INT* lda,
                        const double* t, const MKL_INT* tsize, double* c,
                        const MKL_INT* ldc, double* work,
                        const MKL_INT* lwork, MKL_INT* info );

void __stdcall DGEMLQT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* mb, const double* v,
                        const MKL_INT* ldv, const double* t,
                        const MKL_INT* ldt, double* c, const MKL_INT* ldc,
                        double* work, MKL_INT* info );
void __stdcall DGEMLQT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb, const double* v,
                         const MKL_INT* ldv, const double* t,
                         const MKL_INT* ldt, double* c, const MKL_INT* ldc,
                         double* work, MKL_INT* info );
void __stdcall dgemlqt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* mb, const double* v,
                        const MKL_INT* ldv, const double* t,
                        const MKL_INT* ldt, double* c, const MKL_INT* ldc,
                        double* work, MKL_INT* info );
void __stdcall dgemlqt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb, const double* v,
                         const MKL_INT* ldv, const double* t,
                         const MKL_INT* ldt, double* c, const MKL_INT* ldc,
                         double* work, MKL_INT* info );

void __stdcall DGEQR( const MKL_INT* m, const MKL_INT* n, double* a,
                      const MKL_INT* lda, double* t, const MKL_INT* tsize,
                      double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DGEQR_( const MKL_INT* m, const MKL_INT* n, double* a,
                       const MKL_INT* lda, double* t,
                       const MKL_INT* tsize, double* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall dgeqr( const MKL_INT* m, const MKL_INT* n, double* a,
                      const MKL_INT* lda, double* t, const MKL_INT* tsize,
                      double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dgeqr_( const MKL_INT* m, const MKL_INT* n, double* a,
                       const MKL_INT* lda, double* t,
                       const MKL_INT* tsize, double* work,
                       const MKL_INT* lwork, MKL_INT* info );

void __stdcall DLAMSWLQ( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, double* a, const MKL_INT* lda,
                         const double* t, const MKL_INT* ldt, double* c,
                         const MKL_INT* ldc, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall DLAMSWLQ_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, double* a, const MKL_INT* lda,
                          const double* t, const MKL_INT* ldt, double* c,
                          const MKL_INT* ldc, double* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall dlamswlq( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, double* a, const MKL_INT* lda,
                         const double* t, const MKL_INT* ldt, double* c,
                         const MKL_INT* ldc, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall dlamswlq_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, double* a, const MKL_INT* lda,
                          const double* t, const MKL_INT* ldt, double* c,
                          const MKL_INT* ldc, double* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall DLAMTSQR( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, double* a, const MKL_INT* lda,
                         const double* t, const MKL_INT* ldt, double* c,
                         const MKL_INT* ldc, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall DLAMTSQR_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, double* a, const MKL_INT* lda,
                          const double* t, const MKL_INT* ldt, double* c,
                          const MKL_INT* ldc, double* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall dlamtsqr( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, double* a, const MKL_INT* lda,
                         const double* t, const MKL_INT* ldt, double* c,
                         const MKL_INT* ldc, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall dlamtsqr_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, double* a, const MKL_INT* lda,
                          const double* t, const MKL_INT* ldt, double* c,
                          const MKL_INT* ldc, double* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall DLASWLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, double* a, const MKL_INT* lda,
                        double* t, const MKL_INT* ldt, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall DLASWLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, double* a, const MKL_INT* lda,
                         double* t, const MKL_INT* ldt, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall dlaswlq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, double* a, const MKL_INT* lda,
                        double* t, const MKL_INT* ldt, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall dlaswlq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, double* a, const MKL_INT* lda,
                         double* t, const MKL_INT* ldt, double* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall DLATSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, double* a, const MKL_INT* lda,
                        double* t, const MKL_INT* ldt, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall DLATSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, double* a, const MKL_INT* lda,
                         double* t, const MKL_INT* ldt, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall dlatsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, double* a, const MKL_INT* lda,
                        double* t, const MKL_INT* ldt, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall dlatsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, double* a, const MKL_INT* lda,
                         double* t, const MKL_INT* ldt, double* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall DTPLQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                       const MKL_INT* mb, double* a, const MKL_INT* lda,
                       double* b, const MKL_INT* ldb, double* t,
                       const MKL_INT* ldt, double* work, MKL_INT* info );
void __stdcall DTPLQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        const MKL_INT* mb, double* a, const MKL_INT* lda,
                        double* b, const MKL_INT* ldb, double* t,
                        const MKL_INT* ldt, double* work, MKL_INT* info );
void __stdcall dtplqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                       const MKL_INT* mb, double* a, const MKL_INT* lda,
                       double* b, const MKL_INT* ldb, double* t,
                       const MKL_INT* ldt, double* work, MKL_INT* info );
void __stdcall dtplqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        const MKL_INT* mb, double* a, const MKL_INT* lda,
                        double* b, const MKL_INT* ldb, double* t,
                        const MKL_INT* ldt, double* work, MKL_INT* info );

void __stdcall DTPLQT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        double* a, const MKL_INT* lda, double* b,
                        const MKL_INT* ldb, double* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall DTPLQT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         double* a, const MKL_INT* lda, double* b,
                         const MKL_INT* ldb, double* t, const MKL_INT* ldt,
                         MKL_INT* info );
void __stdcall dtplqt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        double* a, const MKL_INT* lda, double* b,
                        const MKL_INT* ldb, double* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall dtplqt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         double* a, const MKL_INT* lda, double* b,
                         const MKL_INT* ldb, double* t, const MKL_INT* ldt,
                         MKL_INT* info );

void __stdcall DTPMLQT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                        const double* v, const MKL_INT* ldv, const double* t,
                        const MKL_INT* ldt, double* a, const MKL_INT* lda,
                        double* b, const MKL_INT* ldb, double* work,
                        MKL_INT* info );
void __stdcall DTPMLQT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                         const double* v, const MKL_INT* ldv, const double* t,
                         const MKL_INT* ldt, double* a, const MKL_INT* lda,
                         double* b, const MKL_INT* ldb, double* work,
                         MKL_INT* info );
void __stdcall dtpmlqt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                        const double* v, const MKL_INT* ldv, const double* t,
                        const MKL_INT* ldt, double* a, const MKL_INT* lda,
                        double* b, const MKL_INT* ldb, double* work,
                        MKL_INT* info );
void __stdcall dtpmlqt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                         const double* v, const MKL_INT* ldv, const double* t,
                         const MKL_INT* ldt, double* a, const MKL_INT* lda,
                         double* b, const MKL_INT* ldb, double* work,
                         MKL_INT* info );

void __stdcall SGELQ( const MKL_INT* m, const MKL_INT* n, float* a,
                      const MKL_INT* lda, float* t, const MKL_INT* tsize,
                      float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SGELQ_( const MKL_INT* m, const MKL_INT* n, float* a,
                       const MKL_INT* lda, float* t, const MKL_INT* tsize,
                       float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sgelq( const MKL_INT* m, const MKL_INT* n, float* a,
                      const MKL_INT* lda, float* t, const MKL_INT* tsize,
                      float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sgelq_( const MKL_INT* m, const MKL_INT* n, float* a,
                       const MKL_INT* lda, float* t, const MKL_INT* tsize,
                       float* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall DGETSLS( const char* trans, int trans_len, const MKL_INT* m,
                        const MKL_INT* n, const MKL_INT* nrhs, double* a,
                        const MKL_INT* lda, double* b, const MKL_INT* ldb,
                        double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DGETSLS_( const char* trans, int trans_len, const MKL_INT* m,
                         const MKL_INT* n, const MKL_INT* nrhs, double* a,
                         const MKL_INT* lda, double* b, const MKL_INT* ldb,
                         double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dgetsls( const char* trans, int trans_len, const MKL_INT* m,
                        const MKL_INT* n, const MKL_INT* nrhs, double* a,
                        const MKL_INT* lda, double* b, const MKL_INT* ldb,
                        double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dgetsls_( const char* trans, int trans_len, const MKL_INT* m,
                         const MKL_INT* n, const MKL_INT* nrhs, double* a,
                         const MKL_INT* lda, double* b, const MKL_INT* ldb,
                         double* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SGELQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                       float* a, const MKL_INT* lda, float* t,
                       const MKL_INT* ldt, float* work, MKL_INT* info );
void __stdcall SGELQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        float* a, const MKL_INT* lda, float* t,
                        const MKL_INT* ldt, float* work, MKL_INT* info );
void __stdcall sgelqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                       float* a, const MKL_INT* lda, float* t,
                       const MKL_INT* ldt, float* work, MKL_INT* info );
void __stdcall sgelqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        float* a, const MKL_INT* lda, float* t,
                        const MKL_INT* ldt, float* work, MKL_INT* info );

void __stdcall SGELQT3( const MKL_INT* m, const MKL_INT* n, float* a,
                        const MKL_INT* lda, float* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall SGELQT3_( const MKL_INT* m, const MKL_INT* n, float* a,
                         const MKL_INT* lda, float* t, const MKL_INT* ldt,
                         MKL_INT* info );
void __stdcall sgelqt3( const MKL_INT* m, const MKL_INT* n, float* a,
                        const MKL_INT* lda, float* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall sgelqt3_( const MKL_INT* m, const MKL_INT* n, float* a,
                         const MKL_INT* lda, float* t, const MKL_INT* ldt,
                         MKL_INT* info );

void __stdcall SGEMLQT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* mb, const float* v,
                        const MKL_INT* ldv, const float* t, const MKL_INT* ldt,
                        float* c, const MKL_INT* ldc, float* work,
                        MKL_INT* info );
void __stdcall SGEMLQT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb, const float* v,
                         const MKL_INT* ldv, const float* t,
                         const MKL_INT* ldt, float* c, const MKL_INT* ldc,
                         float* work, MKL_INT* info );
void __stdcall sgemlqt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* mb, const float* v,
                        const MKL_INT* ldv, const float* t, const MKL_INT* ldt,
                        float* c, const MKL_INT* ldc, float* work,
                        MKL_INT* info );
void __stdcall sgemlqt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb, const float* v,
                         const MKL_INT* ldv, const float* t,
                         const MKL_INT* ldt, float* c, const MKL_INT* ldc,
                         float* work, MKL_INT* info );

void __stdcall SGEQR( const MKL_INT* m, const MKL_INT* n, float* a,
                      const MKL_INT* lda, float* t, const MKL_INT* tsize,
                      float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SGEQR_( const MKL_INT* m, const MKL_INT* n, float* a,
                       const MKL_INT* lda, float* t, const MKL_INT* tsize,
                       float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sgeqr( const MKL_INT* m, const MKL_INT* n, float* a,
                      const MKL_INT* lda, float* t, const MKL_INT* tsize,
                      float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sgeqr_( const MKL_INT* m, const MKL_INT* n, float* a,
                       const MKL_INT* lda, float* t, const MKL_INT* tsize,
                       float* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SGETSLS( const char* trans, int trans_len, const MKL_INT* m,
                        const MKL_INT* n, const MKL_INT* nrhs, float* a,
                        const MKL_INT* lda, float* b, const MKL_INT* ldb,
                        float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SGETSLS_( const char* trans, int trans_len, const MKL_INT* m,
                         const MKL_INT* n, const MKL_INT* nrhs, float* a,
                         const MKL_INT* lda, float* b, const MKL_INT* ldb,
                         float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sgetsls( const char* trans, int trans_len, const MKL_INT* m,
                        const MKL_INT* n, const MKL_INT* nrhs, float* a,
                        const MKL_INT* lda, float* b, const MKL_INT* ldb,
                        float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sgetsls_( const char* trans, int trans_len, const MKL_INT* m,
                         const MKL_INT* n, const MKL_INT* nrhs, float* a,
                         const MKL_INT* lda, float* b, const MKL_INT* ldb,
                         float* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SLAMTSQR( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, float* a, const MKL_INT* lda,
                         const float* t, const MKL_INT* ldt, float* c,
                         const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall SLAMTSQR_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, float* a, const MKL_INT* lda,
                          const float* t, const MKL_INT* ldt, float* c,
                          const MKL_INT* ldc, float* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall slamtsqr( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, float* a, const MKL_INT* lda,
                         const float* t, const MKL_INT* ldt, float* c,
                         const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall slamtsqr_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, float* a, const MKL_INT* lda,
                          const float* t, const MKL_INT* ldt, float* c,
                          const MKL_INT* ldc, float* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall SLASWLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, float* a, const MKL_INT* lda,
                        float* t, const MKL_INT* ldt, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall SLASWLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, float* a, const MKL_INT* lda,
                         float* t, const MKL_INT* ldt, float* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall slaswlq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, float* a, const MKL_INT* lda,
                        float* t, const MKL_INT* ldt, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall slaswlq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, float* a, const MKL_INT* lda,
                         float* t, const MKL_INT* ldt, float* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall STPLQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                       const MKL_INT* mb, float* a, const MKL_INT* lda,
                       float* b, const MKL_INT* ldb, float* t,
                       const MKL_INT* ldt, float* work, MKL_INT* info );
void __stdcall STPLQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        const MKL_INT* mb, float* a, const MKL_INT* lda,
                        float* b, const MKL_INT* ldb, float* t,
                        const MKL_INT* ldt, float* work, MKL_INT* info );
void __stdcall stplqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                       const MKL_INT* mb, float* a, const MKL_INT* lda,
                       float* b, const MKL_INT* ldb, float* t,
                       const MKL_INT* ldt, float* work, MKL_INT* info );
void __stdcall stplqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        const MKL_INT* mb, float* a, const MKL_INT* lda,
                        float* b, const MKL_INT* ldb, float* t,
                        const MKL_INT* ldt, float* work, MKL_INT* info );

void __stdcall STPMLQT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                        const float* v, const MKL_INT* ldv, const float* t,
                        const MKL_INT* ldt, float* a, const MKL_INT* lda,
                        float* b, const MKL_INT* ldb, float* work,
                        MKL_INT* info );
void __stdcall STPMLQT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                         const float* v, const MKL_INT* ldv, const float* t,
                         const MKL_INT* ldt, float* a, const MKL_INT* lda,
                         float* b, const MKL_INT* ldb, float* work,
                         MKL_INT* info );
void __stdcall stpmlqt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                        const float* v, const MKL_INT* ldv, const float* t,
                        const MKL_INT* ldt, float* a, const MKL_INT* lda,
                        float* b, const MKL_INT* ldb, float* work,
                        MKL_INT* info );
void __stdcall stpmlqt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                         const float* v, const MKL_INT* ldv, const float* t,
                         const MKL_INT* ldt, float* a, const MKL_INT* lda,
                         float* b, const MKL_INT* ldb, float* work,
                         MKL_INT* info );

void __stdcall ZGELQ( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                      const MKL_INT* lda, MKL_Complex16* t,
                      const MKL_INT* tsize, MKL_Complex16* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZGELQ_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                       const MKL_INT* lda, MKL_Complex16* t,
                       const MKL_INT* tsize, MKL_Complex16* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall zgelq( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                      const MKL_INT* lda, MKL_Complex16* t,
                      const MKL_INT* tsize, MKL_Complex16* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall zgelq_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                       const MKL_INT* lda, MKL_Complex16* t,
                       const MKL_INT* tsize, MKL_Complex16* work,
                       const MKL_INT* lwork, MKL_INT* info );

void __stdcall SGEMLQ( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const float* a, const MKL_INT* lda,
                       const float* t, const MKL_INT* tsize, float* c,
                       const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall SGEMLQ_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const float* a, const MKL_INT* lda,
                        const float* t, const MKL_INT* tsize, float* c,
                        const MKL_INT* ldc, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall sgemlq( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const float* a, const MKL_INT* lda,
                       const float* t, const MKL_INT* tsize, float* c,
                       const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall sgemlq_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const float* a, const MKL_INT* lda,
                        const float* t, const MKL_INT* tsize, float* c,
                        const MKL_INT* ldc, float* work,
                        const MKL_INT* lwork, MKL_INT* info );

void __stdcall SLAMSWLQ( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, float* a, const MKL_INT* lda,
                         const float* t, const MKL_INT* ldt, float* c,
                         const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall SLAMSWLQ_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, float* a, const MKL_INT* lda,
                          const float* t, const MKL_INT* ldt, float* c,
                          const MKL_INT* ldc, float* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall slamswlq( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, float* a, const MKL_INT* lda,
                         const float* t, const MKL_INT* ldt, float* c,
                         const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall slamswlq_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, float* a, const MKL_INT* lda,
                          const float* t, const MKL_INT* ldt, float* c,
                          const MKL_INT* ldc, float* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall SLATSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, float* a, const MKL_INT* lda,
                        float* t, const MKL_INT* ldt, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall SLATSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, float* a, const MKL_INT* lda,
                         float* t, const MKL_INT* ldt, float* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall slatsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, float* a, const MKL_INT* lda,
                        float* t, const MKL_INT* ldt, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall slatsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, float* a, const MKL_INT* lda,
                         float* t, const MKL_INT* ldt, float* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall STPLQT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        float* a, const MKL_INT* lda, float* b,
                        const MKL_INT* ldb, float* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall STPLQT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         float* a, const MKL_INT* lda, float* b,
                         const MKL_INT* ldb, float* t, const MKL_INT* ldt,
                         MKL_INT* info );
void __stdcall stplqt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        float* a, const MKL_INT* lda, float* b,
                        const MKL_INT* ldb, float* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall stplqt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         float* a, const MKL_INT* lda, float* b,
                         const MKL_INT* ldb, float* t, const MKL_INT* ldt,
                         MKL_INT* info );

void __stdcall ZGELQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
                       const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );
void __stdcall ZGELQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_Complex16* work,
                        MKL_INT* info );
void __stdcall zgelqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
                       const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );
void __stdcall zgelqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_Complex16* work,
                        MKL_INT* info );

void __stdcall ZGELQT3( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall ZGELQT3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_INT* info );
void __stdcall zgelqt3( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall zgelqt3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_INT* info );

void __stdcall ZGEMLQ( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* lda,
                       const MKL_Complex16* t, const MKL_INT* tsize,
                       MKL_Complex16* c, const MKL_INT* ldc,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall ZGEMLQ_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* lda,
                        const MKL_Complex16* t, const MKL_INT* tsize,
                        MKL_Complex16* c, const MKL_INT* ldc,
                        MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall zgemlq( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* lda,
                       const MKL_Complex16* t, const MKL_INT* tsize,
                       MKL_Complex16* c, const MKL_INT* ldc,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall zgemlq_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* lda,
                        const MKL_Complex16* t, const MKL_INT* tsize,
                        MKL_Complex16* c, const MKL_INT* ldc,
                        MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );

void __stdcall ZGEMLQT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* mb,
                        const MKL_Complex16* v, const MKL_INT* ldv,
                        const MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* c, const MKL_INT* ldc,
                        MKL_Complex16* work, MKL_INT* info );
void __stdcall ZGEMLQT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_Complex16* v, const MKL_INT* ldv,
                         const MKL_Complex16* t, const MKL_INT* ldt,
                         MKL_Complex16* c, const MKL_INT* ldc,
                         MKL_Complex16* work, MKL_INT* info );
void __stdcall zgemlqt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* mb,
                        const MKL_Complex16* v, const MKL_INT* ldv,
                        const MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* c, const MKL_INT* ldc,
                        MKL_Complex16* work, MKL_INT* info );
void __stdcall zgemlqt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_Complex16* v, const MKL_INT* ldv,
                         const MKL_Complex16* t, const MKL_INT* ldt,
                         MKL_Complex16* c, const MKL_INT* ldc,
                         MKL_Complex16* work, MKL_INT* info );

void __stdcall ZGEQR( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                      const MKL_INT* lda, MKL_Complex16* t,
                      const MKL_INT* tsize, MKL_Complex16* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZGEQR_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                       const MKL_INT* lda, MKL_Complex16* t,
                       const MKL_INT* tsize, MKL_Complex16* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall zgeqr( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                      const MKL_INT* lda, MKL_Complex16* t,
                      const MKL_INT* tsize, MKL_Complex16* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall zgeqr_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                       const MKL_INT* lda, MKL_Complex16* t,
                       const MKL_INT* tsize, MKL_Complex16* work,
                       const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZGETSLS( const char* trans, int trans_len, const MKL_INT* m,
                        const MKL_INT* n, const MKL_INT* nrhs,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZGETSLS_( const char* trans, int trans_len, const MKL_INT* m,
                         const MKL_INT* n, const MKL_INT* nrhs,
                         MKL_Complex16* a, const MKL_INT* lda,
                         MKL_Complex16* b, const MKL_INT* ldb,
                         MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall zgetsls( const char* trans, int trans_len, const MKL_INT* m,
                        const MKL_INT* n, const MKL_INT* nrhs,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall zgetsls_( const char* trans, int trans_len, const MKL_INT* m,
                         const MKL_INT* n, const MKL_INT* nrhs,
                         MKL_Complex16* a, const MKL_INT* lda,
                         MKL_Complex16* b, const MKL_INT* ldb,
                         MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );

void __stdcall ZLAMSWLQ( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_Complex16* c,
                         const MKL_INT* ldc, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZLAMSWLQ_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_Complex16* t,
                          const MKL_INT* ldt, MKL_Complex16* c,
                          const MKL_INT* ldc, MKL_Complex16* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall zlamswlq( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_Complex16* c,
                         const MKL_INT* ldc, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall zlamswlq_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_Complex16* t,
                          const MKL_INT* ldt, MKL_Complex16* c,
                          const MKL_INT* ldc, MKL_Complex16* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZLAMTSQR( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_Complex16* c,
                         const MKL_INT* ldc, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZLAMTSQR_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_Complex16* t,
                          const MKL_INT* ldt, MKL_Complex16* c,
                          const MKL_INT* ldc, MKL_Complex16* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall zlamtsqr( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_Complex16* c,
                         const MKL_INT* ldc, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall zlamtsqr_( const char* side, int side_len, const char* trans,
                          int trans_len, const MKL_INT* m, const MKL_INT* n,
                          const MKL_INT* k, const MKL_INT* mb,
                          const MKL_INT* nb, MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_Complex16* t,
                          const MKL_INT* ldt, MKL_Complex16* c,
                          const MKL_INT* ldc, MKL_Complex16* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZLASWLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZLASWLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall zlaswlq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall zlaswlq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZLATSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZLATSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall zlatsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                        const MKL_INT* nb, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall zlatsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
                         const MKL_INT* nb, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZTPLQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                       const MKL_INT* mb, MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* t,
                       const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );
void __stdcall ZTPLQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        const MKL_INT* mb, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_Complex16* work,
                        MKL_INT* info );
void __stdcall ztplqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                       const MKL_INT* mb, MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* t,
                       const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );
void __stdcall ztplqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        const MKL_INT* mb, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_Complex16* work,
                        MKL_INT* info );

void __stdcall ZTPLQT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall ZTPLQT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         MKL_Complex16* a, const MKL_INT* lda,
                         MKL_Complex16* b, const MKL_INT* ldb,
                         MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );
void __stdcall ztplqt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall ztplqt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         MKL_Complex16* a, const MKL_INT* lda,
                         MKL_Complex16* b, const MKL_INT* ldb,
                         MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );

void __stdcall ZTPMLQT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                        const MKL_Complex16* v, const MKL_INT* ldv,
                        const MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_Complex16* work,
                        MKL_INT* info );
void __stdcall ZTPMLQT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                         const MKL_Complex16* v, const MKL_INT* ldv,
                         const MKL_Complex16* t, const MKL_INT* ldt,
                         MKL_Complex16* a, const MKL_INT* lda,
                         MKL_Complex16* b, const MKL_INT* ldb,
                         MKL_Complex16* work, MKL_INT* info );
void __stdcall ztpmlqt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                        const MKL_Complex16* v, const MKL_INT* ldv,
                        const MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_Complex16* work,
                        MKL_INT* info );
void __stdcall ztpmlqt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l, const MKL_INT* mb,
                         const MKL_Complex16* v, const MKL_INT* ldv,
                         const MKL_Complex16* t, const MKL_INT* ldt,
                         MKL_Complex16* a, const MKL_INT* lda,
                         MKL_Complex16* b, const MKL_INT* ldb,
                         MKL_Complex16* work, MKL_INT* info );

void __stdcall CHESV_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall CHESV_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
                          const MKL_INT* ldb, MKL_Complex8* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall chesv_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall chesv_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
                          const MKL_INT* ldb, MKL_Complex8* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall CHETRF_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                          MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall CHETRF_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex8* work, const MKL_INT* lwork,
                           MKL_INT* info );
void __stdcall chetrf_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                          MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall chetrf_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex8* work, const MKL_INT* lwork,
                           MKL_INT* info );

void __stdcall CHETRS_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_INT* ipiv,
                          MKL_Complex8* b, const MKL_INT* ldb,
                          const MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall CHETRS_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nrhs, const MKL_Complex8* a,
                           const MKL_INT* lda, const MKL_INT* ipiv,
                           MKL_Complex8* b, const MKL_INT* ldb,
                           const MKL_Complex8* work, const MKL_INT* lwork,
                           MKL_INT* info );
void __stdcall chetrs_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_INT* ipiv,
                          MKL_Complex8* b, const MKL_INT* ldb,
                          const MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall chetrs_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nrhs, const MKL_Complex8* a,
                           const MKL_INT* lda, const MKL_INT* ipiv,
                           MKL_Complex8* b, const MKL_INT* ldb,
                           const MKL_Complex8* work, const MKL_INT* lwork,
                           MKL_INT* info );

void __stdcall CLAHEF_AA( const char* uplo, int uplo_len, const MKL_INT* j1,
                          const MKL_INT* m, const MKL_INT* nb, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* h,
                          const MKL_INT* ldh, MKL_Complex8* work );
void __stdcall CLAHEF_AA_( const char* uplo, int uplo_len, const MKL_INT* j1,
                           const MKL_INT* m, const MKL_INT* nb,
                           MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex8* h, const MKL_INT* ldh,
                           MKL_Complex8* work );
void __stdcall clahef_aa( const char* uplo, int uplo_len, const MKL_INT* j1,
                          const MKL_INT* m, const MKL_INT* nb, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* h,
                          const MKL_INT* ldh, MKL_Complex8* work );
void __stdcall clahef_aa_( const char* uplo, int uplo_len, const MKL_INT* j1,
                           const MKL_INT* m, const MKL_INT* nb,
                           MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex8* h, const MKL_INT* ldh,
                           MKL_Complex8* work );

void __stdcall DLASYF_AA( const char* uplo, int uplo_len, const MKL_INT* j1,
                          const MKL_INT* m, const MKL_INT* nb, double* a,
                          const MKL_INT* lda, MKL_INT* ipiv, double* h,
                          const MKL_INT* ldh, double* work );
void __stdcall DLASYF_AA_( const char* uplo, int uplo_len, const MKL_INT* j1,
                           const MKL_INT* m, const MKL_INT* nb, double* a,
                           const MKL_INT* lda, MKL_INT* ipiv, double* h,
                           const MKL_INT* ldh, double* work );
void __stdcall dlasyf_aa( const char* uplo, int uplo_len, const MKL_INT* j1,
                          const MKL_INT* m, const MKL_INT* nb, double* a,
                          const MKL_INT* lda, MKL_INT* ipiv, double* h,
                          const MKL_INT* ldh, double* work );
void __stdcall dlasyf_aa_( const char* uplo, int uplo_len, const MKL_INT* j1,
                           const MKL_INT* m, const MKL_INT* nb, double* a,
                           const MKL_INT* lda, MKL_INT* ipiv, double* h,
                           const MKL_INT* ldh, double* work );

void __stdcall DSYSV_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, double* a, const MKL_INT* lda,
                         MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                         double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DSYSV_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, double* a, const MKL_INT* lda,
                          MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                          double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsysv_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, double* a, const MKL_INT* lda,
                         MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                         double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsysv_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, double* a, const MKL_INT* lda,
                          MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                          double* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall DSYTRF_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                          double* a, const MKL_INT* lda, MKL_INT* ipiv,
                          double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DSYTRF_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                           double* a, const MKL_INT* lda, MKL_INT* ipiv,
                           double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsytrf_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                          double* a, const MKL_INT* lda, MKL_INT* ipiv,
                          double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsytrf_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                           double* a, const MKL_INT* lda, MKL_INT* ipiv,
                           double* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall DSYTRS_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const double* a,
                          const MKL_INT* lda, const MKL_INT* ipiv, double* b,
                          const MKL_INT* ldb, const double* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall DSYTRS_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nrhs, const double* a,
                           const MKL_INT* lda, const MKL_INT* ipiv, double* b,
                           const MKL_INT* ldb, const double* work,
                           const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsytrs_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const double* a,
                          const MKL_INT* lda, const MKL_INT* ipiv, double* b,
                          const MKL_INT* ldb, const double* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsytrs_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nrhs, const double* a,
                           const MKL_INT* lda, const MKL_INT* ipiv, double* b,
                           const MKL_INT* ldb, const double* work,
                           const MKL_INT* lwork, MKL_INT* info );

void __stdcall SLASYF_AA( const char* uplo, int uplo_len, const MKL_INT* j1,
                          const MKL_INT* m, const MKL_INT* nb, float* a,
                          const MKL_INT* lda, MKL_INT* ipiv, float* h,
                          const MKL_INT* ldh, float* work );
void __stdcall SLASYF_AA_( const char* uplo, int uplo_len, const MKL_INT* j1,
                           const MKL_INT* m, const MKL_INT* nb, float* a,
                           const MKL_INT* lda, MKL_INT* ipiv, float* h,
                           const MKL_INT* ldh, float* work );
void __stdcall slasyf_aa( const char* uplo, int uplo_len, const MKL_INT* j1,
                          const MKL_INT* m, const MKL_INT* nb, float* a,
                          const MKL_INT* lda, MKL_INT* ipiv, float* h,
                          const MKL_INT* ldh, float* work );
void __stdcall slasyf_aa_( const char* uplo, int uplo_len, const MKL_INT* j1,
                           const MKL_INT* m, const MKL_INT* nb, float* a,
                           const MKL_INT* lda, MKL_INT* ipiv, float* h,
                           const MKL_INT* ldh, float* work );

void __stdcall SSYSV_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, float* a, const MKL_INT* lda,
                         MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                         float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSYSV_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, float* a, const MKL_INT* lda,
                          MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                          float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssysv_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, float* a, const MKL_INT* lda,
                         MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                         float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssysv_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, float* a, const MKL_INT* lda,
                          MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                          float* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SSYTRF_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                          float* a, const MKL_INT* lda, MKL_INT* ipiv,
                          float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSYTRF_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                           float* a, const MKL_INT* lda, MKL_INT* ipiv,
                           float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytrf_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                          float* a, const MKL_INT* lda, MKL_INT* ipiv,
                          float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytrf_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                           float* a, const MKL_INT* lda, MKL_INT* ipiv,
                           float* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SSYTRS_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const float* a,
                          const MKL_INT* lda, const MKL_INT* ipiv, float* b,
                          const MKL_INT* ldb, const float* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSYTRS_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nrhs, const float* a,
                           const MKL_INT* lda, const MKL_INT* ipiv, float* b,
                           const MKL_INT* ldb, const float* work,
                           const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytrs_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const float* a,
                          const MKL_INT* lda, const MKL_INT* ipiv, float* b,
                          const MKL_INT* ldb, const float* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytrs_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nrhs, const float* a,
                           const MKL_INT* lda, const MKL_INT* ipiv, float* b,
                           const MKL_INT* ldb, const float* work,
                           const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZHESV_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* b,
                         const MKL_INT* ldb, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZHESV_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* b,
                          const MKL_INT* ldb, MKL_Complex16* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall zhesv_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* b,
                         const MKL_INT* ldb, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall zhesv_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* b,
                          const MKL_INT* ldb, MKL_Complex16* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZHETRF_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                          MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall ZHETRF_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex16* work, const MKL_INT* lwork,
                           MKL_INT* info );
void __stdcall zhetrf_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                          MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall zhetrf_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex16* work, const MKL_INT* lwork,
                           MKL_INT* info );

void __stdcall ZHETRS_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_INT* ipiv,
                          MKL_Complex16* b, const MKL_INT* ldb,
                          const MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall ZHETRS_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nrhs, const MKL_Complex16* a,
                           const MKL_INT* lda, const MKL_INT* ipiv,
                           MKL_Complex16* b, const MKL_INT* ldb,
                           const MKL_Complex16* work, const MKL_INT* lwork,
                           MKL_INT* info );
void __stdcall zhetrs_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_INT* ipiv,
                          MKL_Complex16* b, const MKL_INT* ldb,
                          const MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall zhetrs_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nrhs, const MKL_Complex16* a,
                           const MKL_INT* lda, const MKL_INT* ipiv,
                           MKL_Complex16* b, const MKL_INT* ldb,
                           const MKL_Complex16* work, const MKL_INT* lwork,
                           MKL_INT* info );

void __stdcall ZLAHEF_AA( const char* uplo, int uplo_len, const MKL_INT* j1,
                          const MKL_INT* m, const MKL_INT* nb,
                          MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                          MKL_Complex16* h, const MKL_INT* ldh,
                          MKL_Complex16* work );
void __stdcall ZLAHEF_AA_( const char* uplo, int uplo_len, const MKL_INT* j1,
                           const MKL_INT* m, const MKL_INT* nb,
                           MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex16* h, const MKL_INT* ldh,
                           MKL_Complex16* work );
void __stdcall zlahef_aa( const char* uplo, int uplo_len, const MKL_INT* j1,
                          const MKL_INT* m, const MKL_INT* nb,
                          MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                          MKL_Complex16* h, const MKL_INT* ldh,
                          MKL_Complex16* work );
void __stdcall zlahef_aa_( const char* uplo, int uplo_len, const MKL_INT* j1,
                           const MKL_INT* m, const MKL_INT* nb,
                           MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex16* h, const MKL_INT* ldh,
                           MKL_Complex16* work );

void __stdcall CGEMQR( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const MKL_Complex8* a,
                       const MKL_INT* lda, const MKL_Complex8* t,
                       const MKL_INT* tsize, MKL_Complex8* c,
                       const MKL_INT* ldc, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGEMQR_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex8* a,
                        const MKL_INT* lda, const MKL_Complex8* t,
                        const MKL_INT* tsize, MKL_Complex8* c,
                        const MKL_INT* ldc, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgemqr( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const MKL_Complex8* a,
                       const MKL_INT* lda, const MKL_Complex8* t,
                       const MKL_INT* tsize, MKL_Complex8* c,
                       const MKL_INT* ldc, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgemqr_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex8* a,
                        const MKL_INT* lda, const MKL_Complex8* t,
                        const MKL_INT* tsize, MKL_Complex8* c,
                        const MKL_INT* ldc, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );

void __stdcall DGEMQR( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const double* a, const MKL_INT* lda,
                       const double* t, const MKL_INT* tsize, double* c,
                       const MKL_INT* ldc, double* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall DGEMQR_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const double* a, const MKL_INT* lda,
                        const double* t, const MKL_INT* tsize, double* c,
                        const MKL_INT* ldc, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall dgemqr( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const double* a, const MKL_INT* lda,
                       const double* t, const MKL_INT* tsize, double* c,
                       const MKL_INT* ldc, double* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall dgemqr_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const double* a, const MKL_INT* lda,
                        const double* t, const MKL_INT* tsize, double* c,
                        const MKL_INT* ldc, double* work,
                        const MKL_INT* lwork, MKL_INT* info );

void __stdcall SGEMQR( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const float* a, const MKL_INT* lda,
                       const float* t, const MKL_INT* tsize, float* c,
                       const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall SGEMQR_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const float* a, const MKL_INT* lda,
                        const float* t, const MKL_INT* tsize, float* c,
                        const MKL_INT* ldc, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall sgemqr( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const float* a, const MKL_INT* lda,
                       const float* t, const MKL_INT* tsize, float* c,
                       const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall sgemqr_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const float* a, const MKL_INT* lda,
                        const float* t, const MKL_INT* tsize, float* c,
                        const MKL_INT* ldc, float* work,
                        const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZGEMQR( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const MKL_Complex16* a,
                       const MKL_INT* lda, const MKL_Complex16* t,
                       const MKL_INT* tsize, MKL_Complex16* c,
                       const MKL_INT* ldc, MKL_Complex16* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZGEMQR_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex16* a,
                        const MKL_INT* lda, const MKL_Complex16* t,
                        const MKL_INT* tsize, MKL_Complex16* c,
                        const MKL_INT* ldc, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall zgemqr( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const MKL_Complex16* a,
                       const MKL_INT* lda, const MKL_Complex16* t,
                       const MKL_INT* tsize, MKL_Complex16* c,
                       const MKL_INT* ldc, MKL_Complex16* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall zgemqr_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex16* a,
                        const MKL_INT* lda, const MKL_Complex16* t,
                        const MKL_INT* tsize, MKL_Complex16* c,
                        const MKL_INT* ldc, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );

void __stdcall CHECON_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* e, const MKL_INT* ipiv,
                         const float* anorm, float* rcond, MKL_Complex8* work,
                         MKL_INT* info );
void __stdcall CHECON_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_Complex8* a, const MKL_INT* lda,
                          const MKL_Complex8* e, const MKL_INT* ipiv,
                          const float* anorm, float* rcond, MKL_Complex8* work,
                          MKL_INT* info );
void __stdcall checon_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* e, const MKL_INT* ipiv,
                         const float* anorm, float* rcond, MKL_Complex8* work,
                         MKL_INT* info );
void __stdcall checon_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_Complex8* a, const MKL_INT* lda,
                          const MKL_Complex8* e, const MKL_INT* ipiv,
                          const float* anorm, float* rcond, MKL_Complex8* work,
                          MKL_INT* info );

void __stdcall CHESV_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                         MKL_Complex8* b, const MKL_INT* ldb,
                         MKL_Complex8* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall CHESV_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                          MKL_Complex8* b, const MKL_INT* ldb,
                          MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall chesv_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                         MKL_Complex8* b, const MKL_INT* ldb,
                         MKL_Complex8* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall chesv_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                          MKL_Complex8* b, const MKL_INT* ldb,
                          MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );

void __stdcall CHETF2_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                          MKL_INT* ipiv, MKL_INT* info );
void __stdcall CHETF2_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda,
                           MKL_Complex8* e, MKL_INT* ipiv, MKL_INT* info );
void __stdcall chetf2_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                          MKL_INT* ipiv, MKL_INT* info );
void __stdcall chetf2_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda,
                           MKL_Complex8* e, MKL_INT* ipiv, MKL_INT* info );

void __stdcall CHETRF_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                          MKL_INT* ipiv, MKL_Complex8* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall CHETRF_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda,
                           MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* work,
                           const MKL_INT* lwork, MKL_INT* info );
void __stdcall chetrf_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                          MKL_INT* ipiv, MKL_Complex8* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall chetrf_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda,
                           MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* work,
                           const MKL_INT* lwork, MKL_INT* info );

void __stdcall CHETRI_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* e, const MKL_INT* ipiv,
                         MKL_Complex8* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall CHETRI_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda,
                          const MKL_Complex8* e, const MKL_INT* ipiv,
                          MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall chetri_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* e, const MKL_INT* ipiv,
                         MKL_Complex8* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall chetri_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda,
                          const MKL_Complex8* e, const MKL_INT* ipiv,
                          MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );

void __stdcall CHETRI_3X( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda,
                          const MKL_Complex8* e, const MKL_INT* ipiv,
                          MKL_Complex8* work, const MKL_INT* nb,
                          MKL_INT* info );
void __stdcall CHETRI_3X_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda,
                           const MKL_Complex8* e, const MKL_INT* ipiv,
                           MKL_Complex8* work, const MKL_INT* nb,
                           MKL_INT* info );
void __stdcall chetri_3x( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda,
                          const MKL_Complex8* e, const MKL_INT* ipiv,
                          MKL_Complex8* work, const MKL_INT* nb,
                          MKL_INT* info );
void __stdcall chetri_3x_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda,
                           const MKL_Complex8* e, const MKL_INT* ipiv,
                           MKL_Complex8* work, const MKL_INT* nb,
                           MKL_INT* info );

void __stdcall CHETRS_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_Complex8* e,
                         const MKL_INT* ipiv, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_INT* info );
void __stdcall CHETRS_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_Complex8* e,
                          const MKL_INT* ipiv, MKL_Complex8* b,
                          const MKL_INT* ldb, MKL_INT* info );
void __stdcall chetrs_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_Complex8* e,
                         const MKL_INT* ipiv, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_INT* info );
void __stdcall chetrs_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_Complex8* e,
                          const MKL_INT* ipiv, MKL_Complex8* b,
                          const MKL_INT* ldb, MKL_INT* info );

void __stdcall CLAHEF_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                          MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall CLAHEF_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
                           const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                           MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall clahef_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                          MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall clahef_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
                           const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                           MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );

void __stdcall CLARFY( const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_Complex8* v, const MKL_INT* incv,
                       const MKL_Complex8* tau, MKL_Complex8* c,
                       const MKL_INT* ldc, MKL_Complex8* work );
void __stdcall CLARFY_( const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_Complex8* v, const MKL_INT* incv,
                        const MKL_Complex8* tau, MKL_Complex8* c,
                        const MKL_INT* ldc, MKL_Complex8* work );
void __stdcall clarfy( const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_Complex8* v, const MKL_INT* incv,
                       const MKL_Complex8* tau, MKL_Complex8* c,
                       const MKL_INT* ldc, MKL_Complex8* work );
void __stdcall clarfy_( const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_Complex8* v, const MKL_INT* incv,
                        const MKL_Complex8* tau, MKL_Complex8* c,
                        const MKL_INT* ldc, MKL_Complex8* work );

void __stdcall CLASYF_AA( const char* uplo, int uplo_len, const MKL_INT* j1,
                          const MKL_INT* m, const MKL_INT* nb, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* h,
                          const MKL_INT* ldh, MKL_Complex8* work );
void __stdcall CLASYF_AA_( const char* uplo, int uplo_len, const MKL_INT* j1,
                           const MKL_INT* m, const MKL_INT* nb,
                           MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex8* h, const MKL_INT* ldh,
                           MKL_Complex8* work );
void __stdcall clasyf_aa( const char* uplo, int uplo_len, const MKL_INT* j1,
                          const MKL_INT* m, const MKL_INT* nb, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* h,
                          const MKL_INT* ldh, MKL_Complex8* work );
void __stdcall clasyf_aa_( const char* uplo, int uplo_len, const MKL_INT* j1,
                           const MKL_INT* m, const MKL_INT* nb,
                           MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex8* h, const MKL_INT* ldh,
                           MKL_Complex8* work );

void __stdcall CLASYF_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                          MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall CLASYF_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
                           const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                           MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall clasyf_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                          MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall clasyf_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
                           const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                           MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );

void __stdcall CSYCON_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* e, const MKL_INT* ipiv,
                         const float* anorm, float* rcond, MKL_Complex8* work,
                         MKL_INT* info );
void __stdcall CSYCON_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_Complex8* a, const MKL_INT* lda,
                          const MKL_Complex8* e, const MKL_INT* ipiv,
                          const float* anorm, float* rcond, MKL_Complex8* work,
                          MKL_INT* info );
void __stdcall csycon_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* e, const MKL_INT* ipiv,
                         const float* anorm, float* rcond, MKL_Complex8* work,
                         MKL_INT* info );
void __stdcall csycon_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_Complex8* a, const MKL_INT* lda,
                          const MKL_Complex8* e, const MKL_INT* ipiv,
                          const float* anorm, float* rcond, MKL_Complex8* work,
                          MKL_INT* info );

void __stdcall CSYCONVF( const char* uplo, int uplo_len, const char* way,
                         int way_len, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                         MKL_INT* info );
void __stdcall CSYCONVF_( const char* uplo, int uplo_len, const char* way,
                          int way_len, const MKL_INT* n, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                          MKL_INT* info );
void __stdcall csyconvf( const char* uplo, int uplo_len, const char* way,
                         int way_len, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                         MKL_INT* info );
void __stdcall csyconvf_( const char* uplo, int uplo_len, const char* way,
                          int way_len, const MKL_INT* n, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                          MKL_INT* info );

void __stdcall CSYCONVF_ROOK( const char* uplo, int uplo_len, const char* way,
                              int way_len, const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, MKL_Complex8* e,
                              const MKL_INT* ipiv, MKL_INT* info );
void __stdcall CSYCONVF_ROOK_( const char* uplo, int uplo_len, const char* way,
                               int way_len, const MKL_INT* n, MKL_Complex8* a,
                               const MKL_INT* lda, MKL_Complex8* e,
                               const MKL_INT* ipiv, MKL_INT* info );
void __stdcall csyconvf_rook( const char* uplo, int uplo_len, const char* way,
                              int way_len, const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, MKL_Complex8* e,
                              const MKL_INT* ipiv, MKL_INT* info );
void __stdcall csyconvf_rook_( const char* uplo, int uplo_len, const char* way,
                               int way_len, const MKL_INT* n, MKL_Complex8* a,
                               const MKL_INT* lda, MKL_Complex8* e,
                               const MKL_INT* ipiv, MKL_INT* info );

void __stdcall CSYSV_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall CSYSV_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
                          const MKL_INT* ldb, MKL_Complex8* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall csysv_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall csysv_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
                          const MKL_INT* ldb, MKL_Complex8* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall CSYSV_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                         MKL_Complex8* b, const MKL_INT* ldb,
                         MKL_Complex8* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall CSYSV_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                          MKL_Complex8* b, const MKL_INT* ldb,
                          MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall csysv_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                         MKL_Complex8* b, const MKL_INT* ldb,
                         MKL_Complex8* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall csysv_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex8* a,
                          const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                          MKL_Complex8* b, const MKL_INT* ldb,
                          MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );

void __stdcall CSYTF2_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                          MKL_INT* ipiv, MKL_INT* info );
void __stdcall CSYTF2_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda,
                           MKL_Complex8* e, MKL_INT* ipiv, MKL_INT* info );
void __stdcall csytf2_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                          MKL_INT* ipiv, MKL_INT* info );
void __stdcall csytf2_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda,
                           MKL_Complex8* e, MKL_INT* ipiv, MKL_INT* info );

void __stdcall CSYTRF_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                          MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall CSYTRF_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex8* work, const MKL_INT* lwork,
                           MKL_INT* info );
void __stdcall csytrf_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                          MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall csytrf_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex8* work, const MKL_INT* lwork,
                           MKL_INT* info );

void __stdcall CSYTRF_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                          MKL_INT* ipiv, MKL_Complex8* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall CSYTRF_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda,
                           MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* work,
                           const MKL_INT* lwork, MKL_INT* info );
void __stdcall csytrf_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                          MKL_INT* ipiv, MKL_Complex8* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall csytrf_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda,
                           MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* work,
                           const MKL_INT* lwork, MKL_INT* info );

void __stdcall CSYTRI_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* e, const MKL_INT* ipiv,
                         MKL_Complex8* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall CSYTRI_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda,
                          const MKL_Complex8* e, const MKL_INT* ipiv,
                          MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall csytri_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* e, const MKL_INT* ipiv,
                         MKL_Complex8* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall csytri_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda,
                          const MKL_Complex8* e, const MKL_INT* ipiv,
                          MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );

void __stdcall CSYTRI_3X( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda,
                          const MKL_Complex8* e, const MKL_INT* ipiv,
                          MKL_Complex8* work, const MKL_INT* nb,
                          MKL_INT* info );
void __stdcall CSYTRI_3X_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda,
                           const MKL_Complex8* e, const MKL_INT* ipiv,
                           MKL_Complex8* work, const MKL_INT* nb,
                           MKL_INT* info );
void __stdcall csytri_3x( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex8* a, const MKL_INT* lda,
                          const MKL_Complex8* e, const MKL_INT* ipiv,
                          MKL_Complex8* work, const MKL_INT* nb,
                          MKL_INT* info );
void __stdcall csytri_3x_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex8* a, const MKL_INT* lda,
                           const MKL_Complex8* e, const MKL_INT* ipiv,
                           MKL_Complex8* work, const MKL_INT* nb,
                           MKL_INT* info );

void __stdcall CSYTRS_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_Complex8* e,
                         const MKL_INT* ipiv, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_INT* info );
void __stdcall CSYTRS_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_Complex8* e,
                          const MKL_INT* ipiv, MKL_Complex8* b,
                          const MKL_INT* ldb, MKL_INT* info );
void __stdcall csytrs_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_Complex8* e,
                         const MKL_INT* ipiv, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_INT* info );
void __stdcall csytrs_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_Complex8* e,
                          const MKL_INT* ipiv, MKL_Complex8* b,
                          const MKL_INT* ldb, MKL_INT* info );

void __stdcall CSYTRS_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_INT* ipiv,
                          MKL_Complex8* b, const MKL_INT* ldb,
                          const MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall CSYTRS_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nrhs, const MKL_Complex8* a,
                           const MKL_INT* lda, const MKL_INT* ipiv,
                           MKL_Complex8* b, const MKL_INT* ldb,
                           const MKL_Complex8* work, const MKL_INT* lwork,
                           MKL_INT* info );
void __stdcall csytrs_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_INT* ipiv,
                          MKL_Complex8* b, const MKL_INT* ldb,
                          const MKL_Complex8* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall csytrs_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nrhs, const MKL_Complex8* a,
                           const MKL_INT* lda, const MKL_INT* ipiv,
                           MKL_Complex8* b, const MKL_INT* ldb,
                           const MKL_Complex8* work, const MKL_INT* lwork,
                           MKL_INT* info );

void __stdcall DLARFY( const char* uplo, int uplo_len, const MKL_INT* n,
                       const double* v, const MKL_INT* incv, const double* tau,
                       double* c, const MKL_INT* ldc, double* work );
void __stdcall DLARFY_( const char* uplo, int uplo_len, const MKL_INT* n,
                        const double* v, const MKL_INT* incv,
                        const double* tau, double* c, const MKL_INT* ldc,
                        double* work );
void __stdcall dlarfy( const char* uplo, int uplo_len, const MKL_INT* n,
                       const double* v, const MKL_INT* incv, const double* tau,
                       double* c, const MKL_INT* ldc, double* work );
void __stdcall dlarfy_( const char* uplo, int uplo_len, const MKL_INT* n,
                        const double* v, const MKL_INT* incv,
                        const double* tau, double* c, const MKL_INT* ldc,
                        double* work );

void __stdcall DLASYF_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nb, MKL_INT* kb, double* a,
                          const MKL_INT* lda, double* e, MKL_INT* ipiv,
                          double* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall DLASYF_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nb, MKL_INT* kb, double* a,
                           const MKL_INT* lda, double* e, MKL_INT* ipiv,
                           double* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall dlasyf_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nb, MKL_INT* kb, double* a,
                          const MKL_INT* lda, double* e, MKL_INT* ipiv,
                          double* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall dlasyf_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nb, MKL_INT* kb, double* a,
                           const MKL_INT* lda, double* e, MKL_INT* ipiv,
                           double* w, const MKL_INT* ldw, MKL_INT* info );

void __stdcall DSYCON_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const double* a, const MKL_INT* lda, const double* e,
                         const MKL_INT* ipiv, const double* anorm,
                         double* rcond, double* work, MKL_INT* iwork,
                         MKL_INT* info );
void __stdcall DSYCON_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const double* a, const MKL_INT* lda, const double* e,
                          const MKL_INT* ipiv, const double* anorm,
                          double* rcond, double* work, MKL_INT* iwork,
                          MKL_INT* info );
void __stdcall dsycon_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const double* a, const MKL_INT* lda, const double* e,
                         const MKL_INT* ipiv, const double* anorm,
                         double* rcond, double* work, MKL_INT* iwork,
                         MKL_INT* info );
void __stdcall dsycon_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const double* a, const MKL_INT* lda, const double* e,
                          const MKL_INT* ipiv, const double* anorm,
                          double* rcond, double* work, MKL_INT* iwork,
                          MKL_INT* info );

void __stdcall DSYCONVF( const char* uplo, int uplo_len, const char* way,
                         int way_len, const MKL_INT* n, double* a,
                         const MKL_INT* lda, double* e, MKL_INT* ipiv,
                         MKL_INT* info );
void __stdcall DSYCONVF_( const char* uplo, int uplo_len, const char* way,
                          int way_len, const MKL_INT* n, double* a,
                          const MKL_INT* lda, double* e, MKL_INT* ipiv,
                          MKL_INT* info );
void __stdcall dsyconvf( const char* uplo, int uplo_len, const char* way,
                         int way_len, const MKL_INT* n, double* a,
                         const MKL_INT* lda, double* e, MKL_INT* ipiv,
                         MKL_INT* info );
void __stdcall dsyconvf_( const char* uplo, int uplo_len, const char* way,
                          int way_len, const MKL_INT* n, double* a,
                          const MKL_INT* lda, double* e, MKL_INT* ipiv,
                          MKL_INT* info );

void __stdcall DSYCONVF_ROOK( const char* uplo, int uplo_len, const char* way,
                              int way_len, const MKL_INT* n, double* a,
                              const MKL_INT* lda, double* e,
                              const MKL_INT* ipiv, MKL_INT* info );
void __stdcall DSYCONVF_ROOK_( const char* uplo, int uplo_len, const char* way,
                               int way_len, const MKL_INT* n, double* a,
                               const MKL_INT* lda, double* e,
                               const MKL_INT* ipiv, MKL_INT* info );
void __stdcall dsyconvf_rook( const char* uplo, int uplo_len, const char* way,
                              int way_len, const MKL_INT* n, double* a,
                              const MKL_INT* lda, double* e,
                              const MKL_INT* ipiv, MKL_INT* info );
void __stdcall dsyconvf_rook_( const char* uplo, int uplo_len, const char* way,
                               int way_len, const MKL_INT* n, double* a,
                               const MKL_INT* lda, double* e,
                               const MKL_INT* ipiv, MKL_INT* info );

void __stdcall DSYSV_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, double* a, const MKL_INT* lda,
                         double* e, MKL_INT* ipiv, double* b,
                         const MKL_INT* ldb, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall DSYSV_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, double* a, const MKL_INT* lda,
                          double* e, MKL_INT* ipiv, double* b,
                          const MKL_INT* ldb, double* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsysv_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, double* a, const MKL_INT* lda,
                         double* e, MKL_INT* ipiv, double* b,
                         const MKL_INT* ldb, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsysv_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, double* a, const MKL_INT* lda,
                          double* e, MKL_INT* ipiv, double* b,
                          const MKL_INT* ldb, double* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall DSYTF2_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          double* a, const MKL_INT* lda, double* e,
                          MKL_INT* ipiv, MKL_INT* info );
void __stdcall DSYTF2_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           double* a, const MKL_INT* lda, double* e,
                           MKL_INT* ipiv, MKL_INT* info );
void __stdcall dsytf2_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          double* a, const MKL_INT* lda, double* e,
                          MKL_INT* ipiv, MKL_INT* info );
void __stdcall dsytf2_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           double* a, const MKL_INT* lda, double* e,
                           MKL_INT* ipiv, MKL_INT* info );

void __stdcall DSYTRF_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          double* a, const MKL_INT* lda, double* e,
                          MKL_INT* ipiv, double* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall DSYTRF_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           double* a, const MKL_INT* lda, double* e,
                           MKL_INT* ipiv, double* work, const MKL_INT* lwork,
                           MKL_INT* info );
void __stdcall dsytrf_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          double* a, const MKL_INT* lda, double* e,
                          MKL_INT* ipiv, double* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall dsytrf_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           double* a, const MKL_INT* lda, double* e,
                           MKL_INT* ipiv, double* work, const MKL_INT* lwork,
                           MKL_INT* info );

void __stdcall DSYTRI_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         double* a, const MKL_INT* lda, const double* e,
                         const MKL_INT* ipiv, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall DSYTRI_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          double* a, const MKL_INT* lda, const double* e,
                          const MKL_INT* ipiv, double* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsytri_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         double* a, const MKL_INT* lda, const double* e,
                         const MKL_INT* ipiv, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsytri_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          double* a, const MKL_INT* lda, const double* e,
                          const MKL_INT* ipiv, double* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall DSYTRI_3X( const char* uplo, int uplo_len, const MKL_INT* n,
                          double* a, const MKL_INT* lda, const double* e,
                          const MKL_INT* ipiv, double* work, const MKL_INT* nb,
                          MKL_INT* info );
void __stdcall DSYTRI_3X_( const char* uplo, int uplo_len, const MKL_INT* n,
                           double* a, const MKL_INT* lda, const double* e,
                           const MKL_INT* ipiv, double* work,
                           const MKL_INT* nb, MKL_INT* info );
void __stdcall dsytri_3x( const char* uplo, int uplo_len, const MKL_INT* n,
                          double* a, const MKL_INT* lda, const double* e,
                          const MKL_INT* ipiv, double* work, const MKL_INT* nb,
                          MKL_INT* info );
void __stdcall dsytri_3x_( const char* uplo, int uplo_len, const MKL_INT* n,
                           double* a, const MKL_INT* lda, const double* e,
                           const MKL_INT* ipiv, double* work,
                           const MKL_INT* nb, MKL_INT* info );

void __stdcall DSYTRS_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const double* a,
                         const MKL_INT* lda, const double* e,
                         const MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                         MKL_INT* info );
void __stdcall DSYTRS_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const double* a,
                          const MKL_INT* lda, const double* e,
                          const MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                          MKL_INT* info );
void __stdcall dsytrs_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const double* a,
                         const MKL_INT* lda, const double* e,
                         const MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                         MKL_INT* info );
void __stdcall dsytrs_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const double* a,
                          const MKL_INT* lda, const double* e,
                          const MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                          MKL_INT* info );

void __stdcall SLARFY( const char* uplo, int uplo_len, const MKL_INT* n,
                       const float* v, const MKL_INT* incv, const float* tau,
                       float* c, const MKL_INT* ldc, float* work );
void __stdcall SLARFY_( const char* uplo, int uplo_len, const MKL_INT* n,
                        const float* v, const MKL_INT* incv, const float* tau,
                        float* c, const MKL_INT* ldc, float* work );
void __stdcall slarfy( const char* uplo, int uplo_len, const MKL_INT* n,
                       const float* v, const MKL_INT* incv, const float* tau,
                       float* c, const MKL_INT* ldc, float* work );
void __stdcall slarfy_( const char* uplo, int uplo_len, const MKL_INT* n,
                        const float* v, const MKL_INT* incv, const float* tau,
                        float* c, const MKL_INT* ldc, float* work );

void __stdcall SLASYF_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nb, MKL_INT* kb, float* a,
                          const MKL_INT* lda, float* e, MKL_INT* ipiv,
                          float* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall SLASYF_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nb, MKL_INT* kb, float* a,
                           const MKL_INT* lda, float* e, MKL_INT* ipiv,
                           float* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall slasyf_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nb, MKL_INT* kb, float* a,
                          const MKL_INT* lda, float* e, MKL_INT* ipiv,
                          float* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall slasyf_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nb, MKL_INT* kb, float* a,
                           const MKL_INT* lda, float* e, MKL_INT* ipiv,
                           float* w, const MKL_INT* ldw, MKL_INT* info );

void __stdcall SSYCON_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const float* a, const MKL_INT* lda, const float* e,
                         const MKL_INT* ipiv, const float* anorm, float* rcond,
                         float* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall SSYCON_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const float* a, const MKL_INT* lda, const float* e,
                          const MKL_INT* ipiv, const float* anorm,
                          float* rcond, float* work, MKL_INT* iwork,
                          MKL_INT* info );
void __stdcall ssycon_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const float* a, const MKL_INT* lda, const float* e,
                         const MKL_INT* ipiv, const float* anorm, float* rcond,
                         float* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall ssycon_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const float* a, const MKL_INT* lda, const float* e,
                          const MKL_INT* ipiv, const float* anorm,
                          float* rcond, float* work, MKL_INT* iwork,
                          MKL_INT* info );

void __stdcall SSYCONVF( const char* uplo, int uplo_len, const char* way,
                         int way_len, const MKL_INT* n, float* a,
                         const MKL_INT* lda, float* e, MKL_INT* ipiv,
                         MKL_INT* info );
void __stdcall SSYCONVF_( const char* uplo, int uplo_len, const char* way,
                          int way_len, const MKL_INT* n, float* a,
                          const MKL_INT* lda, float* e, MKL_INT* ipiv,
                          MKL_INT* info );
void __stdcall ssyconvf( const char* uplo, int uplo_len, const char* way,
                         int way_len, const MKL_INT* n, float* a,
                         const MKL_INT* lda, float* e, MKL_INT* ipiv,
                         MKL_INT* info );
void __stdcall ssyconvf_( const char* uplo, int uplo_len, const char* way,
                          int way_len, const MKL_INT* n, float* a,
                          const MKL_INT* lda, float* e, MKL_INT* ipiv,
                          MKL_INT* info );

void __stdcall SSYCONVF_ROOK( const char* uplo, int uplo_len, const char* way,
                              int way_len, const MKL_INT* n, float* a,
                              const MKL_INT* lda, float* e,
                              const MKL_INT* ipiv, MKL_INT* info );
void __stdcall SSYCONVF_ROOK_( const char* uplo, int uplo_len, const char* way,
                               int way_len, const MKL_INT* n, float* a,
                               const MKL_INT* lda, float* e,
                               const MKL_INT* ipiv, MKL_INT* info );
void __stdcall ssyconvf_rook( const char* uplo, int uplo_len, const char* way,
                              int way_len, const MKL_INT* n, float* a,
                              const MKL_INT* lda, float* e,
                              const MKL_INT* ipiv, MKL_INT* info );
void __stdcall ssyconvf_rook_( const char* uplo, int uplo_len, const char* way,
                               int way_len, const MKL_INT* n, float* a,
                               const MKL_INT* lda, float* e,
                               const MKL_INT* ipiv, MKL_INT* info );

void __stdcall SSYSV_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, float* a, const MKL_INT* lda,
                         float* e, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                         float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSYSV_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, float* a, const MKL_INT* lda,
                          float* e, MKL_INT* ipiv, float* b,
                          const MKL_INT* ldb, float* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssysv_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, float* a, const MKL_INT* lda,
                         float* e, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                         float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssysv_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, float* a, const MKL_INT* lda,
                          float* e, MKL_INT* ipiv, float* b,
                          const MKL_INT* ldb, float* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall SSYTF2_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          float* a, const MKL_INT* lda, float* e,
                          MKL_INT* ipiv, MKL_INT* info );
void __stdcall SSYTF2_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           float* a, const MKL_INT* lda, float* e,
                           MKL_INT* ipiv, MKL_INT* info );
void __stdcall ssytf2_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          float* a, const MKL_INT* lda, float* e,
                          MKL_INT* ipiv, MKL_INT* info );
void __stdcall ssytf2_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           float* a, const MKL_INT* lda, float* e,
                           MKL_INT* ipiv, MKL_INT* info );

void __stdcall SSYTRF_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          float* a, const MKL_INT* lda, float* e,
                          MKL_INT* ipiv, float* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall SSYTRF_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           float* a, const MKL_INT* lda, float* e,
                           MKL_INT* ipiv, float* work, const MKL_INT* lwork,
                           MKL_INT* info );
void __stdcall ssytrf_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          float* a, const MKL_INT* lda, float* e,
                          MKL_INT* ipiv, float* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall ssytrf_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           float* a, const MKL_INT* lda, float* e,
                           MKL_INT* ipiv, float* work, const MKL_INT* lwork,
                           MKL_INT* info );

void __stdcall SSYTRI_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         float* a, const MKL_INT* lda, const float* e,
                         const MKL_INT* ipiv, float* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSYTRI_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          float* a, const MKL_INT* lda, const float* e,
                          const MKL_INT* ipiv, float* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytri_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         float* a, const MKL_INT* lda, const float* e,
                         const MKL_INT* ipiv, float* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytri_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          float* a, const MKL_INT* lda, const float* e,
                          const MKL_INT* ipiv, float* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall SSYTRI_3X( const char* uplo, int uplo_len, const MKL_INT* n,
                          float* a, const MKL_INT* lda, const float* e,
                          const MKL_INT* ipiv, float* work, const MKL_INT* nb,
                          MKL_INT* info );
void __stdcall SSYTRI_3X_( const char* uplo, int uplo_len, const MKL_INT* n,
                           float* a, const MKL_INT* lda, const float* e,
                           const MKL_INT* ipiv, float* work, const MKL_INT* nb,
                           MKL_INT* info );
void __stdcall ssytri_3x( const char* uplo, int uplo_len, const MKL_INT* n,
                          float* a, const MKL_INT* lda, const float* e,
                          const MKL_INT* ipiv, float* work, const MKL_INT* nb,
                          MKL_INT* info );
void __stdcall ssytri_3x_( const char* uplo, int uplo_len, const MKL_INT* n,
                           float* a, const MKL_INT* lda, const float* e,
                           const MKL_INT* ipiv, float* work, const MKL_INT* nb,
                           MKL_INT* info );

void __stdcall SSYTRS_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const float* a,
                         const MKL_INT* lda, const float* e,
                         const MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                         MKL_INT* info );
void __stdcall SSYTRS_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const float* a,
                          const MKL_INT* lda, const float* e,
                          const MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                          MKL_INT* info );
void __stdcall ssytrs_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const float* a,
                         const MKL_INT* lda, const float* e,
                         const MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                         MKL_INT* info );
void __stdcall ssytrs_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const float* a,
                          const MKL_INT* lda, const float* e,
                          const MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                          MKL_INT* info );

void __stdcall ZHECON_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex16* a, const MKL_INT* lda,
                         const MKL_Complex16* e, const MKL_INT* ipiv,
                         const double* anorm, double* rcond,
                         MKL_Complex16* work, MKL_INT* info );
void __stdcall ZHECON_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_Complex16* a, const MKL_INT* lda,
                          const MKL_Complex16* e, const MKL_INT* ipiv,
                          const double* anorm, double* rcond,
                          MKL_Complex16* work, MKL_INT* info );
void __stdcall zhecon_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex16* a, const MKL_INT* lda,
                         const MKL_Complex16* e, const MKL_INT* ipiv,
                         const double* anorm, double* rcond,
                         MKL_Complex16* work, MKL_INT* info );
void __stdcall zhecon_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_Complex16* a, const MKL_INT* lda,
                          const MKL_Complex16* e, const MKL_INT* ipiv,
                          const double* anorm, double* rcond,
                          MKL_Complex16* work, MKL_INT* info );

void __stdcall ZHESV_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                         MKL_Complex16* b, const MKL_INT* ldb,
                         MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall ZHESV_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                          MKL_Complex16* b, const MKL_INT* ldb,
                          MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall zhesv_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                         MKL_Complex16* b, const MKL_INT* ldb,
                         MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall zhesv_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                          MKL_Complex16* b, const MKL_INT* ldb,
                          MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );

void __stdcall ZHETF2_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          MKL_Complex16* e, MKL_INT* ipiv, MKL_INT* info );
void __stdcall ZHETF2_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           MKL_Complex16* e, MKL_INT* ipiv, MKL_INT* info );
void __stdcall zhetf2_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          MKL_Complex16* e, MKL_INT* ipiv, MKL_INT* info );
void __stdcall zhetf2_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           MKL_Complex16* e, MKL_INT* ipiv, MKL_INT* info );

void __stdcall ZHETRF_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZHETRF_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           MKL_Complex16* e, MKL_INT* ipiv,
                           MKL_Complex16* work, const MKL_INT* lwork,
                           MKL_INT* info );
void __stdcall zhetrf_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall zhetrf_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           MKL_Complex16* e, MKL_INT* ipiv,
                           MKL_Complex16* work, const MKL_INT* lwork,
                           MKL_INT* info );

void __stdcall ZHETRI_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         MKL_Complex16* a, const MKL_INT* lda,
                         const MKL_Complex16* e, const MKL_INT* ipiv,
                         MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall ZHETRI_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          const MKL_Complex16* e, const MKL_INT* ipiv,
                          MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall zhetri_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         MKL_Complex16* a, const MKL_INT* lda,
                         const MKL_Complex16* e, const MKL_INT* ipiv,
                         MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall zhetri_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          const MKL_Complex16* e, const MKL_INT* ipiv,
                          MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );

void __stdcall ZHETRI_3X( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          const MKL_Complex16* e, const MKL_INT* ipiv,
                          MKL_Complex16* work, const MKL_INT* nb,
                          MKL_INT* info );
void __stdcall ZHETRI_3X_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           const MKL_Complex16* e, const MKL_INT* ipiv,
                           MKL_Complex16* work, const MKL_INT* nb,
                           MKL_INT* info );
void __stdcall zhetri_3x( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          const MKL_Complex16* e, const MKL_INT* ipiv,
                          MKL_Complex16* work, const MKL_INT* nb,
                          MKL_INT* info );
void __stdcall zhetri_3x_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           const MKL_Complex16* e, const MKL_INT* ipiv,
                           MKL_Complex16* work, const MKL_INT* nb,
                           MKL_INT* info );

void __stdcall ZHETRS_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_Complex16* e,
                         const MKL_INT* ipiv, MKL_Complex16* b,
                         const MKL_INT* ldb, MKL_INT* info );
void __stdcall ZHETRS_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_Complex16* e,
                          const MKL_INT* ipiv, MKL_Complex16* b,
                          const MKL_INT* ldb, MKL_INT* info );
void __stdcall zhetrs_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_Complex16* e,
                         const MKL_INT* ipiv, MKL_Complex16* b,
                         const MKL_INT* ldb, MKL_INT* info );
void __stdcall zhetrs_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_Complex16* e,
                          const MKL_INT* ipiv, MKL_Complex16* b,
                          const MKL_INT* ldb, MKL_INT* info );

void __stdcall ZLAHEF_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nb, MKL_INT* kb, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                          MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall ZLAHEF_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nb, MKL_INT* kb, MKL_Complex16* a,
                           const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                           MKL_Complex16* w, const MKL_INT* ldw,
                           MKL_INT* info );
void __stdcall zlahef_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nb, MKL_INT* kb, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                          MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall zlahef_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nb, MKL_INT* kb, MKL_Complex16* a,
                           const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                           MKL_Complex16* w, const MKL_INT* ldw,
                           MKL_INT* info );

void __stdcall ZLARFY( const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_Complex16* v, const MKL_INT* incv,
                       const MKL_Complex16* tau, MKL_Complex16* c,
                       const MKL_INT* ldc, MKL_Complex16* work );
void __stdcall ZLARFY_( const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_Complex16* v, const MKL_INT* incv,
                        const MKL_Complex16* tau, MKL_Complex16* c,
                        const MKL_INT* ldc, MKL_Complex16* work );
void __stdcall zlarfy( const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_Complex16* v, const MKL_INT* incv,
                       const MKL_Complex16* tau, MKL_Complex16* c,
                       const MKL_INT* ldc, MKL_Complex16* work );
void __stdcall zlarfy_( const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_Complex16* v, const MKL_INT* incv,
                        const MKL_Complex16* tau, MKL_Complex16* c,
                        const MKL_INT* ldc, MKL_Complex16* work );

void __stdcall ZLASYF_AA( const char* uplo, int uplo_len, const MKL_INT* j1,
                          const MKL_INT* m, const MKL_INT* nb,
                          MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                          MKL_Complex16* h, const MKL_INT* ldh,
                          MKL_Complex16* work );
void __stdcall ZLASYF_AA_( const char* uplo, int uplo_len, const MKL_INT* j1,
                           const MKL_INT* m, const MKL_INT* nb,
                           MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex16* h, const MKL_INT* ldh,
                           MKL_Complex16* work );
void __stdcall zlasyf_aa( const char* uplo, int uplo_len, const MKL_INT* j1,
                          const MKL_INT* m, const MKL_INT* nb,
                          MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                          MKL_Complex16* h, const MKL_INT* ldh,
                          MKL_Complex16* work );
void __stdcall zlasyf_aa_( const char* uplo, int uplo_len, const MKL_INT* j1,
                           const MKL_INT* m, const MKL_INT* nb,
                           MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex16* h, const MKL_INT* ldh,
                           MKL_Complex16* work );

void __stdcall ZLASYF_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nb, MKL_INT* kb, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                          MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall ZLASYF_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nb, MKL_INT* kb, MKL_Complex16* a,
                           const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                           MKL_Complex16* w, const MKL_INT* ldw,
                           MKL_INT* info );
void __stdcall zlasyf_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nb, MKL_INT* kb, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                          MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall zlasyf_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nb, MKL_INT* kb, MKL_Complex16* a,
                           const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                           MKL_Complex16* w, const MKL_INT* ldw,
                           MKL_INT* info );

void __stdcall ZSYCON_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex16* a, const MKL_INT* lda,
                         const MKL_Complex16* e, const MKL_INT* ipiv,
                         const double* anorm, double* rcond,
                         MKL_Complex16* work, MKL_INT* info );
void __stdcall ZSYCON_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_Complex16* a, const MKL_INT* lda,
                          const MKL_Complex16* e, const MKL_INT* ipiv,
                          const double* anorm, double* rcond,
                          MKL_Complex16* work, MKL_INT* info );
void __stdcall zsycon_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex16* a, const MKL_INT* lda,
                         const MKL_Complex16* e, const MKL_INT* ipiv,
                         const double* anorm, double* rcond,
                         MKL_Complex16* work, MKL_INT* info );
void __stdcall zsycon_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_Complex16* a, const MKL_INT* lda,
                          const MKL_Complex16* e, const MKL_INT* ipiv,
                          const double* anorm, double* rcond,
                          MKL_Complex16* work, MKL_INT* info );

void __stdcall ZSYCONVF( const char* uplo, int uplo_len, const char* way,
                         int way_len, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                         MKL_INT* info );
void __stdcall ZSYCONVF_( const char* uplo, int uplo_len, const char* way,
                          int way_len, const MKL_INT* n, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                          MKL_INT* info );
void __stdcall zsyconvf( const char* uplo, int uplo_len, const char* way,
                         int way_len, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                         MKL_INT* info );
void __stdcall zsyconvf_( const char* uplo, int uplo_len, const char* way,
                          int way_len, const MKL_INT* n, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                          MKL_INT* info );

void __stdcall ZSYCONVF_ROOK( const char* uplo, int uplo_len, const char* way,
                              int way_len, const MKL_INT* n, MKL_Complex16* a,
                              const MKL_INT* lda, MKL_Complex16* e,
                              const MKL_INT* ipiv, MKL_INT* info );
void __stdcall ZSYCONVF_ROOK_( const char* uplo, int uplo_len, const char* way,
                               int way_len, const MKL_INT* n, MKL_Complex16* a,
                               const MKL_INT* lda, MKL_Complex16* e,
                               const MKL_INT* ipiv, MKL_INT* info );
void __stdcall zsyconvf_rook( const char* uplo, int uplo_len, const char* way,
                              int way_len, const MKL_INT* n, MKL_Complex16* a,
                              const MKL_INT* lda, MKL_Complex16* e,
                              const MKL_INT* ipiv, MKL_INT* info );
void __stdcall zsyconvf_rook_( const char* uplo, int uplo_len, const char* way,
                               int way_len, const MKL_INT* n, MKL_Complex16* a,
                               const MKL_INT* lda, MKL_Complex16* e,
                               const MKL_INT* ipiv, MKL_INT* info );

void __stdcall ZSYSV_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* b,
                         const MKL_INT* ldb, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZSYSV_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* b,
                          const MKL_INT* ldb, MKL_Complex16* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall zsysv_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* b,
                         const MKL_INT* ldb, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall zsysv_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* b,
                          const MKL_INT* ldb, MKL_Complex16* work,
                          const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZSYSV_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                         MKL_Complex16* b, const MKL_INT* ldb,
                         MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall ZSYSV_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                          MKL_Complex16* b, const MKL_INT* ldb,
                          MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall zsysv_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                         MKL_Complex16* b, const MKL_INT* ldb,
                         MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall zsysv_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, MKL_Complex16* a,
                          const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                          MKL_Complex16* b, const MKL_INT* ldb,
                          MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );

void __stdcall ZSYTF2_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          MKL_Complex16* e, MKL_INT* ipiv, MKL_INT* info );
void __stdcall ZSYTF2_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           MKL_Complex16* e, MKL_INT* ipiv, MKL_INT* info );
void __stdcall zsytf2_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          MKL_Complex16* e, MKL_INT* ipiv, MKL_INT* info );
void __stdcall zsytf2_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           MKL_Complex16* e, MKL_INT* ipiv, MKL_INT* info );

void __stdcall ZSYTRF_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                          MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall ZSYTRF_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex16* work, const MKL_INT* lwork,
                           MKL_INT* info );
void __stdcall zsytrf_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                          MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall zsytrf_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex16* work, const MKL_INT* lwork,
                           MKL_INT* info );

void __stdcall ZSYTRF_RK( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZSYTRF_RK_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           MKL_Complex16* e, MKL_INT* ipiv,
                           MKL_Complex16* work, const MKL_INT* lwork,
                           MKL_INT* info );
void __stdcall zsytrf_rk( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* work,
                          const MKL_INT* lwork, MKL_INT* info );
void __stdcall zsytrf_rk_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           MKL_Complex16* e, MKL_INT* ipiv,
                           MKL_Complex16* work, const MKL_INT* lwork,
                           MKL_INT* info );

void __stdcall ZSYTRI_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         MKL_Complex16* a, const MKL_INT* lda,
                         const MKL_Complex16* e, const MKL_INT* ipiv,
                         MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall ZSYTRI_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          const MKL_Complex16* e, const MKL_INT* ipiv,
                          MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall zsytri_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         MKL_Complex16* a, const MKL_INT* lda,
                         const MKL_Complex16* e, const MKL_INT* ipiv,
                         MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall zsytri_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          const MKL_Complex16* e, const MKL_INT* ipiv,
                          MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );

void __stdcall ZSYTRI_3X( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          const MKL_Complex16* e, const MKL_INT* ipiv,
                          MKL_Complex16* work, const MKL_INT* nb,
                          MKL_INT* info );
void __stdcall ZSYTRI_3X_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           const MKL_Complex16* e, const MKL_INT* ipiv,
                           MKL_Complex16* work, const MKL_INT* nb,
                           MKL_INT* info );
void __stdcall zsytri_3x( const char* uplo, int uplo_len, const MKL_INT* n,
                          MKL_Complex16* a, const MKL_INT* lda,
                          const MKL_Complex16* e, const MKL_INT* ipiv,
                          MKL_Complex16* work, const MKL_INT* nb,
                          MKL_INT* info );
void __stdcall zsytri_3x_( const char* uplo, int uplo_len, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           const MKL_Complex16* e, const MKL_INT* ipiv,
                           MKL_Complex16* work, const MKL_INT* nb,
                           MKL_INT* info );

void __stdcall ZSYTRS_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_Complex16* e,
                         const MKL_INT* ipiv, MKL_Complex16* b,
                         const MKL_INT* ldb, MKL_INT* info );
void __stdcall ZSYTRS_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_Complex16* e,
                          const MKL_INT* ipiv, MKL_Complex16* b,
                          const MKL_INT* ldb, MKL_INT* info );
void __stdcall zsytrs_3( const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_Complex16* e,
                         const MKL_INT* ipiv, MKL_Complex16* b,
                         const MKL_INT* ldb, MKL_INT* info );
void __stdcall zsytrs_3_( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_Complex16* e,
                          const MKL_INT* ipiv, MKL_Complex16* b,
                          const MKL_INT* ldb, MKL_INT* info );

void __stdcall ZSYTRS_AA( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_INT* ipiv,
                          MKL_Complex16* b, const MKL_INT* ldb,
                          const MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall ZSYTRS_AA_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nrhs, const MKL_Complex16* a,
                           const MKL_INT* lda, const MKL_INT* ipiv,
                           MKL_Complex16* b, const MKL_INT* ldb,
                           const MKL_Complex16* work, const MKL_INT* lwork,
                           MKL_INT* info );
void __stdcall zsytrs_aa( const char* uplo, int uplo_len, const MKL_INT* n,
                          const MKL_INT* nrhs, const MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_INT* ipiv,
                          MKL_Complex16* b, const MKL_INT* ldb,
                          const MKL_Complex16* work, const MKL_INT* lwork,
                          MKL_INT* info );
void __stdcall zsytrs_aa_( const char* uplo, int uplo_len, const MKL_INT* n,
                           const MKL_INT* nrhs, const MKL_Complex16* a,
                           const MKL_INT* lda, const MKL_INT* ipiv,
                           MKL_Complex16* b, const MKL_INT* ldb,
                           const MKL_Complex16* work, const MKL_INT* lwork,
                           MKL_INT* info );

void __stdcall CHB2ST_KERNELS( const char* uplo, int uplo_len,
                               const MKL_INT* wantz, const MKL_INT* ttype,
                               const MKL_INT* st, const MKL_INT* ed,
                               const MKL_INT* sweep, const MKL_INT* n,
                               const MKL_INT* nb, const MKL_INT* ib,
                               MKL_Complex8* a, const MKL_INT* lda,
                               MKL_Complex8* v, MKL_Complex8* tau,
                               const MKL_INT* ldvt, const MKL_Complex8* work );
void __stdcall CHB2ST_KERNELS_( const char* uplo, int uplo_len,
                                const MKL_INT* wantz, const MKL_INT* ttype,
                                const MKL_INT* st, const MKL_INT* ed,
                                const MKL_INT* sweep, const MKL_INT* n,
                                const MKL_INT* nb, const MKL_INT* ib,
                                MKL_Complex8* a, const MKL_INT* lda,
                                MKL_Complex8* v, MKL_Complex8* tau,
                                const MKL_INT* ldvt, const MKL_Complex8* work );
void __stdcall chb2st_kernels( const char* uplo, int uplo_len,
                               const MKL_INT* wantz, const MKL_INT* ttype,
                               const MKL_INT* st, const MKL_INT* ed,
                               const MKL_INT* sweep, const MKL_INT* n,
                               const MKL_INT* nb, const MKL_INT* ib,
                               MKL_Complex8* a, const MKL_INT* lda,
                               MKL_Complex8* v, MKL_Complex8* tau,
                               const MKL_INT* ldvt, const MKL_Complex8* work );
void __stdcall chb2st_kernels_( const char* uplo, int uplo_len,
                                const MKL_INT* wantz, const MKL_INT* ttype,
                                const MKL_INT* st, const MKL_INT* ed,
                                const MKL_INT* sweep, const MKL_INT* n,
                                const MKL_INT* nb, const MKL_INT* ib,
                                MKL_Complex8* a, const MKL_INT* lda,
                                MKL_Complex8* v, MKL_Complex8* tau,
                                const MKL_INT* ldvt, const MKL_Complex8* work );

void __stdcall CHBEV_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             MKL_Complex8* ab, const MKL_INT* ldab, float* w,
                             MKL_Complex8* z, const MKL_INT* ldz,
                             MKL_Complex8* work, const MKL_INT* lwork,
                             float* rwork, MKL_INT* info );
void __stdcall CHBEV_2STAGE_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex8* ab,
                              const MKL_INT* ldab, float* w, MKL_Complex8* z,
                              const MKL_INT* ldz, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              MKL_INT* info );
void __stdcall chbev_2stage( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             MKL_Complex8* ab, const MKL_INT* ldab, float* w,
                             MKL_Complex8* z, const MKL_INT* ldz,
                             MKL_Complex8* work, const MKL_INT* lwork,
                             float* rwork, MKL_INT* info );
void __stdcall chbev_2stage_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex8* ab,
                              const MKL_INT* ldab, float* w, MKL_Complex8* z,
                              const MKL_INT* ldz, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              MKL_INT* info );

void __stdcall CHBEVD_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex8* ab,
                              const MKL_INT* ldab, float* w, MKL_Complex8* z,
                              const MKL_INT* ldz, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              const MKL_INT* lrwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall CHBEVD_2STAGE_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd,
                               MKL_Complex8* ab, const MKL_INT* ldab, float* w,
                               MKL_Complex8* z, const MKL_INT* ldz,
                               MKL_Complex8* work, const MKL_INT* lwork,
                               float* rwork, const MKL_INT* lrwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );
void __stdcall chbevd_2stage( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex8* ab,
                              const MKL_INT* ldab, float* w, MKL_Complex8* z,
                              const MKL_INT* ldz, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              const MKL_INT* lrwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall chbevd_2stage_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd,
                               MKL_Complex8* ab, const MKL_INT* ldab, float* w,
                               MKL_Complex8* z, const MKL_INT* ldz,
                               MKL_Complex8* work, const MKL_INT* lwork,
                               float* rwork, const MKL_INT* lrwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );

void __stdcall CHBEVX_2STAGE( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex8* ab,
                              const MKL_INT* ldab, MKL_Complex8* q,
                              const MKL_INT* ldq, const float* vl,
                              const float* vu, const MKL_INT* il,
                              const MKL_INT* iu, const float* abstol,
                              MKL_INT* m, float* w, MKL_Complex8* z,
                              const MKL_INT* ldz, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall CHBEVX_2STAGE_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd,
                               MKL_Complex8* ab, const MKL_INT* ldab,
                               MKL_Complex8* q, const MKL_INT* ldq,
                               const float* vl, const float* vu,
                               const MKL_INT* il, const MKL_INT* iu,
                               const float* abstol, MKL_INT* m, float* w,
                               MKL_Complex8* z, const MKL_INT* ldz,
                               MKL_Complex8* work, const MKL_INT* lwork,
                               float* rwork, MKL_INT* iwork, MKL_INT* ifail,
                               MKL_INT* info );
void __stdcall chbevx_2stage( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex8* ab,
                              const MKL_INT* ldab, MKL_Complex8* q,
                              const MKL_INT* ldq, const float* vl,
                              const float* vu, const MKL_INT* il,
                              const MKL_INT* iu, const float* abstol,
                              MKL_INT* m, float* w, MKL_Complex8* z,
                              const MKL_INT* ldz, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall chbevx_2stage_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd,
                               MKL_Complex8* ab, const MKL_INT* ldab,
                               MKL_Complex8* q, const MKL_INT* ldq,
                               const float* vl, const float* vu,
                               const MKL_INT* il, const MKL_INT* iu,
                               const float* abstol, MKL_INT* m, float* w,
                               MKL_Complex8* z, const MKL_INT* ldz,
                               MKL_Complex8* work, const MKL_INT* lwork,
                               float* rwork, MKL_INT* iwork, MKL_INT* ifail,
                               MKL_INT* info );

void __stdcall CHEEV_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, float* w, MKL_Complex8* work,
                             const MKL_INT* lwork, float* rwork,
                             MKL_INT* info );
void __stdcall CHEEV_2STAGE_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, float* w, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              MKL_INT* info );
void __stdcall cheev_2stage( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, float* w, MKL_Complex8* work,
                             const MKL_INT* lwork, float* rwork,
                             MKL_INT* info );
void __stdcall cheev_2stage_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, float* w, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              MKL_INT* info );

void __stdcall CHEEVD_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, float* w, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              const MKL_INT* lrwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall CHEEVD_2STAGE_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex8* a,
                               const MKL_INT* lda, float* w,
                               MKL_Complex8* work, const MKL_INT* lwork,
                               float* rwork, const MKL_INT* lrwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );
void __stdcall cheevd_2stage( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, float* w, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              const MKL_INT* lrwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall cheevd_2stage_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex8* a,
                               const MKL_INT* lda, float* w,
                               MKL_Complex8* work, const MKL_INT* lwork,
                               float* rwork, const MKL_INT* lrwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );

void __stdcall CHEEVR_2STAGE( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              MKL_Complex8* a, const MKL_INT* lda,
                              const float* vl, const float* vu,
                              const MKL_INT* il, const MKL_INT* iu,
                              const float* abstol, MKL_INT* m, float* w,
                              MKL_Complex8* z, const MKL_INT* ldz,
                              MKL_INT* isuppz, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              const MKL_INT* lrwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall CHEEVR_2STAGE_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex8* a,
                               const MKL_INT* lda, const float* vl,
                               const float* vu, const MKL_INT* il,
                               const MKL_INT* iu, const float* abstol,
                               MKL_INT* m, float* w, MKL_Complex8* z,
                               const MKL_INT* ldz, MKL_INT* isuppz,
                               MKL_Complex8* work, const MKL_INT* lwork,
                               float* rwork, const MKL_INT* lrwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );
void __stdcall cheevr_2stage( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              MKL_Complex8* a, const MKL_INT* lda,
                              const float* vl, const float* vu,
                              const MKL_INT* il, const MKL_INT* iu,
                              const float* abstol, MKL_INT* m, float* w,
                              MKL_Complex8* z, const MKL_INT* ldz,
                              MKL_INT* isuppz, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              const MKL_INT* lrwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall cheevr_2stage_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex8* a,
                               const MKL_INT* lda, const float* vl,
                               const float* vu, const MKL_INT* il,
                               const MKL_INT* iu, const float* abstol,
                               MKL_INT* m, float* w, MKL_Complex8* z,
                               const MKL_INT* ldz, MKL_INT* isuppz,
                               MKL_Complex8* work, const MKL_INT* lwork,
                               float* rwork, const MKL_INT* lrwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );

void __stdcall CHEEVX_2STAGE( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              MKL_Complex8* a, const MKL_INT* lda,
                              const float* vl, const float* vu,
                              const MKL_INT* il, const MKL_INT* iu,
                              const float* abstol, MKL_INT* m, float* w,
                              MKL_Complex8* z, const MKL_INT* ldz,
                              MKL_Complex8* work, const MKL_INT* lwork,
                              float* rwork, MKL_INT* iwork, MKL_INT* ifail,
                              MKL_INT* info );
void __stdcall CHEEVX_2STAGE_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex8* a,
                               const MKL_INT* lda, const float* vl,
                               const float* vu, const MKL_INT* il,
                               const MKL_INT* iu, const float* abstol,
                               MKL_INT* m, float* w, MKL_Complex8* z,
                               const MKL_INT* ldz, MKL_Complex8* work,
                               const MKL_INT* lwork, float* rwork,
                               MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall cheevx_2stage( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              MKL_Complex8* a, const MKL_INT* lda,
                              const float* vl, const float* vu,
                              const MKL_INT* il, const MKL_INT* iu,
                              const float* abstol, MKL_INT* m, float* w,
                              MKL_Complex8* z, const MKL_INT* ldz,
                              MKL_Complex8* work, const MKL_INT* lwork,
                              float* rwork, MKL_INT* iwork, MKL_INT* ifail,
                              MKL_INT* info );
void __stdcall cheevx_2stage_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex8* a,
                               const MKL_INT* lda, const float* vl,
                               const float* vu, const MKL_INT* il,
                               const MKL_INT* iu, const float* abstol,
                               MKL_INT* m, float* w, MKL_Complex8* z,
                               const MKL_INT* ldz, MKL_Complex8* work,
                               const MKL_INT* lwork, float* rwork,
                               MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void __stdcall CHEGV_2STAGE( const MKL_INT* itype, const char* jobz,
                             int jobz_len, const char* uplo, int uplo_len,
                             const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_Complex8* b,
                             const MKL_INT* ldb, float* w, MKL_Complex8* work,
                             const MKL_INT* lwork, float* rwork,
                             MKL_INT* info );
void __stdcall CHEGV_2STAGE_( const MKL_INT* itype, const char* jobz,
                              int jobz_len, const char* uplo, int uplo_len,
                              const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, MKL_Complex8* b,
                              const MKL_INT* ldb, float* w, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              MKL_INT* info );
void __stdcall chegv_2stage( const MKL_INT* itype, const char* jobz,
                             int jobz_len, const char* uplo, int uplo_len,
                             const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_Complex8* b,
                             const MKL_INT* ldb, float* w, MKL_Complex8* work,
                             const MKL_INT* lwork, float* rwork,
                             MKL_INT* info );
void __stdcall chegv_2stage_( const MKL_INT* itype, const char* jobz,
                              int jobz_len, const char* uplo, int uplo_len,
                              const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, MKL_Complex8* b,
                              const MKL_INT* ldb, float* w, MKL_Complex8* work,
                              const MKL_INT* lwork, float* rwork,
                              MKL_INT* info );

void __stdcall CHETRD_2STAGE( const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, float* d, float* e,
                              MKL_Complex8* tau, MKL_Complex8* hous2,
                              const MKL_INT* lhous2, MKL_Complex8* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall CHETRD_2STAGE_( const char* vect, int vect_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex8* a,
                               const MKL_INT* lda, float* d, float* e,
                               MKL_Complex8* tau, MKL_Complex8* hous2,
                               const MKL_INT* lhous2, MKL_Complex8* work,
                               const MKL_INT* lwork, MKL_INT* info );
void __stdcall chetrd_2stage( const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, float* d, float* e,
                              MKL_Complex8* tau, MKL_Complex8* hous2,
                              const MKL_INT* lhous2, MKL_Complex8* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall chetrd_2stage_( const char* vect, int vect_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex8* a,
                               const MKL_INT* lda, float* d, float* e,
                               MKL_Complex8* tau, MKL_Complex8* hous2,
                               const MKL_INT* lhous2, MKL_Complex8* work,
                               const MKL_INT* lwork, MKL_INT* info );

void __stdcall CHETRD_HB2ST( const char* stage1, int stage1_len,
                             const char* vect, int vect_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             MKL_Complex8* ab, const MKL_INT* ldab, float* d,
                             float* e, MKL_Complex8* hous,
                             const MKL_INT* lhous, MKL_Complex8* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall CHETRD_HB2ST_( const char* stage1, int stage1_len,
                              const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex8* ab,
                              const MKL_INT* ldab, float* d, float* e,
                              MKL_Complex8* hous, const MKL_INT* lhous,
                              MKL_Complex8* work, const MKL_INT* lwork,
                              MKL_INT* info );
void __stdcall chetrd_hb2st( const char* stage1, int stage1_len,
                             const char* vect, int vect_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             MKL_Complex8* ab, const MKL_INT* ldab, float* d,
                             float* e, MKL_Complex8* hous,
                             const MKL_INT* lhous, MKL_Complex8* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall chetrd_hb2st_( const char* stage1, int stage1_len,
                              const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex8* ab,
                              const MKL_INT* ldab, float* d, float* e,
                              MKL_Complex8* hous, const MKL_INT* lhous,
                              MKL_Complex8* work, const MKL_INT* lwork,
                              MKL_INT* info );

void __stdcall CHETRD_HE2HB( const char* uplo, int uplo_len, const MKL_INT* n,
                             const MKL_INT* kd, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_Complex8* ab,
                             const MKL_INT* ldab, MKL_Complex8* tau,
                             MKL_Complex8* work, const MKL_INT* lwork,
                             MKL_INT* info );
void __stdcall CHETRD_HE2HB_( const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex8* a,
                              const MKL_INT* lda, MKL_Complex8* ab,
                              const MKL_INT* ldab, MKL_Complex8* tau,
                              MKL_Complex8* work, const MKL_INT* lwork,
                              MKL_INT* info );
void __stdcall chetrd_he2hb( const char* uplo, int uplo_len, const MKL_INT* n,
                             const MKL_INT* kd, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_Complex8* ab,
                             const MKL_INT* ldab, MKL_Complex8* tau,
                             MKL_Complex8* work, const MKL_INT* lwork,
                             MKL_INT* info );
void __stdcall chetrd_he2hb_( const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex8* a,
                              const MKL_INT* lda, MKL_Complex8* ab,
                              const MKL_INT* ldab, MKL_Complex8* tau,
                              MKL_Complex8* work, const MKL_INT* lwork,
                              MKL_INT* info );

void __stdcall DSB2ST_KERNELS( const char* uplo, int uplo_len,
                               const MKL_INT* wantz, const MKL_INT* ttype,
                               const MKL_INT* st, const MKL_INT* ed,
                               const MKL_INT* sweep, const MKL_INT* n,
                               const MKL_INT* nb, const MKL_INT* ib, double* a,
                               const MKL_INT* lda, double* v, double* tau,
                               const MKL_INT* ldvt, const double* work );
void __stdcall DSB2ST_KERNELS_( const char* uplo, int uplo_len,
                                const MKL_INT* wantz, const MKL_INT* ttype,
                                const MKL_INT* st, const MKL_INT* ed,
                                const MKL_INT* sweep, const MKL_INT* n,
                                const MKL_INT* nb, const MKL_INT* ib,
                                double* a, const MKL_INT* lda, double* v,
                                double* tau, const MKL_INT* ldvt,
                                const double* work );
void __stdcall dsb2st_kernels( const char* uplo, int uplo_len,
                               const MKL_INT* wantz, const MKL_INT* ttype,
                               const MKL_INT* st, const MKL_INT* ed,
                               const MKL_INT* sweep, const MKL_INT* n,
                               const MKL_INT* nb, const MKL_INT* ib, double* a,
                               const MKL_INT* lda, double* v, double* tau,
                               const MKL_INT* ldvt, const double* work );
void __stdcall dsb2st_kernels_( const char* uplo, int uplo_len,
                                const MKL_INT* wantz, const MKL_INT* ttype,
                                const MKL_INT* st, const MKL_INT* ed,
                                const MKL_INT* sweep, const MKL_INT* n,
                                const MKL_INT* nb, const MKL_INT* ib,
                                double* a, const MKL_INT* lda, double* v,
                                double* tau, const MKL_INT* ldvt,
                                const double* work );

void __stdcall DSBEV_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             double* ab, const MKL_INT* ldab, double* w,
                             double* z, const MKL_INT* ldz, double* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall DSBEV_2STAGE_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, double* ab,
                              const MKL_INT* ldab, double* w, double* z,
                              const MKL_INT* ldz, double* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsbev_2stage( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             double* ab, const MKL_INT* ldab, double* w,
                             double* z, const MKL_INT* ldz, double* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsbev_2stage_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, double* ab,
                              const MKL_INT* ldab, double* w, double* z,
                              const MKL_INT* ldz, double* work,
                              const MKL_INT* lwork, MKL_INT* info );

void __stdcall DSBEVD_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, double* ab,
                              const MKL_INT* ldab, double* w, double* z,
                              const MKL_INT* ldz, double* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall DSBEVD_2STAGE_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd, double* ab,
                               const MKL_INT* ldab, double* w, double* z,
                               const MKL_INT* ldz, double* work,
                               const MKL_INT* lwork, MKL_INT* iwork,
                               const MKL_INT* liwork, MKL_INT* info );
void __stdcall dsbevd_2stage( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, double* ab,
                              const MKL_INT* ldab, double* w, double* z,
                              const MKL_INT* ldz, double* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall dsbevd_2stage_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd, double* ab,
                               const MKL_INT* ldab, double* w, double* z,
                               const MKL_INT* ldz, double* work,
                               const MKL_INT* lwork, MKL_INT* iwork,
                               const MKL_INT* liwork, MKL_INT* info );

void __stdcall DSBEVX_2STAGE( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, double* ab,
                              const MKL_INT* ldab, double* q,
                              const MKL_INT* ldq, const double* vl,
                              const double* vu, const MKL_INT* il,
                              const MKL_INT* iu, const double* abstol,
                              MKL_INT* m, double* w, double* z,
                              const MKL_INT* ldz, double* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              MKL_INT* ifail, MKL_INT* info );
void __stdcall DSBEVX_2STAGE_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd, double* ab,
                               const MKL_INT* ldab, double* q,
                               const MKL_INT* ldq, const double* vl,
                               const double* vu, const MKL_INT* il,
                               const MKL_INT* iu, const double* abstol,
                               MKL_INT* m, double* w, double* z,
                               const MKL_INT* ldz, double* work,
                               const MKL_INT* lwork, MKL_INT* iwork,
                               MKL_INT* ifail, MKL_INT* info );
void __stdcall dsbevx_2stage( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, double* ab,
                              const MKL_INT* ldab, double* q,
                              const MKL_INT* ldq, const double* vl,
                              const double* vu, const MKL_INT* il,
                              const MKL_INT* iu, const double* abstol,
                              MKL_INT* m, double* w, double* z,
                              const MKL_INT* ldz, double* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              MKL_INT* ifail, MKL_INT* info );
void __stdcall dsbevx_2stage_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd, double* ab,
                               const MKL_INT* ldab, double* q,
                               const MKL_INT* ldq, const double* vl,
                               const double* vu, const MKL_INT* il,
                               const MKL_INT* iu, const double* abstol,
                               MKL_INT* m, double* w, double* z,
                               const MKL_INT* ldz, double* work,
                               const MKL_INT* lwork, MKL_INT* iwork,
                               MKL_INT* ifail, MKL_INT* info );

void __stdcall DSYEV_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, double* a,
                             const MKL_INT* lda, double* w, double* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall DSYEV_2STAGE_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, double* a,
                              const MKL_INT* lda, double* w, double* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsyev_2stage( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, double* a,
                             const MKL_INT* lda, double* w, double* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsyev_2stage_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, double* a,
                              const MKL_INT* lda, double* w, double* work,
                              const MKL_INT* lwork, MKL_INT* info );

void __stdcall DSYEVD_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, double* a,
                              const MKL_INT* lda, double* w, double* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall DSYEVD_2STAGE_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, double* a, const MKL_INT* lda,
                               double* w, double* work, const MKL_INT* lwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );
void __stdcall dsyevd_2stage( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, double* a,
                              const MKL_INT* lda, double* w, double* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall dsyevd_2stage_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, double* a, const MKL_INT* lda,
                               double* w, double* work, const MKL_INT* lwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );

void __stdcall DSYEVR_2STAGE( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              double* a, const MKL_INT* lda, const double* vl,
                              const double* vu, const MKL_INT* il,
                              const MKL_INT* iu, const double* abstol,
                              MKL_INT* m, double* w, double* z,
                              const MKL_INT* ldz, MKL_INT* isuppz,
                              double* work, const MKL_INT* lwork,
                              MKL_INT* iwork, const MKL_INT* liwork,
                              MKL_INT* info );
void __stdcall DSYEVR_2STAGE_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, double* a, const MKL_INT* lda,
                               const double* vl, const double* vu,
                               const MKL_INT* il, const MKL_INT* iu,
                               const double* abstol, MKL_INT* m, double* w,
                               double* z, const MKL_INT* ldz, MKL_INT* isuppz,
                               double* work, const MKL_INT* lwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );
void __stdcall dsyevr_2stage( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              double* a, const MKL_INT* lda, const double* vl,
                              const double* vu, const MKL_INT* il,
                              const MKL_INT* iu, const double* abstol,
                              MKL_INT* m, double* w, double* z,
                              const MKL_INT* ldz, MKL_INT* isuppz,
                              double* work, const MKL_INT* lwork,
                              MKL_INT* iwork, const MKL_INT* liwork,
                              MKL_INT* info );
void __stdcall dsyevr_2stage_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, double* a, const MKL_INT* lda,
                               const double* vl, const double* vu,
                               const MKL_INT* il, const MKL_INT* iu,
                               const double* abstol, MKL_INT* m, double* w,
                               double* z, const MKL_INT* ldz, MKL_INT* isuppz,
                               double* work, const MKL_INT* lwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );

void __stdcall DSYEVX_2STAGE( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              double* a, const MKL_INT* lda, const double* vl,
                              const double* vu, const MKL_INT* il,
                              const MKL_INT* iu, const double* abstol,
                              MKL_INT* m, double* w, double* z,
                              const MKL_INT* ldz, double* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              MKL_INT* ifail, MKL_INT* info );
void __stdcall DSYEVX_2STAGE_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, double* a, const MKL_INT* lda,
                               const double* vl, const double* vu,
                               const MKL_INT* il, const MKL_INT* iu,
                               const double* abstol, MKL_INT* m, double* w,
                               double* z, const MKL_INT* ldz, double* work,
                               const MKL_INT* lwork, MKL_INT* iwork,
                               MKL_INT* ifail, MKL_INT* info );
void __stdcall dsyevx_2stage( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              double* a, const MKL_INT* lda, const double* vl,
                              const double* vu, const MKL_INT* il,
                              const MKL_INT* iu, const double* abstol,
                              MKL_INT* m, double* w, double* z,
                              const MKL_INT* ldz, double* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              MKL_INT* ifail, MKL_INT* info );
void __stdcall dsyevx_2stage_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, double* a, const MKL_INT* lda,
                               const double* vl, const double* vu,
                               const MKL_INT* il, const MKL_INT* iu,
                               const double* abstol, MKL_INT* m, double* w,
                               double* z, const MKL_INT* ldz, double* work,
                               const MKL_INT* lwork, MKL_INT* iwork,
                               MKL_INT* ifail, MKL_INT* info );

void __stdcall DSYGV_2STAGE( const MKL_INT* itype, const char* jobz,
                             int jobz_len, const char* uplo, int uplo_len,
                             const MKL_INT* n, double* a, const MKL_INT* lda,
                             double* b, const MKL_INT* ldb, double* w,
                             double* work, const MKL_INT* lwork,
                             MKL_INT* info );
void __stdcall DSYGV_2STAGE_( const MKL_INT* itype, const char* jobz,
                              int jobz_len, const char* uplo, int uplo_len,
                              const MKL_INT* n, double* a, const MKL_INT* lda,
                              double* b, const MKL_INT* ldb, double* w,
                              double* work, const MKL_INT* lwork,
                              MKL_INT* info );
void __stdcall dsygv_2stage( const MKL_INT* itype, const char* jobz,
                             int jobz_len, const char* uplo, int uplo_len,
                             const MKL_INT* n, double* a, const MKL_INT* lda,
                             double* b, const MKL_INT* ldb, double* w,
                             double* work, const MKL_INT* lwork,
                             MKL_INT* info );
void __stdcall dsygv_2stage_( const MKL_INT* itype, const char* jobz,
                              int jobz_len, const char* uplo, int uplo_len,
                              const MKL_INT* n, double* a, const MKL_INT* lda,
                              double* b, const MKL_INT* ldb, double* w,
                              double* work, const MKL_INT* lwork,
                              MKL_INT* info );

void __stdcall DSYTRD_2STAGE( const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, double* a,
                              const MKL_INT* lda, double* d, double* e,
                              double* tau, double* hous2,
                              const MKL_INT* lhous2, double* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall DSYTRD_2STAGE_( const char* vect, int vect_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, double* a, const MKL_INT* lda,
                               double* d, double* e, double* tau,
                               double* hous2, const MKL_INT* lhous2,
                               double* work, const MKL_INT* lwork,
                               MKL_INT* info );
void __stdcall dsytrd_2stage( const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, double* a,
                              const MKL_INT* lda, double* d, double* e,
                              double* tau, double* hous2,
                              const MKL_INT* lhous2, double* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsytrd_2stage_( const char* vect, int vect_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, double* a, const MKL_INT* lda,
                               double* d, double* e, double* tau,
                               double* hous2, const MKL_INT* lhous2,
                               double* work, const MKL_INT* lwork,
                               MKL_INT* info );

void __stdcall DSYTRD_SB2ST( const char* stage1, int stage1_len,
                             const char* vect, int vect_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             double* ab, const MKL_INT* ldab, double* d,
                             double* e, double* hous, const MKL_INT* lhous,
                             double* work, const MKL_INT* lwork,
                             MKL_INT* info );
void __stdcall DSYTRD_SB2ST_( const char* stage1, int stage1_len,
                              const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, double* ab,
                              const MKL_INT* ldab, double* d, double* e,
                              double* hous, const MKL_INT* lhous, double* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsytrd_sb2st( const char* stage1, int stage1_len,
                             const char* vect, int vect_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             double* ab, const MKL_INT* ldab, double* d,
                             double* e, double* hous, const MKL_INT* lhous,
                             double* work, const MKL_INT* lwork,
                             MKL_INT* info );
void __stdcall dsytrd_sb2st_( const char* stage1, int stage1_len,
                              const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, double* ab,
                              const MKL_INT* ldab, double* d, double* e,
                              double* hous, const MKL_INT* lhous, double* work,
                              const MKL_INT* lwork, MKL_INT* info );

void __stdcall DSYTRD_SY2SB( const char* uplo, int uplo_len, const MKL_INT* n,
                             const MKL_INT* kd, double* a, const MKL_INT* lda,
                             double* ab, const MKL_INT* ldab, double* tau,
                             double* work, const MKL_INT* lwork,
                             MKL_INT* info );
void __stdcall DSYTRD_SY2SB_( const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, double* a, const MKL_INT* lda,
                              double* ab, const MKL_INT* ldab, double* tau,
                              double* work, const MKL_INT* lwork,
                              MKL_INT* info );
void __stdcall dsytrd_sy2sb( const char* uplo, int uplo_len, const MKL_INT* n,
                             const MKL_INT* kd, double* a, const MKL_INT* lda,
                             double* ab, const MKL_INT* ldab, double* tau,
                             double* work, const MKL_INT* lwork,
                             MKL_INT* info );
void __stdcall dsytrd_sy2sb_( const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, double* a, const MKL_INT* lda,
                              double* ab, const MKL_INT* ldab, double* tau,
                              double* work, const MKL_INT* lwork,
                              MKL_INT* info );

MKL_INT __stdcall IPARAM2STAGE( const MKL_INT* ispec, const char* name,
                                int name_len, const char* opts, int opts_len,
                                const MKL_INT* ni, const MKL_INT* nbi,
                                const MKL_INT* ibi, const MKL_INT* nxi );
MKL_INT __stdcall IPARAM2STAGE_( const MKL_INT* ispec, const char* name,
                                 int name_len, const char* opts, int opts_len,
                                 const MKL_INT* ni, const MKL_INT* nbi,
                                 const MKL_INT* ibi, const MKL_INT* nxi );
MKL_INT __stdcall iparam2stage( const MKL_INT* ispec, const char* name,
                                int name_len, const char* opts, int opts_len,
                                const MKL_INT* ni, const MKL_INT* nbi,
                                const MKL_INT* ibi, const MKL_INT* nxi );
MKL_INT __stdcall iparam2stage_( const MKL_INT* ispec, const char* name,
                                 int name_len, const char* opts, int opts_len,
                                 const MKL_INT* ni, const MKL_INT* nbi,
                                 const MKL_INT* ibi, const MKL_INT* nxi );

void __stdcall SSB2ST_KERNELS( const char* uplo, int uplo_len,
                               const MKL_INT* wantz, const MKL_INT* ttype,
                               const MKL_INT* st, const MKL_INT* ed,
                               const MKL_INT* sweep, const MKL_INT* n,
                               const MKL_INT* nb, const MKL_INT* ib, float* a,
                               const MKL_INT* lda, float* v, float* tau,
                               const MKL_INT* ldvt, const float* work );
void __stdcall SSB2ST_KERNELS_( const char* uplo, int uplo_len,
                                const MKL_INT* wantz, const MKL_INT* ttype,
                                const MKL_INT* st, const MKL_INT* ed,
                                const MKL_INT* sweep, const MKL_INT* n,
                                const MKL_INT* nb, const MKL_INT* ib, float* a,
                                const MKL_INT* lda, float* v, float* tau,
                                const MKL_INT* ldvt, const float* work );
void __stdcall ssb2st_kernels( const char* uplo, int uplo_len,
                               const MKL_INT* wantz, const MKL_INT* ttype,
                               const MKL_INT* st, const MKL_INT* ed,
                               const MKL_INT* sweep, const MKL_INT* n,
                               const MKL_INT* nb, const MKL_INT* ib, float* a,
                               const MKL_INT* lda, float* v, float* tau,
                               const MKL_INT* ldvt, const float* work );
void __stdcall ssb2st_kernels_( const char* uplo, int uplo_len,
                                const MKL_INT* wantz, const MKL_INT* ttype,
                                const MKL_INT* st, const MKL_INT* ed,
                                const MKL_INT* sweep, const MKL_INT* n,
                                const MKL_INT* nb, const MKL_INT* ib, float* a,
                                const MKL_INT* lda, float* v, float* tau,
                                const MKL_INT* ldvt, const float* work );

void __stdcall SSBEV_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             float* ab, const MKL_INT* ldab, float* w,
                             float* z, const MKL_INT* ldz, float* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSBEV_2STAGE_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, float* ab,
                              const MKL_INT* ldab, float* w, float* z,
                              const MKL_INT* ldz, float* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssbev_2stage( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             float* ab, const MKL_INT* ldab, float* w,
                             float* z, const MKL_INT* ldz, float* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssbev_2stage_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, float* ab,
                              const MKL_INT* ldab, float* w, float* z,
                              const MKL_INT* ldz, float* work,
                              const MKL_INT* lwork, MKL_INT* info );

void __stdcall SSBEVD_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, float* ab,
                              const MKL_INT* ldab, float* w, float* z,
                              const MKL_INT* ldz, float* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall SSBEVD_2STAGE_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd, float* ab,
                               const MKL_INT* ldab, float* w, float* z,
                               const MKL_INT* ldz, float* work,
                               const MKL_INT* lwork, MKL_INT* iwork,
                               const MKL_INT* liwork, MKL_INT* info );
void __stdcall ssbevd_2stage( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, float* ab,
                              const MKL_INT* ldab, float* w, float* z,
                              const MKL_INT* ldz, float* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall ssbevd_2stage_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd, float* ab,
                               const MKL_INT* ldab, float* w, float* z,
                               const MKL_INT* ldz, float* work,
                               const MKL_INT* lwork, MKL_INT* iwork,
                               const MKL_INT* liwork, MKL_INT* info );

void __stdcall SSBEVX_2STAGE( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, float* ab,
                              const MKL_INT* ldab, float* q,
                              const MKL_INT* ldq, const float* vl,
                              const float* vu, const MKL_INT* il,
                              const MKL_INT* iu, const float* abstol,
                              MKL_INT* m, float* w, float* z,
                              const MKL_INT* ldz, float* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              MKL_INT* ifail, MKL_INT* info );
void __stdcall SSBEVX_2STAGE_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd, float* ab,
                               const MKL_INT* ldab, float* q,
                               const MKL_INT* ldq, const float* vl,
                               const float* vu, const MKL_INT* il,
                               const MKL_INT* iu, const float* abstol,
                               MKL_INT* m, float* w, float* z,
                               const MKL_INT* ldz, float* work,
                               const MKL_INT* lwork, MKL_INT* iwork,
                               MKL_INT* ifail, MKL_INT* info );
void __stdcall ssbevx_2stage( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, float* ab,
                              const MKL_INT* ldab, float* q,
                              const MKL_INT* ldq, const float* vl,
                              const float* vu, const MKL_INT* il,
                              const MKL_INT* iu, const float* abstol,
                              MKL_INT* m, float* w, float* z,
                              const MKL_INT* ldz, float* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              MKL_INT* ifail, MKL_INT* info );
void __stdcall ssbevx_2stage_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd, float* ab,
                               const MKL_INT* ldab, float* q,
                               const MKL_INT* ldq, const float* vl,
                               const float* vu, const MKL_INT* il,
                               const MKL_INT* iu, const float* abstol,
                               MKL_INT* m, float* w, float* z,
                               const MKL_INT* ldz, float* work,
                               const MKL_INT* lwork, MKL_INT* iwork,
                               MKL_INT* ifail, MKL_INT* info );

void __stdcall SSYEV_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, float* a,
                             const MKL_INT* lda, float* w, float* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSYEV_2STAGE_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, float* a,
                              const MKL_INT* lda, float* w, float* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssyev_2stage( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, float* a,
                             const MKL_INT* lda, float* w, float* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssyev_2stage_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, float* a,
                              const MKL_INT* lda, float* w, float* work,
                              const MKL_INT* lwork, MKL_INT* info );

void __stdcall SSYEVD_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, float* a,
                              const MKL_INT* lda, float* w, float* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall SSYEVD_2STAGE_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, float* a, const MKL_INT* lda,
                               float* w, float* work, const MKL_INT* lwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );
void __stdcall ssyevd_2stage( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, float* a,
                              const MKL_INT* lda, float* w, float* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall ssyevd_2stage_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, float* a, const MKL_INT* lda,
                               float* w, float* work, const MKL_INT* lwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );

void __stdcall SSYEVR_2STAGE( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              float* a, const MKL_INT* lda, const float* vl,
                              const float* vu, const MKL_INT* il,
                              const MKL_INT* iu, const float* abstol,
                              MKL_INT* m, float* w, float* z,
                              const MKL_INT* ldz, MKL_INT* isuppz, float* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall SSYEVR_2STAGE_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, float* a, const MKL_INT* lda,
                               const float* vl, const float* vu,
                               const MKL_INT* il, const MKL_INT* iu,
                               const float* abstol, MKL_INT* m, float* w,
                               float* z, const MKL_INT* ldz, MKL_INT* isuppz,
                               float* work, const MKL_INT* lwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );
void __stdcall ssyevr_2stage( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              float* a, const MKL_INT* lda, const float* vl,
                              const float* vu, const MKL_INT* il,
                              const MKL_INT* iu, const float* abstol,
                              MKL_INT* m, float* w, float* z,
                              const MKL_INT* ldz, MKL_INT* isuppz, float* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall ssyevr_2stage_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, float* a, const MKL_INT* lda,
                               const float* vl, const float* vu,
                               const MKL_INT* il, const MKL_INT* iu,
                               const float* abstol, MKL_INT* m, float* w,
                               float* z, const MKL_INT* ldz, MKL_INT* isuppz,
                               float* work, const MKL_INT* lwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );

void __stdcall SSYEVX_2STAGE( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              float* a, const MKL_INT* lda, const float* vl,
                              const float* vu, const MKL_INT* il,
                              const MKL_INT* iu, const float* abstol,
                              MKL_INT* m, float* w, float* z,
                              const MKL_INT* ldz, float* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              MKL_INT* ifail, MKL_INT* info );
void __stdcall SSYEVX_2STAGE_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, float* a, const MKL_INT* lda,
                               const float* vl, const float* vu,
                               const MKL_INT* il, const MKL_INT* iu,
                               const float* abstol, MKL_INT* m, float* w,
                               float* z, const MKL_INT* ldz, float* work,
                               const MKL_INT* lwork, MKL_INT* iwork,
                               MKL_INT* ifail, MKL_INT* info );
void __stdcall ssyevx_2stage( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              float* a, const MKL_INT* lda, const float* vl,
                              const float* vu, const MKL_INT* il,
                              const MKL_INT* iu, const float* abstol,
                              MKL_INT* m, float* w, float* z,
                              const MKL_INT* ldz, float* work,
                              const MKL_INT* lwork, MKL_INT* iwork,
                              MKL_INT* ifail, MKL_INT* info );
void __stdcall ssyevx_2stage_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, float* a, const MKL_INT* lda,
                               const float* vl, const float* vu,
                               const MKL_INT* il, const MKL_INT* iu,
                               const float* abstol, MKL_INT* m, float* w,
                               float* z, const MKL_INT* ldz, float* work,
                               const MKL_INT* lwork, MKL_INT* iwork,
                               MKL_INT* ifail, MKL_INT* info );

void __stdcall SSYGV_2STAGE( const MKL_INT* itype, const char* jobz,
                             int jobz_len, const char* uplo, int uplo_len,
                             const MKL_INT* n, float* a, const MKL_INT* lda,
                             float* b, const MKL_INT* ldb, float* w,
                             float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSYGV_2STAGE_( const MKL_INT* itype, const char* jobz,
                              int jobz_len, const char* uplo, int uplo_len,
                              const MKL_INT* n, float* a, const MKL_INT* lda,
                              float* b, const MKL_INT* ldb, float* w,
                              float* work, const MKL_INT* lwork,
                              MKL_INT* info );
void __stdcall ssygv_2stage( const MKL_INT* itype, const char* jobz,
                             int jobz_len, const char* uplo, int uplo_len,
                             const MKL_INT* n, float* a, const MKL_INT* lda,
                             float* b, const MKL_INT* ldb, float* w,
                             float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssygv_2stage_( const MKL_INT* itype, const char* jobz,
                              int jobz_len, const char* uplo, int uplo_len,
                              const MKL_INT* n, float* a, const MKL_INT* lda,
                              float* b, const MKL_INT* ldb, float* w,
                              float* work, const MKL_INT* lwork,
                              MKL_INT* info );

void __stdcall SSYTRD_2STAGE( const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, float* a,
                              const MKL_INT* lda, float* d, float* e,
                              float* tau, float* hous2, const MKL_INT* lhous2,
                              float* work, const MKL_INT* lwork,
                              MKL_INT* info );
void __stdcall SSYTRD_2STAGE_( const char* vect, int vect_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, float* a, const MKL_INT* lda,
                               float* d, float* e, float* tau, float* hous2,
                               const MKL_INT* lhous2, float* work,
                               const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytrd_2stage( const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, float* a,
                              const MKL_INT* lda, float* d, float* e,
                              float* tau, float* hous2, const MKL_INT* lhous2,
                              float* work, const MKL_INT* lwork,
                              MKL_INT* info );
void __stdcall ssytrd_2stage_( const char* vect, int vect_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, float* a, const MKL_INT* lda,
                               float* d, float* e, float* tau, float* hous2,
                               const MKL_INT* lhous2, float* work,
                               const MKL_INT* lwork, MKL_INT* info );

void __stdcall SSYTRD_SB2ST( const char* stage1, int stage1_len,
                             const char* vect, int vect_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             float* ab, const MKL_INT* ldab, float* d,
                             float* e, float* hous, const MKL_INT* lhous,
                             float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSYTRD_SB2ST_( const char* stage1, int stage1_len,
                              const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, float* ab,
                              const MKL_INT* ldab, float* d, float* e,
                              float* hous, const MKL_INT* lhous, float* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytrd_sb2st( const char* stage1, int stage1_len,
                             const char* vect, int vect_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             float* ab, const MKL_INT* ldab, float* d,
                             float* e, float* hous, const MKL_INT* lhous,
                             float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytrd_sb2st_( const char* stage1, int stage1_len,
                              const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, float* ab,
                              const MKL_INT* ldab, float* d, float* e,
                              float* hous, const MKL_INT* lhous, float* work,
                              const MKL_INT* lwork, MKL_INT* info );

void __stdcall SSYTRD_SY2SB( const char* uplo, int uplo_len, const MKL_INT* n,
                             const MKL_INT* kd, float* a, const MKL_INT* lda,
                             float* ab, const MKL_INT* ldab, float* tau,
                             float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSYTRD_SY2SB_( const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, float* a, const MKL_INT* lda,
                              float* ab, const MKL_INT* ldab, float* tau,
                              float* work, const MKL_INT* lwork,
                              MKL_INT* info );
void __stdcall ssytrd_sy2sb( const char* uplo, int uplo_len, const MKL_INT* n,
                             const MKL_INT* kd, float* a, const MKL_INT* lda,
                             float* ab, const MKL_INT* ldab, float* tau,
                             float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytrd_sy2sb_( const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, float* a, const MKL_INT* lda,
                              float* ab, const MKL_INT* ldab, float* tau,
                              float* work, const MKL_INT* lwork,
                              MKL_INT* info );

void __stdcall ZHB2ST_KERNELS( const char* uplo, int uplo_len,
                               const MKL_INT* wantz, const MKL_INT* ttype,
                               const MKL_INT* st, const MKL_INT* ed,
                               const MKL_INT* sweep, const MKL_INT* n,
                               const MKL_INT* nb, const MKL_INT* ib,
                               MKL_Complex16* a, const MKL_INT* lda,
                               MKL_Complex16* v, MKL_Complex16* tau,
                               const MKL_INT* ldvt, const MKL_Complex16* work );
void __stdcall ZHB2ST_KERNELS_( const char* uplo, int uplo_len,
                                const MKL_INT* wantz, const MKL_INT* ttype,
                                const MKL_INT* st, const MKL_INT* ed,
                                const MKL_INT* sweep, const MKL_INT* n,
                                const MKL_INT* nb, const MKL_INT* ib,
                                MKL_Complex16* a, const MKL_INT* lda,
                                MKL_Complex16* v, MKL_Complex16* tau,
                                const MKL_INT* ldvt,
                                const MKL_Complex16* work );
void __stdcall zhb2st_kernels( const char* uplo, int uplo_len,
                               const MKL_INT* wantz, const MKL_INT* ttype,
                               const MKL_INT* st, const MKL_INT* ed,
                               const MKL_INT* sweep, const MKL_INT* n,
                               const MKL_INT* nb, const MKL_INT* ib,
                               MKL_Complex16* a, const MKL_INT* lda,
                               MKL_Complex16* v, MKL_Complex16* tau,
                               const MKL_INT* ldvt, const MKL_Complex16* work );
void __stdcall zhb2st_kernels_( const char* uplo, int uplo_len,
                                const MKL_INT* wantz, const MKL_INT* ttype,
                                const MKL_INT* st, const MKL_INT* ed,
                                const MKL_INT* sweep, const MKL_INT* n,
                                const MKL_INT* nb, const MKL_INT* ib,
                                MKL_Complex16* a, const MKL_INT* lda,
                                MKL_Complex16* v, MKL_Complex16* tau,
                                const MKL_INT* ldvt,
                                const MKL_Complex16* work );

void __stdcall ZHBEV_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             MKL_Complex16* ab, const MKL_INT* ldab, double* w,
                             MKL_Complex16* z, const MKL_INT* ldz,
                             MKL_Complex16* work, const MKL_INT* lwork,
                             double* rwork, MKL_INT* info );
void __stdcall ZHBEV_2STAGE_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex16* ab,
                              const MKL_INT* ldab, double* w, MKL_Complex16* z,
                              const MKL_INT* ldz, MKL_Complex16* work,
                              const MKL_INT* lwork, double* rwork,
                              MKL_INT* info );
void __stdcall zhbev_2stage( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             MKL_Complex16* ab, const MKL_INT* ldab, double* w,
                             MKL_Complex16* z, const MKL_INT* ldz,
                             MKL_Complex16* work, const MKL_INT* lwork,
                             double* rwork, MKL_INT* info );
void __stdcall zhbev_2stage_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex16* ab,
                              const MKL_INT* ldab, double* w, MKL_Complex16* z,
                              const MKL_INT* ldz, MKL_Complex16* work,
                              const MKL_INT* lwork, double* rwork,
                              MKL_INT* info );

void __stdcall ZHBEVD_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex16* ab,
                              const MKL_INT* ldab, double* w, MKL_Complex16* z,
                              const MKL_INT* ldz, MKL_Complex16* work,
                              const MKL_INT* lwork, double* rwork,
                              const MKL_INT* lrwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall ZHBEVD_2STAGE_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd,
                               MKL_Complex16* ab, const MKL_INT* ldab,
                               double* w, MKL_Complex16* z, const MKL_INT* ldz,
                               MKL_Complex16* work, const MKL_INT* lwork,
                               double* rwork, const MKL_INT* lrwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );
void __stdcall zhbevd_2stage( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex16* ab,
                              const MKL_INT* ldab, double* w, MKL_Complex16* z,
                              const MKL_INT* ldz, MKL_Complex16* work,
                              const MKL_INT* lwork, double* rwork,
                              const MKL_INT* lrwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall zhbevd_2stage_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd,
                               MKL_Complex16* ab, const MKL_INT* ldab,
                               double* w, MKL_Complex16* z, const MKL_INT* ldz,
                               MKL_Complex16* work, const MKL_INT* lwork,
                               double* rwork, const MKL_INT* lrwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );

void __stdcall ZHBEVX_2STAGE( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex16* ab,
                              const MKL_INT* ldab, MKL_Complex16* q,
                              const MKL_INT* ldq, const double* vl,
                              const double* vu, const MKL_INT* il,
                              const MKL_INT* iu, const double* abstol,
                              MKL_INT* m, double* w, MKL_Complex16* z,
                              const MKL_INT* ldz, MKL_Complex16* work,
                              const MKL_INT* lwork, double* rwork,
                              MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall ZHBEVX_2STAGE_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd,
                               MKL_Complex16* ab, const MKL_INT* ldab,
                               MKL_Complex16* q, const MKL_INT* ldq,
                               const double* vl, const double* vu,
                               const MKL_INT* il, const MKL_INT* iu,
                               const double* abstol, MKL_INT* m, double* w,
                               MKL_Complex16* z, const MKL_INT* ldz,
                               MKL_Complex16* work, const MKL_INT* lwork,
                               double* rwork, MKL_INT* iwork, MKL_INT* ifail,
                               MKL_INT* info );
void __stdcall zhbevx_2stage( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex16* ab,
                              const MKL_INT* ldab, MKL_Complex16* q,
                              const MKL_INT* ldq, const double* vl,
                              const double* vu, const MKL_INT* il,
                              const MKL_INT* iu, const double* abstol,
                              MKL_INT* m, double* w, MKL_Complex16* z,
                              const MKL_INT* ldz, MKL_Complex16* work,
                              const MKL_INT* lwork, double* rwork,
                              MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall zhbevx_2stage_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, const MKL_INT* kd,
                               MKL_Complex16* ab, const MKL_INT* ldab,
                               MKL_Complex16* q, const MKL_INT* ldq,
                               const double* vl, const double* vu,
                               const MKL_INT* il, const MKL_INT* iu,
                               const double* abstol, MKL_INT* m, double* w,
                               MKL_Complex16* z, const MKL_INT* ldz,
                               MKL_Complex16* work, const MKL_INT* lwork,
                               double* rwork, MKL_INT* iwork, MKL_INT* ifail,
                               MKL_INT* info );

void __stdcall ZHEEV_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, double* w,
                             MKL_Complex16* work, const MKL_INT* lwork,
                             double* rwork, MKL_INT* info );
void __stdcall ZHEEV_2STAGE_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                              const MKL_INT* lda, double* w,
                              MKL_Complex16* work, const MKL_INT* lwork,
                              double* rwork, MKL_INT* info );
void __stdcall zheev_2stage( const char* jobz, int jobz_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, double* w,
                             MKL_Complex16* work, const MKL_INT* lwork,
                             double* rwork, MKL_INT* info );
void __stdcall zheev_2stage_( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                              const MKL_INT* lda, double* w,
                              MKL_Complex16* work, const MKL_INT* lwork,
                              double* rwork, MKL_INT* info );

void __stdcall ZHEEVD_2STAGE( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                              const MKL_INT* lda, double* w,
                              MKL_Complex16* work, const MKL_INT* lwork,
                              double* rwork, const MKL_INT* lrwork,
                              MKL_INT* iwork, const MKL_INT* liwork,
                              MKL_INT* info );
void __stdcall ZHEEVD_2STAGE_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex16* a,
                               const MKL_INT* lda, double* w,
                               MKL_Complex16* work, const MKL_INT* lwork,
                               double* rwork, const MKL_INT* lrwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );
void __stdcall zheevd_2stage( const char* jobz, int jobz_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                              const MKL_INT* lda, double* w,
                              MKL_Complex16* work, const MKL_INT* lwork,
                              double* rwork, const MKL_INT* lrwork,
                              MKL_INT* iwork, const MKL_INT* liwork,
                              MKL_INT* info );
void __stdcall zheevd_2stage_( const char* jobz, int jobz_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex16* a,
                               const MKL_INT* lda, double* w,
                               MKL_Complex16* work, const MKL_INT* lwork,
                               double* rwork, const MKL_INT* lrwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );

void __stdcall ZHEEVR_2STAGE( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              MKL_Complex16* a, const MKL_INT* lda,
                              const double* vl, const double* vu,
                              const MKL_INT* il, const MKL_INT* iu,
                              const double* abstol, MKL_INT* m, double* w,
                              MKL_Complex16* z, const MKL_INT* ldz,
                              MKL_INT* isuppz, MKL_Complex16* work,
                              const MKL_INT* lwork, double* rwork,
                              const MKL_INT* lrwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall ZHEEVR_2STAGE_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex16* a,
                               const MKL_INT* lda, const double* vl,
                               const double* vu, const MKL_INT* il,
                               const MKL_INT* iu, const double* abstol,
                               MKL_INT* m, double* w, MKL_Complex16* z,
                               const MKL_INT* ldz, MKL_INT* isuppz,
                               MKL_Complex16* work, const MKL_INT* lwork,
                               double* rwork, const MKL_INT* lrwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );
void __stdcall zheevr_2stage( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              MKL_Complex16* a, const MKL_INT* lda,
                              const double* vl, const double* vu,
                              const MKL_INT* il, const MKL_INT* iu,
                              const double* abstol, MKL_INT* m, double* w,
                              MKL_Complex16* z, const MKL_INT* ldz,
                              MKL_INT* isuppz, MKL_Complex16* work,
                              const MKL_INT* lwork, double* rwork,
                              const MKL_INT* lrwork, MKL_INT* iwork,
                              const MKL_INT* liwork, MKL_INT* info );
void __stdcall zheevr_2stage_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex16* a,
                               const MKL_INT* lda, const double* vl,
                               const double* vu, const MKL_INT* il,
                               const MKL_INT* iu, const double* abstol,
                               MKL_INT* m, double* w, MKL_Complex16* z,
                               const MKL_INT* ldz, MKL_INT* isuppz,
                               MKL_Complex16* work, const MKL_INT* lwork,
                               double* rwork, const MKL_INT* lrwork,
                               MKL_INT* iwork, const MKL_INT* liwork,
                               MKL_INT* info );

void __stdcall ZHEEVX_2STAGE( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              MKL_Complex16* a, const MKL_INT* lda,
                              const double* vl, const double* vu,
                              const MKL_INT* il, const MKL_INT* iu,
                              const double* abstol, MKL_INT* m, double* w,
                              MKL_Complex16* z, const MKL_INT* ldz,
                              MKL_Complex16* work, const MKL_INT* lwork,
                              double* rwork, MKL_INT* iwork, MKL_INT* ifail,
                              MKL_INT* info );
void __stdcall ZHEEVX_2STAGE_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex16* a,
                               const MKL_INT* lda, const double* vl,
                               const double* vu, const MKL_INT* il,
                               const MKL_INT* iu, const double* abstol,
                               MKL_INT* m, double* w, MKL_Complex16* z,
                               const MKL_INT* ldz, MKL_Complex16* work,
                               const MKL_INT* lwork, double* rwork,
                               MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall zheevx_2stage( const char* jobz, int jobz_len,
                              const char* range, int range_len,
                              const char* uplo, int uplo_len, const MKL_INT* n,
                              MKL_Complex16* a, const MKL_INT* lda,
                              const double* vl, const double* vu,
                              const MKL_INT* il, const MKL_INT* iu,
                              const double* abstol, MKL_INT* m, double* w,
                              MKL_Complex16* z, const MKL_INT* ldz,
                              MKL_Complex16* work, const MKL_INT* lwork,
                              double* rwork, MKL_INT* iwork, MKL_INT* ifail,
                              MKL_INT* info );
void __stdcall zheevx_2stage_( const char* jobz, int jobz_len,
                               const char* range, int range_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex16* a,
                               const MKL_INT* lda, const double* vl,
                               const double* vu, const MKL_INT* il,
                               const MKL_INT* iu, const double* abstol,
                               MKL_INT* m, double* w, MKL_Complex16* z,
                               const MKL_INT* ldz, MKL_Complex16* work,
                               const MKL_INT* lwork, double* rwork,
                               MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void __stdcall ZHEGV_2STAGE( const MKL_INT* itype, const char* jobz,
                             int jobz_len, const char* uplo, int uplo_len,
                             const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_Complex16* b,
                             const MKL_INT* ldb, double* w,
                             MKL_Complex16* work, const MKL_INT* lwork,
                             double* rwork, MKL_INT* info );
void __stdcall ZHEGV_2STAGE_( const MKL_INT* itype, const char* jobz,
                              int jobz_len, const char* uplo, int uplo_len,
                              const MKL_INT* n, MKL_Complex16* a,
                              const MKL_INT* lda, MKL_Complex16* b,
                              const MKL_INT* ldb, double* w,
                              MKL_Complex16* work, const MKL_INT* lwork,
                              double* rwork, MKL_INT* info );
void __stdcall zhegv_2stage( const MKL_INT* itype, const char* jobz,
                             int jobz_len, const char* uplo, int uplo_len,
                             const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_Complex16* b,
                             const MKL_INT* ldb, double* w,
                             MKL_Complex16* work, const MKL_INT* lwork,
                             double* rwork, MKL_INT* info );
void __stdcall zhegv_2stage_( const MKL_INT* itype, const char* jobz,
                              int jobz_len, const char* uplo, int uplo_len,
                              const MKL_INT* n, MKL_Complex16* a,
                              const MKL_INT* lda, MKL_Complex16* b,
                              const MKL_INT* ldb, double* w,
                              MKL_Complex16* work, const MKL_INT* lwork,
                              double* rwork, MKL_INT* info );

void __stdcall ZHETRD_2STAGE( const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                              const MKL_INT* lda, double* d, double* e,
                              MKL_Complex16* tau, MKL_Complex16* hous2,
                              const MKL_INT* lhous2, MKL_Complex16* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZHETRD_2STAGE_( const char* vect, int vect_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex16* a,
                               const MKL_INT* lda, double* d, double* e,
                               MKL_Complex16* tau, MKL_Complex16* hous2,
                               const MKL_INT* lhous2, MKL_Complex16* work,
                               const MKL_INT* lwork, MKL_INT* info );
void __stdcall zhetrd_2stage( const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                              const MKL_INT* lda, double* d, double* e,
                              MKL_Complex16* tau, MKL_Complex16* hous2,
                              const MKL_INT* lhous2, MKL_Complex16* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall zhetrd_2stage_( const char* vect, int vect_len,
                               const char* uplo, int uplo_len,
                               const MKL_INT* n, MKL_Complex16* a,
                               const MKL_INT* lda, double* d, double* e,
                               MKL_Complex16* tau, MKL_Complex16* hous2,
                               const MKL_INT* lhous2, MKL_Complex16* work,
                               const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZHETRD_HB2ST( const char* stage1, int stage1_len,
                             const char* vect, int vect_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             MKL_Complex16* ab, const MKL_INT* ldab, double* d,
                             double* e, MKL_Complex16* hous,
                             const MKL_INT* lhous, MKL_Complex16* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZHETRD_HB2ST_( const char* stage1, int stage1_len,
                              const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex16* ab,
                              const MKL_INT* ldab, double* d, double* e,
                              MKL_Complex16* hous, const MKL_INT* lhous,
                              MKL_Complex16* work, const MKL_INT* lwork,
                              MKL_INT* info );
void __stdcall zhetrd_hb2st( const char* stage1, int stage1_len,
                             const char* vect, int vect_len, const char* uplo,
                             int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                             MKL_Complex16* ab, const MKL_INT* ldab, double* d,
                             double* e, MKL_Complex16* hous,
                             const MKL_INT* lhous, MKL_Complex16* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall zhetrd_hb2st_( const char* stage1, int stage1_len,
                              const char* vect, int vect_len, const char* uplo,
                              int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex16* ab,
                              const MKL_INT* ldab, double* d, double* e,
                              MKL_Complex16* hous, const MKL_INT* lhous,
                              MKL_Complex16* work, const MKL_INT* lwork,
                              MKL_INT* info );

void __stdcall ZHETRD_HE2HB( const char* uplo, int uplo_len, const MKL_INT* n,
                             const MKL_INT* kd, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_Complex16* ab,
                             const MKL_INT* ldab, MKL_Complex16* tau,
                             MKL_Complex16* work, const MKL_INT* lwork,
                             MKL_INT* info );
void __stdcall ZHETRD_HE2HB_( const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex16* a,
                              const MKL_INT* lda, MKL_Complex16* ab,
                              const MKL_INT* ldab, MKL_Complex16* tau,
                              MKL_Complex16* work, const MKL_INT* lwork,
                              MKL_INT* info );
void __stdcall zhetrd_he2hb( const char* uplo, int uplo_len, const MKL_INT* n,
                             const MKL_INT* kd, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_Complex16* ab,
                             const MKL_INT* ldab, MKL_Complex16* tau,
                             MKL_Complex16* work, const MKL_INT* lwork,
                             MKL_INT* info );
void __stdcall zhetrd_he2hb_( const char* uplo, int uplo_len, const MKL_INT* n,
                              const MKL_INT* kd, MKL_Complex16* a,
                              const MKL_INT* lda, MKL_Complex16* ab,
                              const MKL_INT* ldab, MKL_Complex16* tau,
                              MKL_Complex16* work, const MKL_INT* lwork,
                              MKL_INT* info );

void __stdcall MKL_CGETRFNP( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_INT* info );
void __stdcall MKL_CGETRFNP_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, MKL_INT* info );
void __stdcall mkl_cgetrfnp( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_INT* info );
void __stdcall mkl_cgetrfnp_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, MKL_INT* info );

void __stdcall MKL_DGETRFNP( const MKL_INT* m, const MKL_INT* n, double* a,
                             const MKL_INT* lda, MKL_INT* info );
void __stdcall MKL_DGETRFNP_( const MKL_INT* m, const MKL_INT* n, double* a,
                              const MKL_INT* lda, MKL_INT* info );
void __stdcall mkl_dgetrfnp( const MKL_INT* m, const MKL_INT* n, double* a,
                             const MKL_INT* lda, MKL_INT* info );
void __stdcall mkl_dgetrfnp_( const MKL_INT* m, const MKL_INT* n, double* a,
                              const MKL_INT* lda, MKL_INT* info );

void __stdcall MKL_SGETRFNP( const MKL_INT* m, const MKL_INT* n, float* a,
                             const MKL_INT* lda, MKL_INT* info );
void __stdcall MKL_SGETRFNP_( const MKL_INT* m, const MKL_INT* n, float* a,
                              const MKL_INT* lda, MKL_INT* info );
void __stdcall mkl_sgetrfnp( const MKL_INT* m, const MKL_INT* n, float* a,
                             const MKL_INT* lda, MKL_INT* info );
void __stdcall mkl_sgetrfnp_( const MKL_INT* m, const MKL_INT* n, float* a,
                              const MKL_INT* lda, MKL_INT* info );

void __stdcall MKL_ZGETRFNP( const MKL_INT* m, const MKL_INT* n,
                             MKL_Complex16* a, const MKL_INT* lda,
                             MKL_INT* info );
void __stdcall MKL_ZGETRFNP_( const MKL_INT* m, const MKL_INT* n,
                              MKL_Complex16* a, const MKL_INT* lda,
                              MKL_INT* info );
void __stdcall mkl_zgetrfnp( const MKL_INT* m, const MKL_INT* n,
                             MKL_Complex16* a, const MKL_INT* lda,
                             MKL_INT* info );
void __stdcall mkl_zgetrfnp_( const MKL_INT* m, const MKL_INT* n,
                              MKL_Complex16* a, const MKL_INT* lda,
                              MKL_INT* info );

void __stdcall MKL_CGETRINP( const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_Complex8* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall MKL_CGETRINP_( const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, MKL_Complex8* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall mkl_cgetrinp( const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_Complex8* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall mkl_cgetrinp_( const MKL_INT* n, MKL_Complex8* a,
                              const MKL_INT* lda, MKL_Complex8* work,
                              const MKL_INT* lwork, MKL_INT* info );

void __stdcall MKL_DGETRINP( const MKL_INT* n, double* a, const MKL_INT* lda,
                             double* work, const MKL_INT* lwork,
                             MKL_INT* info );
void __stdcall MKL_DGETRINP_( const MKL_INT* n, double* a, const MKL_INT* lda,
                              double* work, const MKL_INT* lwork,
                              MKL_INT* info );
void __stdcall mkl_dgetrinp( const MKL_INT* n, double* a, const MKL_INT* lda,
                             double* work, const MKL_INT* lwork,
                             MKL_INT* info );
void __stdcall mkl_dgetrinp_( const MKL_INT* n, double* a, const MKL_INT* lda,
                              double* work, const MKL_INT* lwork,
                              MKL_INT* info );

void __stdcall MKL_SGETRINP( const MKL_INT* n, float* a, const MKL_INT* lda,
                             float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall MKL_SGETRINP_( const MKL_INT* n, float* a, const MKL_INT* lda,
                              float* work, const MKL_INT* lwork,
                              MKL_INT* info );
void __stdcall mkl_sgetrinp( const MKL_INT* n, float* a, const MKL_INT* lda,
                             float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall mkl_sgetrinp_( const MKL_INT* n, float* a, const MKL_INT* lda,
                              float* work, const MKL_INT* lwork,
                              MKL_INT* info );

void __stdcall MKL_ZGETRINP( const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_Complex16* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall MKL_ZGETRINP_( const MKL_INT* n, MKL_Complex16* a,
                              const MKL_INT* lda, MKL_Complex16* work,
                              const MKL_INT* lwork, MKL_INT* info );
void __stdcall mkl_zgetrinp( const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_Complex16* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall mkl_zgetrinp_( const MKL_INT* n, MKL_Complex16* a,
                              const MKL_INT* lda, MKL_Complex16* work,
                              const MKL_INT* lwork, MKL_INT* info );

void __stdcall DSYTRF_AA_2STAGE( const char* uplo, int uplo_len,
                                 const MKL_INT* n, double* a,
                                 const MKL_INT* lda, double* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, double* work,
                                 const MKL_INT* lwork, MKL_INT* info );
void __stdcall DSYTRF_AA_2STAGE_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, double* a,
                                  const MKL_INT* lda, double* tb,
                                  const MKL_INT* ltb, MKL_INT* ipiv,
                                  MKL_INT* ipiv2, double* work,
                                  const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsytrf_aa_2stage( const char* uplo, int uplo_len,
                                 const MKL_INT* n, double* a,
                                 const MKL_INT* lda, double* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, double* work,
                                 const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsytrf_aa_2stage_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, double* a,
                                  const MKL_INT* lda, double* tb,
                                  const MKL_INT* ltb, MKL_INT* ipiv,
                                  MKL_INT* ipiv2, double* work,
                                  const MKL_INT* lwork, MKL_INT* info );

void __stdcall CHESV_AA_2STAGE( const char* uplo, int uplo_len,
                                const MKL_INT* n, const MKL_INT* nrhs,
                                MKL_Complex8* a, const MKL_INT* lda,
                                MKL_Complex8* tb, const MKL_INT* ltb,
                                MKL_INT* ipiv, MKL_INT* ipiv2, MKL_Complex8* b,
                                const MKL_INT* ldb, MKL_Complex8* work,
                                const MKL_INT* lwork, MKL_INT* info );
void __stdcall CHESV_AA_2STAGE_( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 MKL_Complex8* a, const MKL_INT* lda,
                                 MKL_Complex8* tb, const MKL_INT* ltb,
                                 MKL_INT* ipiv, MKL_INT* ipiv2,
                                 MKL_Complex8* b, const MKL_INT* ldb,
                                 MKL_Complex8* work, const MKL_INT* lwork,
                                 MKL_INT* info );
void __stdcall chesv_aa_2stage( const char* uplo, int uplo_len,
                                const MKL_INT* n, const MKL_INT* nrhs,
                                MKL_Complex8* a, const MKL_INT* lda,
                                MKL_Complex8* tb, const MKL_INT* ltb,
                                MKL_INT* ipiv, MKL_INT* ipiv2, MKL_Complex8* b,
                                const MKL_INT* ldb, MKL_Complex8* work,
                                const MKL_INT* lwork, MKL_INT* info );
void __stdcall chesv_aa_2stage_( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 MKL_Complex8* a, const MKL_INT* lda,
                                 MKL_Complex8* tb, const MKL_INT* ltb,
                                 MKL_INT* ipiv, MKL_INT* ipiv2,
                                 MKL_Complex8* b, const MKL_INT* ldb,
                                 MKL_Complex8* work, const MKL_INT* lwork,
                                 MKL_INT* info );

void __stdcall CHETRF_AA_2STAGE( const char* uplo, int uplo_len,
                                 const MKL_INT* n, MKL_Complex8* a,
                                 const MKL_INT* lda, MKL_Complex8* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, MKL_Complex8* work,
                                 const MKL_INT* lwork, MKL_INT* info );
void __stdcall CHETRF_AA_2STAGE_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, MKL_Complex8* a,
                                  const MKL_INT* lda, MKL_Complex8* tb,
                                  const MKL_INT* ltb, MKL_INT* ipiv,
                                  MKL_INT* ipiv2, MKL_Complex8* work,
                                  const MKL_INT* lwork, MKL_INT* info );
void __stdcall chetrf_aa_2stage( const char* uplo, int uplo_len,
                                 const MKL_INT* n, MKL_Complex8* a,
                                 const MKL_INT* lda, MKL_Complex8* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, MKL_Complex8* work,
                                 const MKL_INT* lwork, MKL_INT* info );
void __stdcall chetrf_aa_2stage_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, MKL_Complex8* a,
                                  const MKL_INT* lda, MKL_Complex8* tb,
                                  const MKL_INT* ltb, MKL_INT* ipiv,
                                  MKL_INT* ipiv2, MKL_Complex8* work,
                                  const MKL_INT* lwork, MKL_INT* info );

void __stdcall CHETRS_AA_2STAGE( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 const MKL_Complex8* a, const MKL_INT* lda,
                                 MKL_Complex8* tb, const MKL_INT* ltb,
                                 const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                 MKL_Complex8* b, const MKL_INT* ldb,
                                 MKL_INT* info );
void __stdcall CHETRS_AA_2STAGE_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, const MKL_INT* nrhs,
                                  const MKL_Complex8* a, const MKL_INT* lda,
                                  MKL_Complex8* tb, const MKL_INT* ltb,
                                  const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                  MKL_Complex8* b, const MKL_INT* ldb,
                                  MKL_INT* info );
void __stdcall chetrs_aa_2stage( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 const MKL_Complex8* a, const MKL_INT* lda,
                                 MKL_Complex8* tb, const MKL_INT* ltb,
                                 const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                 MKL_Complex8* b, const MKL_INT* ldb,
                                 MKL_INT* info );
void __stdcall chetrs_aa_2stage_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, const MKL_INT* nrhs,
                                  const MKL_Complex8* a, const MKL_INT* lda,
                                  MKL_Complex8* tb, const MKL_INT* ltb,
                                  const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                  MKL_Complex8* b, const MKL_INT* ldb,
                                  MKL_INT* info );

void __stdcall CSYSV_AA_2STAGE( const char* uplo, int uplo_len,
                                const MKL_INT* n, const MKL_INT* nrhs,
                                MKL_Complex8* a, const MKL_INT* lda,
                                MKL_Complex8* tb, const MKL_INT* ltb,
                                MKL_INT* ipiv, MKL_INT* ipiv2, MKL_Complex8* b,
                                const MKL_INT* ldb, MKL_Complex8* work,
                                const MKL_INT* lwork, MKL_INT* info );
void __stdcall CSYSV_AA_2STAGE_( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 MKL_Complex8* a, const MKL_INT* lda,
                                 MKL_Complex8* tb, const MKL_INT* ltb,
                                 MKL_INT* ipiv, MKL_INT* ipiv2,
                                 MKL_Complex8* b, const MKL_INT* ldb,
                                 MKL_Complex8* work, const MKL_INT* lwork,
                                 MKL_INT* info );
void __stdcall csysv_aa_2stage( const char* uplo, int uplo_len,
                                const MKL_INT* n, const MKL_INT* nrhs,
                                MKL_Complex8* a, const MKL_INT* lda,
                                MKL_Complex8* tb, const MKL_INT* ltb,
                                MKL_INT* ipiv, MKL_INT* ipiv2, MKL_Complex8* b,
                                const MKL_INT* ldb, MKL_Complex8* work,
                                const MKL_INT* lwork, MKL_INT* info );
void __stdcall csysv_aa_2stage_( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 MKL_Complex8* a, const MKL_INT* lda,
                                 MKL_Complex8* tb, const MKL_INT* ltb,
                                 MKL_INT* ipiv, MKL_INT* ipiv2,
                                 MKL_Complex8* b, const MKL_INT* ldb,
                                 MKL_Complex8* work, const MKL_INT* lwork,
                                 MKL_INT* info );

void __stdcall CSYTRF_AA_2STAGE( const char* uplo, int uplo_len,
                                 const MKL_INT* n, MKL_Complex8* a,
                                 const MKL_INT* lda, MKL_Complex8* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, MKL_Complex8* work,
                                 const MKL_INT* lwork, MKL_INT* info );
void __stdcall CSYTRF_AA_2STAGE_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, MKL_Complex8* a,
                                  const MKL_INT* lda, MKL_Complex8* tb,
                                  const MKL_INT* ltb, MKL_INT* ipiv,
                                  MKL_INT* ipiv2, MKL_Complex8* work,
                                  const MKL_INT* lwork, MKL_INT* info );
void __stdcall csytrf_aa_2stage( const char* uplo, int uplo_len,
                                 const MKL_INT* n, MKL_Complex8* a,
                                 const MKL_INT* lda, MKL_Complex8* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, MKL_Complex8* work,
                                 const MKL_INT* lwork, MKL_INT* info );
void __stdcall csytrf_aa_2stage_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, MKL_Complex8* a,
                                  const MKL_INT* lda, MKL_Complex8* tb,
                                  const MKL_INT* ltb, MKL_INT* ipiv,
                                  MKL_INT* ipiv2, MKL_Complex8* work,
                                  const MKL_INT* lwork, MKL_INT* info );

void __stdcall CSYTRS_AA_2STAGE( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 const MKL_Complex8* a, const MKL_INT* lda,
                                 MKL_Complex8* tb, const MKL_INT* ltb,
                                 const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                 MKL_Complex8* b, const MKL_INT* ldb,
                                 MKL_INT* info );
void __stdcall CSYTRS_AA_2STAGE_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, const MKL_INT* nrhs,
                                  const MKL_Complex8* a, const MKL_INT* lda,
                                  MKL_Complex8* tb, const MKL_INT* ltb,
                                  const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                  MKL_Complex8* b, const MKL_INT* ldb,
                                  MKL_INT* info );
void __stdcall csytrs_aa_2stage( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 const MKL_Complex8* a, const MKL_INT* lda,
                                 MKL_Complex8* tb, const MKL_INT* ltb,
                                 const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                 MKL_Complex8* b, const MKL_INT* ldb,
                                 MKL_INT* info );
void __stdcall csytrs_aa_2stage_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, const MKL_INT* nrhs,
                                  const MKL_Complex8* a, const MKL_INT* lda,
                                  MKL_Complex8* tb, const MKL_INT* ltb,
                                  const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                  MKL_Complex8* b, const MKL_INT* ldb,
                                  MKL_INT* info );

void __stdcall ZHESV_AA_2STAGE( const char* uplo, int uplo_len,
                                const MKL_INT* n, const MKL_INT* nrhs,
                                MKL_Complex16* a, const MKL_INT* lda,
                                MKL_Complex16* tb, const MKL_INT* ltb,
                                MKL_INT* ipiv, MKL_INT* ipiv2,
                                MKL_Complex16* b, const MKL_INT* ldb,
                                MKL_Complex16* work, const MKL_INT* lwork,
                                MKL_INT* info );
void __stdcall ZHESV_AA_2STAGE_( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 MKL_Complex16* a, const MKL_INT* lda,
                                 MKL_Complex16* tb, const MKL_INT* ltb,
                                 MKL_INT* ipiv, MKL_INT* ipiv2,
                                 MKL_Complex16* b, const MKL_INT* ldb,
                                 MKL_Complex16* work, const MKL_INT* lwork,
                                 MKL_INT* info );
void __stdcall zhesv_aa_2stage( const char* uplo, int uplo_len,
                                const MKL_INT* n, const MKL_INT* nrhs,
                                MKL_Complex16* a, const MKL_INT* lda,
                                MKL_Complex16* tb, const MKL_INT* ltb,
                                MKL_INT* ipiv, MKL_INT* ipiv2,
                                MKL_Complex16* b, const MKL_INT* ldb,
                                MKL_Complex16* work, const MKL_INT* lwork,
                                MKL_INT* info );
void __stdcall zhesv_aa_2stage_( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 MKL_Complex16* a, const MKL_INT* lda,
                                 MKL_Complex16* tb, const MKL_INT* ltb,
                                 MKL_INT* ipiv, MKL_INT* ipiv2,
                                 MKL_Complex16* b, const MKL_INT* ldb,
                                 MKL_Complex16* work, const MKL_INT* lwork,
                                 MKL_INT* info );

void __stdcall ZHETRF_AA_2STAGE( const char* uplo, int uplo_len,
                                 const MKL_INT* n, MKL_Complex16* a,
                                 const MKL_INT* lda, MKL_Complex16* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, MKL_Complex16* work,
                                 const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZHETRF_AA_2STAGE_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, MKL_Complex16* a,
                                  const MKL_INT* lda, MKL_Complex16* tb,
                                  const MKL_INT* ltb, MKL_INT* ipiv,
                                  MKL_INT* ipiv2, MKL_Complex16* work,
                                  const MKL_INT* lwork, MKL_INT* info );
void __stdcall zhetrf_aa_2stage( const char* uplo, int uplo_len,
                                 const MKL_INT* n, MKL_Complex16* a,
                                 const MKL_INT* lda, MKL_Complex16* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, MKL_Complex16* work,
                                 const MKL_INT* lwork, MKL_INT* info );
void __stdcall zhetrf_aa_2stage_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, MKL_Complex16* a,
                                  const MKL_INT* lda, MKL_Complex16* tb,
                                  const MKL_INT* ltb, MKL_INT* ipiv,
                                  MKL_INT* ipiv2, MKL_Complex16* work,
                                  const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZHETRS_AA_2STAGE( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 const MKL_Complex16* a, const MKL_INT* lda,
                                 MKL_Complex16* tb, const MKL_INT* ltb,
                                 const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                 MKL_Complex16* b, const MKL_INT* ldb,
                                 MKL_INT* info );
void __stdcall ZHETRS_AA_2STAGE_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, const MKL_INT* nrhs,
                                  const MKL_Complex16* a, const MKL_INT* lda,
                                  MKL_Complex16* tb, const MKL_INT* ltb,
                                  const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                  MKL_Complex16* b, const MKL_INT* ldb,
                                  MKL_INT* info );
void __stdcall zhetrs_aa_2stage( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 const MKL_Complex16* a, const MKL_INT* lda,
                                 MKL_Complex16* tb, const MKL_INT* ltb,
                                 const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                 MKL_Complex16* b, const MKL_INT* ldb,
                                 MKL_INT* info );
void __stdcall zhetrs_aa_2stage_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, const MKL_INT* nrhs,
                                  const MKL_Complex16* a, const MKL_INT* lda,
                                  MKL_Complex16* tb, const MKL_INT* ltb,
                                  const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                  MKL_Complex16* b, const MKL_INT* ldb,
                                  MKL_INT* info );

void __stdcall ZSYSV_AA_2STAGE( const char* uplo, int uplo_len,
                                const MKL_INT* n, const MKL_INT* nrhs,
                                MKL_Complex16* a, const MKL_INT* lda,
                                MKL_Complex16* tb, const MKL_INT* ltb,
                                MKL_INT* ipiv, MKL_INT* ipiv2,
                                MKL_Complex16* b, const MKL_INT* ldb,
                                MKL_Complex16* work, const MKL_INT* lwork,
                                MKL_INT* info );
void __stdcall ZSYSV_AA_2STAGE_( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 MKL_Complex16* a, const MKL_INT* lda,
                                 MKL_Complex16* tb, const MKL_INT* ltb,
                                 MKL_INT* ipiv, MKL_INT* ipiv2,
                                 MKL_Complex16* b, const MKL_INT* ldb,
                                 MKL_Complex16* work, const MKL_INT* lwork,
                                 MKL_INT* info );
void __stdcall zsysv_aa_2stage( const char* uplo, int uplo_len,
                                const MKL_INT* n, const MKL_INT* nrhs,
                                MKL_Complex16* a, const MKL_INT* lda,
                                MKL_Complex16* tb, const MKL_INT* ltb,
                                MKL_INT* ipiv, MKL_INT* ipiv2,
                                MKL_Complex16* b, const MKL_INT* ldb,
                                MKL_Complex16* work, const MKL_INT* lwork,
                                MKL_INT* info );
void __stdcall zsysv_aa_2stage_( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 MKL_Complex16* a, const MKL_INT* lda,
                                 MKL_Complex16* tb, const MKL_INT* ltb,
                                 MKL_INT* ipiv, MKL_INT* ipiv2,
                                 MKL_Complex16* b, const MKL_INT* ldb,
                                 MKL_Complex16* work, const MKL_INT* lwork,
                                 MKL_INT* info );

void __stdcall ZSYTRF_AA_2STAGE( const char* uplo, int uplo_len,
                                 const MKL_INT* n, MKL_Complex16* a,
                                 const MKL_INT* lda, MKL_Complex16* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, MKL_Complex16* work,
                                 const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZSYTRF_AA_2STAGE_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, MKL_Complex16* a,
                                  const MKL_INT* lda, MKL_Complex16* tb,
                                  const MKL_INT* ltb, MKL_INT* ipiv,
                                  MKL_INT* ipiv2, MKL_Complex16* work,
                                  const MKL_INT* lwork, MKL_INT* info );
void __stdcall zsytrf_aa_2stage( const char* uplo, int uplo_len,
                                 const MKL_INT* n, MKL_Complex16* a,
                                 const MKL_INT* lda, MKL_Complex16* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, MKL_Complex16* work,
                                 const MKL_INT* lwork, MKL_INT* info );
void __stdcall zsytrf_aa_2stage_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, MKL_Complex16* a,
                                  const MKL_INT* lda, MKL_Complex16* tb,
                                  const MKL_INT* ltb, MKL_INT* ipiv,
                                  MKL_INT* ipiv2, MKL_Complex16* work,
                                  const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZSYTRS_AA_2STAGE( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 const MKL_Complex16* a, const MKL_INT* lda,
                                 MKL_Complex16* tb, const MKL_INT* ltb,
                                 const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                 MKL_Complex16* b, const MKL_INT* ldb,
                                 MKL_INT* info );
void __stdcall ZSYTRS_AA_2STAGE_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, const MKL_INT* nrhs,
                                  const MKL_Complex16* a, const MKL_INT* lda,
                                  MKL_Complex16* tb, const MKL_INT* ltb,
                                  const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                  MKL_Complex16* b, const MKL_INT* ldb,
                                  MKL_INT* info );
void __stdcall zsytrs_aa_2stage( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 const MKL_Complex16* a, const MKL_INT* lda,
                                 MKL_Complex16* tb, const MKL_INT* ltb,
                                 const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                 MKL_Complex16* b, const MKL_INT* ldb,
                                 MKL_INT* info );
void __stdcall zsytrs_aa_2stage_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, const MKL_INT* nrhs,
                                  const MKL_Complex16* a, const MKL_INT* lda,
                                  MKL_Complex16* tb, const MKL_INT* ltb,
                                  const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                  MKL_Complex16* b, const MKL_INT* ldb,
                                  MKL_INT* info );

void __stdcall DSYTRS_AA_2STAGE( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 const double* a, const MKL_INT* lda,
                                 double* tb, const MKL_INT* ltb,
                                 const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                 double* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall DSYTRS_AA_2STAGE_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, const MKL_INT* nrhs,
                                  const double* a, const MKL_INT* lda,
                                  double* tb, const MKL_INT* ltb,
                                  const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                  double* b, const MKL_INT* ldb,
                                  MKL_INT* info );
void __stdcall dsytrs_aa_2stage( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 const double* a, const MKL_INT* lda,
                                 double* tb, const MKL_INT* ltb,
                                 const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                 double* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall dsytrs_aa_2stage_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, const MKL_INT* nrhs,
                                  const double* a, const MKL_INT* lda,
                                  double* tb, const MKL_INT* ltb,
                                  const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                  double* b, const MKL_INT* ldb,
                                  MKL_INT* info );

void __stdcall DSYSV_AA_2STAGE( const char* uplo, int uplo_len,
                                const MKL_INT* n, const MKL_INT* nrhs,
                                double* a, const MKL_INT* lda, double* tb,
                                const MKL_INT* ltb, MKL_INT* ipiv,
                                MKL_INT* ipiv2, double* b, const MKL_INT* ldb,
                                double* work, const MKL_INT* lwork,
                                MKL_INT* info );
void __stdcall DSYSV_AA_2STAGE_( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 double* a, const MKL_INT* lda, double* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, double* b, const MKL_INT* ldb,
                                 double* work, const MKL_INT* lwork,
                                 MKL_INT* info );
void __stdcall dsysv_aa_2stage( const char* uplo, int uplo_len,
                                const MKL_INT* n, const MKL_INT* nrhs,
                                double* a, const MKL_INT* lda, double* tb,
                                const MKL_INT* ltb, MKL_INT* ipiv,
                                MKL_INT* ipiv2, double* b, const MKL_INT* ldb,
                                double* work, const MKL_INT* lwork,
                                MKL_INT* info );
void __stdcall dsysv_aa_2stage_( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 double* a, const MKL_INT* lda, double* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, double* b, const MKL_INT* ldb,
                                 double* work, const MKL_INT* lwork,
                                 MKL_INT* info );

void __stdcall SSYSV_AA_2STAGE( const char* uplo, int uplo_len,
                                const MKL_INT* n, const MKL_INT* nrhs,
                                float* a, const MKL_INT* lda, float* tb,
                                const MKL_INT* ltb, MKL_INT* ipiv,
                                MKL_INT* ipiv2, float* b, const MKL_INT* ldb,
                                float* work, const MKL_INT* lwork,
                                MKL_INT* info );
void __stdcall SSYSV_AA_2STAGE_( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 float* a, const MKL_INT* lda, float* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, float* b, const MKL_INT* ldb,
                                 float* work, const MKL_INT* lwork,
                                 MKL_INT* info );
void __stdcall ssysv_aa_2stage( const char* uplo, int uplo_len,
                                const MKL_INT* n, const MKL_INT* nrhs,
                                float* a, const MKL_INT* lda, float* tb,
                                const MKL_INT* ltb, MKL_INT* ipiv,
                                MKL_INT* ipiv2, float* b, const MKL_INT* ldb,
                                float* work, const MKL_INT* lwork,
                                MKL_INT* info );
void __stdcall ssysv_aa_2stage_( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 float* a, const MKL_INT* lda, float* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, float* b, const MKL_INT* ldb,
                                 float* work, const MKL_INT* lwork,
                                 MKL_INT* info );

void __stdcall SSYTRS_AA_2STAGE( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 const float* a, const MKL_INT* lda, float* tb,
                                 const MKL_INT* ltb, const MKL_INT* ipiv,
                                 const MKL_INT* ipiv2, float* b,
                                 const MKL_INT* ldb, MKL_INT* info );
void __stdcall SSYTRS_AA_2STAGE_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, const MKL_INT* nrhs,
                                  const float* a, const MKL_INT* lda,
                                  float* tb, const MKL_INT* ltb,
                                  const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                  float* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall ssytrs_aa_2stage( const char* uplo, int uplo_len,
                                 const MKL_INT* n, const MKL_INT* nrhs,
                                 const float* a, const MKL_INT* lda, float* tb,
                                 const MKL_INT* ltb, const MKL_INT* ipiv,
                                 const MKL_INT* ipiv2, float* b,
                                 const MKL_INT* ldb, MKL_INT* info );
void __stdcall ssytrs_aa_2stage_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, const MKL_INT* nrhs,
                                  const float* a, const MKL_INT* lda,
                                  float* tb, const MKL_INT* ltb,
                                  const MKL_INT* ipiv, const MKL_INT* ipiv2,
                                  float* b, const MKL_INT* ldb, MKL_INT* info );

void __stdcall SSYTRF_AA_2STAGE( const char* uplo, int uplo_len,
                                 const MKL_INT* n, float* a,
                                 const MKL_INT* lda, float* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, float* work,
                                 const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSYTRF_AA_2STAGE_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, float* a,
                                  const MKL_INT* lda, float* tb,
                                  const MKL_INT* ltb, MKL_INT* ipiv,
                                  MKL_INT* ipiv2, float* work,
                                  const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytrf_aa_2stage( const char* uplo, int uplo_len,
                                 const MKL_INT* n, float* a,
                                 const MKL_INT* lda, float* tb,
                                 const MKL_INT* ltb, MKL_INT* ipiv,
                                 MKL_INT* ipiv2, float* work,
                                 const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytrf_aa_2stage_( const char* uplo, int uplo_len,
                                  const MKL_INT* n, float* a,
                                  const MKL_INT* lda, float* tb,
                                  const MKL_INT* ltb, MKL_INT* ipiv,
                                  MKL_INT* ipiv2, float* work,
                                  const MKL_INT* lwork, MKL_INT* info );

void __stdcall DTREVC3( const char* side, int side_len, const char* howmny,
                        int howmny_len, MKL_INT* select, const MKL_INT* n,
                        const double* t, const MKL_INT* ldt, double* vl,
                        const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
                        const MKL_INT* mm, MKL_INT* m, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall DTREVC3_( const char* side, int side_len, const char* howmny,
                         int howmny_len, MKL_INT* select, const MKL_INT* n,
                         const double* t, const MKL_INT* ldt, double* vl,
                         const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
                         const MKL_INT* mm, MKL_INT* m, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall dtrevc3( const char* side, int side_len, const char* howmny,
                        int howmny_len, MKL_INT* select, const MKL_INT* n,
                        const double* t, const MKL_INT* ldt, double* vl,
                        const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
                        const MKL_INT* mm, MKL_INT* m, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall dtrevc3_( const char* side, int side_len, const char* howmny,
                         int howmny_len, MKL_INT* select, const MKL_INT* n,
                         const double* t, const MKL_INT* ldt, double* vl,
                         const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
                         const MKL_INT* mm, MKL_INT* m, double* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall STREVC3( const char* side, int side_len, const char* howmny,
                        int howmny_len, MKL_INT* select, const MKL_INT* n,
                        const float* t, const MKL_INT* ldt, float* vl,
                        const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
                        const MKL_INT* mm, MKL_INT* m, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall STREVC3_( const char* side, int side_len, const char* howmny,
                         int howmny_len, MKL_INT* select, const MKL_INT* n,
                         const float* t, const MKL_INT* ldt, float* vl,
                         const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
                         const MKL_INT* mm, MKL_INT* m, float* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall strevc3( const char* side, int side_len, const char* howmny,
                        int howmny_len, MKL_INT* select, const MKL_INT* n,
                        const float* t, const MKL_INT* ldt, float* vl,
                        const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
                        const MKL_INT* mm, MKL_INT* m, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall strevc3_( const char* side, int side_len, const char* howmny,
                         int howmny_len, MKL_INT* select, const MKL_INT* n,
                         const float* t, const MKL_INT* ldt, float* vl,
                         const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
                         const MKL_INT* mm, MKL_INT* m, float* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall CTREVC3( const char* side, int side_len, const char* howmny,
                        int howmny_len, const MKL_INT* select,
                        const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* vl, const MKL_INT* ldvl,
                        MKL_Complex8* vr, const MKL_INT* ldvr,
                        const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* info );
void __stdcall CTREVC3_( const char* side, int side_len, const char* howmny,
                         int howmny_len, const MKL_INT* select,
                         const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
                         MKL_Complex8* vl, const MKL_INT* ldvl,
                         MKL_Complex8* vr, const MKL_INT* ldvr,
                         const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
                         const MKL_INT* lwork, float* rwork,
                         const MKL_INT* lrwork, MKL_INT* info );
void __stdcall ctrevc3( const char* side, int side_len, const char* howmny,
                        int howmny_len, const MKL_INT* select,
                        const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* vl, const MKL_INT* ldvl,
                        MKL_Complex8* vr, const MKL_INT* ldvr,
                        const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* info );
void __stdcall ctrevc3_( const char* side, int side_len, const char* howmny,
                         int howmny_len, const MKL_INT* select,
                         const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
                         MKL_Complex8* vl, const MKL_INT* ldvl,
                         MKL_Complex8* vr, const MKL_INT* ldvr,
                         const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
                         const MKL_INT* lwork, float* rwork,
                         const MKL_INT* lrwork, MKL_INT* info );

void __stdcall ZTREVC3( const char* side, int side_len, const char* howmny,
                        int howmny_len, const MKL_INT* select,
                        const MKL_INT* n, MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* vl, const MKL_INT* ldvl,
                        MKL_Complex16* vr, const MKL_INT* ldvr,
                        const MKL_INT* mm, MKL_INT* m, MKL_Complex16* work,
                        const MKL_INT* lwork, double* rwork,
                        const MKL_INT* lrwork, MKL_INT* info );
void __stdcall ZTREVC3_( const char* side, int side_len, const char* howmny,
                         int howmny_len, const MKL_INT* select,
                         const MKL_INT* n, MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_Complex16* vl,
                         const MKL_INT* ldvl, MKL_Complex16* vr,
                         const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
                         MKL_Complex16* work, const MKL_INT* lwork,
                         double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void __stdcall ztrevc3( const char* side, int side_len, const char* howmny,
                        int howmny_len, const MKL_INT* select,
                        const MKL_INT* n, MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* vl, const MKL_INT* ldvl,
                        MKL_Complex16* vr, const MKL_INT* ldvr,
                        const MKL_INT* mm, MKL_INT* m, MKL_Complex16* work,
                        const MKL_INT* lwork, double* rwork,
                        const MKL_INT* lrwork, MKL_INT* info );
void __stdcall ztrevc3_( const char* side, int side_len, const char* howmny,
                         int howmny_len, const MKL_INT* select,
                         const MKL_INT* n, MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_Complex16* vl,
                         const MKL_INT* ldvl, MKL_Complex16* vr,
                         const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
                         MKL_Complex16* work, const MKL_INT* lwork,
                         double* rwork, const MKL_INT* lrwork, MKL_INT* info );

/* LAPACK 3.6.0 routines */

void __stdcall CGEJSV( const char* joba, int joba_len, const char* jobu, int jobu_len,
                       const char* jobv, int jobv_len, const char* jobr, int jobr_len,
                       const char* jobt, int jobt_len, const char* jobp, int jobp_len,
                       const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       float* sva, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
                       const MKL_INT* ldv, MKL_Complex8* cwork, const MKL_INT* lwork,
                       float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall CGEJSV_( const char* joba, int joba_len, const char* jobu, int jobu_len,
                        const char* jobv, int jobv_len, const char* jobr, int jobr_len,
                        const char* jobt, int jobt_len, const char* jobp, int jobp_len,
                        const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        float* sva, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
                        const MKL_INT* ldv, MKL_Complex8* cwork, const MKL_INT* lwork,
                        float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall cgejsv( const char* joba, int joba_len, const char* jobu, int jobu_len,
                       const char* jobv, int jobv_len, const char* jobr, int jobr_len,
                       const char* jobt, int jobt_len, const char* jobp, int jobp_len,
                       const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       float* sva, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
                       const MKL_INT* ldv, MKL_Complex8* cwork, const MKL_INT* lwork,
                       float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall cgejsv_( const char* joba, int joba_len, const char* jobu, int jobu_len,
                        const char* jobv, int jobv_len, const char* jobr, int jobr_len,
                        const char* jobt, int jobt_len, const char* jobp, int jobp_len,
                        const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        float* sva, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
                        const MKL_INT* ldv, MKL_Complex8* cwork, const MKL_INT* lwork,
                        float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info );

void __stdcall ZGEJSV( const char* joba, int joba_len, const char* jobu, int jobu_len,
                       const char* jobv, int jobv_len, const char* jobr, int jobr_len,
                       const char* jobt, int jobt_len, const char* jobp, int jobp_len,
                       const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                       double* sva, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
                       const MKL_INT* ldv, MKL_Complex16* cwork, const MKL_INT* lwork,
                       double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall ZGEJSV_( const char* joba, int joba_len, const char* jobu, int jobu_len,
                        const char* jobv, int jobv_len, const char* jobr, int jobr_len,
                        const char* jobt, int jobt_len, const char* jobp, int jobp_len,
                        const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                        double* sva, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
                        const MKL_INT* ldv, MKL_Complex16* cwork, const MKL_INT* lwork,
                        double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall zgejsv( const char* joba, int joba_len, const char* jobu, int jobu_len,
                       const char* jobv, int jobv_len, const char* jobr, int jobr_len,
                       const char* jobt, int jobt_len, const char* jobp, int jobp_len,
                       const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                       double* sva, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
                       const MKL_INT* ldv, MKL_Complex16* cwork, const MKL_INT* lwork,
                       double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall zgejsv_( const char* joba, int joba_len, const char* jobu, int jobu_len,
                        const char* jobv, int jobv_len, const char* jobr, int jobr_len,
                        const char* jobt, int jobt_len, const char* jobp, int jobp_len,
                        const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                        double* sva, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
                        const MKL_INT* ldv, MKL_Complex16* cwork, const MKL_INT* lwork,
                        double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info );

void __stdcall DGESVDX( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                        const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                        double* a, const MKL_INT* lda, const double* vl, const double* vu,
                        const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                        double* s, double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
                        double* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall DGESVDX_( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                         const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                         double* a, const MKL_INT* lda, const double* vl, const double* vu,
                         const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                         double* s, double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
                         double* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall dgesvdx( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                        const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                        double* a, const MKL_INT* lda, const double* vl, const double* vu,
                        const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                        double* s, double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
                        double* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall dgesvdx_( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                         const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                         double* a, const MKL_INT* lda, const double* vl, const double* vu,
                         const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                         double* s, double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
                         double* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );

void __stdcall SGESVDX( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                        const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                        float* a, const MKL_INT* lda, const float* vl, const float* vu,
                        const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                        float* s, float* u, const MKL_INT* ldu, float* vt, const MKL_INT* ldvt,
                        float* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall SGESVDX_( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                         const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                         float* a, const MKL_INT* lda, const float* vl, const float* vu,
                         const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                         float* s, float* u, const MKL_INT* ldu, float* vt, const MKL_INT* ldvt,
                         float* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall sgesvdx( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                        const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                        float* a, const MKL_INT* lda, const float* vl, const float* vu,
                        const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                        float* s, float* u, const MKL_INT* ldu, float* vt, const MKL_INT* ldvt,
                        float* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall sgesvdx_( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                         const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                         float* a, const MKL_INT* lda, const float* vl, const float* vu,
                         const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                         float* s, float* u, const MKL_INT* ldu, float* vt, const MKL_INT* ldvt,
                         float* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );

void __stdcall CGESVDX( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                        const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, const float* vl, const float* vu,
                        const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                        float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
                        const MKL_INT* ldvt, MKL_Complex8* work,const MKL_INT* lwork,
                        float* rwork, const MKL_INT* iwork, MKL_INT* info );
void __stdcall CGESVDX_( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                         const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                         MKL_Complex8* a, const MKL_INT* lda, const float* vl, const float* vu,
                         const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                         float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
                         const MKL_INT* ldvt, MKL_Complex8* work,const MKL_INT* lwork,
                         float* rwork, const MKL_INT* iwork, MKL_INT* info );
void __stdcall cgesvdx( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                        const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, const float* vl, const float* vu,
                        const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                        float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
                        const MKL_INT* ldvt, MKL_Complex8* work,const MKL_INT* lwork,
                        float* rwork, const MKL_INT* iwork, MKL_INT* info );
void __stdcall cgesvdx_( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                         const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                         MKL_Complex8* a, const MKL_INT* lda, const float* vl, const float* vu,
                         const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                         float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
                         const MKL_INT* ldvt, MKL_Complex8* work,const MKL_INT* lwork,
                         float* rwork, const MKL_INT* iwork, MKL_INT* info );

void __stdcall ZGESVDX( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                        const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex16* a, const MKL_INT* lda, const double* vl, const double* vu,
                        const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                        double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* vt,
                        const MKL_INT* ldvt, MKL_Complex16* work,const MKL_INT* lwork,
                        double* rwork, const MKL_INT* iwork, MKL_INT* info );
void __stdcall ZGESVDX_( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                         const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                         MKL_Complex16* a, const MKL_INT* lda, const double* vl, const double* vu,
                         const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                         double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* vt,
                         const MKL_INT* ldvt, MKL_Complex16* work,const MKL_INT* lwork,
                         double* rwork, const MKL_INT* iwork, MKL_INT* info );
void __stdcall zgesvdx( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                        const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex16* a, const MKL_INT* lda, const double* vl, const double* vu,
                        const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                        double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* vt,
                        const MKL_INT* ldvt, MKL_Complex16* work,const MKL_INT* lwork,
                        double* rwork, const MKL_INT* iwork, MKL_INT* info );
void __stdcall zgesvdx_( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len,
                         const char* range, int range_len, const MKL_INT* m, const MKL_INT* n,
                         MKL_Complex16* a, const MKL_INT* lda, const double* vl, const double* vu,
                         const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
                         double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* vt,
                         const MKL_INT* ldvt, MKL_Complex16* work,const MKL_INT* lwork,
                         double* rwork, const MKL_INT* iwork, MKL_INT* info );

void __stdcall CGESVJ( const char* joba, int joba_len, const char* jobu, int jobu_len,
                       const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, float* sva, const MKL_INT* mv,
                       MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* info );
void __stdcall CGESVJ_( const char* joba, int joba_len, const char* jobu, int jobu_len,
                        const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, float* sva, const MKL_INT* mv,
                        MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork,
                        const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                        MKL_INT* info );
void __stdcall cgesvj( const char* joba, int joba_len, const char* jobu, int jobu_len,
                       const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, float* sva, const MKL_INT* mv,
                       MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* info );
void __stdcall cgesvj_( const char* joba, int joba_len, const char* jobu, int jobu_len,
                        const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, float* sva, const MKL_INT* mv,
                        MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork,
                        const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                        MKL_INT* info );

void __stdcall ZGESVJ( const char* joba, int joba_len, const char* jobu, int jobu_len,
                       const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex16* a, const MKL_INT* lda, double* sva,
                       const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv,
                       MKL_Complex16* cwork, const MKL_INT* lwork, double* rwork,
                       const MKL_INT* lrwork, MKL_INT* info );
void __stdcall ZGESVJ_( const char* joba, int joba_len, const char* jobu, int jobu_len,
                        const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex16* a, const MKL_INT* lda, double* sva,
                        const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv,
                        MKL_Complex16* cwork, const MKL_INT* lwork, double* rwork,
                        const MKL_INT* lrwork, MKL_INT* info );
void __stdcall zgesvj( const char* joba, int joba_len, const char* jobu, int jobu_len,
                       const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex16* a, const MKL_INT* lda, double* sva,
                       const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv,
                       MKL_Complex16* cwork, const MKL_INT* lwork, double* rwork,
                       const MKL_INT* lrwork, MKL_INT* info );
void __stdcall zgesvj_( const char* joba, int joba_len, const char* jobu, int jobu_len,
                        const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex16* a, const MKL_INT* lda, double* sva,
                        const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv,
                        MKL_Complex16* cwork, const MKL_INT* lwork, double* rwork,
                        const MKL_INT* lrwork, MKL_INT* info );

void __stdcall DGGSVD3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* p, MKL_INT* k, MKL_INT* l, double* a, const MKL_INT* lda,
                        double* b, const MKL_INT* ldb, double* alpha, double* beta,
                        double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
                        double* q, const MKL_INT* ldq, double* work, const MKL_INT* lwork,
                        MKL_INT* iwork, MKL_INT* info );
void __stdcall DGGSVD3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* p, MKL_INT* k, MKL_INT* l, double* a, const MKL_INT* lda,
                         double* b, const MKL_INT* ldb, double* alpha, double* beta,
                         double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
                         double* q, const MKL_INT* ldq, double* work, const MKL_INT* lwork,
                         MKL_INT* iwork, MKL_INT* info );
void __stdcall dggsvd3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* p, MKL_INT* k, MKL_INT* l, double* a, const MKL_INT* lda,
                        double* b, const MKL_INT* ldb, double* alpha, double* beta,
                        double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
                        double* q, const MKL_INT* ldq, double* work, const MKL_INT* lwork,
                        MKL_INT* iwork, MKL_INT* info );
void __stdcall dggsvd3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* p, MKL_INT* k, MKL_INT* l, double* a, const MKL_INT* lda,
                         double* b, const MKL_INT* ldb, double* alpha, double* beta,
                         double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
                         double* q, const MKL_INT* ldq, double* work, const MKL_INT* lwork,
                         MKL_INT* iwork, MKL_INT* info );

void __stdcall SGGSVD3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* p, MKL_INT* k, MKL_INT* l, float* a, const MKL_INT* lda,
                        float* b, const MKL_INT* ldb, float* alpha, float* beta,
                        float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv,
                        float* q, const MKL_INT* ldq, float* work, const MKL_INT* lwork,
                        MKL_INT* iwork, MKL_INT* info );
void __stdcall SGGSVD3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* p, MKL_INT* k, MKL_INT* l, float* a, const MKL_INT* lda,
                         float* b, const MKL_INT* ldb, float* alpha, float* beta,
                         float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv,
                         float* q, const MKL_INT* ldq, float* work, const MKL_INT* lwork,
                         MKL_INT* iwork, MKL_INT* info );
void __stdcall sggsvd3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* p, MKL_INT* k, MKL_INT* l, float* a, const MKL_INT* lda,
                        float* b, const MKL_INT* ldb, float* alpha, float* beta,
                        float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv,
                        float* q, const MKL_INT* ldq, float* work, const MKL_INT* lwork,
                        MKL_INT* iwork, MKL_INT* info );
void __stdcall sggsvd3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* p, MKL_INT* k, MKL_INT* l, float* a, const MKL_INT* lda,
                         float* b, const MKL_INT* ldb, float* alpha, float* beta,
                         float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv,
                         float* q, const MKL_INT* ldq, float* work, const MKL_INT* lwork,
                         MKL_INT* iwork, MKL_INT* info );

void __stdcall CGGSVD3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        float* alpha, float* beta, MKL_Complex8* u, const MKL_INT* ldu,
                        MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* iwork, MKL_INT* info );
void __stdcall CGGSVD3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                         float* alpha, float* beta, MKL_Complex8* u, const MKL_INT* ldu,
                         MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
                         MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                         MKL_INT* iwork, MKL_INT* info );
void __stdcall cggsvd3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        float* alpha, float* beta, MKL_Complex8* u, const MKL_INT* ldu,
                        MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* iwork, MKL_INT* info );
void __stdcall cggsvd3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                         float* alpha, float* beta, MKL_Complex8* u, const MKL_INT* ldu,
                         MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
                         MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                         MKL_INT* iwork, MKL_INT* info );

void __stdcall ZGGSVD3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
                        double* alpha, double* beta, MKL_Complex16* u, const MKL_INT* ldu,
                        MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* q,
                        const MKL_INT* ldq, MKL_Complex16* work, const MKL_INT* lwork,
                        double* rwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall ZGGSVD3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
                         double* alpha, double* beta, MKL_Complex16* u, const MKL_INT* ldu,
                         MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* q,
                         const MKL_INT* ldq, MKL_Complex16* work, const MKL_INT* lwork,
                         double* rwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall zggsvd3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
                        double* alpha, double* beta, MKL_Complex16* u, const MKL_INT* ldu,
                        MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* q,
                        const MKL_INT* ldq, MKL_Complex16* work, const MKL_INT* lwork,
                        double* rwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall zggsvd3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
                         double* alpha, double* beta, MKL_Complex16* u, const MKL_INT* ldu,
                         MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* q,
                         const MKL_INT* ldq, MKL_Complex16* work, const MKL_INT* lwork,
                         double* rwork, MKL_INT* iwork, MKL_INT* info );

void __stdcall DGGSVP3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                        const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                        const MKL_INT* ldb, const double* tola, const double* tolb,
                        MKL_INT* k, MKL_INT* l, double* u, const MKL_INT* ldu, double* v,
                        const MKL_INT* ldv, double* q, const MKL_INT* ldq, MKL_INT* iwork,
                        double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DGGSVP3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                         const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                         const MKL_INT* ldb, const double* tola, const double* tolb,
                         MKL_INT* k, MKL_INT* l, double* u, const MKL_INT* ldu, double* v,
                         const MKL_INT* ldv, double* q, const MKL_INT* ldq, MKL_INT* iwork,
                         double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dggsvp3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                        const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                        const MKL_INT* ldb, const double* tola, const double* tolb,
                        MKL_INT* k, MKL_INT* l, double* u, const MKL_INT* ldu, double* v,
                        const MKL_INT* ldv, double* q, const MKL_INT* ldq, MKL_INT* iwork,
                        double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dggsvp3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                         const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                         const MKL_INT* ldb, const double* tola, const double* tolb,
                         MKL_INT* k, MKL_INT* l, double* u, const MKL_INT* ldu, double* v,
                         const MKL_INT* ldv, double* q, const MKL_INT* ldq, MKL_INT* iwork,
                         double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SGGSVP3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                        const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                        const MKL_INT* ldb, const float* tola, const float* tolb,
                        MKL_INT* k, MKL_INT* l, float* u, const MKL_INT* ldu, float* v,
                        const MKL_INT* ldv, float* q, const MKL_INT* ldq, MKL_INT* iwork,
                        float* tau, float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SGGSVP3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                         const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                         const MKL_INT* ldb, const float* tola, const float* tolb,
                         MKL_INT* k, MKL_INT* l, float* u, const MKL_INT* ldu, float* v,
                         const MKL_INT* ldv, float* q, const MKL_INT* ldq, MKL_INT* iwork,
                         float* tau, float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sggsvp3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                        const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                        const MKL_INT* ldb, const float* tola, const float* tolb,
                        MKL_INT* k, MKL_INT* l, float* u, const MKL_INT* ldu, float* v,
                        const MKL_INT* ldv, float* q, const MKL_INT* ldq, MKL_INT* iwork,
                        float* tau, float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sggsvp3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                         const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                         const MKL_INT* ldb, const float* tola, const float* tolb,
                         MKL_INT* k, MKL_INT* l, float* u, const MKL_INT* ldu, float* v,
                         const MKL_INT* ldv, float* q, const MKL_INT* ldq, MKL_INT* iwork,
                         float* tau, float* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall CGGSVP3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, const float* tola, const float* tolb,
                        MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
                        MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
                        MKL_INT* iwork, float* rwork, MKL_Complex8* tau, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGGSVP3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                         const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                         const MKL_INT* ldb, const float* tola, const float* tolb,
                         MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
                         MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
                         MKL_INT* iwork, float* rwork, MKL_Complex8* tau, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall cggsvp3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, const float* tola, const float* tolb,
                        MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
                        MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
                        MKL_INT* iwork, float* rwork, MKL_Complex8* tau, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall cggsvp3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                         const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                         const MKL_INT* ldb, const float* tola, const float* tolb,
                         MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
                         MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
                         MKL_INT* iwork, float* rwork, MKL_Complex8* tau, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZGGSVP3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                        const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                        MKL_Complex16* b, const MKL_INT* ldb, const double* tola,
                        const double* tolb, MKL_INT* k, MKL_INT* l, MKL_Complex16* u,
                        const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv,
                        MKL_Complex16* q, const MKL_INT* ldq, MKL_INT* iwork, double* rwork,
                        MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall ZGGSVP3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                         const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                         MKL_Complex16* b, const MKL_INT* ldb, const double* tola,
                         const double* tolb, MKL_INT* k, MKL_INT* l, MKL_Complex16* u,
                         const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv,
                         MKL_Complex16* q, const MKL_INT* ldq, MKL_INT* iwork, double* rwork,
                         MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall zggsvp3( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                        const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                        const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                        MKL_Complex16* b, const MKL_INT* ldb, const double* tola,
                        const double* tolb, MKL_INT* k, MKL_INT* l, MKL_Complex16* u,
                        const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv,
                        MKL_Complex16* q, const MKL_INT* ldq, MKL_INT* iwork, double* rwork,
                        MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall zggsvp3_( const char* jobu, int jobu_len, const char* jobv, int jobv_len,
                         const char* jobq, int jobq_len, const MKL_INT* m, const MKL_INT* p,
                         const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                         MKL_Complex16* b, const MKL_INT* ldb, const double* tola,
                         const double* tolb, MKL_INT* k, MKL_INT* l, MKL_Complex16* u,
                         const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv,
                         MKL_Complex16* q, const MKL_INT* ldq, MKL_INT* iwork, double* rwork,
                         MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );

void __stdcall CGSVJ0( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, float* sva,
                       const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv, const float* eps,
                       const float* sfmin, const float* tol, const MKL_INT* nsweep,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGSVJ0_( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, float* sva,
                        const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv, const float* eps,
                        const float* sfmin, const float* tol, const MKL_INT* nsweep,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgsvj0( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, float* sva,
                       const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv, const float* eps,
                       const float* sfmin, const float* tol, const MKL_INT* nsweep,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgsvj0_( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, float* sva,
                        const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv, const float* eps,
                        const float* sfmin, const float* tol, const MKL_INT* nsweep,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZGSVJ0( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, double* sva,
                       const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv,
                       const double* eps, const double* sfmin, const double* tol,
                       const MKL_INT* nsweep, MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall ZGSVJ0_( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, double* sva,
                        const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv,
                        const double* eps, const double* sfmin, const double* tol,
                        const MKL_INT* nsweep, MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall zgsvj0( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, double* sva,
                       const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv,
                       const double* eps, const double* sfmin, const double* tol,
                       const MKL_INT* nsweep, MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall zgsvj0_( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, double* sva,
                        const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv,
                        const double* eps, const double* sfmin, const double* tol,
                        const MKL_INT* nsweep, MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );

void __stdcall CGSVJ1( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* n1, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d,
                       float* sva, const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv,
                       const float* eps, const float* sfmin, const float* tol, const MKL_INT* nsweep,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGSVJ1_( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* n1, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d,
                        float* sva, const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv,
                        const float* eps, const float* sfmin, const float* tol, const MKL_INT* nsweep,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgsvj1( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* n1, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d,
                       float* sva, const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv,
                       const float* eps, const float* sfmin, const float* tol, const MKL_INT* nsweep,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgsvj1_( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* n1, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d,
                        float* sva, const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv,
                        const float* eps, const float* sfmin, const float* tol, const MKL_INT* nsweep,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZGSVJ1( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* n1, MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* d, double* sva, const MKL_INT* mv, MKL_Complex16* v,
                       const MKL_INT* ldv, const double* eps, const double* sfmin,
                       const double* tol, const MKL_INT* nsweep, MKL_Complex16* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZGSVJ1_( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* n1, MKL_Complex16* a, const MKL_INT* lda,
                        MKL_Complex16* d, double* sva, const MKL_INT* mv, MKL_Complex16* v,
                        const MKL_INT* ldv, const double* eps, const double* sfmin,
                        const double* tol, const MKL_INT* nsweep, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall zgsvj1( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* n1, MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* d, double* sva, const MKL_INT* mv, MKL_Complex16* v,
                       const MKL_INT* ldv, const double* eps, const double* sfmin,
                       const double* tol, const MKL_INT* nsweep, MKL_Complex16* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall zgsvj1_( const char* jobv, int jobv_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* n1, MKL_Complex16* a, const MKL_INT* lda,
                        MKL_Complex16* d, double* sva, const MKL_INT* mv, MKL_Complex16* v,
                        const MKL_INT* ldv, const double* eps, const double* sfmin,
                        const double* tol, const MKL_INT* nsweep, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );

void __stdcall CPOTRF2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* info );
void __stdcall CPOTRF2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_INT* info );
void __stdcall cpotrf2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* info );
void __stdcall cpotrf2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_INT* info );

void __stdcall DPOTRF2( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                        const MKL_INT* lda, MKL_INT* info );
void __stdcall DPOTRF2_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                         const MKL_INT* lda, MKL_INT* info );
void __stdcall dpotrf2( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                        const MKL_INT* lda, MKL_INT* info );
void __stdcall dpotrf2_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                         const MKL_INT* lda, MKL_INT* info );

void __stdcall SPOTRF2( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                        const MKL_INT* lda, MKL_INT* info );
void __stdcall SPOTRF2_( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                         const MKL_INT* lda, MKL_INT* info );
void __stdcall spotrf2( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                        const MKL_INT* lda, MKL_INT* info );
void __stdcall spotrf2_( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                         const MKL_INT* lda, MKL_INT* info );

void __stdcall ZPOTRF2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_INT* info );
void __stdcall ZPOTRF2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_INT* info );
void __stdcall zpotrf2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_INT* info );
void __stdcall zpotrf2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_INT* info );

void __stdcall DBDSVDX( const char* uplo, int uplo_len, const char* jobz, int jobz_len,
                        const char* range, int range_len, const MKL_INT* n, const double* d,
                        const double* e, const double* vl, const double* vu, const MKL_INT* il,
                        const MKL_INT* iu, MKL_INT* ns, double* s, double* z, const MKL_INT* ldz,
                        double* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall DBDSVDX_( const char* uplo, int uplo_len, const char* jobz, int jobz_len,
                         const char* range, int range_len, const MKL_INT* n, const double* d,
                         const double* e, const double* vl, const double* vu, const MKL_INT* il,
                         const MKL_INT* iu, MKL_INT* ns, double* s, double* z, const MKL_INT* ldz,
                         double* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall dbdsvdx( const char* uplo, int uplo_len, const char* jobz, int jobz_len,
                        const char* range, int range_len, const MKL_INT* n, const double* d,
                        const double* e, const double* vl, const double* vu, const MKL_INT* il,
                        const MKL_INT* iu, MKL_INT* ns, double* s, double* z, const MKL_INT* ldz,
                        double* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall dbdsvdx_( const char* uplo, int uplo_len, const char* jobz, int jobz_len,
                         const char* range, int range_len, const MKL_INT* n, const double* d,
                         const double* e, const double* vl, const double* vu, const MKL_INT* il,
                         const MKL_INT* iu, MKL_INT* ns, double* s, double* z, const MKL_INT* ldz,
                         double* work, MKL_INT* iwork, MKL_INT* info );

void __stdcall SBDSVDX( const char* uplo, int uplo_len, const char* jobz, int jobz_len,
                        const char* range, int range_len, const MKL_INT* n, const float* d,
                        const float* e, const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, MKL_INT* ns, float* s, float* z, const MKL_INT* ldz,
                        float* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall SBDSVDX_( const char* uplo, int uplo_len, const char* jobz, int jobz_len,
                         const char* range, int range_len, const MKL_INT* n, const float* d,
                         const float* e, const float* vl, const float* vu, const MKL_INT* il,
                         const MKL_INT* iu, MKL_INT* ns, float* s, float* z, const MKL_INT* ldz,
                         float* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall sbdsvdx( const char* uplo, int uplo_len, const char* jobz, int jobz_len,
                        const char* range, int range_len, const MKL_INT* n, const float* d,
                        const float* e, const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, MKL_INT* ns, float* s, float* z, const MKL_INT* ldz,
                        float* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall sbdsvdx_( const char* uplo, int uplo_len, const char* jobz, int jobz_len,
                         const char* range, int range_len, const MKL_INT* n, const float* d,
                         const float* e, const float* vl, const float* vu, const MKL_INT* il,
                         const MKL_INT* iu, MKL_INT* ns, float* s, float* z, const MKL_INT* ldz,
                         float* work, MKL_INT* iwork, MKL_INT* info );

void __stdcall CGETRF2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_INT* ipiv, MKL_INT* info );
void __stdcall CGETRF2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                         MKL_INT* ipiv, MKL_INT* info );
void __stdcall cgetrf2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_INT* ipiv, MKL_INT* info );
void __stdcall cgetrf2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                         MKL_INT* ipiv, MKL_INT* info );

void __stdcall DGETRF2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
                        MKL_INT* ipiv, MKL_INT* info );
void __stdcall DGETRF2_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
                         MKL_INT* ipiv, MKL_INT* info );
void __stdcall dgetrf2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
                        MKL_INT* ipiv, MKL_INT* info );
void __stdcall dgetrf2_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
                         MKL_INT* ipiv, MKL_INT* info );

void __stdcall SGETRF2( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
                        MKL_INT* ipiv, MKL_INT* info );
void __stdcall SGETRF2_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
                         MKL_INT* ipiv, MKL_INT* info );
void __stdcall sgetrf2( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
                        MKL_INT* ipiv, MKL_INT* info );
void __stdcall sgetrf2_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
                         MKL_INT* ipiv, MKL_INT* info );

void __stdcall ZGETRF2( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                        MKL_INT* ipiv, MKL_INT* info );
void __stdcall ZGETRF2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                         MKL_INT* ipiv, MKL_INT* info );
void __stdcall zgetrf2( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                        MKL_INT* ipiv, MKL_INT* info );
void __stdcall zgetrf2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                         MKL_INT* ipiv, MKL_INT* info );

void __stdcall CGGEV3( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                       MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                       const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );
void __stdcall CGGEV3_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                        MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                        const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                        float* rwork, MKL_INT* info );
void __stdcall cggev3( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                       MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                       const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );
void __stdcall cggev3_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                        MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                        const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                        float* rwork, MKL_INT* info );

void __stdcall ZGGEV3( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                       const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
                       const MKL_INT* ldb, MKL_Complex16* alpha, MKL_Complex16* beta,
                       MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
                       const MKL_INT* ldvr, MKL_Complex16* work, const MKL_INT* lwork,
                       double* rwork, MKL_INT* info );
void __stdcall ZGGEV3_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                        const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_Complex16* alpha, MKL_Complex16* beta,
                        MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
                        const MKL_INT* ldvr, MKL_Complex16* work, const MKL_INT* lwork,
                        double* rwork, MKL_INT* info );
void __stdcall zggev3( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                       const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
                       const MKL_INT* ldb, MKL_Complex16* alpha, MKL_Complex16* beta,
                       MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
                       const MKL_INT* ldvr, MKL_Complex16* work, const MKL_INT* lwork,
                       double* rwork, MKL_INT* info );
void __stdcall zggev3_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                        const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_Complex16* alpha, MKL_Complex16* beta,
                        MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
                        const MKL_INT* ldvr, MKL_Complex16* work, const MKL_INT* lwork,
                        double* rwork, MKL_INT* info );

void __stdcall DGGEV3( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                       const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                       const MKL_INT* ldb, double* alphar, double* alphai, double* beta,
                       double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
                       double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DGGEV3_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                        const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                        const MKL_INT* ldb, double* alphar, double* alphai, double* beta,
                        double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
                        double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dggev3( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                       const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                       const MKL_INT* ldb, double* alphar, double* alphai, double* beta,
                       double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
                       double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dggev3_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                        const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                        const MKL_INT* ldb, double* alphar, double* alphai, double* beta,
                        double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
                        double* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SGGEV3( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                       const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                       const MKL_INT* ldb, float* alphar, float* alphai, float* beta,
                       float* vl, const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
                       float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SGGEV3_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                        const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                        const MKL_INT* ldb, float* alphar, float* alphai, float* beta,
                        float* vl, const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
                        float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sggev3( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                       const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                       const MKL_INT* ldb, float* alphar, float* alphai, float* beta,
                       float* vl, const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
                       float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sggev3_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                        const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                        const MKL_INT* ldb, float* alphar, float* alphai, float* beta,
                        float* vl, const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
                        float* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall CUNM22( const char* side, int side_len, const char* trans, int trans_len,
                       const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* n2,
                       const MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* c,
                       const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall CUNM22_( const char* side, int side_len, const char* trans, int trans_len,
                        const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* n2,
                        const MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* c,
                        const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall cunm22( const char* side, int side_len, const char* trans, int trans_len,
                       const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* n2,
                       const MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* c,
                       const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall cunm22_( const char* side, int side_len, const char* trans, int trans_len,
                        const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* n2,
                        const MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* c,
                        const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );

void __stdcall ZUNM22( const char* side, int side_len, const char* trans, int trans_len,
                       const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* n2,
                       const MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* c,
                       const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall ZUNM22_( const char* side, int side_len, const char* trans, int trans_len,
                        const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* n2,
                        const MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* c,
                        const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall zunm22( const char* side, int side_len, const char* trans, int trans_len,
                       const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* n2,
                       const MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* c,
                       const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall zunm22_( const char* side, int side_len, const char* trans, int trans_len,
                        const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* n2,
                        const MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* c,
                        const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );

void __stdcall CGGHD3( const char* compq, int compq_len, const char* compz, int compz_len,
                       const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGGHD3_( const char* compq, int compq_len, const char* compz, int compz_len,
                        const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgghd3( const char* compq, int compq_len, const char* compz, int compz_len,
                       const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgghd3_( const char* compq, int compq_len, const char* compz, int compz_len,
                        const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall DGGHD3( const char* compq, int compq_len, const char* compz, int compz_len,
                       const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
                       double* q, const MKL_INT* ldq, double* z, const MKL_INT* ldz,
                       double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DGGHD3_( const char* compq, int compq_len, const char* compz, int compz_len,
                        const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
                        double* q, const MKL_INT* ldq, double* z, const MKL_INT* ldz,
                        double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dgghd3( const char* compq, int compq_len, const char* compz, int compz_len,
                       const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
                       double* q, const MKL_INT* ldq, double* z, const MKL_INT* ldz,
                       double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dgghd3_( const char* compq, int compq_len, const char* compz, int compz_len,
                        const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
                        double* q, const MKL_INT* ldq, double* z, const MKL_INT* ldz,
                        double* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SGGHD3( const char* compq, int compq_len, const char* compz, int compz_len,
                       const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
                       float* q, const MKL_INT* ldq, float* z, const MKL_INT* ldz,
                       float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SGGHD3_( const char* compq, int compq_len, const char* compz, int compz_len,
                        const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
                        float* q, const MKL_INT* ldq, float* z, const MKL_INT* ldz,
                        float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sgghd3( const char* compq, int compq_len, const char* compz, int compz_len,
                       const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
                       float* q, const MKL_INT* ldq, float* z, const MKL_INT* ldz,
                       float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sgghd3_( const char* compq, int compq_len, const char* compz, int compz_len,
                        const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
                        float* q, const MKL_INT* ldq, float* z, const MKL_INT* ldz,
                        float* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZGGHD3( const char* compq, int compq_len, const char* compz, int compz_len,
                       const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* z, const MKL_INT* ldz,
                       MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZGGHD3_( const char* compq, int compq_len, const char* compz, int compz_len,
                        const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
                        MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* z, const MKL_INT* ldz,
                        MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall zgghd3( const char* compq, int compq_len, const char* compz, int compz_len,
                       const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* z, const MKL_INT* ldz,
                       MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall zgghd3_( const char* compq, int compq_len, const char* compz, int compz_len,
                        const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
                        MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* z, const MKL_INT* ldz,
                        MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall CGGES3( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                       const char* sort, int sort_len, MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
                       const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
                       MKL_INT* info );
void __stdcall CGGES3_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                        const char* sort, int sort_len, MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
                        const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
                        MKL_INT* info );
void __stdcall cgges3( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                       const char* sort, int sort_len, MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
                       const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
                       MKL_INT* info );
void __stdcall cgges3_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                        const char* sort, int sort_len, MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
                        const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
                        MKL_INT* info );

void __stdcall ZGGES3( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                       const char* sort, int sort_len, MKL_Z_SELECT_FUNCTION_2 selctg, const MKL_INT* n,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_INT* sdim, MKL_Complex16* alpha, MKL_Complex16* beta,
                       MKL_Complex16* vsl, const MKL_INT* ldvsl, MKL_Complex16* vsr,
                       const MKL_INT* ldvsr, MKL_Complex16* work, const MKL_INT* lwork,
                       double* rwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall ZGGES3_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                        const char* sort, int sort_len, MKL_Z_SELECT_FUNCTION_2 selctg, const MKL_INT* n,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
                        MKL_INT* sdim, MKL_Complex16* alpha, MKL_Complex16* beta,
                        MKL_Complex16* vsl, const MKL_INT* ldvsl, MKL_Complex16* vsr,
                        const MKL_INT* ldvsr, MKL_Complex16* work, const MKL_INT* lwork,
                        double* rwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall zgges3( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                       const char* sort, int sort_len, MKL_Z_SELECT_FUNCTION_2 selctg, const MKL_INT* n,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_INT* sdim, MKL_Complex16* alpha, MKL_Complex16* beta,
                       MKL_Complex16* vsl, const MKL_INT* ldvsl, MKL_Complex16* vsr,
                       const MKL_INT* ldvsr, MKL_Complex16* work, const MKL_INT* lwork,
                       double* rwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall zgges3_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                        const char* sort, int sort_len, MKL_Z_SELECT_FUNCTION_2 selctg, const MKL_INT* n,
                        MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
                        MKL_INT* sdim, MKL_Complex16* alpha, MKL_Complex16* beta,
                        MKL_Complex16* vsl, const MKL_INT* ldvsl, MKL_Complex16* vsr,
                        const MKL_INT* ldvsr, MKL_Complex16* work, const MKL_INT* lwork,
                        double* rwork, MKL_INT* bwork, MKL_INT* info );

void __stdcall DGGES3( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                       const char* sort, int sort_len, MKL_D_SELECT_FUNCTION_3 selctg, const MKL_INT* n,
                       double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
                       MKL_INT* sdim, double* alphar, double* alphai, double* beta,
                       double* vsl, const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
                       double* work, const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall DGGES3_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                        const char* sort, int sort_len, MKL_D_SELECT_FUNCTION_3 selctg, const MKL_INT* n,
                        double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
                        MKL_INT* sdim, double* alphar, double* alphai, double* beta,
                        double* vsl, const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
                        double* work, const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall dgges3( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                       const char* sort, int sort_len, MKL_D_SELECT_FUNCTION_3 selctg, const MKL_INT* n,
                       double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
                       MKL_INT* sdim, double* alphar, double* alphai, double* beta,
                       double* vsl, const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
                       double* work, const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall dgges3_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                        const char* sort, int sort_len, MKL_D_SELECT_FUNCTION_3 selctg, const MKL_INT* n,
                        double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
                        MKL_INT* sdim, double* alphar, double* alphai, double* beta,
                        double* vsl, const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
                        double* work, const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );

void __stdcall SGGES3( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                       const char* sort, int sort_len, MKL_S_SELECT_FUNCTION_3 selctg, const MKL_INT* n,
                       float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
                       MKL_INT* sdim, float* alphar, float* alphai, float* beta,
                       float* vsl, const MKL_INT* ldvsl, float* vsr, const MKL_INT* ldvsr,
                       float* work, const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall SGGES3_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                        const char* sort, int sort_len, MKL_S_SELECT_FUNCTION_3 selctg, const MKL_INT* n,
                        float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
                        MKL_INT* sdim, float* alphar, float* alphai, float* beta,
                        float* vsl, const MKL_INT* ldvsl, float* vsr, const MKL_INT* ldvsr,
                        float* work, const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall sgges3( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                       const char* sort, int sort_len, MKL_S_SELECT_FUNCTION_3 selctg, const MKL_INT* n,
                       float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
                       MKL_INT* sdim, float* alphar, float* alphai, float* beta,
                       float* vsl, const MKL_INT* ldvsl, float* vsr, const MKL_INT* ldvsr,
                       float* work, const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall sgges3_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len,
                        const char* sort, int sort_len, MKL_S_SELECT_FUNCTION_3 selctg, const MKL_INT* n,
                        float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
                        MKL_INT* sdim, float* alphar, float* alphai, float* beta,
                        float* vsl, const MKL_INT* ldvsl, float* vsr, const MKL_INT* ldvsr,
                        float* work, const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );

void __stdcall DORM22( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* n1, const MKL_INT* n2, const double* q,
                       const MKL_INT* ldq, double* c, const MKL_INT* ldc,
                       double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DORM22_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* n1, const MKL_INT* n2, const double* q,
                        const MKL_INT* ldq, double* c, const MKL_INT* ldc,
                        double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorm22( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* n1, const MKL_INT* n2, const double* q,
                       const MKL_INT* ldq, double* c, const MKL_INT* ldc,
                       double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorm22_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* n1, const MKL_INT* n2, const double* q,
                        const MKL_INT* ldq, double* c, const MKL_INT* ldc,
                        double* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SORM22( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* n1, const MKL_INT* n2, const float* q,
                       const MKL_INT* ldq, float* c, const MKL_INT* ldc,
                       float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SORM22_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* n1, const MKL_INT* n2, const float* q,
                        const MKL_INT* ldq, float* c, const MKL_INT* ldc,
                        float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorm22( const char* side, int side_len, const char* trans,
                       int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* n1, const MKL_INT* n2, const float* q,
                       const MKL_INT* ldq, float* c, const MKL_INT* ldc,
                       float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorm22_( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* n1, const MKL_INT* n2, const float* q,
                        const MKL_INT* ldq, float* c, const MKL_INT* ldc,
                        float* work, const MKL_INT* lwork, MKL_INT* info );


/* LAPACK 3.5.0 routines */

void __stdcall CHECON_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                            float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall CHECON_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                             float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall checon_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                            float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall checon_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                             float* rcond, MKL_Complex8* work, MKL_INT* info );

void __stdcall CHESV_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                           MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                           const MKL_INT* lwork, MKL_INT* info );
void __stdcall CHESV_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                            const MKL_INT* lwork, MKL_INT* info );
void __stdcall chesv_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                           MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                           const MKL_INT* lwork, MKL_INT* info );
void __stdcall chesv_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                            const MKL_INT* lwork, MKL_INT* info );

void __stdcall CHETF2_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall CHETF2_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall chetf2_rook( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall chetf2_rook_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void __stdcall CHETRF_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                            const MKL_INT* lwork, MKL_INT* info );
void __stdcall CHETRF_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall chetrf_rook( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                            const MKL_INT* lwork, MKL_INT* info );
void __stdcall chetrf_rook_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                             const MKL_INT* lwork, MKL_INT* info );

void __stdcall CHETRI_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                            MKL_INT* info );
void __stdcall CHETRI_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                             MKL_INT* info );
void __stdcall chetri_rook( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                            MKL_INT* info );
void __stdcall chetri_rook_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                             MKL_INT* info );

void __stdcall CHETRS_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                            MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall CHETRS_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall chetrs_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                            MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall chetrs_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void __stdcall CLAHEF_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                            MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall CLAHEF_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                             MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                             MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall clahef_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                            MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall clahef_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                             MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                             MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );

void __stdcall CLASYF_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                            MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall CLASYF_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                             MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                             MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall clasyf_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                            MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall clasyf_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                             MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                             MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );

void __stdcall CSYCON_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                            float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall CSYCON_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                             float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall csycon_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                            float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall csycon_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                             float* rcond, MKL_Complex8* work, MKL_INT* info );

void __stdcall CSYSV_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                           MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                           const MKL_INT* lwork, MKL_INT* info );
void __stdcall CSYSV_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                            const MKL_INT* lwork, MKL_INT* info );
void __stdcall csysv_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                           MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                           const MKL_INT* lwork, MKL_INT* info );
void __stdcall csysv_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                            const MKL_INT* lwork, MKL_INT* info );

void __stdcall CSYTF2_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall CSYTF2_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall csytf2_rook( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall csytf2_rook_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void __stdcall CSYTRF_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                            const MKL_INT* lwork, MKL_INT* info );
void __stdcall CSYTRF_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall csytrf_rook( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                            const MKL_INT* lwork, MKL_INT* info );
void __stdcall csytrf_rook_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                             const MKL_INT* lwork, MKL_INT* info );

void __stdcall CSYTRI_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                            MKL_INT* info );
void __stdcall CSYTRI_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                             MKL_INT* info );
void __stdcall csytri_rook( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                            MKL_INT* info );
void __stdcall csytri_rook_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                             MKL_INT* info );

void __stdcall CSYTRS_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                            MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall CSYTRS_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall csytrs_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                            MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall csytrs_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void __stdcall DLASYF_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                            MKL_INT* kb, double* a, const MKL_INT* lda, MKL_INT* ipiv,
                            double* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall DLASYF_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                             MKL_INT* kb, double* a, const MKL_INT* lda, MKL_INT* ipiv,
                             double* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall dlasyf_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                            MKL_INT* kb, double* a, const MKL_INT* lda, MKL_INT* ipiv,
                            double* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall dlasyf_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                             MKL_INT* kb, double* a, const MKL_INT* lda, MKL_INT* ipiv,
                             double* w, const MKL_INT* ldw, MKL_INT* info );

void __stdcall DSYCON_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const double* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                            double* rcond, double* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall DSYCON_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const double* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                             double* rcond, double* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall dsycon_rook( const char* uplo, int uplo_len, const MKL_INT* n, const double* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                            double* rcond, double* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall dsycon_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const double* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                             double* rcond, double* work, MKL_INT* iwork, MKL_INT* info );

void __stdcall DSYSV_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs, double* a,
                           const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                           double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DSYSV_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
                            const MKL_INT* ldb, double* work, const MKL_INT* lwork,
                            MKL_INT* info );
void __stdcall dsysv_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs, double* a,
                           const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                           double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsysv_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
                            const MKL_INT* ldb, double* work, const MKL_INT* lwork,
                            MKL_INT* info );

void __stdcall DSYTF2_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, double* a, const MKL_INT* lda,
                            MKL_INT* ipiv, MKL_INT* info );
void __stdcall DSYTF2_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall dsytf2_rook( const char* uplo, int uplo_len, const MKL_INT* n, double* a, const MKL_INT* lda,
                            MKL_INT* ipiv, MKL_INT* info );
void __stdcall dsytf2_rook_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void __stdcall DSYTRF_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, double* a, const MKL_INT* lda,
                            MKL_INT* ipiv, double* work, const MKL_INT* lwork,
                            MKL_INT* info );
void __stdcall DSYTRF_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                             const MKL_INT* lda, MKL_INT* ipiv, double* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsytrf_rook( const char* uplo, int uplo_len, const MKL_INT* n, double* a, const MKL_INT* lda,
                            MKL_INT* ipiv, double* work, const MKL_INT* lwork,
                            MKL_INT* info );
void __stdcall dsytrf_rook_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                             const MKL_INT* lda, MKL_INT* ipiv, double* work,
                             const MKL_INT* lwork, MKL_INT* info );

void __stdcall DSYTRI_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, double* a, const MKL_INT* lda,
                            const MKL_INT* ipiv, double* work, MKL_INT* info );
void __stdcall DSYTRI_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                             MKL_INT* info );
void __stdcall dsytri_rook( const char* uplo, int uplo_len, const MKL_INT* n, double* a, const MKL_INT* lda,
                            const MKL_INT* ipiv, double* work, MKL_INT* info );
void __stdcall dsytri_rook_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                             MKL_INT* info );

void __stdcall DSYTRS_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                            double* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall DSYTRS_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                             const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                             double* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall dsytrs_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                            double* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall dsytrs_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                             const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                             double* b, const MKL_INT* ldb, MKL_INT* info );

void __stdcall SLASYF_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                            MKL_INT* kb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                            float* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall SLASYF_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                             MKL_INT* kb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                             float* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall slasyf_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                            MKL_INT* kb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                            float* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall slasyf_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                             MKL_INT* kb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                             float* w, const MKL_INT* ldw, MKL_INT* info );

void __stdcall SSYCON_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const float* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                            float* rcond, float* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall SSYCON_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const float* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                             float* rcond, float* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall ssycon_rook( const char* uplo, int uplo_len, const MKL_INT* n, const float* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                            float* rcond, float* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall ssycon_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const float* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                             float* rcond, float* work, MKL_INT* iwork, MKL_INT* info );

void __stdcall SSYSV_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs, float* a,
                           const MKL_INT* lda, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                           float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSYSV_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs, float* a,
                            const MKL_INT* lda, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                            float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssysv_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs, float* a,
                           const MKL_INT* lda, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                           float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssysv_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs, float* a,
                            const MKL_INT* lda, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                            float* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SSYTF2_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, float* a, const MKL_INT* lda,
                            MKL_INT* ipiv, MKL_INT* info );
void __stdcall SSYTF2_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, float* a, const MKL_INT* lda,
                             MKL_INT* ipiv, MKL_INT* info );
void __stdcall ssytf2_rook( const char* uplo, int uplo_len, const MKL_INT* n, float* a, const MKL_INT* lda,
                            MKL_INT* ipiv, MKL_INT* info );
void __stdcall ssytf2_rook_( const char* uplo, int uplo_len, const MKL_INT* n, float* a, const MKL_INT* lda,
                             MKL_INT* ipiv, MKL_INT* info );

void __stdcall SSYTRF_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, float* a, const MKL_INT* lda,
                            MKL_INT* ipiv, float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSYTRF_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, float* a, const MKL_INT* lda,
                             MKL_INT* ipiv, float* work, const MKL_INT* lwork,
                             MKL_INT* info );
void __stdcall ssytrf_rook( const char* uplo, int uplo_len, const MKL_INT* n, float* a, const MKL_INT* lda,
                            MKL_INT* ipiv, float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytrf_rook_( const char* uplo, int uplo_len, const MKL_INT* n, float* a, const MKL_INT* lda,
                             MKL_INT* ipiv, float* work, const MKL_INT* lwork,
                             MKL_INT* info );

void __stdcall SSYTRI_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, float* a, const MKL_INT* lda,
                            const MKL_INT* ipiv, float* work, MKL_INT* info );
void __stdcall SSYTRI_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, float* a, const MKL_INT* lda,
                             const MKL_INT* ipiv, float* work, MKL_INT* info );
void __stdcall ssytri_rook( const char* uplo, int uplo_len, const MKL_INT* n, float* a, const MKL_INT* lda,
                            const MKL_INT* ipiv, float* work, MKL_INT* info );
void __stdcall ssytri_rook_( const char* uplo, int uplo_len, const MKL_INT* n, float* a, const MKL_INT* lda,
                             const MKL_INT* ipiv, float* work, MKL_INT* info );

void __stdcall SSYTRS_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            const float* a, const MKL_INT* lda, const MKL_INT* ipiv, float* b,
                            const MKL_INT* ldb, MKL_INT* info );
void __stdcall SSYTRS_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                             const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                             float* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall ssytrs_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            const float* a, const MKL_INT* lda, const MKL_INT* ipiv, float* b,
                            const MKL_INT* ldb, MKL_INT* info );
void __stdcall ssytrs_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                             const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                             float* b, const MKL_INT* ldb, MKL_INT* info );

void __stdcall ZHECON_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex16* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                            double* rcond, MKL_Complex16* work, MKL_INT* info );
void __stdcall ZHECON_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex16* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                             double* rcond, MKL_Complex16* work, MKL_INT* info );
void __stdcall zhecon_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex16* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                            double* rcond, MKL_Complex16* work, MKL_INT* info );
void __stdcall zhecon_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex16* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                             double* rcond, MKL_Complex16* work, MKL_INT* info );

void __stdcall ZHESV_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                           MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                           const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZHESV_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                            const MKL_INT* lwork, MKL_INT* info );
void __stdcall zhesv_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                           MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                           const MKL_INT* lwork, MKL_INT* info );
void __stdcall zhesv_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                            const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZHETF2_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall ZHETF2_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall zhetf2_rook( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall zhetf2_rook_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void __stdcall ZHETRF_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                            const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZHETRF_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall zhetrf_rook( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                            const MKL_INT* lwork, MKL_INT* info );
void __stdcall zhetrf_rook_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                             const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZHETRI_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                            MKL_INT* info );
void __stdcall ZHETRI_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                             MKL_INT* info );
void __stdcall zhetri_rook( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                            MKL_INT* info );
void __stdcall zhetri_rook_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                             MKL_INT* info );

void __stdcall ZHETRS_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                            MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall ZHETRS_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                             const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                             MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall zhetrs_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                            MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall zhetrs_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                             const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                             MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );

void __stdcall ZLAHEF_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                            MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall ZLAHEF_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                             MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                             MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall zlahef_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                            MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall zlahef_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                             MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                             MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );

void __stdcall ZLASYF_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                            MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall ZLASYF_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                             MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                             MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall zlasyf_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                            MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall zlasyf_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                             MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                             MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );

void __stdcall ZSYCON_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex16* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                            double* rcond, MKL_Complex16* work, MKL_INT* info );
void __stdcall ZSYCON_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex16* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                             double* rcond, MKL_Complex16* work, MKL_INT* info );
void __stdcall zsycon_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex16* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                            double* rcond, MKL_Complex16* work, MKL_INT* info );
void __stdcall zsycon_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex16* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                             double* rcond, MKL_Complex16* work, MKL_INT* info );

void __stdcall ZSYSV_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                           MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                           const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZSYSV_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                            const MKL_INT* lwork, MKL_INT* info );
void __stdcall zsysv_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                           MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                           MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                           const MKL_INT* lwork, MKL_INT* info );
void __stdcall zsysv_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                            MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                            const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZSYTF2_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall ZSYTF2_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall zsytf2_rook( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall zsytf2_rook_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void __stdcall ZSYTRF_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                            const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZSYTRF_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                             const MKL_INT* lwork, MKL_INT* info );
void __stdcall zsytrf_rook( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                            const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                            const MKL_INT* lwork, MKL_INT* info );
void __stdcall zsytrf_rook_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                             const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZSYTRI_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                            MKL_INT* info );
void __stdcall ZSYTRI_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                             MKL_INT* info );
void __stdcall zsytri_rook( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                            const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                            MKL_INT* info );
void __stdcall zsytri_rook_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                             MKL_INT* info );

void __stdcall ZSYTRS_ROOK( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                            MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall ZSYTRS_ROOK_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                             const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                             MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall zsytrs_rook( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                            const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                            MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall zsytrs_rook_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                             const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                             MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );







void __stdcall CUNBDB1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall CUNBDB1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                         MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cunbdb1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cunbdb1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                         MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall CUNBDB2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall CUNBDB2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                         MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cunbdb2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cunbdb2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                         MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall CUNBDB3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall CUNBDB3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                         MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cunbdb3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cunbdb3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                         MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall CUNBDB4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                        MKL_Complex8* phantom, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall CUNBDB4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                         MKL_Complex8* phantom, MKL_Complex8* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall cunbdb4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                        MKL_Complex8* phantom, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall cunbdb4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
                         MKL_Complex8* phantom, MKL_Complex8* work, const MKL_INT* lwork,
                         MKL_INT* info );

void __stdcall CUNBDB5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
                        const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
                        MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall CUNBDB5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
                         const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
                         MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall cunbdb5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
                        const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
                        MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall cunbdb5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
                         const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
                         MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall CUNBDB6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
                        const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
                        MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall CUNBDB6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
                         const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
                         MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall cunbdb6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
                        const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
                        MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall cunbdb6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
                         const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
                         MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall CUNCSD2BY1( const char* jobu1, int jobu1_len, const char* jobu2,
                           int jobu2_len, const char* jobv1t, int jobv1t_len,
                           const MKL_INT* m, const MKL_INT* p,
                           const MKL_INT* q, MKL_Complex8* x11,
                           const MKL_INT* ldx11, MKL_Complex8* x21,
                           const MKL_INT* ldx21, float* theta,
                           MKL_Complex8* u1, const MKL_INT* ldu1,
                           MKL_Complex8* u2, const MKL_INT* ldu2,
                           MKL_Complex8* v1t, const MKL_INT* ldv1t,
                           MKL_Complex8* work, const MKL_INT* lwork,
                           float* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                           MKL_INT* info );
void __stdcall CUNCSD2BY1_( const char* jobu1, int jobu1_len,
                            const char* jobu2, int jobu2_len,
                            const char* jobv1t, int jobv1t_len,
                            const MKL_INT* m, const MKL_INT* p,
                            const MKL_INT* q, MKL_Complex8* x11,
                            const MKL_INT* ldx11, MKL_Complex8* x21,
                            const MKL_INT* ldx21, float* theta,
                            MKL_Complex8* u1, const MKL_INT* ldu1,
                            MKL_Complex8* u2, const MKL_INT* ldu2,
                            MKL_Complex8* v1t, const MKL_INT* ldv1t,
                            MKL_Complex8* work, const MKL_INT* lwork,
                            float* rwork, const MKL_INT* lrwork,
                            MKL_INT* iwork, MKL_INT* info );
void __stdcall cuncsd2by1( const char* jobu1, int jobu1_len, const char* jobu2,
                           int jobu2_len, const char* jobv1t, int jobv1t_len,
                           const MKL_INT* m, const MKL_INT* p,
                           const MKL_INT* q, MKL_Complex8* x11,
                           const MKL_INT* ldx11, MKL_Complex8* x21,
                           const MKL_INT* ldx21, float* theta,
                           MKL_Complex8* u1, const MKL_INT* ldu1,
                           MKL_Complex8* u2, const MKL_INT* ldu2,
                           MKL_Complex8* v1t, const MKL_INT* ldv1t,
                           MKL_Complex8* work, const MKL_INT* lwork,
                           float* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                           MKL_INT* info );
void __stdcall cuncsd2by1_( const char* jobu1, int jobu1_len,
                            const char* jobu2, int jobu2_len,
                            const char* jobv1t, int jobv1t_len,
                            const MKL_INT* m, const MKL_INT* p,
                            const MKL_INT* q, MKL_Complex8* x11,
                            const MKL_INT* ldx11, MKL_Complex8* x21,
                            const MKL_INT* ldx21, float* theta,
                            MKL_Complex8* u1, const MKL_INT* ldu1,
                            MKL_Complex8* u2, const MKL_INT* ldu2,
                            MKL_Complex8* v1t, const MKL_INT* ldv1t,
                            MKL_Complex8* work, const MKL_INT* lwork,
                            float* rwork, const MKL_INT* lrwork,
                            MKL_INT* iwork, MKL_INT* info );

void __stdcall DORBDB1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        double* x11, const MKL_INT* ldx11, double* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        double* taup1, double* taup2, double* tauq1,
                        double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DORBDB1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         double* x11, const MKL_INT* ldx11, double* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         double* taup1, double* taup2, double* tauq1,
                         double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorbdb1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        double* x11, const MKL_INT* ldx11, double* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        double* taup1, double* taup2, double* tauq1,
                        double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorbdb1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         double* x11, const MKL_INT* ldx11, double* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         double* taup1, double* taup2, double* tauq1,
                         double* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall DORBDB2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        double* x11, const MKL_INT* ldx11, double* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        double* taup1, double* taup2, double* tauq1,
                        double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DORBDB2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         double* x11, const MKL_INT* ldx11, double* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         double* taup1, double* taup2, double* tauq1,
                         double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorbdb2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        double* x11, const MKL_INT* ldx11, double* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        double* taup1, double* taup2, double* tauq1,
                        double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorbdb2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         double* x11, const MKL_INT* ldx11, double* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         double* taup1, double* taup2, double* tauq1,
                         double* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall DORBDB3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        double* x11, const MKL_INT* ldx11, double* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        double* taup1, double* taup2, double* tauq1,
                        double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall DORBDB3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         double* x11, const MKL_INT* ldx11, double* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         double* taup1, double* taup2, double* tauq1,
                         double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorbdb3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        double* x11, const MKL_INT* ldx11, double* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        double* taup1, double* taup2, double* tauq1,
                        double* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorbdb3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         double* x11, const MKL_INT* ldx11, double* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         double* taup1, double* taup2, double* tauq1,
                         double* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall DORBDB4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        double* x11, const MKL_INT* ldx11, double* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        double* taup1, double* taup2, double* tauq1,
                        double* phantom, double* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall DORBDB4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         double* x11, const MKL_INT* ldx11, double* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         double* taup1, double* taup2, double* tauq1,
                         double* phantom, double* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall dorbdb4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        double* x11, const MKL_INT* ldx11, double* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        double* taup1, double* taup2, double* tauq1,
                        double* phantom, double* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall dorbdb4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         double* x11, const MKL_INT* ldx11, double* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         double* taup1, double* taup2, double* tauq1,
                         double* phantom, double* work, const MKL_INT* lwork,
                         MKL_INT* info );

void __stdcall DORBDB5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        double* x1, const MKL_INT* incx1, double* x2,
                        const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
                        double* q2, const MKL_INT* ldq2, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall DORBDB5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         double* x1, const MKL_INT* incx1, double* x2,
                         const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
                         double* q2, const MKL_INT* ldq2, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorbdb5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        double* x1, const MKL_INT* incx1, double* x2,
                        const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
                        double* q2, const MKL_INT* ldq2, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorbdb5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         double* x1, const MKL_INT* incx1, double* x2,
                         const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
                         double* q2, const MKL_INT* ldq2, double* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall DORBDB6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        double* x1, const MKL_INT* incx1, double* x2,
                        const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
                        double* q2, const MKL_INT* ldq2, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall DORBDB6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         double* x1, const MKL_INT* incx1, double* x2,
                         const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
                         double* q2, const MKL_INT* ldq2, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorbdb6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        double* x1, const MKL_INT* incx1, double* x2,
                        const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
                        double* q2, const MKL_INT* ldq2, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall dorbdb6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         double* x1, const MKL_INT* incx1, double* x2,
                         const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
                         double* q2, const MKL_INT* ldq2, double* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall DORCSD2BY1( const char* jobu1, int jobu1_len, const char* jobu2,
                           int jobu2_len, const char* jobv1t, int jobv1t_len,
                           const MKL_INT* m, const MKL_INT* p,
                           const MKL_INT* q, double* x11, const MKL_INT* ldx11,
                           double* x21, const MKL_INT* ldx21, double* theta,
                           double* u1, const MKL_INT* ldu1, double* u2,
                           const MKL_INT* ldu2, double* v1t,
                           const MKL_INT* ldv1t, double* work,
                           const MKL_INT* lwork, MKL_INT* iwork,
                           MKL_INT* info );
void __stdcall DORCSD2BY1_( const char* jobu1, int jobu1_len,
                            const char* jobu2, int jobu2_len,
                            const char* jobv1t, int jobv1t_len,
                            const MKL_INT* m, const MKL_INT* p,
                            const MKL_INT* q, double* x11,
                            const MKL_INT* ldx11, double* x21,
                            const MKL_INT* ldx21, double* theta, double* u1,
                            const MKL_INT* ldu1, double* u2,
                            const MKL_INT* ldu2, double* v1t,
                            const MKL_INT* ldv1t, double* work,
                            const MKL_INT* lwork, MKL_INT* iwork,
                            MKL_INT* info );
void __stdcall dorcsd2by1( const char* jobu1, int jobu1_len, const char* jobu2,
                           int jobu2_len, const char* jobv1t, int jobv1t_len,
                           const MKL_INT* m, const MKL_INT* p,
                           const MKL_INT* q, double* x11, const MKL_INT* ldx11,
                           double* x21, const MKL_INT* ldx21, double* theta,
                           double* u1, const MKL_INT* ldu1, double* u2,
                           const MKL_INT* ldu2, double* v1t,
                           const MKL_INT* ldv1t, double* work,
                           const MKL_INT* lwork, MKL_INT* iwork,
                           MKL_INT* info );
void __stdcall dorcsd2by1_( const char* jobu1, int jobu1_len,
                            const char* jobu2, int jobu2_len,
                            const char* jobv1t, int jobv1t_len,
                            const MKL_INT* m, const MKL_INT* p,
                            const MKL_INT* q, double* x11,
                            const MKL_INT* ldx11, double* x21,
                            const MKL_INT* ldx21, double* theta, double* u1,
                            const MKL_INT* ldu1, double* u2,
                            const MKL_INT* ldu2, double* v1t,
                            const MKL_INT* ldv1t, double* work,
                            const MKL_INT* lwork, MKL_INT* iwork,
                            MKL_INT* info );

void __stdcall SORBDB1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        float* x11, const MKL_INT* ldx11, float* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        float* taup1, float* taup2, float* tauq1,
                        float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SORBDB1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         float* x11, const MKL_INT* ldx11, float* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         float* taup1, float* taup2, float* tauq1,
                         float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorbdb1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        float* x11, const MKL_INT* ldx11, float* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        float* taup1, float* taup2, float* tauq1,
                        float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorbdb1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         float* x11, const MKL_INT* ldx11, float* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         float* taup1, float* taup2, float* tauq1,
                         float* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SORBDB2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        float* x11, const MKL_INT* ldx11, float* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        float* taup1, float* taup2, float* tauq1,
                        float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SORBDB2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         float* x11, const MKL_INT* ldx11, float* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         float* taup1, float* taup2, float* tauq1,
                         float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorbdb2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        float* x11, const MKL_INT* ldx11, float* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        float* taup1, float* taup2, float* tauq1,
                        float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorbdb2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         float* x11, const MKL_INT* ldx11, float* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         float* taup1, float* taup2, float* tauq1,
                         float* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SORBDB3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        float* x11, const MKL_INT* ldx11, float* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        float* taup1, float* taup2, float* tauq1,
                        float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall SORBDB3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         float* x11, const MKL_INT* ldx11, float* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         float* taup1, float* taup2, float* tauq1,
                         float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorbdb3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        float* x11, const MKL_INT* ldx11, float* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        float* taup1, float* taup2, float* tauq1,
                        float* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorbdb3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         float* x11, const MKL_INT* ldx11, float* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         float* taup1, float* taup2, float* tauq1,
                         float* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall SORBDB4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        float* x11, const MKL_INT* ldx11, float* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        float* taup1, float* taup2, float* tauq1,
                        float* phantom, float* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall SORBDB4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         float* x11, const MKL_INT* ldx11, float* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         float* taup1, float* taup2, float* tauq1,
                         float* phantom, float* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall sorbdb4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        float* x11, const MKL_INT* ldx11, float* x21,
                        const MKL_INT* ldx21, float* theta, float* phi,
                        float* taup1, float* taup2, float* tauq1,
                        float* phantom, float* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall sorbdb4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         float* x11, const MKL_INT* ldx11, float* x21,
                         const MKL_INT* ldx21, float* theta, float* phi,
                         float* taup1, float* taup2, float* tauq1,
                         float* phantom, float* work, const MKL_INT* lwork,
                         MKL_INT* info );

void __stdcall SORBDB5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        float* x1, const MKL_INT* incx1, float* x2,
                        const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
                        float* q2, const MKL_INT* ldq2, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall SORBDB5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         float* x1, const MKL_INT* incx1, float* x2,
                         const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
                         float* q2, const MKL_INT* ldq2, float* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorbdb5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        float* x1, const MKL_INT* incx1, float* x2,
                        const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
                        float* q2, const MKL_INT* ldq2, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorbdb5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         float* x1, const MKL_INT* incx1, float* x2,
                         const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
                         float* q2, const MKL_INT* ldq2, float* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall SORBDB6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        float* x1, const MKL_INT* incx1, float* x2,
                        const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
                        float* q2, const MKL_INT* ldq2, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall SORBDB6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         float* x1, const MKL_INT* incx1, float* x2,
                         const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
                         float* q2, const MKL_INT* ldq2, float* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorbdb6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        float* x1, const MKL_INT* incx1, float* x2,
                        const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
                        float* q2, const MKL_INT* ldq2, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall sorbdb6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         float* x1, const MKL_INT* incx1, float* x2,
                         const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
                         float* q2, const MKL_INT* ldq2, float* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall SORCSD2BY1( const char* jobu1, int jobu1_len, const char* jobu2,
                           int jobu2_len, const char* jobv1t, int jobv1t_len,
                           const MKL_INT* m, const MKL_INT* p,
                           const MKL_INT* q, float* x11, const MKL_INT* ldx11,
                           float* x21, const MKL_INT* ldx21, float* theta,
                           float* u1, const MKL_INT* ldu1, float* u2,
                           const MKL_INT* ldu2, float* v1t,
                           const MKL_INT* ldv1t, float* work,
                           const MKL_INT* lwork, MKL_INT* iwork,
                           MKL_INT* info );
void __stdcall SORCSD2BY1_( const char* jobu1, int jobu1_len,
                            const char* jobu2, int jobu2_len,
                            const char* jobv1t, int jobv1t_len,
                            const MKL_INT* m, const MKL_INT* p,
                            const MKL_INT* q, float* x11, const MKL_INT* ldx11,
                            float* x21, const MKL_INT* ldx21, float* theta,
                            float* u1, const MKL_INT* ldu1, float* u2,
                            const MKL_INT* ldu2, float* v1t,
                            const MKL_INT* ldv1t, float* work,
                            const MKL_INT* lwork, MKL_INT* iwork,
                            MKL_INT* info );
void __stdcall sorcsd2by1( const char* jobu1, int jobu1_len, const char* jobu2,
                           int jobu2_len, const char* jobv1t, int jobv1t_len,
                           const MKL_INT* m, const MKL_INT* p,
                           const MKL_INT* q, float* x11, const MKL_INT* ldx11,
                           float* x21, const MKL_INT* ldx21, float* theta,
                           float* u1, const MKL_INT* ldu1, float* u2,
                           const MKL_INT* ldu2, float* v1t,
                           const MKL_INT* ldv1t, float* work,
                           const MKL_INT* lwork, MKL_INT* iwork,
                           MKL_INT* info );
void __stdcall sorcsd2by1_( const char* jobu1, int jobu1_len,
                            const char* jobu2, int jobu2_len,
                            const char* jobv1t, int jobv1t_len,
                            const MKL_INT* m, const MKL_INT* p,
                            const MKL_INT* q, float* x11, const MKL_INT* ldx11,
                            float* x21, const MKL_INT* ldx21, float* theta,
                            float* u1, const MKL_INT* ldu1, float* u2,
                            const MKL_INT* ldu2, float* v1t,
                            const MKL_INT* ldv1t, float* work,
                            const MKL_INT* lwork, MKL_INT* iwork,
                            MKL_INT* info );

void __stdcall ZUNBDB1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                        MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZUNBDB1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                         MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall zunbdb1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                        MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall zunbdb1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                         MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZUNBDB2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                        MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZUNBDB2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                         MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall zunbdb2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                        MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall zunbdb2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                         MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZUNBDB3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                        MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZUNBDB3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                         MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall zunbdb3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                        MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall zunbdb3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                         MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZUNBDB4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                        MKL_Complex16* phantom, MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall ZUNBDB4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                         MKL_Complex16* phantom, MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );
void __stdcall zunbdb4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                        MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                        const MKL_INT* ldx21, double* theta, double* phi,
                        MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                        MKL_Complex16* phantom, MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall zunbdb4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                         MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                         const MKL_INT* ldx21, double* theta, double* phi,
                         MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
                         MKL_Complex16* phantom, MKL_Complex16* work, const MKL_INT* lwork,
                         MKL_INT* info );

void __stdcall ZUNBDB5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
                        const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
                        MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZUNBDB5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
                         const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
                         MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall zunbdb5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
                        const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
                        MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall zunbdb5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
                         const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
                         MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZUNBDB6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
                        const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
                        MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZUNBDB6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
                         const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
                         MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall zunbdb6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                        MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
                        const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
                        MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall zunbdb6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
                         MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
                         const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
                         MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZUNCSD2BY1( const char* jobu1, int jobu1_len, const char* jobu2,
                           int jobu2_len, const char* jobv1t, int jobv1t_len,
                           const MKL_INT* m, const MKL_INT* p,
                           const MKL_INT* q, MKL_Complex16* x11,
                           const MKL_INT* ldx11, MKL_Complex16* x21,
                           const MKL_INT* ldx21, double* theta,
                           MKL_Complex16* u1, const MKL_INT* ldu1,
                           MKL_Complex16* u2, const MKL_INT* ldu2,
                           MKL_Complex16* v1t, const MKL_INT* ldv1t,
                           MKL_Complex16* work, const MKL_INT* lwork,
                           double* rwork, const MKL_INT* lrwork,
                           MKL_INT* iwork, MKL_INT* info );
void __stdcall ZUNCSD2BY1_( const char* jobu1, int jobu1_len,
                            const char* jobu2, int jobu2_len,
                            const char* jobv1t, int jobv1t_len,
                            const MKL_INT* m, const MKL_INT* p,
                            const MKL_INT* q, MKL_Complex16* x11,
                            const MKL_INT* ldx11, MKL_Complex16* x21,
                            const MKL_INT* ldx21, double* theta,
                            MKL_Complex16* u1, const MKL_INT* ldu1,
                            MKL_Complex16* u2, const MKL_INT* ldu2,
                            MKL_Complex16* v1t, const MKL_INT* ldv1t,
                            MKL_Complex16* work, const MKL_INT* lwork,
                            double* rwork, const MKL_INT* lrwork,
                            MKL_INT* iwork, MKL_INT* info );
void __stdcall zuncsd2by1( const char* jobu1, int jobu1_len, const char* jobu2,
                           int jobu2_len, const char* jobv1t, int jobv1t_len,
                           const MKL_INT* m, const MKL_INT* p,
                           const MKL_INT* q, MKL_Complex16* x11,
                           const MKL_INT* ldx11, MKL_Complex16* x21,
                           const MKL_INT* ldx21, double* theta,
                           MKL_Complex16* u1, const MKL_INT* ldu1,
                           MKL_Complex16* u2, const MKL_INT* ldu2,
                           MKL_Complex16* v1t, const MKL_INT* ldv1t,
                           MKL_Complex16* work, const MKL_INT* lwork,
                           double* rwork, const MKL_INT* lrwork,
                           MKL_INT* iwork, MKL_INT* info );
void __stdcall zuncsd2by1_( const char* jobu1, int jobu1_len,
                            const char* jobu2, int jobu2_len,
                            const char* jobv1t, int jobv1t_len,
                            const MKL_INT* m, const MKL_INT* p,
                            const MKL_INT* q, MKL_Complex16* x11,
                            const MKL_INT* ldx11, MKL_Complex16* x21,
                            const MKL_INT* ldx21, double* theta,
                            MKL_Complex16* u1, const MKL_INT* ldu1,
                            MKL_Complex16* u2, const MKL_INT* ldu2,
                            MKL_Complex16* v1t, const MKL_INT* ldv1t,
                            MKL_Complex16* work, const MKL_INT* lwork,
                            double* rwork, const MKL_INT* lrwork,
                            MKL_INT* iwork, MKL_INT* info );

/* LAPACK 3.4.0 routines */

void __stdcall CGEMQRT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* nb,
                        const MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* c, const MKL_INT* ldc,
                        MKL_Complex8* work, MKL_INT* info );
void __stdcall CGEMQRT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* nb,
                         const MKL_Complex8* v, const MKL_INT* ldv,
                         const MKL_Complex8* t, const MKL_INT* ldt,
                         MKL_Complex8* c, const MKL_INT* ldc,
                         MKL_Complex8* work, MKL_INT* info );
void __stdcall cgemqrt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* nb,
                        const MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* c, const MKL_INT* ldc,
                        MKL_Complex8* work, MKL_INT* info );
void __stdcall cgemqrt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* nb,
                         const MKL_Complex8* v, const MKL_INT* ldv,
                         const MKL_Complex8* t, const MKL_INT* ldt,
                         MKL_Complex8* c, const MKL_INT* ldc,
                         MKL_Complex8* work, MKL_INT* info );

void __stdcall DGEMQRT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* nb, const double* v,
                        const MKL_INT* ldv, const double* t,
                        const MKL_INT* ldt, double* c, const MKL_INT* ldc,
                        double* work, MKL_INT* info );
void __stdcall DGEMQRT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* nb, const double* v,
                         const MKL_INT* ldv, const double* t,
                         const MKL_INT* ldt, double* c, const MKL_INT* ldc,
                         double* work, MKL_INT* info );
void __stdcall dgemqrt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* nb, const double* v,
                        const MKL_INT* ldv, const double* t,
                        const MKL_INT* ldt, double* c, const MKL_INT* ldc,
                        double* work, MKL_INT* info );
void __stdcall dgemqrt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* nb, const double* v,
                         const MKL_INT* ldv, const double* t,
                         const MKL_INT* ldt, double* c, const MKL_INT* ldc,
                         double* work, MKL_INT* info );

void __stdcall SGEMQRT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* nb, const float* v,
                        const MKL_INT* ldv, const float* t,
                        const MKL_INT* ldt, float* c, const MKL_INT* ldc,
                        float* work, MKL_INT* info );
void __stdcall SGEMQRT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* nb, const float* v,
                         const MKL_INT* ldv, const float* t,
                         const MKL_INT* ldt, float* c, const MKL_INT* ldc,
                         float* work, MKL_INT* info );
void __stdcall sgemqrt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* nb, const float* v,
                        const MKL_INT* ldv, const float* t,
                        const MKL_INT* ldt, float* c, const MKL_INT* ldc,
                        float* work, MKL_INT* info );
void __stdcall sgemqrt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* nb, const float* v,
                         const MKL_INT* ldv, const float* t,
                         const MKL_INT* ldt, float* c, const MKL_INT* ldc,
                         float* work, MKL_INT* info );

void __stdcall ZGEMQRT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* nb,
                        const MKL_Complex16* v, const MKL_INT* ldv,
                        const MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* c, const MKL_INT* ldc,
                        MKL_Complex16* work, MKL_INT* info );
void __stdcall ZGEMQRT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* nb,
                         const MKL_Complex16* v, const MKL_INT* ldv,
                         const MKL_Complex16* t, const MKL_INT* ldt,
                         MKL_Complex16* c, const MKL_INT* ldc,
                         MKL_Complex16* work, MKL_INT* info );
void __stdcall zgemqrt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* nb,
                        const MKL_Complex16* v, const MKL_INT* ldv,
                        const MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* c, const MKL_INT* ldc,
                        MKL_Complex16* work, MKL_INT* info );
void __stdcall zgemqrt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* nb,
                         const MKL_Complex16* v, const MKL_INT* ldv,
                         const MKL_Complex16* t, const MKL_INT* ldt,
                         MKL_Complex16* c, const MKL_INT* ldc,
                         MKL_Complex16* work, MKL_INT* info );

void __stdcall CGEQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
                       const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void __stdcall CGEQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void __stdcall cgeqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
                       const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void __stdcall cgeqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );

void __stdcall DGEQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                       double* a, const MKL_INT* lda, double* t,
                       const MKL_INT* ldt, double* work, MKL_INT* info );
void __stdcall DGEQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                        double* a, const MKL_INT* lda, double* t,
                        const MKL_INT* ldt, double* work, MKL_INT* info );
void __stdcall dgeqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                       double* a, const MKL_INT* lda, double* t,
                       const MKL_INT* ldt, double* work, MKL_INT* info );
void __stdcall dgeqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                        double* a, const MKL_INT* lda, double* t,
                        const MKL_INT* ldt, double* work, MKL_INT* info );

void __stdcall SGEQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                       float* a, const MKL_INT* lda, float* t,
                       const MKL_INT* ldt, float* work, MKL_INT* info );
void __stdcall SGEQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                        float* a, const MKL_INT* lda, float* t,
                        const MKL_INT* ldt, float* work, MKL_INT* info );
void __stdcall sgeqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                       float* a, const MKL_INT* lda, float* t,
                       const MKL_INT* ldt, float* work, MKL_INT* info );
void __stdcall sgeqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                        float* a, const MKL_INT* lda, float* t,
                        const MKL_INT* ldt, float* work, MKL_INT* info );

void __stdcall ZGEQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
                       const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );
void __stdcall ZGEQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                        MKL_Complex16* a, const MKL_INT* lda,
                        MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* work, MKL_INT* info );
void __stdcall zgeqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
                       const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );
void __stdcall zgeqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                        MKL_Complex16* a, const MKL_INT* lda,
                        MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* work, MKL_INT* info );

void __stdcall CGEQRT3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall CGEQRT3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_INT* info );
void __stdcall cgeqrt3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall cgeqrt3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_INT* info );

void __stdcall DGEQRT3( const MKL_INT* m, const MKL_INT* n, double* a,
                        const MKL_INT* lda, double* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall DGEQRT3_( const MKL_INT* m, const MKL_INT* n, double* a,
                         const MKL_INT* lda, double* t, const MKL_INT* ldt,
                         MKL_INT* info );
void __stdcall dgeqrt3( const MKL_INT* m, const MKL_INT* n, double* a,
                        const MKL_INT* lda, double* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall dgeqrt3_( const MKL_INT* m, const MKL_INT* n, double* a,
                         const MKL_INT* lda, double* t, const MKL_INT* ldt,
                         MKL_INT* info );

void __stdcall SGEQRT3( const MKL_INT* m, const MKL_INT* n, float* a,
                        const MKL_INT* lda, float* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall SGEQRT3_( const MKL_INT* m, const MKL_INT* n, float* a,
                         const MKL_INT* lda, float* t, const MKL_INT* ldt,
                         MKL_INT* info );
void __stdcall sgeqrt3( const MKL_INT* m, const MKL_INT* n, float* a,
                        const MKL_INT* lda, float* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall sgeqrt3_( const MKL_INT* m, const MKL_INT* n, float* a,
                         const MKL_INT* lda, float* t, const MKL_INT* ldt,
                         MKL_INT* info );

void __stdcall ZGEQRT3( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall ZGEQRT3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_INT* info );
void __stdcall zgeqrt3( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall zgeqrt3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_INT* info );

void __stdcall CTPMQRT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
                        const MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info );
void __stdcall CTPMQRT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l,
                         const MKL_INT* nb, const MKL_Complex8* v,
                         const MKL_INT* ldv, const MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* work,
                         MKL_INT* info );
void __stdcall ctpmqrt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
                        const MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info );
void __stdcall ctpmqrt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l,
                         const MKL_INT* nb, const MKL_Complex8* v,
                         const MKL_INT* ldv, const MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* work,
                         MKL_INT* info );

void __stdcall DTPMQRT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
                        const double* v, const MKL_INT* ldv, const double* t,
                        const MKL_INT* ldt, double* a, const MKL_INT* lda,
                        double* b, const MKL_INT* ldb, double* work,
                        MKL_INT* info );
void __stdcall DTPMQRT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l,
                         const MKL_INT* nb, const double* v,
                         const MKL_INT* ldv, const double* t,
                         const MKL_INT* ldt, double* a, const MKL_INT* lda,
                         double* b, const MKL_INT* ldb, double* work,
                         MKL_INT* info );
void __stdcall dtpmqrt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
                        const double* v, const MKL_INT* ldv, const double* t,
                        const MKL_INT* ldt, double* a, const MKL_INT* lda,
                        double* b, const MKL_INT* ldb, double* work,
                        MKL_INT* info );
void __stdcall dtpmqrt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l,
                         const MKL_INT* nb, const double* v,
                         const MKL_INT* ldv, const double* t,
                         const MKL_INT* ldt, double* a, const MKL_INT* lda,
                         double* b, const MKL_INT* ldb, double* work,
                         MKL_INT* info );

void __stdcall STPMQRT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
                        const float* v, const MKL_INT* ldv, const float* t,
                        const MKL_INT* ldt, float* a, const MKL_INT* lda,
                        float* b, const MKL_INT* ldb, float* work,
                        MKL_INT* info );
void __stdcall STPMQRT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l,
                         const MKL_INT* nb, const float* v,
                         const MKL_INT* ldv, const float* t,
                         const MKL_INT* ldt, float* a, const MKL_INT* lda,
                         float* b, const MKL_INT* ldb, float* work,
                         MKL_INT* info );
void __stdcall stpmqrt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
                        const float* v, const MKL_INT* ldv, const float* t,
                        const MKL_INT* ldt, float* a, const MKL_INT* lda,
                        float* b, const MKL_INT* ldb, float* work,
                        MKL_INT* info );
void __stdcall stpmqrt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l,
                         const MKL_INT* nb, const float* v,
                         const MKL_INT* ldv, const float* t,
                         const MKL_INT* ldt, float* a, const MKL_INT* lda,
                         float* b, const MKL_INT* ldb, float* work,
                         MKL_INT* info );

void __stdcall ZTPMQRT( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
                        const MKL_Complex16* v, const MKL_INT* ldv,
                        const MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* a, const MKL_INT* lda,
                        MKL_Complex16* b, const MKL_INT* ldb,
                        MKL_Complex16* work, MKL_INT* info );
void __stdcall ZTPMQRT_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l,
                         const MKL_INT* nb, const MKL_Complex16* v,
                         const MKL_INT* ldv, const MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* b,
                         const MKL_INT* ldb, MKL_Complex16* work,
                         MKL_INT* info );
void __stdcall ztpmqrt( const char* side, int side_len, const char* trans,
                        int trans_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
                        const MKL_Complex16* v, const MKL_INT* ldv,
                        const MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* a, const MKL_INT* lda,
                        MKL_Complex16* b, const MKL_INT* ldb,
                        MKL_Complex16* work, MKL_INT* info );
void __stdcall ztpmqrt_( const char* side, int side_len, const char* trans,
                         int trans_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_INT* k, const MKL_INT* l,
                         const MKL_INT* nb, const MKL_Complex16* v,
                         const MKL_INT* ldv, const MKL_Complex16* t,
                         const MKL_INT* ldt, MKL_Complex16* a,
                         const MKL_INT* lda, MKL_Complex16* b,
                         const MKL_INT* ldb, MKL_Complex16* work,
                         MKL_INT* info );

void __stdcall CTPQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                       MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* t, const MKL_INT* ldt,
                       MKL_Complex8* work, MKL_INT* info );
void __stdcall CTPQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                        MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* work, MKL_INT* info );
void __stdcall ctpqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                       MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* t, const MKL_INT* ldt,
                       MKL_Complex8* work, MKL_INT* info );
void __stdcall ctpqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                        MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* work, MKL_INT* info );

void __stdcall DTPQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                       double* a, const MKL_INT* lda,
                       double* b, const MKL_INT* ldb,
                       double* t, const MKL_INT* ldt,
                       double* work, MKL_INT* info );
void __stdcall DTPQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                        double* a, const MKL_INT* lda,
                        double* b, const MKL_INT* ldb,
                        double* t, const MKL_INT* ldt,
                        double* work, MKL_INT* info );
void __stdcall dtpqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                       double* a, const MKL_INT* lda,
                       double* b, const MKL_INT* ldb,
                       double* t, const MKL_INT* ldt,
                       double* work, MKL_INT* info );
void __stdcall dtpqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                        double* a, const MKL_INT* lda,
                        double* b, const MKL_INT* ldb,
                        double* t, const MKL_INT* ldt,
                        double* work, MKL_INT* info );

void __stdcall STPQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                       float* a, const MKL_INT* lda,
                       float* b, const MKL_INT* ldb,
                       float* t, const MKL_INT* ldt,
                       float* work, MKL_INT* info );
void __stdcall STPQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                        float* a, const MKL_INT* lda,
                        float* b, const MKL_INT* ldb,
                        float* t, const MKL_INT* ldt,
                        float* work, MKL_INT* info );
void __stdcall stpqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                       float* a, const MKL_INT* lda,
                       float* b, const MKL_INT* ldb,
                       float* t, const MKL_INT* ldt,
                       float* work, MKL_INT* info );
void __stdcall stpqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                        float* a, const MKL_INT* lda,
                        float* b, const MKL_INT* ldb,
                        float* t, const MKL_INT* ldt,
                        float* work, MKL_INT* info );

void __stdcall ZTPQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                       MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_Complex16* t, const MKL_INT* ldt,
                       MKL_Complex16* work, MKL_INT* info );
void __stdcall ZTPQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                        MKL_Complex16* a, const MKL_INT* lda,
                        MKL_Complex16* b, const MKL_INT* ldb,
                        MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* work, MKL_INT* info );
void __stdcall ztpqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                       MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_Complex16* t, const MKL_INT* ldt,
                       MKL_Complex16* work, MKL_INT* info );
void __stdcall ztpqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
                        MKL_Complex16* a, const MKL_INT* lda,
                        MKL_Complex16* b, const MKL_INT* ldb,
                        MKL_Complex16* t, const MKL_INT* ldt,
                        MKL_Complex16* work, MKL_INT* info );

void __stdcall CTPQRT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall CTPQRT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_INT* info );
void __stdcall ctpqrt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_INT* info );
void __stdcall ctpqrt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* t,
                         const MKL_INT* ldt, MKL_INT* info );

void __stdcall DTPQRT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        double* a, const MKL_INT* lda, double* b,
                        const MKL_INT* ldb, double* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall DTPQRT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         double* a, const MKL_INT* lda, double* b,
                         const MKL_INT* ldb, double* t, const MKL_INT* ldt,
                         MKL_INT* info );
void __stdcall dtpqrt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        double* a, const MKL_INT* lda, double* b,
                        const MKL_INT* ldb, double* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall dtpqrt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         double* a, const MKL_INT* lda, double* b,
                         const MKL_INT* ldb, double* t, const MKL_INT* ldt,
                         MKL_INT* info );

void __stdcall STPQRT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        float* a, const MKL_INT* lda, float* b,
                        const MKL_INT* ldb, float* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall STPQRT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         float* a, const MKL_INT* lda, float* b,
                         const MKL_INT* ldb, float* t, const MKL_INT* ldt,
                         MKL_INT* info );
void __stdcall stpqrt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        float* a, const MKL_INT* lda, float* b,
                        const MKL_INT* ldb, float* t, const MKL_INT* ldt,
                        MKL_INT* info );
void __stdcall stpqrt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         float* a, const MKL_INT* lda, float* b,
                         const MKL_INT* ldb, float* t, const MKL_INT* ldt,
                         MKL_INT* info );

void __stdcall ZTPQRT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        MKL_Complex16* a, const MKL_INT* lda,
                        MKL_Complex16* b, const MKL_INT* ldb,
                        MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );
void __stdcall ZTPQRT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         MKL_Complex16* a, const MKL_INT* lda,
                         MKL_Complex16* b, const MKL_INT* ldb,
                         MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );
void __stdcall ztpqrt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        MKL_Complex16* a, const MKL_INT* lda,
                        MKL_Complex16* b, const MKL_INT* ldb,
                        MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );
void __stdcall ztpqrt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                         MKL_Complex16* a, const MKL_INT* lda,
                         MKL_Complex16* b, const MKL_INT* ldb,
                         MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );


/* LAPACK 3.3.0 routines */

void __stdcall CBBCSD( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
                       MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
                       const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
                       MKL_Complex8* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
                       float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
                       float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall CBBCSD_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
                        MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
                        const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
                        MKL_Complex8* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
                        float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
                        float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall cbbcsd( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
                       MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
                       const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
                       MKL_Complex8* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
                       float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
                       float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall cbbcsd_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
                        MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
                        const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
                        MKL_Complex8* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
                        float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
                        float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall ZBBCSD( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
                       MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
                       const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
                       MKL_Complex16* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
                       double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
                       double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall ZBBCSD_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
                        MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
                        const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
                        MKL_Complex16* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
                        double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
                        double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall zbbcsd( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
                       MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
                       const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
                       MKL_Complex16* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
                       double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
                       double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall zbbcsd_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
                        MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
                        const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
                        MKL_Complex16* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
                        double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
                        double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall SBBCSD( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
                       float* u1, const MKL_INT* ldu1, float* u2,
                       const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
                       float* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
                       float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
                       float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall SBBCSD_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
                        float* u1, const MKL_INT* ldu1, float* u2,
                        const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
                        float* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
                        float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
                        float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall sbbcsd( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
                       float* u1, const MKL_INT* ldu1, float* u2,
                       const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
                       float* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
                       float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
                       float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall sbbcsd_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
                        float* u1, const MKL_INT* ldu1, float* u2,
                        const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
                        float* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
                        float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
                        float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall DBBCSD( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
                       double* u1, const MKL_INT* ldu1, double* u2,
                       const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
                       double* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
                       double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
                       double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall DBBCSD_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
                        double* u1, const MKL_INT* ldu1, double* u2,
                        const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
                        double* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
                        double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
                        double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall dbbcsd( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
                       double* u1, const MKL_INT* ldu1, double* u2,
                       const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
                       double* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
                       double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
                       double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall dbbcsd_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
                        double* u1, const MKL_INT* ldu1, double* u2,
                        const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
                        double* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
                        double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
                        double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void __stdcall CUNBDB( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, MKL_Complex8* x11,
                       const MKL_INT* ldx11, MKL_Complex8* x12, const MKL_INT* ldx12,
                       MKL_Complex8* x21, const MKL_INT* ldx21, MKL_Complex8* x22,
                       const MKL_INT* ldx22, float* theta, float* phi, MKL_Complex8* taup1,
                       MKL_Complex8* taup2, MKL_Complex8* tauq1, MKL_Complex8* tauq2,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall CUNBDB_( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, MKL_Complex8* x11,
                        const MKL_INT* ldx11, MKL_Complex8* x12, const MKL_INT* ldx12,
                        MKL_Complex8* x21, const MKL_INT* ldx21, MKL_Complex8* x22,
                        const MKL_INT* ldx22, float* theta, float* phi, MKL_Complex8* taup1,
                        MKL_Complex8* taup2, MKL_Complex8* tauq1, MKL_Complex8* tauq2,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall cunbdb( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, MKL_Complex8* x11,
                       const MKL_INT* ldx11, MKL_Complex8* x12, const MKL_INT* ldx12,
                       MKL_Complex8* x21, const MKL_INT* ldx21, MKL_Complex8* x22,
                       const MKL_INT* ldx22, float* theta, float* phi, MKL_Complex8* taup1,
                       MKL_Complex8* taup2, MKL_Complex8* tauq1, MKL_Complex8* tauq2,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall cunbdb_( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, MKL_Complex8* x11,
                        const MKL_INT* ldx11, MKL_Complex8* x12, const MKL_INT* ldx12,
                        MKL_Complex8* x21, const MKL_INT* ldx21, MKL_Complex8* x22,
                        const MKL_INT* ldx22, float* theta, float* phi, MKL_Complex8* taup1,
                        MKL_Complex8* taup2, MKL_Complex8* tauq1, MKL_Complex8* tauq2,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall ZUNBDB( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, MKL_Complex16* x11,
                       const MKL_INT* ldx11, MKL_Complex16* x12, const MKL_INT* ldx12,
                       MKL_Complex16* x21, const MKL_INT* ldx21, MKL_Complex16* x22,
                       const MKL_INT* ldx22, double* theta, double* phi, MKL_Complex16* taup1,
                       MKL_Complex16* taup2, MKL_Complex16* tauq1, MKL_Complex16* tauq2,
                       MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall ZUNBDB_( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, MKL_Complex16* x11,
                        const MKL_INT* ldx11, MKL_Complex16* x12, const MKL_INT* ldx12,
                        MKL_Complex16* x21, const MKL_INT* ldx21, MKL_Complex16* x22,
                        const MKL_INT* ldx22, double* theta, double* phi, MKL_Complex16* taup1,
                        MKL_Complex16* taup2, MKL_Complex16* tauq1, MKL_Complex16* tauq2,
                        MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall zunbdb( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, MKL_Complex16* x11,
                       const MKL_INT* ldx11, MKL_Complex16* x12, const MKL_INT* ldx12,
                       MKL_Complex16* x21, const MKL_INT* ldx21, MKL_Complex16* x22,
                       const MKL_INT* ldx22, double* theta, double* phi, MKL_Complex16* taup1,
                       MKL_Complex16* taup2, MKL_Complex16* tauq1, MKL_Complex16* tauq2,
                       MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall zunbdb_( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, MKL_Complex16* x11,
                        const MKL_INT* ldx11, MKL_Complex16* x12, const MKL_INT* ldx12,
                        MKL_Complex16* x21, const MKL_INT* ldx21, MKL_Complex16* x22,
                        const MKL_INT* ldx22, double* theta, double* phi, MKL_Complex16* taup1,
                        MKL_Complex16* taup2, MKL_Complex16* tauq1, MKL_Complex16* tauq2,
                        MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall SORBDB( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, float* x11,
                       const MKL_INT* ldx11, float* x12, const MKL_INT* ldx12,
                       float* x21, const MKL_INT* ldx21, float* x22,
                       const MKL_INT* ldx22, float* theta, float* phi, float* taup1,
                       float* taup2, float* tauq1, float* tauq2,
                       float* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall SORBDB_( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, float* x11,
                        const MKL_INT* ldx11, float* x12, const MKL_INT* ldx12,
                        float* x21, const MKL_INT* ldx21, float* x22,
                        const MKL_INT* ldx22, float* theta, float* phi, float* taup1,
                        float* taup2, float* tauq1, float* tauq2,
                        float* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall sorbdb( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, float* x11,
                       const MKL_INT* ldx11, float* x12, const MKL_INT* ldx12,
                       float* x21, const MKL_INT* ldx21, float* x22,
                       const MKL_INT* ldx22, float* theta, float* phi, float* taup1,
                       float* taup2, float* tauq1, float* tauq2,
                       float* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall sorbdb_( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, float* x11,
                        const MKL_INT* ldx11, float* x12, const MKL_INT* ldx12,
                        float* x21, const MKL_INT* ldx21, float* x22,
                        const MKL_INT* ldx22, float* theta, float* phi, float* taup1,
                        float* taup2, float* tauq1, float* tauq2,
                        float* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall DORBDB( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, double* x11,
                       const MKL_INT* ldx11, double* x12, const MKL_INT* ldx12,
                       double* x21, const MKL_INT* ldx21, double* x22,
                       const MKL_INT* ldx22, double* theta, double* phi, double* taup1,
                       double* taup2, double* tauq1, double* tauq2,
                       double* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall DORBDB_( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, double* x11,
                        const MKL_INT* ldx11, double* x12, const MKL_INT* ldx12,
                        double* x21, const MKL_INT* ldx21, double* x22,
                        const MKL_INT* ldx22, double* theta, double* phi, double* taup1,
                        double* taup2, double* tauq1, double* tauq2,
                        double* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall dorbdb( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                       const MKL_INT* P, const MKL_INT* Q, double* x11,
                       const MKL_INT* ldx11, double* x12, const MKL_INT* ldx12,
                       double* x21, const MKL_INT* ldx21, double* x22,
                       const MKL_INT* ldx22, double* theta, double* phi, double* taup1,
                       double* taup2, double* tauq1, double* tauq2,
                       double* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall dorbdb_( const char* trans, int trans_len, const char* signs, int signs_len, const MKL_INT* M,
                        const MKL_INT* P, const MKL_INT* Q, double* x11,
                        const MKL_INT* ldx11, double* x12, const MKL_INT* ldx12,
                        double* x21, const MKL_INT* ldx21, double* x22,
                        const MKL_INT* ldx22, double* theta, double* phi, double* taup1,
                        double* taup2, double* tauq1, double* tauq2,
                        double* work, const MKL_INT* lwork, MKL_INT* info);

void __stdcall CUNCSD( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                       const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                       MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x12,
                       const MKL_INT* ldx12, MKL_Complex8* x21, const MKL_INT* ldx21,
                       MKL_Complex8* x22, const MKL_INT* ldx22, float* theta,
                       MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
                       const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
                       MKL_Complex8* v2t, const MKL_INT* ldv2t, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, MKL_INT* info);

void __stdcall CUNCSD_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                        const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                        MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x12,
                        const MKL_INT* ldx12, MKL_Complex8* x21, const MKL_INT* ldx21,
                        MKL_Complex8* x22, const MKL_INT* ldx22, float* theta,
                        MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
                        const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
                        MKL_Complex8* v2t, const MKL_INT* ldv2t, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                        MKL_INT* iwork, MKL_INT* info);

void __stdcall cuncsd( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                       const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                       MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x12,
                       const MKL_INT* ldx12, MKL_Complex8* x21, const MKL_INT* ldx21,
                       MKL_Complex8* x22, const MKL_INT* ldx22, float* theta,
                       MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
                       const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
                       MKL_Complex8* v2t, const MKL_INT* ldv2t, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, MKL_INT* info);

void __stdcall cuncsd_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                        const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                        MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x12,
                        const MKL_INT* ldx12, MKL_Complex8* x21, const MKL_INT* ldx21,
                        MKL_Complex8* x22, const MKL_INT* ldx22, float* theta,
                        MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
                        const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
                        MKL_Complex8* v2t, const MKL_INT* ldv2t, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                        MKL_INT* iwork, MKL_INT* info);

void __stdcall ZUNCSD( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                       const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                       MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x12,
                       const MKL_INT* ldx12, MKL_Complex16* x21, const MKL_INT* ldx21,
                       MKL_Complex16* x22, const MKL_INT* ldx22, double* theta,
                       MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
                       const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
                       MKL_Complex16* v2t, const MKL_INT* ldv2t, MKL_Complex16* work,
                       const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, MKL_INT* info);

void __stdcall ZUNCSD_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                        const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                        MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x12,
                        const MKL_INT* ldx12, MKL_Complex16* x21, const MKL_INT* ldx21,
                        MKL_Complex16* x22, const MKL_INT* ldx22, double* theta,
                        MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
                        const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
                        MKL_Complex16* v2t, const MKL_INT* ldv2t, MKL_Complex16* work,
                        const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
                        MKL_INT* iwork, MKL_INT* info);

void __stdcall zuncsd( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                       const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                       MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x12,
                       const MKL_INT* ldx12, MKL_Complex16* x21, const MKL_INT* ldx21,
                       MKL_Complex16* x22, const MKL_INT* ldx22, double* theta,
                       MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
                       const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
                       MKL_Complex16* v2t, const MKL_INT* ldv2t, MKL_Complex16* work,
                       const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, MKL_INT* info);

void __stdcall zuncsd_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                        const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                        MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x12,
                        const MKL_INT* ldx12, MKL_Complex16* x21, const MKL_INT* ldx21,
                        MKL_Complex16* x22, const MKL_INT* ldx22, double* theta,
                        MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
                        const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
                        MKL_Complex16* v2t, const MKL_INT* ldv2t, MKL_Complex16* work,
                        const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
                        MKL_INT* iwork, MKL_INT* info);

void __stdcall SORCSD( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                       const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                       float* x11, const MKL_INT* ldx11, float* x12,
                       const MKL_INT* ldx12, float* x21, const MKL_INT* ldx21,
                       float* x22, const MKL_INT* ldx22, float* theta,
                       float* u1, const MKL_INT* ldu1, float* u2,
                       const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
                       float* v2t, const MKL_INT* ldv2t, float* work,
                       const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void __stdcall SORCSD_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                        const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                        float* x11, const MKL_INT* ldx11, float* x12,
                        const MKL_INT* ldx12, float* x21, const MKL_INT* ldx21,
                        float* x22, const MKL_INT* ldx22, float* theta,
                        float* u1, const MKL_INT* ldu1, float* u2,
                        const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
                        float* v2t, const MKL_INT* ldv2t, float* work,
                        const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void __stdcall sorcsd( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                       const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                       float* x11, const MKL_INT* ldx11, float* x12,
                       const MKL_INT* ldx12, float* x21, const MKL_INT* ldx21,
                       float* x22, const MKL_INT* ldx22, float* theta,
                       float* u1, const MKL_INT* ldu1, float* u2,
                       const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
                       float* v2t, const MKL_INT* ldv2t, float* work,
                       const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void __stdcall sorcsd_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                        const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                        float* x11, const MKL_INT* ldx11, float* x12,
                        const MKL_INT* ldx12, float* x21, const MKL_INT* ldx21,
                        float* x22, const MKL_INT* ldx22, float* theta,
                        float* u1, const MKL_INT* ldu1, float* u2,
                        const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
                        float* v2t, const MKL_INT* ldv2t, float* work,
                        const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void __stdcall DORCSD( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                       const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                       double* x11, const MKL_INT* ldx11, double* x12,
                       const MKL_INT* ldx12, double* x21, const MKL_INT* ldx21,
                       double* x22, const MKL_INT* ldx22, double* theta,
                       double* u1, const MKL_INT* ldu1, double* u2,
                       const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
                       double* v2t, const MKL_INT* ldv2t, double* work,
                       const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void __stdcall DORCSD_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                        const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                        double* x11, const MKL_INT* ldx11, double* x12,
                        const MKL_INT* ldx12, double* x21, const MKL_INT* ldx21,
                        double* x22, const MKL_INT* ldx22, double* theta,
                        double* u1, const MKL_INT* ldu1, double* u2,
                        const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
                        double* v2t, const MKL_INT* ldv2t, double* work,
                        const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void __stdcall dorcsd( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                       const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                       const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                       double* x11, const MKL_INT* ldx11, double* x12,
                       const MKL_INT* ldx12, double* x21, const MKL_INT* ldx21,
                       double* x22, const MKL_INT* ldx22, double* theta,
                       double* u1, const MKL_INT* ldu1, double* u2,
                       const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
                       double* v2t, const MKL_INT* ldv2t, double* work,
                       const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void __stdcall dorcsd_( const char* jobu1, int jobu1_len, const char* jobu2, int jobu2_len, const char* jobv1t, int jobv1t_len,
                        const char* jobv2t, int jobv2t_len, const char* trans, int trans_len, const char* signs, int signs_len,
                        const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
                        double* x11, const MKL_INT* ldx11, double* x12,
                        const MKL_INT* ldx12, double* x21, const MKL_INT* ldx21,
                        double* x22, const MKL_INT* ldx22, double* theta,
                        double* u1, const MKL_INT* ldu1, double* u2,
                        const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
                        double* v2t, const MKL_INT* ldv2t, double* work,
                        const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);


void __stdcall CLAPMR( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall CLAPMR_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall clapmr( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall clapmr_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );

void __stdcall DLAPMR( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                       double* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall DLAPMR_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                        double* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall dlapmr( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                       double* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall dlapmr_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                        double* x, const MKL_INT* ldx, MKL_INT* k );

void __stdcall ZLAPMR( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex16* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall ZLAPMR_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex16* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall zlapmr( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex16* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall zlapmr_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex16* x, const MKL_INT* ldx, MKL_INT* k );

void __stdcall SLAPMR( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                       float* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall SLAPMR_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                        float* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall slapmr( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                       float* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall slapmr_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                        float* x, const MKL_INT* ldx, MKL_INT* k );

void __stdcall CSYCONV( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex8* e, MKL_INT* info );
void __stdcall CSYCONV_( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex8* e, MKL_INT* info );
void __stdcall csyconv( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex8* e, MKL_INT* info );
void __stdcall csyconv_( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex8* e, MKL_INT* info );

void __stdcall ZSYCONV( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex16* e, MKL_INT* info );
void __stdcall ZSYCONV_( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex16* e, MKL_INT* info );
void __stdcall zsyconv( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex16* e, MKL_INT* info );
void __stdcall zsyconv_( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex16* e, MKL_INT* info );

void __stdcall SSYCONV( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       float* e, MKL_INT* info );
void __stdcall SSYCONV_( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       float* a, const MKL_INT* lda, const MKL_INT* ipiv, 
                       float* e, MKL_INT* info );
void __stdcall ssyconv( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       float* e, MKL_INT* info );
void __stdcall ssyconv_( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       float* e, MKL_INT* info );

void __stdcall DSYCONV( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       double* e, MKL_INT* info );
void __stdcall DSYCONV_( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       double* e, MKL_INT* info );
void __stdcall dsyconv( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       double* e, MKL_INT* info );
void __stdcall dsyconv_( const char* uplo, int uplo_len, const char* way, int way_len, const MKL_INT* n,
                       double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       double* e, MKL_INT* info );

void __stdcall CSYSWAPR( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void __stdcall CSYSWAPR_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void __stdcall csyswapr( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void __stdcall csyswapr_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                          const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );

void __stdcall ZSYSWAPR( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void __stdcall ZSYSWAPR_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void __stdcall zsyswapr( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void __stdcall zsyswapr_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                          const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );

void __stdcall SSYSWAPR( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                         const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void __stdcall SSYSWAPR_( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                          const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void __stdcall ssyswapr( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                         const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void __stdcall ssyswapr_( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                          const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );

void __stdcall DSYSWAPR( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                         const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void __stdcall DSYSWAPR_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                          const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void __stdcall dsyswapr( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                         const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void __stdcall dsyswapr_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                          const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );

void __stdcall CSYTRI2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall CSYTRI2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall csytri2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall csytri2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall ZSYTRI2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall ZSYTRI2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall zsytri2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall zsytri2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall SSYTRI2( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall SSYTRI2_( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, float* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytri2( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall ssytri2_( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, float* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall DSYTRI2( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall DSYTRI2_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsytri2( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall dsytri2_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall CSYTRI2X( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                        MKL_INT* nb, MKL_INT* info );
void __stdcall CSYTRI2X_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                         MKL_INT* nb, MKL_INT* info );
void __stdcall csytri2x( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                        MKL_INT* nb, MKL_INT* info );
void __stdcall csytri2x_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                         MKL_INT* nb, MKL_INT* info );

void __stdcall ZSYTRI2X( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                        MKL_INT* nb, MKL_INT* info );
void __stdcall ZSYTRI2X_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                         MKL_INT* nb, MKL_INT* info );
void __stdcall zsytri2x( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                        MKL_INT* nb, MKL_INT* info );
void __stdcall zsytri2x_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex16* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                         MKL_INT* nb, MKL_INT* info );

void __stdcall SSYTRI2X( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, float* work,
                        MKL_INT* nb, MKL_INT* info );
void __stdcall SSYTRI2X_( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, float* work,
                         MKL_INT* nb, MKL_INT* info );
void __stdcall ssytri2x( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, float* work,
                        MKL_INT* nb, MKL_INT* info );
void __stdcall ssytri2x_( const char* uplo, int uplo_len, const MKL_INT* n, float* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, float* work,
                         MKL_INT* nb, MKL_INT* info );

void __stdcall DSYTRI2X( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                        MKL_INT* nb, MKL_INT* info );
void __stdcall DSYTRI2X_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                         MKL_INT* nb, MKL_INT* info );
void __stdcall dsytri2x( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                        MKL_INT* nb, MKL_INT* info );
void __stdcall dsytri2x_( const char* uplo, int uplo_len, const MKL_INT* n, double* a,
                         const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                         MKL_INT* nb, MKL_INT* info );

void __stdcall SLARTGP( float* f, float* g, float* cs, float* sn, float* r );
void __stdcall SLARTGP_( float* f, float* g, float* cs, float* sn, float* r );
void __stdcall slartgp( float* f, float* g, float* cs, float* sn, float* r );
void __stdcall slartgp_( float* f, float* g, float* cs, float* sn, float* r );

void __stdcall DLARTGP( double* f, double* g, double* cs, double* sn, double* r );
void __stdcall DLARTGP_( double* f, double* g, double* cs, double* sn, double* r );
void __stdcall dlartgp( double* f, double* g, double* cs, double* sn, double* r );
void __stdcall dlartgp_( double* f, double* g, double* cs, double* sn, double* r );

void __stdcall SLARTGS( const float* x, const float* y, const float* sigma, float* cs, float* sn );
void __stdcall SLARTGS_( const float* x, const float* y, const float* sigma, float* cs, float* sn );
void __stdcall slartgs( const float* x, const float* y, const float* sigma, float* cs, float* sn );
void __stdcall slartgs_( const float* x, const float* y, const float* sigma, float* cs, float* sn );

void __stdcall DLARTGS( const double* x, const double* y, const double* sigma, double* cs, double* sn );
void __stdcall DLARTGS_( const double* x, const double* y, const double* sigma, double* cs, double* sn );
void __stdcall dlartgs( const double* x, const double* y, const double* sigma, double* cs, double* sn );
void __stdcall dlartgs_( const double* x, const double* y, const double* sigma, double* cs, double* sn );

void __stdcall CSYTRS2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info );
void __stdcall CSYTRS2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info );
void __stdcall csytrs2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info );
void __stdcall csytrs2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info );

void __stdcall ZSYTRS2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );
void __stdcall ZSYTRS2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );
void __stdcall zsytrs2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );
void __stdcall zsytrs2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );

void __stdcall SSYTRS2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       float* b, const MKL_INT* ldb, float* work, MKL_INT* info );
void __stdcall SSYTRS2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       float* b, const MKL_INT* ldb, float* work, MKL_INT* info );
void __stdcall ssytrs2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       float* b, const MKL_INT* ldb, float* work, MKL_INT* info );
void __stdcall ssytrs2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       float* b, const MKL_INT* ldb, float* work, MKL_INT* info );

void __stdcall DSYTRS2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       double* b, const MKL_INT* ldb, double* work, MKL_INT* info );
void __stdcall DSYTRS2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       double* b, const MKL_INT* ldb, double* work, MKL_INT* info );
void __stdcall dsytrs2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       double* b, const MKL_INT* ldb, double* work, MKL_INT* info );
void __stdcall dsytrs2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       double* b, const MKL_INT* ldb, double* work, MKL_INT* info );

void __stdcall CHETRS2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                        MKL_INT* info );
void __stdcall CHETRS2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                         const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                         MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                         MKL_INT* info );
void __stdcall chetrs2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                         const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                         MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                         MKL_INT* info );
void __stdcall chetrs2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                         const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                         MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                         MKL_INT* info );

void __stdcall ZHETRS2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );
void __stdcall ZHETRS2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );
void __stdcall zhetrs2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );
void __stdcall zhetrs2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );

/* LAPACK 3.2 routines */

void __stdcall CBDSQR( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* ncvt,
                       const MKL_INT* nru, const MKL_INT* ncc, float* d, float* e,
                       MKL_Complex8* vt, const MKL_INT* ldvt, MKL_Complex8* u,
                       const MKL_INT* ldu, MKL_Complex8* c, const MKL_INT* ldc,
                       float* rwork, MKL_INT* info );
void __stdcall CBDSQR_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* ncvt,
                        const MKL_INT* nru, const MKL_INT* ncc, float* d, float* e,
                        MKL_Complex8* vt, const MKL_INT* ldvt, MKL_Complex8* u,
                        const MKL_INT* ldu, MKL_Complex8* c, const MKL_INT* ldc,
                        float* rwork, MKL_INT* info );
void __stdcall cbdsqr( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* ncvt,
                       const MKL_INT* nru, const MKL_INT* ncc, float* d, float* e,
                       MKL_Complex8* vt, const MKL_INT* ldvt, MKL_Complex8* u,
                       const MKL_INT* ldu, MKL_Complex8* c, const MKL_INT* ldc,
                       float* rwork, MKL_INT* info );
void __stdcall cbdsqr_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* ncvt,
                        const MKL_INT* nru, const MKL_INT* ncc, float* d, float* e,
                        MKL_Complex8* vt, const MKL_INT* ldvt, MKL_Complex8* u,
                        const MKL_INT* ldu, MKL_Complex8* c, const MKL_INT* ldc,
                        float* rwork, MKL_INT* info );

void __stdcall CGBBRD( const char* vect, int vect_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
                       MKL_Complex8* ab, const MKL_INT* ldab, float* d, float* e,
                       MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* pt,
                       const MKL_INT* ldpt, MKL_Complex8* c, const MKL_INT* ldc,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CGBBRD_( const char* vect, int vect_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
                        MKL_Complex8* ab, const MKL_INT* ldab, float* d, float* e,
                        MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* pt,
                        const MKL_INT* ldpt, MKL_Complex8* c, const MKL_INT* ldc,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgbbrd( const char* vect, int vect_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
                       MKL_Complex8* ab, const MKL_INT* ldab, float* d, float* e,
                       MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* pt,
                       const MKL_INT* ldpt, MKL_Complex8* c, const MKL_INT* ldc,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgbbrd_( const char* vect, int vect_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
                        MKL_Complex8* ab, const MKL_INT* ldab, float* d, float* e,
                        MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* pt,
                        const MKL_INT* ldpt, MKL_Complex8* c, const MKL_INT* ldc,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CGBCON( const char* norm, int norm_len, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                       const MKL_INT* ipiv, const float* anorm, float* rcond,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CGBCON_( const char* norm, int norm_len, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                        const MKL_INT* ipiv, const float* anorm, float* rcond,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgbcon( const char* norm, int norm_len, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                       const MKL_INT* ipiv, const float* anorm, float* rcond,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgbcon_( const char* norm, int norm_len, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                        const MKL_INT* ipiv, const float* anorm, float* rcond,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CGBEQUB( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                        float* r, float* c, float* rowcnd, float* colcnd, float* amax,
                        MKL_INT* info );
void __stdcall CGBEQUB_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                         const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                         float* r, float* c, float* rowcnd, float* colcnd, float* amax,
                         MKL_INT* info );
void __stdcall cgbequb( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                        float* r, float* c, float* rowcnd, float* colcnd, float* amax,
                        MKL_INT* info );
void __stdcall cgbequb_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                         const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                         float* r, float* c, float* rowcnd, float* colcnd, float* amax,
                         MKL_INT* info );

void __stdcall CGBEQU( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                       float* r, float* c, float* rowcnd, float* colcnd, float* amax,
                       MKL_INT* info );
void __stdcall CGBEQU_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                        float* r, float* c, float* rowcnd, float* colcnd, float* amax,
                        MKL_INT* info );
void __stdcall cgbequ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                       float* r, float* c, float* rowcnd, float* colcnd, float* amax,
                       MKL_INT* info );
void __stdcall cgbequ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                        float* r, float* c, float* rowcnd, float* colcnd, float* amax,
                        MKL_INT* info );

void __stdcall CGBRFS( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
                       const MKL_INT* ldab, const MKL_Complex8* afb,
                       const MKL_INT* ldafb, const MKL_INT* ipiv, const MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                       float* ferr, float* berr, MKL_Complex8* work, float* rwork,
                       MKL_INT* info );
void __stdcall CGBRFS_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
                        const MKL_INT* ldab, const MKL_Complex8* afb,
                        const MKL_INT* ldafb, const MKL_INT* ipiv, const MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                        float* ferr, float* berr, MKL_Complex8* work, float* rwork,
                        MKL_INT* info );
void __stdcall cgbrfs( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
                       const MKL_INT* ldab, const MKL_Complex8* afb,
                       const MKL_INT* ldafb, const MKL_INT* ipiv, const MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                       float* ferr, float* berr, MKL_Complex8* work, float* rwork,
                       MKL_INT* info );
void __stdcall cgbrfs_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
                        const MKL_INT* ldab, const MKL_Complex8* afb,
                        const MKL_INT* ldafb, const MKL_INT* ipiv, const MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                        float* ferr, float* berr, MKL_Complex8* work, float* rwork,
                        MKL_INT* info );

void __stdcall CGBRFSX( const char* trans, int trans_len, const char* equed, int equed_len, const MKL_INT* n,
                        const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
                        const MKL_Complex8* ab, const MKL_INT* ldab,
                        const MKL_Complex8* afb, const MKL_INT* ldafb,
                        const MKL_INT* ipiv, const float* r, const float* c,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CGBRFSX_( const char* trans, int trans_len, const char* equed, int equed_len, const MKL_INT* n,
                         const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
                         const MKL_Complex8* ab, const MKL_INT* ldab,
                         const MKL_Complex8* afb, const MKL_INT* ldafb,
                         const MKL_INT* ipiv, const float* r, const float* c,
                         const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                         const MKL_INT* ldx, float* rcond, float* berr,
                         const MKL_INT* n_err_bnds, float* err_bnds_norm,
                         float* err_bnds_comp, const MKL_INT* nparams, float* params,
                         MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgbrfsx( const char* trans, int trans_len, const char* equed, int equed_len, const MKL_INT* n,
                        const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
                        const MKL_Complex8* ab, const MKL_INT* ldab,
                        const MKL_Complex8* afb, const MKL_INT* ldafb,
                        const MKL_INT* ipiv, const float* r, const float* c,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgbrfsx_( const char* trans, int trans_len, const char* equed, int equed_len, const MKL_INT* n,
                         const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
                         const MKL_Complex8* ab, const MKL_INT* ldab,
                         const MKL_Complex8* afb, const MKL_INT* ldafb,
                         const MKL_INT* ipiv, const float* r, const float* c,
                         const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                         const MKL_INT* ldx, float* rcond, float* berr,
                         const MKL_INT* n_err_bnds, float* err_bnds_norm,
                         float* err_bnds_comp, const MKL_INT* nparams, float* params,
                         MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CGBSV( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
                      const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
                      MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                      MKL_INT* info );
void __stdcall CGBSV_( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
                       const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
                       MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* info );
void __stdcall cgbsv( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
                      const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
                      MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                      MKL_INT* info );
void __stdcall cgbsv_( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
                       const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
                       MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* info );

void __stdcall CGBSVX( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                       const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
                       MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
                       const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, int equed_len, float* r,
                       float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CGBSVX_( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                        const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
                        MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
                        const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, int equed_len, float* r,
                        float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgbsvx( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                       const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
                       MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
                       const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, int equed_len, float* r,
                       float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgbsvx_( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                        const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
                        MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
                        const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, int equed_len, float* r,
                        float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CGBSVXX( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                        const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
                        MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
                        const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, int equed_len, float* r,
                        float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CGBSVXX_( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                         const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
                         MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
                         const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, int equed_len, float* r,
                         float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                         const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
                         const MKL_INT* n_err_bnds, float* err_bnds_norm,
                         float* err_bnds_comp, const MKL_INT* nparams, float* params,
                         MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgbsvxx( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                        const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
                        MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
                        const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, int equed_len, float* r,
                        float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgbsvxx_( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                         const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
                         MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
                         const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, int equed_len, float* r,
                         float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                         const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
                         const MKL_INT* n_err_bnds, float* err_bnds_norm,
                         float* err_bnds_comp, const MKL_INT* nparams, float* params,
                         MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CGBTF2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
                       MKL_INT* ipiv, MKL_INT* info );
void __stdcall CGBTF2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
                        MKL_INT* ipiv, MKL_INT* info );
void __stdcall cgbtf2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
                       MKL_INT* ipiv, MKL_INT* info );
void __stdcall cgbtf2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
                        MKL_INT* ipiv, MKL_INT* info );

void __stdcall CGBTRF( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
                       MKL_INT* ipiv, MKL_INT* info );
void __stdcall CGBTRF_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
                        MKL_INT* ipiv, MKL_INT* info );
void __stdcall cgbtrf( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
                       MKL_INT* ipiv, MKL_INT* info );
void __stdcall cgbtrf_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
                        MKL_INT* ipiv, MKL_INT* info );

void __stdcall CGBTRS( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
                       const MKL_INT* ldab, const MKL_INT* ipiv, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall CGBTRS_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
                        const MKL_INT* ldab, const MKL_INT* ipiv, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );
void __stdcall cgbtrs( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
                       const MKL_INT* ldab, const MKL_INT* ipiv, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall cgbtrs_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
                        const MKL_INT* ldab, const MKL_INT* ipiv, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );

void __stdcall CGEBAK( const char* job, int job_len, const char* side, int side_len, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, const float* scale,
                       const MKL_INT* m, MKL_Complex8* v, const MKL_INT* ldv,
                       MKL_INT* info );
void __stdcall CGEBAK_( const char* job, int job_len, const char* side, int side_len, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, const float* scale,
                        const MKL_INT* m, MKL_Complex8* v, const MKL_INT* ldv,
                        MKL_INT* info );
void __stdcall cgebak( const char* job, int job_len, const char* side, int side_len, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, const float* scale,
                       const MKL_INT* m, MKL_Complex8* v, const MKL_INT* ldv,
                       MKL_INT* info );
void __stdcall cgebak_( const char* job, int job_len, const char* side, int side_len, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, const float* scale,
                        const MKL_INT* m, MKL_Complex8* v, const MKL_INT* ldv,
                        MKL_INT* info );

void __stdcall CGEBAL( const char* job, int job_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* ilo, MKL_INT* ihi, float* scale,
                       MKL_INT* info );
void __stdcall CGEBAL_( const char* job, int job_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* ilo, MKL_INT* ihi, float* scale,
                        MKL_INT* info );
void __stdcall cgebal( const char* job, int job_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* ilo, MKL_INT* ihi, float* scale,
                       MKL_INT* info );
void __stdcall cgebal_( const char* job, int job_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* ilo, MKL_INT* ihi, float* scale,
                        MKL_INT* info );

void __stdcall CGEBD2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
                       MKL_Complex8* taup, MKL_Complex8* work, MKL_INT* info );
void __stdcall CGEBD2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
                        MKL_Complex8* taup, MKL_Complex8* work, MKL_INT* info );
void __stdcall cgebd2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
                       MKL_Complex8* taup, MKL_Complex8* work, MKL_INT* info );
void __stdcall cgebd2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
                        MKL_Complex8* taup, MKL_Complex8* work, MKL_INT* info );

void __stdcall CGEBRD( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
                       MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall CGEBRD_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
                        MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall cgebrd( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
                       MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall cgebrd_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
                        MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );

void __stdcall CGECON( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, const float* anorm, float* rcond,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CGECON_( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, const float* anorm, float* rcond,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgecon( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, const float* anorm, float* rcond,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgecon_( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, const float* anorm, float* rcond,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CGEEQUB( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, float* r, float* c, float* rowcnd,
                        float* colcnd, float* amax, MKL_INT* info );
void __stdcall CGEEQUB_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                         const MKL_INT* lda, float* r, float* c, float* rowcnd,
                         float* colcnd, float* amax, MKL_INT* info );
void __stdcall cgeequb( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, float* r, float* c, float* rowcnd,
                        float* colcnd, float* amax, MKL_INT* info );
void __stdcall cgeequb_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                         const MKL_INT* lda, float* r, float* c, float* rowcnd,
                         float* colcnd, float* amax, MKL_INT* info );

void __stdcall CGEEQU( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, float* r, float* c, float* rowcnd,
                       float* colcnd, float* amax, MKL_INT* info );
void __stdcall CGEEQU_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, float* r, float* c, float* rowcnd,
                        float* colcnd, float* amax, MKL_INT* info );
void __stdcall cgeequ( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, float* r, float* c, float* rowcnd,
                       float* colcnd, float* amax, MKL_INT* info );
void __stdcall cgeequ_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, float* r, float* c, float* rowcnd,
                        float* colcnd, float* amax, MKL_INT* info );

void __stdcall CGEES( const char* jobvs, int jobvs_len, const char* sort, int sort_len,
                      MKL_C_SELECT_FUNCTION_1 select, const MKL_INT* n, MKL_Complex8* a,
                      const MKL_INT* lda, MKL_INT* sdim, MKL_Complex8* w,
                      MKL_Complex8* vs, const MKL_INT* ldvs, MKL_Complex8* work,
                      const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
                      MKL_INT* info );
void __stdcall CGEES_( const char* jobvs, int jobvs_len, const char* sort, int sort_len,
                       MKL_C_SELECT_FUNCTION_1 select, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* sdim, MKL_Complex8* w,
                       MKL_Complex8* vs, const MKL_INT* ldvs, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
                       MKL_INT* info );
void __stdcall cgees( const char* jobvs, int jobvs_len, const char* sort, int sort_len,
                      MKL_C_SELECT_FUNCTION_1 select, const MKL_INT* n, MKL_Complex8* a,
                      const MKL_INT* lda, MKL_INT* sdim, MKL_Complex8* w,
                      MKL_Complex8* vs, const MKL_INT* ldvs, MKL_Complex8* work,
                      const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
                      MKL_INT* info );
void __stdcall cgees_( const char* jobvs, int jobvs_len, const char* sort, int sort_len,
                       MKL_C_SELECT_FUNCTION_1 select, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* sdim, MKL_Complex8* w,
                       MKL_Complex8* vs, const MKL_INT* ldvs, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
                       MKL_INT* info );

void __stdcall CGEESX( const char* jobvs, int jobvs_len, const char* sort, int sort_len,
                       MKL_C_SELECT_FUNCTION_1 select, const char* sense, int sense_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_INT* sdim, MKL_Complex8* w, MKL_Complex8* vs,
                       const MKL_INT* ldvs, float* rconde, float* rcondv,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* bwork, MKL_INT* info );
void __stdcall CGEESX_( const char* jobvs, int jobvs_len, const char* sort, int sort_len,
                        MKL_C_SELECT_FUNCTION_1 select, const char* sense, int sense_len,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_INT* sdim, MKL_Complex8* w, MKL_Complex8* vs,
                        const MKL_INT* ldvs, float* rconde, float* rcondv,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* bwork, MKL_INT* info );
void __stdcall cgeesx( const char* jobvs, int jobvs_len, const char* sort, int sort_len,
                       MKL_C_SELECT_FUNCTION_1 select, const char* sense, int sense_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_INT* sdim, MKL_Complex8* w, MKL_Complex8* vs,
                       const MKL_INT* ldvs, float* rconde, float* rcondv,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* bwork, MKL_INT* info );
void __stdcall cgeesx_( const char* jobvs, int jobvs_len, const char* sort, int sort_len,
                        MKL_C_SELECT_FUNCTION_1 select, const char* sense, int sense_len,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_INT* sdim, MKL_Complex8* w, MKL_Complex8* vs,
                        const MKL_INT* ldvs, float* rconde, float* rcondv,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* bwork, MKL_INT* info );

void __stdcall CGEEV( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len, const MKL_INT* n,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* w,
                      MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                      const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                      float* rwork, MKL_INT* info );
void __stdcall CGEEV_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* w,
                       MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                       const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );
void __stdcall cgeev( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len, const MKL_INT* n,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* w,
                      MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                      const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                      float* rwork, MKL_INT* info );
void __stdcall cgeev_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* w,
                       MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                       const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );

void __stdcall CGEEVX( const char* balanc, int balanc_len, const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                       const char* sense, int sense_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* w, MKL_Complex8* vl,
                       const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
                       MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,
                       float* rconde, float* rcondv, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* info );
void __stdcall CGEEVX_( const char* balanc, int balanc_len, const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                        const char* sense, int sense_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* w, MKL_Complex8* vl,
                        const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
                        MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,
                        float* rconde, float* rcondv, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, MKL_INT* info );
void __stdcall cgeevx( const char* balanc, int balanc_len, const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                       const char* sense, int sense_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* w, MKL_Complex8* vl,
                       const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
                       MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,
                       float* rconde, float* rcondv, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* info );
void __stdcall cgeevx_( const char* balanc, int balanc_len, const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                        const char* sense, int sense_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* w, MKL_Complex8* vl,
                        const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
                        MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,
                        float* rconde, float* rcondv, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, MKL_INT* info );

void __stdcall CGEGS( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len, const MKL_INT* n,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                      MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
                      const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
                      float* rwork, MKL_INT* info );
void __stdcall CGEGS_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                       MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
                       const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );
void __stdcall cgegs( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len, const MKL_INT* n,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                      MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
                      const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
                      float* rwork, MKL_INT* info );
void __stdcall cgegs_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                       MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
                       const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );

void __stdcall CGEGV( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len, const MKL_INT* n,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                      MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                      const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                      float* rwork, MKL_INT* info );
void __stdcall CGEGV_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                       MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                       const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );
void __stdcall cgegv( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len, const MKL_INT* n,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                      MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                      const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                      float* rwork, MKL_INT* info );
void __stdcall cgegv_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                       MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                       const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );

void __stdcall CGEHD2( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                       MKL_Complex8* work, MKL_INT* info );
void __stdcall CGEHD2_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                        MKL_Complex8* work, MKL_INT* info );
void __stdcall cgehd2( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                       MKL_Complex8* work, MKL_INT* info );
void __stdcall cgehd2_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                        MKL_Complex8* work, MKL_INT* info );

void __stdcall CGEHRD( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGEHRD_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgehrd( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgehrd_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall CGELQ2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       MKL_INT* info );
void __stdcall CGELQ2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        MKL_INT* info );
void __stdcall cgelq2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       MKL_INT* info );
void __stdcall cgelq2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        MKL_INT* info );

void __stdcall CGELQF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGELQF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgelqf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgelqf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );

void __stdcall CGELSD( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* iwork, MKL_INT* info );
void __stdcall CGELSD_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* iwork, MKL_INT* info );
void __stdcall cgelsd( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* iwork, MKL_INT* info );
void __stdcall cgelsd_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* iwork, MKL_INT* info );

void __stdcall CGELS( const char* trans, int trans_len, const MKL_INT* m, const MKL_INT* n,
                      const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGELS_( const char* trans, int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgels( const char* trans, int trans_len, const MKL_INT* m, const MKL_INT* n,
                      const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgels_( const char* trans, int trans_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );

void __stdcall CGELSS( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* info );
void __stdcall CGELSS_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* info );
void __stdcall cgelss( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* info );
void __stdcall cgelss_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* info );

void __stdcall CGELSX( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
                       MKL_INT* rank, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CGELSX_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
                        MKL_INT* rank, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgelsx( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
                       MKL_INT* rank, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgelsx_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
                        MKL_INT* rank, MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CGELSY( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
                       MKL_INT* rank, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );
void __stdcall CGELSY_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
                        MKL_INT* rank, MKL_Complex8* work, const MKL_INT* lwork,
                        float* rwork, MKL_INT* info );
void __stdcall cgelsy( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
                       MKL_INT* rank, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );
void __stdcall cgelsy_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
                        MKL_INT* rank, MKL_Complex8* work, const MKL_INT* lwork,
                        float* rwork, MKL_INT* info );

void __stdcall CGEQL2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       MKL_INT* info );
void __stdcall CGEQL2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        MKL_INT* info );
void __stdcall cgeql2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       MKL_INT* info );
void __stdcall cgeql2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        MKL_INT* info );

void __stdcall CGEQLF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGEQLF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgeqlf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgeqlf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );

void __stdcall CGEQP3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* info );
void __stdcall CGEQP3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* info );
void __stdcall cgeqp3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* info );
void __stdcall cgeqp3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* info );

void __stdcall CGEQPF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CGEQPF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgeqpf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgeqpf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CGEQR2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       MKL_INT* info );
void __stdcall CGEQR2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        MKL_INT* info );
void __stdcall cgeqr2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       MKL_INT* info );
void __stdcall cgeqr2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        MKL_INT* info );

void __stdcall CGEQR2P( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        MKL_INT* info );
void __stdcall CGEQR2P_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                         MKL_INT* info );
void __stdcall cgeqr2p( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        MKL_INT* info );
void __stdcall cgeqr2p_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                         MKL_INT* info );

void __stdcall CGEQRF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGEQRF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgeqrf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgeqrf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );

void __stdcall CGEQRFP( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGEQRFP_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgeqrfp( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgeqrfp_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                         const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                         const MKL_INT* lwork, MKL_INT* info );

void __stdcall CGERFS( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
                       const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                       float* ferr, float* berr, MKL_Complex8* work, float* rwork,
                       MKL_INT* info );
void __stdcall CGERFS_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );
void __stdcall cgerfs( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
                       const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                       float* ferr, float* berr, MKL_Complex8* work, float* rwork,
                       MKL_INT* info );
void __stdcall cgerfs_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );

void __stdcall CGERFSX( const char* trans, int trans_len, const char* equed, int equed_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
                        const float* r, const float* c, const MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                        float* rcond, float* berr, const MKL_INT* n_err_bnds,
                        float* err_bnds_norm, float* err_bnds_comp,
                        const MKL_INT* nparams, float* params, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );
void __stdcall CGERFSX_( const char* trans, int trans_len, const char* equed, int equed_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* af, const MKL_INT* ldaf,
                         const MKL_INT* ipiv, const float* r, const float* c,
                         const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                         const MKL_INT* ldx, float* rcond, float* berr,
                         const MKL_INT* n_err_bnds, float* err_bnds_norm,
                         float* err_bnds_comp, const MKL_INT* nparams, float* params,
                         MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgerfsx( const char* trans, int trans_len, const char* equed, int equed_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
                        const float* r, const float* c, const MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                        float* rcond, float* berr, const MKL_INT* n_err_bnds,
                        float* err_bnds_norm, float* err_bnds_comp,
                        const MKL_INT* nparams, float* params, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );
void __stdcall cgerfsx_( const char* trans, int trans_len, const char* equed, int equed_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* af, const MKL_INT* ldaf,
                         const MKL_INT* ipiv, const float* r, const float* c,
                         const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                         const MKL_INT* ldx, float* rcond, float* berr,
                         const MKL_INT* n_err_bnds, float* err_bnds_norm,
                         float* err_bnds_comp, const MKL_INT* nparams, float* params,
                         MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CGERQ2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       MKL_INT* info );
void __stdcall CGERQ2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        MKL_INT* info );
void __stdcall cgerq2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       MKL_INT* info );
void __stdcall cgerq2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        MKL_INT* info );

void __stdcall CGERQF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGERQF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgerqf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall cgerqf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );

void __stdcall CGESC2( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
                       float* scale );
void __stdcall CGESC2_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
                        float* scale );
void __stdcall cgesc2( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
                       float* scale );
void __stdcall cgesc2_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
                        float* scale );

void __stdcall CGESDD( const char* jobz, int jobz_len, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u,
                       const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* iwork, MKL_INT* info );
void __stdcall CGESDD_( const char* jobz, int jobz_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u,
                        const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* iwork, MKL_INT* info );
void __stdcall cgesdd( const char* jobz, int jobz_len, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u,
                       const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* iwork, MKL_INT* info );
void __stdcall cgesdd_( const char* jobz, int jobz_len, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u,
                        const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* iwork, MKL_INT* info );

void __stdcall CGESVD( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len, const MKL_INT* m,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s,
                       MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
                       const MKL_INT* ldvt, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );
void __stdcall CGESVD_( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len, const MKL_INT* m,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s,
                        MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
                        const MKL_INT* ldvt, MKL_Complex8* work, const MKL_INT* lwork,
                        float* rwork, MKL_INT* info );
void __stdcall cgesvd( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len, const MKL_INT* m,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s,
                       MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
                       const MKL_INT* ldvt, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );
void __stdcall cgesvd_( const char* jobu, int jobu_len, const char* jobvt, int jobvt_len, const MKL_INT* m,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s,
                        MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
                        const MKL_INT* ldvt, MKL_Complex8* work, const MKL_INT* lwork,
                        float* rwork, MKL_INT* info );

void __stdcall CGESV( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
                      const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_INT* info );
void __stdcall CGESV_( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall cgesv( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
                      const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_INT* info );
void __stdcall cgesv_( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );

void __stdcall CGESVX( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                       const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, int equed_len,
                       float* r, float* c, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CGESVX_( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                        char* equed, int equed_len, float* r, float* c, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                        float* rcond, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );
void __stdcall cgesvx( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                       const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, int equed_len,
                       float* r, float* c, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgesvx_( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                        char* equed, int equed_len, float* r, float* c, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                        float* rcond, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );

void __stdcall CGESVXX( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                        char* equed, int equed_len, float* r, float* c, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                        float* rcond, float* rpvgrw, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CGESVXX_( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                         MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                         char* equed, int equed_len, float* r, float* c, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                         float* rcond, float* rpvgrw, float* berr,
                         const MKL_INT* n_err_bnds, float* err_bnds_norm,
                         float* err_bnds_comp, const MKL_INT* nparams, float* params,
                         MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgesvxx( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                        char* equed, int equed_len, float* r, float* c, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                        float* rcond, float* rpvgrw, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgesvxx_( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                         MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                         char* equed, int equed_len, float* r, float* c, MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                         float* rcond, float* rpvgrw, float* berr,
                         const MKL_INT* n_err_bnds, float* err_bnds_norm,
                         float* err_bnds_comp, const MKL_INT* nparams, float* params,
                         MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CGETC2( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_INT* ipiv, MKL_INT* jpiv, MKL_INT* info );
void __stdcall CGETC2_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_INT* ipiv, MKL_INT* jpiv, MKL_INT* info );
void __stdcall cgetc2( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_INT* ipiv, MKL_INT* jpiv, MKL_INT* info );
void __stdcall cgetc2_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_INT* ipiv, MKL_INT* jpiv, MKL_INT* info );

void __stdcall CGETF2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall CGETF2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall cgetf2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall cgetf2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void __stdcall CGETRF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall CGETRF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall cgetrf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall cgetrf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void __stdcall MKL_CGETRFNPI( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void __stdcall MKL_CGETRFNPI_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                               MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void __stdcall mkl_cgetrfnpi( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void __stdcall mkl_cgetrfnpi_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                               MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );

void __stdcall CGETRI( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall CGETRI_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall cgetri( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall cgetri_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );

void __stdcall CGETRS( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall CGETRS_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall cgetrs( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall cgetrs_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void __stdcall CGGBAK( const char* job, int job_len, const char* side, int side_len, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, const float* lscale,
                       const float* rscale, const MKL_INT* m, MKL_Complex8* v,
                       const MKL_INT* ldv, MKL_INT* info );
void __stdcall CGGBAK_( const char* job, int job_len, const char* side, int side_len, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, const float* lscale,
                        const float* rscale, const MKL_INT* m, MKL_Complex8* v,
                        const MKL_INT* ldv, MKL_INT* info );
void __stdcall cggbak( const char* job, int job_len, const char* side, int side_len, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, const float* lscale,
                       const float* rscale, const MKL_INT* m, MKL_Complex8* v,
                       const MKL_INT* ldv, MKL_INT* info );
void __stdcall cggbak_( const char* job, int job_len, const char* side, int side_len, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, const float* lscale,
                        const float* rscale, const MKL_INT* m, MKL_Complex8* v,
                        const MKL_INT* ldv, MKL_INT* info );

void __stdcall CGGBAL( const char* job, int job_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
                       float* work, MKL_INT* info );
void __stdcall CGGBAL_( const char* job, int job_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
                        float* work, MKL_INT* info );
void __stdcall cggbal( const char* job, int job_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
                       float* work, MKL_INT* info );
void __stdcall cggbal_( const char* job, int job_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
                        float* work, MKL_INT* info );

void __stdcall CGGES( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len, const char* sort, int sort_len,
                      MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n, MKL_Complex8* a,
                      const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                      MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
                      MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
                      const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
                      float* rwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall CGGES_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len, const char* sort, int sort_len,
                       MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
                       MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
                       const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall cgges( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len, const char* sort, int sort_len,
                      MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n, MKL_Complex8* a,
                      const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                      MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
                      MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
                      const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
                      float* rwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall cgges_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len, const char* sort, int sort_len,
                       MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
                       MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
                       const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* bwork, MKL_INT* info );

void __stdcall CGGESX( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len, const char* sort, int sort_len,
                       MKL_C_SELECT_FUNCTION_2 selctg, const char* sense, int sense_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* sdim,
                       MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
                       const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
                       float* rconde, float* rcondv, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
                       const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall CGGESX_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len, const char* sort, int sort_len,
                        MKL_C_SELECT_FUNCTION_2 selctg, const char* sense, int sense_len,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* sdim,
                        MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
                        const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
                        float* rconde, float* rcondv, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
                        const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall cggesx( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len, const char* sort, int sort_len,
                       MKL_C_SELECT_FUNCTION_2 selctg, const char* sense, int sense_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* sdim,
                       MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
                       const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
                       float* rconde, float* rcondv, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
                       const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall cggesx_( const char* jobvsl, int jobvsl_len, const char* jobvsr, int jobvsr_len, const char* sort, int sort_len,
                        MKL_C_SELECT_FUNCTION_2 selctg, const char* sense, int sense_len,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* sdim,
                        MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
                        const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
                        float* rconde, float* rcondv, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
                        const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info );

void __stdcall CGGEV( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len, const MKL_INT* n,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                      MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                      const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                      float* rwork, MKL_INT* info );
void __stdcall CGGEV_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                       MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                       const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );
void __stdcall cggev( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len, const MKL_INT* n,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                      MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                      const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                      float* rwork, MKL_INT* info );
void __stdcall cggev_( const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
                       MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
                       const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );

void __stdcall CGGEVX( const char* balanc, int balanc_len, const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                       const char* sense, int sense_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vl,
                       const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
                       MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
                       float* abnrm, float* bbnrm, float* rconde, float* rcondv,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* iwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall CGGEVX_( const char* balanc, int balanc_len, const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                        const char* sense, int sense_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vl,
                        const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
                        MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
                        float* abnrm, float* bbnrm, float* rconde, float* rcondv,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* iwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall cggevx( const char* balanc, int balanc_len, const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                       const char* sense, int sense_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vl,
                       const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
                       MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
                       float* abnrm, float* bbnrm, float* rconde, float* rcondv,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* iwork, MKL_INT* bwork, MKL_INT* info );
void __stdcall cggevx_( const char* balanc, int balanc_len, const char* jobvl, int jobvl_len, const char* jobvr, int jobvr_len,
                        const char* sense, int sense_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vl,
                        const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
                        MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
                        float* abnrm, float* bbnrm, float* rconde, float* rcondv,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* iwork, MKL_INT* bwork, MKL_INT* info );

void __stdcall CGGGLM( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* d, MKL_Complex8* x,
                       MKL_Complex8* y, MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall CGGGLM_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* d, MKL_Complex8* x,
                        MKL_Complex8* y, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall cggglm( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* d, MKL_Complex8* x,
                       MKL_Complex8* y, MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall cggglm_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* d, MKL_Complex8* x,
                        MKL_Complex8* y, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );

void __stdcall CGGHRD( const char* compq, int compq_len, const char* compz, int compz_len, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
                       const MKL_INT* ldz, MKL_INT* info );
void __stdcall CGGHRD_( const char* compq, int compq_len, const char* compz, int compz_len, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
                        const MKL_INT* ldz, MKL_INT* info );
void __stdcall cgghrd( const char* compq, int compq_len, const char* compz, int compz_len, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
                       const MKL_INT* ldz, MKL_INT* info );
void __stdcall cgghrd_( const char* compq, int compq_len, const char* compz, int compz_len, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
                        const MKL_INT* ldz, MKL_INT* info );

void __stdcall CGGLSE( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* c, MKL_Complex8* d,
                       MKL_Complex8* x, MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall CGGLSE_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* c, MKL_Complex8* d,
                        MKL_Complex8* x, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall cgglse( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* c, MKL_Complex8* d,
                       MKL_Complex8* x, MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall cgglse_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* c, MKL_Complex8* d,
                        MKL_Complex8* x, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );

void __stdcall CGGQRF( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGGQRF_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cggqrf( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cggqrf_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall CGGRQF( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall CGGRQF_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cggrqf( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall cggrqf_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall CGGSVD( const char* jobu, int jobu_len, const char* jobv, int jobv_len, const char* jobq, int jobq_len,
                       const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
                       MKL_INT* l, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, float* alpha, float* beta, MKL_Complex8* u,
                       const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv,
                       MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
                       float* rwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall CGGSVD_( const char* jobu, int jobu_len, const char* jobv, int jobv_len, const char* jobq, int jobq_len,
                        const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
                        MKL_INT* l, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, float* alpha, float* beta, MKL_Complex8* u,
                        const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv,
                        MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
                        float* rwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall cggsvd( const char* jobu, int jobu_len, const char* jobv, int jobv_len, const char* jobq, int jobq_len,
                       const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
                       MKL_INT* l, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, float* alpha, float* beta, MKL_Complex8* u,
                       const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv,
                       MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
                       float* rwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall cggsvd_( const char* jobu, int jobu_len, const char* jobv, int jobv_len, const char* jobq, int jobq_len,
                        const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
                        MKL_INT* l, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, float* alpha, float* beta, MKL_Complex8* u,
                        const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv,
                        MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
                        float* rwork, MKL_INT* iwork, MKL_INT* info );

void __stdcall CGGSVP( const char* jobu, int jobu_len, const char* jobv, int jobv_len, const char* jobq, int jobq_len,
                       const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, const float* tola, const float* tolb,
                       MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
                       MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q,
                       const MKL_INT* ldq, MKL_INT* iwork, float* rwork,
                       MKL_Complex8* tau, MKL_Complex8* work, MKL_INT* info );
void __stdcall CGGSVP_( const char* jobu, int jobu_len, const char* jobv, int jobv_len, const char* jobq, int jobq_len,
                        const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, const float* tola, const float* tolb,
                        MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
                        MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q,
                        const MKL_INT* ldq, MKL_INT* iwork, float* rwork,
                        MKL_Complex8* tau, MKL_Complex8* work, MKL_INT* info );
void __stdcall cggsvp( const char* jobu, int jobu_len, const char* jobv, int jobv_len, const char* jobq, int jobq_len,
                       const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, const float* tola, const float* tolb,
                       MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
                       MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q,
                       const MKL_INT* ldq, MKL_INT* iwork, float* rwork,
                       MKL_Complex8* tau, MKL_Complex8* work, MKL_INT* info );
void __stdcall cggsvp_( const char* jobu, int jobu_len, const char* jobv, int jobv_len, const char* jobq, int jobq_len,
                        const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, const float* tola, const float* tolb,
                        MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
                        MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q,
                        const MKL_INT* ldq, MKL_INT* iwork, float* rwork,
                        MKL_Complex8* tau, MKL_Complex8* work, MKL_INT* info );

void __stdcall CGTCON( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* dl,
                       const MKL_Complex8* d, const MKL_Complex8* du,
                       const MKL_Complex8* du2, const MKL_INT* ipiv, const float* anorm,
                       float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall CGTCON_( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* dl,
                        const MKL_Complex8* d, const MKL_Complex8* du,
                        const MKL_Complex8* du2, const MKL_INT* ipiv, const float* anorm,
                        float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall cgtcon( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* dl,
                       const MKL_Complex8* d, const MKL_Complex8* du,
                       const MKL_Complex8* du2, const MKL_INT* ipiv, const float* anorm,
                       float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall cgtcon_( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* dl,
                        const MKL_Complex8* d, const MKL_Complex8* du,
                        const MKL_Complex8* du2, const MKL_INT* ipiv, const float* anorm,
                        float* rcond, MKL_Complex8* work, MKL_INT* info );

void __stdcall CGTRFS( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* dl, const MKL_Complex8* d,
                       const MKL_Complex8* du, const MKL_Complex8* dlf,
                       const MKL_Complex8* df, const MKL_Complex8* duf,
                       const MKL_Complex8* du2, const MKL_INT* ipiv,
                       const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );
void __stdcall CGTRFS_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* dl, const MKL_Complex8* d,
                        const MKL_Complex8* du, const MKL_Complex8* dlf,
                        const MKL_Complex8* df, const MKL_Complex8* duf,
                        const MKL_Complex8* du2, const MKL_INT* ipiv,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );
void __stdcall cgtrfs( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* dl, const MKL_Complex8* d,
                       const MKL_Complex8* du, const MKL_Complex8* dlf,
                       const MKL_Complex8* df, const MKL_Complex8* duf,
                       const MKL_Complex8* du2, const MKL_INT* ipiv,
                       const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );
void __stdcall cgtrfs_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* dl, const MKL_Complex8* d,
                        const MKL_Complex8* du, const MKL_Complex8* dlf,
                        const MKL_Complex8* df, const MKL_Complex8* duf,
                        const MKL_Complex8* du2, const MKL_INT* ipiv,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );

void __stdcall CGTSV( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl,
                      MKL_Complex8* d, MKL_Complex8* du, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_INT* info );
void __stdcall CGTSV_( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl,
                       MKL_Complex8* d, MKL_Complex8* du, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall cgtsv( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl,
                      MKL_Complex8* d, MKL_Complex8* du, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_INT* info );
void __stdcall cgtsv_( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl,
                       MKL_Complex8* d, MKL_Complex8* du, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );

void __stdcall CGTSVX( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                       const MKL_INT* nrhs, const MKL_Complex8* dl,
                       const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* dlf,
                       MKL_Complex8* df, MKL_Complex8* duf, MKL_Complex8* du2,
                       MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CGTSVX_( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* dl,
                        const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* dlf,
                        MKL_Complex8* df, MKL_Complex8* duf, MKL_Complex8* du2,
                        MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                        float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgtsvx( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                       const MKL_INT* nrhs, const MKL_Complex8* dl,
                       const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* dlf,
                       MKL_Complex8* df, MKL_Complex8* duf, MKL_Complex8* du2,
                       MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cgtsvx_( const char* fact, int fact_len, const char* trans, int trans_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* dl,
                        const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* dlf,
                        MKL_Complex8* df, MKL_Complex8* duf, MKL_Complex8* du2,
                        MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                        float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CGTTRF( const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d,
                       MKL_Complex8* du, MKL_Complex8* du2, MKL_INT* ipiv,
                       MKL_INT* info );
void __stdcall CGTTRF_( const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d,
                        MKL_Complex8* du, MKL_Complex8* du2, MKL_INT* ipiv,
                        MKL_INT* info );
void __stdcall cgttrf( const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d,
                       MKL_Complex8* du, MKL_Complex8* du2, MKL_INT* ipiv,
                       MKL_INT* info );
void __stdcall cgttrf_( const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d,
                        MKL_Complex8* du, MKL_Complex8* du2, MKL_INT* ipiv,
                        MKL_INT* info );

void __stdcall CGTTRS( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* dl, const MKL_Complex8* d,
                       const MKL_Complex8* du, const MKL_Complex8* du2,
                       const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* info );
void __stdcall CGTTRS_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* dl, const MKL_Complex8* d,
                        const MKL_Complex8* du, const MKL_Complex8* du2,
                        const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_INT* info );
void __stdcall cgttrs( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* dl, const MKL_Complex8* d,
                       const MKL_Complex8* du, const MKL_Complex8* du2,
                       const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* info );
void __stdcall cgttrs_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* dl, const MKL_Complex8* d,
                        const MKL_Complex8* du, const MKL_Complex8* du2,
                        const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_INT* info );

void __stdcall CGTTS2( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* dl, const MKL_Complex8* d,
                       const MKL_Complex8* du, const MKL_Complex8* du2,
                       const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb );
void __stdcall CGTTS2_( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* dl, const MKL_Complex8* d,
                        const MKL_Complex8* du, const MKL_Complex8* du2,
                        const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb );
void __stdcall cgtts2( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* dl, const MKL_Complex8* d,
                       const MKL_Complex8* du, const MKL_Complex8* du2,
                       const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb );
void __stdcall cgtts2_( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* dl, const MKL_Complex8* d,
                        const MKL_Complex8* du, const MKL_Complex8* du2,
                        const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb );

void __stdcall CHBEVD( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                       float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall CHBEVD_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                        float* w, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                        MKL_INT* info );
void __stdcall chbevd( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                       float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall chbevd_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                        float* w, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                        MKL_INT* info );

void __stdcall CHBEV( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                      const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab, float* w,
                      MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                      float* rwork, MKL_INT* info );
void __stdcall CHBEV_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                       float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );
void __stdcall chbev( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                      const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab, float* w,
                      MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                      float* rwork, MKL_INT* info );
void __stdcall chbev_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                       float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );

void __stdcall CHBEVX( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                       const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
                       const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall CHBEVX_( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                        const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
                        const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                        float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall chbevx( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                       const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
                       const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall chbevx_( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                        const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
                        const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                        float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void __stdcall CHBGST( const char* vect, int vect_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
                       const MKL_INT* ldab, const MKL_Complex8* bb, const MKL_INT* ldbb,
                       MKL_Complex8* x, const MKL_INT* ldx, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );
void __stdcall CHBGST_( const char* vect, int vect_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
                        const MKL_INT* ldab, const MKL_Complex8* bb, const MKL_INT* ldbb,
                        MKL_Complex8* x, const MKL_INT* ldx, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );
void __stdcall chbgst( const char* vect, int vect_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
                       const MKL_INT* ldab, const MKL_Complex8* bb, const MKL_INT* ldbb,
                       MKL_Complex8* x, const MKL_INT* ldx, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );
void __stdcall chbgst_( const char* vect, int vect_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
                        const MKL_INT* ldab, const MKL_Complex8* bb, const MKL_INT* ldbb,
                        MKL_Complex8* x, const MKL_INT* ldx, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );

void __stdcall CHBGVD( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
                       const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
                       float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall CHBGVD_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
                        const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
                        float* w, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                        MKL_INT* info );
void __stdcall chbgvd( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
                       const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
                       float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall chbgvd_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
                        const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
                        float* w, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                        MKL_INT* info );

void __stdcall CHBGV( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                      const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
                      const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
                      float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                      float* rwork, MKL_INT* info );
void __stdcall CHBGV_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
                       const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
                       float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );
void __stdcall chbgv( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                      const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
                      const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
                      float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                      float* rwork, MKL_INT* info );
void __stdcall chbgv_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
                       const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
                       float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );

void __stdcall CHBGVX( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, const MKL_INT* ka, const MKL_INT* kb,
                       MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* bb,
                       const MKL_INT* ldbb, MKL_Complex8* q, const MKL_INT* ldq,
                       const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall CHBGVX_( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, const MKL_INT* ka, const MKL_INT* kb,
                        MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* bb,
                        const MKL_INT* ldbb, MKL_Complex8* q, const MKL_INT* ldq,
                        const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                        float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall chbgvx( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, const MKL_INT* ka, const MKL_INT* kb,
                       MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* bb,
                       const MKL_INT* ldbb, MKL_Complex8* q, const MKL_INT* ldq,
                       const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall chbgvx_( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, const MKL_INT* ka, const MKL_INT* kb,
                        MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* bb,
                        const MKL_INT* ldbb, MKL_Complex8* q, const MKL_INT* ldq,
                        const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                        float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void __stdcall CHBTRD( const char* vect, int vect_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                       float* d, float* e, MKL_Complex8* q, const MKL_INT* ldq,
                       MKL_Complex8* work, MKL_INT* info );
void __stdcall CHBTRD_( const char* vect, int vect_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                        float* d, float* e, MKL_Complex8* q, const MKL_INT* ldq,
                        MKL_Complex8* work, MKL_INT* info );
void __stdcall chbtrd( const char* vect, int vect_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                       float* d, float* e, MKL_Complex8* q, const MKL_INT* ldq,
                       MKL_Complex8* work, MKL_INT* info );
void __stdcall chbtrd_( const char* vect, int vect_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                        float* d, float* e, MKL_Complex8* q, const MKL_INT* ldq,
                        MKL_Complex8* work, MKL_INT* info );

void __stdcall CHECON( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                       float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall CHECON_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                        float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall checon( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                       float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall checon_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                        float* rcond, MKL_Complex8* work, MKL_INT* info );

void __stdcall CHEEQUB( char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, float* s, float* scond, float* amax,
                        MKL_Complex8* work, MKL_INT* info );
void __stdcall CHEEQUB_( char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                         const MKL_INT* lda, float* s, float* scond, float* amax,
                         MKL_Complex8* work, MKL_INT* info );
void __stdcall cheequb( char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, float* s, float* scond, float* amax,
                        MKL_Complex8* work, MKL_INT* info );
void __stdcall cheequb_( char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                         const MKL_INT* lda, float* s, float* scond, float* amax,
                         MKL_Complex8* work, MKL_INT* info );

void __stdcall CHEEVD( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall CHEEVD_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, float* w,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                        MKL_INT* info );
void __stdcall cheevd( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall cheevd_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, float* w,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                        MKL_INT* info );

void __stdcall CHEEV( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                      MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
                      const MKL_INT* lwork, float* rwork, MKL_INT* info );
void __stdcall CHEEV_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* info );
void __stdcall cheev( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                      MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
                      const MKL_INT* lwork, float* rwork, MKL_INT* info );
void __stdcall cheev_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* info );

void __stdcall CHEEVR( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                       MKL_INT* info );
void __stdcall CHEEVR_( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                        MKL_INT* info );
void __stdcall cheevr( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                       MKL_INT* info );
void __stdcall cheevr_( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                        MKL_INT* info );

void __stdcall CHEEVX( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
                       MKL_INT* ifail, MKL_INT* info );
void __stdcall CHEEVX_( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
                        MKL_INT* ifail, MKL_INT* info );
void __stdcall cheevx( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
                       MKL_INT* ifail, MKL_INT* info );
void __stdcall cheevx_( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
                        MKL_INT* ifail, MKL_INT* info );

void __stdcall CHEGS2( const MKL_INT* itype, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall CHEGS2_( const MKL_INT* itype, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );
void __stdcall chegs2( const MKL_INT* itype, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall chegs2_( const MKL_INT* itype, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );

void __stdcall CHEGST( const MKL_INT* itype, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall CHEGST_( const MKL_INT* itype, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );
void __stdcall chegst( const MKL_INT* itype, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall chegst_( const MKL_INT* itype, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );

void __stdcall CHEGVD( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall CHEGVD_( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* b, const MKL_INT* ldb, float* w,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                        MKL_INT* info );
void __stdcall chegvd( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall chegvd_( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* b, const MKL_INT* ldb, float* w,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                        MKL_INT* info );

void __stdcall CHEGV( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                      const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                      MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
                      const MKL_INT* lwork, float* rwork, MKL_INT* info );
void __stdcall CHEGV_( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* info );
void __stdcall chegv( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                      const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                      MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
                      const MKL_INT* lwork, float* rwork, MKL_INT* info );
void __stdcall chegv_( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* info );

void __stdcall CHEGVX( const MKL_INT* itype, const char* jobz, int jobz_len, const char* range, int range_len,
                       const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
                       MKL_INT* ifail, MKL_INT* info );
void __stdcall CHEGVX_( const MKL_INT* itype, const char* jobz, int jobz_len, const char* range, int range_len,
                        const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
                        MKL_INT* ifail, MKL_INT* info );
void __stdcall chegvx( const MKL_INT* itype, const char* jobz, int jobz_len, const char* range, int range_len,
                       const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                       const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
                       MKL_INT* ifail, MKL_INT* info );
void __stdcall chegvx_( const MKL_INT* itype, const char* jobz, int jobz_len, const char* range, int range_len,
                        const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
                        const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
                        MKL_INT* ifail, MKL_INT* info );

void __stdcall CHERFS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
                       const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                       float* ferr, float* berr, MKL_Complex8* work, float* rwork,
                       MKL_INT* info );
void __stdcall CHERFS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );
void __stdcall cherfs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
                       const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                       float* ferr, float* berr, MKL_Complex8* work, float* rwork,
                       MKL_INT* info );
void __stdcall cherfs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );

void __stdcall CHERFSX( const char* uplo, int uplo_len, const char* equed, int equed_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
                        const float* s, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CHERFSX_( const char* uplo, int uplo_len, const char* equed, int equed_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* af, const MKL_INT* ldaf,
                         const MKL_INT* ipiv, const float* s, const MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                         float* rcond, float* berr, const MKL_INT* n_err_bnds,
                         float* err_bnds_norm, float* err_bnds_comp,
                         const MKL_INT* nparams, float* params, MKL_Complex8* work,
                         float* rwork, MKL_INT* info );
void __stdcall cherfsx( const char* uplo, int uplo_len, const char* equed, int equed_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
                        const float* s, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cherfsx_( const char* uplo, int uplo_len, const char* equed, int equed_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* af, const MKL_INT* ldaf,
                         const MKL_INT* ipiv, const float* s, const MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                         float* rcond, float* berr, const MKL_INT* n_err_bnds,
                         float* err_bnds_norm, float* err_bnds_comp,
                         const MKL_INT* nparams, float* params, MKL_Complex8* work,
                         float* rwork, MKL_INT* info );

void __stdcall CHESV( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall CHESV_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall chesv( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall chesv_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );

void __stdcall CHESVX( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                       const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* info );
void __stdcall CHESVX_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* info );
void __stdcall chesvx( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                       const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* info );
void __stdcall chesvx_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* info );

void __stdcall CHESVXX( const char* fact, int fact_len, char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                        char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* rpvgrw,
                        float* berr, const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CHESVXX_( const char* fact, int fact_len, char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                         MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                         char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                         MKL_Complex8* x, const MKL_INT* ldx, float* rcond,
                         float* rpvgrw, float* berr, const MKL_INT* n_err_bnds,
                         float* err_bnds_norm, float* err_bnds_comp,
                         const MKL_INT* nparams, float* params, MKL_Complex8* work,
                         float* rwork, MKL_INT* info );
void __stdcall chesvxx( const char* fact, int fact_len, char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                        char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* rpvgrw,
                        float* berr, const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall chesvxx_( const char* fact, int fact_len, char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                         MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                         char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                         MKL_Complex8* x, const MKL_INT* ldx, float* rcond,
                         float* rpvgrw, float* berr, const MKL_INT* n_err_bnds,
                         float* err_bnds_norm, float* err_bnds_comp,
                         const MKL_INT* nparams, float* params, MKL_Complex8* work,
                         float* rwork, MKL_INT* info );

void __stdcall CHETD2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
                       MKL_INT* info );
void __stdcall CHETD2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
                        MKL_INT* info );
void __stdcall chetd2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
                       MKL_INT* info );
void __stdcall chetd2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
                        MKL_INT* info );

void __stdcall CHETF2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall CHETF2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall chetf2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void __stdcall chetf2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void __stdcall CHETRD( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall CHETRD_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall chetrd( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
                       MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall chetrd_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall CHETRF( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall CHETRF_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );
void __stdcall chetrf( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall chetrf_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                        const MKL_INT* lwork, MKL_INT* info );

void __stdcall CHETRI( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                       MKL_INT* info );
void __stdcall CHETRI_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                        MKL_INT* info );
void __stdcall chetri( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                       MKL_INT* info );
void __stdcall chetri_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                        MKL_INT* info );

void __stdcall CHETRS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall CHETRS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall chetrs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall chetrs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void __stdcall CHFRK( const char* transr, int transr_len, const char* uplo, int uplo_len, const char* trans, int trans_len,
                      const MKL_INT* n, const MKL_INT* k, const float* alpha,
                      const MKL_Complex8* a, const MKL_INT* lda, const float* beta,
                      MKL_Complex8* c );
void __stdcall CHFRK_( const char* transr, int transr_len, const char* uplo, int uplo_len, const char* trans, int trans_len,
                       const MKL_INT* n, const MKL_INT* k, const float* alpha,
                       const MKL_Complex8* a, const MKL_INT* lda, const float* beta,
                       MKL_Complex8* c );
void __stdcall chfrk( const char* transr, int transr_len, const char* uplo, int uplo_len, const char* trans, int trans_len,
                      const MKL_INT* n, const MKL_INT* k, const float* alpha,
                      const MKL_Complex8* a, const MKL_INT* lda, const float* beta,
                      MKL_Complex8* c );
void __stdcall chfrk_( const char* transr, int transr_len, const char* uplo, int uplo_len, const char* trans, int trans_len,
                       const MKL_INT* n, const MKL_INT* k, const float* alpha,
                       const MKL_Complex8* a, const MKL_INT* lda, const float* beta,
                       MKL_Complex8* c );

void __stdcall CHGEQZ( const char* job, int job_len, const char* compq, int compq_len, const char* compz, int compz_len,
                       const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* t,
                       const MKL_INT* ldt, MKL_Complex8* alpha, MKL_Complex8* beta,
                       MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
                       const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );
void __stdcall CHGEQZ_( const char* job, int job_len, const char* compq, int compq_len, const char* compz, int compz_len,
                        const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_Complex8* alpha, MKL_Complex8* beta,
                        MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
                        const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
                        float* rwork, MKL_INT* info );
void __stdcall chgeqz( const char* job, int job_len, const char* compq, int compq_len, const char* compz, int compz_len,
                       const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                       MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* t,
                       const MKL_INT* ldt, MKL_Complex8* alpha, MKL_Complex8* beta,
                       MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
                       const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
                       float* rwork, MKL_INT* info );
void __stdcall chgeqz_( const char* job, int job_len, const char* compq, int compq_len, const char* compz, int compz_len,
                        const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
                        MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* t,
                        const MKL_INT* ldt, MKL_Complex8* alpha, MKL_Complex8* beta,
                        MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
                        const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
                        float* rwork, MKL_INT* info );

void __stdcall CHLA_TRANSTYPE( char* ret_val, int ret_val_len, const MKL_INT* trans );
void __stdcall CHLA_TRANSTYPE_( char* ret_val, int ret_val_len, const MKL_INT* trans );
void __stdcall chla_transtype( char* ret_val, int ret_val_len, const MKL_INT* trans );
void __stdcall chla_transtype_( char* ret_val, int ret_val_len, const MKL_INT* trans );

void __stdcall CHPCON( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                       const MKL_INT* ipiv, const float* anorm, float* rcond,
                       MKL_Complex8* work, MKL_INT* info );
void __stdcall CHPCON_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                        const MKL_INT* ipiv, const float* anorm, float* rcond,
                        MKL_Complex8* work, MKL_INT* info );
void __stdcall chpcon( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                       const MKL_INT* ipiv, const float* anorm, float* rcond,
                       MKL_Complex8* work, MKL_INT* info );
void __stdcall chpcon_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                        const MKL_INT* ipiv, const float* anorm, float* rcond,
                        MKL_Complex8* work, MKL_INT* info );

void __stdcall CHPEVD( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                       MKL_INT* info );
void __stdcall CHPEVD_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                        MKL_INT* info );
void __stdcall chpevd( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                       MKL_INT* info );
void __stdcall chpevd_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
                        MKL_INT* info );

void __stdcall CHPEV( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                      MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
                      MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CHPEV_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall chpev( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                      MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
                      MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall chpev_( const char* jobz, int jobz_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CHPEVX( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* ap, const float* vl,
                       const float* vu, const MKL_INT* il, const MKL_INT* iu,
                       const float* abstol, MKL_INT* m, float* w, MKL_Complex8* z,
                       const MKL_INT* ldz, MKL_Complex8* work, float* rwork,
                       MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall CHPEVX_( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, MKL_Complex8* ap, const float* vl,
                        const float* vu, const MKL_INT* il, const MKL_INT* iu,
                        const float* abstol, MKL_INT* m, float* w, MKL_Complex8* z,
                        const MKL_INT* ldz, MKL_Complex8* work, float* rwork,
                        MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall chpevx( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* ap, const float* vl,
                       const float* vu, const MKL_INT* il, const MKL_INT* iu,
                       const float* abstol, MKL_INT* m, float* w, MKL_Complex8* z,
                       const MKL_INT* ldz, MKL_Complex8* work, float* rwork,
                       MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall chpevx_( const char* jobz, int jobz_len, const char* range, int range_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, MKL_Complex8* ap, const float* vl,
                        const float* vu, const MKL_INT* il, const MKL_INT* iu,
                        const float* abstol, MKL_INT* m, float* w, MKL_Complex8* z,
                        const MKL_INT* ldz, MKL_Complex8* work, float* rwork,
                        MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void __stdcall CHPGST( const MKL_INT* itype, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* ap, const MKL_Complex8* bp, MKL_INT* info );
void __stdcall CHPGST_( const MKL_INT* itype, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* ap, const MKL_Complex8* bp, MKL_INT* info );
void __stdcall chpgst( const MKL_INT* itype, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* ap, const MKL_Complex8* bp, MKL_INT* info );
void __stdcall chpgst_( const MKL_INT* itype, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* ap, const MKL_Complex8* bp, MKL_INT* info );

void __stdcall CHPGVD( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall CHPGVD_( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                        MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall chpgvd( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall chpgvd_( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                        MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );

void __stdcall CHPGV( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                      const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
                      MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                      float* rwork, MKL_INT* info );
void __stdcall CHPGV_( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );
void __stdcall chpgv( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                      const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
                      MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                      float* rwork, MKL_INT* info );
void __stdcall chpgv_( const MKL_INT* itype, const char* jobz, int jobz_len, const char* uplo, int uplo_len,
                       const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );

void __stdcall CHPGVX( const MKL_INT* itype, const char* jobz, int jobz_len, const char* range, int range_len,
                       const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       MKL_Complex8* bp, const float* vl, const float* vu,
                       const MKL_INT* il, const MKL_INT* iu, const float* abstol,
                       MKL_INT* m, float* w, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* ifail,
                       MKL_INT* info );
void __stdcall CHPGVX_( const MKL_INT* itype, const char* jobz, int jobz_len, const char* range, int range_len,
                        const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        MKL_Complex8* bp, const float* vl, const float* vu,
                        const MKL_INT* il, const MKL_INT* iu, const float* abstol,
                        MKL_INT* m, float* w, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* ifail,
                        MKL_INT* info );
void __stdcall chpgvx( const MKL_INT* itype, const char* jobz, int jobz_len, const char* range, int range_len,
                       const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       MKL_Complex8* bp, const float* vl, const float* vu,
                       const MKL_INT* il, const MKL_INT* iu, const float* abstol,
                       MKL_INT* m, float* w, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* ifail,
                       MKL_INT* info );
void __stdcall chpgvx_( const MKL_INT* itype, const char* jobz, int jobz_len, const char* range, int range_len,
                        const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        MKL_Complex8* bp, const float* vl, const float* vu,
                        const MKL_INT* il, const MKL_INT* iu, const float* abstol,
                        MKL_INT* m, float* w, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* ifail,
                        MKL_INT* info );

void __stdcall CHPRFS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* ap, const MKL_Complex8* afp,
                       const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CHPRFS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* ap, const MKL_Complex8* afp,
                        const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall chprfs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* ap, const MKL_Complex8* afp,
                       const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall chprfs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* ap, const MKL_Complex8* afp,
                        const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CHPSV( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_INT* info );
void __stdcall CHPSV_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall chpsv( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_INT* info );
void __stdcall chpsv_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );

void __stdcall CHPSVX( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
                       MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CHPSVX_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
                        MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                        float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall chpsvx( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
                       MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall chpsvx_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
                        MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                        float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CHPTRD( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap, float* d,
                       float* e, MKL_Complex8* tau, MKL_INT* info );
void __stdcall CHPTRD_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap, float* d,
                        float* e, MKL_Complex8* tau, MKL_INT* info );
void __stdcall chptrd( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap, float* d,
                       float* e, MKL_Complex8* tau, MKL_INT* info );
void __stdcall chptrd_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap, float* d,
                        float* e, MKL_Complex8* tau, MKL_INT* info );

void __stdcall CHPTRF( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       MKL_INT* ipiv, MKL_INT* info );
void __stdcall CHPTRF_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        MKL_INT* ipiv, MKL_INT* info );
void __stdcall chptrf( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       MKL_INT* ipiv, MKL_INT* info );
void __stdcall chptrf_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        MKL_INT* ipiv, MKL_INT* info );

void __stdcall CHPTRI( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );
void __stdcall CHPTRI_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );
void __stdcall chptri( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );
void __stdcall chptri_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );

void __stdcall CHPTRS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall CHPTRS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );
void __stdcall chptrs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall chptrs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );

void __stdcall CHSEIN( const char* side, int side_len, const char* eigsrc, int eigsrc_len, const char* initv, int initv_len,
                       const MKL_INT* select, const MKL_INT* n, const MKL_Complex8* h,
                       const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* vl,
                       const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
                       const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
                       MKL_INT* ifaill, MKL_INT* ifailr, MKL_INT* info );
void __stdcall CHSEIN_( const char* side, int side_len, const char* eigsrc, int eigsrc_len, const char* initv, int initv_len,
                        const MKL_INT* select, const MKL_INT* n, const MKL_Complex8* h,
                        const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* vl,
                        const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
                        const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
                        MKL_INT* ifaill, MKL_INT* ifailr, MKL_INT* info );
void __stdcall chsein( const char* side, int side_len, const char* eigsrc, int eigsrc_len, const char* initv, int initv_len,
                       const MKL_INT* select, const MKL_INT* n, const MKL_Complex8* h,
                       const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* vl,
                       const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
                       const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
                       MKL_INT* ifaill, MKL_INT* ifailr, MKL_INT* info );
void __stdcall chsein_( const char* side, int side_len, const char* eigsrc, int eigsrc_len, const char* initv, int initv_len,
                        const MKL_INT* select, const MKL_INT* n, const MKL_Complex8* h,
                        const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* vl,
                        const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
                        const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
                        MKL_INT* ifaill, MKL_INT* ifailr, MKL_INT* info );

void __stdcall CHSEQR( const char* job, int job_len, const char* compz, int compz_len, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                       const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* z,
                       const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall CHSEQR_( const char* job, int job_len, const char* compz, int compz_len, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                        const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* z,
                        const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void __stdcall chseqr( const char* job, int job_len, const char* compz, int compz_len, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                       const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* z,
                       const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void __stdcall chseqr_( const char* job, int job_len, const char* compz, int compz_len, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                        const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* z,
                        const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );

void __stdcall CLABRD( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                       MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
                       MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x,
                       const MKL_INT* ldx, MKL_Complex8* y, const MKL_INT* ldy );
void __stdcall CLABRD_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                        MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
                        MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x,
                        const MKL_INT* ldx, MKL_Complex8* y, const MKL_INT* ldy );
void __stdcall clabrd( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                       MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
                       MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x,
                       const MKL_INT* ldx, MKL_Complex8* y, const MKL_INT* ldy );
void __stdcall clabrd_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
                        MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
                        MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x,
                        const MKL_INT* ldx, MKL_Complex8* y, const MKL_INT* ldy );

void __stdcall CLACGV( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx );
void __stdcall CLACGV_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx );
void __stdcall clacgv( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx );
void __stdcall clacgv_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx );

void __stdcall CLACN2( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
                       MKL_INT* kase, MKL_INT* isave );
void __stdcall CLACN2_( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
                        MKL_INT* kase, MKL_INT* isave );
void __stdcall clacn2( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
                       MKL_INT* kase, MKL_INT* isave );
void __stdcall clacn2_( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
                        MKL_INT* kase, MKL_INT* isave );

void __stdcall CLACON( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
                       MKL_INT* kase );
void __stdcall CLACON_( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
                        MKL_INT* kase );
void __stdcall clacon( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
                       MKL_INT* kase );
void __stdcall clacon_( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
                        MKL_INT* kase );

void __stdcall CLACP2( const char* uplo, int uplo_len, const MKL_INT* m, const MKL_INT* n,
                       const float* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb );
void __stdcall CLACP2_( const char* uplo, int uplo_len, const MKL_INT* m, const MKL_INT* n,
                        const float* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb );
void __stdcall clacp2( const char* uplo, int uplo_len, const MKL_INT* m, const MKL_INT* n,
                       const float* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb );
void __stdcall clacp2_( const char* uplo, int uplo_len, const MKL_INT* m, const MKL_INT* n,
                        const float* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb );

void __stdcall CLACPY( const char* uplo, int uplo_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb );
void __stdcall CLACPY_( const char* uplo, int uplo_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb );
void __stdcall clacpy( const char* uplo, int uplo_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb );
void __stdcall clacpy_( const char* uplo, int uplo_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb );

void __stdcall CLACRM( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, const float* b, const MKL_INT* ldb,
                       MKL_Complex8* c, const MKL_INT* ldc, float* rwork );
void __stdcall CLACRM_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, const float* b, const MKL_INT* ldb,
                        MKL_Complex8* c, const MKL_INT* ldc, float* rwork );
void __stdcall clacrm( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, const float* b, const MKL_INT* ldb,
                       MKL_Complex8* c, const MKL_INT* ldc, float* rwork );
void __stdcall clacrm_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, const float* b, const MKL_INT* ldb,
                        MKL_Complex8* c, const MKL_INT* ldc, float* rwork );

void __stdcall CLACRT( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
                       MKL_Complex8* cy, const MKL_INT* incy, const MKL_Complex8* c,
                       const MKL_Complex8* s );
void __stdcall CLACRT_( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
                        MKL_Complex8* cy, const MKL_INT* incy, const MKL_Complex8* c,
                        const MKL_Complex8* s );
void __stdcall clacrt( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
                       MKL_Complex8* cy, const MKL_INT* incy, const MKL_Complex8* c,
                       const MKL_Complex8* s );
void __stdcall clacrt_( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
                        MKL_Complex8* cy, const MKL_INT* incy, const MKL_Complex8* c,
                        const MKL_Complex8* s );

void __stdcall CLADIV( MKL_Complex8* ret_value, const MKL_Complex8* x,
                       const MKL_Complex8* y );
void __stdcall CLADIV_( MKL_Complex8* ret_value, const MKL_Complex8* x,
                        const MKL_Complex8* y );
void __stdcall cladiv( MKL_Complex8* ret_value, const MKL_Complex8* x,
                       const MKL_Complex8* y );
void __stdcall cladiv_( MKL_Complex8* ret_value, const MKL_Complex8* x,
                        const MKL_Complex8* y );

void __stdcall CLAED0( const MKL_INT* qsiz, const MKL_INT* n, float* d, float* e,
                       MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* qstore,
                       const MKL_INT* ldqs, float* rwork, MKL_INT* iwork,
                       MKL_INT* info );
void __stdcall CLAED0_( const MKL_INT* qsiz, const MKL_INT* n, float* d, float* e,
                        MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* qstore,
                        const MKL_INT* ldqs, float* rwork, MKL_INT* iwork,
                        MKL_INT* info );
void __stdcall claed0( const MKL_INT* qsiz, const MKL_INT* n, float* d, float* e,
                       MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* qstore,
                       const MKL_INT* ldqs, float* rwork, MKL_INT* iwork,
                       MKL_INT* info );
void __stdcall claed0_( const MKL_INT* qsiz, const MKL_INT* n, float* d, float* e,
                        MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* qstore,
                        const MKL_INT* ldqs, float* rwork, MKL_INT* iwork,
                        MKL_INT* info );

void __stdcall CLAED7( const MKL_INT* n, const MKL_INT* cutpnt, const MKL_INT* qsiz,
                       const MKL_INT* tlvls, const MKL_INT* curlvl,
                       const MKL_INT* curpbm, float* d, MKL_Complex8* q,
                       const MKL_INT* ldq, const float* rho, MKL_INT* indxq,
                       float* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
                       const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
                       const float* givnum, MKL_Complex8* work, float* rwork,
                       MKL_INT* iwork, MKL_INT* info );
void __stdcall CLAED7_( const MKL_INT* n, const MKL_INT* cutpnt, const MKL_INT* qsiz,
                        const MKL_INT* tlvls, const MKL_INT* curlvl,
                        const MKL_INT* curpbm, float* d, MKL_Complex8* q,
                        const MKL_INT* ldq, const float* rho, MKL_INT* indxq,
                        float* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
                        const MKL_INT* perm, const MKL_INT* givptr,
                        const MKL_INT* givcol, const float* givnum, MKL_Complex8* work,
                        float* rwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall claed7( const MKL_INT* n, const MKL_INT* cutpnt, const MKL_INT* qsiz,
                       const MKL_INT* tlvls, const MKL_INT* curlvl,
                       const MKL_INT* curpbm, float* d, MKL_Complex8* q,
                       const MKL_INT* ldq, const float* rho, MKL_INT* indxq,
                       float* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
                       const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
                       const float* givnum, MKL_Complex8* work, float* rwork,
                       MKL_INT* iwork, MKL_INT* info );
void __stdcall claed7_( const MKL_INT* n, const MKL_INT* cutpnt, const MKL_INT* qsiz,
                        const MKL_INT* tlvls, const MKL_INT* curlvl,
                        const MKL_INT* curpbm, float* d, MKL_Complex8* q,
                        const MKL_INT* ldq, const float* rho, MKL_INT* indxq,
                        float* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
                        const MKL_INT* perm, const MKL_INT* givptr,
                        const MKL_INT* givcol, const float* givnum, MKL_Complex8* work,
                        float* rwork, MKL_INT* iwork, MKL_INT* info );

void __stdcall CLAED8( MKL_INT* k, const MKL_INT* n, const MKL_INT* qsiz,
                       MKL_Complex8* q, const MKL_INT* ldq, float* d, float* rho,
                       const MKL_INT* cutpnt, const float* z, float* dlamda,
                       MKL_Complex8* q2, const MKL_INT* ldq2, float* w, MKL_INT* indxp,
                       MKL_INT* indx, const MKL_INT* indxq, MKL_INT* perm,
                       MKL_INT* givptr, MKL_INT* givcol, float* givnum, MKL_INT* info );
void __stdcall CLAED8_( MKL_INT* k, const MKL_INT* n, const MKL_INT* qsiz,
                        MKL_Complex8* q, const MKL_INT* ldq, float* d, float* rho,
                        const MKL_INT* cutpnt, const float* z, float* dlamda,
                        MKL_Complex8* q2, const MKL_INT* ldq2, float* w, MKL_INT* indxp,
                        MKL_INT* indx, const MKL_INT* indxq, MKL_INT* perm,
                        MKL_INT* givptr, MKL_INT* givcol, float* givnum, MKL_INT* info );
void __stdcall claed8( MKL_INT* k, const MKL_INT* n, const MKL_INT* qsiz,
                       MKL_Complex8* q, const MKL_INT* ldq, float* d, float* rho,
                       const MKL_INT* cutpnt, const float* z, float* dlamda,
                       MKL_Complex8* q2, const MKL_INT* ldq2, float* w, MKL_INT* indxp,
                       MKL_INT* indx, const MKL_INT* indxq, MKL_INT* perm,
                       MKL_INT* givptr, MKL_INT* givcol, float* givnum, MKL_INT* info );
void __stdcall claed8_( MKL_INT* k, const MKL_INT* n, const MKL_INT* qsiz,
                        MKL_Complex8* q, const MKL_INT* ldq, float* d, float* rho,
                        const MKL_INT* cutpnt, const float* z, float* dlamda,
                        MKL_Complex8* q2, const MKL_INT* ldq2, float* w, MKL_INT* indxp,
                        MKL_INT* indx, const MKL_INT* indxq, MKL_INT* perm,
                        MKL_INT* givptr, MKL_INT* givcol, float* givnum, MKL_INT* info );

void __stdcall CLAEIN( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
                       const MKL_Complex8* h, const MKL_INT* ldh, const MKL_Complex8* w,
                       MKL_Complex8* v, MKL_Complex8* b, const MKL_INT* ldb,
                       float* rwork, const float* eps3, const float* smlnum,
                       MKL_INT* info );
void __stdcall CLAEIN_( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
                        const MKL_Complex8* h, const MKL_INT* ldh, const MKL_Complex8* w,
                        MKL_Complex8* v, MKL_Complex8* b, const MKL_INT* ldb,
                        float* rwork, const float* eps3, const float* smlnum,
                        MKL_INT* info );
void __stdcall claein( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
                       const MKL_Complex8* h, const MKL_INT* ldh, const MKL_Complex8* w,
                       MKL_Complex8* v, MKL_Complex8* b, const MKL_INT* ldb,
                       float* rwork, const float* eps3, const float* smlnum,
                       MKL_INT* info );
void __stdcall claein_( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
                        const MKL_Complex8* h, const MKL_INT* ldh, const MKL_Complex8* w,
                        MKL_Complex8* v, MKL_Complex8* b, const MKL_INT* ldb,
                        float* rwork, const float* eps3, const float* smlnum,
                        MKL_INT* info );

void __stdcall CLAESY( const MKL_Complex8* a, const MKL_Complex8* b,
                       const MKL_Complex8* c, MKL_Complex8* rt1, MKL_Complex8* rt2,
                       MKL_Complex8* evscal, MKL_Complex8* cs1, MKL_Complex8* sn1 );
void __stdcall CLAESY_( const MKL_Complex8* a, const MKL_Complex8* b,
                        const MKL_Complex8* c, MKL_Complex8* rt1, MKL_Complex8* rt2,
                        MKL_Complex8* evscal, MKL_Complex8* cs1, MKL_Complex8* sn1 );
void __stdcall claesy( const MKL_Complex8* a, const MKL_Complex8* b,
                       const MKL_Complex8* c, MKL_Complex8* rt1, MKL_Complex8* rt2,
                       MKL_Complex8* evscal, MKL_Complex8* cs1, MKL_Complex8* sn1 );
void __stdcall claesy_( const MKL_Complex8* a, const MKL_Complex8* b,
                        const MKL_Complex8* c, MKL_Complex8* rt1, MKL_Complex8* rt2,
                        MKL_Complex8* evscal, MKL_Complex8* cs1, MKL_Complex8* sn1 );

void __stdcall CLAEV2( const MKL_Complex8* a, const MKL_Complex8* b,
                       const MKL_Complex8* c, float* rt1, float* rt2, float* cs1,
                       MKL_Complex8* sn1 );
void __stdcall CLAEV2_( const MKL_Complex8* a, const MKL_Complex8* b,
                        const MKL_Complex8* c, float* rt1, float* rt2, float* cs1,
                        MKL_Complex8* sn1 );
void __stdcall claev2( const MKL_Complex8* a, const MKL_Complex8* b,
                       const MKL_Complex8* c, float* rt1, float* rt2, float* cs1,
                       MKL_Complex8* sn1 );
void __stdcall claev2_( const MKL_Complex8* a, const MKL_Complex8* b,
                        const MKL_Complex8* c, float* rt1, float* rt2, float* cs1,
                        MKL_Complex8* sn1 );

void __stdcall CLAG2Z( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* sa,
                       const MKL_INT* ldsa, MKL_Complex16* a, const MKL_INT* lda,
                       MKL_INT* info );
void __stdcall CLAG2Z_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* sa,
                        const MKL_INT* ldsa, MKL_Complex16* a, const MKL_INT* lda,
                        MKL_INT* info );
void __stdcall clag2z( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* sa,
                       const MKL_INT* ldsa, MKL_Complex16* a, const MKL_INT* lda,
                       MKL_INT* info );
void __stdcall clag2z_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* sa,
                        const MKL_INT* ldsa, MKL_Complex16* a, const MKL_INT* lda,
                        MKL_INT* info );

void __stdcall CLAGS2( const MKL_INT* upper, const float* a1, const MKL_Complex8* a2,
                       const float* a3, const float* b1, const MKL_Complex8* b2,
                       const float* b3, float* csu, MKL_Complex8* snu, float* csv,
                       MKL_Complex8* snv, float* csq, MKL_Complex8* snq );
void __stdcall CLAGS2_( const MKL_INT* upper, const float* a1, const MKL_Complex8* a2,
                        const float* a3, const float* b1, const MKL_Complex8* b2,
                        const float* b3, float* csu, MKL_Complex8* snu, float* csv,
                        MKL_Complex8* snv, float* csq, MKL_Complex8* snq );
void __stdcall clags2( const MKL_INT* upper, const float* a1, const MKL_Complex8* a2,
                       const float* a3, const float* b1, const MKL_Complex8* b2,
                       const float* b3, float* csu, MKL_Complex8* snu, float* csv,
                       MKL_Complex8* snv, float* csq, MKL_Complex8* snq );
void __stdcall clags2_( const MKL_INT* upper, const float* a1, const MKL_Complex8* a2,
                        const float* a3, const float* b1, const MKL_Complex8* b2,
                        const float* b3, float* csu, MKL_Complex8* snu, float* csv,
                        MKL_Complex8* snv, float* csq, MKL_Complex8* snq );

void __stdcall CLAGTM( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* alpha, const MKL_Complex8* dl, const MKL_Complex8* d,
                       const MKL_Complex8* du, const MKL_Complex8* x, const MKL_INT* ldx,
                       const float* beta, MKL_Complex8* b, const MKL_INT* ldb );
void __stdcall CLAGTM_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const float* alpha, const MKL_Complex8* dl,
                        const MKL_Complex8* d, const MKL_Complex8* du,
                        const MKL_Complex8* x, const MKL_INT* ldx, const float* beta,
                        MKL_Complex8* b, const MKL_INT* ldb );
void __stdcall clagtm( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* alpha, const MKL_Complex8* dl, const MKL_Complex8* d,
                       const MKL_Complex8* du, const MKL_Complex8* x, const MKL_INT* ldx,
                       const float* beta, MKL_Complex8* b, const MKL_INT* ldb );
void __stdcall clagtm_( const char* trans, int trans_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const float* alpha, const MKL_Complex8* dl,
                        const MKL_Complex8* d, const MKL_Complex8* du,
                        const MKL_Complex8* x, const MKL_INT* ldx, const float* beta,
                        MKL_Complex8* b, const MKL_INT* ldb );

void __stdcall CLAHEF( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                       MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                       MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall CLAHEF_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                        MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                        MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall clahef( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                       MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                       MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall clahef_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                        MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                        MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );

void __stdcall CLAHQR( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                       const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz,
                       const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_INT* info );
void __stdcall CLAHQR_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                        const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz,
                        const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_INT* info );
void __stdcall clahqr( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                       const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz,
                       const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_INT* info );
void __stdcall clahqr_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                        const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz,
                        const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_INT* info );

void __stdcall CLAHR2( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                       MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
                       const MKL_INT* ldy );
void __stdcall CLAHR2_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                        MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
                        const MKL_INT* ldy );
void __stdcall clahr2( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                       MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
                       const MKL_INT* ldy );
void __stdcall clahr2_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                        MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
                        const MKL_INT* ldy );

void __stdcall CLAHRD( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                       MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
                       const MKL_INT* ldy );
void __stdcall CLAHRD_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                        MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
                        const MKL_INT* ldy );
void __stdcall clahrd( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                       MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
                       const MKL_INT* ldy );
void __stdcall clahrd_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                        MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
                        const MKL_INT* ldy );

void __stdcall CLAIC1( const MKL_INT* job, const MKL_INT* j, const MKL_Complex8* x,
                       const float* sest, const MKL_Complex8* w,
                       const MKL_Complex8* gamma, float* sestpr, MKL_Complex8* s,
                       MKL_Complex8* c );
void __stdcall CLAIC1_( const MKL_INT* job, const MKL_INT* j, const MKL_Complex8* x,
                        const float* sest, const MKL_Complex8* w,
                        const MKL_Complex8* gamma, float* sestpr, MKL_Complex8* s,
                        MKL_Complex8* c );
void __stdcall claic1( const MKL_INT* job, const MKL_INT* j, const MKL_Complex8* x,
                       const float* sest, const MKL_Complex8* w,
                       const MKL_Complex8* gamma, float* sestpr, MKL_Complex8* s,
                       MKL_Complex8* c );
void __stdcall claic1_( const MKL_INT* job, const MKL_INT* j, const MKL_Complex8* x,
                        const float* sest, const MKL_Complex8* w,
                        const MKL_Complex8* gamma, float* sestpr, MKL_Complex8* s,
                        MKL_Complex8* c );

void __stdcall CLALS0( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
                       const MKL_INT* sqre, const MKL_INT* nrhs, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* bx, const MKL_INT* ldbx,
                       const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
                       const MKL_INT* ldgcol, const float* givnum, const MKL_INT* ldgnum,
                       const float* poles, const float* difl, const float* difr,
                       const float* z, const MKL_INT* k, const float* c, const float* s,
                       float* rwork, MKL_INT* info );
void __stdcall CLALS0_( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
                        const MKL_INT* sqre, const MKL_INT* nrhs, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* bx, const MKL_INT* ldbx,
                        const MKL_INT* perm, const MKL_INT* givptr,
                        const MKL_INT* givcol, const MKL_INT* ldgcol,
                        const float* givnum, const MKL_INT* ldgnum, const float* poles,
                        const float* difl, const float* difr, const float* z,
                        const MKL_INT* k, const float* c, const float* s, float* rwork,
                        MKL_INT* info );
void __stdcall clals0( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
                       const MKL_INT* sqre, const MKL_INT* nrhs, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* bx, const MKL_INT* ldbx,
                       const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
                       const MKL_INT* ldgcol, const float* givnum, const MKL_INT* ldgnum,
                       const float* poles, const float* difl, const float* difr,
                       const float* z, const MKL_INT* k, const float* c, const float* s,
                       float* rwork, MKL_INT* info );
void __stdcall clals0_( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
                        const MKL_INT* sqre, const MKL_INT* nrhs, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* bx, const MKL_INT* ldbx,
                        const MKL_INT* perm, const MKL_INT* givptr,
                        const MKL_INT* givcol, const MKL_INT* ldgcol,
                        const float* givnum, const MKL_INT* ldgnum, const float* poles,
                        const float* difl, const float* difr, const float* z,
                        const MKL_INT* k, const float* c, const float* s, float* rwork,
                        MKL_INT* info );

void __stdcall CLALSA( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
                       const MKL_INT* nrhs, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* bx, const MKL_INT* ldbx, const float* u,
                       const MKL_INT* ldu, const float* vt, const MKL_INT* k,
                       const float* difl, const float* difr, const float* z,
                       const float* poles, const MKL_INT* givptr, const MKL_INT* givcol,
                       const MKL_INT* ldgcol, const MKL_INT* perm, const float* givnum,
                       const float* c, const float* s, float* rwork, MKL_INT* iwork,
                       MKL_INT* info );
void __stdcall CLALSA_( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* bx, const MKL_INT* ldbx, const float* u,
                        const MKL_INT* ldu, const float* vt, const MKL_INT* k,
                        const float* difl, const float* difr, const float* z,
                        const float* poles, const MKL_INT* givptr, const MKL_INT* givcol,
                        const MKL_INT* ldgcol, const MKL_INT* perm, const float* givnum,
                        const float* c, const float* s, float* rwork, MKL_INT* iwork,
                        MKL_INT* info );
void __stdcall clalsa( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
                       const MKL_INT* nrhs, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* bx, const MKL_INT* ldbx, const float* u,
                       const MKL_INT* ldu, const float* vt, const MKL_INT* k,
                       const float* difl, const float* difr, const float* z,
                       const float* poles, const MKL_INT* givptr, const MKL_INT* givcol,
                       const MKL_INT* ldgcol, const MKL_INT* perm, const float* givnum,
                       const float* c, const float* s, float* rwork, MKL_INT* iwork,
                       MKL_INT* info );
void __stdcall clalsa_( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* bx, const MKL_INT* ldbx, const float* u,
                        const MKL_INT* ldu, const float* vt, const MKL_INT* k,
                        const float* difl, const float* difr, const float* z,
                        const float* poles, const MKL_INT* givptr, const MKL_INT* givcol,
                        const MKL_INT* ldgcol, const MKL_INT* perm, const float* givnum,
                        const float* c, const float* s, float* rwork, MKL_INT* iwork,
                        MKL_INT* info );

void __stdcall CLALSD( const char* uplo, int uplo_len, const MKL_INT* smlsiz, const MKL_INT* n,
                       const MKL_INT* nrhs, float* d, float* e, MKL_Complex8* b,
                       const MKL_INT* ldb, const float* rcond, MKL_INT* rank,
                       MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall CLALSD_( const char* uplo, int uplo_len, const MKL_INT* smlsiz, const MKL_INT* n,
                        const MKL_INT* nrhs, float* d, float* e, MKL_Complex8* b,
                        const MKL_INT* ldb, const float* rcond, MKL_INT* rank,
                        MKL_Complex8* work, float* rwork, MKL_INT* iwork,
                        MKL_INT* info );
void __stdcall clalsd( const char* uplo, int uplo_len, const MKL_INT* smlsiz, const MKL_INT* n,
                       const MKL_INT* nrhs, float* d, float* e, MKL_Complex8* b,
                       const MKL_INT* ldb, const float* rcond, MKL_INT* rank,
                       MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* info );
void __stdcall clalsd_( const char* uplo, int uplo_len, const MKL_INT* smlsiz, const MKL_INT* n,
                        const MKL_INT* nrhs, float* d, float* e, MKL_Complex8* b,
                        const MKL_INT* ldb, const float* rcond, MKL_INT* rank,
                        MKL_Complex8* work, float* rwork, MKL_INT* iwork,
                        MKL_INT* info );

float __stdcall CLANGB( const char* norm, int norm_len, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                        float* work );
float __stdcall CLANGB_( const char* norm, int norm_len, const MKL_INT* n, const MKL_INT* kl,
                         const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                         float* work );
float __stdcall clangb( const char* norm, int norm_len, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                        float* work );
float __stdcall clangb_( const char* norm, int norm_len, const MKL_INT* n, const MKL_INT* kl,
                         const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
                         float* work );

float __stdcall CLANGE( const char* norm, int norm_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_Complex8* a, const MKL_INT* lda, float* work );
float __stdcall CLANGE_( const char* norm, int norm_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_Complex8* a, const MKL_INT* lda, float* work );
float __stdcall clange( const char* norm, int norm_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_Complex8* a, const MKL_INT* lda, float* work );
float __stdcall clange_( const char* norm, int norm_len, const MKL_INT* m, const MKL_INT* n,
                         const MKL_Complex8* a, const MKL_INT* lda, float* work );

float __stdcall CLANGT( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* dl,
                        const MKL_Complex8* d, const MKL_Complex8* du );
float __stdcall CLANGT_( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* dl,
                         const MKL_Complex8* d, const MKL_Complex8* du );
float __stdcall clangt( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* dl,
                        const MKL_Complex8* d, const MKL_Complex8* du );
float __stdcall clangt_( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* dl,
                         const MKL_Complex8* d, const MKL_Complex8* du );

float __stdcall CLANHB( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
                        float* work );
float __stdcall CLANHB_( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
                         float* work );
float __stdcall clanhb( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
                        float* work );
float __stdcall clanhb_( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
                         float* work );

float __stdcall CLANHE( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_Complex8* a, const MKL_INT* lda, float* work );
float __stdcall CLANHE_( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex8* a, const MKL_INT* lda, float* work );
float __stdcall clanhe( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_Complex8* a, const MKL_INT* lda, float* work );
float __stdcall clanhe_( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex8* a, const MKL_INT* lda, float* work );

float __stdcall CLANHF( const char* norm, int norm_len, const char* transr, int transr_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, const MKL_Complex8* a, float* work );
float __stdcall CLANHF_( const char* norm, int norm_len, const char* transr, int transr_len, const char* uplo, int uplo_len,
                         const MKL_INT* n, const MKL_Complex8* a, float* work );
float __stdcall clanhf( const char* norm, int norm_len, const char* transr, int transr_len, const char* uplo, int uplo_len,
                        const MKL_INT* n, const MKL_Complex8* a, float* work );
float __stdcall clanhf_( const char* norm, int norm_len, const char* transr, int transr_len, const char* uplo, int uplo_len,
                         const MKL_INT* n, const MKL_Complex8* a, float* work );

float __stdcall CLANHP( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_Complex8* ap, float* work );
float __stdcall CLANHP_( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex8* ap, float* work );
float __stdcall clanhp( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_Complex8* ap, float* work );
float __stdcall clanhp_( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex8* ap, float* work );

float __stdcall CLANHS( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, float* work );
float __stdcall CLANHS_( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* a,
                         const MKL_INT* lda, float* work );
float __stdcall clanhs( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, float* work );
float __stdcall clanhs_( const char* norm, int norm_len, const MKL_INT* n, const MKL_Complex8* a,
                         const MKL_INT* lda, float* work );

float __stdcall CLANHT( const char* norm, int norm_len, const MKL_INT* n, const float* d,
                        const MKL_Complex8* e );
float __stdcall CLANHT_( const char* norm, int norm_len, const MKL_INT* n, const float* d,
                         const MKL_Complex8* e );
float __stdcall clanht( const char* norm, int norm_len, const MKL_INT* n, const float* d,
                        const MKL_Complex8* e );
float __stdcall clanht_( const char* norm, int norm_len, const MKL_INT* n, const float* d,
                         const MKL_Complex8* e );

float __stdcall CLANSB( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
                        float* work );
float __stdcall CLANSB_( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
                         float* work );
float __stdcall clansb( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
                        float* work );
float __stdcall clansb_( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
                         float* work );

float __stdcall CLANSP( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_Complex8* ap, float* work );
float __stdcall CLANSP_( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex8* ap, float* work );
float __stdcall clansp( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_Complex8* ap, float* work );
float __stdcall clansp_( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex8* ap, float* work );

float __stdcall CLANSY( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_Complex8* a, const MKL_INT* lda, float* work );
float __stdcall CLANSY_( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex8* a, const MKL_INT* lda, float* work );
float __stdcall clansy( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_Complex8* a, const MKL_INT* lda, float* work );
float __stdcall clansy_( const char* norm, int norm_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_Complex8* a, const MKL_INT* lda, float* work );

float __stdcall CLANTB( const char* norm, int norm_len, const char* uplo, int uplo_len, const char* diag, int diag_len,
                        const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* ab,
                        const MKL_INT* ldab, float* work );
float __stdcall CLANTB_( const char* norm, int norm_len, const char* uplo, int uplo_len, const char* diag, int diag_len,
                         const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* ab,
                         const MKL_INT* ldab, float* work );
float __stdcall clantb( const char* norm, int norm_len, const char* uplo, int uplo_len, const char* diag, int diag_len,
                        const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* ab,
                        const MKL_INT* ldab, float* work );
float __stdcall clantb_( const char* norm, int norm_len, const char* uplo, int uplo_len, const char* diag, int diag_len,
                         const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* ab,
                         const MKL_INT* ldab, float* work );

float __stdcall CLANTP( const char* norm, int norm_len, const char* uplo, int uplo_len, const char* diag, int diag_len,
                        const MKL_INT* n, const MKL_Complex8* ap, float* work );
float __stdcall CLANTP_( const char* norm, int norm_len, const char* uplo, int uplo_len, const char* diag, int diag_len,
                         const MKL_INT* n, const MKL_Complex8* ap, float* work );
float __stdcall clantp( const char* norm, int norm_len, const char* uplo, int uplo_len, const char* diag, int diag_len,
                        const MKL_INT* n, const MKL_Complex8* ap, float* work );
float __stdcall clantp_( const char* norm, int norm_len, const char* uplo, int uplo_len, const char* diag, int diag_len,
                         const MKL_INT* n, const MKL_Complex8* ap, float* work );

float __stdcall CLANTR( const char* norm, int norm_len, const char* uplo, int uplo_len, const char* diag, int diag_len,
                        const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, float* work );
float __stdcall CLANTR_( const char* norm, int norm_len, const char* uplo, int uplo_len, const char* diag, int diag_len,
                         const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                         const MKL_INT* lda, float* work );
float __stdcall clantr( const char* norm, int norm_len, const char* uplo, int uplo_len, const char* diag, int diag_len,
                        const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, float* work );
float __stdcall clantr_( const char* norm, int norm_len, const char* uplo, int uplo_len, const char* diag, int diag_len,
                         const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
                         const MKL_INT* lda, float* work );

void __stdcall CLAPLL( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
                       MKL_Complex8* y, const MKL_INT* incy, float* ssmin );
void __stdcall CLAPLL_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
                        MKL_Complex8* y, const MKL_INT* incy, float* ssmin );
void __stdcall clapll( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
                       MKL_Complex8* y, const MKL_INT* incy, float* ssmin );
void __stdcall clapll_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
                        MKL_Complex8* y, const MKL_INT* incy, float* ssmin );

void __stdcall CLAPMT( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall CLAPMT_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall clapmt( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                       MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );
void __stdcall clapmt_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
                        MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );

void __stdcall CLAQGB( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
                       const float* r, const float* c, const float* rowcnd,
                       const float* colcnd, const float* amax, char* equed , int equed_len);
void __stdcall CLAQGB_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
                        const float* r, const float* c, const float* rowcnd,
                        const float* colcnd, const float* amax, char* equed , int equed_len);
void __stdcall claqgb( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                       const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
                       const float* r, const float* c, const float* rowcnd,
                       const float* colcnd, const float* amax, char* equed , int equed_len);
void __stdcall claqgb_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
                        const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
                        const float* r, const float* c, const float* rowcnd,
                        const float* colcnd, const float* amax, char* equed , int equed_len);

void __stdcall CLAQGE( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, const float* r, const float* c,
                       const float* rowcnd, const float* colcnd, const float* amax,
                       char* equed , int equed_len);
void __stdcall CLAQGE_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, const float* r, const float* c,
                        const float* rowcnd, const float* colcnd, const float* amax,
                        char* equed , int equed_len);
void __stdcall claqge( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, const float* r, const float* c,
                       const float* rowcnd, const float* colcnd, const float* amax,
                       char* equed , int equed_len);
void __stdcall claqge_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, const float* r, const float* c,
                        const float* rowcnd, const float* colcnd, const float* amax,
                        char* equed , int equed_len);

void __stdcall CLAQHB( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       MKL_Complex8* ab, const MKL_INT* ldab, float* s,
                       const float* scond, const float* amax, char* equed , int equed_len);
void __stdcall CLAQHB_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        MKL_Complex8* ab, const MKL_INT* ldab, float* s,
                        const float* scond, const float* amax, char* equed , int equed_len);
void __stdcall claqhb( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       MKL_Complex8* ab, const MKL_INT* ldab, float* s,
                       const float* scond, const float* amax, char* equed , int equed_len);
void __stdcall claqhb_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        MKL_Complex8* ab, const MKL_INT* ldab, float* s,
                        const float* scond, const float* amax, char* equed , int equed_len);

void __stdcall CLAQHE( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, const float* s, const float* scond,
                       const float* amax, char* equed , int equed_len);
void __stdcall CLAQHE_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, const float* s, const float* scond,
                        const float* amax, char* equed , int equed_len);
void __stdcall claqhe( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, const float* s, const float* scond,
                       const float* amax, char* equed , int equed_len);
void __stdcall claqhe_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, const float* s, const float* scond,
                        const float* amax, char* equed , int equed_len);

void __stdcall CLAQHP( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       const float* s, const float* scond, const float* amax,
                       char* equed , int equed_len);
void __stdcall CLAQHP_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        const float* s, const float* scond, const float* amax,
                        char* equed , int equed_len);
void __stdcall claqhp( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       const float* s, const float* scond, const float* amax,
                       char* equed , int equed_len);
void __stdcall claqhp_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        const float* s, const float* scond, const float* amax,
                        char* equed , int equed_len);

void __stdcall CLAQP2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_INT* jpvt,
                       MKL_Complex8* tau, float* vn1, float* vn2, MKL_Complex8* work );
void __stdcall CLAQP2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_INT* jpvt,
                        MKL_Complex8* tau, float* vn1, float* vn2, MKL_Complex8* work );
void __stdcall claqp2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_INT* jpvt,
                       MKL_Complex8* tau, float* vn1, float* vn2, MKL_Complex8* work );
void __stdcall claqp2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_INT* jpvt,
                        MKL_Complex8* tau, float* vn1, float* vn2, MKL_Complex8* work );

void __stdcall CLAQPS( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
                       const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau, float* vn1,
                       float* vn2, MKL_Complex8* auxv, MKL_Complex8* f,
                       const MKL_INT* ldf );
void __stdcall CLAQPS_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
                        const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau, float* vn1,
                        float* vn2, MKL_Complex8* auxv, MKL_Complex8* f,
                        const MKL_INT* ldf );
void __stdcall claqps( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
                       const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau, float* vn1,
                       float* vn2, MKL_Complex8* auxv, MKL_Complex8* f,
                       const MKL_INT* ldf );
void __stdcall claqps_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
                        const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau, float* vn1,
                        float* vn2, MKL_Complex8* auxv, MKL_Complex8* f,
                        const MKL_INT* ldf );

void __stdcall CLAQR0( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                       const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz, MKL_INT* ihiz,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall CLAQR0_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                        const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz,
                        MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall claqr0( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                       const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz, MKL_INT* ihiz,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall claqr0_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                        const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz,
                        MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall CLAQR1( const MKL_INT* n, const MKL_Complex8* h, const MKL_INT* ldh,
                       const MKL_Complex8* s1, MKL_Complex8* s2, MKL_Complex8* v );
void __stdcall CLAQR1_( const MKL_INT* n, const MKL_Complex8* h, const MKL_INT* ldh,
                        const MKL_Complex8* s1, MKL_Complex8* s2, MKL_Complex8* v );
void __stdcall claqr1( const MKL_INT* n, const MKL_Complex8* h, const MKL_INT* ldh,
                       const MKL_Complex8* s1, MKL_Complex8* s2, MKL_Complex8* v );
void __stdcall claqr1_( const MKL_INT* n, const MKL_Complex8* h, const MKL_INT* ldh,
                        const MKL_Complex8* s1, MKL_Complex8* s2, MKL_Complex8* v );

void __stdcall CLAQR2( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                       const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
                       MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
                       const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
                       const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
                       const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
                       const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );
void __stdcall CLAQR2_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                        const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
                        MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
                        const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
                        const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
                        const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
                        const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );
void __stdcall claqr2( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                       const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
                       MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
                       const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
                       const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
                       const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
                       const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );
void __stdcall claqr2_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                        const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
                        MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
                        const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
                        const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
                        const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
                        const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );

void __stdcall CLAQR3( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                       const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
                       MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
                       const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
                       const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
                       const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
                       const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );
void __stdcall CLAQR3_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                        const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
                        MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
                        const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
                        const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
                        const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
                        const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );
void __stdcall claqr3( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                       const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
                       MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
                       const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
                       const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
                       const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
                       const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );
void __stdcall claqr3_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                        const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
                        MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
                        const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
                        const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
                        const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
                        const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );

void __stdcall CLAQR4( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                       const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz, MKL_INT* ihiz,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall CLAQR4_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                        const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz,
                        MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void __stdcall claqr4( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                       const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                       const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz, MKL_INT* ihiz,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall claqr4_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
                        const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
                        const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz,
                        MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void __stdcall CLAQR5( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22,
                       const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot,
                       const MKL_INT* nshfts, MKL_Complex8* s, MKL_Complex8* h,
                       const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* v,
                       const MKL_INT* ldv, MKL_Complex8* u, const MKL_INT* ldu,
                       const MKL_INT* nv, MKL_Complex8* wv, const MKL_INT* ldwv,
                       const MKL_INT* nh, MKL_Complex8* wh, const MKL_INT* ldwh );
void __stdcall CLAQR5_( const MKL_INT* wantt, const MKL_INT* wantz,
                        const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop,
                        const MKL_INT* kbot, const MKL_INT* nshfts, MKL_Complex8* s,
                        MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
                        const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* u,
                        const MKL_INT* ldu, const MKL_INT* nv, MKL_Complex8* wv,
                        const MKL_INT* ldwv, const MKL_INT* nh, MKL_Complex8* wh,
                        const MKL_INT* ldwh );
void __stdcall claqr5( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22,
                       const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot,
                       const MKL_INT* nshfts, MKL_Complex8* s, MKL_Complex8* h,
                       const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* v,
                       const MKL_INT* ldv, MKL_Complex8* u, const MKL_INT* ldu,
                       const MKL_INT* nv, MKL_Complex8* wv, const MKL_INT* ldwv,
                       const MKL_INT* nh, MKL_Complex8* wh, const MKL_INT* ldwh );
void __stdcall claqr5_( const MKL_INT* wantt, const MKL_INT* wantz,
                        const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop,
                        const MKL_INT* kbot, const MKL_INT* nshfts, MKL_Complex8* s,
                        MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
                        const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* u,
                        const MKL_INT* ldu, const MKL_INT* nv, MKL_Complex8* wv,
                        const MKL_INT* ldwv, const MKL_INT* nh, MKL_Complex8* wh,
                        const MKL_INT* ldwh );

void __stdcall CLAQSB( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       MKL_Complex8* ab, const MKL_INT* ldab, const float* s,
                       const float* scond, const float* amax, char* equed , int equed_len);
void __stdcall CLAQSB_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        MKL_Complex8* ab, const MKL_INT* ldab, const float* s,
                        const float* scond, const float* amax, char* equed , int equed_len);
void __stdcall claqsb( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       MKL_Complex8* ab, const MKL_INT* ldab, const float* s,
                       const float* scond, const float* amax, char* equed , int equed_len);
void __stdcall claqsb_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        MKL_Complex8* ab, const MKL_INT* ldab, const float* s,
                        const float* scond, const float* amax, char* equed , int equed_len);

void __stdcall CLAQSP( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       const float* s, const float* scond, const float* amax,
                       char* equed , int equed_len);
void __stdcall CLAQSP_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        const float* s, const float* scond, const float* amax,
                        char* equed , int equed_len);
void __stdcall claqsp( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       const float* s, const float* scond, const float* amax,
                       char* equed , int equed_len);
void __stdcall claqsp_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        const float* s, const float* scond, const float* amax,
                        char* equed , int equed_len);

void __stdcall CLAQSY( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, const float* s, const float* scond,
                       const float* amax, char* equed , int equed_len);
void __stdcall CLAQSY_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, const float* s, const float* scond,
                        const float* amax, char* equed , int equed_len);
void __stdcall claqsy( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, const float* s, const float* scond,
                       const float* amax, char* equed , int equed_len);
void __stdcall claqsy_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, const float* s, const float* scond,
                        const float* amax, char* equed , int equed_len);

void __stdcall CLAR1V( const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn,
                       const float* lambda, const float* d, const float* l,
                       const float* ld, const float* lld, const float* pivmin,
                       const float* gaptol, MKL_Complex8* z, const MKL_INT* wantnc,
                       MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r,
                       MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr,
                       float* work );
void __stdcall CLAR1V_( const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn,
                        const float* lambda, const float* d, const float* l,
                        const float* ld, const float* lld, const float* pivmin,
                        const float* gaptol, MKL_Complex8* z, const MKL_INT* wantnc,
                        MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r,
                        MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr,
                        float* work );
void __stdcall clar1v( const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn,
                       const float* lambda, const float* d, const float* l,
                       const float* ld, const float* lld, const float* pivmin,
                       const float* gaptol, MKL_Complex8* z, const MKL_INT* wantnc,
                       MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r,
                       MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr,
                       float* work );
void __stdcall clar1v_( const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn,
                        const float* lambda, const float* d, const float* l,
                        const float* ld, const float* lld, const float* pivmin,
                        const float* gaptol, MKL_Complex8* z, const MKL_INT* wantnc,
                        MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r,
                        MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr,
                        float* work );

void __stdcall CLAR2V( const MKL_INT* n, MKL_Complex8* x, MKL_Complex8* y,
                       MKL_Complex8* z, const MKL_INT* incx, const float* c,
                       const MKL_Complex8* s, const MKL_INT* incc );
void __stdcall CLAR2V_( const MKL_INT* n, MKL_Complex8* x, MKL_Complex8* y,
                        MKL_Complex8* z, const MKL_INT* incx, const float* c,
                        const MKL_Complex8* s, const MKL_INT* incc );
void __stdcall clar2v( const MKL_INT* n, MKL_Complex8* x, MKL_Complex8* y,
                       MKL_Complex8* z, const MKL_INT* incx, const float* c,
                       const MKL_Complex8* s, const MKL_INT* incc );
void __stdcall clar2v_( const MKL_INT* n, MKL_Complex8* x, MKL_Complex8* y,
                        MKL_Complex8* z, const MKL_INT* incx, const float* c,
                        const MKL_Complex8* s, const MKL_INT* incc );

void __stdcall CLARCM( const MKL_INT* m, const MKL_INT* n, const float* a,
                       const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* c, const MKL_INT* ldc, float* rwork );
void __stdcall CLARCM_( const MKL_INT* m, const MKL_INT* n, const float* a,
                        const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* c, const MKL_INT* ldc, float* rwork );
void __stdcall clarcm( const MKL_INT* m, const MKL_INT* n, const float* a,
                       const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* c, const MKL_INT* ldc, float* rwork );
void __stdcall clarcm_( const MKL_INT* m, const MKL_INT* n, const float* a,
                        const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* c, const MKL_INT* ldc, float* rwork );

void __stdcall CLARFB( const char* side, int side_len, const char* trans, int trans_len, const char* direct, int direct_len,
                       const char* storev, int storev_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
                       const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
                       const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* ldwork );
void __stdcall CLARFB_( const char* side, int side_len, const char* trans, int trans_len, const char* direct, int direct_len,
                        const char* storev, int storev_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
                        const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* ldwork );
void __stdcall clarfb( const char* side, int side_len, const char* trans, int trans_len, const char* direct, int direct_len,
                       const char* storev, int storev_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
                       const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
                       const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* ldwork );
void __stdcall clarfb_( const char* side, int side_len, const char* trans, int trans_len, const char* direct, int direct_len,
                        const char* storev, int storev_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
                        const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* ldwork );

void __stdcall CLARF( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                      const MKL_Complex8* v, const MKL_INT* incv,
                      const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
                      MKL_Complex8* work );
void __stdcall CLARF_( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_Complex8* v, const MKL_INT* incv,
                       const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
                       MKL_Complex8* work );
void __stdcall clarf( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                      const MKL_Complex8* v, const MKL_INT* incv,
                      const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
                      MKL_Complex8* work );
void __stdcall clarf_( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_Complex8* v, const MKL_INT* incv,
                       const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
                       MKL_Complex8* work );

void __stdcall CLARFG( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
                       const MKL_INT* incx, MKL_Complex8* tau );
void __stdcall CLARFG_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
                        const MKL_INT* incx, MKL_Complex8* tau );
void __stdcall clarfg( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
                       const MKL_INT* incx, MKL_Complex8* tau );
void __stdcall clarfg_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
                        const MKL_INT* incx, MKL_Complex8* tau );

void __stdcall CLARFGP( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
                        const MKL_INT* incx, MKL_Complex8* tau );
void __stdcall CLARFGP_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
                         const MKL_INT* incx, MKL_Complex8* tau );
void __stdcall clarfgp( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
                        const MKL_INT* incx, MKL_Complex8* tau );
void __stdcall clarfgp_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
                         const MKL_INT* incx, MKL_Complex8* tau );

void __stdcall CLARFP( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
                       const MKL_INT* incx, MKL_Complex8* tau );
void __stdcall CLARFP_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
                        const MKL_INT* incx, MKL_Complex8* tau );
void __stdcall clarfp( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
                       const MKL_INT* incx, MKL_Complex8* tau );
void __stdcall clarfp_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
                        const MKL_INT* incx, MKL_Complex8* tau );

void __stdcall CLARFT( const char* direct, int direct_len, const char* storev, int storev_len, const MKL_INT* n,
                       const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
                       const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );
void __stdcall CLARFT_( const char* direct, int direct_len, const char* storev, int storev_len, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );
void __stdcall clarft( const char* direct, int direct_len, const char* storev, int storev_len, const MKL_INT* n,
                       const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
                       const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );
void __stdcall clarft_( const char* direct, int direct_len, const char* storev, int storev_len, const MKL_INT* n,
                        const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );

void __stdcall CLARFX( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_Complex8* v, const MKL_Complex8* tau, MKL_Complex8* c,
                       const MKL_INT* ldc, MKL_Complex8* work );
void __stdcall CLARFX_( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_Complex8* v, const MKL_Complex8* tau, MKL_Complex8* c,
                        const MKL_INT* ldc, MKL_Complex8* work );
void __stdcall clarfx( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_Complex8* v, const MKL_Complex8* tau, MKL_Complex8* c,
                       const MKL_INT* ldc, MKL_Complex8* work );
void __stdcall clarfx_( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_Complex8* v, const MKL_Complex8* tau, MKL_Complex8* c,
                        const MKL_INT* ldc, MKL_Complex8* work );

void __stdcall CLARGV( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
                       MKL_Complex8* y, const MKL_INT* incy, float* c,
                       const MKL_INT* incc );
void __stdcall CLARGV_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
                        MKL_Complex8* y, const MKL_INT* incy, float* c,
                        const MKL_INT* incc );
void __stdcall clargv( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
                       MKL_Complex8* y, const MKL_INT* incy, float* c,
                       const MKL_INT* incc );
void __stdcall clargv_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
                        MKL_Complex8* y, const MKL_INT* incy, float* c,
                        const MKL_INT* incc );

void __stdcall CLARNV( const MKL_INT* idist, MKL_INT* iseed, const MKL_INT* n,
                       MKL_Complex8* x );
void __stdcall CLARNV_( const MKL_INT* idist, MKL_INT* iseed, const MKL_INT* n,
                        MKL_Complex8* x );
void __stdcall clarnv( const MKL_INT* idist, MKL_INT* iseed, const MKL_INT* n,
                       MKL_Complex8* x );
void __stdcall clarnv_( const MKL_INT* idist, MKL_INT* iseed, const MKL_INT* n,
                        MKL_Complex8* x );

void __stdcall CLARRV( const MKL_INT* n, const float* vl, const float* vu, float* d,
                       float* l, float* pivmin, const MKL_INT* isplit, const MKL_INT* m,
                       const MKL_INT* dol, const MKL_INT* dou, const float* minrgp,
                       const float* rtol1, const float* rtol2, float* w, float* werr,
                       float* wgap, const MKL_INT* iblock, const MKL_INT* indexw,
                       const float* gers, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall CLARRV_( const MKL_INT* n, const float* vl, const float* vu, float* d,
                        float* l, float* pivmin, const MKL_INT* isplit, const MKL_INT* m,
                        const MKL_INT* dol, const MKL_INT* dou, const float* minrgp,
                        const float* rtol1, const float* rtol2, float* w, float* werr,
                        float* wgap, const MKL_INT* iblock, const MKL_INT* indexw,
                        const float* gers, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall clarrv( const MKL_INT* n, const float* vl, const float* vu, float* d,
                       float* l, float* pivmin, const MKL_INT* isplit, const MKL_INT* m,
                       const MKL_INT* dol, const MKL_INT* dou, const float* minrgp,
                       const float* rtol1, const float* rtol2, float* w, float* werr,
                       float* wgap, const MKL_INT* iblock, const MKL_INT* indexw,
                       const float* gers, MKL_Complex8* z, const MKL_INT* ldz,
                       MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* info );
void __stdcall clarrv_( const MKL_INT* n, const float* vl, const float* vu, float* d,
                        float* l, float* pivmin, const MKL_INT* isplit, const MKL_INT* m,
                        const MKL_INT* dol, const MKL_INT* dou, const float* minrgp,
                        const float* rtol1, const float* rtol2, float* w, float* werr,
                        float* wgap, const MKL_INT* iblock, const MKL_INT* indexw,
                        const float* gers, MKL_Complex8* z, const MKL_INT* ldz,
                        MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* info );

void __stdcall CLARTG( const MKL_Complex8* f, const MKL_Complex8* g, float* cs,
                       MKL_Complex8* sn, MKL_Complex8* r );
void __stdcall CLARTG_( const MKL_Complex8* f, const MKL_Complex8* g, float* cs,
                        MKL_Complex8* sn, MKL_Complex8* r );
void __stdcall clartg( const MKL_Complex8* f, const MKL_Complex8* g, float* cs,
                       MKL_Complex8* sn, MKL_Complex8* r );
void __stdcall clartg_( const MKL_Complex8* f, const MKL_Complex8* g, float* cs,
                        MKL_Complex8* sn, MKL_Complex8* r );

void __stdcall CLARTV( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
                       MKL_Complex8* y, const MKL_INT* incy, const float* c,
                       const MKL_Complex8* s, const MKL_INT* incc );
void __stdcall CLARTV_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
                        MKL_Complex8* y, const MKL_INT* incy, const float* c,
                        const MKL_Complex8* s, const MKL_INT* incc );
void __stdcall clartv( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
                       MKL_Complex8* y, const MKL_INT* incy, const float* c,
                       const MKL_Complex8* s, const MKL_INT* incc );
void __stdcall clartv_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
                        MKL_Complex8* y, const MKL_INT* incy, const float* c,
                        const MKL_Complex8* s, const MKL_INT* incc );

void __stdcall CLARZB( const char* side, int side_len, const char* trans, int trans_len, const char* direct, int direct_len,
                       const char* storev, int storev_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v,
                       const MKL_INT* ldv, const MKL_Complex8* t, const MKL_INT* ldt,
                       MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work,
                       const MKL_INT* ldwork );
void __stdcall CLARZB_( const char* side, int side_len, const char* trans, int trans_len, const char* direct, int direct_len,
                        const char* storev, int storev_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v,
                        const MKL_INT* ldv, const MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work,
                        const MKL_INT* ldwork );
void __stdcall clarzb( const char* side, int side_len, const char* trans, int trans_len, const char* direct, int direct_len,
                       const char* storev, int storev_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v,
                       const MKL_INT* ldv, const MKL_Complex8* t, const MKL_INT* ldt,
                       MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work,
                       const MKL_INT* ldwork );
void __stdcall clarzb_( const char* side, int side_len, const char* trans, int trans_len, const char* direct, int direct_len,
                        const char* storev, int storev_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v,
                        const MKL_INT* ldv, const MKL_Complex8* t, const MKL_INT* ldt,
                        MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work,
                        const MKL_INT* ldwork );

void __stdcall CLARZ( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                      const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* incv,
                      const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
                      MKL_Complex8* work );
void __stdcall CLARZ_( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* incv,
                       const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
                       MKL_Complex8* work );
void __stdcall clarz( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                      const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* incv,
                      const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
                      MKL_Complex8* work );
void __stdcall clarz_( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* incv,
                       const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
                       MKL_Complex8* work );

void __stdcall CLARZT( const char* direct, int direct_len, const char* storev, int storev_len, const MKL_INT* n,
                       const MKL_INT* k, MKL_Complex8* v, const MKL_INT* ldv,
                       const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );
void __stdcall CLARZT_( const char* direct, int direct_len, const char* storev, int storev_len, const MKL_INT* n,
                        const MKL_INT* k, MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );
void __stdcall clarzt( const char* direct, int direct_len, const char* storev, int storev_len, const MKL_INT* n,
                       const MKL_INT* k, MKL_Complex8* v, const MKL_INT* ldv,
                       const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );
void __stdcall clarzt_( const char* direct, int direct_len, const char* storev, int storev_len, const MKL_INT* n,
                        const MKL_INT* k, MKL_Complex8* v, const MKL_INT* ldv,
                        const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );

void __stdcall CLASCL( const char* type, int type_len, const MKL_INT* kl, const MKL_INT* ku,
                       const float* cfrom, const float* cto, const MKL_INT* m,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_INT* info );
void __stdcall CLASCL_( const char* type, int type_len, const MKL_INT* kl, const MKL_INT* ku,
                        const float* cfrom, const float* cto, const MKL_INT* m,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_INT* info );
void __stdcall clascl( const char* type, int type_len, const MKL_INT* kl, const MKL_INT* ku,
                       const float* cfrom, const float* cto, const MKL_INT* m,
                       const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_INT* info );
void __stdcall clascl_( const char* type, int type_len, const MKL_INT* kl, const MKL_INT* ku,
                        const float* cfrom, const float* cto, const MKL_INT* m,
                        const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_INT* info );

void __stdcall CLASET( const char* uplo, int uplo_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_Complex8* alpha, const MKL_Complex8* beta,
                       MKL_Complex8* a, const MKL_INT* lda );
void __stdcall CLASET_( const char* uplo, int uplo_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_Complex8* alpha, const MKL_Complex8* beta,
                        MKL_Complex8* a, const MKL_INT* lda );
void __stdcall claset( const char* uplo, int uplo_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_Complex8* alpha, const MKL_Complex8* beta,
                       MKL_Complex8* a, const MKL_INT* lda );
void __stdcall claset_( const char* uplo, int uplo_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_Complex8* alpha, const MKL_Complex8* beta,
                        MKL_Complex8* a, const MKL_INT* lda );

void __stdcall CLASR( const char* side, int side_len, const char* pivot, int pivot_len, const char* direct, int direct_len,
                      const MKL_INT* m, const MKL_INT* n, const float* c, const float* s,
                      MKL_Complex8* a, const MKL_INT* lda );
void __stdcall CLASR_( const char* side, int side_len, const char* pivot, int pivot_len, const char* direct, int direct_len,
                       const MKL_INT* m, const MKL_INT* n, const float* c,
                       const float* s, MKL_Complex8* a, const MKL_INT* lda );
void __stdcall clasr( const char* side, int side_len, const char* pivot, int pivot_len, const char* direct, int direct_len,
                      const MKL_INT* m, const MKL_INT* n, const float* c, const float* s,
                      MKL_Complex8* a, const MKL_INT* lda );
void __stdcall clasr_( const char* side, int side_len, const char* pivot, int pivot_len, const char* direct, int direct_len,
                       const MKL_INT* m, const MKL_INT* n, const float* c,
                       const float* s, MKL_Complex8* a, const MKL_INT* lda );

void __stdcall CLASSQ( const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* incx,
                       float* scale, float* sumsq );
void __stdcall CLASSQ_( const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* incx,
                        float* scale, float* sumsq );
void __stdcall classq( const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* incx,
                       float* scale, float* sumsq );
void __stdcall classq_( const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* incx,
                        float* scale, float* sumsq );

void __stdcall CLASWP( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv,
                       const MKL_INT* incx );
void __stdcall CLASWP_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv,
                        const MKL_INT* incx );
void __stdcall claswp( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                       const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv,
                       const MKL_INT* incx );
void __stdcall claswp_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv,
                        const MKL_INT* incx );

void __stdcall CLASYF( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                       MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                       MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall CLASYF_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                        MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                        MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall clasyf( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                       MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                       MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void __stdcall clasyf_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                        MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                        MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );

void __stdcall CLATBS( const char* uplo, int uplo_len, const char* trans, int trans_len, const char* diag, int diag_len,
                       const char* normin, int normin_len, const MKL_INT* n, const MKL_INT* kd,
                       const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* x,
                       float* scale, float* cnorm, MKL_INT* info );
void __stdcall CLATBS_( const char* uplo, int uplo_len, const char* trans, int trans_len, const char* diag, int diag_len,
                        const char* normin, int normin_len, const MKL_INT* n, const MKL_INT* kd,
                        const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* x,
                        float* scale, float* cnorm, MKL_INT* info );
void __stdcall clatbs( const char* uplo, int uplo_len, const char* trans, int trans_len, const char* diag, int diag_len,
                       const char* normin, int normin_len, const MKL_INT* n, const MKL_INT* kd,
                       const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* x,
                       float* scale, float* cnorm, MKL_INT* info );
void __stdcall clatbs_( const char* uplo, int uplo_len, const char* trans, int trans_len, const char* diag, int diag_len,
                        const char* normin, int normin_len, const MKL_INT* n, const MKL_INT* kd,
                        const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* x,
                        float* scale, float* cnorm, MKL_INT* info );

void __stdcall CLATDF( const MKL_INT* ijob, const MKL_INT* n, const MKL_Complex8* z,
                       const MKL_INT* ldz, MKL_Complex8* rhs, float* rdsum,
                       float* rdscal, const MKL_INT* ipiv, const MKL_INT* jpiv );
void __stdcall CLATDF_( const MKL_INT* ijob, const MKL_INT* n, const MKL_Complex8* z,
                        const MKL_INT* ldz, MKL_Complex8* rhs, float* rdsum,
                        float* rdscal, const MKL_INT* ipiv, const MKL_INT* jpiv );
void __stdcall clatdf( const MKL_INT* ijob, const MKL_INT* n, const MKL_Complex8* z,
                       const MKL_INT* ldz, MKL_Complex8* rhs, float* rdsum,
                       float* rdscal, const MKL_INT* ipiv, const MKL_INT* jpiv );
void __stdcall clatdf_( const MKL_INT* ijob, const MKL_INT* n, const MKL_Complex8* z,
                        const MKL_INT* ldz, MKL_Complex8* rhs, float* rdsum,
                        float* rdscal, const MKL_INT* ipiv, const MKL_INT* jpiv );

void __stdcall CLATPS( const char* uplo, int uplo_len, const char* trans, int trans_len, const char* diag, int diag_len,
                       const char* normin, int normin_len, const MKL_INT* n, const MKL_Complex8* ap,
                       MKL_Complex8* x, float* scale, float* cnorm, MKL_INT* info );
void __stdcall CLATPS_( const char* uplo, int uplo_len, const char* trans, int trans_len, const char* diag, int diag_len,
                        const char* normin, int normin_len, const MKL_INT* n, const MKL_Complex8* ap,
                        MKL_Complex8* x, float* scale, float* cnorm, MKL_INT* info );
void __stdcall clatps( const char* uplo, int uplo_len, const char* trans, int trans_len, const char* diag, int diag_len,
                       const char* normin, int normin_len, const MKL_INT* n, const MKL_Complex8* ap,
                       MKL_Complex8* x, float* scale, float* cnorm, MKL_INT* info );
void __stdcall clatps_( const char* uplo, int uplo_len, const char* trans, int trans_len, const char* diag, int diag_len,
                        const char* normin, int normin_len, const MKL_INT* n, const MKL_Complex8* ap,
                        MKL_Complex8* x, float* scale, float* cnorm, MKL_INT* info );

void __stdcall CLATRD( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                       MKL_Complex8* a, const MKL_INT* lda, float* e, MKL_Complex8* tau,
                       MKL_Complex8* w, const MKL_INT* ldw );
void __stdcall CLATRD_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                        MKL_Complex8* a, const MKL_INT* lda, float* e, MKL_Complex8* tau,
                        MKL_Complex8* w, const MKL_INT* ldw );
void __stdcall clatrd( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                       MKL_Complex8* a, const MKL_INT* lda, float* e, MKL_Complex8* tau,
                       MKL_Complex8* w, const MKL_INT* ldw );
void __stdcall clatrd_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nb,
                        MKL_Complex8* a, const MKL_INT* lda, float* e, MKL_Complex8* tau,
                        MKL_Complex8* w, const MKL_INT* ldw );

void __stdcall CLATRS( const char* uplo, int uplo_len, const char* trans, int trans_len, const char* diag, int diag_len,
                       const char* normin, int normin_len, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* x, float* scale, float* cnorm,
                       MKL_INT* info );
void __stdcall CLATRS_( const char* uplo, int uplo_len, const char* trans, int trans_len, const char* diag, int diag_len,
                        const char* normin, int normin_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* x, float* scale, float* cnorm,
                        MKL_INT* info );
void __stdcall clatrs( const char* uplo, int uplo_len, const char* trans, int trans_len, const char* diag, int diag_len,
                       const char* normin, int normin_len, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* x, float* scale, float* cnorm,
                       MKL_INT* info );
void __stdcall clatrs_( const char* uplo, int uplo_len, const char* trans, int trans_len, const char* diag, int diag_len,
                        const char* normin, int normin_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* x, float* scale, float* cnorm,
                        MKL_INT* info );

void __stdcall CLATRZ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                       MKL_Complex8* work );
void __stdcall CLATRZ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                        MKL_Complex8* work );
void __stdcall clatrz( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                       MKL_Complex8* work );
void __stdcall clatrz_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
                        MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
                        MKL_Complex8* work );

void __stdcall CLATZM( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_Complex8* v, const MKL_INT* incv,
                       const MKL_Complex8* tau, MKL_Complex8* c1, MKL_Complex8* c2,
                       const MKL_INT* ldc, MKL_Complex8* work );
void __stdcall CLATZM_( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_Complex8* v, const MKL_INT* incv,
                        const MKL_Complex8* tau, MKL_Complex8* c1, MKL_Complex8* c2,
                        const MKL_INT* ldc, MKL_Complex8* work );
void __stdcall clatzm( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                       const MKL_Complex8* v, const MKL_INT* incv,
                       const MKL_Complex8* tau, MKL_Complex8* c1, MKL_Complex8* c2,
                       const MKL_INT* ldc, MKL_Complex8* work );
void __stdcall clatzm_( const char* side, int side_len, const MKL_INT* m, const MKL_INT* n,
                        const MKL_Complex8* v, const MKL_INT* incv,
                        const MKL_Complex8* tau, MKL_Complex8* c1, MKL_Complex8* c2,
                        const MKL_INT* ldc, MKL_Complex8* work );

void __stdcall CLAUU2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* info );
void __stdcall CLAUU2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* info );
void __stdcall clauu2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* info );
void __stdcall clauu2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* info );

void __stdcall CLAUUM( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* info );
void __stdcall CLAUUM_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* info );
void __stdcall clauum( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* info );
void __stdcall clauum_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* info );

void __stdcall CPBCON( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       const MKL_Complex8* ab, const MKL_INT* ldab, const float* anorm,
                       float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CPBCON_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        const MKL_Complex8* ab, const MKL_INT* ldab, const float* anorm,
                        float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cpbcon( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       const MKL_Complex8* ab, const MKL_INT* ldab, const float* anorm,
                       float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cpbcon_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        const MKL_Complex8* ab, const MKL_INT* ldab, const float* anorm,
                        float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CPBEQU( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       const MKL_Complex8* ab, const MKL_INT* ldab, float* s,
                       float* scond, float* amax, MKL_INT* info );
void __stdcall CPBEQU_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        const MKL_Complex8* ab, const MKL_INT* ldab, float* s,
                        float* scond, float* amax, MKL_INT* info );
void __stdcall cpbequ( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       const MKL_Complex8* ab, const MKL_INT* ldab, float* s,
                       float* scond, float* amax, MKL_INT* info );
void __stdcall cpbequ_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        const MKL_Complex8* ab, const MKL_INT* ldab, float* s,
                        float* scond, float* amax, MKL_INT* info );

void __stdcall CPBRFS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
                       const MKL_Complex8* afb, const MKL_INT* ldafb,
                       const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );
void __stdcall CPBRFS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
                        const MKL_Complex8* afb, const MKL_INT* ldafb,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );
void __stdcall cpbrfs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
                       const MKL_Complex8* afb, const MKL_INT* ldafb,
                       const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );
void __stdcall cpbrfs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
                        const MKL_Complex8* afb, const MKL_INT* ldafb,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );

void __stdcall CPBSTF( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void __stdcall CPBSTF_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void __stdcall cpbstf( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void __stdcall cpbstf_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );

void __stdcall CPBSV( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                      const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall CPBSV_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall cpbsv( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                      const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall cpbsv_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void __stdcall CPBSVX( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* kd, const MKL_INT* nrhs, MKL_Complex8* ab,
                       const MKL_INT* ldab, MKL_Complex8* afb, const MKL_INT* ldafb,
                       char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CPBSVX_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* kd, const MKL_INT* nrhs, MKL_Complex8* ab,
                        const MKL_INT* ldab, MKL_Complex8* afb, const MKL_INT* ldafb,
                        char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                        float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cpbsvx( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* kd, const MKL_INT* nrhs, MKL_Complex8* ab,
                       const MKL_INT* ldab, MKL_Complex8* afb, const MKL_INT* ldafb,
                       char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cpbsvx_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* kd, const MKL_INT* nrhs, MKL_Complex8* ab,
                        const MKL_INT* ldab, MKL_Complex8* afb, const MKL_INT* ldafb,
                        char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                        float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CPBTF2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void __stdcall CPBTF2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void __stdcall cpbtf2( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void __stdcall cpbtf2_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );

void __stdcall CPBTRF( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void __stdcall CPBTRF_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void __stdcall cpbtrf( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void __stdcall cpbtrf_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );

void __stdcall CPBTRS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall CPBTRS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall cpbtrs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                       const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall cpbtrs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* kd,
                        const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void __stdcall CPFTRF( const char* transr, int transr_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* a, MKL_INT* info );
void __stdcall CPFTRF_( const char* transr, int transr_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* a, MKL_INT* info );
void __stdcall cpftrf( const char* transr, int transr_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* a, MKL_INT* info );
void __stdcall cpftrf_( const char* transr, int transr_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* a, MKL_INT* info );

void __stdcall CPFTRI( const char* transr, int transr_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* a, MKL_INT* info );
void __stdcall CPFTRI_( const char* transr, int transr_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* a, MKL_INT* info );
void __stdcall cpftri( const char* transr, int transr_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       MKL_Complex8* a, MKL_INT* info );
void __stdcall cpftri_( const char* transr, int transr_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        MKL_Complex8* a, MKL_INT* info );

void __stdcall CPFTRS( const char* transr, int transr_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, const MKL_Complex8* a, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall CPFTRS_( const char* transr, int transr_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );
void __stdcall cpftrs( const char* transr, int transr_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, const MKL_Complex8* a, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall cpftrs_( const char* transr, int transr_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );

void __stdcall CPOCON( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, const float* anorm, float* rcond,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CPOCON_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, const float* anorm, float* rcond,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cpocon( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, const float* anorm, float* rcond,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cpocon_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, const float* anorm, float* rcond,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CPOEQUB( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                        float* s, float* scond, float* amax, MKL_INT* info );
void __stdcall CPOEQUB_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                         float* s, float* scond, float* amax, MKL_INT* info );
void __stdcall cpoequb( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                        float* s, float* scond, float* amax, MKL_INT* info );
void __stdcall cpoequb_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                         float* s, float* scond, float* amax, MKL_INT* info );

void __stdcall CPOEQU( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                       float* s, float* scond, float* amax, MKL_INT* info );
void __stdcall CPOEQU_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                        float* s, float* scond, float* amax, MKL_INT* info );
void __stdcall cpoequ( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                       float* s, float* scond, float* amax, MKL_INT* info );
void __stdcall cpoequ_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                        float* s, float* scond, float* amax, MKL_INT* info );

void __stdcall CPORFS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
                       const MKL_INT* ldaf, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CPORFS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );
void __stdcall cporfs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
                       const MKL_INT* ldaf, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cporfs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );

void __stdcall CPORFSX( const char* uplo, int uplo_len, const char* equed, int equed_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const float* s,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CPORFSX_( const char* uplo, int uplo_len, const char* equed, int equed_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* af, const MKL_INT* ldaf, const float* s,
                         const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                         const MKL_INT* ldx, float* rcond, float* berr,
                         const MKL_INT* n_err_bnds, float* err_bnds_norm,
                         float* err_bnds_comp, const MKL_INT* nparams, float* params,
                         MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cporfsx( const char* uplo, int uplo_len, const char* equed, int equed_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const float* s,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cporfsx_( const char* uplo, int uplo_len, const char* equed, int equed_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* af, const MKL_INT* ldaf, const float* s,
                         const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                         const MKL_INT* ldx, float* rcond, float* berr,
                         const MKL_INT* n_err_bnds, float* err_bnds_norm,
                         float* err_bnds_comp, const MKL_INT* nparams, float* params,
                         MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CPOSV( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_INT* info );
void __stdcall CPOSV_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall cposv( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_INT* info );
void __stdcall cposv_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );

void __stdcall CPOSVX( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* af, const MKL_INT* ldaf, char* equed, int equed_len, float* s,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CPOSVX_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, char* equed, int equed_len, float* s,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cposvx( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* af, const MKL_INT* ldaf, char* equed, int equed_len, float* s,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cposvx_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, char* equed, int equed_len, float* s,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CPOSVXX( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, char* equed, int equed_len, float* s,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CPOSVXX_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                         MKL_Complex8* af, const MKL_INT* ldaf, char* equed, int equed_len, float* s,
                         MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                         const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
                         const MKL_INT* n_err_bnds, float* err_bnds_norm,
                         float* err_bnds_comp, const MKL_INT* nparams, float* params,
                         MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cposvxx( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, char* equed, int equed_len, float* s,
                        MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cposvxx_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                         MKL_Complex8* af, const MKL_INT* ldaf, char* equed, int equed_len, float* s,
                         MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                         const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
                         const MKL_INT* n_err_bnds, float* err_bnds_norm,
                         float* err_bnds_comp, const MKL_INT* nparams, float* params,
                         MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CPOTF2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* info );
void __stdcall CPOTF2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* info );
void __stdcall cpotf2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* info );
void __stdcall cpotf2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* info );

void __stdcall CPOTRF( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* info );
void __stdcall CPOTRF_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* info );
void __stdcall cpotrf( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* info );
void __stdcall cpotrf_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* info );

void __stdcall CPOTRI( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* info );
void __stdcall CPOTRI_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* info );
void __stdcall cpotri( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* info );
void __stdcall cpotri_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* info );

void __stdcall CPOTRS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall CPOTRS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );
void __stdcall cpotrs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall cpotrs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );

void __stdcall CPPCON( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                       const float* anorm, float* rcond, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );
void __stdcall CPPCON_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                        const float* anorm, float* rcond, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );
void __stdcall cppcon( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                       const float* anorm, float* rcond, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );
void __stdcall cppcon_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                        const float* anorm, float* rcond, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );

void __stdcall CPPEQU( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                       float* s, float* scond, float* amax, MKL_INT* info );
void __stdcall CPPEQU_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                        float* s, float* scond, float* amax, MKL_INT* info );
void __stdcall cppequ( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                       float* s, float* scond, float* amax, MKL_INT* info );
void __stdcall cppequ_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                        float* s, float* scond, float* amax, MKL_INT* info );

void __stdcall CPPRFS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* ap, const MKL_Complex8* afp,
                       const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );
void __stdcall CPPRFS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* ap, const MKL_Complex8* afp,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );
void __stdcall cpprfs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* ap, const MKL_Complex8* afp,
                       const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                       float* rwork, MKL_INT* info );
void __stdcall cpprfs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* ap, const MKL_Complex8* afp,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );

void __stdcall CPPSV( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
                      MKL_INT* info );
void __stdcall CPPSV_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* info );
void __stdcall cppsv( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
                      MKL_INT* info );
void __stdcall cppsv_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* info );

void __stdcall CPPSVX( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, MKL_Complex8* ap, MKL_Complex8* afp,
                       char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CPPSVX_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* ap, MKL_Complex8* afp,
                        char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                        float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cppsvx( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, MKL_Complex8* ap, MKL_Complex8* afp,
                       char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cppsvx_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* ap, MKL_Complex8* afp,
                        char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                        float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CPPTRF( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       MKL_INT* info );
void __stdcall CPPTRF_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        MKL_INT* info );
void __stdcall cpptrf( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       MKL_INT* info );
void __stdcall cpptrf_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        MKL_INT* info );

void __stdcall CPPTRI( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       MKL_INT* info );
void __stdcall CPPTRI_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        MKL_INT* info );
void __stdcall cpptri( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       MKL_INT* info );
void __stdcall cpptri_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        MKL_INT* info );

void __stdcall CPPTRS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* info );
void __stdcall CPPTRS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_INT* info );
void __stdcall cpptrs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_INT* info );
void __stdcall cpptrs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_INT* info );

void __stdcall CPSTF2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank, const float* tol,
                       float* work, MKL_INT* info );
void __stdcall CPSTF2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank,
                        const float* tol, float* work, MKL_INT* info );
void __stdcall cpstf2( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank, const float* tol,
                       float* work, MKL_INT* info );
void __stdcall cpstf2_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank,
                        const float* tol, float* work, MKL_INT* info );

void __stdcall CPSTRF( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank, const float* tol,
                       float* work, MKL_INT* info );
void __stdcall CPSTRF_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank,
                        const float* tol, float* work, MKL_INT* info );
void __stdcall cpstrf( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank, const float* tol,
                       float* work, MKL_INT* info );
void __stdcall cpstrf_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank,
                        const float* tol, float* work, MKL_INT* info );

void __stdcall CPTCON( const MKL_INT* n, const float* d, const MKL_Complex8* e,
                       const float* anorm, float* rcond, float* rwork, MKL_INT* info );
void __stdcall CPTCON_( const MKL_INT* n, const float* d, const MKL_Complex8* e,
                        const float* anorm, float* rcond, float* rwork, MKL_INT* info );
void __stdcall cptcon( const MKL_INT* n, const float* d, const MKL_Complex8* e,
                       const float* anorm, float* rcond, float* rwork, MKL_INT* info );
void __stdcall cptcon_( const MKL_INT* n, const float* d, const MKL_Complex8* e,
                        const float* anorm, float* rcond, float* rwork, MKL_INT* info );

void __stdcall CPTEQR( const char* compz, int compz_len, const MKL_INT* n, float* d, float* e,
                       MKL_Complex8* z, const MKL_INT* ldz, float* work, MKL_INT* info );
void __stdcall CPTEQR_( const char* compz, int compz_len, const MKL_INT* n, float* d, float* e,
                        MKL_Complex8* z, const MKL_INT* ldz, float* work,
                        MKL_INT* info );
void __stdcall cpteqr( const char* compz, int compz_len, const MKL_INT* n, float* d, float* e,
                       MKL_Complex8* z, const MKL_INT* ldz, float* work, MKL_INT* info );
void __stdcall cpteqr_( const char* compz, int compz_len, const MKL_INT* n, float* d, float* e,
                        MKL_Complex8* z, const MKL_INT* ldz, float* work,
                        MKL_INT* info );

void __stdcall CPTRFS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* d, const MKL_Complex8* e, const float* df,
                       const MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CPTRFS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const float* d, const MKL_Complex8* e, const float* df,
                        const MKL_Complex8* ef, const MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                        float* ferr, float* berr, MKL_Complex8* work, float* rwork,
                        MKL_INT* info );
void __stdcall cptrfs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* d, const MKL_Complex8* e, const float* df,
                       const MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cptrfs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const float* d, const MKL_Complex8* e, const float* df,
                        const MKL_Complex8* ef, const MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                        float* ferr, float* berr, MKL_Complex8* work, float* rwork,
                        MKL_INT* info );

void __stdcall CPTSV( const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall CPTSV_( const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall cptsv( const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void __stdcall cptsv_( const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void __stdcall CPTSVX( const char* fact, int fact_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* d, const MKL_Complex8* e, float* df,
                       MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CPTSVX_( const char* fact, int fact_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const float* d, const MKL_Complex8* e, float* df,
                        MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                        float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cptsvx( const char* fact, int fact_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* d, const MKL_Complex8* e, float* df,
                       MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cptsvx_( const char* fact, int fact_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const float* d, const MKL_Complex8* e, float* df,
                        MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                        float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CPTTRF( const MKL_INT* n, float* d, MKL_Complex8* e, MKL_INT* info );
void __stdcall CPTTRF_( const MKL_INT* n, float* d, MKL_Complex8* e, MKL_INT* info );
void __stdcall cpttrf( const MKL_INT* n, float* d, MKL_Complex8* e, MKL_INT* info );
void __stdcall cpttrf_( const MKL_INT* n, float* d, MKL_Complex8* e, MKL_INT* info );

void __stdcall CPTTRS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* d, const MKL_Complex8* e, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall CPTTRS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const float* d, const MKL_Complex8* e, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );
void __stdcall cpttrs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* d, const MKL_Complex8* e, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall cpttrs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const float* d, const MKL_Complex8* e, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );

void __stdcall CPTTS2( const MKL_INT* iuplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* d, const MKL_Complex8* e, MKL_Complex8* b,
                       const MKL_INT* ldb );
void __stdcall CPTTS2_( const MKL_INT* iuplo, const MKL_INT* n, const MKL_INT* nrhs,
                        const float* d, const MKL_Complex8* e, MKL_Complex8* b,
                        const MKL_INT* ldb );
void __stdcall cptts2( const MKL_INT* iuplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* d, const MKL_Complex8* e, MKL_Complex8* b,
                       const MKL_INT* ldb );
void __stdcall cptts2_( const MKL_INT* iuplo, const MKL_INT* n, const MKL_INT* nrhs,
                        const float* d, const MKL_Complex8* e, MKL_Complex8* b,
                        const MKL_INT* ldb );

void __stdcall CROT( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
                     MKL_Complex8* cy, const MKL_INT* incy, const float* c,
                     const MKL_Complex8* s );
void __stdcall CROT_( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
                      MKL_Complex8* cy, const MKL_INT* incy, const float* c,
                      const MKL_Complex8* s );
void __stdcall crot( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
                     MKL_Complex8* cy, const MKL_INT* incy, const float* c,
                     const MKL_Complex8* s );
void __stdcall crot_( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
                      MKL_Complex8* cy, const MKL_INT* incy, const float* c,
                      const MKL_Complex8* s );

void __stdcall CSPCON( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                       const MKL_INT* ipiv, const float* anorm, float* rcond,
                       MKL_Complex8* work, MKL_INT* info );
void __stdcall CSPCON_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                        const MKL_INT* ipiv, const float* anorm, float* rcond,
                        MKL_Complex8* work, MKL_INT* info );
void __stdcall cspcon( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                       const MKL_INT* ipiv, const float* anorm, float* rcond,
                       MKL_Complex8* work, MKL_INT* info );
void __stdcall cspcon_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* ap,
                        const MKL_INT* ipiv, const float* anorm, float* rcond,
                        MKL_Complex8* work, MKL_INT* info );

void __stdcall CSPMV( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                      const MKL_Complex8* ap, const MKL_Complex8* x, const MKL_INT* incx,
                      const MKL_Complex8* beta, MKL_Complex8* y, const MKL_INT* incy );
void __stdcall CSPMV_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                       const MKL_Complex8* ap, const MKL_Complex8* x,
                       const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
                       const MKL_INT* incy );
void __stdcall cspmv( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                      const MKL_Complex8* ap, const MKL_Complex8* x, const MKL_INT* incx,
                      const MKL_Complex8* beta, MKL_Complex8* y, const MKL_INT* incy );
void __stdcall cspmv_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                       const MKL_Complex8* ap, const MKL_Complex8* x,
                       const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
                       const MKL_INT* incy );

void __stdcall CSPR( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                     const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* ap );
void __stdcall CSPR_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                      const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* ap );
void __stdcall cspr( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                     const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* ap );
void __stdcall cspr_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                      const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* ap );

void __stdcall CSPRFS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* ap, const MKL_Complex8* afp,
                       const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CSPRFS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* ap, const MKL_Complex8* afp,
                        const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall csprfs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* ap, const MKL_Complex8* afp,
                       const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
                       MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall csprfs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* ap, const MKL_Complex8* afp,
                        const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CSPSV( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_INT* info );
void __stdcall CSPSV_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall cspsv( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
                      const MKL_INT* ldb, MKL_INT* info );
void __stdcall cspsv_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );

void __stdcall CSPSVX( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
                       MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CSPSVX_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
                        MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                        float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cspsvx( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
                       MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                       MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                       float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall cspsvx_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
                        MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
                        float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );

void __stdcall CSPTRF( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       MKL_INT* ipiv, MKL_INT* info );
void __stdcall CSPTRF_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        MKL_INT* ipiv, MKL_INT* info );
void __stdcall csptrf( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       MKL_INT* ipiv, MKL_INT* info );
void __stdcall csptrf_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        MKL_INT* ipiv, MKL_INT* info );

void __stdcall CSPTRI( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );
void __stdcall CSPTRI_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );
void __stdcall csptri( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                       const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );
void __stdcall csptri_( const char* uplo, int uplo_len, const MKL_INT* n, MKL_Complex8* ap,
                        const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );

void __stdcall CSPTRS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall CSPTRS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );
void __stdcall csptrs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_INT* info );
void __stdcall csptrs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );

void __stdcall CSRSCL( const MKL_INT* n, const float* sa, MKL_Complex8* sx,
                       const MKL_INT* incx );
void __stdcall CSRSCL_( const MKL_INT* n, const float* sa, MKL_Complex8* sx,
                        const MKL_INT* incx );
void __stdcall csrscl( const MKL_INT* n, const float* sa, MKL_Complex8* sx,
                       const MKL_INT* incx );
void __stdcall csrscl_( const MKL_INT* n, const float* sa, MKL_Complex8* sx,
                        const MKL_INT* incx );

void __stdcall CSTEDC( const char* compz, int compz_len, const MKL_INT* n, float* d, float* e,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall CSTEDC_( const char* compz, int compz_len, const MKL_INT* n, float* d, float* e,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                        MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall cstedc( const char* compz, int compz_len, const MKL_INT* n, float* d, float* e,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                       const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall cstedc_( const char* compz, int compz_len, const MKL_INT* n, float* d, float* e,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
                        const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                        MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );

void __stdcall CSTEGR( const char* jobz, int jobz_len, const char* range, int range_len, const MKL_INT* n, float* d,
                       float* e, const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz, float* work,
                       const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
                       MKL_INT* info );
void __stdcall CSTEGR_( const char* jobz, int jobz_len, const char* range, int range_len, const MKL_INT* n, float* d,
                        float* e, const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
                        float* work, const MKL_INT* lwork, MKL_INT* iwork,
                        const MKL_INT* liwork, MKL_INT* info );
void __stdcall cstegr( const char* jobz, int jobz_len, const char* range, int range_len, const MKL_INT* n, float* d,
                       float* e, const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                       MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz, float* work,
                       const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
                       MKL_INT* info );
void __stdcall cstegr_( const char* jobz, int jobz_len, const char* range, int range_len, const MKL_INT* n, float* d,
                        float* e, const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
                        MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
                        float* work, const MKL_INT* lwork, MKL_INT* iwork,
                        const MKL_INT* liwork, MKL_INT* info );

void __stdcall CSTEIN( const MKL_INT* n, const float* d, const float* e,
                       const MKL_INT* m, const float* w, const MKL_INT* iblock,
                       const MKL_INT* isplit, MKL_Complex8* z, const MKL_INT* ldz,
                       float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall CSTEIN_( const MKL_INT* n, const float* d, const float* e,
                        const MKL_INT* m, const float* w, const MKL_INT* iblock,
                        const MKL_INT* isplit, MKL_Complex8* z, const MKL_INT* ldz,
                        float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall cstein( const MKL_INT* n, const float* d, const float* e,
                       const MKL_INT* m, const float* w, const MKL_INT* iblock,
                       const MKL_INT* isplit, MKL_Complex8* z, const MKL_INT* ldz,
                       float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void __stdcall cstein_( const MKL_INT* n, const float* d, const float* e,
                        const MKL_INT* m, const float* w, const MKL_INT* iblock,
                        const MKL_INT* isplit, MKL_Complex8* z, const MKL_INT* ldz,
                        float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void __stdcall CSTEMR( const char* jobz, int jobz_len, const char* range, int range_len, const MKL_INT* n, float* d,
                       float* e, const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, MKL_INT* m, float* w, MKL_Complex8* z,
                       const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz,
                       MKL_INT* tryrac, float* work, const MKL_INT* lwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall CSTEMR_( const char* jobz, int jobz_len, const char* range, int range_len, const MKL_INT* n, float* d,
                        float* e, const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, MKL_INT* m, float* w, MKL_Complex8* z,
                        const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz,
                        MKL_INT* tryrac, float* work, const MKL_INT* lwork,
                        MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall cstemr( const char* jobz, int jobz_len, const char* range, int range_len, const MKL_INT* n, float* d,
                       float* e, const float* vl, const float* vu, const MKL_INT* il,
                       const MKL_INT* iu, MKL_INT* m, float* w, MKL_Complex8* z,
                       const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz,
                       MKL_INT* tryrac, float* work, const MKL_INT* lwork,
                       MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void __stdcall cstemr_( const char* jobz, int jobz_len, const char* range, int range_len, const MKL_INT* n, float* d,
                        float* e, const float* vl, const float* vu, const MKL_INT* il,
                        const MKL_INT* iu, MKL_INT* m, float* w, MKL_Complex8* z,
                        const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz,
                        MKL_INT* tryrac, float* work, const MKL_INT* lwork,
                        MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );

void __stdcall CSTEQR( const char* compz, int compz_len, const MKL_INT* n, float* d, float* e,
                       MKL_Complex8* z, const MKL_INT* ldz, float* work, MKL_INT* info );
void __stdcall CSTEQR_( const char* compz, int compz_len, const MKL_INT* n, float* d, float* e,
                        MKL_Complex8* z, const MKL_INT* ldz, float* work,
                        MKL_INT* info );
void __stdcall csteqr( const char* compz, int compz_len, const MKL_INT* n, float* d, float* e,
                       MKL_Complex8* z, const MKL_INT* ldz, float* work, MKL_INT* info );
void __stdcall csteqr_( const char* compz, int compz_len, const MKL_INT* n, float* d, float* e,
                        MKL_Complex8* z, const MKL_INT* ldz, float* work,
                        MKL_INT* info );

void __stdcall CSYCON( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                       float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall CSYCON_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                        float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall csycon( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                       const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                       float* rcond, MKL_Complex8* work, MKL_INT* info );
void __stdcall csycon_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                        float* rcond, MKL_Complex8* work, MKL_INT* info );

void __stdcall CSYEQUB( char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, float* s, float* scond, float* amax,
                        MKL_Complex8* work, MKL_INT* info );
void __stdcall CSYEQUB_( char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                         const MKL_INT* lda, float* s, float* scond, float* amax,
                         MKL_Complex8* work, MKL_INT* info );
void __stdcall csyequb( char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                        const MKL_INT* lda, float* s, float* scond, float* amax,
                        MKL_Complex8* work, MKL_INT* info );
void __stdcall csyequb_( char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* a,
                         const MKL_INT* lda, float* s, float* scond, float* amax,
                         MKL_Complex8* work, MKL_INT* info );

void __stdcall CSYMV( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                      const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* x,
                      const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
                      const MKL_INT* incy );
void __stdcall CSYMV_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* x,
                       const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
                       const MKL_INT* incy );
void __stdcall csymv( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                      const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* x,
                      const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
                      const MKL_INT* incy );
void __stdcall csymv_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* x,
                       const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
                       const MKL_INT* incy );

void __stdcall CSYR( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                     const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* a,
                     const MKL_INT* lda );
void __stdcall CSYR_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                      const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* a,
                      const MKL_INT* lda );
void __stdcall csyr( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                     const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* a,
                     const MKL_INT* lda );
void __stdcall csyr_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_Complex8* alpha,
                      const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* a,
                      const MKL_INT* lda );

void __stdcall CSYRFS( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
                       const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                       float* ferr, float* berr, MKL_Complex8* work, float* rwork,
                       MKL_INT* info );
void __stdcall CSYRFS_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );
void __stdcall csyrfs( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
                       const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
                       const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                       float* ferr, float* berr, MKL_Complex8* work, float* rwork,
                       MKL_INT* info );
void __stdcall csyrfs_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                        const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
                        float* rwork, MKL_INT* info );

void __stdcall CSYRFSX( const char* uplo, int uplo_len, const char* equed, int equed_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
                        const float* s, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CSYRFSX_( const char* uplo, int uplo_len, const char* equed, int equed_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* af, const MKL_INT* ldaf,
                         const MKL_INT* ipiv, const float* s, const MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                         float* rcond, float* berr, const MKL_INT* n_err_bnds,
                         float* err_bnds_norm, float* err_bnds_comp,
                         const MKL_INT* nparams, float* params, MKL_Complex8* work,
                         float* rwork, MKL_INT* info );
void __stdcall csyrfsx( const char* uplo, int uplo_len, const char* equed, int equed_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                        const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
                        const float* s, const MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* berr,
                        const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall csyrfsx_( const char* uplo, int uplo_len, const char* equed, int equed_len, const MKL_INT* n,
                         const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                         const MKL_Complex8* af, const MKL_INT* ldaf,
                         const MKL_INT* ipiv, const float* s, const MKL_Complex8* b,
                         const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
                         float* rcond, float* berr, const MKL_INT* n_err_bnds,
                         float* err_bnds_norm, float* err_bnds_comp,
                         const MKL_INT* nparams, float* params, MKL_Complex8* work,
                         float* rwork, MKL_INT* info );

void __stdcall CSYSV( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall CSYSV_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void __stdcall csysv( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void __stdcall csysv_( const char* uplo, int uplo_len, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );

void __stdcall CSYSVX( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                       const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* info );
void __stdcall CSYSVX_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* info );
void __stdcall csysvx( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                       const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                       const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                       const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                       MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                       MKL_INT* info );
void __stdcall csysvx_( const char* fact, int fact_len, const char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                        const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
                        const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
                        MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                        MKL_INT* info );

void __stdcall CSYSVXX( const char* fact, int fact_len, char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                        char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* rpvgrw,
                        float* berr, const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall CSYSVXX_( const char* fact, int fact_len, char* uplo, int uplo_len, const MKL_INT* n,
                         const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                         MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                         char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                         MKL_Complex8* x, const MKL_INT* ldx, float* rcond,
                         float* rpvgrw, float* berr, const MKL_INT* n_err_bnds,
                         float* err_bnds_norm, float* err_bnds_comp,
                         const MKL_INT* nparams, float* params, MKL_Complex8* work,
                         float* rwork, MKL_INT* info );
void __stdcall csysvxx( const char* fact, int fact_len, char* uplo, int uplo_len, const MKL_INT* n,
                        const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
                        MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
                        char* equed, int equed_len, float* s, MKL_Complex8* b, const MKL_INT* ldb,
                        MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* rpvgrw,
                        float* berr, const MKL_INT* n_err_bnds, float* err_bnds_norm,
                        float* err_bnds_comp, const MKL_INT* nparams, float* params,
                        MKL_Complex8* work, float* rwork, MKL_INT* info );
void __stdcall csysvx