// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.onnxruntime;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.opencl.*;
import static org.bytedeco.opencl.global.OpenCL.*;
import org.bytedeco.dnnl.*;
import static org.bytedeco.dnnl.global.dnnl.*;

import static org.bytedeco.onnxruntime.global.onnxruntime.*;


@Properties(inherit = org.bytedeco.onnxruntime.presets.onnxruntime.class)
public class OrtApi extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public OrtApi() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public OrtApi(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public OrtApi(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public OrtApi position(long position) {
        return (OrtApi)super.position(position);
    }
    @Override public OrtApi getPointer(long i) {
        return new OrtApi((Pointer)this).position(position + i);
    }

  /**
* @param msg A null-terminated string. Its content will be copied into the newly created OrtStatus
*/
  public static class CreateStatus_int_BytePointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateStatus_int_BytePointer(Pointer p) { super(p); }
      protected CreateStatus_int_BytePointer() { allocate(); }
      private native void allocate();
      public native OrtStatus call(@Cast("OrtErrorCode") int code, @Cast("const char*") BytePointer msg);
  }
  public native CreateStatus_int_BytePointer CreateStatus(); public native OrtApi CreateStatus(CreateStatus_int_BytePointer setter);

  public static class GetErrorCode_OrtStatus extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetErrorCode_OrtStatus(Pointer p) { super(p); }
      protected GetErrorCode_OrtStatus() { allocate(); }
      private native void allocate();
      public native @Cast("OrtErrorCode") int call(@Const OrtStatus status);
  }
  public native GetErrorCode_OrtStatus GetErrorCode(); public native OrtApi GetErrorCode(GetErrorCode_OrtStatus setter);

  /**
 * @param status must not be NULL
 * @return The error message inside the {@code status}. Do not free the returned value.
 */
  public static class GetErrorMessage_OrtStatus extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetErrorMessage_OrtStatus(Pointer p) { super(p); }
      protected GetErrorMessage_OrtStatus() { allocate(); }
      private native void allocate();
      public native @Cast("const char*") BytePointer call(@Const OrtStatus status);
  }
  public native GetErrorMessage_OrtStatus GetErrorMessage(); public native OrtApi GetErrorMessage(GetErrorMessage_OrtStatus setter);

  /**
     * @param out Should be freed by {@code OrtReleaseEnv} after use
     */
  public static class CreateEnv_int_BytePointer_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateEnv_int_BytePointer_PointerPointer(Pointer p) { super(p); }
      protected CreateEnv_int_BytePointer_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("OrtLoggingLevel") int logging_level, @Cast("const char*") BytePointer logid, @Cast("OrtEnv**") PointerPointer out);
  }
  public native CreateEnv_int_BytePointer_PointerPointer CreateEnv(); public native OrtApi CreateEnv(CreateEnv_int_BytePointer_PointerPointer setter);

  /**
   * @param out Should be freed by {@code OrtReleaseEnv} after use
   */
  public static class CreateEnvWithCustomLogger_OrtLoggingFunction_Pointer_int_BytePointer_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateEnvWithCustomLogger_OrtLoggingFunction_Pointer_int_BytePointer_PointerPointer(Pointer p) { super(p); }
      protected CreateEnvWithCustomLogger_OrtLoggingFunction_Pointer_int_BytePointer_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtLoggingFunction logging_function, Pointer logger_param,
                    @Cast("OrtLoggingLevel") int logging_level, @Cast("const char*") BytePointer logid, @Cast("OrtEnv**") PointerPointer out);
  }
  public native CreateEnvWithCustomLogger_OrtLoggingFunction_Pointer_int_BytePointer_PointerPointer CreateEnvWithCustomLogger(); public native OrtApi CreateEnvWithCustomLogger(CreateEnvWithCustomLogger_OrtLoggingFunction_Pointer_int_BytePointer_PointerPointer setter);

  // Platform telemetry events are on by default since they are lightweight.  You can manually turn them off.
  public static class EnableTelemetryEvents_OrtEnv extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    EnableTelemetryEvents_OrtEnv(Pointer p) { super(p); }
      protected EnableTelemetryEvents_OrtEnv() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtEnv env);
  }
  public native EnableTelemetryEvents_OrtEnv EnableTelemetryEvents(); public native OrtApi EnableTelemetryEvents(EnableTelemetryEvents_OrtEnv setter);
  public static class DisableTelemetryEvents_OrtEnv extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    DisableTelemetryEvents_OrtEnv(Pointer p) { super(p); }
      protected DisableTelemetryEvents_OrtEnv() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtEnv env);
  }
  public native DisableTelemetryEvents_OrtEnv DisableTelemetryEvents(); public native OrtApi DisableTelemetryEvents(DisableTelemetryEvents_OrtEnv setter);

  // TODO: document the path separator convention? '/' vs '\'
  // TODO: should specify the access characteristics of model_path. Is this read only during the
  // execution of CreateSession, or does the OrtSession retain a handle to the file/directory
  // and continue to access throughout the OrtSession lifetime?
  //  What sort of access is needed to model_path : read or read/write?
  public static class CreateSession_OrtEnv_Pointer_OrtSessionOptions_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateSession_OrtEnv_Pointer_OrtSessionOptions_PointerPointer(Pointer p) { super(p); }
      protected CreateSession_OrtEnv_Pointer_OrtSessionOptions_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtEnv env, @Cast("const ORTCHAR_T*") Pointer model_path,
                    @Const OrtSessionOptions options, @Cast("OrtSession**") PointerPointer out);
  }
  public native CreateSession_OrtEnv_Pointer_OrtSessionOptions_PointerPointer CreateSession(); public native OrtApi CreateSession(CreateSession_OrtEnv_Pointer_OrtSessionOptions_PointerPointer setter);

  public static class CreateSessionFromArray_OrtEnv_Pointer_long_OrtSessionOptions_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateSessionFromArray_OrtEnv_Pointer_long_OrtSessionOptions_PointerPointer(Pointer p) { super(p); }
      protected CreateSessionFromArray_OrtEnv_Pointer_long_OrtSessionOptions_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtEnv env, @Const Pointer model_data, @Cast("size_t") long model_data_length,
                    @Const OrtSessionOptions options, @Cast("OrtSession**") PointerPointer out);
  }
  public native CreateSessionFromArray_OrtEnv_Pointer_long_OrtSessionOptions_PointerPointer CreateSessionFromArray(); public native OrtApi CreateSessionFromArray(CreateSessionFromArray_OrtEnv_Pointer_long_OrtSessionOptions_PointerPointer setter);

  public static class Run_OrtSession_OrtRunOptions_PointerPointer_PointerPointer_long_PointerPointer_long_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    Run_OrtSession_OrtRunOptions_PointerPointer_PointerPointer_long_PointerPointer_long_PointerPointer(Pointer p) { super(p); }
      protected Run_OrtSession_OrtRunOptions_PointerPointer_PointerPointer_long_PointerPointer_long_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSession sess, @Const OrtRunOptions run_options,
                    @Cast("const char*const*") PointerPointer input_names,
                    @Cast("const OrtValue*const*") PointerPointer input, @Cast("size_t") long input_len,
                    @Cast("const char*const*") PointerPointer output_names1, @Cast("size_t") long output_names_len,
                    @Cast("OrtValue**") PointerPointer output);
  }
  public native Run_OrtSession_OrtRunOptions_PointerPointer_PointerPointer_long_PointerPointer_long_PointerPointer Run(); public native OrtApi Run(Run_OrtSession_OrtRunOptions_PointerPointer_PointerPointer_long_PointerPointer_long_PointerPointer setter);

  /**
    * @return A pointer of the newly created object. The pointer should be freed by OrtReleaseSessionOptions after use
    */
  public static class CreateSessionOptions_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateSessionOptions_PointerPointer(Pointer p) { super(p); }
      protected CreateSessionOptions_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("OrtSessionOptions**") PointerPointer options);
  }
  public native CreateSessionOptions_PointerPointer CreateSessionOptions(); public native OrtApi CreateSessionOptions(CreateSessionOptions_PointerPointer setter);

  // Set filepath to save optimized model after graph level transformations.
  public static class SetOptimizedModelFilePath_OrtSessionOptions_Pointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetOptimizedModelFilePath_OrtSessionOptions_Pointer(Pointer p) { super(p); }
      protected SetOptimizedModelFilePath_OrtSessionOptions_Pointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options,
                    @Cast("const ORTCHAR_T*") Pointer optimized_model_filepath);
  }
  public native SetOptimizedModelFilePath_OrtSessionOptions_Pointer SetOptimizedModelFilePath(); public native OrtApi SetOptimizedModelFilePath(SetOptimizedModelFilePath_OrtSessionOptions_Pointer setter);

  // create a copy of an existing OrtSessionOptions
  public static class CloneSessionOptions_OrtSessionOptions_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CloneSessionOptions_OrtSessionOptions_PointerPointer(Pointer p) { super(p); }
      protected CloneSessionOptions_OrtSessionOptions_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSessionOptions in_options,
                    @Cast("OrtSessionOptions**") PointerPointer out_options);
  }
  public native CloneSessionOptions_OrtSessionOptions_PointerPointer CloneSessionOptions(); public native OrtApi CloneSessionOptions(CloneSessionOptions_OrtSessionOptions_PointerPointer setter);

  // Controls whether you want to execute operators in your graph sequentially or in parallel. Usually when the model
  // has many branches, setting this option to ExecutionMode.ORT_PARALLEL will give you better performance.
  // See [docs/ONNX_Runtime_Perf_Tuning.md] for more details.
  public static class SetSessionExecutionMode_OrtSessionOptions_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetSessionExecutionMode_OrtSessionOptions_int(Pointer p) { super(p); }
      protected SetSessionExecutionMode_OrtSessionOptions_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options, @Cast("ExecutionMode") int execution_mode);
  }
  public native SetSessionExecutionMode_OrtSessionOptions_int SetSessionExecutionMode(); public native OrtApi SetSessionExecutionMode(SetSessionExecutionMode_OrtSessionOptions_int setter);

  // Enable profiling for this session.
  public static class EnableProfiling_OrtSessionOptions_Pointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    EnableProfiling_OrtSessionOptions_Pointer(Pointer p) { super(p); }
      protected EnableProfiling_OrtSessionOptions_Pointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options, @Cast("const ORTCHAR_T*") Pointer profile_file_prefix);
  }
  public native EnableProfiling_OrtSessionOptions_Pointer EnableProfiling(); public native OrtApi EnableProfiling(EnableProfiling_OrtSessionOptions_Pointer setter);
  public static class DisableProfiling_OrtSessionOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    DisableProfiling_OrtSessionOptions(Pointer p) { super(p); }
      protected DisableProfiling_OrtSessionOptions() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options);
  }
  public native DisableProfiling_OrtSessionOptions DisableProfiling(); public native OrtApi DisableProfiling(DisableProfiling_OrtSessionOptions setter);

  // Enable the memory pattern optimization.
  // The idea is if the input shapes are the same, we could trace the internal memory allocation
  // and generate a memory pattern for future request. So next time we could just do one allocation
  // with a big chunk for all the internal memory allocation.
  // Note: memory pattern optimization is only available when SequentialExecution enabled.
  public static class EnableMemPattern_OrtSessionOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    EnableMemPattern_OrtSessionOptions(Pointer p) { super(p); }
      protected EnableMemPattern_OrtSessionOptions() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options);
  }
  public native EnableMemPattern_OrtSessionOptions EnableMemPattern(); public native OrtApi EnableMemPattern(EnableMemPattern_OrtSessionOptions setter);
  public static class DisableMemPattern_OrtSessionOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    DisableMemPattern_OrtSessionOptions(Pointer p) { super(p); }
      protected DisableMemPattern_OrtSessionOptions() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options);
  }
  public native DisableMemPattern_OrtSessionOptions DisableMemPattern(); public native OrtApi DisableMemPattern(DisableMemPattern_OrtSessionOptions setter);

  // Enable the memory arena on CPU
  // Arena may pre-allocate memory for future usage.
  // set this option to false if you don't want it.
  public static class EnableCpuMemArena_OrtSessionOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    EnableCpuMemArena_OrtSessionOptions(Pointer p) { super(p); }
      protected EnableCpuMemArena_OrtSessionOptions() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options);
  }
  public native EnableCpuMemArena_OrtSessionOptions EnableCpuMemArena(); public native OrtApi EnableCpuMemArena(EnableCpuMemArena_OrtSessionOptions setter);
  public static class DisableCpuMemArena_OrtSessionOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    DisableCpuMemArena_OrtSessionOptions(Pointer p) { super(p); }
      protected DisableCpuMemArena_OrtSessionOptions() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options);
  }
  public native DisableCpuMemArena_OrtSessionOptions DisableCpuMemArena(); public native OrtApi DisableCpuMemArena(DisableCpuMemArena_OrtSessionOptions setter);

  // < logger id to use for session output
  public static class SetSessionLogId_OrtSessionOptions_BytePointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetSessionLogId_OrtSessionOptions_BytePointer(Pointer p) { super(p); }
      protected SetSessionLogId_OrtSessionOptions_BytePointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options, @Cast("const char*") BytePointer logid);
  }
  public native SetSessionLogId_OrtSessionOptions_BytePointer SetSessionLogId(); public native OrtApi SetSessionLogId(SetSessionLogId_OrtSessionOptions_BytePointer setter);

  // < applies to session load, initialization, etc
  public static class SetSessionLogVerbosityLevel_OrtSessionOptions_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetSessionLogVerbosityLevel_OrtSessionOptions_int(Pointer p) { super(p); }
      protected SetSessionLogVerbosityLevel_OrtSessionOptions_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options, int session_log_verbosity_level);
  }
  public native SetSessionLogVerbosityLevel_OrtSessionOptions_int SetSessionLogVerbosityLevel(); public native OrtApi SetSessionLogVerbosityLevel(SetSessionLogVerbosityLevel_OrtSessionOptions_int setter);
  public static class SetSessionLogSeverityLevel_OrtSessionOptions_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetSessionLogSeverityLevel_OrtSessionOptions_int(Pointer p) { super(p); }
      protected SetSessionLogSeverityLevel_OrtSessionOptions_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options, int session_log_severity_level);
  }
  public native SetSessionLogSeverityLevel_OrtSessionOptions_int SetSessionLogSeverityLevel(); public native OrtApi SetSessionLogSeverityLevel(SetSessionLogSeverityLevel_OrtSessionOptions_int setter);

  public static class SetSessionGraphOptimizationLevel_OrtSessionOptions_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetSessionGraphOptimizationLevel_OrtSessionOptions_int(Pointer p) { super(p); }
      protected SetSessionGraphOptimizationLevel_OrtSessionOptions_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options,
                    @Cast("GraphOptimizationLevel") int graph_optimization_level);
  }
  public native SetSessionGraphOptimizationLevel_OrtSessionOptions_int SetSessionGraphOptimizationLevel(); public native OrtApi SetSessionGraphOptimizationLevel(SetSessionGraphOptimizationLevel_OrtSessionOptions_int setter);

  // Sets the number of threads used to parallelize the execution within nodes
  // A value of 0 means ORT will pick a default
  // Note: If you've built ORT with OpenMP, this API has no effect on the number of threads used. In this case
  // use the OpenMP env variables to configure the number of intra op num threads.
  public static class SetIntraOpNumThreads_OrtSessionOptions_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetIntraOpNumThreads_OrtSessionOptions_int(Pointer p) { super(p); }
      protected SetIntraOpNumThreads_OrtSessionOptions_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options, int intra_op_num_threads);
  }
  public native SetIntraOpNumThreads_OrtSessionOptions_int SetIntraOpNumThreads(); public native OrtApi SetIntraOpNumThreads(SetIntraOpNumThreads_OrtSessionOptions_int setter);

  // Sets the number of threads used to parallelize the execution of the graph (across nodes)
  // If sequential execution is enabled this value is ignored
  // A value of 0 means ORT will pick a default
  public static class SetInterOpNumThreads_OrtSessionOptions_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetInterOpNumThreads_OrtSessionOptions_int(Pointer p) { super(p); }
      protected SetInterOpNumThreads_OrtSessionOptions_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options, int inter_op_num_threads);
  }
  public native SetInterOpNumThreads_OrtSessionOptions_int SetInterOpNumThreads(); public native OrtApi SetInterOpNumThreads(SetInterOpNumThreads_OrtSessionOptions_int setter);

  /*
  Create a custom op domain. After all sessions using it are released, call OrtReleaseCustomOpDomain
  */
  public static class CreateCustomOpDomain_BytePointer_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateCustomOpDomain_BytePointer_PointerPointer(Pointer p) { super(p); }
      protected CreateCustomOpDomain_BytePointer_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("const char*") BytePointer domain, @Cast("OrtCustomOpDomain**") PointerPointer out);
  }
  public native CreateCustomOpDomain_BytePointer_PointerPointer CreateCustomOpDomain(); public native OrtApi CreateCustomOpDomain(CreateCustomOpDomain_BytePointer_PointerPointer setter);

  /*
     * Add custom ops to the OrtCustomOpDomain
     *  Note: The OrtCustomOp* pointer must remain valid until the OrtCustomOpDomain using it is released
    */
  public static class CustomOpDomain_Add_OrtCustomOpDomain_OrtCustomOp extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CustomOpDomain_Add_OrtCustomOpDomain_OrtCustomOp(Pointer p) { super(p); }
      protected CustomOpDomain_Add_OrtCustomOpDomain_OrtCustomOp() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtCustomOpDomain custom_op_domain, @Const OrtCustomOp op);
  }
  public native CustomOpDomain_Add_OrtCustomOpDomain_OrtCustomOp CustomOpDomain_Add(); public native OrtApi CustomOpDomain_Add(CustomOpDomain_Add_OrtCustomOpDomain_OrtCustomOp setter);

  /*
     * Add a custom op domain to the OrtSessionOptions
     *  Note: The OrtCustomOpDomain* must not be deleted until the sessions using it are released
    */
  public static class AddCustomOpDomain_OrtSessionOptions_OrtCustomOpDomain extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    AddCustomOpDomain_OrtSessionOptions_OrtCustomOpDomain(Pointer p) { super(p); }
      protected AddCustomOpDomain_OrtSessionOptions_OrtCustomOpDomain() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options, OrtCustomOpDomain custom_op_domain);
  }
  public native AddCustomOpDomain_OrtSessionOptions_OrtCustomOpDomain AddCustomOpDomain(); public native OrtApi AddCustomOpDomain(AddCustomOpDomain_OrtSessionOptions_OrtCustomOpDomain setter);

  /*
     * Loads a DLL named 'library_path' and looks for this entry point:
     *		OrtStatus* RegisterCustomOps(OrtSessionOptions * options, const OrtApiBase* api);
     * It then passes in the provided session options to this function along with the api base.
     * The handle to the loaded library is returned in library_handle. It can be freed by the caller after all sessions using the passed in
     * session options are destroyed, or if an error occurs and it is non null.
  */
  public static class RegisterCustomOpsLibrary_OrtSessionOptions_BytePointer_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    RegisterCustomOpsLibrary_OrtSessionOptions_BytePointer_PointerPointer(Pointer p) { super(p); }
      protected RegisterCustomOpsLibrary_OrtSessionOptions_BytePointer_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options, @Cast("const char*") BytePointer library_path,
                    @Cast("void**") PointerPointer library_handle);
  }
  public native RegisterCustomOpsLibrary_OrtSessionOptions_BytePointer_PointerPointer RegisterCustomOpsLibrary(); public native OrtApi RegisterCustomOpsLibrary(RegisterCustomOpsLibrary_OrtSessionOptions_BytePointer_PointerPointer setter);

  /**
    * To use additional providers, you must build ORT with the extra providers enabled. Then call one of these
    * functions to enable them in the session:
    *   OrtSessionOptionsAppendExecutionProvider_CPU
    *   OrtSessionOptionsAppendExecutionProvider_CUDA
    *   OrtSessionOptionsAppendExecutionProvider_<remaining providers...>
    * The order they are called indicates the preference order as well. In other words call this method
    * on your most preferred execution provider first followed by the less preferred ones.
    * If none are called Ort will use its internal CPU execution provider.
    */

  public static class SessionGetInputCount_OrtSession_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionGetInputCount_OrtSession_SizeTPointer(Pointer p) { super(p); }
      protected SessionGetInputCount_OrtSession_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSession sess, @Cast("size_t*") SizeTPointer out);
  }
  public native SessionGetInputCount_OrtSession_SizeTPointer SessionGetInputCount(); public native OrtApi SessionGetInputCount(SessionGetInputCount_OrtSession_SizeTPointer setter);
  public static class SessionGetOutputCount_OrtSession_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionGetOutputCount_OrtSession_SizeTPointer(Pointer p) { super(p); }
      protected SessionGetOutputCount_OrtSession_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSession sess, @Cast("size_t*") SizeTPointer out);
  }
  public native SessionGetOutputCount_OrtSession_SizeTPointer SessionGetOutputCount(); public native OrtApi SessionGetOutputCount(SessionGetOutputCount_OrtSession_SizeTPointer setter);
  public static class SessionGetOverridableInitializerCount_OrtSession_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionGetOverridableInitializerCount_OrtSession_SizeTPointer(Pointer p) { super(p); }
      protected SessionGetOverridableInitializerCount_OrtSession_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSession sess, @Cast("size_t*") SizeTPointer out);
  }
  public native SessionGetOverridableInitializerCount_OrtSession_SizeTPointer SessionGetOverridableInitializerCount(); public native OrtApi SessionGetOverridableInitializerCount(SessionGetOverridableInitializerCount_OrtSession_SizeTPointer setter);

  /**
   * @param out  should be freed by OrtReleaseTypeInfo after use
   */
  public static class SessionGetInputTypeInfo_OrtSession_long_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionGetInputTypeInfo_OrtSession_long_PointerPointer(Pointer p) { super(p); }
      protected SessionGetInputTypeInfo_OrtSession_long_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSession sess, @Cast("size_t") long index, @Cast("OrtTypeInfo**") PointerPointer type_info);
  }
  public native SessionGetInputTypeInfo_OrtSession_long_PointerPointer SessionGetInputTypeInfo(); public native OrtApi SessionGetInputTypeInfo(SessionGetInputTypeInfo_OrtSession_long_PointerPointer setter);

  /**
   * @param out  should be freed by OrtReleaseTypeInfo after use
   */
  public static class SessionGetOutputTypeInfo_OrtSession_long_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionGetOutputTypeInfo_OrtSession_long_PointerPointer(Pointer p) { super(p); }
      protected SessionGetOutputTypeInfo_OrtSession_long_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSession sess, @Cast("size_t") long index,
                    @Cast("OrtTypeInfo**") PointerPointer type_info);
  }
  public native SessionGetOutputTypeInfo_OrtSession_long_PointerPointer SessionGetOutputTypeInfo(); public native OrtApi SessionGetOutputTypeInfo(SessionGetOutputTypeInfo_OrtSession_long_PointerPointer setter);

  /**
 * @param out  should be freed by OrtReleaseTypeInfo after use
 */
  public static class SessionGetOverridableInitializerTypeInfo_OrtSession_long_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionGetOverridableInitializerTypeInfo_OrtSession_long_PointerPointer(Pointer p) { super(p); }
      protected SessionGetOverridableInitializerTypeInfo_OrtSession_long_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSession sess, @Cast("size_t") long index,
                    @Cast("OrtTypeInfo**") PointerPointer type_info);
  }
  public native SessionGetOverridableInitializerTypeInfo_OrtSession_long_PointerPointer SessionGetOverridableInitializerTypeInfo(); public native OrtApi SessionGetOverridableInitializerTypeInfo(SessionGetOverridableInitializerTypeInfo_OrtSession_long_PointerPointer setter);

  /**
   * @param value  is set to a null terminated string allocated using 'allocator'. The caller is responsible for freeing it.
   */
  public static class SessionGetInputName_OrtSession_long_OrtAllocator_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionGetInputName_OrtSession_long_OrtAllocator_PointerPointer(Pointer p) { super(p); }
      protected SessionGetInputName_OrtSession_long_OrtAllocator_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSession sess, @Cast("size_t") long index, OrtAllocator allocator,
                    @Cast("char**") PointerPointer value);
  }
  public native SessionGetInputName_OrtSession_long_OrtAllocator_PointerPointer SessionGetInputName(); public native OrtApi SessionGetInputName(SessionGetInputName_OrtSession_long_OrtAllocator_PointerPointer setter);
  public static class SessionGetOutputName_OrtSession_long_OrtAllocator_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionGetOutputName_OrtSession_long_OrtAllocator_PointerPointer(Pointer p) { super(p); }
      protected SessionGetOutputName_OrtSession_long_OrtAllocator_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSession sess, @Cast("size_t") long index, OrtAllocator allocator,
                    @Cast("char**") PointerPointer value);
  }
  public native SessionGetOutputName_OrtSession_long_OrtAllocator_PointerPointer SessionGetOutputName(); public native OrtApi SessionGetOutputName(SessionGetOutputName_OrtSession_long_OrtAllocator_PointerPointer setter);
  public static class SessionGetOverridableInitializerName_OrtSession_long_OrtAllocator_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionGetOverridableInitializerName_OrtSession_long_OrtAllocator_PointerPointer(Pointer p) { super(p); }
      protected SessionGetOverridableInitializerName_OrtSession_long_OrtAllocator_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSession sess, @Cast("size_t") long index,
                    OrtAllocator allocator, @Cast("char**") PointerPointer value);
  }
  public native SessionGetOverridableInitializerName_OrtSession_long_OrtAllocator_PointerPointer SessionGetOverridableInitializerName(); public native OrtApi SessionGetOverridableInitializerName(SessionGetOverridableInitializerName_OrtSession_long_OrtAllocator_PointerPointer setter);

  /**
   * @return A pointer to the newly created object. The pointer should be freed by OrtReleaseRunOptions after use
   */
  public static class CreateRunOptions_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateRunOptions_PointerPointer(Pointer p) { super(p); }
      protected CreateRunOptions_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("OrtRunOptions**") PointerPointer out);
  }
  public native CreateRunOptions_PointerPointer CreateRunOptions(); public native OrtApi CreateRunOptions(CreateRunOptions_PointerPointer setter);

  public static class RunOptionsSetRunLogVerbosityLevel_OrtRunOptions_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    RunOptionsSetRunLogVerbosityLevel_OrtRunOptions_int(Pointer p) { super(p); }
      protected RunOptionsSetRunLogVerbosityLevel_OrtRunOptions_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtRunOptions options, int value);
  }
  public native RunOptionsSetRunLogVerbosityLevel_OrtRunOptions_int RunOptionsSetRunLogVerbosityLevel(); public native OrtApi RunOptionsSetRunLogVerbosityLevel(RunOptionsSetRunLogVerbosityLevel_OrtRunOptions_int setter);
  public static class RunOptionsSetRunLogSeverityLevel_OrtRunOptions_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    RunOptionsSetRunLogSeverityLevel_OrtRunOptions_int(Pointer p) { super(p); }
      protected RunOptionsSetRunLogSeverityLevel_OrtRunOptions_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtRunOptions options, int value);
  }
  public native RunOptionsSetRunLogSeverityLevel_OrtRunOptions_int RunOptionsSetRunLogSeverityLevel(); public native OrtApi RunOptionsSetRunLogSeverityLevel(RunOptionsSetRunLogSeverityLevel_OrtRunOptions_int setter);
  public static class RunOptionsSetRunTag_OrtRunOptions_BytePointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    RunOptionsSetRunTag_OrtRunOptions_BytePointer(Pointer p) { super(p); }
      protected RunOptionsSetRunTag_OrtRunOptions_BytePointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtRunOptions arg0, @Cast("const char*") BytePointer run_tag);
  }
  public native RunOptionsSetRunTag_OrtRunOptions_BytePointer RunOptionsSetRunTag(); public native OrtApi RunOptionsSetRunTag(RunOptionsSetRunTag_OrtRunOptions_BytePointer setter);

  public static class RunOptionsGetRunLogVerbosityLevel_OrtRunOptions_IntPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    RunOptionsGetRunLogVerbosityLevel_OrtRunOptions_IntPointer(Pointer p) { super(p); }
      protected RunOptionsGetRunLogVerbosityLevel_OrtRunOptions_IntPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtRunOptions options, IntPointer out);
  }
  public native RunOptionsGetRunLogVerbosityLevel_OrtRunOptions_IntPointer RunOptionsGetRunLogVerbosityLevel(); public native OrtApi RunOptionsGetRunLogVerbosityLevel(RunOptionsGetRunLogVerbosityLevel_OrtRunOptions_IntPointer setter);
  public static class RunOptionsGetRunLogSeverityLevel_OrtRunOptions_IntPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    RunOptionsGetRunLogSeverityLevel_OrtRunOptions_IntPointer(Pointer p) { super(p); }
      protected RunOptionsGetRunLogSeverityLevel_OrtRunOptions_IntPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtRunOptions options, IntPointer out);
  }
  public native RunOptionsGetRunLogSeverityLevel_OrtRunOptions_IntPointer RunOptionsGetRunLogSeverityLevel(); public native OrtApi RunOptionsGetRunLogSeverityLevel(RunOptionsGetRunLogSeverityLevel_OrtRunOptions_IntPointer setter);
  public static class RunOptionsGetRunTag_OrtRunOptions_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    RunOptionsGetRunTag_OrtRunOptions_PointerPointer(Pointer p) { super(p); }
      protected RunOptionsGetRunTag_OrtRunOptions_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtRunOptions arg0, @Cast("const char**") PointerPointer out);
  }
  public native RunOptionsGetRunTag_OrtRunOptions_PointerPointer RunOptionsGetRunTag(); public native OrtApi RunOptionsGetRunTag(RunOptionsGetRunTag_OrtRunOptions_PointerPointer setter);

  // Set a flag so that ALL incomplete OrtRun calls that are using this instance of OrtRunOptions
  // will exit as soon as possible.
  public static class RunOptionsSetTerminate_OrtRunOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    RunOptionsSetTerminate_OrtRunOptions(Pointer p) { super(p); }
      protected RunOptionsSetTerminate_OrtRunOptions() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtRunOptions options);
  }
  public native RunOptionsSetTerminate_OrtRunOptions RunOptionsSetTerminate(); public native OrtApi RunOptionsSetTerminate(RunOptionsSetTerminate_OrtRunOptions setter);
  // Unset the terminate flag to enable this OrtRunOptions instance being used in new OrtRun calls.
  public static class RunOptionsUnsetTerminate_OrtRunOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    RunOptionsUnsetTerminate_OrtRunOptions(Pointer p) { super(p); }
      protected RunOptionsUnsetTerminate_OrtRunOptions() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtRunOptions options);
  }
  public native RunOptionsUnsetTerminate_OrtRunOptions RunOptionsUnsetTerminate(); public native OrtApi RunOptionsUnsetTerminate(RunOptionsUnsetTerminate_OrtRunOptions setter);

  /**
   * Create a tensor from an allocator. OrtReleaseValue will also release the buffer inside the output value
   * @param out Should be freed by calling OrtReleaseValue
   * @param type must be one of TENSOR_ELEMENT_DATA_TYPE_xxxx
   */
  public static class CreateTensorAsOrtValue_OrtAllocator_LongPointer_long_int_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateTensorAsOrtValue_OrtAllocator_LongPointer_long_int_PointerPointer(Pointer p) { super(p); }
      protected CreateTensorAsOrtValue_OrtAllocator_LongPointer_long_int_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtAllocator allocator, @Cast("const int64_t*") LongPointer shape, @Cast("size_t") long shape_len,
                    @Cast("ONNXTensorElementDataType") int type, @Cast("OrtValue**") PointerPointer out);
  }
  public native CreateTensorAsOrtValue_OrtAllocator_LongPointer_long_int_PointerPointer CreateTensorAsOrtValue(); public native OrtApi CreateTensorAsOrtValue(CreateTensorAsOrtValue_OrtAllocator_LongPointer_long_int_PointerPointer setter);

  /**
   * Create a tensor with user's buffer. You can fill the buffer either before calling this function or after.
   * p_data is owned by caller. OrtReleaseValue won't release p_data.
   * @param out Should be freed by calling OrtReleaseValue
   */
  public static class CreateTensorWithDataAsOrtValue_OrtMemoryInfo_Pointer_long_LongPointer_long_int_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateTensorWithDataAsOrtValue_OrtMemoryInfo_Pointer_long_LongPointer_long_int_PointerPointer(Pointer p) { super(p); }
      protected CreateTensorWithDataAsOrtValue_OrtMemoryInfo_Pointer_long_LongPointer_long_int_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtMemoryInfo info, Pointer p_data,
                    @Cast("size_t") long p_data_len, @Cast("const int64_t*") LongPointer shape, @Cast("size_t") long shape_len, @Cast("ONNXTensorElementDataType") int type,
                    @Cast("OrtValue**") PointerPointer out);
  }
  public native CreateTensorWithDataAsOrtValue_OrtMemoryInfo_Pointer_long_LongPointer_long_int_PointerPointer CreateTensorWithDataAsOrtValue(); public native OrtApi CreateTensorWithDataAsOrtValue(CreateTensorWithDataAsOrtValue_OrtMemoryInfo_Pointer_long_LongPointer_long_int_PointerPointer setter);

  /**
   * \Sets *out to 1 iff an OrtValue is a tensor, 0 otherwise
   */
  public static class IsTensor_OrtValue_IntPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    IsTensor_OrtValue_IntPointer(Pointer p) { super(p); }
      protected IsTensor_OrtValue_IntPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtValue value, IntPointer out);
  }
  public native IsTensor_OrtValue_IntPointer IsTensor(); public native OrtApi IsTensor(IsTensor_OrtValue_IntPointer setter);

  // This function doesn't work with string tensor
  // this is a no-copy method whose pointer is only valid until the backing OrtValue is free'd.
  public static class GetTensorMutableData_OrtValue_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetTensorMutableData_OrtValue_PointerPointer(Pointer p) { super(p); }
      protected GetTensorMutableData_OrtValue_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtValue value, @Cast("void**") PointerPointer out);
  }
  public native GetTensorMutableData_OrtValue_PointerPointer GetTensorMutableData(); public native OrtApi GetTensorMutableData(GetTensorMutableData_OrtValue_PointerPointer setter);

  /**
     * @param value A tensor created from OrtCreateTensor... function.
     * @param s each A string array. Each string in this array must be null terminated.
     * @param s_len length of s
     */
  public static class FillStringTensor_OrtValue_PointerPointer_long extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    FillStringTensor_OrtValue_PointerPointer_long(Pointer p) { super(p); }
      protected FillStringTensor_OrtValue_PointerPointer_long() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtValue value, @Cast("const char*const*") PointerPointer s, @Cast("size_t") long s_len);
  }
  public native FillStringTensor_OrtValue_PointerPointer_long FillStringTensor(); public native OrtApi FillStringTensor(FillStringTensor_OrtValue_PointerPointer_long setter);

  /**
     * @param value A tensor created from OrtCreateTensor... function.
     * @param len total data length, not including the trailing '\0' chars.
     */
  public static class GetStringTensorDataLength_OrtValue_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetStringTensorDataLength_OrtValue_SizeTPointer(Pointer p) { super(p); }
      protected GetStringTensorDataLength_OrtValue_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtValue value, @Cast("size_t*") SizeTPointer len);
  }
  public native GetStringTensorDataLength_OrtValue_SizeTPointer GetStringTensorDataLength(); public native OrtApi GetStringTensorDataLength(GetStringTensorDataLength_OrtValue_SizeTPointer setter);

  /**
     * @param s string contents. Each string is NOT null-terminated.
     * @param value A tensor created from OrtCreateTensor... function.
     * @param s_len total data length, get it from OrtGetStringTensorDataLength
     */
  public static class GetStringTensorContent_OrtValue_Pointer_long_SizeTPointer_long extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetStringTensorContent_OrtValue_Pointer_long_SizeTPointer_long(Pointer p) { super(p); }
      protected GetStringTensorContent_OrtValue_Pointer_long_SizeTPointer_long() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtValue value, Pointer s,
                    @Cast("size_t") long s_len, @Cast("size_t*") SizeTPointer offsets, @Cast("size_t") long offsets_len);
  }
  public native GetStringTensorContent_OrtValue_Pointer_long_SizeTPointer_long GetStringTensorContent(); public native OrtApi GetStringTensorContent(GetStringTensorContent_OrtValue_Pointer_long_SizeTPointer_long setter);

  /**
     * Don't free the 'out' value
     */
  public static class CastTypeInfoToTensorInfo_OrtTypeInfo_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CastTypeInfoToTensorInfo_OrtTypeInfo_PointerPointer(Pointer p) { super(p); }
      protected CastTypeInfoToTensorInfo_OrtTypeInfo_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtTypeInfo arg0,
                    @Cast("const OrtTensorTypeAndShapeInfo**") PointerPointer out);
  }
  public native CastTypeInfoToTensorInfo_OrtTypeInfo_PointerPointer CastTypeInfoToTensorInfo(); public native OrtApi CastTypeInfoToTensorInfo(CastTypeInfoToTensorInfo_OrtTypeInfo_PointerPointer setter);

  /**
     * Return OnnxType from OrtTypeInfo
     */
  public static class GetOnnxTypeFromTypeInfo_OrtTypeInfo_IntPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetOnnxTypeFromTypeInfo_OrtTypeInfo_IntPointer(Pointer p) { super(p); }
      protected GetOnnxTypeFromTypeInfo_OrtTypeInfo_IntPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtTypeInfo arg0, @Cast("ONNXType*") IntPointer out);
  }
  public native GetOnnxTypeFromTypeInfo_OrtTypeInfo_IntPointer GetOnnxTypeFromTypeInfo(); public native OrtApi GetOnnxTypeFromTypeInfo(GetOnnxTypeFromTypeInfo_OrtTypeInfo_IntPointer setter);

  /**
     * The 'out' value should be released by calling OrtReleaseTensorTypeAndShapeInfo
     */
  public static class CreateTensorTypeAndShapeInfo_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateTensorTypeAndShapeInfo_PointerPointer(Pointer p) { super(p); }
      protected CreateTensorTypeAndShapeInfo_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("OrtTensorTypeAndShapeInfo**") PointerPointer out);
  }
  public native CreateTensorTypeAndShapeInfo_PointerPointer CreateTensorTypeAndShapeInfo(); public native OrtApi CreateTensorTypeAndShapeInfo(CreateTensorTypeAndShapeInfo_PointerPointer setter);

  public static class SetTensorElementType_OrtTensorTypeAndShapeInfo_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetTensorElementType_OrtTensorTypeAndShapeInfo_int(Pointer p) { super(p); }
      protected SetTensorElementType_OrtTensorTypeAndShapeInfo_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtTensorTypeAndShapeInfo arg0, @Cast("ONNXTensorElementDataType") int type);
  }
  public native SetTensorElementType_OrtTensorTypeAndShapeInfo_int SetTensorElementType(); public native OrtApi SetTensorElementType(SetTensorElementType_OrtTensorTypeAndShapeInfo_int setter);

  /**
 * @param info Created from CreateTensorTypeAndShapeInfo() function
 * @param dim_values An array with length of {@code dim_count}. Its elements can contain negative values.
 * @param dim_count length of dim_values
 */
  public static class SetDimensions_OrtTensorTypeAndShapeInfo_LongPointer_long extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetDimensions_OrtTensorTypeAndShapeInfo_LongPointer_long(Pointer p) { super(p); }
      protected SetDimensions_OrtTensorTypeAndShapeInfo_LongPointer_long() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtTensorTypeAndShapeInfo info, @Cast("const int64_t*") LongPointer dim_values, @Cast("size_t") long dim_count);
  }
  public native SetDimensions_OrtTensorTypeAndShapeInfo_LongPointer_long SetDimensions(); public native OrtApi SetDimensions(SetDimensions_OrtTensorTypeAndShapeInfo_LongPointer_long setter);

  public static class GetTensorElementType_OrtTensorTypeAndShapeInfo_IntPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetTensorElementType_OrtTensorTypeAndShapeInfo_IntPointer(Pointer p) { super(p); }
      protected GetTensorElementType_OrtTensorTypeAndShapeInfo_IntPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtTensorTypeAndShapeInfo arg0,
                    @Cast("ONNXTensorElementDataType*") IntPointer out);
  }
  public native GetTensorElementType_OrtTensorTypeAndShapeInfo_IntPointer GetTensorElementType(); public native OrtApi GetTensorElementType(GetTensorElementType_OrtTensorTypeAndShapeInfo_IntPointer setter);
  public static class GetDimensionsCount_OrtTensorTypeAndShapeInfo_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetDimensionsCount_OrtTensorTypeAndShapeInfo_SizeTPointer(Pointer p) { super(p); }
      protected GetDimensionsCount_OrtTensorTypeAndShapeInfo_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtTensorTypeAndShapeInfo info, @Cast("size_t*") SizeTPointer out);
  }
  public native GetDimensionsCount_OrtTensorTypeAndShapeInfo_SizeTPointer GetDimensionsCount(); public native OrtApi GetDimensionsCount(GetDimensionsCount_OrtTensorTypeAndShapeInfo_SizeTPointer setter);
  public static class GetDimensions_OrtTensorTypeAndShapeInfo_LongPointer_long extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetDimensions_OrtTensorTypeAndShapeInfo_LongPointer_long(Pointer p) { super(p); }
      protected GetDimensions_OrtTensorTypeAndShapeInfo_LongPointer_long() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtTensorTypeAndShapeInfo info, @Cast("int64_t*") LongPointer dim_values,
                    @Cast("size_t") long dim_values_length);
  }
  public native GetDimensions_OrtTensorTypeAndShapeInfo_LongPointer_long GetDimensions(); public native OrtApi GetDimensions(GetDimensions_OrtTensorTypeAndShapeInfo_LongPointer_long setter);
  public static class GetSymbolicDimensions_OrtTensorTypeAndShapeInfo_PointerPointer_long extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetSymbolicDimensions_OrtTensorTypeAndShapeInfo_PointerPointer_long(Pointer p) { super(p); }
      protected GetSymbolicDimensions_OrtTensorTypeAndShapeInfo_PointerPointer_long() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtTensorTypeAndShapeInfo info,
                    @Cast("const char**") PointerPointer dim_params, @Cast("size_t") long dim_params_length);
  }
  public native GetSymbolicDimensions_OrtTensorTypeAndShapeInfo_PointerPointer_long GetSymbolicDimensions(); public native OrtApi GetSymbolicDimensions(GetSymbolicDimensions_OrtTensorTypeAndShapeInfo_PointerPointer_long setter);

  /**
 * Return the number of elements specified by the tensor shape.
 * Return a negative value if unknown (i.e., any dimension is negative.)
 * e.g.
 * [] -> 1
 * [1,3,4] -> 12
 * [2,0,4] -> 0
 * [-1,3,4] -> -1
 */
  public static class GetTensorShapeElementCount_OrtTensorTypeAndShapeInfo_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetTensorShapeElementCount_OrtTensorTypeAndShapeInfo_SizeTPointer(Pointer p) { super(p); }
      protected GetTensorShapeElementCount_OrtTensorTypeAndShapeInfo_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtTensorTypeAndShapeInfo info, @Cast("size_t*") SizeTPointer out);
  }
  public native GetTensorShapeElementCount_OrtTensorTypeAndShapeInfo_SizeTPointer GetTensorShapeElementCount(); public native OrtApi GetTensorShapeElementCount(GetTensorShapeElementCount_OrtTensorTypeAndShapeInfo_SizeTPointer setter);

  /**
 * @param out Should be freed by OrtReleaseTensorTypeAndShapeInfo after use
 */
  public static class GetTensorTypeAndShape_OrtValue_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetTensorTypeAndShape_OrtValue_PointerPointer(Pointer p) { super(p); }
      protected GetTensorTypeAndShape_OrtValue_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtValue value, @Cast("OrtTensorTypeAndShapeInfo**") PointerPointer out);
  }
  public native GetTensorTypeAndShape_OrtValue_PointerPointer GetTensorTypeAndShape(); public native OrtApi GetTensorTypeAndShape(GetTensorTypeAndShape_OrtValue_PointerPointer setter);

  /**
 * Get the type information of an OrtValue
 * @param value
 * @param out The returned value should be freed by OrtReleaseTypeInfo after use
 */
  public static class GetTypeInfo_OrtValue_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetTypeInfo_OrtValue_PointerPointer(Pointer p) { super(p); }
      protected GetTypeInfo_OrtValue_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtValue value, @Cast("OrtTypeInfo**") PointerPointer out);
  }
  public native GetTypeInfo_OrtValue_PointerPointer GetTypeInfo(); public native OrtApi GetTypeInfo(GetTypeInfo_OrtValue_PointerPointer setter);

  public static class GetValueType_OrtValue_IntPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetValueType_OrtValue_IntPointer(Pointer p) { super(p); }
      protected GetValueType_OrtValue_IntPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtValue value, @Cast("ONNXType*") IntPointer out);
  }
  public native GetValueType_OrtValue_IntPointer GetValueType(); public native OrtApi GetValueType(GetValueType_OrtValue_IntPointer setter);

  public static class CreateMemoryInfo_BytePointer_int_int_int_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateMemoryInfo_BytePointer_int_int_int_PointerPointer(Pointer p) { super(p); }
      protected CreateMemoryInfo_BytePointer_int_int_int_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("const char*") BytePointer name1, @Cast("OrtAllocatorType") int type, int id1,
                    @Cast("OrtMemType") int mem_type1, @Cast("OrtMemoryInfo**") PointerPointer out);
  }
  public native CreateMemoryInfo_BytePointer_int_int_int_PointerPointer CreateMemoryInfo(); public native OrtApi CreateMemoryInfo(CreateMemoryInfo_BytePointer_int_int_int_PointerPointer setter);

  /**
 * Convenience function for special case of CreateMemoryInfo, for the CPU allocator. Uses name = "Cpu" and id = 0.
 */
  public static class CreateCpuMemoryInfo_int_int_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateCpuMemoryInfo_int_int_PointerPointer(Pointer p) { super(p); }
      protected CreateCpuMemoryInfo_int_int_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("OrtAllocatorType") int type, @Cast("OrtMemType") int mem_type1,
                    @Cast("OrtMemoryInfo**") PointerPointer out);
  }
  public native CreateCpuMemoryInfo_int_int_PointerPointer CreateCpuMemoryInfo(); public native OrtApi CreateCpuMemoryInfo(CreateCpuMemoryInfo_int_int_PointerPointer setter);

  /**
 * Test if two memory info are equal
 * \Sets 'out' to 0 if equal, -1 if not equal
 */
  public static class CompareMemoryInfo_OrtMemoryInfo_OrtMemoryInfo_IntPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CompareMemoryInfo_OrtMemoryInfo_OrtMemoryInfo_IntPointer(Pointer p) { super(p); }
      protected CompareMemoryInfo_OrtMemoryInfo_OrtMemoryInfo_IntPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtMemoryInfo info1, @Const OrtMemoryInfo info2, IntPointer out);
  }
  public native CompareMemoryInfo_OrtMemoryInfo_OrtMemoryInfo_IntPointer CompareMemoryInfo(); public native OrtApi CompareMemoryInfo(CompareMemoryInfo_OrtMemoryInfo_OrtMemoryInfo_IntPointer setter);

  /**
 * Do not free the returned value
 */
  public static class MemoryInfoGetName_OrtMemoryInfo_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    MemoryInfoGetName_OrtMemoryInfo_PointerPointer(Pointer p) { super(p); }
      protected MemoryInfoGetName_OrtMemoryInfo_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtMemoryInfo ptr, @Cast("const char**") PointerPointer out);
  }
  public native MemoryInfoGetName_OrtMemoryInfo_PointerPointer MemoryInfoGetName(); public native OrtApi MemoryInfoGetName(MemoryInfoGetName_OrtMemoryInfo_PointerPointer setter);
  public static class MemoryInfoGetId_OrtMemoryInfo_IntPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    MemoryInfoGetId_OrtMemoryInfo_IntPointer(Pointer p) { super(p); }
      protected MemoryInfoGetId_OrtMemoryInfo_IntPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtMemoryInfo ptr, IntPointer out);
  }
  public native MemoryInfoGetId_OrtMemoryInfo_IntPointer MemoryInfoGetId(); public native OrtApi MemoryInfoGetId(MemoryInfoGetId_OrtMemoryInfo_IntPointer setter);
  public static class MemoryInfoGetMemType_OrtMemoryInfo_IntPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    MemoryInfoGetMemType_OrtMemoryInfo_IntPointer(Pointer p) { super(p); }
      protected MemoryInfoGetMemType_OrtMemoryInfo_IntPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtMemoryInfo ptr, @Cast("OrtMemType*") IntPointer out);
  }
  public native MemoryInfoGetMemType_OrtMemoryInfo_IntPointer MemoryInfoGetMemType(); public native OrtApi MemoryInfoGetMemType(MemoryInfoGetMemType_OrtMemoryInfo_IntPointer setter);
  public static class MemoryInfoGetType_OrtMemoryInfo_IntPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    MemoryInfoGetType_OrtMemoryInfo_IntPointer(Pointer p) { super(p); }
      protected MemoryInfoGetType_OrtMemoryInfo_IntPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtMemoryInfo ptr, @Cast("OrtAllocatorType*") IntPointer out);
  }
  public native MemoryInfoGetType_OrtMemoryInfo_IntPointer MemoryInfoGetType(); public native OrtApi MemoryInfoGetType(MemoryInfoGetType_OrtMemoryInfo_IntPointer setter);

  public static class AllocatorAlloc_OrtAllocator_long_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    AllocatorAlloc_OrtAllocator_long_PointerPointer(Pointer p) { super(p); }
      protected AllocatorAlloc_OrtAllocator_long_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtAllocator ptr, @Cast("size_t") long size, @Cast("void**") PointerPointer out);
  }
  public native AllocatorAlloc_OrtAllocator_long_PointerPointer AllocatorAlloc(); public native OrtApi AllocatorAlloc(AllocatorAlloc_OrtAllocator_long_PointerPointer setter);
  public static class AllocatorFree_OrtAllocator_Pointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    AllocatorFree_OrtAllocator_Pointer(Pointer p) { super(p); }
      protected AllocatorFree_OrtAllocator_Pointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtAllocator ptr, Pointer p);
  }
  public native AllocatorFree_OrtAllocator_Pointer AllocatorFree(); public native OrtApi AllocatorFree(AllocatorFree_OrtAllocator_Pointer setter);
  public static class AllocatorGetInfo_OrtAllocator_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    AllocatorGetInfo_OrtAllocator_PointerPointer(Pointer p) { super(p); }
      protected AllocatorGetInfo_OrtAllocator_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtAllocator ptr, @Cast("const OrtMemoryInfo**") PointerPointer out);
  }
  public native AllocatorGetInfo_OrtAllocator_PointerPointer AllocatorGetInfo(); public native OrtApi AllocatorGetInfo(AllocatorGetInfo_OrtAllocator_PointerPointer setter);

  // The returned pointer doesn't have to be freed.
  // Always returns the same instance on every invocation.
  // Please note that this is a non-arena based allocator.
  public static class GetAllocatorWithDefaultOptions_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetAllocatorWithDefaultOptions_PointerPointer(Pointer p) { super(p); }
      protected GetAllocatorWithDefaultOptions_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("OrtAllocator**") PointerPointer out);
  }
  public native GetAllocatorWithDefaultOptions_PointerPointer GetAllocatorWithDefaultOptions(); public native OrtApi GetAllocatorWithDefaultOptions(GetAllocatorWithDefaultOptions_PointerPointer setter);

  // Override symbolic dimensions (by specific denotation strings) with actual values if known at session initialization time to enable
  // optimizations that can take advantage of fixed values (such as memory planning, etc)
  public static class AddFreeDimensionOverride_OrtSessionOptions_BytePointer_long extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    AddFreeDimensionOverride_OrtSessionOptions_BytePointer_long(Pointer p) { super(p); }
      protected AddFreeDimensionOverride_OrtSessionOptions_BytePointer_long() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options, @Cast("const char*") BytePointer dim_denotation,
                    @Cast("int64_t") long dim_value);
  }
  public native AddFreeDimensionOverride_OrtSessionOptions_BytePointer_long AddFreeDimensionOverride(); public native OrtApi AddFreeDimensionOverride(AddFreeDimensionOverride_OrtSessionOptions_BytePointer_long setter);

  /**
   * APIs to support non-tensor types - map and sequence.
   * Currently only the following types are supported
   * Note: the following types should be kept in sync with data_types.h
   * Map types
   * =========
   * std::map<std::string, std::string>
   * std::map<std::string, int64_t>
   * std::map<std::string, float>
   * std::map<std::string, double>
   * std::map<int64_t, std::string>
   * std::map<int64_t, int64_t>
   * std::map<int64_t, float>
   * std::map<int64_t, double>
   *
   * Sequence types
   * ==============
   * std::vector<std::string>
   * std::vector<int64_t>
   * std::vector<float>
   * std::vector<double>
   * std::vector<std::map<std::string, float>>
   * std::vector<std::map<int64_t, float>
   */

  /**
   * If input OrtValue represents a map, you need to retrieve the keys and values
   * separately. Use index=0 to retrieve keys and index=1 to retrieve values.
   * If input OrtValue represents a sequence, use index to retrieve the index'th element
   * of the sequence.
   */
  public static class GetValue_OrtValue_int_OrtAllocator_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetValue_OrtValue_int_OrtAllocator_PointerPointer(Pointer p) { super(p); }
      protected GetValue_OrtValue_int_OrtAllocator_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtValue value, int index, OrtAllocator allocator,
                    @Cast("OrtValue**") PointerPointer out);
  }
  public native GetValue_OrtValue_int_OrtAllocator_PointerPointer GetValue(); public native OrtApi GetValue(GetValue_OrtValue_int_OrtAllocator_PointerPointer setter);

  /**
   * Returns 2 for type map and N for sequence where N is the number of elements
   * in the sequence.
   */
  public static class GetValueCount_OrtValue_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetValueCount_OrtValue_SizeTPointer(Pointer p) { super(p); }
      protected GetValueCount_OrtValue_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtValue value, @Cast("size_t*") SizeTPointer out);
  }
  public native GetValueCount_OrtValue_SizeTPointer GetValueCount(); public native OrtApi GetValueCount(GetValueCount_OrtValue_SizeTPointer setter);

  /**
   * To construct a map, use num_values = 2 and 'in' should be an arrary of 2 OrtValues
   * representing keys and values.
   * To construct a sequence, use num_values = N where N is the number of the elements in the
   * sequence. 'in' should be an arrary of N OrtValues.
   * \value_type should be either map or sequence.
   */
  public static class CreateValue_PointerPointer_long_int_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateValue_PointerPointer_long_int_PointerPointer(Pointer p) { super(p); }
      protected CreateValue_PointerPointer_long_int_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("const OrtValue*const*") PointerPointer in, @Cast("size_t") long num_values,
                    @Cast("ONNXType") int value_type, @Cast("OrtValue**") PointerPointer out);
  }
  public native CreateValue_PointerPointer_long_int_PointerPointer CreateValue(); public native OrtApi CreateValue(CreateValue_PointerPointer_long_int_PointerPointer setter);

  /**
     * Construct OrtValue that contains a value of non-standard type created for
     * experiments or while awaiting standardization. OrtValue in this case would contain
     * an internal representation of the Opaque type. Opaque types are distinguished between
     * each other by two strings 1) domain and 2) type name. The combination of the two
     * must be unique, so the type representation is properly identified internally. The combination
     * must be properly registered from within ORT at both compile/run time or by another API.
     *
     * To construct the OrtValue pass domain and type names, also a pointer to a data container
     * the type of which must be know to both ORT and the client program. That data container may or may
     * not match the internal representation of the Opaque type. The sizeof(data_container) is passed for
     * verification purposes.
     *
     * \domain_name - domain name for the Opaque type, null terminated.
     * \type_name   - type name for the Opaque type, null terminated.
     * \data_contianer - data to populate OrtValue
     * \data_container_size - sizeof() of the data container. Must match the sizeof() of the expected
     *                    data_container size internally.
     */
  public static class CreateOpaqueValue_BytePointer_BytePointer_Pointer_long_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateOpaqueValue_BytePointer_BytePointer_Pointer_long_PointerPointer(Pointer p) { super(p); }
      protected CreateOpaqueValue_BytePointer_BytePointer_Pointer_long_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("const char*") BytePointer domain_name, @Cast("const char*") BytePointer type_name,
                    @Const Pointer data_container, @Cast("size_t") long data_container_size, @Cast("OrtValue**") PointerPointer out);
  }
  public native CreateOpaqueValue_BytePointer_BytePointer_Pointer_long_PointerPointer CreateOpaqueValue(); public native OrtApi CreateOpaqueValue(CreateOpaqueValue_BytePointer_BytePointer_Pointer_long_PointerPointer setter);

  /**
     * Fetch data from an OrtValue that contains a value of non-standard type created for
     * experiments or while awaiting standardization.
     * \domain_name - domain name for the Opaque type, null terminated.
     * \type_name   - type name for the Opaque type, null terminated.
     * \data_contianer - data to populate OrtValue
     * \data_container_size - sizeof() of the data container. Must match the sizeof() of the expected
     *                    data_container size internally.
     */

  public static class GetOpaqueValue_BytePointer_BytePointer_OrtValue_Pointer_long extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetOpaqueValue_BytePointer_BytePointer_OrtValue_Pointer_long(Pointer p) { super(p); }
      protected GetOpaqueValue_BytePointer_BytePointer_OrtValue_Pointer_long() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("const char*") BytePointer domain_name, @Cast("const char*") BytePointer type_name, @Const OrtValue in,
                    Pointer data_container, @Cast("size_t") long data_container_size);
  }
  public native GetOpaqueValue_BytePointer_BytePointer_OrtValue_Pointer_long GetOpaqueValue(); public native OrtApi GetOpaqueValue(GetOpaqueValue_BytePointer_BytePointer_OrtValue_Pointer_long setter);

  public static class KernelInfoGetAttribute_float_OrtKernelInfo_BytePointer_FloatPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    KernelInfoGetAttribute_float_OrtKernelInfo_BytePointer_FloatPointer(Pointer p) { super(p); }
      protected KernelInfoGetAttribute_float_OrtKernelInfo_BytePointer_FloatPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtKernelInfo info, @Cast("const char*") BytePointer name,
                    FloatPointer out);
  }
  public native KernelInfoGetAttribute_float_OrtKernelInfo_BytePointer_FloatPointer KernelInfoGetAttribute_float(); public native OrtApi KernelInfoGetAttribute_float(KernelInfoGetAttribute_float_OrtKernelInfo_BytePointer_FloatPointer setter);
  public static class KernelInfoGetAttribute_int64_OrtKernelInfo_BytePointer_LongPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    KernelInfoGetAttribute_int64_OrtKernelInfo_BytePointer_LongPointer(Pointer p) { super(p); }
      protected KernelInfoGetAttribute_int64_OrtKernelInfo_BytePointer_LongPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtKernelInfo info, @Cast("const char*") BytePointer name,
                    @Cast("int64_t*") LongPointer out);
  }
  public native KernelInfoGetAttribute_int64_OrtKernelInfo_BytePointer_LongPointer KernelInfoGetAttribute_int64(); public native OrtApi KernelInfoGetAttribute_int64(KernelInfoGetAttribute_int64_OrtKernelInfo_BytePointer_LongPointer setter);
  public static class KernelInfoGetAttribute_string_OrtKernelInfo_BytePointer_BytePointer_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    KernelInfoGetAttribute_string_OrtKernelInfo_BytePointer_BytePointer_SizeTPointer(Pointer p) { super(p); }
      protected KernelInfoGetAttribute_string_OrtKernelInfo_BytePointer_BytePointer_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtKernelInfo info, @Cast("const char*") BytePointer name, @Cast("char*") BytePointer out,
                    @Cast("size_t*") SizeTPointer size);
  }
  public native KernelInfoGetAttribute_string_OrtKernelInfo_BytePointer_BytePointer_SizeTPointer KernelInfoGetAttribute_string(); public native OrtApi KernelInfoGetAttribute_string(KernelInfoGetAttribute_string_OrtKernelInfo_BytePointer_BytePointer_SizeTPointer setter);

  public static class KernelContext_GetInputCount_OrtKernelContext_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    KernelContext_GetInputCount_OrtKernelContext_SizeTPointer(Pointer p) { super(p); }
      protected KernelContext_GetInputCount_OrtKernelContext_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtKernelContext context, @Cast("size_t*") SizeTPointer out);
  }
  public native KernelContext_GetInputCount_OrtKernelContext_SizeTPointer KernelContext_GetInputCount(); public native OrtApi KernelContext_GetInputCount(KernelContext_GetInputCount_OrtKernelContext_SizeTPointer setter);
  public static class KernelContext_GetOutputCount_OrtKernelContext_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    KernelContext_GetOutputCount_OrtKernelContext_SizeTPointer(Pointer p) { super(p); }
      protected KernelContext_GetOutputCount_OrtKernelContext_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtKernelContext context, @Cast("size_t*") SizeTPointer out);
  }
  public native KernelContext_GetOutputCount_OrtKernelContext_SizeTPointer KernelContext_GetOutputCount(); public native OrtApi KernelContext_GetOutputCount(KernelContext_GetOutputCount_OrtKernelContext_SizeTPointer setter);
  public static class KernelContext_GetInput_OrtKernelContext_long_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    KernelContext_GetInput_OrtKernelContext_long_PointerPointer(Pointer p) { super(p); }
      protected KernelContext_GetInput_OrtKernelContext_long_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtKernelContext context, @Cast("size_t") long index,
                    @Cast("const OrtValue**") PointerPointer out);
  }
  public native KernelContext_GetInput_OrtKernelContext_long_PointerPointer KernelContext_GetInput(); public native OrtApi KernelContext_GetInput(KernelContext_GetInput_OrtKernelContext_long_PointerPointer setter);
  public static class KernelContext_GetOutput_OrtKernelContext_long_LongPointer_long_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    KernelContext_GetOutput_OrtKernelContext_long_LongPointer_long_PointerPointer(Pointer p) { super(p); }
      protected KernelContext_GetOutput_OrtKernelContext_long_LongPointer_long_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtKernelContext context, @Cast("size_t") long index,
                    @Cast("const int64_t*") LongPointer dim_values, @Cast("size_t") long dim_count, @Cast("OrtValue**") PointerPointer out);
  }
  public native KernelContext_GetOutput_OrtKernelContext_long_LongPointer_long_PointerPointer KernelContext_GetOutput(); public native OrtApi KernelContext_GetOutput(KernelContext_GetOutput_OrtKernelContext_long_LongPointer_long_PointerPointer setter);

  public static class ReleaseEnv_OrtEnv extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseEnv_OrtEnv(Pointer p) { super(p); }
      protected ReleaseEnv_OrtEnv() { allocate(); }
      private native void allocate();
      public native void call(OrtEnv input);
  }
  public native ReleaseEnv_OrtEnv ReleaseEnv(); public native OrtApi ReleaseEnv(ReleaseEnv_OrtEnv setter);
  public static class ReleaseStatus_OrtStatus extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseStatus_OrtStatus(Pointer p) { super(p); }
      protected ReleaseStatus_OrtStatus() { allocate(); }
      private native void allocate();
      public native void call(OrtStatus input);
  }
  public native ReleaseStatus_OrtStatus ReleaseStatus(); public native OrtApi ReleaseStatus(ReleaseStatus_OrtStatus setter);  // nullptr for Status* indicates success
  public static class ReleaseMemoryInfo_OrtMemoryInfo extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseMemoryInfo_OrtMemoryInfo(Pointer p) { super(p); }
      protected ReleaseMemoryInfo_OrtMemoryInfo() { allocate(); }
      private native void allocate();
      public native void call(OrtMemoryInfo input);
  }
  public native ReleaseMemoryInfo_OrtMemoryInfo ReleaseMemoryInfo(); public native OrtApi ReleaseMemoryInfo(ReleaseMemoryInfo_OrtMemoryInfo setter);
  public static class ReleaseSession_OrtSession extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseSession_OrtSession(Pointer p) { super(p); }
      protected ReleaseSession_OrtSession() { allocate(); }
      private native void allocate();
      public native void call(OrtSession input);
  }
  public native ReleaseSession_OrtSession ReleaseSession(); public native OrtApi ReleaseSession(ReleaseSession_OrtSession setter);  //Don't call OrtReleaseSession from Dllmain (because session owns a thread pool)
  public static class ReleaseValue_OrtValue extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseValue_OrtValue(Pointer p) { super(p); }
      protected ReleaseValue_OrtValue() { allocate(); }
      private native void allocate();
      public native void call(OrtValue input);
  }
  public native ReleaseValue_OrtValue ReleaseValue(); public native OrtApi ReleaseValue(ReleaseValue_OrtValue setter);
  public static class ReleaseRunOptions_OrtRunOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseRunOptions_OrtRunOptions(Pointer p) { super(p); }
      protected ReleaseRunOptions_OrtRunOptions() { allocate(); }
      private native void allocate();
      public native void call(OrtRunOptions input);
  }
  public native ReleaseRunOptions_OrtRunOptions ReleaseRunOptions(); public native OrtApi ReleaseRunOptions(ReleaseRunOptions_OrtRunOptions setter);
  public static class ReleaseTypeInfo_OrtTypeInfo extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseTypeInfo_OrtTypeInfo(Pointer p) { super(p); }
      protected ReleaseTypeInfo_OrtTypeInfo() { allocate(); }
      private native void allocate();
      public native void call(OrtTypeInfo input);
  }
  public native ReleaseTypeInfo_OrtTypeInfo ReleaseTypeInfo(); public native OrtApi ReleaseTypeInfo(ReleaseTypeInfo_OrtTypeInfo setter);
  public static class ReleaseTensorTypeAndShapeInfo_OrtTensorTypeAndShapeInfo extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseTensorTypeAndShapeInfo_OrtTensorTypeAndShapeInfo(Pointer p) { super(p); }
      protected ReleaseTensorTypeAndShapeInfo_OrtTensorTypeAndShapeInfo() { allocate(); }
      private native void allocate();
      public native void call(OrtTensorTypeAndShapeInfo input);
  }
  public native ReleaseTensorTypeAndShapeInfo_OrtTensorTypeAndShapeInfo ReleaseTensorTypeAndShapeInfo(); public native OrtApi ReleaseTensorTypeAndShapeInfo(ReleaseTensorTypeAndShapeInfo_OrtTensorTypeAndShapeInfo setter);
  public static class ReleaseSessionOptions_OrtSessionOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseSessionOptions_OrtSessionOptions(Pointer p) { super(p); }
      protected ReleaseSessionOptions_OrtSessionOptions() { allocate(); }
      private native void allocate();
      public native void call(OrtSessionOptions input);
  }
  public native ReleaseSessionOptions_OrtSessionOptions ReleaseSessionOptions(); public native OrtApi ReleaseSessionOptions(ReleaseSessionOptions_OrtSessionOptions setter);
  public static class ReleaseCustomOpDomain_OrtCustomOpDomain extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseCustomOpDomain_OrtCustomOpDomain(Pointer p) { super(p); }
      protected ReleaseCustomOpDomain_OrtCustomOpDomain() { allocate(); }
      private native void allocate();
      public native void call(OrtCustomOpDomain input);
  }
  public native ReleaseCustomOpDomain_OrtCustomOpDomain ReleaseCustomOpDomain(); public native OrtApi ReleaseCustomOpDomain(ReleaseCustomOpDomain_OrtCustomOpDomain setter);

  // End of Version 1 - DO NOT MODIFY ABOVE (see above text for more information)

  // Version 2 - In development, feel free to add/remove/rearrange here

  /**
    * GetDenotationFromTypeInfo
	 * This api augments OrtTypeInfo to return denotations on the type.
	 * This is used by WinML to determine if an input/output is intended to be an Image or a Tensor.
    */
  public static class GetDenotationFromTypeInfo_OrtTypeInfo_PointerPointer_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetDenotationFromTypeInfo_OrtTypeInfo_PointerPointer_SizeTPointer(Pointer p) { super(p); }
      protected GetDenotationFromTypeInfo_OrtTypeInfo_PointerPointer_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtTypeInfo arg0, @Cast("const char**const") PointerPointer denotation,
                    @Cast("size_t*") SizeTPointer len);
  }
  public native GetDenotationFromTypeInfo_OrtTypeInfo_PointerPointer_SizeTPointer GetDenotationFromTypeInfo(); public native OrtApi GetDenotationFromTypeInfo(GetDenotationFromTypeInfo_OrtTypeInfo_PointerPointer_SizeTPointer setter);

  // OrtTypeInfo Casting methods

  /**
    * CastTypeInfoToMapTypeInfo
	 * This api augments OrtTypeInfo to return an OrtMapTypeInfo when the type is a map.
	 * The OrtMapTypeInfo has additional information about the map's key type and value type.
	 * This is used by WinML to support model reflection APIs.
	 * This is used by WinML to support model reflection APIs.
	 *
	 * Don't free the 'out' value
    */
  public static class CastTypeInfoToMapTypeInfo_OrtTypeInfo_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CastTypeInfoToMapTypeInfo_OrtTypeInfo_PointerPointer(Pointer p) { super(p); }
      protected CastTypeInfoToMapTypeInfo_OrtTypeInfo_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtTypeInfo type_info,
                    @Cast("const OrtMapTypeInfo**") PointerPointer out);
  }
  public native CastTypeInfoToMapTypeInfo_OrtTypeInfo_PointerPointer CastTypeInfoToMapTypeInfo(); public native OrtApi CastTypeInfoToMapTypeInfo(CastTypeInfoToMapTypeInfo_OrtTypeInfo_PointerPointer setter);

  /**
    * CastTypeInfoToSequenceTypeInfo
	 * This api augments OrtTypeInfo to return an OrtSequenceTypeInfo when the type is a sequence.
	 * The OrtSequenceTypeInfo has additional information about the sequence's element type.
    * This is used by WinML to support model reflection APIs.
	 *
	 * Don't free the 'out' value
    */
  public static class CastTypeInfoToSequenceTypeInfo_OrtTypeInfo_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CastTypeInfoToSequenceTypeInfo_OrtTypeInfo_PointerPointer(Pointer p) { super(p); }
      protected CastTypeInfoToSequenceTypeInfo_OrtTypeInfo_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtTypeInfo type_info,
                    @Cast("const OrtSequenceTypeInfo**") PointerPointer out);
  }
  public native CastTypeInfoToSequenceTypeInfo_OrtTypeInfo_PointerPointer CastTypeInfoToSequenceTypeInfo(); public native OrtApi CastTypeInfoToSequenceTypeInfo(CastTypeInfoToSequenceTypeInfo_OrtTypeInfo_PointerPointer setter);

  // OrtMapTypeInfo Accessors

  /**
    * GetMapKeyType
	 * This api augments get the key type of a map. Key types are restricted to being scalar types and use ONNXTensorElementDataType.
	 * This is used by WinML to support model reflection APIs.
    */
  public static class GetMapKeyType_OrtMapTypeInfo_IntPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetMapKeyType_OrtMapTypeInfo_IntPointer(Pointer p) { super(p); }
      protected GetMapKeyType_OrtMapTypeInfo_IntPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtMapTypeInfo map_type_info, @Cast("ONNXTensorElementDataType*") IntPointer out);
  }
  public native GetMapKeyType_OrtMapTypeInfo_IntPointer GetMapKeyType(); public native OrtApi GetMapKeyType(GetMapKeyType_OrtMapTypeInfo_IntPointer setter);

  /**
    * GetMapValueType
	 * This api augments get the value type of a map.
    */
  public static class GetMapValueType_OrtMapTypeInfo_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetMapValueType_OrtMapTypeInfo_PointerPointer(Pointer p) { super(p); }
      protected GetMapValueType_OrtMapTypeInfo_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtMapTypeInfo map_type_info, @Cast("OrtTypeInfo**") PointerPointer type_info);
  }
  public native GetMapValueType_OrtMapTypeInfo_PointerPointer GetMapValueType(); public native OrtApi GetMapValueType(GetMapValueType_OrtMapTypeInfo_PointerPointer setter);

  // OrtSequenceTypeInfo Accessors

  /**
    * GetSequenceElementType
	 * This api augments get the element type of a sequence.
	 * This is used by WinML to support model reflection APIs.
    */
  public static class GetSequenceElementType_OrtSequenceTypeInfo_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetSequenceElementType_OrtSequenceTypeInfo_PointerPointer(Pointer p) { super(p); }
      protected GetSequenceElementType_OrtSequenceTypeInfo_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSequenceTypeInfo sequence_type_info,
                    @Cast("OrtTypeInfo**") PointerPointer type_info);
  }
  public native GetSequenceElementType_OrtSequenceTypeInfo_PointerPointer GetSequenceElementType(); public native OrtApi GetSequenceElementType(GetSequenceElementType_OrtSequenceTypeInfo_PointerPointer setter);

  public static class ReleaseMapTypeInfo_OrtMapTypeInfo extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseMapTypeInfo_OrtMapTypeInfo(Pointer p) { super(p); }
      protected ReleaseMapTypeInfo_OrtMapTypeInfo() { allocate(); }
      private native void allocate();
      public native void call(OrtMapTypeInfo input);
  }
  public native ReleaseMapTypeInfo_OrtMapTypeInfo ReleaseMapTypeInfo(); public native OrtApi ReleaseMapTypeInfo(ReleaseMapTypeInfo_OrtMapTypeInfo setter);
  public static class ReleaseSequenceTypeInfo_OrtSequenceTypeInfo extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseSequenceTypeInfo_OrtSequenceTypeInfo(Pointer p) { super(p); }
      protected ReleaseSequenceTypeInfo_OrtSequenceTypeInfo() { allocate(); }
      private native void allocate();
      public native void call(OrtSequenceTypeInfo input);
  }
  public native ReleaseSequenceTypeInfo_OrtSequenceTypeInfo ReleaseSequenceTypeInfo(); public native OrtApi ReleaseSequenceTypeInfo(ReleaseSequenceTypeInfo_OrtSequenceTypeInfo setter);

  /**
   * @param out is set to a null terminated string allocated using 'allocator'. The caller is responsible for freeing it.
   * Profiling is turned ON automatically if enabled for the particular session by invoking EnableProfiling()
   * on the SessionOptions instance used to create the session.
   */
  public static class SessionEndProfiling_OrtSession_OrtAllocator_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionEndProfiling_OrtSession_OrtAllocator_PointerPointer(Pointer p) { super(p); }
      protected SessionEndProfiling_OrtSession_OrtAllocator_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSession sess, OrtAllocator allocator, @Cast("char**") PointerPointer out);
  }
  public native SessionEndProfiling_OrtSession_OrtAllocator_PointerPointer SessionEndProfiling(); public native OrtApi SessionEndProfiling(SessionEndProfiling_OrtSession_OrtAllocator_PointerPointer setter);

  /**
   * @param out is a pointer to the newly created object. The pointer should be freed by calling ReleaseModelMetadata after use.
   */
  public static class SessionGetModelMetadata_OrtSession_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionGetModelMetadata_OrtSession_PointerPointer(Pointer p) { super(p); }
      protected SessionGetModelMetadata_OrtSession_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSession sess, @Cast("OrtModelMetadata**") PointerPointer out);
  }
  public native SessionGetModelMetadata_OrtSession_PointerPointer SessionGetModelMetadata(); public native OrtApi SessionGetModelMetadata(SessionGetModelMetadata_OrtSession_PointerPointer setter);

  /**
   * @param value  is set to a null terminated string allocated using 'allocator'. The caller is responsible for freeing it.
   */
  public static class ModelMetadataGetProducerName_OrtModelMetadata_OrtAllocator_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ModelMetadataGetProducerName_OrtModelMetadata_OrtAllocator_PointerPointer(Pointer p) { super(p); }
      protected ModelMetadataGetProducerName_OrtModelMetadata_OrtAllocator_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtModelMetadata model_metadata,
                    OrtAllocator allocator, @Cast("char**") PointerPointer value);
  }
  public native ModelMetadataGetProducerName_OrtModelMetadata_OrtAllocator_PointerPointer ModelMetadataGetProducerName(); public native OrtApi ModelMetadataGetProducerName(ModelMetadataGetProducerName_OrtModelMetadata_OrtAllocator_PointerPointer setter);
  public static class ModelMetadataGetGraphName_OrtModelMetadata_OrtAllocator_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ModelMetadataGetGraphName_OrtModelMetadata_OrtAllocator_PointerPointer(Pointer p) { super(p); }
      protected ModelMetadataGetGraphName_OrtModelMetadata_OrtAllocator_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtModelMetadata model_metadata,
                    OrtAllocator allocator, @Cast("char**") PointerPointer value);
  }
  public native ModelMetadataGetGraphName_OrtModelMetadata_OrtAllocator_PointerPointer ModelMetadataGetGraphName(); public native OrtApi ModelMetadataGetGraphName(ModelMetadataGetGraphName_OrtModelMetadata_OrtAllocator_PointerPointer setter);
  public static class ModelMetadataGetDomain_OrtModelMetadata_OrtAllocator_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ModelMetadataGetDomain_OrtModelMetadata_OrtAllocator_PointerPointer(Pointer p) { super(p); }
      protected ModelMetadataGetDomain_OrtModelMetadata_OrtAllocator_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtModelMetadata model_metadata, OrtAllocator allocator,
                    @Cast("char**") PointerPointer value);
  }
  public native ModelMetadataGetDomain_OrtModelMetadata_OrtAllocator_PointerPointer ModelMetadataGetDomain(); public native OrtApi ModelMetadataGetDomain(ModelMetadataGetDomain_OrtModelMetadata_OrtAllocator_PointerPointer setter);
  public static class ModelMetadataGetDescription_OrtModelMetadata_OrtAllocator_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ModelMetadataGetDescription_OrtModelMetadata_OrtAllocator_PointerPointer(Pointer p) { super(p); }
      protected ModelMetadataGetDescription_OrtModelMetadata_OrtAllocator_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtModelMetadata model_metadata,
                    OrtAllocator allocator, @Cast("char**") PointerPointer value);
  }
  public native ModelMetadataGetDescription_OrtModelMetadata_OrtAllocator_PointerPointer ModelMetadataGetDescription(); public native OrtApi ModelMetadataGetDescription(ModelMetadataGetDescription_OrtModelMetadata_OrtAllocator_PointerPointer setter);
  /**
   * @param value  is set to a null terminated string allocated using 'allocator'. The caller is responsible for freeing it.
   * 'value' will be a nullptr if the given key is not found in the custom metadata map.
   */
  public static class ModelMetadataLookupCustomMetadataMap_OrtModelMetadata_OrtAllocator_BytePointer_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ModelMetadataLookupCustomMetadataMap_OrtModelMetadata_OrtAllocator_BytePointer_PointerPointer(Pointer p) { super(p); }
      protected ModelMetadataLookupCustomMetadataMap_OrtModelMetadata_OrtAllocator_BytePointer_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtModelMetadata model_metadata,
                    OrtAllocator allocator, @Cast("const char*") BytePointer key, @Cast("char**") PointerPointer value);
  }
  public native ModelMetadataLookupCustomMetadataMap_OrtModelMetadata_OrtAllocator_BytePointer_PointerPointer ModelMetadataLookupCustomMetadataMap(); public native OrtApi ModelMetadataLookupCustomMetadataMap(ModelMetadataLookupCustomMetadataMap_OrtModelMetadata_OrtAllocator_BytePointer_PointerPointer setter);

  public static class ModelMetadataGetVersion_OrtModelMetadata_LongPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ModelMetadataGetVersion_OrtModelMetadata_LongPointer(Pointer p) { super(p); }
      protected ModelMetadataGetVersion_OrtModelMetadata_LongPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtModelMetadata model_metadata, @Cast("int64_t*") LongPointer value);
  }
  public native ModelMetadataGetVersion_OrtModelMetadata_LongPointer ModelMetadataGetVersion(); public native OrtApi ModelMetadataGetVersion(ModelMetadataGetVersion_OrtModelMetadata_LongPointer setter);

  public static class ReleaseModelMetadata_OrtModelMetadata extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseModelMetadata_OrtModelMetadata(Pointer p) { super(p); }
      protected ReleaseModelMetadata_OrtModelMetadata() { allocate(); }
      private native void allocate();
      public native void call(OrtModelMetadata input);
  }
  public native ReleaseModelMetadata_OrtModelMetadata ReleaseModelMetadata(); public native OrtApi ReleaseModelMetadata(ReleaseModelMetadata_OrtModelMetadata setter);

  /*
  * Creates an environment with global threadpools that will be shared across sessions.
  * Use this in conjunction with DisablePerSessionThreads API or else the session will use
  * its own thread pools.
  */
  public static class CreateEnvWithGlobalThreadPools_int_BytePointer_OrtThreadingOptions_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateEnvWithGlobalThreadPools_int_BytePointer_OrtThreadingOptions_PointerPointer(Pointer p) { super(p); }
      protected CreateEnvWithGlobalThreadPools_int_BytePointer_OrtThreadingOptions_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("OrtLoggingLevel") int logging_level, @Cast("const char*") BytePointer logid,
                    @Const OrtThreadingOptions t_options, @Cast("OrtEnv**") PointerPointer out);
  }
  public native CreateEnvWithGlobalThreadPools_int_BytePointer_OrtThreadingOptions_PointerPointer CreateEnvWithGlobalThreadPools(); public native OrtApi CreateEnvWithGlobalThreadPools(CreateEnvWithGlobalThreadPools_int_BytePointer_OrtThreadingOptions_PointerPointer setter);

  /*
  * Calling this API will make the session use the global threadpools shared across sessions.
  * This API should be used in conjunction with CreateEnvWithGlobalThreadPools API.
  */
  public static class DisablePerSessionThreads_OrtSessionOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    DisablePerSessionThreads_OrtSessionOptions(Pointer p) { super(p); }
      protected DisablePerSessionThreads_OrtSessionOptions() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options);
  }
  public native DisablePerSessionThreads_OrtSessionOptions DisablePerSessionThreads(); public native OrtApi DisablePerSessionThreads(DisablePerSessionThreads_OrtSessionOptions setter);

  public static class CreateThreadingOptions_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateThreadingOptions_PointerPointer(Pointer p) { super(p); }
      protected CreateThreadingOptions_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("OrtThreadingOptions**") PointerPointer out);
  }
  public native CreateThreadingOptions_PointerPointer CreateThreadingOptions(); public native OrtApi CreateThreadingOptions(CreateThreadingOptions_PointerPointer setter);

  public static class ReleaseThreadingOptions_OrtThreadingOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseThreadingOptions_OrtThreadingOptions(Pointer p) { super(p); }
      protected ReleaseThreadingOptions_OrtThreadingOptions() { allocate(); }
      private native void allocate();
      public native void call(OrtThreadingOptions input);
  }
  public native ReleaseThreadingOptions_OrtThreadingOptions ReleaseThreadingOptions(); public native OrtApi ReleaseThreadingOptions(ReleaseThreadingOptions_OrtThreadingOptions setter);

  /**
   * @param num_keys contains the number of keys in the custom metadata map
   * @param keys is an array of null terminated strings (array count = num_keys) allocated using 'allocator'.
   * The caller is responsible for freeing each string and the pointer array.
   * 'keys' will be a nullptr if custom metadata map is empty.
   */
  public static class ModelMetadataGetCustomMetadataMapKeys_OrtModelMetadata_OrtAllocator_PointerPointer_LongPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ModelMetadataGetCustomMetadataMapKeys_OrtModelMetadata_OrtAllocator_PointerPointer_LongPointer(Pointer p) { super(p); }
      protected ModelMetadataGetCustomMetadataMapKeys_OrtModelMetadata_OrtAllocator_PointerPointer_LongPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtModelMetadata model_metadata,
                    OrtAllocator allocator, @Cast("char***") @ByPtrPtr PointerPointer keys, @Cast("int64_t*") LongPointer num_keys);
  }
  public native ModelMetadataGetCustomMetadataMapKeys_OrtModelMetadata_OrtAllocator_PointerPointer_LongPointer ModelMetadataGetCustomMetadataMapKeys(); public native OrtApi ModelMetadataGetCustomMetadataMapKeys(ModelMetadataGetCustomMetadataMapKeys_OrtModelMetadata_OrtAllocator_PointerPointer_LongPointer setter);

  // Override symbolic dimensions (by specific name strings) with actual values
  // if known at session initialization time to enable optimizations that can
  // take advantage of fixed values (such as memory planning, etc)
  public static class AddFreeDimensionOverrideByName_OrtSessionOptions_BytePointer_long extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    AddFreeDimensionOverrideByName_OrtSessionOptions_BytePointer_long(Pointer p) { super(p); }
      protected AddFreeDimensionOverrideByName_OrtSessionOptions_BytePointer_long() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call(
                    OrtSessionOptions options, @Cast("const char*") BytePointer dim_name,
                    @Cast("int64_t") long dim_value);
  }
  public native AddFreeDimensionOverrideByName_OrtSessionOptions_BytePointer_long AddFreeDimensionOverrideByName(); public native OrtApi AddFreeDimensionOverrideByName(AddFreeDimensionOverrideByName_OrtSessionOptions_BytePointer_long setter);

  /**
   * @param out_ptr will hold a pointer to the array of char *
   * representing available providers.
   * @param provider_length is a pointer to an int variable where
   * the number of available providers will be added.
   * The caller is responsible for freeing each char * and the pointer
   * array by calling ReleaseAvailableProviders().
   */
  public static class GetAvailableProviders_PointerPointer_IntPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetAvailableProviders_PointerPointer_IntPointer(Pointer p) { super(p); }
      protected GetAvailableProviders_PointerPointer_IntPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("char***") @ByPtrPtr PointerPointer out_ptr,
                    IntPointer provider_length);
  }
  public native GetAvailableProviders_PointerPointer_IntPointer GetAvailableProviders(); public native OrtApi GetAvailableProviders(GetAvailableProviders_PointerPointer_IntPointer setter);

  /**
   * @param ptr is the pointer to an array of available providers you
   * get after calling GetAvailableProviders().
   * @param providers_length is the number of available providers.
   */
  public static class ReleaseAvailableProviders_PointerPointer_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseAvailableProviders_PointerPointer_int(Pointer p) { super(p); }
      protected ReleaseAvailableProviders_PointerPointer_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("char**") PointerPointer ptr,
                    int providers_length);
  }
  public native ReleaseAvailableProviders_PointerPointer_int ReleaseAvailableProviders(); public native OrtApi ReleaseAvailableProviders(ReleaseAvailableProviders_PointerPointer_int setter);

  /**
     * @param value - A tensor created from OrtCreateTensor... function.
     * @param index - index of string tensor element, length of element at index will be returned.
     * @param out - number of UTF-8 bytes that the string contains
     */
  public static class GetStringTensorElementLength_OrtValue_long_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetStringTensorElementLength_OrtValue_long_SizeTPointer(Pointer p) { super(p); }
      protected GetStringTensorElementLength_OrtValue_long_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtValue value, @Cast("size_t") long index, @Cast("size_t*") SizeTPointer out);
  }
  public native GetStringTensorElementLength_OrtValue_long_SizeTPointer GetStringTensorElementLength(); public native OrtApi GetStringTensorElementLength(GetStringTensorElementLength_OrtValue_long_SizeTPointer setter);

  /**
     * @param s string element contents in UTF-8 encoding. The string is NOT null-terminated.
     * @param value A tensor created from OrtCreateTensor... function.
     * @param s_len element length, get it from OrtGetStringTensorElementLength.
     * @param index offset of element of tensor to return.
     */
  public static class GetStringTensorElement_OrtValue_long_long_Pointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetStringTensorElement_OrtValue_long_long_Pointer(Pointer p) { super(p); }
      protected GetStringTensorElement_OrtValue_long_long_Pointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtValue value, @Cast("size_t") long s_len, @Cast("size_t") long index, Pointer s);
  }
  public native GetStringTensorElement_OrtValue_long_long_Pointer GetStringTensorElement(); public native OrtApi GetStringTensorElement(GetStringTensorElement_OrtValue_long_long_Pointer setter);

  /**
     * @param value - A tensor created from OrtCreateTensor... function.
     * @param s - A null terminated UTF-8 encoded string.
     * @param index - index of string tensor element to fill
     */
  public static class FillStringTensorElement_OrtValue_BytePointer_long extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    FillStringTensorElement_OrtValue_BytePointer_long(Pointer p) { super(p); }
      protected FillStringTensorElement_OrtValue_BytePointer_long() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtValue value, @Cast("const char*") BytePointer s, @Cast("size_t") long index);
  }
  public native FillStringTensorElement_OrtValue_BytePointer_long FillStringTensorElement(); public native OrtApi FillStringTensorElement(FillStringTensorElement_OrtValue_BytePointer_long setter);

  /**
     * Set a single session configuration entry as a pair of strings
     * If a configuration with same key exists, this will overwrite the configuration with the given config_value
     * @param config_key    A null terminated string representation of the config key
     * @param config_value  A null terminated string representation of the config value
     * The config_key and the format of config_value are defined in onnxruntime_session_options_config_keys.h
     */
  public static class AddSessionConfigEntry_OrtSessionOptions_BytePointer_BytePointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    AddSessionConfigEntry_OrtSessionOptions_BytePointer_BytePointer(Pointer p) { super(p); }
      protected AddSessionConfigEntry_OrtSessionOptions_BytePointer_BytePointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options,
                    @Cast("const char*") BytePointer config_key, @Cast("const char*") BytePointer config_value);
  }
  public native AddSessionConfigEntry_OrtSessionOptions_BytePointer_BytePointer AddSessionConfigEntry(); public native OrtApi AddSessionConfigEntry(AddSessionConfigEntry_OrtSessionOptions_BytePointer_BytePointer setter);

  /**
   * @param sess valid OrtSession instance
   * @param mem_info - valid OrtMemoryInfo instance
   * @param - out a ptr to a new instance of OrtAllocator according to the spec within mem_info
   *         if successful
   * @return OrtStatus or nullptr if successful
   */
  public static class CreateAllocator_OrtSession_OrtMemoryInfo_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateAllocator_OrtSession_OrtMemoryInfo_PointerPointer(Pointer p) { super(p); }
      protected CreateAllocator_OrtSession_OrtMemoryInfo_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSession sess, @Const OrtMemoryInfo mem_info,
                    @Cast("OrtAllocator**") PointerPointer out);
  }
  public native CreateAllocator_OrtSession_OrtMemoryInfo_PointerPointer CreateAllocator(); public native OrtApi CreateAllocator(CreateAllocator_OrtSession_OrtMemoryInfo_PointerPointer setter);

  // Release instance of OrtAllocator obtained from CreateAllocator API
  public static class ReleaseAllocator_OrtAllocator extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseAllocator_OrtAllocator(Pointer p) { super(p); }
      protected ReleaseAllocator_OrtAllocator() { allocate(); }
      private native void allocate();
      public native void call(OrtAllocator input);
  }
  public native ReleaseAllocator_OrtAllocator ReleaseAllocator(); public native OrtApi ReleaseAllocator(ReleaseAllocator_OrtAllocator setter);

  public static class RunWithBinding_OrtSession_OrtRunOptions_OrtIoBinding extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    RunWithBinding_OrtSession_OrtRunOptions_OrtIoBinding(Pointer p) { super(p); }
      protected RunWithBinding_OrtSession_OrtRunOptions_OrtIoBinding() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSession sess, @Const OrtRunOptions run_options, @Const OrtIoBinding binding_ptr);
  }
  public native RunWithBinding_OrtSession_OrtRunOptions_OrtIoBinding RunWithBinding(); public native OrtApi RunWithBinding(RunWithBinding_OrtSession_OrtRunOptions_OrtIoBinding setter);

  // Creates an IoBinding instance that allows one to bind pre-allocated OrtValues
  // to input names. Thus if you want to use a raw on device buffer as input or output
  // you can avoid extra copy during runtime.
  public static class CreateIoBinding_OrtSession_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateIoBinding_OrtSession_PointerPointer(Pointer p) { super(p); }
      protected CreateIoBinding_OrtSession_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSession sess, @Cast("OrtIoBinding**") PointerPointer out);
  }
  public native CreateIoBinding_OrtSession_PointerPointer CreateIoBinding(); public native OrtApi CreateIoBinding(CreateIoBinding_OrtSession_PointerPointer setter);

  // Release instance or OrtIoBinding obtained from CreateIoBinding API
  public static class ReleaseIoBinding_OrtIoBinding extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseIoBinding_OrtIoBinding(Pointer p) { super(p); }
      protected ReleaseIoBinding_OrtIoBinding() { allocate(); }
      private native void allocate();
      public native void call(OrtIoBinding input);
  }
  public native ReleaseIoBinding_OrtIoBinding ReleaseIoBinding(); public native OrtApi ReleaseIoBinding(ReleaseIoBinding_OrtIoBinding setter);

  /**
   * The function will bind the OrtValue to a specified input name.
   * The OrtValue must be a Tensor. ORT would use that value in place of input for the specified name.
   * @param binding_ptr - an instance of OrtIoBinding created by CreateIoBinding()
   * @param name - name for the model input
   * @param  val_ptr - OrtValue of Tensor type.
   * @return OrtStatus instance on error which the caller is responsible to free or nullptr on success
   */
  public static class BindInput_OrtIoBinding_BytePointer_OrtValue extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    BindInput_OrtIoBinding_BytePointer_OrtValue(Pointer p) { super(p); }
      protected BindInput_OrtIoBinding_BytePointer_OrtValue() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtIoBinding binding_ptr, @Cast("const char*") BytePointer name, @Const OrtValue val_ptr);
  }
  public native BindInput_OrtIoBinding_BytePointer_OrtValue BindInput(); public native OrtApi BindInput(BindInput_OrtIoBinding_BytePointer_OrtValue setter);

  /**
   * The function will bind the OrtValue to the specified output name.
   * The OrtValue must be a Tensor. ORT would use that value in place of output for the specified name.
   *
   * @param binding_ptr - an instance of OrtIoBinding created by CreateIoBinding()
   * @param name - name for the model output
   * @param  val_ptr - OrtValue of Tensor type.
   * @return OrtStatus instance on error which the caller is responsible to free or nullptr on success
   */
  public static class BindOutput_OrtIoBinding_BytePointer_OrtValue extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    BindOutput_OrtIoBinding_BytePointer_OrtValue(Pointer p) { super(p); }
      protected BindOutput_OrtIoBinding_BytePointer_OrtValue() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtIoBinding binding_ptr, @Cast("const char*") BytePointer name, @Const OrtValue val_ptr);
  }
  public native BindOutput_OrtIoBinding_BytePointer_OrtValue BindOutput(); public native OrtApi BindOutput(BindOutput_OrtIoBinding_BytePointer_OrtValue setter);

  /**
   * The function will bind the OrtValue to a device which specification is contained within OrtMemoryInfo
   * You can either create an instance of OrtMemoryInfo with a device id or obtain one from the allocator that you are created/using
   * This is useful when one or more outputs have dynamic shapes and, it is hard to pre-allocated and bind a chunk of
   * memory within OrtValue ahead of time.
   *
   * @param binding_ptr - an instance of OrtIoBinding created by CreateIoBinding()
   * @param name - name for the model output
   * @param  mem_info_ptr - OrtMemoryInfo
   * @return OrtStatus instance on error which the caller is responsible to free or nullptr on success
   */
  public static class BindOutputToDevice_OrtIoBinding_BytePointer_OrtMemoryInfo extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    BindOutputToDevice_OrtIoBinding_BytePointer_OrtMemoryInfo(Pointer p) { super(p); }
      protected BindOutputToDevice_OrtIoBinding_BytePointer_OrtMemoryInfo() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtIoBinding binding_ptr, @Cast("const char*") BytePointer name, @Const OrtMemoryInfo val_ptr);
  }
  public native BindOutputToDevice_OrtIoBinding_BytePointer_OrtMemoryInfo BindOutputToDevice(); public native OrtApi BindOutputToDevice(BindOutputToDevice_OrtIoBinding_BytePointer_OrtMemoryInfo setter);

  /**
    * The function returns the names of the outputs in the order they were bound. This is useful after running the model
    * with bound outputs because the returned names are in order in which output OrtValues are returned. This API is optional
    * to use. If you knew the order of outputs and its names you used for binding you would not need to use this API.
    *
    * @param  binding_ptr - a ptr to an instance of OrtIoBinding created obtained from CreateIoBinding()
    * @param  allocator - a ptr to an instance of OrtAllocator obtained with CreateAllocator() or GetAllocatorWithDefaultOptions()
    *                      the specified allocator will be used to allocate continuous buffers for output strings and lengths.
    * @param buffer - pointer to a continuous buffer of non-zero terminated UTF-8 encoded strings. The number of strings stored is returned count parameter.
    *                 this buffer will be allocated with the specified allocator and must be freed after it is no longer needed.
    * @param lengths - a pointer to a continuous buffer of size_t lengths of strings returned in the buffer. The number of items is returned
    *                  in the count. This buffer is allocated with the specified allocator and must be freed after it is no longer needed.
    * \para count - is the number of strings returned. If the instance of OrtIoBiding has no bound outputs, zero is returned,
    *              no memory allocation is performed and buffer and lengths are nullptr on return.
    */
  public static class GetBoundOutputNames_OrtIoBinding_OrtAllocator_PointerPointer_PointerPointer_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetBoundOutputNames_OrtIoBinding_OrtAllocator_PointerPointer_PointerPointer_SizeTPointer(Pointer p) { super(p); }
      protected GetBoundOutputNames_OrtIoBinding_OrtAllocator_PointerPointer_PointerPointer_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtIoBinding binding_ptr, OrtAllocator allocator,
                    @Cast("char**") PointerPointer buffer, @Cast("size_t**") PointerPointer lengths, @Cast("size_t*") SizeTPointer count);
  }
  public native GetBoundOutputNames_OrtIoBinding_OrtAllocator_PointerPointer_PointerPointer_SizeTPointer GetBoundOutputNames(); public native OrtApi GetBoundOutputNames(GetBoundOutputNames_OrtIoBinding_OrtAllocator_PointerPointer_PointerPointer_SizeTPointer setter);

  /**
    * The function returns an array of pointers to individually allocated OrtValues that contain results of a model execution with RunWithBinding()
    * The array contains the same number of OrtValues and they are in the same order as they were bound with BindOutput()
    * or BindOutputToDevice().
    * The returned OrtValues must be individually released after they are no longer needed.
    * The array is allocated using the specified instance of the allocator and must be freed using the same allocator after
    * all the OrtValues contained therein are individually released.
    *
    * @param binding_ptr - instance of OrtIoBidning
    * @param allocator - instance of allocator to allocate output array
    * @param output - pointer to the allocated buffer. Returns nullptr if no outputs.
    * @param output_count - pointer to the number of OrtValues returned. Zero if no outputs.
    */
  public static class GetBoundOutputValues_OrtIoBinding_OrtAllocator_PointerPointer_SizeTPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetBoundOutputValues_OrtIoBinding_OrtAllocator_PointerPointer_SizeTPointer(Pointer p) { super(p); }
      protected GetBoundOutputValues_OrtIoBinding_OrtAllocator_PointerPointer_SizeTPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtIoBinding binding_ptr, OrtAllocator allocator,
                    @Cast("OrtValue***") @ByPtrPtr PointerPointer output, @Cast("size_t*") SizeTPointer output_count);
  }
  public native GetBoundOutputValues_OrtIoBinding_OrtAllocator_PointerPointer_SizeTPointer GetBoundOutputValues(); public native OrtApi GetBoundOutputValues(GetBoundOutputValues_OrtIoBinding_OrtAllocator_PointerPointer_SizeTPointer setter);

  /** Clears any previously specified bindings for inputs/outputs
   */
  public static class ClearBoundInputs_OrtIoBinding extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ClearBoundInputs_OrtIoBinding(Pointer p) { super(p); }
      protected ClearBoundInputs_OrtIoBinding() { allocate(); }
      private native void allocate();
      public native void call(OrtIoBinding binding_ptr);
  }
  public native ClearBoundInputs_OrtIoBinding ClearBoundInputs(); public native OrtApi ClearBoundInputs(ClearBoundInputs_OrtIoBinding setter);
  public static class ClearBoundOutputs_OrtIoBinding extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ClearBoundOutputs_OrtIoBinding(Pointer p) { super(p); }
      protected ClearBoundOutputs_OrtIoBinding() { allocate(); }
      private native void allocate();
      public native void call(OrtIoBinding binding_ptr);
  }
  public native ClearBoundOutputs_OrtIoBinding ClearBoundOutputs(); public native OrtApi ClearBoundOutputs(ClearBoundOutputs_OrtIoBinding setter);

  /**
   * Provides element-level access into a tensor.
   * @param location_values a pointer to an array of index values that specify an element's location in the tensor data blob
   * @param location_values_count length of location_values
   * @param out a pointer to the element specified by location_values
   * e.g.
   * Given a tensor with overall shape [3,224,224], an element at
   * location [2,150,128] can be accessed directly.
   *
   * This function only works for numeric tensors.
   * This is a no-copy method whose pointer is only valid until the backing OrtValue is free'd.
   */
  public static class TensorAt_OrtValue_LongPointer_long_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    TensorAt_OrtValue_LongPointer_long_PointerPointer(Pointer p) { super(p); }
      protected TensorAt_OrtValue_LongPointer_long_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtValue value, @Cast("const int64_t*") LongPointer location_values, @Cast("size_t") long location_values_count, @Cast("void**") PointerPointer out);
  }
  public native TensorAt_OrtValue_LongPointer_long_PointerPointer TensorAt(); public native OrtApi TensorAt(TensorAt_OrtValue_LongPointer_long_PointerPointer setter);

  /**
   * Creates an allocator instance and registers it with the env to enable
   * sharing between multiple sessions that use the same env instance.
   * Lifetime of the created allocator will be valid for the duration of the environment.
   * Returns an error if an allocator with the same OrtMemoryInfo is already registered.
   * @param mem_info must be non-null.
   * @param arena_cfg if nullptr defaults will be used.
   * See docs/C_API.md for details.
  */
  public static class CreateAndRegisterAllocator_OrtEnv_OrtMemoryInfo_OrtArenaCfg extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateAndRegisterAllocator_OrtEnv_OrtMemoryInfo_OrtArenaCfg(Pointer p) { super(p); }
      protected CreateAndRegisterAllocator_OrtEnv_OrtMemoryInfo_OrtArenaCfg() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtEnv env, @Const OrtMemoryInfo mem_info,
                    @Const OrtArenaCfg arena_cfg);
  }
  public native CreateAndRegisterAllocator_OrtEnv_OrtMemoryInfo_OrtArenaCfg CreateAndRegisterAllocator(); public native OrtApi CreateAndRegisterAllocator(CreateAndRegisterAllocator_OrtEnv_OrtMemoryInfo_OrtArenaCfg setter);

  /**
   * Set the language projection for collecting telemetry data when Env is created
   * @param projection the source projected language.
  */
  public static class SetLanguageProjection_OrtEnv_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetLanguageProjection_OrtEnv_int(Pointer p) { super(p); }
      protected SetLanguageProjection_OrtEnv_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtEnv ort_env, @Cast("OrtLanguageProjection") int projection);
  }
  public native SetLanguageProjection_OrtEnv_int SetLanguageProjection(); public native OrtApi SetLanguageProjection(SetLanguageProjection_OrtEnv_int setter);

  /**
   * On some platforms, this timer may not be as precise as nanoseconds
   * For instance, on Windows and MacOS, the precision will be ~100ns
   * @param out is set to the nanoseconds of profiling's start time
   */
  public static class SessionGetProfilingStartTimeNs_OrtSession_LongPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionGetProfilingStartTimeNs_OrtSession_LongPointer(Pointer p) { super(p); }
      protected SessionGetProfilingStartTimeNs_OrtSession_LongPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtSession sess, @Cast("uint64_t*") LongPointer out);
  }
  public native SessionGetProfilingStartTimeNs_OrtSession_LongPointer SessionGetProfilingStartTimeNs(); public native OrtApi SessionGetProfilingStartTimeNs(SessionGetProfilingStartTimeNs_OrtSession_LongPointer setter);

  /**
   * Use this API to configure the global thread pool options to be used in the call to CreateEnvWithGlobalThreadPools.
   * A value of 0 means ORT will pick the default.
   * A value of 1 means the invoking thread will be used; no threads will be created in the thread pool.
   */
  public static class SetGlobalIntraOpNumThreads_OrtThreadingOptions_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetGlobalIntraOpNumThreads_OrtThreadingOptions_int(Pointer p) { super(p); }
      protected SetGlobalIntraOpNumThreads_OrtThreadingOptions_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtThreadingOptions tp_options, int intra_op_num_threads);
  }
  public native SetGlobalIntraOpNumThreads_OrtThreadingOptions_int SetGlobalIntraOpNumThreads(); public native OrtApi SetGlobalIntraOpNumThreads(SetGlobalIntraOpNumThreads_OrtThreadingOptions_int setter);
  public static class SetGlobalInterOpNumThreads_OrtThreadingOptions_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetGlobalInterOpNumThreads_OrtThreadingOptions_int(Pointer p) { super(p); }
      protected SetGlobalInterOpNumThreads_OrtThreadingOptions_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtThreadingOptions tp_options, int inter_op_num_threads);
  }
  public native SetGlobalInterOpNumThreads_OrtThreadingOptions_int SetGlobalInterOpNumThreads(); public native OrtApi SetGlobalInterOpNumThreads(SetGlobalInterOpNumThreads_OrtThreadingOptions_int setter);

  /**
   * Use this API to configure the global thread pool options to be used in the call to CreateEnvWithGlobalThreadPools.
   * Allow spinning of thread pools when their queues are empty. This API will set the value for both
   * inter_op and intra_op threadpools.
   * @param allow_spinning valid values are 1 and 0.
   * 1: threadpool will spin to wait for queue to become non-empty, 0: it won't spin.
   * Prefer a value of 0 if your CPU usage is very high.
   */
  public static class SetGlobalSpinControl_OrtThreadingOptions_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetGlobalSpinControl_OrtThreadingOptions_int(Pointer p) { super(p); }
      protected SetGlobalSpinControl_OrtThreadingOptions_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtThreadingOptions tp_options, int allow_spinning);
  }
  public native SetGlobalSpinControl_OrtThreadingOptions_int SetGlobalSpinControl(); public native OrtApi SetGlobalSpinControl(SetGlobalSpinControl_OrtThreadingOptions_int setter);

  /**
   * Add a pre-allocated initializer to a session. If a model contains an initializer with a name
   * that is same as the name passed to this API call, ORT will use this initializer instance
   * instead of deserializing one from the model file. This is useful when you want to share
   * the same initializer across sessions.
   * @param name name of the initializer
   * @param val OrtValue containing the initializer. Lifetime of 'val' and the underlying initializer buffer must be
   * managed by the user (created using the CreateTensorWithDataAsOrtValue API) and it must outlive the session object
   * to which it is added.
   */
  public static class AddInitializer_OrtSessionOptions_BytePointer_OrtValue extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    AddInitializer_OrtSessionOptions_BytePointer_OrtValue(Pointer p) { super(p); }
      protected AddInitializer_OrtSessionOptions_BytePointer_OrtValue() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtSessionOptions options, @Cast("const char*") BytePointer name,
                    @Const OrtValue val);
  }
  public native AddInitializer_OrtSessionOptions_BytePointer_OrtValue AddInitializer(); public native OrtApi AddInitializer(AddInitializer_OrtSessionOptions_BytePointer_OrtValue setter);

  /**
   * Creates a custom environment with global threadpools and logger that will be shared across sessions.
   * Use this in conjunction with DisablePerSessionThreads API or else the session will use
   * its own thread pools.
   *
   * @param out should be freed by {@code OrtReleaseEnv} after use
   */
  public static class CreateEnvWithCustomLoggerAndGlobalThreadPools_OrtLoggingFunction_Pointer_int_BytePointer_OrtThreadingOptions_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateEnvWithCustomLoggerAndGlobalThreadPools_OrtLoggingFunction_Pointer_int_BytePointer_OrtThreadingOptions_PointerPointer(Pointer p) { super(p); }
      protected CreateEnvWithCustomLoggerAndGlobalThreadPools_OrtLoggingFunction_Pointer_int_BytePointer_OrtThreadingOptions_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtLoggingFunction logging_function, Pointer logger_param, @Cast("OrtLoggingLevel") int logging_level,
                    @Cast("const char*") BytePointer logid, @Const OrtThreadingOptions tp_options, @Cast("OrtEnv**") PointerPointer out);
  }
  public native CreateEnvWithCustomLoggerAndGlobalThreadPools_OrtLoggingFunction_Pointer_int_BytePointer_OrtThreadingOptions_PointerPointer CreateEnvWithCustomLoggerAndGlobalThreadPools(); public native OrtApi CreateEnvWithCustomLoggerAndGlobalThreadPools(CreateEnvWithCustomLoggerAndGlobalThreadPools_OrtLoggingFunction_Pointer_int_BytePointer_OrtThreadingOptions_PointerPointer setter);

  /**
   * Append CUDA execution provider to the session options
   * If CUDA is not available (due to a non cuda enabled build), this function will return failure.
   */
  public static class SessionOptionsAppendExecutionProvider_CUDA_OrtSessionOptions_OrtCUDAProviderOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionOptionsAppendExecutionProvider_CUDA_OrtSessionOptions_OrtCUDAProviderOptions(Pointer p) { super(p); }
      protected SessionOptionsAppendExecutionProvider_CUDA_OrtSessionOptions_OrtCUDAProviderOptions() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call(
                    OrtSessionOptions options, @Const OrtCUDAProviderOptions cuda_options);
  }
  public native SessionOptionsAppendExecutionProvider_CUDA_OrtSessionOptions_OrtCUDAProviderOptions SessionOptionsAppendExecutionProvider_CUDA(); public native OrtApi SessionOptionsAppendExecutionProvider_CUDA(SessionOptionsAppendExecutionProvider_CUDA_OrtSessionOptions_OrtCUDAProviderOptions setter);

  /**
   * Append OpenVINO execution provider to the session options
   * If OpenVINO is not available (due to the OpenVINO provider shared library or its dependencies not being installed), this function will fail.
   */
  public static class SessionOptionsAppendExecutionProvider_OpenVINO_OrtSessionOptions_OrtOpenVINOProviderOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionOptionsAppendExecutionProvider_OpenVINO_OrtSessionOptions_OrtOpenVINOProviderOptions(Pointer p) { super(p); }
      protected SessionOptionsAppendExecutionProvider_OpenVINO_OrtSessionOptions_OrtOpenVINOProviderOptions() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call(
                    OrtSessionOptions options, @Const OrtOpenVINOProviderOptions provider_options);
  }
  public native SessionOptionsAppendExecutionProvider_OpenVINO_OrtSessionOptions_OrtOpenVINOProviderOptions SessionOptionsAppendExecutionProvider_OpenVINO(); public native OrtApi SessionOptionsAppendExecutionProvider_OpenVINO(SessionOptionsAppendExecutionProvider_OpenVINO_OrtSessionOptions_OrtOpenVINOProviderOptions setter);

  /**
   * Use this API to configure the global thread pool options to be used in the call to CreateEnvWithGlobalThreadPools.
   * When this API is called, flush-to-zero and denormal-as-zero are applied to threads in both intra and inter global thread pool.
   * Note that an alternative way not using this option at runtime is to train and export a model without denormals
   * and that's recommended because turning this option on may hurt model accuracy.
   */
  public static class SetGlobalDenormalAsZero_OrtThreadingOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetGlobalDenormalAsZero_OrtThreadingOptions(Pointer p) { super(p); }
      protected SetGlobalDenormalAsZero_OrtThreadingOptions() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( OrtThreadingOptions tp_options);
  }
  public native SetGlobalDenormalAsZero_OrtThreadingOptions SetGlobalDenormalAsZero(); public native OrtApi SetGlobalDenormalAsZero(SetGlobalDenormalAsZero_OrtThreadingOptions setter);

  /**
  * Use this API to create the configuration of an arena that can eventually be used to define 
  * an arena based allocator's behavior
  * @param max_mem - use 0 to allow ORT to choose the default
  * @param arena_extend_strategy -  use -1 to allow ORT to choose the default, 0 = kNextPowerOfTwo, 1 = kSameAsRequested
  * @param initial_chunk_size_bytes - use -1 to allow ORT to choose the default
  * @param max_dead_bytes_per_chunk - use -1 to allow ORT to choose the default
  * @param out - a pointer to an OrtArenaCfg instance
  * @return a nullptr in case of success or a pointer to an OrtStatus instance in case of failure
  * See docs/C_API.md for details on what the following parameters mean and how to choose these values
  */
  public static class CreateArenaCfg_long_int_int_int_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    CreateArenaCfg_long_int_int_int_PointerPointer(Pointer p) { super(p); }
      protected CreateArenaCfg_long_int_int_int_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Cast("size_t") long max_mem, int arena_extend_strategy, int initial_chunk_size_bytes,
                    int max_dead_bytes_per_chunk, @Cast("OrtArenaCfg**") PointerPointer out);
  }
  public native CreateArenaCfg_long_int_int_int_PointerPointer CreateArenaCfg(); public native OrtApi CreateArenaCfg(CreateArenaCfg_long_int_int_int_PointerPointer setter);

  public static class ReleaseArenaCfg_OrtArenaCfg extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ReleaseArenaCfg_OrtArenaCfg(Pointer p) { super(p); }
      protected ReleaseArenaCfg_OrtArenaCfg() { allocate(); }
      private native void allocate();
      public native void call(OrtArenaCfg input);
  }
  public native ReleaseArenaCfg_OrtArenaCfg ReleaseArenaCfg(); public native OrtApi ReleaseArenaCfg(ReleaseArenaCfg_OrtArenaCfg setter);

  /**
  * Use this API to obtain the description of the graph present in the model
  * (doc_string field of the GraphProto message within the ModelProto message).
  * If it doesn't exist, an empty string will be returned.
  * @param model_metadata - an instance of OrtModelMetadata
  * @param allocator - allocator used to allocate the string that will be returned back 
  * @param value - is set to a null terminated string allocated using 'allocator'. 
    The caller is responsible for freeing it.
  */
  public static class ModelMetadataGetGraphDescription_OrtModelMetadata_OrtAllocator_PointerPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    ModelMetadataGetGraphDescription_OrtModelMetadata_OrtAllocator_PointerPointer(Pointer p) { super(p); }
      protected ModelMetadataGetGraphDescription_OrtModelMetadata_OrtAllocator_PointerPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( @Const OrtModelMetadata model_metadata,
                    OrtAllocator allocator, @Cast("char**") PointerPointer value);
  }
  public native ModelMetadataGetGraphDescription_OrtModelMetadata_OrtAllocator_PointerPointer ModelMetadataGetGraphDescription(); public native OrtApi ModelMetadataGetGraphDescription(ModelMetadataGetGraphDescription_OrtModelMetadata_OrtAllocator_PointerPointer setter);
  /**
   * Append TensorRT execution provider to the session options
   * If TensorRT is not available (due to a non TensorRT enabled build), this function will return failure.
   */
  public static class SessionOptionsAppendExecutionProvider_TensorRT_OrtSessionOptions_OrtTensorRTProviderOptions extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SessionOptionsAppendExecutionProvider_TensorRT_OrtSessionOptions_OrtTensorRTProviderOptions(Pointer p) { super(p); }
      protected SessionOptionsAppendExecutionProvider_TensorRT_OrtSessionOptions_OrtTensorRTProviderOptions() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call(
                    OrtSessionOptions options, @Const OrtTensorRTProviderOptions tensorrt_options);
  }
  public native SessionOptionsAppendExecutionProvider_TensorRT_OrtSessionOptions_OrtTensorRTProviderOptions SessionOptionsAppendExecutionProvider_TensorRT(); public native OrtApi SessionOptionsAppendExecutionProvider_TensorRT(SessionOptionsAppendExecutionProvider_TensorRT_OrtSessionOptions_OrtTensorRTProviderOptions setter);

  /**
  * Set the current device id of the GPU execution provider (cuda/tensorrt/rocm). The device id should be less
  * than the total number of devices available. Using this API makes sense only when doing multi-GPU inferencing.
  */
  public static class SetCurrentGpuDeviceId_int extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    SetCurrentGpuDeviceId_int(Pointer p) { super(p); }
      protected SetCurrentGpuDeviceId_int() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( int device_id);
  }
  public native SetCurrentGpuDeviceId_int SetCurrentGpuDeviceId(); public native OrtApi SetCurrentGpuDeviceId(SetCurrentGpuDeviceId_int setter);

  /**
   * Get the current device id of the GPU execution provider (cuda/tensorrt/rocm).
   */
  public static class GetCurrentGpuDeviceId_IntPointer extends FunctionPointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public    GetCurrentGpuDeviceId_IntPointer(Pointer p) { super(p); }
      protected GetCurrentGpuDeviceId_IntPointer() { allocate(); }
      private native void allocate();
      public native @Cast("OrtStatusPtr") OrtStatus call( IntPointer device_id);
  }
  public native GetCurrentGpuDeviceId_IntPointer GetCurrentGpuDeviceId(); public native OrtApi GetCurrentGpuDeviceId(GetCurrentGpuDeviceId_IntPointer setter);
}
