/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.onnxruntime.presets;

import java.util.List;
import org.bytedeco.dnnl.presets.dnnl;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.LoadEnabled;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.InfoMapper;

@Properties(inherit={dnnl.class}, value={@Platform(value={"linux", "macosx", "windows"}, compiler={"cpp11"}, define={"GENERIC_EXCEPTION_CLASS Ort::Exception", "GENERIC_EXCEPTION_TOSTRING what()"}, include={"onnxruntime/core/session/onnxruntime_c_api.h", "onnxruntime/core/session/onnxruntime_cxx_api.h", "onnxruntime/core/providers/cuda/cuda_provider_factory.h", "onnxruntime/core/providers/dnnl/dnnl_provider_factory.h"}, link={"onnxruntime@.1.7.0"}, preload={"onnxruntime_providers_shared", "onnxruntime_providers_dnnl", "onnxruntime_providers_cuda"}), @Platform(value={"linux", "macosx", "windows"}, extension={"-gpu"})}, target="org.bytedeco.onnxruntime", global="org.bytedeco.onnxruntime.global.onnxruntime")
public class onnxruntime
implements LoadEnabled,
InfoMapper {
    public void init(ClassProperties properties) {
        String[] libs;
        String platform = properties.getProperty("platform");
        String extension = properties.getProperty("platform.extension");
        List preloads = properties.get("platform.preload");
        List resources = properties.get("platform.preloadresource");
        if (!Loader.isLoadLibraries() || extension == null || !extension.equals("-gpu")) {
            return;
        }
        int i = 0;
        for (String lib : libs = new String[]{"cudart", "cublasLt", "cublas", "cufft", "curand", "cudnn", "cudnn_ops_infer", "cudnn_ops_train", "cudnn_adv_infer", "cudnn_adv_train", "cudnn_cnn_infer", "cudnn_cnn_train"}) {
            if (platform.startsWith("linux")) {
                lib = lib + (lib.startsWith("cudnn") ? "@.8" : (lib.equals("cufft") || lib.equals("curand") ? "@.10" : (lib.equals("cudart") ? "@.11.0" : "@.11")));
            } else {
                if (!platform.startsWith("windows")) continue;
                lib = lib + (lib.startsWith("cudnn") ? "64_8" : (lib.equals("cufft") || lib.equals("curand") ? "64_10" : (lib.equals("cudart") ? "64_110" : "64_11")));
            }
            if (preloads.contains(lib)) continue;
            preloads.add(i++, lib);
        }
        if (i > 0) {
            resources.add("/org/bytedeco/cuda/");
        }
    }

    public void map(InfoMap infoMap) {
        infoMap.put(new Info(new String[]{"ORTCHAR_T"}).cppText("").cppTypes(new String[0]).cast().pointerTypes(new String[]{"Pointer"})).put(new Info(new String[]{"ORT_EXPORT", "ORT_API_CALL", "NO_EXCEPTION", "ORT_ALL_ARGS_NONNULL", "OrtCustomOpApi"}).cppTypes(new String[0]).annotations(new String[0])).put(new Info(new String[]{"ORT_API_MANUAL_INIT"}).define(false)).put(new Info(new String[]{"Ort::stub_api", "Ort::Global<T>::api_", "std::nullptr_t", "Ort::Env::s_api"}).skip()).put(new Info(new String[]{"std::string"}).annotations(new String[]{"@Cast({\"char*\", \"std::string&&\"}) @StdString"}).valueTypes(new String[]{"BytePointer", "String"}).pointerTypes(new String[]{"BytePointer"})).put(new Info(new String[]{"std::vector<std::string>"}).pointerTypes(new String[]{"StringVector"}).define()).put(new Info(new String[]{"std::vector<Ort::Value>"}).valueTypes(new String[]{"@StdMove ValueVector"}).pointerTypes(new String[]{"ValueVector"}).define()).put(new Info(new String[]{"Ort::Value"}).valueTypes(new String[]{"@StdMove Value"}).pointerTypes(new String[]{"Value"})).put(new Info(new String[]{"Ort::Value::CreateTensor<float>"}).javaNames(new String[]{"CreateTensorFloat"})).put(new Info(new String[]{"Ort::Value::CreateTensor<double>"}).javaNames(new String[]{"CreateTensorDouble"})).put(new Info(new String[]{"Ort::Value::CreateTensor<int8_t>"}).javaNames(new String[]{"CreateTensorByte"})).put(new Info(new String[]{"Ort::Value::CreateTensor<int16_t>"}).javaNames(new String[]{"CreateTensorShort"})).put(new Info(new String[]{"Ort::Value::CreateTensor<int32_t>"}).javaNames(new String[]{"CreateTensorInt"})).put(new Info(new String[]{"Ort::Value::CreateTensor<int64_t>"}).javaNames(new String[]{"CreateTensorLong"})).put(new Info(new String[]{"Ort::Value::CreateTensor<uint8_t>"}).javaNames(new String[]{"CreateTensorUByte"})).put(new Info(new String[]{"Ort::Value::CreateTensor<uint16_t>"}).javaNames(new String[]{"CreateTensorUShort"})).put(new Info(new String[]{"Ort::Value::CreateTensor<uint32_t>"}).javaNames(new String[]{"CreateTensorUInt"})).put(new Info(new String[]{"Ort::Value::CreateTensor<uint64_t>"}).javaNames(new String[]{"CreateTensorULong"})).put(new Info(new String[]{"Ort::Value::CreateTensor<bool>"}).javaNames(new String[]{"CreateTensorBool"})).put(new Info(new String[]{"Ort::Value::GetTensorMutableData<float>"}).javaNames(new String[]{"GetTensorMutableDataFloat"})).put(new Info(new String[]{"Ort::Value::GetTensorMutableData<double>"}).javaNames(new String[]{"GetTensorMutableDataDouble"})).put(new Info(new String[]{"Ort::Value::GetTensorMutableData<int8_t>"}).javaNames(new String[]{"GetTensorMutableDataByte"})).put(new Info(new String[]{"Ort::Value::GetTensorMutableData<int16_t>"}).javaNames(new String[]{"GetTensorMutableDataShort"})).put(new Info(new String[]{"Ort::Value::GetTensorMutableData<int32_t>"}).javaNames(new String[]{"GetTensorMutableDataInt"})).put(new Info(new String[]{"Ort::Value::GetTensorMutableData<int64_t>"}).javaNames(new String[]{"GetTensorMutableDataLong"})).put(new Info(new String[]{"Ort::Value::GetTensorMutableData<uint8_t>"}).javaNames(new String[]{"GetTensorMutableDataUByte"})).put(new Info(new String[]{"Ort::Value::GetTensorMutableData<uint16_t>"}).javaNames(new String[]{"GetTensorMutableDataUShort"})).put(new Info(new String[]{"Ort::Value::GetTensorMutableData<uint32_t>"}).javaNames(new String[]{"GetTensorMutableDataUInt"})).put(new Info(new String[]{"Ort::Value::GetTensorMutableData<uint64_t>"}).javaNames(new String[]{"GetTensorMutableDataULong"})).put(new Info(new String[]{"Ort::Value::GetTensorMutableData<bool>"}).javaNames(new String[]{"GetTensorMutableDataBool"})).put(new Info(new String[]{"Ort::Unowned<Ort::TensorTypeAndShapeInfo>"}).pointerTypes(new String[]{"UnownedTensorTypeAndShapeInfo"}).purify()).put(new Info(new String[]{"Ort::Unowned<Ort::SequenceTypeInfo>"}).pointerTypes(new String[]{"UnownedSequenceTypeInfo"}).purify()).put(new Info(new String[]{"Ort::Unowned<Ort::MapTypeInfo>"}).pointerTypes(new String[]{"UnownedMapTypeInfo"}).purify()).put(new Info(new String[]{"Ort::MemoryAllocation"}).purify()).put(new Info(new String[]{"Ort::MemoryAllocation::operator ="}).skip()).put(new Info(new String[]{"Ort::RunOptions::GetRunLogSeverityLevel"}).skip()).put(new Info(new String[]{"Ort::Exception"}).pointerTypes(new String[]{"OrtException"})).put(new Info(new String[]{"Ort::Base<OrtArenaCfg>"}).pointerTypes(new String[]{"BaseArenaCfg"})).put(new Info(new String[]{"Ort::Base<OrtAllocator>"}).pointerTypes(new String[]{"BaseAllocator"})).put(new Info(new String[]{"Ort::Base<OrtIoBinding>"}).pointerTypes(new String[]{"BaseIoBinding"})).put(new Info(new String[]{"Ort::Base<OrtMemoryInfo>", "Ort::BaseMemoryInfo<Ort::Base<OrtMemoryInfo> >", "Ort::BaseMemoryInfo<Ort::Base<const OrtMemoryInfo> >"}).pointerTypes(new String[]{"BaseMemoryInfo"})).put(new Info(new String[]{"Ort::Base<OrtModelMetadata>"}).pointerTypes(new String[]{"BaseModelMetadata"})).put(new Info(new String[]{"Ort::Base<OrtCustomOpDomain>"}).pointerTypes(new String[]{"BaseCustomOpDomain"})).put(new Info(new String[]{"Ort::Base<OrtEnv>"}).pointerTypes(new String[]{"BaseEnv"})).put(new Info(new String[]{"Ort::Base<OrtRunOptions>"}).pointerTypes(new String[]{"BaseRunOptions"})).put(new Info(new String[]{"Ort::Base<OrtSession>"}).pointerTypes(new String[]{"BaseSession"})).put(new Info(new String[]{"Ort::Base<OrtSessionOptions>"}).pointerTypes(new String[]{"BaseSessionOptions"})).put(new Info(new String[]{"Ort::Base<OrtTensorTypeAndShapeInfo>"}).pointerTypes(new String[]{"BaseTensorTypeAndShapeInfo"})).put(new Info(new String[]{"Ort::Base<OrtSequenceTypeInfo>"}).pointerTypes(new String[]{"BaseSequenceTypeInfo"})).put(new Info(new String[]{"Ort::Base<OrtMapTypeInfo>"}).pointerTypes(new String[]{"BaseMapTypeInfo"})).put(new Info(new String[]{"Ort::Base<OrtTypeInfo>"}).pointerTypes(new String[]{"BaseTypeInfo"})).put(new Info(new String[]{"Ort::Base<OrtValue>"}).pointerTypes(new String[]{"BaseValue"})).put(new Info(new String[]{"OrtSessionOptionsAppendExecutionProvider_CUDA"}).annotations(new String[]{"@Platform(extension=\"-gpu\")"}).javaNames(new String[]{"OrtSessionOptionsAppendExecutionProvider_CUDA"}));
    }

    static {
        Loader.checkVersion((String)"org.bytedeco", (String)"onnxruntime");
    }
}

