// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.openblas.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;

public class openblas extends org.bytedeco.openblas.presets.openblas {
    static { Loader.load(); }

// Parsed from openblas_config.h

// #ifndef OPENBLAS_CONFIG_H
// #define OPENBLAS_CONFIG_H
public static final int OPENBLAS_OS_WINNT = 1;
public static final int OPENBLAS_ARCH_X86_64 = 1;
public static final int OPENBLAS_C_GCC = 1;
public static final int OPENBLAS___64BIT__ = 1;
public static final int OPENBLAS_HAVE_C11 = 1;
// #define OPENBLAS_PTHREAD_CREATE_FUNC pthread_create
// #define OPENBLAS_BUNDERSCORE _
public static final int OPENBLAS_NEEDBUNDERSCORE = 1;
// #define OPENBLAS_NEHALEM 
public static final int OPENBLAS_L1_DATA_SIZE = 32768;
public static final int OPENBLAS_L1_DATA_LINESIZE = 64;
public static final int OPENBLAS_L2_SIZE = 262144;
public static final int OPENBLAS_L2_LINESIZE = 64;
public static final int OPENBLAS_DTB_DEFAULT_ENTRIES = 64;
public static final int OPENBLAS_DTB_SIZE = 4096;
// #define OPENBLAS_HAVE_CMOV 
// #define OPENBLAS_HAVE_MMX 
// #define OPENBLAS_HAVE_SSE 
// #define OPENBLAS_HAVE_SSE2 
// #define OPENBLAS_HAVE_SSE3 
// #define OPENBLAS_HAVE_SSSE3 
// #define OPENBLAS_HAVE_SSE4_1 
// #define OPENBLAS_HAVE_SSE4_2 
// #define OPENBLAS_CORE_NEHALEM 
public static final String OPENBLAS_CHAR_CORENAME = "NEHALEM";
public static final int OPENBLAS_SLOCAL_BUFFER_SIZE = 65536;
public static final int OPENBLAS_DLOCAL_BUFFER_SIZE = 32768;
public static final int OPENBLAS_CLOCAL_BUFFER_SIZE = 65536;
public static final int OPENBLAS_ZLOCAL_BUFFER_SIZE = 32768;
public static final int OPENBLAS_GEMM_MULTITHREAD_THRESHOLD = 4;
public static final String OPENBLAS_VERSION = " OpenBLAS 0.3.23 ";
/*This is only for "make install" target.*/

// #if defined(OPENBLAS_OS_WINNT) || defined(OPENBLAS_OS_CYGWIN_NT) || defined(OPENBLAS_OS_INTERIX)
// #define OPENBLAS_WINDOWS_ABI
// #define OPENBLAS_OS_WINDOWS

// #ifdef DOUBLE
// #define DOUBLE_DEFINED DOUBLE
// #undef  DOUBLE
// #endif
// #endif

// #ifdef OPENBLAS_NEEDBUNDERSCORE
// #define BLASFUNC(FUNC) FUNC##_
// #else
// #endif

// #ifdef OPENBLAS_QUAD_PRECISION
// #elif defined OPENBLAS_EXPRECISION
// #else
// #define xdouble double
// #endif

// #if defined(OPENBLAS_OS_WINDOWS) && defined(OPENBLAS___64BIT__)
// #else
// #endif

// #ifndef BFLOAT16
// #include <stdint.h>
// #endif

// #ifdef OPENBLAS_USE64BITINT
// #else
// #endif

// #if defined(XDOUBLE) || defined(DOUBLE)
// #define FLOATRET	FLOAT
// #else
// #ifdef NEED_F2CCONV
// #define FLOATRET	double
// #else
// #define FLOATRET	float
// #endif
// #endif

/* Inclusion of a standard header file is needed for definition of __STDC_*
   predefined macros with some compilers (e.g. GCC 4.7 on Linux).  This occurs
   as a side effect of including either <features.h> or <stdc-predef.h>. */
// #include <stdio.h>

/* C99 supports complex floating numbers natively, which GCC also offers as an
   extension since version 3.0.  If neither are available, use a compatible
   structure as fallback (see Clause 6.2.5.13 of the C99 standard). */
// #if ((defined(__STDC_IEC_559_COMPLEX__) || __STDC_VERSION__ >= 199901L ||
//       (__GNUC__ >= 3 && !defined(__cplusplus))) && !(defined(FORCE_OPENBLAS_COMPLEX_STRUCT))) && !defined(_MSC_VER)
//   #define OPENBLAS_COMPLEX_C99
// #ifndef __cplusplus
//   #include <complex.h>
// #endif
//   #define openblas_make_complex_float(real, imag)    ((real) + ((imag) * _Complex_I))
//   #define openblas_make_complex_double(real, imag)   ((real) + ((imag) * _Complex_I))
//   #define openblas_make_complex_xdouble(real, imag)  ((real) + ((imag) * _Complex_I))
//   #define openblas_complex_float_real(z)             (creal(z))
//   #define openblas_complex_float_imag(z)             (cimag(z))
//   #define openblas_complex_double_real(z)            (creal(z))
//   #define openblas_complex_double_imag(z)            (cimag(z))
//   #define openblas_complex_xdouble_real(z)           (creal(z))
//   #define openblas_complex_xdouble_imag(z)           (cimag(z))
// #else
// #endif

/* Inclusion of Linux-specific header is needed for definition of cpu_set_t. */
// #ifdef OPENBLAS_OS_LINUX
// #endif
// #endif /* OPENBLAS_CONFIG_H */


// Parsed from cblas.h

// #ifndef CBLAS_H
// #define CBLAS_H

// #include <stddef.h>
// #include "openblas_config.h"

// #ifdef __cplusplus
	/* Assume C declarations for C++ */
// #endif  /* __cplusplus */

/*Set the number of threads on runtime.*/



/*Get the number of threads on runtime.*/


/*Get the number of physical processors (cores).*/


/*Get the build configure on runtime.*/


/*Get the CPU corename on runtime.*/


// #ifdef OPENBLAS_OS_LINUX
// #endif

/* Get the parallelization type which is used by OpenBLAS */

/* OpenBLAS is compiled for sequential use  */
public static final int OPENBLAS_SEQUENTIAL =  0;
/* OpenBLAS is compiled using normal threading model */
public static final int OPENBLAS_THREAD =  1;
/* OpenBLAS is compiled using OpenMP threading model */
public static final int OPENBLAS_OPENMP = 2;


/*
 * Since all of GotoBlas was written without const,
 * we disable it at build time.
 */
// #ifndef OPENBLAS_CONST
// # define OPENBLAS_CONST const
// #endif


// #define CBLAS_INDEX size_t

/** enum CBLAS_ORDER */
public static final int CblasRowMajor = 101, CblasColMajor = 102;
/** enum CBLAS_TRANSPOSE */
public static final int CblasNoTrans = 111, CblasTrans = 112, CblasConjTrans = 113, CblasConjNoTrans = 114;
/** enum CBLAS_UPLO */
public static final int CblasUpper = 121, CblasLower = 122;
/** enum CBLAS_DIAG */
public static final int CblasNonUnit = 131, CblasUnit = 132;
/** enum CBLAS_SIDE */
public static final int CblasLeft = 141, CblasRight = 142;
	
public static native float cblas_sdsdot(@Cast("const blasint") int n, float alpha, @Const FloatPointer x, @Cast("const blasint") int incx, @Const FloatPointer y, @Cast("const blasint") int incy);
public static native float cblas_sdsdot(@Cast("const blasint") int n, float alpha, @Const FloatBuffer x, @Cast("const blasint") int incx, @Const FloatBuffer y, @Cast("const blasint") int incy);
public static native float cblas_sdsdot(@Cast("const blasint") int n, float alpha, @Const float[] x, @Cast("const blasint") int incx, @Const float[] y, @Cast("const blasint") int incy);
public static native double cblas_dsdot(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx, @Const FloatPointer y, @Cast("const blasint") int incy);
public static native double cblas_dsdot(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx, @Const FloatBuffer y, @Cast("const blasint") int incy);
public static native double cblas_dsdot(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx, @Const float[] y, @Cast("const blasint") int incy);
public static native float cblas_sdot(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx, @Const FloatPointer y, @Cast("const blasint") int incy);
public static native float cblas_sdot(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx, @Const FloatBuffer y, @Cast("const blasint") int incy);
public static native float cblas_sdot(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx, @Const float[] y, @Cast("const blasint") int incy);
public static native double cblas_ddot(@Cast("const blasint") int n, @Const DoublePointer x, @Cast("const blasint") int incx, @Const DoublePointer y, @Cast("const blasint") int incy);
public static native double cblas_ddot(@Cast("const blasint") int n, @Const DoubleBuffer x, @Cast("const blasint") int incx, @Const DoubleBuffer y, @Cast("const blasint") int incy);
public static native double cblas_ddot(@Cast("const blasint") int n, @Const double[] x, @Cast("const blasint") int incx, @Const double[] y, @Cast("const blasint") int incy);






public static native void cblas_cdotu_sub(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, @Const Pointer y, @Cast("const blasint") int incy, Pointer ret);
public static native void cblas_cdotc_sub(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, @Const Pointer y, @Cast("const blasint") int incy, Pointer ret);
public static native void cblas_zdotu_sub(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, @Const Pointer y, @Cast("const blasint") int incy, Pointer ret);
public static native void cblas_zdotc_sub(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, @Const Pointer y, @Cast("const blasint") int incy, Pointer ret);

public static native float cblas_sasum(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx);
public static native float cblas_sasum(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx);
public static native float cblas_sasum(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx);
public static native double cblas_dasum(@Cast("const blasint") int n, @Const DoublePointer x, @Cast("const blasint") int incx);
public static native double cblas_dasum(@Cast("const blasint") int n, @Const DoubleBuffer x, @Cast("const blasint") int incx);
public static native double cblas_dasum(@Cast("const blasint") int n, @Const double[] x, @Cast("const blasint") int incx);
public static native float cblas_scasum(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx);
public static native double cblas_dzasum(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx);






public static native float cblas_snrm2(@Cast("const blasint") int N, @Const FloatPointer X, @Cast("const blasint") int incX);
public static native float cblas_snrm2(@Cast("const blasint") int N, @Const FloatBuffer X, @Cast("const blasint") int incX);
public static native float cblas_snrm2(@Cast("const blasint") int N, @Const float[] X, @Cast("const blasint") int incX);
public static native double cblas_dnrm2(@Cast("const blasint") int N, @Const DoublePointer X, @Cast("const blasint") int incX);
public static native double cblas_dnrm2(@Cast("const blasint") int N, @Const DoubleBuffer X, @Cast("const blasint") int incX);
public static native double cblas_dnrm2(@Cast("const blasint") int N, @Const double[] X, @Cast("const blasint") int incX);
public static native float cblas_scnrm2(@Cast("const blasint") int N, @Const Pointer X, @Cast("const blasint") int incX);
public static native double cblas_dznrm2(@Cast("const blasint") int N, @Const Pointer X, @Cast("const blasint") int incX);

public static native @Cast("size_t") long cblas_isamax(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_isamax(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_isamax(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_idamax(@Cast("const blasint") int n, @Const DoublePointer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_idamax(@Cast("const blasint") int n, @Const DoubleBuffer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_idamax(@Cast("const blasint") int n, @Const double[] x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_icamax(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_izamax(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx);
















public static native void cblas_saxpy(@Cast("const blasint") int n, float alpha, @Const FloatPointer x, @Cast("const blasint") int incx, FloatPointer y, @Cast("const blasint") int incy);
public static native void cblas_saxpy(@Cast("const blasint") int n, float alpha, @Const FloatBuffer x, @Cast("const blasint") int incx, FloatBuffer y, @Cast("const blasint") int incy);
public static native void cblas_saxpy(@Cast("const blasint") int n, float alpha, @Const float[] x, @Cast("const blasint") int incx, float[] y, @Cast("const blasint") int incy);
public static native void cblas_daxpy(@Cast("const blasint") int n, double alpha, @Const DoublePointer x, @Cast("const blasint") int incx, DoublePointer y, @Cast("const blasint") int incy);
public static native void cblas_daxpy(@Cast("const blasint") int n, double alpha, @Const DoubleBuffer x, @Cast("const blasint") int incx, DoubleBuffer y, @Cast("const blasint") int incy);
public static native void cblas_daxpy(@Cast("const blasint") int n, double alpha, @Const double[] x, @Cast("const blasint") int incx, double[] y, @Cast("const blasint") int incy);
public static native void cblas_caxpy(@Cast("const blasint") int n, @Const Pointer alpha, @Const Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);
public static native void cblas_zaxpy(@Cast("const blasint") int n, @Const Pointer alpha, @Const Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);

public static native void cblas_scopy(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx, FloatPointer y, @Cast("const blasint") int incy);
public static native void cblas_scopy(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx, FloatBuffer y, @Cast("const blasint") int incy);
public static native void cblas_scopy(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx, float[] y, @Cast("const blasint") int incy);
public static native void cblas_dcopy(@Cast("const blasint") int n, @Const DoublePointer x, @Cast("const blasint") int incx, DoublePointer y, @Cast("const blasint") int incy);
public static native void cblas_dcopy(@Cast("const blasint") int n, @Const DoubleBuffer x, @Cast("const blasint") int incx, DoubleBuffer y, @Cast("const blasint") int incy);
public static native void cblas_dcopy(@Cast("const blasint") int n, @Const double[] x, @Cast("const blasint") int incx, double[] y, @Cast("const blasint") int incy);
public static native void cblas_ccopy(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);
public static native void cblas_zcopy(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);

public static native void cblas_sswap(@Cast("const blasint") int n, FloatPointer x, @Cast("const blasint") int incx, FloatPointer y, @Cast("const blasint") int incy);
public static native void cblas_sswap(@Cast("const blasint") int n, FloatBuffer x, @Cast("const blasint") int incx, FloatBuffer y, @Cast("const blasint") int incy);
public static native void cblas_sswap(@Cast("const blasint") int n, float[] x, @Cast("const blasint") int incx, float[] y, @Cast("const blasint") int incy);
public static native void cblas_dswap(@Cast("const blasint") int n, DoublePointer x, @Cast("const blasint") int incx, DoublePointer y, @Cast("const blasint") int incy);
public static native void cblas_dswap(@Cast("const blasint") int n, DoubleBuffer x, @Cast("const blasint") int incx, DoubleBuffer y, @Cast("const blasint") int incy);
public static native void cblas_dswap(@Cast("const blasint") int n, double[] x, @Cast("const blasint") int incx, double[] y, @Cast("const blasint") int incy);
public static native void cblas_cswap(@Cast("const blasint") int n, Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);
public static native void cblas_zswap(@Cast("const blasint") int n, Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);

public static native void cblas_srot(@Cast("const blasint") int N, FloatPointer X, @Cast("const blasint") int incX, FloatPointer Y, @Cast("const blasint") int incY, float c, float s);
public static native void cblas_srot(@Cast("const blasint") int N, FloatBuffer X, @Cast("const blasint") int incX, FloatBuffer Y, @Cast("const blasint") int incY, float c, float s);
public static native void cblas_srot(@Cast("const blasint") int N, float[] X, @Cast("const blasint") int incX, float[] Y, @Cast("const blasint") int incY, float c, float s);
public static native void cblas_drot(@Cast("const blasint") int N, DoublePointer X, @Cast("const blasint") int incX, DoublePointer Y, @Cast("const blasint") int incY, double c, double s);
public static native void cblas_drot(@Cast("const blasint") int N, DoubleBuffer X, @Cast("const blasint") int incX, DoubleBuffer Y, @Cast("const blasint") int incY, double c, double s);
public static native void cblas_drot(@Cast("const blasint") int N, double[] X, @Cast("const blasint") int incX, double[] Y, @Cast("const blasint") int incY, double c, double s);



public static native void cblas_srotg(FloatPointer a, FloatPointer b, FloatPointer c, FloatPointer s);
public static native void cblas_srotg(FloatBuffer a, FloatBuffer b, FloatBuffer c, FloatBuffer s);
public static native void cblas_srotg(float[] a, float[] b, float[] c, float[] s);
public static native void cblas_drotg(DoublePointer a, DoublePointer b, DoublePointer c, DoublePointer s);
public static native void cblas_drotg(DoubleBuffer a, DoubleBuffer b, DoubleBuffer c, DoubleBuffer s);
public static native void cblas_drotg(double[] a, double[] b, double[] c, double[] s);




public static native void cblas_srotm(@Cast("const blasint") int N, FloatPointer X, @Cast("const blasint") int incX, FloatPointer Y, @Cast("const blasint") int incY, @Const FloatPointer P);
public static native void cblas_srotm(@Cast("const blasint") int N, FloatBuffer X, @Cast("const blasint") int incX, FloatBuffer Y, @Cast("const blasint") int incY, @Const FloatBuffer P);
public static native void cblas_srotm(@Cast("const blasint") int N, float[] X, @Cast("const blasint") int incX, float[] Y, @Cast("const blasint") int incY, @Const float[] P);
public static native void cblas_drotm(@Cast("const blasint") int N, DoublePointer X, @Cast("const blasint") int incX, DoublePointer Y, @Cast("const blasint") int incY, @Const DoublePointer P);
public static native void cblas_drotm(@Cast("const blasint") int N, DoubleBuffer X, @Cast("const blasint") int incX, DoubleBuffer Y, @Cast("const blasint") int incY, @Const DoubleBuffer P);
public static native void cblas_drotm(@Cast("const blasint") int N, double[] X, @Cast("const blasint") int incX, double[] Y, @Cast("const blasint") int incY, @Const double[] P);

public static native void cblas_srotmg(FloatPointer d1, FloatPointer d2, FloatPointer b1, float b2, FloatPointer P);
public static native void cblas_srotmg(FloatBuffer d1, FloatBuffer d2, FloatBuffer b1, float b2, FloatBuffer P);
public static native void cblas_srotmg(float[] d1, float[] d2, float[] b1, float b2, float[] P);
public static native void cblas_drotmg(DoublePointer d1, DoublePointer d2, DoublePointer b1, double b2, DoublePointer P);
public static native void cblas_drotmg(DoubleBuffer d1, DoubleBuffer d2, DoubleBuffer b1, double b2, DoubleBuffer P);
public static native void cblas_drotmg(double[] d1, double[] d2, double[] b1, double b2, double[] P);

public static native void cblas_sscal(@Cast("const blasint") int N, float alpha, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_sscal(@Cast("const blasint") int N, float alpha, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_sscal(@Cast("const blasint") int N, float alpha, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dscal(@Cast("const blasint") int N, double alpha, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dscal(@Cast("const blasint") int N, double alpha, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dscal(@Cast("const blasint") int N, double alpha, double[] X, @Cast("const blasint") int incX);
public static native void cblas_cscal(@Cast("const blasint") int N, @Const Pointer alpha, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_zscal(@Cast("const blasint") int N, @Const Pointer alpha, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_csscal(@Cast("const blasint") int N, float alpha, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_zdscal(@Cast("const blasint") int N, double alpha, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_sgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 float alpha, @Const FloatPointer a, @Cast("const blasint") int lda,  @Const FloatPointer x, @Cast("const blasint") int incx,  float beta,  FloatPointer y, @Cast("const blasint") int incy);
public static native void cblas_sgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 float alpha, @Const FloatBuffer a, @Cast("const blasint") int lda,  @Const FloatBuffer x, @Cast("const blasint") int incx,  float beta,  FloatBuffer y, @Cast("const blasint") int incy);
public static native void cblas_sgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 float alpha, @Const float[] a, @Cast("const blasint") int lda,  @Const float[] x, @Cast("const blasint") int incx,  float beta,  float[] y, @Cast("const blasint") int incy);
public static native void cblas_dgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 double alpha, @Const DoublePointer a, @Cast("const blasint") int lda,  @Const DoublePointer x, @Cast("const blasint") int incx,  double beta,  DoublePointer y, @Cast("const blasint") int incy);
public static native void cblas_dgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 double alpha, @Const DoubleBuffer a, @Cast("const blasint") int lda,  @Const DoubleBuffer x, @Cast("const blasint") int incx,  double beta,  DoubleBuffer y, @Cast("const blasint") int incy);
public static native void cblas_dgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 double alpha, @Const double[] a, @Cast("const blasint") int lda,  @Const double[] x, @Cast("const blasint") int incx,  double beta,  double[] y, @Cast("const blasint") int incy);
public static native void cblas_cgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 @Const Pointer alpha, @Const Pointer a, @Cast("const blasint") int lda,  @Const Pointer x, @Cast("const blasint") int incx,  @Const Pointer beta,  Pointer y, @Cast("const blasint") int incy);
public static native void cblas_zgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 @Const Pointer alpha, @Const Pointer a, @Cast("const blasint") int lda,  @Const Pointer x, @Cast("const blasint") int incx,  @Const Pointer beta,  Pointer y, @Cast("const blasint") int incy);

public static native void cblas_sger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatPointer X, @Cast("const blasint") int incX, @Const FloatPointer Y, @Cast("const blasint") int incY, FloatPointer A, @Cast("const blasint") int lda);
public static native void cblas_sger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatBuffer X, @Cast("const blasint") int incX, @Const FloatBuffer Y, @Cast("const blasint") int incY, FloatBuffer A, @Cast("const blasint") int lda);
public static native void cblas_sger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const float[] X, @Cast("const blasint") int incX, @Const float[] Y, @Cast("const blasint") int incY, float[] A, @Cast("const blasint") int lda);
public static native void cblas_dger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoublePointer X, @Cast("const blasint") int incX, @Const DoublePointer Y, @Cast("const blasint") int incY, DoublePointer A, @Cast("const blasint") int lda);
public static native void cblas_dger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X, @Cast("const blasint") int incX, @Const DoubleBuffer Y, @Cast("const blasint") int incY, DoubleBuffer A, @Cast("const blasint") int lda);
public static native void cblas_dger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const double[] X, @Cast("const blasint") int incX, @Const double[] Y, @Cast("const blasint") int incY, double[] A, @Cast("const blasint") int lda);
public static native void cblas_cgeru(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_cgerc(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_zgeru(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_zgerc(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);

public static native void cblas_strsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_strsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_strsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const float[] A, @Cast("const blasint") int lda, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const double[] A, @Cast("const blasint") int lda, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_strmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_strmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_strmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const float[] A, @Cast("const blasint") int lda, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const double[] A, @Cast("const blasint") int lda, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_ssyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer X, @Cast("const blasint") int incX, FloatPointer A, @Cast("const blasint") int lda);
public static native void cblas_ssyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer X, @Cast("const blasint") int incX, FloatBuffer A, @Cast("const blasint") int lda);
public static native void cblas_ssyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] X, @Cast("const blasint") int incX, float[] A, @Cast("const blasint") int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer X, @Cast("const blasint") int incX, DoublePointer A, @Cast("const blasint") int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X, @Cast("const blasint") int incX, DoubleBuffer A, @Cast("const blasint") int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] X, @Cast("const blasint") int incX, double[] A, @Cast("const blasint") int lda);
public static native void cblas_cher(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const Pointer X, @Cast("const blasint") int incX, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_zher(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const Pointer X, @Cast("const blasint") int incX, Pointer A, @Cast("const blasint") int lda);

public static native void cblas_ssyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo,@Cast("const blasint") int N, float alpha, @Const FloatPointer X,
                @Cast("const blasint") int incX, @Const FloatPointer Y, @Cast("const blasint") int incY, FloatPointer A, @Cast("const blasint") int lda);
public static native void cblas_ssyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo,@Cast("const blasint") int N, float alpha, @Const FloatBuffer X,
                @Cast("const blasint") int incX, @Const FloatBuffer Y, @Cast("const blasint") int incY, FloatBuffer A, @Cast("const blasint") int lda);
public static native void cblas_ssyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo,@Cast("const blasint") int N, float alpha, @Const float[] X,
                @Cast("const blasint") int incX, @Const float[] Y, @Cast("const blasint") int incY, float[] A, @Cast("const blasint") int lda);
public static native void cblas_dsyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer X,
                @Cast("const blasint") int incX, @Const DoublePointer Y, @Cast("const blasint") int incY, DoublePointer A, @Cast("const blasint") int lda);
public static native void cblas_dsyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X,
                @Cast("const blasint") int incX, @Const DoubleBuffer Y, @Cast("const blasint") int incY, DoubleBuffer A, @Cast("const blasint") int lda);
public static native void cblas_dsyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] X,
                @Cast("const blasint") int incX, @Const double[] Y, @Cast("const blasint") int incY, double[] A, @Cast("const blasint") int lda);
public static native void cblas_cher2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX,
                @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_zher2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX,
                @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);

public static native void cblas_sgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, @Const FloatPointer X, @Cast("const blasint") int incX, float beta, FloatPointer Y, @Cast("const blasint") int incY);
public static native void cblas_sgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, @Const FloatBuffer X, @Cast("const blasint") int incX, float beta, FloatBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_sgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, float alpha, @Const float[] A, @Cast("const blasint") int lda, @Const float[] X, @Cast("const blasint") int incX, float beta, float[] Y, @Cast("const blasint") int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, @Const DoublePointer X, @Cast("const blasint") int incX, double beta, DoublePointer Y, @Cast("const blasint") int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, @Const DoubleBuffer X, @Cast("const blasint") int incX, double beta, DoubleBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, double alpha, @Const double[] A, @Cast("const blasint") int lda, @Const double[] X, @Cast("const blasint") int incX, double beta, double[] Y, @Cast("const blasint") int incY);
public static native void cblas_cgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);
public static native void cblas_zgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);

public static native void cblas_ssbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatPointer A,
                 @Cast("const blasint") int lda, @Const FloatPointer X, @Cast("const blasint") int incX, float beta, FloatPointer Y, @Cast("const blasint") int incY);
public static native void cblas_ssbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatBuffer A,
                 @Cast("const blasint") int lda, @Const FloatBuffer X, @Cast("const blasint") int incX, float beta, FloatBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_ssbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const float[] A,
                 @Cast("const blasint") int lda, @Const float[] X, @Cast("const blasint") int incX, float beta, float[] Y, @Cast("const blasint") int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoublePointer A,
                 @Cast("const blasint") int lda, @Const DoublePointer X, @Cast("const blasint") int incX, double beta, DoublePointer Y, @Cast("const blasint") int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoubleBuffer A,
                 @Cast("const blasint") int lda, @Const DoubleBuffer X, @Cast("const blasint") int incX, double beta, DoubleBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const double[] A,
                 @Cast("const blasint") int lda, @Const double[] X, @Cast("const blasint") int incX, double beta, double[] Y, @Cast("const blasint") int incY);


public static native void cblas_stbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_stbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_stbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const float[] A, @Cast("const blasint") int lda, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const double[] A, @Cast("const blasint") int lda, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_stbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_stbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_stbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const float[] A, @Cast("const blasint") int lda, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const double[] A, @Cast("const blasint") int lda, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_stpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const FloatPointer Ap, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_stpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const FloatBuffer Ap, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_stpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const float[] Ap, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const DoublePointer Ap, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const DoubleBuffer Ap, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const double[] Ap, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const Pointer Ap, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const Pointer Ap, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_stpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const FloatPointer Ap, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_stpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const FloatBuffer Ap, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_stpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const float[] Ap, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const DoublePointer Ap, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const DoubleBuffer Ap, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const double[] Ap, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const Pointer Ap, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const Pointer Ap, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_ssymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer A,
                 @Cast("const blasint") int lda, @Const FloatPointer X, @Cast("const blasint") int incX, float beta, FloatPointer Y, @Cast("const blasint") int incY);
public static native void cblas_ssymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer A,
                 @Cast("const blasint") int lda, @Const FloatBuffer X, @Cast("const blasint") int incX, float beta, FloatBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_ssymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] A,
                 @Cast("const blasint") int lda, @Const float[] X, @Cast("const blasint") int incX, float beta, float[] Y, @Cast("const blasint") int incY);
public static native void cblas_dsymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer A,
                 @Cast("const blasint") int lda, @Const DoublePointer X, @Cast("const blasint") int incX, double beta, DoublePointer Y, @Cast("const blasint") int incY);
public static native void cblas_dsymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer A,
                 @Cast("const blasint") int lda, @Const DoubleBuffer X, @Cast("const blasint") int incX, double beta, DoubleBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_dsymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] A,
                 @Cast("const blasint") int lda, @Const double[] X, @Cast("const blasint") int incX, double beta, double[] Y, @Cast("const blasint") int incY);
public static native void cblas_chemv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A,
                 @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);
public static native void cblas_zhemv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A,
                 @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);


public static native void cblas_sspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer Ap,
                 @Const FloatPointer X, @Cast("const blasint") int incX, float beta, FloatPointer Y, @Cast("const blasint") int incY);
public static native void cblas_sspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer Ap,
                 @Const FloatBuffer X, @Cast("const blasint") int incX, float beta, FloatBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_sspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] Ap,
                 @Const float[] X, @Cast("const blasint") int incX, float beta, float[] Y, @Cast("const blasint") int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer Ap,
                 @Const DoublePointer X, @Cast("const blasint") int incX, double beta, DoublePointer Y, @Cast("const blasint") int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer Ap,
                 @Const DoubleBuffer X, @Cast("const blasint") int incX, double beta, DoubleBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] Ap,
                 @Const double[] X, @Cast("const blasint") int incX, double beta, double[] Y, @Cast("const blasint") int incY);

public static native void cblas_sspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer X, @Cast("const blasint") int incX, FloatPointer Ap);
public static native void cblas_sspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer X, @Cast("const blasint") int incX, FloatBuffer Ap);
public static native void cblas_sspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] X, @Cast("const blasint") int incX, float[] Ap);
public static native void cblas_dspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer X, @Cast("const blasint") int incX, DoublePointer Ap);
public static native void cblas_dspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X, @Cast("const blasint") int incX, DoubleBuffer Ap);
public static native void cblas_dspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] X, @Cast("const blasint") int incX, double[] Ap);

public static native void cblas_chpr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const Pointer X, @Cast("const blasint") int incX, Pointer A);
public static native void cblas_zhpr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const Pointer X,@Cast("const blasint") int incX, Pointer A);

public static native void cblas_sspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer X, @Cast("const blasint") int incX, @Const FloatPointer Y, @Cast("const blasint") int incY, FloatPointer A);
public static native void cblas_sspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer X, @Cast("const blasint") int incX, @Const FloatBuffer Y, @Cast("const blasint") int incY, FloatBuffer A);
public static native void cblas_sspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] X, @Cast("const blasint") int incX, @Const float[] Y, @Cast("const blasint") int incY, float[] A);
public static native void cblas_dspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer X, @Cast("const blasint") int incX, @Const DoublePointer Y, @Cast("const blasint") int incY, DoublePointer A);
public static native void cblas_dspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X, @Cast("const blasint") int incX, @Const DoubleBuffer Y, @Cast("const blasint") int incY, DoubleBuffer A);
public static native void cblas_dspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] X, @Cast("const blasint") int incX, @Const double[] Y, @Cast("const blasint") int incY, double[] A);
public static native void cblas_chpr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer Ap);
public static native void cblas_zhpr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer Ap);

public static native void cblas_chbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);
public static native void cblas_zhbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);

public static native void cblas_chpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N,
		 @Const Pointer alpha, @Const Pointer Ap, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);
public static native void cblas_zhpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N,
		 @Const Pointer alpha, @Const Pointer Ap, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);

public static native void cblas_sgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, @Const FloatPointer B, @Cast("const blasint") int ldb, float beta, FloatPointer C, @Cast("const blasint") int ldc);
public static native void cblas_sgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, @Const FloatBuffer B, @Cast("const blasint") int ldb, float beta, FloatBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_sgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 float alpha, @Const float[] A, @Cast("const blasint") int lda, @Const float[] B, @Cast("const blasint") int ldb, float beta, float[] C, @Cast("const blasint") int ldc);
public static native void cblas_dgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, @Const DoublePointer B, @Cast("const blasint") int ldb, double beta, DoublePointer C, @Cast("const blasint") int ldc);
public static native void cblas_dgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, @Const DoubleBuffer B, @Cast("const blasint") int ldb, double beta, DoubleBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_dgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 double alpha, @Const double[] A, @Cast("const blasint") int lda, @Const double[] B, @Cast("const blasint") int ldb, double beta, double[] C, @Cast("const blasint") int ldc);
public static native void cblas_cgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_zgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);



public static native void cblas_ssymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, @Const FloatPointer B, @Cast("const blasint") int ldb, float beta, FloatPointer C, @Cast("const blasint") int ldc);
public static native void cblas_ssymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, @Const FloatBuffer B, @Cast("const blasint") int ldb, float beta, FloatBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_ssymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 float alpha, @Const float[] A, @Cast("const blasint") int lda, @Const float[] B, @Cast("const blasint") int ldb, float beta, float[] C, @Cast("const blasint") int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, @Const DoublePointer B, @Cast("const blasint") int ldb, double beta, DoublePointer C, @Cast("const blasint") int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, @Const DoubleBuffer B, @Cast("const blasint") int ldb, double beta, DoubleBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 double alpha, @Const double[] A, @Cast("const blasint") int lda, @Const double[] B, @Cast("const blasint") int ldb, double beta, double[] C, @Cast("const blasint") int ldc);
public static native void cblas_csymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zsymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_ssyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, float beta, FloatPointer C, @Cast("const blasint") int ldc);
public static native void cblas_ssyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, float beta, FloatBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_ssyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const float[] A, @Cast("const blasint") int lda, float beta, float[] C, @Cast("const blasint") int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, double beta, DoublePointer C, @Cast("const blasint") int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, double beta, DoubleBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const double[] A, @Cast("const blasint") int lda, double beta, double[] C, @Cast("const blasint") int ldc);
public static native void cblas_csyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zsyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_ssyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, @Const FloatPointer B, @Cast("const blasint") int ldb, float beta, FloatPointer C, @Cast("const blasint") int ldc);
public static native void cblas_ssyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, @Const FloatBuffer B, @Cast("const blasint") int ldb, float beta, FloatBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_ssyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const float[] A, @Cast("const blasint") int lda, @Const float[] B, @Cast("const blasint") int ldb, float beta, float[] C, @Cast("const blasint") int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, @Const DoublePointer B, @Cast("const blasint") int ldb, double beta, DoublePointer C, @Cast("const blasint") int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, @Const DoubleBuffer B, @Cast("const blasint") int ldb, double beta, DoubleBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const double[] A, @Cast("const blasint") int lda, @Const double[] B, @Cast("const blasint") int ldb, double beta, double[] C, @Cast("const blasint") int ldc);
public static native void cblas_csyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zsyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_strmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer B, @Cast("const blasint") int ldb);
public static native void cblas_strmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer B, @Cast("const blasint") int ldb);
public static native void cblas_strmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const float[] A, @Cast("const blasint") int lda, float[] B, @Cast("const blasint") int ldb);
public static native void cblas_dtrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer B, @Cast("const blasint") int ldb);
public static native void cblas_dtrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer B, @Cast("const blasint") int ldb);
public static native void cblas_dtrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const double[] A, @Cast("const blasint") int lda, double[] B, @Cast("const blasint") int ldb);
public static native void cblas_ctrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, Pointer B, @Cast("const blasint") int ldb);
public static native void cblas_ztrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, Pointer B, @Cast("const blasint") int ldb);

public static native void cblas_strsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer B, @Cast("const blasint") int ldb);
public static native void cblas_strsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer B, @Cast("const blasint") int ldb);
public static native void cblas_strsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const float[] A, @Cast("const blasint") int lda, float[] B, @Cast("const blasint") int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer B, @Cast("const blasint") int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer B, @Cast("const blasint") int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const double[] A, @Cast("const blasint") int lda, double[] B, @Cast("const blasint") int ldb);
public static native void cblas_ctrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, Pointer B, @Cast("const blasint") int ldb);
public static native void cblas_ztrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, Pointer B, @Cast("const blasint") int ldb);

public static native void cblas_chemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zhemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_cherk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans, @Cast("const blasint") int N, @Cast("const blasint") int K,
                 float alpha, @Const Pointer A, @Cast("const blasint") int lda, float beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zherk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans, @Cast("const blasint") int N, @Cast("const blasint") int K,
                 double alpha, @Const Pointer A, @Cast("const blasint") int lda, double beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_cher2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans, @Cast("const blasint") int N, @Cast("const blasint") int K,
                  @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, float beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zher2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans, @Cast("const blasint") int N, @Cast("const blasint") int K,
                  @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, double beta, Pointer C, @Cast("const blasint") int ldc);



/*** BLAS extensions ***/









 
 
 
 

 
 
 
 

 
 
 
 

/*** BFLOAT16 and INT8 extensions ***/
/* convert float array to BFLOAT16 array by rounding */

/* convert double array to BFLOAT16 array by rounding */

/* convert BFLOAT16 array to float array */

/* convert BFLOAT16 array to double array */

/* dot production of BFLOAT16 input arrays, and output as float */




// #ifdef __cplusplus
// #endif  /* __cplusplus */

// #endif


// Parsed from lapacke_config.h

/*****************************************************************************
  Copyright (c) 2010, Intel Corp.
  All rights reserved.
  <p>
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:
    <p>
    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Intel Corporation nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.
  <p>
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************************
* Contents: Native C interface to LAPACK
* Author: Intel Corporation
*****************************************************************************/

// #ifndef _LAPACKE_CONFIG_H_
// #define _LAPACKE_CONFIG_H_

// #ifdef __cplusplus
// #if defined(LAPACK_COMPLEX_CPP)
// #include <complex>
// #endif
// #endif /* __cplusplus */

// #include <stdlib.h>
// #include <stdint.h>
// #include <inttypes.h>

// #ifndef lapack_int
// #if defined(LAPACK_ILP64)
// #define lapack_int        int64_t
// #else
// #define lapack_int        int32_t
// #endif
// #endif

/*
 * Integer format string
 */
// #ifndef LAPACK_IFMT
// #if defined(LAPACK_ILP64)
// #define LAPACK_IFMT       PRId64
// #else
// #define LAPACK_IFMT       PRId32
// #endif
// #endif

// #ifndef lapack_logical
// #define lapack_logical    lapack_int
// #endif

// #ifndef LAPACK_COMPLEX_CUSTOM

// #endif

// #ifndef LAPACK_malloc
// #define LAPACK_malloc( size )   malloc( size )
// #endif

// #ifndef LAPACK_free
// #define LAPACK_free( p )        free( p )
// #endif

// #ifdef __cplusplus
// #endif /* __cplusplus */

// #endif /* _LAPACKE_CONFIG_H_ */


// Parsed from lapacke_mangling.h

// #ifndef LAPACK_HEADER_INCLUDED
// #define LAPACK_HEADER_INCLUDED

// #ifndef LAPACK_GLOBAL
// #if defined(LAPACK_GLOBAL_PATTERN_LC) || defined(ADD_)
// #define LAPACK_GLOBAL(lcname,UCNAME)  lcname##_
// #elif defined(LAPACK_GLOBAL_PATTERN_UC) || defined(UPPER)
// #define LAPACK_GLOBAL(lcname,UCNAME)  UCNAME
// #elif defined(LAPACK_GLOBAL_PATTERN_MC) || defined(NOCHANGE)
// #define LAPACK_GLOBAL(lcname,UCNAME)  lcname
// #else
// #define LAPACK_GLOBAL(lcname,UCNAME)  lcname##_
// #endif
// #endif

// #endif



// Parsed from lapack.h

// #ifndef LAPACK_H
// #define LAPACK_H

/*
*  Turn on HAVE_LAPACK_CONFIG_H to redefine C-LAPACK datatypes
*/
// #ifdef HAVE_LAPACK_CONFIG_H
// #include "lapacke_config.h"
// #endif

// #include "lapacke_mangling.h"

// #include <stdlib.h>
// #include <stdarg.h>
// #include <inttypes.h>

/* It seems all current Fortran compilers put strlen at end.
*  Some historical compilers put strlen after the str argument
*  or make the str argument into a struct. */
// #ifndef __EMSCRIPTEN__
// #define LAPACK_FORTRAN_STRLEN_END
// #endif

/* Complex types are structures equivalent to the
* Fortran complex types COMPLEX(4) and COMPLEX(8).
*
* One can also redefine the types with his own types
* for example by including in the code definitions like
*
* #define lapack_complex_float std::complex<float>
* #define lapack_complex_double std::complex<double>
*
* or define these types in the command line:
*
* -Dlapack_complex_float="std::complex<float>"
* -Dlapack_complex_double="std::complex<double>"
*/

// #ifndef LAPACK_COMPLEX_CUSTOM

// #endif /* LAPACK_COMPLEX_CUSTOM */


// #ifdef __cplusplus
// #endif

/*----------------------------------------------------------------------------*/
// #ifndef lapack_int
// #if defined(LAPACK_ILP64)
// #define lapack_int        int64_t
// #else
// #define lapack_int        int32_t
// #endif
// #endif

/*
 * Integer format string
 */
// #ifndef LAPACK_IFMT
// #if defined(LAPACK_ILP64)
// #define LAPACK_IFMT       PRId64
// #else
// #define LAPACK_IFMT       PRId32
// #endif
// #endif

// #ifndef lapack_logical
// #define lapack_logical    lapack_int
// #endif

/* f2c, hence clapack and MacOS Accelerate, returns double instead of float
 * for sdot, slange, clange, etc. */
// #if defined(LAPACK_F2C)
// #else
// #endif


/* Callback logical functions of one, two, or three arguments are used
*  to select eigenvalues to sort to the top left of the Schur form.
*  The value is selected if function returns TRUE (non-zero). */

public static class LAPACK_S_SELECT2 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_S_SELECT2(Pointer p) { super(p); }
    protected LAPACK_S_SELECT2() { allocate(); }
    private native void allocate();
    public native int call( @Const FloatPointer arg0, @Const FloatPointer arg1 );
}
public static class LAPACK_S_SELECT3 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_S_SELECT3(Pointer p) { super(p); }
    protected LAPACK_S_SELECT3() { allocate(); }
    private native void allocate();
    public native int call( @Const FloatPointer arg0, @Const FloatPointer arg1, @Const FloatPointer arg2 );
}
public static class LAPACK_D_SELECT2 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_D_SELECT2(Pointer p) { super(p); }
    protected LAPACK_D_SELECT2() { allocate(); }
    private native void allocate();
    public native int call( @Const DoublePointer arg0, @Const DoublePointer arg1 );
}
public static class LAPACK_D_SELECT3 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_D_SELECT3(Pointer p) { super(p); }
    protected LAPACK_D_SELECT3() { allocate(); }
    private native void allocate();
    public native int call( @Const DoublePointer arg0, @Const DoublePointer arg1, @Const DoublePointer arg2 );
}

public static class LAPACK_C_SELECT1 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_C_SELECT1(Pointer p) { super(p); }
    protected LAPACK_C_SELECT1() { allocate(); }
    private native void allocate();
    public native int call( @Cast("const lapack_complex_float*") FloatPointer arg0 );
}
public static class LAPACK_C_SELECT2 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_C_SELECT2(Pointer p) { super(p); }
    protected LAPACK_C_SELECT2() { allocate(); }
    private native void allocate();
    public native int call( @Cast("const lapack_complex_float*") FloatPointer arg0, @Cast("const lapack_complex_float*") FloatPointer arg1 );
}
public static class LAPACK_Z_SELECT1 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_Z_SELECT1(Pointer p) { super(p); }
    protected LAPACK_Z_SELECT1() { allocate(); }
    private native void allocate();
    public native int call( @Cast("const lapack_complex_double*") DoublePointer arg0 );
}
public static class LAPACK_Z_SELECT2 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_Z_SELECT2(Pointer p) { super(p); }
    protected LAPACK_Z_SELECT2() { allocate(); }
    private native void allocate();
    public native int call( @Cast("const lapack_complex_double*") DoublePointer arg0, @Cast("const lapack_complex_double*") DoublePointer arg1 );
}

public static native int LAPACK_lsame_base( @Cast("const char*") BytePointer ca,  @Cast("const char*") BytePointer cb,  int lca, int lcb, @Cast("size_t") long arg4, @Cast("size_t") long arg5
);
public static native int LAPACK_lsame_base( String ca,  String cb,  int lca, int lcb, @Cast("size_t") long arg4, @Cast("size_t") long arg5
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_lsame(...) LAPACK_lsame_base(__VA_ARGS__, 1, 1)
// #else
// #endif


/*----------------------------------------------------------------------------*/
/* This is in alphabetical order (ignoring leading precision). */

public static native void LAPACK_cbbcsd_base(
    @Cast("const char*") BytePointer jobu1, @Cast("const char*") BytePointer jobu2, @Cast("const char*") BytePointer jobv1t, @Cast("const char*") BytePointer jobv2t, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer q,
    FloatPointer theta,
    FloatPointer phi,
    @Cast("lapack_complex_float*") FloatPointer U1, @Const IntPointer ldu1,
    @Cast("lapack_complex_float*") FloatPointer U2, @Const IntPointer ldu2,
    @Cast("lapack_complex_float*") FloatPointer V1T, @Const IntPointer ldv1t,
    @Cast("lapack_complex_float*") FloatPointer V2T, @Const IntPointer ldv2t,
    FloatPointer B11D,
    FloatPointer B11E,
    FloatPointer B12D,
    FloatPointer B12E,
    FloatPointer B21D,
    FloatPointer B21E,
    FloatPointer B22D,
    FloatPointer B22E,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_cbbcsd_base(
    String jobu1, String jobu2, String jobv1t, String jobv2t, String trans,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer q,
    FloatBuffer theta,
    FloatBuffer phi,
    @Cast("lapack_complex_float*") FloatBuffer U1, @Const IntBuffer ldu1,
    @Cast("lapack_complex_float*") FloatBuffer U2, @Const IntBuffer ldu2,
    @Cast("lapack_complex_float*") FloatBuffer V1T, @Const IntBuffer ldv1t,
    @Cast("lapack_complex_float*") FloatBuffer V2T, @Const IntBuffer ldv2t,
    FloatBuffer B11D,
    FloatBuffer B11E,
    FloatBuffer B12D,
    FloatBuffer B12E,
    FloatBuffer B21D,
    FloatBuffer B21E,
    FloatBuffer B22D,
    FloatBuffer B22E,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_cbbcsd_base(
    @Cast("const char*") BytePointer jobu1, @Cast("const char*") BytePointer jobu2, @Cast("const char*") BytePointer jobv1t, @Cast("const char*") BytePointer jobv2t, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] p, @Const int[] q,
    float[] theta,
    float[] phi,
    @Cast("lapack_complex_float*") float[] U1, @Const int[] ldu1,
    @Cast("lapack_complex_float*") float[] U2, @Const int[] ldu2,
    @Cast("lapack_complex_float*") float[] V1T, @Const int[] ldv1t,
    @Cast("lapack_complex_float*") float[] V2T, @Const int[] ldv2t,
    float[] B11D,
    float[] B11E,
    float[] B12D,
    float[] B12E,
    float[] B21D,
    float[] B21E,
    float[] B22D,
    float[] B22E,
    float[] rwork, @Const int[] lrwork,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_cbbcsd_base(
    String jobu1, String jobu2, String jobv1t, String jobv2t, String trans,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer q,
    FloatPointer theta,
    FloatPointer phi,
    @Cast("lapack_complex_float*") FloatPointer U1, @Const IntPointer ldu1,
    @Cast("lapack_complex_float*") FloatPointer U2, @Const IntPointer ldu2,
    @Cast("lapack_complex_float*") FloatPointer V1T, @Const IntPointer ldv1t,
    @Cast("lapack_complex_float*") FloatPointer V2T, @Const IntPointer ldv2t,
    FloatPointer B11D,
    FloatPointer B11E,
    FloatPointer B12D,
    FloatPointer B12E,
    FloatPointer B21D,
    FloatPointer B21E,
    FloatPointer B22D,
    FloatPointer B22E,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_cbbcsd_base(
    @Cast("const char*") BytePointer jobu1, @Cast("const char*") BytePointer jobu2, @Cast("const char*") BytePointer jobv1t, @Cast("const char*") BytePointer jobv2t, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer q,
    FloatBuffer theta,
    FloatBuffer phi,
    @Cast("lapack_complex_float*") FloatBuffer U1, @Const IntBuffer ldu1,
    @Cast("lapack_complex_float*") FloatBuffer U2, @Const IntBuffer ldu2,
    @Cast("lapack_complex_float*") FloatBuffer V1T, @Const IntBuffer ldv1t,
    @Cast("lapack_complex_float*") FloatBuffer V2T, @Const IntBuffer ldv2t,
    FloatBuffer B11D,
    FloatBuffer B11E,
    FloatBuffer B12D,
    FloatBuffer B12E,
    FloatBuffer B21D,
    FloatBuffer B21E,
    FloatBuffer B22D,
    FloatBuffer B22E,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_cbbcsd_base(
    String jobu1, String jobu2, String jobv1t, String jobv2t, String trans,
    @Const int[] m, @Const int[] p, @Const int[] q,
    float[] theta,
    float[] phi,
    @Cast("lapack_complex_float*") float[] U1, @Const int[] ldu1,
    @Cast("lapack_complex_float*") float[] U2, @Const int[] ldu2,
    @Cast("lapack_complex_float*") float[] V1T, @Const int[] ldv1t,
    @Cast("lapack_complex_float*") float[] V2T, @Const int[] ldv2t,
    float[] B11D,
    float[] B11E,
    float[] B12D,
    float[] B12E,
    float[] B21D,
    float[] B21E,
    float[] B22D,
    float[] B22E,
    float[] rwork, @Const int[] lrwork,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cbbcsd(...) LAPACK_cbbcsd_base(__VA_ARGS__, 1, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dbbcsd_base(
    @Cast("const char*") BytePointer jobu1, @Cast("const char*") BytePointer jobu2, @Cast("const char*") BytePointer jobv1t, @Cast("const char*") BytePointer jobv2t, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer q,
    DoublePointer theta,
    DoublePointer phi,
    DoublePointer U1, @Const IntPointer ldu1,
    DoublePointer U2, @Const IntPointer ldu2,
    DoublePointer V1T, @Const IntPointer ldv1t,
    DoublePointer V2T, @Const IntPointer ldv2t,
    DoublePointer B11D,
    DoublePointer B11E,
    DoublePointer B12D,
    DoublePointer B12E,
    DoublePointer b21d,
    DoublePointer b21e,
    DoublePointer b22d,
    DoublePointer b22e,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_dbbcsd_base(
    String jobu1, String jobu2, String jobv1t, String jobv2t, String trans,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer q,
    DoubleBuffer theta,
    DoubleBuffer phi,
    DoubleBuffer U1, @Const IntBuffer ldu1,
    DoubleBuffer U2, @Const IntBuffer ldu2,
    DoubleBuffer V1T, @Const IntBuffer ldv1t,
    DoubleBuffer V2T, @Const IntBuffer ldv2t,
    DoubleBuffer B11D,
    DoubleBuffer B11E,
    DoubleBuffer B12D,
    DoubleBuffer B12E,
    DoubleBuffer b21d,
    DoubleBuffer b21e,
    DoubleBuffer b22d,
    DoubleBuffer b22e,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_dbbcsd_base(
    @Cast("const char*") BytePointer jobu1, @Cast("const char*") BytePointer jobu2, @Cast("const char*") BytePointer jobv1t, @Cast("const char*") BytePointer jobv2t, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] p, @Const int[] q,
    double[] theta,
    double[] phi,
    double[] U1, @Const int[] ldu1,
    double[] U2, @Const int[] ldu2,
    double[] V1T, @Const int[] ldv1t,
    double[] V2T, @Const int[] ldv2t,
    double[] B11D,
    double[] B11E,
    double[] B12D,
    double[] B12E,
    double[] b21d,
    double[] b21e,
    double[] b22d,
    double[] b22e,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_dbbcsd_base(
    String jobu1, String jobu2, String jobv1t, String jobv2t, String trans,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer q,
    DoublePointer theta,
    DoublePointer phi,
    DoublePointer U1, @Const IntPointer ldu1,
    DoublePointer U2, @Const IntPointer ldu2,
    DoublePointer V1T, @Const IntPointer ldv1t,
    DoublePointer V2T, @Const IntPointer ldv2t,
    DoublePointer B11D,
    DoublePointer B11E,
    DoublePointer B12D,
    DoublePointer B12E,
    DoublePointer b21d,
    DoublePointer b21e,
    DoublePointer b22d,
    DoublePointer b22e,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_dbbcsd_base(
    @Cast("const char*") BytePointer jobu1, @Cast("const char*") BytePointer jobu2, @Cast("const char*") BytePointer jobv1t, @Cast("const char*") BytePointer jobv2t, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer q,
    DoubleBuffer theta,
    DoubleBuffer phi,
    DoubleBuffer U1, @Const IntBuffer ldu1,
    DoubleBuffer U2, @Const IntBuffer ldu2,
    DoubleBuffer V1T, @Const IntBuffer ldv1t,
    DoubleBuffer V2T, @Const IntBuffer ldv2t,
    DoubleBuffer B11D,
    DoubleBuffer B11E,
    DoubleBuffer B12D,
    DoubleBuffer B12E,
    DoubleBuffer b21d,
    DoubleBuffer b21e,
    DoubleBuffer b22d,
    DoubleBuffer b22e,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_dbbcsd_base(
    String jobu1, String jobu2, String jobv1t, String jobv2t, String trans,
    @Const int[] m, @Const int[] p, @Const int[] q,
    double[] theta,
    double[] phi,
    double[] U1, @Const int[] ldu1,
    double[] U2, @Const int[] ldu2,
    double[] V1T, @Const int[] ldv1t,
    double[] V2T, @Const int[] ldv2t,
    double[] B11D,
    double[] B11E,
    double[] B12D,
    double[] B12E,
    double[] b21d,
    double[] b21e,
    double[] b22d,
    double[] b22e,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dbbcsd(...) LAPACK_dbbcsd_base(__VA_ARGS__, 1, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sbbcsd_base(
    @Cast("const char*") BytePointer jobu1, @Cast("const char*") BytePointer jobu2, @Cast("const char*") BytePointer jobv1t, @Cast("const char*") BytePointer jobv2t, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer q,
    FloatPointer theta,
    FloatPointer phi,
    FloatPointer U1, @Const IntPointer ldu1,
    FloatPointer U2, @Const IntPointer ldu2,
    FloatPointer V1T, @Const IntPointer ldv1t,
    FloatPointer V2T, @Const IntPointer ldv2t,
    FloatPointer B11D,
    FloatPointer B11E,
    FloatPointer B12D,
    FloatPointer B12E,
    FloatPointer B21D,
    FloatPointer B21E,
    FloatPointer B22D,
    FloatPointer B22E,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_sbbcsd_base(
    String jobu1, String jobu2, String jobv1t, String jobv2t, String trans,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer q,
    FloatBuffer theta,
    FloatBuffer phi,
    FloatBuffer U1, @Const IntBuffer ldu1,
    FloatBuffer U2, @Const IntBuffer ldu2,
    FloatBuffer V1T, @Const IntBuffer ldv1t,
    FloatBuffer V2T, @Const IntBuffer ldv2t,
    FloatBuffer B11D,
    FloatBuffer B11E,
    FloatBuffer B12D,
    FloatBuffer B12E,
    FloatBuffer B21D,
    FloatBuffer B21E,
    FloatBuffer B22D,
    FloatBuffer B22E,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_sbbcsd_base(
    @Cast("const char*") BytePointer jobu1, @Cast("const char*") BytePointer jobu2, @Cast("const char*") BytePointer jobv1t, @Cast("const char*") BytePointer jobv2t, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] p, @Const int[] q,
    float[] theta,
    float[] phi,
    float[] U1, @Const int[] ldu1,
    float[] U2, @Const int[] ldu2,
    float[] V1T, @Const int[] ldv1t,
    float[] V2T, @Const int[] ldv2t,
    float[] B11D,
    float[] B11E,
    float[] B12D,
    float[] B12E,
    float[] B21D,
    float[] B21E,
    float[] B22D,
    float[] B22E,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_sbbcsd_base(
    String jobu1, String jobu2, String jobv1t, String jobv2t, String trans,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer q,
    FloatPointer theta,
    FloatPointer phi,
    FloatPointer U1, @Const IntPointer ldu1,
    FloatPointer U2, @Const IntPointer ldu2,
    FloatPointer V1T, @Const IntPointer ldv1t,
    FloatPointer V2T, @Const IntPointer ldv2t,
    FloatPointer B11D,
    FloatPointer B11E,
    FloatPointer B12D,
    FloatPointer B12E,
    FloatPointer B21D,
    FloatPointer B21E,
    FloatPointer B22D,
    FloatPointer B22E,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_sbbcsd_base(
    @Cast("const char*") BytePointer jobu1, @Cast("const char*") BytePointer jobu2, @Cast("const char*") BytePointer jobv1t, @Cast("const char*") BytePointer jobv2t, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer q,
    FloatBuffer theta,
    FloatBuffer phi,
    FloatBuffer U1, @Const IntBuffer ldu1,
    FloatBuffer U2, @Const IntBuffer ldu2,
    FloatBuffer V1T, @Const IntBuffer ldv1t,
    FloatBuffer V2T, @Const IntBuffer ldv2t,
    FloatBuffer B11D,
    FloatBuffer B11E,
    FloatBuffer B12D,
    FloatBuffer B12E,
    FloatBuffer B21D,
    FloatBuffer B21E,
    FloatBuffer B22D,
    FloatBuffer B22E,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_sbbcsd_base(
    String jobu1, String jobu2, String jobv1t, String jobv2t, String trans,
    @Const int[] m, @Const int[] p, @Const int[] q,
    float[] theta,
    float[] phi,
    float[] U1, @Const int[] ldu1,
    float[] U2, @Const int[] ldu2,
    float[] V1T, @Const int[] ldv1t,
    float[] V2T, @Const int[] ldv2t,
    float[] B11D,
    float[] B11E,
    float[] B12D,
    float[] B12E,
    float[] B21D,
    float[] B21E,
    float[] B22D,
    float[] B22E,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sbbcsd(...) LAPACK_sbbcsd_base(__VA_ARGS__, 1, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zbbcsd_base(
    @Cast("const char*") BytePointer jobu1, @Cast("const char*") BytePointer jobu2, @Cast("const char*") BytePointer jobv1t, @Cast("const char*") BytePointer jobv2t, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer q,
    DoublePointer theta,
    DoublePointer phi,
    @Cast("lapack_complex_double*") DoublePointer U1, @Const IntPointer ldu1,
    @Cast("lapack_complex_double*") DoublePointer U2, @Const IntPointer ldu2,
    @Cast("lapack_complex_double*") DoublePointer V1T, @Const IntPointer ldv1t,
    @Cast("lapack_complex_double*") DoublePointer V2T, @Const IntPointer ldv2t,
    DoublePointer B11D,
    DoublePointer B11E,
    DoublePointer B12D,
    DoublePointer B12E,
    DoublePointer B21D,
    DoublePointer B21E,
    DoublePointer B22D,
    DoublePointer B22E,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_zbbcsd_base(
    String jobu1, String jobu2, String jobv1t, String jobv2t, String trans,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer q,
    DoubleBuffer theta,
    DoubleBuffer phi,
    @Cast("lapack_complex_double*") DoubleBuffer U1, @Const IntBuffer ldu1,
    @Cast("lapack_complex_double*") DoubleBuffer U2, @Const IntBuffer ldu2,
    @Cast("lapack_complex_double*") DoubleBuffer V1T, @Const IntBuffer ldv1t,
    @Cast("lapack_complex_double*") DoubleBuffer V2T, @Const IntBuffer ldv2t,
    DoubleBuffer B11D,
    DoubleBuffer B11E,
    DoubleBuffer B12D,
    DoubleBuffer B12E,
    DoubleBuffer B21D,
    DoubleBuffer B21E,
    DoubleBuffer B22D,
    DoubleBuffer B22E,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_zbbcsd_base(
    @Cast("const char*") BytePointer jobu1, @Cast("const char*") BytePointer jobu2, @Cast("const char*") BytePointer jobv1t, @Cast("const char*") BytePointer jobv2t, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] p, @Const int[] q,
    double[] theta,
    double[] phi,
    @Cast("lapack_complex_double*") double[] U1, @Const int[] ldu1,
    @Cast("lapack_complex_double*") double[] U2, @Const int[] ldu2,
    @Cast("lapack_complex_double*") double[] V1T, @Const int[] ldv1t,
    @Cast("lapack_complex_double*") double[] V2T, @Const int[] ldv2t,
    double[] B11D,
    double[] B11E,
    double[] B12D,
    double[] B12E,
    double[] B21D,
    double[] B21E,
    double[] B22D,
    double[] B22E,
    double[] rwork, @Const int[] lrwork,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_zbbcsd_base(
    String jobu1, String jobu2, String jobv1t, String jobv2t, String trans,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer q,
    DoublePointer theta,
    DoublePointer phi,
    @Cast("lapack_complex_double*") DoublePointer U1, @Const IntPointer ldu1,
    @Cast("lapack_complex_double*") DoublePointer U2, @Const IntPointer ldu2,
    @Cast("lapack_complex_double*") DoublePointer V1T, @Const IntPointer ldv1t,
    @Cast("lapack_complex_double*") DoublePointer V2T, @Const IntPointer ldv2t,
    DoublePointer B11D,
    DoublePointer B11E,
    DoublePointer B12D,
    DoublePointer B12E,
    DoublePointer B21D,
    DoublePointer B21E,
    DoublePointer B22D,
    DoublePointer B22E,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_zbbcsd_base(
    @Cast("const char*") BytePointer jobu1, @Cast("const char*") BytePointer jobu2, @Cast("const char*") BytePointer jobv1t, @Cast("const char*") BytePointer jobv2t, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer q,
    DoubleBuffer theta,
    DoubleBuffer phi,
    @Cast("lapack_complex_double*") DoubleBuffer U1, @Const IntBuffer ldu1,
    @Cast("lapack_complex_double*") DoubleBuffer U2, @Const IntBuffer ldu2,
    @Cast("lapack_complex_double*") DoubleBuffer V1T, @Const IntBuffer ldv1t,
    @Cast("lapack_complex_double*") DoubleBuffer V2T, @Const IntBuffer ldv2t,
    DoubleBuffer B11D,
    DoubleBuffer B11E,
    DoubleBuffer B12D,
    DoubleBuffer B12E,
    DoubleBuffer B21D,
    DoubleBuffer B21E,
    DoubleBuffer B22D,
    DoubleBuffer B22E,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
public static native void LAPACK_zbbcsd_base(
    String jobu1, String jobu2, String jobv1t, String jobv2t, String trans,
    @Const int[] m, @Const int[] p, @Const int[] q,
    double[] theta,
    double[] phi,
    @Cast("lapack_complex_double*") double[] U1, @Const int[] ldu1,
    @Cast("lapack_complex_double*") double[] U2, @Const int[] ldu2,
    @Cast("lapack_complex_double*") double[] V1T, @Const int[] ldv1t,
    @Cast("lapack_complex_double*") double[] V2T, @Const int[] ldv2t,
    double[] B11D,
    double[] B11E,
    double[] B12D,
    double[] B12E,
    double[] B21D,
    double[] B21E,
    double[] B22D,
    double[] B22E,
    double[] rwork, @Const int[] lrwork,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32, @Cast("size_t") long arg33
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zbbcsd(...) LAPACK_zbbcsd_base(__VA_ARGS__, 1, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dbdsdc_base(
    @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer compq,
    @Const IntPointer n,
    DoublePointer D,
    DoublePointer E,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer VT, @Const IntPointer ldvt,
    DoublePointer Q, IntPointer IQ,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dbdsdc_base(
    String uplo, String compq,
    @Const IntBuffer n,
    DoubleBuffer D,
    DoubleBuffer E,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer VT, @Const IntBuffer ldvt,
    DoubleBuffer Q, IntBuffer IQ,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dbdsdc_base(
    @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer compq,
    @Const int[] n,
    double[] D,
    double[] E,
    double[] U, @Const int[] ldu,
    double[] VT, @Const int[] ldvt,
    double[] Q, int[] IQ,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dbdsdc_base(
    String uplo, String compq,
    @Const IntPointer n,
    DoublePointer D,
    DoublePointer E,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer VT, @Const IntPointer ldvt,
    DoublePointer Q, IntPointer IQ,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dbdsdc_base(
    @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer compq,
    @Const IntBuffer n,
    DoubleBuffer D,
    DoubleBuffer E,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer VT, @Const IntBuffer ldvt,
    DoubleBuffer Q, IntBuffer IQ,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dbdsdc_base(
    String uplo, String compq,
    @Const int[] n,
    double[] D,
    double[] E,
    double[] U, @Const int[] ldu,
    double[] VT, @Const int[] ldvt,
    double[] Q, int[] IQ,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dbdsdc(...) LAPACK_dbdsdc_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sbdsdc_base(
    @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer compq,
    @Const IntPointer n,
    FloatPointer D,
    FloatPointer E,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer VT, @Const IntPointer ldvt,
    FloatPointer Q, IntPointer IQ,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sbdsdc_base(
    String uplo, String compq,
    @Const IntBuffer n,
    FloatBuffer D,
    FloatBuffer E,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer VT, @Const IntBuffer ldvt,
    FloatBuffer Q, IntBuffer IQ,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sbdsdc_base(
    @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer compq,
    @Const int[] n,
    float[] D,
    float[] E,
    float[] U, @Const int[] ldu,
    float[] VT, @Const int[] ldvt,
    float[] Q, int[] IQ,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sbdsdc_base(
    String uplo, String compq,
    @Const IntPointer n,
    FloatPointer D,
    FloatPointer E,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer VT, @Const IntPointer ldvt,
    FloatPointer Q, IntPointer IQ,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sbdsdc_base(
    @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer compq,
    @Const IntBuffer n,
    FloatBuffer D,
    FloatBuffer E,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer VT, @Const IntBuffer ldvt,
    FloatBuffer Q, IntBuffer IQ,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sbdsdc_base(
    String uplo, String compq,
    @Const int[] n,
    float[] D,
    float[] E,
    float[] U, @Const int[] ldu,
    float[] VT, @Const int[] ldvt,
    float[] Q, int[] IQ,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sbdsdc(...) LAPACK_sbdsdc_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cbdsqr_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer ncvt, @Const IntPointer nru, @Const IntPointer ncc,
    FloatPointer D,
    FloatPointer E,
    @Cast("lapack_complex_float*") FloatPointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer C, @Const IntPointer ldc,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg15
);
public static native void LAPACK_cbdsqr_base(
    String uplo,
    @Const IntBuffer n, @Const IntBuffer ncvt, @Const IntBuffer nru, @Const IntBuffer ncc,
    FloatBuffer D,
    FloatBuffer E,
    @Cast("lapack_complex_float*") FloatBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer C, @Const IntBuffer ldc,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg15
);
public static native void LAPACK_cbdsqr_base(
    @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] ncvt, @Const int[] nru, @Const int[] ncc,
    float[] D,
    float[] E,
    @Cast("lapack_complex_float*") float[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] C, @Const int[] ldc,
    float[] rwork,
    int[] info, @Cast("size_t") long arg15
);
public static native void LAPACK_cbdsqr_base(
    String uplo,
    @Const IntPointer n, @Const IntPointer ncvt, @Const IntPointer nru, @Const IntPointer ncc,
    FloatPointer D,
    FloatPointer E,
    @Cast("lapack_complex_float*") FloatPointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer C, @Const IntPointer ldc,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg15
);
public static native void LAPACK_cbdsqr_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer ncvt, @Const IntBuffer nru, @Const IntBuffer ncc,
    FloatBuffer D,
    FloatBuffer E,
    @Cast("lapack_complex_float*") FloatBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer C, @Const IntBuffer ldc,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg15
);
public static native void LAPACK_cbdsqr_base(
    String uplo,
    @Const int[] n, @Const int[] ncvt, @Const int[] nru, @Const int[] ncc,
    float[] D,
    float[] E,
    @Cast("lapack_complex_float*") float[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] C, @Const int[] ldc,
    float[] rwork,
    int[] info, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cbdsqr(...) LAPACK_cbdsqr_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dbdsqr_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer ncvt, @Const IntPointer nru, @Const IntPointer ncc,
    DoublePointer D,
    DoublePointer E,
    DoublePointer VT, @Const IntPointer ldvt,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer C, @Const IntPointer ldc,
    DoublePointer work,
    IntPointer info, @Cast("size_t") long arg15
);
public static native void LAPACK_dbdsqr_base(
    String uplo,
    @Const IntBuffer n, @Const IntBuffer ncvt, @Const IntBuffer nru, @Const IntBuffer ncc,
    DoubleBuffer D,
    DoubleBuffer E,
    DoubleBuffer VT, @Const IntBuffer ldvt,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer C, @Const IntBuffer ldc,
    DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg15
);
public static native void LAPACK_dbdsqr_base(
    @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] ncvt, @Const int[] nru, @Const int[] ncc,
    double[] D,
    double[] E,
    double[] VT, @Const int[] ldvt,
    double[] U, @Const int[] ldu,
    double[] C, @Const int[] ldc,
    double[] work,
    int[] info, @Cast("size_t") long arg15
);
public static native void LAPACK_dbdsqr_base(
    String uplo,
    @Const IntPointer n, @Const IntPointer ncvt, @Const IntPointer nru, @Const IntPointer ncc,
    DoublePointer D,
    DoublePointer E,
    DoublePointer VT, @Const IntPointer ldvt,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer C, @Const IntPointer ldc,
    DoublePointer work,
    IntPointer info, @Cast("size_t") long arg15
);
public static native void LAPACK_dbdsqr_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer ncvt, @Const IntBuffer nru, @Const IntBuffer ncc,
    DoubleBuffer D,
    DoubleBuffer E,
    DoubleBuffer VT, @Const IntBuffer ldvt,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer C, @Const IntBuffer ldc,
    DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg15
);
public static native void LAPACK_dbdsqr_base(
    String uplo,
    @Const int[] n, @Const int[] ncvt, @Const int[] nru, @Const int[] ncc,
    double[] D,
    double[] E,
    double[] VT, @Const int[] ldvt,
    double[] U, @Const int[] ldu,
    double[] C, @Const int[] ldc,
    double[] work,
    int[] info, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dbdsqr(...) LAPACK_dbdsqr_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sbdsqr_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer ncvt, @Const IntPointer nru, @Const IntPointer ncc,
    FloatPointer D,
    FloatPointer E,
    FloatPointer VT, @Const IntPointer ldvt,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer C, @Const IntPointer ldc,
    FloatPointer work,
    IntPointer info, @Cast("size_t") long arg15
);
public static native void LAPACK_sbdsqr_base(
    String uplo,
    @Const IntBuffer n, @Const IntBuffer ncvt, @Const IntBuffer nru, @Const IntBuffer ncc,
    FloatBuffer D,
    FloatBuffer E,
    FloatBuffer VT, @Const IntBuffer ldvt,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer C, @Const IntBuffer ldc,
    FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg15
);
public static native void LAPACK_sbdsqr_base(
    @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] ncvt, @Const int[] nru, @Const int[] ncc,
    float[] D,
    float[] E,
    float[] VT, @Const int[] ldvt,
    float[] U, @Const int[] ldu,
    float[] C, @Const int[] ldc,
    float[] work,
    int[] info, @Cast("size_t") long arg15
);
public static native void LAPACK_sbdsqr_base(
    String uplo,
    @Const IntPointer n, @Const IntPointer ncvt, @Const IntPointer nru, @Const IntPointer ncc,
    FloatPointer D,
    FloatPointer E,
    FloatPointer VT, @Const IntPointer ldvt,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer C, @Const IntPointer ldc,
    FloatPointer work,
    IntPointer info, @Cast("size_t") long arg15
);
public static native void LAPACK_sbdsqr_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer ncvt, @Const IntBuffer nru, @Const IntBuffer ncc,
    FloatBuffer D,
    FloatBuffer E,
    FloatBuffer VT, @Const IntBuffer ldvt,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer C, @Const IntBuffer ldc,
    FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg15
);
public static native void LAPACK_sbdsqr_base(
    String uplo,
    @Const int[] n, @Const int[] ncvt, @Const int[] nru, @Const int[] ncc,
    float[] D,
    float[] E,
    float[] VT, @Const int[] ldvt,
    float[] U, @Const int[] ldu,
    float[] C, @Const int[] ldc,
    float[] work,
    int[] info, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sbdsqr(...) LAPACK_sbdsqr_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zbdsqr_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer ncvt, @Const IntPointer nru, @Const IntPointer ncc,
    DoublePointer D,
    DoublePointer E,
    @Cast("lapack_complex_double*") DoublePointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer C, @Const IntPointer ldc,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg15
);
public static native void LAPACK_zbdsqr_base(
    String uplo,
    @Const IntBuffer n, @Const IntBuffer ncvt, @Const IntBuffer nru, @Const IntBuffer ncc,
    DoubleBuffer D,
    DoubleBuffer E,
    @Cast("lapack_complex_double*") DoubleBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer C, @Const IntBuffer ldc,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg15
);
public static native void LAPACK_zbdsqr_base(
    @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] ncvt, @Const int[] nru, @Const int[] ncc,
    double[] D,
    double[] E,
    @Cast("lapack_complex_double*") double[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] C, @Const int[] ldc,
    double[] rwork,
    int[] info, @Cast("size_t") long arg15
);
public static native void LAPACK_zbdsqr_base(
    String uplo,
    @Const IntPointer n, @Const IntPointer ncvt, @Const IntPointer nru, @Const IntPointer ncc,
    DoublePointer D,
    DoublePointer E,
    @Cast("lapack_complex_double*") DoublePointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer C, @Const IntPointer ldc,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg15
);
public static native void LAPACK_zbdsqr_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer ncvt, @Const IntBuffer nru, @Const IntBuffer ncc,
    DoubleBuffer D,
    DoubleBuffer E,
    @Cast("lapack_complex_double*") DoubleBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer C, @Const IntBuffer ldc,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg15
);
public static native void LAPACK_zbdsqr_base(
    String uplo,
    @Const int[] n, @Const int[] ncvt, @Const int[] nru, @Const int[] ncc,
    double[] D,
    double[] E,
    @Cast("lapack_complex_double*") double[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] C, @Const int[] ldc,
    double[] rwork,
    int[] info, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zbdsqr(...) LAPACK_zbdsqr_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dbdsvdx_base(
    @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range,
    @Const IntPointer n,
    @Const DoublePointer D,
    @Const DoublePointer E,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu, IntPointer ns,
    DoublePointer S,
    DoublePointer Z, @Const IntPointer ldz,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18, @Cast("size_t") long arg19
);
public static native void LAPACK_dbdsvdx_base(
    String uplo, String jobz, String range,
    @Const IntBuffer n,
    @Const DoubleBuffer D,
    @Const DoubleBuffer E,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu, IntBuffer ns,
    DoubleBuffer S,
    DoubleBuffer Z, @Const IntBuffer ldz,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18, @Cast("size_t") long arg19
);
public static native void LAPACK_dbdsvdx_base(
    @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range,
    @Const int[] n,
    @Const double[] D,
    @Const double[] E,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu, int[] ns,
    double[] S,
    double[] Z, @Const int[] ldz,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18, @Cast("size_t") long arg19
);
public static native void LAPACK_dbdsvdx_base(
    String uplo, String jobz, String range,
    @Const IntPointer n,
    @Const DoublePointer D,
    @Const DoublePointer E,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu, IntPointer ns,
    DoublePointer S,
    DoublePointer Z, @Const IntPointer ldz,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18, @Cast("size_t") long arg19
);
public static native void LAPACK_dbdsvdx_base(
    @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range,
    @Const IntBuffer n,
    @Const DoubleBuffer D,
    @Const DoubleBuffer E,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu, IntBuffer ns,
    DoubleBuffer S,
    DoubleBuffer Z, @Const IntBuffer ldz,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18, @Cast("size_t") long arg19
);
public static native void LAPACK_dbdsvdx_base(
    String uplo, String jobz, String range,
    @Const int[] n,
    @Const double[] D,
    @Const double[] E,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu, int[] ns,
    double[] S,
    double[] Z, @Const int[] ldz,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18, @Cast("size_t") long arg19
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dbdsvdx(...) LAPACK_dbdsvdx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sbdsvdx_base(
    @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range,
    @Const IntPointer n,
    @Const FloatPointer D,
    @Const FloatPointer E,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu, IntPointer ns,
    FloatPointer S,
    FloatPointer Z, @Const IntPointer ldz,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18, @Cast("size_t") long arg19
);
public static native void LAPACK_sbdsvdx_base(
    String uplo, String jobz, String range,
    @Const IntBuffer n,
    @Const FloatBuffer D,
    @Const FloatBuffer E,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu, IntBuffer ns,
    FloatBuffer S,
    FloatBuffer Z, @Const IntBuffer ldz,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18, @Cast("size_t") long arg19
);
public static native void LAPACK_sbdsvdx_base(
    @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range,
    @Const int[] n,
    @Const float[] D,
    @Const float[] E,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu, int[] ns,
    float[] S,
    float[] Z, @Const int[] ldz,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18, @Cast("size_t") long arg19
);
public static native void LAPACK_sbdsvdx_base(
    String uplo, String jobz, String range,
    @Const IntPointer n,
    @Const FloatPointer D,
    @Const FloatPointer E,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu, IntPointer ns,
    FloatPointer S,
    FloatPointer Z, @Const IntPointer ldz,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18, @Cast("size_t") long arg19
);
public static native void LAPACK_sbdsvdx_base(
    @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range,
    @Const IntBuffer n,
    @Const FloatBuffer D,
    @Const FloatBuffer E,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu, IntBuffer ns,
    FloatBuffer S,
    FloatBuffer Z, @Const IntBuffer ldz,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18, @Cast("size_t") long arg19
);
public static native void LAPACK_sbdsvdx_base(
    String uplo, String jobz, String range,
    @Const int[] n,
    @Const float[] D,
    @Const float[] E,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu, int[] ns,
    float[] S,
    float[] Z, @Const int[] ldz,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18, @Cast("size_t") long arg19
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sbdsvdx(...) LAPACK_sbdsvdx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_ddisna_base(
    @Cast("const char*") BytePointer job,
    @Const IntPointer m, @Const IntPointer n,
    @Const DoublePointer D,
    DoublePointer SEP,
    IntPointer info, @Cast("size_t") long arg6
);
public static native void LAPACK_ddisna_base(
    String job,
    @Const IntBuffer m, @Const IntBuffer n,
    @Const DoubleBuffer D,
    DoubleBuffer SEP,
    IntBuffer info, @Cast("size_t") long arg6
);
public static native void LAPACK_ddisna_base(
    @Cast("const char*") BytePointer job,
    @Const int[] m, @Const int[] n,
    @Const double[] D,
    double[] SEP,
    int[] info, @Cast("size_t") long arg6
);
public static native void LAPACK_ddisna_base(
    String job,
    @Const IntPointer m, @Const IntPointer n,
    @Const DoublePointer D,
    DoublePointer SEP,
    IntPointer info, @Cast("size_t") long arg6
);
public static native void LAPACK_ddisna_base(
    @Cast("const char*") BytePointer job,
    @Const IntBuffer m, @Const IntBuffer n,
    @Const DoubleBuffer D,
    DoubleBuffer SEP,
    IntBuffer info, @Cast("size_t") long arg6
);
public static native void LAPACK_ddisna_base(
    String job,
    @Const int[] m, @Const int[] n,
    @Const double[] D,
    double[] SEP,
    int[] info, @Cast("size_t") long arg6
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_ddisna(...) LAPACK_ddisna_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sdisna_base(
    @Cast("const char*") BytePointer job,
    @Const IntPointer m, @Const IntPointer n,
    @Const FloatPointer D,
    FloatPointer SEP,
    IntPointer info, @Cast("size_t") long arg6
);
public static native void LAPACK_sdisna_base(
    String job,
    @Const IntBuffer m, @Const IntBuffer n,
    @Const FloatBuffer D,
    FloatBuffer SEP,
    IntBuffer info, @Cast("size_t") long arg6
);
public static native void LAPACK_sdisna_base(
    @Cast("const char*") BytePointer job,
    @Const int[] m, @Const int[] n,
    @Const float[] D,
    float[] SEP,
    int[] info, @Cast("size_t") long arg6
);
public static native void LAPACK_sdisna_base(
    String job,
    @Const IntPointer m, @Const IntPointer n,
    @Const FloatPointer D,
    FloatPointer SEP,
    IntPointer info, @Cast("size_t") long arg6
);
public static native void LAPACK_sdisna_base(
    @Cast("const char*") BytePointer job,
    @Const IntBuffer m, @Const IntBuffer n,
    @Const FloatBuffer D,
    FloatBuffer SEP,
    IntBuffer info, @Cast("size_t") long arg6
);
public static native void LAPACK_sdisna_base(
    String job,
    @Const int[] m, @Const int[] n,
    @Const float[] D,
    float[] SEP,
    int[] info, @Cast("size_t") long arg6
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sdisna(...) LAPACK_sdisna_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_cgbbrd_base(
    @Cast("const char*") BytePointer vect,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer ncc, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer D,
    FloatPointer E,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_float*") FloatPointer PT, @Const IntPointer ldpt,
    @Cast("lapack_complex_float*") FloatPointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg19
);
public static native void LAPACK_cgbbrd_base(
    String vect,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer ncc, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer D,
    FloatBuffer E,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_float*") FloatBuffer PT, @Const IntBuffer ldpt,
    @Cast("lapack_complex_float*") FloatBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg19
);
public static native void LAPACK_cgbbrd_base(
    @Cast("const char*") BytePointer vect,
    @Const int[] m, @Const int[] n, @Const int[] ncc, @Const int[] kl, @Const int[] ku,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] D,
    float[] E,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Cast("lapack_complex_float*") float[] PT, @Const int[] ldpt,
    @Cast("lapack_complex_float*") float[] C, @Const int[] ldc,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg19
);
public static native void LAPACK_cgbbrd_base(
    String vect,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer ncc, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer D,
    FloatPointer E,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_float*") FloatPointer PT, @Const IntPointer ldpt,
    @Cast("lapack_complex_float*") FloatPointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg19
);
public static native void LAPACK_cgbbrd_base(
    @Cast("const char*") BytePointer vect,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer ncc, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer D,
    FloatBuffer E,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_float*") FloatBuffer PT, @Const IntBuffer ldpt,
    @Cast("lapack_complex_float*") FloatBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg19
);
public static native void LAPACK_cgbbrd_base(
    String vect,
    @Const int[] m, @Const int[] n, @Const int[] ncc, @Const int[] kl, @Const int[] ku,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] D,
    float[] E,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Cast("lapack_complex_float*") float[] PT, @Const int[] ldpt,
    @Cast("lapack_complex_float*") float[] C, @Const int[] ldc,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg19
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgbbrd(...) LAPACK_cgbbrd_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dgbbrd_base(
    @Cast("const char*") BytePointer vect,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer ncc, @Const IntPointer kl, @Const IntPointer ku,
    DoublePointer AB, @Const IntPointer ldab,
    DoublePointer D,
    DoublePointer E,
    DoublePointer Q, @Const IntPointer ldq,
    DoublePointer PT, @Const IntPointer ldpt,
    DoublePointer C, @Const IntPointer ldc,
    DoublePointer work,
    IntPointer info, @Cast("size_t") long arg18
);
public static native void LAPACK_dgbbrd_base(
    String vect,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer ncc, @Const IntBuffer kl, @Const IntBuffer ku,
    DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer D,
    DoubleBuffer E,
    DoubleBuffer Q, @Const IntBuffer ldq,
    DoubleBuffer PT, @Const IntBuffer ldpt,
    DoubleBuffer C, @Const IntBuffer ldc,
    DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg18
);
public static native void LAPACK_dgbbrd_base(
    @Cast("const char*") BytePointer vect,
    @Const int[] m, @Const int[] n, @Const int[] ncc, @Const int[] kl, @Const int[] ku,
    double[] AB, @Const int[] ldab,
    double[] D,
    double[] E,
    double[] Q, @Const int[] ldq,
    double[] PT, @Const int[] ldpt,
    double[] C, @Const int[] ldc,
    double[] work,
    int[] info, @Cast("size_t") long arg18
);
public static native void LAPACK_dgbbrd_base(
    String vect,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer ncc, @Const IntPointer kl, @Const IntPointer ku,
    DoublePointer AB, @Const IntPointer ldab,
    DoublePointer D,
    DoublePointer E,
    DoublePointer Q, @Const IntPointer ldq,
    DoublePointer PT, @Const IntPointer ldpt,
    DoublePointer C, @Const IntPointer ldc,
    DoublePointer work,
    IntPointer info, @Cast("size_t") long arg18
);
public static native void LAPACK_dgbbrd_base(
    @Cast("const char*") BytePointer vect,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer ncc, @Const IntBuffer kl, @Const IntBuffer ku,
    DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer D,
    DoubleBuffer E,
    DoubleBuffer Q, @Const IntBuffer ldq,
    DoubleBuffer PT, @Const IntBuffer ldpt,
    DoubleBuffer C, @Const IntBuffer ldc,
    DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg18
);
public static native void LAPACK_dgbbrd_base(
    String vect,
    @Const int[] m, @Const int[] n, @Const int[] ncc, @Const int[] kl, @Const int[] ku,
    double[] AB, @Const int[] ldab,
    double[] D,
    double[] E,
    double[] Q, @Const int[] ldq,
    double[] PT, @Const int[] ldpt,
    double[] C, @Const int[] ldc,
    double[] work,
    int[] info, @Cast("size_t") long arg18
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgbbrd(...) LAPACK_dgbbrd_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sgbbrd_base(
    @Cast("const char*") BytePointer vect,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer ncc, @Const IntPointer kl, @Const IntPointer ku,
    FloatPointer AB, @Const IntPointer ldab,
    FloatPointer D,
    FloatPointer E,
    FloatPointer Q, @Const IntPointer ldq,
    FloatPointer PT, @Const IntPointer ldpt,
    FloatPointer C, @Const IntPointer ldc,
    FloatPointer work,
    IntPointer info, @Cast("size_t") long arg18
);
public static native void LAPACK_sgbbrd_base(
    String vect,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer ncc, @Const IntBuffer kl, @Const IntBuffer ku,
    FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer D,
    FloatBuffer E,
    FloatBuffer Q, @Const IntBuffer ldq,
    FloatBuffer PT, @Const IntBuffer ldpt,
    FloatBuffer C, @Const IntBuffer ldc,
    FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg18
);
public static native void LAPACK_sgbbrd_base(
    @Cast("const char*") BytePointer vect,
    @Const int[] m, @Const int[] n, @Const int[] ncc, @Const int[] kl, @Const int[] ku,
    float[] AB, @Const int[] ldab,
    float[] D,
    float[] E,
    float[] Q, @Const int[] ldq,
    float[] PT, @Const int[] ldpt,
    float[] C, @Const int[] ldc,
    float[] work,
    int[] info, @Cast("size_t") long arg18
);
public static native void LAPACK_sgbbrd_base(
    String vect,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer ncc, @Const IntPointer kl, @Const IntPointer ku,
    FloatPointer AB, @Const IntPointer ldab,
    FloatPointer D,
    FloatPointer E,
    FloatPointer Q, @Const IntPointer ldq,
    FloatPointer PT, @Const IntPointer ldpt,
    FloatPointer C, @Const IntPointer ldc,
    FloatPointer work,
    IntPointer info, @Cast("size_t") long arg18
);
public static native void LAPACK_sgbbrd_base(
    @Cast("const char*") BytePointer vect,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer ncc, @Const IntBuffer kl, @Const IntBuffer ku,
    FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer D,
    FloatBuffer E,
    FloatBuffer Q, @Const IntBuffer ldq,
    FloatBuffer PT, @Const IntBuffer ldpt,
    FloatBuffer C, @Const IntBuffer ldc,
    FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg18
);
public static native void LAPACK_sgbbrd_base(
    String vect,
    @Const int[] m, @Const int[] n, @Const int[] ncc, @Const int[] kl, @Const int[] ku,
    float[] AB, @Const int[] ldab,
    float[] D,
    float[] E,
    float[] Q, @Const int[] ldq,
    float[] PT, @Const int[] ldpt,
    float[] C, @Const int[] ldc,
    float[] work,
    int[] info, @Cast("size_t") long arg18
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgbbrd(...) LAPACK_sgbbrd_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zgbbrd_base(
    @Cast("const char*") BytePointer vect,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer ncc, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer D,
    DoublePointer E,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_double*") DoublePointer PT, @Const IntPointer ldpt,
    @Cast("lapack_complex_double*") DoublePointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg19
);
public static native void LAPACK_zgbbrd_base(
    String vect,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer ncc, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer D,
    DoubleBuffer E,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_double*") DoubleBuffer PT, @Const IntBuffer ldpt,
    @Cast("lapack_complex_double*") DoubleBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg19
);
public static native void LAPACK_zgbbrd_base(
    @Cast("const char*") BytePointer vect,
    @Const int[] m, @Const int[] n, @Const int[] ncc, @Const int[] kl, @Const int[] ku,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] D,
    double[] E,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Cast("lapack_complex_double*") double[] PT, @Const int[] ldpt,
    @Cast("lapack_complex_double*") double[] C, @Const int[] ldc,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg19
);
public static native void LAPACK_zgbbrd_base(
    String vect,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer ncc, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer D,
    DoublePointer E,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_double*") DoublePointer PT, @Const IntPointer ldpt,
    @Cast("lapack_complex_double*") DoublePointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg19
);
public static native void LAPACK_zgbbrd_base(
    @Cast("const char*") BytePointer vect,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer ncc, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer D,
    DoubleBuffer E,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_double*") DoubleBuffer PT, @Const IntBuffer ldpt,
    @Cast("lapack_complex_double*") DoubleBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg19
);
public static native void LAPACK_zgbbrd_base(
    String vect,
    @Const int[] m, @Const int[] n, @Const int[] ncc, @Const int[] kl, @Const int[] ku,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] D,
    double[] E,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Cast("lapack_complex_double*") double[] PT, @Const int[] ldpt,
    @Cast("lapack_complex_double*") double[] C, @Const int[] ldc,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg19
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgbbrd(...) LAPACK_zgbbrd_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_cgbcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("const lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_cgbcon_base(
    String norm,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("const lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_cgbcon_base(
    @Cast("const char*") BytePointer norm,
    @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Cast("const lapack_complex_float*") float[] AB, @Const int[] ldab, @Const int[] ipiv,
    @Const float[] anorm,
    float[] rcond,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg12
);
public static native void LAPACK_cgbcon_base(
    String norm,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("const lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_cgbcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("const lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_cgbcon_base(
    String norm,
    @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Cast("const lapack_complex_float*") float[] AB, @Const int[] ldab, @Const int[] ipiv,
    @Const float[] anorm,
    float[] rcond,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgbcon(...) LAPACK_cgbcon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dgbcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Const DoublePointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_dgbcon_base(
    String norm,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Const DoubleBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_dgbcon_base(
    @Cast("const char*") BytePointer norm,
    @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Const double[] AB, @Const int[] ldab, @Const int[] ipiv,
    @Const double[] anorm,
    double[] rcond,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg12
);
public static native void LAPACK_dgbcon_base(
    String norm,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Const DoublePointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_dgbcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Const DoubleBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_dgbcon_base(
    String norm,
    @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Const double[] AB, @Const int[] ldab, @Const int[] ipiv,
    @Const double[] anorm,
    double[] rcond,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgbcon(...) LAPACK_dgbcon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sgbcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Const FloatPointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_sgbcon_base(
    String norm,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Const FloatBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_sgbcon_base(
    @Cast("const char*") BytePointer norm,
    @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Const float[] AB, @Const int[] ldab, @Const int[] ipiv,
    @Const float[] anorm,
    float[] rcond,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg12
);
public static native void LAPACK_sgbcon_base(
    String norm,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Const FloatPointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_sgbcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Const FloatBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_sgbcon_base(
    String norm,
    @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Const float[] AB, @Const int[] ldab, @Const int[] ipiv,
    @Const float[] anorm,
    float[] rcond,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgbcon(...) LAPACK_sgbcon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zgbcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("const lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_zgbcon_base(
    String norm,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("const lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_zgbcon_base(
    @Cast("const char*") BytePointer norm,
    @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Cast("const lapack_complex_double*") double[] AB, @Const int[] ldab, @Const int[] ipiv,
    @Const double[] anorm,
    double[] rcond,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg12
);
public static native void LAPACK_zgbcon_base(
    String norm,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("const lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_zgbcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("const lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_zgbcon_base(
    String norm,
    @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Cast("const lapack_complex_double*") double[] AB, @Const int[] ldab, @Const int[] ipiv,
    @Const double[] anorm,
    double[] rcond,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgbcon(...) LAPACK_zgbcon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_cgbequ(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("const lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer R,
    FloatPointer C,
    FloatPointer rowcnd,
    FloatPointer colcnd,
    FloatPointer amax,
    IntPointer info );
public static native void LAPACK_cgbequ(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("const lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer R,
    FloatBuffer C,
    FloatBuffer rowcnd,
    FloatBuffer colcnd,
    FloatBuffer amax,
    IntBuffer info );
public static native void LAPACK_cgbequ(
    @Const int[] m, @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Cast("const lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] R,
    float[] C,
    float[] rowcnd,
    float[] colcnd,
    float[] amax,
    int[] info );

public static native void LAPACK_dgbequ(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Const DoublePointer AB, @Const IntPointer ldab,
    DoublePointer R,
    DoublePointer C,
    DoublePointer rowcnd,
    DoublePointer colcnd,
    DoublePointer amax,
    IntPointer info );
public static native void LAPACK_dgbequ(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Const DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer R,
    DoubleBuffer C,
    DoubleBuffer rowcnd,
    DoubleBuffer colcnd,
    DoubleBuffer amax,
    IntBuffer info );
public static native void LAPACK_dgbequ(
    @Const int[] m, @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Const double[] AB, @Const int[] ldab,
    double[] R,
    double[] C,
    double[] rowcnd,
    double[] colcnd,
    double[] amax,
    int[] info );

public static native void LAPACK_sgbequ(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Const FloatPointer AB, @Const IntPointer ldab,
    FloatPointer R,
    FloatPointer C,
    FloatPointer rowcnd,
    FloatPointer colcnd,
    FloatPointer amax,
    IntPointer info );
public static native void LAPACK_sgbequ(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Const FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer R,
    FloatBuffer C,
    FloatBuffer rowcnd,
    FloatBuffer colcnd,
    FloatBuffer amax,
    IntBuffer info );
public static native void LAPACK_sgbequ(
    @Const int[] m, @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Const float[] AB, @Const int[] ldab,
    float[] R,
    float[] C,
    float[] rowcnd,
    float[] colcnd,
    float[] amax,
    int[] info );

public static native void LAPACK_zgbequ(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("const lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer R,
    DoublePointer C,
    DoublePointer rowcnd,
    DoublePointer colcnd,
    DoublePointer amax,
    IntPointer info );
public static native void LAPACK_zgbequ(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("const lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer R,
    DoubleBuffer C,
    DoubleBuffer rowcnd,
    DoubleBuffer colcnd,
    DoubleBuffer amax,
    IntBuffer info );
public static native void LAPACK_zgbequ(
    @Const int[] m, @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Cast("const lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] R,
    double[] C,
    double[] rowcnd,
    double[] colcnd,
    double[] amax,
    int[] info );

public static native void LAPACK_cgbequb(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("const lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer R,
    FloatPointer C,
    FloatPointer rowcnd,
    FloatPointer colcnd,
    FloatPointer amax,
    IntPointer info );
public static native void LAPACK_cgbequb(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("const lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer R,
    FloatBuffer C,
    FloatBuffer rowcnd,
    FloatBuffer colcnd,
    FloatBuffer amax,
    IntBuffer info );
public static native void LAPACK_cgbequb(
    @Const int[] m, @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Cast("const lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] R,
    float[] C,
    float[] rowcnd,
    float[] colcnd,
    float[] amax,
    int[] info );

public static native void LAPACK_dgbequb(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Const DoublePointer AB, @Const IntPointer ldab,
    DoublePointer R,
    DoublePointer C,
    DoublePointer rowcnd,
    DoublePointer colcnd,
    DoublePointer amax,
    IntPointer info );
public static native void LAPACK_dgbequb(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Const DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer R,
    DoubleBuffer C,
    DoubleBuffer rowcnd,
    DoubleBuffer colcnd,
    DoubleBuffer amax,
    IntBuffer info );
public static native void LAPACK_dgbequb(
    @Const int[] m, @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Const double[] AB, @Const int[] ldab,
    double[] R,
    double[] C,
    double[] rowcnd,
    double[] colcnd,
    double[] amax,
    int[] info );

public static native void LAPACK_sgbequb(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Const FloatPointer AB, @Const IntPointer ldab,
    FloatPointer R,
    FloatPointer C,
    FloatPointer rowcnd,
    FloatPointer colcnd,
    FloatPointer amax,
    IntPointer info );
public static native void LAPACK_sgbequb(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Const FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer R,
    FloatBuffer C,
    FloatBuffer rowcnd,
    FloatBuffer colcnd,
    FloatBuffer amax,
    IntBuffer info );
public static native void LAPACK_sgbequb(
    @Const int[] m, @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Const float[] AB, @Const int[] ldab,
    float[] R,
    float[] C,
    float[] rowcnd,
    float[] colcnd,
    float[] amax,
    int[] info );

public static native void LAPACK_zgbequb(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("const lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer R,
    DoublePointer C,
    DoublePointer rowcnd,
    DoublePointer colcnd,
    DoublePointer amax,
    IntPointer info );
public static native void LAPACK_zgbequb(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("const lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer R,
    DoubleBuffer C,
    DoubleBuffer rowcnd,
    DoubleBuffer colcnd,
    DoubleBuffer amax,
    IntBuffer info );
public static native void LAPACK_zgbequb(
    @Const int[] m, @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Cast("const lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] R,
    double[] C,
    double[] rowcnd,
    double[] colcnd,
    double[] amax,
    int[] info );

public static native void LAPACK_cgbrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("const lapack_complex_float*") FloatPointer AFB, @Const IntPointer ldafb, @Const IntPointer ipiv,
    @Cast("const lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    FloatPointer ferr,
    FloatPointer berr,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg19
);
public static native void LAPACK_cgbrfs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("const lapack_complex_float*") FloatBuffer AFB, @Const IntBuffer ldafb, @Const IntBuffer ipiv,
    @Cast("const lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer ferr,
    FloatBuffer berr,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg19
);
public static native void LAPACK_cgbrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("const lapack_complex_float*") float[] AFB, @Const int[] ldafb, @Const int[] ipiv,
    @Cast("const lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    float[] ferr,
    float[] berr,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg19
);
public static native void LAPACK_cgbrfs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("const lapack_complex_float*") FloatPointer AFB, @Const IntPointer ldafb, @Const IntPointer ipiv,
    @Cast("const lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    FloatPointer ferr,
    FloatPointer berr,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg19
);
public static native void LAPACK_cgbrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("const lapack_complex_float*") FloatBuffer AFB, @Const IntBuffer ldafb, @Const IntBuffer ipiv,
    @Cast("const lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer ferr,
    FloatBuffer berr,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg19
);
public static native void LAPACK_cgbrfs_base(
    String trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("const lapack_complex_float*") float[] AFB, @Const int[] ldafb, @Const int[] ipiv,
    @Cast("const lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    float[] ferr,
    float[] berr,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg19
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgbrfs(...) LAPACK_cgbrfs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dgbrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Const DoublePointer AB, @Const IntPointer ldab,
    @Const DoublePointer AFB, @Const IntPointer ldafb, @Const IntPointer ipiv,
    @Const DoublePointer B, @Const IntPointer ldb,
    DoublePointer X, @Const IntPointer ldx,
    DoublePointer ferr,
    DoublePointer berr,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg19
);
public static native void LAPACK_dgbrfs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Const DoubleBuffer AB, @Const IntBuffer ldab,
    @Const DoubleBuffer AFB, @Const IntBuffer ldafb, @Const IntBuffer ipiv,
    @Const DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg19
);
public static native void LAPACK_dgbrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Const double[] AB, @Const int[] ldab,
    @Const double[] AFB, @Const int[] ldafb, @Const int[] ipiv,
    @Const double[] B, @Const int[] ldb,
    double[] X, @Const int[] ldx,
    double[] ferr,
    double[] berr,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg19
);
public static native void LAPACK_dgbrfs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Const DoublePointer AB, @Const IntPointer ldab,
    @Const DoublePointer AFB, @Const IntPointer ldafb, @Const IntPointer ipiv,
    @Const DoublePointer B, @Const IntPointer ldb,
    DoublePointer X, @Const IntPointer ldx,
    DoublePointer ferr,
    DoublePointer berr,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg19
);
public static native void LAPACK_dgbrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Const DoubleBuffer AB, @Const IntBuffer ldab,
    @Const DoubleBuffer AFB, @Const IntBuffer ldafb, @Const IntBuffer ipiv,
    @Const DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg19
);
public static native void LAPACK_dgbrfs_base(
    String trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Const double[] AB, @Const int[] ldab,
    @Const double[] AFB, @Const int[] ldafb, @Const int[] ipiv,
    @Const double[] B, @Const int[] ldb,
    double[] X, @Const int[] ldx,
    double[] ferr,
    double[] berr,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg19
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgbrfs(...) LAPACK_dgbrfs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sgbrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Const FloatPointer AB, @Const IntPointer ldab,
    @Const FloatPointer AFB, @Const IntPointer ldafb, @Const IntPointer ipiv,
    @Const FloatPointer B, @Const IntPointer ldb,
    FloatPointer X, @Const IntPointer ldx,
    FloatPointer ferr,
    FloatPointer berr,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg19
);
public static native void LAPACK_sgbrfs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Const FloatBuffer AB, @Const IntBuffer ldab,
    @Const FloatBuffer AFB, @Const IntBuffer ldafb, @Const IntBuffer ipiv,
    @Const FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer ferr,
    FloatBuffer berr,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg19
);
public static native void LAPACK_sgbrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Const float[] AB, @Const int[] ldab,
    @Const float[] AFB, @Const int[] ldafb, @Const int[] ipiv,
    @Const float[] B, @Const int[] ldb,
    float[] X, @Const int[] ldx,
    float[] ferr,
    float[] berr,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg19
);
public static native void LAPACK_sgbrfs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Const FloatPointer AB, @Const IntPointer ldab,
    @Const FloatPointer AFB, @Const IntPointer ldafb, @Const IntPointer ipiv,
    @Const FloatPointer B, @Const IntPointer ldb,
    FloatPointer X, @Const IntPointer ldx,
    FloatPointer ferr,
    FloatPointer berr,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg19
);
public static native void LAPACK_sgbrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Const FloatBuffer AB, @Const IntBuffer ldab,
    @Const FloatBuffer AFB, @Const IntBuffer ldafb, @Const IntBuffer ipiv,
    @Const FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer ferr,
    FloatBuffer berr,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg19
);
public static native void LAPACK_sgbrfs_base(
    String trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Const float[] AB, @Const int[] ldab,
    @Const float[] AFB, @Const int[] ldafb, @Const int[] ipiv,
    @Const float[] B, @Const int[] ldb,
    float[] X, @Const int[] ldx,
    float[] ferr,
    float[] berr,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg19
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgbrfs(...) LAPACK_sgbrfs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zgbrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("const lapack_complex_double*") DoublePointer AFB, @Const IntPointer ldafb, @Const IntPointer ipiv,
    @Cast("const lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    DoublePointer ferr,
    DoublePointer berr,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg19
);
public static native void LAPACK_zgbrfs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("const lapack_complex_double*") DoubleBuffer AFB, @Const IntBuffer ldafb, @Const IntBuffer ipiv,
    @Cast("const lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg19
);
public static native void LAPACK_zgbrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("const lapack_complex_double*") double[] AFB, @Const int[] ldafb, @Const int[] ipiv,
    @Cast("const lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    double[] ferr,
    double[] berr,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg19
);
public static native void LAPACK_zgbrfs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("const lapack_complex_double*") DoublePointer AFB, @Const IntPointer ldafb, @Const IntPointer ipiv,
    @Cast("const lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    DoublePointer ferr,
    DoublePointer berr,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg19
);
public static native void LAPACK_zgbrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("const lapack_complex_double*") DoubleBuffer AFB, @Const IntBuffer ldafb, @Const IntBuffer ipiv,
    @Cast("const lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg19
);
public static native void LAPACK_zgbrfs_base(
    String trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("const lapack_complex_double*") double[] AFB, @Const int[] ldafb, @Const int[] ipiv,
    @Cast("const lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    double[] ferr,
    double[] berr,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg19
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgbrfs(...) LAPACK_zgbrfs_base(__VA_ARGS__, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgbrfsx(...) LAPACK_cgbrfsx_base(__VA_ARGS__, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgbrfsx(...) LAPACK_dgbrfsx_base(__VA_ARGS__, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgbrfsx(...) LAPACK_sgbrfsx_base(__VA_ARGS__, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgbrfsx(...) LAPACK_zgbrfsx_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cgbsv(
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab, IntPointer ipiv,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    IntPointer info );
public static native void LAPACK_cgbsv(
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab, IntBuffer ipiv,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info );
public static native void LAPACK_cgbsv(
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab, int[] ipiv,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    int[] info );

public static native void LAPACK_dgbsv(
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    DoublePointer AB, @Const IntPointer ldab, IntPointer ipiv,
    DoublePointer B, @Const IntPointer ldb,
    IntPointer info );
public static native void LAPACK_dgbsv(
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    DoubleBuffer AB, @Const IntBuffer ldab, IntBuffer ipiv,
    DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info );
public static native void LAPACK_dgbsv(
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    double[] AB, @Const int[] ldab, int[] ipiv,
    double[] B, @Const int[] ldb,
    int[] info );

public static native void LAPACK_sgbsv(
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    FloatPointer AB, @Const IntPointer ldab, IntPointer ipiv,
    FloatPointer B, @Const IntPointer ldb,
    IntPointer info );
public static native void LAPACK_sgbsv(
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    FloatBuffer AB, @Const IntBuffer ldab, IntBuffer ipiv,
    FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info );
public static native void LAPACK_sgbsv(
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    float[] AB, @Const int[] ldab, int[] ipiv,
    float[] B, @Const int[] ldb,
    int[] info );

public static native void LAPACK_zgbsv(
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab, IntPointer ipiv,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    IntPointer info );
public static native void LAPACK_zgbsv(
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab, IntBuffer ipiv,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info );
public static native void LAPACK_zgbsv(
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab, int[] ipiv,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    int[] info );

public static native void LAPACK_cgbsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_float*") FloatPointer AFB, @Const IntPointer ldafb, IntPointer ipiv, @Cast("char*") BytePointer equed,
    FloatPointer R,
    FloatPointer C,
    @Cast("lapack_complex_float*") FloatPointer B,
    @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    FloatPointer rcond,
    FloatPointer ferr,
    FloatPointer berr,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_cgbsvx_base(
    String fact, String trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_float*") FloatBuffer AFB, @Const IntBuffer ldafb, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    FloatBuffer R,
    FloatBuffer C,
    @Cast("lapack_complex_float*") FloatBuffer B,
    @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer rcond,
    FloatBuffer ferr,
    FloatBuffer berr,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_cgbsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("lapack_complex_float*") float[] AFB, @Const int[] ldafb, int[] ipiv, @Cast("char*") byte[] equed,
    float[] R,
    float[] C,
    @Cast("lapack_complex_float*") float[] B,
    @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    float[] rcond,
    float[] ferr,
    float[] berr,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_cgbsvx_base(
    String fact, String trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_float*") FloatPointer AFB, @Const IntPointer ldafb, IntPointer ipiv, @Cast("char*") BytePointer equed,
    FloatPointer R,
    FloatPointer C,
    @Cast("lapack_complex_float*") FloatPointer B,
    @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    FloatPointer rcond,
    FloatPointer ferr,
    FloatPointer berr,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_cgbsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_float*") FloatBuffer AFB, @Const IntBuffer ldafb, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    FloatBuffer R,
    FloatBuffer C,
    @Cast("lapack_complex_float*") FloatBuffer B,
    @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer rcond,
    FloatBuffer ferr,
    FloatBuffer berr,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_cgbsvx_base(
    String fact, String trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("lapack_complex_float*") float[] AFB, @Const int[] ldafb, int[] ipiv, @Cast("char*") byte[] equed,
    float[] R,
    float[] C,
    @Cast("lapack_complex_float*") float[] B,
    @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    float[] rcond,
    float[] ferr,
    float[] berr,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgbsvx(...) LAPACK_cgbsvx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dgbsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    DoublePointer AB, @Const IntPointer ldab,
    DoublePointer AFB, @Const IntPointer ldafb, IntPointer ipiv, @Cast("char*") BytePointer equed,
    DoublePointer R,
    DoublePointer C,
    DoublePointer B,
    @Const IntPointer ldb,
    DoublePointer X, @Const IntPointer ldx,
    DoublePointer rcond,
    DoublePointer ferr,
    DoublePointer berr,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dgbsvx_base(
    String fact, String trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer AFB, @Const IntBuffer ldafb, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    DoubleBuffer R,
    DoubleBuffer C,
    DoubleBuffer B,
    @Const IntBuffer ldb,
    DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer rcond,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dgbsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    double[] AB, @Const int[] ldab,
    double[] AFB, @Const int[] ldafb, int[] ipiv, @Cast("char*") byte[] equed,
    double[] R,
    double[] C,
    double[] B,
    @Const int[] ldb,
    double[] X, @Const int[] ldx,
    double[] rcond,
    double[] ferr,
    double[] berr,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dgbsvx_base(
    String fact, String trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    DoublePointer AB, @Const IntPointer ldab,
    DoublePointer AFB, @Const IntPointer ldafb, IntPointer ipiv, @Cast("char*") BytePointer equed,
    DoublePointer R,
    DoublePointer C,
    DoublePointer B,
    @Const IntPointer ldb,
    DoublePointer X, @Const IntPointer ldx,
    DoublePointer rcond,
    DoublePointer ferr,
    DoublePointer berr,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dgbsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer AFB, @Const IntBuffer ldafb, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    DoubleBuffer R,
    DoubleBuffer C,
    DoubleBuffer B,
    @Const IntBuffer ldb,
    DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer rcond,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dgbsvx_base(
    String fact, String trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    double[] AB, @Const int[] ldab,
    double[] AFB, @Const int[] ldafb, int[] ipiv, @Cast("char*") byte[] equed,
    double[] R,
    double[] C,
    double[] B,
    @Const int[] ldb,
    double[] X, @Const int[] ldx,
    double[] rcond,
    double[] ferr,
    double[] berr,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgbsvx(...) LAPACK_dgbsvx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sgbsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    FloatPointer AB, @Const IntPointer ldab,
    FloatPointer AFB, @Const IntPointer ldafb, IntPointer ipiv, @Cast("char*") BytePointer equed,
    FloatPointer R,
    FloatPointer C,
    FloatPointer B,
    @Const IntPointer ldb,
    FloatPointer X, @Const IntPointer ldx,
    FloatPointer rcond,
    FloatPointer ferr,
    FloatPointer berr,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sgbsvx_base(
    String fact, String trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer AFB, @Const IntBuffer ldafb, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    FloatBuffer R,
    FloatBuffer C,
    FloatBuffer B,
    @Const IntBuffer ldb,
    FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer rcond,
    FloatBuffer ferr,
    FloatBuffer berr,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sgbsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    float[] AB, @Const int[] ldab,
    float[] AFB, @Const int[] ldafb, int[] ipiv, @Cast("char*") byte[] equed,
    float[] R,
    float[] C,
    float[] B,
    @Const int[] ldb,
    float[] X, @Const int[] ldx,
    float[] rcond,
    float[] ferr,
    float[] berr,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sgbsvx_base(
    String fact, String trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    FloatPointer AB, @Const IntPointer ldab,
    FloatPointer AFB, @Const IntPointer ldafb, IntPointer ipiv, @Cast("char*") BytePointer equed,
    FloatPointer R,
    FloatPointer C,
    FloatPointer B,
    @Const IntPointer ldb,
    FloatPointer X, @Const IntPointer ldx,
    FloatPointer rcond,
    FloatPointer ferr,
    FloatPointer berr,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sgbsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer AFB, @Const IntBuffer ldafb, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    FloatBuffer R,
    FloatBuffer C,
    FloatBuffer B,
    @Const IntBuffer ldb,
    FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer rcond,
    FloatBuffer ferr,
    FloatBuffer berr,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sgbsvx_base(
    String fact, String trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    float[] AB, @Const int[] ldab,
    float[] AFB, @Const int[] ldafb, int[] ipiv, @Cast("char*") byte[] equed,
    float[] R,
    float[] C,
    float[] B,
    @Const int[] ldb,
    float[] X, @Const int[] ldx,
    float[] rcond,
    float[] ferr,
    float[] berr,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgbsvx(...) LAPACK_sgbsvx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zgbsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_double*") DoublePointer AFB, @Const IntPointer ldafb, IntPointer ipiv, @Cast("char*") BytePointer equed,
    DoublePointer R,
    DoublePointer C,
    @Cast("lapack_complex_double*") DoublePointer B,
    @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    DoublePointer rcond,
    DoublePointer ferr,
    DoublePointer berr,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zgbsvx_base(
    String fact, String trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_double*") DoubleBuffer AFB, @Const IntBuffer ldafb, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    DoubleBuffer R,
    DoubleBuffer C,
    @Cast("lapack_complex_double*") DoubleBuffer B,
    @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer rcond,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zgbsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("lapack_complex_double*") double[] AFB, @Const int[] ldafb, int[] ipiv, @Cast("char*") byte[] equed,
    double[] R,
    double[] C,
    @Cast("lapack_complex_double*") double[] B,
    @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    double[] rcond,
    double[] ferr,
    double[] berr,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zgbsvx_base(
    String fact, String trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_double*") DoublePointer AFB, @Const IntPointer ldafb, IntPointer ipiv, @Cast("char*") BytePointer equed,
    DoublePointer R,
    DoublePointer C,
    @Cast("lapack_complex_double*") DoublePointer B,
    @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    DoublePointer rcond,
    DoublePointer ferr,
    DoublePointer berr,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zgbsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_double*") DoubleBuffer AFB, @Const IntBuffer ldafb, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    DoubleBuffer R,
    DoubleBuffer C,
    @Cast("lapack_complex_double*") DoubleBuffer B,
    @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer rcond,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zgbsvx_base(
    String fact, String trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("lapack_complex_double*") double[] AFB, @Const int[] ldafb, int[] ipiv, @Cast("char*") byte[] equed,
    double[] R,
    double[] C,
    @Cast("lapack_complex_double*") double[] B,
    @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    double[] rcond,
    double[] ferr,
    double[] berr,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgbsvx(...) LAPACK_zgbsvx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgbsvxx(...) LAPACK_cgbsvxx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgbsvxx(...) LAPACK_dgbsvxx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgbsvxx(...) LAPACK_sgbsvxx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgbsvxx(...) LAPACK_zgbsvxx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cgbtrf(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab, IntPointer ipiv,
    IntPointer info );
public static native void LAPACK_cgbtrf(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab, IntBuffer ipiv,
    IntBuffer info );
public static native void LAPACK_cgbtrf(
    @Const int[] m, @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab, int[] ipiv,
    int[] info );

public static native void LAPACK_dgbtrf(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    DoublePointer AB, @Const IntPointer ldab, IntPointer ipiv,
    IntPointer info );
public static native void LAPACK_dgbtrf(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    DoubleBuffer AB, @Const IntBuffer ldab, IntBuffer ipiv,
    IntBuffer info );
public static native void LAPACK_dgbtrf(
    @Const int[] m, @Const int[] n, @Const int[] kl, @Const int[] ku,
    double[] AB, @Const int[] ldab, int[] ipiv,
    int[] info );

public static native void LAPACK_sgbtrf(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    FloatPointer AB, @Const IntPointer ldab, IntPointer ipiv,
    IntPointer info );
public static native void LAPACK_sgbtrf(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    FloatBuffer AB, @Const IntBuffer ldab, IntBuffer ipiv,
    IntBuffer info );
public static native void LAPACK_sgbtrf(
    @Const int[] m, @Const int[] n, @Const int[] kl, @Const int[] ku,
    float[] AB, @Const int[] ldab, int[] ipiv,
    int[] info );

public static native void LAPACK_zgbtrf(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab, IntPointer ipiv,
    IntPointer info );
public static native void LAPACK_zgbtrf(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab, IntBuffer ipiv,
    IntBuffer info );
public static native void LAPACK_zgbtrf(
    @Const int[] m, @Const int[] n, @Const int[] kl, @Const int[] ku,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab, int[] ipiv,
    int[] info );

public static native void LAPACK_cgbtrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgbtrs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgbtrs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] AB, @Const int[] ldab, @Const int[] ipiv,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgbtrs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgbtrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgbtrs_base(
    String trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] AB, @Const int[] ldab, @Const int[] ipiv,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgbtrs(...) LAPACK_cgbtrs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dgbtrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Const DoublePointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgbtrs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Const DoubleBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgbtrs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Const double[] AB, @Const int[] ldab, @Const int[] ipiv,
    double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgbtrs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Const DoublePointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgbtrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Const DoubleBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgbtrs_base(
    String trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Const double[] AB, @Const int[] ldab, @Const int[] ipiv,
    double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgbtrs(...) LAPACK_dgbtrs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sgbtrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Const FloatPointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgbtrs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Const FloatBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgbtrs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Const float[] AB, @Const int[] ldab, @Const int[] ipiv,
    float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgbtrs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Const FloatPointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgbtrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Const FloatBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgbtrs_base(
    String trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Const float[] AB, @Const int[] ldab, @Const int[] ipiv,
    float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgbtrs(...) LAPACK_sgbtrs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zgbtrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgbtrs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgbtrs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] AB, @Const int[] ldab, @Const int[] ipiv,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgbtrs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer kl, @Const IntPointer ku, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab, @Const IntPointer ipiv,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgbtrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer kl, @Const IntBuffer ku, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab, @Const IntBuffer ipiv,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgbtrs_base(
    String trans,
    @Const int[] n, @Const int[] kl, @Const int[] ku, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] AB, @Const int[] ldab, @Const int[] ipiv,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgbtrs(...) LAPACK_zgbtrs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_cgebak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const FloatPointer scale, @Const IntPointer m,
    @Cast("lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cgebak_base(
    String job, String side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const FloatBuffer scale, @Const IntBuffer m,
    @Cast("lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cgebak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const float[] scale, @Const int[] m,
    @Cast("lapack_complex_float*") float[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cgebak_base(
    String job, String side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const FloatPointer scale, @Const IntPointer m,
    @Cast("lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cgebak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const FloatBuffer scale, @Const IntBuffer m,
    @Cast("lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cgebak_base(
    String job, String side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const float[] scale, @Const int[] m,
    @Cast("lapack_complex_float*") float[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgebak(...) LAPACK_cgebak_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_dgebak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const DoublePointer scale, @Const IntPointer m,
    DoublePointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_dgebak_base(
    String job, String side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const DoubleBuffer scale, @Const IntBuffer m,
    DoubleBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_dgebak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const double[] scale, @Const int[] m,
    double[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_dgebak_base(
    String job, String side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const DoublePointer scale, @Const IntPointer m,
    DoublePointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_dgebak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const DoubleBuffer scale, @Const IntBuffer m,
    DoubleBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_dgebak_base(
    String job, String side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const double[] scale, @Const int[] m,
    double[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgebak(...) LAPACK_dgebak_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sgebak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const FloatPointer scale, @Const IntPointer m,
    FloatPointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_sgebak_base(
    String job, String side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const FloatBuffer scale, @Const IntBuffer m,
    FloatBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_sgebak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const float[] scale, @Const int[] m,
    float[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_sgebak_base(
    String job, String side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const FloatPointer scale, @Const IntPointer m,
    FloatPointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_sgebak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const FloatBuffer scale, @Const IntBuffer m,
    FloatBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_sgebak_base(
    String job, String side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const float[] scale, @Const int[] m,
    float[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgebak(...) LAPACK_sgebak_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zgebak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const DoublePointer scale, @Const IntPointer m,
    @Cast("lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zgebak_base(
    String job, String side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const DoubleBuffer scale, @Const IntBuffer m,
    @Cast("lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zgebak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const double[] scale, @Const int[] m,
    @Cast("lapack_complex_double*") double[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zgebak_base(
    String job, String side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const DoublePointer scale, @Const IntPointer m,
    @Cast("lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zgebak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const DoubleBuffer scale, @Const IntBuffer m,
    @Cast("lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zgebak_base(
    String job, String side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const double[] scale, @Const int[] m,
    @Cast("lapack_complex_double*") double[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgebak(...) LAPACK_zgebak_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cgebal_base(
    @Cast("const char*") BytePointer job,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda, IntPointer ilo, IntPointer ihi,
    FloatPointer scale,
    IntPointer info, @Cast("size_t") long arg8
);
public static native void LAPACK_cgebal_base(
    String job,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer scale,
    IntBuffer info, @Cast("size_t") long arg8
);
public static native void LAPACK_cgebal_base(
    @Cast("const char*") BytePointer job,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda, int[] ilo, int[] ihi,
    float[] scale,
    int[] info, @Cast("size_t") long arg8
);
public static native void LAPACK_cgebal_base(
    String job,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda, IntPointer ilo, IntPointer ihi,
    FloatPointer scale,
    IntPointer info, @Cast("size_t") long arg8
);
public static native void LAPACK_cgebal_base(
    @Cast("const char*") BytePointer job,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer scale,
    IntBuffer info, @Cast("size_t") long arg8
);
public static native void LAPACK_cgebal_base(
    String job,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda, int[] ilo, int[] ihi,
    float[] scale,
    int[] info, @Cast("size_t") long arg8
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgebal(...) LAPACK_cgebal_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dgebal_base(
    @Cast("const char*") BytePointer job,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda, IntPointer ilo, IntPointer ihi,
    DoublePointer scale,
    IntPointer info, @Cast("size_t") long arg8
);
public static native void LAPACK_dgebal_base(
    String job,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer scale,
    IntBuffer info, @Cast("size_t") long arg8
);
public static native void LAPACK_dgebal_base(
    @Cast("const char*") BytePointer job,
    @Const int[] n,
    double[] A, @Const int[] lda, int[] ilo, int[] ihi,
    double[] scale,
    int[] info, @Cast("size_t") long arg8
);
public static native void LAPACK_dgebal_base(
    String job,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda, IntPointer ilo, IntPointer ihi,
    DoublePointer scale,
    IntPointer info, @Cast("size_t") long arg8
);
public static native void LAPACK_dgebal_base(
    @Cast("const char*") BytePointer job,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer scale,
    IntBuffer info, @Cast("size_t") long arg8
);
public static native void LAPACK_dgebal_base(
    String job,
    @Const int[] n,
    double[] A, @Const int[] lda, int[] ilo, int[] ihi,
    double[] scale,
    int[] info, @Cast("size_t") long arg8
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgebal(...) LAPACK_dgebal_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sgebal_base(
    @Cast("const char*") BytePointer job,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda, IntPointer ilo, IntPointer ihi,
    FloatPointer scale,
    IntPointer info, @Cast("size_t") long arg8
);
public static native void LAPACK_sgebal_base(
    String job,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer scale,
    IntBuffer info, @Cast("size_t") long arg8
);
public static native void LAPACK_sgebal_base(
    @Cast("const char*") BytePointer job,
    @Const int[] n,
    float[] A, @Const int[] lda, int[] ilo, int[] ihi,
    float[] scale,
    int[] info, @Cast("size_t") long arg8
);
public static native void LAPACK_sgebal_base(
    String job,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda, IntPointer ilo, IntPointer ihi,
    FloatPointer scale,
    IntPointer info, @Cast("size_t") long arg8
);
public static native void LAPACK_sgebal_base(
    @Cast("const char*") BytePointer job,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer scale,
    IntBuffer info, @Cast("size_t") long arg8
);
public static native void LAPACK_sgebal_base(
    String job,
    @Const int[] n,
    float[] A, @Const int[] lda, int[] ilo, int[] ihi,
    float[] scale,
    int[] info, @Cast("size_t") long arg8
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgebal(...) LAPACK_sgebal_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zgebal_base(
    @Cast("const char*") BytePointer job,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda, IntPointer ilo, IntPointer ihi,
    DoublePointer scale,
    IntPointer info, @Cast("size_t") long arg8
);
public static native void LAPACK_zgebal_base(
    String job,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer scale,
    IntBuffer info, @Cast("size_t") long arg8
);
public static native void LAPACK_zgebal_base(
    @Cast("const char*") BytePointer job,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda, int[] ilo, int[] ihi,
    double[] scale,
    int[] info, @Cast("size_t") long arg8
);
public static native void LAPACK_zgebal_base(
    String job,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda, IntPointer ilo, IntPointer ihi,
    DoublePointer scale,
    IntPointer info, @Cast("size_t") long arg8
);
public static native void LAPACK_zgebal_base(
    @Cast("const char*") BytePointer job,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer scale,
    IntBuffer info, @Cast("size_t") long arg8
);
public static native void LAPACK_zgebal_base(
    String job,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda, int[] ilo, int[] ihi,
    double[] scale,
    int[] info, @Cast("size_t") long arg8
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgebal(...) LAPACK_zgebal_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_cgebrd(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer D,
    FloatPointer E,
    @Cast("lapack_complex_float*") FloatPointer tauq,
    @Cast("lapack_complex_float*") FloatPointer taup,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cgebrd(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer D,
    FloatBuffer E,
    @Cast("lapack_complex_float*") FloatBuffer tauq,
    @Cast("lapack_complex_float*") FloatBuffer taup,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cgebrd(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] D,
    float[] E,
    @Cast("lapack_complex_float*") float[] tauq,
    @Cast("lapack_complex_float*") float[] taup,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dgebrd(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer D,
    DoublePointer E,
    DoublePointer tauq,
    DoublePointer taup,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgebrd(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer D,
    DoubleBuffer E,
    DoubleBuffer tauq,
    DoubleBuffer taup,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgebrd(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] D,
    double[] E,
    double[] tauq,
    double[] taup,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgebrd(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer D,
    FloatPointer E,
    FloatPointer tauq,
    FloatPointer taup,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgebrd(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer D,
    FloatBuffer E,
    FloatBuffer tauq,
    FloatBuffer taup,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgebrd(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] D,
    float[] E,
    float[] tauq,
    float[] taup,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgebrd(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer D,
    DoublePointer E,
    @Cast("lapack_complex_double*") DoublePointer tauq,
    @Cast("lapack_complex_double*") DoublePointer taup,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zgebrd(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer D,
    DoubleBuffer E,
    @Cast("lapack_complex_double*") DoubleBuffer tauq,
    @Cast("lapack_complex_double*") DoubleBuffer taup,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zgebrd(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] D,
    double[] E,
    @Cast("lapack_complex_double*") double[] tauq,
    @Cast("lapack_complex_double*") double[] taup,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_cgecon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntPointer n,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_cgecon_base(
    String norm,
    @Const IntBuffer n,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_cgecon_base(
    @Cast("const char*") BytePointer norm,
    @Const int[] n,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    @Const float[] anorm,
    float[] rcond,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg9
);
public static native void LAPACK_cgecon_base(
    String norm,
    @Const IntPointer n,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_cgecon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntBuffer n,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_cgecon_base(
    String norm,
    @Const int[] n,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    @Const float[] anorm,
    float[] rcond,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg9
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgecon(...) LAPACK_cgecon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dgecon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntPointer n,
    @Const DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_dgecon_base(
    String norm,
    @Const IntBuffer n,
    @Const DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_dgecon_base(
    @Cast("const char*") BytePointer norm,
    @Const int[] n,
    @Const double[] A, @Const int[] lda,
    @Const double[] anorm,
    double[] rcond,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg9
);
public static native void LAPACK_dgecon_base(
    String norm,
    @Const IntPointer n,
    @Const DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_dgecon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntBuffer n,
    @Const DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_dgecon_base(
    String norm,
    @Const int[] n,
    @Const double[] A, @Const int[] lda,
    @Const double[] anorm,
    double[] rcond,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg9
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgecon(...) LAPACK_dgecon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sgecon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntPointer n,
    @Const FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_sgecon_base(
    String norm,
    @Const IntBuffer n,
    @Const FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_sgecon_base(
    @Cast("const char*") BytePointer norm,
    @Const int[] n,
    @Const float[] A, @Const int[] lda,
    @Const float[] anorm,
    float[] rcond,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg9
);
public static native void LAPACK_sgecon_base(
    String norm,
    @Const IntPointer n,
    @Const FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_sgecon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntBuffer n,
    @Const FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_sgecon_base(
    String norm,
    @Const int[] n,
    @Const float[] A, @Const int[] lda,
    @Const float[] anorm,
    float[] rcond,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg9
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgecon(...) LAPACK_sgecon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zgecon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntPointer n,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_zgecon_base(
    String norm,
    @Const IntBuffer n,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_zgecon_base(
    @Cast("const char*") BytePointer norm,
    @Const int[] n,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    @Const double[] anorm,
    double[] rcond,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg9
);
public static native void LAPACK_zgecon_base(
    String norm,
    @Const IntPointer n,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_zgecon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntBuffer n,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_zgecon_base(
    String norm,
    @Const int[] n,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    @Const double[] anorm,
    double[] rcond,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg9
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgecon(...) LAPACK_zgecon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_cgeequ(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer R,
    FloatPointer C,
    FloatPointer rowcnd,
    FloatPointer colcnd,
    FloatPointer amax,
    IntPointer info );
public static native void LAPACK_cgeequ(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer R,
    FloatBuffer C,
    FloatBuffer rowcnd,
    FloatBuffer colcnd,
    FloatBuffer amax,
    IntBuffer info );
public static native void LAPACK_cgeequ(
    @Const int[] m, @Const int[] n,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    float[] R,
    float[] C,
    float[] rowcnd,
    float[] colcnd,
    float[] amax,
    int[] info );

public static native void LAPACK_dgeequ(
    @Const IntPointer m, @Const IntPointer n,
    @Const DoublePointer A, @Const IntPointer lda,
    DoublePointer R,
    DoublePointer C,
    DoublePointer rowcnd,
    DoublePointer colcnd,
    DoublePointer amax,
    IntPointer info );
public static native void LAPACK_dgeequ(
    @Const IntBuffer m, @Const IntBuffer n,
    @Const DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer R,
    DoubleBuffer C,
    DoubleBuffer rowcnd,
    DoubleBuffer colcnd,
    DoubleBuffer amax,
    IntBuffer info );
public static native void LAPACK_dgeequ(
    @Const int[] m, @Const int[] n,
    @Const double[] A, @Const int[] lda,
    double[] R,
    double[] C,
    double[] rowcnd,
    double[] colcnd,
    double[] amax,
    int[] info );

public static native void LAPACK_sgeequ(
    @Const IntPointer m, @Const IntPointer n,
    @Const FloatPointer A, @Const IntPointer lda,
    FloatPointer R,
    FloatPointer C,
    FloatPointer rowcnd,
    FloatPointer colcnd,
    FloatPointer amax,
    IntPointer info );
public static native void LAPACK_sgeequ(
    @Const IntBuffer m, @Const IntBuffer n,
    @Const FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer R,
    FloatBuffer C,
    FloatBuffer rowcnd,
    FloatBuffer colcnd,
    FloatBuffer amax,
    IntBuffer info );
public static native void LAPACK_sgeequ(
    @Const int[] m, @Const int[] n,
    @Const float[] A, @Const int[] lda,
    float[] R,
    float[] C,
    float[] rowcnd,
    float[] colcnd,
    float[] amax,
    int[] info );

public static native void LAPACK_zgeequ(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer R,
    DoublePointer C,
    DoublePointer rowcnd,
    DoublePointer colcnd,
    DoublePointer amax,
    IntPointer info );
public static native void LAPACK_zgeequ(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer R,
    DoubleBuffer C,
    DoubleBuffer rowcnd,
    DoubleBuffer colcnd,
    DoubleBuffer amax,
    IntBuffer info );
public static native void LAPACK_zgeequ(
    @Const int[] m, @Const int[] n,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    double[] R,
    double[] C,
    double[] rowcnd,
    double[] colcnd,
    double[] amax,
    int[] info );

public static native void LAPACK_cgeequb(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer R,
    FloatPointer C,
    FloatPointer rowcnd,
    FloatPointer colcnd,
    FloatPointer amax,
    IntPointer info );
public static native void LAPACK_cgeequb(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer R,
    FloatBuffer C,
    FloatBuffer rowcnd,
    FloatBuffer colcnd,
    FloatBuffer amax,
    IntBuffer info );
public static native void LAPACK_cgeequb(
    @Const int[] m, @Const int[] n,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    float[] R,
    float[] C,
    float[] rowcnd,
    float[] colcnd,
    float[] amax,
    int[] info );

public static native void LAPACK_dgeequb(
    @Const IntPointer m, @Const IntPointer n,
    @Const DoublePointer A, @Const IntPointer lda,
    DoublePointer R,
    DoublePointer C,
    DoublePointer rowcnd,
    DoublePointer colcnd,
    DoublePointer amax,
    IntPointer info );
public static native void LAPACK_dgeequb(
    @Const IntBuffer m, @Const IntBuffer n,
    @Const DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer R,
    DoubleBuffer C,
    DoubleBuffer rowcnd,
    DoubleBuffer colcnd,
    DoubleBuffer amax,
    IntBuffer info );
public static native void LAPACK_dgeequb(
    @Const int[] m, @Const int[] n,
    @Const double[] A, @Const int[] lda,
    double[] R,
    double[] C,
    double[] rowcnd,
    double[] colcnd,
    double[] amax,
    int[] info );

public static native void LAPACK_sgeequb(
    @Const IntPointer m, @Const IntPointer n,
    @Const FloatPointer A, @Const IntPointer lda,
    FloatPointer R,
    FloatPointer C,
    FloatPointer rowcnd,
    FloatPointer colcnd,
    FloatPointer amax,
    IntPointer info );
public static native void LAPACK_sgeequb(
    @Const IntBuffer m, @Const IntBuffer n,
    @Const FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer R,
    FloatBuffer C,
    FloatBuffer rowcnd,
    FloatBuffer colcnd,
    FloatBuffer amax,
    IntBuffer info );
public static native void LAPACK_sgeequb(
    @Const int[] m, @Const int[] n,
    @Const float[] A, @Const int[] lda,
    float[] R,
    float[] C,
    float[] rowcnd,
    float[] colcnd,
    float[] amax,
    int[] info );

public static native void LAPACK_zgeequb(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer R,
    DoublePointer C,
    DoublePointer rowcnd,
    DoublePointer colcnd,
    DoublePointer amax,
    IntPointer info );
public static native void LAPACK_zgeequb(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer R,
    DoubleBuffer C,
    DoubleBuffer rowcnd,
    DoubleBuffer colcnd,
    DoubleBuffer amax,
    IntBuffer info );
public static native void LAPACK_zgeequb(
    @Const int[] m, @Const int[] n,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    double[] R,
    double[] C,
    double[] rowcnd,
    double[] colcnd,
    double[] amax,
    int[] info );

public static native void LAPACK_cgees_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT1 select,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda, IntPointer sdim,
    @Cast("lapack_complex_float*") FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer VS, @Const IntPointer ldvs,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_cgees_base(
    String jobvs, String sort, LAPACK_C_SELECT1 select,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    @Cast("lapack_complex_float*") FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer VS, @Const IntBuffer ldvs,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_cgees_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT1 select,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda, int[] sdim,
    @Cast("lapack_complex_float*") float[] W,
    @Cast("lapack_complex_float*") float[] VS, @Const int[] ldvs,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_cgees_base(
    String jobvs, String sort, LAPACK_C_SELECT1 select,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda, IntPointer sdim,
    @Cast("lapack_complex_float*") FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer VS, @Const IntPointer ldvs,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_cgees_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT1 select,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    @Cast("lapack_complex_float*") FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer VS, @Const IntBuffer ldvs,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_cgees_base(
    String jobvs, String sort, LAPACK_C_SELECT1 select,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda, int[] sdim,
    @Cast("lapack_complex_float*") float[] W,
    @Cast("lapack_complex_float*") float[] VS, @Const int[] ldvs,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgees(...) LAPACK_cgees_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_dgees_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT2 select,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda, IntPointer sdim,
    DoublePointer WR,
    DoublePointer WI,
    DoublePointer VS, @Const IntPointer ldvs,
    DoublePointer work, @Const IntPointer lwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_dgees_base(
    String jobvs, String sort, LAPACK_D_SELECT2 select,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    DoubleBuffer WR,
    DoubleBuffer WI,
    DoubleBuffer VS, @Const IntBuffer ldvs,
    DoubleBuffer work, @Const IntBuffer lwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_dgees_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT2 select,
    @Const int[] n,
    double[] A, @Const int[] lda, int[] sdim,
    double[] WR,
    double[] WI,
    double[] VS, @Const int[] ldvs,
    double[] work, @Const int[] lwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_dgees_base(
    String jobvs, String sort, LAPACK_D_SELECT2 select,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda, IntPointer sdim,
    DoublePointer WR,
    DoublePointer WI,
    DoublePointer VS, @Const IntPointer ldvs,
    DoublePointer work, @Const IntPointer lwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_dgees_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT2 select,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    DoubleBuffer WR,
    DoubleBuffer WI,
    DoubleBuffer VS, @Const IntBuffer ldvs,
    DoubleBuffer work, @Const IntBuffer lwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_dgees_base(
    String jobvs, String sort, LAPACK_D_SELECT2 select,
    @Const int[] n,
    double[] A, @Const int[] lda, int[] sdim,
    double[] WR,
    double[] WI,
    double[] VS, @Const int[] ldvs,
    double[] work, @Const int[] lwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgees(...) LAPACK_dgees_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sgees_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT2 select,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda, IntPointer sdim,
    FloatPointer WR,
    FloatPointer WI,
    FloatPointer VS, @Const IntPointer ldvs,
    FloatPointer work, @Const IntPointer lwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_sgees_base(
    String jobvs, String sort, LAPACK_S_SELECT2 select,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    FloatBuffer WR,
    FloatBuffer WI,
    FloatBuffer VS, @Const IntBuffer ldvs,
    FloatBuffer work, @Const IntBuffer lwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_sgees_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT2 select,
    @Const int[] n,
    float[] A, @Const int[] lda, int[] sdim,
    float[] WR,
    float[] WI,
    float[] VS, @Const int[] ldvs,
    float[] work, @Const int[] lwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_sgees_base(
    String jobvs, String sort, LAPACK_S_SELECT2 select,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda, IntPointer sdim,
    FloatPointer WR,
    FloatPointer WI,
    FloatPointer VS, @Const IntPointer ldvs,
    FloatPointer work, @Const IntPointer lwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_sgees_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT2 select,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    FloatBuffer WR,
    FloatBuffer WI,
    FloatBuffer VS, @Const IntBuffer ldvs,
    FloatBuffer work, @Const IntBuffer lwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_sgees_base(
    String jobvs, String sort, LAPACK_S_SELECT2 select,
    @Const int[] n,
    float[] A, @Const int[] lda, int[] sdim,
    float[] WR,
    float[] WI,
    float[] VS, @Const int[] ldvs,
    float[] work, @Const int[] lwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgees(...) LAPACK_sgees_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zgees_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT1 select,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda, IntPointer sdim,
    @Cast("lapack_complex_double*") DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer VS, @Const IntPointer ldvs,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zgees_base(
    String jobvs, String sort, LAPACK_Z_SELECT1 select,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    @Cast("lapack_complex_double*") DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer VS, @Const IntBuffer ldvs,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zgees_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT1 select,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda, int[] sdim,
    @Cast("lapack_complex_double*") double[] W,
    @Cast("lapack_complex_double*") double[] VS, @Const int[] ldvs,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zgees_base(
    String jobvs, String sort, LAPACK_Z_SELECT1 select,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda, IntPointer sdim,
    @Cast("lapack_complex_double*") DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer VS, @Const IntPointer ldvs,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zgees_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT1 select,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    @Cast("lapack_complex_double*") DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer VS, @Const IntBuffer ldvs,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zgees_base(
    String jobvs, String sort, LAPACK_Z_SELECT1 select,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda, int[] sdim,
    @Cast("lapack_complex_double*") double[] W,
    @Cast("lapack_complex_double*") double[] VS, @Const int[] ldvs,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgees(...) LAPACK_zgees_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cgeesx_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT1 select, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda, IntPointer sdim,
    @Cast("lapack_complex_float*") FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer VS, @Const IntPointer ldvs,
    FloatPointer rconde,
    FloatPointer rcondv,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg18, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_cgeesx_base(
    String jobvs, String sort, LAPACK_C_SELECT1 select, String sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    @Cast("lapack_complex_float*") FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer VS, @Const IntBuffer ldvs,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg18, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_cgeesx_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT1 select, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda, int[] sdim,
    @Cast("lapack_complex_float*") float[] W,
    @Cast("lapack_complex_float*") float[] VS, @Const int[] ldvs,
    float[] rconde,
    float[] rcondv,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg18, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_cgeesx_base(
    String jobvs, String sort, LAPACK_C_SELECT1 select, String sense,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda, IntPointer sdim,
    @Cast("lapack_complex_float*") FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer VS, @Const IntPointer ldvs,
    FloatPointer rconde,
    FloatPointer rcondv,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg18, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_cgeesx_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT1 select, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    @Cast("lapack_complex_float*") FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer VS, @Const IntBuffer ldvs,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg18, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_cgeesx_base(
    String jobvs, String sort, LAPACK_C_SELECT1 select, String sense,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda, int[] sdim,
    @Cast("lapack_complex_float*") float[] W,
    @Cast("lapack_complex_float*") float[] VS, @Const int[] ldvs,
    float[] rconde,
    float[] rcondv,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg18, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgeesx(...) LAPACK_cgeesx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dgeesx_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT2 select, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda, IntPointer sdim,
    DoublePointer WR,
    DoublePointer WI,
    DoublePointer VS, @Const IntPointer ldvs,
    DoublePointer rconde,
    DoublePointer rcondv,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork, @Const IntPointer liwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22
);
public static native void LAPACK_dgeesx_base(
    String jobvs, String sort, LAPACK_D_SELECT2 select, String sense,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    DoubleBuffer WR,
    DoubleBuffer WI,
    DoubleBuffer VS, @Const IntBuffer ldvs,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork, @Const IntBuffer liwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22
);
public static native void LAPACK_dgeesx_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT2 select, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    double[] A, @Const int[] lda, int[] sdim,
    double[] WR,
    double[] WI,
    double[] VS, @Const int[] ldvs,
    double[] rconde,
    double[] rcondv,
    double[] work, @Const int[] lwork,
    int[] iwork, @Const int[] liwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22
);
public static native void LAPACK_dgeesx_base(
    String jobvs, String sort, LAPACK_D_SELECT2 select, String sense,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda, IntPointer sdim,
    DoublePointer WR,
    DoublePointer WI,
    DoublePointer VS, @Const IntPointer ldvs,
    DoublePointer rconde,
    DoublePointer rcondv,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork, @Const IntPointer liwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22
);
public static native void LAPACK_dgeesx_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT2 select, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    DoubleBuffer WR,
    DoubleBuffer WI,
    DoubleBuffer VS, @Const IntBuffer ldvs,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork, @Const IntBuffer liwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22
);
public static native void LAPACK_dgeesx_base(
    String jobvs, String sort, LAPACK_D_SELECT2 select, String sense,
    @Const int[] n,
    double[] A, @Const int[] lda, int[] sdim,
    double[] WR,
    double[] WI,
    double[] VS, @Const int[] ldvs,
    double[] rconde,
    double[] rcondv,
    double[] work, @Const int[] lwork,
    int[] iwork, @Const int[] liwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgeesx(...) LAPACK_dgeesx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sgeesx_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT2 select, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda, IntPointer sdim,
    FloatPointer WR,
    FloatPointer WI,
    FloatPointer VS, @Const IntPointer ldvs,
    FloatPointer rconde,
    FloatPointer rcondv,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork, @Const IntPointer liwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22
);
public static native void LAPACK_sgeesx_base(
    String jobvs, String sort, LAPACK_S_SELECT2 select, String sense,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    FloatBuffer WR,
    FloatBuffer WI,
    FloatBuffer VS, @Const IntBuffer ldvs,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork, @Const IntBuffer liwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22
);
public static native void LAPACK_sgeesx_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT2 select, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    float[] A, @Const int[] lda, int[] sdim,
    float[] WR,
    float[] WI,
    float[] VS, @Const int[] ldvs,
    float[] rconde,
    float[] rcondv,
    float[] work, @Const int[] lwork,
    int[] iwork, @Const int[] liwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22
);
public static native void LAPACK_sgeesx_base(
    String jobvs, String sort, LAPACK_S_SELECT2 select, String sense,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda, IntPointer sdim,
    FloatPointer WR,
    FloatPointer WI,
    FloatPointer VS, @Const IntPointer ldvs,
    FloatPointer rconde,
    FloatPointer rcondv,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork, @Const IntPointer liwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22
);
public static native void LAPACK_sgeesx_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT2 select, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    FloatBuffer WR,
    FloatBuffer WI,
    FloatBuffer VS, @Const IntBuffer ldvs,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork, @Const IntBuffer liwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22
);
public static native void LAPACK_sgeesx_base(
    String jobvs, String sort, LAPACK_S_SELECT2 select, String sense,
    @Const int[] n,
    float[] A, @Const int[] lda, int[] sdim,
    float[] WR,
    float[] WI,
    float[] VS, @Const int[] ldvs,
    float[] rconde,
    float[] rcondv,
    float[] work, @Const int[] lwork,
    int[] iwork, @Const int[] liwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgeesx(...) LAPACK_sgeesx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zgeesx_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT1 select, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda, IntPointer sdim,
    @Cast("lapack_complex_double*") DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer VS, @Const IntPointer ldvs,
    DoublePointer rconde,
    DoublePointer rcondv,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg18, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_zgeesx_base(
    String jobvs, String sort, LAPACK_Z_SELECT1 select, String sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    @Cast("lapack_complex_double*") DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer VS, @Const IntBuffer ldvs,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg18, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_zgeesx_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT1 select, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda, int[] sdim,
    @Cast("lapack_complex_double*") double[] W,
    @Cast("lapack_complex_double*") double[] VS, @Const int[] ldvs,
    double[] rconde,
    double[] rcondv,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg18, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_zgeesx_base(
    String jobvs, String sort, LAPACK_Z_SELECT1 select, String sense,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda, IntPointer sdim,
    @Cast("lapack_complex_double*") DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer VS, @Const IntPointer ldvs,
    DoublePointer rconde,
    DoublePointer rcondv,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg18, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_zgeesx_base(
    @Cast("const char*") BytePointer jobvs, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT1 select, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, IntBuffer sdim,
    @Cast("lapack_complex_double*") DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer VS, @Const IntBuffer ldvs,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg18, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_zgeesx_base(
    String jobvs, String sort, LAPACK_Z_SELECT1 select, String sense,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda, int[] sdim,
    @Cast("lapack_complex_double*") double[] W,
    @Cast("lapack_complex_double*") double[] VS, @Const int[] ldvs,
    double[] rconde,
    double[] rcondv,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg18, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgeesx(...) LAPACK_zgeesx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cgeev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_float*") FloatPointer VR, @Const IntPointer ldvr,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgeev_base(
    String jobvl, String jobvr,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_float*") FloatBuffer VR, @Const IntBuffer ldvr,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgeev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] W,
    @Cast("lapack_complex_float*") float[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_float*") float[] VR, @Const int[] ldvr,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgeev_base(
    String jobvl, String jobvr,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_float*") FloatPointer VR, @Const IntPointer ldvr,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgeev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_float*") FloatBuffer VR, @Const IntBuffer ldvr,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgeev_base(
    String jobvl, String jobvr,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] W,
    @Cast("lapack_complex_float*") float[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_float*") float[] VR, @Const int[] ldvr,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgeev(...) LAPACK_cgeev_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_dgeev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer WR,
    DoublePointer WI,
    DoublePointer VL, @Const IntPointer ldvl,
    DoublePointer VR, @Const IntPointer ldvr,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgeev_base(
    String jobvl, String jobvr,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer WR,
    DoubleBuffer WI,
    DoubleBuffer VL, @Const IntBuffer ldvl,
    DoubleBuffer VR, @Const IntBuffer ldvr,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgeev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] WR,
    double[] WI,
    double[] VL, @Const int[] ldvl,
    double[] VR, @Const int[] ldvr,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgeev_base(
    String jobvl, String jobvr,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer WR,
    DoublePointer WI,
    DoublePointer VL, @Const IntPointer ldvl,
    DoublePointer VR, @Const IntPointer ldvr,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgeev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer WR,
    DoubleBuffer WI,
    DoubleBuffer VL, @Const IntBuffer ldvl,
    DoubleBuffer VR, @Const IntBuffer ldvr,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgeev_base(
    String jobvl, String jobvr,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] WR,
    double[] WI,
    double[] VL, @Const int[] ldvl,
    double[] VR, @Const int[] ldvr,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgeev(...) LAPACK_dgeev_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sgeev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer WR,
    FloatPointer WI,
    FloatPointer VL, @Const IntPointer ldvl,
    FloatPointer VR, @Const IntPointer ldvr,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgeev_base(
    String jobvl, String jobvr,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer WR,
    FloatBuffer WI,
    FloatBuffer VL, @Const IntBuffer ldvl,
    FloatBuffer VR, @Const IntBuffer ldvr,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgeev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] WR,
    float[] WI,
    float[] VL, @Const int[] ldvl,
    float[] VR, @Const int[] ldvr,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgeev_base(
    String jobvl, String jobvr,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer WR,
    FloatPointer WI,
    FloatPointer VL, @Const IntPointer ldvl,
    FloatPointer VR, @Const IntPointer ldvr,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgeev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer WR,
    FloatBuffer WI,
    FloatBuffer VL, @Const IntBuffer ldvl,
    FloatBuffer VR, @Const IntBuffer ldvr,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgeev_base(
    String jobvl, String jobvr,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] WR,
    float[] WI,
    float[] VL, @Const int[] ldvl,
    float[] VR, @Const int[] ldvr,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgeev(...) LAPACK_sgeev_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zgeev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_double*") DoublePointer VR, @Const IntPointer ldvr,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgeev_base(
    String jobvl, String jobvr,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_double*") DoubleBuffer VR, @Const IntBuffer ldvr,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgeev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] W,
    @Cast("lapack_complex_double*") double[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_double*") double[] VR, @Const int[] ldvr,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgeev_base(
    String jobvl, String jobvr,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_double*") DoublePointer VR, @Const IntPointer ldvr,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgeev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_double*") DoubleBuffer VR, @Const IntBuffer ldvr,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgeev_base(
    String jobvl, String jobvr,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] W,
    @Cast("lapack_complex_double*") double[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_double*") double[] VR, @Const int[] ldvr,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgeev(...) LAPACK_zgeev_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cgeevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_float*") FloatPointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    FloatPointer scale,
    FloatPointer abnrm,
    FloatPointer rconde,
    FloatPointer rcondv,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cgeevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_float*") FloatBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer scale,
    FloatBuffer abnrm,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cgeevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] W,
    @Cast("lapack_complex_float*") float[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_float*") float[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    float[] scale,
    float[] abnrm,
    float[] rconde,
    float[] rcondv,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cgeevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_float*") FloatPointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    FloatPointer scale,
    FloatPointer abnrm,
    FloatPointer rconde,
    FloatPointer rcondv,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cgeevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_float*") FloatBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer scale,
    FloatBuffer abnrm,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cgeevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] W,
    @Cast("lapack_complex_float*") float[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_float*") float[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    float[] scale,
    float[] abnrm,
    float[] rconde,
    float[] rcondv,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgeevx(...) LAPACK_cgeevx_base(__VA_ARGS__, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dgeevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer WR,
    DoublePointer WI,
    DoublePointer VL, @Const IntPointer ldvl,
    DoublePointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    DoublePointer scale,
    DoublePointer abnrm,
    DoublePointer rconde,
    DoublePointer rcondv,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dgeevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer WR,
    DoubleBuffer WI,
    DoubleBuffer VL, @Const IntBuffer ldvl,
    DoubleBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer scale,
    DoubleBuffer abnrm,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dgeevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] WR,
    double[] WI,
    double[] VL, @Const int[] ldvl,
    double[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    double[] scale,
    double[] abnrm,
    double[] rconde,
    double[] rcondv,
    double[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dgeevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer WR,
    DoublePointer WI,
    DoublePointer VL, @Const IntPointer ldvl,
    DoublePointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    DoublePointer scale,
    DoublePointer abnrm,
    DoublePointer rconde,
    DoublePointer rcondv,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dgeevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer WR,
    DoubleBuffer WI,
    DoubleBuffer VL, @Const IntBuffer ldvl,
    DoubleBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer scale,
    DoubleBuffer abnrm,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dgeevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] WR,
    double[] WI,
    double[] VL, @Const int[] ldvl,
    double[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    double[] scale,
    double[] abnrm,
    double[] rconde,
    double[] rcondv,
    double[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgeevx(...) LAPACK_dgeevx_base(__VA_ARGS__, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sgeevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer WR,
    FloatPointer WI,
    FloatPointer VL, @Const IntPointer ldvl,
    FloatPointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    FloatPointer scale,
    FloatPointer abnrm,
    FloatPointer rconde,
    FloatPointer rcondv,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sgeevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer WR,
    FloatBuffer WI,
    FloatBuffer VL, @Const IntBuffer ldvl,
    FloatBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer scale,
    FloatBuffer abnrm,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sgeevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] WR,
    float[] WI,
    float[] VL, @Const int[] ldvl,
    float[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    float[] scale,
    float[] abnrm,
    float[] rconde,
    float[] rcondv,
    float[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sgeevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer WR,
    FloatPointer WI,
    FloatPointer VL, @Const IntPointer ldvl,
    FloatPointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    FloatPointer scale,
    FloatPointer abnrm,
    FloatPointer rconde,
    FloatPointer rcondv,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sgeevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer WR,
    FloatBuffer WI,
    FloatBuffer VL, @Const IntBuffer ldvl,
    FloatBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer scale,
    FloatBuffer abnrm,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sgeevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] WR,
    float[] WI,
    float[] VL, @Const int[] ldvl,
    float[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    float[] scale,
    float[] abnrm,
    float[] rconde,
    float[] rcondv,
    float[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgeevx(...) LAPACK_sgeevx_base(__VA_ARGS__, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zgeevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_double*") DoublePointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    DoublePointer scale,
    DoublePointer abnrm,
    DoublePointer rconde,
    DoublePointer rcondv,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zgeevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_double*") DoubleBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer scale,
    DoubleBuffer abnrm,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zgeevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] W,
    @Cast("lapack_complex_double*") double[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_double*") double[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    double[] scale,
    double[] abnrm,
    double[] rconde,
    double[] rcondv,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zgeevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_double*") DoublePointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    DoublePointer scale,
    DoublePointer abnrm,
    DoublePointer rconde,
    DoublePointer rcondv,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zgeevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_double*") DoubleBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer scale,
    DoubleBuffer abnrm,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zgeevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] W,
    @Cast("lapack_complex_double*") double[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_double*") double[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    double[] scale,
    double[] abnrm,
    double[] rconde,
    double[] rcondv,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgeevx(...) LAPACK_zgeevx_base(__VA_ARGS__, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cgehrd(
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer tau,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cgehrd(
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer tau,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cgehrd(
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] tau,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dgehrd(
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer tau,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgehrd(
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer tau,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgehrd(
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    double[] A, @Const int[] lda,
    double[] tau,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgehrd(
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer tau,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgehrd(
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer tau,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgehrd(
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    float[] A, @Const int[] lda,
    float[] tau,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgehrd(
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer tau,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zgehrd(
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer tau,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zgehrd(
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] tau,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_cgejsv_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobr, @Cast("const char*") BytePointer jobt, @Cast("const char*") BytePointer jobp,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer SVA,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_float*") FloatPointer cwork, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_cgejsv_base(
    String joba, String jobu, String jobv, String jobr, String jobt, String jobp,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer SVA,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_float*") FloatBuffer cwork, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_cgejsv_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobr, @Cast("const char*") BytePointer jobt, @Cast("const char*") BytePointer jobp,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] SVA,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] V, @Const int[] ldv,
    @Cast("lapack_complex_float*") float[] cwork, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_cgejsv_base(
    String joba, String jobu, String jobv, String jobr, String jobt, String jobp,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer SVA,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_float*") FloatPointer cwork, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_cgejsv_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobr, @Cast("const char*") BytePointer jobt, @Cast("const char*") BytePointer jobp,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer SVA,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_float*") FloatBuffer cwork, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_cgejsv_base(
    String joba, String jobu, String jobv, String jobr, String jobt, String jobp,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] SVA,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] V, @Const int[] ldv,
    @Cast("lapack_complex_float*") float[] cwork, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgejsv(...) LAPACK_cgejsv_base(__VA_ARGS__, 1, 1, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dgejsv_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobr, @Cast("const char*") BytePointer jobt, @Cast("const char*") BytePointer jobp,
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer SVA,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer V, @Const IntPointer ldv,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_dgejsv_base(
    String joba, String jobu, String jobv, String jobr, String jobt, String jobp,
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer SVA,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer V, @Const IntBuffer ldv,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_dgejsv_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobr, @Cast("const char*") BytePointer jobt, @Cast("const char*") BytePointer jobp,
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] SVA,
    double[] U, @Const int[] ldu,
    double[] V, @Const int[] ldv,
    double[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg19, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_dgejsv_base(
    String joba, String jobu, String jobv, String jobr, String jobt, String jobp,
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer SVA,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer V, @Const IntPointer ldv,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_dgejsv_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobr, @Cast("const char*") BytePointer jobt, @Cast("const char*") BytePointer jobp,
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer SVA,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer V, @Const IntBuffer ldv,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_dgejsv_base(
    String joba, String jobu, String jobv, String jobr, String jobt, String jobp,
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] SVA,
    double[] U, @Const int[] ldu,
    double[] V, @Const int[] ldv,
    double[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg19, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgejsv(...) LAPACK_dgejsv_base(__VA_ARGS__, 1, 1, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sgejsv_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobr, @Cast("const char*") BytePointer jobt, @Cast("const char*") BytePointer jobp,
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer SVA,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer V, @Const IntPointer ldv,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_sgejsv_base(
    String joba, String jobu, String jobv, String jobr, String jobt, String jobp,
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer SVA,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer V, @Const IntBuffer ldv,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_sgejsv_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobr, @Cast("const char*") BytePointer jobt, @Cast("const char*") BytePointer jobp,
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] SVA,
    float[] U, @Const int[] ldu,
    float[] V, @Const int[] ldv,
    float[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg19, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_sgejsv_base(
    String joba, String jobu, String jobv, String jobr, String jobt, String jobp,
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer SVA,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer V, @Const IntPointer ldv,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_sgejsv_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobr, @Cast("const char*") BytePointer jobt, @Cast("const char*") BytePointer jobp,
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer SVA,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer V, @Const IntBuffer ldv,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_sgejsv_base(
    String joba, String jobu, String jobv, String jobr, String jobt, String jobp,
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] SVA,
    float[] U, @Const int[] ldu,
    float[] V, @Const int[] ldv,
    float[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg19, @Cast("size_t") long arg20, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgejsv(...) LAPACK_sgejsv_base(__VA_ARGS__, 1, 1, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zgejsv_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobr, @Cast("const char*") BytePointer jobt, @Cast("const char*") BytePointer jobp,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer SVA,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_double*") DoublePointer cwork, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zgejsv_base(
    String joba, String jobu, String jobv, String jobr, String jobt, String jobp,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer SVA,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_double*") DoubleBuffer cwork, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zgejsv_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobr, @Cast("const char*") BytePointer jobt, @Cast("const char*") BytePointer jobp,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] SVA,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] V, @Const int[] ldv,
    @Cast("lapack_complex_double*") double[] cwork, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zgejsv_base(
    String joba, String jobu, String jobv, String jobr, String jobt, String jobp,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer SVA,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_double*") DoublePointer cwork, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zgejsv_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobr, @Cast("const char*") BytePointer jobt, @Cast("const char*") BytePointer jobp,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer SVA,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_double*") DoubleBuffer cwork, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zgejsv_base(
    String joba, String jobu, String jobv, String jobr, String jobt, String jobp,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] SVA,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] V, @Const int[] ldv,
    @Cast("lapack_complex_double*") double[] cwork, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgejsv(...) LAPACK_zgejsv_base(__VA_ARGS__, 1, 1, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cgelq(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer T, @Const IntPointer tsize,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cgelq(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer T, @Const IntBuffer tsize,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cgelq(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] T, @Const int[] tsize,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dgelq(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer T, @Const IntPointer tsize,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgelq(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer T, @Const IntBuffer tsize,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgelq(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] T, @Const int[] tsize,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgelq(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer T, @Const IntPointer tsize,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgelq(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer T, @Const IntBuffer tsize,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgelq(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] T, @Const int[] tsize,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgelq(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer T, @Const IntPointer tsize,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zgelq(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer T, @Const IntBuffer tsize,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zgelq(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] T, @Const int[] tsize,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_cgelq2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer tau,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info );
public static native void LAPACK_cgelq2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer tau,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info );
public static native void LAPACK_cgelq2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] tau,
    @Cast("lapack_complex_float*") float[] work,
    int[] info );

public static native void LAPACK_dgelq2(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer tau,
    DoublePointer work,
    IntPointer info );
public static native void LAPACK_dgelq2(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer tau,
    DoubleBuffer work,
    IntBuffer info );
public static native void LAPACK_dgelq2(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] tau,
    double[] work,
    int[] info );

public static native void LAPACK_sgelq2(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer tau,
    FloatPointer work,
    IntPointer info );
public static native void LAPACK_sgelq2(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer tau,
    FloatBuffer work,
    IntBuffer info );
public static native void LAPACK_sgelq2(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] tau,
    float[] work,
    int[] info );

public static native void LAPACK_zgelq2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer tau,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info );
public static native void LAPACK_zgelq2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer tau,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info );
public static native void LAPACK_zgelq2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] tau,
    @Cast("lapack_complex_double*") double[] work,
    int[] info );

public static native void LAPACK_cgelqf(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer tau,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cgelqf(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer tau,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cgelqf(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] tau,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dgelqf(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer tau,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgelqf(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer tau,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgelqf(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] tau,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgelqf(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer tau,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgelqf(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer tau,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgelqf(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] tau,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgelqf(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer tau,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zgelqf(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer tau,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zgelqf(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] tau,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_cgels_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgels_base(
    String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgels_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgels_base(
    String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgels_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgels_base(
    String trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgels(...) LAPACK_cgels_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dgels_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgels_base(
    String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgels_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgels_base(
    String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgels_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgels_base(
    String trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgels(...) LAPACK_dgels_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sgels_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgels_base(
    String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgels_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgels_base(
    String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgels_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgels_base(
    String trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgels(...) LAPACK_sgels_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zgels_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgels_base(
    String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgels_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgels_base(
    String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgels_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgels_base(
    String trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgels(...) LAPACK_zgels_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_cgelsd(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    FloatPointer S,
    @Const FloatPointer rcond, IntPointer rank,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork,
    IntPointer info );
public static native void LAPACK_cgelsd(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer S,
    @Const FloatBuffer rcond, IntBuffer rank,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork,
    IntBuffer info );
public static native void LAPACK_cgelsd(
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    float[] S,
    @Const float[] rcond, int[] rank,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork,
    int[] info );

public static native void LAPACK_dgelsd(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer S,
    @Const DoublePointer rcond, IntPointer rank,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info );
public static native void LAPACK_dgelsd(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer S,
    @Const DoubleBuffer rcond, IntBuffer rank,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info );
public static native void LAPACK_dgelsd(
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] S,
    @Const double[] rcond, int[] rank,
    double[] work, @Const int[] lwork,
    int[] iwork,
    int[] info );

public static native void LAPACK_sgelsd(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer S,
    @Const FloatPointer rcond, IntPointer rank,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info );
public static native void LAPACK_sgelsd(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer S,
    @Const FloatBuffer rcond, IntBuffer rank,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info );
public static native void LAPACK_sgelsd(
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] S,
    @Const float[] rcond, int[] rank,
    float[] work, @Const int[] lwork,
    int[] iwork,
    int[] info );

public static native void LAPACK_zgelsd(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    DoublePointer S,
    @Const DoublePointer rcond, IntPointer rank,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork,
    IntPointer info );
public static native void LAPACK_zgelsd(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer S,
    @Const DoubleBuffer rcond, IntBuffer rank,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork,
    IntBuffer info );
public static native void LAPACK_zgelsd(
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    double[] S,
    @Const double[] rcond, int[] rank,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork,
    int[] info );

public static native void LAPACK_cgelss(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    FloatPointer S,
    @Const FloatPointer rcond, IntPointer rank,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info );
public static native void LAPACK_cgelss(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer S,
    @Const FloatBuffer rcond, IntBuffer rank,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info );
public static native void LAPACK_cgelss(
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    float[] S,
    @Const float[] rcond, int[] rank,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info );

public static native void LAPACK_dgelss(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer S,
    @Const DoublePointer rcond, IntPointer rank,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgelss(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer S,
    @Const DoubleBuffer rcond, IntBuffer rank,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgelss(
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] S,
    @Const double[] rcond, int[] rank,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgelss(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer S,
    @Const FloatPointer rcond, IntPointer rank,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgelss(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer S,
    @Const FloatBuffer rcond, IntBuffer rank,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgelss(
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] S,
    @Const float[] rcond, int[] rank,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgelss(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    DoublePointer S,
    @Const DoublePointer rcond, IntPointer rank,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info );
public static native void LAPACK_zgelss(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer S,
    @Const DoubleBuffer rcond, IntBuffer rank,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info );
public static native void LAPACK_zgelss(
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    double[] S,
    @Const double[] rcond, int[] rank,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info );

public static native void LAPACK_cgelsy(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb, IntPointer JPVT,
    @Const FloatPointer rcond, IntPointer rank,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info );
public static native void LAPACK_cgelsy(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb, IntBuffer JPVT,
    @Const FloatBuffer rcond, IntBuffer rank,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info );
public static native void LAPACK_cgelsy(
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb, int[] JPVT,
    @Const float[] rcond, int[] rank,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info );

public static native void LAPACK_dgelsy(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb, IntPointer JPVT,
    @Const DoublePointer rcond, IntPointer rank,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgelsy(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb, IntBuffer JPVT,
    @Const DoubleBuffer rcond, IntBuffer rank,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgelsy(
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb, int[] JPVT,
    @Const double[] rcond, int[] rank,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgelsy(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb, IntPointer JPVT,
    @Const FloatPointer rcond, IntPointer rank,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgelsy(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb, IntBuffer JPVT,
    @Const FloatBuffer rcond, IntBuffer rank,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgelsy(
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb, int[] JPVT,
    @Const float[] rcond, int[] rank,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgelsy(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb, IntPointer JPVT,
    @Const DoublePointer rcond, IntPointer rank,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info );
public static native void LAPACK_zgelsy(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb, IntBuffer JPVT,
    @Const DoubleBuffer rcond, IntBuffer rank,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info );
public static native void LAPACK_zgelsy(
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb, int[] JPVT,
    @Const double[] rcond, int[] rank,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info );

public static native void LAPACK_cgemlq_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_float*") FloatPointer T, @Const IntPointer tsize,
    @Cast("lapack_complex_float*") FloatPointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemlq_base(
    String side, String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_float*") FloatBuffer T, @Const IntBuffer tsize,
    @Cast("lapack_complex_float*") FloatBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemlq_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("const lapack_complex_float*") float[] T, @Const int[] tsize,
    @Cast("lapack_complex_float*") float[] C, @Const int[] ldc,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemlq_base(
    String side, String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_float*") FloatPointer T, @Const IntPointer tsize,
    @Cast("lapack_complex_float*") FloatPointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemlq_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_float*") FloatBuffer T, @Const IntBuffer tsize,
    @Cast("lapack_complex_float*") FloatBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemlq_base(
    String side, String trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("const lapack_complex_float*") float[] T, @Const int[] tsize,
    @Cast("lapack_complex_float*") float[] C, @Const int[] ldc,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgemlq(...) LAPACK_cgemlq_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_dgemlq_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Const DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer T, @Const IntPointer tsize,
    DoublePointer C, @Const IntPointer ldc,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemlq_base(
    String side, String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Const DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer T, @Const IntBuffer tsize,
    DoubleBuffer C, @Const IntBuffer ldc,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemlq_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Const double[] A, @Const int[] lda,
    @Const double[] T, @Const int[] tsize,
    double[] C, @Const int[] ldc,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemlq_base(
    String side, String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Const DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer T, @Const IntPointer tsize,
    DoublePointer C, @Const IntPointer ldc,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemlq_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Const DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer T, @Const IntBuffer tsize,
    DoubleBuffer C, @Const IntBuffer ldc,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemlq_base(
    String side, String trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Const double[] A, @Const int[] lda,
    @Const double[] T, @Const int[] tsize,
    double[] C, @Const int[] ldc,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgemlq(...) LAPACK_dgemlq_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sgemlq_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Const FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer T, @Const IntPointer tsize,
    FloatPointer C, @Const IntPointer ldc,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemlq_base(
    String side, String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Const FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer T, @Const IntBuffer tsize,
    FloatBuffer C, @Const IntBuffer ldc,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemlq_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Const float[] A, @Const int[] lda,
    @Const float[] T, @Const int[] tsize,
    float[] C, @Const int[] ldc,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemlq_base(
    String side, String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Const FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer T, @Const IntPointer tsize,
    FloatPointer C, @Const IntPointer ldc,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemlq_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Const FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer T, @Const IntBuffer tsize,
    FloatBuffer C, @Const IntBuffer ldc,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemlq_base(
    String side, String trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Const float[] A, @Const int[] lda,
    @Const float[] T, @Const int[] tsize,
    float[] C, @Const int[] ldc,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgemlq(...) LAPACK_sgemlq_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zgemlq_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_double*") DoublePointer T, @Const IntPointer tsize,
    @Cast("lapack_complex_double*") DoublePointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemlq_base(
    String side, String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_double*") DoubleBuffer T, @Const IntBuffer tsize,
    @Cast("lapack_complex_double*") DoubleBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemlq_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("const lapack_complex_double*") double[] T, @Const int[] tsize,
    @Cast("lapack_complex_double*") double[] C, @Const int[] ldc,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemlq_base(
    String side, String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_double*") DoublePointer T, @Const IntPointer tsize,
    @Cast("lapack_complex_double*") DoublePointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemlq_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_double*") DoubleBuffer T, @Const IntBuffer tsize,
    @Cast("lapack_complex_double*") DoubleBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemlq_base(
    String side, String trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("const lapack_complex_double*") double[] T, @Const int[] tsize,
    @Cast("lapack_complex_double*") double[] C, @Const int[] ldc,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgemlq(...) LAPACK_zgemlq_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cgemqr_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_float*") FloatPointer T, @Const IntPointer tsize,
    @Cast("lapack_complex_float*") FloatPointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemqr_base(
    String side, String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_float*") FloatBuffer T, @Const IntBuffer tsize,
    @Cast("lapack_complex_float*") FloatBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemqr_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("const lapack_complex_float*") float[] T, @Const int[] tsize,
    @Cast("lapack_complex_float*") float[] C, @Const int[] ldc,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemqr_base(
    String side, String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_float*") FloatPointer T, @Const IntPointer tsize,
    @Cast("lapack_complex_float*") FloatPointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemqr_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_float*") FloatBuffer T, @Const IntBuffer tsize,
    @Cast("lapack_complex_float*") FloatBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemqr_base(
    String side, String trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("const lapack_complex_float*") float[] T, @Const int[] tsize,
    @Cast("lapack_complex_float*") float[] C, @Const int[] ldc,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgemqr(...) LAPACK_cgemqr_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_dgemqr_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Const DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer T, @Const IntPointer tsize,
    DoublePointer C, @Const IntPointer ldc,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemqr_base(
    String side, String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Const DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer T, @Const IntBuffer tsize,
    DoubleBuffer C, @Const IntBuffer ldc,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemqr_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Const double[] A, @Const int[] lda,
    @Const double[] T, @Const int[] tsize,
    double[] C, @Const int[] ldc,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemqr_base(
    String side, String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Const DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer T, @Const IntPointer tsize,
    DoublePointer C, @Const IntPointer ldc,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemqr_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Const DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer T, @Const IntBuffer tsize,
    DoubleBuffer C, @Const IntBuffer ldc,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemqr_base(
    String side, String trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Const double[] A, @Const int[] lda,
    @Const double[] T, @Const int[] tsize,
    double[] C, @Const int[] ldc,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgemqr(...) LAPACK_dgemqr_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sgemqr_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Const FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer T, @Const IntPointer tsize,
    FloatPointer C, @Const IntPointer ldc,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemqr_base(
    String side, String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Const FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer T, @Const IntBuffer tsize,
    FloatBuffer C, @Const IntBuffer ldc,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemqr_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Const float[] A, @Const int[] lda,
    @Const float[] T, @Const int[] tsize,
    float[] C, @Const int[] ldc,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemqr_base(
    String side, String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Const FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer T, @Const IntPointer tsize,
    FloatPointer C, @Const IntPointer ldc,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemqr_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Const FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer T, @Const IntBuffer tsize,
    FloatBuffer C, @Const IntBuffer ldc,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemqr_base(
    String side, String trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Const float[] A, @Const int[] lda,
    @Const float[] T, @Const int[] tsize,
    float[] C, @Const int[] ldc,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgemqr(...) LAPACK_sgemqr_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zgemqr_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_double*") DoublePointer T, @Const IntPointer tsize,
    @Cast("lapack_complex_double*") DoublePointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemqr_base(
    String side, String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_double*") DoubleBuffer T, @Const IntBuffer tsize,
    @Cast("lapack_complex_double*") DoubleBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemqr_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("const lapack_complex_double*") double[] T, @Const int[] tsize,
    @Cast("lapack_complex_double*") double[] C, @Const int[] ldc,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemqr_base(
    String side, String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_double*") DoublePointer T, @Const IntPointer tsize,
    @Cast("lapack_complex_double*") DoublePointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemqr_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_double*") DoubleBuffer T, @Const IntBuffer tsize,
    @Cast("lapack_complex_double*") DoubleBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemqr_base(
    String side, String trans,
    @Const int[] m, @Const int[] n, @Const int[] k,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("const lapack_complex_double*") double[] T, @Const int[] tsize,
    @Cast("lapack_complex_double*") double[] C, @Const int[] ldc,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgemqr(...) LAPACK_zgemqr_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cgemqrt_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer nb,
    @Cast("const lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    @Cast("const lapack_complex_float*") FloatPointer T, @Const IntPointer ldt,
    @Cast("lapack_complex_float*") FloatPointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemqrt_base(
    String side, String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer nb,
    @Cast("const lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    @Cast("const lapack_complex_float*") FloatBuffer T, @Const IntBuffer ldt,
    @Cast("lapack_complex_float*") FloatBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemqrt_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] nb,
    @Cast("const lapack_complex_float*") float[] V, @Const int[] ldv,
    @Cast("const lapack_complex_float*") float[] T, @Const int[] ldt,
    @Cast("lapack_complex_float*") float[] C, @Const int[] ldc,
    @Cast("lapack_complex_float*") float[] work,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemqrt_base(
    String side, String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer nb,
    @Cast("const lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    @Cast("const lapack_complex_float*") FloatPointer T, @Const IntPointer ldt,
    @Cast("lapack_complex_float*") FloatPointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemqrt_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer nb,
    @Cast("const lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    @Cast("const lapack_complex_float*") FloatBuffer T, @Const IntBuffer ldt,
    @Cast("lapack_complex_float*") FloatBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgemqrt_base(
    String side, String trans,
    @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] nb,
    @Cast("const lapack_complex_float*") float[] V, @Const int[] ldv,
    @Cast("const lapack_complex_float*") float[] T, @Const int[] ldt,
    @Cast("lapack_complex_float*") float[] C, @Const int[] ldc,
    @Cast("lapack_complex_float*") float[] work,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgemqrt(...) LAPACK_cgemqrt_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_dgemqrt_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer nb,
    @Const DoublePointer V, @Const IntPointer ldv,
    @Const DoublePointer T, @Const IntPointer ldt,
    DoublePointer C, @Const IntPointer ldc,
    DoublePointer work,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemqrt_base(
    String side, String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer nb,
    @Const DoubleBuffer V, @Const IntBuffer ldv,
    @Const DoubleBuffer T, @Const IntBuffer ldt,
    DoubleBuffer C, @Const IntBuffer ldc,
    DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemqrt_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] nb,
    @Const double[] V, @Const int[] ldv,
    @Const double[] T, @Const int[] ldt,
    double[] C, @Const int[] ldc,
    double[] work,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemqrt_base(
    String side, String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer nb,
    @Const DoublePointer V, @Const IntPointer ldv,
    @Const DoublePointer T, @Const IntPointer ldt,
    DoublePointer C, @Const IntPointer ldc,
    DoublePointer work,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemqrt_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer nb,
    @Const DoubleBuffer V, @Const IntBuffer ldv,
    @Const DoubleBuffer T, @Const IntBuffer ldt,
    DoubleBuffer C, @Const IntBuffer ldc,
    DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgemqrt_base(
    String side, String trans,
    @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] nb,
    @Const double[] V, @Const int[] ldv,
    @Const double[] T, @Const int[] ldt,
    double[] C, @Const int[] ldc,
    double[] work,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgemqrt(...) LAPACK_dgemqrt_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sgemqrt_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer nb,
    @Const FloatPointer V, @Const IntPointer ldv,
    @Const FloatPointer T, @Const IntPointer ldt,
    FloatPointer C, @Const IntPointer ldc,
    FloatPointer work,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemqrt_base(
    String side, String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer nb,
    @Const FloatBuffer V, @Const IntBuffer ldv,
    @Const FloatBuffer T, @Const IntBuffer ldt,
    FloatBuffer C, @Const IntBuffer ldc,
    FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemqrt_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] nb,
    @Const float[] V, @Const int[] ldv,
    @Const float[] T, @Const int[] ldt,
    float[] C, @Const int[] ldc,
    float[] work,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemqrt_base(
    String side, String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer nb,
    @Const FloatPointer V, @Const IntPointer ldv,
    @Const FloatPointer T, @Const IntPointer ldt,
    FloatPointer C, @Const IntPointer ldc,
    FloatPointer work,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemqrt_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer nb,
    @Const FloatBuffer V, @Const IntBuffer ldv,
    @Const FloatBuffer T, @Const IntBuffer ldt,
    FloatBuffer C, @Const IntBuffer ldc,
    FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgemqrt_base(
    String side, String trans,
    @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] nb,
    @Const float[] V, @Const int[] ldv,
    @Const float[] T, @Const int[] ldt,
    float[] C, @Const int[] ldc,
    float[] work,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgemqrt(...) LAPACK_sgemqrt_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zgemqrt_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer nb,
    @Cast("const lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    @Cast("const lapack_complex_double*") DoublePointer T, @Const IntPointer ldt,
    @Cast("lapack_complex_double*") DoublePointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemqrt_base(
    String side, String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer nb,
    @Cast("const lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    @Cast("const lapack_complex_double*") DoubleBuffer T, @Const IntBuffer ldt,
    @Cast("lapack_complex_double*") DoubleBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemqrt_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] nb,
    @Cast("const lapack_complex_double*") double[] V, @Const int[] ldv,
    @Cast("const lapack_complex_double*") double[] T, @Const int[] ldt,
    @Cast("lapack_complex_double*") double[] C, @Const int[] ldc,
    @Cast("lapack_complex_double*") double[] work,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemqrt_base(
    String side, String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer nb,
    @Cast("const lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    @Cast("const lapack_complex_double*") DoublePointer T, @Const IntPointer ldt,
    @Cast("lapack_complex_double*") DoublePointer C, @Const IntPointer ldc,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemqrt_base(
    @Cast("const char*") BytePointer side, @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer nb,
    @Cast("const lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    @Cast("const lapack_complex_double*") DoubleBuffer T, @Const IntBuffer ldt,
    @Cast("lapack_complex_double*") DoubleBuffer C, @Const IntBuffer ldc,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgemqrt_base(
    String side, String trans,
    @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] nb,
    @Cast("const lapack_complex_double*") double[] V, @Const int[] ldv,
    @Cast("const lapack_complex_double*") double[] T, @Const int[] ldt,
    @Cast("lapack_complex_double*") double[] C, @Const int[] ldc,
    @Cast("lapack_complex_double*") double[] work,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgemqrt(...) LAPACK_zgemqrt_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cgeql2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer tau,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info );
public static native void LAPACK_cgeql2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer tau,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info );
public static native void LAPACK_cgeql2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] tau,
    @Cast("lapack_complex_float*") float[] work,
    int[] info );

public static native void LAPACK_dgeql2(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer tau,
    DoublePointer work,
    IntPointer info );
public static native void LAPACK_dgeql2(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer tau,
    DoubleBuffer work,
    IntBuffer info );
public static native void LAPACK_dgeql2(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] tau,
    double[] work,
    int[] info );

public static native void LAPACK_sgeql2(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer tau,
    FloatPointer work,
    IntPointer info );
public static native void LAPACK_sgeql2(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer tau,
    FloatBuffer work,
    IntBuffer info );
public static native void LAPACK_sgeql2(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] tau,
    float[] work,
    int[] info );

public static native void LAPACK_zgeql2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer tau,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info );
public static native void LAPACK_zgeql2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer tau,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info );
public static native void LAPACK_zgeql2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] tau,
    @Cast("lapack_complex_double*") double[] work,
    int[] info );

public static native void LAPACK_cgeqlf(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer tau,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cgeqlf(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer tau,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cgeqlf(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] tau,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dgeqlf(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer tau,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgeqlf(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer tau,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgeqlf(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] tau,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgeqlf(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer tau,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgeqlf(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer tau,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgeqlf(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] tau,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgeqlf(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer tau,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zgeqlf(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer tau,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zgeqlf(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] tau,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );









public static native void LAPACK_cgeqp3(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda, IntPointer JPVT,
    @Cast("lapack_complex_float*") FloatPointer tau,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info );
public static native void LAPACK_cgeqp3(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, IntBuffer JPVT,
    @Cast("lapack_complex_float*") FloatBuffer tau,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info );
public static native void LAPACK_cgeqp3(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda, int[] JPVT,
    @Cast("lapack_complex_float*") float[] tau,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info );

public static native void LAPACK_dgeqp3(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda, IntPointer JPVT,
    DoublePointer tau,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgeqp3(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda, IntBuffer JPVT,
    DoubleBuffer tau,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgeqp3(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda, int[] JPVT,
    double[] tau,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgeqp3(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda, IntPointer JPVT,
    FloatPointer tau,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgeqp3(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda, IntBuffer JPVT,
    FloatBuffer tau,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgeqp3(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda, int[] JPVT,
    float[] tau,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgeqp3(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda, IntPointer JPVT,
    @Cast("lapack_complex_double*") DoublePointer tau,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info );
public static native void LAPACK_zgeqp3(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, IntBuffer JPVT,
    @Cast("lapack_complex_double*") DoubleBuffer tau,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info );
public static native void LAPACK_zgeqp3(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda, int[] JPVT,
    @Cast("lapack_complex_double*") double[] tau,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info );

public static native void LAPACK_cgeqr(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer T, @Const IntPointer tsize,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cgeqr(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer T, @Const IntBuffer tsize,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cgeqr(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] T, @Const int[] tsize,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dgeqr(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer T, @Const IntPointer tsize,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgeqr(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer T, @Const IntBuffer tsize,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgeqr(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] T, @Const int[] tsize,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgeqr(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer T, @Const IntPointer tsize,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgeqr(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer T, @Const IntBuffer tsize,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgeqr(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] T, @Const int[] tsize,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgeqr(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer T, @Const IntPointer tsize,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zgeqr(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer T, @Const IntBuffer tsize,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zgeqr(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] T, @Const int[] tsize,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_cgeqr2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer tau,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info );
public static native void LAPACK_cgeqr2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer tau,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info );
public static native void LAPACK_cgeqr2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] tau,
    @Cast("lapack_complex_float*") float[] work,
    int[] info );

public static native void LAPACK_dgeqr2(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer tau,
    DoublePointer work,
    IntPointer info );
public static native void LAPACK_dgeqr2(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer tau,
    DoubleBuffer work,
    IntBuffer info );
public static native void LAPACK_dgeqr2(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] tau,
    double[] work,
    int[] info );

public static native void LAPACK_sgeqr2(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer tau,
    FloatPointer work,
    IntPointer info );
public static native void LAPACK_sgeqr2(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer tau,
    FloatBuffer work,
    IntBuffer info );
public static native void LAPACK_sgeqr2(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] tau,
    float[] work,
    int[] info );

public static native void LAPACK_zgeqr2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer tau,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info );
public static native void LAPACK_zgeqr2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer tau,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info );
public static native void LAPACK_zgeqr2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] tau,
    @Cast("lapack_complex_double*") double[] work,
    int[] info );

public static native void LAPACK_cgeqrf(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer tau,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cgeqrf(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer tau,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cgeqrf(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] tau,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dgeqrf(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer tau,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgeqrf(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer tau,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgeqrf(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] tau,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgeqrf(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer tau,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgeqrf(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer tau,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgeqrf(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] tau,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgeqrf(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer tau,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zgeqrf(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer tau,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zgeqrf(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] tau,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_cgeqrfp(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer tau,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cgeqrfp(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer tau,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cgeqrfp(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] tau,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dgeqrfp(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer tau,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgeqrfp(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer tau,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgeqrfp(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] tau,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgeqrfp(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer tau,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgeqrfp(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer tau,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgeqrfp(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] tau,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgeqrfp(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer tau,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zgeqrfp(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer tau,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zgeqrfp(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] tau,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_cgeqrt(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nb,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer T, @Const IntPointer ldt,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info );
public static native void LAPACK_cgeqrt(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nb,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer T, @Const IntBuffer ldt,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info );
public static native void LAPACK_cgeqrt(
    @Const int[] m, @Const int[] n, @Const int[] nb,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] T, @Const int[] ldt,
    @Cast("lapack_complex_float*") float[] work,
    int[] info );

public static native void LAPACK_dgeqrt(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nb,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer T, @Const IntPointer ldt,
    DoublePointer work,
    IntPointer info );
public static native void LAPACK_dgeqrt(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nb,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer T, @Const IntBuffer ldt,
    DoubleBuffer work,
    IntBuffer info );
public static native void LAPACK_dgeqrt(
    @Const int[] m, @Const int[] n, @Const int[] nb,
    double[] A, @Const int[] lda,
    double[] T, @Const int[] ldt,
    double[] work,
    int[] info );

public static native void LAPACK_sgeqrt(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nb,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer T, @Const IntPointer ldt,
    FloatPointer work,
    IntPointer info );
public static native void LAPACK_sgeqrt(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nb,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer T, @Const IntBuffer ldt,
    FloatBuffer work,
    IntBuffer info );
public static native void LAPACK_sgeqrt(
    @Const int[] m, @Const int[] n, @Const int[] nb,
    float[] A, @Const int[] lda,
    float[] T, @Const int[] ldt,
    float[] work,
    int[] info );

public static native void LAPACK_zgeqrt(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nb,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer T, @Const IntPointer ldt,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info );
public static native void LAPACK_zgeqrt(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nb,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer T, @Const IntBuffer ldt,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info );
public static native void LAPACK_zgeqrt(
    @Const int[] m, @Const int[] n, @Const int[] nb,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] T, @Const int[] ldt,
    @Cast("lapack_complex_double*") double[] work,
    int[] info );

public static native void LAPACK_cgeqrt2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer T, @Const IntPointer ldt,
    IntPointer info );
public static native void LAPACK_cgeqrt2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer T, @Const IntBuffer ldt,
    IntBuffer info );
public static native void LAPACK_cgeqrt2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] T, @Const int[] ldt,
    int[] info );

public static native void LAPACK_dgeqrt2(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer T, @Const IntPointer ldt,
    IntPointer info );
public static native void LAPACK_dgeqrt2(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer T, @Const IntBuffer ldt,
    IntBuffer info );
public static native void LAPACK_dgeqrt2(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] T, @Const int[] ldt,
    int[] info );

public static native void LAPACK_sgeqrt2(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer T, @Const IntPointer ldt,
    IntPointer info );
public static native void LAPACK_sgeqrt2(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer T, @Const IntBuffer ldt,
    IntBuffer info );
public static native void LAPACK_sgeqrt2(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] T, @Const int[] ldt,
    int[] info );

public static native void LAPACK_zgeqrt2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer T, @Const IntPointer ldt,
    IntPointer info );
public static native void LAPACK_zgeqrt2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer T, @Const IntBuffer ldt,
    IntBuffer info );
public static native void LAPACK_zgeqrt2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] T, @Const int[] ldt,
    int[] info );

public static native void LAPACK_cgeqrt3(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer T, @Const IntPointer ldt,
    IntPointer info );
public static native void LAPACK_cgeqrt3(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer T, @Const IntBuffer ldt,
    IntBuffer info );
public static native void LAPACK_cgeqrt3(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] T, @Const int[] ldt,
    int[] info );

public static native void LAPACK_dgeqrt3(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer T, @Const IntPointer ldt,
    IntPointer info );
public static native void LAPACK_dgeqrt3(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer T, @Const IntBuffer ldt,
    IntBuffer info );
public static native void LAPACK_dgeqrt3(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] T, @Const int[] ldt,
    int[] info );

public static native void LAPACK_sgeqrt3(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer T, @Const IntPointer ldt,
    IntPointer info );
public static native void LAPACK_sgeqrt3(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer T, @Const IntBuffer ldt,
    IntBuffer info );
public static native void LAPACK_sgeqrt3(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] T, @Const int[] ldt,
    int[] info );

public static native void LAPACK_zgeqrt3(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer T, @Const IntPointer ldt,
    IntPointer info );
public static native void LAPACK_zgeqrt3(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer T, @Const IntBuffer ldt,
    IntBuffer info );
public static native void LAPACK_zgeqrt3(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] T, @Const int[] ldt,
    int[] info );

public static native void LAPACK_cgerfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_float*") FloatPointer AF, @Const IntPointer ldaf, @Const IntPointer ipiv,
    @Cast("const lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    FloatPointer ferr,
    FloatPointer berr,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg17
);
public static native void LAPACK_cgerfs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_float*") FloatBuffer AF, @Const IntBuffer ldaf, @Const IntBuffer ipiv,
    @Cast("const lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer ferr,
    FloatBuffer berr,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg17
);
public static native void LAPACK_cgerfs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("const lapack_complex_float*") float[] AF, @Const int[] ldaf, @Const int[] ipiv,
    @Cast("const lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    float[] ferr,
    float[] berr,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg17
);
public static native void LAPACK_cgerfs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_float*") FloatPointer AF, @Const IntPointer ldaf, @Const IntPointer ipiv,
    @Cast("const lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    FloatPointer ferr,
    FloatPointer berr,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg17
);
public static native void LAPACK_cgerfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_float*") FloatBuffer AF, @Const IntBuffer ldaf, @Const IntBuffer ipiv,
    @Cast("const lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer ferr,
    FloatBuffer berr,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg17
);
public static native void LAPACK_cgerfs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("const lapack_complex_float*") float[] AF, @Const int[] ldaf, @Const int[] ipiv,
    @Cast("const lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    float[] ferr,
    float[] berr,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg17
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgerfs(...) LAPACK_cgerfs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dgerfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer AF, @Const IntPointer ldaf, @Const IntPointer ipiv,
    @Const DoublePointer B, @Const IntPointer ldb,
    DoublePointer X, @Const IntPointer ldx,
    DoublePointer ferr,
    DoublePointer berr,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg17
);
public static native void LAPACK_dgerfs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer AF, @Const IntBuffer ldaf, @Const IntBuffer ipiv,
    @Const DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg17
);
public static native void LAPACK_dgerfs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Const double[] A, @Const int[] lda,
    @Const double[] AF, @Const int[] ldaf, @Const int[] ipiv,
    @Const double[] B, @Const int[] ldb,
    double[] X, @Const int[] ldx,
    double[] ferr,
    double[] berr,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg17
);
public static native void LAPACK_dgerfs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer AF, @Const IntPointer ldaf, @Const IntPointer ipiv,
    @Const DoublePointer B, @Const IntPointer ldb,
    DoublePointer X, @Const IntPointer ldx,
    DoublePointer ferr,
    DoublePointer berr,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg17
);
public static native void LAPACK_dgerfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer AF, @Const IntBuffer ldaf, @Const IntBuffer ipiv,
    @Const DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg17
);
public static native void LAPACK_dgerfs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Const double[] A, @Const int[] lda,
    @Const double[] AF, @Const int[] ldaf, @Const int[] ipiv,
    @Const double[] B, @Const int[] ldb,
    double[] X, @Const int[] ldx,
    double[] ferr,
    double[] berr,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg17
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgerfs(...) LAPACK_dgerfs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sgerfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer AF, @Const IntPointer ldaf, @Const IntPointer ipiv,
    @Const FloatPointer B, @Const IntPointer ldb,
    FloatPointer X, @Const IntPointer ldx,
    FloatPointer ferr,
    FloatPointer berr,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg17
);
public static native void LAPACK_sgerfs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer AF, @Const IntBuffer ldaf, @Const IntBuffer ipiv,
    @Const FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer ferr,
    FloatBuffer berr,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg17
);
public static native void LAPACK_sgerfs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Const float[] A, @Const int[] lda,
    @Const float[] AF, @Const int[] ldaf, @Const int[] ipiv,
    @Const float[] B, @Const int[] ldb,
    float[] X, @Const int[] ldx,
    float[] ferr,
    float[] berr,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg17
);
public static native void LAPACK_sgerfs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer AF, @Const IntPointer ldaf, @Const IntPointer ipiv,
    @Const FloatPointer B, @Const IntPointer ldb,
    FloatPointer X, @Const IntPointer ldx,
    FloatPointer ferr,
    FloatPointer berr,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg17
);
public static native void LAPACK_sgerfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer AF, @Const IntBuffer ldaf, @Const IntBuffer ipiv,
    @Const FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer ferr,
    FloatBuffer berr,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg17
);
public static native void LAPACK_sgerfs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Const float[] A, @Const int[] lda,
    @Const float[] AF, @Const int[] ldaf, @Const int[] ipiv,
    @Const float[] B, @Const int[] ldb,
    float[] X, @Const int[] ldx,
    float[] ferr,
    float[] berr,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg17
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgerfs(...) LAPACK_sgerfs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zgerfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_double*") DoublePointer AF, @Const IntPointer ldaf, @Const IntPointer ipiv,
    @Cast("const lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    DoublePointer ferr,
    DoublePointer berr,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg17
);
public static native void LAPACK_zgerfs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_double*") DoubleBuffer AF, @Const IntBuffer ldaf, @Const IntBuffer ipiv,
    @Cast("const lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg17
);
public static native void LAPACK_zgerfs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("const lapack_complex_double*") double[] AF, @Const int[] ldaf, @Const int[] ipiv,
    @Cast("const lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    double[] ferr,
    double[] berr,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg17
);
public static native void LAPACK_zgerfs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_double*") DoublePointer AF, @Const IntPointer ldaf, @Const IntPointer ipiv,
    @Cast("const lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    DoublePointer ferr,
    DoublePointer berr,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg17
);
public static native void LAPACK_zgerfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_double*") DoubleBuffer AF, @Const IntBuffer ldaf, @Const IntBuffer ipiv,
    @Cast("const lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg17
);
public static native void LAPACK_zgerfs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("const lapack_complex_double*") double[] AF, @Const int[] ldaf, @Const int[] ipiv,
    @Cast("const lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    double[] ferr,
    double[] berr,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg17
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgerfs(...) LAPACK_zgerfs_base(__VA_ARGS__, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgerfsx(...) LAPACK_cgerfsx_base(__VA_ARGS__, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgerfsx(...) LAPACK_dgerfsx_base(__VA_ARGS__, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgerfsx(...) LAPACK_sgerfsx_base(__VA_ARGS__, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgerfsx(...) LAPACK_zgerfsx_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cgerq2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer tau,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info );
public static native void LAPACK_cgerq2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer tau,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info );
public static native void LAPACK_cgerq2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] tau,
    @Cast("lapack_complex_float*") float[] work,
    int[] info );

public static native void LAPACK_dgerq2(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer tau,
    DoublePointer work,
    IntPointer info );
public static native void LAPACK_dgerq2(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer tau,
    DoubleBuffer work,
    IntBuffer info );
public static native void LAPACK_dgerq2(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] tau,
    double[] work,
    int[] info );

public static native void LAPACK_sgerq2(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer tau,
    FloatPointer work,
    IntPointer info );
public static native void LAPACK_sgerq2(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer tau,
    FloatBuffer work,
    IntBuffer info );
public static native void LAPACK_sgerq2(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] tau,
    float[] work,
    int[] info );

public static native void LAPACK_zgerq2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer tau,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info );
public static native void LAPACK_zgerq2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer tau,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info );
public static native void LAPACK_zgerq2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] tau,
    @Cast("lapack_complex_double*") double[] work,
    int[] info );

public static native void LAPACK_cgerqf(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer tau,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cgerqf(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer tau,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cgerqf(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] tau,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dgerqf(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer tau,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgerqf(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer tau,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgerqf(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] tau,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgerqf(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer tau,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgerqf(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer tau,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgerqf(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] tau,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgerqf(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer tau,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zgerqf(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer tau,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zgerqf(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] tau,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_cgesdd_base(
    @Cast("const char*") BytePointer jobz,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer S,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg15
);
public static native void LAPACK_cgesdd_base(
    String jobz,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer S,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg15
);
public static native void LAPACK_cgesdd_base(
    @Cast("const char*") BytePointer jobz,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] S,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg15
);
public static native void LAPACK_cgesdd_base(
    String jobz,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer S,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg15
);
public static native void LAPACK_cgesdd_base(
    @Cast("const char*") BytePointer jobz,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer S,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg15
);
public static native void LAPACK_cgesdd_base(
    String jobz,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] S,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgesdd(...) LAPACK_cgesdd_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dgesdd_base(
    @Cast("const char*") BytePointer jobz,
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer S,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer VT, @Const IntPointer ldvt,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg14
);
public static native void LAPACK_dgesdd_base(
    String jobz,
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer S,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer VT, @Const IntBuffer ldvt,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg14
);
public static native void LAPACK_dgesdd_base(
    @Cast("const char*") BytePointer jobz,
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] S,
    double[] U, @Const int[] ldu,
    double[] VT, @Const int[] ldvt,
    double[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg14
);
public static native void LAPACK_dgesdd_base(
    String jobz,
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer S,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer VT, @Const IntPointer ldvt,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg14
);
public static native void LAPACK_dgesdd_base(
    @Cast("const char*") BytePointer jobz,
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer S,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer VT, @Const IntBuffer ldvt,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg14
);
public static native void LAPACK_dgesdd_base(
    String jobz,
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] S,
    double[] U, @Const int[] ldu,
    double[] VT, @Const int[] ldvt,
    double[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg14
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgesdd(...) LAPACK_dgesdd_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sgesdd_base(
    @Cast("const char*") BytePointer jobz,
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer S,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer VT, @Const IntPointer ldvt,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg14
);
public static native void LAPACK_sgesdd_base(
    String jobz,
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer S,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer VT, @Const IntBuffer ldvt,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg14
);
public static native void LAPACK_sgesdd_base(
    @Cast("const char*") BytePointer jobz,
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] S,
    float[] U, @Const int[] ldu,
    float[] VT, @Const int[] ldvt,
    float[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg14
);
public static native void LAPACK_sgesdd_base(
    String jobz,
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer S,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer VT, @Const IntPointer ldvt,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg14
);
public static native void LAPACK_sgesdd_base(
    @Cast("const char*") BytePointer jobz,
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer S,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer VT, @Const IntBuffer ldvt,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg14
);
public static native void LAPACK_sgesdd_base(
    String jobz,
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] S,
    float[] U, @Const int[] ldu,
    float[] VT, @Const int[] ldvt,
    float[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg14
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgesdd(...) LAPACK_sgesdd_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zgesdd_base(
    @Cast("const char*") BytePointer jobz,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer S,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg15
);
public static native void LAPACK_zgesdd_base(
    String jobz,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer S,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg15
);
public static native void LAPACK_zgesdd_base(
    @Cast("const char*") BytePointer jobz,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] S,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg15
);
public static native void LAPACK_zgesdd_base(
    String jobz,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer S,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg15
);
public static native void LAPACK_zgesdd_base(
    @Cast("const char*") BytePointer jobz,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer S,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg15
);
public static native void LAPACK_zgesdd_base(
    String jobz,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] S,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgesdd(...) LAPACK_zgesdd_base(__VA_ARGS__, 1)
// #else
// #endif

public static native int LAPACK_cgesv(
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda, IntPointer ipiv,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    IntPointer info );
public static native int LAPACK_cgesv(
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info );
public static native int LAPACK_cgesv(
    @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda, int[] ipiv,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    int[] info );

public static native int LAPACK_dgesv(
    @Const IntPointer n, @Const IntPointer nrhs,
    DoublePointer A, @Const IntPointer lda, IntPointer ipiv,
    DoublePointer B, @Const IntPointer ldb,
    IntPointer info );
public static native int LAPACK_dgesv(
    @Const IntBuffer n, @Const IntBuffer nrhs,
    DoubleBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info );
public static native int LAPACK_dgesv(
    @Const int[] n, @Const int[] nrhs,
    double[] A, @Const int[] lda, int[] ipiv,
    double[] B, @Const int[] ldb,
    int[] info );

public static native int LAPACK_sgesv(
    @Const IntPointer n, @Const IntPointer nrhs,
    FloatPointer A, @Const IntPointer lda, IntPointer ipiv,
    FloatPointer B, @Const IntPointer ldb,
    IntPointer info );
public static native int LAPACK_sgesv(
    @Const IntBuffer n, @Const IntBuffer nrhs,
    FloatBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info );
public static native int LAPACK_sgesv(
    @Const int[] n, @Const int[] nrhs,
    float[] A, @Const int[] lda, int[] ipiv,
    float[] B, @Const int[] ldb,
    int[] info );

public static native int LAPACK_zgesv(
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda, IntPointer ipiv,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    IntPointer info );
public static native int LAPACK_zgesv(
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info );
public static native int LAPACK_zgesv(
    @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda, int[] ipiv,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    int[] info );

public static native void LAPACK_dsgesv(
    @Const IntPointer n, @Const IntPointer nrhs,
    DoublePointer A, @Const IntPointer lda, IntPointer ipiv,
    @Const DoublePointer B, @Const IntPointer ldb,
    DoublePointer X, @Const IntPointer ldx,
    DoublePointer work,
    FloatPointer swork, IntPointer iter,
    IntPointer info );
public static native void LAPACK_dsgesv(
    @Const IntBuffer n, @Const IntBuffer nrhs,
    DoubleBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    @Const DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer work,
    FloatBuffer swork, IntBuffer iter,
    IntBuffer info );
public static native void LAPACK_dsgesv(
    @Const int[] n, @Const int[] nrhs,
    double[] A, @Const int[] lda, int[] ipiv,
    @Const double[] B, @Const int[] ldb,
    double[] X, @Const int[] ldx,
    double[] work,
    float[] swork, int[] iter,
    int[] info );

public static native void LAPACK_zcgesv(
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda, IntPointer ipiv,
    @Cast("const lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    @Cast("lapack_complex_double*") DoublePointer work,
    @Cast("lapack_complex_float*") FloatPointer swork,
    DoublePointer rwork, IntPointer iter,
    IntPointer info );
public static native void LAPACK_zcgesv(
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    @Cast("const lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    @Cast("lapack_complex_float*") FloatBuffer swork,
    DoubleBuffer rwork, IntBuffer iter,
    IntBuffer info );
public static native void LAPACK_zcgesv(
    @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda, int[] ipiv,
    @Cast("const lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    @Cast("lapack_complex_double*") double[] work,
    @Cast("lapack_complex_float*") float[] swork,
    double[] rwork, int[] iter,
    int[] info );

public static native void LAPACK_cgesvd_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer S,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_cgesvd_base(
    String jobu, String jobvt,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer S,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_cgesvd_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] S,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_cgesvd_base(
    String jobu, String jobvt,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer S,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_cgesvd_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer S,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_cgesvd_base(
    String jobu, String jobvt,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] S,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgesvd(...) LAPACK_cgesvd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_dgesvd_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt,
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer S,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer VT, @Const IntPointer ldvt,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgesvd_base(
    String jobu, String jobvt,
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer S,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer VT, @Const IntBuffer ldvt,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgesvd_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt,
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] S,
    double[] U, @Const int[] ldu,
    double[] VT, @Const int[] ldvt,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgesvd_base(
    String jobu, String jobvt,
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer S,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer VT, @Const IntPointer ldvt,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgesvd_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt,
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer S,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer VT, @Const IntBuffer ldvt,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgesvd_base(
    String jobu, String jobvt,
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] S,
    double[] U, @Const int[] ldu,
    double[] VT, @Const int[] ldvt,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgesvd(...) LAPACK_dgesvd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sgesvd_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt,
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer S,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer VT, @Const IntPointer ldvt,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgesvd_base(
    String jobu, String jobvt,
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer S,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer VT, @Const IntBuffer ldvt,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgesvd_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt,
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] S,
    float[] U, @Const int[] ldu,
    float[] VT, @Const int[] ldvt,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgesvd_base(
    String jobu, String jobvt,
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer S,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer VT, @Const IntPointer ldvt,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgesvd_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt,
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer S,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer VT, @Const IntBuffer ldvt,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgesvd_base(
    String jobu, String jobvt,
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] S,
    float[] U, @Const int[] ldu,
    float[] VT, @Const int[] ldvt,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgesvd(...) LAPACK_sgesvd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zgesvd_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer S,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zgesvd_base(
    String jobu, String jobvt,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer S,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zgesvd_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] S,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zgesvd_base(
    String jobu, String jobvt,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer S,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zgesvd_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer S,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zgesvd_base(
    String jobu, String jobvt,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] S,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgesvd(...) LAPACK_zgesvd_base(__VA_ARGS__, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgesvdq(...) LAPACK_cgesvdq_base(__VA_ARGS__, 1, 1, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgesvdq(...) LAPACK_dgesvdq_base(__VA_ARGS__, 1, 1, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgesvdq(...) LAPACK_sgesvdq_base(__VA_ARGS__, 1, 1, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgesvdq(...) LAPACK_zgesvdq_base(__VA_ARGS__, 1, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cgesvdx_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt, @Cast("const char*") BytePointer range,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu, IntPointer ns,
    FloatPointer S,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_cgesvdx_base(
    String jobu, String jobvt, String range,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu, IntBuffer ns,
    FloatBuffer S,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_cgesvdx_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt, @Cast("const char*") BytePointer range,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu, int[] ns,
    float[] S,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_cgesvdx_base(
    String jobu, String jobvt, String range,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu, IntPointer ns,
    FloatPointer S,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_cgesvdx_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt, @Cast("const char*") BytePointer range,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu, IntBuffer ns,
    FloatBuffer S,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_cgesvdx_base(
    String jobu, String jobvt, String range,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu, int[] ns,
    float[] S,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgesvdx(...) LAPACK_cgesvdx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


public static native void LAPACK_dgesvdx_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt, @Cast("const char*") BytePointer range,
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu, IntPointer ns,
    DoublePointer S,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer VT, @Const IntPointer ldvt,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgesvdx_base(
    String jobu, String jobvt, String range,
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu, IntBuffer ns,
    DoubleBuffer S,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer VT, @Const IntBuffer ldvt,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgesvdx_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt, @Cast("const char*") BytePointer range,
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu, int[] ns,
    double[] S,
    double[] U, @Const int[] ldu,
    double[] VT, @Const int[] ldvt,
    double[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgesvdx_base(
    String jobu, String jobvt, String range,
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu, IntPointer ns,
    DoublePointer S,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer VT, @Const IntPointer ldvt,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgesvdx_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt, @Cast("const char*") BytePointer range,
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu, IntBuffer ns,
    DoubleBuffer S,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer VT, @Const IntBuffer ldvt,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgesvdx_base(
    String jobu, String jobvt, String range,
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu, int[] ns,
    double[] S,
    double[] U, @Const int[] ldu,
    double[] VT, @Const int[] ldvt,
    double[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgesvdx(...) LAPACK_dgesvdx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sgesvdx_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt, @Cast("const char*") BytePointer range,
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu, IntPointer ns,
    FloatPointer S,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer VT, @Const IntPointer ldvt,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgesvdx_base(
    String jobu, String jobvt, String range,
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu, IntBuffer ns,
    FloatBuffer S,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer VT, @Const IntBuffer ldvt,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgesvdx_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt, @Cast("const char*") BytePointer range,
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu, int[] ns,
    float[] S,
    float[] U, @Const int[] ldu,
    float[] VT, @Const int[] ldvt,
    float[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgesvdx_base(
    String jobu, String jobvt, String range,
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu, IntPointer ns,
    FloatPointer S,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer VT, @Const IntPointer ldvt,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgesvdx_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt, @Cast("const char*") BytePointer range,
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu, IntBuffer ns,
    FloatBuffer S,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer VT, @Const IntBuffer ldvt,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgesvdx_base(
    String jobu, String jobvt, String range,
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu, int[] ns,
    float[] S,
    float[] U, @Const int[] ldu,
    float[] VT, @Const int[] ldvt,
    float[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgesvdx(...) LAPACK_sgesvdx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zgesvdx_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt, @Cast("const char*") BytePointer range,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu, IntPointer ns,
    DoublePointer S,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_zgesvdx_base(
    String jobu, String jobvt, String range,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu, IntBuffer ns,
    DoubleBuffer S,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_zgesvdx_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt, @Cast("const char*") BytePointer range,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu, int[] ns,
    double[] S,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_zgesvdx_base(
    String jobu, String jobvt, String range,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu, IntPointer ns,
    DoublePointer S,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer VT, @Const IntPointer ldvt,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_zgesvdx_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobvt, @Cast("const char*") BytePointer range,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu, IntBuffer ns,
    DoubleBuffer S,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer VT, @Const IntBuffer ldvt,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_zgesvdx_base(
    String jobu, String jobvt, String range,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu, int[] ns,
    double[] S,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] VT, @Const int[] ldvt,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgesvdx(...) LAPACK_zgesvdx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cgesvj_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer SVA, @Const IntPointer mv,
    @Cast("lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_float*") FloatPointer cwork, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cgesvj_base(
    String joba, String jobu, String jobv,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer SVA, @Const IntBuffer mv,
    @Cast("lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_float*") FloatBuffer cwork, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cgesvj_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] SVA, @Const int[] mv,
    @Cast("lapack_complex_float*") float[] V, @Const int[] ldv,
    @Cast("lapack_complex_float*") float[] cwork, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cgesvj_base(
    String joba, String jobu, String jobv,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer SVA, @Const IntPointer mv,
    @Cast("lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_float*") FloatPointer cwork, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cgesvj_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer SVA, @Const IntBuffer mv,
    @Cast("lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_float*") FloatBuffer cwork, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cgesvj_base(
    String joba, String jobu, String jobv,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] SVA, @Const int[] mv,
    @Cast("lapack_complex_float*") float[] V, @Const int[] ldv,
    @Cast("lapack_complex_float*") float[] cwork, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgesvj(...) LAPACK_cgesvj_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dgesvj_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv,
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer SVA, @Const IntPointer mv,
    DoublePointer V, @Const IntPointer ldv,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_dgesvj_base(
    String joba, String jobu, String jobv,
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer SVA, @Const IntBuffer mv,
    DoubleBuffer V, @Const IntBuffer ldv,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_dgesvj_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv,
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] SVA, @Const int[] mv,
    double[] V, @Const int[] ldv,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_dgesvj_base(
    String joba, String jobu, String jobv,
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer SVA, @Const IntPointer mv,
    DoublePointer V, @Const IntPointer ldv,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_dgesvj_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv,
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer SVA, @Const IntBuffer mv,
    DoubleBuffer V, @Const IntBuffer ldv,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_dgesvj_base(
    String joba, String jobu, String jobv,
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] SVA, @Const int[] mv,
    double[] V, @Const int[] ldv,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgesvj(...) LAPACK_dgesvj_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sgesvj_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv,
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer SVA, @Const IntPointer mv,
    FloatPointer V, @Const IntPointer ldv,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_sgesvj_base(
    String joba, String jobu, String jobv,
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer SVA, @Const IntBuffer mv,
    FloatBuffer V, @Const IntBuffer ldv,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_sgesvj_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv,
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] SVA, @Const int[] mv,
    float[] V, @Const int[] ldv,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_sgesvj_base(
    String joba, String jobu, String jobv,
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer SVA, @Const IntPointer mv,
    FloatPointer V, @Const IntPointer ldv,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_sgesvj_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv,
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer SVA, @Const IntBuffer mv,
    FloatBuffer V, @Const IntBuffer ldv,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_sgesvj_base(
    String joba, String jobu, String jobv,
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] SVA, @Const int[] mv,
    float[] V, @Const int[] ldv,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgesvj(...) LAPACK_sgesvj_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zgesvj_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer SVA, @Const IntPointer mv,
    @Cast("lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_double*") DoublePointer cwork, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zgesvj_base(
    String joba, String jobu, String jobv,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer SVA, @Const IntBuffer mv,
    @Cast("lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_double*") DoubleBuffer cwork, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zgesvj_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] SVA, @Const int[] mv,
    @Cast("lapack_complex_double*") double[] V, @Const int[] ldv,
    @Cast("lapack_complex_double*") double[] cwork, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zgesvj_base(
    String joba, String jobu, String jobv,
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer SVA, @Const IntPointer mv,
    @Cast("lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_double*") DoublePointer cwork, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zgesvj_base(
    @Cast("const char*") BytePointer joba, @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv,
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer SVA, @Const IntBuffer mv,
    @Cast("lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_double*") DoubleBuffer cwork, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zgesvj_base(
    String joba, String jobu, String jobv,
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] SVA, @Const int[] mv,
    @Cast("lapack_complex_double*") double[] V, @Const int[] ldv,
    @Cast("lapack_complex_double*") double[] cwork, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgesvj(...) LAPACK_zgesvj_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cgesvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer AF, @Const IntPointer ldaf, IntPointer ipiv, @Cast("char*") BytePointer equed,
    FloatPointer R,
    FloatPointer C,
    @Cast("lapack_complex_float*") FloatPointer B,
    @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    FloatPointer rcond,
    FloatPointer ferr,
    FloatPointer berr,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_cgesvx_base(
    String fact, String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer AF, @Const IntBuffer ldaf, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    FloatBuffer R,
    FloatBuffer C,
    @Cast("lapack_complex_float*") FloatBuffer B,
    @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer rcond,
    FloatBuffer ferr,
    FloatBuffer berr,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_cgesvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] AF, @Const int[] ldaf, int[] ipiv, @Cast("char*") byte[] equed,
    float[] R,
    float[] C,
    @Cast("lapack_complex_float*") float[] B,
    @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    float[] rcond,
    float[] ferr,
    float[] berr,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_cgesvx_base(
    String fact, String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer AF, @Const IntPointer ldaf, IntPointer ipiv, @Cast("char*") BytePointer equed,
    FloatPointer R,
    FloatPointer C,
    @Cast("lapack_complex_float*") FloatPointer B,
    @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    FloatPointer rcond,
    FloatPointer ferr,
    FloatPointer berr,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_cgesvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer AF, @Const IntBuffer ldaf, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    FloatBuffer R,
    FloatBuffer C,
    @Cast("lapack_complex_float*") FloatBuffer B,
    @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer rcond,
    FloatBuffer ferr,
    FloatBuffer berr,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_cgesvx_base(
    String fact, String trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] AF, @Const int[] ldaf, int[] ipiv, @Cast("char*") byte[] equed,
    float[] R,
    float[] C,
    @Cast("lapack_complex_float*") float[] B,
    @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    float[] rcond,
    float[] ferr,
    float[] berr,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgesvx(...) LAPACK_cgesvx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dgesvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer AF, @Const IntPointer ldaf, IntPointer ipiv, @Cast("char*") BytePointer equed,
    DoublePointer R,
    DoublePointer C,
    DoublePointer B,
    @Const IntPointer ldb,
    DoublePointer X, @Const IntPointer ldx,
    DoublePointer rcond,
    DoublePointer ferr,
    DoublePointer berr,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_dgesvx_base(
    String fact, String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer AF, @Const IntBuffer ldaf, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    DoubleBuffer R,
    DoubleBuffer C,
    DoubleBuffer B,
    @Const IntBuffer ldb,
    DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer rcond,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_dgesvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    double[] A, @Const int[] lda,
    double[] AF, @Const int[] ldaf, int[] ipiv, @Cast("char*") byte[] equed,
    double[] R,
    double[] C,
    double[] B,
    @Const int[] ldb,
    double[] X, @Const int[] ldx,
    double[] rcond,
    double[] ferr,
    double[] berr,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_dgesvx_base(
    String fact, String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer AF, @Const IntPointer ldaf, IntPointer ipiv, @Cast("char*") BytePointer equed,
    DoublePointer R,
    DoublePointer C,
    DoublePointer B,
    @Const IntPointer ldb,
    DoublePointer X, @Const IntPointer ldx,
    DoublePointer rcond,
    DoublePointer ferr,
    DoublePointer berr,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_dgesvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer AF, @Const IntBuffer ldaf, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    DoubleBuffer R,
    DoubleBuffer C,
    DoubleBuffer B,
    @Const IntBuffer ldb,
    DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer rcond,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_dgesvx_base(
    String fact, String trans,
    @Const int[] n, @Const int[] nrhs,
    double[] A, @Const int[] lda,
    double[] AF, @Const int[] ldaf, int[] ipiv, @Cast("char*") byte[] equed,
    double[] R,
    double[] C,
    double[] B,
    @Const int[] ldb,
    double[] X, @Const int[] ldx,
    double[] rcond,
    double[] ferr,
    double[] berr,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgesvx(...) LAPACK_dgesvx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sgesvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer AF, @Const IntPointer ldaf, IntPointer ipiv, @Cast("char*") BytePointer equed,
    FloatPointer R,
    FloatPointer C,
    FloatPointer B,
    @Const IntPointer ldb,
    FloatPointer X, @Const IntPointer ldx,
    FloatPointer rcond,
    FloatPointer ferr,
    FloatPointer berr,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_sgesvx_base(
    String fact, String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer AF, @Const IntBuffer ldaf, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    FloatBuffer R,
    FloatBuffer C,
    FloatBuffer B,
    @Const IntBuffer ldb,
    FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer rcond,
    FloatBuffer ferr,
    FloatBuffer berr,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_sgesvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    float[] A, @Const int[] lda,
    float[] AF, @Const int[] ldaf, int[] ipiv, @Cast("char*") byte[] equed,
    float[] R,
    float[] C,
    float[] B,
    @Const int[] ldb,
    float[] X, @Const int[] ldx,
    float[] rcond,
    float[] ferr,
    float[] berr,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_sgesvx_base(
    String fact, String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer AF, @Const IntPointer ldaf, IntPointer ipiv, @Cast("char*") BytePointer equed,
    FloatPointer R,
    FloatPointer C,
    FloatPointer B,
    @Const IntPointer ldb,
    FloatPointer X, @Const IntPointer ldx,
    FloatPointer rcond,
    FloatPointer ferr,
    FloatPointer berr,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_sgesvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer AF, @Const IntBuffer ldaf, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    FloatBuffer R,
    FloatBuffer C,
    FloatBuffer B,
    @Const IntBuffer ldb,
    FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer rcond,
    FloatBuffer ferr,
    FloatBuffer berr,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_sgesvx_base(
    String fact, String trans,
    @Const int[] n, @Const int[] nrhs,
    float[] A, @Const int[] lda,
    float[] AF, @Const int[] ldaf, int[] ipiv, @Cast("char*") byte[] equed,
    float[] R,
    float[] C,
    float[] B,
    @Const int[] ldb,
    float[] X, @Const int[] ldx,
    float[] rcond,
    float[] ferr,
    float[] berr,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgesvx(...) LAPACK_sgesvx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zgesvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer AF, @Const IntPointer ldaf, IntPointer ipiv, @Cast("char*") BytePointer equed,
    DoublePointer R,
    DoublePointer C,
    @Cast("lapack_complex_double*") DoublePointer B,
    @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    DoublePointer rcond,
    DoublePointer ferr,
    DoublePointer berr,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_zgesvx_base(
    String fact, String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer AF, @Const IntBuffer ldaf, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    DoubleBuffer R,
    DoubleBuffer C,
    @Cast("lapack_complex_double*") DoubleBuffer B,
    @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer rcond,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_zgesvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] AF, @Const int[] ldaf, int[] ipiv, @Cast("char*") byte[] equed,
    double[] R,
    double[] C,
    @Cast("lapack_complex_double*") double[] B,
    @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    double[] rcond,
    double[] ferr,
    double[] berr,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_zgesvx_base(
    String fact, String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer AF, @Const IntPointer ldaf, IntPointer ipiv, @Cast("char*") BytePointer equed,
    DoublePointer R,
    DoublePointer C,
    @Cast("lapack_complex_double*") DoublePointer B,
    @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    DoublePointer rcond,
    DoublePointer ferr,
    DoublePointer berr,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_zgesvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer AF, @Const IntBuffer ldaf, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
    DoubleBuffer R,
    DoubleBuffer C,
    @Cast("lapack_complex_double*") DoubleBuffer B,
    @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer rcond,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
public static native void LAPACK_zgesvx_base(
    String fact, String trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] AF, @Const int[] ldaf, int[] ipiv, @Cast("char*") byte[] equed,
    double[] R,
    double[] C,
    @Cast("lapack_complex_double*") double[] B,
    @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    double[] rcond,
    double[] ferr,
    double[] berr,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23, @Cast("size_t") long arg24
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgesvx(...) LAPACK_zgesvx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgesvxx(...) LAPACK_cgesvxx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgesvxx(...) LAPACK_dgesvxx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgesvxx(...) LAPACK_sgesvxx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgesvxx(...) LAPACK_zgesvxx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native int LAPACK_cgetf2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda, IntPointer ipiv,
    IntPointer info );
public static native int LAPACK_cgetf2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    IntBuffer info );
public static native int LAPACK_cgetf2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda, int[] ipiv,
    int[] info );

public static native int LAPACK_dgetf2(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda, IntPointer ipiv,
    IntPointer info );
public static native int LAPACK_dgetf2(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    IntBuffer info );
public static native int LAPACK_dgetf2(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda, int[] ipiv,
    int[] info );

public static native int LAPACK_sgetf2(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda, IntPointer ipiv,
    IntPointer info );
public static native int LAPACK_sgetf2(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    IntBuffer info );
public static native int LAPACK_sgetf2(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda, int[] ipiv,
    int[] info );

public static native int LAPACK_zgetf2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda, IntPointer ipiv,
    IntPointer info );
public static native int LAPACK_zgetf2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    IntBuffer info );
public static native int LAPACK_zgetf2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda, int[] ipiv,
    int[] info );

public static native int LAPACK_cgetrf(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda, IntPointer ipiv,
    IntPointer info );
public static native int LAPACK_cgetrf(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    IntBuffer info );
public static native int LAPACK_cgetrf(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda, int[] ipiv,
    int[] info );

public static native int LAPACK_dgetrf(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda, IntPointer ipiv,
    IntPointer info );
public static native int LAPACK_dgetrf(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    IntBuffer info );
public static native int LAPACK_dgetrf(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda, int[] ipiv,
    int[] info );

public static native int LAPACK_sgetrf(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda, IntPointer ipiv,
    IntPointer info );
public static native int LAPACK_sgetrf(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    IntBuffer info );
public static native int LAPACK_sgetrf(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda, int[] ipiv,
    int[] info );

public static native int LAPACK_zgetrf(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda, IntPointer ipiv,
    IntPointer info );
public static native int LAPACK_zgetrf(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    IntBuffer info );
public static native int LAPACK_zgetrf(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda, int[] ipiv,
    int[] info );

public static native void LAPACK_cgetrf2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda, IntPointer ipiv,
    IntPointer info );
public static native void LAPACK_cgetrf2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    IntBuffer info );
public static native void LAPACK_cgetrf2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda, int[] ipiv,
    int[] info );

public static native void LAPACK_dgetrf2(
    @Const IntPointer m, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda, IntPointer ipiv,
    IntPointer info );
public static native void LAPACK_dgetrf2(
    @Const IntBuffer m, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    IntBuffer info );
public static native void LAPACK_dgetrf2(
    @Const int[] m, @Const int[] n,
    double[] A, @Const int[] lda, int[] ipiv,
    int[] info );

public static native void LAPACK_sgetrf2(
    @Const IntPointer m, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda, IntPointer ipiv,
    IntPointer info );
public static native void LAPACK_sgetrf2(
    @Const IntBuffer m, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    IntBuffer info );
public static native void LAPACK_sgetrf2(
    @Const int[] m, @Const int[] n,
    float[] A, @Const int[] lda, int[] ipiv,
    int[] info );

public static native void LAPACK_zgetrf2(
    @Const IntPointer m, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda, IntPointer ipiv,
    IntPointer info );
public static native void LAPACK_zgetrf2(
    @Const IntBuffer m, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, IntBuffer ipiv,
    IntBuffer info );
public static native void LAPACK_zgetrf2(
    @Const int[] m, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda, int[] ipiv,
    int[] info );

public static native void LAPACK_cgetri(
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cgetri(
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cgetri(
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda, @Const int[] ipiv,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dgetri(
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgetri(
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgetri(
    @Const int[] n,
    double[] A, @Const int[] lda, @Const int[] ipiv,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgetri(
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgetri(
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgetri(
    @Const int[] n,
    float[] A, @Const int[] lda, @Const int[] ipiv,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgetri(
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zgetri(
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zgetri(
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda, @Const int[] ipiv,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );

public static native int LAPACK_cgetrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg9
);
public static native int LAPACK_cgetrs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native int LAPACK_cgetrs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda, @Const int[] ipiv,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg9
);
public static native int LAPACK_cgetrs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg9
);
public static native int LAPACK_cgetrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native int LAPACK_cgetrs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda, @Const int[] ipiv,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg9
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgetrs(...) LAPACK_cgetrs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native int LAPACK_dgetrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const DoublePointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg9
);
public static native int LAPACK_dgetrs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const DoubleBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native int LAPACK_dgetrs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Const double[] A, @Const int[] lda, @Const int[] ipiv,
    double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg9
);
public static native int LAPACK_dgetrs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const DoublePointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg9
);
public static native int LAPACK_dgetrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const DoubleBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native int LAPACK_dgetrs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Const double[] A, @Const int[] lda, @Const int[] ipiv,
    double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg9
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgetrs(...) LAPACK_dgetrs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native int LAPACK_sgetrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const FloatPointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg9
);
public static native int LAPACK_sgetrs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const FloatBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native int LAPACK_sgetrs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Const float[] A, @Const int[] lda, @Const int[] ipiv,
    float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg9
);
public static native int LAPACK_sgetrs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const FloatPointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg9
);
public static native int LAPACK_sgetrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const FloatBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native int LAPACK_sgetrs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Const float[] A, @Const int[] lda, @Const int[] ipiv,
    float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg9
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgetrs(...) LAPACK_sgetrs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native int LAPACK_zgetrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg9
);
public static native int LAPACK_zgetrs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native int LAPACK_zgetrs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda, @Const int[] ipiv,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg9
);
public static native int LAPACK_zgetrs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg9
);
public static native int LAPACK_zgetrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native int LAPACK_zgetrs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda, @Const int[] ipiv,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg9
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgetrs(...) LAPACK_zgetrs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_cgetsls_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgetsls_base(
    String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgetsls_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgetsls_base(
    String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgetsls_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgetsls_base(
    String trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgetsls(...) LAPACK_cgetsls_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dgetsls_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgetsls_base(
    String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgetsls_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgetsls_base(
    String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgetsls_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgetsls_base(
    String trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgetsls(...) LAPACK_dgetsls_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sgetsls_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgetsls_base(
    String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgetsls_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgetsls_base(
    String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgetsls_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgetsls_base(
    String trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgetsls(...) LAPACK_sgetsls_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zgetsls_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgetsls_base(
    String trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgetsls_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgetsls_base(
    String trans,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgetsls_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgetsls_base(
    String trans,
    @Const int[] m, @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgetsls(...) LAPACK_zgetsls_base(__VA_ARGS__, 1)
// #else
// #endif









public static native void LAPACK_cggbak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const FloatPointer lscale,
    @Const FloatPointer rscale, @Const IntPointer m,
    @Cast("lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_cggbak_base(
    String job, String side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const FloatBuffer lscale,
    @Const FloatBuffer rscale, @Const IntBuffer m,
    @Cast("lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_cggbak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const float[] lscale,
    @Const float[] rscale, @Const int[] m,
    @Cast("lapack_complex_float*") float[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_cggbak_base(
    String job, String side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const FloatPointer lscale,
    @Const FloatPointer rscale, @Const IntPointer m,
    @Cast("lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_cggbak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const FloatBuffer lscale,
    @Const FloatBuffer rscale, @Const IntBuffer m,
    @Cast("lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_cggbak_base(
    String job, String side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const float[] lscale,
    @Const float[] rscale, @Const int[] m,
    @Cast("lapack_complex_float*") float[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cggbak(...) LAPACK_cggbak_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_dggbak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const DoublePointer lscale,
    @Const DoublePointer rscale, @Const IntPointer m,
    DoublePointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_dggbak_base(
    String job, String side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const DoubleBuffer lscale,
    @Const DoubleBuffer rscale, @Const IntBuffer m,
    DoubleBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_dggbak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const double[] lscale,
    @Const double[] rscale, @Const int[] m,
    double[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_dggbak_base(
    String job, String side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const DoublePointer lscale,
    @Const DoublePointer rscale, @Const IntPointer m,
    DoublePointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_dggbak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const DoubleBuffer lscale,
    @Const DoubleBuffer rscale, @Const IntBuffer m,
    DoubleBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_dggbak_base(
    String job, String side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const double[] lscale,
    @Const double[] rscale, @Const int[] m,
    double[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dggbak(...) LAPACK_dggbak_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sggbak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const FloatPointer lscale,
    @Const FloatPointer rscale, @Const IntPointer m,
    FloatPointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_sggbak_base(
    String job, String side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const FloatBuffer lscale,
    @Const FloatBuffer rscale, @Const IntBuffer m,
    FloatBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_sggbak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const float[] lscale,
    @Const float[] rscale, @Const int[] m,
    float[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_sggbak_base(
    String job, String side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const FloatPointer lscale,
    @Const FloatPointer rscale, @Const IntPointer m,
    FloatPointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_sggbak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const FloatBuffer lscale,
    @Const FloatBuffer rscale, @Const IntBuffer m,
    FloatBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_sggbak_base(
    String job, String side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const float[] lscale,
    @Const float[] rscale, @Const int[] m,
    float[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sggbak(...) LAPACK_sggbak_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zggbak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const DoublePointer lscale,
    @Const DoublePointer rscale, @Const IntPointer m,
    @Cast("lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_zggbak_base(
    String job, String side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const DoubleBuffer lscale,
    @Const DoubleBuffer rscale, @Const IntBuffer m,
    @Cast("lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_zggbak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const double[] lscale,
    @Const double[] rscale, @Const int[] m,
    @Cast("lapack_complex_double*") double[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_zggbak_base(
    String job, String side,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Const DoublePointer lscale,
    @Const DoublePointer rscale, @Const IntPointer m,
    @Cast("lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    IntPointer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_zggbak_base(
    @Cast("const char*") BytePointer job, @Cast("const char*") BytePointer side,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Const DoubleBuffer lscale,
    @Const DoubleBuffer rscale, @Const IntBuffer m,
    @Cast("lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    IntBuffer info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
public static native void LAPACK_zggbak_base(
    String job, String side,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Const double[] lscale,
    @Const double[] rscale, @Const int[] m,
    @Cast("lapack_complex_double*") double[] V, @Const int[] ldv,
    int[] info, @Cast("size_t") long arg11, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zggbak(...) LAPACK_zggbak_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cggbal_base(
    @Cast("const char*") BytePointer job,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb, IntPointer ilo, IntPointer ihi,
    FloatPointer lscale,
    FloatPointer rscale,
    FloatPointer work,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_cggbal_base(
    String job,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer lscale,
    FloatBuffer rscale,
    FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_cggbal_base(
    @Cast("const char*") BytePointer job,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb, int[] ilo, int[] ihi,
    float[] lscale,
    float[] rscale,
    float[] work,
    int[] info, @Cast("size_t") long arg12
);
public static native void LAPACK_cggbal_base(
    String job,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb, IntPointer ilo, IntPointer ihi,
    FloatPointer lscale,
    FloatPointer rscale,
    FloatPointer work,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_cggbal_base(
    @Cast("const char*") BytePointer job,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer lscale,
    FloatBuffer rscale,
    FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_cggbal_base(
    String job,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb, int[] ilo, int[] ihi,
    float[] lscale,
    float[] rscale,
    float[] work,
    int[] info, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cggbal(...) LAPACK_cggbal_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dggbal_base(
    @Cast("const char*") BytePointer job,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb, IntPointer ilo, IntPointer ihi,
    DoublePointer lscale,
    DoublePointer rscale,
    DoublePointer work,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_dggbal_base(
    String job,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer lscale,
    DoubleBuffer rscale,
    DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_dggbal_base(
    @Cast("const char*") BytePointer job,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb, int[] ilo, int[] ihi,
    double[] lscale,
    double[] rscale,
    double[] work,
    int[] info, @Cast("size_t") long arg12
);
public static native void LAPACK_dggbal_base(
    String job,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb, IntPointer ilo, IntPointer ihi,
    DoublePointer lscale,
    DoublePointer rscale,
    DoublePointer work,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_dggbal_base(
    @Cast("const char*") BytePointer job,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer lscale,
    DoubleBuffer rscale,
    DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_dggbal_base(
    String job,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb, int[] ilo, int[] ihi,
    double[] lscale,
    double[] rscale,
    double[] work,
    int[] info, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dggbal(...) LAPACK_dggbal_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sggbal_base(
    @Cast("const char*") BytePointer job,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb, IntPointer ilo, IntPointer ihi,
    FloatPointer lscale,
    FloatPointer rscale,
    FloatPointer work,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_sggbal_base(
    String job,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer lscale,
    FloatBuffer rscale,
    FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_sggbal_base(
    @Cast("const char*") BytePointer job,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb, int[] ilo, int[] ihi,
    float[] lscale,
    float[] rscale,
    float[] work,
    int[] info, @Cast("size_t") long arg12
);
public static native void LAPACK_sggbal_base(
    String job,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb, IntPointer ilo, IntPointer ihi,
    FloatPointer lscale,
    FloatPointer rscale,
    FloatPointer work,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_sggbal_base(
    @Cast("const char*") BytePointer job,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer lscale,
    FloatBuffer rscale,
    FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_sggbal_base(
    String job,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb, int[] ilo, int[] ihi,
    float[] lscale,
    float[] rscale,
    float[] work,
    int[] info, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sggbal(...) LAPACK_sggbal_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zggbal_base(
    @Cast("const char*") BytePointer job,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb, IntPointer ilo, IntPointer ihi,
    DoublePointer lscale,
    DoublePointer rscale,
    DoublePointer work,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_zggbal_base(
    String job,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer lscale,
    DoubleBuffer rscale,
    DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_zggbal_base(
    @Cast("const char*") BytePointer job,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb, int[] ilo, int[] ihi,
    double[] lscale,
    double[] rscale,
    double[] work,
    int[] info, @Cast("size_t") long arg12
);
public static native void LAPACK_zggbal_base(
    String job,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb, IntPointer ilo, IntPointer ihi,
    DoublePointer lscale,
    DoublePointer rscale,
    DoublePointer work,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_zggbal_base(
    @Cast("const char*") BytePointer job,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer lscale,
    DoubleBuffer rscale,
    DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_zggbal_base(
    String job,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb, int[] ilo, int[] ihi,
    double[] lscale,
    double[] rscale,
    double[] work,
    int[] info, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zggbal(...) LAPACK_zggbal_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_cgges_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT2 selctg,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb, IntPointer sdim,
    @Cast("lapack_complex_float*") FloatPointer alpha,
    @Cast("lapack_complex_float*") FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer VSL, @Const IntPointer ldvsl,
    @Cast("lapack_complex_float*") FloatPointer VSR, @Const IntPointer ldvsr,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgges_base(
    String jobvsl, String jobvsr, String sort, LAPACK_C_SELECT2 selctg,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    @Cast("lapack_complex_float*") FloatBuffer alpha,
    @Cast("lapack_complex_float*") FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer VSL, @Const IntBuffer ldvsl,
    @Cast("lapack_complex_float*") FloatBuffer VSR, @Const IntBuffer ldvsr,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgges_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT2 selctg,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb, int[] sdim,
    @Cast("lapack_complex_float*") float[] alpha,
    @Cast("lapack_complex_float*") float[] beta,
    @Cast("lapack_complex_float*") float[] VSL, @Const int[] ldvsl,
    @Cast("lapack_complex_float*") float[] VSR, @Const int[] ldvsr,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgges_base(
    String jobvsl, String jobvsr, String sort, LAPACK_C_SELECT2 selctg,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb, IntPointer sdim,
    @Cast("lapack_complex_float*") FloatPointer alpha,
    @Cast("lapack_complex_float*") FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer VSL, @Const IntPointer ldvsl,
    @Cast("lapack_complex_float*") FloatPointer VSR, @Const IntPointer ldvsr,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgges_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT2 selctg,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    @Cast("lapack_complex_float*") FloatBuffer alpha,
    @Cast("lapack_complex_float*") FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer VSL, @Const IntBuffer ldvsl,
    @Cast("lapack_complex_float*") FloatBuffer VSR, @Const IntBuffer ldvsr,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgges_base(
    String jobvsl, String jobvsr, String sort, LAPACK_C_SELECT2 selctg,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb, int[] sdim,
    @Cast("lapack_complex_float*") float[] alpha,
    @Cast("lapack_complex_float*") float[] beta,
    @Cast("lapack_complex_float*") float[] VSL, @Const int[] ldvsl,
    @Cast("lapack_complex_float*") float[] VSR, @Const int[] ldvsr,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgges(...) LAPACK_cgges_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dgges_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT3 selctg,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb, IntPointer sdim,
    DoublePointer alphar,
    DoublePointer alphai,
    DoublePointer beta,
    DoublePointer VSL, @Const IntPointer ldvsl,
    DoublePointer VSR, @Const IntPointer ldvsr,
    DoublePointer work, @Const IntPointer lwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgges_base(
    String jobvsl, String jobvsr, String sort, LAPACK_D_SELECT3 selctg,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    DoubleBuffer alphar,
    DoubleBuffer alphai,
    DoubleBuffer beta,
    DoubleBuffer VSL, @Const IntBuffer ldvsl,
    DoubleBuffer VSR, @Const IntBuffer ldvsr,
    DoubleBuffer work, @Const IntBuffer lwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgges_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT3 selctg,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb, int[] sdim,
    double[] alphar,
    double[] alphai,
    double[] beta,
    double[] VSL, @Const int[] ldvsl,
    double[] VSR, @Const int[] ldvsr,
    double[] work, @Const int[] lwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgges_base(
    String jobvsl, String jobvsr, String sort, LAPACK_D_SELECT3 selctg,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb, IntPointer sdim,
    DoublePointer alphar,
    DoublePointer alphai,
    DoublePointer beta,
    DoublePointer VSL, @Const IntPointer ldvsl,
    DoublePointer VSR, @Const IntPointer ldvsr,
    DoublePointer work, @Const IntPointer lwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgges_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT3 selctg,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    DoubleBuffer alphar,
    DoubleBuffer alphai,
    DoubleBuffer beta,
    DoubleBuffer VSL, @Const IntBuffer ldvsl,
    DoubleBuffer VSR, @Const IntBuffer ldvsr,
    DoubleBuffer work, @Const IntBuffer lwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgges_base(
    String jobvsl, String jobvsr, String sort, LAPACK_D_SELECT3 selctg,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb, int[] sdim,
    double[] alphar,
    double[] alphai,
    double[] beta,
    double[] VSL, @Const int[] ldvsl,
    double[] VSR, @Const int[] ldvsr,
    double[] work, @Const int[] lwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgges(...) LAPACK_dgges_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sgges_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT3 selctg,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb, IntPointer sdim,
    FloatPointer alphar,
    FloatPointer alphai,
    FloatPointer beta,
    FloatPointer VSL, @Const IntPointer ldvsl,
    FloatPointer VSR, @Const IntPointer ldvsr,
    FloatPointer work, @Const IntPointer lwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgges_base(
    String jobvsl, String jobvsr, String sort, LAPACK_S_SELECT3 selctg,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    FloatBuffer alphar,
    FloatBuffer alphai,
    FloatBuffer beta,
    FloatBuffer VSL, @Const IntBuffer ldvsl,
    FloatBuffer VSR, @Const IntBuffer ldvsr,
    FloatBuffer work, @Const IntBuffer lwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgges_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT3 selctg,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb, int[] sdim,
    float[] alphar,
    float[] alphai,
    float[] beta,
    float[] VSL, @Const int[] ldvsl,
    float[] VSR, @Const int[] ldvsr,
    float[] work, @Const int[] lwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgges_base(
    String jobvsl, String jobvsr, String sort, LAPACK_S_SELECT3 selctg,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb, IntPointer sdim,
    FloatPointer alphar,
    FloatPointer alphai,
    FloatPointer beta,
    FloatPointer VSL, @Const IntPointer ldvsl,
    FloatPointer VSR, @Const IntPointer ldvsr,
    FloatPointer work, @Const IntPointer lwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgges_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT3 selctg,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    FloatBuffer alphar,
    FloatBuffer alphai,
    FloatBuffer beta,
    FloatBuffer VSL, @Const IntBuffer ldvsl,
    FloatBuffer VSR, @Const IntBuffer ldvsr,
    FloatBuffer work, @Const IntBuffer lwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgges_base(
    String jobvsl, String jobvsr, String sort, LAPACK_S_SELECT3 selctg,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb, int[] sdim,
    float[] alphar,
    float[] alphai,
    float[] beta,
    float[] VSL, @Const int[] ldvsl,
    float[] VSR, @Const int[] ldvsr,
    float[] work, @Const int[] lwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgges(...) LAPACK_sgges_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zgges_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT2 selctg,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb, IntPointer sdim,
    @Cast("lapack_complex_double*") DoublePointer alpha,
    @Cast("lapack_complex_double*") DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer VSL, @Const IntPointer ldvsl,
    @Cast("lapack_complex_double*") DoublePointer VSR, @Const IntPointer ldvsr,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgges_base(
    String jobvsl, String jobvsr, String sort, LAPACK_Z_SELECT2 selctg,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    @Cast("lapack_complex_double*") DoubleBuffer alpha,
    @Cast("lapack_complex_double*") DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer VSL, @Const IntBuffer ldvsl,
    @Cast("lapack_complex_double*") DoubleBuffer VSR, @Const IntBuffer ldvsr,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgges_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT2 selctg,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb, int[] sdim,
    @Cast("lapack_complex_double*") double[] alpha,
    @Cast("lapack_complex_double*") double[] beta,
    @Cast("lapack_complex_double*") double[] VSL, @Const int[] ldvsl,
    @Cast("lapack_complex_double*") double[] VSR, @Const int[] ldvsr,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgges_base(
    String jobvsl, String jobvsr, String sort, LAPACK_Z_SELECT2 selctg,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb, IntPointer sdim,
    @Cast("lapack_complex_double*") DoublePointer alpha,
    @Cast("lapack_complex_double*") DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer VSL, @Const IntPointer ldvsl,
    @Cast("lapack_complex_double*") DoublePointer VSR, @Const IntPointer ldvsr,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgges_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT2 selctg,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    @Cast("lapack_complex_double*") DoubleBuffer alpha,
    @Cast("lapack_complex_double*") DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer VSL, @Const IntBuffer ldvsl,
    @Cast("lapack_complex_double*") DoubleBuffer VSR, @Const IntBuffer ldvsr,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgges_base(
    String jobvsl, String jobvsr, String sort, LAPACK_Z_SELECT2 selctg,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb, int[] sdim,
    @Cast("lapack_complex_double*") double[] alpha,
    @Cast("lapack_complex_double*") double[] beta,
    @Cast("lapack_complex_double*") double[] VSL, @Const int[] ldvsl,
    @Cast("lapack_complex_double*") double[] VSR, @Const int[] ldvsr,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgges(...) LAPACK_zgges_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cgges3_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT2 selctg,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb, IntPointer sdim,
    @Cast("lapack_complex_float*") FloatPointer alpha,
    @Cast("lapack_complex_float*") FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer VSL, @Const IntPointer ldvsl,
    @Cast("lapack_complex_float*") FloatPointer VSR, @Const IntPointer ldvsr,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgges3_base(
    String jobvsl, String jobvsr, String sort, LAPACK_C_SELECT2 selctg,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    @Cast("lapack_complex_float*") FloatBuffer alpha,
    @Cast("lapack_complex_float*") FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer VSL, @Const IntBuffer ldvsl,
    @Cast("lapack_complex_float*") FloatBuffer VSR, @Const IntBuffer ldvsr,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgges3_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT2 selctg,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb, int[] sdim,
    @Cast("lapack_complex_float*") float[] alpha,
    @Cast("lapack_complex_float*") float[] beta,
    @Cast("lapack_complex_float*") float[] VSL, @Const int[] ldvsl,
    @Cast("lapack_complex_float*") float[] VSR, @Const int[] ldvsr,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgges3_base(
    String jobvsl, String jobvsr, String sort, LAPACK_C_SELECT2 selctg,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb, IntPointer sdim,
    @Cast("lapack_complex_float*") FloatPointer alpha,
    @Cast("lapack_complex_float*") FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer VSL, @Const IntPointer ldvsl,
    @Cast("lapack_complex_float*") FloatPointer VSR, @Const IntPointer ldvsr,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgges3_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT2 selctg,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    @Cast("lapack_complex_float*") FloatBuffer alpha,
    @Cast("lapack_complex_float*") FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer VSL, @Const IntBuffer ldvsl,
    @Cast("lapack_complex_float*") FloatBuffer VSR, @Const IntBuffer ldvsr,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgges3_base(
    String jobvsl, String jobvsr, String sort, LAPACK_C_SELECT2 selctg,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb, int[] sdim,
    @Cast("lapack_complex_float*") float[] alpha,
    @Cast("lapack_complex_float*") float[] beta,
    @Cast("lapack_complex_float*") float[] VSL, @Const int[] ldvsl,
    @Cast("lapack_complex_float*") float[] VSR, @Const int[] ldvsr,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgges3(...) LAPACK_cgges3_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dgges3_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT3 selctg,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb, IntPointer sdim,
    DoublePointer alphar,
    DoublePointer alphai,
    DoublePointer beta,
    DoublePointer VSL, @Const IntPointer ldvsl,
    DoublePointer VSR, @Const IntPointer ldvsr,
    DoublePointer work, @Const IntPointer lwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgges3_base(
    String jobvsl, String jobvsr, String sort, LAPACK_D_SELECT3 selctg,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    DoubleBuffer alphar,
    DoubleBuffer alphai,
    DoubleBuffer beta,
    DoubleBuffer VSL, @Const IntBuffer ldvsl,
    DoubleBuffer VSR, @Const IntBuffer ldvsr,
    DoubleBuffer work, @Const IntBuffer lwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgges3_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT3 selctg,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb, int[] sdim,
    double[] alphar,
    double[] alphai,
    double[] beta,
    double[] VSL, @Const int[] ldvsl,
    double[] VSR, @Const int[] ldvsr,
    double[] work, @Const int[] lwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgges3_base(
    String jobvsl, String jobvsr, String sort, LAPACK_D_SELECT3 selctg,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb, IntPointer sdim,
    DoublePointer alphar,
    DoublePointer alphai,
    DoublePointer beta,
    DoublePointer VSL, @Const IntPointer ldvsl,
    DoublePointer VSR, @Const IntPointer ldvsr,
    DoublePointer work, @Const IntPointer lwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgges3_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT3 selctg,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    DoubleBuffer alphar,
    DoubleBuffer alphai,
    DoubleBuffer beta,
    DoubleBuffer VSL, @Const IntBuffer ldvsl,
    DoubleBuffer VSR, @Const IntBuffer ldvsr,
    DoubleBuffer work, @Const IntBuffer lwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgges3_base(
    String jobvsl, String jobvsr, String sort, LAPACK_D_SELECT3 selctg,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb, int[] sdim,
    double[] alphar,
    double[] alphai,
    double[] beta,
    double[] VSL, @Const int[] ldvsl,
    double[] VSR, @Const int[] ldvsr,
    double[] work, @Const int[] lwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgges3(...) LAPACK_dgges3_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sgges3_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT3 selctg,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb, IntPointer sdim,
    FloatPointer alphar,
    FloatPointer alphai,
    FloatPointer beta,
    FloatPointer VSL, @Const IntPointer ldvsl,
    FloatPointer VSR, @Const IntPointer ldvsr,
    FloatPointer work, @Const IntPointer lwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgges3_base(
    String jobvsl, String jobvsr, String sort, LAPACK_S_SELECT3 selctg,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    FloatBuffer alphar,
    FloatBuffer alphai,
    FloatBuffer beta,
    FloatBuffer VSL, @Const IntBuffer ldvsl,
    FloatBuffer VSR, @Const IntBuffer ldvsr,
    FloatBuffer work, @Const IntBuffer lwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgges3_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT3 selctg,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb, int[] sdim,
    float[] alphar,
    float[] alphai,
    float[] beta,
    float[] VSL, @Const int[] ldvsl,
    float[] VSR, @Const int[] ldvsr,
    float[] work, @Const int[] lwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgges3_base(
    String jobvsl, String jobvsr, String sort, LAPACK_S_SELECT3 selctg,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb, IntPointer sdim,
    FloatPointer alphar,
    FloatPointer alphai,
    FloatPointer beta,
    FloatPointer VSL, @Const IntPointer ldvsl,
    FloatPointer VSR, @Const IntPointer ldvsr,
    FloatPointer work, @Const IntPointer lwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgges3_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT3 selctg,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    FloatBuffer alphar,
    FloatBuffer alphai,
    FloatBuffer beta,
    FloatBuffer VSL, @Const IntBuffer ldvsl,
    FloatBuffer VSR, @Const IntBuffer ldvsr,
    FloatBuffer work, @Const IntBuffer lwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgges3_base(
    String jobvsl, String jobvsr, String sort, LAPACK_S_SELECT3 selctg,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb, int[] sdim,
    float[] alphar,
    float[] alphai,
    float[] beta,
    float[] VSL, @Const int[] ldvsl,
    float[] VSR, @Const int[] ldvsr,
    float[] work, @Const int[] lwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgges3(...) LAPACK_sgges3_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zgges3_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT2 selctg,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb, IntPointer sdim,
    @Cast("lapack_complex_double*") DoublePointer alpha,
    @Cast("lapack_complex_double*") DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer VSL, @Const IntPointer ldvsl,
    @Cast("lapack_complex_double*") DoublePointer VSR, @Const IntPointer ldvsr,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgges3_base(
    String jobvsl, String jobvsr, String sort, LAPACK_Z_SELECT2 selctg,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    @Cast("lapack_complex_double*") DoubleBuffer alpha,
    @Cast("lapack_complex_double*") DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer VSL, @Const IntBuffer ldvsl,
    @Cast("lapack_complex_double*") DoubleBuffer VSR, @Const IntBuffer ldvsr,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgges3_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT2 selctg,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb, int[] sdim,
    @Cast("lapack_complex_double*") double[] alpha,
    @Cast("lapack_complex_double*") double[] beta,
    @Cast("lapack_complex_double*") double[] VSL, @Const int[] ldvsl,
    @Cast("lapack_complex_double*") double[] VSR, @Const int[] ldvsr,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgges3_base(
    String jobvsl, String jobvsr, String sort, LAPACK_Z_SELECT2 selctg,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb, IntPointer sdim,
    @Cast("lapack_complex_double*") DoublePointer alpha,
    @Cast("lapack_complex_double*") DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer VSL, @Const IntPointer ldvsl,
    @Cast("lapack_complex_double*") DoublePointer VSR, @Const IntPointer ldvsr,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgges3_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT2 selctg,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    @Cast("lapack_complex_double*") DoubleBuffer alpha,
    @Cast("lapack_complex_double*") DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer VSL, @Const IntBuffer ldvsl,
    @Cast("lapack_complex_double*") DoubleBuffer VSR, @Const IntBuffer ldvsr,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgges3_base(
    String jobvsl, String jobvsr, String sort, LAPACK_Z_SELECT2 selctg,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb, int[] sdim,
    @Cast("lapack_complex_double*") double[] alpha,
    @Cast("lapack_complex_double*") double[] beta,
    @Cast("lapack_complex_double*") double[] VSL, @Const int[] ldvsl,
    @Cast("lapack_complex_double*") double[] VSR, @Const int[] ldvsr,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgges3(...) LAPACK_zgges3_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cggesx_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT2 selctg, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb, IntPointer sdim,
    @Cast("lapack_complex_float*") FloatPointer alpha,
    @Cast("lapack_complex_float*") FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer VSL, @Const IntPointer ldvsl,
    @Cast("lapack_complex_float*") FloatPointer VSR, @Const IntPointer ldvsr,
    FloatPointer rconde,
    FloatPointer rcondv,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork, @Const IntPointer liwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_cggesx_base(
    String jobvsl, String jobvsr, String sort, LAPACK_C_SELECT2 selctg, String sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    @Cast("lapack_complex_float*") FloatBuffer alpha,
    @Cast("lapack_complex_float*") FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer VSL, @Const IntBuffer ldvsl,
    @Cast("lapack_complex_float*") FloatBuffer VSR, @Const IntBuffer ldvsr,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork, @Const IntBuffer liwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_cggesx_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT2 selctg, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb, int[] sdim,
    @Cast("lapack_complex_float*") float[] alpha,
    @Cast("lapack_complex_float*") float[] beta,
    @Cast("lapack_complex_float*") float[] VSL, @Const int[] ldvsl,
    @Cast("lapack_complex_float*") float[] VSR, @Const int[] ldvsr,
    float[] rconde,
    float[] rcondv,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork, @Const int[] liwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_cggesx_base(
    String jobvsl, String jobvsr, String sort, LAPACK_C_SELECT2 selctg, String sense,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb, IntPointer sdim,
    @Cast("lapack_complex_float*") FloatPointer alpha,
    @Cast("lapack_complex_float*") FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer VSL, @Const IntPointer ldvsl,
    @Cast("lapack_complex_float*") FloatPointer VSR, @Const IntPointer ldvsr,
    FloatPointer rconde,
    FloatPointer rcondv,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork, @Const IntPointer liwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_cggesx_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_C_SELECT2 selctg, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    @Cast("lapack_complex_float*") FloatBuffer alpha,
    @Cast("lapack_complex_float*") FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer VSL, @Const IntBuffer ldvsl,
    @Cast("lapack_complex_float*") FloatBuffer VSR, @Const IntBuffer ldvsr,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork, @Const IntBuffer liwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_cggesx_base(
    String jobvsl, String jobvsr, String sort, LAPACK_C_SELECT2 selctg, String sense,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb, int[] sdim,
    @Cast("lapack_complex_float*") float[] alpha,
    @Cast("lapack_complex_float*") float[] beta,
    @Cast("lapack_complex_float*") float[] VSL, @Const int[] ldvsl,
    @Cast("lapack_complex_float*") float[] VSR, @Const int[] ldvsr,
    float[] rconde,
    float[] rcondv,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork, @Const int[] liwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cggesx(...) LAPACK_cggesx_base(__VA_ARGS__, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dggesx_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT3 selctg, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb, IntPointer sdim,
    DoublePointer alphar,
    DoublePointer alphai,
    DoublePointer beta,
    DoublePointer VSL, @Const IntPointer ldvsl,
    DoublePointer VSR, @Const IntPointer ldvsr,
    DoublePointer rconde,
    DoublePointer rcondv,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork, @Const IntPointer liwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_dggesx_base(
    String jobvsl, String jobvsr, String sort, LAPACK_D_SELECT3 selctg, String sense,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    DoubleBuffer alphar,
    DoubleBuffer alphai,
    DoubleBuffer beta,
    DoubleBuffer VSL, @Const IntBuffer ldvsl,
    DoubleBuffer VSR, @Const IntBuffer ldvsr,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork, @Const IntBuffer liwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_dggesx_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT3 selctg, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb, int[] sdim,
    double[] alphar,
    double[] alphai,
    double[] beta,
    double[] VSL, @Const int[] ldvsl,
    double[] VSR, @Const int[] ldvsr,
    double[] rconde,
    double[] rcondv,
    double[] work, @Const int[] lwork,
    int[] iwork, @Const int[] liwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_dggesx_base(
    String jobvsl, String jobvsr, String sort, LAPACK_D_SELECT3 selctg, String sense,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb, IntPointer sdim,
    DoublePointer alphar,
    DoublePointer alphai,
    DoublePointer beta,
    DoublePointer VSL, @Const IntPointer ldvsl,
    DoublePointer VSR, @Const IntPointer ldvsr,
    DoublePointer rconde,
    DoublePointer rcondv,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork, @Const IntPointer liwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_dggesx_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_D_SELECT3 selctg, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    DoubleBuffer alphar,
    DoubleBuffer alphai,
    DoubleBuffer beta,
    DoubleBuffer VSL, @Const IntBuffer ldvsl,
    DoubleBuffer VSR, @Const IntBuffer ldvsr,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork, @Const IntBuffer liwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_dggesx_base(
    String jobvsl, String jobvsr, String sort, LAPACK_D_SELECT3 selctg, String sense,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb, int[] sdim,
    double[] alphar,
    double[] alphai,
    double[] beta,
    double[] VSL, @Const int[] ldvsl,
    double[] VSR, @Const int[] ldvsr,
    double[] rconde,
    double[] rcondv,
    double[] work, @Const int[] lwork,
    int[] iwork, @Const int[] liwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dggesx(...) LAPACK_dggesx_base(__VA_ARGS__, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sggesx_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT3 selctg, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb, IntPointer sdim,
    FloatPointer alphar,
    FloatPointer alphai,
    FloatPointer beta,
    FloatPointer VSL, @Const IntPointer ldvsl,
    FloatPointer VSR, @Const IntPointer ldvsr,
    FloatPointer rconde,
    FloatPointer rcondv,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork, @Const IntPointer liwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_sggesx_base(
    String jobvsl, String jobvsr, String sort, LAPACK_S_SELECT3 selctg, String sense,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    FloatBuffer alphar,
    FloatBuffer alphai,
    FloatBuffer beta,
    FloatBuffer VSL, @Const IntBuffer ldvsl,
    FloatBuffer VSR, @Const IntBuffer ldvsr,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork, @Const IntBuffer liwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_sggesx_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT3 selctg, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb, int[] sdim,
    float[] alphar,
    float[] alphai,
    float[] beta,
    float[] VSL, @Const int[] ldvsl,
    float[] VSR, @Const int[] ldvsr,
    float[] rconde,
    float[] rcondv,
    float[] work, @Const int[] lwork,
    int[] iwork, @Const int[] liwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_sggesx_base(
    String jobvsl, String jobvsr, String sort, LAPACK_S_SELECT3 selctg, String sense,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb, IntPointer sdim,
    FloatPointer alphar,
    FloatPointer alphai,
    FloatPointer beta,
    FloatPointer VSL, @Const IntPointer ldvsl,
    FloatPointer VSR, @Const IntPointer ldvsr,
    FloatPointer rconde,
    FloatPointer rcondv,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork, @Const IntPointer liwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_sggesx_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_S_SELECT3 selctg, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    FloatBuffer alphar,
    FloatBuffer alphai,
    FloatBuffer beta,
    FloatBuffer VSL, @Const IntBuffer ldvsl,
    FloatBuffer VSR, @Const IntBuffer ldvsr,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork, @Const IntBuffer liwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_sggesx_base(
    String jobvsl, String jobvsr, String sort, LAPACK_S_SELECT3 selctg, String sense,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb, int[] sdim,
    float[] alphar,
    float[] alphai,
    float[] beta,
    float[] VSL, @Const int[] ldvsl,
    float[] VSR, @Const int[] ldvsr,
    float[] rconde,
    float[] rcondv,
    float[] work, @Const int[] lwork,
    int[] iwork, @Const int[] liwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sggesx(...) LAPACK_sggesx_base(__VA_ARGS__, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zggesx_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT2 selctg, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb, IntPointer sdim,
    @Cast("lapack_complex_double*") DoublePointer alpha,
    @Cast("lapack_complex_double*") DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer VSL, @Const IntPointer ldvsl,
    @Cast("lapack_complex_double*") DoublePointer VSR, @Const IntPointer ldvsr,
    DoublePointer rconde,
    DoublePointer rcondv,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork, @Const IntPointer liwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_zggesx_base(
    String jobvsl, String jobvsr, String sort, LAPACK_Z_SELECT2 selctg, String sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    @Cast("lapack_complex_double*") DoubleBuffer alpha,
    @Cast("lapack_complex_double*") DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer VSL, @Const IntBuffer ldvsl,
    @Cast("lapack_complex_double*") DoubleBuffer VSR, @Const IntBuffer ldvsr,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork, @Const IntBuffer liwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_zggesx_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT2 selctg, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb, int[] sdim,
    @Cast("lapack_complex_double*") double[] alpha,
    @Cast("lapack_complex_double*") double[] beta,
    @Cast("lapack_complex_double*") double[] VSL, @Const int[] ldvsl,
    @Cast("lapack_complex_double*") double[] VSR, @Const int[] ldvsr,
    double[] rconde,
    double[] rcondv,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork, @Const int[] liwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_zggesx_base(
    String jobvsl, String jobvsr, String sort, LAPACK_Z_SELECT2 selctg, String sense,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb, IntPointer sdim,
    @Cast("lapack_complex_double*") DoublePointer alpha,
    @Cast("lapack_complex_double*") DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer VSL, @Const IntPointer ldvsl,
    @Cast("lapack_complex_double*") DoublePointer VSR, @Const IntPointer ldvsr,
    DoublePointer rconde,
    DoublePointer rcondv,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork, @Const IntPointer liwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_zggesx_base(
    @Cast("const char*") BytePointer jobvsl, @Cast("const char*") BytePointer jobvsr, @Cast("const char*") BytePointer sort, LAPACK_Z_SELECT2 selctg, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb, IntBuffer sdim,
    @Cast("lapack_complex_double*") DoubleBuffer alpha,
    @Cast("lapack_complex_double*") DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer VSL, @Const IntBuffer ldvsl,
    @Cast("lapack_complex_double*") DoubleBuffer VSR, @Const IntBuffer ldvsr,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork, @Const IntBuffer liwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
public static native void LAPACK_zggesx_base(
    String jobvsl, String jobvsr, String sort, LAPACK_Z_SELECT2 selctg, String sense,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb, int[] sdim,
    @Cast("lapack_complex_double*") double[] alpha,
    @Cast("lapack_complex_double*") double[] beta,
    @Cast("lapack_complex_double*") double[] VSL, @Const int[] ldvsl,
    @Cast("lapack_complex_double*") double[] VSR, @Const int[] ldvsr,
    double[] rconde,
    double[] rcondv,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork, @Const int[] liwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28, @Cast("size_t") long arg29
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zggesx(...) LAPACK_zggesx_base(__VA_ARGS__, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cggev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer alpha,
    @Cast("lapack_complex_float*") FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_float*") FloatPointer VR, @Const IntPointer ldvr,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cggev_base(
    String jobvl, String jobvr,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer alpha,
    @Cast("lapack_complex_float*") FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_float*") FloatBuffer VR, @Const IntBuffer ldvr,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cggev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] alpha,
    @Cast("lapack_complex_float*") float[] beta,
    @Cast("lapack_complex_float*") float[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_float*") float[] VR, @Const int[] ldvr,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cggev_base(
    String jobvl, String jobvr,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer alpha,
    @Cast("lapack_complex_float*") FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_float*") FloatPointer VR, @Const IntPointer ldvr,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cggev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer alpha,
    @Cast("lapack_complex_float*") FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_float*") FloatBuffer VR, @Const IntBuffer ldvr,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cggev_base(
    String jobvl, String jobvr,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] alpha,
    @Cast("lapack_complex_float*") float[] beta,
    @Cast("lapack_complex_float*") float[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_float*") float[] VR, @Const int[] ldvr,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cggev(...) LAPACK_cggev_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_dggev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer alphar,
    DoublePointer alphai,
    DoublePointer beta,
    DoublePointer VL, @Const IntPointer ldvl,
    DoublePointer VR, @Const IntPointer ldvr,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_dggev_base(
    String jobvl, String jobvr,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer alphar,
    DoubleBuffer alphai,
    DoubleBuffer beta,
    DoubleBuffer VL, @Const IntBuffer ldvl,
    DoubleBuffer VR, @Const IntBuffer ldvr,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_dggev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] alphar,
    double[] alphai,
    double[] beta,
    double[] VL, @Const int[] ldvl,
    double[] VR, @Const int[] ldvr,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_dggev_base(
    String jobvl, String jobvr,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer alphar,
    DoublePointer alphai,
    DoublePointer beta,
    DoublePointer VL, @Const IntPointer ldvl,
    DoublePointer VR, @Const IntPointer ldvr,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_dggev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer alphar,
    DoubleBuffer alphai,
    DoubleBuffer beta,
    DoubleBuffer VL, @Const IntBuffer ldvl,
    DoubleBuffer VR, @Const IntBuffer ldvr,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_dggev_base(
    String jobvl, String jobvr,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] alphar,
    double[] alphai,
    double[] beta,
    double[] VL, @Const int[] ldvl,
    double[] VR, @Const int[] ldvr,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dggev(...) LAPACK_dggev_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sggev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer alphar,
    FloatPointer alphai,
    FloatPointer beta,
    FloatPointer VL, @Const IntPointer ldvl,
    FloatPointer VR, @Const IntPointer ldvr,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_sggev_base(
    String jobvl, String jobvr,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer alphar,
    FloatBuffer alphai,
    FloatBuffer beta,
    FloatBuffer VL, @Const IntBuffer ldvl,
    FloatBuffer VR, @Const IntBuffer ldvr,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_sggev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] alphar,
    float[] alphai,
    float[] beta,
    float[] VL, @Const int[] ldvl,
    float[] VR, @Const int[] ldvr,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_sggev_base(
    String jobvl, String jobvr,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer alphar,
    FloatPointer alphai,
    FloatPointer beta,
    FloatPointer VL, @Const IntPointer ldvl,
    FloatPointer VR, @Const IntPointer ldvr,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_sggev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer alphar,
    FloatBuffer alphai,
    FloatBuffer beta,
    FloatBuffer VL, @Const IntBuffer ldvl,
    FloatBuffer VR, @Const IntBuffer ldvr,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_sggev_base(
    String jobvl, String jobvr,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] alphar,
    float[] alphai,
    float[] beta,
    float[] VL, @Const int[] ldvl,
    float[] VR, @Const int[] ldvr,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sggev(...) LAPACK_sggev_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zggev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer alpha,
    @Cast("lapack_complex_double*") DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_double*") DoublePointer VR, @Const IntPointer ldvr,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zggev_base(
    String jobvl, String jobvr,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer alpha,
    @Cast("lapack_complex_double*") DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_double*") DoubleBuffer VR, @Const IntBuffer ldvr,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zggev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] alpha,
    @Cast("lapack_complex_double*") double[] beta,
    @Cast("lapack_complex_double*") double[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_double*") double[] VR, @Const int[] ldvr,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zggev_base(
    String jobvl, String jobvr,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer alpha,
    @Cast("lapack_complex_double*") DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_double*") DoublePointer VR, @Const IntPointer ldvr,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zggev_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer alpha,
    @Cast("lapack_complex_double*") DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_double*") DoubleBuffer VR, @Const IntBuffer ldvr,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zggev_base(
    String jobvl, String jobvr,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] alpha,
    @Cast("lapack_complex_double*") double[] beta,
    @Cast("lapack_complex_double*") double[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_double*") double[] VR, @Const int[] ldvr,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zggev(...) LAPACK_zggev_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cggev3_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer alpha,
    @Cast("lapack_complex_float*") FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_float*") FloatPointer VR, @Const IntPointer ldvr,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cggev3_base(
    String jobvl, String jobvr,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer alpha,
    @Cast("lapack_complex_float*") FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_float*") FloatBuffer VR, @Const IntBuffer ldvr,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cggev3_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] alpha,
    @Cast("lapack_complex_float*") float[] beta,
    @Cast("lapack_complex_float*") float[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_float*") float[] VR, @Const int[] ldvr,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cggev3_base(
    String jobvl, String jobvr,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer alpha,
    @Cast("lapack_complex_float*") FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_float*") FloatPointer VR, @Const IntPointer ldvr,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cggev3_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer alpha,
    @Cast("lapack_complex_float*") FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_float*") FloatBuffer VR, @Const IntBuffer ldvr,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_cggev3_base(
    String jobvl, String jobvr,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] alpha,
    @Cast("lapack_complex_float*") float[] beta,
    @Cast("lapack_complex_float*") float[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_float*") float[] VR, @Const int[] ldvr,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cggev3(...) LAPACK_cggev3_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_dggev3_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer alphar,
    DoublePointer alphai,
    DoublePointer beta,
    DoublePointer VL, @Const IntPointer ldvl,
    DoublePointer VR, @Const IntPointer ldvr,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_dggev3_base(
    String jobvl, String jobvr,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer alphar,
    DoubleBuffer alphai,
    DoubleBuffer beta,
    DoubleBuffer VL, @Const IntBuffer ldvl,
    DoubleBuffer VR, @Const IntBuffer ldvr,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_dggev3_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] alphar,
    double[] alphai,
    double[] beta,
    double[] VL, @Const int[] ldvl,
    double[] VR, @Const int[] ldvr,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_dggev3_base(
    String jobvl, String jobvr,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer alphar,
    DoublePointer alphai,
    DoublePointer beta,
    DoublePointer VL, @Const IntPointer ldvl,
    DoublePointer VR, @Const IntPointer ldvr,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_dggev3_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer alphar,
    DoubleBuffer alphai,
    DoubleBuffer beta,
    DoubleBuffer VL, @Const IntBuffer ldvl,
    DoubleBuffer VR, @Const IntBuffer ldvr,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_dggev3_base(
    String jobvl, String jobvr,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] alphar,
    double[] alphai,
    double[] beta,
    double[] VL, @Const int[] ldvl,
    double[] VR, @Const int[] ldvr,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dggev3(...) LAPACK_dggev3_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sggev3_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer alphar,
    FloatPointer alphai,
    FloatPointer beta,
    FloatPointer VL, @Const IntPointer ldvl,
    FloatPointer VR, @Const IntPointer ldvr,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_sggev3_base(
    String jobvl, String jobvr,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer alphar,
    FloatBuffer alphai,
    FloatBuffer beta,
    FloatBuffer VL, @Const IntBuffer ldvl,
    FloatBuffer VR, @Const IntBuffer ldvr,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_sggev3_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] alphar,
    float[] alphai,
    float[] beta,
    float[] VL, @Const int[] ldvl,
    float[] VR, @Const int[] ldvr,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_sggev3_base(
    String jobvl, String jobvr,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer alphar,
    FloatPointer alphai,
    FloatPointer beta,
    FloatPointer VL, @Const IntPointer ldvl,
    FloatPointer VR, @Const IntPointer ldvr,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_sggev3_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer alphar,
    FloatBuffer alphai,
    FloatBuffer beta,
    FloatBuffer VL, @Const IntBuffer ldvl,
    FloatBuffer VR, @Const IntBuffer ldvr,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_sggev3_base(
    String jobvl, String jobvr,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] alphar,
    float[] alphai,
    float[] beta,
    float[] VL, @Const int[] ldvl,
    float[] VR, @Const int[] ldvr,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sggev3(...) LAPACK_sggev3_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zggev3_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer alpha,
    @Cast("lapack_complex_double*") DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_double*") DoublePointer VR, @Const IntPointer ldvr,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zggev3_base(
    String jobvl, String jobvr,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer alpha,
    @Cast("lapack_complex_double*") DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_double*") DoubleBuffer VR, @Const IntBuffer ldvr,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zggev3_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] alpha,
    @Cast("lapack_complex_double*") double[] beta,
    @Cast("lapack_complex_double*") double[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_double*") double[] VR, @Const int[] ldvr,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zggev3_base(
    String jobvl, String jobvr,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer alpha,
    @Cast("lapack_complex_double*") DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_double*") DoublePointer VR, @Const IntPointer ldvr,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zggev3_base(
    @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer alpha,
    @Cast("lapack_complex_double*") DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_double*") DoubleBuffer VR, @Const IntBuffer ldvr,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
public static native void LAPACK_zggev3_base(
    String jobvl, String jobvr,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] alpha,
    @Cast("lapack_complex_double*") double[] beta,
    @Cast("lapack_complex_double*") double[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_double*") double[] VR, @Const int[] ldvr,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg17, @Cast("size_t") long arg18
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zggev3(...) LAPACK_zggev3_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cggevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer alpha,
    @Cast("lapack_complex_float*") FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_float*") FloatPointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    FloatPointer lscale,
    FloatPointer rscale,
    FloatPointer abnrm,
    FloatPointer bbnrm,
    FloatPointer rconde,
    FloatPointer rcondv,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_cggevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer alpha,
    @Cast("lapack_complex_float*") FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_float*") FloatBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer lscale,
    FloatBuffer rscale,
    FloatBuffer abnrm,
    FloatBuffer bbnrm,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_cggevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] alpha,
    @Cast("lapack_complex_float*") float[] beta,
    @Cast("lapack_complex_float*") float[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_float*") float[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    float[] lscale,
    float[] rscale,
    float[] abnrm,
    float[] bbnrm,
    float[] rconde,
    float[] rcondv,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_cggevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer alpha,
    @Cast("lapack_complex_float*") FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_float*") FloatPointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    FloatPointer lscale,
    FloatPointer rscale,
    FloatPointer abnrm,
    FloatPointer bbnrm,
    FloatPointer rconde,
    FloatPointer rcondv,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_cggevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer alpha,
    @Cast("lapack_complex_float*") FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_float*") FloatBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer lscale,
    FloatBuffer rscale,
    FloatBuffer abnrm,
    FloatBuffer bbnrm,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_cggevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] alpha,
    @Cast("lapack_complex_float*") float[] beta,
    @Cast("lapack_complex_float*") float[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_float*") float[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    float[] lscale,
    float[] rscale,
    float[] abnrm,
    float[] bbnrm,
    float[] rconde,
    float[] rcondv,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cggevx(...) LAPACK_cggevx_base(__VA_ARGS__, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dggevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer alphar,
    DoublePointer alphai,
    DoublePointer beta,
    DoublePointer VL, @Const IntPointer ldvl,
    DoublePointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    DoublePointer lscale,
    DoublePointer rscale,
    DoublePointer abnrm,
    DoublePointer bbnrm,
    DoublePointer rconde,
    DoublePointer rcondv,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_dggevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer alphar,
    DoubleBuffer alphai,
    DoubleBuffer beta,
    DoubleBuffer VL, @Const IntBuffer ldvl,
    DoubleBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer lscale,
    DoubleBuffer rscale,
    DoubleBuffer abnrm,
    DoubleBuffer bbnrm,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_dggevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] alphar,
    double[] alphai,
    double[] beta,
    double[] VL, @Const int[] ldvl,
    double[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    double[] lscale,
    double[] rscale,
    double[] abnrm,
    double[] bbnrm,
    double[] rconde,
    double[] rcondv,
    double[] work, @Const int[] lwork,
    int[] iwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_dggevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer alphar,
    DoublePointer alphai,
    DoublePointer beta,
    DoublePointer VL, @Const IntPointer ldvl,
    DoublePointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    DoublePointer lscale,
    DoublePointer rscale,
    DoublePointer abnrm,
    DoublePointer bbnrm,
    DoublePointer rconde,
    DoublePointer rcondv,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_dggevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer alphar,
    DoubleBuffer alphai,
    DoubleBuffer beta,
    DoubleBuffer VL, @Const IntBuffer ldvl,
    DoubleBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer lscale,
    DoubleBuffer rscale,
    DoubleBuffer abnrm,
    DoubleBuffer bbnrm,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_dggevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] alphar,
    double[] alphai,
    double[] beta,
    double[] VL, @Const int[] ldvl,
    double[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    double[] lscale,
    double[] rscale,
    double[] abnrm,
    double[] bbnrm,
    double[] rconde,
    double[] rcondv,
    double[] work, @Const int[] lwork,
    int[] iwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dggevx(...) LAPACK_dggevx_base(__VA_ARGS__, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sggevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer alphar,
    FloatPointer alphai,
    FloatPointer beta,
    FloatPointer VL, @Const IntPointer ldvl,
    FloatPointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    FloatPointer lscale,
    FloatPointer rscale,
    FloatPointer abnrm,
    FloatPointer bbnrm,
    FloatPointer rconde,
    FloatPointer rcondv,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_sggevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer alphar,
    FloatBuffer alphai,
    FloatBuffer beta,
    FloatBuffer VL, @Const IntBuffer ldvl,
    FloatBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer lscale,
    FloatBuffer rscale,
    FloatBuffer abnrm,
    FloatBuffer bbnrm,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_sggevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] alphar,
    float[] alphai,
    float[] beta,
    float[] VL, @Const int[] ldvl,
    float[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    float[] lscale,
    float[] rscale,
    float[] abnrm,
    float[] bbnrm,
    float[] rconde,
    float[] rcondv,
    float[] work, @Const int[] lwork,
    int[] iwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_sggevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer alphar,
    FloatPointer alphai,
    FloatPointer beta,
    FloatPointer VL, @Const IntPointer ldvl,
    FloatPointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    FloatPointer lscale,
    FloatPointer rscale,
    FloatPointer abnrm,
    FloatPointer bbnrm,
    FloatPointer rconde,
    FloatPointer rcondv,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_sggevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer alphar,
    FloatBuffer alphai,
    FloatBuffer beta,
    FloatBuffer VL, @Const IntBuffer ldvl,
    FloatBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    FloatBuffer lscale,
    FloatBuffer rscale,
    FloatBuffer abnrm,
    FloatBuffer bbnrm,
    FloatBuffer rconde,
    FloatBuffer rcondv,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_sggevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] alphar,
    float[] alphai,
    float[] beta,
    float[] VL, @Const int[] ldvl,
    float[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    float[] lscale,
    float[] rscale,
    float[] abnrm,
    float[] bbnrm,
    float[] rconde,
    float[] rcondv,
    float[] work, @Const int[] lwork,
    int[] iwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sggevx(...) LAPACK_sggevx_base(__VA_ARGS__, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zggevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer alpha,
    @Cast("lapack_complex_double*") DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_double*") DoublePointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    DoublePointer lscale,
    DoublePointer rscale,
    DoublePointer abnrm,
    DoublePointer bbnrm,
    DoublePointer rconde,
    DoublePointer rcondv,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_zggevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer alpha,
    @Cast("lapack_complex_double*") DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_double*") DoubleBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer lscale,
    DoubleBuffer rscale,
    DoubleBuffer abnrm,
    DoubleBuffer bbnrm,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_zggevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] alpha,
    @Cast("lapack_complex_double*") double[] beta,
    @Cast("lapack_complex_double*") double[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_double*") double[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    double[] lscale,
    double[] rscale,
    double[] abnrm,
    double[] bbnrm,
    double[] rconde,
    double[] rcondv,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_zggevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer alpha,
    @Cast("lapack_complex_double*") DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer VL, @Const IntPointer ldvl,
    @Cast("lapack_complex_double*") DoublePointer VR, @Const IntPointer ldvr, IntPointer ilo, IntPointer ihi,
    DoublePointer lscale,
    DoublePointer rscale,
    DoublePointer abnrm,
    DoublePointer bbnrm,
    DoublePointer rconde,
    DoublePointer rcondv,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork, IntPointer BWORK,
    IntPointer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_zggevx_base(
    @Cast("const char*") BytePointer balanc, @Cast("const char*") BytePointer jobvl, @Cast("const char*") BytePointer jobvr, @Cast("const char*") BytePointer sense,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer alpha,
    @Cast("lapack_complex_double*") DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer VL, @Const IntBuffer ldvl,
    @Cast("lapack_complex_double*") DoubleBuffer VR, @Const IntBuffer ldvr, IntBuffer ilo, IntBuffer ihi,
    DoubleBuffer lscale,
    DoubleBuffer rscale,
    DoubleBuffer abnrm,
    DoubleBuffer bbnrm,
    DoubleBuffer rconde,
    DoubleBuffer rcondv,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork, IntBuffer BWORK,
    IntBuffer info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
public static native void LAPACK_zggevx_base(
    String balanc, String jobvl, String jobvr, String sense,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] alpha,
    @Cast("lapack_complex_double*") double[] beta,
    @Cast("lapack_complex_double*") double[] VL, @Const int[] ldvl,
    @Cast("lapack_complex_double*") double[] VR, @Const int[] ldvr, int[] ilo, int[] ihi,
    double[] lscale,
    double[] rscale,
    double[] abnrm,
    double[] bbnrm,
    double[] rconde,
    double[] rcondv,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork, int[] BWORK,
    int[] info, @Cast("size_t") long arg29, @Cast("size_t") long arg30, @Cast("size_t") long arg31, @Cast("size_t") long arg32
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zggevx(...) LAPACK_zggevx_base(__VA_ARGS__, 1, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cggglm(
    @Const IntPointer n, @Const IntPointer m, @Const IntPointer p,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer D,
    @Cast("lapack_complex_float*") FloatPointer X,
    @Cast("lapack_complex_float*") FloatPointer Y,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cggglm(
    @Const IntBuffer n, @Const IntBuffer m, @Const IntBuffer p,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer D,
    @Cast("lapack_complex_float*") FloatBuffer X,
    @Cast("lapack_complex_float*") FloatBuffer Y,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cggglm(
    @Const int[] n, @Const int[] m, @Const int[] p,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] D,
    @Cast("lapack_complex_float*") float[] X,
    @Cast("lapack_complex_float*") float[] Y,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dggglm(
    @Const IntPointer n, @Const IntPointer m, @Const IntPointer p,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer D,
    DoublePointer X,
    DoublePointer Y,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dggglm(
    @Const IntBuffer n, @Const IntBuffer m, @Const IntBuffer p,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer D,
    DoubleBuffer X,
    DoubleBuffer Y,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dggglm(
    @Const int[] n, @Const int[] m, @Const int[] p,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] D,
    double[] X,
    double[] Y,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sggglm(
    @Const IntPointer n, @Const IntPointer m, @Const IntPointer p,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer D,
    FloatPointer X,
    FloatPointer Y,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sggglm(
    @Const IntBuffer n, @Const IntBuffer m, @Const IntBuffer p,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer D,
    FloatBuffer X,
    FloatBuffer Y,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sggglm(
    @Const int[] n, @Const int[] m, @Const int[] p,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] D,
    float[] X,
    float[] Y,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zggglm(
    @Const IntPointer n, @Const IntPointer m, @Const IntPointer p,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer D,
    @Cast("lapack_complex_double*") DoublePointer X,
    @Cast("lapack_complex_double*") DoublePointer Y,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zggglm(
    @Const IntBuffer n, @Const IntBuffer m, @Const IntBuffer p,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer D,
    @Cast("lapack_complex_double*") DoubleBuffer X,
    @Cast("lapack_complex_double*") DoubleBuffer Y,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zggglm(
    @Const int[] n, @Const int[] m, @Const int[] p,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] D,
    @Cast("lapack_complex_double*") double[] X,
    @Cast("lapack_complex_double*") double[] Y,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_cgghd3_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_cgghd3_base(
    String compq, String compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_cgghd3_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_cgghd3_base(
    String compq, String compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_cgghd3_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_cgghd3_base(
    String compq, String compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgghd3(...) LAPACK_cgghd3_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_dgghd3_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer Q, @Const IntPointer ldq,
    DoublePointer Z, @Const IntPointer ldz,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_dgghd3_base(
    String compq, String compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer Q, @Const IntBuffer ldq,
    DoubleBuffer Z, @Const IntBuffer ldz,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_dgghd3_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] Q, @Const int[] ldq,
    double[] Z, @Const int[] ldz,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_dgghd3_base(
    String compq, String compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer Q, @Const IntPointer ldq,
    DoublePointer Z, @Const IntPointer ldz,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_dgghd3_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer Q, @Const IntBuffer ldq,
    DoubleBuffer Z, @Const IntBuffer ldz,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_dgghd3_base(
    String compq, String compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] Q, @Const int[] ldq,
    double[] Z, @Const int[] ldz,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgghd3(...) LAPACK_dgghd3_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sgghd3_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer Q, @Const IntPointer ldq,
    FloatPointer Z, @Const IntPointer ldz,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_sgghd3_base(
    String compq, String compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer Q, @Const IntBuffer ldq,
    FloatBuffer Z, @Const IntBuffer ldz,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_sgghd3_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] Q, @Const int[] ldq,
    float[] Z, @Const int[] ldz,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_sgghd3_base(
    String compq, String compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer Q, @Const IntPointer ldq,
    FloatPointer Z, @Const IntPointer ldz,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_sgghd3_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer Q, @Const IntBuffer ldq,
    FloatBuffer Z, @Const IntBuffer ldz,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_sgghd3_base(
    String compq, String compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] Q, @Const int[] ldq,
    float[] Z, @Const int[] ldz,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgghd3(...) LAPACK_sgghd3_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zgghd3_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zgghd3_base(
    String compq, String compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zgghd3_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zgghd3_base(
    String compq, String compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zgghd3_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zgghd3_base(
    String compq, String compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgghd3(...) LAPACK_zgghd3_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cgghrd_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgghrd_base(
    String compq, String compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgghrd_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgghrd_base(
    String compq, String compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgghrd_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_cgghrd_base(
    String compq, String compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgghrd(...) LAPACK_cgghrd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_dgghrd_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer Q, @Const IntPointer ldq,
    DoublePointer Z, @Const IntPointer ldz,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgghrd_base(
    String compq, String compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer Q, @Const IntBuffer ldq,
    DoubleBuffer Z, @Const IntBuffer ldz,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgghrd_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] Q, @Const int[] ldq,
    double[] Z, @Const int[] ldz,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgghrd_base(
    String compq, String compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer Q, @Const IntPointer ldq,
    DoublePointer Z, @Const IntPointer ldz,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgghrd_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer Q, @Const IntBuffer ldq,
    DoubleBuffer Z, @Const IntBuffer ldz,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_dgghrd_base(
    String compq, String compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] Q, @Const int[] ldq,
    double[] Z, @Const int[] ldz,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgghrd(...) LAPACK_dgghrd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sgghrd_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer Q, @Const IntPointer ldq,
    FloatPointer Z, @Const IntPointer ldz,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgghrd_base(
    String compq, String compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer Q, @Const IntBuffer ldq,
    FloatBuffer Z, @Const IntBuffer ldz,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgghrd_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] Q, @Const int[] ldq,
    float[] Z, @Const int[] ldz,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgghrd_base(
    String compq, String compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer Q, @Const IntPointer ldq,
    FloatPointer Z, @Const IntPointer ldz,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgghrd_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer Q, @Const IntBuffer ldq,
    FloatBuffer Z, @Const IntBuffer ldz,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_sgghrd_base(
    String compq, String compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] Q, @Const int[] ldq,
    float[] Z, @Const int[] ldz,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgghrd(...) LAPACK_sgghrd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zgghrd_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgghrd_base(
    String compq, String compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgghrd_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgghrd_base(
    String compq, String compz,
    @Const IntPointer n, @Const IntPointer ilo, @Const IntPointer ihi,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgghrd_base(
    @Cast("const char*") BytePointer compq, @Cast("const char*") BytePointer compz,
    @Const IntBuffer n, @Const IntBuffer ilo, @Const IntBuffer ihi,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zgghrd_base(
    String compq, String compz,
    @Const int[] n, @Const int[] ilo, @Const int[] ihi,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgghrd(...) LAPACK_zgghrd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cgglse(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer p,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer C,
    @Cast("lapack_complex_float*") FloatPointer D,
    @Cast("lapack_complex_float*") FloatPointer X,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cgglse(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer p,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer C,
    @Cast("lapack_complex_float*") FloatBuffer D,
    @Cast("lapack_complex_float*") FloatBuffer X,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cgglse(
    @Const int[] m, @Const int[] n, @Const int[] p,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] C,
    @Cast("lapack_complex_float*") float[] D,
    @Cast("lapack_complex_float*") float[] X,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dgglse(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer p,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer C,
    DoublePointer D,
    DoublePointer X,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dgglse(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer p,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer C,
    DoubleBuffer D,
    DoubleBuffer X,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dgglse(
    @Const int[] m, @Const int[] n, @Const int[] p,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] C,
    double[] D,
    double[] X,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sgglse(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer p,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer C,
    FloatPointer D,
    FloatPointer X,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sgglse(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer p,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer C,
    FloatBuffer D,
    FloatBuffer X,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sgglse(
    @Const int[] m, @Const int[] n, @Const int[] p,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] C,
    float[] D,
    float[] X,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zgglse(
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer p,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer C,
    @Cast("lapack_complex_double*") DoublePointer D,
    @Cast("lapack_complex_double*") DoublePointer X,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zgglse(
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer p,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer C,
    @Cast("lapack_complex_double*") DoubleBuffer D,
    @Cast("lapack_complex_double*") DoubleBuffer X,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zgglse(
    @Const int[] m, @Const int[] n, @Const int[] p,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] C,
    @Cast("lapack_complex_double*") double[] D,
    @Cast("lapack_complex_double*") double[] X,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_cggqrf(
    @Const IntPointer n, @Const IntPointer m, @Const IntPointer p,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer taua,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer taub,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cggqrf(
    @Const IntBuffer n, @Const IntBuffer m, @Const IntBuffer p,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer taua,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer taub,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cggqrf(
    @Const int[] n, @Const int[] m, @Const int[] p,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] taua,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] taub,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dggqrf(
    @Const IntPointer n, @Const IntPointer m, @Const IntPointer p,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer taua,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer taub,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dggqrf(
    @Const IntBuffer n, @Const IntBuffer m, @Const IntBuffer p,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer taua,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer taub,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dggqrf(
    @Const int[] n, @Const int[] m, @Const int[] p,
    double[] A, @Const int[] lda,
    double[] taua,
    double[] B, @Const int[] ldb,
    double[] taub,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sggqrf(
    @Const IntPointer n, @Const IntPointer m, @Const IntPointer p,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer taua,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer taub,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sggqrf(
    @Const IntBuffer n, @Const IntBuffer m, @Const IntBuffer p,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer taua,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer taub,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sggqrf(
    @Const int[] n, @Const int[] m, @Const int[] p,
    float[] A, @Const int[] lda,
    float[] taua,
    float[] B, @Const int[] ldb,
    float[] taub,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zggqrf(
    @Const IntPointer n, @Const IntPointer m, @Const IntPointer p,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer taua,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer taub,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zggqrf(
    @Const IntBuffer n, @Const IntBuffer m, @Const IntBuffer p,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer taua,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer taub,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zggqrf(
    @Const int[] n, @Const int[] m, @Const int[] p,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] taua,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] taub,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_cggrqf(
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer taua,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer taub,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_cggrqf(
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer taua,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer taub,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_cggrqf(
    @Const int[] m, @Const int[] p, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] taua,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] taub,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_dggrqf(
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer taua,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer taub,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_dggrqf(
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer taua,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer taub,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_dggrqf(
    @Const int[] m, @Const int[] p, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] taua,
    double[] B, @Const int[] ldb,
    double[] taub,
    double[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_sggrqf(
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer taua,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer taub,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_sggrqf(
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer taua,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer taub,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_sggrqf(
    @Const int[] m, @Const int[] p, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] taua,
    float[] B, @Const int[] ldb,
    float[] taub,
    float[] work, @Const int[] lwork,
    int[] info );

public static native void LAPACK_zggrqf(
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer taua,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer taub,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info );
public static native void LAPACK_zggrqf(
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer taua,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer taub,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info );
public static native void LAPACK_zggrqf(
    @Const int[] m, @Const int[] p, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] taua,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] taub,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info );


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cggsvd(...) LAPACK_cggsvd_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sggsvd(...) LAPACK_sggsvd_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dggsvd(...) LAPACK_dggsvd_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zggsvd(...) LAPACK_zggsvd_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cggsvd3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer p, IntPointer k, IntPointer l,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    FloatPointer alpha,
    FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_cggsvd3_base(
    String jobu, String jobv, String jobq,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer p, IntBuffer k, IntBuffer l,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer alpha,
    FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_cggsvd3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const int[] m, @Const int[] n, @Const int[] p, int[] k, int[] l,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    float[] alpha,
    float[] beta,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] V, @Const int[] ldv,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_cggsvd3_base(
    String jobu, String jobv, String jobq,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer p, IntPointer k, IntPointer l,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    FloatPointer alpha,
    FloatPointer beta,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_cggsvd3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer p, IntBuffer k, IntBuffer l,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer alpha,
    FloatBuffer beta,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_cggsvd3_base(
    String jobu, String jobv, String jobq,
    @Const int[] m, @Const int[] n, @Const int[] p, int[] k, int[] l,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    float[] alpha,
    float[] beta,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] V, @Const int[] ldv,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cggsvd3(...) LAPACK_cggsvd3_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dggsvd3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer p, IntPointer k, IntPointer l,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer alpha,
    DoublePointer beta,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer V, @Const IntPointer ldv,
    DoublePointer Q, @Const IntPointer ldq,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dggsvd3_base(
    String jobu, String jobv, String jobq,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer p, IntBuffer k, IntBuffer l,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer alpha,
    DoubleBuffer beta,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer V, @Const IntBuffer ldv,
    DoubleBuffer Q, @Const IntBuffer ldq,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dggsvd3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const int[] m, @Const int[] n, @Const int[] p, int[] k, int[] l,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] alpha,
    double[] beta,
    double[] U, @Const int[] ldu,
    double[] V, @Const int[] ldv,
    double[] Q, @Const int[] ldq,
    double[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dggsvd3_base(
    String jobu, String jobv, String jobq,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer p, IntPointer k, IntPointer l,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    DoublePointer alpha,
    DoublePointer beta,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer V, @Const IntPointer ldv,
    DoublePointer Q, @Const IntPointer ldq,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dggsvd3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer p, IntBuffer k, IntBuffer l,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer alpha,
    DoubleBuffer beta,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer V, @Const IntBuffer ldv,
    DoubleBuffer Q, @Const IntBuffer ldq,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_dggsvd3_base(
    String jobu, String jobv, String jobq,
    @Const int[] m, @Const int[] n, @Const int[] p, int[] k, int[] l,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    double[] alpha,
    double[] beta,
    double[] U, @Const int[] ldu,
    double[] V, @Const int[] ldv,
    double[] Q, @Const int[] ldq,
    double[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dggsvd3(...) LAPACK_dggsvd3_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sggsvd3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer p, IntPointer k, IntPointer l,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer alpha,
    FloatPointer beta,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer V, @Const IntPointer ldv,
    FloatPointer Q, @Const IntPointer ldq,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sggsvd3_base(
    String jobu, String jobv, String jobq,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer p, IntBuffer k, IntBuffer l,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer alpha,
    FloatBuffer beta,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer V, @Const IntBuffer ldv,
    FloatBuffer Q, @Const IntBuffer ldq,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sggsvd3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const int[] m, @Const int[] n, @Const int[] p, int[] k, int[] l,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] alpha,
    float[] beta,
    float[] U, @Const int[] ldu,
    float[] V, @Const int[] ldv,
    float[] Q, @Const int[] ldq,
    float[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sggsvd3_base(
    String jobu, String jobv, String jobq,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer p, IntPointer k, IntPointer l,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    FloatPointer alpha,
    FloatPointer beta,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer V, @Const IntPointer ldv,
    FloatPointer Q, @Const IntPointer ldq,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sggsvd3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer p, IntBuffer k, IntBuffer l,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer alpha,
    FloatBuffer beta,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer V, @Const IntBuffer ldv,
    FloatBuffer Q, @Const IntBuffer ldq,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_sggsvd3_base(
    String jobu, String jobv, String jobq,
    @Const int[] m, @Const int[] n, @Const int[] p, int[] k, int[] l,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    float[] alpha,
    float[] beta,
    float[] U, @Const int[] ldu,
    float[] V, @Const int[] ldv,
    float[] Q, @Const int[] ldq,
    float[] work, @Const int[] lwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sggsvd3(...) LAPACK_sggsvd3_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zggsvd3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer p, IntPointer k, IntPointer l,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    DoublePointer alpha,
    DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_zggsvd3_base(
    String jobu, String jobv, String jobq,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer p, IntBuffer k, IntBuffer l,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer alpha,
    DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_zggsvd3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const int[] m, @Const int[] n, @Const int[] p, int[] k, int[] l,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    double[] alpha,
    double[] beta,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] V, @Const int[] ldv,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_zggsvd3_base(
    String jobu, String jobv, String jobq,
    @Const IntPointer m, @Const IntPointer n, @Const IntPointer p, IntPointer k, IntPointer l,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    DoublePointer alpha,
    DoublePointer beta,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_zggsvd3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer p, IntBuffer k, IntBuffer l,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer alpha,
    DoubleBuffer beta,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_zggsvd3_base(
    String jobu, String jobv, String jobq,
    @Const int[] m, @Const int[] n, @Const int[] p, int[] k, int[] l,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    double[] alpha,
    double[] beta,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] V, @Const int[] ldv,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork,
    int[] info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zggsvd3(...) LAPACK_zggsvd3_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sggsvp(...) LAPACK_sggsvp_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dggsvp(...) LAPACK_dggsvp_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cggsvp(...) LAPACK_cggsvp_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif


// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zggsvp(...) LAPACK_zggsvp_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cggsvp3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Const FloatPointer tola,
    @Const FloatPointer tolb, IntPointer k, IntPointer l,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    IntPointer iwork,
    FloatPointer rwork,
    @Cast("lapack_complex_float*") FloatPointer tau,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_cggsvp3_base(
    String jobu, String jobv, String jobq,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Const FloatBuffer tola,
    @Const FloatBuffer tolb, IntBuffer k, IntBuffer l,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    IntBuffer iwork,
    FloatBuffer rwork,
    @Cast("lapack_complex_float*") FloatBuffer tau,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_cggsvp3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const int[] m, @Const int[] p, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Const float[] tola,
    @Const float[] tolb, int[] k, int[] l,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] V, @Const int[] ldv,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    int[] iwork,
    float[] rwork,
    @Cast("lapack_complex_float*") float[] tau,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_cggsvp3_base(
    String jobu, String jobv, String jobq,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Const FloatPointer tola,
    @Const FloatPointer tolb, IntPointer k, IntPointer l,
    @Cast("lapack_complex_float*") FloatPointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_float*") FloatPointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    IntPointer iwork,
    FloatPointer rwork,
    @Cast("lapack_complex_float*") FloatPointer tau,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_cggsvp3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Const FloatBuffer tola,
    @Const FloatBuffer tolb, IntBuffer k, IntBuffer l,
    @Cast("lapack_complex_float*") FloatBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_float*") FloatBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    IntBuffer iwork,
    FloatBuffer rwork,
    @Cast("lapack_complex_float*") FloatBuffer tau,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_cggsvp3_base(
    String jobu, String jobv, String jobq,
    @Const int[] m, @Const int[] p, @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    @Const float[] tola,
    @Const float[] tolb, int[] k, int[] l,
    @Cast("lapack_complex_float*") float[] U, @Const int[] ldu,
    @Cast("lapack_complex_float*") float[] V, @Const int[] ldv,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    int[] iwork,
    float[] rwork,
    @Cast("lapack_complex_float*") float[] tau,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cggsvp3(...) LAPACK_cggsvp3_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_dggsvp3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    @Const DoublePointer tola,
    @Const DoublePointer tolb, IntPointer k, IntPointer l,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer V, @Const IntPointer ldv,
    DoublePointer Q, @Const IntPointer ldq,
    IntPointer iwork,
    DoublePointer tau,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_dggsvp3_base(
    String jobu, String jobv, String jobq,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    @Const DoubleBuffer tola,
    @Const DoubleBuffer tolb, IntBuffer k, IntBuffer l,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer V, @Const IntBuffer ldv,
    DoubleBuffer Q, @Const IntBuffer ldq,
    IntBuffer iwork,
    DoubleBuffer tau,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_dggsvp3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const int[] m, @Const int[] p, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    @Const double[] tola,
    @Const double[] tolb, int[] k, int[] l,
    double[] U, @Const int[] ldu,
    double[] V, @Const int[] ldv,
    double[] Q, @Const int[] ldq,
    int[] iwork,
    double[] tau,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_dggsvp3_base(
    String jobu, String jobv, String jobq,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer n,
    DoublePointer A, @Const IntPointer lda,
    DoublePointer B, @Const IntPointer ldb,
    @Const DoublePointer tola,
    @Const DoublePointer tolb, IntPointer k, IntPointer l,
    DoublePointer U, @Const IntPointer ldu,
    DoublePointer V, @Const IntPointer ldv,
    DoublePointer Q, @Const IntPointer ldq,
    IntPointer iwork,
    DoublePointer tau,
    DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_dggsvp3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer n,
    DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer B, @Const IntBuffer ldb,
    @Const DoubleBuffer tola,
    @Const DoubleBuffer tolb, IntBuffer k, IntBuffer l,
    DoubleBuffer U, @Const IntBuffer ldu,
    DoubleBuffer V, @Const IntBuffer ldv,
    DoubleBuffer Q, @Const IntBuffer ldq,
    IntBuffer iwork,
    DoubleBuffer tau,
    DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_dggsvp3_base(
    String jobu, String jobv, String jobq,
    @Const int[] m, @Const int[] p, @Const int[] n,
    double[] A, @Const int[] lda,
    double[] B, @Const int[] ldb,
    @Const double[] tola,
    @Const double[] tolb, int[] k, int[] l,
    double[] U, @Const int[] ldu,
    double[] V, @Const int[] ldv,
    double[] Q, @Const int[] ldq,
    int[] iwork,
    double[] tau,
    double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dggsvp3(...) LAPACK_dggsvp3_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_sggsvp3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    @Const FloatPointer tola,
    @Const FloatPointer tolb, IntPointer k, IntPointer l,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer V, @Const IntPointer ldv,
    FloatPointer Q, @Const IntPointer ldq,
    IntPointer iwork,
    FloatPointer tau,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_sggsvp3_base(
    String jobu, String jobv, String jobq,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    @Const FloatBuffer tola,
    @Const FloatBuffer tolb, IntBuffer k, IntBuffer l,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer V, @Const IntBuffer ldv,
    FloatBuffer Q, @Const IntBuffer ldq,
    IntBuffer iwork,
    FloatBuffer tau,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_sggsvp3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const int[] m, @Const int[] p, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    @Const float[] tola,
    @Const float[] tolb, int[] k, int[] l,
    float[] U, @Const int[] ldu,
    float[] V, @Const int[] ldv,
    float[] Q, @Const int[] ldq,
    int[] iwork,
    float[] tau,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_sggsvp3_base(
    String jobu, String jobv, String jobq,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer n,
    FloatPointer A, @Const IntPointer lda,
    FloatPointer B, @Const IntPointer ldb,
    @Const FloatPointer tola,
    @Const FloatPointer tolb, IntPointer k, IntPointer l,
    FloatPointer U, @Const IntPointer ldu,
    FloatPointer V, @Const IntPointer ldv,
    FloatPointer Q, @Const IntPointer ldq,
    IntPointer iwork,
    FloatPointer tau,
    FloatPointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_sggsvp3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer n,
    FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer B, @Const IntBuffer ldb,
    @Const FloatBuffer tola,
    @Const FloatBuffer tolb, IntBuffer k, IntBuffer l,
    FloatBuffer U, @Const IntBuffer ldu,
    FloatBuffer V, @Const IntBuffer ldv,
    FloatBuffer Q, @Const IntBuffer ldq,
    IntBuffer iwork,
    FloatBuffer tau,
    FloatBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
public static native void LAPACK_sggsvp3_base(
    String jobu, String jobv, String jobq,
    @Const int[] m, @Const int[] p, @Const int[] n,
    float[] A, @Const int[] lda,
    float[] B, @Const int[] ldb,
    @Const float[] tola,
    @Const float[] tolb, int[] k, int[] l,
    float[] U, @Const int[] ldu,
    float[] V, @Const int[] ldv,
    float[] Q, @Const int[] ldq,
    int[] iwork,
    float[] tau,
    float[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg25, @Cast("size_t") long arg26, @Cast("size_t") long arg27
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sggsvp3(...) LAPACK_sggsvp3_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zggsvp3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Const DoublePointer tola,
    @Const DoublePointer tolb, IntPointer k, IntPointer l,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    IntPointer iwork,
    DoublePointer rwork,
    @Cast("lapack_complex_double*") DoublePointer tau,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_zggsvp3_base(
    String jobu, String jobv, String jobq,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Const DoubleBuffer tola,
    @Const DoubleBuffer tolb, IntBuffer k, IntBuffer l,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    IntBuffer iwork,
    DoubleBuffer rwork,
    @Cast("lapack_complex_double*") DoubleBuffer tau,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_zggsvp3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const int[] m, @Const int[] p, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Const double[] tola,
    @Const double[] tolb, int[] k, int[] l,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] V, @Const int[] ldv,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    int[] iwork,
    double[] rwork,
    @Cast("lapack_complex_double*") double[] tau,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_zggsvp3_base(
    String jobu, String jobv, String jobq,
    @Const IntPointer m, @Const IntPointer p, @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Const DoublePointer tola,
    @Const DoublePointer tolb, IntPointer k, IntPointer l,
    @Cast("lapack_complex_double*") DoublePointer U, @Const IntPointer ldu,
    @Cast("lapack_complex_double*") DoublePointer V, @Const IntPointer ldv,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    IntPointer iwork,
    DoublePointer rwork,
    @Cast("lapack_complex_double*") DoublePointer tau,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_zggsvp3_base(
    @Cast("const char*") BytePointer jobu, @Cast("const char*") BytePointer jobv, @Cast("const char*") BytePointer jobq,
    @Const IntBuffer m, @Const IntBuffer p, @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Const DoubleBuffer tola,
    @Const DoubleBuffer tolb, IntBuffer k, IntBuffer l,
    @Cast("lapack_complex_double*") DoubleBuffer U, @Const IntBuffer ldu,
    @Cast("lapack_complex_double*") DoubleBuffer V, @Const IntBuffer ldv,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    IntBuffer iwork,
    DoubleBuffer rwork,
    @Cast("lapack_complex_double*") DoubleBuffer tau,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_zggsvp3_base(
    String jobu, String jobv, String jobq,
    @Const int[] m, @Const int[] p, @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    @Const double[] tola,
    @Const double[] tolb, int[] k, int[] l,
    @Cast("lapack_complex_double*") double[] U, @Const int[] ldu,
    @Cast("lapack_complex_double*") double[] V, @Const int[] ldv,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    int[] iwork,
    double[] rwork,
    @Cast("lapack_complex_double*") double[] tau,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zggsvp3(...) LAPACK_zggsvp3_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cgtcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntPointer n,
    @Cast("const lapack_complex_float*") FloatPointer DL,
    @Cast("const lapack_complex_float*") FloatPointer D,
    @Cast("const lapack_complex_float*") FloatPointer DU,
    @Cast("const lapack_complex_float*") FloatPointer DU2, @Const IntPointer ipiv,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgtcon_base(
    String norm,
    @Const IntBuffer n,
    @Cast("const lapack_complex_float*") FloatBuffer DL,
    @Cast("const lapack_complex_float*") FloatBuffer D,
    @Cast("const lapack_complex_float*") FloatBuffer DU,
    @Cast("const lapack_complex_float*") FloatBuffer DU2, @Const IntBuffer ipiv,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgtcon_base(
    @Cast("const char*") BytePointer norm,
    @Const int[] n,
    @Cast("const lapack_complex_float*") float[] DL,
    @Cast("const lapack_complex_float*") float[] D,
    @Cast("const lapack_complex_float*") float[] DU,
    @Cast("const lapack_complex_float*") float[] DU2, @Const int[] ipiv,
    @Const float[] anorm,
    float[] rcond,
    @Cast("lapack_complex_float*") float[] work,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgtcon_base(
    String norm,
    @Const IntPointer n,
    @Cast("const lapack_complex_float*") FloatPointer DL,
    @Cast("const lapack_complex_float*") FloatPointer D,
    @Cast("const lapack_complex_float*") FloatPointer DU,
    @Cast("const lapack_complex_float*") FloatPointer DU2, @Const IntPointer ipiv,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgtcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntBuffer n,
    @Cast("const lapack_complex_float*") FloatBuffer DL,
    @Cast("const lapack_complex_float*") FloatBuffer D,
    @Cast("const lapack_complex_float*") FloatBuffer DU,
    @Cast("const lapack_complex_float*") FloatBuffer DU2, @Const IntBuffer ipiv,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgtcon_base(
    String norm,
    @Const int[] n,
    @Cast("const lapack_complex_float*") float[] DL,
    @Cast("const lapack_complex_float*") float[] D,
    @Cast("const lapack_complex_float*") float[] DU,
    @Cast("const lapack_complex_float*") float[] DU2, @Const int[] ipiv,
    @Const float[] anorm,
    float[] rcond,
    @Cast("lapack_complex_float*") float[] work,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgtcon(...) LAPACK_cgtcon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dgtcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntPointer n,
    @Const DoublePointer DL,
    @Const DoublePointer D,
    @Const DoublePointer DU,
    @Const DoublePointer DU2, @Const IntPointer ipiv,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_dgtcon_base(
    String norm,
    @Const IntBuffer n,
    @Const DoubleBuffer DL,
    @Const DoubleBuffer D,
    @Const DoubleBuffer DU,
    @Const DoubleBuffer DU2, @Const IntBuffer ipiv,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_dgtcon_base(
    @Cast("const char*") BytePointer norm,
    @Const int[] n,
    @Const double[] DL,
    @Const double[] D,
    @Const double[] DU,
    @Const double[] DU2, @Const int[] ipiv,
    @Const double[] anorm,
    double[] rcond,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg12
);
public static native void LAPACK_dgtcon_base(
    String norm,
    @Const IntPointer n,
    @Const DoublePointer DL,
    @Const DoublePointer D,
    @Const DoublePointer DU,
    @Const DoublePointer DU2, @Const IntPointer ipiv,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_dgtcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntBuffer n,
    @Const DoubleBuffer DL,
    @Const DoubleBuffer D,
    @Const DoubleBuffer DU,
    @Const DoubleBuffer DU2, @Const IntBuffer ipiv,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_dgtcon_base(
    String norm,
    @Const int[] n,
    @Const double[] DL,
    @Const double[] D,
    @Const double[] DU,
    @Const double[] DU2, @Const int[] ipiv,
    @Const double[] anorm,
    double[] rcond,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgtcon(...) LAPACK_dgtcon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sgtcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntPointer n,
    @Const FloatPointer DL,
    @Const FloatPointer D,
    @Const FloatPointer DU,
    @Const FloatPointer DU2, @Const IntPointer ipiv,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_sgtcon_base(
    String norm,
    @Const IntBuffer n,
    @Const FloatBuffer DL,
    @Const FloatBuffer D,
    @Const FloatBuffer DU,
    @Const FloatBuffer DU2, @Const IntBuffer ipiv,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_sgtcon_base(
    @Cast("const char*") BytePointer norm,
    @Const int[] n,
    @Const float[] DL,
    @Const float[] D,
    @Const float[] DU,
    @Const float[] DU2, @Const int[] ipiv,
    @Const float[] anorm,
    float[] rcond,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg12
);
public static native void LAPACK_sgtcon_base(
    String norm,
    @Const IntPointer n,
    @Const FloatPointer DL,
    @Const FloatPointer D,
    @Const FloatPointer DU,
    @Const FloatPointer DU2, @Const IntPointer ipiv,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg12
);
public static native void LAPACK_sgtcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntBuffer n,
    @Const FloatBuffer DL,
    @Const FloatBuffer D,
    @Const FloatBuffer DU,
    @Const FloatBuffer DU2, @Const IntBuffer ipiv,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg12
);
public static native void LAPACK_sgtcon_base(
    String norm,
    @Const int[] n,
    @Const float[] DL,
    @Const float[] D,
    @Const float[] DU,
    @Const float[] DU2, @Const int[] ipiv,
    @Const float[] anorm,
    float[] rcond,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg12
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgtcon(...) LAPACK_sgtcon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zgtcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntPointer n,
    @Cast("const lapack_complex_double*") DoublePointer DL,
    @Cast("const lapack_complex_double*") DoublePointer D,
    @Cast("const lapack_complex_double*") DoublePointer DU,
    @Cast("const lapack_complex_double*") DoublePointer DU2, @Const IntPointer ipiv,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgtcon_base(
    String norm,
    @Const IntBuffer n,
    @Cast("const lapack_complex_double*") DoubleBuffer DL,
    @Cast("const lapack_complex_double*") DoubleBuffer D,
    @Cast("const lapack_complex_double*") DoubleBuffer DU,
    @Cast("const lapack_complex_double*") DoubleBuffer DU2, @Const IntBuffer ipiv,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgtcon_base(
    @Cast("const char*") BytePointer norm,
    @Const int[] n,
    @Cast("const lapack_complex_double*") double[] DL,
    @Cast("const lapack_complex_double*") double[] D,
    @Cast("const lapack_complex_double*") double[] DU,
    @Cast("const lapack_complex_double*") double[] DU2, @Const int[] ipiv,
    @Const double[] anorm,
    double[] rcond,
    @Cast("lapack_complex_double*") double[] work,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgtcon_base(
    String norm,
    @Const IntPointer n,
    @Cast("const lapack_complex_double*") DoublePointer DL,
    @Cast("const lapack_complex_double*") DoublePointer D,
    @Cast("const lapack_complex_double*") DoublePointer DU,
    @Cast("const lapack_complex_double*") DoublePointer DU2, @Const IntPointer ipiv,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgtcon_base(
    @Cast("const char*") BytePointer norm,
    @Const IntBuffer n,
    @Cast("const lapack_complex_double*") DoubleBuffer DL,
    @Cast("const lapack_complex_double*") DoubleBuffer D,
    @Cast("const lapack_complex_double*") DoubleBuffer DU,
    @Cast("const lapack_complex_double*") DoubleBuffer DU2, @Const IntBuffer ipiv,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgtcon_base(
    String norm,
    @Const int[] n,
    @Cast("const lapack_complex_double*") double[] DL,
    @Cast("const lapack_complex_double*") double[] D,
    @Cast("const lapack_complex_double*") double[] DU,
    @Cast("const lapack_complex_double*") double[] DU2, @Const int[] ipiv,
    @Const double[] anorm,
    double[] rcond,
    @Cast("lapack_complex_double*") double[] work,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgtcon(...) LAPACK_zgtcon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_cgtrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer DL,
    @Cast("const lapack_complex_float*") FloatPointer D,
    @Cast("const lapack_complex_float*") FloatPointer DU,
    @Cast("const lapack_complex_float*") FloatPointer DLF,
    @Cast("const lapack_complex_float*") FloatPointer DF,
    @Cast("const lapack_complex_float*") FloatPointer DUF,
    @Cast("const lapack_complex_float*") FloatPointer DU2, @Const IntPointer ipiv,
    @Cast("const lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    FloatPointer ferr,
    FloatPointer berr,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg20
);
public static native void LAPACK_cgtrfs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer DL,
    @Cast("const lapack_complex_float*") FloatBuffer D,
    @Cast("const lapack_complex_float*") FloatBuffer DU,
    @Cast("const lapack_complex_float*") FloatBuffer DLF,
    @Cast("const lapack_complex_float*") FloatBuffer DF,
    @Cast("const lapack_complex_float*") FloatBuffer DUF,
    @Cast("const lapack_complex_float*") FloatBuffer DU2, @Const IntBuffer ipiv,
    @Cast("const lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer ferr,
    FloatBuffer berr,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg20
);
public static native void LAPACK_cgtrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] DL,
    @Cast("const lapack_complex_float*") float[] D,
    @Cast("const lapack_complex_float*") float[] DU,
    @Cast("const lapack_complex_float*") float[] DLF,
    @Cast("const lapack_complex_float*") float[] DF,
    @Cast("const lapack_complex_float*") float[] DUF,
    @Cast("const lapack_complex_float*") float[] DU2, @Const int[] ipiv,
    @Cast("const lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    float[] ferr,
    float[] berr,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg20
);
public static native void LAPACK_cgtrfs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer DL,
    @Cast("const lapack_complex_float*") FloatPointer D,
    @Cast("const lapack_complex_float*") FloatPointer DU,
    @Cast("const lapack_complex_float*") FloatPointer DLF,
    @Cast("const lapack_complex_float*") FloatPointer DF,
    @Cast("const lapack_complex_float*") FloatPointer DUF,
    @Cast("const lapack_complex_float*") FloatPointer DU2, @Const IntPointer ipiv,
    @Cast("const lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    FloatPointer ferr,
    FloatPointer berr,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg20
);
public static native void LAPACK_cgtrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer DL,
    @Cast("const lapack_complex_float*") FloatBuffer D,
    @Cast("const lapack_complex_float*") FloatBuffer DU,
    @Cast("const lapack_complex_float*") FloatBuffer DLF,
    @Cast("const lapack_complex_float*") FloatBuffer DF,
    @Cast("const lapack_complex_float*") FloatBuffer DUF,
    @Cast("const lapack_complex_float*") FloatBuffer DU2, @Const IntBuffer ipiv,
    @Cast("const lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer ferr,
    FloatBuffer berr,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg20
);
public static native void LAPACK_cgtrfs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] DL,
    @Cast("const lapack_complex_float*") float[] D,
    @Cast("const lapack_complex_float*") float[] DU,
    @Cast("const lapack_complex_float*") float[] DLF,
    @Cast("const lapack_complex_float*") float[] DF,
    @Cast("const lapack_complex_float*") float[] DUF,
    @Cast("const lapack_complex_float*") float[] DU2, @Const int[] ipiv,
    @Cast("const lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    float[] ferr,
    float[] berr,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg20
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgtrfs(...) LAPACK_cgtrfs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dgtrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const DoublePointer DL,
    @Const DoublePointer D,
    @Const DoublePointer DU,
    @Const DoublePointer DLF,
    @Const DoublePointer DF,
    @Const DoublePointer DUF,
    @Const DoublePointer DU2, @Const IntPointer ipiv,
    @Const DoublePointer B, @Const IntPointer ldb,
    DoublePointer X, @Const IntPointer ldx,
    DoublePointer ferr,
    DoublePointer berr,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg20
);
public static native void LAPACK_dgtrfs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const DoubleBuffer DL,
    @Const DoubleBuffer D,
    @Const DoubleBuffer DU,
    @Const DoubleBuffer DLF,
    @Const DoubleBuffer DF,
    @Const DoubleBuffer DUF,
    @Const DoubleBuffer DU2, @Const IntBuffer ipiv,
    @Const DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg20
);
public static native void LAPACK_dgtrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Const double[] DL,
    @Const double[] D,
    @Const double[] DU,
    @Const double[] DLF,
    @Const double[] DF,
    @Const double[] DUF,
    @Const double[] DU2, @Const int[] ipiv,
    @Const double[] B, @Const int[] ldb,
    double[] X, @Const int[] ldx,
    double[] ferr,
    double[] berr,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg20
);
public static native void LAPACK_dgtrfs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const DoublePointer DL,
    @Const DoublePointer D,
    @Const DoublePointer DU,
    @Const DoublePointer DLF,
    @Const DoublePointer DF,
    @Const DoublePointer DUF,
    @Const DoublePointer DU2, @Const IntPointer ipiv,
    @Const DoublePointer B, @Const IntPointer ldb,
    DoublePointer X, @Const IntPointer ldx,
    DoublePointer ferr,
    DoublePointer berr,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg20
);
public static native void LAPACK_dgtrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const DoubleBuffer DL,
    @Const DoubleBuffer D,
    @Const DoubleBuffer DU,
    @Const DoubleBuffer DLF,
    @Const DoubleBuffer DF,
    @Const DoubleBuffer DUF,
    @Const DoubleBuffer DU2, @Const IntBuffer ipiv,
    @Const DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg20
);
public static native void LAPACK_dgtrfs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Const double[] DL,
    @Const double[] D,
    @Const double[] DU,
    @Const double[] DLF,
    @Const double[] DF,
    @Const double[] DUF,
    @Const double[] DU2, @Const int[] ipiv,
    @Const double[] B, @Const int[] ldb,
    double[] X, @Const int[] ldx,
    double[] ferr,
    double[] berr,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg20
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgtrfs(...) LAPACK_dgtrfs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sgtrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const FloatPointer DL,
    @Const FloatPointer D,
    @Const FloatPointer DU,
    @Const FloatPointer DLF,
    @Const FloatPointer DF,
    @Const FloatPointer DUF,
    @Const FloatPointer DU2, @Const IntPointer ipiv,
    @Const FloatPointer B, @Const IntPointer ldb,
    FloatPointer X, @Const IntPointer ldx,
    FloatPointer ferr,
    FloatPointer berr,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg20
);
public static native void LAPACK_sgtrfs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const FloatBuffer DL,
    @Const FloatBuffer D,
    @Const FloatBuffer DU,
    @Const FloatBuffer DLF,
    @Const FloatBuffer DF,
    @Const FloatBuffer DUF,
    @Const FloatBuffer DU2, @Const IntBuffer ipiv,
    @Const FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer ferr,
    FloatBuffer berr,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg20
);
public static native void LAPACK_sgtrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Const float[] DL,
    @Const float[] D,
    @Const float[] DU,
    @Const float[] DLF,
    @Const float[] DF,
    @Const float[] DUF,
    @Const float[] DU2, @Const int[] ipiv,
    @Const float[] B, @Const int[] ldb,
    float[] X, @Const int[] ldx,
    float[] ferr,
    float[] berr,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg20
);
public static native void LAPACK_sgtrfs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const FloatPointer DL,
    @Const FloatPointer D,
    @Const FloatPointer DU,
    @Const FloatPointer DLF,
    @Const FloatPointer DF,
    @Const FloatPointer DUF,
    @Const FloatPointer DU2, @Const IntPointer ipiv,
    @Const FloatPointer B, @Const IntPointer ldb,
    FloatPointer X, @Const IntPointer ldx,
    FloatPointer ferr,
    FloatPointer berr,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg20
);
public static native void LAPACK_sgtrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const FloatBuffer DL,
    @Const FloatBuffer D,
    @Const FloatBuffer DU,
    @Const FloatBuffer DLF,
    @Const FloatBuffer DF,
    @Const FloatBuffer DUF,
    @Const FloatBuffer DU2, @Const IntBuffer ipiv,
    @Const FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer ferr,
    FloatBuffer berr,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg20
);
public static native void LAPACK_sgtrfs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Const float[] DL,
    @Const float[] D,
    @Const float[] DU,
    @Const float[] DLF,
    @Const float[] DF,
    @Const float[] DUF,
    @Const float[] DU2, @Const int[] ipiv,
    @Const float[] B, @Const int[] ldb,
    float[] X, @Const int[] ldx,
    float[] ferr,
    float[] berr,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg20
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgtrfs(...) LAPACK_sgtrfs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zgtrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer DL,
    @Cast("const lapack_complex_double*") DoublePointer D,
    @Cast("const lapack_complex_double*") DoublePointer DU,
    @Cast("const lapack_complex_double*") DoublePointer DLF,
    @Cast("const lapack_complex_double*") DoublePointer DF,
    @Cast("const lapack_complex_double*") DoublePointer DUF,
    @Cast("const lapack_complex_double*") DoublePointer DU2, @Const IntPointer ipiv,
    @Cast("const lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    DoublePointer ferr,
    DoublePointer berr,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg20
);
public static native void LAPACK_zgtrfs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer DL,
    @Cast("const lapack_complex_double*") DoubleBuffer D,
    @Cast("const lapack_complex_double*") DoubleBuffer DU,
    @Cast("const lapack_complex_double*") DoubleBuffer DLF,
    @Cast("const lapack_complex_double*") DoubleBuffer DF,
    @Cast("const lapack_complex_double*") DoubleBuffer DUF,
    @Cast("const lapack_complex_double*") DoubleBuffer DU2, @Const IntBuffer ipiv,
    @Cast("const lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg20
);
public static native void LAPACK_zgtrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] DL,
    @Cast("const lapack_complex_double*") double[] D,
    @Cast("const lapack_complex_double*") double[] DU,
    @Cast("const lapack_complex_double*") double[] DLF,
    @Cast("const lapack_complex_double*") double[] DF,
    @Cast("const lapack_complex_double*") double[] DUF,
    @Cast("const lapack_complex_double*") double[] DU2, @Const int[] ipiv,
    @Cast("const lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    double[] ferr,
    double[] berr,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg20
);
public static native void LAPACK_zgtrfs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer DL,
    @Cast("const lapack_complex_double*") DoublePointer D,
    @Cast("const lapack_complex_double*") DoublePointer DU,
    @Cast("const lapack_complex_double*") DoublePointer DLF,
    @Cast("const lapack_complex_double*") DoublePointer DF,
    @Cast("const lapack_complex_double*") DoublePointer DUF,
    @Cast("const lapack_complex_double*") DoublePointer DU2, @Const IntPointer ipiv,
    @Cast("const lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    DoublePointer ferr,
    DoublePointer berr,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg20
);
public static native void LAPACK_zgtrfs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer DL,
    @Cast("const lapack_complex_double*") DoubleBuffer D,
    @Cast("const lapack_complex_double*") DoubleBuffer DU,
    @Cast("const lapack_complex_double*") DoubleBuffer DLF,
    @Cast("const lapack_complex_double*") DoubleBuffer DF,
    @Cast("const lapack_complex_double*") DoubleBuffer DUF,
    @Cast("const lapack_complex_double*") DoubleBuffer DU2, @Const IntBuffer ipiv,
    @Cast("const lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg20
);
public static native void LAPACK_zgtrfs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] DL,
    @Cast("const lapack_complex_double*") double[] D,
    @Cast("const lapack_complex_double*") double[] DU,
    @Cast("const lapack_complex_double*") double[] DLF,
    @Cast("const lapack_complex_double*") double[] DF,
    @Cast("const lapack_complex_double*") double[] DUF,
    @Cast("const lapack_complex_double*") double[] DU2, @Const int[] ipiv,
    @Cast("const lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    double[] ferr,
    double[] berr,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg20
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgtrfs(...) LAPACK_zgtrfs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_cgtsv(
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_float*") FloatPointer DL,
    @Cast("lapack_complex_float*") FloatPointer D,
    @Cast("lapack_complex_float*") FloatPointer DU,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    IntPointer info );
public static native void LAPACK_cgtsv(
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_float*") FloatBuffer DL,
    @Cast("lapack_complex_float*") FloatBuffer D,
    @Cast("lapack_complex_float*") FloatBuffer DU,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info );
public static native void LAPACK_cgtsv(
    @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_float*") float[] DL,
    @Cast("lapack_complex_float*") float[] D,
    @Cast("lapack_complex_float*") float[] DU,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    int[] info );

public static native void LAPACK_dgtsv(
    @Const IntPointer n, @Const IntPointer nrhs,
    DoublePointer DL,
    DoublePointer D,
    DoublePointer DU,
    DoublePointer B, @Const IntPointer ldb,
    IntPointer info );
public static native void LAPACK_dgtsv(
    @Const IntBuffer n, @Const IntBuffer nrhs,
    DoubleBuffer DL,
    DoubleBuffer D,
    DoubleBuffer DU,
    DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info );
public static native void LAPACK_dgtsv(
    @Const int[] n, @Const int[] nrhs,
    double[] DL,
    double[] D,
    double[] DU,
    double[] B, @Const int[] ldb,
    int[] info );

public static native void LAPACK_sgtsv(
    @Const IntPointer n, @Const IntPointer nrhs,
    FloatPointer DL,
    FloatPointer D,
    FloatPointer DU,
    FloatPointer B, @Const IntPointer ldb,
    IntPointer info );
public static native void LAPACK_sgtsv(
    @Const IntBuffer n, @Const IntBuffer nrhs,
    FloatBuffer DL,
    FloatBuffer D,
    FloatBuffer DU,
    FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info );
public static native void LAPACK_sgtsv(
    @Const int[] n, @Const int[] nrhs,
    float[] DL,
    float[] D,
    float[] DU,
    float[] B, @Const int[] ldb,
    int[] info );

public static native void LAPACK_zgtsv(
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("lapack_complex_double*") DoublePointer DL,
    @Cast("lapack_complex_double*") DoublePointer D,
    @Cast("lapack_complex_double*") DoublePointer DU,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    IntPointer info );
public static native void LAPACK_zgtsv(
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("lapack_complex_double*") DoubleBuffer DL,
    @Cast("lapack_complex_double*") DoubleBuffer D,
    @Cast("lapack_complex_double*") DoubleBuffer DU,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info );
public static native void LAPACK_zgtsv(
    @Const int[] n, @Const int[] nrhs,
    @Cast("lapack_complex_double*") double[] DL,
    @Cast("lapack_complex_double*") double[] D,
    @Cast("lapack_complex_double*") double[] DU,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    int[] info );

public static native void LAPACK_cgtsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer DL,
    @Cast("const lapack_complex_float*") FloatPointer D,
    @Cast("const lapack_complex_float*") FloatPointer DU,
    @Cast("lapack_complex_float*") FloatPointer DLF,
    @Cast("lapack_complex_float*") FloatPointer DF,
    @Cast("lapack_complex_float*") FloatPointer DUF,
    @Cast("lapack_complex_float*") FloatPointer DU2, IntPointer ipiv,
    @Cast("const lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    FloatPointer rcond,
    FloatPointer ferr,
    FloatPointer berr,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgtsvx_base(
    String fact, String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer DL,
    @Cast("const lapack_complex_float*") FloatBuffer D,
    @Cast("const lapack_complex_float*") FloatBuffer DU,
    @Cast("lapack_complex_float*") FloatBuffer DLF,
    @Cast("lapack_complex_float*") FloatBuffer DF,
    @Cast("lapack_complex_float*") FloatBuffer DUF,
    @Cast("lapack_complex_float*") FloatBuffer DU2, IntBuffer ipiv,
    @Cast("const lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer rcond,
    FloatBuffer ferr,
    FloatBuffer berr,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgtsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] DL,
    @Cast("const lapack_complex_float*") float[] D,
    @Cast("const lapack_complex_float*") float[] DU,
    @Cast("lapack_complex_float*") float[] DLF,
    @Cast("lapack_complex_float*") float[] DF,
    @Cast("lapack_complex_float*") float[] DUF,
    @Cast("lapack_complex_float*") float[] DU2, int[] ipiv,
    @Cast("const lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    float[] rcond,
    float[] ferr,
    float[] berr,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgtsvx_base(
    String fact, String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer DL,
    @Cast("const lapack_complex_float*") FloatPointer D,
    @Cast("const lapack_complex_float*") FloatPointer DU,
    @Cast("lapack_complex_float*") FloatPointer DLF,
    @Cast("lapack_complex_float*") FloatPointer DF,
    @Cast("lapack_complex_float*") FloatPointer DUF,
    @Cast("lapack_complex_float*") FloatPointer DU2, IntPointer ipiv,
    @Cast("const lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    FloatPointer rcond,
    FloatPointer ferr,
    FloatPointer berr,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgtsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer DL,
    @Cast("const lapack_complex_float*") FloatBuffer D,
    @Cast("const lapack_complex_float*") FloatBuffer DU,
    @Cast("lapack_complex_float*") FloatBuffer DLF,
    @Cast("lapack_complex_float*") FloatBuffer DF,
    @Cast("lapack_complex_float*") FloatBuffer DUF,
    @Cast("lapack_complex_float*") FloatBuffer DU2, IntBuffer ipiv,
    @Cast("const lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer rcond,
    FloatBuffer ferr,
    FloatBuffer berr,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cgtsvx_base(
    String fact, String trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] DL,
    @Cast("const lapack_complex_float*") float[] D,
    @Cast("const lapack_complex_float*") float[] DU,
    @Cast("lapack_complex_float*") float[] DLF,
    @Cast("lapack_complex_float*") float[] DF,
    @Cast("lapack_complex_float*") float[] DUF,
    @Cast("lapack_complex_float*") float[] DU2, int[] ipiv,
    @Cast("const lapack_complex_float*") float[] B, @Const int[] ldb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    float[] rcond,
    float[] ferr,
    float[] berr,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgtsvx(...) LAPACK_cgtsvx_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_dgtsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const DoublePointer DL,
    @Const DoublePointer D,
    @Const DoublePointer DU,
    DoublePointer DLF,
    DoublePointer DF,
    DoublePointer DUF,
    DoublePointer DU2, IntPointer ipiv,
    @Const DoublePointer B, @Const IntPointer ldb,
    DoublePointer X, @Const IntPointer ldx,
    DoublePointer rcond,
    DoublePointer ferr,
    DoublePointer berr,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgtsvx_base(
    String fact, String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const DoubleBuffer DL,
    @Const DoubleBuffer D,
    @Const DoubleBuffer DU,
    DoubleBuffer DLF,
    DoubleBuffer DF,
    DoubleBuffer DUF,
    DoubleBuffer DU2, IntBuffer ipiv,
    @Const DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer rcond,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgtsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Const double[] DL,
    @Const double[] D,
    @Const double[] DU,
    double[] DLF,
    double[] DF,
    double[] DUF,
    double[] DU2, int[] ipiv,
    @Const double[] B, @Const int[] ldb,
    double[] X, @Const int[] ldx,
    double[] rcond,
    double[] ferr,
    double[] berr,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgtsvx_base(
    String fact, String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const DoublePointer DL,
    @Const DoublePointer D,
    @Const DoublePointer DU,
    DoublePointer DLF,
    DoublePointer DF,
    DoublePointer DUF,
    DoublePointer DU2, IntPointer ipiv,
    @Const DoublePointer B, @Const IntPointer ldb,
    DoublePointer X, @Const IntPointer ldx,
    DoublePointer rcond,
    DoublePointer ferr,
    DoublePointer berr,
    DoublePointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgtsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const DoubleBuffer DL,
    @Const DoubleBuffer D,
    @Const DoubleBuffer DU,
    DoubleBuffer DLF,
    DoubleBuffer DF,
    DoubleBuffer DUF,
    DoubleBuffer DU2, IntBuffer ipiv,
    @Const DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer rcond,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    DoubleBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_dgtsvx_base(
    String fact, String trans,
    @Const int[] n, @Const int[] nrhs,
    @Const double[] DL,
    @Const double[] D,
    @Const double[] DU,
    double[] DLF,
    double[] DF,
    double[] DUF,
    double[] DU2, int[] ipiv,
    @Const double[] B, @Const int[] ldb,
    double[] X, @Const int[] ldx,
    double[] rcond,
    double[] ferr,
    double[] berr,
    double[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgtsvx(...) LAPACK_dgtsvx_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_sgtsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const FloatPointer DL,
    @Const FloatPointer D,
    @Const FloatPointer DU,
    FloatPointer DLF,
    FloatPointer DF,
    FloatPointer DUF,
    FloatPointer DU2, IntPointer ipiv,
    @Const FloatPointer B, @Const IntPointer ldb,
    FloatPointer X, @Const IntPointer ldx,
    FloatPointer rcond,
    FloatPointer ferr,
    FloatPointer berr,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgtsvx_base(
    String fact, String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const FloatBuffer DL,
    @Const FloatBuffer D,
    @Const FloatBuffer DU,
    FloatBuffer DLF,
    FloatBuffer DF,
    FloatBuffer DUF,
    FloatBuffer DU2, IntBuffer ipiv,
    @Const FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer rcond,
    FloatBuffer ferr,
    FloatBuffer berr,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgtsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Const float[] DL,
    @Const float[] D,
    @Const float[] DU,
    float[] DLF,
    float[] DF,
    float[] DUF,
    float[] DU2, int[] ipiv,
    @Const float[] B, @Const int[] ldb,
    float[] X, @Const int[] ldx,
    float[] rcond,
    float[] ferr,
    float[] berr,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgtsvx_base(
    String fact, String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const FloatPointer DL,
    @Const FloatPointer D,
    @Const FloatPointer DU,
    FloatPointer DLF,
    FloatPointer DF,
    FloatPointer DUF,
    FloatPointer DU2, IntPointer ipiv,
    @Const FloatPointer B, @Const IntPointer ldb,
    FloatPointer X, @Const IntPointer ldx,
    FloatPointer rcond,
    FloatPointer ferr,
    FloatPointer berr,
    FloatPointer work,
    IntPointer iwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgtsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const FloatBuffer DL,
    @Const FloatBuffer D,
    @Const FloatBuffer DU,
    FloatBuffer DLF,
    FloatBuffer DF,
    FloatBuffer DUF,
    FloatBuffer DU2, IntBuffer ipiv,
    @Const FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer X, @Const IntBuffer ldx,
    FloatBuffer rcond,
    FloatBuffer ferr,
    FloatBuffer berr,
    FloatBuffer work,
    IntBuffer iwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_sgtsvx_base(
    String fact, String trans,
    @Const int[] n, @Const int[] nrhs,
    @Const float[] DL,
    @Const float[] D,
    @Const float[] DU,
    float[] DLF,
    float[] DF,
    float[] DUF,
    float[] DU2, int[] ipiv,
    @Const float[] B, @Const int[] ldb,
    float[] X, @Const int[] ldx,
    float[] rcond,
    float[] ferr,
    float[] berr,
    float[] work,
    int[] iwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgtsvx(...) LAPACK_sgtsvx_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zgtsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer DL,
    @Cast("const lapack_complex_double*") DoublePointer D,
    @Cast("const lapack_complex_double*") DoublePointer DU,
    @Cast("lapack_complex_double*") DoublePointer DLF,
    @Cast("lapack_complex_double*") DoublePointer DF,
    @Cast("lapack_complex_double*") DoublePointer DUF,
    @Cast("lapack_complex_double*") DoublePointer DU2, IntPointer ipiv,
    @Cast("const lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    DoublePointer rcond,
    DoublePointer ferr,
    DoublePointer berr,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgtsvx_base(
    String fact, String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer DL,
    @Cast("const lapack_complex_double*") DoubleBuffer D,
    @Cast("const lapack_complex_double*") DoubleBuffer DU,
    @Cast("lapack_complex_double*") DoubleBuffer DLF,
    @Cast("lapack_complex_double*") DoubleBuffer DF,
    @Cast("lapack_complex_double*") DoubleBuffer DUF,
    @Cast("lapack_complex_double*") DoubleBuffer DU2, IntBuffer ipiv,
    @Cast("const lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer rcond,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgtsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] DL,
    @Cast("const lapack_complex_double*") double[] D,
    @Cast("const lapack_complex_double*") double[] DU,
    @Cast("lapack_complex_double*") double[] DLF,
    @Cast("lapack_complex_double*") double[] DF,
    @Cast("lapack_complex_double*") double[] DUF,
    @Cast("lapack_complex_double*") double[] DU2, int[] ipiv,
    @Cast("const lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    double[] rcond,
    double[] ferr,
    double[] berr,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgtsvx_base(
    String fact, String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer DL,
    @Cast("const lapack_complex_double*") DoublePointer D,
    @Cast("const lapack_complex_double*") DoublePointer DU,
    @Cast("lapack_complex_double*") DoublePointer DLF,
    @Cast("lapack_complex_double*") DoublePointer DF,
    @Cast("lapack_complex_double*") DoublePointer DUF,
    @Cast("lapack_complex_double*") DoublePointer DU2, IntPointer ipiv,
    @Cast("const lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    DoublePointer rcond,
    DoublePointer ferr,
    DoublePointer berr,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgtsvx_base(
    @Cast("const char*") BytePointer fact, @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer DL,
    @Cast("const lapack_complex_double*") DoubleBuffer D,
    @Cast("const lapack_complex_double*") DoubleBuffer DU,
    @Cast("lapack_complex_double*") DoubleBuffer DLF,
    @Cast("lapack_complex_double*") DoubleBuffer DF,
    @Cast("lapack_complex_double*") DoubleBuffer DUF,
    @Cast("lapack_complex_double*") DoubleBuffer DU2, IntBuffer ipiv,
    @Cast("const lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    DoubleBuffer rcond,
    DoubleBuffer ferr,
    DoubleBuffer berr,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zgtsvx_base(
    String fact, String trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] DL,
    @Cast("const lapack_complex_double*") double[] D,
    @Cast("const lapack_complex_double*") double[] DU,
    @Cast("lapack_complex_double*") double[] DLF,
    @Cast("lapack_complex_double*") double[] DF,
    @Cast("lapack_complex_double*") double[] DUF,
    @Cast("lapack_complex_double*") double[] DU2, int[] ipiv,
    @Cast("const lapack_complex_double*") double[] B, @Const int[] ldb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    double[] rcond,
    double[] ferr,
    double[] berr,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgtsvx(...) LAPACK_zgtsvx_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cgttrf(
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer DL,
    @Cast("lapack_complex_float*") FloatPointer D,
    @Cast("lapack_complex_float*") FloatPointer DU,
    @Cast("lapack_complex_float*") FloatPointer DU2, IntPointer ipiv,
    IntPointer info );
public static native void LAPACK_cgttrf(
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer DL,
    @Cast("lapack_complex_float*") FloatBuffer D,
    @Cast("lapack_complex_float*") FloatBuffer DU,
    @Cast("lapack_complex_float*") FloatBuffer DU2, IntBuffer ipiv,
    IntBuffer info );
public static native void LAPACK_cgttrf(
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] DL,
    @Cast("lapack_complex_float*") float[] D,
    @Cast("lapack_complex_float*") float[] DU,
    @Cast("lapack_complex_float*") float[] DU2, int[] ipiv,
    int[] info );

public static native void LAPACK_dgttrf(
    @Const IntPointer n,
    DoublePointer DL,
    DoublePointer D,
    DoublePointer DU,
    DoublePointer DU2, IntPointer ipiv,
    IntPointer info );
public static native void LAPACK_dgttrf(
    @Const IntBuffer n,
    DoubleBuffer DL,
    DoubleBuffer D,
    DoubleBuffer DU,
    DoubleBuffer DU2, IntBuffer ipiv,
    IntBuffer info );
public static native void LAPACK_dgttrf(
    @Const int[] n,
    double[] DL,
    double[] D,
    double[] DU,
    double[] DU2, int[] ipiv,
    int[] info );

public static native void LAPACK_sgttrf(
    @Const IntPointer n,
    FloatPointer DL,
    FloatPointer D,
    FloatPointer DU,
    FloatPointer DU2, IntPointer ipiv,
    IntPointer info );
public static native void LAPACK_sgttrf(
    @Const IntBuffer n,
    FloatBuffer DL,
    FloatBuffer D,
    FloatBuffer DU,
    FloatBuffer DU2, IntBuffer ipiv,
    IntBuffer info );
public static native void LAPACK_sgttrf(
    @Const int[] n,
    float[] DL,
    float[] D,
    float[] DU,
    float[] DU2, int[] ipiv,
    int[] info );

public static native void LAPACK_zgttrf(
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer DL,
    @Cast("lapack_complex_double*") DoublePointer D,
    @Cast("lapack_complex_double*") DoublePointer DU,
    @Cast("lapack_complex_double*") DoublePointer DU2, IntPointer ipiv,
    IntPointer info );
public static native void LAPACK_zgttrf(
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer DL,
    @Cast("lapack_complex_double*") DoubleBuffer D,
    @Cast("lapack_complex_double*") DoubleBuffer DU,
    @Cast("lapack_complex_double*") DoubleBuffer DU2, IntBuffer ipiv,
    IntBuffer info );
public static native void LAPACK_zgttrf(
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] DL,
    @Cast("lapack_complex_double*") double[] D,
    @Cast("lapack_complex_double*") double[] DU,
    @Cast("lapack_complex_double*") double[] DU2, int[] ipiv,
    int[] info );

public static native void LAPACK_cgttrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer DL,
    @Cast("const lapack_complex_float*") FloatPointer D,
    @Cast("const lapack_complex_float*") FloatPointer DU,
    @Cast("const lapack_complex_float*") FloatPointer DU2, @Const IntPointer ipiv,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgttrs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer DL,
    @Cast("const lapack_complex_float*") FloatBuffer D,
    @Cast("const lapack_complex_float*") FloatBuffer DU,
    @Cast("const lapack_complex_float*") FloatBuffer DU2, @Const IntBuffer ipiv,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgttrs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] DL,
    @Cast("const lapack_complex_float*") float[] D,
    @Cast("const lapack_complex_float*") float[] DU,
    @Cast("const lapack_complex_float*") float[] DU2, @Const int[] ipiv,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgttrs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_float*") FloatPointer DL,
    @Cast("const lapack_complex_float*") FloatPointer D,
    @Cast("const lapack_complex_float*") FloatPointer DU,
    @Cast("const lapack_complex_float*") FloatPointer DU2, @Const IntPointer ipiv,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgttrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_float*") FloatBuffer DL,
    @Cast("const lapack_complex_float*") FloatBuffer D,
    @Cast("const lapack_complex_float*") FloatBuffer DU,
    @Cast("const lapack_complex_float*") FloatBuffer DU2, @Const IntBuffer ipiv,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_cgttrs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_float*") float[] DL,
    @Cast("const lapack_complex_float*") float[] D,
    @Cast("const lapack_complex_float*") float[] DU,
    @Cast("const lapack_complex_float*") float[] DU2, @Const int[] ipiv,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cgttrs(...) LAPACK_cgttrs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_dgttrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const DoublePointer DL,
    @Const DoublePointer D,
    @Const DoublePointer DU,
    @Const DoublePointer DU2, @Const IntPointer ipiv,
    DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgttrs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const DoubleBuffer DL,
    @Const DoubleBuffer D,
    @Const DoubleBuffer DU,
    @Const DoubleBuffer DU2, @Const IntBuffer ipiv,
    DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgttrs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Const double[] DL,
    @Const double[] D,
    @Const double[] DU,
    @Const double[] DU2, @Const int[] ipiv,
    double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgttrs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const DoublePointer DL,
    @Const DoublePointer D,
    @Const DoublePointer DU,
    @Const DoublePointer DU2, @Const IntPointer ipiv,
    DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgttrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const DoubleBuffer DL,
    @Const DoubleBuffer D,
    @Const DoubleBuffer DU,
    @Const DoubleBuffer DU2, @Const IntBuffer ipiv,
    DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_dgttrs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Const double[] DL,
    @Const double[] D,
    @Const double[] DU,
    @Const double[] DU2, @Const int[] ipiv,
    double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_dgttrs(...) LAPACK_dgttrs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_sgttrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const FloatPointer DL,
    @Const FloatPointer D,
    @Const FloatPointer DU,
    @Const FloatPointer DU2, @Const IntPointer ipiv,
    FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgttrs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const FloatBuffer DL,
    @Const FloatBuffer D,
    @Const FloatBuffer DU,
    @Const FloatBuffer DU2, @Const IntBuffer ipiv,
    FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgttrs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Const float[] DL,
    @Const float[] D,
    @Const float[] DU,
    @Const float[] DU2, @Const int[] ipiv,
    float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgttrs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Const FloatPointer DL,
    @Const FloatPointer D,
    @Const FloatPointer DU,
    @Const FloatPointer DU2, @Const IntPointer ipiv,
    FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgttrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Const FloatBuffer DL,
    @Const FloatBuffer D,
    @Const FloatBuffer DU,
    @Const FloatBuffer DU2, @Const IntBuffer ipiv,
    FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_sgttrs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Const float[] DL,
    @Const float[] D,
    @Const float[] DU,
    @Const float[] DU2, @Const int[] ipiv,
    float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_sgttrs(...) LAPACK_sgttrs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zgttrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer DL,
    @Cast("const lapack_complex_double*") DoublePointer D,
    @Cast("const lapack_complex_double*") DoublePointer DU,
    @Cast("const lapack_complex_double*") DoublePointer DU2, @Const IntPointer ipiv,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgttrs_base(
    String trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer DL,
    @Cast("const lapack_complex_double*") DoubleBuffer D,
    @Cast("const lapack_complex_double*") DoubleBuffer DU,
    @Cast("const lapack_complex_double*") DoubleBuffer DU2, @Const IntBuffer ipiv,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgttrs_base(
    @Cast("const char*") BytePointer trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] DL,
    @Cast("const lapack_complex_double*") double[] D,
    @Cast("const lapack_complex_double*") double[] DU,
    @Cast("const lapack_complex_double*") double[] DU2, @Const int[] ipiv,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgttrs_base(
    String trans,
    @Const IntPointer n, @Const IntPointer nrhs,
    @Cast("const lapack_complex_double*") DoublePointer DL,
    @Cast("const lapack_complex_double*") DoublePointer D,
    @Cast("const lapack_complex_double*") DoublePointer DU,
    @Cast("const lapack_complex_double*") DoublePointer DU2, @Const IntPointer ipiv,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgttrs_base(
    @Cast("const char*") BytePointer trans,
    @Const IntBuffer n, @Const IntBuffer nrhs,
    @Cast("const lapack_complex_double*") DoubleBuffer DL,
    @Cast("const lapack_complex_double*") DoubleBuffer D,
    @Cast("const lapack_complex_double*") DoubleBuffer DU,
    @Cast("const lapack_complex_double*") DoubleBuffer DU2, @Const IntBuffer ipiv,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg11
);
public static native void LAPACK_zgttrs_base(
    String trans,
    @Const int[] n, @Const int[] nrhs,
    @Cast("const lapack_complex_double*") double[] DL,
    @Cast("const lapack_complex_double*") double[] D,
    @Cast("const lapack_complex_double*") double[] DU,
    @Cast("const lapack_complex_double*") double[] DU2, @Const int[] ipiv,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zgttrs(...) LAPACK_zgttrs_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_chbev_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_chbev_base(
    String jobz, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_chbev_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_chbev_base(
    String jobz, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_chbev_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_chbev_base(
    String jobz, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chbev(...) LAPACK_chbev_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zhbev_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_zhbev_base(
    String jobz, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_zhbev_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_zhbev_base(
    String jobz, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_zhbev_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_zhbev_base(
    String jobz, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhbev(...) LAPACK_zhbev_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_chbev_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chbev_2stage_base(
    String jobz, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chbev_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chbev_2stage_base(
    String jobz, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chbev_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chbev_2stage_base(
    String jobz, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chbev_2stage(...) LAPACK_chbev_2stage_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zhbev_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhbev_2stage_base(
    String jobz, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhbev_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhbev_2stage_base(
    String jobz, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhbev_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhbev_2stage_base(
    String jobz, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhbev_2stage(...) LAPACK_zhbev_2stage_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_chbevd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chbevd_base(
    String jobz, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chbevd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chbevd_base(
    String jobz, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chbevd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chbevd_base(
    String jobz, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chbevd(...) LAPACK_chbevd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zhbevd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zhbevd_base(
    String jobz, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zhbevd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zhbevd_base(
    String jobz, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zhbevd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zhbevd_base(
    String jobz, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhbevd(...) LAPACK_zhbevd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_chbevd_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chbevd_2stage_base(
    String jobz, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chbevd_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chbevd_2stage_base(
    String jobz, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chbevd_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chbevd_2stage_base(
    String jobz, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chbevd_2stage(...) LAPACK_chbevd_2stage_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zhbevd_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zhbevd_2stage_base(
    String jobz, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zhbevd_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zhbevd_2stage_base(
    String jobz, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zhbevd_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zhbevd_2stage_base(
    String jobz, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhbevd_2stage(...) LAPACK_zhbevd_2stage_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_chbevx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_chbevx_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_chbevx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_chbevx_base(
    String jobz, String range, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_chbevx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_chbevx_base(
    String jobz, String range, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chbevx(...) LAPACK_chbevx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zhbevx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zhbevx_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zhbevx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zhbevx_base(
    String jobz, String range, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zhbevx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zhbevx_base(
    String jobz, String range, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhbevx(...) LAPACK_zhbevx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_chbevx_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_chbevx_2stage_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_chbevx_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_chbevx_2stage_base(
    String jobz, String range, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_chbevx_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_chbevx_2stage_base(
    String jobz, String range, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chbevx_2stage(...) LAPACK_chbevx_2stage_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zhbevx_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zhbevx_2stage_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zhbevx_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zhbevx_2stage_base(
    String jobz, String range, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zhbevx_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
public static native void LAPACK_zhbevx_2stage_base(
    String jobz, String range, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg24, @Cast("size_t") long arg25, @Cast("size_t") long arg26
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhbevx_2stage(...) LAPACK_zhbevx_2stage_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_chbgst_base(
    @Cast("const char*") BytePointer vect, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("const lapack_complex_float*") FloatPointer BB, @Const IntPointer ldbb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_chbgst_base(
    String vect, String uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("const lapack_complex_float*") FloatBuffer BB, @Const IntBuffer ldbb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_chbgst_base(
    @Cast("const char*") BytePointer vect, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("const lapack_complex_float*") float[] BB, @Const int[] ldbb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_chbgst_base(
    String vect, String uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("const lapack_complex_float*") FloatPointer BB, @Const IntPointer ldbb,
    @Cast("lapack_complex_float*") FloatPointer X, @Const IntPointer ldx,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_chbgst_base(
    @Cast("const char*") BytePointer vect, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("const lapack_complex_float*") FloatBuffer BB, @Const IntBuffer ldbb,
    @Cast("lapack_complex_float*") FloatBuffer X, @Const IntBuffer ldx,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_chbgst_base(
    String vect, String uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("const lapack_complex_float*") float[] BB, @Const int[] ldbb,
    @Cast("lapack_complex_float*") float[] X, @Const int[] ldx,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chbgst(...) LAPACK_chbgst_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zhbgst_base(
    @Cast("const char*") BytePointer vect, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("const lapack_complex_double*") DoublePointer BB, @Const IntPointer ldbb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zhbgst_base(
    String vect, String uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("const lapack_complex_double*") DoubleBuffer BB, @Const IntBuffer ldbb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zhbgst_base(
    @Cast("const char*") BytePointer vect, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("const lapack_complex_double*") double[] BB, @Const int[] ldbb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zhbgst_base(
    String vect, String uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("const lapack_complex_double*") DoublePointer BB, @Const IntPointer ldbb,
    @Cast("lapack_complex_double*") DoublePointer X, @Const IntPointer ldx,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zhbgst_base(
    @Cast("const char*") BytePointer vect, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("const lapack_complex_double*") DoubleBuffer BB, @Const IntBuffer ldbb,
    @Cast("lapack_complex_double*") DoubleBuffer X, @Const IntBuffer ldx,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
public static native void LAPACK_zhbgst_base(
    String vect, String uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("const lapack_complex_double*") double[] BB, @Const int[] ldbb,
    @Cast("lapack_complex_double*") double[] X, @Const int[] ldx,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg14, @Cast("size_t") long arg15
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhbgst(...) LAPACK_zhbgst_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_chbgv_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_float*") FloatPointer BB, @Const IntPointer ldbb,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_chbgv_base(
    String jobz, String uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_float*") FloatBuffer BB, @Const IntBuffer ldbb,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_chbgv_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("lapack_complex_float*") float[] BB, @Const int[] ldbb,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_chbgv_base(
    String jobz, String uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_float*") FloatPointer BB, @Const IntPointer ldbb,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_chbgv_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_float*") FloatBuffer BB, @Const IntBuffer ldbb,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_chbgv_base(
    String jobz, String uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("lapack_complex_float*") float[] BB, @Const int[] ldbb,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chbgv(...) LAPACK_chbgv_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zhbgv_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_double*") DoublePointer BB, @Const IntPointer ldbb,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zhbgv_base(
    String jobz, String uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_double*") DoubleBuffer BB, @Const IntBuffer ldbb,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zhbgv_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("lapack_complex_double*") double[] BB, @Const int[] ldbb,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zhbgv_base(
    String jobz, String uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_double*") DoublePointer BB, @Const IntPointer ldbb,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zhbgv_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_double*") DoubleBuffer BB, @Const IntBuffer ldbb,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
public static native void LAPACK_zhbgv_base(
    String jobz, String uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("lapack_complex_double*") double[] BB, @Const int[] ldbb,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] info, @Cast("size_t") long arg15, @Cast("size_t") long arg16
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhbgv(...) LAPACK_zhbgv_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_chbgvd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_float*") FloatPointer BB, @Const IntPointer ldbb,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_chbgvd_base(
    String jobz, String uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_float*") FloatBuffer BB, @Const IntBuffer ldbb,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_chbgvd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("lapack_complex_float*") float[] BB, @Const int[] ldbb,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_chbgvd_base(
    String jobz, String uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_float*") FloatPointer BB, @Const IntPointer ldbb,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_chbgvd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_float*") FloatBuffer BB, @Const IntBuffer ldbb,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_chbgvd_base(
    String jobz, String uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("lapack_complex_float*") float[] BB, @Const int[] ldbb,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chbgvd(...) LAPACK_chbgvd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zhbgvd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_double*") DoublePointer BB, @Const IntPointer ldbb,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_zhbgvd_base(
    String jobz, String uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_double*") DoubleBuffer BB, @Const IntBuffer ldbb,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_zhbgvd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("lapack_complex_double*") double[] BB, @Const int[] ldbb,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_zhbgvd_base(
    String jobz, String uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_double*") DoublePointer BB, @Const IntPointer ldbb,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_zhbgvd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_double*") DoubleBuffer BB, @Const IntBuffer ldbb,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
public static native void LAPACK_zhbgvd_base(
    String jobz, String uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("lapack_complex_double*") double[] BB, @Const int[] ldbb,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg19, @Cast("size_t") long arg20
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhbgvd(...) LAPACK_zhbgvd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_chbgvx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_float*") FloatPointer BB, @Const IntPointer ldbb,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_chbgvx_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_float*") FloatBuffer BB, @Const IntBuffer ldbb,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_chbgvx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("lapack_complex_float*") float[] BB, @Const int[] ldbb,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_chbgvx_base(
    String jobz, String range, String uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_float*") FloatPointer BB, @Const IntPointer ldbb,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work,
    FloatPointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_chbgvx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_float*") FloatBuffer BB, @Const IntBuffer ldbb,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work,
    FloatBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_chbgvx_base(
    String jobz, String range, String uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    @Cast("lapack_complex_float*") float[] BB, @Const int[] ldbb,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work,
    float[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chbgvx(...) LAPACK_chbgvx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zhbgvx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_double*") DoublePointer BB, @Const IntPointer ldbb,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_zhbgvx_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_double*") DoubleBuffer BB, @Const IntBuffer ldbb,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_zhbgvx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("lapack_complex_double*") double[] BB, @Const int[] ldbb,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_zhbgvx_base(
    String jobz, String range, String uplo,
    @Const IntPointer n, @Const IntPointer ka, @Const IntPointer kb,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    @Cast("lapack_complex_double*") DoublePointer BB, @Const IntPointer ldbb,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work,
    DoublePointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_zhbgvx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer ka, @Const IntBuffer kb,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    @Cast("lapack_complex_double*") DoubleBuffer BB, @Const IntBuffer ldbb,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    DoubleBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
public static native void LAPACK_zhbgvx_base(
    String jobz, String range, String uplo,
    @Const int[] n, @Const int[] ka, @Const int[] kb,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    @Cast("lapack_complex_double*") double[] BB, @Const int[] ldbb,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work,
    double[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg26, @Cast("size_t") long arg27, @Cast("size_t") long arg28
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhbgvx(...) LAPACK_zhbgvx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_chbtrd_base(
    @Cast("const char*") BytePointer vect, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer D,
    FloatPointer E,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_chbtrd_base(
    String vect, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer D,
    FloatBuffer E,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_chbtrd_base(
    @Cast("const char*") BytePointer vect, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] D,
    float[] E,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Cast("lapack_complex_float*") float[] work,
    int[] info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_chbtrd_base(
    String vect, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_float*") FloatPointer AB, @Const IntPointer ldab,
    FloatPointer D,
    FloatPointer E,
    @Cast("lapack_complex_float*") FloatPointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_chbtrd_base(
    @Cast("const char*") BytePointer vect, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_float*") FloatBuffer AB, @Const IntBuffer ldab,
    FloatBuffer D,
    FloatBuffer E,
    @Cast("lapack_complex_float*") FloatBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_chbtrd_base(
    String vect, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_float*") float[] AB, @Const int[] ldab,
    float[] D,
    float[] E,
    @Cast("lapack_complex_float*") float[] Q, @Const int[] ldq,
    @Cast("lapack_complex_float*") float[] work,
    int[] info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chbtrd(...) LAPACK_chbtrd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zhbtrd_base(
    @Cast("const char*") BytePointer vect, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer D,
    DoublePointer E,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_zhbtrd_base(
    String vect, String uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer D,
    DoubleBuffer E,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_zhbtrd_base(
    @Cast("const char*") BytePointer vect, @Cast("const char*") BytePointer uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] D,
    double[] E,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Cast("lapack_complex_double*") double[] work,
    int[] info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_zhbtrd_base(
    String vect, String uplo,
    @Const IntPointer n, @Const IntPointer kd,
    @Cast("lapack_complex_double*") DoublePointer AB, @Const IntPointer ldab,
    DoublePointer D,
    DoublePointer E,
    @Cast("lapack_complex_double*") DoublePointer Q, @Const IntPointer ldq,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_zhbtrd_base(
    @Cast("const char*") BytePointer vect, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n, @Const IntBuffer kd,
    @Cast("lapack_complex_double*") DoubleBuffer AB, @Const IntBuffer ldab,
    DoubleBuffer D,
    DoubleBuffer E,
    @Cast("lapack_complex_double*") DoubleBuffer Q, @Const IntBuffer ldq,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
public static native void LAPACK_zhbtrd_base(
    String vect, String uplo,
    @Const int[] n, @Const int[] kd,
    @Cast("lapack_complex_double*") double[] AB, @Const int[] ldab,
    double[] D,
    double[] E,
    @Cast("lapack_complex_double*") double[] Q, @Const int[] ldq,
    @Cast("lapack_complex_double*") double[] work,
    int[] info, @Cast("size_t") long arg12, @Cast("size_t") long arg13
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhbtrd(...) LAPACK_zhbtrd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_checon_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_checon_base(
    String uplo,
    @Const IntBuffer n,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_checon_base(
    @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda, @Const int[] ipiv,
    @Const float[] anorm,
    float[] rcond,
    @Cast("lapack_complex_float*") float[] work,
    int[] info, @Cast("size_t") long arg9
);
public static native void LAPACK_checon_base(
    String uplo,
    @Const IntPointer n,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_checon_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_checon_base(
    String uplo,
    @Const int[] n,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda, @Const int[] ipiv,
    @Const float[] anorm,
    float[] rcond,
    @Cast("lapack_complex_float*") float[] work,
    int[] info, @Cast("size_t") long arg9
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_checon(...) LAPACK_checon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zhecon_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_zhecon_base(
    String uplo,
    @Const IntBuffer n,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_zhecon_base(
    @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda, @Const int[] ipiv,
    @Const double[] anorm,
    double[] rcond,
    @Cast("lapack_complex_double*") double[] work,
    int[] info, @Cast("size_t") long arg9
);
public static native void LAPACK_zhecon_base(
    String uplo,
    @Const IntPointer n,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda, @Const IntPointer ipiv,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_zhecon_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda, @Const IntBuffer ipiv,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_zhecon_base(
    String uplo,
    @Const int[] n,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda, @Const int[] ipiv,
    @Const double[] anorm,
    double[] rcond,
    @Cast("lapack_complex_double*") double[] work,
    int[] info, @Cast("size_t") long arg9
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhecon(...) LAPACK_zhecon_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_checon_3_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_float*") FloatPointer E, @Const IntPointer ipiv,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info, @Cast("size_t") long arg10
);
public static native void LAPACK_checon_3_base(
    String uplo,
    @Const IntBuffer n,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_float*") FloatBuffer E, @Const IntBuffer ipiv,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg10
);
public static native void LAPACK_checon_3_base(
    @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("const lapack_complex_float*") float[] E, @Const int[] ipiv,
    @Const float[] anorm,
    float[] rcond,
    @Cast("lapack_complex_float*") float[] work,
    int[] info, @Cast("size_t") long arg10
);
public static native void LAPACK_checon_3_base(
    String uplo,
    @Const IntPointer n,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_float*") FloatPointer E, @Const IntPointer ipiv,
    @Const FloatPointer anorm,
    FloatPointer rcond,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info, @Cast("size_t") long arg10
);
public static native void LAPACK_checon_3_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_float*") FloatBuffer E, @Const IntBuffer ipiv,
    @Const FloatBuffer anorm,
    FloatBuffer rcond,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg10
);
public static native void LAPACK_checon_3_base(
    String uplo,
    @Const int[] n,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("const lapack_complex_float*") float[] E, @Const int[] ipiv,
    @Const float[] anorm,
    float[] rcond,
    @Cast("lapack_complex_float*") float[] work,
    int[] info, @Cast("size_t") long arg10
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_checon_3(...) LAPACK_checon_3_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zhecon_3_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_double*") DoublePointer E, @Const IntPointer ipiv,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info, @Cast("size_t") long arg10
);
public static native void LAPACK_zhecon_3_base(
    String uplo,
    @Const IntBuffer n,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_double*") DoubleBuffer E, @Const IntBuffer ipiv,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg10
);
public static native void LAPACK_zhecon_3_base(
    @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("const lapack_complex_double*") double[] E, @Const int[] ipiv,
    @Const double[] anorm,
    double[] rcond,
    @Cast("lapack_complex_double*") double[] work,
    int[] info, @Cast("size_t") long arg10
);
public static native void LAPACK_zhecon_3_base(
    String uplo,
    @Const IntPointer n,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_double*") DoublePointer E, @Const IntPointer ipiv,
    @Const DoublePointer anorm,
    DoublePointer rcond,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info, @Cast("size_t") long arg10
);
public static native void LAPACK_zhecon_3_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_double*") DoubleBuffer E, @Const IntBuffer ipiv,
    @Const DoubleBuffer anorm,
    DoubleBuffer rcond,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg10
);
public static native void LAPACK_zhecon_3_base(
    String uplo,
    @Const int[] n,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("const lapack_complex_double*") double[] E, @Const int[] ipiv,
    @Const double[] anorm,
    double[] rcond,
    @Cast("lapack_complex_double*") double[] work,
    int[] info, @Cast("size_t") long arg10
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhecon_3(...) LAPACK_zhecon_3_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_cheequb_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer S,
    FloatPointer scond,
    FloatPointer amax,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_cheequb_base(
    String uplo,
    @Const IntBuffer n,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer S,
    FloatBuffer scond,
    FloatBuffer amax,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_cheequb_base(
    @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    float[] S,
    float[] scond,
    float[] amax,
    @Cast("lapack_complex_float*") float[] work,
    int[] info, @Cast("size_t") long arg9
);
public static native void LAPACK_cheequb_base(
    String uplo,
    @Const IntPointer n,
    @Cast("const lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer S,
    FloatPointer scond,
    FloatPointer amax,
    @Cast("lapack_complex_float*") FloatPointer work,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_cheequb_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("const lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer S,
    FloatBuffer scond,
    FloatBuffer amax,
    @Cast("lapack_complex_float*") FloatBuffer work,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_cheequb_base(
    String uplo,
    @Const int[] n,
    @Cast("const lapack_complex_float*") float[] A, @Const int[] lda,
    float[] S,
    float[] scond,
    float[] amax,
    @Cast("lapack_complex_float*") float[] work,
    int[] info, @Cast("size_t") long arg9
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cheequb(...) LAPACK_cheequb_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zheequb_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer S,
    DoublePointer scond,
    DoublePointer amax,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_zheequb_base(
    String uplo,
    @Const IntBuffer n,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer S,
    DoubleBuffer scond,
    DoubleBuffer amax,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_zheequb_base(
    @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    double[] S,
    double[] scond,
    double[] amax,
    @Cast("lapack_complex_double*") double[] work,
    int[] info, @Cast("size_t") long arg9
);
public static native void LAPACK_zheequb_base(
    String uplo,
    @Const IntPointer n,
    @Cast("const lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer S,
    DoublePointer scond,
    DoublePointer amax,
    @Cast("lapack_complex_double*") DoublePointer work,
    IntPointer info, @Cast("size_t") long arg9
);
public static native void LAPACK_zheequb_base(
    @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("const lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer S,
    DoubleBuffer scond,
    DoubleBuffer amax,
    @Cast("lapack_complex_double*") DoubleBuffer work,
    IntBuffer info, @Cast("size_t") long arg9
);
public static native void LAPACK_zheequb_base(
    String uplo,
    @Const int[] n,
    @Cast("const lapack_complex_double*") double[] A, @Const int[] lda,
    double[] S,
    double[] scond,
    double[] amax,
    @Cast("lapack_complex_double*") double[] work,
    int[] info, @Cast("size_t") long arg9
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zheequb(...) LAPACK_zheequb_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_cheev_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cheev_base(
    String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cheev_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cheev_base(
    String jobz, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cheev_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cheev_base(
    String jobz, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cheev(...) LAPACK_cheev_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zheev_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zheev_base(
    String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zheev_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] W,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zheev_base(
    String jobz, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zheev_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zheev_base(
    String jobz, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] W,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zheev(...) LAPACK_zheev_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cheev_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cheev_2stage_base(
    String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cheev_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cheev_2stage_base(
    String jobz, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cheev_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_cheev_2stage_base(
    String jobz, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cheev_2stage(...) LAPACK_cheev_2stage_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zheev_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zheev_2stage_base(
    String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zheev_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] W,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zheev_2stage_base(
    String jobz, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zheev_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
public static native void LAPACK_zheev_2stage_base(
    String jobz, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] W,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg10, @Cast("size_t") long arg11
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zheev_2stage(...) LAPACK_zheev_2stage_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cheevd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_cheevd_base(
    String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_cheevd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_cheevd_base(
    String jobz, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_cheevd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_cheevd_base(
    String jobz, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cheevd(...) LAPACK_cheevd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zheevd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zheevd_base(
    String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zheevd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] W,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zheevd_base(
    String jobz, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zheevd_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zheevd_base(
    String jobz, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] W,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zheevd(...) LAPACK_zheevd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cheevd_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_cheevd_2stage_base(
    String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_cheevd_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_cheevd_2stage_base(
    String jobz, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_cheevd_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_cheevd_2stage_base(
    String jobz, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cheevd_2stage(...) LAPACK_cheevd_2stage_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zheevd_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zheevd_2stage_base(
    String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zheevd_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] W,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zheevd_2stage_base(
    String jobz, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zheevd_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zheevd_2stage_base(
    String jobz, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    double[] W,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zheevd_2stage(...) LAPACK_zheevd_2stage_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_cheevr_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz, IntPointer ISUPPZ,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cheevr_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz, IntBuffer ISUPPZ,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cheevr_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz, int[] ISUPPZ,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cheevr_base(
    String jobz, String range, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz, IntPointer ISUPPZ,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cheevr_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz, IntBuffer ISUPPZ,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cheevr_base(
    String jobz, String range, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz, int[] ISUPPZ,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cheevr(...) LAPACK_cheevr_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zheevr_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz, IntPointer ISUPPZ,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zheevr_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz, IntBuffer ISUPPZ,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zheevr_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz, int[] ISUPPZ,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zheevr_base(
    String jobz, String range, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz, IntPointer ISUPPZ,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zheevr_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz, IntBuffer ISUPPZ,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zheevr_base(
    String jobz, String range, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz, int[] ISUPPZ,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zheevr(...) LAPACK_zheevr_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cheevr_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz, IntPointer ISUPPZ,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cheevr_2stage_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz, IntBuffer ISUPPZ,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cheevr_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz, int[] ISUPPZ,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cheevr_2stage_base(
    String jobz, String range, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz, IntPointer ISUPPZ,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cheevr_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz, IntBuffer ISUPPZ,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_cheevr_2stage_base(
    String jobz, String range, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz, int[] ISUPPZ,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cheevr_2stage(...) LAPACK_cheevr_2stage_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zheevr_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz, IntPointer ISUPPZ,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zheevr_2stage_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz, IntBuffer ISUPPZ,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zheevr_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz, int[] ISUPPZ,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zheevr_2stage_base(
    String jobz, String range, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz, IntPointer ISUPPZ,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zheevr_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz, IntBuffer ISUPPZ,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
public static native void LAPACK_zheevr_2stage_base(
    String jobz, String range, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz, int[] ISUPPZ,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg23, @Cast("size_t") long arg24, @Cast("size_t") long arg25
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zheevr_2stage(...) LAPACK_zheevr_2stage_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cheevx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cheevx_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cheevx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cheevx_base(
    String jobz, String range, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cheevx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cheevx_base(
    String jobz, String range, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cheevx(...) LAPACK_cheevx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zheevx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zheevx_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zheevx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zheevx_base(
    String jobz, String range, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zheevx_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zheevx_base(
    String jobz, String range, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zheevx(...) LAPACK_zheevx_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_cheevx_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cheevx_2stage_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cheevx_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cheevx_2stage_base(
    String jobz, String range, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Const FloatPointer vl,
    @Const FloatPointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const FloatPointer abstol, IntPointer m,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cheevx_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Const FloatBuffer vl,
    @Const FloatBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const FloatBuffer abstol, IntBuffer m,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_cheevx_2stage_base(
    String jobz, String range, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Const float[] vl,
    @Const float[] vu, @Const int[] il, @Const int[] iu,
    @Const float[] abstol, int[] m,
    float[] W,
    @Cast("lapack_complex_float*") float[] Z, @Const int[] ldz,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_cheevx_2stage(...) LAPACK_cheevx_2stage_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_zheevx_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zheevx_2stage_base(
    String jobz, String range, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zheevx_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zheevx_2stage_base(
    String jobz, String range, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Const DoublePointer vl,
    @Const DoublePointer vu, @Const IntPointer il, @Const IntPointer iu,
    @Const DoublePointer abstol, IntPointer m,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer Z, @Const IntPointer ldz,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer iwork, IntPointer IFAIL,
    IntPointer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zheevx_2stage_base(
    @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer range, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Const DoubleBuffer vl,
    @Const DoubleBuffer vu, @Const IntBuffer il, @Const IntBuffer iu,
    @Const DoubleBuffer abstol, IntBuffer m,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer Z, @Const IntBuffer ldz,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer iwork, IntBuffer IFAIL,
    IntBuffer info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
public static native void LAPACK_zheevx_2stage_base(
    String jobz, String range, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Const double[] vl,
    @Const double[] vu, @Const int[] il, @Const int[] iu,
    @Const double[] abstol, int[] m,
    double[] W,
    @Cast("lapack_complex_double*") double[] Z, @Const int[] ldz,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] iwork, int[] IFAIL,
    int[] info, @Cast("size_t") long arg21, @Cast("size_t") long arg22, @Cast("size_t") long arg23
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zheevx_2stage(...) LAPACK_zheevx_2stage_base(__VA_ARGS__, 1, 1, 1)
// #else
// #endif

public static native void LAPACK_chegst_base(
    @Const IntPointer itype, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg8
);
public static native void LAPACK_chegst_base(
    @Const IntBuffer itype, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg8
);
public static native void LAPACK_chegst_base(
    @Const int[] itype, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("const lapack_complex_float*") float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg8
);
public static native void LAPACK_chegst_base(
    @Const IntPointer itype, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg8
);
public static native void LAPACK_chegst_base(
    @Const IntBuffer itype, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg8
);
public static native void LAPACK_chegst_base(
    @Const int[] itype, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("const lapack_complex_float*") float[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg8
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chegst(...) LAPACK_chegst_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_zhegst_base(
    @Const IntPointer itype, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg8
);
public static native void LAPACK_zhegst_base(
    @Const IntBuffer itype, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg8
);
public static native void LAPACK_zhegst_base(
    @Const int[] itype, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("const lapack_complex_double*") double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg8
);
public static native void LAPACK_zhegst_base(
    @Const IntPointer itype, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("const lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    IntPointer info, @Cast("size_t") long arg8
);
public static native void LAPACK_zhegst_base(
    @Const IntBuffer itype, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("const lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    IntBuffer info, @Cast("size_t") long arg8
);
public static native void LAPACK_zhegst_base(
    @Const int[] itype, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("const lapack_complex_double*") double[] B, @Const int[] ldb,
    int[] info, @Cast("size_t") long arg8
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhegst(...) LAPACK_zhegst_base(__VA_ARGS__, 1)
// #else
// #endif

public static native void LAPACK_chegv_base(
    @Const IntPointer itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chegv_base(
    @Const IntBuffer itype, String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chegv_base(
    @Const int[] itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chegv_base(
    @Const IntPointer itype, String jobz, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chegv_base(
    @Const IntBuffer itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chegv_base(
    @Const int[] itype, String jobz, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chegv(...) LAPACK_chegv_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zhegv_base(
    @Const IntPointer itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhegv_base(
    @Const IntBuffer itype, String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhegv_base(
    @Const int[] itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    double[] W,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhegv_base(
    @Const IntPointer itype, String jobz, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhegv_base(
    @Const IntBuffer itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhegv_base(
    @Const int[] itype, String jobz, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    double[] W,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhegv(...) LAPACK_zhegv_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_chegv_2stage_base(
    @Const IntPointer itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chegv_2stage_base(
    @Const IntBuffer itype, String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chegv_2stage_base(
    @Const int[] itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chegv_2stage_base(
    @Const IntPointer itype, String jobz, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chegv_2stage_base(
    @Const IntBuffer itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_chegv_2stage_base(
    @Const int[] itype, String jobz, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chegv_2stage(...) LAPACK_chegv_2stage_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zhegv_2stage_base(
    @Const IntPointer itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhegv_2stage_base(
    @Const IntBuffer itype, String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhegv_2stage_base(
    @Const int[] itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    double[] W,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhegv_2stage_base(
    @Const IntPointer itype, String jobz, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork,
    IntPointer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhegv_2stage_base(
    @Const IntBuffer itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork,
    IntBuffer info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
public static native void LAPACK_zhegv_2stage_base(
    @Const int[] itype, String jobz, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    double[] W,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork,
    int[] info, @Cast("size_t") long arg13, @Cast("size_t") long arg14
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_zhegv_2stage(...) LAPACK_zhegv_2stage_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_chegvd_base(
    @Const IntPointer itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chegvd_base(
    @Const IntBuffer itype, String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chegvd_base(
    @Const int[] itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chegvd_base(
    @Const IntPointer itype, String jobz, String uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_float*") FloatPointer A, @Const IntPointer lda,
    @Cast("lapack_complex_float*") FloatPointer B, @Const IntPointer ldb,
    FloatPointer W,
    @Cast("lapack_complex_float*") FloatPointer work, @Const IntPointer lwork,
    FloatPointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chegvd_base(
    @Const IntBuffer itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_float*") FloatBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_float*") FloatBuffer B, @Const IntBuffer ldb,
    FloatBuffer W,
    @Cast("lapack_complex_float*") FloatBuffer work, @Const IntBuffer lwork,
    FloatBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_chegvd_base(
    @Const int[] itype, String jobz, String uplo,
    @Const int[] n,
    @Cast("lapack_complex_float*") float[] A, @Const int[] lda,
    @Cast("lapack_complex_float*") float[] B, @Const int[] ldb,
    float[] W,
    @Cast("lapack_complex_float*") float[] work, @Const int[] lwork,
    float[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
// #ifdef LAPACK_FORTRAN_STRLEN_END
//     #define LAPACK_chegvd(...) LAPACK_chegvd_base(__VA_ARGS__, 1, 1)
// #else
// #endif

public static native void LAPACK_zhegvd_base(
    @Const IntPointer itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const IntPointer n,
    @Cast("lapack_complex_double*") DoublePointer A, @Const IntPointer lda,
    @Cast("lapack_complex_double*") DoublePointer B, @Const IntPointer ldb,
    DoublePointer W,
    @Cast("lapack_complex_double*") DoublePointer work, @Const IntPointer lwork,
    DoublePointer rwork, @Const IntPointer lrwork,
    IntPointer iwork, @Const IntPointer liwork,
    IntPointer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zhegvd_base(
    @Const IntBuffer itype, String jobz, String uplo,
    @Const IntBuffer n,
    @Cast("lapack_complex_double*") DoubleBuffer A, @Const IntBuffer lda,
    @Cast("lapack_complex_double*") DoubleBuffer B, @Const IntBuffer ldb,
    DoubleBuffer W,
    @Cast("lapack_complex_double*") DoubleBuffer work, @Const IntBuffer lwork,
    DoubleBuffer rwork, @Const IntBuffer lrwork,
    IntBuffer iwork, @Const IntBuffer liwork,
    IntBuffer info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native void LAPACK_zhegvd_base(
    @Const int[] itype, @Cast("const char*") BytePointer jobz, @Cast("const char*") BytePointer uplo,
    @Const int[] n,
    @Cast("lapack_complex_double*") double[] A, @Const int[] lda,
    @Cast("lapack_complex_double*") double[] B, @Const int[] ldb,
    double[] W,
    @Cast("lapack_complex_double*") double[] work, @Const int[] lwork,
    double[] rwork, @Const int[] lrwork,
    int[] iwork, @Const int[] liwork,
    int[] info, @Cast("size_t") long arg16, @Cast("size_t") long arg17
);
public static native vo