// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.openblas.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class openblas_nolapack extends org.bytedeco.openblas.presets.openblas_nolapack {
    static { Loader.load(); }

// Parsed from openblas_config.h

// #ifndef OPENBLAS_CONFIG_H
// #define OPENBLAS_CONFIG_H
public static final int OPENBLAS_OS_WINNT = 1;
public static final int OPENBLAS_ARCH_X86_64 = 1;
public static final int OPENBLAS_C_GCC = 1;
public static final int OPENBLAS___64BIT__ = 1;
public static final int OPENBLAS_HAVE_C11 = 1;
// #define OPENBLAS_PTHREAD_CREATE_FUNC pthread_create
// #define OPENBLAS_BUNDERSCORE _
public static final int OPENBLAS_NEEDBUNDERSCORE = 1;
// #define OPENBLAS_NEHALEM 
public static final int OPENBLAS_L1_DATA_SIZE = 32768;
public static final int OPENBLAS_L1_DATA_LINESIZE = 64;
public static final int OPENBLAS_L2_SIZE = 262144;
public static final int OPENBLAS_L2_LINESIZE = 64;
public static final int OPENBLAS_DTB_DEFAULT_ENTRIES = 64;
public static final int OPENBLAS_DTB_SIZE = 4096;
// #define OPENBLAS_HAVE_CMOV 
// #define OPENBLAS_HAVE_MMX 
// #define OPENBLAS_HAVE_SSE 
// #define OPENBLAS_HAVE_SSE2 
// #define OPENBLAS_HAVE_SSE3 
// #define OPENBLAS_HAVE_SSSE3 
// #define OPENBLAS_HAVE_SSE4_1 
// #define OPENBLAS_HAVE_SSE4_2 
// #define OPENBLAS_CORE_NEHALEM 
public static final String OPENBLAS_CHAR_CORENAME = "NEHALEM";
public static final int OPENBLAS_SLOCAL_BUFFER_SIZE = 65536;
public static final int OPENBLAS_DLOCAL_BUFFER_SIZE = 32768;
public static final int OPENBLAS_CLOCAL_BUFFER_SIZE = 65536;
public static final int OPENBLAS_ZLOCAL_BUFFER_SIZE = 32768;
public static final int OPENBLAS_GEMM_MULTITHREAD_THRESHOLD = 4;
public static final String OPENBLAS_VERSION = " OpenBLAS 0.3.28 ";
/*This is only for "make install" target.*/

// #if defined(OPENBLAS_OS_WINNT) || defined(OPENBLAS_OS_CYGWIN_NT) || defined(OPENBLAS_OS_INTERIX)
// #define OPENBLAS_WINDOWS_ABI
// #define OPENBLAS_OS_WINDOWS

// #ifdef DOUBLE
// #define DOUBLE_DEFINED DOUBLE
// #undef  DOUBLE
// #endif
// #endif

// #ifdef OPENBLAS_NEEDBUNDERSCORE
// #define BLASFUNC(FUNC) FUNC##_
// #else
// #endif

// #ifdef OPENBLAS_QUAD_PRECISION
// #elif defined OPENBLAS_EXPRECISION
// #else
// #define xdouble double
// #endif

// #if defined(OPENBLAS_OS_WINDOWS) && defined(OPENBLAS___64BIT__)
// #else
// #endif

// #ifndef BFLOAT16
// #include <stdint.h>
// #endif

// #ifdef OPENBLAS_USE64BITINT
// #else
// #endif

// #if defined(XDOUBLE) || defined(DOUBLE)
// #define FLOATRET	FLOAT
// #else
// #ifdef NEED_F2CCONV
// #define FLOATRET	double
// #else
// #define FLOATRET	float
// #endif
// #endif

/* Inclusion of a standard header file is needed for definition of __STDC_*
   predefined macros with some compilers (e.g. GCC 4.7 on Linux).  This occurs
   as a side effect of including either <features.h> or <stdc-predef.h>. */
// #include <stdio.h>

/* C99 supports complex floating numbers natively, which GCC also offers as an
   extension since version 3.0.  If neither are available, use a compatible
   structure as fallback (see Clause 6.2.5.13 of the C99 standard). */
// #if ((defined(__STDC_IEC_559_COMPLEX__) || __STDC_VERSION__ >= 199901L ||
//       (__GNUC__ >= 3 && !defined(__cplusplus))) && !(defined(FORCE_OPENBLAS_COMPLEX_STRUCT))) && !defined(_MSC_VER)
//   #define OPENBLAS_COMPLEX_C99
// #ifndef __cplusplus
//   #include <complex.h>
// #endif
//   #define openblas_make_complex_float(real, imag)    ((real) + ((imag) * _Complex_I))
//   #define openblas_make_complex_double(real, imag)   ((real) + ((imag) * _Complex_I))
//   #define openblas_make_complex_xdouble(real, imag)  ((real) + ((imag) * _Complex_I))
//   #define openblas_complex_float_real(z)             (creal(z))
//   #define openblas_complex_float_imag(z)             (cimag(z))
//   #define openblas_complex_double_real(z)            (creal(z))
//   #define openblas_complex_double_imag(z)            (cimag(z))
//   #define openblas_complex_xdouble_real(z)           (creal(z))
//   #define openblas_complex_xdouble_imag(z)           (cimag(z))
// #else
// #endif

/* Inclusion of Linux-specific header is needed for definition of cpu_set_t. */
// #ifdef OPENBLAS_OS_LINUX
// #endif
// #endif /* OPENBLAS_CONFIG_H */


// Parsed from cblas.h

// #ifndef CBLAS_H
// #define CBLAS_H

// #include <stddef.h>
// #include "openblas_config.h"

// #ifdef __cplusplus
	/* Assume C declarations for C++ */
// #endif  /* __cplusplus */

/*Set the number of threads on runtime.*/




/*Get the number of threads on runtime.*/


/*Get the number of physical processors (cores).*/


/*Get the build configure on runtime.*/


/*Get the CPU corename on runtime.*/


/*Set the threading backend to a custom callback.*/
public static class openblas_dojob_callback extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    openblas_dojob_callback(Pointer p) { super(p); }
    protected openblas_dojob_callback() { allocate(); }
    private native void allocate();
    public native void call(int thread_num, Pointer jobdata, int dojob_data);
}
public static class openblas_threads_callback extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    openblas_threads_callback(Pointer p) { super(p); }
    protected openblas_threads_callback() { allocate(); }
    private native void allocate();
    public native void call(int sync, openblas_dojob_callback dojob, int numjobs, @Cast("size_t") long jobdata_elsize, Pointer jobdata, int dojob_data);
}


// #ifdef OPENBLAS_OS_LINUX
// #endif

/* Get the parallelization type which is used by OpenBLAS */

/* OpenBLAS is compiled for sequential use  */
public static final int OPENBLAS_SEQUENTIAL =  0;
/* OpenBLAS is compiled using normal threading model */
public static final int OPENBLAS_THREAD =  1;
/* OpenBLAS is compiled using OpenMP threading model */
public static final int OPENBLAS_OPENMP = 2;


/*
 * Since all of GotoBlas was written without const,
 * we disable it at build time.
 */
// #ifndef OPENBLAS_CONST
// # define OPENBLAS_CONST const
// #endif


// #define CBLAS_INDEX size_t

/** enum CBLAS_ORDER */
public static final int CblasRowMajor = 101, CblasColMajor = 102;
/** enum CBLAS_TRANSPOSE */
public static final int CblasNoTrans = 111, CblasTrans = 112, CblasConjTrans = 113, CblasConjNoTrans = 114;
/** enum CBLAS_UPLO */
public static final int CblasUpper = 121, CblasLower = 122;
/** enum CBLAS_DIAG */
public static final int CblasNonUnit = 131, CblasUnit = 132;
/** enum CBLAS_SIDE */
public static final int CblasLeft = 141, CblasRight = 142;
	
public static native float cblas_sdsdot(@Cast("const blasint") int n, float alpha, @Const FloatPointer x, @Cast("const blasint") int incx, @Const FloatPointer y, @Cast("const blasint") int incy);
public static native float cblas_sdsdot(@Cast("const blasint") int n, float alpha, @Const FloatBuffer x, @Cast("const blasint") int incx, @Const FloatBuffer y, @Cast("const blasint") int incy);
public static native float cblas_sdsdot(@Cast("const blasint") int n, float alpha, @Const float[] x, @Cast("const blasint") int incx, @Const float[] y, @Cast("const blasint") int incy);
public static native double cblas_dsdot(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx, @Const FloatPointer y, @Cast("const blasint") int incy);
public static native double cblas_dsdot(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx, @Const FloatBuffer y, @Cast("const blasint") int incy);
public static native double cblas_dsdot(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx, @Const float[] y, @Cast("const blasint") int incy);
public static native float cblas_sdot(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx, @Const FloatPointer y, @Cast("const blasint") int incy);
public static native float cblas_sdot(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx, @Const FloatBuffer y, @Cast("const blasint") int incy);
public static native float cblas_sdot(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx, @Const float[] y, @Cast("const blasint") int incy);
public static native double cblas_ddot(@Cast("const blasint") int n, @Const DoublePointer x, @Cast("const blasint") int incx, @Const DoublePointer y, @Cast("const blasint") int incy);
public static native double cblas_ddot(@Cast("const blasint") int n, @Const DoubleBuffer x, @Cast("const blasint") int incx, @Const DoubleBuffer y, @Cast("const blasint") int incy);
public static native double cblas_ddot(@Cast("const blasint") int n, @Const double[] x, @Cast("const blasint") int incx, @Const double[] y, @Cast("const blasint") int incy);






public static native void cblas_cdotu_sub(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, @Const Pointer y, @Cast("const blasint") int incy, Pointer ret);
public static native void cblas_cdotc_sub(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, @Const Pointer y, @Cast("const blasint") int incy, Pointer ret);
public static native void cblas_zdotu_sub(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, @Const Pointer y, @Cast("const blasint") int incy, Pointer ret);
public static native void cblas_zdotc_sub(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, @Const Pointer y, @Cast("const blasint") int incy, Pointer ret);

public static native float cblas_sasum(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx);
public static native float cblas_sasum(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx);
public static native float cblas_sasum(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx);
public static native double cblas_dasum(@Cast("const blasint") int n, @Const DoublePointer x, @Cast("const blasint") int incx);
public static native double cblas_dasum(@Cast("const blasint") int n, @Const DoubleBuffer x, @Cast("const blasint") int incx);
public static native double cblas_dasum(@Cast("const blasint") int n, @Const double[] x, @Cast("const blasint") int incx);
public static native float cblas_scasum(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx);
public static native double cblas_dzasum(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx);






public static native float cblas_snrm2(@Cast("const blasint") int N, @Const FloatPointer X, @Cast("const blasint") int incX);
public static native float cblas_snrm2(@Cast("const blasint") int N, @Const FloatBuffer X, @Cast("const blasint") int incX);
public static native float cblas_snrm2(@Cast("const blasint") int N, @Const float[] X, @Cast("const blasint") int incX);
public static native double cblas_dnrm2(@Cast("const blasint") int N, @Const DoublePointer X, @Cast("const blasint") int incX);
public static native double cblas_dnrm2(@Cast("const blasint") int N, @Const DoubleBuffer X, @Cast("const blasint") int incX);
public static native double cblas_dnrm2(@Cast("const blasint") int N, @Const double[] X, @Cast("const blasint") int incX);
public static native float cblas_scnrm2(@Cast("const blasint") int N, @Const Pointer X, @Cast("const blasint") int incX);
public static native double cblas_dznrm2(@Cast("const blasint") int N, @Const Pointer X, @Cast("const blasint") int incX);

public static native @Cast("size_t") long cblas_isamax(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_isamax(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_isamax(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_idamax(@Cast("const blasint") int n, @Const DoublePointer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_idamax(@Cast("const blasint") int n, @Const DoubleBuffer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_idamax(@Cast("const blasint") int n, @Const double[] x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_icamax(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_izamax(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx);


























public static native void cblas_saxpy(@Cast("const blasint") int n, float alpha, @Const FloatPointer x, @Cast("const blasint") int incx, FloatPointer y, @Cast("const blasint") int incy);
public static native void cblas_saxpy(@Cast("const blasint") int n, float alpha, @Const FloatBuffer x, @Cast("const blasint") int incx, FloatBuffer y, @Cast("const blasint") int incy);
public static native void cblas_saxpy(@Cast("const blasint") int n, float alpha, @Const float[] x, @Cast("const blasint") int incx, float[] y, @Cast("const blasint") int incy);
public static native void cblas_daxpy(@Cast("const blasint") int n, double alpha, @Const DoublePointer x, @Cast("const blasint") int incx, DoublePointer y, @Cast("const blasint") int incy);
public static native void cblas_daxpy(@Cast("const blasint") int n, double alpha, @Const DoubleBuffer x, @Cast("const blasint") int incx, DoubleBuffer y, @Cast("const blasint") int incy);
public static native void cblas_daxpy(@Cast("const blasint") int n, double alpha, @Const double[] x, @Cast("const blasint") int incx, double[] y, @Cast("const blasint") int incy);
public static native void cblas_caxpy(@Cast("const blasint") int n, @Const Pointer alpha, @Const Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);
public static native void cblas_zaxpy(@Cast("const blasint") int n, @Const Pointer alpha, @Const Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);




public static native void cblas_scopy(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx, FloatPointer y, @Cast("const blasint") int incy);
public static native void cblas_scopy(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx, FloatBuffer y, @Cast("const blasint") int incy);
public static native void cblas_scopy(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx, float[] y, @Cast("const blasint") int incy);
public static native void cblas_dcopy(@Cast("const blasint") int n, @Const DoublePointer x, @Cast("const blasint") int incx, DoublePointer y, @Cast("const blasint") int incy);
public static native void cblas_dcopy(@Cast("const blasint") int n, @Const DoubleBuffer x, @Cast("const blasint") int incx, DoubleBuffer y, @Cast("const blasint") int incy);
public static native void cblas_dcopy(@Cast("const blasint") int n, @Const double[] x, @Cast("const blasint") int incx, double[] y, @Cast("const blasint") int incy);
public static native void cblas_ccopy(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);
public static native void cblas_zcopy(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);

public static native void cblas_sswap(@Cast("const blasint") int n, FloatPointer x, @Cast("const blasint") int incx, FloatPointer y, @Cast("const blasint") int incy);
public static native void cblas_sswap(@Cast("const blasint") int n, FloatBuffer x, @Cast("const blasint") int incx, FloatBuffer y, @Cast("const blasint") int incy);
public static native void cblas_sswap(@Cast("const blasint") int n, float[] x, @Cast("const blasint") int incx, float[] y, @Cast("const blasint") int incy);
public static native void cblas_dswap(@Cast("const blasint") int n, DoublePointer x, @Cast("const blasint") int incx, DoublePointer y, @Cast("const blasint") int incy);
public static native void cblas_dswap(@Cast("const blasint") int n, DoubleBuffer x, @Cast("const blasint") int incx, DoubleBuffer y, @Cast("const blasint") int incy);
public static native void cblas_dswap(@Cast("const blasint") int n, double[] x, @Cast("const blasint") int incx, double[] y, @Cast("const blasint") int incy);
public static native void cblas_cswap(@Cast("const blasint") int n, Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);
public static native void cblas_zswap(@Cast("const blasint") int n, Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);

public static native void cblas_srot(@Cast("const blasint") int N, FloatPointer X, @Cast("const blasint") int incX, FloatPointer Y, @Cast("const blasint") int incY, float c, float s);
public static native void cblas_srot(@Cast("const blasint") int N, FloatBuffer X, @Cast("const blasint") int incX, FloatBuffer Y, @Cast("const blasint") int incY, float c, float s);
public static native void cblas_srot(@Cast("const blasint") int N, float[] X, @Cast("const blasint") int incX, float[] Y, @Cast("const blasint") int incY, float c, float s);
public static native void cblas_drot(@Cast("const blasint") int N, DoublePointer X, @Cast("const blasint") int incX, DoublePointer Y, @Cast("const blasint") int incY, double c, double s);
public static native void cblas_drot(@Cast("const blasint") int N, DoubleBuffer X, @Cast("const blasint") int incX, DoubleBuffer Y, @Cast("const blasint") int incY, double c, double s);
public static native void cblas_drot(@Cast("const blasint") int N, double[] X, @Cast("const blasint") int incX, double[] Y, @Cast("const blasint") int incY, double c, double s);



public static native void cblas_srotg(FloatPointer a, FloatPointer b, FloatPointer c, FloatPointer s);
public static native void cblas_srotg(FloatBuffer a, FloatBuffer b, FloatBuffer c, FloatBuffer s);
public static native void cblas_srotg(float[] a, float[] b, float[] c, float[] s);
public static native void cblas_drotg(DoublePointer a, DoublePointer b, DoublePointer c, DoublePointer s);
public static native void cblas_drotg(DoubleBuffer a, DoubleBuffer b, DoubleBuffer c, DoubleBuffer s);
public static native void cblas_drotg(double[] a, double[] b, double[] c, double[] s);




public static native void cblas_srotm(@Cast("const blasint") int N, FloatPointer X, @Cast("const blasint") int incX, FloatPointer Y, @Cast("const blasint") int incY, @Const FloatPointer P);
public static native void cblas_srotm(@Cast("const blasint") int N, FloatBuffer X, @Cast("const blasint") int incX, FloatBuffer Y, @Cast("const blasint") int incY, @Const FloatBuffer P);
public static native void cblas_srotm(@Cast("const blasint") int N, float[] X, @Cast("const blasint") int incX, float[] Y, @Cast("const blasint") int incY, @Const float[] P);
public static native void cblas_drotm(@Cast("const blasint") int N, DoublePointer X, @Cast("const blasint") int incX, DoublePointer Y, @Cast("const blasint") int incY, @Const DoublePointer P);
public static native void cblas_drotm(@Cast("const blasint") int N, DoubleBuffer X, @Cast("const blasint") int incX, DoubleBuffer Y, @Cast("const blasint") int incY, @Const DoubleBuffer P);
public static native void cblas_drotm(@Cast("const blasint") int N, double[] X, @Cast("const blasint") int incX, double[] Y, @Cast("const blasint") int incY, @Const double[] P);

public static native void cblas_srotmg(FloatPointer d1, FloatPointer d2, FloatPointer b1, float b2, FloatPointer P);
public static native void cblas_srotmg(FloatBuffer d1, FloatBuffer d2, FloatBuffer b1, float b2, FloatBuffer P);
public static native void cblas_srotmg(float[] d1, float[] d2, float[] b1, float b2, float[] P);
public static native void cblas_drotmg(DoublePointer d1, DoublePointer d2, DoublePointer b1, double b2, DoublePointer P);
public static native void cblas_drotmg(DoubleBuffer d1, DoubleBuffer d2, DoubleBuffer b1, double b2, DoubleBuffer P);
public static native void cblas_drotmg(double[] d1, double[] d2, double[] b1, double b2, double[] P);

public static native void cblas_sscal(@Cast("const blasint") int N, float alpha, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_sscal(@Cast("const blasint") int N, float alpha, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_sscal(@Cast("const blasint") int N, float alpha, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dscal(@Cast("const blasint") int N, double alpha, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dscal(@Cast("const blasint") int N, double alpha, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dscal(@Cast("const blasint") int N, double alpha, double[] X, @Cast("const blasint") int incX);
public static native void cblas_cscal(@Cast("const blasint") int N, @Const Pointer alpha, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_zscal(@Cast("const blasint") int N, @Const Pointer alpha, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_csscal(@Cast("const blasint") int N, float alpha, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_zdscal(@Cast("const blasint") int N, double alpha, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_sgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 float alpha, @Const FloatPointer a, @Cast("const blasint") int lda,  @Const FloatPointer x, @Cast("const blasint") int incx,  float beta,  FloatPointer y, @Cast("const blasint") int incy);
public static native void cblas_sgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 float alpha, @Const FloatBuffer a, @Cast("const blasint") int lda,  @Const FloatBuffer x, @Cast("const blasint") int incx,  float beta,  FloatBuffer y, @Cast("const blasint") int incy);
public static native void cblas_sgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 float alpha, @Const float[] a, @Cast("const blasint") int lda,  @Const float[] x, @Cast("const blasint") int incx,  float beta,  float[] y, @Cast("const blasint") int incy);
public static native void cblas_dgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 double alpha, @Const DoublePointer a, @Cast("const blasint") int lda,  @Const DoublePointer x, @Cast("const blasint") int incx,  double beta,  DoublePointer y, @Cast("const blasint") int incy);
public static native void cblas_dgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 double alpha, @Const DoubleBuffer a, @Cast("const blasint") int lda,  @Const DoubleBuffer x, @Cast("const blasint") int incx,  double beta,  DoubleBuffer y, @Cast("const blasint") int incy);
public static native void cblas_dgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 double alpha, @Const double[] a, @Cast("const blasint") int lda,  @Const double[] x, @Cast("const blasint") int incx,  double beta,  double[] y, @Cast("const blasint") int incy);
public static native void cblas_cgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 @Const Pointer alpha, @Const Pointer a, @Cast("const blasint") int lda,  @Const Pointer x, @Cast("const blasint") int incx,  @Const Pointer beta,  Pointer y, @Cast("const blasint") int incy);
public static native void cblas_zgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 @Const Pointer alpha, @Const Pointer a, @Cast("const blasint") int lda,  @Const Pointer x, @Cast("const blasint") int incx,  @Const Pointer beta,  Pointer y, @Cast("const blasint") int incy);

public static native void cblas_sger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatPointer X, @Cast("const blasint") int incX, @Const FloatPointer Y, @Cast("const blasint") int incY, FloatPointer A, @Cast("const blasint") int lda);
public static native void cblas_sger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatBuffer X, @Cast("const blasint") int incX, @Const FloatBuffer Y, @Cast("const blasint") int incY, FloatBuffer A, @Cast("const blasint") int lda);
public static native void cblas_sger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const float[] X, @Cast("const blasint") int incX, @Const float[] Y, @Cast("const blasint") int incY, float[] A, @Cast("const blasint") int lda);
public static native void cblas_dger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoublePointer X, @Cast("const blasint") int incX, @Const DoublePointer Y, @Cast("const blasint") int incY, DoublePointer A, @Cast("const blasint") int lda);
public static native void cblas_dger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X, @Cast("const blasint") int incX, @Const DoubleBuffer Y, @Cast("const blasint") int incY, DoubleBuffer A, @Cast("const blasint") int lda);
public static native void cblas_dger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const double[] X, @Cast("const blasint") int incX, @Const double[] Y, @Cast("const blasint") int incY, double[] A, @Cast("const blasint") int lda);
public static native void cblas_cgeru(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_cgerc(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_zgeru(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_zgerc(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);

public static native void cblas_strsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_strsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_strsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const float[] A, @Cast("const blasint") int lda, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const double[] A, @Cast("const blasint") int lda, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_strmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_strmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_strmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const float[] A, @Cast("const blasint") int lda, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const double[] A, @Cast("const blasint") int lda, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_ssyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer X, @Cast("const blasint") int incX, FloatPointer A, @Cast("const blasint") int lda);
public static native void cblas_ssyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer X, @Cast("const blasint") int incX, FloatBuffer A, @Cast("const blasint") int lda);
public static native void cblas_ssyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] X, @Cast("const blasint") int incX, float[] A, @Cast("const blasint") int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer X, @Cast("const blasint") int incX, DoublePointer A, @Cast("const blasint") int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X, @Cast("const blasint") int incX, DoubleBuffer A, @Cast("const blasint") int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] X, @Cast("const blasint") int incX, double[] A, @Cast("const blasint") int lda);
public static native void cblas_cher(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const Pointer X, @Cast("const blasint") int incX, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_zher(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const Pointer X, @Cast("const blasint") int incX, Pointer A, @Cast("const blasint") int lda);

public static native void cblas_ssyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo,@Cast("const blasint") int N, float alpha, @Const FloatPointer X,
                @Cast("const blasint") int incX, @Const FloatPointer Y, @Cast("const blasint") int incY, FloatPointer A, @Cast("const blasint") int lda);
public static native void cblas_ssyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo,@Cast("const blasint") int N, float alpha, @Const FloatBuffer X,
                @Cast("const blasint") int incX, @Const FloatBuffer Y, @Cast("const blasint") int incY, FloatBuffer A, @Cast("const blasint") int lda);
public static native void cblas_ssyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo,@Cast("const blasint") int N, float alpha, @Const float[] X,
                @Cast("const blasint") int incX, @Const float[] Y, @Cast("const blasint") int incY, float[] A, @Cast("const blasint") int lda);
public static native void cblas_dsyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer X,
                @Cast("const blasint") int incX, @Const DoublePointer Y, @Cast("const blasint") int incY, DoublePointer A, @Cast("const blasint") int lda);
public static native void cblas_dsyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X,
                @Cast("const blasint") int incX, @Const DoubleBuffer Y, @Cast("const blasint") int incY, DoubleBuffer A, @Cast("const blasint") int lda);
public static native void cblas_dsyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] X,
                @Cast("const blasint") int incX, @Const double[] Y, @Cast("const blasint") int incY, double[] A, @Cast("const blasint") int lda);
public static native void cblas_cher2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX,
                @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_zher2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX,
                @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);

public static native void cblas_sgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, @Const FloatPointer X, @Cast("const blasint") int incX, float beta, FloatPointer Y, @Cast("const blasint") int incY);
public static native void cblas_sgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, @Const FloatBuffer X, @Cast("const blasint") int incX, float beta, FloatBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_sgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, float alpha, @Const float[] A, @Cast("const blasint") int lda, @Const float[] X, @Cast("const blasint") int incX, float beta, float[] Y, @Cast("const blasint") int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, @Const DoublePointer X, @Cast("const blasint") int incX, double beta, DoublePointer Y, @Cast("const blasint") int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, @Const DoubleBuffer X, @Cast("const blasint") int incX, double beta, DoubleBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, double alpha, @Const double[] A, @Cast("const blasint") int lda, @Const double[] X, @Cast("const blasint") int incX, double beta, double[] Y, @Cast("const blasint") int incY);
public static native void cblas_cgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);
public static native void cblas_zgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);

public static native void cblas_ssbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatPointer A,
                 @Cast("const blasint") int lda, @Const FloatPointer X, @Cast("const blasint") int incX, float beta, FloatPointer Y, @Cast("const blasint") int incY);
public static native void cblas_ssbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatBuffer A,
                 @Cast("const blasint") int lda, @Const FloatBuffer X, @Cast("const blasint") int incX, float beta, FloatBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_ssbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const float[] A,
                 @Cast("const blasint") int lda, @Const float[] X, @Cast("const blasint") int incX, float beta, float[] Y, @Cast("const blasint") int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoublePointer A,
                 @Cast("const blasint") int lda, @Const DoublePointer X, @Cast("const blasint") int incX, double beta, DoublePointer Y, @Cast("const blasint") int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoubleBuffer A,
                 @Cast("const blasint") int lda, @Const DoubleBuffer X, @Cast("const blasint") int incX, double beta, DoubleBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const double[] A,
                 @Cast("const blasint") int lda, @Const double[] X, @Cast("const blasint") int incX, double beta, double[] Y, @Cast("const blasint") int incY);


public static native void cblas_stbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_stbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_stbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const float[] A, @Cast("const blasint") int lda, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const double[] A, @Cast("const blasint") int lda, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_stbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_stbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_stbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const float[] A, @Cast("const blasint") int lda, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const double[] A, @Cast("const blasint") int lda, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_stpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const FloatPointer Ap, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_stpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const FloatBuffer Ap, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_stpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const float[] Ap, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const DoublePointer Ap, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const DoubleBuffer Ap, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const double[] Ap, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const Pointer Ap, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const Pointer Ap, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_stpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const FloatPointer Ap, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_stpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const FloatBuffer Ap, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_stpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const float[] Ap, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const DoublePointer Ap, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const DoubleBuffer Ap, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const double[] Ap, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const Pointer Ap, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const Pointer Ap, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_ssymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer A,
                 @Cast("const blasint") int lda, @Const FloatPointer X, @Cast("const blasint") int incX, float beta, FloatPointer Y, @Cast("const blasint") int incY);
public static native void cblas_ssymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer A,
                 @Cast("const blasint") int lda, @Const FloatBuffer X, @Cast("const blasint") int incX, float beta, FloatBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_ssymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] A,
                 @Cast("const blasint") int lda, @Const float[] X, @Cast("const blasint") int incX, float beta, float[] Y, @Cast("const blasint") int incY);
public static native void cblas_dsymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer A,
                 @Cast("const blasint") int lda, @Const DoublePointer X, @Cast("const blasint") int incX, double beta, DoublePointer Y, @Cast("const blasint") int incY);
public static native void cblas_dsymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer A,
                 @Cast("const blasint") int lda, @Const DoubleBuffer X, @Cast("const blasint") int incX, double beta, DoubleBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_dsymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] A,
                 @Cast("const blasint") int lda, @Const double[] X, @Cast("const blasint") int incX, double beta, double[] Y, @Cast("const blasint") int incY);
public static native void cblas_chemv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A,
                 @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);
public static native void cblas_zhemv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A,
                 @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);


public static native void cblas_sspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer Ap,
                 @Const FloatPointer X, @Cast("const blasint") int incX, float beta, FloatPointer Y, @Cast("const blasint") int incY);
public static native void cblas_sspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer Ap,
                 @Const FloatBuffer X, @Cast("const blasint") int incX, float beta, FloatBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_sspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] Ap,
                 @Const float[] X, @Cast("const blasint") int incX, float beta, float[] Y, @Cast("const blasint") int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer Ap,
                 @Const DoublePointer X, @Cast("const blasint") int incX, double beta, DoublePointer Y, @Cast("const blasint") int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer Ap,
                 @Const DoubleBuffer X, @Cast("const blasint") int incX, double beta, DoubleBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] Ap,
                 @Const double[] X, @Cast("const blasint") int incX, double beta, double[] Y, @Cast("const blasint") int incY);

public static native void cblas_sspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer X, @Cast("const blasint") int incX, FloatPointer Ap);
public static native void cblas_sspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer X, @Cast("const blasint") int incX, FloatBuffer Ap);
public static native void cblas_sspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] X, @Cast("const blasint") int incX, float[] Ap);
public static native void cblas_dspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer X, @Cast("const blasint") int incX, DoublePointer Ap);
public static native void cblas_dspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X, @Cast("const blasint") int incX, DoubleBuffer Ap);
public static native void cblas_dspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] X, @Cast("const blasint") int incX, double[] Ap);

public static native void cblas_chpr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const Pointer X, @Cast("const blasint") int incX, Pointer A);
public static native void cblas_zhpr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const Pointer X,@Cast("const blasint") int incX, Pointer A);

public static native void cblas_sspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer X, @Cast("const blasint") int incX, @Const FloatPointer Y, @Cast("const blasint") int incY, FloatPointer A);
public static native void cblas_sspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer X, @Cast("const blasint") int incX, @Const FloatBuffer Y, @Cast("const blasint") int incY, FloatBuffer A);
public static native void cblas_sspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] X, @Cast("const blasint") int incX, @Const float[] Y, @Cast("const blasint") int incY, float[] A);
public static native void cblas_dspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer X, @Cast("const blasint") int incX, @Const DoublePointer Y, @Cast("const blasint") int incY, DoublePointer A);
public static native void cblas_dspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X, @Cast("const blasint") int incX, @Const DoubleBuffer Y, @Cast("const blasint") int incY, DoubleBuffer A);
public static native void cblas_dspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] X, @Cast("const blasint") int incX, @Const double[] Y, @Cast("const blasint") int incY, double[] A);
public static native void cblas_chpr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer Ap);
public static native void cblas_zhpr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer Ap);

public static native void cblas_chbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);
public static native void cblas_zhbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);

public static native void cblas_chpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N,
		 @Const Pointer alpha, @Const Pointer Ap, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);
public static native void cblas_zhpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N,
		 @Const Pointer alpha, @Const Pointer Ap, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);

public static native void cblas_sgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, @Const FloatPointer B, @Cast("const blasint") int ldb, float beta, FloatPointer C, @Cast("const blasint") int ldc);
public static native void cblas_sgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, @Const FloatBuffer B, @Cast("const blasint") int ldb, float beta, FloatBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_sgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 float alpha, @Const float[] A, @Cast("const blasint") int lda, @Const float[] B, @Cast("const blasint") int ldb, float beta, float[] C, @Cast("const blasint") int ldc);
public static native void cblas_dgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, @Const DoublePointer B, @Cast("const blasint") int ldb, double beta, DoublePointer C, @Cast("const blasint") int ldc);
public static native void cblas_dgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, @Const DoubleBuffer B, @Cast("const blasint") int ldb, double beta, DoubleBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_dgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 double alpha, @Const double[] A, @Cast("const blasint") int lda, @Const double[] B, @Cast("const blasint") int ldb, double beta, double[] C, @Cast("const blasint") int ldc);
public static native void cblas_cgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_zgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);







public static native void cblas_ssymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, @Const FloatPointer B, @Cast("const blasint") int ldb, float beta, FloatPointer C, @Cast("const blasint") int ldc);
public static native void cblas_ssymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, @Const FloatBuffer B, @Cast("const blasint") int ldb, float beta, FloatBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_ssymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 float alpha, @Const float[] A, @Cast("const blasint") int lda, @Const float[] B, @Cast("const blasint") int ldb, float beta, float[] C, @Cast("const blasint") int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, @Const DoublePointer B, @Cast("const blasint") int ldb, double beta, DoublePointer C, @Cast("const blasint") int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, @Const DoubleBuffer B, @Cast("const blasint") int ldb, double beta, DoubleBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 double alpha, @Const double[] A, @Cast("const blasint") int lda, @Const double[] B, @Cast("const blasint") int ldb, double beta, double[] C, @Cast("const blasint") int ldc);
public static native void cblas_csymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zsymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_ssyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, float beta, FloatPointer C, @Cast("const blasint") int ldc);
public static native void cblas_ssyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, float beta, FloatBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_ssyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const float[] A, @Cast("const blasint") int lda, float beta, float[] C, @Cast("const blasint") int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, double beta, DoublePointer C, @Cast("const blasint") int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, double beta, DoubleBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const double[] A, @Cast("const blasint") int lda, double beta, double[] C, @Cast("const blasint") int ldc);
public static native void cblas_csyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zsyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_ssyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, @Const FloatPointer B, @Cast("const blasint") int ldb, float beta, FloatPointer C, @Cast("const blasint") int ldc);
public static native void cblas_ssyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, @Const FloatBuffer B, @Cast("const blasint") int ldb, float beta, FloatBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_ssyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const float[] A, @Cast("const blasint") int lda, @Const float[] B, @Cast("const blasint") int ldb, float beta, float[] C, @Cast("const blasint") int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, @Const DoublePointer B, @Cast("const blasint") int ldb, double beta, DoublePointer C, @Cast("const blasint") int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, @Const DoubleBuffer B, @Cast("const blasint") int ldb, double beta, DoubleBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const double[] A, @Cast("const blasint") int lda, @Const double[] B, @Cast("const blasint") int ldb, double beta, double[] C, @Cast("const blasint") int ldc);
public static native void cblas_csyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zsyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_strmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer B, @Cast("const blasint") int ldb);
public static native void cblas_strmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer B, @Cast("const blasint") int ldb);
public static native void cblas_strmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const float[] A, @Cast("const blasint") int lda, float[] B, @Cast("const blasint") int ldb);
public static native void cblas_dtrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer B, @Cast("const blasint") int ldb);
public static native void cblas_dtrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer B, @Cast("const blasint") int ldb);
public static native void cblas_dtrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const double[] A, @Cast("const blasint") int lda, double[] B, @Cast("const blasint") int ldb);
public static native void cblas_ctrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, Pointer B, @Cast("const blasint") int ldb);
public static native void cblas_ztrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, Pointer B, @Cast("const blasint") int ldb);

public static native void cblas_strsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer B, @Cast("const blasint") int ldb);
public static native void cblas_strsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer B, @Cast("const blasint") int ldb);
public static native void cblas_strsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const float[] A, @Cast("const blasint") int lda, float[] B, @Cast("const blasint") int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer B, @Cast("const blasint") int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer B, @Cast("const blasint") int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const double[] A, @Cast("const blasint") int lda, double[] B, @Cast("const blasint") int ldb);
public static native void cblas_ctrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, Pointer B, @Cast("const blasint") int ldb);
public static native void cblas_ztrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, Pointer B, @Cast("const blasint") int ldb);

public static native void cblas_chemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zhemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_cherk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans, @Cast("const blasint") int N, @Cast("const blasint") int K,
                 float alpha, @Const Pointer A, @Cast("const blasint") int lda, float beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zherk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans, @Cast("const blasint") int N, @Cast("const blasint") int K,
                 double alpha, @Const Pointer A, @Cast("const blasint") int lda, double beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_cher2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans, @Cast("const blasint") int N, @Cast("const blasint") int K,
                  @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, float beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zher2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans, @Cast("const blasint") int N, @Cast("const blasint") int K,
                  @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, double beta, Pointer C, @Cast("const blasint") int ldc);



/*** BLAS extensions ***/









 
 
 
 

 
 
 
 

 
 
 
 









/*** BFLOAT16 and INT8 extensions ***/
/* convert float array to BFLOAT16 array by rounding */

/* convert double array to BFLOAT16 array by rounding */

/* convert BFLOAT16 array to float array */

/* convert BFLOAT16 array to double array */

/* dot production of BFLOAT16 input arrays, and output as float */






// #ifdef __cplusplus
// #endif  /* __cplusplus */

// #endif


}
