// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_core;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.opencv.global.opencv_core.*;


/** \brief a Class to measure passing time.
<p>
The class computes passing time by counting the number of ticks per second. That is, the following code computes the
execution time in seconds:
<pre>{@code
TickMeter tm;
tm.start();
// do something ...
tm.stop();
std::cout << tm.getTimeSec();
}</pre>
<p>
It is also possible to compute the average time over multiple runs:
<pre>{@code
TickMeter tm;
for (int i = 0; i < 100; i++)
{
    tm.start();
    // do something ...
    tm.stop();
}
double average_time = tm.getTimeSec() / tm.getCounter();
std::cout << "Average time in second per iteration is: " << average_time << std::endl;
}</pre>
@see getTickCount, getTickFrequency
*/

@Namespace("cv") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_core.class)
public class TickMeter extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TickMeter(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public TickMeter(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public TickMeter position(long position) {
        return (TickMeter)super.position(position);
    }

    /** the default constructor */
    public TickMeter() { super((Pointer)null); allocate(); }
    private native void allocate();

    /**
    starts counting ticks.
    */
    public native void start();

    /**
    stops counting ticks.
    */
    public native void stop();

    /**
    returns counted ticks.
    */
    public native @Cast("int64") long getTimeTicks();

    /**
    returns passed time in microseconds.
    */
    public native double getTimeMicro();

    /**
    returns passed time in milliseconds.
    */
    public native double getTimeMilli();

    /**
    returns passed time in seconds.
    */
    public native double getTimeSec();

    /**
    returns internal counter value.
    */
    public native @Cast("int64") long getCounter();

    /**
    resets internal values.
    */
    public native void reset();
}
