// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_tracking;

import org.bytedeco.javacpp.annotation.Index;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import org.bytedeco.opencv.opencv_plot.*;
import static org.bytedeco.opencv.global.opencv_plot.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_video.*;
import static org.bytedeco.opencv.global.opencv_video.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;

import static org.bytedeco.opencv.global.opencv_tracking.*;



/************************************ MultiTracker Class ---By Laksono Kurnianggoro---) ************************************/
/** \brief This class is used to track multiple objects using the specified tracker algorithm.
<p>
* The %MultiTracker is naive implementation of multiple object tracking.
* It process the tracked objects independently without any optimization accross the tracked objects.
*/
@Namespace("cv") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_tracking.class)
public class MultiTracker extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MultiTracker(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public MultiTracker(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public MultiTracker position(long position) {
        return (MultiTracker)super.position(position);
    }


  /**
  * \brief Constructor.
  */
  public MultiTracker() { super((Pointer)null); allocate(); }
  private native void allocate();

  /**
  * \brief Destructor
  */

  /**
  * \brief Add a new object to be tracked.
  *
  * @param newTracker tracking algorithm to be used
  * @param image input image
  * @param boundingBox a rectangle represents ROI of the tracked object
  */
  public native @Cast("bool") boolean add(@Ptr @ByVal Tracker newTracker, @ByVal Mat image, @Const @ByRef Rect2d boundingBox);
  public native @Cast("bool") boolean add(@Ptr @ByVal Tracker newTracker, @ByVal UMat image, @Const @ByRef Rect2d boundingBox);
  public native @Cast("bool") boolean add(@Ptr @ByVal Tracker newTracker, @ByVal GpuMat image, @Const @ByRef Rect2d boundingBox);

  /**
  * \brief Add a set of objects to be tracked.
  * @param newTrackers list of tracking algorithms to be used
  * @param image input image
  * @param boundingBox list of the tracked objects
  */
  public native @Cast("bool") boolean add(@ByVal TrackerVector newTrackers, @ByVal Mat image, @ByVal Rect2dVector boundingBox);
  public native @Cast("bool") boolean add(@ByVal TrackerVector newTrackers, @ByVal UMat image, @ByVal Rect2dVector boundingBox);
  public native @Cast("bool") boolean add(@ByVal TrackerVector newTrackers, @ByVal GpuMat image, @ByVal Rect2dVector boundingBox);

  /**
  * \brief Update the current tracking status.
  * The result will be saved in the internal storage.
  * @param image input image
  */
  public native @Cast("bool") boolean update(@ByVal Mat image);
  public native @Cast("bool") boolean update(@ByVal UMat image);
  public native @Cast("bool") boolean update(@ByVal GpuMat image);

  /**
  * \brief Update the current tracking status.
  * @param image input image
  * @param boundingBox the tracking result, represent a list of ROIs of the tracked objects.
  */
  public native @Cast("bool") boolean update(@ByVal Mat image, @ByRef Rect2dVector boundingBox);
  public native @Cast("bool") boolean update(@ByVal UMat image, @ByRef Rect2dVector boundingBox);
  public native @Cast("bool") boolean update(@ByVal GpuMat image, @ByRef Rect2dVector boundingBox);

  /**
  * \brief Returns a reference to a storage for the tracked objects, each object corresponds to one tracker algorithm
  */
  public native @Const @ByRef Rect2dVector getObjects();

  /**
  * \brief Returns a pointer to a new instance of MultiTracker
  */
  public static native @Ptr MultiTracker create();
}
