/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.CvSize;
import org.bytedeco.opencv.opencv_core.IplROI;

@Properties(inherit={org.bytedeco.opencv.presets.opencv_core.class})
public abstract class AbstractArray
extends Pointer
implements Indexable {
    public AbstractArray(Pointer p) {
        super(p);
    }

    public abstract int arrayChannels();

    public abstract int arrayDepth();

    public abstract int arrayOrigin();

    public abstract void arrayOrigin(int var1);

    public abstract int arrayWidth();

    public abstract int arrayHeight();

    public abstract IplROI arrayROI();

    public abstract long arraySize();

    public abstract BytePointer arrayData();

    public abstract long arrayStep();

    public <B extends Buffer> B createBuffer() {
        return this.createBuffer(0);
    }

    public <B extends Buffer> B createBuffer(int index) {
        BytePointer ptr = this.arrayData();
        long size = this.arraySize();
        switch (this.arrayDepth()) {
            case -2147483640: 
            case 8: {
                return (B)ptr.position((long)index).capacity(size).asBuffer();
            }
            case -2147483632: 
            case 16: {
                return (B)new ShortPointer((Pointer)ptr).position((long)index).capacity(size / 2L).asBuffer();
            }
            case -2147483616: {
                return (B)new IntPointer((Pointer)ptr).position((long)index).capacity(size / 4L).asBuffer();
            }
            case 32: {
                return (B)new FloatPointer((Pointer)ptr).position((long)index).capacity(size / 4L).asBuffer();
            }
            case 64: {
                return (B)new DoublePointer((Pointer)ptr).position((long)index).capacity(size / 8L).asBuffer();
            }
        }
        assert (false);
        return null;
    }

    public <I extends Indexer> I createIndexer() {
        return this.createIndexer(true);
    }

    public <I extends Indexer> I createIndexer(boolean direct) {
        BytePointer ptr = this.arrayData();
        long size = this.arraySize();
        long[] sizes = new long[]{this.arrayHeight(), this.arrayWidth(), this.arrayChannels()};
        long[] strides = new long[]{this.arrayStep(), this.arrayChannels(), 1L};
        switch (this.arrayDepth()) {
            case 8: {
                return (I)UByteIndexer.create((BytePointer)ptr.capacity(size), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
            case -2147483640: {
                return (I)ByteIndexer.create((BytePointer)ptr.capacity(size), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
            case 16: {
                strides[0] = strides[0] / 2L;
                return (I)UShortIndexer.create((ShortPointer)new ShortPointer((Pointer)ptr).capacity(size / 2L), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
            case -2147483632: {
                strides[0] = strides[0] / 2L;
                return (I)ShortIndexer.create((ShortPointer)new ShortPointer((Pointer)ptr).capacity(size / 2L), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
            case -2147483616: {
                strides[0] = strides[0] / 4L;
                return (I)IntIndexer.create((IntPointer)new IntPointer((Pointer)ptr).capacity(size / 4L), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
            case 32: {
                strides[0] = strides[0] / 4L;
                return (I)FloatIndexer.create((FloatPointer)new FloatPointer((Pointer)ptr).capacity(size / 4L), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
            case 64: {
                strides[0] = strides[0] / 8L;
                return (I)DoubleIndexer.create((DoublePointer)new DoublePointer((Pointer)ptr).capacity(size / 8L), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
        }
        assert (false);
        return null;
    }

    public double highValue() {
        double highValue = 0.0;
        switch (this.arrayDepth()) {
            case 8: {
                highValue = 255.0;
                break;
            }
            case 16: {
                highValue = 65535.0;
                break;
            }
            case -2147483640: {
                highValue = 127.0;
                break;
            }
            case -2147483632: {
                highValue = 32767.0;
                break;
            }
            case -2147483616: {
                highValue = 2.147483647E9;
                break;
            }
            case 1: 
            case 32: 
            case 64: {
                highValue = 1.0;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return highValue;
    }

    public CvSize cvSize() {
        return opencv_core.cvSize(this.arrayWidth(), this.arrayHeight());
    }

    @Deprecated
    public ByteBuffer getByteBuffer(int index) {
        return this.arrayData().position((long)index).capacity(this.arraySize()).asByteBuffer();
    }

    @Deprecated
    public ShortBuffer getShortBuffer(int index) {
        return this.getByteBuffer(index * 2).asShortBuffer();
    }

    @Deprecated
    public IntBuffer getIntBuffer(int index) {
        return this.getByteBuffer(index * 4).asIntBuffer();
    }

    @Deprecated
    public FloatBuffer getFloatBuffer(int index) {
        return this.getByteBuffer(index * 4).asFloatBuffer();
    }

    @Deprecated
    public DoubleBuffer getDoubleBuffer(int index) {
        return this.getByteBuffer(index * 8).asDoubleBuffer();
    }

    @Deprecated
    public ByteBuffer getByteBuffer() {
        return this.getByteBuffer(0);
    }

    @Deprecated
    public ShortBuffer getShortBuffer() {
        return this.getShortBuffer(0);
    }

    @Deprecated
    public IntBuffer getIntBuffer() {
        return this.getIntBuffer(0);
    }

    @Deprecated
    public FloatBuffer getFloatBuffer() {
        return this.getFloatBuffer(0);
    }

    @Deprecated
    public DoubleBuffer getDoubleBuffer() {
        return this.getDoubleBuffer(0);
    }

    public String toString() {
        if (this.isNull()) {
            return super.toString();
        }
        try {
            return ((Object)((Object)this)).getClass().getName() + "[width=" + this.arrayWidth() + ",height=" + this.arrayHeight() + ",depth=" + this.arrayDepth() + ",channels=" + this.arrayChannels() + "]";
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    static {
        Loader.load();
    }
}

